# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from collections.abc import MutableMapping
import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .._utils import serialization as _serialization

if TYPE_CHECKING:
    from .. import models as _models
JSON = MutableMapping[str, Any]


class DeleteJob(_serialization.Model):
    """A job which contains a reference to the operations to perform, results, and execution metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the delete job.
    :vartype id: str
    :ivar status: Status of the job. Known values are: "notstarted", "running", "failed", and
     "succeeded".
    :vartype status: str or ~azure.digitaltwins.core.models.DeleteJobStatus
    :ivar created_date_time: Start time of the job. The timestamp is in RFC3339 format:
     ``yyyy-MM-ddTHH:mm:ssZ``.
    :vartype created_date_time: ~datetime.datetime
    :ivar finished_date_time: End time of the job. The timestamp is in RFC3339 format:
     ``yyyy-MM-ddTHH:mm:ssZ``.
    :vartype finished_date_time: ~datetime.datetime
    :ivar purge_date_time: Time at which job will be purged by the service from the system. The
     timestamp is in RFC3339 format: ``yyyy-MM-ddTHH:mm:ssZ``.
    :vartype purge_date_time: ~datetime.datetime
    :ivar error: Details of the error(s) that occurred executing the import job.
    :vartype error: ~azure.digitaltwins.core.models.Error
    """

    _validation = {
        "id": {"readonly": True},
        "status": {"readonly": True},
        "created_date_time": {"readonly": True},
        "finished_date_time": {"readonly": True},
        "purge_date_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "created_date_time": {"key": "createdDateTime", "type": "iso-8601"},
        "finished_date_time": {"key": "finishedDateTime", "type": "iso-8601"},
        "purge_date_time": {"key": "purgeDateTime", "type": "iso-8601"},
        "error": {"key": "error", "type": "Error"},
    }

    def __init__(self, *, error: Optional["_models.Error"] = None, **kwargs: Any) -> None:
        """
        :keyword error: Details of the error(s) that occurred executing the import job.
        :paramtype error: ~azure.digitaltwins.core.models.Error
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.status: Optional[Union[str, "_models.DeleteJobStatus"]] = None
        self.created_date_time: Optional[datetime.datetime] = None
        self.finished_date_time: Optional[datetime.datetime] = None
        self.purge_date_time: Optional[datetime.datetime] = None
        self.error = error


class DeleteJobCollection(_serialization.Model):
    """A collection of delete job objects.

    All required parameters must be populated in order to send to server.

    :ivar value: The list of delete job objects. Required.
    :vartype value: list[~azure.digitaltwins.core.models.DeleteJob]
    :ivar next_link: A URI to retrieve the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DeleteJob]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.DeleteJob"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of delete job objects. Required.
        :paramtype value: list[~azure.digitaltwins.core.models.DeleteJob]
        :keyword next_link: A URI to retrieve the next page of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DeleteJobsAddOptions(_serialization.Model):
    """Parameter group.

    :ivar traceparent: Identifies the request in a distributed tracing system.
    :vartype traceparent: str
    :ivar tracestate: Provides vendor-specific trace identification information and is a companion
     to traceparent.
    :vartype tracestate: str
    """

    _attribute_map = {
        "traceparent": {"key": "traceparent", "type": "str"},
        "tracestate": {"key": "tracestate", "type": "str"},
    }

    def __init__(self, *, traceparent: Optional[str] = None, tracestate: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword traceparent: Identifies the request in a distributed tracing system.
        :paramtype traceparent: str
        :keyword tracestate: Provides vendor-specific trace identification information and is a
         companion to traceparent.
        :paramtype tracestate: str
        """
        super().__init__(**kwargs)
        self.traceparent = traceparent
        self.tracestate = tracestate


class DeleteJobsGetByIdOptions(_serialization.Model):
    """Parameter group.

    :ivar traceparent: Identifies the request in a distributed tracing system.
    :vartype traceparent: str
    :ivar tracestate: Provides vendor-specific trace identification information and is a companion
     to traceparent.
    :vartype tracestate: str
    """

    _attribute_map = {
        "traceparent": {"key": "traceparent", "type": "str"},
        "tracestate": {"key": "tracestate", "type": "str"},
    }

    def __init__(self, *, traceparent: Optional[str] = None, tracestate: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword traceparent: Identifies the request in a distributed tracing system.
        :paramtype traceparent: str
        :keyword tracestate: Provides vendor-specific trace identification information and is a
         companion to traceparent.
        :paramtype tracestate: str
        """
        super().__init__(**kwargs)
        self.traceparent = traceparent
        self.tracestate = tracestate


class DeleteJobsListOptions(_serialization.Model):
    """Parameter group.

    :ivar traceparent: Identifies the request in a distributed tracing system.
    :vartype traceparent: str
    :ivar tracestate: Provides vendor-specific trace identification information and is a companion
     to traceparent.
    :vartype tracestate: str
    :ivar max_items_per_page: The maximum number of items to retrieve per request. The server may
     choose to return less than the requested number.
    :vartype max_items_per_page: int
    """

    _attribute_map = {
        "traceparent": {"key": "traceparent", "type": "str"},
        "tracestate": {"key": "tracestate", "type": "str"},
        "max_items_per_page": {"key": "MaxItemsPerPage", "type": "int"},
    }

    def __init__(
        self,
        *,
        traceparent: Optional[str] = None,
        tracestate: Optional[str] = None,
        max_items_per_page: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword traceparent: Identifies the request in a distributed tracing system.
        :paramtype traceparent: str
        :keyword tracestate: Provides vendor-specific trace identification information and is a
         companion to traceparent.
        :paramtype tracestate: str
        :keyword max_items_per_page: The maximum number of items to retrieve per request. The server
         may choose to return less than the requested number.
        :paramtype max_items_per_page: int
        """
        super().__init__(**kwargs)
        self.traceparent = traceparent
        self.tracestate = tracestate
        self.max_items_per_page = max_items_per_page


class DigitalTwinModelsAddOptions(_serialization.Model):
    """Parameter group.

    :ivar traceparent: Identifies the request in a distributed tracing system.
    :vartype traceparent: str
    :ivar tracestate: Provides vendor-specific trace identification information and is a companion
     to traceparent.
    :vartype tracestate: str
    """

    _attribute_map = {
        "traceparent": {"key": "traceparent", "type": "str"},
        "tracestate": {"key": "tracestate", "type": "str"},
    }

    def __init__(self, *, traceparent: Optional[str] = None, tracestate: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword traceparent: Identifies the request in a distributed tracing system.
        :paramtype traceparent: str
        :keyword tracestate: Provides vendor-specific trace identification information and is a
         companion to traceparent.
        :paramtype tracestate: str
        """
        super().__init__(**kwargs)
        self.traceparent = traceparent
        self.tracestate = tracestate


class DigitalTwinModelsDeleteOptions(_serialization.Model):
    """Parameter group.

    :ivar traceparent: Identifies the request in a distributed tracing system.
    :vartype traceparent: str
    :ivar tracestate: Provides vendor-specific trace identification information and is a companion
     to traceparent.
    :vartype tracestate: str
    """

    _attribute_map = {
        "traceparent": {"key": "traceparent", "type": "str"},
        "tracestate": {"key": "tracestate", "type": "str"},
    }

    def __init__(self, *, traceparent: Optional[str] = None, tracestate: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword traceparent: Identifies the request in a distributed tracing system.
        :paramtype traceparent: str
        :keyword tracestate: Provides vendor-specific trace identification information and is a
         companion to traceparent.
        :paramtype tracestate: str
        """
        super().__init__(**kwargs)
        self.traceparent = traceparent
        self.tracestate = tracestate


class DigitalTwinModelsGetByIdOptions(_serialization.Model):
    """Parameter group.

    :ivar traceparent: Identifies the request in a distributed tracing system.
    :vartype traceparent: str
    :ivar tracestate: Provides vendor-specific trace identification information and is a companion
     to traceparent.
    :vartype tracestate: str
    """

    _attribute_map = {
        "traceparent": {"key": "traceparent", "type": "str"},
        "tracestate": {"key": "tracestate", "type": "str"},
    }

    def __init__(self, *, traceparent: Optional[str] = None, tracestate: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword traceparent: Identifies the request in a distributed tracing system.
        :paramtype traceparent: str
        :keyword tracestate: Provides vendor-specific trace identification information and is a
         companion to traceparent.
        :paramtype tracestate: str
        """
        super().__init__(**kwargs)
        self.traceparent = traceparent
        self.tracestate = tracestate


class DigitalTwinModelsListOptions(_serialization.Model):
    """Parameter group.

    :ivar traceparent: Identifies the request in a distributed tracing system.
    :vartype traceparent: str
    :ivar tracestate: Provides vendor-specific trace identification information and is a companion
     to traceparent.
    :vartype tracestate: str
    :ivar max_items_per_page: The maximum number of items to retrieve per request. The server may
     choose to return less than the requested number.
    :vartype max_items_per_page: int
    """

    _attribute_map = {
        "traceparent": {"key": "traceparent", "type": "str"},
        "tracestate": {"key": "tracestate", "type": "str"},
        "max_items_per_page": {"key": "MaxItemsPerPage", "type": "int"},
    }

    def __init__(
        self,
        *,
        traceparent: Optional[str] = None,
        tracestate: Optional[str] = None,
        max_items_per_page: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword traceparent: Identifies the request in a distributed tracing system.
        :paramtype traceparent: str
        :keyword tracestate: Provides vendor-specific trace identification information and is a
         companion to traceparent.
        :paramtype tracestate: str
        :keyword max_items_per_page: The maximum number of items to retrieve per request. The server
         may choose to return less than the requested number.
        :paramtype max_items_per_page: int
        """
        super().__init__(**kwargs)
        self.traceparent = traceparent
        self.tracestate = tracestate
        self.max_items_per_page = max_items_per_page


class DigitalTwinModelsUpdateOptions(_serialization.Model):
    """Parameter group.

    :ivar traceparent: Identifies the request in a distributed tracing system.
    :vartype traceparent: str
    :ivar tracestate: Provides vendor-specific trace identification information and is a companion
     to traceparent.
    :vartype tracestate: str
    """

    _attribute_map = {
        "traceparent": {"key": "traceparent", "type": "str"},
        "tracestate": {"key": "tracestate", "type": "str"},
    }

    def __init__(self, *, traceparent: Optional[str] = None, tracestate: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword traceparent: Identifies the request in a distributed tracing system.
        :paramtype traceparent: str
        :keyword tracestate: Provides vendor-specific trace identification information and is a
         companion to traceparent.
        :paramtype tracestate: str
        """
        super().__init__(**kwargs)
        self.traceparent = traceparent
        self.tracestate = tracestate


class DigitalTwinsAddOptions(_serialization.Model):
    """Parameter group.

    :ivar traceparent: Identifies the request in a distributed tracing system.
    :vartype traceparent: str
    :ivar tracestate: Provides vendor-specific trace identification information and is a companion
     to traceparent.
    :vartype tracestate: str
    :ivar if_none_match: Only perform the operation if the entity does not already exist.
    :vartype if_none_match: str
    """

    _attribute_map = {
        "traceparent": {"key": "traceparent", "type": "str"},
        "tracestate": {"key": "tracestate", "type": "str"},
        "if_none_match": {"key": "If-None-Match", "type": "str"},
    }

    def __init__(
        self,
        *,
        traceparent: Optional[str] = None,
        tracestate: Optional[str] = None,
        if_none_match: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword traceparent: Identifies the request in a distributed tracing system.
        :paramtype traceparent: str
        :keyword tracestate: Provides vendor-specific trace identification information and is a
         companion to traceparent.
        :paramtype tracestate: str
        :keyword if_none_match: Only perform the operation if the entity does not already exist.
        :paramtype if_none_match: str
        """
        super().__init__(**kwargs)
        self.traceparent = traceparent
        self.tracestate = tracestate
        self.if_none_match = if_none_match


class DigitalTwinsAddRelationshipOptions(_serialization.Model):
    """Parameter group.

    :ivar traceparent: Identifies the request in a distributed tracing system.
    :vartype traceparent: str
    :ivar tracestate: Provides vendor-specific trace identification information and is a companion
     to traceparent.
    :vartype tracestate: str
    :ivar if_none_match: Only perform the operation if the entity does not already exist.
    :vartype if_none_match: str
    """

    _attribute_map = {
        "traceparent": {"key": "traceparent", "type": "str"},
        "tracestate": {"key": "tracestate", "type": "str"},
        "if_none_match": {"key": "If-None-Match", "type": "str"},
    }

    def __init__(
        self,
        *,
        traceparent: Optional[str] = None,
        tracestate: Optional[str] = None,
        if_none_match: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword traceparent: Identifies the request in a distributed tracing system.
        :paramtype traceparent: str
        :keyword tracestate: Provides vendor-specific trace identification information and is a
         companion to traceparent.
        :paramtype tracestate: str
        :keyword if_none_match: Only perform the operation if the entity does not already exist.
        :paramtype if_none_match: str
        """
        super().__init__(**kwargs)
        self.traceparent = traceparent
        self.tracestate = tracestate
        self.if_none_match = if_none_match


class DigitalTwinsDeleteOptions(_serialization.Model):
    """Parameter group.

    :ivar traceparent: Identifies the request in a distributed tracing system.
    :vartype traceparent: str
    :ivar tracestate: Provides vendor-specific trace identification information and is a companion
     to traceparent.
    :vartype tracestate: str
    :ivar if_match: Only perform the operation if the entity's etag matches one of the etags
     provided or * is provided.
    :vartype if_match: str
    """

    _attribute_map = {
        "traceparent": {"key": "traceparent", "type": "str"},
        "tracestate": {"key": "tracestate", "type": "str"},
        "if_match": {"key": "If-Match", "type": "str"},
    }

    def __init__(
        self,
        *,
        traceparent: Optional[str] = None,
        tracestate: Optional[str] = None,
        if_match: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword traceparent: Identifies the request in a distributed tracing system.
        :paramtype traceparent: str
        :keyword tracestate: Provides vendor-specific trace identification information and is a
         companion to traceparent.
        :paramtype tracestate: str
        :keyword if_match: Only perform the operation if the entity's etag matches one of the etags
         provided or * is provided.
        :paramtype if_match: str
        """
        super().__init__(**kwargs)
        self.traceparent = traceparent
        self.tracestate = tracestate
        self.if_match = if_match


class DigitalTwinsDeleteRelationshipOptions(_serialization.Model):
    """Parameter group.

    :ivar traceparent: Identifies the request in a distributed tracing system.
    :vartype traceparent: str
    :ivar tracestate: Provides vendor-specific trace identification information and is a companion
     to traceparent.
    :vartype tracestate: str
    :ivar if_match: Only perform the operation if the entity's etag matches one of the etags
     provided or * is provided.
    :vartype if_match: str
    """

    _attribute_map = {
        "traceparent": {"key": "traceparent", "type": "str"},
        "tracestate": {"key": "tracestate", "type": "str"},
        "if_match": {"key": "If-Match", "type": "str"},
    }

    def __init__(
        self,
        *,
        traceparent: Optional[str] = None,
        tracestate: Optional[str] = None,
        if_match: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword traceparent: Identifies the request in a distributed tracing system.
        :paramtype traceparent: str
        :keyword tracestate: Provides vendor-specific trace identification information and is a
         companion to traceparent.
        :paramtype tracestate: str
        :keyword if_match: Only perform the operation if the entity's etag matches one of the etags
         provided or * is provided.
        :paramtype if_match: str
        """
        super().__init__(**kwargs)
        self.traceparent = traceparent
        self.tracestate = tracestate
        self.if_match = if_match


class DigitalTwinsEventRoute(_serialization.Model):
    """A route which directs notification and telemetry events to an endpoint. Endpoints are a
    destination outside of Azure Digital Twins such as an EventHub.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The id of the event route.
    :vartype id: str
    :ivar endpoint_name: The name of the endpoint this event route is bound to. Required.
    :vartype endpoint_name: str
    :ivar filter: An expression which describes the events which are routed to the endpoint.
     Required.
    :vartype filter: str
    """

    _validation = {
        "id": {"readonly": True},
        "endpoint_name": {"required": True},
        "filter": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "endpoint_name": {"key": "endpointName", "type": "str"},
        "filter": {"key": "filter", "type": "str"},
    }

    def __init__(self, *, endpoint_name: str, filter: str, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword endpoint_name: The name of the endpoint this event route is bound to. Required.
        :paramtype endpoint_name: str
        :keyword filter: An expression which describes the events which are routed to the endpoint.
         Required.
        :paramtype filter: str
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.endpoint_name = endpoint_name
        self.filter = filter


class DigitalTwinsGetByIdOptions(_serialization.Model):
    """Parameter group.

    :ivar traceparent: Identifies the request in a distributed tracing system.
    :vartype traceparent: str
    :ivar tracestate: Provides vendor-specific trace identification information and is a companion
     to traceparent.
    :vartype tracestate: str
    """

    _attribute_map = {
        "traceparent": {"key": "traceparent", "type": "str"},
        "tracestate": {"key": "tracestate", "type": "str"},
    }

    def __init__(self, *, traceparent: Optional[str] = None, tracestate: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword traceparent: Identifies the request in a distributed tracing system.
        :paramtype traceparent: str
        :keyword tracestate: Provides vendor-specific trace identification information and is a
         companion to traceparent.
        :paramtype tracestate: str
        """
        super().__init__(**kwargs)
        self.traceparent = traceparent
        self.tracestate = tracestate


class DigitalTwinsGetComponentOptions(_serialization.Model):
    """Parameter group.

    :ivar traceparent: Identifies the request in a distributed tracing system.
    :vartype traceparent: str
    :ivar tracestate: Provides vendor-specific trace identification information and is a companion
     to traceparent.
    :vartype tracestate: str
    """

    _attribute_map = {
        "traceparent": {"key": "traceparent", "type": "str"},
        "tracestate": {"key": "tracestate", "type": "str"},
    }

    def __init__(self, *, traceparent: Optional[str] = None, tracestate: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword traceparent: Identifies the request in a distributed tracing system.
        :paramtype traceparent: str
        :keyword tracestate: Provides vendor-specific trace identification information and is a
         companion to traceparent.
        :paramtype tracestate: str
        """
        super().__init__(**kwargs)
        self.traceparent = traceparent
        self.tracestate = tracestate


class DigitalTwinsGetRelationshipByIdOptions(_serialization.Model):
    """Parameter group.

    :ivar traceparent: Identifies the request in a distributed tracing system.
    :vartype traceparent: str
    :ivar tracestate: Provides vendor-specific trace identification information and is a companion
     to traceparent.
    :vartype tracestate: str
    """

    _attribute_map = {
        "traceparent": {"key": "traceparent", "type": "str"},
        "tracestate": {"key": "tracestate", "type": "str"},
    }

    def __init__(self, *, traceparent: Optional[str] = None, tracestate: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword traceparent: Identifies the request in a distributed tracing system.
        :paramtype traceparent: str
        :keyword tracestate: Provides vendor-specific trace identification information and is a
         companion to traceparent.
        :paramtype tracestate: str
        """
        super().__init__(**kwargs)
        self.traceparent = traceparent
        self.tracestate = tracestate


class DigitalTwinsListIncomingRelationshipsOptions(_serialization.Model):  # pylint: disable=name-too-long
    """Parameter group.

    :ivar traceparent: Identifies the request in a distributed tracing system.
    :vartype traceparent: str
    :ivar tracestate: Provides vendor-specific trace identification information and is a companion
     to traceparent.
    :vartype tracestate: str
    """

    _attribute_map = {
        "traceparent": {"key": "traceparent", "type": "str"},
        "tracestate": {"key": "tracestate", "type": "str"},
    }

    def __init__(self, *, traceparent: Optional[str] = None, tracestate: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword traceparent: Identifies the request in a distributed tracing system.
        :paramtype traceparent: str
        :keyword tracestate: Provides vendor-specific trace identification information and is a
         companion to traceparent.
        :paramtype tracestate: str
        """
        super().__init__(**kwargs)
        self.traceparent = traceparent
        self.tracestate = tracestate


class DigitalTwinsListRelationshipsOptions(_serialization.Model):
    """Parameter group.

    :ivar traceparent: Identifies the request in a distributed tracing system.
    :vartype traceparent: str
    :ivar tracestate: Provides vendor-specific trace identification information and is a companion
     to traceparent.
    :vartype tracestate: str
    """

    _attribute_map = {
        "traceparent": {"key": "traceparent", "type": "str"},
        "tracestate": {"key": "tracestate", "type": "str"},
    }

    def __init__(self, *, traceparent: Optional[str] = None, tracestate: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword traceparent: Identifies the request in a distributed tracing system.
        :paramtype traceparent: str
        :keyword tracestate: Provides vendor-specific trace identification information and is a
         companion to traceparent.
        :paramtype tracestate: str
        """
        super().__init__(**kwargs)
        self.traceparent = traceparent
        self.tracestate = tracestate


class DigitalTwinsModelData(_serialization.Model):
    """A model definition and metadata for that model.

    All required parameters must be populated in order to send to server.

    :ivar display_name: A language map that contains the localized display names as specified in
     the model definition.
    :vartype display_name: dict[str, str]
    :ivar description: A language map that contains the localized descriptions as specified in the
     model definition.
    :vartype description: dict[str, str]
    :ivar id: The id of the model as specified in the model definition. Required.
    :vartype id: str
    :ivar upload_time: The time the model was uploaded to the service.
    :vartype upload_time: ~datetime.datetime
    :ivar decommissioned: Indicates if the model is decommissioned. Decommissioned models cannot be
     referenced by newly created digital twins.
    :vartype decommissioned: bool
    :ivar model: The model definition.
    :vartype model: JSON
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "{str}"},
        "description": {"key": "description", "type": "{str}"},
        "id": {"key": "id", "type": "str"},
        "upload_time": {"key": "uploadTime", "type": "iso-8601"},
        "decommissioned": {"key": "decommissioned", "type": "bool"},
        "model": {"key": "model", "type": "object"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        display_name: Optional[Dict[str, str]] = None,
        description: Optional[Dict[str, str]] = None,
        upload_time: Optional[datetime.datetime] = None,
        decommissioned: bool = False,
        model: Optional[JSON] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display_name: A language map that contains the localized display names as specified in
         the model definition.
        :paramtype display_name: dict[str, str]
        :keyword description: A language map that contains the localized descriptions as specified in
         the model definition.
        :paramtype description: dict[str, str]
        :keyword id: The id of the model as specified in the model definition. Required.
        :paramtype id: str
        :keyword upload_time: The time the model was uploaded to the service.
        :paramtype upload_time: ~datetime.datetime
        :keyword decommissioned: Indicates if the model is decommissioned. Decommissioned models cannot
         be referenced by newly created digital twins.
        :paramtype decommissioned: bool
        :keyword model: The model definition.
        :paramtype model: JSON
        """
        super().__init__(**kwargs)
        self.display_name = display_name
        self.description = description
        self.id = id
        self.upload_time = upload_time
        self.decommissioned = decommissioned
        self.model = model


class DigitalTwinsSendComponentTelemetryOptions(_serialization.Model):  # pylint: disable=name-too-long
    """Parameter group.

    :ivar traceparent: Identifies the request in a distributed tracing system.
    :vartype traceparent: str
    :ivar tracestate: Provides vendor-specific trace identification information and is a companion
     to traceparent.
    :vartype tracestate: str
    """

    _attribute_map = {
        "traceparent": {"key": "traceparent", "type": "str"},
        "tracestate": {"key": "tracestate", "type": "str"},
    }

    def __init__(self, *, traceparent: Optional[str] = None, tracestate: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword traceparent: Identifies the request in a distributed tracing system.
        :paramtype traceparent: str
        :keyword tracestate: Provides vendor-specific trace identification information and is a
         companion to traceparent.
        :paramtype tracestate: str
        """
        super().__init__(**kwargs)
        self.traceparent = traceparent
        self.tracestate = tracestate


class DigitalTwinsSendTelemetryOptions(_serialization.Model):
    """Parameter group.

    :ivar traceparent: Identifies the request in a distributed tracing system.
    :vartype traceparent: str
    :ivar tracestate: Provides vendor-specific trace identification information and is a companion
     to traceparent.
    :vartype tracestate: str
    """

    _attribute_map = {
        "traceparent": {"key": "traceparent", "type": "str"},
        "tracestate": {"key": "tracestate", "type": "str"},
    }

    def __init__(self, *, traceparent: Optional[str] = None, tracestate: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword traceparent: Identifies the request in a distributed tracing system.
        :paramtype traceparent: str
        :keyword tracestate: Provides vendor-specific trace identification information and is a
         companion to traceparent.
        :paramtype tracestate: str
        """
        super().__init__(**kwargs)
        self.traceparent = traceparent
        self.tracestate = tracestate


class DigitalTwinsUpdateComponentOptions(_serialization.Model):
    """Parameter group.

    :ivar traceparent: Identifies the request in a distributed tracing system.
    :vartype traceparent: str
    :ivar tracestate: Provides vendor-specific trace identification information and is a companion
     to traceparent.
    :vartype tracestate: str
    :ivar if_match: Only perform the operation if the entity's etag matches one of the etags
     provided or * is provided.
    :vartype if_match: str
    """

    _attribute_map = {
        "traceparent": {"key": "traceparent", "type": "str"},
        "tracestate": {"key": "tracestate", "type": "str"},
        "if_match": {"key": "If-Match", "type": "str"},
    }

    def __init__(
        self,
        *,
        traceparent: Optional[str] = None,
        tracestate: Optional[str] = None,
        if_match: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword traceparent: Identifies the request in a distributed tracing system.
        :paramtype traceparent: str
        :keyword tracestate: Provides vendor-specific trace identification information and is a
         companion to traceparent.
        :paramtype tracestate: str
        :keyword if_match: Only perform the operation if the entity's etag matches one of the etags
         provided or * is provided.
        :paramtype if_match: str
        """
        super().__init__(**kwargs)
        self.traceparent = traceparent
        self.tracestate = tracestate
        self.if_match = if_match


class DigitalTwinsUpdateOptions(_serialization.Model):
    """Parameter group.

    :ivar traceparent: Identifies the request in a distributed tracing system.
    :vartype traceparent: str
    :ivar tracestate: Provides vendor-specific trace identification information and is a companion
     to traceparent.
    :vartype tracestate: str
    :ivar if_match: Only perform the operation if the entity's etag matches one of the etags
     provided or * is provided.
    :vartype if_match: str
    """

    _attribute_map = {
        "traceparent": {"key": "traceparent", "type": "str"},
        "tracestate": {"key": "tracestate", "type": "str"},
        "if_match": {"key": "If-Match", "type": "str"},
    }

    def __init__(
        self,
        *,
        traceparent: Optional[str] = None,
        tracestate: Optional[str] = None,
        if_match: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword traceparent: Identifies the request in a distributed tracing system.
        :paramtype traceparent: str
        :keyword tracestate: Provides vendor-specific trace identification information and is a
         companion to traceparent.
        :paramtype tracestate: str
        :keyword if_match: Only perform the operation if the entity's etag matches one of the etags
         provided or * is provided.
        :paramtype if_match: str
        """
        super().__init__(**kwargs)
        self.traceparent = traceparent
        self.tracestate = tracestate
        self.if_match = if_match


class DigitalTwinsUpdateRelationshipOptions(_serialization.Model):
    """Parameter group.

    :ivar traceparent: Identifies the request in a distributed tracing system.
    :vartype traceparent: str
    :ivar tracestate: Provides vendor-specific trace identification information and is a companion
     to traceparent.
    :vartype tracestate: str
    :ivar if_match: Only perform the operation if the entity's etag matches one of the etags
     provided or * is provided.
    :vartype if_match: str
    """

    _attribute_map = {
        "traceparent": {"key": "traceparent", "type": "str"},
        "tracestate": {"key": "tracestate", "type": "str"},
        "if_match": {"key": "If-Match", "type": "str"},
    }

    def __init__(
        self,
        *,
        traceparent: Optional[str] = None,
        tracestate: Optional[str] = None,
        if_match: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword traceparent: Identifies the request in a distributed tracing system.
        :paramtype traceparent: str
        :keyword tracestate: Provides vendor-specific trace identification information and is a
         companion to traceparent.
        :paramtype tracestate: str
        :keyword if_match: Only perform the operation if the entity's etag matches one of the etags
         provided or * is provided.
        :paramtype if_match: str
        """
        super().__init__(**kwargs)
        self.traceparent = traceparent
        self.tracestate = tracestate
        self.if_match = if_match


class Error(_serialization.Model):
    """Error definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Service specific error code which serves as the substatus for the HTTP error code.
    :vartype code: str
    :ivar message: A human-readable representation of the error.
    :vartype message: str
    :ivar details: Internal error details.
    :vartype details: list[~azure.digitaltwins.core.models.Error]
    :ivar innererror: An object containing more specific information than the current object about
     the error.
    :vartype innererror: ~azure.digitaltwins.core.models.InnerError
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "details": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "details": {"key": "details", "type": "[Error]"},
        "innererror": {"key": "innererror", "type": "InnerError"},
    }

    def __init__(self, *, innererror: Optional["_models.InnerError"] = None, **kwargs: Any) -> None:
        """
        :keyword innererror: An object containing more specific information than the current object
         about the error.
        :paramtype innererror: ~azure.digitaltwins.core.models.InnerError
        """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.details: Optional[List["_models.Error"]] = None
        self.innererror = innererror


class ErrorResponse(_serialization.Model):
    """Error response.

    All required parameters must be populated in order to send to server.

    :ivar error: The error details. Required.
    :vartype error: ~azure.digitaltwins.core.models.Error
    """

    _validation = {
        "error": {"required": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "Error"},
    }

    def __init__(self, *, error: "_models.Error", **kwargs: Any) -> None:
        """
        :keyword error: The error details. Required.
        :paramtype error: ~azure.digitaltwins.core.models.Error
        """
        super().__init__(**kwargs)
        self.error = error


class EventRouteCollection(_serialization.Model):
    """A collection of EventRoute objects.

    All required parameters must be populated in order to send to server.

    :ivar value: The EventRoute objects. Required.
    :vartype value: list[~azure.digitaltwins.core.models.DigitalTwinsEventRoute]
    :ivar next_link: A URI to retrieve the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DigitalTwinsEventRoute]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.DigitalTwinsEventRoute"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The EventRoute objects. Required.
        :paramtype value: list[~azure.digitaltwins.core.models.DigitalTwinsEventRoute]
        :keyword next_link: A URI to retrieve the next page of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class EventRoutesAddOptions(_serialization.Model):
    """Parameter group.

    :ivar traceparent: Identifies the request in a distributed tracing system.
    :vartype traceparent: str
    :ivar tracestate: Provides vendor-specific trace identification information and is a companion
     to traceparent.
    :vartype tracestate: str
    """

    _attribute_map = {
        "traceparent": {"key": "traceparent", "type": "str"},
        "tracestate": {"key": "tracestate", "type": "str"},
    }

    def __init__(self, *, traceparent: Optional[str] = None, tracestate: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword traceparent: Identifies the request in a distributed tracing system.
        :paramtype traceparent: str
        :keyword tracestate: Provides vendor-specific trace identification information and is a
         companion to traceparent.
        :paramtype tracestate: str
        """
        super().__init__(**kwargs)
        self.traceparent = traceparent
        self.tracestate = tracestate


class EventRoutesDeleteOptions(_serialization.Model):
    """Parameter group.

    :ivar traceparent: Identifies the request in a distributed tracing system.
    :vartype traceparent: str
    :ivar tracestate: Provides vendor-specific trace identification information and is a companion
     to traceparent.
    :vartype tracestate: str
    """

    _attribute_map = {
        "traceparent": {"key": "traceparent", "type": "str"},
        "tracestate": {"key": "tracestate", "type": "str"},
    }

    def __init__(self, *, traceparent: Optional[str] = None, tracestate: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword traceparent: Identifies the request in a distributed tracing system.
        :paramtype traceparent: str
        :keyword tracestate: Provides vendor-specific trace identification information and is a
         companion to traceparent.
        :paramtype tracestate: str
        """
        super().__init__(**kwargs)
        self.traceparent = traceparent
        self.tracestate = tracestate


class EventRoutesGetByIdOptions(_serialization.Model):
    """Parameter group.

    :ivar traceparent: Identifies the request in a distributed tracing system.
    :vartype traceparent: str
    :ivar tracestate: Provides vendor-specific trace identification information and is a companion
     to traceparent.
    :vartype tracestate: str
    """

    _attribute_map = {
        "traceparent": {"key": "traceparent", "type": "str"},
        "tracestate": {"key": "tracestate", "type": "str"},
    }

    def __init__(self, *, traceparent: Optional[str] = None, tracestate: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword traceparent: Identifies the request in a distributed tracing system.
        :paramtype traceparent: str
        :keyword tracestate: Provides vendor-specific trace identification information and is a
         companion to traceparent.
        :paramtype tracestate: str
        """
        super().__init__(**kwargs)
        self.traceparent = traceparent
        self.tracestate = tracestate


class EventRoutesListOptions(_serialization.Model):
    """Parameter group.

    :ivar traceparent: Identifies the request in a distributed tracing system.
    :vartype traceparent: str
    :ivar tracestate: Provides vendor-specific trace identification information and is a companion
     to traceparent.
    :vartype tracestate: str
    :ivar max_items_per_page: The maximum number of items to retrieve per request. The server may
     choose to return less than the requested number.
    :vartype max_items_per_page: int
    """

    _attribute_map = {
        "traceparent": {"key": "traceparent", "type": "str"},
        "tracestate": {"key": "tracestate", "type": "str"},
        "max_items_per_page": {"key": "MaxItemsPerPage", "type": "int"},
    }

    def __init__(
        self,
        *,
        traceparent: Optional[str] = None,
        tracestate: Optional[str] = None,
        max_items_per_page: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword traceparent: Identifies the request in a distributed tracing system.
        :paramtype traceparent: str
        :keyword tracestate: Provides vendor-specific trace identification information and is a
         companion to traceparent.
        :paramtype tracestate: str
        :keyword max_items_per_page: The maximum number of items to retrieve per request. The server
         may choose to return less than the requested number.
        :paramtype max_items_per_page: int
        """
        super().__init__(**kwargs)
        self.traceparent = traceparent
        self.tracestate = tracestate
        self.max_items_per_page = max_items_per_page


class ImportJob(_serialization.Model):
    """A job which contains a reference to the operations to perform, results, and execution metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The identifier of the import job.
    :vartype id: str
    :ivar input_blob_uri: The path to the input Azure storage blob that contains file(s) describing
     the operations to perform in the job. Required.
    :vartype input_blob_uri: str
    :ivar output_blob_uri: The path to the output Azure storage blob that will contain the errors
     and progress logs of import job. Required.
    :vartype output_blob_uri: str
    :ivar status: Status of the job. Known values are: "notstarted", "running", "failed",
     "succeeded", "cancelling", and "cancelled".
    :vartype status: str or ~azure.digitaltwins.core.models.Status
    :ivar created_date_time: Start time of the job. The timestamp is in RFC3339 format:
     ``yyyy-MM-ddTHH:mm:ssZ``.
    :vartype created_date_time: ~datetime.datetime
    :ivar last_action_date_time: Last time service performed any action from the job. The timestamp
     is in RFC3339 format: ``yyyy-MM-ddTHH:mm:ssZ``.
    :vartype last_action_date_time: ~datetime.datetime
    :ivar finished_date_time: End time of the job. The timestamp is in RFC3339 format:
     ``yyyy-MM-ddTHH:mm:ssZ``.
    :vartype finished_date_time: ~datetime.datetime
    :ivar purge_date_time: Time at which job will be purged by the service from the system. The
     timestamp is in RFC3339 format: ``yyyy-MM-ddTHH:mm:ssZ``.
    :vartype purge_date_time: ~datetime.datetime
    :ivar error: Details of the error(s) that occurred executing the import job.
    :vartype error: ~azure.digitaltwins.core.models.Error
    """

    _validation = {
        "id": {"readonly": True},
        "input_blob_uri": {"required": True},
        "output_blob_uri": {"required": True},
        "status": {"readonly": True},
        "created_date_time": {"readonly": True},
        "last_action_date_time": {"readonly": True},
        "finished_date_time": {"readonly": True},
        "purge_date_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "input_blob_uri": {"key": "inputBlobUri", "type": "str"},
        "output_blob_uri": {"key": "outputBlobUri", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "created_date_time": {"key": "createdDateTime", "type": "iso-8601"},
        "last_action_date_time": {"key": "lastActionDateTime", "type": "iso-8601"},
        "finished_date_time": {"key": "finishedDateTime", "type": "iso-8601"},
        "purge_date_time": {"key": "purgeDateTime", "type": "iso-8601"},
        "error": {"key": "error", "type": "Error"},
    }

    def __init__(
        self, *, input_blob_uri: str, output_blob_uri: str, error: Optional["_models.Error"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword input_blob_uri: The path to the input Azure storage blob that contains file(s)
         describing the operations to perform in the job. Required.
        :paramtype input_blob_uri: str
        :keyword output_blob_uri: The path to the output Azure storage blob that will contain the
         errors and progress logs of import job. Required.
        :paramtype output_blob_uri: str
        :keyword error: Details of the error(s) that occurred executing the import job.
        :paramtype error: ~azure.digitaltwins.core.models.Error
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.input_blob_uri = input_blob_uri
        self.output_blob_uri = output_blob_uri
        self.status: Optional[Union[str, "_models.Status"]] = None
        self.created_date_time: Optional[datetime.datetime] = None
        self.last_action_date_time: Optional[datetime.datetime] = None
        self.finished_date_time: Optional[datetime.datetime] = None
        self.purge_date_time: Optional[datetime.datetime] = None
        self.error = error


class ImportJobCollection(_serialization.Model):
    """A collection of import job objects.

    All required parameters must be populated in order to send to server.

    :ivar value: The list of import job objects. Required.
    :vartype value: list[~azure.digitaltwins.core.models.ImportJob]
    :ivar next_link: A URI to retrieve the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ImportJob]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ImportJob"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of import job objects. Required.
        :paramtype value: list[~azure.digitaltwins.core.models.ImportJob]
        :keyword next_link: A URI to retrieve the next page of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ImportJobsAddOptions(_serialization.Model):
    """Parameter group.

    :ivar traceparent: Identifies the request in a distributed tracing system.
    :vartype traceparent: str
    :ivar tracestate: Provides vendor-specific trace identification information and is a companion
     to traceparent.
    :vartype tracestate: str
    """

    _attribute_map = {
        "traceparent": {"key": "traceparent", "type": "str"},
        "tracestate": {"key": "tracestate", "type": "str"},
    }

    def __init__(self, *, traceparent: Optional[str] = None, tracestate: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword traceparent: Identifies the request in a distributed tracing system.
        :paramtype traceparent: str
        :keyword tracestate: Provides vendor-specific trace identification information and is a
         companion to traceparent.
        :paramtype tracestate: str
        """
        super().__init__(**kwargs)
        self.traceparent = traceparent
        self.tracestate = tracestate


class ImportJobsCancelOptions(_serialization.Model):
    """Parameter group.

    :ivar traceparent: Identifies the request in a distributed tracing system.
    :vartype traceparent: str
    :ivar tracestate: Provides vendor-specific trace identification information and is a companion
     to traceparent.
    :vartype tracestate: str
    """

    _attribute_map = {
        "traceparent": {"key": "traceparent", "type": "str"},
        "tracestate": {"key": "tracestate", "type": "str"},
    }

    def __init__(self, *, traceparent: Optional[str] = None, tracestate: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword traceparent: Identifies the request in a distributed tracing system.
        :paramtype traceparent: str
        :keyword tracestate: Provides vendor-specific trace identification information and is a
         companion to traceparent.
        :paramtype tracestate: str
        """
        super().__init__(**kwargs)
        self.traceparent = traceparent
        self.tracestate = tracestate


class ImportJobsDeleteOptions(_serialization.Model):
    """Parameter group.

    :ivar traceparent: Identifies the request in a distributed tracing system.
    :vartype traceparent: str
    :ivar tracestate: Provides vendor-specific trace identification information and is a companion
     to traceparent.
    :vartype tracestate: str
    """

    _attribute_map = {
        "traceparent": {"key": "traceparent", "type": "str"},
        "tracestate": {"key": "tracestate", "type": "str"},
    }

    def __init__(self, *, traceparent: Optional[str] = None, tracestate: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword traceparent: Identifies the request in a distributed tracing system.
        :paramtype traceparent: str
        :keyword tracestate: Provides vendor-specific trace identification information and is a
         companion to traceparent.
        :paramtype tracestate: str
        """
        super().__init__(**kwargs)
        self.traceparent = traceparent
        self.tracestate = tracestate


class ImportJobsGetByIdOptions(_serialization.Model):
    """Parameter group.

    :ivar traceparent: Identifies the request in a distributed tracing system.
    :vartype traceparent: str
    :ivar tracestate: Provides vendor-specific trace identification information and is a companion
     to traceparent.
    :vartype tracestate: str
    """

    _attribute_map = {
        "traceparent": {"key": "traceparent", "type": "str"},
        "tracestate": {"key": "tracestate", "type": "str"},
    }

    def __init__(self, *, traceparent: Optional[str] = None, tracestate: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword traceparent: Identifies the request in a distributed tracing system.
        :paramtype traceparent: str
        :keyword tracestate: Provides vendor-specific trace identification information and is a
         companion to traceparent.
        :paramtype tracestate: str
        """
        super().__init__(**kwargs)
        self.traceparent = traceparent
        self.tracestate = tracestate


class ImportJobsListOptions(_serialization.Model):
    """Parameter group.

    :ivar traceparent: Identifies the request in a distributed tracing system.
    :vartype traceparent: str
    :ivar tracestate: Provides vendor-specific trace identification information and is a companion
     to traceparent.
    :vartype tracestate: str
    :ivar max_items_per_page: The maximum number of items to retrieve per request. The server may
     choose to return less than the requested number.
    :vartype max_items_per_page: int
    """

    _attribute_map = {
        "traceparent": {"key": "traceparent", "type": "str"},
        "tracestate": {"key": "tracestate", "type": "str"},
        "max_items_per_page": {"key": "MaxItemsPerPage", "type": "int"},
    }

    def __init__(
        self,
        *,
        traceparent: Optional[str] = None,
        tracestate: Optional[str] = None,
        max_items_per_page: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword traceparent: Identifies the request in a distributed tracing system.
        :paramtype traceparent: str
        :keyword tracestate: Provides vendor-specific trace identification information and is a
         companion to traceparent.
        :paramtype tracestate: str
        :keyword max_items_per_page: The maximum number of items to retrieve per request. The server
         may choose to return less than the requested number.
        :paramtype max_items_per_page: int
        """
        super().__init__(**kwargs)
        self.traceparent = traceparent
        self.tracestate = tracestate
        self.max_items_per_page = max_items_per_page


class IncomingRelationship(_serialization.Model):
    """An incoming relationship.

    :ivar relationship_id: A user-provided string representing the id of this relationship, unique
     in the context of the source digital twin, i.e. sourceId + relationshipId is unique in the
     context of the service.
    :vartype relationship_id: str
    :ivar source_id: The id of the source digital twin.
    :vartype source_id: str
    :ivar relationship_name: The name of the relationship.
    :vartype relationship_name: str
    :ivar relationship_link: Link to the relationship, to be used for deletion.
    :vartype relationship_link: str
    """

    _attribute_map = {
        "relationship_id": {"key": "$relationshipId", "type": "str"},
        "source_id": {"key": "$sourceId", "type": "str"},
        "relationship_name": {"key": "$relationshipName", "type": "str"},
        "relationship_link": {"key": "$relationshipLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        relationship_id: Optional[str] = None,
        source_id: Optional[str] = None,
        relationship_name: Optional[str] = None,
        relationship_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword relationship_id: A user-provided string representing the id of this relationship,
         unique in the context of the source digital twin, i.e. sourceId + relationshipId is unique in
         the context of the service.
        :paramtype relationship_id: str
        :keyword source_id: The id of the source digital twin.
        :paramtype source_id: str
        :keyword relationship_name: The name of the relationship.
        :paramtype relationship_name: str
        :keyword relationship_link: Link to the relationship, to be used for deletion.
        :paramtype relationship_link: str
        """
        super().__init__(**kwargs)
        self.relationship_id = relationship_id
        self.source_id = source_id
        self.relationship_name = relationship_name
        self.relationship_link = relationship_link


class IncomingRelationshipCollection(_serialization.Model):
    """A collection of incoming relationships which relate digital twins together.

    All required parameters must be populated in order to send to server.

    :ivar value: Required.
    :vartype value: list[~azure.digitaltwins.core.models.IncomingRelationship]
    :ivar next_link: A URI to retrieve the next page of objects.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[IncomingRelationship]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.IncomingRelationship"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Required.
        :paramtype value: list[~azure.digitaltwins.core.models.IncomingRelationship]
        :keyword next_link: A URI to retrieve the next page of objects.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class InnerError(_serialization.Model):
    """A more specific error description than was provided by the containing error.

    :ivar code: A more specific error code than was provided by the containing error.
    :vartype code: str
    :ivar innererror: An object containing more specific information than the current object about
     the error.
    :vartype innererror: ~azure.digitaltwins.core.models.InnerError
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "innererror": {"key": "innererror", "type": "InnerError"},
    }

    def __init__(
        self, *, code: Optional[str] = None, innererror: Optional["_models.InnerError"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword code: A more specific error code than was provided by the containing error.
        :paramtype code: str
        :keyword innererror: An object containing more specific information than the current object
         about the error.
        :paramtype innererror: ~azure.digitaltwins.core.models.InnerError
        """
        super().__init__(**kwargs)
        self.code = code
        self.innererror = innererror


class PagedDigitalTwinsModelDataCollection(_serialization.Model):
    """A collection of DigitalTwinsModelData objects.

    All required parameters must be populated in order to send to server.

    :ivar value: The DigitalTwinsModelData objects. Required.
    :vartype value: list[~azure.digitaltwins.core.models.DigitalTwinsModelData]
    :ivar next_link: A URI to retrieve the next page of objects.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DigitalTwinsModelData]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.DigitalTwinsModelData"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The DigitalTwinsModelData objects. Required.
        :paramtype value: list[~azure.digitaltwins.core.models.DigitalTwinsModelData]
        :keyword next_link: A URI to retrieve the next page of objects.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class QueryResult(_serialization.Model):
    """The results of a query operation and an optional continuation token.

    All required parameters must be populated in order to send to server.

    :ivar value: The query results. Required.
    :vartype value: list[JSON]
    :ivar continuation_token: A token which can be used to construct a new QuerySpecification to
     retrieve the next set of results.
    :vartype continuation_token: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[object]"},
        "continuation_token": {"key": "continuationToken", "type": "str"},
    }

    def __init__(self, *, value: List[JSON], continuation_token: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The query results. Required.
        :paramtype value: list[JSON]
        :keyword continuation_token: A token which can be used to construct a new QuerySpecification to
         retrieve the next set of results.
        :paramtype continuation_token: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.continuation_token = continuation_token


class QuerySpecification(_serialization.Model):
    """A query specification containing either a query statement or a continuation token from a
    previous query result.

    :ivar query: The query to execute. This value is ignored if a continuation token is provided.
    :vartype query: str
    :ivar continuation_token: A token which is used to retrieve the next set of results from a
     previous query.
    :vartype continuation_token: str
    """

    _attribute_map = {
        "query": {"key": "query", "type": "str"},
        "continuation_token": {"key": "continuationToken", "type": "str"},
    }

    def __init__(self, *, query: Optional[str] = None, continuation_token: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword query: The query to execute. This value is ignored if a continuation token is
         provided.
        :paramtype query: str
        :keyword continuation_token: A token which is used to retrieve the next set of results from a
         previous query.
        :paramtype continuation_token: str
        """
        super().__init__(**kwargs)
        self.query = query
        self.continuation_token = continuation_token


class QueryTwinsOptions(_serialization.Model):
    """Parameter group.

    :ivar traceparent: Identifies the request in a distributed tracing system.
    :vartype traceparent: str
    :ivar tracestate: Provides vendor-specific trace identification information and is a companion
     to traceparent.
    :vartype tracestate: str
    :ivar max_items_per_page: The maximum number of items to retrieve per request. The server may
     choose to return less than the requested number.
    :vartype max_items_per_page: int
    """

    _attribute_map = {
        "traceparent": {"key": "traceparent", "type": "str"},
        "tracestate": {"key": "tracestate", "type": "str"},
        "max_items_per_page": {"key": "MaxItemsPerPage", "type": "int"},
    }

    def __init__(
        self,
        *,
        traceparent: Optional[str] = None,
        tracestate: Optional[str] = None,
        max_items_per_page: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword traceparent: Identifies the request in a distributed tracing system.
        :paramtype traceparent: str
        :keyword tracestate: Provides vendor-specific trace identification information and is a
         companion to traceparent.
        :paramtype tracestate: str
        :keyword max_items_per_page: The maximum number of items to retrieve per request. The server
         may choose to return less than the requested number.
        :paramtype max_items_per_page: int
        """
        super().__init__(**kwargs)
        self.traceparent = traceparent
        self.tracestate = tracestate
        self.max_items_per_page = max_items_per_page


class RelationshipCollection(_serialization.Model):
    """A collection of relationships which relate digital twins together.

    All required parameters must be populated in order to send to server.

    :ivar value: The relationship objects. Required.
    :vartype value: list[JSON]
    :ivar next_link: A URI to retrieve the next page of objects.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[object]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List[JSON], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The relationship objects. Required.
        :paramtype value: list[JSON]
        :keyword next_link: A URI to retrieve the next page of objects.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link
