import { Table, Thead, Tr, Th, Tbody, Td } from '@patternfly/react-table';
import {
  Bullseye,
  Button,
  EmptyState,
  EmptyStateVariant,
  EmptyStateBody,
  EmptyStateFooter,
  EmptyStateActions,
  PageSection
} from '@patternfly/react-core';
import SearchIcon from '@patternfly/react-icons/dist/esm/icons/search-icon';
import { DashboardWrapper } from '@patternfly/react-table/dist/esm/demos/DashboardWrapper';

export const TableEmptyStateDefault: React.FunctionComponent = () => (
  <DashboardWrapper hasPageTemplateTitle>
    <PageSection padding={{ default: 'noPadding', xl: 'padding' }} aria-label="Empty state table data">
      <Table aria-label="Empty state table">
        <Thead>
          <Tr>
            <Th>Repositories</Th>
            <Th>Branches</Th>
            <Th>Pull requests</Th>
            <Th>Workspaces</Th>
            <Th>Last commit</Th>
          </Tr>
        </Thead>
        <Tbody>
          <Tr>
            <Td colSpan={8}>
              <Bullseye>
                <EmptyState
                  titleText="No results found"
                  icon={SearchIcon}
                  headingLevel="h2"
                  variant={EmptyStateVariant.sm}
                >
                  <EmptyStateBody>
                    No results match this filter criteria. Clear all filters and try again.
                  </EmptyStateBody>
                  <EmptyStateFooter>
                    <EmptyStateActions>
                      <Button variant="link">Clear all filters</Button>
                    </EmptyStateActions>
                  </EmptyStateFooter>
                </EmptyState>
              </Bullseye>
            </Td>
          </Tr>
        </Tbody>
      </Table>
    </PageSection>
  </DashboardWrapper>
);
