#[derive(Clone,Copy,Eq,PartialEq,Debug)]
pub enum UnicodeBlock {
  BasicLatin, Latin1Supplement, LatinExtendedA, LatinExtendedB, IPAExtensions,
  SpacingModifierLetters, CombiningDiacriticalMarks, GreekandCoptic, Cyrillic,
  CyrillicSupplement, Armenian, Hebrew, Arabic, Syriac, ArabicSupplement,
  Thaana, NKo, Samaritan, Mandaic, ArabicExtendedA, Devanagari, Bengali,
  Gurmukhi, Gujarati, Oriya, Tamil, Telugu, Kannada, Malayalam, Sinhala, Thai,
  Lao, Tibetan, Myanmar, Georgian, HangulJamo, Ethiopic, EthiopicSupplement,
  Cherokee, UnifiedCanadianAboriginalSyllabics, Ogham, Runic, Tagalog, Hanunoo,
  Buhid, Tagbanwa, Khmer, Mongolian, UnifiedCanadianAboriginalSyllabicsExtended,
  Limbu, TaiLe, NewTaiLue, KhmerSymbols, Buginese, TaiTham,
  CombiningDiacriticalMarksExtended, Balinese, Sundanese, Batak, Lepcha,
  OlChiki, CyrillicExtendedC, SundaneseSupplement, VedicExtensions,
  PhoneticExtensions, PhoneticExtensionsSupplement,
  CombiningDiacriticalMarksSupplement, LatinExtendedAdditional, GreekExtended,
  GeneralPunctuation, SuperscriptsandSubscripts, CurrencySymbols,
  CombiningDiacriticalMarksforSymbols, LetterlikeSymbols, NumberForms, Arrows,
  MathematicalOperators, MiscellaneousTechnical, ControlPictures,
  OpticalCharacterRecognition, EnclosedAlphanumerics, BoxDrawing, BlockElements,
  GeometricShapes, MiscellaneousSymbols, Dingbats,
  MiscellaneousMathematicalSymbolsA, SupplementalArrowsA, BraillePatterns,
  SupplementalArrowsB, MiscellaneousMathematicalSymbolsB,
  SupplementalMathematicalOperators, MiscellaneousSymbolsandArrows, Glagolitic,
  LatinExtendedC, Coptic, GeorgianSupplement, Tifinagh, EthiopicExtended,
  CyrillicExtendedA, SupplementalPunctuation, CJKRadicalsSupplement,
  KangxiRadicals, IdeographicDescriptionCharacters, CJKSymbolsandPunctuation,
  Hiragana, Katakana, Bopomofo, HangulCompatibilityJamo, Kanbun,
  BopomofoExtended, CJKStrokes, KatakanaPhoneticExtensions,
  EnclosedCJKLettersandMonths, CJKCompatibility, CJKUnifiedIdeographsExtensionA,
  YijingHexagramSymbols, CJKUnifiedIdeographs, YiSyllables, YiRadicals, Lisu,
  Vai, CyrillicExtendedB, Bamum, ModifierToneLetters, LatinExtendedD,
  SylotiNagri, CommonIndicNumberForms, Phagspa, Saurashtra, DevanagariExtended,
  KayahLi, Rejang, HangulJamoExtendedA, Javanese, MyanmarExtendedB, Cham,
  MyanmarExtendedA, TaiViet, MeeteiMayekExtensions, EthiopicExtendedA,
  LatinExtendedE, CherokeeSupplement, MeeteiMayek, HangulSyllables,
  HangulJamoExtendedB, HighSurrogates, HighPrivateUseSurrogates, LowSurrogates,
  PrivateUseArea, CJKCompatibilityIdeographs, AlphabeticPresentationForms,
  ArabicPresentationFormsA, VariationSelectors, VerticalForms,
  CombiningHalfMarks, CJKCompatibilityForms, SmallFormVariants,
  ArabicPresentationFormsB, HalfwidthandFullwidthForms, Specials,
  LinearBSyllabary, LinearBIdeograms, AegeanNumbers, AncientGreekNumbers,
  AncientSymbols, PhaistosDisc, Lycian, Carian, CopticEpactNumbers, OldItalic,
  Gothic, OldPermic, Ugaritic, OldPersian, Deseret, Shavian, Osmanya, Osage,
  Elbasan, CaucasianAlbanian, LinearA, CypriotSyllabary, ImperialAramaic,
  Palmyrene, Nabataean, Hatran, Phoenician, Lydian, MeroiticHieroglyphs,
  MeroiticCursive, Kharoshthi, OldSouthArabian, OldNorthArabian, Manichaean,
  Avestan, InscriptionalParthian, InscriptionalPahlavi, PsalterPahlavi,
  OldTurkic, OldHungarian, RumiNumeralSymbols, Brahmi, Kaithi, SoraSompeng,
  Chakma, Mahajani, Sharada, SinhalaArchaicNumbers, Khojki, Multani, Khudawadi,
  Grantha, Newa, Tirhuta, Siddham, Modi, MongolianSupplement, Takri, Ahom,
  WarangCiti, PauCinHau, Bhaiksuki, Marchen, Cuneiform,
  CuneiformNumbersandPunctuation, EarlyDynasticCuneiform, EgyptianHieroglyphs,
  AnatolianHieroglyphs, BamumSupplement, Mro, BassaVah, PahawhHmong, Miao,
  IdeographicSymbolsandPunctuation, Tangut, TangutComponents, KanaSupplement,
  Duployan, ShorthandFormatControls, ByzantineMusicalSymbols, MusicalSymbols,
  AncientGreekMusicalNotation, TaiXuanJingSymbols, CountingRodNumerals,
  MathematicalAlphanumericSymbols, SuttonSignWriting, GlagoliticSupplement,
  MendeKikakui, Adlam, ArabicMathematicalAlphabeticSymbols, MahjongTiles,
  DominoTiles, PlayingCards, EnclosedAlphanumericSupplement,
  EnclosedIdeographicSupplement, MiscellaneousSymbolsandPictographs, Emoticons,
  OrnamentalDingbats, TransportandMapSymbols, AlchemicalSymbols,
  GeometricShapesExtended, SupplementalArrowsC,
  SupplementalSymbolsandPictographs, CJKUnifiedIdeographsExtensionB,
  CJKUnifiedIdeographsExtensionC, CJKUnifiedIdeographsExtensionD,
  CJKUnifiedIdeographsExtensionE, CJKCompatibilityIdeographsSupplement, Tags,
  VariationSelectorsSupplement, SupplementaryPrivateUseAreaA,
  SupplementaryPrivateUseAreaB
}

pub static UCD_BLOCK: &'static [((u8,u8,u8), (u8,u8,u8), UnicodeBlock)] = &[
  ((0,0,0),(0,0,127),UnicodeBlock::BasicLatin),
  ((0,0,128),(0,0,255),UnicodeBlock::Latin1Supplement),
  ((0,1,0),(0,1,127),UnicodeBlock::LatinExtendedA),
  ((0,1,128),(0,2,79),UnicodeBlock::LatinExtendedB),
  ((0,2,80),(0,2,175),UnicodeBlock::IPAExtensions),
  ((0,2,176),(0,2,255),UnicodeBlock::SpacingModifierLetters),
  ((0,3,0),(0,3,111),UnicodeBlock::CombiningDiacriticalMarks),
  ((0,3,112),(0,3,255),UnicodeBlock::GreekandCoptic),
  ((0,4,0),(0,4,255),UnicodeBlock::Cyrillic),
  ((0,5,0),(0,5,47),UnicodeBlock::CyrillicSupplement),
  ((0,5,48),(0,5,143),UnicodeBlock::Armenian),
  ((0,5,144),(0,5,255),UnicodeBlock::Hebrew),
  ((0,6,0),(0,6,255),UnicodeBlock::Arabic),
  ((0,7,0),(0,7,79),UnicodeBlock::Syriac),
  ((0,7,80),(0,7,127),UnicodeBlock::ArabicSupplement),
  ((0,7,128),(0,7,191),UnicodeBlock::Thaana),
  ((0,7,192),(0,7,255),UnicodeBlock::NKo),
  ((0,8,0),(0,8,63),UnicodeBlock::Samaritan),
  ((0,8,64),(0,8,95),UnicodeBlock::Mandaic),
  ((0,8,160),(0,8,255),UnicodeBlock::ArabicExtendedA),
  ((0,9,0),(0,9,127),UnicodeBlock::Devanagari),
  ((0,9,128),(0,9,255),UnicodeBlock::Bengali),
  ((0,10,0),(0,10,127),UnicodeBlock::Gurmukhi),
  ((0,10,128),(0,10,255),UnicodeBlock::Gujarati),
  ((0,11,0),(0,11,127),UnicodeBlock::Oriya),
  ((0,11,128),(0,11,255),UnicodeBlock::Tamil),
  ((0,12,0),(0,12,127),UnicodeBlock::Telugu),
  ((0,12,128),(0,12,255),UnicodeBlock::Kannada),
  ((0,13,0),(0,13,127),UnicodeBlock::Malayalam),
  ((0,13,128),(0,13,255),UnicodeBlock::Sinhala),
  ((0,14,0),(0,14,127),UnicodeBlock::Thai),
  ((0,14,128),(0,14,255),UnicodeBlock::Lao),
  ((0,15,0),(0,15,255),UnicodeBlock::Tibetan),
  ((0,16,0),(0,16,159),UnicodeBlock::Myanmar),
  ((0,16,160),(0,16,255),UnicodeBlock::Georgian),
  ((0,17,0),(0,17,255),UnicodeBlock::HangulJamo),
  ((0,18,0),(0,19,127),UnicodeBlock::Ethiopic),
  ((0,19,128),(0,19,159),UnicodeBlock::EthiopicSupplement),
  ((0,19,160),(0,19,255),UnicodeBlock::Cherokee),
  ((0,20,0),(0,22,127),UnicodeBlock::UnifiedCanadianAboriginalSyllabics),
  ((0,22,128),(0,22,159),UnicodeBlock::Ogham),
  ((0,22,160),(0,22,255),UnicodeBlock::Runic),
  ((0,23,0),(0,23,31),UnicodeBlock::Tagalog),
  ((0,23,32),(0,23,63),UnicodeBlock::Hanunoo),
  ((0,23,64),(0,23,95),UnicodeBlock::Buhid),
  ((0,23,96),(0,23,127),UnicodeBlock::Tagbanwa),
  ((0,23,128),(0,23,255),UnicodeBlock::Khmer),
  ((0,24,0),(0,24,175),UnicodeBlock::Mongolian),
  ((0,24,176),(0,24,255),UnicodeBlock::UnifiedCanadianAboriginalSyllabicsExtended),
  ((0,25,0),(0,25,79),UnicodeBlock::Limbu),
  ((0,25,80),(0,25,127),UnicodeBlock::TaiLe),
  ((0,25,128),(0,25,223),UnicodeBlock::NewTaiLue),
  ((0,25,224),(0,25,255),UnicodeBlock::KhmerSymbols),
  ((0,26,0),(0,26,31),UnicodeBlock::Buginese),
  ((0,26,32),(0,26,175),UnicodeBlock::TaiTham),
  ((0,26,176),(0,26,255),UnicodeBlock::CombiningDiacriticalMarksExtended),
  ((0,27,0),(0,27,127),UnicodeBlock::Balinese),
  ((0,27,128),(0,27,191),UnicodeBlock::Sundanese),
  ((0,27,192),(0,27,255),UnicodeBlock::Batak),
  ((0,28,0),(0,28,79),UnicodeBlock::Lepcha),
  ((0,28,80),(0,28,127),UnicodeBlock::OlChiki),
  ((0,28,128),(0,28,143),UnicodeBlock::CyrillicExtendedC),
  ((0,28,192),(0,28,207),UnicodeBlock::SundaneseSupplement),
  ((0,28,208),(0,28,255),UnicodeBlock::VedicExtensions),
  ((0,29,0),(0,29,127),UnicodeBlock::PhoneticExtensions),
  ((0,29,128),(0,29,191),UnicodeBlock::PhoneticExtensionsSupplement),
  ((0,29,192),(0,29,255),UnicodeBlock::CombiningDiacriticalMarksSupplement),
  ((0,30,0),(0,30,255),UnicodeBlock::LatinExtendedAdditional),
  ((0,31,0),(0,31,255),UnicodeBlock::GreekExtended),
  ((0,32,0),(0,32,111),UnicodeBlock::GeneralPunctuation),
  ((0,32,112),(0,32,159),UnicodeBlock::SuperscriptsandSubscripts),
  ((0,32,160),(0,32,207),UnicodeBlock::CurrencySymbols),
  ((0,32,208),(0,32,255),UnicodeBlock::CombiningDiacriticalMarksforSymbols),
  ((0,33,0),(0,33,79),UnicodeBlock::LetterlikeSymbols),
  ((0,33,80),(0,33,143),UnicodeBlock::NumberForms),
  ((0,33,144),(0,33,255),UnicodeBlock::Arrows),
  ((0,34,0),(0,34,255),UnicodeBlock::MathematicalOperators),
  ((0,35,0),(0,35,255),UnicodeBlock::MiscellaneousTechnical),
  ((0,36,0),(0,36,63),UnicodeBlock::ControlPictures),
  ((0,36,64),(0,36,95),UnicodeBlock::OpticalCharacterRecognition),
  ((0,36,96),(0,36,255),UnicodeBlock::EnclosedAlphanumerics),
  ((0,37,0),(0,37,127),UnicodeBlock::BoxDrawing),
  ((0,37,128),(0,37,159),UnicodeBlock::BlockElements),
  ((0,37,160),(0,37,255),UnicodeBlock::GeometricShapes),
  ((0,38,0),(0,38,255),UnicodeBlock::MiscellaneousSymbols),
  ((0,39,0),(0,39,191),UnicodeBlock::Dingbats),
  ((0,39,192),(0,39,239),UnicodeBlock::MiscellaneousMathematicalSymbolsA),
  ((0,39,240),(0,39,255),UnicodeBlock::SupplementalArrowsA),
  ((0,40,0),(0,40,255),UnicodeBlock::BraillePatterns),
  ((0,41,0),(0,41,127),UnicodeBlock::SupplementalArrowsB),
  ((0,41,128),(0,41,255),UnicodeBlock::MiscellaneousMathematicalSymbolsB),
  ((0,42,0),(0,42,255),UnicodeBlock::SupplementalMathematicalOperators),
  ((0,43,0),(0,43,255),UnicodeBlock::MiscellaneousSymbolsandArrows),
  ((0,44,0),(0,44,95),UnicodeBlock::Glagolitic),
  ((0,44,96),(0,44,127),UnicodeBlock::LatinExtendedC),
  ((0,44,128),(0,44,255),UnicodeBlock::Coptic),
  ((0,45,0),(0,45,47),UnicodeBlock::GeorgianSupplement),
  ((0,45,48),(0,45,127),UnicodeBlock::Tifinagh),
  ((0,45,128),(0,45,223),UnicodeBlock::EthiopicExtended),
  ((0,45,224),(0,45,255),UnicodeBlock::CyrillicExtendedA),
  ((0,46,0),(0,46,127),UnicodeBlock::SupplementalPunctuation),
  ((0,46,128),(0,46,255),UnicodeBlock::CJKRadicalsSupplement),
  ((0,47,0),(0,47,223),UnicodeBlock::KangxiRadicals),
  ((0,47,240),(0,47,255),UnicodeBlock::IdeographicDescriptionCharacters),
  ((0,48,0),(0,48,63),UnicodeBlock::CJKSymbolsandPunctuation),
  ((0,48,64),(0,48,159),UnicodeBlock::Hiragana),
  ((0,48,160),(0,48,255),UnicodeBlock::Katakana),
  ((0,49,0),(0,49,47),UnicodeBlock::Bopomofo),
  ((0,49,48),(0,49,143),UnicodeBlock::HangulCompatibilityJamo),
  ((0,49,144),(0,49,159),UnicodeBlock::Kanbun),
  ((0,49,160),(0,49,191),UnicodeBlock::BopomofoExtended),
  ((0,49,192),(0,49,239),UnicodeBlock::CJKStrokes),
  ((0,49,240),(0,49,255),UnicodeBlock::KatakanaPhoneticExtensions),
  ((0,50,0),(0,50,255),UnicodeBlock::EnclosedCJKLettersandMonths),
  ((0,51,0),(0,51,255),UnicodeBlock::CJKCompatibility),
  ((0,52,0),(0,77,191),UnicodeBlock::CJKUnifiedIdeographsExtensionA),
  ((0,77,192),(0,77,255),UnicodeBlock::YijingHexagramSymbols),
  ((0,78,0),(0,159,255),UnicodeBlock::CJKUnifiedIdeographs),
  ((0,160,0),(0,164,143),UnicodeBlock::YiSyllables),
  ((0,164,144),(0,164,207),UnicodeBlock::YiRadicals),
  ((0,164,208),(0,164,255),UnicodeBlock::Lisu),
  ((0,165,0),(0,166,63),UnicodeBlock::Vai),
  ((0,166,64),(0,166,159),UnicodeBlock::CyrillicExtendedB),
  ((0,166,160),(0,166,255),UnicodeBlock::Bamum),
  ((0,167,0),(0,167,31),UnicodeBlock::ModifierToneLetters),
  ((0,167,32),(0,167,255),UnicodeBlock::LatinExtendedD),
  ((0,168,0),(0,168,47),UnicodeBlock::SylotiNagri),
  ((0,168,48),(0,168,63),UnicodeBlock::CommonIndicNumberForms),
  ((0,168,64),(0,168,127),UnicodeBlock::Phagspa),
  ((0,168,128),(0,168,223),UnicodeBlock::Saurashtra),
  ((0,168,224),(0,168,255),UnicodeBlock::DevanagariExtended),
  ((0,169,0),(0,169,47),UnicodeBlock::KayahLi),
  ((0,169,48),(0,169,95),UnicodeBlock::Rejang),
  ((0,169,96),(0,169,127),UnicodeBlock::HangulJamoExtendedA),
  ((0,169,128),(0,169,223),UnicodeBlock::Javanese),
  ((0,169,224),(0,169,255),UnicodeBlock::MyanmarExtendedB),
  ((0,170,0),(0,170,95),UnicodeBlock::Cham),
  ((0,170,96),(0,170,127),UnicodeBlock::MyanmarExtendedA),
  ((0,170,128),(0,170,223),UnicodeBlock::TaiViet),
  ((0,170,224),(0,170,255),UnicodeBlock::MeeteiMayekExtensions),
  ((0,171,0),(0,171,47),UnicodeBlock::EthiopicExtendedA),
  ((0,171,48),(0,171,111),UnicodeBlock::LatinExtendedE),
  ((0,171,112),(0,171,191),UnicodeBlock::CherokeeSupplement),
  ((0,171,192),(0,171,255),UnicodeBlock::MeeteiMayek),
  ((0,172,0),(0,215,175),UnicodeBlock::HangulSyllables),
  ((0,215,176),(0,215,255),UnicodeBlock::HangulJamoExtendedB),
  ((0,216,0),(0,219,127),UnicodeBlock::HighSurrogates),
  ((0,219,128),(0,219,255),UnicodeBlock::HighPrivateUseSurrogates),
  ((0,220,0),(0,223,255),UnicodeBlock::LowSurrogates),
  ((0,224,0),(0,248,255),UnicodeBlock::PrivateUseArea),
  ((0,249,0),(0,250,255),UnicodeBlock::CJKCompatibilityIdeographs),
  ((0,251,0),(0,251,79),UnicodeBlock::AlphabeticPresentationForms),
  ((0,251,80),(0,253,255),UnicodeBlock::ArabicPresentationFormsA),
  ((0,254,0),(0,254,15),UnicodeBlock::VariationSelectors),
  ((0,254,16),(0,254,31),UnicodeBlock::VerticalForms),
  ((0,254,32),(0,254,47),UnicodeBlock::CombiningHalfMarks),
  ((0,254,48),(0,254,79),UnicodeBlock::CJKCompatibilityForms),
  ((0,254,80),(0,254,111),UnicodeBlock::SmallFormVariants),
  ((0,254,112),(0,254,255),UnicodeBlock::ArabicPresentationFormsB),
  ((0,255,0),(0,255,239),UnicodeBlock::HalfwidthandFullwidthForms),
  ((0,255,240),(0,255,255),UnicodeBlock::Specials),
  ((1,0,0),(1,0,127),UnicodeBlock::LinearBSyllabary),
  ((1,0,128),(1,0,255),UnicodeBlock::LinearBIdeograms),
  ((1,1,0),(1,1,63),UnicodeBlock::AegeanNumbers),
  ((1,1,64),(1,1,143),UnicodeBlock::AncientGreekNumbers),
  ((1,1,144),(1,1,207),UnicodeBlock::AncientSymbols),
  ((1,1,208),(1,1,255),UnicodeBlock::PhaistosDisc),
  ((1,2,128),(1,2,159),UnicodeBlock::Lycian),
  ((1,2,160),(1,2,223),UnicodeBlock::Carian),
  ((1,2,224),(1,2,255),UnicodeBlock::CopticEpactNumbers),
  ((1,3,0),(1,3,47),UnicodeBlock::OldItalic),
  ((1,3,48),(1,3,79),UnicodeBlock::Gothic),
  ((1,3,80),(1,3,127),UnicodeBlock::OldPermic),
  ((1,3,128),(1,3,159),UnicodeBlock::Ugaritic),
  ((1,3,160),(1,3,223),UnicodeBlock::OldPersian),
  ((1,4,0),(1,4,79),UnicodeBlock::Deseret),
  ((1,4,80),(1,4,127),UnicodeBlock::Shavian),
  ((1,4,128),(1,4,175),UnicodeBlock::Osmanya),
  ((1,4,176),(1,4,255),UnicodeBlock::Osage),
  ((1,5,0),(1,5,47),UnicodeBlock::Elbasan),
  ((1,5,48),(1,5,111),UnicodeBlock::CaucasianAlbanian),
  ((1,6,0),(1,7,127),UnicodeBlock::LinearA),
  ((1,8,0),(1,8,63),UnicodeBlock::CypriotSyllabary),
  ((1,8,64),(1,8,95),UnicodeBlock::ImperialAramaic),
  ((1,8,96),(1,8,127),UnicodeBlock::Palmyrene),
  ((1,8,128),(1,8,175),UnicodeBlock::Nabataean),
  ((1,8,224),(1,8,255),UnicodeBlock::Hatran),
  ((1,9,0),(1,9,31),UnicodeBlock::Phoenician),
  ((1,9,32),(1,9,63),UnicodeBlock::Lydian),
  ((1,9,128),(1,9,159),UnicodeBlock::MeroiticHieroglyphs),
  ((1,9,160),(1,9,255),UnicodeBlock::MeroiticCursive),
  ((1,10,0),(1,10,95),UnicodeBlock::Kharoshthi),
  ((1,10,96),(1,10,127),UnicodeBlock::OldSouthArabian),
  ((1,10,128),(1,10,159),UnicodeBlock::OldNorthArabian),
  ((1,10,192),(1,10,255),UnicodeBlock::Manichaean),
  ((1,11,0),(1,11,63),UnicodeBlock::Avestan),
  ((1,11,64),(1,11,95),UnicodeBlock::InscriptionalParthian),
  ((1,11,96),(1,11,127),UnicodeBlock::InscriptionalPahlavi),
  ((1,11,128),(1,11,175),UnicodeBlock::PsalterPahlavi),
  ((1,12,0),(1,12,79),UnicodeBlock::OldTurkic),
  ((1,12,128),(1,12,255),UnicodeBlock::OldHungarian),
  ((1,14,96),(1,14,127),UnicodeBlock::RumiNumeralSymbols),
  ((1,16,0),(1,16,127),UnicodeBlock::Brahmi),
  ((1,16,128),(1,16,207),UnicodeBlock::Kaithi),
  ((1,16,208),(1,16,255),UnicodeBlock::SoraSompeng),
  ((1,17,0),(1,17,79),UnicodeBlock::Chakma),
  ((1,17,80),(1,17,127),UnicodeBlock::Mahajani),
  ((1,17,128),(1,17,223),UnicodeBlock::Sharada),
  ((1,17,224),(1,17,255),UnicodeBlock::SinhalaArchaicNumbers),
  ((1,18,0),(1,18,79),UnicodeBlock::Khojki),
  ((1,18,128),(1,18,175),UnicodeBlock::Multani),
  ((1,18,176),(1,18,255),UnicodeBlock::Khudawadi),
  ((1,19,0),(1,19,127),UnicodeBlock::Grantha),
  ((1,20,0),(1,20,127),UnicodeBlock::Newa),
  ((1,20,128),(1,20,223),UnicodeBlock::Tirhuta),
  ((1,21,128),(1,21,255),UnicodeBlock::Siddham),
  ((1,22,0),(1,22,95),UnicodeBlock::Modi),
  ((1,22,96),(1,22,127),UnicodeBlock::MongolianSupplement),
  ((1,22,128),(1,22,207),UnicodeBlock::Takri),
  ((1,23,0),(1,23,63),UnicodeBlock::Ahom),
  ((1,24,160),(1,24,255),UnicodeBlock::WarangCiti),
  ((1,26,192),(1,26,255),UnicodeBlock::PauCinHau),
  ((1,28,0),(1,28,111),UnicodeBlock::Bhaiksuki),
  ((1,28,112),(1,28,191),UnicodeBlock::Marchen),
  ((1,32,0),(1,35,255),UnicodeBlock::Cuneiform),
  ((1,36,0),(1,36,127),UnicodeBlock::CuneiformNumbersandPunctuation),
  ((1,36,128),(1,37,79),UnicodeBlock::EarlyDynasticCuneiform),
  ((1,48,0),(1,52,47),UnicodeBlock::EgyptianHieroglyphs),
  ((1,68,0),(1,70,127),UnicodeBlock::AnatolianHieroglyphs),
  ((1,104,0),(1,106,63),UnicodeBlock::BamumSupplement),
  ((1,106,64),(1,106,111),UnicodeBlock::Mro),
  ((1,106,208),(1,106,255),UnicodeBlock::BassaVah),
  ((1,107,0),(1,107,143),UnicodeBlock::PahawhHmong),
  ((1,111,0),(1,111,159),UnicodeBlock::Miao),
  ((1,111,224),(1,111,255),UnicodeBlock::IdeographicSymbolsandPunctuation),
  ((1,112,0),(1,135,255),UnicodeBlock::Tangut),
  ((1,136,0),(1,138,255),UnicodeBlock::TangutComponents),
  ((1,176,0),(1,176,255),UnicodeBlock::KanaSupplement),
  ((1,188,0),(1,188,159),UnicodeBlock::Duployan),
  ((1,188,160),(1,188,175),UnicodeBlock::ShorthandFormatControls),
  ((1,208,0),(1,208,255),UnicodeBlock::ByzantineMusicalSymbols),
  ((1,209,0),(1,209,255),UnicodeBlock::MusicalSymbols),
  ((1,210,0),(1,210,79),UnicodeBlock::AncientGreekMusicalNotation),
  ((1,211,0),(1,211,95),UnicodeBlock::TaiXuanJingSymbols),
  ((1,211,96),(1,211,127),UnicodeBlock::CountingRodNumerals),
  ((1,212,0),(1,215,255),UnicodeBlock::MathematicalAlphanumericSymbols),
  ((1,216,0),(1,218,175),UnicodeBlock::SuttonSignWriting),
  ((1,224,0),(1,224,47),UnicodeBlock::GlagoliticSupplement),
  ((1,232,0),(1,232,223),UnicodeBlock::MendeKikakui),
  ((1,233,0),(1,233,95),UnicodeBlock::Adlam),
  ((1,238,0),(1,238,255),UnicodeBlock::ArabicMathematicalAlphabeticSymbols),
  ((1,240,0),(1,240,47),UnicodeBlock::MahjongTiles),
  ((1,240,48),(1,240,159),UnicodeBlock::DominoTiles),
  ((1,240,160),(1,240,255),UnicodeBlock::PlayingCards),
  ((1,241,0),(1,241,255),UnicodeBlock::EnclosedAlphanumericSupplement),
  ((1,242,0),(1,242,255),UnicodeBlock::EnclosedIdeographicSupplement),
  ((1,243,0),(1,245,255),UnicodeBlock::MiscellaneousSymbolsandPictographs),
  ((1,246,0),(1,246,79),UnicodeBlock::Emoticons),
  ((1,246,80),(1,246,127),UnicodeBlock::OrnamentalDingbats),
  ((1,246,128),(1,246,255),UnicodeBlock::TransportandMapSymbols),
  ((1,247,0),(1,247,127),UnicodeBlock::AlchemicalSymbols),
  ((1,247,128),(1,247,255),UnicodeBlock::GeometricShapesExtended),
  ((1,248,0),(1,248,255),UnicodeBlock::SupplementalArrowsC),
  ((1,249,0),(1,249,255),UnicodeBlock::SupplementalSymbolsandPictographs),
  ((2,0,0),(2,166,223),UnicodeBlock::CJKUnifiedIdeographsExtensionB),
  ((2,167,0),(2,183,63),UnicodeBlock::CJKUnifiedIdeographsExtensionC),
  ((2,183,64),(2,184,31),UnicodeBlock::CJKUnifiedIdeographsExtensionD),
  ((2,184,32),(2,206,175),UnicodeBlock::CJKUnifiedIdeographsExtensionE),
  ((2,248,0),(2,250,31),UnicodeBlock::CJKCompatibilityIdeographsSupplement),
  ((14,0,0),(14,0,127),UnicodeBlock::Tags),
  ((14,1,0),(14,1,239),UnicodeBlock::VariationSelectorsSupplement),
  ((15,0,0),(15,255,255),UnicodeBlock::SupplementaryPrivateUseAreaA),
  ((16,0,0),(16,255,255),UnicodeBlock::SupplementaryPrivateUseAreaB)
];

pub static UCD_AGE: &'static [((u8,u8,u8), (u8,u8,u8), (u8,u8))] = &[
  ((0,0,0),(0,1,245),(1,1)), ((0,1,246),(0,1,249),(3,0)),
  ((0,1,250),(0,2,23),(1,1)), ((0,2,24),(0,2,31),(3,0)),
  ((0,2,32),(0,2,32),(3,2)), ((0,2,33),(0,2,33),(4,0)),
  ((0,2,34),(0,2,51),(3,0)), ((0,2,52),(0,2,54),(4,0)),
  ((0,2,55),(0,2,65),(4,1)), ((0,2,66),(0,2,79),(5,0)),
  ((0,2,80),(0,2,168),(1,1)), ((0,2,169),(0,2,173),(3,0)),
  ((0,2,174),(0,2,175),(4,0)), ((0,2,176),(0,2,222),(1,1)),
  ((0,2,223),(0,2,223),(3,0)), ((0,2,224),(0,2,233),(1,1)),
  ((0,2,234),(0,2,238),(3,0)), ((0,2,239),(0,2,255),(4,0)),
  ((0,3,0),(0,3,69),(1,1)), ((0,3,70),(0,3,78),(3,0)),
  ((0,3,79),(0,3,79),(3,2)), ((0,3,80),(0,3,87),(4,0)),
  ((0,3,88),(0,3,92),(4,1)), ((0,3,93),(0,3,95),(4,0)),
  ((0,3,96),(0,3,97),(1,1)), ((0,3,98),(0,3,98),(3,0)),
  ((0,3,99),(0,3,111),(3,2)), ((0,3,112),(0,3,115),(5,1)),
  ((0,3,116),(0,3,117),(1,1)), ((0,3,118),(0,3,119),(5,1)),
  ((0,3,122),(0,3,122),(1,1)), ((0,3,123),(0,3,125),(5,0)),
  ((0,3,126),(0,3,126),(1,1)), ((0,3,127),(0,3,127),(7,0)),
  ((0,3,132),(0,3,138),(1,1)), ((0,3,140),(0,3,140),(1,1)),
  ((0,3,142),(0,3,161),(1,1)), ((0,3,163),(0,3,206),(1,1)),
  ((0,3,207),(0,3,207),(5,1)), ((0,3,208),(0,3,214),(1,1)),
  ((0,3,215),(0,3,215),(3,0)), ((0,3,216),(0,3,217),(3,2)),
  ((0,3,218),(0,3,218),(1,1)), ((0,3,219),(0,3,219),(3,0)),
  ((0,3,220),(0,3,220),(1,1)), ((0,3,221),(0,3,221),(3,0)),
  ((0,3,222),(0,3,222),(1,1)), ((0,3,223),(0,3,223),(3,0)),
  ((0,3,224),(0,3,224),(1,1)), ((0,3,225),(0,3,225),(3,0)),
  ((0,3,226),(0,3,243),(1,1)), ((0,3,244),(0,3,245),(3,1)),
  ((0,3,246),(0,3,246),(3,2)), ((0,3,247),(0,3,251),(4,0)),
  ((0,3,252),(0,3,255),(4,1)), ((0,4,0),(0,4,0),(3,0)),
  ((0,4,1),(0,4,12),(1,1)), ((0,4,13),(0,4,13),(3,0)),
  ((0,4,14),(0,4,79),(1,1)), ((0,4,80),(0,4,80),(3,0)),
  ((0,4,81),(0,4,92),(1,1)), ((0,4,93),(0,4,93),(3,0)),
  ((0,4,94),(0,4,134),(1,1)), ((0,4,135),(0,4,135),(5,1)),
  ((0,4,136),(0,4,137),(3,0)), ((0,4,138),(0,4,139),(3,2)),
  ((0,4,140),(0,4,143),(3,0)), ((0,4,144),(0,4,196),(1,1)),
  ((0,4,197),(0,4,198),(3,2)), ((0,4,199),(0,4,200),(1,1)),
  ((0,4,201),(0,4,202),(3,2)), ((0,4,203),(0,4,204),(1,1)),
  ((0,4,205),(0,4,206),(3,2)), ((0,4,207),(0,4,207),(5,0)),
  ((0,4,208),(0,4,235),(1,1)), ((0,4,236),(0,4,237),(3,0)),
  ((0,4,238),(0,4,245),(1,1)), ((0,4,246),(0,4,247),(4,1)),
  ((0,4,248),(0,4,249),(1,1)), ((0,4,250),(0,4,255),(5,0)),
  ((0,5,0),(0,5,15),(3,2)), ((0,5,16),(0,5,19),(5,0)),
  ((0,5,20),(0,5,35),(5,1)), ((0,5,36),(0,5,37),(5,2)),
  ((0,5,38),(0,5,39),(6,0)), ((0,5,40),(0,5,47),(7,0)),
  ((0,5,49),(0,5,86),(1,1)), ((0,5,89),(0,5,95),(1,1)),
  ((0,5,97),(0,5,135),(1,1)), ((0,5,137),(0,5,137),(1,1)),
  ((0,5,138),(0,5,138),(3,0)), ((0,5,141),(0,5,142),(7,0)),
  ((0,5,143),(0,5,143),(6,1)), ((0,5,145),(0,5,161),(2,0)),
  ((0,5,162),(0,5,162),(4,1)), ((0,5,163),(0,5,175),(2,0)),
  ((0,5,176),(0,5,185),(1,1)), ((0,5,186),(0,5,186),(5,0)),
  ((0,5,187),(0,5,195),(1,1)), ((0,5,196),(0,5,196),(2,0)),
  ((0,5,197),(0,5,199),(4,1)), ((0,5,208),(0,5,234),(1,1)),
  ((0,5,240),(0,5,244),(1,1)), ((0,6,0),(0,6,3),(4,0)), ((0,6,4),(0,6,4),(6,1)),
  ((0,6,5),(0,6,5),(7,0)), ((0,6,6),(0,6,10),(5,1)), ((0,6,11),(0,6,11),(4,1)),
  ((0,6,12),(0,6,12),(1,1)), ((0,6,13),(0,6,21),(4,0)),
  ((0,6,22),(0,6,26),(5,1)), ((0,6,27),(0,6,27),(1,1)),
  ((0,6,28),(0,6,28),(6,3)), ((0,6,30),(0,6,30),(4,1)),
  ((0,6,31),(0,6,31),(1,1)), ((0,6,32),(0,6,32),(6,0)),
  ((0,6,33),(0,6,58),(1,1)), ((0,6,59),(0,6,63),(5,1)),
  ((0,6,64),(0,6,82),(1,1)), ((0,6,83),(0,6,85),(3,0)),
  ((0,6,86),(0,6,88),(4,0)), ((0,6,89),(0,6,94),(4,1)),
  ((0,6,95),(0,6,95),(6,0)), ((0,6,96),(0,6,109),(1,1)),
  ((0,6,110),(0,6,111),(3,2)), ((0,6,112),(0,6,183),(1,1)),
  ((0,6,184),(0,6,185),(3,0)), ((0,6,186),(0,6,190),(1,1)),
  ((0,6,191),(0,6,191),(3,0)), ((0,6,192),(0,6,206),(1,1)),
  ((0,6,207),(0,6,207),(3,0)), ((0,6,208),(0,6,237),(1,1)),
  ((0,6,238),(0,6,239),(4,0)), ((0,6,240),(0,6,249),(1,1)),
  ((0,6,250),(0,6,254),(3,0)), ((0,6,255),(0,6,255),(4,0)),
  ((0,7,0),(0,7,13),(3,0)), ((0,7,15),(0,7,44),(3,0)),
  ((0,7,45),(0,7,47),(4,0)), ((0,7,48),(0,7,74),(3,0)),
  ((0,7,77),(0,7,79),(4,0)), ((0,7,80),(0,7,109),(4,1)),
  ((0,7,110),(0,7,127),(5,1)), ((0,7,128),(0,7,176),(3,0)),
  ((0,7,177),(0,7,177),(3,2)), ((0,7,192),(0,7,250),(5,0)),
  ((0,8,0),(0,8,45),(5,2)), ((0,8,48),(0,8,62),(5,2)),
  ((0,8,64),(0,8,91),(6,0)), ((0,8,94),(0,8,94),(6,0)),
  ((0,8,160),(0,8,160),(6,1)), ((0,8,161),(0,8,161),(7,0)),
  ((0,8,162),(0,8,172),(6,1)), ((0,8,173),(0,8,178),(7,0)),
  ((0,8,179),(0,8,180),(8,0)), ((0,8,182),(0,8,189),(9,0)),
  ((0,8,212),(0,8,226),(9,0)), ((0,8,227),(0,8,227),(8,0)),
  ((0,8,228),(0,8,254),(6,1)), ((0,8,255),(0,8,255),(7,0)),
  ((0,9,0),(0,9,0),(5,2)), ((0,9,1),(0,9,3),(1,1)), ((0,9,4),(0,9,4),(4,0)),
  ((0,9,5),(0,9,57),(1,1)), ((0,9,58),(0,9,59),(6,0)),
  ((0,9,60),(0,9,77),(1,1)), ((0,9,78),(0,9,78),(5,2)),
  ((0,9,79),(0,9,79),(6,0)), ((0,9,80),(0,9,84),(1,1)),
  ((0,9,85),(0,9,85),(5,2)), ((0,9,86),(0,9,87),(6,0)),
  ((0,9,88),(0,9,112),(1,1)), ((0,9,113),(0,9,114),(5,1)),
  ((0,9,115),(0,9,119),(6,0)), ((0,9,120),(0,9,120),(7,0)),
  ((0,9,121),(0,9,122),(5,2)), ((0,9,123),(0,9,124),(5,0)),
  ((0,9,125),(0,9,125),(4,1)), ((0,9,126),(0,9,127),(5,0)),
  ((0,9,128),(0,9,128),(7,0)), ((0,9,129),(0,9,131),(1,1)),
  ((0,9,133),(0,9,140),(1,1)), ((0,9,143),(0,9,144),(1,1)),
  ((0,9,147),(0,9,168),(1,1)), ((0,9,170),(0,9,176),(1,1)),
  ((0,9,178),(0,9,178),(1,1)), ((0,9,182),(0,9,185),(1,1)),
  ((0,9,188),(0,9,188),(1,1)), ((0,9,189),(0,9,189),(4,0)),
  ((0,9,190),(0,9,196),(1,1)), ((0,9,199),(0,9,200),(1,1)),
  ((0,9,203),(0,9,205),(1,1)), ((0,9,206),(0,9,206),(4,1)),
  ((0,9,215),(0,9,215),(1,1)), ((0,9,220),(0,9,221),(1,1)),
  ((0,9,223),(0,9,227),(1,1)), ((0,9,230),(0,9,250),(1,1)),
  ((0,9,251),(0,9,251),(5,2)), ((0,10,1),(0,10,1),(4,0)),
  ((0,10,2),(0,10,2),(1,1)), ((0,10,3),(0,10,3),(4,0)),
  ((0,10,5),(0,10,10),(1,1)), ((0,10,15),(0,10,16),(1,1)),
  ((0,10,19),(0,10,40),(1,1)), ((0,10,42),(0,10,48),(1,1)),
  ((0,10,50),(0,10,51),(1,1)), ((0,10,53),(0,10,54),(1,1)),
  ((0,10,56),(0,10,57),(1,1)), ((0,10,60),(0,10,60),(1,1)),
  ((0,10,62),(0,10,66),(1,1)), ((0,10,71),(0,10,72),(1,1)),
  ((0,10,75),(0,10,77),(1,1)), ((0,10,81),(0,10,81),(5,1)),
  ((0,10,89),(0,10,92),(1,1)), ((0,10,94),(0,10,94),(1,1)),
  ((0,10,102),(0,10,116),(1,1)), ((0,10,117),(0,10,117),(5,1)),
  ((0,10,129),(0,10,131),(1,1)), ((0,10,133),(0,10,139),(1,1)),
  ((0,10,140),(0,10,140),(4,0)), ((0,10,141),(0,10,141),(1,1)),
  ((0,10,143),(0,10,145),(1,1)), ((0,10,147),(0,10,168),(1,1)),
  ((0,10,170),(0,10,176),(1,1)), ((0,10,178),(0,10,179),(1,1)),
  ((0,10,181),(0,10,185),(1,1)), ((0,10,188),(0,10,197),(1,1)),
  ((0,10,199),(0,10,201),(1,1)), ((0,10,203),(0,10,205),(1,1)),
  ((0,10,208),(0,10,208),(1,1)), ((0,10,224),(0,10,224),(1,1)),
  ((0,10,225),(0,10,227),(4,0)), ((0,10,230),(0,10,239),(1,1)),
  ((0,10,240),(0,10,240),(6,1)), ((0,10,241),(0,10,241),(4,0)),
  ((0,10,249),(0,10,249),(8,0)), ((0,11,1),(0,11,3),(1,1)),
  ((0,11,5),(0,11,12),(1,1)), ((0,11,15),(0,11,16),(1,1)),
  ((0,11,19),(0,11,40),(1,1)), ((0,11,42),(0,11,48),(1,1)),
  ((0,11,50),(0,11,51),(1,1)), ((0,11,53),(0,11,53),(4,0)),
  ((0,11,54),(0,11,57),(1,1)), ((0,11,60),(0,11,67),(1,1)),
  ((0,11,68),(0,11,68),(5,1)), ((0,11,71),(0,11,72),(1,1)),
  ((0,11,75),(0,11,77),(1,1)), ((0,11,86),(0,11,87),(1,1)),
  ((0,11,92),(0,11,93),(1,1)), ((0,11,95),(0,11,97),(1,1)),
  ((0,11,98),(0,11,99),(5,1)), ((0,11,102),(0,11,112),(1,1)),
  ((0,11,113),(0,11,113),(4,0)), ((0,11,114),(0,11,119),(6,0)),
  ((0,11,130),(0,11,131),(1,1)), ((0,11,133),(0,11,138),(1,1)),
  ((0,11,142),(0,11,144),(1,1)), ((0,11,146),(0,11,149),(1,1)),
  ((0,11,153),(0,11,154),(1,1)), ((0,11,156),(0,11,156),(1,1)),
  ((0,11,158),(0,11,159),(1,1)), ((0,11,163),(0,11,164),(1,1)),
  ((0,11,168),(0,11,170),(1,1)), ((0,11,174),(0,11,181),(1,1)),
  ((0,11,182),(0,11,182),(4,1)), ((0,11,183),(0,11,185),(1,1)),
  ((0,11,190),(0,11,194),(1,1)), ((0,11,198),(0,11,200),(1,1)),
  ((0,11,202),(0,11,205),(1,1)), ((0,11,208),(0,11,208),(5,1)),
  ((0,11,215),(0,11,215),(1,1)), ((0,11,230),(0,11,230),(4,1)),
  ((0,11,231),(0,11,242),(1,1)), ((0,11,243),(0,11,250),(4,0)),
  ((0,12,0),(0,12,0),(7,0)), ((0,12,1),(0,12,3),(1,1)),
  ((0,12,5),(0,12,12),(1,1)), ((0,12,14),(0,12,16),(1,1)),
  ((0,12,18),(0,12,40),(1,1)), ((0,12,42),(0,12,51),(1,1)),
  ((0,12,52),(0,12,52),(7,0)), ((0,12,53),(0,12,57),(1,1)),
  ((0,12,61),(0,12,61),(5,1)), ((0,12,62),(0,12,68),(1,1)),
  ((0,12,70),(0,12,72),(1,1)), ((0,12,74),(0,12,77),(1,1)),
  ((0,12,85),(0,12,86),(1,1)), ((0,12,88),(0,12,89),(5,1)),
  ((0,12,90),(0,12,90),(8,0)), ((0,12,96),(0,12,97),(1,1)),
  ((0,12,98),(0,12,99),(5,1)), ((0,12,102),(0,12,111),(1,1)),
  ((0,12,120),(0,12,127),(5,1)), ((0,12,128),(0,12,128),(9,0)),
  ((0,12,129),(0,12,129),(7,0)), ((0,12,130),(0,12,131),(1,1)),
  ((0,12,133),(0,12,140),(1,1)), ((0,12,142),(0,12,144),(1,1)),
  ((0,12,146),(0,12,168),(1,1)), ((0,12,170),(0,12,179),(1,1)),
  ((0,12,181),(0,12,185),(1,1)), ((0,12,188),(0,12,189),(4,0)),
  ((0,12,190),(0,12,196),(1,1)), ((0,12,198),(0,12,200),(1,1)),
  ((0,12,202),(0,12,205),(1,1)), ((0,12,213),(0,12,214),(1,1)),
  ((0,12,222),(0,12,222),(1,1)), ((0,12,224),(0,12,225),(1,1)),
  ((0,12,226),(0,12,227),(5,0)), ((0,12,230),(0,12,239),(1,1)),
  ((0,12,241),(0,12,242),(5,0)), ((0,13,1),(0,13,1),(7,0)),
  ((0,13,2),(0,13,3),(1,1)), ((0,13,5),(0,13,12),(1,1)),
  ((0,13,14),(0,13,16),(1,1)), ((0,13,18),(0,13,40),(1,1)),
  ((0,13,41),(0,13,41),(6,0)), ((0,13,42),(0,13,57),(1,1)),
  ((0,13,58),(0,13,58),(6,0)), ((0,13,61),(0,13,61),(5,1)),
  ((0,13,62),(0,13,67),(1,1)), ((0,13,68),(0,13,68),(5,1)),
  ((0,13,70),(0,13,72),(1,1)), ((0,13,74),(0,13,77),(1,1)),
  ((0,13,78),(0,13,78),(6,0)), ((0,13,79),(0,13,79),(9,0)),
  ((0,13,84),(0,13,86),(9,0)), ((0,13,87),(0,13,87),(1,1)),
  ((0,13,88),(0,13,94),(9,0)), ((0,13,95),(0,13,95),(8,0)),
  ((0,13,96),(0,13,97),(1,1)), ((0,13,98),(0,13,99),(5,1)),
  ((0,13,102),(0,13,111),(1,1)), ((0,13,112),(0,13,117),(5,1)),
  ((0,13,118),(0,13,120),(9,0)), ((0,13,121),(0,13,127),(5,1)),
  ((0,13,130),(0,13,131),(3,0)), ((0,13,133),(0,13,150),(3,0)),
  ((0,13,154),(0,13,177),(3,0)), ((0,13,179),(0,13,187),(3,0)),
  ((0,13,189),(0,13,189),(3,0)), ((0,13,192),(0,13,198),(3,0)),
  ((0,13,202),(0,13,202),(3,0)), ((0,13,207),(0,13,212),(3,0)),
  ((0,13,214),(0,13,214),(3,0)), ((0,13,216),(0,13,223),(3,0)),
  ((0,13,230),(0,13,239),(7,0)), ((0,13,242),(0,13,244),(3,0)),
  ((0,14,1),(0,14,58),(1,1)), ((0,14,63),(0,14,91),(1,1)),
  ((0,14,129),(0,14,130),(1,1)), ((0,14,132),(0,14,132),(1,1)),
  ((0,14,135),(0,14,136),(1,1)), ((0,14,138),(0,14,138),(1,1)),
  ((0,14,141),(0,14,141),(1,1)), ((0,14,148),(0,14,151),(1,1)),
  ((0,14,153),(0,14,159),(1,1)), ((0,14,161),(0,14,163),(1,1)),
  ((0,14,165),(0,14,165),(1,1)), ((0,14,167),(0,14,167),(1,1)),
  ((0,14,170),(0,14,171),(1,1)), ((0,14,173),(0,14,185),(1,1)),
  ((0,14,187),(0,14,189),(1,1)), ((0,14,192),(0,14,196),(1,1)),
  ((0,14,198),(0,14,198),(1,1)), ((0,14,200),(0,14,205),(1,1)),
  ((0,14,208),(0,14,217),(1,1)), ((0,14,220),(0,14,221),(1,1)),
  ((0,14,222),(0,14,223),(6,1)), ((0,15,0),(0,15,71),(2,0)),
  ((0,15,73),(0,15,105),(2,0)), ((0,15,106),(0,15,106),(3,0)),
  ((0,15,107),(0,15,108),(5,1)), ((0,15,113),(0,15,139),(2,0)),
  ((0,15,140),(0,15,143),(6,0)), ((0,15,144),(0,15,149),(2,0)),
  ((0,15,150),(0,15,150),(3,0)), ((0,15,151),(0,15,151),(2,0)),
  ((0,15,153),(0,15,173),(2,0)), ((0,15,174),(0,15,176),(3,0)),
  ((0,15,177),(0,15,183),(2,0)), ((0,15,184),(0,15,184),(3,0)),
  ((0,15,185),(0,15,185),(2,0)), ((0,15,186),(0,15,188),(3,0)),
  ((0,15,190),(0,15,204),(3,0)), ((0,15,206),(0,15,206),(5,1)),
  ((0,15,207),(0,15,207),(3,0)), ((0,15,208),(0,15,209),(4,1)),
  ((0,15,210),(0,15,212),(5,1)), ((0,15,213),(0,15,216),(5,2)),
  ((0,15,217),(0,15,218),(6,0)), ((0,16,0),(0,16,33),(3,0)),
  ((0,16,34),(0,16,34),(5,1)), ((0,16,35),(0,16,39),(3,0)),
  ((0,16,40),(0,16,40),(5,1)), ((0,16,41),(0,16,42),(3,0)),
  ((0,16,43),(0,16,43),(5,1)), ((0,16,44),(0,16,50),(3,0)),
  ((0,16,51),(0,16,53),(5,1)), ((0,16,54),(0,16,57),(3,0)),
  ((0,16,58),(0,16,63),(5,1)), ((0,16,64),(0,16,89),(3,0)),
  ((0,16,90),(0,16,153),(5,1)), ((0,16,154),(0,16,157),(5,2)),
  ((0,16,158),(0,16,159),(5,1)), ((0,16,160),(0,16,197),(1,1)),
  ((0,16,199),(0,16,199),(6,1)), ((0,16,205),(0,16,205),(6,1)),
  ((0,16,208),(0,16,246),(1,1)), ((0,16,247),(0,16,248),(3,2)),
  ((0,16,249),(0,16,250),(4,1)), ((0,16,251),(0,16,251),(1,1)),
  ((0,16,252),(0,16,252),(4,1)), ((0,16,253),(0,16,255),(6,1)),
  ((0,17,0),(0,17,89),(1,1)), ((0,17,90),(0,17,94),(5,2)),
  ((0,17,95),(0,17,162),(1,1)), ((0,17,163),(0,17,167),(5,2)),
  ((0,17,168),(0,17,249),(1,1)), ((0,17,250),(0,17,255),(5,2)),
  ((0,18,0),(0,18,6),(3,0)), ((0,18,7),(0,18,7),(4,1)),
  ((0,18,8),(0,18,70),(3,0)), ((0,18,71),(0,18,71),(4,1)),
  ((0,18,72),(0,18,72),(3,0)), ((0,18,74),(0,18,77),(3,0)),
  ((0,18,80),(0,18,86),(3,0)), ((0,18,88),(0,18,88),(3,0)),
  ((0,18,90),(0,18,93),(3,0)), ((0,18,96),(0,18,134),(3,0)),
  ((0,18,135),(0,18,135),(4,1)), ((0,18,136),(0,18,136),(3,0)),
  ((0,18,138),(0,18,141),(3,0)), ((0,18,144),(0,18,174),(3,0)),
  ((0,18,175),(0,18,175),(4,1)), ((0,18,176),(0,18,176),(3,0)),
  ((0,18,178),(0,18,181),(3,0)), ((0,18,184),(0,18,190),(3,0)),
  ((0,18,192),(0,18,192),(3,0)), ((0,18,194),(0,18,197),(3,0)),
  ((0,18,200),(0,18,206),(3,0)), ((0,18,207),(0,18,207),(4,1)),
  ((0,18,208),(0,18,214),(3,0)), ((0,18,216),(0,18,238),(3,0)),
  ((0,18,239),(0,18,239),(4,1)), ((0,18,240),(0,19,14),(3,0)),
  ((0,19,15),(0,19,15),(4,1)), ((0,19,16),(0,19,16),(3,0)),
  ((0,19,18),(0,19,21),(3,0)), ((0,19,24),(0,19,30),(3,0)),
  ((0,19,31),(0,19,31),(4,1)), ((0,19,32),(0,19,70),(3,0)),
  ((0,19,71),(0,19,71),(4,1)), ((0,19,72),(0,19,90),(3,0)),
  ((0,19,93),(0,19,94),(6,0)), ((0,19,95),(0,19,96),(4,1)),
  ((0,19,97),(0,19,124),(3,0)), ((0,19,128),(0,19,153),(4,1)),
  ((0,19,160),(0,19,244),(3,0)), ((0,19,245),(0,19,245),(8,0)),
  ((0,19,248),(0,19,253),(8,0)), ((0,20,0),(0,20,0),(5,2)),
  ((0,20,1),(0,22,118),(3,0)), ((0,22,119),(0,22,127),(5,2)),
  ((0,22,128),(0,22,156),(3,0)), ((0,22,160),(0,22,240),(3,0)),
  ((0,22,241),(0,22,248),(7,0)), ((0,23,0),(0,23,12),(3,2)),
  ((0,23,14),(0,23,20),(3,2)), ((0,23,32),(0,23,54),(3,2)),
  ((0,23,64),(0,23,83),(3,2)), ((0,23,96),(0,23,108),(3,2)),
  ((0,23,110),(0,23,112),(3,2)), ((0,23,114),(0,23,115),(3,2)),
  ((0,23,128),(0,23,220),(3,0)), ((0,23,221),(0,23,221),(4,0)),
  ((0,23,224),(0,23,233),(3,0)), ((0,23,240),(0,23,249),(4,0)),
  ((0,24,0),(0,24,14),(3,0)), ((0,24,16),(0,24,25),(3,0)),
  ((0,24,32),(0,24,119),(3,0)), ((0,24,128),(0,24,169),(3,0)),
  ((0,24,170),(0,24,170),(5,1)), ((0,24,176),(0,24,245),(5,2)),
  ((0,25,0),(0,25,28),(4,0)), ((0,25,29),(0,25,30),(7,0)),
  ((0,25,32),(0,25,43),(4,0)), ((0,25,48),(0,25,59),(4,0)),
  ((0,25,64),(0,25,64),(4,0)), ((0,25,68),(0,25,109),(4,0)),
  ((0,25,112),(0,25,116),(4,0)), ((0,25,128),(0,25,169),(4,1)),
  ((0,25,170),(0,25,171),(5,2)), ((0,25,176),(0,25,201),(4,1)),
  ((0,25,208),(0,25,217),(4,1)), ((0,25,218),(0,25,218),(5,2)),
  ((0,25,222),(0,25,223),(4,1)), ((0,25,224),(0,25,255),(4,0)),
  ((0,26,0),(0,26,27),(4,1)), ((0,26,30),(0,26,31),(4,1)),
  ((0,26,32),(0,26,94),(5,2)), ((0,26,96),(0,26,124),(5,2)),
  ((0,26,127),(0,26,137),(5,2)), ((0,26,144),(0,26,153),(5,2)),
  ((0,26,160),(0,26,173),(5,2)), ((0,26,176),(0,26,190),(7,0)),
  ((0,27,0),(0,27,75),(5,0)), ((0,27,80),(0,27,124),(5,0)),
  ((0,27,128),(0,27,170),(5,1)), ((0,27,171),(0,27,173),(6,1)),
  ((0,27,174),(0,27,185),(5,1)), ((0,27,186),(0,27,191),(6,1)),
  ((0,27,192),(0,27,243),(6,0)), ((0,27,252),(0,27,255),(6,0)),
  ((0,28,0),(0,28,55),(5,1)), ((0,28,59),(0,28,73),(5,1)),
  ((0,28,77),(0,28,127),(5,1)), ((0,28,128),(0,28,136),(9,0)),
  ((0,28,192),(0,28,199),(6,1)), ((0,28,208),(0,28,242),(5,2)),
  ((0,28,243),(0,28,246),(6,1)), ((0,28,248),(0,28,249),(7,0)),
  ((0,29,0),(0,29,107),(4,0)), ((0,29,108),(0,29,195),(4,1)),
  ((0,29,196),(0,29,202),(5,0)), ((0,29,203),(0,29,230),(5,1)),
  ((0,29,231),(0,29,245),(7,0)), ((0,29,251),(0,29,251),(9,0)),
  ((0,29,252),(0,29,252),(6,0)), ((0,29,253),(0,29,253),(5,2)),
  ((0,29,254),(0,29,255),(5,0)), ((0,30,0),(0,30,154),(1,1)),
  ((0,30,155),(0,30,155),(2,0)), ((0,30,156),(0,30,159),(5,1)),
  ((0,30,160),(0,30,249),(1,1)), ((0,30,250),(0,30,255),(5,1)),
  ((0,31,0),(0,31,21),(1,1)), ((0,31,24),(0,31,29),(1,1)),
  ((0,31,32),(0,31,69),(1,1)), ((0,31,72),(0,31,77),(1,1)),
  ((0,31,80),(0,31,87),(1,1)), ((0,31,89),(0,31,89),(1,1)),
  ((0,31,91),(0,31,91),(1,1)), ((0,31,93),(0,31,93),(1,1)),
  ((0,31,95),(0,31,125),(1,1)), ((0,31,128),(0,31,180),(1,1)),
  ((0,31,182),(0,31,196),(1,1)), ((0,31,198),(0,31,211),(1,1)),
  ((0,31,214),(0,31,219),(1,1)), ((0,31,221),(0,31,239),(1,1)),
  ((0,31,242),(0,31,244),(1,1)), ((0,31,246),(0,31,254),(1,1)),
  ((0,32,0),(0,32,46),(1,1)), ((0,32,47),(0,32,47),(3,0)),
  ((0,32,48),(0,32,70),(1,1)), ((0,32,71),(0,32,71),(3,2)),
  ((0,32,72),(0,32,77),(3,0)), ((0,32,78),(0,32,82),(3,2)),
  ((0,32,83),(0,32,84),(4,0)), ((0,32,85),(0,32,86),(4,1)),
  ((0,32,87),(0,32,87),(3,2)), ((0,32,88),(0,32,94),(4,1)),
  ((0,32,95),(0,32,99),(3,2)), ((0,32,100),(0,32,100),(5,1)),
  ((0,32,102),(0,32,105),(6,3)), ((0,32,106),(0,32,112),(1,1)),
  ((0,32,113),(0,32,113),(3,2)), ((0,32,116),(0,32,142),(1,1)),
  ((0,32,144),(0,32,148),(4,1)), ((0,32,149),(0,32,156),(6,0)),
  ((0,32,160),(0,32,170),(1,1)), ((0,32,171),(0,32,171),(2,0)),
  ((0,32,172),(0,32,172),(2,1)), ((0,32,173),(0,32,175),(3,0)),
  ((0,32,176),(0,32,177),(3,2)), ((0,32,178),(0,32,181),(4,1)),
  ((0,32,182),(0,32,184),(5,2)), ((0,32,185),(0,32,185),(6,0)),
  ((0,32,186),(0,32,186),(6,2)), ((0,32,187),(0,32,189),(7,0)),
  ((0,32,190),(0,32,190),(8,0)), ((0,32,208),(0,32,225),(1,1)),
  ((0,32,226),(0,32,227),(3,0)), ((0,32,228),(0,32,234),(3,2)),
  ((0,32,235),(0,32,235),(4,1)), ((0,32,236),(0,32,239),(5,0)),
  ((0,32,240),(0,32,240),(5,1)), ((0,33,0),(0,33,56),(1,1)),
  ((0,33,57),(0,33,58),(3,0)), ((0,33,59),(0,33,59),(4,0)),
  ((0,33,60),(0,33,60),(4,1)), ((0,33,61),(0,33,75),(3,2)),
  ((0,33,76),(0,33,76),(4,1)), ((0,33,77),(0,33,78),(5,0)),
  ((0,33,79),(0,33,79),(5,1)), ((0,33,80),(0,33,82),(5,2)),
  ((0,33,83),(0,33,130),(1,1)), ((0,33,131),(0,33,131),(3,0)),
  ((0,33,132),(0,33,132),(5,0)), ((0,33,133),(0,33,136),(5,1)),
  ((0,33,137),(0,33,137),(5,2)), ((0,33,138),(0,33,139),(8,0)),
  ((0,33,144),(0,33,234),(1,1)), ((0,33,235),(0,33,243),(3,0)),
  ((0,33,244),(0,33,255),(3,2)), ((0,34,0),(0,34,241),(1,1)),
  ((0,34,242),(0,34,255),(3,2)), ((0,35,0),(0,35,0),(1,1)),
  ((0,35,1),(0,35,1),(3,0)), ((0,35,2),(0,35,122),(1,1)),
  ((0,35,123),(0,35,123),(3,0)), ((0,35,124),(0,35,124),(3,2)),
  ((0,35,125),(0,35,154),(3,0)), ((0,35,155),(0,35,206),(3,2)),
  ((0,35,207),(0,35,208),(4,0)), ((0,35,209),(0,35,219),(4,1)),
  ((0,35,220),(0,35,231),(5,0)), ((0,35,232),(0,35,232),(5,2)),
  ((0,35,233),(0,35,243),(6,0)), ((0,35,244),(0,35,250),(7,0)),
  ((0,35,251),(0,35,254),(9,0)), ((0,36,0),(0,36,36),(1,1)),
  ((0,36,37),(0,36,38),(3,0)), ((0,36,64),(0,36,74),(1,1)),
  ((0,36,96),(0,36,234),(1,1)), ((0,36,235),(0,36,254),(3,2)),
  ((0,36,255),(0,36,255),(4,0)), ((0,37,0),(0,37,149),(1,1)),
  ((0,37,150),(0,37,159),(3,2)), ((0,37,160),(0,37,239),(1,1)),
  ((0,37,240),(0,37,247),(3,0)), ((0,37,248),(0,37,255),(3,2)),
  ((0,38,0),(0,38,19),(1,1)), ((0,38,20),(0,38,21),(4,0)),
  ((0,38,22),(0,38,23),(3,2)), ((0,38,24),(0,38,24),(4,1)),
  ((0,38,25),(0,38,25),(3,0)), ((0,38,26),(0,38,111),(1,1)),
  ((0,38,112),(0,38,113),(3,0)), ((0,38,114),(0,38,125),(3,2)),
  ((0,38,126),(0,38,127),(4,1)), ((0,38,128),(0,38,137),(3,2)),
  ((0,38,138),(0,38,145),(4,0)), ((0,38,146),(0,38,156),(4,1)),
  ((0,38,157),(0,38,157),(5,1)), ((0,38,158),(0,38,159),(5,2)),
  ((0,38,160),(0,38,161),(4,0)), ((0,38,162),(0,38,177),(4,1)),
  ((0,38,178),(0,38,178),(5,0)), ((0,38,179),(0,38,188),(5,1)),
  ((0,38,189),(0,38,191),(5,2)), ((0,38,192),(0,38,195),(5,1)),
  ((0,38,196),(0,38,205),(5,2)), ((0,38,206),(0,38,206),(6,0)),
  ((0,38,207),(0,38,225),(5,2)), ((0,38,226),(0,38,226),(6,0)),
  ((0,38,227),(0,38,227),(5,2)), ((0,38,228),(0,38,231),(6,0)),
  ((0,38,232),(0,38,255),(5,2)), ((0,39,0),(0,39,0),(7,0)),
  ((0,39,1),(0,39,4),(1,1)), ((0,39,5),(0,39,5),(6,0)),
  ((0,39,6),(0,39,9),(1,1)), ((0,39,10),(0,39,11),(6,0)),
  ((0,39,12),(0,39,39),(1,1)), ((0,39,40),(0,39,40),(6,0)),
  ((0,39,41),(0,39,75),(1,1)), ((0,39,76),(0,39,76),(6,0)),
  ((0,39,77),(0,39,77),(1,1)), ((0,39,78),(0,39,78),(6,0)),
  ((0,39,79),(0,39,82),(1,1)), ((0,39,83),(0,39,85),(6,0)),
  ((0,39,86),(0,39,86),(1,1)), ((0,39,87),(0,39,87),(5,2)),
  ((0,39,88),(0,39,94),(1,1)), ((0,39,95),(0,39,96),(6,0)),
  ((0,39,97),(0,39,103),(1,1)), ((0,39,104),(0,39,117),(3,2)),
  ((0,39,118),(0,39,148),(1,1)), ((0,39,149),(0,39,151),(6,0)),
  ((0,39,152),(0,39,175),(1,1)), ((0,39,176),(0,39,176),(6,0)),
  ((0,39,177),(0,39,190),(1,1)), ((0,39,191),(0,39,191),(6,0)),
  ((0,39,192),(0,39,198),(4,1)), ((0,39,199),(0,39,202),(5,0)),
  ((0,39,203),(0,39,203),(6,1)), ((0,39,204),(0,39,204),(5,1)),
  ((0,39,205),(0,39,205),(6,1)), ((0,39,206),(0,39,207),(6,0)),
  ((0,39,208),(0,39,235),(3,2)), ((0,39,236),(0,39,239),(5,1)),
  ((0,39,240),(0,39,255),(3,2)), ((0,40,0),(0,40,255),(3,0)),
  ((0,41,0),(0,42,255),(3,2)), ((0,43,0),(0,43,13),(4,0)),
  ((0,43,14),(0,43,19),(4,1)), ((0,43,20),(0,43,26),(5,0)),
  ((0,43,27),(0,43,31),(5,1)), ((0,43,32),(0,43,35),(5,0)),
  ((0,43,36),(0,43,76),(5,1)), ((0,43,77),(0,43,79),(7,0)),
  ((0,43,80),(0,43,84),(5,1)), ((0,43,85),(0,43,89),(5,2)),
  ((0,43,90),(0,43,115),(7,0)), ((0,43,118),(0,43,149),(7,0)),
  ((0,43,152),(0,43,185),(7,0)), ((0,43,189),(0,43,200),(7,0)),
  ((0,43,202),(0,43,209),(7,0)), ((0,43,236),(0,43,239),(8,0)),
  ((0,44,0),(0,44,46),(4,1)), ((0,44,48),(0,44,94),(4,1)),
  ((0,44,96),(0,44,108),(5,0)), ((0,44,109),(0,44,111),(5,1)),
  ((0,44,112),(0,44,112),(5,2)), ((0,44,113),(0,44,115),(5,1)),
  ((0,44,116),(0,44,119),(5,0)), ((0,44,120),(0,44,125),(5,1)),
  ((0,44,126),(0,44,127),(5,2)), ((0,44,128),(0,44,234),(4,1)),
  ((0,44,235),(0,44,241),(5,2)), ((0,44,242),(0,44,243),(6,1)),
  ((0,44,249),(0,45,37),(4,1)), ((0,45,39),(0,45,39),(6,1)),
  ((0,45,45),(0,45,45),(6,1)), ((0,45,48),(0,45,101),(4,1)),
  ((0,45,102),(0,45,103),(6,1)), ((0,45,111),(0,45,111),(4,1)),
  ((0,45,112),(0,45,112),(6,0)), ((0,45,127),(0,45,127),(6,0)),
  ((0,45,128),(0,45,150),(4,1)), ((0,45,160),(0,45,166),(4,1)),
  ((0,45,168),(0,45,174),(4,1)), ((0,45,176),(0,45,182),(4,1)),
  ((0,45,184),(0,45,190),(4,1)), ((0,45,192),(0,45,198),(4,1)),
  ((0,45,200),(0,45,206),(4,1)), ((0,45,208),(0,45,214),(4,1)),
  ((0,45,216),(0,45,222),(4,1)), ((0,45,224),(0,45,255),(5,1)),
  ((0,46,0),(0,46,23),(4,1)), ((0,46,24),(0,46,27),(5,1)),
  ((0,46,28),(0,46,29),(4,1)), ((0,46,30),(0,46,48),(5,1)),
  ((0,46,49),(0,46,49),(5,2)), ((0,46,50),(0,46,59),(6,1)),
  ((0,46,60),(0,46,66),(7,0)), ((0,46,67),(0,46,68),(9,0)),
  ((0,46,128),(0,46,153),(3,0)), ((0,46,155),(0,46,243),(3,0)),
  ((0,47,0),(0,47,213),(3,0)), ((0,47,240),(0,47,251),(3,0)),
  ((0,48,0),(0,48,55),(1,1)), ((0,48,56),(0,48,58),(3,0)),
  ((0,48,59),(0,48,61),(3,2)), ((0,48,62),(0,48,62),(3,0)),
  ((0,48,63),(0,48,63),(1,1)), ((0,48,65),(0,48,148),(1,1)),
  ((0,48,149),(0,48,150),(3,2)), ((0,48,153),(0,48,158),(1,1)),
  ((0,48,159),(0,48,160),(3,2)), ((0,48,161),(0,48,254),(1,1)),
  ((0,48,255),(0,48,255),(3,2)), ((0,49,5),(0,49,44),(1,1)),
  ((0,49,45),(0,49,45),(5,1)), ((0,49,49),(0,49,142),(1,1)),
  ((0,49,144),(0,49,159),(1,1)), ((0,49,160),(0,49,183),(3,0)),
  ((0,49,184),(0,49,186),(6,0)), ((0,49,192),(0,49,207),(4,1)),
  ((0,49,208),(0,49,227),(5,1)), ((0,49,240),(0,49,255),(3,2)),
  ((0,50,0),(0,50,28),(1,1)), ((0,50,29),(0,50,30),(4,0)),
  ((0,50,32),(0,50,67),(1,1)), ((0,50,68),(0,50,79),(5,2)),
  ((0,50,80),(0,50,80),(4,0)), ((0,50,81),(0,50,95),(3,2)),
  ((0,50,96),(0,50,123),(1,1)), ((0,50,124),(0,50,125),(4,0)),
  ((0,50,126),(0,50,126),(4,1)), ((0,50,127),(0,50,176),(1,1)),
  ((0,50,177),(0,50,191),(3,2)), ((0,50,192),(0,50,203),(1,1)),
  ((0,50,204),(0,50,207),(4,0)), ((0,50,208),(0,50,254),(1,1)),
  ((0,51,0),(0,51,118),(1,1)), ((0,51,119),(0,51,122),(4,0)),
  ((0,51,123),(0,51,221),(1,1)), ((0,51,222),(0,51,223),(4,0)),
  ((0,51,224),(0,51,254),(1,1)), ((0,51,255),(0,51,255),(4,0)),
  ((0,52,0),(0,77,181),(3,0)), ((0,77,192),(0,77,255),(4,0)),
  ((0,78,0),(0,159,165),(1,1)), ((0,159,166),(0,159,187),(4,1)),
  ((0,159,188),(0,159,195),(5,1)), ((0,159,196),(0,159,203),(5,2)),
  ((0,159,204),(0,159,204),(6,1)), ((0,159,205),(0,159,213),(8,0)),
  ((0,160,0),(0,164,140),(3,0)), ((0,164,144),(0,164,161),(3,0)),
  ((0,164,162),(0,164,163),(3,2)), ((0,164,164),(0,164,179),(3,0)),
  ((0,164,180),(0,164,180),(3,2)), ((0,164,181),(0,164,192),(3,0)),
  ((0,164,193),(0,164,193),(3,2)), ((0,164,194),(0,164,196),(3,0)),
  ((0,164,197),(0,164,197),(3,2)), ((0,164,198),(0,164,198),(3,0)),
  ((0,164,208),(0,164,255),(5,2)), ((0,165,0),(0,166,43),(5,1)),
  ((0,166,64),(0,166,95),(5,1)), ((0,166,96),(0,166,97),(6,0)),
  ((0,166,98),(0,166,115),(5,1)), ((0,166,116),(0,166,123),(6,1)),
  ((0,166,124),(0,166,151),(5,1)), ((0,166,152),(0,166,157),(7,0)),
  ((0,166,158),(0,166,158),(8,0)), ((0,166,159),(0,166,159),(6,1)),
  ((0,166,160),(0,166,247),(5,2)), ((0,167,0),(0,167,22),(4,1)),
  ((0,167,23),(0,167,26),(5,0)), ((0,167,27),(0,167,31),(5,1)),
  ((0,167,32),(0,167,33),(5,0)), ((0,167,34),(0,167,140),(5,1)),
  ((0,167,141),(0,167,142),(6,0)), ((0,167,143),(0,167,143),(8,0)),
  ((0,167,144),(0,167,145),(6,0)), ((0,167,146),(0,167,147),(6,1)),
  ((0,167,148),(0,167,159),(7,0)), ((0,167,160),(0,167,169),(6,0)),
  ((0,167,170),(0,167,170),(6,1)), ((0,167,171),(0,167,173),(7,0)),
  ((0,167,174),(0,167,174),(9,0)), ((0,167,176),(0,167,177),(7,0)),
  ((0,167,178),(0,167,183),(8,0)), ((0,167,247),(0,167,247),(7,0)),
  ((0,167,248),(0,167,249),(6,1)), ((0,167,250),(0,167,250),(6,0)),
  ((0,167,251),(0,167,255),(5,1)), ((0,168,0),(0,168,43),(4,1)),
  ((0,168,48),(0,168,57),(5,2)), ((0,168,64),(0,168,119),(5,0)),
  ((0,168,128),(0,168,196),(5,1)), ((0,168,197),(0,168,197),(9,0)),
  ((0,168,206),(0,168,217),(5,1)), ((0,168,224),(0,168,251),(5,2)),
  ((0,168,252),(0,168,253),(8,0)), ((0,169,0),(0,169,83),(5,1)),
  ((0,169,95),(0,169,95),(5,1)), ((0,169,96),(0,169,124),(5,2)),
  ((0,169,128),(0,169,205),(5,2)), ((0,169,207),(0,169,217),(5,2)),
  ((0,169,222),(0,169,223),(5,2)), ((0,169,224),(0,169,254),(7,0)),
  ((0,170,0),(0,170,54),(5,1)), ((0,170,64),(0,170,77),(5,1)),
  ((0,170,80),(0,170,89),(5,1)), ((0,170,92),(0,170,95),(5,1)),
  ((0,170,96),(0,170,123),(5,2)), ((0,170,124),(0,170,127),(7,0)),
  ((0,170,128),(0,170,194),(5,2)), ((0,170,219),(0,170,223),(5,2)),
  ((0,170,224),(0,170,246),(6,1)), ((0,171,1),(0,171,6),(6,0)),
  ((0,171,9),(0,171,14),(6,0)), ((0,171,17),(0,171,22),(6,0)),
  ((0,171,32),(0,171,38),(6,0)), ((0,171,40),(0,171,46),(6,0)),
  ((0,171,48),(0,171,95),(7,0)), ((0,171,96),(0,171,99),(8,0)),
  ((0,171,100),(0,171,101),(7,0)), ((0,171,112),(0,171,191),(8,0)),
  ((0,171,192),(0,171,237),(5,2)), ((0,171,240),(0,171,249),(5,2)),
  ((0,172,0),(0,215,163),(2,0)), ((0,215,176),(0,215,198),(5,2)),
  ((0,215,203),(0,215,251),(5,2)), ((0,216,0),(0,223,255),(2,0)),
  ((0,224,0),(0,250,45),(1,1)), ((0,250,46),(0,250,47),(6,1)),
  ((0,250,48),(0,250,106),(3,2)), ((0,250,107),(0,250,109),(5,2)),
  ((0,250,112),(0,250,217),(4,1)), ((0,251,0),(0,251,6),(1,1)),
  ((0,251,19),(0,251,23),(1,1)), ((0,251,29),(0,251,29),(3,0)),
  ((0,251,30),(0,251,54),(1,1)), ((0,251,56),(0,251,60),(1,1)),
  ((0,251,62),(0,251,62),(1,1)), ((0,251,64),(0,251,65),(1,1)),
  ((0,251,67),(0,251,68),(1,1)), ((0,251,70),(0,251,177),(1,1)),
  ((0,251,178),(0,251,193),(6,0)), ((0,251,211),(0,253,63),(1,1)),
  ((0,253,80),(0,253,143),(1,1)), ((0,253,146),(0,253,199),(1,1)),
  ((0,253,208),(0,253,239),(3,1)), ((0,253,240),(0,253,251),(1,1)),
  ((0,253,252),(0,253,252),(3,2)), ((0,253,253),(0,253,253),(4,0)),
  ((0,254,0),(0,254,15),(3,2)), ((0,254,16),(0,254,25),(4,1)),
  ((0,254,32),(0,254,35),(1,1)), ((0,254,36),(0,254,38),(5,1)),
  ((0,254,39),(0,254,45),(7,0)), ((0,254,46),(0,254,47),(8,0)),
  ((0,254,48),(0,254,68),(1,1)), ((0,254,69),(0,254,70),(3,2)),
  ((0,254,71),(0,254,72),(4,0)), ((0,254,73),(0,254,82),(1,1)),
  ((0,254,84),(0,254,102),(1,1)), ((0,254,104),(0,254,107),(1,1)),
  ((0,254,112),(0,254,114),(1,1)), ((0,254,115),(0,254,115),(3,2)),
  ((0,254,116),(0,254,116),(1,1)), ((0,254,118),(0,254,252),(1,1)),
  ((0,254,255),(0,254,255),(1,1)), ((0,255,1),(0,255,94),(1,1)),
  ((0,255,95),(0,255,96),(3,2)), ((0,255,97),(0,255,190),(1,1)),
  ((0,255,194),(0,255,199),(1,1)), ((0,255,202),(0,255,207),(1,1)),
  ((0,255,210),(0,255,215),(1,1)), ((0,255,218),(0,255,220),(1,1)),
  ((0,255,224),(0,255,230),(1,1)), ((0,255,232),(0,255,238),(1,1)),
  ((0,255,249),(0,255,251),(3,0)), ((0,255,252),(0,255,252),(2,1)),
  ((0,255,253),(0,255,255),(1,1)), ((1,0,0),(1,0,11),(4,0)),
  ((1,0,13),(1,0,38),(4,0)), ((1,0,40),(1,0,58),(4,0)),
  ((1,0,60),(1,0,61),(4,0)), ((1,0,63),(1,0,77),(4,0)),
  ((1,0,80),(1,0,93),(4,0)), ((1,0,128),(1,0,250),(4,0)),
  ((1,1,0),(1,1,2),(4,0)), ((1,1,7),(1,1,51),(4,0)), ((1,1,55),(1,1,63),(4,0)),
  ((1,1,64),(1,1,138),(4,1)), ((1,1,139),(1,1,140),(7,0)),
  ((1,1,141),(1,1,142),(9,0)), ((1,1,144),(1,1,155),(5,1)),
  ((1,1,160),(1,1,160),(7,0)), ((1,1,208),(1,1,253),(5,1)),
  ((1,2,128),(1,2,156),(5,1)), ((1,2,160),(1,2,208),(5,1)),
  ((1,2,224),(1,2,251),(7,0)), ((1,3,0),(1,3,30),(3,1)),
  ((1,3,31),(1,3,31),(7,0)), ((1,3,32),(1,3,35),(3,1)),
  ((1,3,48),(1,3,74),(3,1)), ((1,3,80),(1,3,122),(7,0)),
  ((1,3,128),(1,3,157),(4,0)), ((1,3,159),(1,3,159),(4,0)),
  ((1,3,160),(1,3,195),(4,1)), ((1,3,200),(1,3,213),(4,1)),
  ((1,4,0),(1,4,37),(3,1)), ((1,4,38),(1,4,39),(4,0)),
  ((1,4,40),(1,4,77),(3,1)), ((1,4,78),(1,4,157),(4,0)),
  ((1,4,160),(1,4,169),(4,0)), ((1,4,176),(1,4,211),(9,0)),
  ((1,4,216),(1,4,251),(9,0)), ((1,5,0),(1,5,39),(7,0)),
  ((1,5,48),(1,5,99),(7,0)), ((1,5,111),(1,5,111),(7,0)),
  ((1,6,0),(1,7,54),(7,0)), ((1,7,64),(1,7,85),(7,0)),
  ((1,7,96),(1,7,103),(7,0)), ((1,8,0),(1,8,5),(4,0)), ((1,8,8),(1,8,8),(4,0)),
  ((1,8,10),(1,8,53),(4,0)), ((1,8,55),(1,8,56),(4,0)),
  ((1,8,60),(1,8,60),(4,0)), ((1,8,63),(1,8,63),(4,0)),
  ((1,8,64),(1,8,85),(5,2)), ((1,8,87),(1,8,95),(5,2)),
  ((1,8,96),(1,8,158),(7,0)), ((1,8,167),(1,8,175),(7,0)),
  ((1,8,224),(1,8,242),(8,0)), ((1,8,244),(1,8,245),(8,0)),
  ((1,8,251),(1,8,255),(8,0)), ((1,9,0),(1,9,25),(5,0)),
  ((1,9,26),(1,9,27),(5,2)), ((1,9,31),(1,9,31),(5,0)),
  ((1,9,32),(1,9,57),(5,1)), ((1,9,63),(1,9,63),(5,1)),
  ((1,9,128),(1,9,183),(6,1)), ((1,9,188),(1,9,189),(8,0)),
  ((1,9,190),(1,9,191),(6,1)), ((1,9,192),(1,9,207),(8,0)),
  ((1,9,210),(1,9,255),(8,0)), ((1,10,0),(1,10,3),(4,1)),
  ((1,10,5),(1,10,6),(4,1)), ((1,10,12),(1,10,19),(4,1)),
  ((1,10,21),(1,10,23),(4,1)), ((1,10,25),(1,10,51),(4,1)),
  ((1,10,56),(1,10,58),(4,1)), ((1,10,63),(1,10,71),(4,1)),
  ((1,10,80),(1,10,88),(4,1)), ((1,10,96),(1,10,127),(5,2)),
  ((1,10,128),(1,10,159),(7,0)), ((1,10,192),(1,10,230),(7,0)),
  ((1,10,235),(1,10,246),(7,0)), ((1,11,0),(1,11,53),(5,2)),
  ((1,11,57),(1,11,85),(5,2)), ((1,11,88),(1,11,114),(5,2)),
  ((1,11,120),(1,11,127),(5,2)), ((1,11,128),(1,11,145),(7,0)),
  ((1,11,153),(1,11,156),(7,0)), ((1,11,169),(1,11,175),(7,0)),
  ((1,12,0),(1,12,72),(5,2)), ((1,12,128),(1,12,178),(8,0)),
  ((1,12,192),(1,12,242),(8,0)), ((1,12,250),(1,12,255),(8,0)),
  ((1,14,96),(1,14,126),(5,2)), ((1,16,0),(1,16,77),(6,0)),
  ((1,16,82),(1,16,111),(6,0)), ((1,16,127),(1,16,127),(7,0)),
  ((1,16,128),(1,16,193),(5,2)), ((1,16,208),(1,16,232),(6,1)),
  ((1,16,240),(1,16,249),(6,1)), ((1,17,0),(1,17,52),(6,1)),
  ((1,17,54),(1,17,67),(6,1)), ((1,17,80),(1,17,118),(7,0)),
  ((1,17,128),(1,17,200),(6,1)), ((1,17,201),(1,17,204),(8,0)),
  ((1,17,205),(1,17,205),(7,0)), ((1,17,208),(1,17,217),(6,1)),
  ((1,17,218),(1,17,218),(7,0)), ((1,17,219),(1,17,223),(8,0)),
  ((1,17,225),(1,17,244),(7,0)), ((1,18,0),(1,18,17),(7,0)),
  ((1,18,19),(1,18,61),(7,0)), ((1,18,62),(1,18,62),(9,0)),
  ((1,18,128),(1,18,134),(8,0)), ((1,18,136),(1,18,136),(8,0)),
  ((1,18,138),(1,18,141),(8,0)), ((1,18,143),(1,18,157),(8,0)),
  ((1,18,159),(1,18,169),(8,0)), ((1,18,176),(1,18,234),(7,0)),
  ((1,18,240),(1,18,249),(7,0)), ((1,19,0),(1,19,0),(8,0)),
  ((1,19,1),(1,19,3),(7,0)), ((1,19,5),(1,19,12),(7,0)),
  ((1,19,15),(1,19,16),(7,0)), ((1,19,19),(1,19,40),(7,0)),
  ((1,19,42),(1,19,48),(7,0)), ((1,19,50),(1,19,51),(7,0)),
  ((1,19,53),(1,19,57),(7,0)), ((1,19,60),(1,19,68),(7,0)),
  ((1,19,71),(1,19,72),(7,0)), ((1,19,75),(1,19,77),(7,0)),
  ((1,19,80),(1,19,80),(8,0)), ((1,19,87),(1,19,87),(7,0)),
  ((1,19,93),(1,19,99),(7,0)), ((1,19,102),(1,19,108),(7,0)),
  ((1,19,112),(1,19,116),(7,0)), ((1,20,0),(1,20,89),(9,0)),
  ((1,20,91),(1,20,91),(9,0)), ((1,20,93),(1,20,93),(9,0)),
  ((1,20,128),(1,20,199),(7,0)), ((1,20,208),(1,20,217),(7,0)),
  ((1,21,128),(1,21,181),(7,0)), ((1,21,184),(1,21,201),(7,0)),
  ((1,21,202),(1,21,221),(8,0)), ((1,22,0),(1,22,68),(7,0)),
  ((1,22,80),(1,22,89),(7,0)), ((1,22,96),(1,22,108),(9,0)),
  ((1,22,128),(1,22,183),(6,1)), ((1,22,192),(1,22,201),(6,1)),
  ((1,23,0),(1,23,25),(8,0)), ((1,23,29),(1,23,43),(8,0)),
  ((1,23,48),(1,23,63),(8,0)), ((1,24,160),(1,24,242),(7,0)),
  ((1,24,255),(1,24,255),(7,0)), ((1,26,192),(1,26,248),(7,0)),
  ((1,28,0),(1,28,8),(9,0)), ((1,28,10),(1,28,54),(9,0)),
  ((1,28,56),(1,28,69),(9,0)), ((1,28,80),(1,28,108),(9,0)),
  ((1,28,112),(1,28,143),(9,0)), ((1,28,146),(1,28,167),(9,0)),
  ((1,28,169),(1,28,182),(9,0)), ((1,32,0),(1,35,110),(5,0)),
  ((1,35,111),(1,35,152),(7,0)), ((1,35,153),(1,35,153),(8,0)),
  ((1,36,0),(1,36,98),(5,0)), ((1,36,99),(1,36,110),(7,0)),
  ((1,36,112),(1,36,115),(5,0)), ((1,36,116),(1,36,116),(7,0)),
  ((1,36,128),(1,37,67),(8,0)), ((1,48,0),(1,52,46),(5,2)),
  ((1,68,0),(1,70,70),(8,0)), ((1,104,0),(1,106,56),(6,0)),
  ((1,106,64),(1,106,94),(7,0)), ((1,106,96),(1,106,105),(7,0)),
  ((1,106,110),(1,106,111),(7,0)), ((1,106,208),(1,106,237),(7,0)),
  ((1,106,240),(1,106,245),(7,0)), ((1,107,0),(1,107,69),(7,0)),
  ((1,107,80),(1,107,89),(7,0)), ((1,107,91),(1,107,97),(7,0)),
  ((1,107,99),(1,107,119),(7,0)), ((1,107,125),(1,107,143),(7,0)),
  ((1,111,0),(1,111,68),(6,1)), ((1,111,80),(1,111,126),(6,1)),
  ((1,111,143),(1,111,159),(6,1)), ((1,111,224),(1,111,224),(9,0)),
  ((1,112,0),(1,135,236),(9,0)), ((1,136,0),(1,138,242),(9,0)),
  ((1,176,0),(1,176,1),(6,0)), ((1,188,0),(1,188,106),(7,0)),
  ((1,188,112),(1,188,124),(7,0)), ((1,188,128),(1,188,136),(7,0)),
  ((1,188,144),(1,188,153),(7,0)), ((1,188,156),(1,188,163),(7,0)),
  ((1,208,0),(1,208,245),(3,1)), ((1,209,0),(1,209,38),(3,1)),
  ((1,209,41),(1,209,41),(5,1)), ((1,209,42),(1,209,221),(3,1)),
  ((1,209,222),(1,209,232),(8,0)), ((1,210,0),(1,210,69),(4,1)),
  ((1,211,0),(1,211,86),(4,0)), ((1,211,96),(1,211,113),(5,0)),
  ((1,212,0),(1,212,84),(3,1)), ((1,212,86),(1,212,156),(3,1)),
  ((1,212,158),(1,212,159),(3,1)), ((1,212,162),(1,212,162),(3,1)),
  ((1,212,165),(1,212,166),(3,1)), ((1,212,169),(1,212,172),(3,1)),
  ((1,212,174),(1,212,185),(3,1)), ((1,212,187),(1,212,187),(3,1)),
  ((1,212,189),(1,212,192),(3,1)), ((1,212,193),(1,212,193),(4,0)),
  ((1,212,194),(1,212,195),(3,1)), ((1,212,197),(1,213,5),(3,1)),
  ((1,213,7),(1,213,10),(3,1)), ((1,213,13),(1,213,20),(3,1)),
  ((1,213,22),(1,213,28),(3,1)), ((1,213,30),(1,213,57),(3,1)),
  ((1,213,59),(1,213,62),(3,1)), ((1,213,64),(1,213,68),(3,1)),
  ((1,213,70),(1,213,70),(3,1)), ((1,213,74),(1,213,80),(3,1)),
  ((1,213,82),(1,214,163),(3,1)), ((1,214,164),(1,214,165),(4,1)),
  ((1,214,168),(1,215,201),(3,1)), ((1,215,202),(1,215,203),(5,0)),
  ((1,215,206),(1,215,255),(3,1)), ((1,216,0),(1,218,139),(8,0)),
  ((1,218,155),(1,218,159),(8,0)), ((1,218,161),(1,218,175),(8,0)),
  ((1,224,0),(1,224,6),(9,0)), ((1,224,8),(1,224,24),(9,0)),
  ((1,224,27),(1,224,33),(9,0)), ((1,224,35),(1,224,36),(9,0)),
  ((1,224,38),(1,224,42),(9,0)), ((1,232,0),(1,232,196),(7,0)),
  ((1,232,199),(1,232,214),(7,0)), ((1,233,0),(1,233,74),(9,0)),
  ((1,233,80),(1,233,89),(9,0)), ((1,233,94),(1,233,95),(9,0)),
  ((1,238,0),(1,238,3),(6,1)), ((1,238,5),(1,238,31),(6,1)),
  ((1,238,33),(1,238,34),(6,1)), ((1,238,36),(1,238,36),(6,1)),
  ((1,238,39),(1,238,39),(6,1)), ((1,238,41),(1,238,50),(6,1)),
  ((1,238,52),(1,238,55),(6,1)), ((1,238,57),(1,238,57),(6,1)),
  ((1,238,59),(1,238,59),(6,1)), ((1,238,66),(1,238,66),(6,1)),
  ((1,238,71),(1,238,71),(6,1)), ((1,238,73),(1,238,73),(6,1)),
  ((1,238,75),(1,238,75),(6,1)), ((1,238,77),(1,238,79),(6,1)),
  ((1,238,81),(1,238,82),(6,1)), ((1,238,84),(1,238,84),(6,1)),
  ((1,238,87),(1,238,87),(6,1)), ((1,238,89),(1,238,89),(6,1)),
  ((1,238,91),(1,238,91),(6,1)), ((1,238,93),(1,238,93),(6,1)),
  ((1,238,95),(1,238,95),(6,1)), ((1,238,97),(1,238,98),(6,1)),
  ((1,238,100),(1,238,100),(6,1)), ((1,238,103),(1,238,106),(6,1)),
  ((1,238,108),(1,238,114),(6,1)), ((1,238,116),(1,238,119),(6,1)),
  ((1,238,121),(1,238,124),(6,1)), ((1,238,126),(1,238,126),(6,1)),
  ((1,238,128),(1,238,137),(6,1)), ((1,238,139),(1,238,155),(6,1)),
  ((1,238,161),(1,238,163),(6,1)), ((1,238,165),(1,238,169),(6,1)),
  ((1,238,171),(1,238,187),(6,1)), ((1,238,240),(1,238,241),(6,1)),
  ((1,240,0),(1,240,43),(5,1)), ((1,240,48),(1,240,147),(5,1)),
  ((1,240,160),(1,240,174),(6,0)), ((1,240,177),(1,240,190),(6,0)),
  ((1,240,191),(1,240,191),(7,0)), ((1,240,193),(1,240,207),(6,0)),
  ((1,240,209),(1,240,223),(6,0)), ((1,240,224),(1,240,245),(7,0)),
  ((1,241,0),(1,241,10),(5,2)), ((1,241,11),(1,241,12),(7,0)),
  ((1,241,16),(1,241,46),(5,2)), ((1,241,48),(1,241,48),(6,0)),
  ((1,241,49),(1,241,49),(5,2)), ((1,241,50),(1,241,60),(6,0)),
  ((1,241,61),(1,241,61),(5,2)), ((1,241,62),(1,241,62),(6,0)),
  ((1,241,63),(1,241,63),(5,2)), ((1,241,64),(1,241,65),(6,0)),
  ((1,241,66),(1,241,66),(5,2)), ((1,241,67),(1,241,69),(6,0)),
  ((1,241,70),(1,241,70),(5,2)), ((1,241,71),(1,241,73),(6,0)),
  ((1,241,74),(1,241,78),(5,2)), ((1,241,79),(1,241,86),(6,0)),
  ((1,241,87),(1,241,87),(5,2)), ((1,241,88),(1,241,94),(6,0)),
  ((1,241,95),(1,241,95),(5,2)), ((1,241,96),(1,241,105),(6,0)),
  ((1,241,106),(1,241,107),(6,1)), ((1,241,112),(1,241,120),(6,0)),
  ((1,241,121),(1,241,121),(5,2)), ((1,241,122),(1,241,122),(6,0)),
  ((1,241,123),(1,241,124),(5,2)), ((1,241,125),(1,241,126),(6,0)),
  ((1,241,127),(1,241,127),(5,2)), ((1,241,128),(1,241,137),(6,0)),
  ((1,241,138),(1,241,141),(5,2)), ((1,241,142),(1,241,143),(6,0)),
  ((1,241,144),(1,241,144),(5,2)), ((1,241,145),(1,241,154),(6,0)),
  ((1,241,155),(1,241,172),(9,0)), ((1,241,230),(1,241,255),(6,0)),
  ((1,242,0),(1,242,0),(5,2)), ((1,242,1),(1,242,2),(6,0)),
  ((1,242,16),(1,242,49),(5,2)), ((1,242,50),(1,242,58),(6,0)),
  ((1,242,59),(1,242,59),(9,0)), ((1,242,64),(1,242,72),(5,2)),
  ((1,242,80),(1,242,81),(6,0)), ((1,243,0),(1,243,32),(6,0)),
  ((1,243,33),(1,243,44),(7,0)), ((1,243,45),(1,243,47),(8,0)),
  ((1,243,48),(1,243,53),(6,0)), ((1,243,54),(1,243,54),(7,0)),
  ((1,243,55),(1,243,124),(6,0)), ((1,243,125),(1,243,125),(7,0)),
  ((1,243,126),(1,243,127),(8,0)), ((1,243,128),(1,243,147),(6,0)),
  ((1,243,148),(1,243,159),(7,0)), ((1,243,160),(1,243,196),(6,0)),
  ((1,243,197),(1,243,197),(7,0)), ((1,243,198),(1,243,202),(6,0)),
  ((1,243,203),(1,243,206),(7,0)), ((1,243,207),(1,243,211),(8,0)),
  ((1,243,212),(1,243,223),(7,0)), ((1,243,224),(1,243,240),(6,0)),
  ((1,243,241),(1,243,247),(7,0)), ((1,243,248),(1,243,255),(8,0)),
  ((1,244,0),(1,244,62),(6,0)), ((1,244,63),(1,244,63),(7,0)),
  ((1,244,64),(1,244,64),(6,0)), ((1,244,65),(1,244,65),(7,0)),
  ((1,244,66),(1,244,247),(6,0)), ((1,244,248),(1,244,248),(7,0)),
  ((1,244,249),(1,244,252),(6,0)), ((1,244,253),(1,244,254),(7,0)),
  ((1,244,255),(1,244,255),(8,0)), ((1,245,0),(1,245,61),(6,0)),
  ((1,245,62),(1,245,63),(7,0)), ((1,245,64),(1,245,67),(6,1)),
  ((1,245,68),(1,245,74),(7,0)), ((1,245,75),(1,245,79),(8,0)),
  ((1,245,80),(1,245,103),(6,0)), ((1,245,104),(1,245,121),(7,0)),
  ((1,245,122),(1,245,122),(9,0)), ((1,245,123),(1,245,163),(7,0)),
  ((1,245,164),(1,245,164),(9,0)), ((1,245,165),(1,245,250),(7,0)),
  ((1,245,251),(1,245,255),(6,0)), ((1,246,0),(1,246,0),(6,1)),
  ((1,246,1),(1,246,16),(6,0)), ((1,246,17),(1,246,17),(6,1)),
  ((1,246,18),(1,246,20),(6,0)), ((1,246,21),(1,246,21),(6,1)),
  ((1,246,22),(1,246,22),(6,0)), ((1,246,23),(1,246,23),(6,1)),
  ((1,246,24),(1,246,24),(6,0)), ((1,246,25),(1,246,25),(6,1)),
  ((1,246,26),(1,246,26),(6,0)), ((1,246,27),(1,246,27),(6,1)),
  ((1,246,28),(1,246,30),(6,0)), ((1,246,31),(1,246,31),(6,1)),
  ((1,246,32),(1,246,37),(6,0)), ((1,246,38),(1,246,39),(6,1)),
  ((1,246,40),(1,246,43),(6,0)), ((1,246,44),(1,246,44),(6,1)),
  ((1,246,45),(1,246,45),(6,0)), ((1,246,46),(1,246,47),(6,1)),
  ((1,246,48),(1,246,51),(6,0)), ((1,246,52),(1,246,52),(6,1)),
  ((1,246,53),(1,246,64),(6,0)), ((1,246,65),(1,246,66),(7,0)),
  ((1,246,67),(1,246,68),(8,0)), ((1,246,69),(1,246,79),(6,0)),
  ((1,246,80),(1,246,127),(7,0)), ((1,246,128),(1,246,197),(6,0)),
  ((1,246,198),(1,246,207),(7,0)), ((1,246,208),(1,246,208),(8,0)),
  ((1,246,209),(1,246,210),(9,0)), ((1,246,224),(1,246,236),(7,0)),
  ((1,246,240),(1,246,243),(7,0)), ((1,246,244),(1,246,246),(9,0)),
  ((1,247,0),(1,247,115),(6,0)), ((1,247,128),(1,247,212),(7,0)),
  ((1,248,0),(1,248,11),(7,0)), ((1,248,16),(1,248,71),(7,0)),
  ((1,248,80),(1,248,89),(7,0)), ((1,248,96),(1,248,135),(7,0)),
  ((1,248,144),(1,248,173),(7,0)), ((1,249,16),(1,249,24),(8,0)),
  ((1,249,25),(1,249,30),(9,0)), ((1,249,32),(1,249,39),(9,0)),
  ((1,249,48),(1,249,48),(9,0)), ((1,249,51),(1,249,62),(9,0)),
  ((1,249,64),(1,249,75),(9,0)), ((1,249,80),(1,249,94),(9,0)),
  ((1,249,128),(1,249,132),(8,0)), ((1,249,133),(1,249,145),(9,0)),
  ((1,249,192),(1,249,192),(8,0)), ((1,255,254),(1,255,255),(2,0)),
  ((2,0,0),(2,166,214),(3,1)), ((2,167,0),(2,183,52),(5,2)),
  ((2,183,64),(2,184,29),(6,0)), ((2,184,32),(2,206,161),(8,0)),
  ((2,248,0),(2,250,29),(3,1)), ((2,255,254),(2,255,255),(2,0)),
  ((3,255,254),(3,255,255),(2,0)), ((4,255,254),(4,255,255),(2,0)),
  ((5,255,254),(5,255,255),(2,0)), ((6,255,254),(6,255,255),(2,0)),
  ((7,255,254),(7,255,255),(2,0)), ((8,255,254),(8,255,255),(2,0)),
  ((9,255,254),(9,255,255),(2,0)), ((10,255,254),(10,255,255),(2,0)),
  ((11,255,254),(11,255,255),(2,0)), ((12,255,254),(12,255,255),(2,0)),
  ((13,255,254),(13,255,255),(2,0)), ((14,0,1),(14,0,1),(3,1)),
  ((14,0,32),(14,0,127),(3,1)), ((14,1,0),(14,1,239),(4,0)),
  ((14,255,254),(16,255,255),(2,0))
];

#[derive(Clone,Copy,Eq,PartialEq,Debug)]
pub enum UnicodeCategory {
  UppercaseLetter, LowercaseLetter, TitlecaseLetter, ModifierLetter,
  OtherLetter, NonspacingMark, SpacingMark, EnclosingMark, DecimalNumber,
  LetterNumber, OtherNumber, ConnectorPunctuation, DashPunctuation,
  OpenPunctuation, ClosePunctuation, InitialPunctuation, FinalPunctuation,
  OtherPunctuation, MathSymbol, CurrencySymbol, ModifierSymbol, OtherSymbol,
  SpaceSeparator, LineSeparator, ParagraphSeparator, Control, Format, Surrogate,
  PrivateUse, Unassigned
}

pub static UCD_CAT: &'static [((u8,u8,u8), (u8,u8,u8), UnicodeCategory)] = &[
  ((0,0,0),(0,0,31),UnicodeCategory::Control),
  ((0,0,32),(0,0,32),UnicodeCategory::SpaceSeparator),
  ((0,0,33),(0,0,35),UnicodeCategory::OtherPunctuation),
  ((0,0,36),(0,0,36),UnicodeCategory::CurrencySymbol),
  ((0,0,37),(0,0,39),UnicodeCategory::OtherPunctuation),
  ((0,0,40),(0,0,40),UnicodeCategory::OpenPunctuation),
  ((0,0,41),(0,0,41),UnicodeCategory::ClosePunctuation),
  ((0,0,42),(0,0,42),UnicodeCategory::OtherPunctuation),
  ((0,0,43),(0,0,43),UnicodeCategory::MathSymbol),
  ((0,0,44),(0,0,44),UnicodeCategory::OtherPunctuation),
  ((0,0,45),(0,0,45),UnicodeCategory::DashPunctuation),
  ((0,0,46),(0,0,47),UnicodeCategory::OtherPunctuation),
  ((0,0,48),(0,0,57),UnicodeCategory::DecimalNumber),
  ((0,0,58),(0,0,59),UnicodeCategory::OtherPunctuation),
  ((0,0,60),(0,0,62),UnicodeCategory::MathSymbol),
  ((0,0,63),(0,0,64),UnicodeCategory::OtherPunctuation),
  ((0,0,65),(0,0,90),UnicodeCategory::UppercaseLetter),
  ((0,0,91),(0,0,91),UnicodeCategory::OpenPunctuation),
  ((0,0,92),(0,0,92),UnicodeCategory::OtherPunctuation),
  ((0,0,93),(0,0,93),UnicodeCategory::ClosePunctuation),
  ((0,0,94),(0,0,94),UnicodeCategory::ModifierSymbol),
  ((0,0,95),(0,0,95),UnicodeCategory::ConnectorPunctuation),
  ((0,0,96),(0,0,96),UnicodeCategory::ModifierSymbol),
  ((0,0,97),(0,0,122),UnicodeCategory::LowercaseLetter),
  ((0,0,123),(0,0,123),UnicodeCategory::OpenPunctuation),
  ((0,0,124),(0,0,124),UnicodeCategory::MathSymbol),
  ((0,0,125),(0,0,125),UnicodeCategory::ClosePunctuation),
  ((0,0,126),(0,0,126),UnicodeCategory::MathSymbol),
  ((0,0,127),(0,0,159),UnicodeCategory::Control),
  ((0,0,160),(0,0,160),UnicodeCategory::SpaceSeparator),
  ((0,0,161),(0,0,161),UnicodeCategory::OtherPunctuation),
  ((0,0,162),(0,0,165),UnicodeCategory::CurrencySymbol),
  ((0,0,166),(0,0,166),UnicodeCategory::OtherSymbol),
  ((0,0,167),(0,0,167),UnicodeCategory::OtherPunctuation),
  ((0,0,168),(0,0,168),UnicodeCategory::ModifierSymbol),
  ((0,0,169),(0,0,169),UnicodeCategory::OtherSymbol),
  ((0,0,170),(0,0,170),UnicodeCategory::OtherLetter),
  ((0,0,171),(0,0,171),UnicodeCategory::InitialPunctuation),
  ((0,0,172),(0,0,172),UnicodeCategory::MathSymbol),
  ((0,0,173),(0,0,173),UnicodeCategory::Format),
  ((0,0,174),(0,0,174),UnicodeCategory::OtherSymbol),
  ((0,0,175),(0,0,175),UnicodeCategory::ModifierSymbol),
  ((0,0,176),(0,0,176),UnicodeCategory::OtherSymbol),
  ((0,0,177),(0,0,177),UnicodeCategory::MathSymbol),
  ((0,0,178),(0,0,179),UnicodeCategory::OtherNumber),
  ((0,0,180),(0,0,180),UnicodeCategory::ModifierSymbol),
  ((0,0,181),(0,0,181),UnicodeCategory::LowercaseLetter),
  ((0,0,182),(0,0,183),UnicodeCategory::OtherPunctuation),
  ((0,0,184),(0,0,184),UnicodeCategory::ModifierSymbol),
  ((0,0,185),(0,0,185),UnicodeCategory::OtherNumber),
  ((0,0,186),(0,0,186),UnicodeCategory::OtherLetter),
  ((0,0,187),(0,0,187),UnicodeCategory::FinalPunctuation),
  ((0,0,188),(0,0,190),UnicodeCategory::OtherNumber),
  ((0,0,191),(0,0,191),UnicodeCategory::OtherPunctuation),
  ((0,0,192),(0,0,214),UnicodeCategory::UppercaseLetter),
  ((0,0,215),(0,0,215),UnicodeCategory::MathSymbol),
  ((0,0,216),(0,0,222),UnicodeCategory::UppercaseLetter),
  ((0,0,223),(0,0,246),UnicodeCategory::LowercaseLetter),
  ((0,0,247),(0,0,247),UnicodeCategory::MathSymbol),
  ((0,0,248),(0,0,255),UnicodeCategory::LowercaseLetter),
  ((0,1,0),(0,1,0),UnicodeCategory::UppercaseLetter),
  ((0,1,1),(0,1,1),UnicodeCategory::LowercaseLetter),
  ((0,1,2),(0,1,2),UnicodeCategory::UppercaseLetter),
  ((0,1,3),(0,1,3),UnicodeCategory::LowercaseLetter),
  ((0,1,4),(0,1,4),UnicodeCategory::UppercaseLetter),
  ((0,1,5),(0,1,5),UnicodeCategory::LowercaseLetter),
  ((0,1,6),(0,1,6),UnicodeCategory::UppercaseLetter),
  ((0,1,7),(0,1,7),UnicodeCategory::LowercaseLetter),
  ((0,1,8),(0,1,8),UnicodeCategory::UppercaseLetter),
  ((0,1,9),(0,1,9),UnicodeCategory::LowercaseLetter),
  ((0,1,10),(0,1,10),UnicodeCategory::UppercaseLetter),
  ((0,1,11),(0,1,11),UnicodeCategory::LowercaseLetter),
  ((0,1,12),(0,1,12),UnicodeCategory::UppercaseLetter),
  ((0,1,13),(0,1,13),UnicodeCategory::LowercaseLetter),
  ((0,1,14),(0,1,14),UnicodeCategory::UppercaseLetter),
  ((0,1,15),(0,1,15),UnicodeCategory::LowercaseLetter),
  ((0,1,16),(0,1,16),UnicodeCategory::UppercaseLetter),
  ((0,1,17),(0,1,17),UnicodeCategory::LowercaseLetter),
  ((0,1,18),(0,1,18),UnicodeCategory::UppercaseLetter),
  ((0,1,19),(0,1,19),UnicodeCategory::LowercaseLetter),
  ((0,1,20),(0,1,20),UnicodeCategory::UppercaseLetter),
  ((0,1,21),(0,1,21),UnicodeCategory::LowercaseLetter),
  ((0,1,22),(0,1,22),UnicodeCategory::UppercaseLetter),
  ((0,1,23),(0,1,23),UnicodeCategory::LowercaseLetter),
  ((0,1,24),(0,1,24),UnicodeCategory::UppercaseLetter),
  ((0,1,25),(0,1,25),UnicodeCategory::LowercaseLetter),
  ((0,1,26),(0,1,26),UnicodeCategory::UppercaseLetter),
  ((0,1,27),(0,1,27),UnicodeCategory::LowercaseLetter),
  ((0,1,28),(0,1,28),UnicodeCategory::UppercaseLetter),
  ((0,1,29),(0,1,29),UnicodeCategory::LowercaseLetter),
  ((0,1,30),(0,1,30),UnicodeCategory::UppercaseLetter),
  ((0,1,31),(0,1,31),UnicodeCategory::LowercaseLetter),
  ((0,1,32),(0,1,32),UnicodeCategory::UppercaseLetter),
  ((0,1,33),(0,1,33),UnicodeCategory::LowercaseLetter),
  ((0,1,34),(0,1,34),UnicodeCategory::UppercaseLetter),
  ((0,1,35),(0,1,35),UnicodeCategory::LowercaseLetter),
  ((0,1,36),(0,1,36),UnicodeCategory::UppercaseLetter),
  ((0,1,37),(0,1,37),UnicodeCategory::LowercaseLetter),
  ((0,1,38),(0,1,38),UnicodeCategory::UppercaseLetter),
  ((0,1,39),(0,1,39),UnicodeCategory::LowercaseLetter),
  ((0,1,40),(0,1,40),UnicodeCategory::UppercaseLetter),
  ((0,1,41),(0,1,41),UnicodeCategory::LowercaseLetter),
  ((0,1,42),(0,1,42),UnicodeCategory::UppercaseLetter),
  ((0,1,43),(0,1,43),UnicodeCategory::LowercaseLetter),
  ((0,1,44),(0,1,44),UnicodeCategory::UppercaseLetter),
  ((0,1,45),(0,1,45),UnicodeCategory::LowercaseLetter),
  ((0,1,46),(0,1,46),UnicodeCategory::UppercaseLetter),
  ((0,1,47),(0,1,47),UnicodeCategory::LowercaseLetter),
  ((0,1,48),(0,1,48),UnicodeCategory::UppercaseLetter),
  ((0,1,49),(0,1,49),UnicodeCategory::LowercaseLetter),
  ((0,1,50),(0,1,50),UnicodeCategory::UppercaseLetter),
  ((0,1,51),(0,1,51),UnicodeCategory::LowercaseLetter),
  ((0,1,52),(0,1,52),UnicodeCategory::UppercaseLetter),
  ((0,1,53),(0,1,53),UnicodeCategory::LowercaseLetter),
  ((0,1,54),(0,1,54),UnicodeCategory::UppercaseLetter),
  ((0,1,55),(0,1,56),UnicodeCategory::LowercaseLetter),
  ((0,1,57),(0,1,57),UnicodeCategory::UppercaseLetter),
  ((0,1,58),(0,1,58),UnicodeCategory::LowercaseLetter),
  ((0,1,59),(0,1,59),UnicodeCategory::UppercaseLetter),
  ((0,1,60),(0,1,60),UnicodeCategory::LowercaseLetter),
  ((0,1,61),(0,1,61),UnicodeCategory::UppercaseLetter),
  ((0,1,62),(0,1,62),UnicodeCategory::LowercaseLetter),
  ((0,1,63),(0,1,63),UnicodeCategory::UppercaseLetter),
  ((0,1,64),(0,1,64),UnicodeCategory::LowercaseLetter),
  ((0,1,65),(0,1,65),UnicodeCategory::UppercaseLetter),
  ((0,1,66),(0,1,66),UnicodeCategory::LowercaseLetter),
  ((0,1,67),(0,1,67),UnicodeCategory::UppercaseLetter),
  ((0,1,68),(0,1,68),UnicodeCategory::LowercaseLetter),
  ((0,1,69),(0,1,69),UnicodeCategory::UppercaseLetter),
  ((0,1,70),(0,1,70),UnicodeCategory::LowercaseLetter),
  ((0,1,71),(0,1,71),UnicodeCategory::UppercaseLetter),
  ((0,1,72),(0,1,73),UnicodeCategory::LowercaseLetter),
  ((0,1,74),(0,1,74),UnicodeCategory::UppercaseLetter),
  ((0,1,75),(0,1,75),UnicodeCategory::LowercaseLetter),
  ((0,1,76),(0,1,76),UnicodeCategory::UppercaseLetter),
  ((0,1,77),(0,1,77),UnicodeCategory::LowercaseLetter),
  ((0,1,78),(0,1,78),UnicodeCategory::UppercaseLetter),
  ((0,1,79),(0,1,79),UnicodeCategory::LowercaseLetter),
  ((0,1,80),(0,1,80),UnicodeCategory::UppercaseLetter),
  ((0,1,81),(0,1,81),UnicodeCategory::LowercaseLetter),
  ((0,1,82),(0,1,82),UnicodeCategory::UppercaseLetter),
  ((0,1,83),(0,1,83),UnicodeCategory::LowercaseLetter),
  ((0,1,84),(0,1,84),UnicodeCategory::UppercaseLetter),
  ((0,1,85),(0,1,85),UnicodeCategory::LowercaseLetter),
  ((0,1,86),(0,1,86),UnicodeCategory::UppercaseLetter),
  ((0,1,87),(0,1,87),UnicodeCategory::LowercaseLetter),
  ((0,1,88),(0,1,88),UnicodeCategory::UppercaseLetter),
  ((0,1,89),(0,1,89),UnicodeCategory::LowercaseLetter),
  ((0,1,90),(0,1,90),UnicodeCategory::UppercaseLetter),
  ((0,1,91),(0,1,91),UnicodeCategory::LowercaseLetter),
  ((0,1,92),(0,1,92),UnicodeCategory::UppercaseLetter),
  ((0,1,93),(0,1,93),UnicodeCategory::LowercaseLetter),
  ((0,1,94),(0,1,94),UnicodeCategory::UppercaseLetter),
  ((0,1,95),(0,1,95),UnicodeCategory::LowercaseLetter),
  ((0,1,96),(0,1,96),UnicodeCategory::UppercaseLetter),
  ((0,1,97),(0,1,97),UnicodeCategory::LowercaseLetter),
  ((0,1,98),(0,1,98),UnicodeCategory::UppercaseLetter),
  ((0,1,99),(0,1,99),UnicodeCategory::LowercaseLetter),
  ((0,1,100),(0,1,100),UnicodeCategory::UppercaseLetter),
  ((0,1,101),(0,1,101),UnicodeCategory::LowercaseLetter),
  ((0,1,102),(0,1,102),UnicodeCategory::UppercaseLetter),
  ((0,1,103),(0,1,103),UnicodeCategory::LowercaseLetter),
  ((0,1,104),(0,1,104),UnicodeCategory::UppercaseLetter),
  ((0,1,105),(0,1,105),UnicodeCategory::LowercaseLetter),
  ((0,1,106),(0,1,106),UnicodeCategory::UppercaseLetter),
  ((0,1,107),(0,1,107),UnicodeCategory::LowercaseLetter),
  ((0,1,108),(0,1,108),UnicodeCategory::UppercaseLetter),
  ((0,1,109),(0,1,109),UnicodeCategory::LowercaseLetter),
  ((0,1,110),(0,1,110),UnicodeCategory::UppercaseLetter),
  ((0,1,111),(0,1,111),UnicodeCategory::LowercaseLetter),
  ((0,1,112),(0,1,112),UnicodeCategory::UppercaseLetter),
  ((0,1,113),(0,1,113),UnicodeCategory::LowercaseLetter),
  ((0,1,114),(0,1,114),UnicodeCategory::UppercaseLetter),
  ((0,1,115),(0,1,115),UnicodeCategory::LowercaseLetter),
  ((0,1,116),(0,1,116),UnicodeCategory::UppercaseLetter),
  ((0,1,117),(0,1,117),UnicodeCategory::LowercaseLetter),
  ((0,1,118),(0,1,118),UnicodeCategory::UppercaseLetter),
  ((0,1,119),(0,1,119),UnicodeCategory::LowercaseLetter),
  ((0,1,120),(0,1,121),UnicodeCategory::UppercaseLetter),
  ((0,1,122),(0,1,122),UnicodeCategory::LowercaseLetter),
  ((0,1,123),(0,1,123),UnicodeCategory::UppercaseLetter),
  ((0,1,124),(0,1,124),UnicodeCategory::LowercaseLetter),
  ((0,1,125),(0,1,125),UnicodeCategory::UppercaseLetter),
  ((0,1,126),(0,1,128),UnicodeCategory::LowercaseLetter),
  ((0,1,129),(0,1,130),UnicodeCategory::UppercaseLetter),
  ((0,1,131),(0,1,131),UnicodeCategory::LowercaseLetter),
  ((0,1,132),(0,1,132),UnicodeCategory::UppercaseLetter),
  ((0,1,133),(0,1,133),UnicodeCategory::LowercaseLetter),
  ((0,1,134),(0,1,135),UnicodeCategory::UppercaseLetter),
  ((0,1,136),(0,1,136),UnicodeCategory::LowercaseLetter),
  ((0,1,137),(0,1,139),UnicodeCategory::UppercaseLetter),
  ((0,1,140),(0,1,141),UnicodeCategory::LowercaseLetter),
  ((0,1,142),(0,1,145),UnicodeCategory::UppercaseLetter),
  ((0,1,146),(0,1,146),UnicodeCategory::LowercaseLetter),
  ((0,1,147),(0,1,148),UnicodeCategory::UppercaseLetter),
  ((0,1,149),(0,1,149),UnicodeCategory::LowercaseLetter),
  ((0,1,150),(0,1,152),UnicodeCategory::UppercaseLetter),
  ((0,1,153),(0,1,155),UnicodeCategory::LowercaseLetter),
  ((0,1,156),(0,1,157),UnicodeCategory::UppercaseLetter),
  ((0,1,158),(0,1,158),UnicodeCategory::LowercaseLetter),
  ((0,1,159),(0,1,160),UnicodeCategory::UppercaseLetter),
  ((0,1,161),(0,1,161),UnicodeCategory::LowercaseLetter),
  ((0,1,162),(0,1,162),UnicodeCategory::UppercaseLetter),
  ((0,1,163),(0,1,163),UnicodeCategory::LowercaseLetter),
  ((0,1,164),(0,1,164),UnicodeCategory::UppercaseLetter),
  ((0,1,165),(0,1,165),UnicodeCategory::LowercaseLetter),
  ((0,1,166),(0,1,167),UnicodeCategory::UppercaseLetter),
  ((0,1,168),(0,1,168),UnicodeCategory::LowercaseLetter),
  ((0,1,169),(0,1,169),UnicodeCategory::UppercaseLetter),
  ((0,1,170),(0,1,171),UnicodeCategory::LowercaseLetter),
  ((0,1,172),(0,1,172),UnicodeCategory::UppercaseLetter),
  ((0,1,173),(0,1,173),UnicodeCategory::LowercaseLetter),
  ((0,1,174),(0,1,175),UnicodeCategory::UppercaseLetter),
  ((0,1,176),(0,1,176),UnicodeCategory::LowercaseLetter),
  ((0,1,177),(0,1,179),UnicodeCategory::UppercaseLetter),
  ((0,1,180),(0,1,180),UnicodeCategory::LowercaseLetter),
  ((0,1,181),(0,1,181),UnicodeCategory::UppercaseLetter),
  ((0,1,182),(0,1,182),UnicodeCategory::LowercaseLetter),
  ((0,1,183),(0,1,184),UnicodeCategory::UppercaseLetter),
  ((0,1,185),(0,1,186),UnicodeCategory::LowercaseLetter),
  ((0,1,187),(0,1,187),UnicodeCategory::OtherLetter),
  ((0,1,188),(0,1,188),UnicodeCategory::UppercaseLetter),
  ((0,1,189),(0,1,191),UnicodeCategory::LowercaseLetter),
  ((0,1,192),(0,1,195),UnicodeCategory::OtherLetter),
  ((0,1,196),(0,1,196),UnicodeCategory::UppercaseLetter),
  ((0,1,197),(0,1,197),UnicodeCategory::TitlecaseLetter),
  ((0,1,198),(0,1,198),UnicodeCategory::LowercaseLetter),
  ((0,1,199),(0,1,199),UnicodeCategory::UppercaseLetter),
  ((0,1,200),(0,1,200),UnicodeCategory::TitlecaseLetter),
  ((0,1,201),(0,1,201),UnicodeCategory::LowercaseLetter),
  ((0,1,202),(0,1,202),UnicodeCategory::UppercaseLetter),
  ((0,1,203),(0,1,203),UnicodeCategory::TitlecaseLetter),
  ((0,1,204),(0,1,204),UnicodeCategory::LowercaseLetter),
  ((0,1,205),(0,1,205),UnicodeCategory::UppercaseLetter),
  ((0,1,206),(0,1,206),UnicodeCategory::LowercaseLetter),
  ((0,1,207),(0,1,207),UnicodeCategory::UppercaseLetter),
  ((0,1,208),(0,1,208),UnicodeCategory::LowercaseLetter),
  ((0,1,209),(0,1,209),UnicodeCategory::UppercaseLetter),
  ((0,1,210),(0,1,210),UnicodeCategory::LowercaseLetter),
  ((0,1,211),(0,1,211),UnicodeCategory::UppercaseLetter),
  ((0,1,212),(0,1,212),UnicodeCategory::LowercaseLetter),
  ((0,1,213),(0,1,213),UnicodeCategory::UppercaseLetter),
  ((0,1,214),(0,1,214),UnicodeCategory::LowercaseLetter),
  ((0,1,215),(0,1,215),UnicodeCategory::UppercaseLetter),
  ((0,1,216),(0,1,216),UnicodeCategory::LowercaseLetter),
  ((0,1,217),(0,1,217),UnicodeCategory::UppercaseLetter),
  ((0,1,218),(0,1,218),UnicodeCategory::LowercaseLetter),
  ((0,1,219),(0,1,219),UnicodeCategory::UppercaseLetter),
  ((0,1,220),(0,1,221),UnicodeCategory::LowercaseLetter),
  ((0,1,222),(0,1,222),UnicodeCategory::UppercaseLetter),
  ((0,1,223),(0,1,223),UnicodeCategory::LowercaseLetter),
  ((0,1,224),(0,1,224),UnicodeCategory::UppercaseLetter),
  ((0,1,225),(0,1,225),UnicodeCategory::LowercaseLetter),
  ((0,1,226),(0,1,226),UnicodeCategory::UppercaseLetter),
  ((0,1,227),(0,1,227),UnicodeCategory::LowercaseLetter),
  ((0,1,228),(0,1,228),UnicodeCategory::UppercaseLetter),
  ((0,1,229),(0,1,229),UnicodeCategory::LowercaseLetter),
  ((0,1,230),(0,1,230),UnicodeCategory::UppercaseLetter),
  ((0,1,231),(0,1,231),UnicodeCategory::LowercaseLetter),
  ((0,1,232),(0,1,232),UnicodeCategory::UppercaseLetter),
  ((0,1,233),(0,1,233),UnicodeCategory::LowercaseLetter),
  ((0,1,234),(0,1,234),UnicodeCategory::UppercaseLetter),
  ((0,1,235),(0,1,235),UnicodeCategory::LowercaseLetter),
  ((0,1,236),(0,1,236),UnicodeCategory::UppercaseLetter),
  ((0,1,237),(0,1,237),UnicodeCategory::LowercaseLetter),
  ((0,1,238),(0,1,238),UnicodeCategory::UppercaseLetter),
  ((0,1,239),(0,1,240),UnicodeCategory::LowercaseLetter),
  ((0,1,241),(0,1,241),UnicodeCategory::UppercaseLetter),
  ((0,1,242),(0,1,242),UnicodeCategory::TitlecaseLetter),
  ((0,1,243),(0,1,243),UnicodeCategory::LowercaseLetter),
  ((0,1,244),(0,1,244),UnicodeCategory::UppercaseLetter),
  ((0,1,245),(0,1,245),UnicodeCategory::LowercaseLetter),
  ((0,1,246),(0,1,248),UnicodeCategory::UppercaseLetter),
  ((0,1,249),(0,1,249),UnicodeCategory::LowercaseLetter),
  ((0,1,250),(0,1,250),UnicodeCategory::UppercaseLetter),
  ((0,1,251),(0,1,251),UnicodeCategory::LowercaseLetter),
  ((0,1,252),(0,1,252),UnicodeCategory::UppercaseLetter),
  ((0,1,253),(0,1,253),UnicodeCategory::LowercaseLetter),
  ((0,1,254),(0,1,254),UnicodeCategory::UppercaseLetter),
  ((0,1,255),(0,1,255),UnicodeCategory::LowercaseLetter),
  ((0,2,0),(0,2,0),UnicodeCategory::UppercaseLetter),
  ((0,2,1),(0,2,1),UnicodeCategory::LowercaseLetter),
  ((0,2,2),(0,2,2),UnicodeCategory::UppercaseLetter),
  ((0,2,3),(0,2,3),UnicodeCategory::LowercaseLetter),
  ((0,2,4),(0,2,4),UnicodeCategory::UppercaseLetter),
  ((0,2,5),(0,2,5),UnicodeCategory::LowercaseLetter),
  ((0,2,6),(0,2,6),UnicodeCategory::UppercaseLetter),
  ((0,2,7),(0,2,7),UnicodeCategory::LowercaseLetter),
  ((0,2,8),(0,2,8),UnicodeCategory::UppercaseLetter),
  ((0,2,9),(0,2,9),UnicodeCategory::LowercaseLetter),
  ((0,2,10),(0,2,10),UnicodeCategory::UppercaseLetter),
  ((0,2,11),(0,2,11),UnicodeCategory::LowercaseLetter),
  ((0,2,12),(0,2,12),UnicodeCategory::UppercaseLetter),
  ((0,2,13),(0,2,13),UnicodeCategory::LowercaseLetter),
  ((0,2,14),(0,2,14),UnicodeCategory::UppercaseLetter),
  ((0,2,15),(0,2,15),UnicodeCategory::LowercaseLetter),
  ((0,2,16),(0,2,16),UnicodeCategory::UppercaseLetter),
  ((0,2,17),(0,2,17),UnicodeCategory::LowercaseLetter),
  ((0,2,18),(0,2,18),UnicodeCategory::UppercaseLetter),
  ((0,2,19),(0,2,19),UnicodeCategory::LowercaseLetter),
  ((0,2,20),(0,2,20),UnicodeCategory::UppercaseLetter),
  ((0,2,21),(0,2,21),UnicodeCategory::LowercaseLetter),
  ((0,2,22),(0,2,22),UnicodeCategory::UppercaseLetter),
  ((0,2,23),(0,2,23),UnicodeCategory::LowercaseLetter),
  ((0,2,24),(0,2,24),UnicodeCategory::UppercaseLetter),
  ((0,2,25),(0,2,25),UnicodeCategory::LowercaseLetter),
  ((0,2,26),(0,2,26),UnicodeCategory::UppercaseLetter),
  ((0,2,27),(0,2,27),UnicodeCategory::LowercaseLetter),
  ((0,2,28),(0,2,28),UnicodeCategory::UppercaseLetter),
  ((0,2,29),(0,2,29),UnicodeCategory::LowercaseLetter),
  ((0,2,30),(0,2,30),UnicodeCategory::UppercaseLetter),
  ((0,2,31),(0,2,31),UnicodeCategory::LowercaseLetter),
  ((0,2,32),(0,2,32),UnicodeCategory::UppercaseLetter),
  ((0,2,33),(0,2,33),UnicodeCategory::LowercaseLetter),
  ((0,2,34),(0,2,34),UnicodeCategory::UppercaseLetter),
  ((0,2,35),(0,2,35),UnicodeCategory::LowercaseLetter),
  ((0,2,36),(0,2,36),UnicodeCategory::UppercaseLetter),
  ((0,2,37),(0,2,37),UnicodeCategory::LowercaseLetter),
  ((0,2,38),(0,2,38),UnicodeCategory::UppercaseLetter),
  ((0,2,39),(0,2,39),UnicodeCategory::LowercaseLetter),
  ((0,2,40),(0,2,40),UnicodeCategory::UppercaseLetter),
  ((0,2,41),(0,2,41),UnicodeCategory::LowercaseLetter),
  ((0,2,42),(0,2,42),UnicodeCategory::UppercaseLetter),
  ((0,2,43),(0,2,43),UnicodeCategory::LowercaseLetter),
  ((0,2,44),(0,2,44),UnicodeCategory::UppercaseLetter),
  ((0,2,45),(0,2,45),UnicodeCategory::LowercaseLetter),
  ((0,2,46),(0,2,46),UnicodeCategory::UppercaseLetter),
  ((0,2,47),(0,2,47),UnicodeCategory::LowercaseLetter),
  ((0,2,48),(0,2,48),UnicodeCategory::UppercaseLetter),
  ((0,2,49),(0,2,49),UnicodeCategory::LowercaseLetter),
  ((0,2,50),(0,2,50),UnicodeCategory::UppercaseLetter),
  ((0,2,51),(0,2,57),UnicodeCategory::LowercaseLetter),
  ((0,2,58),(0,2,59),UnicodeCategory::UppercaseLetter),
  ((0,2,60),(0,2,60),UnicodeCategory::LowercaseLetter),
  ((0,2,61),(0,2,62),UnicodeCategory::UppercaseLetter),
  ((0,2,63),(0,2,64),UnicodeCategory::LowercaseLetter),
  ((0,2,65),(0,2,65),UnicodeCategory::UppercaseLetter),
  ((0,2,66),(0,2,66),UnicodeCategory::LowercaseLetter),
  ((0,2,67),(0,2,70),UnicodeCategory::UppercaseLetter),
  ((0,2,71),(0,2,71),UnicodeCategory::LowercaseLetter),
  ((0,2,72),(0,2,72),UnicodeCategory::UppercaseLetter),
  ((0,2,73),(0,2,73),UnicodeCategory::LowercaseLetter),
  ((0,2,74),(0,2,74),UnicodeCategory::UppercaseLetter),
  ((0,2,75),(0,2,75),UnicodeCategory::LowercaseLetter),
  ((0,2,76),(0,2,76),UnicodeCategory::UppercaseLetter),
  ((0,2,77),(0,2,77),UnicodeCategory::LowercaseLetter),
  ((0,2,78),(0,2,78),UnicodeCategory::UppercaseLetter),
  ((0,2,79),(0,2,147),UnicodeCategory::LowercaseLetter),
  ((0,2,148),(0,2,148),UnicodeCategory::OtherLetter),
  ((0,2,149),(0,2,175),UnicodeCategory::LowercaseLetter),
  ((0,2,176),(0,2,193),UnicodeCategory::ModifierLetter),
  ((0,2,194),(0,2,197),UnicodeCategory::ModifierSymbol),
  ((0,2,198),(0,2,209),UnicodeCategory::ModifierLetter),
  ((0,2,210),(0,2,223),UnicodeCategory::ModifierSymbol),
  ((0,2,224),(0,2,228),UnicodeCategory::ModifierLetter),
  ((0,2,229),(0,2,235),UnicodeCategory::ModifierSymbol),
  ((0,2,236),(0,2,236),UnicodeCategory::ModifierLetter),
  ((0,2,237),(0,2,237),UnicodeCategory::ModifierSymbol),
  ((0,2,238),(0,2,238),UnicodeCategory::ModifierLetter),
  ((0,2,239),(0,2,255),UnicodeCategory::ModifierSymbol),
  ((0,3,0),(0,3,111),UnicodeCategory::NonspacingMark),
  ((0,3,112),(0,3,112),UnicodeCategory::UppercaseLetter),
  ((0,3,113),(0,3,113),UnicodeCategory::LowercaseLetter),
  ((0,3,114),(0,3,114),UnicodeCategory::UppercaseLetter),
  ((0,3,115),(0,3,115),UnicodeCategory::LowercaseLetter),
  ((0,3,116),(0,3,116),UnicodeCategory::ModifierLetter),
  ((0,3,117),(0,3,117),UnicodeCategory::ModifierSymbol),
  ((0,3,118),(0,3,118),UnicodeCategory::UppercaseLetter),
  ((0,3,119),(0,3,119),UnicodeCategory::LowercaseLetter),
  ((0,3,122),(0,3,122),UnicodeCategory::ModifierLetter),
  ((0,3,123),(0,3,125),UnicodeCategory::LowercaseLetter),
  ((0,3,126),(0,3,126),UnicodeCategory::OtherPunctuation),
  ((0,3,127),(0,3,127),UnicodeCategory::UppercaseLetter),
  ((0,3,132),(0,3,133),UnicodeCategory::ModifierSymbol),
  ((0,3,134),(0,3,134),UnicodeCategory::UppercaseLetter),
  ((0,3,135),(0,3,135),UnicodeCategory::OtherPunctuation),
  ((0,3,136),(0,3,138),UnicodeCategory::UppercaseLetter),
  ((0,3,140),(0,3,140),UnicodeCategory::UppercaseLetter),
  ((0,3,142),(0,3,143),UnicodeCategory::UppercaseLetter),
  ((0,3,144),(0,3,144),UnicodeCategory::LowercaseLetter),
  ((0,3,145),(0,3,161),UnicodeCategory::UppercaseLetter),
  ((0,3,163),(0,3,171),UnicodeCategory::UppercaseLetter),
  ((0,3,172),(0,3,206),UnicodeCategory::LowercaseLetter),
  ((0,3,207),(0,3,207),UnicodeCategory::UppercaseLetter),
  ((0,3,208),(0,3,209),UnicodeCategory::LowercaseLetter),
  ((0,3,210),(0,3,212),UnicodeCategory::UppercaseLetter),
  ((0,3,213),(0,3,215),UnicodeCategory::LowercaseLetter),
  ((0,3,216),(0,3,216),UnicodeCategory::UppercaseLetter),
  ((0,3,217),(0,3,217),UnicodeCategory::LowercaseLetter),
  ((0,3,218),(0,3,218),UnicodeCategory::UppercaseLetter),
  ((0,3,219),(0,3,219),UnicodeCategory::LowercaseLetter),
  ((0,3,220),(0,3,220),UnicodeCategory::UppercaseLetter),
  ((0,3,221),(0,3,221),UnicodeCategory::LowercaseLetter),
  ((0,3,222),(0,3,222),UnicodeCategory::UppercaseLetter),
  ((0,3,223),(0,3,223),UnicodeCategory::LowercaseLetter),
  ((0,3,224),(0,3,224),UnicodeCategory::UppercaseLetter),
  ((0,3,225),(0,3,225),UnicodeCategory::LowercaseLetter),
  ((0,3,226),(0,3,226),UnicodeCategory::UppercaseLetter),
  ((0,3,227),(0,3,227),UnicodeCategory::LowercaseLetter),
  ((0,3,228),(0,3,228),UnicodeCategory::UppercaseLetter),
  ((0,3,229),(0,3,229),UnicodeCategory::LowercaseLetter),
  ((0,3,230),(0,3,230),UnicodeCategory::UppercaseLetter),
  ((0,3,231),(0,3,231),UnicodeCategory::LowercaseLetter),
  ((0,3,232),(0,3,232),UnicodeCategory::UppercaseLetter),
  ((0,3,233),(0,3,233),UnicodeCategory::LowercaseLetter),
  ((0,3,234),(0,3,234),UnicodeCategory::UppercaseLetter),
  ((0,3,235),(0,3,235),UnicodeCategory::LowercaseLetter),
  ((0,3,236),(0,3,236),UnicodeCategory::UppercaseLetter),
  ((0,3,237),(0,3,237),UnicodeCategory::LowercaseLetter),
  ((0,3,238),(0,3,238),UnicodeCategory::UppercaseLetter),
  ((0,3,239),(0,3,243),UnicodeCategory::LowercaseLetter),
  ((0,3,244),(0,3,244),UnicodeCategory::UppercaseLetter),
  ((0,3,245),(0,3,245),UnicodeCategory::LowercaseLetter),
  ((0,3,246),(0,3,246),UnicodeCategory::MathSymbol),
  ((0,3,247),(0,3,247),UnicodeCategory::UppercaseLetter),
  ((0,3,248),(0,3,248),UnicodeCategory::LowercaseLetter),
  ((0,3,249),(0,3,250),UnicodeCategory::UppercaseLetter),
  ((0,3,251),(0,3,252),UnicodeCategory::LowercaseLetter),
  ((0,3,253),(0,4,47),UnicodeCategory::UppercaseLetter),
  ((0,4,48),(0,4,95),UnicodeCategory::LowercaseLetter),
  ((0,4,96),(0,4,96),UnicodeCategory::UppercaseLetter),
  ((0,4,97),(0,4,97),UnicodeCategory::LowercaseLetter),
  ((0,4,98),(0,4,98),UnicodeCategory::UppercaseLetter),
  ((0,4,99),(0,4,99),UnicodeCategory::LowercaseLetter),
  ((0,4,100),(0,4,100),UnicodeCategory::UppercaseLetter),
  ((0,4,101),(0,4,101),UnicodeCategory::LowercaseLetter),
  ((0,4,102),(0,4,102),UnicodeCategory::UppercaseLetter),
  ((0,4,103),(0,4,103),UnicodeCategory::LowercaseLetter),
  ((0,4,104),(0,4,104),UnicodeCategory::UppercaseLetter),
  ((0,4,105),(0,4,105),UnicodeCategory::LowercaseLetter),
  ((0,4,106),(0,4,106),UnicodeCategory::UppercaseLetter),
  ((0,4,107),(0,4,107),UnicodeCategory::LowercaseLetter),
  ((0,4,108),(0,4,108),UnicodeCategory::UppercaseLetter),
  ((0,4,109),(0,4,109),UnicodeCategory::LowercaseLetter),
  ((0,4,110),(0,4,110),UnicodeCategory::UppercaseLetter),
  ((0,4,111),(0,4,111),UnicodeCategory::LowercaseLetter),
  ((0,4,112),(0,4,112),UnicodeCategory::UppercaseLetter),
  ((0,4,113),(0,4,113),UnicodeCategory::LowercaseLetter),
  ((0,4,114),(0,4,114),UnicodeCategory::UppercaseLetter),
  ((0,4,115),(0,4,115),UnicodeCategory::LowercaseLetter),
  ((0,4,116),(0,4,116),UnicodeCategory::UppercaseLetter),
  ((0,4,117),(0,4,117),UnicodeCategory::LowercaseLetter),
  ((0,4,118),(0,4,118),UnicodeCategory::UppercaseLetter),
  ((0,4,119),(0,4,119),UnicodeCategory::LowercaseLetter),
  ((0,4,120),(0,4,120),UnicodeCategory::UppercaseLetter),
  ((0,4,121),(0,4,121),UnicodeCategory::LowercaseLetter),
  ((0,4,122),(0,4,122),UnicodeCategory::UppercaseLetter),
  ((0,4,123),(0,4,123),UnicodeCategory::LowercaseLetter),
  ((0,4,124),(0,4,124),UnicodeCategory::UppercaseLetter),
  ((0,4,125),(0,4,125),UnicodeCategory::LowercaseLetter),
  ((0,4,126),(0,4,126),UnicodeCategory::UppercaseLetter),
  ((0,4,127),(0,4,127),UnicodeCategory::LowercaseLetter),
  ((0,4,128),(0,4,128),UnicodeCategory::UppercaseLetter),
  ((0,4,129),(0,4,129),UnicodeCategory::LowercaseLetter),
  ((0,4,130),(0,4,130),UnicodeCategory::OtherSymbol),
  ((0,4,131),(0,4,135),UnicodeCategory::NonspacingMark),
  ((0,4,136),(0,4,137),UnicodeCategory::EnclosingMark),
  ((0,4,138),(0,4,138),UnicodeCategory::UppercaseLetter),
  ((0,4,139),(0,4,139),UnicodeCategory::LowercaseLetter),
  ((0,4,140),(0,4,140),UnicodeCategory::UppercaseLetter),
  ((0,4,141),(0,4,141),UnicodeCategory::LowercaseLetter),
  ((0,4,142),(0,4,142),UnicodeCategory::UppercaseLetter),
  ((0,4,143),(0,4,143),UnicodeCategory::LowercaseLetter),
  ((0,4,144),(0,4,144),UnicodeCategory::UppercaseLetter),
  ((0,4,145),(0,4,145),UnicodeCategory::LowercaseLetter),
  ((0,4,146),(0,4,146),UnicodeCategory::UppercaseLetter),
  ((0,4,147),(0,4,147),UnicodeCategory::LowercaseLetter),
  ((0,4,148),(0,4,148),UnicodeCategory::UppercaseLetter),
  ((0,4,149),(0,4,149),UnicodeCategory::LowercaseLetter),
  ((0,4,150),(0,4,150),UnicodeCategory::UppercaseLetter),
  ((0,4,151),(0,4,151),UnicodeCategory::LowercaseLetter),
  ((0,4,152),(0,4,152),UnicodeCategory::UppercaseLetter),
  ((0,4,153),(0,4,153),UnicodeCategory::LowercaseLetter),
  ((0,4,154),(0,4,154),UnicodeCategory::UppercaseLetter),
  ((0,4,155),(0,4,155),UnicodeCategory::LowercaseLetter),
  ((0,4,156),(0,4,156),UnicodeCategory::UppercaseLetter),
  ((0,4,157),(0,4,157),UnicodeCategory::LowercaseLetter),
  ((0,4,158),(0,4,158),UnicodeCategory::UppercaseLetter),
  ((0,4,159),(0,4,159),UnicodeCategory::LowercaseLetter),
  ((0,4,160),(0,4,160),UnicodeCategory::UppercaseLetter),
  ((0,4,161),(0,4,161),UnicodeCategory::LowercaseLetter),
  ((0,4,162),(0,4,162),UnicodeCategory::UppercaseLetter),
  ((0,4,163),(0,4,163),UnicodeCategory::LowercaseLetter),
  ((0,4,164),(0,4,164),UnicodeCategory::UppercaseLetter),
  ((0,4,165),(0,4,165),UnicodeCategory::LowercaseLetter),
  ((0,4,166),(0,4,166),UnicodeCategory::UppercaseLetter),
  ((0,4,167),(0,4,167),UnicodeCategory::LowercaseLetter),
  ((0,4,168),(0,4,168),UnicodeCategory::UppercaseLetter),
  ((0,4,169),(0,4,169),UnicodeCategory::LowercaseLetter),
  ((0,4,170),(0,4,170),UnicodeCategory::UppercaseLetter),
  ((0,4,171),(0,4,171),UnicodeCategory::LowercaseLetter),
  ((0,4,172),(0,4,172),UnicodeCategory::UppercaseLetter),
  ((0,4,173),(0,4,173),UnicodeCategory::LowercaseLetter),
  ((0,4,174),(0,4,174),UnicodeCategory::UppercaseLetter),
  ((0,4,175),(0,4,175),UnicodeCategory::LowercaseLetter),
  ((0,4,176),(0,4,176),UnicodeCategory::UppercaseLetter),
  ((0,4,177),(0,4,177),UnicodeCategory::LowercaseLetter),
  ((0,4,178),(0,4,178),UnicodeCategory::UppercaseLetter),
  ((0,4,179),(0,4,179),UnicodeCategory::LowercaseLetter),
  ((0,4,180),(0,4,180),UnicodeCategory::UppercaseLetter),
  ((0,4,181),(0,4,181),UnicodeCategory::LowercaseLetter),
  ((0,4,182),(0,4,182),UnicodeCategory::UppercaseLetter),
  ((0,4,183),(0,4,183),UnicodeCategory::LowercaseLetter),
  ((0,4,184),(0,4,184),UnicodeCategory::UppercaseLetter),
  ((0,4,185),(0,4,185),UnicodeCategory::LowercaseLetter),
  ((0,4,186),(0,4,186),UnicodeCategory::UppercaseLetter),
  ((0,4,187),(0,4,187),UnicodeCategory::LowercaseLetter),
  ((0,4,188),(0,4,188),UnicodeCategory::UppercaseLetter),
  ((0,4,189),(0,4,189),UnicodeCategory::LowercaseLetter),
  ((0,4,190),(0,4,190),UnicodeCategory::UppercaseLetter),
  ((0,4,191),(0,4,191),UnicodeCategory::LowercaseLetter),
  ((0,4,192),(0,4,193),UnicodeCategory::UppercaseLetter),
  ((0,4,194),(0,4,194),UnicodeCategory::LowercaseLetter),
  ((0,4,195),(0,4,195),UnicodeCategory::UppercaseLetter),
  ((0,4,196),(0,4,196),UnicodeCategory::LowercaseLetter),
  ((0,4,197),(0,4,197),UnicodeCategory::UppercaseLetter),
  ((0,4,198),(0,4,198),UnicodeCategory::LowercaseLetter),
  ((0,4,199),(0,4,199),UnicodeCategory::UppercaseLetter),
  ((0,4,200),(0,4,200),UnicodeCategory::LowercaseLetter),
  ((0,4,201),(0,4,201),UnicodeCategory::UppercaseLetter),
  ((0,4,202),(0,4,202),UnicodeCategory::LowercaseLetter),
  ((0,4,203),(0,4,203),UnicodeCategory::UppercaseLetter),
  ((0,4,204),(0,4,204),UnicodeCategory::LowercaseLetter),
  ((0,4,205),(0,4,205),UnicodeCategory::UppercaseLetter),
  ((0,4,206),(0,4,207),UnicodeCategory::LowercaseLetter),
  ((0,4,208),(0,4,208),UnicodeCategory::UppercaseLetter),
  ((0,4,209),(0,4,209),UnicodeCategory::LowercaseLetter),
  ((0,4,210),(0,4,210),UnicodeCategory::UppercaseLetter),
  ((0,4,211),(0,4,211),UnicodeCategory::LowercaseLetter),
  ((0,4,212),(0,4,212),UnicodeCategory::UppercaseLetter),
  ((0,4,213),(0,4,213),UnicodeCategory::LowercaseLetter),
  ((0,4,214),(0,4,214),UnicodeCategory::UppercaseLetter),
  ((0,4,215),(0,4,215),UnicodeCategory::LowercaseLetter),
  ((0,4,216),(0,4,216),UnicodeCategory::UppercaseLetter),
  ((0,4,217),(0,4,217),UnicodeCategory::LowercaseLetter),
  ((0,4,218),(0,4,218),UnicodeCategory::UppercaseLetter),
  ((0,4,219),(0,4,219),UnicodeCategory::LowercaseLetter),
  ((0,4,220),(0,4,220),UnicodeCategory::UppercaseLetter),
  ((0,4,221),(0,4,221),UnicodeCategory::LowercaseLetter),
  ((0,4,222),(0,4,222),UnicodeCategory::UppercaseLetter),
  ((0,4,223),(0,4,223),UnicodeCategory::LowercaseLetter),
  ((0,4,224),(0,4,224),UnicodeCategory::UppercaseLetter),
  ((0,4,225),(0,4,225),UnicodeCategory::LowercaseLetter),
  ((0,4,226),(0,4,226),UnicodeCategory::UppercaseLetter),
  ((0,4,227),(0,4,227),UnicodeCategory::LowercaseLetter),
  ((0,4,228),(0,4,228),UnicodeCategory::UppercaseLetter),
  ((0,4,229),(0,4,229),UnicodeCategory::LowercaseLetter),
  ((0,4,230),(0,4,230),UnicodeCategory::UppercaseLetter),
  ((0,4,231),(0,4,231),UnicodeCategory::LowercaseLetter),
  ((0,4,232),(0,4,232),UnicodeCategory::UppercaseLetter),
  ((0,4,233),(0,4,233),UnicodeCategory::LowercaseLetter),
  ((0,4,234),(0,4,234),UnicodeCategory::UppercaseLetter),
  ((0,4,235),(0,4,235),UnicodeCategory::LowercaseLetter),
  ((0,4,236),(0,4,236),UnicodeCategory::UppercaseLetter),
  ((0,4,237),(0,4,237),UnicodeCategory::LowercaseLetter),
  ((0,4,238),(0,4,238),UnicodeCategory::UppercaseLetter),
  ((0,4,239),(0,4,239),UnicodeCategory::LowercaseLetter),
  ((0,4,240),(0,4,240),UnicodeCategory::UppercaseLetter),
  ((0,4,241),(0,4,241),UnicodeCategory::LowercaseLetter),
  ((0,4,242),(0,4,242),UnicodeCategory::UppercaseLetter),
  ((0,4,243),(0,4,243),UnicodeCategory::LowercaseLetter),
  ((0,4,244),(0,4,244),UnicodeCategory::UppercaseLetter),
  ((0,4,245),(0,4,245),UnicodeCategory::LowercaseLetter),
  ((0,4,246),(0,4,246),UnicodeCategory::UppercaseLetter),
  ((0,4,247),(0,4,247),UnicodeCategory::LowercaseLetter),
  ((0,4,248),(0,4,248),UnicodeCategory::UppercaseLetter),
  ((0,4,249),(0,4,249),UnicodeCategory::LowercaseLetter),
  ((0,4,250),(0,4,250),UnicodeCategory::UppercaseLetter),
  ((0,4,251),(0,4,251),UnicodeCategory::LowercaseLetter),
  ((0,4,252),(0,4,252),UnicodeCategory::UppercaseLetter),
  ((0,4,253),(0,4,253),UnicodeCategory::LowercaseLetter),
  ((0,4,254),(0,4,254),UnicodeCategory::UppercaseLetter),
  ((0,4,255),(0,4,255),UnicodeCategory::LowercaseLetter),
  ((0,5,0),(0,5,0),UnicodeCategory::UppercaseLetter),
  ((0,5,1),(0,5,1),UnicodeCategory::LowercaseLetter),
  ((0,5,2),(0,5,2),UnicodeCategory::UppercaseLetter),
  ((0,5,3),(0,5,3),UnicodeCategory::LowercaseLetter),
  ((0,5,4),(0,5,4),UnicodeCategory::UppercaseLetter),
  ((0,5,5),(0,5,5),UnicodeCategory::LowercaseLetter),
  ((0,5,6),(0,5,6),UnicodeCategory::UppercaseLetter),
  ((0,5,7),(0,5,7),UnicodeCategory::LowercaseLetter),
  ((0,5,8),(0,5,8),UnicodeCategory::UppercaseLetter),
  ((0,5,9),(0,5,9),UnicodeCategory::LowercaseLetter),
  ((0,5,10),(0,5,10),UnicodeCategory::UppercaseLetter),
  ((0,5,11),(0,5,11),UnicodeCategory::LowercaseLetter),
  ((0,5,12),(0,5,12),UnicodeCategory::UppercaseLetter),
  ((0,5,13),(0,5,13),UnicodeCategory::LowercaseLetter),
  ((0,5,14),(0,5,14),UnicodeCategory::UppercaseLetter),
  ((0,5,15),(0,5,15),UnicodeCategory::LowercaseLetter),
  ((0,5,16),(0,5,16),UnicodeCategory::UppercaseLetter),
  ((0,5,17),(0,5,17),UnicodeCategory::LowercaseLetter),
  ((0,5,18),(0,5,18),UnicodeCategory::UppercaseLetter),
  ((0,5,19),(0,5,19),UnicodeCategory::LowercaseLetter),
  ((0,5,20),(0,5,20),UnicodeCategory::UppercaseLetter),
  ((0,5,21),(0,5,21),UnicodeCategory::LowercaseLetter),
  ((0,5,22),(0,5,22),UnicodeCategory::UppercaseLetter),
  ((0,5,23),(0,5,23),UnicodeCategory::LowercaseLetter),
  ((0,5,24),(0,5,24),UnicodeCategory::UppercaseLetter),
  ((0,5,25),(0,5,25),UnicodeCategory::LowercaseLetter),
  ((0,5,26),(0,5,26),UnicodeCategory::UppercaseLetter),
  ((0,5,27),(0,5,27),UnicodeCategory::LowercaseLetter),
  ((0,5,28),(0,5,28),UnicodeCategory::UppercaseLetter),
  ((0,5,29),(0,5,29),UnicodeCategory::LowercaseLetter),
  ((0,5,30),(0,5,30),UnicodeCategory::UppercaseLetter),
  ((0,5,31),(0,5,31),UnicodeCategory::LowercaseLetter),
  ((0,5,32),(0,5,32),UnicodeCategory::UppercaseLetter),
  ((0,5,33),(0,5,33),UnicodeCategory::LowercaseLetter),
  ((0,5,34),(0,5,34),UnicodeCategory::UppercaseLetter),
  ((0,5,35),(0,5,35),UnicodeCategory::LowercaseLetter),
  ((0,5,36),(0,5,36),UnicodeCategory::UppercaseLetter),
  ((0,5,37),(0,5,37),UnicodeCategory::LowercaseLetter),
  ((0,5,38),(0,5,38),UnicodeCategory::UppercaseLetter),
  ((0,5,39),(0,5,39),UnicodeCategory::LowercaseLetter),
  ((0,5,40),(0,5,40),UnicodeCategory::UppercaseLetter),
  ((0,5,41),(0,5,41),UnicodeCategory::LowercaseLetter),
  ((0,5,42),(0,5,42),UnicodeCategory::UppercaseLetter),
  ((0,5,43),(0,5,43),UnicodeCategory::LowercaseLetter),
  ((0,5,44),(0,5,44),UnicodeCategory::UppercaseLetter),
  ((0,5,45),(0,5,45),UnicodeCategory::LowercaseLetter),
  ((0,5,46),(0,5,46),UnicodeCategory::UppercaseLetter),
  ((0,5,47),(0,5,47),UnicodeCategory::LowercaseLetter),
  ((0,5,49),(0,5,86),UnicodeCategory::UppercaseLetter),
  ((0,5,89),(0,5,89),UnicodeCategory::ModifierLetter),
  ((0,5,90),(0,5,95),UnicodeCategory::OtherPunctuation),
  ((0,5,97),(0,5,135),UnicodeCategory::LowercaseLetter),
  ((0,5,137),(0,5,137),UnicodeCategory::OtherPunctuation),
  ((0,5,138),(0,5,138),UnicodeCategory::DashPunctuation),
  ((0,5,141),(0,5,142),UnicodeCategory::OtherSymbol),
  ((0,5,143),(0,5,143),UnicodeCategory::CurrencySymbol),
  ((0,5,145),(0,5,189),UnicodeCategory::NonspacingMark),
  ((0,5,190),(0,5,190),UnicodeCategory::DashPunctuation),
  ((0,5,191),(0,5,191),UnicodeCategory::NonspacingMark),
  ((0,5,192),(0,5,192),UnicodeCategory::OtherPunctuation),
  ((0,5,193),(0,5,194),UnicodeCategory::NonspacingMark),
  ((0,5,195),(0,5,195),UnicodeCategory::OtherPunctuation),
  ((0,5,196),(0,5,197),UnicodeCategory::NonspacingMark),
  ((0,5,198),(0,5,198),UnicodeCategory::OtherPunctuation),
  ((0,5,199),(0,5,199),UnicodeCategory::NonspacingMark),
  ((0,5,208),(0,5,234),UnicodeCategory::OtherLetter),
  ((0,5,240),(0,5,242),UnicodeCategory::OtherLetter),
  ((0,5,243),(0,5,244),UnicodeCategory::OtherPunctuation),
  ((0,6,0),(0,6,5),UnicodeCategory::Format),
  ((0,6,6),(0,6,8),UnicodeCategory::MathSymbol),
  ((0,6,9),(0,6,10),UnicodeCategory::OtherPunctuation),
  ((0,6,11),(0,6,11),UnicodeCategory::CurrencySymbol),
  ((0,6,12),(0,6,13),UnicodeCategory::OtherPunctuation),
  ((0,6,14),(0,6,15),UnicodeCategory::OtherSymbol),
  ((0,6,16),(0,6,26),UnicodeCategory::NonspacingMark),
  ((0,6,27),(0,6,27),UnicodeCategory::OtherPunctuation),
  ((0,6,28),(0,6,28),UnicodeCategory::Format),
  ((0,6,30),(0,6,31),UnicodeCategory::OtherPunctuation),
  ((0,6,32),(0,6,63),UnicodeCategory::OtherLetter),
  ((0,6,64),(0,6,64),UnicodeCategory::ModifierLetter),
  ((0,6,65),(0,6,74),UnicodeCategory::OtherLetter),
  ((0,6,75),(0,6,95),UnicodeCategory::NonspacingMark),
  ((0,6,96),(0,6,105),UnicodeCategory::DecimalNumber),
  ((0,6,106),(0,6,109),UnicodeCategory::OtherPunctuation),
  ((0,6,110),(0,6,111),UnicodeCategory::OtherLetter),
  ((0,6,112),(0,6,112),UnicodeCategory::NonspacingMark),
  ((0,6,113),(0,6,211),UnicodeCategory::OtherLetter),
  ((0,6,212),(0,6,212),UnicodeCategory::OtherPunctuation),
  ((0,6,213),(0,6,213),UnicodeCategory::OtherLetter),
  ((0,6,214),(0,6,220),UnicodeCategory::NonspacingMark),
  ((0,6,221),(0,6,221),UnicodeCategory::Format),
  ((0,6,222),(0,6,222),UnicodeCategory::OtherSymbol),
  ((0,6,223),(0,6,228),UnicodeCategory::NonspacingMark),
  ((0,6,229),(0,6,230),UnicodeCategory::ModifierLetter),
  ((0,6,231),(0,6,232),UnicodeCategory::NonspacingMark),
  ((0,6,233),(0,6,233),UnicodeCategory::OtherSymbol),
  ((0,6,234),(0,6,237),UnicodeCategory::NonspacingMark),
  ((0,6,238),(0,6,239),UnicodeCategory::OtherLetter),
  ((0,6,240),(0,6,249),UnicodeCategory::DecimalNumber),
  ((0,6,250),(0,6,252),UnicodeCategory::OtherLetter),
  ((0,6,253),(0,6,254),UnicodeCategory::OtherSymbol),
  ((0,6,255),(0,6,255),UnicodeCategory::OtherLetter),
  ((0,7,0),(0,7,13),UnicodeCategory::OtherPunctuation),
  ((0,7,15),(0,7,15),UnicodeCategory::Format),
  ((0,7,16),(0,7,16),UnicodeCategory::OtherLetter),
  ((0,7,17),(0,7,17),UnicodeCategory::NonspacingMark),
  ((0,7,18),(0,7,47),UnicodeCategory::OtherLetter),
  ((0,7,48),(0,7,74),UnicodeCategory::NonspacingMark),
  ((0,7,77),(0,7,165),UnicodeCategory::OtherLetter),
  ((0,7,166),(0,7,176),UnicodeCategory::NonspacingMark),
  ((0,7,177),(0,7,177),UnicodeCategory::OtherLetter),
  ((0,7,192),(0,7,201),UnicodeCategory::DecimalNumber),
  ((0,7,202),(0,7,234),UnicodeCategory::OtherLetter),
  ((0,7,235),(0,7,243),UnicodeCategory::NonspacingMark),
  ((0,7,244),(0,7,245),UnicodeCategory::ModifierLetter),
  ((0,7,246),(0,7,246),UnicodeCategory::OtherSymbol),
  ((0,7,247),(0,7,249),UnicodeCategory::OtherPunctuation),
  ((0,7,250),(0,7,250),UnicodeCategory::ModifierLetter),
  ((0,8,0),(0,8,21),UnicodeCategory::OtherLetter),
  ((0,8,22),(0,8,25),UnicodeCategory::NonspacingMark),
  ((0,8,26),(0,8,26),UnicodeCategory::ModifierLetter),
  ((0,8,27),(0,8,35),UnicodeCategory::NonspacingMark),
  ((0,8,36),(0,8,36),UnicodeCategory::ModifierLetter),
  ((0,8,37),(0,8,39),UnicodeCategory::NonspacingMark),
  ((0,8,40),(0,8,40),UnicodeCategory::ModifierLetter),
  ((0,8,41),(0,8,45),UnicodeCategory::NonspacingMark),
  ((0,8,48),(0,8,62),UnicodeCategory::OtherPunctuation),
  ((0,8,64),(0,8,88),UnicodeCategory::OtherLetter),
  ((0,8,89),(0,8,91),UnicodeCategory::NonspacingMark),
  ((0,8,94),(0,8,94),UnicodeCategory::OtherPunctuation),
  ((0,8,160),(0,8,180),UnicodeCategory::OtherLetter),
  ((0,8,182),(0,8,189),UnicodeCategory::OtherLetter),
  ((0,8,212),(0,8,225),UnicodeCategory::NonspacingMark),
  ((0,8,226),(0,8,226),UnicodeCategory::Format),
  ((0,8,227),(0,9,2),UnicodeCategory::NonspacingMark),
  ((0,9,3),(0,9,3),UnicodeCategory::SpacingMark),
  ((0,9,4),(0,9,57),UnicodeCategory::OtherLetter),
  ((0,9,58),(0,9,58),UnicodeCategory::NonspacingMark),
  ((0,9,59),(0,9,59),UnicodeCategory::SpacingMark),
  ((0,9,60),(0,9,60),UnicodeCategory::NonspacingMark),
  ((0,9,61),(0,9,61),UnicodeCategory::OtherLetter),
  ((0,9,62),(0,9,64),UnicodeCategory::SpacingMark),
  ((0,9,65),(0,9,72),UnicodeCategory::NonspacingMark),
  ((0,9,73),(0,9,76),UnicodeCategory::SpacingMark),
  ((0,9,77),(0,9,77),UnicodeCategory::NonspacingMark),
  ((0,9,78),(0,9,79),UnicodeCategory::SpacingMark),
  ((0,9,80),(0,9,80),UnicodeCategory::OtherLetter),
  ((0,9,81),(0,9,87),UnicodeCategory::NonspacingMark),
  ((0,9,88),(0,9,97),UnicodeCategory::OtherLetter),
  ((0,9,98),(0,9,99),UnicodeCategory::NonspacingMark),
  ((0,9,100),(0,9,101),UnicodeCategory::OtherPunctuation),
  ((0,9,102),(0,9,111),UnicodeCategory::DecimalNumber),
  ((0,9,112),(0,9,112),UnicodeCategory::OtherPunctuation),
  ((0,9,113),(0,9,113),UnicodeCategory::ModifierLetter),
  ((0,9,114),(0,9,128),UnicodeCategory::OtherLetter),
  ((0,9,129),(0,9,129),UnicodeCategory::NonspacingMark),
  ((0,9,130),(0,9,131),UnicodeCategory::SpacingMark),
  ((0,9,133),(0,9,140),UnicodeCategory::OtherLetter),
  ((0,9,143),(0,9,144),UnicodeCategory::OtherLetter),
  ((0,9,147),(0,9,168),UnicodeCategory::OtherLetter),
  ((0,9,170),(0,9,176),UnicodeCategory::OtherLetter),
  ((0,9,178),(0,9,178),UnicodeCategory::OtherLetter),
  ((0,9,182),(0,9,185),UnicodeCategory::OtherLetter),
  ((0,9,188),(0,9,188),UnicodeCategory::NonspacingMark),
  ((0,9,189),(0,9,189),UnicodeCategory::OtherLetter),
  ((0,9,190),(0,9,192),UnicodeCategory::SpacingMark),
  ((0,9,193),(0,9,196),UnicodeCategory::NonspacingMark),
  ((0,9,199),(0,9,200),UnicodeCategory::SpacingMark),
  ((0,9,203),(0,9,204),UnicodeCategory::SpacingMark),
  ((0,9,205),(0,9,205),UnicodeCategory::NonspacingMark),
  ((0,9,206),(0,9,206),UnicodeCategory::OtherLetter),
  ((0,9,215),(0,9,215),UnicodeCategory::SpacingMark),
  ((0,9,220),(0,9,221),UnicodeCategory::OtherLetter),
  ((0,9,223),(0,9,225),UnicodeCategory::OtherLetter),
  ((0,9,226),(0,9,227),UnicodeCategory::NonspacingMark),
  ((0,9,230),(0,9,239),UnicodeCategory::DecimalNumber),
  ((0,9,240),(0,9,241),UnicodeCategory::OtherLetter),
  ((0,9,242),(0,9,243),UnicodeCategory::CurrencySymbol),
  ((0,9,244),(0,9,249),UnicodeCategory::OtherNumber),
  ((0,9,250),(0,9,250),UnicodeCategory::OtherSymbol),
  ((0,9,251),(0,9,251),UnicodeCategory::CurrencySymbol),
  ((0,10,1),(0,10,2),UnicodeCategory::NonspacingMark),
  ((0,10,3),(0,10,3),UnicodeCategory::SpacingMark),
  ((0,10,5),(0,10,10),UnicodeCategory::OtherLetter),
  ((0,10,15),(0,10,16),UnicodeCategory::OtherLetter),
  ((0,10,19),(0,10,40),UnicodeCategory::OtherLetter),
  ((0,10,42),(0,10,48),UnicodeCategory::OtherLetter),
  ((0,10,50),(0,10,51),UnicodeCategory::OtherLetter),
  ((0,10,53),(0,10,54),UnicodeCategory::OtherLetter),
  ((0,10,56),(0,10,57),UnicodeCategory::OtherLetter),
  ((0,10,60),(0,10,60),UnicodeCategory::NonspacingMark),
  ((0,10,62),(0,10,64),UnicodeCategory::SpacingMark),
  ((0,10,65),(0,10,66),UnicodeCategory::NonspacingMark),
  ((0,10,71),(0,10,72),UnicodeCategory::NonspacingMark),
  ((0,10,75),(0,10,77),UnicodeCategory::NonspacingMark),
  ((0,10,81),(0,10,81),UnicodeCategory::NonspacingMark),
  ((0,10,89),(0,10,92),UnicodeCategory::OtherLetter),
  ((0,10,94),(0,10,94),UnicodeCategory::OtherLetter),
  ((0,10,102),(0,10,111),UnicodeCategory::DecimalNumber),
  ((0,10,112),(0,10,113),UnicodeCategory::NonspacingMark),
  ((0,10,114),(0,10,116),UnicodeCategory::OtherLetter),
  ((0,10,117),(0,10,117),UnicodeCategory::NonspacingMark),
  ((0,10,129),(0,10,130),UnicodeCategory::NonspacingMark),
  ((0,10,131),(0,10,131),UnicodeCategory::SpacingMark),
  ((0,10,133),(0,10,141),UnicodeCategory::OtherLetter),
  ((0,10,143),(0,10,145),UnicodeCategory::OtherLetter),
  ((0,10,147),(0,10,168),UnicodeCategory::OtherLetter),
  ((0,10,170),(0,10,176),UnicodeCategory::OtherLetter),
  ((0,10,178),(0,10,179),UnicodeCategory::OtherLetter),
  ((0,10,181),(0,10,185),UnicodeCategory::OtherLetter),
  ((0,10,188),(0,10,188),UnicodeCategory::NonspacingMark),
  ((0,10,189),(0,10,189),UnicodeCategory::OtherLetter),
  ((0,10,190),(0,10,192),UnicodeCategory::SpacingMark),
  ((0,10,193),(0,10,197),UnicodeCategory::NonspacingMark),
  ((0,10,199),(0,10,200),UnicodeCategory::NonspacingMark),
  ((0,10,201),(0,10,201),UnicodeCategory::SpacingMark),
  ((0,10,203),(0,10,204),UnicodeCategory::SpacingMark),
  ((0,10,205),(0,10,205),UnicodeCategory::NonspacingMark),
  ((0,10,208),(0,10,208),UnicodeCategory::OtherLetter),
  ((0,10,224),(0,10,225),UnicodeCategory::OtherLetter),
  ((0,10,226),(0,10,227),UnicodeCategory::NonspacingMark),
  ((0,10,230),(0,10,239),UnicodeCategory::DecimalNumber),
  ((0,10,240),(0,10,240),UnicodeCategory::OtherPunctuation),
  ((0,10,241),(0,10,241),UnicodeCategory::CurrencySymbol),
  ((0,10,249),(0,10,249),UnicodeCategory::OtherLetter),
  ((0,11,1),(0,11,1),UnicodeCategory::NonspacingMark),
  ((0,11,2),(0,11,3),UnicodeCategory::SpacingMark),
  ((0,11,5),(0,11,12),UnicodeCategory::OtherLetter),
  ((0,11,15),(0,11,16),UnicodeCategory::OtherLetter),
  ((0,11,19),(0,11,40),UnicodeCategory::OtherLetter),
  ((0,11,42),(0,11,48),UnicodeCategory::OtherLetter),
  ((0,11,50),(0,11,51),UnicodeCategory::OtherLetter),
  ((0,11,53),(0,11,57),UnicodeCategory::OtherLetter),
  ((0,11,60),(0,11,60),UnicodeCategory::NonspacingMark),
  ((0,11,61),(0,11,61),UnicodeCategory::OtherLetter),
  ((0,11,62),(0,11,62),UnicodeCategory::SpacingMark),
  ((0,11,63),(0,11,63),UnicodeCategory::NonspacingMark),
  ((0,11,64),(0,11,64),UnicodeCategory::SpacingMark),
  ((0,11,65),(0,11,68),UnicodeCategory::NonspacingMark),
  ((0,11,71),(0,11,72),UnicodeCategory::SpacingMark),
  ((0,11,75),(0,11,76),UnicodeCategory::SpacingMark),
  ((0,11,77),(0,11,77),UnicodeCategory::NonspacingMark),
  ((0,11,86),(0,11,86),UnicodeCategory::NonspacingMark),
  ((0,11,87),(0,11,87),UnicodeCategory::SpacingMark),
  ((0,11,92),(0,11,93),UnicodeCategory::OtherLetter),
  ((0,11,95),(0,11,97),UnicodeCategory::OtherLetter),
  ((0,11,98),(0,11,99),UnicodeCategory::NonspacingMark),
  ((0,11,102),(0,11,111),UnicodeCategory::DecimalNumber),
  ((0,11,112),(0,11,112),UnicodeCategory::OtherSymbol),
  ((0,11,113),(0,11,113),UnicodeCategory::OtherLetter),
  ((0,11,114),(0,11,119),UnicodeCategory::OtherNumber),
  ((0,11,130),(0,11,130),UnicodeCategory::NonspacingMark),
  ((0,11,131),(0,11,131),UnicodeCategory::OtherLetter),
  ((0,11,133),(0,11,138),UnicodeCategory::OtherLetter),
  ((0,11,142),(0,11,144),UnicodeCategory::OtherLetter),
  ((0,11,146),(0,11,149),UnicodeCategory::OtherLetter),
  ((0,11,153),(0,11,154),UnicodeCategory::OtherLetter),
  ((0,11,156),(0,11,156),UnicodeCategory::OtherLetter),
  ((0,11,158),(0,11,159),UnicodeCategory::OtherLetter),
  ((0,11,163),(0,11,164),UnicodeCategory::OtherLetter),
  ((0,11,168),(0,11,170),UnicodeCategory::OtherLetter),
  ((0,11,174),(0,11,185),UnicodeCategory::OtherLetter),
  ((0,11,190),(0,11,191),UnicodeCategory::SpacingMark),
  ((0,11,192),(0,11,192),UnicodeCategory::NonspacingMark),
  ((0,11,193),(0,11,194),UnicodeCategory::SpacingMark),
  ((0,11,198),(0,11,200),UnicodeCategory::SpacingMark),
  ((0,11,202),(0,11,204),UnicodeCategory::SpacingMark),
  ((0,11,205),(0,11,205),UnicodeCategory::NonspacingMark),
  ((0,11,208),(0,11,208),UnicodeCategory::OtherLetter),
  ((0,11,215),(0,11,215),UnicodeCategory::SpacingMark),
  ((0,11,230),(0,11,239),UnicodeCategory::DecimalNumber),
  ((0,11,240),(0,11,242),UnicodeCategory::OtherNumber),
  ((0,11,243),(0,11,248),UnicodeCategory::OtherSymbol),
  ((0,11,249),(0,11,249),UnicodeCategory::CurrencySymbol),
  ((0,11,250),(0,11,250),UnicodeCategory::OtherSymbol),
  ((0,12,0),(0,12,0),UnicodeCategory::NonspacingMark),
  ((0,12,1),(0,12,3),UnicodeCategory::SpacingMark),
  ((0,12,5),(0,12,12),UnicodeCategory::OtherLetter),
  ((0,12,14),(0,12,16),UnicodeCategory::OtherLetter),
  ((0,12,18),(0,12,40),UnicodeCategory::OtherLetter),
  ((0,12,42),(0,12,57),UnicodeCategory::OtherLetter),
  ((0,12,61),(0,12,61),UnicodeCategory::OtherLetter),
  ((0,12,62),(0,12,64),UnicodeCategory::NonspacingMark),
  ((0,12,65),(0,12,68),UnicodeCategory::SpacingMark),
  ((0,12,70),(0,12,72),UnicodeCategory::NonspacingMark),
  ((0,12,74),(0,12,77),UnicodeCategory::NonspacingMark),
  ((0,12,85),(0,12,86),UnicodeCategory::NonspacingMark),
  ((0,12,88),(0,12,90),UnicodeCategory::OtherLetter),
  ((0,12,96),(0,12,97),UnicodeCategory::OtherLetter),
  ((0,12,98),(0,12,99),UnicodeCategory::NonspacingMark),
  ((0,12,102),(0,12,111),UnicodeCategory::DecimalNumber),
  ((0,12,120),(0,12,126),UnicodeCategory::OtherNumber),
  ((0,12,127),(0,12,127),UnicodeCategory::OtherSymbol),
  ((0,12,128),(0,12,128),UnicodeCategory::OtherLetter),
  ((0,12,129),(0,12,129),UnicodeCategory::NonspacingMark),
  ((0,12,130),(0,12,131),UnicodeCategory::SpacingMark),
  ((0,12,133),(0,12,140),UnicodeCategory::OtherLetter),
  ((0,12,142),(0,12,144),UnicodeCategory::OtherLetter),
  ((0,12,146),(0,12,168),UnicodeCategory::OtherLetter),
  ((0,12,170),(0,12,179),UnicodeCategory::OtherLetter),
  ((0,12,181),(0,12,185),UnicodeCategory::OtherLetter),
  ((0,12,188),(0,12,188),UnicodeCategory::NonspacingMark),
  ((0,12,189),(0,12,189),UnicodeCategory::OtherLetter),
  ((0,12,190),(0,12,190),UnicodeCategory::SpacingMark),
  ((0,12,191),(0,12,191),UnicodeCategory::NonspacingMark),
  ((0,12,192),(0,12,196),UnicodeCategory::SpacingMark),
  ((0,12,198),(0,12,198),UnicodeCategory::NonspacingMark),
  ((0,12,199),(0,12,200),UnicodeCategory::SpacingMark),
  ((0,12,202),(0,12,203),UnicodeCategory::SpacingMark),
  ((0,12,204),(0,12,205),UnicodeCategory::NonspacingMark),
  ((0,12,213),(0,12,214),UnicodeCategory::SpacingMark),
  ((0,12,222),(0,12,222),UnicodeCategory::OtherLetter),
  ((0,12,224),(0,12,225),UnicodeCategory::OtherLetter),
  ((0,12,226),(0,12,227),UnicodeCategory::NonspacingMark),
  ((0,12,230),(0,12,239),UnicodeCategory::DecimalNumber),
  ((0,12,241),(0,12,242),UnicodeCategory::OtherLetter),
  ((0,13,1),(0,13,1),UnicodeCategory::NonspacingMark),
  ((0,13,2),(0,13,3),UnicodeCategory::SpacingMark),
  ((0,13,5),(0,13,12),UnicodeCategory::OtherLetter),
  ((0,13,14),(0,13,16),UnicodeCategory::OtherLetter),
  ((0,13,18),(0,13,58),UnicodeCategory::OtherLetter),
  ((0,13,61),(0,13,61),UnicodeCategory::OtherLetter),
  ((0,13,62),(0,13,64),UnicodeCategory::SpacingMark),
  ((0,13,65),(0,13,68),UnicodeCategory::NonspacingMark),
  ((0,13,70),(0,13,72),UnicodeCategory::SpacingMark),
  ((0,13,74),(0,13,76),UnicodeCategory::SpacingMark),
  ((0,13,77),(0,13,77),UnicodeCategory::NonspacingMark),
  ((0,13,78),(0,13,78),UnicodeCategory::OtherLetter),
  ((0,13,79),(0,13,79),UnicodeCategory::OtherSymbol),
  ((0,13,84),(0,13,86),UnicodeCategory::OtherLetter),
  ((0,13,87),(0,13,87),UnicodeCategory::SpacingMark),
  ((0,13,88),(0,13,94),UnicodeCategory::OtherNumber),
  ((0,13,95),(0,13,97),UnicodeCategory::OtherLetter),
  ((0,13,98),(0,13,99),UnicodeCategory::NonspacingMark),
  ((0,13,102),(0,13,111),UnicodeCategory::DecimalNumber),
  ((0,13,112),(0,13,120),UnicodeCategory::OtherNumber),
  ((0,13,121),(0,13,121),UnicodeCategory::OtherSymbol),
  ((0,13,122),(0,13,127),UnicodeCategory::OtherLetter),
  ((0,13,130),(0,13,131),UnicodeCategory::SpacingMark),
  ((0,13,133),(0,13,150),UnicodeCategory::OtherLetter),
  ((0,13,154),(0,13,177),UnicodeCategory::OtherLetter),
  ((0,13,179),(0,13,187),UnicodeCategory::OtherLetter),
  ((0,13,189),(0,13,189),UnicodeCategory::OtherLetter),
  ((0,13,192),(0,13,198),UnicodeCategory::OtherLetter),
  ((0,13,202),(0,13,202),UnicodeCategory::NonspacingMark),
  ((0,13,207),(0,13,209),UnicodeCategory::SpacingMark),
  ((0,13,210),(0,13,212),UnicodeCategory::NonspacingMark),
  ((0,13,214),(0,13,214),UnicodeCategory::NonspacingMark),
  ((0,13,216),(0,13,223),UnicodeCategory::SpacingMark),
  ((0,13,230),(0,13,239),UnicodeCategory::DecimalNumber),
  ((0,13,242),(0,13,243),UnicodeCategory::SpacingMark),
  ((0,13,244),(0,13,244),UnicodeCategory::OtherPunctuation),
  ((0,14,1),(0,14,48),UnicodeCategory::OtherLetter),
  ((0,14,49),(0,14,49),UnicodeCategory::NonspacingMark),
  ((0,14,50),(0,14,51),UnicodeCategory::OtherLetter),
  ((0,14,52),(0,14,58),UnicodeCategory::NonspacingMark),
  ((0,14,63),(0,14,63),UnicodeCategory::CurrencySymbol),
  ((0,14,64),(0,14,69),UnicodeCategory::OtherLetter),
  ((0,14,70),(0,14,70),UnicodeCategory::ModifierLetter),
  ((0,14,71),(0,14,78),UnicodeCategory::NonspacingMark),
  ((0,14,79),(0,14,79),UnicodeCategory::OtherPunctuation),
  ((0,14,80),(0,14,89),UnicodeCategory::DecimalNumber),
  ((0,14,90),(0,14,91),UnicodeCategory::OtherPunctuation),
  ((0,14,129),(0,14,130),UnicodeCategory::OtherLetter),
  ((0,14,132),(0,14,132),UnicodeCategory::OtherLetter),
  ((0,14,135),(0,14,136),UnicodeCategory::OtherLetter),
  ((0,14,138),(0,14,138),UnicodeCategory::OtherLetter),
  ((0,14,141),(0,14,141),UnicodeCategory::OtherLetter),
  ((0,14,148),(0,14,151),UnicodeCategory::OtherLetter),
  ((0,14,153),(0,14,159),UnicodeCategory::OtherLetter),
  ((0,14,161),(0,14,163),UnicodeCategory::OtherLetter),
  ((0,14,165),(0,14,165),UnicodeCategory::OtherLetter),
  ((0,14,167),(0,14,167),UnicodeCategory::OtherLetter),
  ((0,14,170),(0,14,171),UnicodeCategory::OtherLetter),
  ((0,14,173),(0,14,176),UnicodeCategory::OtherLetter),
  ((0,14,177),(0,14,177),UnicodeCategory::NonspacingMark),
  ((0,14,178),(0,14,179),UnicodeCategory::OtherLetter),
  ((0,14,180),(0,14,185),UnicodeCategory::NonspacingMark),
  ((0,14,187),(0,14,188),UnicodeCategory::NonspacingMark),
  ((0,14,189),(0,14,189),UnicodeCategory::OtherLetter),
  ((0,14,192),(0,14,196),UnicodeCategory::OtherLetter),
  ((0,14,198),(0,14,198),UnicodeCategory::ModifierLetter),
  ((0,14,200),(0,14,205),UnicodeCategory::NonspacingMark),
  ((0,14,208),(0,14,217),UnicodeCategory::DecimalNumber),
  ((0,14,220),(0,14,223),UnicodeCategory::OtherLetter),
  ((0,15,0),(0,15,0),UnicodeCategory::OtherLetter),
  ((0,15,1),(0,15,3),UnicodeCategory::OtherSymbol),
  ((0,15,4),(0,15,18),UnicodeCategory::OtherPunctuation),
  ((0,15,19),(0,15,19),UnicodeCategory::OtherSymbol),
  ((0,15,20),(0,15,20),UnicodeCategory::OtherPunctuation),
  ((0,15,21),(0,15,23),UnicodeCategory::OtherSymbol),
  ((0,15,24),(0,15,25),UnicodeCategory::NonspacingMark),
  ((0,15,26),(0,15,31),UnicodeCategory::OtherSymbol),
  ((0,15,32),(0,15,41),UnicodeCategory::DecimalNumber),
  ((0,15,42),(0,15,51),UnicodeCategory::OtherNumber),
  ((0,15,52),(0,15,52),UnicodeCategory::OtherSymbol),
  ((0,15,53),(0,15,53),UnicodeCategory::NonspacingMark),
  ((0,15,54),(0,15,54),UnicodeCategory::OtherSymbol),
  ((0,15,55),(0,15,55),UnicodeCategory::NonspacingMark),
  ((0,15,56),(0,15,56),UnicodeCategory::OtherSymbol),
  ((0,15,57),(0,15,57),UnicodeCategory::NonspacingMark),
  ((0,15,58),(0,15,58),UnicodeCategory::OpenPunctuation),
  ((0,15,59),(0,15,59),UnicodeCategory::ClosePunctuation),
  ((0,15,60),(0,15,60),UnicodeCategory::OpenPunctuation),
  ((0,15,61),(0,15,61),UnicodeCategory::ClosePunctuation),
  ((0,15,62),(0,15,63),UnicodeCategory::SpacingMark),
  ((0,15,64),(0,15,71),UnicodeCategory::OtherLetter),
  ((0,15,73),(0,15,108),UnicodeCategory::OtherLetter),
  ((0,15,113),(0,15,126),UnicodeCategory::NonspacingMark),
  ((0,15,127),(0,15,127),UnicodeCategory::SpacingMark),
  ((0,15,128),(0,15,132),UnicodeCategory::NonspacingMark),
  ((0,15,133),(0,15,133),UnicodeCategory::OtherPunctuation),
  ((0,15,134),(0,15,135),UnicodeCategory::NonspacingMark),
  ((0,15,136),(0,15,140),UnicodeCategory::OtherLetter),
  ((0,15,141),(0,15,151),UnicodeCategory::NonspacingMark),
  ((0,15,153),(0,15,188),UnicodeCategory::NonspacingMark),
  ((0,15,190),(0,15,197),UnicodeCategory::OtherSymbol),
  ((0,15,198),(0,15,198),UnicodeCategory::NonspacingMark),
  ((0,15,199),(0,15,204),UnicodeCategory::OtherSymbol),
  ((0,15,206),(0,15,207),UnicodeCategory::OtherSymbol),
  ((0,15,208),(0,15,212),UnicodeCategory::OtherPunctuation),
  ((0,15,213),(0,15,216),UnicodeCategory::OtherSymbol),
  ((0,15,217),(0,15,218),UnicodeCategory::OtherPunctuation),
  ((0,16,0),(0,16,42),UnicodeCategory::OtherLetter),
  ((0,16,43),(0,16,44),UnicodeCategory::SpacingMark),
  ((0,16,45),(0,16,48),UnicodeCategory::NonspacingMark),
  ((0,16,49),(0,16,49),UnicodeCategory::SpacingMark),
  ((0,16,50),(0,16,55),UnicodeCategory::NonspacingMark),
  ((0,16,56),(0,16,56),UnicodeCategory::SpacingMark),
  ((0,16,57),(0,16,58),UnicodeCategory::NonspacingMark),
  ((0,16,59),(0,16,60),UnicodeCategory::SpacingMark),
  ((0,16,61),(0,16,62),UnicodeCategory::NonspacingMark),
  ((0,16,63),(0,16,63),UnicodeCategory::OtherLetter),
  ((0,16,64),(0,16,73),UnicodeCategory::DecimalNumber),
  ((0,16,74),(0,16,79),UnicodeCategory::OtherPunctuation),
  ((0,16,80),(0,16,85),UnicodeCategory::OtherLetter),
  ((0,16,86),(0,16,87),UnicodeCategory::SpacingMark),
  ((0,16,88),(0,16,89),UnicodeCategory::NonspacingMark),
  ((0,16,90),(0,16,93),UnicodeCategory::OtherLetter),
  ((0,16,94),(0,16,96),UnicodeCategory::NonspacingMark),
  ((0,16,97),(0,16,97),UnicodeCategory::OtherLetter),
  ((0,16,98),(0,16,100),UnicodeCategory::SpacingMark),
  ((0,16,101),(0,16,102),UnicodeCategory::OtherLetter),
  ((0,16,103),(0,16,109),UnicodeCategory::SpacingMark),
  ((0,16,110),(0,16,112),UnicodeCategory::OtherLetter),
  ((0,16,113),(0,16,116),UnicodeCategory::NonspacingMark),
  ((0,16,117),(0,16,129),UnicodeCategory::OtherLetter),
  ((0,16,130),(0,16,130),UnicodeCategory::NonspacingMark),
  ((0,16,131),(0,16,132),UnicodeCategory::SpacingMark),
  ((0,16,133),(0,16,134),UnicodeCategory::NonspacingMark),
  ((0,16,135),(0,16,140),UnicodeCategory::SpacingMark),
  ((0,16,141),(0,16,141),UnicodeCategory::NonspacingMark),
  ((0,16,142),(0,16,142),UnicodeCategory::OtherLetter),
  ((0,16,143),(0,16,143),UnicodeCategory::SpacingMark),
  ((0,16,144),(0,16,153),UnicodeCategory::DecimalNumber),
  ((0,16,154),(0,16,156),UnicodeCategory::SpacingMark),
  ((0,16,157),(0,16,157),UnicodeCategory::NonspacingMark),
  ((0,16,158),(0,16,159),UnicodeCategory::OtherSymbol),
  ((0,16,160),(0,16,197),UnicodeCategory::UppercaseLetter),
  ((0,16,199),(0,16,199),UnicodeCategory::UppercaseLetter),
  ((0,16,205),(0,16,205),UnicodeCategory::UppercaseLetter),
  ((0,16,208),(0,16,250),UnicodeCategory::OtherLetter),
  ((0,16,251),(0,16,251),UnicodeCategory::OtherPunctuation),
  ((0,16,252),(0,16,252),UnicodeCategory::ModifierLetter),
  ((0,16,253),(0,18,72),UnicodeCategory::OtherLetter),
  ((0,18,74),(0,18,77),UnicodeCategory::OtherLetter),
  ((0,18,80),(0,18,86),UnicodeCategory::OtherLetter),
  ((0,18,88),(0,18,88),UnicodeCategory::OtherLetter),
  ((0,18,90),(0,18,93),UnicodeCategory::OtherLetter),
  ((0,18,96),(0,18,136),UnicodeCategory::OtherLetter),
  ((0,18,138),(0,18,141),UnicodeCategory::OtherLetter),
  ((0,18,144),(0,18,176),UnicodeCategory::OtherLetter),
  ((0,18,178),(0,18,181),UnicodeCategory::OtherLetter),
  ((0,18,184),(0,18,190),UnicodeCategory::OtherLetter),
  ((0,18,192),(0,18,192),UnicodeCategory::OtherLetter),
  ((0,18,194),(0,18,197),UnicodeCategory::OtherLetter),
  ((0,18,200),(0,18,214),UnicodeCategory::OtherLetter),
  ((0,18,216),(0,19,16),UnicodeCategory::OtherLetter),
  ((0,19,18),(0,19,21),UnicodeCategory::OtherLetter),
  ((0,19,24),(0,19,90),UnicodeCategory::OtherLetter),
  ((0,19,93),(0,19,95),UnicodeCategory::NonspacingMark),
  ((0,19,96),(0,19,104),UnicodeCategory::OtherPunctuation),
  ((0,19,105),(0,19,124),UnicodeCategory::OtherNumber),
  ((0,19,128),(0,19,143),UnicodeCategory::OtherLetter),
  ((0,19,144),(0,19,153),UnicodeCategory::OtherSymbol),
  ((0,19,160),(0,19,245),UnicodeCategory::UppercaseLetter),
  ((0,19,248),(0,19,253),UnicodeCategory::LowercaseLetter),
  ((0,20,0),(0,20,0),UnicodeCategory::DashPunctuation),
  ((0,20,1),(0,22,108),UnicodeCategory::OtherLetter),
  ((0,22,109),(0,22,110),UnicodeCategory::OtherPunctuation),
  ((0,22,111),(0,22,127),UnicodeCategory::OtherLetter),
  ((0,22,128),(0,22,128),UnicodeCategory::SpaceSeparator),
  ((0,22,129),(0,22,154),UnicodeCategory::OtherLetter),
  ((0,22,155),(0,22,155),UnicodeCategory::OpenPunctuation),
  ((0,22,156),(0,22,156),UnicodeCategory::ClosePunctuation),
  ((0,22,160),(0,22,234),UnicodeCategory::OtherLetter),
  ((0,22,235),(0,22,237),UnicodeCategory::OtherPunctuation),
  ((0,22,238),(0,22,240),UnicodeCategory::LetterNumber),
  ((0,22,241),(0,22,248),UnicodeCategory::OtherLetter),
  ((0,23,0),(0,23,12),UnicodeCategory::OtherLetter),
  ((0,23,14),(0,23,17),UnicodeCategory::OtherLetter),
  ((0,23,18),(0,23,20),UnicodeCategory::NonspacingMark),
  ((0,23,32),(0,23,49),UnicodeCategory::OtherLetter),
  ((0,23,50),(0,23,52),UnicodeCategory::NonspacingMark),
  ((0,23,53),(0,23,54),UnicodeCategory::OtherPunctuation),
  ((0,23,64),(0,23,81),UnicodeCategory::OtherLetter),
  ((0,23,82),(0,23,83),UnicodeCategory::NonspacingMark),
  ((0,23,96),(0,23,108),UnicodeCategory::OtherLetter),
  ((0,23,110),(0,23,112),UnicodeCategory::OtherLetter),
  ((0,23,114),(0,23,115),UnicodeCategory::NonspacingMark),
  ((0,23,128),(0,23,179),UnicodeCategory::OtherLetter),
  ((0,23,180),(0,23,181),UnicodeCategory::NonspacingMark),
  ((0,23,182),(0,23,182),UnicodeCategory::SpacingMark),
  ((0,23,183),(0,23,189),UnicodeCategory::NonspacingMark),
  ((0,23,190),(0,23,197),UnicodeCategory::SpacingMark),
  ((0,23,198),(0,23,198),UnicodeCategory::NonspacingMark),
  ((0,23,199),(0,23,200),UnicodeCategory::SpacingMark),
  ((0,23,201),(0,23,211),UnicodeCategory::NonspacingMark),
  ((0,23,212),(0,23,214),UnicodeCategory::OtherPunctuation),
  ((0,23,215),(0,23,215),UnicodeCategory::ModifierLetter),
  ((0,23,216),(0,23,218),UnicodeCategory::OtherPunctuation),
  ((0,23,219),(0,23,219),UnicodeCategory::CurrencySymbol),
  ((0,23,220),(0,23,220),UnicodeCategory::OtherLetter),
  ((0,23,221),(0,23,221),UnicodeCategory::NonspacingMark),
  ((0,23,224),(0,23,233),UnicodeCategory::DecimalNumber),
  ((0,23,240),(0,23,249),UnicodeCategory::OtherNumber),
  ((0,24,0),(0,24,5),UnicodeCategory::OtherPunctuation),
  ((0,24,6),(0,24,6),UnicodeCategory::DashPunctuation),
  ((0,24,7),(0,24,10),UnicodeCategory::OtherPunctuation),
  ((0,24,11),(0,24,13),UnicodeCategory::NonspacingMark),
  ((0,24,14),(0,24,14),UnicodeCategory::Format),
  ((0,24,16),(0,24,25),UnicodeCategory::DecimalNumber),
  ((0,24,32),(0,24,66),UnicodeCategory::OtherLetter),
  ((0,24,67),(0,24,67),UnicodeCategory::ModifierLetter),
  ((0,24,68),(0,24,119),UnicodeCategory::OtherLetter),
  ((0,24,128),(0,24,132),UnicodeCategory::OtherLetter),
  ((0,24,133),(0,24,134),UnicodeCategory::NonspacingMark),
  ((0,24,135),(0,24,168),UnicodeCategory::OtherLetter),
  ((0,24,169),(0,24,169),UnicodeCategory::NonspacingMark),
  ((0,24,170),(0,24,170),UnicodeCategory::OtherLetter),
  ((0,24,176),(0,24,245),UnicodeCategory::OtherLetter),
  ((0,25,0),(0,25,30),UnicodeCategory::OtherLetter),
  ((0,25,32),(0,25,34),UnicodeCategory::NonspacingMark),
  ((0,25,35),(0,25,38),UnicodeCategory::SpacingMark),
  ((0,25,39),(0,25,40),UnicodeCategory::NonspacingMark),
  ((0,25,41),(0,25,43),UnicodeCategory::SpacingMark),
  ((0,25,48),(0,25,49),UnicodeCategory::SpacingMark),
  ((0,25,50),(0,25,50),UnicodeCategory::NonspacingMark),
  ((0,25,51),(0,25,56),UnicodeCategory::SpacingMark),
  ((0,25,57),(0,25,59),UnicodeCategory::NonspacingMark),
  ((0,25,64),(0,25,64),UnicodeCategory::OtherSymbol),
  ((0,25,68),(0,25,69),UnicodeCategory::OtherPunctuation),
  ((0,25,70),(0,25,79),UnicodeCategory::DecimalNumber),
  ((0,25,80),(0,25,109),UnicodeCategory::OtherLetter),
  ((0,25,112),(0,25,116),UnicodeCategory::OtherLetter),
  ((0,25,128),(0,25,171),UnicodeCategory::OtherLetter),
  ((0,25,176),(0,25,201),UnicodeCategory::OtherLetter),
  ((0,25,208),(0,25,217),UnicodeCategory::DecimalNumber),
  ((0,25,218),(0,25,218),UnicodeCategory::OtherNumber),
  ((0,25,222),(0,25,255),UnicodeCategory::OtherSymbol),
  ((0,26,0),(0,26,22),UnicodeCategory::OtherLetter),
  ((0,26,23),(0,26,24),UnicodeCategory::NonspacingMark),
  ((0,26,25),(0,26,26),UnicodeCategory::SpacingMark),
  ((0,26,27),(0,26,27),UnicodeCategory::NonspacingMark),
  ((0,26,30),(0,26,31),UnicodeCategory::OtherPunctuation),
  ((0,26,32),(0,26,84),UnicodeCategory::OtherLetter),
  ((0,26,85),(0,26,85),UnicodeCategory::SpacingMark),
  ((0,26,86),(0,26,86),UnicodeCategory::NonspacingMark),
  ((0,26,87),(0,26,87),UnicodeCategory::SpacingMark),
  ((0,26,88),(0,26,94),UnicodeCategory::NonspacingMark),
  ((0,26,96),(0,26,96),UnicodeCategory::NonspacingMark),
  ((0,26,97),(0,26,97),UnicodeCategory::SpacingMark),
  ((0,26,98),(0,26,98),UnicodeCategory::NonspacingMark),
  ((0,26,99),(0,26,100),UnicodeCategory::SpacingMark),
  ((0,26,101),(0,26,108),UnicodeCategory::NonspacingMark),
  ((0,26,109),(0,26,114),UnicodeCategory::SpacingMark),
  ((0,26,115),(0,26,124),UnicodeCategory::NonspacingMark),
  ((0,26,127),(0,26,127),UnicodeCategory::NonspacingMark),
  ((0,26,128),(0,26,137),UnicodeCategory::DecimalNumber),
  ((0,26,144),(0,26,153),UnicodeCategory::DecimalNumber),
  ((0,26,160),(0,26,166),UnicodeCategory::OtherPunctuation),
  ((0,26,167),(0,26,167),UnicodeCategory::ModifierLetter),
  ((0,26,168),(0,26,173),UnicodeCategory::OtherPunctuation),
  ((0,26,176),(0,26,189),UnicodeCategory::NonspacingMark),
  ((0,26,190),(0,26,190),UnicodeCategory::EnclosingMark),
  ((0,27,0),(0,27,3),UnicodeCategory::NonspacingMark),
  ((0,27,4),(0,27,4),UnicodeCategory::SpacingMark),
  ((0,27,5),(0,27,51),UnicodeCategory::OtherLetter),
  ((0,27,52),(0,27,52),UnicodeCategory::NonspacingMark),
  ((0,27,53),(0,27,53),UnicodeCategory::SpacingMark),
  ((0,27,54),(0,27,58),UnicodeCategory::NonspacingMark),
  ((0,27,59),(0,27,59),UnicodeCategory::SpacingMark),
  ((0,27,60),(0,27,60),UnicodeCategory::NonspacingMark),
  ((0,27,61),(0,27,65),UnicodeCategory::SpacingMark),
  ((0,27,66),(0,27,66),UnicodeCategory::NonspacingMark),
  ((0,27,67),(0,27,68),UnicodeCategory::SpacingMark),
  ((0,27,69),(0,27,75),UnicodeCategory::OtherLetter),
  ((0,27,80),(0,27,89),UnicodeCategory::DecimalNumber),
  ((0,27,90),(0,27,96),UnicodeCategory::OtherPunctuation),
  ((0,27,97),(0,27,106),UnicodeCategory::OtherSymbol),
  ((0,27,107),(0,27,115),UnicodeCategory::NonspacingMark),
  ((0,27,116),(0,27,124),UnicodeCategory::OtherSymbol),
  ((0,27,128),(0,27,129),UnicodeCategory::NonspacingMark),
  ((0,27,130),(0,27,130),UnicodeCategory::SpacingMark),
  ((0,27,131),(0,27,160),UnicodeCategory::OtherLetter),
  ((0,27,161),(0,27,161),UnicodeCategory::SpacingMark),
  ((0,27,162),(0,27,165),UnicodeCategory::NonspacingMark),
  ((0,27,166),(0,27,167),UnicodeCategory::SpacingMark),
  ((0,27,168),(0,27,169),UnicodeCategory::NonspacingMark),
  ((0,27,170),(0,27,170),UnicodeCategory::SpacingMark),
  ((0,27,171),(0,27,173),UnicodeCategory::NonspacingMark),
  ((0,27,174),(0,27,175),UnicodeCategory::OtherLetter),
  ((0,27,176),(0,27,185),UnicodeCategory::DecimalNumber),
  ((0,27,186),(0,27,229),UnicodeCategory::OtherLetter),
  ((0,27,230),(0,27,230),UnicodeCategory::NonspacingMark),
  ((0,27,231),(0,27,231),UnicodeCategory::SpacingMark),
  ((0,27,232),(0,27,233),UnicodeCategory::NonspacingMark),
  ((0,27,234),(0,27,236),UnicodeCategory::SpacingMark),
  ((0,27,237),(0,27,237),UnicodeCategory::NonspacingMark),
  ((0,27,238),(0,27,238),UnicodeCategory::SpacingMark),
  ((0,27,239),(0,27,241),UnicodeCategory::NonspacingMark),
  ((0,27,242),(0,27,243),UnicodeCategory::SpacingMark),
  ((0,27,252),(0,27,255),UnicodeCategory::OtherPunctuation),
  ((0,28,0),(0,28,35),UnicodeCategory::OtherLetter),
  ((0,28,36),(0,28,43),UnicodeCategory::SpacingMark),
  ((0,28,44),(0,28,51),UnicodeCategory::NonspacingMark),
  ((0,28,52),(0,28,53),UnicodeCategory::SpacingMark),
  ((0,28,54),(0,28,55),UnicodeCategory::NonspacingMark),
  ((0,28,59),(0,28,63),UnicodeCategory::OtherPunctuation),
  ((0,28,64),(0,28,73),UnicodeCategory::DecimalNumber),
  ((0,28,77),(0,28,79),UnicodeCategory::OtherLetter),
  ((0,28,80),(0,28,89),UnicodeCategory::DecimalNumber),
  ((0,28,90),(0,28,119),UnicodeCategory::OtherLetter),
  ((0,28,120),(0,28,125),UnicodeCategory::ModifierLetter),
  ((0,28,126),(0,28,127),UnicodeCategory::OtherPunctuation),
  ((0,28,128),(0,28,136),UnicodeCategory::LowercaseLetter),
  ((0,28,192),(0,28,199),UnicodeCategory::OtherPunctuation),
  ((0,28,208),(0,28,210),UnicodeCategory::NonspacingMark),
  ((0,28,211),(0,28,211),UnicodeCategory::OtherPunctuation),
  ((0,28,212),(0,28,224),UnicodeCategory::NonspacingMark),
  ((0,28,225),(0,28,225),UnicodeCategory::SpacingMark),
  ((0,28,226),(0,28,232),UnicodeCategory::NonspacingMark),
  ((0,28,233),(0,28,236),UnicodeCategory::OtherLetter),
  ((0,28,237),(0,28,237),UnicodeCategory::NonspacingMark),
  ((0,28,238),(0,28,241),UnicodeCategory::OtherLetter),
  ((0,28,242),(0,28,243),UnicodeCategory::SpacingMark),
  ((0,28,244),(0,28,244),UnicodeCategory::NonspacingMark),
  ((0,28,245),(0,28,246),UnicodeCategory::OtherLetter),
  ((0,28,248),(0,28,249),UnicodeCategory::NonspacingMark),
  ((0,29,0),(0,29,43),UnicodeCategory::LowercaseLetter),
  ((0,29,44),(0,29,106),UnicodeCategory::ModifierLetter),
  ((0,29,107),(0,29,119),UnicodeCategory::LowercaseLetter),
  ((0,29,120),(0,29,120),UnicodeCategory::ModifierLetter),
  ((0,29,121),(0,29,154),UnicodeCategory::LowercaseLetter),
  ((0,29,155),(0,29,191),UnicodeCategory::ModifierLetter),
  ((0,29,192),(0,29,245),UnicodeCategory::NonspacingMark),
  ((0,29,251),(0,29,255),UnicodeCategory::NonspacingMark),
  ((0,30,0),(0,30,0),UnicodeCategory::UppercaseLetter),
  ((0,30,1),(0,30,1),UnicodeCategory::LowercaseLetter),
  ((0,30,2),(0,30,2),UnicodeCategory::UppercaseLetter),
  ((0,30,3),(0,30,3),UnicodeCategory::LowercaseLetter),
  ((0,30,4),(0,30,4),UnicodeCategory::UppercaseLetter),
  ((0,30,5),(0,30,5),UnicodeCategory::LowercaseLetter),
  ((0,30,6),(0,30,6),UnicodeCategory::UppercaseLetter),
  ((0,30,7),(0,30,7),UnicodeCategory::LowercaseLetter),
  ((0,30,8),(0,30,8),UnicodeCategory::UppercaseLetter),
  ((0,30,9),(0,30,9),UnicodeCategory::LowercaseLetter),
  ((0,30,10),(0,30,10),UnicodeCategory::UppercaseLetter),
  ((0,30,11),(0,30,11),UnicodeCategory::LowercaseLetter),
  ((0,30,12),(0,30,12),UnicodeCategory::UppercaseLetter),
  ((0,30,13),(0,30,13),UnicodeCategory::LowercaseLetter),
  ((0,30,14),(0,30,14),UnicodeCategory::UppercaseLetter),
  ((0,30,15),(0,30,15),UnicodeCategory::LowercaseLetter),
  ((0,30,16),(0,30,16),UnicodeCategory::UppercaseLetter),
  ((0,30,17),(0,30,17),UnicodeCategory::LowercaseLetter),
  ((0,30,18),(0,30,18),UnicodeCategory::UppercaseLetter),
  ((0,30,19),(0,30,19),UnicodeCategory::LowercaseLetter),
  ((0,30,20),(0,30,20),UnicodeCategory::UppercaseLetter),
  ((0,30,21),(0,30,21),UnicodeCategory::LowercaseLetter),
  ((0,30,22),(0,30,22),UnicodeCategory::UppercaseLetter),
  ((0,30,23),(0,30,23),UnicodeCategory::LowercaseLetter),
  ((0,30,24),(0,30,24),UnicodeCategory::UppercaseLetter),
  ((0,30,25),(0,30,25),UnicodeCategory::LowercaseLetter),
  ((0,30,26),(0,30,26),UnicodeCategory::UppercaseLetter),
  ((0,30,27),(0,30,27),UnicodeCategory::LowercaseLetter),
  ((0,30,28),(0,30,28),UnicodeCategory::UppercaseLetter),
  ((0,30,29),(0,30,29),UnicodeCategory::LowercaseLetter),
  ((0,30,30),(0,30,30),UnicodeCategory::UppercaseLetter),
  ((0,30,31),(0,30,31),UnicodeCategory::LowercaseLetter),
  ((0,30,32),(0,30,32),UnicodeCategory::UppercaseLetter),
  ((0,30,33),(0,30,33),UnicodeCategory::LowercaseLetter),
  ((0,30,34),(0,30,34),UnicodeCategory::UppercaseLetter),
  ((0,30,35),(0,30,35),UnicodeCategory::LowercaseLetter),
  ((0,30,36),(0,30,36),UnicodeCategory::UppercaseLetter),
  ((0,30,37),(0,30,37),UnicodeCategory::LowercaseLetter),
  ((0,30,38),(0,30,38),UnicodeCategory::UppercaseLetter),
  ((0,30,39),(0,30,39),UnicodeCategory::LowercaseLetter),
  ((0,30,40),(0,30,40),UnicodeCategory::UppercaseLetter),
  ((0,30,41),(0,30,41),UnicodeCategory::LowercaseLetter),
  ((0,30,42),(0,30,42),UnicodeCategory::UppercaseLetter),
  ((0,30,43),(0,30,43),UnicodeCategory::LowercaseLetter),
  ((0,30,44),(0,30,44),UnicodeCategory::UppercaseLetter),
  ((0,30,45),(0,30,45),UnicodeCategory::LowercaseLetter),
  ((0,30,46),(0,30,46),UnicodeCategory::UppercaseLetter),
  ((0,30,47),(0,30,47),UnicodeCategory::LowercaseLetter),
  ((0,30,48),(0,30,48),UnicodeCategory::UppercaseLetter),
  ((0,30,49),(0,30,49),UnicodeCategory::LowercaseLetter),
  ((0,30,50),(0,30,50),UnicodeCategory::UppercaseLetter),
  ((0,30,51),(0,30,51),UnicodeCategory::LowercaseLetter),
  ((0,30,52),(0,30,52),UnicodeCategory::UppercaseLetter),
  ((0,30,53),(0,30,53),UnicodeCategory::LowercaseLetter),
  ((0,30,54),(0,30,54),UnicodeCategory::UppercaseLetter),
  ((0,30,55),(0,30,55),UnicodeCategory::LowercaseLetter),
  ((0,30,56),(0,30,56),UnicodeCategory::UppercaseLetter),
  ((0,30,57),(0,30,57),UnicodeCategory::LowercaseLetter),
  ((0,30,58),(0,30,58),UnicodeCategory::UppercaseLetter),
  ((0,30,59),(0,30,59),UnicodeCategory::LowercaseLetter),
  ((0,30,60),(0,30,60),UnicodeCategory::UppercaseLetter),
  ((0,30,61),(0,30,61),UnicodeCategory::LowercaseLetter),
  ((0,30,62),(0,30,62),UnicodeCategory::UppercaseLetter),
  ((0,30,63),(0,30,63),UnicodeCategory::LowercaseLetter),
  ((0,30,64),(0,30,64),UnicodeCategory::UppercaseLetter),
  ((0,30,65),(0,30,65),UnicodeCategory::LowercaseLetter),
  ((0,30,66),(0,30,66),UnicodeCategory::UppercaseLetter),
  ((0,30,67),(0,30,67),UnicodeCategory::LowercaseLetter),
  ((0,30,68),(0,30,68),UnicodeCategory::UppercaseLetter),
  ((0,30,69),(0,30,69),UnicodeCategory::LowercaseLetter),
  ((0,30,70),(0,30,70),UnicodeCategory::UppercaseLetter),
  ((0,30,71),(0,30,71),UnicodeCategory::LowercaseLetter),
  ((0,30,72),(0,30,72),UnicodeCategory::UppercaseLetter),
  ((0,30,73),(0,30,73),UnicodeCategory::LowercaseLetter),
  ((0,30,74),(0,30,74),UnicodeCategory::UppercaseLetter),
  ((0,30,75),(0,30,75),UnicodeCategory::LowercaseLetter),
  ((0,30,76),(0,30,76),UnicodeCategory::UppercaseLetter),
  ((0,30,77),(0,30,77),UnicodeCategory::LowercaseLetter),
  ((0,30,78),(0,30,78),UnicodeCategory::UppercaseLetter),
  ((0,30,79),(0,30,79),UnicodeCategory::LowercaseLetter),
  ((0,30,80),(0,30,80),UnicodeCategory::UppercaseLetter),
  ((0,30,81),(0,30,81),UnicodeCategory::LowercaseLetter),
  ((0,30,82),(0,30,82),UnicodeCategory::UppercaseLetter),
  ((0,30,83),(0,30,83),UnicodeCategory::LowercaseLetter),
  ((0,30,84),(0,30,84),UnicodeCategory::UppercaseLetter),
  ((0,30,85),(0,30,85),UnicodeCategory::LowercaseLetter),
  ((0,30,86),(0,30,86),UnicodeCategory::UppercaseLetter),
  ((0,30,87),(0,30,87),UnicodeCategory::LowercaseLetter),
  ((0,30,88),(0,30,88),UnicodeCategory::UppercaseLetter),
  ((0,30,89),(0,30,89),UnicodeCategory::LowercaseLetter),
  ((0,30,90),(0,30,90),UnicodeCategory::UppercaseLetter),
  ((0,30,91),(0,30,91),UnicodeCategory::LowercaseLetter),
  ((0,30,92),(0,30,92),UnicodeCategory::UppercaseLetter),
  ((0,30,93),(0,30,93),UnicodeCategory::LowercaseLetter),
  ((0,30,94),(0,30,94),UnicodeCategory::UppercaseLetter),
  ((0,30,95),(0,30,95),UnicodeCategory::LowercaseLetter),
  ((0,30,96),(0,30,96),UnicodeCategory::UppercaseLetter),
  ((0,30,97),(0,30,97),UnicodeCategory::LowercaseLetter),
  ((0,30,98),(0,30,98),UnicodeCategory::UppercaseLetter),
  ((0,30,99),(0,30,99),UnicodeCategory::LowercaseLetter),
  ((0,30,100),(0,30,100),UnicodeCategory::UppercaseLetter),
  ((0,30,101),(0,30,101),UnicodeCategory::LowercaseLetter),
  ((0,30,102),(0,30,102),UnicodeCategory::UppercaseLetter),
  ((0,30,103),(0,30,103),UnicodeCategory::LowercaseLetter),
  ((0,30,104),(0,30,104),UnicodeCategory::UppercaseLetter),
  ((0,30,105),(0,30,105),UnicodeCategory::LowercaseLetter),
  ((0,30,106),(0,30,106),UnicodeCategory::UppercaseLetter),
  ((0,30,107),(0,30,107),UnicodeCategory::LowercaseLetter),
  ((0,30,108),(0,30,108),UnicodeCategory::UppercaseLetter),
  ((0,30,109),(0,30,109),UnicodeCategory::LowercaseLetter),
  ((0,30,110),(0,30,110),UnicodeCategory::UppercaseLetter),
  ((0,30,111),(0,30,111),UnicodeCategory::LowercaseLetter),
  ((0,30,112),(0,30,112),UnicodeCategory::UppercaseLetter),
  ((0,30,113),(0,30,113),UnicodeCategory::LowercaseLetter),
  ((0,30,114),(0,30,114),UnicodeCategory::UppercaseLetter),
  ((0,30,115),(0,30,115),UnicodeCategory::LowercaseLetter),
  ((0,30,116),(0,30,116),UnicodeCategory::UppercaseLetter),
  ((0,30,117),(0,30,117),UnicodeCategory::LowercaseLetter),
  ((0,30,118),(0,30,118),UnicodeCategory::UppercaseLetter),
  ((0,30,119),(0,30,119),UnicodeCategory::LowercaseLetter),
  ((0,30,120),(0,30,120),UnicodeCategory::UppercaseLetter),
  ((0,30,121),(0,30,121),UnicodeCategory::LowercaseLetter),
  ((0,30,122),(0,30,122),UnicodeCategory::UppercaseLetter),
  ((0,30,123),(0,30,123),UnicodeCategory::LowercaseLetter),
  ((0,30,124),(0,30,124),UnicodeCategory::UppercaseLetter),
  ((0,30,125),(0,30,125),UnicodeCategory::LowercaseLetter),
  ((0,30,126),(0,30,126),UnicodeCategory::UppercaseLetter),
  ((0,30,127),(0,30,127),UnicodeCategory::LowercaseLetter),
  ((0,30,128),(0,30,128),UnicodeCategory::UppercaseLetter),
  ((0,30,129),(0,30,129),UnicodeCategory::LowercaseLetter),
  ((0,30,130),(0,30,130),UnicodeCategory::UppercaseLetter),
  ((0,30,131),(0,30,131),UnicodeCategory::LowercaseLetter),
  ((0,30,132),(0,30,132),UnicodeCategory::UppercaseLetter),
  ((0,30,133),(0,30,133),UnicodeCategory::LowercaseLetter),
  ((0,30,134),(0,30,134),UnicodeCategory::UppercaseLetter),
  ((0,30,135),(0,30,135),UnicodeCategory::LowercaseLetter),
  ((0,30,136),(0,30,136),UnicodeCategory::UppercaseLetter),
  ((0,30,137),(0,30,137),UnicodeCategory::LowercaseLetter),
  ((0,30,138),(0,30,138),UnicodeCategory::UppercaseLetter),
  ((0,30,139),(0,30,139),UnicodeCategory::LowercaseLetter),
  ((0,30,140),(0,30,140),UnicodeCategory::UppercaseLetter),
  ((0,30,141),(0,30,141),UnicodeCategory::LowercaseLetter),
  ((0,30,142),(0,30,142),UnicodeCategory::UppercaseLetter),
  ((0,30,143),(0,30,143),UnicodeCategory::LowercaseLetter),
  ((0,30,144),(0,30,144),UnicodeCategory::UppercaseLetter),
  ((0,30,145),(0,30,145),UnicodeCategory::LowercaseLetter),
  ((0,30,146),(0,30,146),UnicodeCategory::UppercaseLetter),
  ((0,30,147),(0,30,147),UnicodeCategory::LowercaseLetter),
  ((0,30,148),(0,30,148),UnicodeCategory::UppercaseLetter),
  ((0,30,149),(0,30,157),UnicodeCategory::LowercaseLetter),
  ((0,30,158),(0,30,158),UnicodeCategory::UppercaseLetter),
  ((0,30,159),(0,30,159),UnicodeCategory::LowercaseLetter),
  ((0,30,160),(0,30,160),UnicodeCategory::UppercaseLetter),
  ((0,30,161),(0,30,161),UnicodeCategory::LowercaseLetter),
  ((0,30,162),(0,30,162),UnicodeCategory::UppercaseLetter),
  ((0,30,163),(0,30,163),UnicodeCategory::LowercaseLetter),
  ((0,30,164),(0,30,164),UnicodeCategory::UppercaseLetter),
  ((0,30,165),(0,30,165),UnicodeCategory::LowercaseLetter),
  ((0,30,166),(0,30,166),UnicodeCategory::UppercaseLetter),
  ((0,30,167),(0,30,167),UnicodeCategory::LowercaseLetter),
  ((0,30,168),(0,30,168),UnicodeCategory::UppercaseLetter),
  ((0,30,169),(0,30,169),UnicodeCategory::LowercaseLetter),
  ((0,30,170),(0,30,170),UnicodeCategory::UppercaseLetter),
  ((0,30,171),(0,30,171),UnicodeCategory::LowercaseLetter),
  ((0,30,172),(0,30,172),UnicodeCategory::UppercaseLetter),
  ((0,30,173),(0,30,173),UnicodeCategory::LowercaseLetter),
  ((0,30,174),(0,30,174),UnicodeCategory::UppercaseLetter),
  ((0,30,175),(0,30,175),UnicodeCategory::LowercaseLetter),
  ((0,30,176),(0,30,176),UnicodeCategory::UppercaseLetter),
  ((0,30,177),(0,30,177),UnicodeCategory::LowercaseLetter),
  ((0,30,178),(0,30,178),UnicodeCategory::UppercaseLetter),
  ((0,30,179),(0,30,179),UnicodeCategory::LowercaseLetter),
  ((0,30,180),(0,30,180),UnicodeCategory::UppercaseLetter),
  ((0,30,181),(0,30,181),UnicodeCategory::LowercaseLetter),
  ((0,30,182),(0,30,182),UnicodeCategory::UppercaseLetter),
  ((0,30,183),(0,30,183),UnicodeCategory::LowercaseLetter),
  ((0,30,184),(0,30,184),UnicodeCategory::UppercaseLetter),
  ((0,30,185),(0,30,185),UnicodeCategory::LowercaseLetter),
  ((0,30,186),(0,30,186),UnicodeCategory::UppercaseLetter),
  ((0,30,187),(0,30,187),UnicodeCategory::LowercaseLetter),
  ((0,30,188),(0,30,188),UnicodeCategory::UppercaseLetter),
  ((0,30,189),(0,30,189),UnicodeCategory::LowercaseLetter),
  ((0,30,190),(0,30,190),UnicodeCategory::UppercaseLetter),
  ((0,30,191),(0,30,191),UnicodeCategory::LowercaseLetter),
  ((0,30,192),(0,30,192),UnicodeCategory::UppercaseLetter),
  ((0,30,193),(0,30,193),UnicodeCategory::LowercaseLetter),
  ((0,30,194),(0,30,194),UnicodeCategory::UppercaseLetter),
  ((0,30,195),(0,30,195),UnicodeCategory::LowercaseLetter),
  ((0,30,196),(0,30,196),UnicodeCategory::UppercaseLetter),
  ((0,30,197),(0,30,197),UnicodeCategory::LowercaseLetter),
  ((0,30,198),(0,30,198),UnicodeCategory::UppercaseLetter),
  ((0,30,199),(0,30,199),UnicodeCategory::LowercaseLetter),
  ((0,30,200),(0,30,200),UnicodeCategory::UppercaseLetter),
  ((0,30,201),(0,30,201),UnicodeCategory::LowercaseLetter),
  ((0,30,202),(0,30,202),UnicodeCategory::UppercaseLetter),
  ((0,30,203),(0,30,203),UnicodeCategory::LowercaseLetter),
  ((0,30,204),(0,30,204),UnicodeCategory::UppercaseLetter),
  ((0,30,205),(0,30,205),UnicodeCategory::LowercaseLetter),
  ((0,30,206),(0,30,206),UnicodeCategory::UppercaseLetter),
  ((0,30,207),(0,30,207),UnicodeCategory::LowercaseLetter),
  ((0,30,208),(0,30,208),UnicodeCategory::UppercaseLetter),
  ((0,30,209),(0,30,209),UnicodeCategory::LowercaseLetter),
  ((0,30,210),(0,30,210),UnicodeCategory::UppercaseLetter),
  ((0,30,211),(0,30,211),UnicodeCategory::LowercaseLetter),
  ((0,30,212),(0,30,212),UnicodeCategory::UppercaseLetter),
  ((0,30,213),(0,30,213),UnicodeCategory::LowercaseLetter),
  ((0,30,214),(0,30,214),UnicodeCategory::UppercaseLetter),
  ((0,30,215),(0,30,215),UnicodeCategory::LowercaseLetter),
  ((0,30,216),(0,30,216),UnicodeCategory::UppercaseLetter),
  ((0,30,217),(0,30,217),UnicodeCategory::LowercaseLetter),
  ((0,30,218),(0,30,218),UnicodeCategory::UppercaseLetter),
  ((0,30,219),(0,30,219),UnicodeCategory::LowercaseLetter),
  ((0,30,220),(0,30,220),UnicodeCategory::UppercaseLetter),
  ((0,30,221),(0,30,221),UnicodeCategory::LowercaseLetter),
  ((0,30,222),(0,30,222),UnicodeCategory::UppercaseLetter),
  ((0,30,223),(0,30,223),UnicodeCategory::LowercaseLetter),
  ((0,30,224),(0,30,224),UnicodeCategory::UppercaseLetter),
  ((0,30,225),(0,30,225),UnicodeCategory::LowercaseLetter),
  ((0,30,226),(0,30,226),UnicodeCategory::UppercaseLetter),
  ((0,30,227),(0,30,227),UnicodeCategory::LowercaseLetter),
  ((0,30,228),(0,30,228),UnicodeCategory::UppercaseLetter),
  ((0,30,229),(0,30,229),UnicodeCategory::LowercaseLetter),
  ((0,30,230),(0,30,230),UnicodeCategory::UppercaseLetter),
  ((0,30,231),(0,30,231),UnicodeCategory::LowercaseLetter),
  ((0,30,232),(0,30,232),UnicodeCategory::UppercaseLetter),
  ((0,30,233),(0,30,233),UnicodeCategory::LowercaseLetter),
  ((0,30,234),(0,30,234),UnicodeCategory::UppercaseLetter),
  ((0,30,235),(0,30,235),UnicodeCategory::LowercaseLetter),
  ((0,30,236),(0,30,236),UnicodeCategory::UppercaseLetter),
  ((0,30,237),(0,30,237),UnicodeCategory::LowercaseLetter),
  ((0,30,238),(0,30,238),UnicodeCategory::UppercaseLetter),
  ((0,30,239),(0,30,239),UnicodeCategory::LowercaseLetter),
  ((0,30,240),(0,30,240),UnicodeCategory::UppercaseLetter),
  ((0,30,241),(0,30,241),UnicodeCategory::LowercaseLetter),
  ((0,30,242),(0,30,242),UnicodeCategory::UppercaseLetter),
  ((0,30,243),(0,30,243),UnicodeCategory::LowercaseLetter),
  ((0,30,244),(0,30,244),UnicodeCategory::UppercaseLetter),
  ((0,30,245),(0,30,245),UnicodeCategory::LowercaseLetter),
  ((0,30,246),(0,30,246),UnicodeCategory::UppercaseLetter),
  ((0,30,247),(0,30,247),UnicodeCategory::LowercaseLetter),
  ((0,30,248),(0,30,248),UnicodeCategory::UppercaseLetter),
  ((0,30,249),(0,30,249),UnicodeCategory::LowercaseLetter),
  ((0,30,250),(0,30,250),UnicodeCategory::UppercaseLetter),
  ((0,30,251),(0,30,251),UnicodeCategory::LowercaseLetter),
  ((0,30,252),(0,30,252),UnicodeCategory::UppercaseLetter),
  ((0,30,253),(0,30,253),UnicodeCategory::LowercaseLetter),
  ((0,30,254),(0,30,254),UnicodeCategory::UppercaseLetter),
  ((0,30,255),(0,31,7),UnicodeCategory::LowercaseLetter),
  ((0,31,8),(0,31,15),UnicodeCategory::UppercaseLetter),
  ((0,31,16),(0,31,21),UnicodeCategory::LowercaseLetter),
  ((0,31,24),(0,31,29),UnicodeCategory::UppercaseLetter),
  ((0,31,32),(0,31,39),UnicodeCategory::LowercaseLetter),
  ((0,31,40),(0,31,47),UnicodeCategory::UppercaseLetter),
  ((0,31,48),(0,31,55),UnicodeCategory::LowercaseLetter),
  ((0,31,56),(0,31,63),UnicodeCategory::UppercaseLetter),
  ((0,31,64),(0,31,69),UnicodeCategory::LowercaseLetter),
  ((0,31,72),(0,31,77),UnicodeCategory::UppercaseLetter),
  ((0,31,80),(0,31,87),UnicodeCategory::LowercaseLetter),
  ((0,31,89),(0,31,89),UnicodeCategory::UppercaseLetter),
  ((0,31,91),(0,31,91),UnicodeCategory::UppercaseLetter),
  ((0,31,93),(0,31,93),UnicodeCategory::UppercaseLetter),
  ((0,31,95),(0,31,95),UnicodeCategory::UppercaseLetter),
  ((0,31,96),(0,31,103),UnicodeCategory::LowercaseLetter),
  ((0,31,104),(0,31,111),UnicodeCategory::UppercaseLetter),
  ((0,31,112),(0,31,125),UnicodeCategory::LowercaseLetter),
  ((0,31,128),(0,31,135),UnicodeCategory::LowercaseLetter),
  ((0,31,136),(0,31,143),UnicodeCategory::TitlecaseLetter),
  ((0,31,144),(0,31,151),UnicodeCategory::LowercaseLetter),
  ((0,31,152),(0,31,159),UnicodeCategory::TitlecaseLetter),
  ((0,31,160),(0,31,167),UnicodeCategory::LowercaseLetter),
  ((0,31,168),(0,31,175),UnicodeCategory::TitlecaseLetter),
  ((0,31,176),(0,31,180),UnicodeCategory::LowercaseLetter),
  ((0,31,182),(0,31,183),UnicodeCategory::LowercaseLetter),
  ((0,31,184),(0,31,187),UnicodeCategory::UppercaseLetter),
  ((0,31,188),(0,31,188),UnicodeCategory::TitlecaseLetter),
  ((0,31,189),(0,31,189),UnicodeCategory::ModifierSymbol),
  ((0,31,190),(0,31,190),UnicodeCategory::LowercaseLetter),
  ((0,31,191),(0,31,193),UnicodeCategory::ModifierSymbol),
  ((0,31,194),(0,31,196),UnicodeCategory::LowercaseLetter),
  ((0,31,198),(0,31,199),UnicodeCategory::LowercaseLetter),
  ((0,31,200),(0,31,203),UnicodeCategory::UppercaseLetter),
  ((0,31,204),(0,31,204),UnicodeCategory::TitlecaseLetter),
  ((0,31,205),(0,31,207),UnicodeCategory::ModifierSymbol),
  ((0,31,208),(0,31,211),UnicodeCategory::LowercaseLetter),
  ((0,31,214),(0,31,215),UnicodeCategory::LowercaseLetter),
  ((0,31,216),(0,31,219),UnicodeCategory::UppercaseLetter),
  ((0,31,221),(0,31,223),UnicodeCategory::ModifierSymbol),
  ((0,31,224),(0,31,231),UnicodeCategory::LowercaseLetter),
  ((0,31,232),(0,31,236),UnicodeCategory::UppercaseLetter),
  ((0,31,237),(0,31,239),UnicodeCategory::ModifierSymbol),
  ((0,31,242),(0,31,244),UnicodeCategory::LowercaseLetter),
  ((0,31,246),(0,31,247),UnicodeCategory::LowercaseLetter),
  ((0,31,248),(0,31,251),UnicodeCategory::UppercaseLetter),
  ((0,31,252),(0,31,252),UnicodeCategory::TitlecaseLetter),
  ((0,31,253),(0,31,254),UnicodeCategory::ModifierSymbol),
  ((0,32,0),(0,32,10),UnicodeCategory::SpaceSeparator),
  ((0,32,11),(0,32,15),UnicodeCategory::Format),
  ((0,32,16),(0,32,21),UnicodeCategory::DashPunctuation),
  ((0,32,22),(0,32,23),UnicodeCategory::OtherPunctuation),
  ((0,32,24),(0,32,24),UnicodeCategory::InitialPunctuation),
  ((0,32,25),(0,32,25),UnicodeCategory::FinalPunctuation),
  ((0,32,26),(0,32,26),UnicodeCategory::OpenPunctuation),
  ((0,32,27),(0,32,28),UnicodeCategory::InitialPunctuation),
  ((0,32,29),(0,32,29),UnicodeCategory::FinalPunctuation),
  ((0,32,30),(0,32,30),UnicodeCategory::OpenPunctuation),
  ((0,32,31),(0,32,31),UnicodeCategory::InitialPunctuation),
  ((0,32,32),(0,32,39),UnicodeCategory::OtherPunctuation),
  ((0,32,40),(0,32,40),UnicodeCategory::LineSeparator),
  ((0,32,41),(0,32,41),UnicodeCategory::ParagraphSeparator),
  ((0,32,42),(0,32,46),UnicodeCategory::Format),
  ((0,32,47),(0,32,47),UnicodeCategory::SpaceSeparator),
  ((0,32,48),(0,32,56),UnicodeCategory::OtherPunctuation),
  ((0,32,57),(0,32,57),UnicodeCategory::InitialPunctuation),
  ((0,32,58),(0,32,58),UnicodeCategory::FinalPunctuation),
  ((0,32,59),(0,32,62),UnicodeCategory::OtherPunctuation),
  ((0,32,63),(0,32,64),UnicodeCategory::ConnectorPunctuation),
  ((0,32,65),(0,32,67),UnicodeCategory::OtherPunctuation),
  ((0,32,68),(0,32,68),UnicodeCategory::MathSymbol),
  ((0,32,69),(0,32,69),UnicodeCategory::OpenPunctuation),
  ((0,32,70),(0,32,70),UnicodeCategory::ClosePunctuation),
  ((0,32,71),(0,32,81),UnicodeCategory::OtherPunctuation),
  ((0,32,82),(0,32,82),UnicodeCategory::MathSymbol),
  ((0,32,83),(0,32,83),UnicodeCategory::OtherPunctuation),
  ((0,32,84),(0,32,84),UnicodeCategory::ConnectorPunctuation),
  ((0,32,85),(0,32,94),UnicodeCategory::OtherPunctuation),
  ((0,32,95),(0,32,95),UnicodeCategory::SpaceSeparator),
  ((0,32,96),(0,32,100),UnicodeCategory::Format),
  ((0,32,102),(0,32,111),UnicodeCategory::Format),
  ((0,32,112),(0,32,112),UnicodeCategory::OtherNumber),
  ((0,32,113),(0,32,113),UnicodeCategory::ModifierLetter),
  ((0,32,116),(0,32,121),UnicodeCategory::OtherNumber),
  ((0,32,122),(0,32,124),UnicodeCategory::MathSymbol),
  ((0,32,125),(0,32,125),UnicodeCategory::OpenPunctuation),
  ((0,32,126),(0,32,126),UnicodeCategory::ClosePunctuation),
  ((0,32,127),(0,32,127),UnicodeCategory::ModifierLetter),
  ((0,32,128),(0,32,137),UnicodeCategory::OtherNumber),
  ((0,32,138),(0,32,140),UnicodeCategory::MathSymbol),
  ((0,32,141),(0,32,141),UnicodeCategory::OpenPunctuation),
  ((0,32,142),(0,32,142),UnicodeCategory::ClosePunctuation),
  ((0,32,144),(0,32,156),UnicodeCategory::ModifierLetter),
  ((0,32,160),(0,32,190),UnicodeCategory::CurrencySymbol),
  ((0,32,208),(0,32,220),UnicodeCategory::NonspacingMark),
  ((0,32,221),(0,32,224),UnicodeCategory::EnclosingMark),
  ((0,32,225),(0,32,225),UnicodeCategory::NonspacingMark),
  ((0,32,226),(0,32,228),UnicodeCategory::EnclosingMark),
  ((0,32,229),(0,32,240),UnicodeCategory::NonspacingMark),
  ((0,33,0),(0,33,1),UnicodeCategory::OtherSymbol),
  ((0,33,2),(0,33,2),UnicodeCategory::UppercaseLetter),
  ((0,33,3),(0,33,6),UnicodeCategory::OtherSymbol),
  ((0,33,7),(0,33,7),UnicodeCategory::UppercaseLetter),
  ((0,33,8),(0,33,9),UnicodeCategory::OtherSymbol),
  ((0,33,10),(0,33,10),UnicodeCategory::LowercaseLetter),
  ((0,33,11),(0,33,13),UnicodeCategory::UppercaseLetter),
  ((0,33,14),(0,33,15),UnicodeCategory::LowercaseLetter),
  ((0,33,16),(0,33,18),UnicodeCategory::UppercaseLetter),
  ((0,33,19),(0,33,19),UnicodeCategory::LowercaseLetter),
  ((0,33,20),(0,33,20),UnicodeCategory::OtherSymbol),
  ((0,33,21),(0,33,21),UnicodeCategory::UppercaseLetter),
  ((0,33,22),(0,33,23),UnicodeCategory::OtherSymbol),
  ((0,33,24),(0,33,24),UnicodeCategory::MathSymbol),
  ((0,33,25),(0,33,29),UnicodeCategory::UppercaseLetter),
  ((0,33,30),(0,33,35),UnicodeCategory::OtherSymbol),
  ((0,33,36),(0,33,36),UnicodeCategory::UppercaseLetter),
  ((0,33,37),(0,33,37),UnicodeCategory::OtherSymbol),
  ((0,33,38),(0,33,38),UnicodeCategory::UppercaseLetter),
  ((0,33,39),(0,33,39),UnicodeCategory::OtherSymbol),
  ((0,33,40),(0,33,40),UnicodeCategory::UppercaseLetter),
  ((0,33,41),(0,33,41),UnicodeCategory::OtherSymbol),
  ((0,33,42),(0,33,45),UnicodeCategory::UppercaseLetter),
  ((0,33,46),(0,33,46),UnicodeCategory::OtherSymbol),
  ((0,33,47),(0,33,47),UnicodeCategory::LowercaseLetter),
  ((0,33,48),(0,33,51),UnicodeCategory::UppercaseLetter),
  ((0,33,52),(0,33,52),UnicodeCategory::LowercaseLetter),
  ((0,33,53),(0,33,56),UnicodeCategory::OtherLetter),
  ((0,33,57),(0,33,57),UnicodeCategory::LowercaseLetter),
  ((0,33,58),(0,33,59),UnicodeCategory::OtherSymbol),
  ((0,33,60),(0,33,61),UnicodeCategory::LowercaseLetter),
  ((0,33,62),(0,33,63),UnicodeCategory::UppercaseLetter),
  ((0,33,64),(0,33,68),UnicodeCategory::MathSymbol),
  ((0,33,69),(0,33,69),UnicodeCategory::UppercaseLetter),
  ((0,33,70),(0,33,73),UnicodeCategory::LowercaseLetter),
  ((0,33,74),(0,33,74),UnicodeCategory::OtherSymbol),
  ((0,33,75),(0,33,75),UnicodeCategory::MathSymbol),
  ((0,33,76),(0,33,77),UnicodeCategory::OtherSymbol),
  ((0,33,78),(0,33,78),UnicodeCategory::LowercaseLetter),
  ((0,33,79),(0,33,79),UnicodeCategory::OtherSymbol),
  ((0,33,80),(0,33,95),UnicodeCategory::OtherNumber),
  ((0,33,96),(0,33,130),UnicodeCategory::LetterNumber),
  ((0,33,131),(0,33,131),UnicodeCategory::UppercaseLetter),
  ((0,33,132),(0,33,132),UnicodeCategory::LowercaseLetter),
  ((0,33,133),(0,33,136),UnicodeCategory::LetterNumber),
  ((0,33,137),(0,33,137),UnicodeCategory::OtherNumber),
  ((0,33,138),(0,33,139),UnicodeCategory::OtherSymbol),
  ((0,33,144),(0,33,148),UnicodeCategory::MathSymbol),
  ((0,33,149),(0,33,153),UnicodeCategory::OtherSymbol),
  ((0,33,154),(0,33,155),UnicodeCategory::MathSymbol),
  ((0,33,156),(0,33,159),UnicodeCategory::OtherSymbol),
  ((0,33,160),(0,33,160),UnicodeCategory::MathSymbol),
  ((0,33,161),(0,33,162),UnicodeCategory::OtherSymbol),
  ((0,33,163),(0,33,163),UnicodeCategory::MathSymbol),
  ((0,33,164),(0,33,165),UnicodeCategory::OtherSymbol),
  ((0,33,166),(0,33,166),UnicodeCategory::MathSymbol),
  ((0,33,167),(0,33,173),UnicodeCategory::OtherSymbol),
  ((0,33,174),(0,33,174),UnicodeCategory::MathSymbol),
  ((0,33,175),(0,33,205),UnicodeCategory::OtherSymbol),
  ((0,33,206),(0,33,207),UnicodeCategory::MathSymbol),
  ((0,33,208),(0,33,209),UnicodeCategory::OtherSymbol),
  ((0,33,210),(0,33,210),UnicodeCategory::MathSymbol),
  ((0,33,211),(0,33,211),UnicodeCategory::OtherSymbol),
  ((0,33,212),(0,33,212),UnicodeCategory::MathSymbol),
  ((0,33,213),(0,33,243),UnicodeCategory::OtherSymbol),
  ((0,33,244),(0,34,255),UnicodeCategory::MathSymbol),
  ((0,35,0),(0,35,7),UnicodeCategory::OtherSymbol),
  ((0,35,8),(0,35,8),UnicodeCategory::OpenPunctuation),
  ((0,35,9),(0,35,9),UnicodeCategory::ClosePunctuation),
  ((0,35,10),(0,35,10),UnicodeCategory::OpenPunctuation),
  ((0,35,11),(0,35,11),UnicodeCategory::ClosePunctuation),
  ((0,35,12),(0,35,31),UnicodeCategory::OtherSymbol),
  ((0,35,32),(0,35,33),UnicodeCategory::MathSymbol),
  ((0,35,34),(0,35,40),UnicodeCategory::OtherSymbol),
  ((0,35,41),(0,35,41),UnicodeCategory::OpenPunctuation),
  ((0,35,42),(0,35,42),UnicodeCategory::ClosePunctuation),
  ((0,35,43),(0,35,123),UnicodeCategory::OtherSymbol),
  ((0,35,124),(0,35,124),UnicodeCategory::MathSymbol),
  ((0,35,125),(0,35,154),UnicodeCategory::OtherSymbol),
  ((0,35,155),(0,35,179),UnicodeCategory::MathSymbol),
  ((0,35,180),(0,35,219),UnicodeCategory::OtherSymbol),
  ((0,35,220),(0,35,225),UnicodeCategory::MathSymbol),
  ((0,35,226),(0,35,254),UnicodeCategory::OtherSymbol),
  ((0,36,0),(0,36,38),UnicodeCategory::OtherSymbol),
  ((0,36,64),(0,36,74),UnicodeCategory::OtherSymbol),
  ((0,36,96),(0,36,155),UnicodeCategory::OtherNumber),
  ((0,36,156),(0,36,233),UnicodeCategory::OtherSymbol),
  ((0,36,234),(0,36,255),UnicodeCategory::OtherNumber),
  ((0,37,0),(0,37,182),UnicodeCategory::OtherSymbol),
  ((0,37,183),(0,37,183),UnicodeCategory::MathSymbol),
  ((0,37,184),(0,37,192),UnicodeCategory::OtherSymbol),
  ((0,37,193),(0,37,193),UnicodeCategory::MathSymbol),
  ((0,37,194),(0,37,247),UnicodeCategory::OtherSymbol),
  ((0,37,248),(0,37,255),UnicodeCategory::MathSymbol),
  ((0,38,0),(0,38,110),UnicodeCategory::OtherSymbol),
  ((0,38,111),(0,38,111),UnicodeCategory::MathSymbol),
  ((0,38,112),(0,39,103),UnicodeCategory::OtherSymbol),
  ((0,39,104),(0,39,104),UnicodeCategory::OpenPunctuation),
  ((0,39,105),(0,39,105),UnicodeCategory::ClosePunctuation),
  ((0,39,106),(0,39,106),UnicodeCategory::OpenPunctuation),
  ((0,39,107),(0,39,107),UnicodeCategory::ClosePunctuation),
  ((0,39,108),(0,39,108),UnicodeCategory::OpenPunctuation),
  ((0,39,109),(0,39,109),UnicodeCategory::ClosePunctuation),
  ((0,39,110),(0,39,110),UnicodeCategory::OpenPunctuation),
  ((0,39,111),(0,39,111),UnicodeCategory::ClosePunctuation),
  ((0,39,112),(0,39,112),UnicodeCategory::OpenPunctuation),
  ((0,39,113),(0,39,113),UnicodeCategory::ClosePunctuation),
  ((0,39,114),(0,39,114),UnicodeCategory::OpenPunctuation),
  ((0,39,115),(0,39,115),UnicodeCategory::ClosePunctuation),
  ((0,39,116),(0,39,116),UnicodeCategory::OpenPunctuation),
  ((0,39,117),(0,39,117),UnicodeCategory::ClosePunctuation),
  ((0,39,118),(0,39,147),UnicodeCategory::OtherNumber),
  ((0,39,148),(0,39,191),UnicodeCategory::OtherSymbol),
  ((0,39,192),(0,39,196),UnicodeCategory::MathSymbol),
  ((0,39,197),(0,39,197),UnicodeCategory::OpenPunctuation),
  ((0,39,198),(0,39,198),UnicodeCategory::ClosePunctuation),
  ((0,39,199),(0,39,229),UnicodeCategory::MathSymbol),
  ((0,39,230),(0,39,230),UnicodeCategory::OpenPunctuation),
  ((0,39,231),(0,39,231),UnicodeCategory::ClosePunctuation),
  ((0,39,232),(0,39,232),UnicodeCategory::OpenPunctuation),
  ((0,39,233),(0,39,233),UnicodeCategory::ClosePunctuation),
  ((0,39,234),(0,39,234),UnicodeCategory::OpenPunctuation),
  ((0,39,235),(0,39,235),UnicodeCategory::ClosePunctuation),
  ((0,39,236),(0,39,236),UnicodeCategory::OpenPunctuation),
  ((0,39,237),(0,39,237),UnicodeCategory::ClosePunctuation),
  ((0,39,238),(0,39,238),UnicodeCategory::OpenPunctuation),
  ((0,39,239),(0,39,239),UnicodeCategory::ClosePunctuation),
  ((0,39,240),(0,39,255),UnicodeCategory::MathSymbol),
  ((0,40,0),(0,40,255),UnicodeCategory::OtherSymbol),
  ((0,41,0),(0,41,130),UnicodeCategory::MathSymbol),
  ((0,41,131),(0,41,131),UnicodeCategory::OpenPunctuation),
  ((0,41,132),(0,41,132),UnicodeCategory::ClosePunctuation),
  ((0,41,133),(0,41,133),UnicodeCategory::OpenPunctuation),
  ((0,41,134),(0,41,134),UnicodeCategory::ClosePunctuation),
  ((0,41,135),(0,41,135),UnicodeCategory::OpenPunctuation),
  ((0,41,136),(0,41,136),UnicodeCategory::ClosePunctuation),
  ((0,41,137),(0,41,137),UnicodeCategory::OpenPunctuation),
  ((0,41,138),(0,41,138),UnicodeCategory::ClosePunctuation),
  ((0,41,139),(0,41,139),UnicodeCategory::OpenPunctuation),
  ((0,41,140),(0,41,140),UnicodeCategory::ClosePunctuation),
  ((0,41,141),(0,41,141),UnicodeCategory::OpenPunctuation),
  ((0,41,142),(0,41,142),UnicodeCategory::ClosePunctuation),
  ((0,41,143),(0,41,143),UnicodeCategory::OpenPunctuation),
  ((0,41,144),(0,41,144),UnicodeCategory::ClosePunctuation),
  ((0,41,145),(0,41,145),UnicodeCategory::OpenPunctuation),
  ((0,41,146),(0,41,146),UnicodeCategory::ClosePunctuation),
  ((0,41,147),(0,41,147),UnicodeCategory::OpenPunctuation),
  ((0,41,148),(0,41,148),UnicodeCategory::ClosePunctuation),
  ((0,41,149),(0,41,149),UnicodeCategory::OpenPunctuation),
  ((0,41,150),(0,41,150),UnicodeCategory::ClosePunctuation),
  ((0,41,151),(0,41,151),UnicodeCategory::OpenPunctuation),
  ((0,41,152),(0,41,152),UnicodeCategory::ClosePunctuation),
  ((0,41,153),(0,41,215),UnicodeCategory::MathSymbol),
  ((0,41,216),(0,41,216),UnicodeCategory::OpenPunctuation),
  ((0,41,217),(0,41,217),UnicodeCategory::ClosePunctuation),
  ((0,41,218),(0,41,218),UnicodeCategory::OpenPunctuation),
  ((0,41,219),(0,41,219),UnicodeCategory::ClosePunctuation),
  ((0,41,220),(0,41,251),UnicodeCategory::MathSymbol),
  ((0,41,252),(0,41,252),UnicodeCategory::OpenPunctuation),
  ((0,41,253),(0,41,253),UnicodeCategory::ClosePunctuation),
  ((0,41,254),(0,42,255),UnicodeCategory::MathSymbol),
  ((0,43,0),(0,43,47),UnicodeCategory::OtherSymbol),
  ((0,43,48),(0,43,68),UnicodeCategory::MathSymbol),
  ((0,43,69),(0,43,70),UnicodeCategory::OtherSymbol),
  ((0,43,71),(0,43,76),UnicodeCategory::MathSymbol),
  ((0,43,77),(0,43,115),UnicodeCategory::OtherSymbol),
  ((0,43,118),(0,43,149),UnicodeCategory::OtherSymbol),
  ((0,43,152),(0,43,185),UnicodeCategory::OtherSymbol),
  ((0,43,189),(0,43,200),UnicodeCategory::OtherSymbol),
  ((0,43,202),(0,43,209),UnicodeCategory::OtherSymbol),
  ((0,43,236),(0,43,239),UnicodeCategory::OtherSymbol),
  ((0,44,0),(0,44,46),UnicodeCategory::UppercaseLetter),
  ((0,44,48),(0,44,94),UnicodeCategory::LowercaseLetter),
  ((0,44,96),(0,44,96),UnicodeCategory::UppercaseLetter),
  ((0,44,97),(0,44,97),UnicodeCategory::LowercaseLetter),
  ((0,44,98),(0,44,100),UnicodeCategory::UppercaseLetter),
  ((0,44,101),(0,44,102),UnicodeCategory::LowercaseLetter),
  ((0,44,103),(0,44,103),UnicodeCategory::UppercaseLetter),
  ((0,44,104),(0,44,104),UnicodeCategory::LowercaseLetter),
  ((0,44,105),(0,44,105),UnicodeCategory::UppercaseLetter),
  ((0,44,106),(0,44,106),UnicodeCategory::LowercaseLetter),
  ((0,44,107),(0,44,107),UnicodeCategory::UppercaseLetter),
  ((0,44,108),(0,44,108),UnicodeCategory::LowercaseLetter),
  ((0,44,109),(0,44,112),UnicodeCategory::UppercaseLetter),
  ((0,44,113),(0,44,113),UnicodeCategory::LowercaseLetter),
  ((0,44,114),(0,44,114),UnicodeCategory::UppercaseLetter),
  ((0,44,115),(0,44,116),UnicodeCategory::LowercaseLetter),
  ((0,44,117),(0,44,117),UnicodeCategory::UppercaseLetter),
  ((0,44,118),(0,44,123),UnicodeCategory::LowercaseLetter),
  ((0,44,124),(0,44,125),UnicodeCategory::ModifierLetter),
  ((0,44,126),(0,44,128),UnicodeCategory::UppercaseLetter),
  ((0,44,129),(0,44,129),UnicodeCategory::LowercaseLetter),
  ((0,44,130),(0,44,130),UnicodeCategory::UppercaseLetter),
  ((0,44,131),(0,44,131),UnicodeCategory::LowercaseLetter),
  ((0,44,132),(0,44,132),UnicodeCategory::UppercaseLetter),
  ((0,44,133),(0,44,133),UnicodeCategory::LowercaseLetter),
  ((0,44,134),(0,44,134),UnicodeCategory::UppercaseLetter),
  ((0,44,135),(0,44,135),UnicodeCategory::LowercaseLetter),
  ((0,44,136),(0,44,136),UnicodeCategory::UppercaseLetter),
  ((0,44,137),(0,44,137),UnicodeCategory::LowercaseLetter),
  ((0,44,138),(0,44,138),UnicodeCategory::UppercaseLetter),
  ((0,44,139),(0,44,139),UnicodeCategory::LowercaseLetter),
  ((0,44,140),(0,44,140),UnicodeCategory::UppercaseLetter),
  ((0,44,141),(0,44,141),UnicodeCategory::LowercaseLetter),
  ((0,44,142),(0,44,142),UnicodeCategory::UppercaseLetter),
  ((0,44,143),(0,44,143),UnicodeCategory::LowercaseLetter),
  ((0,44,144),(0,44,144),UnicodeCategory::UppercaseLetter),
  ((0,44,145),(0,44,145),UnicodeCategory::LowercaseLetter),
  ((0,44,146),(0,44,146),UnicodeCategory::UppercaseLetter),
  ((0,44,147),(0,44,147),UnicodeCategory::LowercaseLetter),
  ((0,44,148),(0,44,148),UnicodeCategory::UppercaseLetter),
  ((0,44,149),(0,44,149),UnicodeCategory::LowercaseLetter),
  ((0,44,150),(0,44,150),UnicodeCategory::UppercaseLetter),
  ((0,44,151),(0,44,151),UnicodeCategory::LowercaseLetter),
  ((0,44,152),(0,44,152),UnicodeCategory::UppercaseLetter),
  ((0,44,153),(0,44,153),UnicodeCategory::LowercaseLetter),
  ((0,44,154),(0,44,154),UnicodeCategory::UppercaseLetter),
  ((0,44,155),(0,44,155),UnicodeCategory::LowercaseLetter),
  ((0,44,156),(0,44,156),UnicodeCategory::UppercaseLetter),
  ((0,44,157),(0,44,157),UnicodeCategory::LowercaseLetter),
  ((0,44,158),(0,44,158),UnicodeCategory::UppercaseLetter),
  ((0,44,159),(0,44,159),UnicodeCategory::LowercaseLetter),
  ((0,44,160),(0,44,160),UnicodeCategory::UppercaseLetter),
  ((0,44,161),(0,44,161),UnicodeCategory::LowercaseLetter),
  ((0,44,162),(0,44,162),UnicodeCategory::UppercaseLetter),
  ((0,44,163),(0,44,163),UnicodeCategory::LowercaseLetter),
  ((0,44,164),(0,44,164),UnicodeCategory::UppercaseLetter),
  ((0,44,165),(0,44,165),UnicodeCategory::LowercaseLetter),
  ((0,44,166),(0,44,166),UnicodeCategory::UppercaseLetter),
  ((0,44,167),(0,44,167),UnicodeCategory::LowercaseLetter),
  ((0,44,168),(0,44,168),UnicodeCategory::UppercaseLetter),
  ((0,44,169),(0,44,169),UnicodeCategory::LowercaseLetter),
  ((0,44,170),(0,44,170),UnicodeCategory::UppercaseLetter),
  ((0,44,171),(0,44,171),UnicodeCategory::LowercaseLetter),
  ((0,44,172),(0,44,172),UnicodeCategory::UppercaseLetter),
  ((0,44,173),(0,44,173),UnicodeCategory::LowercaseLetter),
  ((0,44,174),(0,44,174),UnicodeCategory::UppercaseLetter),
  ((0,44,175),(0,44,175),UnicodeCategory::LowercaseLetter),
  ((0,44,176),(0,44,176),UnicodeCategory::UppercaseLetter),
  ((0,44,177),(0,44,177),UnicodeCategory::LowercaseLetter),
  ((0,44,178),(0,44,178),UnicodeCategory::UppercaseLetter),
  ((0,44,179),(0,44,179),UnicodeCategory::LowercaseLetter),
  ((0,44,180),(0,44,180),UnicodeCategory::UppercaseLetter),
  ((0,44,181),(0,44,181),UnicodeCategory::LowercaseLetter),
  ((0,44,182),(0,44,182),UnicodeCategory::UppercaseLetter),
  ((0,44,183),(0,44,183),UnicodeCategory::LowercaseLetter),
  ((0,44,184),(0,44,184),UnicodeCategory::UppercaseLetter),
  ((0,44,185),(0,44,185),UnicodeCategory::LowercaseLetter),
  ((0,44,186),(0,44,186),UnicodeCategory::UppercaseLetter),
  ((0,44,187),(0,44,187),UnicodeCategory::LowercaseLetter),
  ((0,44,188),(0,44,188),UnicodeCategory::UppercaseLetter),
  ((0,44,189),(0,44,189),UnicodeCategory::LowercaseLetter),
  ((0,44,190),(0,44,190),UnicodeCategory::UppercaseLetter),
  ((0,44,191),(0,44,191),UnicodeCategory::LowercaseLetter),
  ((0,44,192),(0,44,192),UnicodeCategory::UppercaseLetter),
  ((0,44,193),(0,44,193),UnicodeCategory::LowercaseLetter),
  ((0,44,194),(0,44,194),UnicodeCategory::UppercaseLetter),
  ((0,44,195),(0,44,195),UnicodeCategory::LowercaseLetter),
  ((0,44,196),(0,44,196),UnicodeCategory::UppercaseLetter),
  ((0,44,197),(0,44,197),UnicodeCategory::LowercaseLetter),
  ((0,44,198),(0,44,198),UnicodeCategory::UppercaseLetter),
  ((0,44,199),(0,44,199),UnicodeCategory::LowercaseLetter),
  ((0,44,200),(0,44,200),UnicodeCategory::UppercaseLetter),
  ((0,44,201),(0,44,201),UnicodeCategory::LowercaseLetter),
  ((0,44,202),(0,44,202),UnicodeCategory::UppercaseLetter),
  ((0,44,203),(0,44,203),UnicodeCategory::LowercaseLetter),
  ((0,44,204),(0,44,204),UnicodeCategory::UppercaseLetter),
  ((0,44,205),(0,44,205),UnicodeCategory::LowercaseLetter),
  ((0,44,206),(0,44,206),UnicodeCategory::UppercaseLetter),
  ((0,44,207),(0,44,207),UnicodeCategory::LowercaseLetter),
  ((0,44,208),(0,44,208),UnicodeCategory::UppercaseLetter),
  ((0,44,209),(0,44,209),UnicodeCategory::LowercaseLetter),
  ((0,44,210),(0,44,210),UnicodeCategory::UppercaseLetter),
  ((0,44,211),(0,44,211),UnicodeCategory::LowercaseLetter),
  ((0,44,212),(0,44,212),UnicodeCategory::UppercaseLetter),
  ((0,44,213),(0,44,213),UnicodeCategory::LowercaseLetter),
  ((0,44,214),(0,44,214),UnicodeCategory::UppercaseLetter),
  ((0,44,215),(0,44,215),UnicodeCategory::LowercaseLetter),
  ((0,44,216),(0,44,216),UnicodeCategory::UppercaseLetter),
  ((0,44,217),(0,44,217),UnicodeCategory::LowercaseLetter),
  ((0,44,218),(0,44,218),UnicodeCategory::UppercaseLetter),
  ((0,44,219),(0,44,219),UnicodeCategory::LowercaseLetter),
  ((0,44,220),(0,44,220),UnicodeCategory::UppercaseLetter),
  ((0,44,221),(0,44,221),UnicodeCategory::LowercaseLetter),
  ((0,44,222),(0,44,222),UnicodeCategory::UppercaseLetter),
  ((0,44,223),(0,44,223),UnicodeCategory::LowercaseLetter),
  ((0,44,224),(0,44,224),UnicodeCategory::UppercaseLetter),
  ((0,44,225),(0,44,225),UnicodeCategory::LowercaseLetter),
  ((0,44,226),(0,44,226),UnicodeCategory::UppercaseLetter),
  ((0,44,227),(0,44,228),UnicodeCategory::LowercaseLetter),
  ((0,44,229),(0,44,234),UnicodeCategory::OtherSymbol),
  ((0,44,235),(0,44,235),UnicodeCategory::UppercaseLetter),
  ((0,44,236),(0,44,236),UnicodeCategory::LowercaseLetter),
  ((0,44,237),(0,44,237),UnicodeCategory::UppercaseLetter),
  ((0,44,238),(0,44,238),UnicodeCategory::LowercaseLetter),
  ((0,44,239),(0,44,241),UnicodeCategory::NonspacingMark),
  ((0,44,242),(0,44,242),UnicodeCategory::UppercaseLetter),
  ((0,44,243),(0,44,243),UnicodeCategory::LowercaseLetter),
  ((0,44,249),(0,44,252),UnicodeCategory::OtherPunctuation),
  ((0,44,253),(0,44,253),UnicodeCategory::OtherNumber),
  ((0,44,254),(0,44,255),UnicodeCategory::OtherPunctuation),
  ((0,45,0),(0,45,37),UnicodeCategory::LowercaseLetter),
  ((0,45,39),(0,45,39),UnicodeCategory::LowercaseLetter),
  ((0,45,45),(0,45,45),UnicodeCategory::LowercaseLetter),
  ((0,45,48),(0,45,103),UnicodeCategory::OtherLetter),
  ((0,45,111),(0,45,111),UnicodeCategory::ModifierLetter),
  ((0,45,112),(0,45,112),UnicodeCategory::OtherPunctuation),
  ((0,45,127),(0,45,127),UnicodeCategory::NonspacingMark),
  ((0,45,128),(0,45,150),UnicodeCategory::OtherLetter),
  ((0,45,160),(0,45,166),UnicodeCategory::OtherLetter),
  ((0,45,168),(0,45,174),UnicodeCategory::OtherLetter),
  ((0,45,176),(0,45,182),UnicodeCategory::OtherLetter),
  ((0,45,184),(0,45,190),UnicodeCategory::OtherLetter),
  ((0,45,192),(0,45,198),UnicodeCategory::OtherLetter),
  ((0,45,200),(0,45,206),UnicodeCategory::OtherLetter),
  ((0,45,208),(0,45,214),UnicodeCategory::OtherLetter),
  ((0,45,216),(0,45,222),UnicodeCategory::OtherLetter),
  ((0,45,224),(0,45,255),UnicodeCategory::NonspacingMark),
  ((0,46,0),(0,46,1),UnicodeCategory::OtherPunctuation),
  ((0,46,2),(0,46,2),UnicodeCategory::InitialPunctuation),
  ((0,46,3),(0,46,3),UnicodeCategory::FinalPunctuation),
  ((0,46,4),(0,46,4),UnicodeCategory::InitialPunctuation),
  ((0,46,5),(0,46,5),UnicodeCategory::FinalPunctuation),
  ((0,46,6),(0,46,8),UnicodeCategory::OtherPunctuation),
  ((0,46,9),(0,46,9),UnicodeCategory::InitialPunctuation),
  ((0,46,10),(0,46,10),UnicodeCategory::FinalPunctuation),
  ((0,46,11),(0,46,11),UnicodeCategory::OtherPunctuation),
  ((0,46,12),(0,46,12),UnicodeCategory::InitialPunctuation),
  ((0,46,13),(0,46,13),UnicodeCategory::FinalPunctuation),
  ((0,46,14),(0,46,22),UnicodeCategory::OtherPunctuation),
  ((0,46,23),(0,46,23),UnicodeCategory::DashPunctuation),
  ((0,46,24),(0,46,25),UnicodeCategory::OtherPunctuation),
  ((0,46,26),(0,46,26),UnicodeCategory::DashPunctuation),
  ((0,46,27),(0,46,27),UnicodeCategory::OtherPunctuation),
  ((0,46,28),(0,46,28),UnicodeCategory::InitialPunctuation),
  ((0,46,29),(0,46,29),UnicodeCategory::FinalPunctuation),
  ((0,46,30),(0,46,31),UnicodeCategory::OtherPunctuation),
  ((0,46,32),(0,46,32),UnicodeCategory::InitialPunctuation),
  ((0,46,33),(0,46,33),UnicodeCategory::FinalPunctuation),
  ((0,46,34),(0,46,34),UnicodeCategory::OpenPunctuation),
  ((0,46,35),(0,46,35),UnicodeCategory::ClosePunctuation),
  ((0,46,36),(0,46,36),UnicodeCategory::OpenPunctuation),
  ((0,46,37),(0,46,37),UnicodeCategory::ClosePunctuation),
  ((0,46,38),(0,46,38),UnicodeCategory::OpenPunctuation),
  ((0,46,39),(0,46,39),UnicodeCategory::ClosePunctuation),
  ((0,46,40),(0,46,40),UnicodeCategory::OpenPunctuation),
  ((0,46,41),(0,46,41),UnicodeCategory::ClosePunctuation),
  ((0,46,42),(0,46,46),UnicodeCategory::OtherPunctuation),
  ((0,46,47),(0,46,47),UnicodeCategory::ModifierLetter),
  ((0,46,48),(0,46,57),UnicodeCategory::OtherPunctuation),
  ((0,46,58),(0,46,59),UnicodeCategory::DashPunctuation),
  ((0,46,60),(0,46,63),UnicodeCategory::OtherPunctuation),
  ((0,46,64),(0,46,64),UnicodeCategory::DashPunctuation),
  ((0,46,65),(0,46,65),UnicodeCategory::OtherPunctuation),
  ((0,46,66),(0,46,66),UnicodeCategory::OpenPunctuation),
  ((0,46,67),(0,46,68),UnicodeCategory::OtherPunctuation),
  ((0,46,128),(0,46,153),UnicodeCategory::OtherSymbol),
  ((0,46,155),(0,46,243),UnicodeCategory::OtherSymbol),
  ((0,47,0),(0,47,213),UnicodeCategory::OtherSymbol),
  ((0,47,240),(0,47,251),UnicodeCategory::OtherSymbol),
  ((0,48,0),(0,48,0),UnicodeCategory::SpaceSeparator),
  ((0,48,1),(0,48,3),UnicodeCategory::OtherPunctuation),
  ((0,48,4),(0,48,4),UnicodeCategory::OtherSymbol),
  ((0,48,5),(0,48,5),UnicodeCategory::ModifierLetter),
  ((0,48,6),(0,48,6),UnicodeCategory::OtherLetter),
  ((0,48,7),(0,48,7),UnicodeCategory::LetterNumber),
  ((0,48,8),(0,48,8),UnicodeCategory::OpenPunctuation),
  ((0,48,9),(0,48,9),UnicodeCategory::ClosePunctuation),
  ((0,48,10),(0,48,10),UnicodeCategory::OpenPunctuation),
  ((0,48,11),(0,48,11),UnicodeCategory::ClosePunctuation),
  ((0,48,12),(0,48,12),UnicodeCategory::OpenPunctuation),
  ((0,48,13),(0,48,13),UnicodeCategory::ClosePunctuation),
  ((0,48,14),(0,48,14),UnicodeCategory::OpenPunctuation),
  ((0,48,15),(0,48,15),UnicodeCategory::ClosePunctuation),
  ((0,48,16),(0,48,16),UnicodeCategory::OpenPunctuation),
  ((0,48,17),(0,48,17),UnicodeCategory::ClosePunctuation),
  ((0,48,18),(0,48,19),UnicodeCategory::OtherSymbol),
  ((0,48,20),(0,48,20),UnicodeCategory::OpenPunctuation),
  ((0,48,21),(0,48,21),UnicodeCategory::ClosePunctuation),
  ((0,48,22),(0,48,22),UnicodeCategory::OpenPunctuation),
  ((0,48,23),(0,48,23),UnicodeCategory::ClosePunctuation),
  ((0,48,24),(0,48,24),UnicodeCategory::OpenPunctuation),
  ((0,48,25),(0,48,25),UnicodeCategory::ClosePunctuation),
  ((0,48,26),(0,48,26),UnicodeCategory::OpenPunctuation),
  ((0,48,27),(0,48,27),UnicodeCategory::ClosePunctuation),
  ((0,48,28),(0,48,28),UnicodeCategory::DashPunctuation),
  ((0,48,29),(0,48,29),UnicodeCategory::OpenPunctuation),
  ((0,48,30),(0,48,31),UnicodeCategory::ClosePunctuation),
  ((0,48,32),(0,48,32),UnicodeCategory::OtherSymbol),
  ((0,48,33),(0,48,41),UnicodeCategory::LetterNumber),
  ((0,48,42),(0,48,45),UnicodeCategory::NonspacingMark),
  ((0,48,46),(0,48,47),UnicodeCategory::SpacingMark),
  ((0,48,48),(0,48,48),UnicodeCategory::DashPunctuation),
  ((0,48,49),(0,48,53),UnicodeCategory::ModifierLetter),
  ((0,48,54),(0,48,55),UnicodeCategory::OtherSymbol),
  ((0,48,56),(0,48,58),UnicodeCategory::LetterNumber),
  ((0,48,59),(0,48,59),UnicodeCategory::ModifierLetter),
  ((0,48,60),(0,48,60),UnicodeCategory::OtherLetter),
  ((0,48,61),(0,48,61),UnicodeCategory::OtherPunctuation),
  ((0,48,62),(0,48,63),UnicodeCategory::OtherSymbol),
  ((0,48,65),(0,48,150),UnicodeCategory::OtherLetter),
  ((0,48,153),(0,48,154),UnicodeCategory::NonspacingMark),
  ((0,48,155),(0,48,156),UnicodeCategory::ModifierSymbol),
  ((0,48,157),(0,48,158),UnicodeCategory::ModifierLetter),
  ((0,48,159),(0,48,159),UnicodeCategory::OtherLetter),
  ((0,48,160),(0,48,160),UnicodeCategory::DashPunctuation),
  ((0,48,161),(0,48,250),UnicodeCategory::OtherLetter),
  ((0,48,251),(0,48,251),UnicodeCategory::OtherPunctuation),
  ((0,48,252),(0,48,254),UnicodeCategory::ModifierLetter),
  ((0,48,255),(0,48,255),UnicodeCategory::OtherLetter),
  ((0,49,5),(0,49,45),UnicodeCategory::OtherLetter),
  ((0,49,49),(0,49,142),UnicodeCategory::OtherLetter),
  ((0,49,144),(0,49,145),UnicodeCategory::OtherSymbol),
  ((0,49,146),(0,49,149),UnicodeCategory::OtherNumber),
  ((0,49,150),(0,49,159),UnicodeCategory::OtherSymbol),
  ((0,49,160),(0,49,186),UnicodeCategory::OtherLetter),
  ((0,49,192),(0,49,227),UnicodeCategory::OtherSymbol),
  ((0,49,240),(0,49,255),UnicodeCategory::OtherLetter),
  ((0,50,0),(0,50,30),UnicodeCategory::OtherSymbol),
  ((0,50,32),(0,50,41),UnicodeCategory::OtherNumber),
  ((0,50,42),(0,50,71),UnicodeCategory::OtherSymbol),
  ((0,50,72),(0,50,79),UnicodeCategory::OtherNumber),
  ((0,50,80),(0,50,80),UnicodeCategory::OtherSymbol),
  ((0,50,81),(0,50,95),UnicodeCategory::OtherNumber),
  ((0,50,96),(0,50,127),UnicodeCategory::OtherSymbol),
  ((0,50,128),(0,50,137),UnicodeCategory::OtherNumber),
  ((0,50,138),(0,50,176),UnicodeCategory::OtherSymbol),
  ((0,50,177),(0,50,191),UnicodeCategory::OtherNumber),
  ((0,50,192),(0,50,254),UnicodeCategory::OtherSymbol),
  ((0,51,0),(0,51,255),UnicodeCategory::OtherSymbol),
  ((0,52,0),(0,77,181),UnicodeCategory::OtherLetter),
  ((0,77,192),(0,77,255),UnicodeCategory::OtherSymbol),
  ((0,78,0),(0,159,213),UnicodeCategory::OtherLetter),
  ((0,160,0),(0,160,20),UnicodeCategory::OtherLetter),
  ((0,160,21),(0,160,21),UnicodeCategory::ModifierLetter),
  ((0,160,22),(0,164,140),UnicodeCategory::OtherLetter),
  ((0,164,144),(0,164,198),UnicodeCategory::OtherSymbol),
  ((0,164,208),(0,164,247),UnicodeCategory::OtherLetter),
  ((0,164,248),(0,164,253),UnicodeCategory::ModifierLetter),
  ((0,164,254),(0,164,255),UnicodeCategory::OtherPunctuation),
  ((0,165,0),(0,166,11),UnicodeCategory::OtherLetter),
  ((0,166,12),(0,166,12),UnicodeCategory::ModifierLetter),
  ((0,166,13),(0,166,15),UnicodeCategory::OtherPunctuation),
  ((0,166,16),(0,166,31),UnicodeCategory::OtherLetter),
  ((0,166,32),(0,166,41),UnicodeCategory::DecimalNumber),
  ((0,166,42),(0,166,43),UnicodeCategory::OtherLetter),
  ((0,166,64),(0,166,64),UnicodeCategory::UppercaseLetter),
  ((0,166,65),(0,166,65),UnicodeCategory::LowercaseLetter),
  ((0,166,66),(0,166,66),UnicodeCategory::UppercaseLetter),
  ((0,166,67),(0,166,67),UnicodeCategory::LowercaseLetter),
  ((0,166,68),(0,166,68),UnicodeCategory::UppercaseLetter),
  ((0,166,69),(0,166,69),UnicodeCategory::LowercaseLetter),
  ((0,166,70),(0,166,70),UnicodeCategory::UppercaseLetter),
  ((0,166,71),(0,166,71),UnicodeCategory::LowercaseLetter),
  ((0,166,72),(0,166,72),UnicodeCategory::UppercaseLetter),
  ((0,166,73),(0,166,73),UnicodeCategory::LowercaseLetter),
  ((0,166,74),(0,166,74),UnicodeCategory::UppercaseLetter),
  ((0,166,75),(0,166,75),UnicodeCategory::LowercaseLetter),
  ((0,166,76),(0,166,76),UnicodeCategory::UppercaseLetter),
  ((0,166,77),(0,166,77),UnicodeCategory::LowercaseLetter),
  ((0,166,78),(0,166,78),UnicodeCategory::UppercaseLetter),
  ((0,166,79),(0,166,79),UnicodeCategory::LowercaseLetter),
  ((0,166,80),(0,166,80),UnicodeCategory::UppercaseLetter),
  ((0,166,81),(0,166,81),UnicodeCategory::LowercaseLetter),
  ((0,166,82),(0,166,82),UnicodeCategory::UppercaseLetter),
  ((0,166,83),(0,166,83),UnicodeCategory::LowercaseLetter),
  ((0,166,84),(0,166,84),UnicodeCategory::UppercaseLetter),
  ((0,166,85),(0,166,85),UnicodeCategory::LowercaseLetter),
  ((0,166,86),(0,166,86),UnicodeCategory::UppercaseLetter),
  ((0,166,87),(0,166,87),UnicodeCategory::LowercaseLetter),
  ((0,166,88),(0,166,88),UnicodeCategory::UppercaseLetter),
  ((0,166,89),(0,166,89),UnicodeCategory::LowercaseLetter),
  ((0,166,90),(0,166,90),UnicodeCategory::UppercaseLetter),
  ((0,166,91),(0,166,91),UnicodeCategory::LowercaseLetter),
  ((0,166,92),(0,166,92),UnicodeCategory::UppercaseLetter),
  ((0,166,93),(0,166,93),UnicodeCategory::LowercaseLetter),
  ((0,166,94),(0,166,94),UnicodeCategory::UppercaseLetter),
  ((0,166,95),(0,166,95),UnicodeCategory::LowercaseLetter),
  ((0,166,96),(0,166,96),UnicodeCategory::UppercaseLetter),
  ((0,166,97),(0,166,97),UnicodeCategory::LowercaseLetter),
  ((0,166,98),(0,166,98),UnicodeCategory::UppercaseLetter),
  ((0,166,99),(0,166,99),UnicodeCategory::LowercaseLetter),
  ((0,166,100),(0,166,100),UnicodeCategory::UppercaseLetter),
  ((0,166,101),(0,166,101),UnicodeCategory::LowercaseLetter),
  ((0,166,102),(0,166,102),UnicodeCategory::UppercaseLetter),
  ((0,166,103),(0,166,103),UnicodeCategory::LowercaseLetter),
  ((0,166,104),(0,166,104),UnicodeCategory::UppercaseLetter),
  ((0,166,105),(0,166,105),UnicodeCategory::LowercaseLetter),
  ((0,166,106),(0,166,106),UnicodeCategory::UppercaseLetter),
  ((0,166,107),(0,166,107),UnicodeCategory::LowercaseLetter),
  ((0,166,108),(0,166,108),UnicodeCategory::UppercaseLetter),
  ((0,166,109),(0,166,109),UnicodeCategory::LowercaseLetter),
  ((0,166,110),(0,166,110),UnicodeCategory::OtherLetter),
  ((0,166,111),(0,166,111),UnicodeCategory::NonspacingMark),
  ((0,166,112),(0,166,114),UnicodeCategory::EnclosingMark),
  ((0,166,115),(0,166,115),UnicodeCategory::OtherPunctuation),
  ((0,166,116),(0,166,125),UnicodeCategory::NonspacingMark),
  ((0,166,126),(0,166,126),UnicodeCategory::OtherPunctuation),
  ((0,166,127),(0,166,127),UnicodeCategory::ModifierLetter),
  ((0,166,128),(0,166,128),UnicodeCategory::UppercaseLetter),
  ((0,166,129),(0,166,129),UnicodeCategory::LowercaseLetter),
  ((0,166,130),(0,166,130),UnicodeCategory::UppercaseLetter),
  ((0,166,131),(0,166,131),UnicodeCategory::LowercaseLetter),
  ((0,166,132),(0,166,132),UnicodeCategory::UppercaseLetter),
  ((0,166,133),(0,166,133),UnicodeCategory::LowercaseLetter),
  ((0,166,134),(0,166,134),UnicodeCategory::UppercaseLetter),
  ((0,166,135),(0,166,135),UnicodeCategory::LowercaseLetter),
  ((0,166,136),(0,166,136),UnicodeCategory::UppercaseLetter),
  ((0,166,137),(0,166,137),UnicodeCategory::LowercaseLetter),
  ((0,166,138),(0,166,138),UnicodeCategory::UppercaseLetter),
  ((0,166,139),(0,166,139),UnicodeCategory::LowercaseLetter),
  ((0,166,140),(0,166,140),UnicodeCategory::UppercaseLetter),
  ((0,166,141),(0,166,141),UnicodeCategory::LowercaseLetter),
  ((0,166,142),(0,166,142),UnicodeCategory::UppercaseLetter),
  ((0,166,143),(0,166,143),UnicodeCategory::LowercaseLetter),
  ((0,166,144),(0,166,144),UnicodeCategory::UppercaseLetter),
  ((0,166,145),(0,166,145),UnicodeCategory::LowercaseLetter),
  ((0,166,146),(0,166,146),UnicodeCategory::UppercaseLetter),
  ((0,166,147),(0,166,147),UnicodeCategory::LowercaseLetter),
  ((0,166,148),(0,166,148),UnicodeCategory::UppercaseLetter),
  ((0,166,149),(0,166,149),UnicodeCategory::LowercaseLetter),
  ((0,166,150),(0,166,150),UnicodeCategory::UppercaseLetter),
  ((0,166,151),(0,166,151),UnicodeCategory::LowercaseLetter),
  ((0,166,152),(0,166,152),UnicodeCategory::UppercaseLetter),
  ((0,166,153),(0,166,153),UnicodeCategory::LowercaseLetter),
  ((0,166,154),(0,166,154),UnicodeCategory::UppercaseLetter),
  ((0,166,155),(0,166,155),UnicodeCategory::LowercaseLetter),
  ((0,166,156),(0,166,157),UnicodeCategory::ModifierLetter),
  ((0,166,158),(0,166,159),UnicodeCategory::NonspacingMark),
  ((0,166,160),(0,166,229),UnicodeCategory::OtherLetter),
  ((0,166,230),(0,166,239),UnicodeCategory::LetterNumber),
  ((0,166,240),(0,166,241),UnicodeCategory::NonspacingMark),
  ((0,166,242),(0,166,247),UnicodeCategory::OtherPunctuation),
  ((0,167,0),(0,167,22),UnicodeCategory::ModifierSymbol),
  ((0,167,23),(0,167,31),UnicodeCategory::ModifierLetter),
  ((0,167,32),(0,167,33),UnicodeCategory::ModifierSymbol),
  ((0,167,34),(0,167,34),UnicodeCategory::UppercaseLetter),
  ((0,167,35),(0,167,35),UnicodeCategory::LowercaseLetter),
  ((0,167,36),(0,167,36),UnicodeCategory::UppercaseLetter),
  ((0,167,37),(0,167,37),UnicodeCategory::LowercaseLetter),
  ((0,167,38),(0,167,38),UnicodeCategory::UppercaseLetter),
  ((0,167,39),(0,167,39),UnicodeCategory::LowercaseLetter),
  ((0,167,40),(0,167,40),UnicodeCategory::UppercaseLetter),
  ((0,167,41),(0,167,41),UnicodeCategory::LowercaseLetter),
  ((0,167,42),(0,167,42),UnicodeCategory::UppercaseLetter),
  ((0,167,43),(0,167,43),UnicodeCategory::LowercaseLetter),
  ((0,167,44),(0,167,44),UnicodeCategory::UppercaseLetter),
  ((0,167,45),(0,167,45),UnicodeCategory::LowercaseLetter),
  ((0,167,46),(0,167,46),UnicodeCategory::UppercaseLetter),
  ((0,167,47),(0,167,49),UnicodeCategory::LowercaseLetter),
  ((0,167,50),(0,167,50),UnicodeCategory::UppercaseLetter),
  ((0,167,51),(0,167,51),UnicodeCategory::LowercaseLetter),
  ((0,167,52),(0,167,52),UnicodeCategory::UppercaseLetter),
  ((0,167,53),(0,167,53),UnicodeCategory::LowercaseLetter),
  ((0,167,54),(0,167,54),UnicodeCategory::UppercaseLetter),
  ((0,167,55),(0,167,55),UnicodeCategory::LowercaseLetter),
  ((0,167,56),(0,167,56),UnicodeCategory::UppercaseLetter),
  ((0,167,57),(0,167,57),UnicodeCategory::LowercaseLetter),
  ((0,167,58),(0,167,58),UnicodeCategory::UppercaseLetter),
  ((0,167,59),(0,167,59),UnicodeCategory::LowercaseLetter),
  ((0,167,60),(0,167,60),UnicodeCategory::UppercaseLetter),
  ((0,167,61),(0,167,61),UnicodeCategory::LowercaseLetter),
  ((0,167,62),(0,167,62),UnicodeCategory::UppercaseLetter),
  ((0,167,63),(0,167,63),UnicodeCategory::LowercaseLetter),
  ((0,167,64),(0,167,64),UnicodeCategory::UppercaseLetter),
  ((0,167,65),(0,167,65),UnicodeCategory::LowercaseLetter),
  ((0,167,66),(0,167,66),UnicodeCategory::UppercaseLetter),
  ((0,167,67),(0,167,67),UnicodeCategory::LowercaseLetter),
  ((0,167,68),(0,167,68),UnicodeCategory::UppercaseLetter),
  ((0,167,69),(0,167,69),UnicodeCategory::LowercaseLetter),
  ((0,167,70),(0,167,70),UnicodeCategory::UppercaseLetter),
  ((0,167,71),(0,167,71),UnicodeCategory::LowercaseLetter),
  ((0,167,72),(0,167,72),UnicodeCategory::UppercaseLetter),
  ((0,167,73),(0,167,73),UnicodeCategory::LowercaseLetter),
  ((0,167,74),(0,167,74),UnicodeCategory::UppercaseLetter),
  ((0,167,75),(0,167,75),UnicodeCategory::LowercaseLetter),
  ((0,167,76),(0,167,76),UnicodeCategory::UppercaseLetter),
  ((0,167,77),(0,167,77),UnicodeCategory::LowercaseLetter),
  ((0,167,78),(0,167,78),UnicodeCategory::UppercaseLetter),
  ((0,167,79),(0,167,79),UnicodeCategory::LowercaseLetter),
  ((0,167,80),(0,167,80),UnicodeCategory::UppercaseLetter),
  ((0,167,81),(0,167,81),UnicodeCategory::LowercaseLetter),
  ((0,167,82),(0,167,82),UnicodeCategory::UppercaseLetter),
  ((0,167,83),(0,167,83),UnicodeCategory::LowercaseLetter),
  ((0,167,84),(0,167,84),UnicodeCategory::UppercaseLetter),
  ((0,167,85),(0,167,85),UnicodeCategory::LowercaseLetter),
  ((0,167,86),(0,167,86),UnicodeCategory::UppercaseLetter),
  ((0,167,87),(0,167,87),UnicodeCategory::LowercaseLetter),
  ((0,167,88),(0,167,88),UnicodeCategory::UppercaseLetter),
  ((0,167,89),(0,167,89),UnicodeCategory::LowercaseLetter),
  ((0,167,90),(0,167,90),UnicodeCategory::UppercaseLetter),
  ((0,167,91),(0,167,91),UnicodeCategory::LowercaseLetter),
  ((0,167,92),(0,167,92),UnicodeCategory::UppercaseLetter),
  ((0,167,93),(0,167,93),UnicodeCategory::LowercaseLetter),
  ((0,167,94),(0,167,94),UnicodeCategory::UppercaseLetter),
  ((0,167,95),(0,167,95),UnicodeCategory::LowercaseLetter),
  ((0,167,96),(0,167,96),UnicodeCategory::UppercaseLetter),
  ((0,167,97),(0,167,97),UnicodeCategory::LowercaseLetter),
  ((0,167,98),(0,167,98),UnicodeCategory::UppercaseLetter),
  ((0,167,99),(0,167,99),UnicodeCategory::LowercaseLetter),
  ((0,167,100),(0,167,100),UnicodeCategory::UppercaseLetter),
  ((0,167,101),(0,167,101),UnicodeCategory::LowercaseLetter),
  ((0,167,102),(0,167,102),UnicodeCategory::UppercaseLetter),
  ((0,167,103),(0,167,103),UnicodeCategory::LowercaseLetter),
  ((0,167,104),(0,167,104),UnicodeCategory::UppercaseLetter),
  ((0,167,105),(0,167,105),UnicodeCategory::LowercaseLetter),
  ((0,167,106),(0,167,106),UnicodeCategory::UppercaseLetter),
  ((0,167,107),(0,167,107),UnicodeCategory::LowercaseLetter),
  ((0,167,108),(0,167,108),UnicodeCategory::UppercaseLetter),
  ((0,167,109),(0,167,109),UnicodeCategory::LowercaseLetter),
  ((0,167,110),(0,167,110),UnicodeCategory::UppercaseLetter),
  ((0,167,111),(0,167,111),UnicodeCategory::LowercaseLetter),
  ((0,167,112),(0,167,112),UnicodeCategory::ModifierLetter),
  ((0,167,113),(0,167,120),UnicodeCategory::LowercaseLetter),
  ((0,167,121),(0,167,121),UnicodeCategory::UppercaseLetter),
  ((0,167,122),(0,167,122),UnicodeCategory::LowercaseLetter),
  ((0,167,123),(0,167,123),UnicodeCategory::UppercaseLetter),
  ((0,167,124),(0,167,124),UnicodeCategory::LowercaseLetter),
  ((0,167,125),(0,167,126),UnicodeCategory::UppercaseLetter),
  ((0,167,127),(0,167,127),UnicodeCategory::LowercaseLetter),
  ((0,167,128),(0,167,128),UnicodeCategory::UppercaseLetter),
  ((0,167,129),(0,167,129),UnicodeCategory::LowercaseLetter),
  ((0,167,130),(0,167,130),UnicodeCategory::UppercaseLetter),
  ((0,167,131),(0,167,131),UnicodeCategory::LowercaseLetter),
  ((0,167,132),(0,167,132),UnicodeCategory::UppercaseLetter),
  ((0,167,133),(0,167,133),UnicodeCategory::LowercaseLetter),
  ((0,167,134),(0,167,134),UnicodeCategory::UppercaseLetter),
  ((0,167,135),(0,167,135),UnicodeCategory::LowercaseLetter),
  ((0,167,136),(0,167,136),UnicodeCategory::ModifierLetter),
  ((0,167,137),(0,167,138),UnicodeCategory::ModifierSymbol),
  ((0,167,139),(0,167,139),UnicodeCategory::UppercaseLetter),
  ((0,167,140),(0,167,140),UnicodeCategory::LowercaseLetter),
  ((0,167,141),(0,167,141),UnicodeCategory::UppercaseLetter),
  ((0,167,142),(0,167,142),UnicodeCategory::LowercaseLetter),
  ((0,167,143),(0,167,143),UnicodeCategory::OtherLetter),
  ((0,167,144),(0,167,144),UnicodeCategory::UppercaseLetter),
  ((0,167,145),(0,167,145),UnicodeCategory::LowercaseLetter),
  ((0,167,146),(0,167,146),UnicodeCategory::UppercaseLetter),
  ((0,167,147),(0,167,149),UnicodeCategory::LowercaseLetter),
  ((0,167,150),(0,167,150),UnicodeCategory::UppercaseLetter),
  ((0,167,151),(0,167,151),UnicodeCategory::LowercaseLetter),
  ((0,167,152),(0,167,152),UnicodeCategory::UppercaseLetter),
  ((0,167,153),(0,167,153),UnicodeCategory::LowercaseLetter),
  ((0,167,154),(0,167,154),UnicodeCategory::UppercaseLetter),
  ((0,167,155),(0,167,155),UnicodeCategory::LowercaseLetter),
  ((0,167,156),(0,167,156),UnicodeCategory::UppercaseLetter),
  ((0,167,157),(0,167,157),UnicodeCategory::LowercaseLetter),
  ((0,167,158),(0,167,158),UnicodeCategory::UppercaseLetter),
  ((0,167,159),(0,167,159),UnicodeCategory::LowercaseLetter),
  ((0,167,160),(0,167,160),UnicodeCategory::UppercaseLetter),
  ((0,167,161),(0,167,161),UnicodeCategory::LowercaseLetter),
  ((0,167,162),(0,167,162),UnicodeCategory::UppercaseLetter),
  ((0,167,163),(0,167,163),UnicodeCategory::LowercaseLetter),
  ((0,167,164),(0,167,164),UnicodeCategory::UppercaseLetter),
  ((0,167,165),(0,167,165),UnicodeCategory::LowercaseLetter),
  ((0,167,166),(0,167,166),UnicodeCategory::UppercaseLetter),
  ((0,167,167),(0,167,167),UnicodeCategory::LowercaseLetter),
  ((0,167,168),(0,167,168),UnicodeCategory::UppercaseLetter),
  ((0,167,169),(0,167,169),UnicodeCategory::LowercaseLetter),
  ((0,167,170),(0,167,174),UnicodeCategory::UppercaseLetter),
  ((0,167,176),(0,167,180),UnicodeCategory::UppercaseLetter),
  ((0,167,181),(0,167,181),UnicodeCategory::LowercaseLetter),
  ((0,167,182),(0,167,182),UnicodeCategory::UppercaseLetter),
  ((0,167,183),(0,167,183),UnicodeCategory::LowercaseLetter),
  ((0,167,247),(0,167,247),UnicodeCategory::OtherLetter),
  ((0,167,248),(0,167,249),UnicodeCategory::ModifierLetter),
  ((0,167,250),(0,167,250),UnicodeCategory::LowercaseLetter),
  ((0,167,251),(0,168,1),UnicodeCategory::OtherLetter),
  ((0,168,2),(0,168,2),UnicodeCategory::NonspacingMark),
  ((0,168,3),(0,168,5),UnicodeCategory::OtherLetter),
  ((0,168,6),(0,168,6),UnicodeCategory::NonspacingMark),
  ((0,168,7),(0,168,10),UnicodeCategory::OtherLetter),
  ((0,168,11),(0,168,11),UnicodeCategory::NonspacingMark),
  ((0,168,12),(0,168,34),UnicodeCategory::OtherLetter),
  ((0,168,35),(0,168,36),UnicodeCategory::SpacingMark),
  ((0,168,37),(0,168,38),UnicodeCategory::NonspacingMark),
  ((0,168,39),(0,168,39),UnicodeCategory::SpacingMark),
  ((0,168,40),(0,168,43),UnicodeCategory::OtherSymbol),
  ((0,168,48),(0,168,53),UnicodeCategory::OtherNumber),
  ((0,168,54),(0,168,55),UnicodeCategory::OtherSymbol),
  ((0,168,56),(0,168,56),UnicodeCategory::CurrencySymbol),
  ((0,168,57),(0,168,57),UnicodeCategory::OtherSymbol),
  ((0,168,64),(0,168,115),UnicodeCategory::OtherLetter),
  ((0,168,116),(0,168,119),UnicodeCategory::OtherPunctuation),
  ((0,168,128),(0,168,129),UnicodeCategory::SpacingMark),
  ((0,168,130),(0,168,179),UnicodeCategory::OtherLetter),
  ((0,168,180),(0,168,195),UnicodeCategory::SpacingMark),
  ((0,168,196),(0,168,197),UnicodeCategory::NonspacingMark),
  ((0,168,206),(0,168,207),UnicodeCategory::OtherPunctuation),
  ((0,168,208),(0,168,217),UnicodeCategory::DecimalNumber),
  ((0,168,224),(0,168,241),UnicodeCategory::NonspacingMark),
  ((0,168,242),(0,168,247),UnicodeCategory::OtherLetter),
  ((0,168,248),(0,168,250),UnicodeCategory::OtherPunctuation),
  ((0,168,251),(0,168,251),UnicodeCategory::OtherLetter),
  ((0,168,252),(0,168,252),UnicodeCategory::OtherPunctuation),
  ((0,168,253),(0,168,253),UnicodeCategory::OtherLetter),
  ((0,169,0),(0,169,9),UnicodeCategory::DecimalNumber),
  ((0,169,10),(0,169,37),UnicodeCategory::OtherLetter),
  ((0,169,38),(0,169,45),UnicodeCategory::NonspacingMark),
  ((0,169,46),(0,169,47),UnicodeCategory::OtherPunctuation),
  ((0,169,48),(0,169,70),UnicodeCategory::OtherLetter),
  ((0,169,71),(0,169,81),UnicodeCategory::NonspacingMark),
  ((0,169,82),(0,169,83),UnicodeCategory::SpacingMark),
  ((0,169,95),(0,169,95),UnicodeCategory::OtherPunctuation),
  ((0,169,96),(0,169,124),UnicodeCategory::OtherLetter),
  ((0,169,128),(0,169,130),UnicodeCategory::NonspacingMark),
  ((0,169,131),(0,169,131),UnicodeCategory::SpacingMark),
  ((0,169,132),(0,169,178),UnicodeCategory::OtherLetter),
  ((0,169,179),(0,169,179),UnicodeCategory::NonspacingMark),
  ((0,169,180),(0,169,181),UnicodeCategory::SpacingMark),
  ((0,169,182),(0,169,185),UnicodeCategory::NonspacingMark),
  ((0,169,186),(0,169,187),UnicodeCategory::SpacingMark),
  ((0,169,188),(0,169,188),UnicodeCategory::NonspacingMark),
  ((0,169,189),(0,169,192),UnicodeCategory::SpacingMark),
  ((0,169,193),(0,169,205),UnicodeCategory::OtherPunctuation),
  ((0,169,207),(0,169,207),UnicodeCategory::ModifierLetter),
  ((0,169,208),(0,169,217),UnicodeCategory::DecimalNumber),
  ((0,169,222),(0,169,223),UnicodeCategory::OtherPunctuation),
  ((0,169,224),(0,169,228),UnicodeCategory::OtherLetter),
  ((0,169,229),(0,169,229),UnicodeCategory::NonspacingMark),
  ((0,169,230),(0,169,230),UnicodeCategory::ModifierLetter),
  ((0,169,231),(0,169,239),UnicodeCategory::OtherLetter),
  ((0,169,240),(0,169,249),UnicodeCategory::DecimalNumber),
  ((0,169,250),(0,169,254),UnicodeCategory::OtherLetter),
  ((0,170,0),(0,170,40),UnicodeCategory::OtherLetter),
  ((0,170,41),(0,170,46),UnicodeCategory::NonspacingMark),
  ((0,170,47),(0,170,48),UnicodeCategory::SpacingMark),
  ((0,170,49),(0,170,50),UnicodeCategory::NonspacingMark),
  ((0,170,51),(0,170,52),UnicodeCategory::SpacingMark),
  ((0,170,53),(0,170,54),UnicodeCategory::NonspacingMark),
  ((0,170,64),(0,170,66),UnicodeCategory::OtherLetter),
  ((0,170,67),(0,170,67),UnicodeCategory::NonspacingMark),
  ((0,170,68),(0,170,75),UnicodeCategory::OtherLetter),
  ((0,170,76),(0,170,76),UnicodeCategory::NonspacingMark),
  ((0,170,77),(0,170,77),UnicodeCategory::SpacingMark),
  ((0,170,80),(0,170,89),UnicodeCategory::DecimalNumber),
  ((0,170,92),(0,170,95),UnicodeCategory::OtherPunctuation),
  ((0,170,96),(0,170,111),UnicodeCategory::OtherLetter),
  ((0,170,112),(0,170,112),UnicodeCategory::ModifierLetter),
  ((0,170,113),(0,170,118),UnicodeCategory::OtherLetter),
  ((0,170,119),(0,170,121),UnicodeCategory::OtherSymbol),
  ((0,170,122),(0,170,122),UnicodeCategory::OtherLetter),
  ((0,170,123),(0,170,123),UnicodeCategory::SpacingMark),
  ((0,170,124),(0,170,124),UnicodeCategory::NonspacingMark),
  ((0,170,125),(0,170,125),UnicodeCategory::SpacingMark),
  ((0,170,126),(0,170,175),UnicodeCategory::OtherLetter),
  ((0,170,176),(0,170,176),UnicodeCategory::NonspacingMark),
  ((0,170,177),(0,170,177),UnicodeCategory::OtherLetter),
  ((0,170,178),(0,170,180),UnicodeCategory::NonspacingMark),
  ((0,170,181),(0,170,182),UnicodeCategory::OtherLetter),
  ((0,170,183),(0,170,184),UnicodeCategory::NonspacingMark),
  ((0,170,185),(0,170,189),UnicodeCategory::OtherLetter),
  ((0,170,190),(0,170,191),UnicodeCategory::NonspacingMark),
  ((0,170,192),(0,170,192),UnicodeCategory::OtherLetter),
  ((0,170,193),(0,170,193),UnicodeCategory::NonspacingMark),
  ((0,170,194),(0,170,194),UnicodeCategory::OtherLetter),
  ((0,170,219),(0,170,220),UnicodeCategory::OtherLetter),
  ((0,170,221),(0,170,221),UnicodeCategory::ModifierLetter),
  ((0,170,222),(0,170,223),UnicodeCategory::OtherPunctuation),
  ((0,170,224),(0,170,234),UnicodeCategory::OtherLetter),
  ((0,170,235),(0,170,235),UnicodeCategory::SpacingMark),
  ((0,170,236),(0,170,237),UnicodeCategory::NonspacingMark),
  ((0,170,238),(0,170,239),UnicodeCategory::SpacingMark),
  ((0,170,240),(0,170,241),UnicodeCategory::OtherPunctuation),
  ((0,170,242),(0,170,242),UnicodeCategory::OtherLetter),
  ((0,170,243),(0,170,244),UnicodeCategory::ModifierLetter),
  ((0,170,245),(0,170,245),UnicodeCategory::SpacingMark),
  ((0,170,246),(0,170,246),UnicodeCategory::NonspacingMark),
  ((0,171,1),(0,171,6),UnicodeCategory::OtherLetter),
  ((0,171,9),(0,171,14),UnicodeCategory::OtherLetter),
  ((0,171,17),(0,171,22),UnicodeCategory::OtherLetter),
  ((0,171,32),(0,171,38),UnicodeCategory::OtherLetter),
  ((0,171,40),(0,171,46),UnicodeCategory::OtherLetter),
  ((0,171,48),(0,171,90),UnicodeCategory::LowercaseLetter),
  ((0,171,91),(0,171,91),UnicodeCategory::ModifierSymbol),
  ((0,171,92),(0,171,95),UnicodeCategory::ModifierLetter),
  ((0,171,96),(0,171,101),UnicodeCategory::LowercaseLetter),
  ((0,171,112),(0,171,191),UnicodeCategory::LowercaseLetter),
  ((0,171,192),(0,171,226),UnicodeCategory::OtherLetter),
  ((0,171,227),(0,171,228),UnicodeCategory::SpacingMark),
  ((0,171,229),(0,171,229),UnicodeCategory::NonspacingMark),
  ((0,171,230),(0,171,231),UnicodeCategory::SpacingMark),
  ((0,171,232),(0,171,232),UnicodeCategory::NonspacingMark),
  ((0,171,233),(0,171,234),UnicodeCategory::SpacingMark),
  ((0,171,235),(0,171,235),UnicodeCategory::OtherPunctuation),
  ((0,171,236),(0,171,236),UnicodeCategory::SpacingMark),
  ((0,171,237),(0,171,237),UnicodeCategory::NonspacingMark),
  ((0,171,240),(0,171,249),UnicodeCategory::DecimalNumber),
  ((0,172,0),(0,215,163),UnicodeCategory::OtherLetter),
  ((0,215,176),(0,215,198),UnicodeCategory::OtherLetter),
  ((0,215,203),(0,215,251),UnicodeCategory::OtherLetter),
  ((0,216,0),(0,223,255),UnicodeCategory::Surrogate),
  ((0,224,0),(0,248,255),UnicodeCategory::PrivateUse),
  ((0,249,0),(0,250,109),UnicodeCategory::OtherLetter),
  ((0,250,112),(0,250,217),UnicodeCategory::OtherLetter),
  ((0,251,0),(0,251,6),UnicodeCategory::LowercaseLetter),
  ((0,251,19),(0,251,23),UnicodeCategory::LowercaseLetter),
  ((0,251,29),(0,251,29),UnicodeCategory::OtherLetter),
  ((0,251,30),(0,251,30),UnicodeCategory::NonspacingMark),
  ((0,251,31),(0,251,40),UnicodeCategory::OtherLetter),
  ((0,251,41),(0,251,41),UnicodeCategory::MathSymbol),
  ((0,251,42),(0,251,54),UnicodeCategory::OtherLetter),
  ((0,251,56),(0,251,60),UnicodeCategory::OtherLetter),
  ((0,251,62),(0,251,62),UnicodeCategory::OtherLetter),
  ((0,251,64),(0,251,65),UnicodeCategory::OtherLetter),
  ((0,251,67),(0,251,68),UnicodeCategory::OtherLetter),
  ((0,251,70),(0,251,177),UnicodeCategory::OtherLetter),
  ((0,251,178),(0,251,193),UnicodeCategory::ModifierSymbol),
  ((0,251,211),(0,253,61),UnicodeCategory::OtherLetter),
  ((0,253,62),(0,253,62),UnicodeCategory::ClosePunctuation),
  ((0,253,63),(0,253,63),UnicodeCategory::OpenPunctuation),
  ((0,253,80),(0,253,143),UnicodeCategory::OtherLetter),
  ((0,253,146),(0,253,199),UnicodeCategory::OtherLetter),
  ((0,253,240),(0,253,251),UnicodeCategory::OtherLetter),
  ((0,253,252),(0,253,252),UnicodeCategory::CurrencySymbol),
  ((0,253,253),(0,253,253),UnicodeCategory::OtherSymbol),
  ((0,254,0),(0,254,15),UnicodeCategory::NonspacingMark),
  ((0,254,16),(0,254,22),UnicodeCategory::OtherPunctuation),
  ((0,254,23),(0,254,23),UnicodeCategory::OpenPunctuation),
  ((0,254,24),(0,254,24),UnicodeCategory::ClosePunctuation),
  ((0,254,25),(0,254,25),UnicodeCategory::OtherPunctuation),
  ((0,254,32),(0,254,47),UnicodeCategory::NonspacingMark),
  ((0,254,48),(0,254,48),UnicodeCategory::OtherPunctuation),
  ((0,254,49),(0,254,50),UnicodeCategory::DashPunctuation),
  ((0,254,51),(0,254,52),UnicodeCategory::ConnectorPunctuation),
  ((0,254,53),(0,254,53),UnicodeCategory::OpenPunctuation),
  ((0,254,54),(0,254,54),UnicodeCategory::ClosePunctuation),
  ((0,254,55),(0,254,55),UnicodeCategory::OpenPunctuation),
  ((0,254,56),(0,254,56),UnicodeCategory::ClosePunctuation),
  ((0,254,57),(0,254,57),UnicodeCategory::OpenPunctuation),
  ((0,254,58),(0,254,58),UnicodeCategory::ClosePunctuation),
  ((0,254,59),(0,254,59),UnicodeCategory::OpenPunctuation),
  ((0,254,60),(0,254,60),UnicodeCategory::ClosePunctuation),
  ((0,254,61),(0,254,61),UnicodeCategory::OpenPunctuation),
  ((0,254,62),(0,254,62),UnicodeCategory::ClosePunctuation),
  ((0,254,63),(0,254,63),UnicodeCategory::OpenPunctuation),
  ((0,254,64),(0,254,64),UnicodeCategory::ClosePunctuation),
  ((0,254,65),(0,254,65),UnicodeCategory::OpenPunctuation),
  ((0,254,66),(0,254,66),UnicodeCategory::ClosePunctuation),
  ((0,254,67),(0,254,67),UnicodeCategory::OpenPunctuation),
  ((0,254,68),(0,254,68),UnicodeCategory::ClosePunctuation),
  ((0,254,69),(0,254,70),UnicodeCategory::OtherPunctuation),
  ((0,254,71),(0,254,71),UnicodeCategory::OpenPunctuation),
  ((0,254,72),(0,254,72),UnicodeCategory::ClosePunctuation),
  ((0,254,73),(0,254,76),UnicodeCategory::OtherPunctuation),
  ((0,254,77),(0,254,79),UnicodeCategory::ConnectorPunctuation),
  ((0,254,80),(0,254,82),UnicodeCategory::OtherPunctuation),
  ((0,254,84),(0,254,87),UnicodeCategory::OtherPunctuation),
  ((0,254,88),(0,254,88),UnicodeCategory::DashPunctuation),
  ((0,254,89),(0,254,89),UnicodeCategory::OpenPunctuation),
  ((0,254,90),(0,254,90),UnicodeCategory::ClosePunctuation),
  ((0,254,91),(0,254,91),UnicodeCategory::OpenPunctuation),
  ((0,254,92),(0,254,92),UnicodeCategory::ClosePunctuation),
  ((0,254,93),(0,254,93),UnicodeCategory::OpenPunctuation),
  ((0,254,94),(0,254,94),UnicodeCategory::ClosePunctuation),
  ((0,254,95),(0,254,97),UnicodeCategory::OtherPunctuation),
  ((0,254,98),(0,254,98),UnicodeCategory::MathSymbol),
  ((0,254,99),(0,254,99),UnicodeCategory::DashPunctuation),
  ((0,254,100),(0,254,102),UnicodeCategory::MathSymbol),
  ((0,254,104),(0,254,104),UnicodeCategory::OtherPunctuation),
  ((0,254,105),(0,254,105),UnicodeCategory::CurrencySymbol),
  ((0,254,106),(0,254,107),UnicodeCategory::OtherPunctuation),
  ((0,254,112),(0,254,116),UnicodeCategory::OtherLetter),
  ((0,254,118),(0,254,252),UnicodeCategory::OtherLetter),
  ((0,254,255),(0,254,255),UnicodeCategory::Format),
  ((0,255,1),(0,255,3),UnicodeCategory::OtherPunctuation),
  ((0,255,4),(0,255,4),UnicodeCategory::CurrencySymbol),
  ((0,255,5),(0,255,7),UnicodeCategory::OtherPunctuation),
  ((0,255,8),(0,255,8),UnicodeCategory::OpenPunctuation),
  ((0,255,9),(0,255,9),UnicodeCategory::ClosePunctuation),
  ((0,255,10),(0,255,10),UnicodeCategory::OtherPunctuation),
  ((0,255,11),(0,255,11),UnicodeCategory::MathSymbol),
  ((0,255,12),(0,255,12),UnicodeCategory::OtherPunctuation),
  ((0,255,13),(0,255,13),UnicodeCategory::DashPunctuation),
  ((0,255,14),(0,255,15),UnicodeCategory::OtherPunctuation),
  ((0,255,16),(0,255,25),UnicodeCategory::DecimalNumber),
  ((0,255,26),(0,255,27),UnicodeCategory::OtherPunctuation),
  ((0,255,28),(0,255,30),UnicodeCategory::MathSymbol),
  ((0,255,31),(0,255,32),UnicodeCategory::OtherPunctuation),
  ((0,255,33),(0,255,58),UnicodeCategory::UppercaseLetter),
  ((0,255,59),(0,255,59),UnicodeCategory::OpenPunctuation),
  ((0,255,60),(0,255,60),UnicodeCategory::OtherPunctuation),
  ((0,255,61),(0,255,61),UnicodeCategory::ClosePunctuation),
  ((0,255,62),(0,255,62),UnicodeCategory::ModifierSymbol),
  ((0,255,63),(0,255,63),UnicodeCategory::ConnectorPunctuation),
  ((0,255,64),(0,255,64),UnicodeCategory::ModifierSymbol),
  ((0,255,65),(0,255,90),UnicodeCategory::LowercaseLetter),
  ((0,255,91),(0,255,91),UnicodeCategory::OpenPunctuation),
  ((0,255,92),(0,255,92),UnicodeCategory::MathSymbol),
  ((0,255,93),(0,255,93),UnicodeCategory::ClosePunctuation),
  ((0,255,94),(0,255,94),UnicodeCategory::MathSymbol),
  ((0,255,95),(0,255,95),UnicodeCategory::OpenPunctuation),
  ((0,255,96),(0,255,96),UnicodeCategory::ClosePunctuation),
  ((0,255,97),(0,255,97),UnicodeCategory::OtherPunctuation),
  ((0,255,98),(0,255,98),UnicodeCategory::OpenPunctuation),
  ((0,255,99),(0,255,99),UnicodeCategory::ClosePunctuation),
  ((0,255,100),(0,255,101),UnicodeCategory::OtherPunctuation),
  ((0,255,102),(0,255,111),UnicodeCategory::OtherLetter),
  ((0,255,112),(0,255,112),UnicodeCategory::ModifierLetter),
  ((0,255,113),(0,255,157),UnicodeCategory::OtherLetter),
  ((0,255,158),(0,255,159),UnicodeCategory::ModifierLetter),
  ((0,255,160),(0,255,190),UnicodeCategory::OtherLetter),
  ((0,255,194),(0,255,199),UnicodeCategory::OtherLetter),
  ((0,255,202),(0,255,207),UnicodeCategory::OtherLetter),
  ((0,255,210),(0,255,215),UnicodeCategory::OtherLetter),
  ((0,255,218),(0,255,220),UnicodeCategory::OtherLetter),
  ((0,255,224),(0,255,225),UnicodeCategory::CurrencySymbol),
  ((0,255,226),(0,255,226),UnicodeCategory::MathSymbol),
  ((0,255,227),(0,255,227),UnicodeCategory::ModifierSymbol),
  ((0,255,228),(0,255,228),UnicodeCategory::OtherSymbol),
  ((0,255,229),(0,255,230),UnicodeCategory::CurrencySymbol),
  ((0,255,232),(0,255,232),UnicodeCategory::OtherSymbol),
  ((0,255,233),(0,255,236),UnicodeCategory::MathSymbol),
  ((0,255,237),(0,255,238),UnicodeCategory::OtherSymbol),
  ((0,255,249),(0,255,251),UnicodeCategory::Format),
  ((0,255,252),(0,255,253),UnicodeCategory::OtherSymbol),
  ((1,0,0),(1,0,11),UnicodeCategory::OtherLetter),
  ((1,0,13),(1,0,38),UnicodeCategory::OtherLetter),
  ((1,0,40),(1,0,58),UnicodeCategory::OtherLetter),
  ((1,0,60),(1,0,61),UnicodeCategory::OtherLetter),
  ((1,0,63),(1,0,77),UnicodeCategory::OtherLetter),
  ((1,0,80),(1,0,93),UnicodeCategory::OtherLetter),
  ((1,0,128),(1,0,250),UnicodeCategory::OtherLetter),
  ((1,1,0),(1,1,2),UnicodeCategory::OtherPunctuation),
  ((1,1,7),(1,1,51),UnicodeCategory::OtherNumber),
  ((1,1,55),(1,1,63),UnicodeCategory::OtherSymbol),
  ((1,1,64),(1,1,116),UnicodeCategory::LetterNumber),
  ((1,1,117),(1,1,120),UnicodeCategory::OtherNumber),
  ((1,1,121),(1,1,137),UnicodeCategory::OtherSymbol),
  ((1,1,138),(1,1,139),UnicodeCategory::OtherNumber),
  ((1,1,140),(1,1,142),UnicodeCategory::OtherSymbol),
  ((1,1,144),(1,1,155),UnicodeCategory::OtherSymbol),
  ((1,1,160),(1,1,160),UnicodeCategory::OtherSymbol),
  ((1,1,208),(1,1,252),UnicodeCategory::OtherSymbol),
  ((1,1,253),(1,1,253),UnicodeCategory::NonspacingMark),
  ((1,2,128),(1,2,156),UnicodeCategory::OtherLetter),
  ((1,2,160),(1,2,208),UnicodeCategory::OtherLetter),
  ((1,2,224),(1,2,224),UnicodeCategory::NonspacingMark),
  ((1,2,225),(1,2,251),UnicodeCategory::OtherNumber),
  ((1,3,0),(1,3,31),UnicodeCategory::OtherLetter),
  ((1,3,32),(1,3,35),UnicodeCategory::OtherNumber),
  ((1,3,48),(1,3,64),UnicodeCategory::OtherLetter),
  ((1,3,65),(1,3,65),UnicodeCategory::LetterNumber),
  ((1,3,66),(1,3,73),UnicodeCategory::OtherLetter),
  ((1,3,74),(1,3,74),UnicodeCategory::LetterNumber),
  ((1,3,80),(1,3,117),UnicodeCategory::OtherLetter),
  ((1,3,118),(1,3,122),UnicodeCategory::NonspacingMark),
  ((1,3,128),(1,3,157),UnicodeCategory::OtherLetter),
  ((1,3,159),(1,3,159),UnicodeCategory::OtherPunctuation),
  ((1,3,160),(1,3,195),UnicodeCategory::OtherLetter),
  ((1,3,200),(1,3,207),UnicodeCategory::OtherLetter),
  ((1,3,208),(1,3,208),UnicodeCategory::OtherPunctuation),
  ((1,3,209),(1,3,213),UnicodeCategory::LetterNumber),
  ((1,4,0),(1,4,39),UnicodeCategory::UppercaseLetter),
  ((1,4,40),(1,4,79),UnicodeCategory::LowercaseLetter),
  ((1,4,80),(1,4,157),UnicodeCategory::OtherLetter),
  ((1,4,160),(1,4,169),UnicodeCategory::DecimalNumber),
  ((1,4,176),(1,4,211),UnicodeCategory::UppercaseLetter),
  ((1,4,216),(1,4,251),UnicodeCategory::LowercaseLetter),
  ((1,5,0),(1,5,39),UnicodeCategory::OtherLetter),
  ((1,5,48),(1,5,99),UnicodeCategory::OtherLetter),
  ((1,5,111),(1,5,111),UnicodeCategory::OtherPunctuation),
  ((1,6,0),(1,7,54),UnicodeCategory::OtherLetter),
  ((1,7,64),(1,7,85),UnicodeCategory::OtherLetter),
  ((1,7,96),(1,7,103),UnicodeCategory::OtherLetter),
  ((1,8,0),(1,8,5),UnicodeCategory::OtherLetter),
  ((1,8,8),(1,8,8),UnicodeCategory::OtherLetter),
  ((1,8,10),(1,8,53),UnicodeCategory::OtherLetter),
  ((1,8,55),(1,8,56),UnicodeCategory::OtherLetter),
  ((1,8,60),(1,8,60),UnicodeCategory::OtherLetter),
  ((1,8,63),(1,8,85),UnicodeCategory::OtherLetter),
  ((1,8,87),(1,8,87),UnicodeCategory::OtherPunctuation),
  ((1,8,88),(1,8,95),UnicodeCategory::OtherNumber),
  ((1,8,96),(1,8,118),UnicodeCategory::OtherLetter),
  ((1,8,119),(1,8,120),UnicodeCategory::OtherSymbol),
  ((1,8,121),(1,8,127),UnicodeCategory::OtherNumber),
  ((1,8,128),(1,8,158),UnicodeCategory::OtherLetter),
  ((1,8,167),(1,8,175),UnicodeCategory::OtherNumber),
  ((1,8,224),(1,8,242),UnicodeCategory::OtherLetter),
  ((1,8,244),(1,8,245),UnicodeCategory::OtherLetter),
  ((1,8,251),(1,8,255),UnicodeCategory::OtherNumber),
  ((1,9,0),(1,9,21),UnicodeCategory::OtherLetter),
  ((1,9,22),(1,9,27),UnicodeCategory::OtherNumber),
  ((1,9,31),(1,9,31),UnicodeCategory::OtherPunctuation),
  ((1,9,32),(1,9,57),UnicodeCategory::OtherLetter),
  ((1,9,63),(1,9,63),UnicodeCategory::OtherPunctuation),
  ((1,9,128),(1,9,183),UnicodeCategory::OtherLetter),
  ((1,9,188),(1,9,189),UnicodeCategory::OtherNumber),
  ((1,9,190),(1,9,191),UnicodeCategory::OtherLetter),
  ((1,9,192),(1,9,207),UnicodeCategory::OtherNumber),
  ((1,9,210),(1,9,255),UnicodeCategory::OtherNumber),
  ((1,10,0),(1,10,0),UnicodeCategory::OtherLetter),
  ((1,10,1),(1,10,3),UnicodeCategory::NonspacingMark),
  ((1,10,5),(1,10,6),UnicodeCategory::NonspacingMark),
  ((1,10,12),(1,10,15),UnicodeCategory::NonspacingMark),
  ((1,10,16),(1,10,19),UnicodeCategory::OtherLetter),
  ((1,10,21),(1,10,23),UnicodeCategory::OtherLetter),
  ((1,10,25),(1,10,51),UnicodeCategory::OtherLetter),
  ((1,10,56),(1,10,58),UnicodeCategory::NonspacingMark),
  ((1,10,63),(1,10,63),UnicodeCategory::NonspacingMark),
  ((1,10,64),(1,10,71),UnicodeCategory::OtherNumber),
  ((1,10,80),(1,10,88),UnicodeCategory::OtherPunctuation),
  ((1,10,96),(1,10,124),UnicodeCategory::OtherLetter),
  ((1,10,125),(1,10,126),UnicodeCategory::OtherNumber),
  ((1,10,127),(1,10,127),UnicodeCategory::OtherPunctuation),
  ((1,10,128),(1,10,156),UnicodeCategory::OtherLetter),
  ((1,10,157),(1,10,159),UnicodeCategory::OtherNumber),
  ((1,10,192),(1,10,199),UnicodeCategory::OtherLetter),
  ((1,10,200),(1,10,200),UnicodeCategory::OtherSymbol),
  ((1,10,201),(1,10,228),UnicodeCategory::OtherLetter),
  ((1,10,229),(1,10,230),UnicodeCategory::NonspacingMark),
  ((1,10,235),(1,10,239),UnicodeCategory::OtherNumber),
  ((1,10,240),(1,10,246),UnicodeCategory::OtherPunctuation),
  ((1,11,0),(1,11,53),UnicodeCategory::OtherLetter),
  ((1,11,57),(1,11,63),UnicodeCategory::OtherPunctuation),
  ((1,11,64),(1,11,85),UnicodeCategory::OtherLetter),
  ((1,11,88),(1,11,95),UnicodeCategory::OtherNumber),
  ((1,11,96),(1,11,114),UnicodeCategory::OtherLetter),
  ((1,11,120),(1,11,127),UnicodeCategory::OtherNumber),
  ((1,11,128),(1,11,145),UnicodeCategory::OtherLetter),
  ((1,11,153),(1,11,156),UnicodeCategory::OtherPunctuation),
  ((1,11,169),(1,11,175),UnicodeCategory::OtherNumber),
  ((1,12,0),(1,12,72),UnicodeCategory::OtherLetter),
  ((1,12,128),(1,12,178),UnicodeCategory::UppercaseLetter),
  ((1,12,192),(1,12,242),UnicodeCategory::LowercaseLetter),
  ((1,12,250),(1,12,255),UnicodeCategory::OtherNumber),
  ((1,14,96),(1,14,126),UnicodeCategory::OtherNumber),
  ((1,16,0),(1,16,0),UnicodeCategory::SpacingMark),
  ((1,16,1),(1,16,1),UnicodeCategory::NonspacingMark),
  ((1,16,2),(1,16,2),UnicodeCategory::SpacingMark),
  ((1,16,3),(1,16,55),UnicodeCategory::OtherLetter),
  ((1,16,56),(1,16,70),UnicodeCategory::NonspacingMark),
  ((1,16,71),(1,16,77),UnicodeCategory::OtherPunctuation),
  ((1,16,82),(1,16,101),UnicodeCategory::OtherNumber),
  ((1,16,102),(1,16,111),UnicodeCategory::DecimalNumber),
  ((1,16,127),(1,16,129),UnicodeCategory::NonspacingMark),
  ((1,16,130),(1,16,130),UnicodeCategory::SpacingMark),
  ((1,16,131),(1,16,175),UnicodeCategory::OtherLetter),
  ((1,16,176),(1,16,178),UnicodeCategory::SpacingMark),
  ((1,16,179),(1,16,182),UnicodeCategory::NonspacingMark),
  ((1,16,183),(1,16,184),UnicodeCategory::SpacingMark),
  ((1,16,185),(1,16,186),UnicodeCategory::NonspacingMark),
  ((1,16,187),(1,16,188),UnicodeCategory::OtherPunctuation),
  ((1,16,189),(1,16,189),UnicodeCategory::Format),
  ((1,16,190),(1,16,193),UnicodeCategory::OtherPunctuation),
  ((1,16,208),(1,16,232),UnicodeCategory::OtherLetter),
  ((1,16,240),(1,16,249),UnicodeCategory::DecimalNumber),
  ((1,17,0),(1,17,2),UnicodeCategory::NonspacingMark),
  ((1,17,3),(1,17,38),UnicodeCategory::OtherLetter),
  ((1,17,39),(1,17,43),UnicodeCategory::NonspacingMark),
  ((1,17,44),(1,17,44),UnicodeCategory::SpacingMark),
  ((1,17,45),(1,17,52),UnicodeCategory::NonspacingMark),
  ((1,17,54),(1,17,63),UnicodeCategory::DecimalNumber),
  ((1,17,64),(1,17,67),UnicodeCategory::OtherPunctuation),
  ((1,17,80),(1,17,114),UnicodeCategory::OtherLetter),
  ((1,17,115),(1,17,115),UnicodeCategory::NonspacingMark),
  ((1,17,116),(1,17,117),UnicodeCategory::OtherPunctuation),
  ((1,17,118),(1,17,118),UnicodeCategory::OtherLetter),
  ((1,17,128),(1,17,129),UnicodeCategory::NonspacingMark),
  ((1,17,130),(1,17,130),UnicodeCategory::SpacingMark),
  ((1,17,131),(1,17,178),UnicodeCategory::OtherLetter),
  ((1,17,179),(1,17,181),UnicodeCategory::SpacingMark),
  ((1,17,182),(1,17,190),UnicodeCategory::NonspacingMark),
  ((1,17,191),(1,17,192),UnicodeCategory::SpacingMark),
  ((1,17,193),(1,17,196),UnicodeCategory::OtherLetter),
  ((1,17,197),(1,17,201),UnicodeCategory::OtherPunctuation),
  ((1,17,202),(1,17,204),UnicodeCategory::NonspacingMark),
  ((1,17,205),(1,17,205),UnicodeCategory::OtherPunctuation),
  ((1,17,208),(1,17,217),UnicodeCategory::DecimalNumber),
  ((1,17,218),(1,17,218),UnicodeCategory::OtherLetter),
  ((1,17,219),(1,17,219),UnicodeCategory::OtherPunctuation),
  ((1,17,220),(1,17,220),UnicodeCategory::OtherLetter),
  ((1,17,221),(1,17,223),UnicodeCategory::OtherPunctuation),
  ((1,17,225),(1,17,244),UnicodeCategory::OtherNumber),
  ((1,18,0),(1,18,17),UnicodeCategory::OtherLetter),
  ((1,18,19),(1,18,43),UnicodeCategory::OtherLetter),
  ((1,18,44),(1,18,46),UnicodeCategory::SpacingMark),
  ((1,18,47),(1,18,49),UnicodeCategory::NonspacingMark),
  ((1,18,50),(1,18,51),UnicodeCategory::SpacingMark),
  ((1,18,52),(1,18,52),UnicodeCategory::NonspacingMark),
  ((1,18,53),(1,18,53),UnicodeCategory::SpacingMark),
  ((1,18,54),(1,18,55),UnicodeCategory::NonspacingMark),
  ((1,18,56),(1,18,61),UnicodeCategory::OtherPunctuation),
  ((1,18,62),(1,18,62),UnicodeCategory::NonspacingMark),
  ((1,18,128),(1,18,134),UnicodeCategory::OtherLetter),
  ((1,18,136),(1,18,136),UnicodeCategory::OtherLetter),
  ((1,18,138),(1,18,141),UnicodeCategory::OtherLetter),
  ((1,18,143),(1,18,157),UnicodeCategory::OtherLetter),
  ((1,18,159),(1,18,168),UnicodeCategory::OtherLetter),
  ((1,18,169),(1,18,169),UnicodeCategory::OtherPunctuation),
  ((1,18,176),(1,18,222),UnicodeCategory::OtherLetter),
  ((1,18,223),(1,18,223),UnicodeCategory::NonspacingMark),
  ((1,18,224),(1,18,226),UnicodeCategory::SpacingMark),
  ((1,18,227),(1,18,234),UnicodeCategory::NonspacingMark),
  ((1,18,240),(1,18,249),UnicodeCategory::DecimalNumber),
  ((1,19,0),(1,19,1),UnicodeCategory::NonspacingMark),
  ((1,19,2),(1,19,3),UnicodeCategory::SpacingMark),
  ((1,19,5),(1,19,12),UnicodeCategory::OtherLetter),
  ((1,19,15),(1,19,16),UnicodeCategory::OtherLetter),
  ((1,19,19),(1,19,40),UnicodeCategory::OtherLetter),
  ((1,19,42),(1,19,48),UnicodeCategory::OtherLetter),
  ((1,19,50),(1,19,51),UnicodeCategory::OtherLetter),
  ((1,19,53),(1,19,57),UnicodeCategory::OtherLetter),
  ((1,19,60),(1,19,60),UnicodeCategory::NonspacingMark),
  ((1,19,61),(1,19,61),UnicodeCategory::OtherLetter),
  ((1,19,62),(1,19,63),UnicodeCategory::SpacingMark),
  ((1,19,64),(1,19,64),UnicodeCategory::NonspacingMark),
  ((1,19,65),(1,19,68),UnicodeCategory::SpacingMark),
  ((1,19,71),(1,19,72),UnicodeCategory::SpacingMark),
  ((1,19,75),(1,19,77),UnicodeCategory::SpacingMark),
  ((1,19,80),(1,19,80),UnicodeCategory::OtherLetter),
  ((1,19,87),(1,19,87),UnicodeCategory::SpacingMark),
  ((1,19,93),(1,19,97),UnicodeCategory::OtherLetter),
  ((1,19,98),(1,19,99),UnicodeCategory::SpacingMark),
  ((1,19,102),(1,19,108),UnicodeCategory::NonspacingMark),
  ((1,19,112),(1,19,116),UnicodeCategory::NonspacingMark),
  ((1,20,0),(1,20,52),UnicodeCategory::OtherLetter),
  ((1,20,53),(1,20,55),UnicodeCategory::SpacingMark),
  ((1,20,56),(1,20,63),UnicodeCategory::NonspacingMark),
  ((1,20,64),(1,20,65),UnicodeCategory::SpacingMark),
  ((1,20,66),(1,20,68),UnicodeCategory::NonspacingMark),
  ((1,20,69),(1,20,69),UnicodeCategory::SpacingMark),
  ((1,20,70),(1,20,70),UnicodeCategory::NonspacingMark),
  ((1,20,71),(1,20,74),UnicodeCategory::OtherLetter),
  ((1,20,75),(1,20,79),UnicodeCategory::OtherPunctuation),
  ((1,20,80),(1,20,89),UnicodeCategory::DecimalNumber),
  ((1,20,91),(1,20,91),UnicodeCategory::OtherPunctuation),
  ((1,20,93),(1,20,93),UnicodeCategory::OtherPunctuation),
  ((1,20,128),(1,20,175),UnicodeCategory::OtherLetter),
  ((1,20,176),(1,20,178),UnicodeCategory::SpacingMark),
  ((1,20,179),(1,20,184),UnicodeCategory::NonspacingMark),
  ((1,20,185),(1,20,185),UnicodeCategory::SpacingMark),
  ((1,20,186),(1,20,186),UnicodeCategory::NonspacingMark),
  ((1,20,187),(1,20,190),UnicodeCategory::SpacingMark),
  ((1,20,191),(1,20,192),UnicodeCategory::NonspacingMark),
  ((1,20,193),(1,20,193),UnicodeCategory::SpacingMark),
  ((1,20,194),(1,20,195),UnicodeCategory::NonspacingMark),
  ((1,20,196),(1,20,197),UnicodeCategory::OtherLetter),
  ((1,20,198),(1,20,198),UnicodeCategory::OtherPunctuation),
  ((1,20,199),(1,20,199),UnicodeCategory::OtherLetter),
  ((1,20,208),(1,20,217),UnicodeCategory::DecimalNumber),
  ((1,21,128),(1,21,174),UnicodeCategory::OtherLetter),
  ((1,21,175),(1,21,177),UnicodeCategory::SpacingMark),
  ((1,21,178),(1,21,181),UnicodeCategory::NonspacingMark),
  ((1,21,184),(1,21,187),UnicodeCategory::SpacingMark),
  ((1,21,188),(1,21,189),UnicodeCategory::NonspacingMark),
  ((1,21,190),(1,21,190),UnicodeCategory::SpacingMark),
  ((1,21,191),(1,21,192),UnicodeCategory::NonspacingMark),
  ((1,21,193),(1,21,215),UnicodeCategory::OtherPunctuation),
  ((1,21,216),(1,21,219),UnicodeCategory::OtherLetter),
  ((1,21,220),(1,21,221),UnicodeCategory::NonspacingMark),
  ((1,22,0),(1,22,47),UnicodeCategory::OtherLetter),
  ((1,22,48),(1,22,50),UnicodeCategory::SpacingMark),
  ((1,22,51),(1,22,58),UnicodeCategory::NonspacingMark),
  ((1,22,59),(1,22,60),UnicodeCategory::SpacingMark),
  ((1,22,61),(1,22,61),UnicodeCategory::NonspacingMark),
  ((1,22,62),(1,22,62),UnicodeCategory::SpacingMark),
  ((1,22,63),(1,22,64),UnicodeCategory::NonspacingMark),
  ((1,22,65),(1,22,67),UnicodeCategory::OtherPunctuation),
  ((1,22,68),(1,22,68),UnicodeCategory::OtherLetter),
  ((1,22,80),(1,22,89),UnicodeCategory::DecimalNumber),
  ((1,22,96),(1,22,108),UnicodeCategory::OtherPunctuation),
  ((1,22,128),(1,22,170),UnicodeCategory::OtherLetter),
  ((1,22,171),(1,22,171),UnicodeCategory::NonspacingMark),
  ((1,22,172),(1,22,172),UnicodeCategory::SpacingMark),
  ((1,22,173),(1,22,173),UnicodeCategory::NonspacingMark),
  ((1,22,174),(1,22,175),UnicodeCategory::SpacingMark),
  ((1,22,176),(1,22,181),UnicodeCategory::NonspacingMark),
  ((1,22,182),(1,22,182),UnicodeCategory::SpacingMark),
  ((1,22,183),(1,22,183),UnicodeCategory::NonspacingMark),
  ((1,22,192),(1,22,201),UnicodeCategory::DecimalNumber),
  ((1,23,0),(1,23,25),UnicodeCategory::OtherLetter),
  ((1,23,29),(1,23,31),UnicodeCategory::NonspacingMark),
  ((1,23,32),(1,23,33),UnicodeCategory::SpacingMark),
  ((1,23,34),(1,23,37),UnicodeCategory::NonspacingMark),
  ((1,23,38),(1,23,38),UnicodeCategory::SpacingMark),
  ((1,23,39),(1,23,43),UnicodeCategory::NonspacingMark),
  ((1,23,48),(1,23,57),UnicodeCategory::DecimalNumber),
  ((1,23,58),(1,23,59),UnicodeCategory::OtherNumber),
  ((1,23,60),(1,23,62),UnicodeCategory::OtherPunctuation),
  ((1,23,63),(1,23,63),UnicodeCategory::OtherSymbol),
  ((1,24,160),(1,24,191),UnicodeCategory::UppercaseLetter),
  ((1,24,192),(1,24,223),UnicodeCategory::LowercaseLetter),
  ((1,24,224),(1,24,233),UnicodeCategory::DecimalNumber),
  ((1,24,234),(1,24,242),UnicodeCategory::OtherNumber),
  ((1,24,255),(1,24,255),UnicodeCategory::OtherLetter),
  ((1,26,192),(1,26,248),UnicodeCategory::OtherLetter),
  ((1,28,0),(1,28,8),UnicodeCategory::OtherLetter),
  ((1,28,10),(1,28,46),UnicodeCategory::OtherLetter),
  ((1,28,47),(1,28,47),UnicodeCategory::SpacingMark),
  ((1,28,48),(1,28,54),UnicodeCategory::NonspacingMark),
  ((1,28,56),(1,28,61),UnicodeCategory::NonspacingMark),
  ((1,28,62),(1,28,62),UnicodeCategory::SpacingMark),
  ((1,28,63),(1,28,63),UnicodeCategory::NonspacingMark),
  ((1,28,64),(1,28,64),UnicodeCategory::OtherLetter),
  ((1,28,65),(1,28,69),UnicodeCategory::OtherPunctuation),
  ((1,28,80),(1,28,89),UnicodeCategory::DecimalNumber),
  ((1,28,90),(1,28,108),UnicodeCategory::OtherNumber),
  ((1,28,112),(1,28,113),UnicodeCategory::OtherPunctuation),
  ((1,28,114),(1,28,143),UnicodeCategory::OtherLetter),
  ((1,28,146),(1,28,167),UnicodeCategory::NonspacingMark),
  ((1,28,169),(1,28,169),UnicodeCategory::SpacingMark),
  ((1,28,170),(1,28,176),UnicodeCategory::NonspacingMark),
  ((1,28,177),(1,28,177),UnicodeCategory::SpacingMark),
  ((1,28,178),(1,28,179),UnicodeCategory::NonspacingMark),
  ((1,28,180),(1,28,180),UnicodeCategory::SpacingMark),
  ((1,28,181),(1,28,182),UnicodeCategory::NonspacingMark),
  ((1,32,0),(1,35,153),UnicodeCategory::OtherLetter),
  ((1,36,0),(1,36,110),UnicodeCategory::LetterNumber),
  ((1,36,112),(1,36,116),UnicodeCategory::OtherPunctuation),
  ((1,36,128),(1,37,67),UnicodeCategory::OtherLetter),
  ((1,48,0),(1,52,46),UnicodeCategory::OtherLetter),
  ((1,68,0),(1,70,70),UnicodeCategory::OtherLetter),
  ((1,104,0),(1,106,56),UnicodeCategory::OtherLetter),
  ((1,106,64),(1,106,94),UnicodeCategory::OtherLetter),
  ((1,106,96),(1,106,105),UnicodeCategory::DecimalNumber),
  ((1,106,110),(1,106,111),UnicodeCategory::OtherPunctuation),
  ((1,106,208),(1,106,237),UnicodeCategory::OtherLetter),
  ((1,106,240),(1,106,244),UnicodeCategory::NonspacingMark),
  ((1,106,245),(1,106,245),UnicodeCategory::OtherPunctuation),
  ((1,107,0),(1,107,47),UnicodeCategory::OtherLetter),
  ((1,107,48),(1,107,54),UnicodeCategory::NonspacingMark),
  ((1,107,55),(1,107,59),UnicodeCategory::OtherPunctuation),
  ((1,107,60),(1,107,63),UnicodeCategory::OtherSymbol),
  ((1,107,64),(1,107,67),UnicodeCategory::ModifierLetter),
  ((1,107,68),(1,107,68),UnicodeCategory::OtherPunctuation),
  ((1,107,69),(1,107,69),UnicodeCategory::OtherSymbol),
  ((1,107,80),(1,107,89),UnicodeCategory::DecimalNumber),
  ((1,107,91),(1,107,97),UnicodeCategory::OtherNumber),
  ((1,107,99),(1,107,119),UnicodeCategory::OtherLetter),
  ((1,107,125),(1,107,143),UnicodeCategory::OtherLetter),
  ((1,111,0),(1,111,68),UnicodeCategory::OtherLetter),
  ((1,111,80),(1,111,80),UnicodeCategory::OtherLetter),
  ((1,111,81),(1,111,126),UnicodeCategory::SpacingMark),
  ((1,111,143),(1,111,146),UnicodeCategory::NonspacingMark),
  ((1,111,147),(1,111,159),UnicodeCategory::ModifierLetter),
  ((1,111,224),(1,111,224),UnicodeCategory::ModifierLetter),
  ((1,112,0),(1,135,236),UnicodeCategory::OtherLetter),
  ((1,136,0),(1,138,242),UnicodeCategory::OtherLetter),
  ((1,176,0),(1,176,1),UnicodeCategory::OtherLetter),
  ((1,188,0),(1,188,106),UnicodeCategory::OtherLetter),
  ((1,188,112),(1,188,124),UnicodeCategory::OtherLetter),
  ((1,188,128),(1,188,136),UnicodeCategory::OtherLetter),
  ((1,188,144),(1,188,153),UnicodeCategory::OtherLetter),
  ((1,188,156),(1,188,156),UnicodeCategory::OtherSymbol),
  ((1,188,157),(1,188,158),UnicodeCategory::NonspacingMark),
  ((1,188,159),(1,188,159),UnicodeCategory::OtherPunctuation),
  ((1,188,160),(1,188,163),UnicodeCategory::Format),
  ((1,208,0),(1,208,245),UnicodeCategory::OtherSymbol),
  ((1,209,0),(1,209,38),UnicodeCategory::OtherSymbol),
  ((1,209,41),(1,209,100),UnicodeCategory::OtherSymbol),
  ((1,209,101),(1,209,102),UnicodeCategory::SpacingMark),
  ((1,209,103),(1,209,105),UnicodeCategory::NonspacingMark),
  ((1,209,106),(1,209,108),UnicodeCategory::OtherSymbol),
  ((1,209,109),(1,209,114),UnicodeCategory::SpacingMark),
  ((1,209,115),(1,209,122),UnicodeCategory::Format),
  ((1,209,123),(1,209,130),UnicodeCategory::NonspacingMark),
  ((1,209,131),(1,209,132),UnicodeCategory::OtherSymbol),
  ((1,209,133),(1,209,139),UnicodeCategory::NonspacingMark),
  ((1,209,140),(1,209,169),UnicodeCategory::OtherSymbol),
  ((1,209,170),(1,209,173),UnicodeCategory::NonspacingMark),
  ((1,209,174),(1,209,232),UnicodeCategory::OtherSymbol),
  ((1,210,0),(1,210,65),UnicodeCategory::OtherSymbol),
  ((1,210,66),(1,210,68),UnicodeCategory::NonspacingMark),
  ((1,210,69),(1,210,69),UnicodeCategory::OtherSymbol),
  ((1,211,0),(1,211,86),UnicodeCategory::OtherSymbol),
  ((1,211,96),(1,211,113),UnicodeCategory::OtherNumber),
  ((1,212,0),(1,212,25),UnicodeCategory::UppercaseLetter),
  ((1,212,26),(1,212,51),UnicodeCategory::LowercaseLetter),
  ((1,212,52),(1,212,77),UnicodeCategory::UppercaseLetter),
  ((1,212,78),(1,212,84),UnicodeCategory::LowercaseLetter),
  ((1,212,86),(1,212,103),UnicodeCategory::LowercaseLetter),
  ((1,212,104),(1,212,129),UnicodeCategory::UppercaseLetter),
  ((1,212,130),(1,212,155),UnicodeCategory::LowercaseLetter),
  ((1,212,156),(1,212,156),UnicodeCategory::UppercaseLetter),
  ((1,212,158),(1,212,159),UnicodeCategory::UppercaseLetter),
  ((1,212,162),(1,212,162),UnicodeCategory::UppercaseLetter),
  ((1,212,165),(1,212,166),UnicodeCategory::UppercaseLetter),
  ((1,212,169),(1,212,172),UnicodeCategory::UppercaseLetter),
  ((1,212,174),(1,212,181),UnicodeCategory::UppercaseLetter),
  ((1,212,182),(1,212,185),UnicodeCategory::LowercaseLetter),
  ((1,212,187),(1,212,187),UnicodeCategory::LowercaseLetter),
  ((1,212,189),(1,212,195),UnicodeCategory::LowercaseLetter),
  ((1,212,197),(1,212,207),UnicodeCategory::LowercaseLetter),
  ((1,212,208),(1,212,233),UnicodeCategory::UppercaseLetter),
  ((1,212,234),(1,213,3),UnicodeCategory::LowercaseLetter),
  ((1,213,4),(1,213,5),UnicodeCategory::UppercaseLetter),
  ((1,213,7),(1,213,10),UnicodeCategory::UppercaseLetter),
  ((1,213,13),(1,213,20),UnicodeCategory::UppercaseLetter),
  ((1,213,22),(1,213,28),UnicodeCategory::UppercaseLetter),
  ((1,213,30),(1,213,55),UnicodeCategory::LowercaseLetter),
  ((1,213,56),(1,213,57),UnicodeCategory::UppercaseLetter),
  ((1,213,59),(1,213,62),UnicodeCategory::UppercaseLetter),
  ((1,213,64),(1,213,68),UnicodeCategory::UppercaseLetter),
  ((1,213,70),(1,213,70),UnicodeCategory::UppercaseLetter),
  ((1,213,74),(1,213,80),UnicodeCategory::UppercaseLetter),
  ((1,213,82),(1,213,107),UnicodeCategory::LowercaseLetter),
  ((1,213,108),(1,213,133),UnicodeCategory::UppercaseLetter),
  ((1,213,134),(1,213,159),UnicodeCategory::LowercaseLetter),
  ((1,213,160),(1,213,185),UnicodeCategory::UppercaseLetter),
  ((1,213,186),(1,213,211),UnicodeCategory::LowercaseLetter),
  ((1,213,212),(1,213,237),UnicodeCategory::UppercaseLetter),
  ((1,213,238),(1,214,7),UnicodeCategory::LowercaseLetter),
  ((1,214,8),(1,214,33),UnicodeCategory::UppercaseLetter),
  ((1,214,34),(1,214,59),UnicodeCategory::LowercaseLetter),
  ((1,214,60),(1,214,85),UnicodeCategory::UppercaseLetter),
  ((1,214,86),(1,214,111),UnicodeCategory::LowercaseLetter),
  ((1,214,112),(1,214,137),UnicodeCategory::UppercaseLetter),
  ((1,214,138),(1,214,165),UnicodeCategory::LowercaseLetter),
  ((1,214,168),(1,214,192),UnicodeCategory::UppercaseLetter),
  ((1,214,193),(1,214,193),UnicodeCategory::MathSymbol),
  ((1,214,194),(1,214,218),UnicodeCategory::LowercaseLetter),
  ((1,214,219),(1,214,219),UnicodeCategory::MathSymbol),
  ((1,214,220),(1,214,225),UnicodeCategory::LowercaseLetter),
  ((1,214,226),(1,214,250),UnicodeCategory::UppercaseLetter),
  ((1,214,251),(1,214,251),UnicodeCategory::MathSymbol),
  ((1,214,252),(1,215,20),UnicodeCategory::LowercaseLetter),
  ((1,215,21),(1,215,21),UnicodeCategory::MathSymbol),
  ((1,215,22),(1,215,27),UnicodeCategory::LowercaseLetter),
  ((1,215,28),(1,215,52),UnicodeCategory::UppercaseLetter),
  ((1,215,53),(1,215,53),UnicodeCategory::MathSymbol),
  ((1,215,54),(1,215,78),UnicodeCategory::LowercaseLetter),
  ((1,215,79),(1,215,79),UnicodeCategory::MathSymbol),
  ((1,215,80),(1,215,85),UnicodeCategory::LowercaseLetter),
  ((1,215,86),(1,215,110),UnicodeCategory::UppercaseLetter),
  ((1,215,111),(1,215,111),UnicodeCategory::MathSymbol),
  ((1,215,112),(1,215,136),UnicodeCategory::LowercaseLetter),
  ((1,215,137),(1,215,137),UnicodeCategory::MathSymbol),
  ((1,215,138),(1,215,143),UnicodeCategory::LowercaseLetter),
  ((1,215,144),(1,215,168),UnicodeCategory::UppercaseLetter),
  ((1,215,169),(1,215,169),UnicodeCategory::MathSymbol),
  ((1,215,170),(1,215,194),UnicodeCategory::LowercaseLetter),
  ((1,215,195),(1,215,195),UnicodeCategory::MathSymbol),
  ((1,215,196),(1,215,201),UnicodeCategory::LowercaseLetter),
  ((1,215,202),(1,215,202),UnicodeCategory::UppercaseLetter),
  ((1,215,203),(1,215,203),UnicodeCategory::LowercaseLetter),
  ((1,215,206),(1,215,255),UnicodeCategory::DecimalNumber),
  ((1,216,0),(1,217,255),UnicodeCategory::OtherSymbol),
  ((1,218,0),(1,218,54),UnicodeCategory::NonspacingMark),
  ((1,218,55),(1,218,58),UnicodeCategory::OtherSymbol),
  ((1,218,59),(1,218,108),UnicodeCategory::NonspacingMark),
  ((1,218,109),(1,218,116),UnicodeCategory::OtherSymbol),
  ((1,218,117),(1,218,117),UnicodeCategory::NonspacingMark),
  ((1,218,118),(1,218,131),UnicodeCategory::OtherSymbol),
  ((1,218,132),(1,218,132),UnicodeCategory::NonspacingMark),
  ((1,218,133),(1,218,134),UnicodeCategory::OtherSymbol),
  ((1,218,135),(1,218,139),UnicodeCategory::OtherPunctuation),
  ((1,218,155),(1,218,159),UnicodeCategory::NonspacingMark),
  ((1,218,161),(1,218,175),UnicodeCategory::NonspacingMark),
  ((1,224,0),(1,224,6),UnicodeCategory::NonspacingMark),
  ((1,224,8),(1,224,24),UnicodeCategory::NonspacingMark),
  ((1,224,27),(1,224,33),UnicodeCategory::NonspacingMark),
  ((1,224,35),(1,224,36),UnicodeCategory::NonspacingMark),
  ((1,224,38),(1,224,42),UnicodeCategory::NonspacingMark),
  ((1,232,0),(1,232,196),UnicodeCategory::OtherLetter),
  ((1,232,199),(1,232,207),UnicodeCategory::OtherNumber),
  ((1,232,208),(1,232,214),UnicodeCategory::NonspacingMark),
  ((1,233,0),(1,233,33),UnicodeCategory::UppercaseLetter),
  ((1,233,34),(1,233,67),UnicodeCategory::LowercaseLetter),
  ((1,233,68),(1,233,74),UnicodeCategory::NonspacingMark),
  ((1,233,80),(1,233,89),UnicodeCategory::DecimalNumber),
  ((1,233,94),(1,233,95),UnicodeCategory::OtherPunctuation),
  ((1,238,0),(1,238,3),UnicodeCategory::OtherLetter),
  ((1,238,5),(1,238,31),UnicodeCategory::OtherLetter),
  ((1,238,33),(1,238,34),UnicodeCategory::OtherLetter),
  ((1,238,36),(1,238,36),UnicodeCategory::OtherLetter),
  ((1,238,39),(1,238,39),UnicodeCategory::OtherLetter),
  ((1,238,41),(1,238,50),UnicodeCategory::OtherLetter),
  ((1,238,52),(1,238,55),UnicodeCategory::OtherLetter),
  ((1,238,57),(1,238,57),UnicodeCategory::OtherLetter),
  ((1,238,59),(1,238,59),UnicodeCategory::OtherLetter),
  ((1,238,66),(1,238,66),UnicodeCategory::OtherLetter),
  ((1,238,71),(1,238,71),UnicodeCategory::OtherLetter),
  ((1,238,73),(1,238,73),UnicodeCategory::OtherLetter),
  ((1,238,75),(1,238,75),UnicodeCategory::OtherLetter),
  ((1,238,77),(1,238,79),UnicodeCategory::OtherLetter),
  ((1,238,81),(1,238,82),UnicodeCategory::OtherLetter),
  ((1,238,84),(1,238,84),UnicodeCategory::OtherLetter),
  ((1,238,87),(1,238,87),UnicodeCategory::OtherLetter),
  ((1,238,89),(1,238,89),UnicodeCategory::OtherLetter),
  ((1,238,91),(1,238,91),UnicodeCategory::OtherLetter),
  ((1,238,93),(1,238,93),UnicodeCategory::OtherLetter),
  ((1,238,95),(1,238,95),UnicodeCategory::OtherLetter),
  ((1,238,97),(1,238,98),UnicodeCategory::OtherLetter),
  ((1,238,100),(1,238,100),UnicodeCategory::OtherLetter),
  ((1,238,103),(1,238,106),UnicodeCategory::OtherLetter),
  ((1,238,108),(1,238,114),UnicodeCategory::OtherLetter),
  ((1,238,116),(1,238,119),UnicodeCategory::OtherLetter),
  ((1,238,121),(1,238,124),UnicodeCategory::OtherLetter),
  ((1,238,126),(1,238,126),UnicodeCategory::OtherLetter),
  ((1,238,128),(1,238,137),UnicodeCategory::OtherLetter),
  ((1,238,139),(1,238,155),UnicodeCategory::OtherLetter),
  ((1,238,161),(1,238,163),UnicodeCategory::OtherLetter),
  ((1,238,165),(1,238,169),UnicodeCategory::OtherLetter),
  ((1,238,171),(1,238,187),UnicodeCategory::OtherLetter),
  ((1,238,240),(1,238,241),UnicodeCategory::MathSymbol),
  ((1,240,0),(1,240,43),UnicodeCategory::OtherSymbol),
  ((1,240,48),(1,240,147),UnicodeCategory::OtherSymbol),
  ((1,240,160),(1,240,174),UnicodeCategory::OtherSymbol),
  ((1,240,177),(1,240,191),UnicodeCategory::OtherSymbol),
  ((1,240,193),(1,240,207),UnicodeCategory::OtherSymbol),
  ((1,240,209),(1,240,245),UnicodeCategory::OtherSymbol),
  ((1,241,0),(1,241,12),UnicodeCategory::OtherNumber),
  ((1,241,16),(1,241,46),UnicodeCategory::OtherSymbol),
  ((1,241,48),(1,241,107),UnicodeCategory::OtherSymbol),
  ((1,241,112),(1,241,172),UnicodeCategory::OtherSymbol),
  ((1,241,230),(1,242,2),UnicodeCategory::OtherSymbol),
  ((1,242,16),(1,242,59),UnicodeCategory::OtherSymbol),
  ((1,242,64),(1,242,72),UnicodeCategory::OtherSymbol),
  ((1,242,80),(1,242,81),UnicodeCategory::OtherSymbol),
  ((1,243,0),(1,243,250),UnicodeCategory::OtherSymbol),
  ((1,243,251),(1,243,255),UnicodeCategory::ModifierSymbol),
  ((1,244,0),(1,246,210),UnicodeCategory::OtherSymbol),
  ((1,246,224),(1,246,236),UnicodeCategory::OtherSymbol),
  ((1,246,240),(1,246,246),UnicodeCategory::OtherSymbol),
  ((1,247,0),(1,247,115),UnicodeCategory::OtherSymbol),
  ((1,247,128),(1,247,212),UnicodeCategory::OtherSymbol),
  ((1,248,0),(1,248,11),UnicodeCategory::OtherSymbol),
  ((1,248,16),(1,248,71),UnicodeCategory::OtherSymbol),
  ((1,248,80),(1,248,89),UnicodeCategory::OtherSymbol),
  ((1,248,96),(1,248,135),UnicodeCategory::OtherSymbol),
  ((1,248,144),(1,248,173),UnicodeCategory::OtherSymbol),
  ((1,249,16),(1,249,30),UnicodeCategory::OtherSymbol),
  ((1,249,32),(1,249,39),UnicodeCategory::OtherSymbol),
  ((1,249,48),(1,249,48),UnicodeCategory::OtherSymbol),
  ((1,249,51),(1,249,62),UnicodeCategory::OtherSymbol),
  ((1,249,64),(1,249,75),UnicodeCategory::OtherSymbol),
  ((1,249,80),(1,249,94),UnicodeCategory::OtherSymbol),
  ((1,249,128),(1,249,145),UnicodeCategory::OtherSymbol),
  ((1,249,192),(1,249,192),UnicodeCategory::OtherSymbol),
  ((2,0,0),(2,166,214),UnicodeCategory::OtherLetter),
  ((2,167,0),(2,183,52),UnicodeCategory::OtherLetter),
  ((2,183,64),(2,184,29),UnicodeCategory::OtherLetter),
  ((2,184,32),(2,206,161),UnicodeCategory::OtherLetter),
  ((2,248,0),(2,250,29),UnicodeCategory::OtherLetter),
  ((14,0,1),(14,0,1),UnicodeCategory::Format),
  ((14,0,32),(14,0,127),UnicodeCategory::Format),
  ((14,1,0),(14,1,239),UnicodeCategory::NonspacingMark),
  ((15,0,0),(15,255,253),UnicodeCategory::PrivateUse),
  ((16,0,0),(16,255,253),UnicodeCategory::PrivateUse)
];

pub static UCD_COMBCLS: &'static [((u8,u8,u8), (u8,u8,u8), u8)] = &[
  ((0,3,0),(0,3,20),230), ((0,3,21),(0,3,21),232), ((0,3,22),(0,3,25),220),
  ((0,3,26),(0,3,26),232), ((0,3,27),(0,3,27),216), ((0,3,28),(0,3,32),220),
  ((0,3,33),(0,3,34),202), ((0,3,35),(0,3,38),220), ((0,3,39),(0,3,40),202),
  ((0,3,41),(0,3,51),220), ((0,3,52),(0,3,56),1), ((0,3,57),(0,3,60),220),
  ((0,3,61),(0,3,68),230), ((0,3,69),(0,3,69),240), ((0,3,70),(0,3,70),230),
  ((0,3,71),(0,3,73),220), ((0,3,74),(0,3,76),230), ((0,3,77),(0,3,78),220),
  ((0,3,80),(0,3,82),230), ((0,3,83),(0,3,86),220), ((0,3,87),(0,3,87),230),
  ((0,3,88),(0,3,88),232), ((0,3,89),(0,3,90),220), ((0,3,91),(0,3,91),230),
  ((0,3,92),(0,3,92),233), ((0,3,93),(0,3,94),234), ((0,3,95),(0,3,95),233),
  ((0,3,96),(0,3,97),234), ((0,3,98),(0,3,98),233), ((0,3,99),(0,3,111),230),
  ((0,4,131),(0,4,135),230), ((0,5,145),(0,5,145),220),
  ((0,5,146),(0,5,149),230), ((0,5,150),(0,5,150),220),
  ((0,5,151),(0,5,153),230), ((0,5,154),(0,5,154),222),
  ((0,5,155),(0,5,155),220), ((0,5,156),(0,5,161),230),
  ((0,5,162),(0,5,167),220), ((0,5,168),(0,5,169),230),
  ((0,5,170),(0,5,170),220), ((0,5,171),(0,5,172),230),
  ((0,5,173),(0,5,173),222), ((0,5,174),(0,5,174),228),
  ((0,5,175),(0,5,175),230), ((0,5,176),(0,5,176),10), ((0,5,177),(0,5,177),11),
  ((0,5,178),(0,5,178),12), ((0,5,179),(0,5,179),13), ((0,5,180),(0,5,180),14),
  ((0,5,181),(0,5,181),15), ((0,5,182),(0,5,182),16), ((0,5,183),(0,5,183),17),
  ((0,5,184),(0,5,184),18), ((0,5,185),(0,5,186),19), ((0,5,187),(0,5,187),20),
  ((0,5,188),(0,5,188),21), ((0,5,189),(0,5,189),22), ((0,5,191),(0,5,191),23),
  ((0,5,193),(0,5,193),24), ((0,5,194),(0,5,194),25), ((0,5,196),(0,5,196),230),
  ((0,5,197),(0,5,197),220), ((0,5,199),(0,5,199),18), ((0,6,16),(0,6,23),230),
  ((0,6,24),(0,6,24),30), ((0,6,25),(0,6,25),31), ((0,6,26),(0,6,26),32),
  ((0,6,75),(0,6,75),27), ((0,6,76),(0,6,76),28), ((0,6,77),(0,6,77),29),
  ((0,6,78),(0,6,78),30), ((0,6,79),(0,6,79),31), ((0,6,80),(0,6,80),32),
  ((0,6,81),(0,6,81),33), ((0,6,82),(0,6,82),34), ((0,6,83),(0,6,84),230),
  ((0,6,85),(0,6,86),220), ((0,6,87),(0,6,91),230), ((0,6,92),(0,6,92),220),
  ((0,6,93),(0,6,94),230), ((0,6,95),(0,6,95),220), ((0,6,112),(0,6,112),35),
  ((0,6,214),(0,6,220),230), ((0,6,223),(0,6,226),230),
  ((0,6,227),(0,6,227),220), ((0,6,228),(0,6,228),230),
  ((0,6,231),(0,6,232),230), ((0,6,234),(0,6,234),220),
  ((0,6,235),(0,6,236),230), ((0,6,237),(0,6,237),220), ((0,7,17),(0,7,17),36),
  ((0,7,48),(0,7,48),230), ((0,7,49),(0,7,49),220), ((0,7,50),(0,7,51),230),
  ((0,7,52),(0,7,52),220), ((0,7,53),(0,7,54),230), ((0,7,55),(0,7,57),220),
  ((0,7,58),(0,7,58),230), ((0,7,59),(0,7,60),220), ((0,7,61),(0,7,61),230),
  ((0,7,62),(0,7,62),220), ((0,7,63),(0,7,65),230), ((0,7,66),(0,7,66),220),
  ((0,7,67),(0,7,67),230), ((0,7,68),(0,7,68),220), ((0,7,69),(0,7,69),230),
  ((0,7,70),(0,7,70),220), ((0,7,71),(0,7,71),230), ((0,7,72),(0,7,72),220),
  ((0,7,73),(0,7,74),230), ((0,7,235),(0,7,241),230), ((0,7,242),(0,7,242),220),
  ((0,7,243),(0,7,243),230), ((0,8,22),(0,8,25),230), ((0,8,27),(0,8,35),230),
  ((0,8,37),(0,8,39),230), ((0,8,41),(0,8,45),230), ((0,8,89),(0,8,91),220),
  ((0,8,212),(0,8,225),230), ((0,8,227),(0,8,227),220),
  ((0,8,228),(0,8,229),230), ((0,8,230),(0,8,230),220),
  ((0,8,231),(0,8,232),230), ((0,8,233),(0,8,233),220),
  ((0,8,234),(0,8,236),230), ((0,8,237),(0,8,239),220),
  ((0,8,240),(0,8,240),27), ((0,8,241),(0,8,241),28), ((0,8,242),(0,8,242),29),
  ((0,8,243),(0,8,245),230), ((0,8,246),(0,8,246),220),
  ((0,8,247),(0,8,248),230), ((0,8,249),(0,8,250),220),
  ((0,8,251),(0,8,255),230), ((0,9,60),(0,9,60),7), ((0,9,77),(0,9,77),9),
  ((0,9,81),(0,9,81),230), ((0,9,82),(0,9,82),220), ((0,9,83),(0,9,84),230),
  ((0,9,188),(0,9,188),7), ((0,9,205),(0,9,205),9), ((0,10,60),(0,10,60),7),
  ((0,10,77),(0,10,77),9), ((0,10,188),(0,10,188),7), ((0,10,205),(0,10,205),9),
  ((0,11,60),(0,11,60),7), ((0,11,77),(0,11,77),9), ((0,11,205),(0,11,205),9),
  ((0,12,77),(0,12,77),9), ((0,12,85),(0,12,85),84), ((0,12,86),(0,12,86),91),
  ((0,12,188),(0,12,188),7), ((0,12,205),(0,12,205),9), ((0,13,77),(0,13,77),9),
  ((0,13,202),(0,13,202),9), ((0,14,56),(0,14,57),103), ((0,14,58),(0,14,58),9),
  ((0,14,72),(0,14,75),107), ((0,14,184),(0,14,185),118),
  ((0,14,200),(0,14,203),122), ((0,15,24),(0,15,25),220),
  ((0,15,53),(0,15,53),220), ((0,15,55),(0,15,55),220),
  ((0,15,57),(0,15,57),216), ((0,15,113),(0,15,113),129),
  ((0,15,114),(0,15,114),130), ((0,15,116),(0,15,116),132),
  ((0,15,122),(0,15,125),130), ((0,15,128),(0,15,128),130),
  ((0,15,130),(0,15,131),230), ((0,15,132),(0,15,132),9),
  ((0,15,134),(0,15,135),230), ((0,15,198),(0,15,198),220),
  ((0,16,55),(0,16,55),7), ((0,16,57),(0,16,58),9), ((0,16,141),(0,16,141),220),
  ((0,19,93),(0,19,95),230), ((0,23,20),(0,23,20),9), ((0,23,52),(0,23,52),9),
  ((0,23,210),(0,23,210),9), ((0,23,221),(0,23,221),230),
  ((0,24,169),(0,24,169),228), ((0,25,57),(0,25,57),222),
  ((0,25,58),(0,25,58),230), ((0,25,59),(0,25,59),220),
  ((0,26,23),(0,26,23),230), ((0,26,24),(0,26,24),220), ((0,26,96),(0,26,96),9),
  ((0,26,117),(0,26,124),230), ((0,26,127),(0,26,127),220),
  ((0,26,176),(0,26,180),230), ((0,26,181),(0,26,186),220),
  ((0,26,187),(0,26,188),230), ((0,26,189),(0,26,189),220),
  ((0,27,52),(0,27,52),7), ((0,27,68),(0,27,68),9), ((0,27,107),(0,27,107),230),
  ((0,27,108),(0,27,108),220), ((0,27,109),(0,27,115),230),
  ((0,27,170),(0,27,171),9), ((0,27,230),(0,27,230),7),
  ((0,27,242),(0,27,243),9), ((0,28,55),(0,28,55),7),
  ((0,28,208),(0,28,210),230), ((0,28,212),(0,28,212),1),
  ((0,28,213),(0,28,217),220), ((0,28,218),(0,28,219),230),
  ((0,28,220),(0,28,223),220), ((0,28,224),(0,28,224),230),
  ((0,28,226),(0,28,232),1), ((0,28,237),(0,28,237),220),
  ((0,28,244),(0,28,244),230), ((0,28,248),(0,28,249),230),
  ((0,29,192),(0,29,193),230), ((0,29,194),(0,29,194),220),
  ((0,29,195),(0,29,201),230), ((0,29,202),(0,29,202),220),
  ((0,29,203),(0,29,204),230), ((0,29,205),(0,29,205),234),
  ((0,29,206),(0,29,206),214), ((0,29,207),(0,29,207),220),
  ((0,29,208),(0,29,208),202), ((0,29,209),(0,29,245),230),
  ((0,29,251),(0,29,251),230), ((0,29,252),(0,29,252),233),
  ((0,29,253),(0,29,253),220), ((0,29,254),(0,29,254),230),
  ((0,29,255),(0,29,255),220), ((0,32,208),(0,32,209),230),
  ((0,32,210),(0,32,211),1), ((0,32,212),(0,32,215),230),
  ((0,32,216),(0,32,218),1), ((0,32,219),(0,32,220),230),
  ((0,32,225),(0,32,225),230), ((0,32,229),(0,32,230),1),
  ((0,32,231),(0,32,231),230), ((0,32,232),(0,32,232),220),
  ((0,32,233),(0,32,233),230), ((0,32,234),(0,32,235),1),
  ((0,32,236),(0,32,239),220), ((0,32,240),(0,32,240),230),
  ((0,44,239),(0,44,241),230), ((0,45,127),(0,45,127),9),
  ((0,45,224),(0,45,255),230), ((0,48,42),(0,48,42),218),
  ((0,48,43),(0,48,43),228), ((0,48,44),(0,48,44),232),
  ((0,48,45),(0,48,45),222), ((0,48,46),(0,48,47),224),
  ((0,48,153),(0,48,154),8), ((0,166,111),(0,166,111),230),
  ((0,166,116),(0,166,125),230), ((0,166,158),(0,166,159),230),
  ((0,166,240),(0,166,241),230), ((0,168,6),(0,168,6),9),
  ((0,168,196),(0,168,196),9), ((0,168,224),(0,168,241),230),
  ((0,169,43),(0,169,45),220), ((0,169,83),(0,169,83),9),
  ((0,169,179),(0,169,179),7), ((0,169,192),(0,169,192),9),
  ((0,170,176),(0,170,176),230), ((0,170,178),(0,170,179),230),
  ((0,170,180),(0,170,180),220), ((0,170,183),(0,170,184),230),
  ((0,170,190),(0,170,191),230), ((0,170,193),(0,170,193),230),
  ((0,170,246),(0,170,246),9), ((0,171,237),(0,171,237),9),
  ((0,251,30),(0,251,30),26), ((0,254,32),(0,254,38),230),
  ((0,254,39),(0,254,45),220), ((0,254,46),(0,254,47),230),
  ((1,1,253),(1,1,253),220), ((1,2,224),(1,2,224),220),
  ((1,3,118),(1,3,122),230), ((1,10,13),(1,10,13),220),
  ((1,10,15),(1,10,15),230), ((1,10,56),(1,10,56),230), ((1,10,57),(1,10,57),1),
  ((1,10,58),(1,10,58),220), ((1,10,63),(1,10,63),9),
  ((1,10,229),(1,10,229),230), ((1,10,230),(1,10,230),220),
  ((1,16,70),(1,16,70),9), ((1,16,127),(1,16,127),9), ((1,16,185),(1,16,185),9),
  ((1,16,186),(1,16,186),7), ((1,17,0),(1,17,2),230), ((1,17,51),(1,17,52),9),
  ((1,17,115),(1,17,115),7), ((1,17,192),(1,17,192),9),
  ((1,17,202),(1,17,202),7), ((1,18,53),(1,18,53),9), ((1,18,54),(1,18,54),7),
  ((1,18,233),(1,18,233),7), ((1,18,234),(1,18,234),9), ((1,19,60),(1,19,60),7),
  ((1,19,77),(1,19,77),9), ((1,19,102),(1,19,108),230),
  ((1,19,112),(1,19,116),230), ((1,20,66),(1,20,66),9), ((1,20,70),(1,20,70),7),
  ((1,20,194),(1,20,194),9), ((1,20,195),(1,20,195),7),
  ((1,21,191),(1,21,191),9), ((1,21,192),(1,21,192),7), ((1,22,63),(1,22,63),9),
  ((1,22,182),(1,22,182),9), ((1,22,183),(1,22,183),7), ((1,23,43),(1,23,43),9),
  ((1,28,63),(1,28,63),9), ((1,106,240),(1,106,244),1),
  ((1,107,48),(1,107,54),230), ((1,188,158),(1,188,158),1),
  ((1,209,101),(1,209,102),216), ((1,209,103),(1,209,105),1),
  ((1,209,109),(1,209,109),226), ((1,209,110),(1,209,114),216),
  ((1,209,123),(1,209,130),220), ((1,209,133),(1,209,137),230),
  ((1,209,138),(1,209,139),220), ((1,209,170),(1,209,173),230),
  ((1,210,66),(1,210,68),230), ((1,224,0),(1,224,6),230),
  ((1,224,8),(1,224,24),230), ((1,224,27),(1,224,33),230),
  ((1,224,35),(1,224,36),230), ((1,224,38),(1,224,42),230),
  ((1,232,208),(1,232,214),220), ((1,233,68),(1,233,73),230),
  ((1,233,74),(1,233,74),7)
];

