# 2023-01-18 Triage Log

Nearly all flagged regressions are likely noise, except one rollup with minor
impact on diesel that we will follow up on. We had a broad (albeit small) win
from [#106294](https://github.com/rust-lang/rust/pull/106294).

Triage done by **@pnkfelix**.
Revision range: [0442fbabe24ec43636a80ad1f40a0ad92a2e38df..1f72129ffe5e8c495113f9a2d4e1730f7fad3209](https://perf.rust-lang.org/?start=0442fbabe24ec43636a80ad1f40a0ad92a2e38df&end=1f72129ffe5e8c495113f9a2d4e1730f7fad3209&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.2%, 1.7%]   | 39    |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.2%, 1.8%]   | 23    |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.6%, -0.2%] | 7     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.6%, -0.2%] | 6     |
| All ❌✅ (primary)                 | 0.3%  | [-0.6%, 1.7%]  | 46    |


4 Regressions, 3 Improvements, 3 Mixed; 4 of them in rollups
50 artifact comparisons made in total

#### Regressions

Rollup of 9 pull requests [#106730](https://github.com/rust-lang/rust/pull/106730) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b22c152958eade17a71d899b29a2d39bcc77aa48&end=ef4046e4f3932991971cdb64915172899532aece&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.2%, 0.3%] | 6     |
| Regressions ❌ <br /> (secondary)  | 0.4% | [0.2%, 0.7%] | 4     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.2%, 0.3%] | 6     |

* already isolated by the PR author to [#106321](https://github.com/rust-lang/rust/issues/106321)
* left comment and marked as triaged

Rollup of 10 pull requests [#106822](https://github.com/rust-lang/rust/pull/106822) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0b90256ada21c6a81b4c18f2c7a23151ab5fc232&end=a11eb4f267ddfe4f00cb40bf94aef508c11e0862&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.8% | [0.8%, 0.9%] | 4     |
| Regressions ❌ <br /> (secondary)  | 0.5% | [0.3%, 0.8%] | 12    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.8% | [0.8%, 0.9%] | 4     |

* the sole primary impacted benchmarks are variants of helloworld-check.
* Looking at the [graph](https://perf.rust-lang.org/index.html?start=2022-12-14&end=2023-01-17&benchmark=helloworld&profile=check&scenario=incr-unchanged&stat=instructions:u), I'm categorizing this as noise.
* left comment and marked as triaged

Rework some `predicates_of`/`{Generic,Instantiated}Predicates` code [#106395](https://github.com/rust-lang/rust/pull/106395) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=41edaac716dde55b6a9d83ae4da0fba354ae5ba8&end=d12412c90fbd974b1cf886e42a95c850d9ee45a1&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.8%  | [0.7%, 0.9%]   | 4     |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.2%, 1.1%]   | 18    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.7% | [-0.7%, -0.7%] | 1     |
| All ❌✅ (primary)                 | 0.8%  | [0.7%, 0.9%]   | 4     |

* already triaged as noise

Heuristically undo path prefix mappings. [#106853](https://github.com/rust-lang/rust/pull/106853) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=af669c26846f85fd15e34a6f03d5d2f237444c17&end=481725984b4cd94ef5c00917b01c1771b6e5299c&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7% | [0.7%, 0.8%] | 3     |
| Regressions ❌ <br /> (secondary)  | 0.4% | [0.3%, 0.6%] | 9     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.7% | [0.7%, 0.8%] | 3     |

* From the [graph](https://perf.rust-lang.org/index.html?start=2022-12-17&end=2023-01-18&benchmark=helloworld&profile=check&scenario=incr-unchanged&stat=instructions:u), I think this is just noise
* left comment and marked as triaged


#### Improvements

Update cargo [#106825](https://github.com/rust-lang/rust/pull/106825) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a11eb4f267ddfe4f00cb40bf94aef508c11e0862&end=ca5d92d789c94060fc32bfc4a778fb16904756ea&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.9% | [-0.9%, -0.8%] | 4     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.8%, -0.3%] | 12    |
| All ❌✅ (primary)                 | -0.9% | [-0.9%, -0.8%] | 4     |

* just noise in the other direction

Emit only one nbsp error per file [#106872](https://github.com/rust-lang/rust/pull/106872) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d12412c90fbd974b1cf886e42a95c850d9ee45a1&end=a5bfc25c93d2549887848529382892f93c95207d&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-0.8%, -0.7%] | 4     |
| Improvements ✅ <br /> (secondary) | -0.6% | [-1.1%, -0.3%] | 15    |
| All ❌✅ (primary)                 | -0.7% | [-0.8%, -0.7%] | 4     |

* just noise in the other direction


Put `noundef` on all scalars that don't allow uninit [#106294](https://github.com/rust-lang/rust/pull/106294) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=38a76f33220c4b9d13dda1fa8f6c629c8a7bcc5d&end=3984bc5833db8bfb0acc522c9775383e4171f3de&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6%  | [0.5%, 0.6%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 1.2%  | [1.2%, 1.2%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.3%, -0.1%] | 52    |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.5%, -0.2%] | 24    |
| All ❌✅ (primary)                 | -0.2% | [-0.3%, 0.6%]  | 54    |

* awesome amount of green (small but broad) in the per fresults

#### Mixed

Rollup of 10 pull requests [#106757](https://github.com/rust-lang/rust/pull/106757) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4887cb18dc2ef5b1bf3fc50ce6c267fde085032b&end=2b8590ef3bd1221830ec8a4131ea9d02b1636746&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6%  | [0.6%, 0.7%]   | 6     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.5%, -0.5%] | 1     |
| All ❌✅ (primary)                 | 0.6%  | [0.6%, 0.7%]   | 6     |

* the regressing cases are all variation of diesel {full, incr-full}
* Not marking #106757 as triaged. Doing some rust-timer runs on the individual builds.

Rollup of 10 pull requests [#106851](https://github.com/rust-lang/rust/pull/106851) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=44a500c8c187b245638684748f54bd6ec67e0b25&end=4b51adf6ffa1ae2286ea436eb48cbaa8771886e6&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.3%, 0.5%]   | 5     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.4%, -0.3%] | 4     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.6%, -0.1%] | 3     |
| All ❌✅ (primary)                 | -0.4% | [-0.4%, -0.3%] | 4     |

* the regressing cases are secondary tuple-stress and deep-vector
* left comment and marked as triaged.

Switch to `EarlyBinder` for `const_param_default` and `impl_trait_ref` queries [#106696](https://github.com/rust-lang/rust/pull/106696) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4b51adf6ffa1ae2286ea436eb48cbaa8771886e6&end=b8f9cb345ab1401f2fbd14cc23f64dda9dd2314e&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.2%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.4%, -0.2%] | 3     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.2% | [-0.4%, 0.2%]  | 4     |

* there is one small regression to bitmaps-full doc, and three improvements to bitmaps-incr-full {check, debug, opt}.
* If its not noise, its seems like the right trade off.
* left comment, marked as triaged.

#### Untriaged Pull Requests

- [#106853 Heuristically undo path prefix mappings.](https://github.com/rust-lang/rust/pull/106853)
- [#106851 Rollup of 10 pull requests](https://github.com/rust-lang/rust/pull/106851)
- [#106822 Rollup of 10 pull requests](https://github.com/rust-lang/rust/pull/106822)
- [#106757 Rollup of 10 pull requests](https://github.com/rust-lang/rust/pull/106757)
- [#106730 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/106730)
- [#106696 Switch to `EarlyBinder` for `const_param_default` and `impl_trait_ref` queries](https://github.com/rust-lang/rust/pull/106696)
- [#105657 Guard ProjectionTy creation against passing the wrong number of substs](https://github.com/rust-lang/rust/pull/105657)
- [#105472 Make encode_info_for_trait_item use queries instead of accessing the HIR](https://github.com/rust-lang/rust/pull/105472)
- [#105426 Catch panics/unwinding in destruction of TLS values](https://github.com/rust-lang/rust/pull/105426)
- [#105378 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/105378)
- [#105323 Perform SimplifyLocals before ConstProp.](https://github.com/rust-lang/rust/pull/105323)
- [#105147 Allow unsafe through inline const](https://github.com/rust-lang/rust/pull/105147)
- [#104566 couple of clippy::perf fixes](https://github.com/rust-lang/rust/pull/104566)
- [#104533 Clean up and harden various methods around trait substs](https://github.com/rust-lang/rust/pull/104533)
- [#104017 Rollup of 5 pull requests](https://github.com/rust-lang/rust/pull/104017)
- [#103998 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/103998)
- [#103975 Some tracing and comment cleanups](https://github.com/rust-lang/rust/pull/103975)
- [#103934 std: sync "Dependencies of the `backtrace` crate" with `backtrace`](https://github.com/rust-lang/rust/pull/103934)
- [#103880 Use non-ascribed type as field's type in mir](https://github.com/rust-lang/rust/pull/103880)
- [#103841 Rollup of 5 pull requests](https://github.com/rust-lang/rust/pull/103841)
- [#103650 rustdoc: change `.src-line-numbers > span` to `.src-line-numbers > a`](https://github.com/rust-lang/rust/pull/103650)
- [#103562 Rollup of 10 pull requests](https://github.com/rust-lang/rust/pull/103562)
- [#103439 Show note where the macro failed to match](https://github.com/rust-lang/rust/pull/103439)
- [#103295 ci: Bring back ninja for dist builders](https://github.com/rust-lang/rust/pull/103295)
- [#103071 Fix line numbers for MIR inlined code](https://github.com/rust-lang/rust/pull/103071)
- [#102975 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/102975)
- [#102915 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/102915)
- [#102895 Get rid of `rustc_query_description!`](https://github.com/rust-lang/rust/pull/102895)
- [#102867 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/102867)
- [#102809 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/102809)
