// Copyright 2012-2018 The Rust Project Developers. See the COPYRIGHT
// file at the top-level directory of this distribution and at
// http://rust-lang.org/COPYRIGHT.
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

// NOTE: The following code was generated by "scripts/unicode.py", do not edit directly

#![allow(missing_docs)]
use crate::quick_check::IsNormalized;
use crate::quick_check::IsNormalized::*;

#[allow(unused)]
pub const UNICODE_VERSION: (u8, u8, u8) = (16, 0, 0);

pub(crate) const CANONICAL_COMBINING_CLASS_SALT: &[u16] = &[
    0x000, 0x001, 0x2E5, 0x085, 0x014, 0x000, 0x023, 0x092, 0x01C, 0x07A, 0x000, 0x001, 0x000,
    0x000, 0x06C, 0x02B, 0x006, 0x000, 0x000, 0x000, 0x00F, 0x000, 0x001, 0x007, 0x03A, 0x009,
    0x10D, 0x002, 0x01A, 0x000, 0x004, 0x008, 0x069, 0x000, 0x000, 0x002, 0x011, 0x000, 0x01E,
    0x000, 0x07E, 0x01B, 0x005, 0x002, 0x008, 0x000, 0x007, 0x004, 0x006, 0x00E, 0x000, 0x00A,
    0x002, 0x057, 0x022, 0x000, 0x013, 0x001, 0x005, 0x000, 0x000, 0x02D, 0x000, 0x000, 0x000,
    0x000, 0x001, 0x049, 0x003, 0x001, 0x057, 0x000, 0x012, 0x000, 0x000, 0x000, 0x005, 0x041,
    0x000, 0x000, 0x003, 0x000, 0x003, 0x002, 0x002, 0x01D, 0x000, 0x000, 0x000, 0x011, 0x001,
    0x000, 0x002, 0x001, 0x000, 0x00E, 0x000, 0x00B, 0x001, 0x006, 0x005, 0x000, 0x001, 0x000,
    0x017, 0x000, 0x000, 0x001, 0x000, 0x000, 0x00A, 0x002, 0x000, 0x004, 0x00B, 0x018, 0x021,
    0x00C, 0x001, 0x038, 0x000, 0x000, 0x002, 0x003, 0x001, 0x005, 0x000, 0x000, 0x00A, 0x01B,
    0x001, 0x000, 0x000, 0x000, 0x019, 0x01A, 0x000, 0x000, 0x000, 0x004, 0x024, 0x003, 0x019,
    0x004, 0x000, 0x00D, 0x001, 0x013, 0x000, 0x012, 0x004, 0x000, 0x006, 0x003, 0x006, 0x000,
    0x002, 0x00F, 0x000, 0x000, 0x000, 0x000, 0x000, 0x011, 0x001, 0x011, 0x011, 0x005, 0x000,
    0x00B, 0x013, 0x01E, 0x00A, 0x004, 0x001, 0x00C, 0x00A, 0x000, 0x000, 0x005, 0x003, 0x006,
    0x000, 0x005, 0x009, 0x002, 0x000, 0x000, 0x009, 0x000, 0x001, 0x000, 0x029, 0x000, 0x012,
    0x019, 0x004, 0x000, 0x000, 0x002, 0x00E, 0x003, 0x001, 0x00F, 0x005, 0x002, 0x001, 0x004,
    0x007, 0x005, 0x000, 0x005, 0x002, 0x000, 0x000, 0x009, 0x000, 0x005, 0x003, 0x009, 0x001,
    0x000, 0x000, 0x001, 0x000, 0x000, 0x009, 0x007, 0x007, 0x000, 0x000, 0x000, 0x006, 0x003,
    0x000, 0x00A, 0x000, 0x000, 0x003, 0x007, 0x001, 0x000, 0x000, 0x001, 0x01A, 0x006, 0x000,
    0x001, 0x009, 0x002, 0x008, 0x000, 0x001, 0x000, 0x008, 0x001, 0x009, 0x006, 0x015, 0x001,
    0x000, 0x004, 0x000, 0x000, 0x000, 0x00C, 0x000, 0x005, 0x003, 0x000, 0x006, 0x000, 0x000,
    0x008, 0x000, 0x000, 0x003, 0x007, 0x001, 0x000, 0x005, 0x001, 0x010, 0x007, 0x001, 0x005,
    0x000, 0x000, 0x004, 0x004, 0x009, 0x00B, 0x001, 0x005, 0x004, 0x00A, 0x008, 0x003, 0x018,
    0x000, 0x001, 0x002, 0x003, 0x000, 0x002, 0x000, 0x007, 0x000, 0x003, 0x000, 0x005, 0x007,
    0x009, 0x00F, 0x006, 0x000, 0x005, 0x003, 0x009, 0x00B, 0x013, 0x002, 0x001, 0x000, 0x001,
    0x001, 0x000, 0x001, 0x000, 0x001, 0x003, 0x00F, 0x000, 0x004, 0x000, 0x000, 0x007, 0x007,
    0x002, 0x000, 0x000, 0x000, 0x002, 0x004, 0x00B, 0x000, 0x00C, 0x001, 0x000, 0x000, 0x002,
    0x004, 0x008, 0x002, 0x002, 0x000, 0x006, 0x000, 0x00B, 0x001, 0x001, 0x00C, 0x006, 0x000,
    0x004, 0x002, 0x00B, 0x001, 0x000, 0x001, 0x000, 0x000, 0x005, 0x001, 0x001, 0x00E, 0x003,
    0x005, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x003, 0x000, 0x000, 0x00A, 0x003,
    0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x013, 0x000, 0x002, 0x00A, 0x000, 0x000, 0x003,
    0x003, 0x001, 0x003, 0x007, 0x004, 0x002, 0x000, 0x002, 0x000, 0x004, 0x000, 0x001, 0x001,
    0x00E, 0x001, 0x005, 0x001, 0x002, 0x006, 0x002, 0x003, 0x004, 0x006, 0x002, 0x003, 0x001,
    0x001, 0x005, 0x001, 0x000, 0x00E, 0x003, 0x002, 0x007, 0x000, 0x000, 0x00A, 0x004, 0x000,
    0x000, 0x000, 0x006, 0x000, 0x000, 0x000, 0x000, 0x005, 0x000, 0x006, 0x001, 0x000, 0x003,
    0x005, 0x003, 0x001, 0x007, 0x001, 0x002, 0x008, 0x008, 0x002, 0x001, 0x004, 0x000, 0x005,
    0x009, 0x002, 0x000, 0x001, 0x003, 0x010, 0x001, 0x004, 0x004, 0x004, 0x003, 0x000, 0x000,
    0x001, 0x000, 0x002, 0x000, 0x000, 0x001, 0x001, 0x010, 0x002, 0x003, 0x000, 0x000, 0x000,
    0x003, 0x001, 0x001, 0x003, 0x000, 0x000, 0x002, 0x000, 0x001, 0x001, 0x000, 0x005, 0x002,
    0x000, 0x002, 0x003, 0x000, 0x006, 0x000, 0x000, 0x001, 0x001, 0x000, 0x000, 0x001, 0x000,
    0x00A, 0x000, 0x007, 0x000, 0x001, 0x001, 0x000, 0x001, 0x001, 0x004, 0x003, 0x003, 0x002,
    0x007, 0x003, 0x000, 0x007, 0x000, 0x000, 0x003, 0x000, 0x001, 0x00B, 0x001, 0x002, 0x005,
    0x000, 0x003, 0x001, 0x000, 0x000, 0x003, 0x000, 0x002, 0x000, 0x000, 0x000, 0x002, 0x001,
    0x000, 0x001, 0x002, 0x001, 0x004, 0x005, 0x004, 0x000, 0x003, 0x002, 0x000, 0x000, 0x001,
    0x005, 0x002, 0x007, 0x001, 0x001, 0x000, 0x001, 0x000, 0x001, 0x003, 0x003, 0x002, 0x004,
    0x000, 0x001, 0x001, 0x001, 0x000, 0x000, 0x003, 0x002, 0x005, 0x000, 0x005, 0x00F, 0x002,
    0x000, 0x001, 0x001, 0x000, 0x002, 0x000, 0x000, 0x000, 0x001, 0x000, 0x003, 0x000, 0x000,
    0x000, 0x000, 0x000, 0x000, 0x001, 0x002, 0x001, 0x001, 0x003, 0x000, 0x001, 0x003, 0x001,
    0x000, 0x000, 0x002, 0x000, 0x005, 0x003, 0x000, 0x006, 0x001, 0x002, 0x002, 0x003, 0x001,
    0x003, 0x005, 0x006, 0x000, 0x002, 0x003, 0x00A, 0x000, 0x001, 0x001, 0x002, 0x002, 0x002,
    0x004, 0x000, 0x000, 0x000, 0x000, 0x000, 0x001, 0x005, 0x004, 0x001, 0x000, 0x000, 0x003,
    0x001, 0x000, 0x000, 0x002, 0x000, 0x002, 0x001, 0x001, 0x002, 0x003, 0x000, 0x002, 0x000,
    0x001, 0x000, 0x002, 0x003, 0x000, 0x002, 0x002, 0x001, 0x000, 0x001, 0x000, 0x001, 0x004,
    0x001, 0x000, 0x004, 0x004, 0x001, 0x000, 0x000, 0x001, 0x001, 0x003, 0x001, 0x000, 0x000,
    0x001, 0x002, 0x002, 0x009, 0x001, 0x005, 0x002, 0x002, 0x001, 0x000, 0x002, 0x006, 0x00D,
    0x001, 0x002, 0x006, 0x000, 0x000, 0x000, 0x000, 0x000, 0x001, 0x000, 0x007, 0x000, 0x004,
    0x002, 0x000, 0x002, 0x003, 0x001, 0x000, 0x002, 0x000, 0x001, 0x003, 0x000, 0x001, 0x000,
    0x001, 0x000, 0x003, 0x002, 0x001, 0x006, 0x000, 0x000, 0x000, 0x001, 0x000, 0x000, 0x000,
    0x003, 0x003, 0x000, 0x000, 0x000, 0x000, 0x000, 0x009, 0x000, 0x000, 0x000, 0x002, 0x001,
    0x001, 0x003, 0x001, 0x001, 0x000, 0x005, 0x000, 0x003, 0x002, 0x003, 0x001, 0x001, 0x002,
    0x000, 0x003, 0x001, 0x001, 0x000, 0x000, 0x001, 0x000, 0x001, 0x001, 0x002, 0x003, 0x001,
    0x001, 0x000, 0x001, 0x005, 0x004, 0x000, 0x003, 0x003, 0x000, 0x002, 0x003, 0x001, 0x001,
    0x005, 0x003, 0x001, 0x000, 0x000, 0x001, 0x002, 0x001, 0x003, 0x00A, 0x004, 0x000, 0x001,
    0x003, 0x001, 0x000, 0x000, 0x000, 0x001, 0x000, 0x000, 0x005, 0x002, 0x000, 0x001, 0x001,
    0x000, 0x000, 0x006, 0x005, 0x003, 0x000, 0x000, 0x002, 0x000, 0x001, 0x000, 0x001, 0x001,
    0x001, 0x001, 0x001, 0x000, 0x000, 0x00B, 0x004, 0x000, 0x002, 0x001, 0x002, 0x002, 0x001,
    0x001, 0x000, 0x001, 0x002, 0x001, 0x001, 0x001, 0x002, 0x002, 0x000, 0x004, 0x001, 0x002,
    0x000, 0x000, 0x001, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x001, 0x000,
    0x000, 0x000, 0x008, 0x001, 0x001, 0x000, 0x002, 0x002, 0x003, 0x002, 0x001, 0x001, 0x002,
    0x000, 0x001, 0x000, 0x000, 0x009, 0x001, 0x001, 0x000, 0x001, 0x000, 0x003, 0x000, 0x001,
    0x006, 0x001, 0x001, 0x000, 0x003, 0x001, 0x001, 0x001, 0x001, 0x004, 0x002, 0x002, 0x001,
    0x000, 0x001, 0x003, 0x004, 0x000, 0x003, 0x000, 0x000, 0x001, 0x001, 0x001,
];
pub(crate) const CANONICAL_COMBINING_CLASS_KV: &[u32] = &[
    0x0034AE6, 0x00E3A09, 0x01DFADA, 0x00818E6, 0x0FE20E6, 0x0A67CE6, 0x020D201, 0x02DFEE6,
    0x008CCE6, 0x00737DC, 0x01DEBE6, 0x0FE26E6, 0x0089DE6, 0x01A7AE6, 0x006EADC, 0x0A675E6,
    0x02DF7E6, 0x0A8EBE6, 0x1193D09, 0x0064F1F, 0x00741E6, 0x10D6AE6, 0x0FE2DDC, 0x1E024E6,
    0x00322CA, 0x1E023E6, 0x01ACBE6, 0x005BB14, 0x00359DC, 0x008CEE6, 0x00F7484, 0x01B6DE6,
    0x0A8E6E6, 0x0030DE6, 0x00F7A82, 0x1117307, 0x00356DC, 0x00592E6, 0x0FE2BDC, 0x01DEEE6,
    0x00360EA, 0x1E947E6, 0x1133B07, 0x02CF1E6, 0x1E02AE6, 0x1D182DC, 0x01DE6E6, 0x10EFDDC,
    0x00736E6, 0x01DECE6, 0x008D6E6, 0x10D25E6, 0x008FDE6, 0x00744DC, 0x00ECA7A, 0x1136CE6,
    0x009BC07, 0x01AB9DC, 0x1D1ADE6, 0x008E4E6, 0x01A79E6, 0x10F4DDC, 0x00825E6, 0x0AABFE6,
    0x0AABEE6, 0x00953E6, 0x0A8E9E6, 0x008E3DC, 0x0064E1E, 0x006D6E6, 0x111CA07, 0x10D69E6,
    0x00364E6, 0x10A3ADC, 0x01DC4E6, 0x0103A09, 0x00349DC, 0x00358E8, 0x00487E6, 0x01AB1E6,
    0x0065020, 0x01CD0E6, 0x0FE28DC, 0x005B711, 0x020D5E6, 0x00819E6, 0x01C3707, 0x16AF301,
    0x01DCADC, 0x01BF309, 0x01DDAE6, 0x0035FE9, 0x01DDDE6, 0x10F82E6, 0x00361EA, 0x11D4509,
    0x00352E6, 0x01DF0E6, 0x0034CE6, 0x01CD7DC, 0x0033701, 0x1E2EDE6, 0x11373E6, 0x01B6EE6,
    0x020EA01, 0x10EABE6, 0x007EFE6, 0x0081DE6, 0x1D16801, 0x1E8D6DC, 0x01CD401, 0x00367E6,
    0x1D188E6, 0x01CE0E6, 0x008EAE6, 0x01CDAE6, 0x00735E6, 0x005C712, 0x00C4D09, 0x00323DC,
    0x00598E6, 0x10F4AE6, 0x01DDFE6, 0x020E8DC, 0x11D9709, 0x01DE1E6, 0x00316DC, 0x01A7CE6,
    0x1E945E6, 0x01DD9E6, 0x0085BDC, 0x00EC97A, 0x00D4D09, 0x02DF0E6, 0x0309908, 0x017D209,
    0x0A67AE6, 0x1D1AAE6, 0x005B40E, 0x01DE3E6, 0x111C009, 0x1D1ACE6, 0x00357E6, 0x119E009,
    0x0030BE6, 0x0033EE6, 0x01CE301, 0x01CF8E6, 0x00F8409, 0x01DCBE6, 0x00317DC, 0x00483E6,
    0x10F4BDC, 0x00326DC, 0x01CD2E6, 0x020D0E6, 0x005C4E6, 0x01AB0E6, 0x0089ADC, 0x0081CE6,
    0x01DE4E6, 0x1144607, 0x115C007, 0x1183A07, 0x10F49E6, 0x00659E6, 0x01B6FE6, 0x0032DDC,
    0x00EB876, 0x1BC9E01, 0x00734DC, 0x1136AE6, 0x0032EDC, 0x020E501, 0x008FBE6, 0x02D7F09,
    0x1E944E6, 0x1E018E6, 0x01DEFE6, 0x1E949E6, 0x02DEEE6, 0x0135FE6, 0x00309E6, 0x01AC2E6,
    0x00485E6, 0x01DF8E4, 0x00F86E6, 0x00613E6, 0x008D9E6, 0x01CDDDC, 0x1104609, 0x00304E6,
    0x008E6DC, 0x0081EE6, 0x01DF6E8, 0x0093C07, 0x0A8ECE6, 0x1D1ABE6, 0x006ECE6, 0x0064C1C,
    0x008F5E6, 0x1D244E6, 0x1E014E6, 0x00FC6DC, 0x0A8E1E6, 0x005AADC, 0x00658E6, 0x1E020E6,
    0x008D4E6, 0x1133C07, 0x00302E6, 0x01AC4DC, 0x01DC6E6, 0x01AB4E6, 0x1D170D8, 0x0135EE6,
    0x0059EE6, 0x008FFE6, 0x00739DC, 0x10AE5E6, 0x1E8D2DC, 0x1107009, 0x00308E6, 0x02CF0E6,
    0x01DF3E6, 0x0A67DE6, 0x01DCED6, 0x0033ADC, 0x1D166D8, 0x00733E6, 0x11F4109, 0x0036BE6,
    0x01CDEDC, 0x1E012E6, 0x0108DDC, 0x00611E6, 0x00ABC07, 0x01CEDDC, 0x1E026E6, 0x00343E6,
    0x020D901, 0x1E948E6, 0x116B707, 0x00746DC, 0x01DE8E6, 0x020D7E6, 0x02DEFE6, 0x00355DC,
    0x01A77E6, 0x00E3867, 0x0FE24E6, 0x1113309, 0x11369E6, 0x02DF4E6, 0x10EFFDC, 0x006EDDC,
    0x0FE29DC, 0x0031EDC, 0x01DFCE9, 0x00F35DC, 0x1E4EEDC, 0x10D6DE6, 0x1D171D8, 0x11A9909,
    0x00303E6, 0x10377E6, 0x1E015E6, 0x00313E6, 0x00332DC, 0x11368E6, 0x10D6CE6, 0x0A92DDC,
    0x006E1E6, 0x00362E9, 0x00596DC, 0x0067023, 0x10F4FDC, 0x1123509, 0x01DC3E6, 0x10A0FE6,
    0x02DF8E6, 0x0A8E4E6, 0x0032CDC, 0x00D3B09, 0x1D165D8, 0x0171409, 0x01CE601, 0x01ABBE6,
    0x008DAE6, 0x00B3C07, 0x008F11C, 0x10AE6DC, 0x1E8D5DC, 0x00745E6, 0x01AC0DC, 0x020EEDC,
    0x01CDFDC, 0x02DF9E6, 0x01AC5E6, 0x00597E6, 0x0302BE4, 0x00897E6, 0x1144209, 0x006DBE6,
    0x0A80609, 0x113CE09, 0x0035DEA, 0x0FE2FE6, 0x00CBC07, 0x01DC7E6, 0x006E7E6, 0x00321CA,
    0x00369E6, 0x00F7C82, 0x0031AE8, 0x02DF1E6, 0x008E8E6, 0x16AF201, 0x00740E6, 0x01DFDDC,
    0x1E5EEE6, 0x11D4207, 0x01ABADC, 0x0A8E2E6, 0x112E907, 0x1D16901, 0x1E010E6, 0x1E000E6,
    0x005B00A, 0x005C5DC, 0x0302FE0, 0x01A78E6, 0x1113409, 0x1E006E6, 0x01DE9E6, 0x008CFDC,
    0x01DCCE6, 0x00F7D82, 0x006DCE6, 0x0173409, 0x0103909, 0x01BE607, 0x00731DC, 0x00312E6,
    0x1E8D4DC, 0x00829E6, 0x008FADC, 0x1E029E6, 0x00823E6, 0x0030CE6, 0x01AB6DC, 0x1E135E6,
    0x01DC8E6, 0x01DEDE6, 0x0035ADC, 0x00732E6, 0x0A8EDE6, 0x0AAB3E6, 0x1E028E6, 0x008F6DC,
    0x008E7E6, 0x1E4ECE8, 0x0073CDC, 0x01DF7E4, 0x005ACE6, 0x020EFDC, 0x01CF4E6, 0x00368E6,
    0x1E01CE6, 0x1D18ADC, 0x0FE21E6, 0x01DDCE6, 0x020D4E6, 0x0059BDC, 0x16B32E6, 0x0035BE6,
    0x008D2DC, 0x0031BD8, 0x0A677E6, 0x1E003E6, 0x00DCA09, 0x0031DDC, 0x10F4CE6, 0x00F19DC,
    0x01DFFDC, 0x0135DE6, 0x0030FE6, 0x02DE5E6, 0x0033801, 0x01ACEE6, 0x00743E6, 0x0193AE6,
    0x10A3F09, 0x00CCD09, 0x01B71E6, 0x00954E6, 0x0089CE6, 0x020E601, 0x008F01B, 0x00657E6,
    0x0FE23E6, 0x00311E6, 0x10EACE6, 0x020D301, 0x0064B1B, 0x020DBE6, 0x008DEE6, 0x0065DE6,
    0x1E009E6, 0x0A674E6, 0x008CDE6, 0x01CE701, 0x008F21D, 0x0089EE6, 0x01DD1E6, 0x00324DC,
    0x10A38E6, 0x01CD1E6, 0x01CD5DC, 0x1E132E6, 0x00EC87A, 0x01DCDEA, 0x0FE25E6, 0x0061A20,
    0x00301E6, 0x005A1E6, 0x008F8E6, 0x1D186E6, 0x00305E6, 0x16B30E6, 0x01DF4E6, 0x00730E6,
    0x00821E6, 0x007F1E6, 0x114C307, 0x0033DE6, 0x01DC2DC, 0x00615E6, 0x006E3DC, 0x01A17E6,
    0x0089FE6, 0x0AAB0E6, 0x01DD5E6, 0x1E01FE6, 0x0082AE6, 0x00325DC, 0x11374E6, 0x10376E6,
    0x0081BE6, 0x02DFFE6, 0x1D16FD8, 0x00484E6, 0x00318DC, 0x1E8D0DC, 0x005A6DC, 0x1193E09,
    0x00F39D8, 0x1E00CE6, 0x00591DC, 0x1D187E6, 0x01B6CDC, 0x01DD0CA, 0x006D8E6, 0x01B3407,
    0x02DEAE6, 0x1163F09, 0x008DDE6, 0x00F87E6, 0x02DE3E6, 0x00300E6, 0x0A6F1E6, 0x02DF2E6,
    0x005A7DC, 0x01DF2E6, 0x00820E6, 0x00365E6, 0x1D17BDC, 0x01AB7DC, 0x1D16ED8, 0x0034DDC,
    0x1E2EEE6, 0x0ABED09, 0x0AAB7E6, 0x0A8EFE6, 0x00614E6, 0x11C3F09, 0x102E0DC, 0x00ACD09,
    0x0171509, 0x01AC6E6, 0x005B610, 0x11A3409, 0x0035EEA, 0x00310E6, 0x16AF401, 0x1E01EE6,
    0x0032ADC, 0x0AAB2E6, 0x0A9C009, 0x00366E6, 0x005B50F, 0x009FEE6, 0x006DFE6, 0x0FE22E6,
    0x1E8D3DC, 0x00340E6, 0x01DD8E6, 0x10F48E6, 0x02DFAE6, 0x1D17CDC, 0x0A678E6, 0x00826E6,
    0x0A82C09, 0x01DE0E6, 0x0A8E0E6, 0x10F83DC, 0x0302DDE, 0x01DF5E6, 0x01B73E6, 0x1E00FE6,
    0x1D16701, 0x01A6009, 0x02DE1E6, 0x0036CE6, 0x006EBE6, 0x00C565B, 0x01DE7E6, 0x00B4D09,
    0x1E00DE6, 0x02DFDE6, 0x008F7E6, 0x00655DC, 0x0A67BE6, 0x00333DC, 0x005C118, 0x11366E6,
    0x1D16DE2, 0x006181E, 0x0033FE6, 0x1E946E6, 0x0FE27DC, 0x007F0E6, 0x1E002E6, 0x114C209,
    0x1E01DE6, 0x0A95309, 0x16B33E6, 0x1E01BE6, 0x01CE201, 0x01ACDE6, 0x00610E6, 0x0FE2CDC,
    0x0A676E6, 0x16AF001, 0x020D6E6, 0x1D17FDC, 0x1D181DC, 0x005B913, 0x00827E6, 0x008D3DC,
    0x115BF09, 0x005A0E6, 0x0065222, 0x008DFE6, 0x00653E6, 0x01CE401, 0x113CF09, 0x01A76E6,
    0x006E2E6, 0x110B909, 0x10F46DC, 0x11A4709, 0x11370E6, 0x01CF9E6, 0x0065EE6, 0x00616E6,
    0x02DFBE6, 0x1136BE6, 0x00656DC, 0x00348DC, 0x10D26E6, 0x01DD6E6, 0x008FCE6, 0x1145EE6,
    0x00654E6, 0x008ECE6, 0x008CAE6, 0x020F0E6, 0x01DD7E6, 0x0030AE6, 0x00328CA, 0x00314E6,
    0x0085ADC, 0x0034BE6, 0x1D189E6, 0x1E00AE6, 0x008DBE6, 0x10F4EDC, 0x005B812, 0x00320DC,
    0x01DDEE6, 0x01B6BE6, 0x01AC3DC, 0x0033BDC, 0x01ACCE6, 0x005B30D, 0x0073FE6, 0x01AC1E6,
    0x0302CE8, 0x01CD6DC, 0x00F37DC, 0x01DC1E6, 0x01DFEE6, 0x018A9E4, 0x020EB01, 0x008EFDC,
    0x00347DC, 0x1123607, 0x00486E6, 0x00749E6, 0x017DDE6, 0x11102E6, 0x00617E6, 0x00D3C09,
    0x0A8EAE6, 0x008EDDC, 0x00351E6, 0x00A3C07, 0x1E2ECE6, 0x116B609, 0x1E011E6, 0x020E1E6,
    0x10D6BE6, 0x005C219, 0x01A7BE6, 0x007EEE6, 0x0036EE6, 0x008F9DC, 0x01DEAE6, 0x00BCD09,
    0x005B10B, 0x01AB3E6, 0x11372E6, 0x008D7E6, 0x1D17EDC, 0x0A8EEE6, 0x008DCE6, 0x16B31E6,
    0x02DE7E6, 0x0065121, 0x006E4E6, 0x0059CE6, 0x00342E6, 0x0AAB4DC, 0x00595E6, 0x16B36E6,
    0x0030EE6, 0x0033501, 0x0036FE6, 0x00816E6, 0x0302EE0, 0x00353DC, 0x0031CDC, 0x00315E8,
    0x01B72E6, 0x005A2DC, 0x02DF6E6, 0x008EEDC, 0x0082DE6, 0x01CD8DC, 0x005BA13, 0x01AC7E6,
    0x01AB2E6, 0x0033CDC, 0x01939DE, 0x0103707, 0x0A8F1E6, 0x00612E6, 0x10F84E6, 0x0073BDC,
    0x1E008E6, 0x007EDE6, 0x020EDDC, 0x00E4A6B, 0x16FF106, 0x110BA07, 0x00346E6, 0x008FEE6,
    0x00331DC, 0x00C3C07, 0x1E00EE6, 0x00ECB7A, 0x005ABE6, 0x16AF101, 0x01ABCE6, 0x0081FE6,
    0x01BAA09, 0x10D24E6, 0x0A92CDC, 0x005A8E6, 0x1037AE6, 0x0059DE6, 0x01B70E6, 0x006E8E6,
    0x00F7181, 0x02DE4E6, 0x16B34E6, 0x02DEDE6, 0x00A4D09, 0x0A92BDC, 0x0082CE6, 0x1E2EFE6,
    0x1D242E6, 0x00354DC, 0x0032BDC, 0x0193BDC, 0x008D1DC, 0x0073EDC, 0x1E005E6, 0x00319DC,
    0x02DEBE6, 0x0073AE6, 0x01AC8E6, 0x00F82E6, 0x1E133E6, 0x1D180DC, 0x0033601, 0x00EBA09,
    0x0AAF609, 0x02DF5E6, 0x00307E6, 0x01DC0E6, 0x10F85DC, 0x0032FDC, 0x0035CE9, 0x01CDBE6,
    0x00330DC, 0x01AB5DC, 0x01DDBE6, 0x02DE9E6, 0x00F7282, 0x1E131E6, 0x00363E6, 0x16FF006,
    0x007ECE6, 0x112EA09, 0x10378E6, 0x007FDDC, 0x0302ADA, 0x0065BE6, 0x006191F, 0x00F18DC,
    0x1172B09, 0x00952DC, 0x00F83E6, 0x00898E6, 0x00899DC, 0x10A3901, 0x1134D09, 0x01DF1E6,
    0x0309A08, 0x00747E6, 0x01DE2E6, 0x1E8D1DC, 0x10EFEDC, 0x1E013E6, 0x0034EDC, 0x005B20C,
    0x16B35E6, 0x00859DC, 0x1107F09, 0x00738DC, 0x005A3DC, 0x11367E6, 0x01ACADC, 0x01A7FDC,
    0x1E08FE6, 0x11100E6, 0x0065AE6, 0x11D4409, 0x01DCFDC, 0x0065CDC, 0x01DD3E6, 0x005AEE4,
    0x1E016E6, 0x008EBE6, 0x0031FDC, 0x00EB976, 0x1E004E6, 0x0033401, 0x0074AE6, 0x01DF9DC,
    0x01CE801, 0x0064D1D, 0x020D1E6, 0x0A8E5E6, 0x1D243E6, 0x0094D09, 0x00E4B6B, 0x007F3E6,
    0x005ADDE, 0x005A4DC, 0x008F4E6, 0x11F4209, 0x0AAC1E6, 0x1D185E6, 0x02DECE6, 0x0A8F0E6,
    0x01DE5E6, 0x00306E6, 0x0A8E3E6, 0x00951E6, 0x11101E6, 0x02DE8E6, 0x00748DC, 0x0A8E8E6,
    0x1E4EDE8, 0x006DAE6, 0x01CE501, 0x0AAB8E6, 0x10A0DDC, 0x00822E6, 0x00327CA, 0x1612F09,
    0x1E017E6, 0x00339DC, 0x02DE6E6, 0x020E7E6, 0x00345F0, 0x0FE2EE6, 0x10379E6, 0x0071124,
    0x101FDDC, 0x0082BE6, 0x01B4409, 0x00329DC, 0x00350E6, 0x005AFE6, 0x02DFCE6, 0x008D8E6,
    0x00C5554, 0x00817E6, 0x1E021E6, 0x01AC9E6, 0x00593E6, 0x01DD2E6, 0x0A9B307, 0x01DC9E6,
    0x00341E6, 0x008D0DC, 0x0A6F0E6, 0x008E0E6, 0x01A75E6, 0x01DC5E6, 0x0059FE6, 0x01ABDDC,
    0x01ABFDC, 0x1E5EFDC, 0x00594E6, 0x005A5DC, 0x007F2DC, 0x01BAB09, 0x01BF209, 0x1E4EFE6,
    0x005A9E6, 0x008F3E6, 0x1E00BE6, 0x1D172D8, 0x006D7E6, 0x006D9E6, 0x0036AE6, 0x01CD9DC,
    0x10F47DC, 0x0A69FE6, 0x005BC15, 0x008E1E6, 0x1E134E6, 0x0065FDC, 0x0A8E7E6, 0x1E001E6,
    0x1E027E6, 0x1E2AEE6, 0x01DFBE6, 0x00E486B, 0x01AB8DC, 0x01A18DC, 0x020D801, 0x0FB1E1A,
    0x0A66FE6, 0x02DE2E6, 0x02DF3E6, 0x00599E6, 0x1183909, 0x113D009, 0x00E3967, 0x0059ADE,
    0x10D27E6, 0x0073DE6, 0x10F50DC, 0x008CBE6, 0x01DD4E6, 0x02CEFE6, 0x00742DC, 0x1D18BDC,
    0x008D5E6, 0x01CDCDC, 0x02DE0E6, 0x0089BDC, 0x0A679E6, 0x020E9E6, 0x008E9DC, 0x1E130E6,
    0x020DA01, 0x020DCE6, 0x1194307, 0x006E0E6, 0x0A69EE6, 0x008E5E6, 0x1E136E6, 0x020ECDC,
    0x00E496B, 0x0036DE6, 0x11371E6, 0x005BF17, 0x0A8C409, 0x007EBE6, 0x0FE2ADC, 0x1D17DDC,
    0x009CD09, 0x005BD16, 0x00F8082, 0x00344E6, 0x00F7B82, 0x1E94A07,
];

pub(crate) const COMPOSITION_TABLE_SALT: &[u16] = &[
    0x000, 0x000, 0x000, 0x000, 0x25D, 0x003, 0x05D, 0x000, 0x002, 0x009, 0x004, 0x087, 0x006,
    0x135, 0x001, 0x000, 0x000, 0x004, 0x003, 0x0E1, 0x078, 0x000, 0x002, 0x029, 0x008, 0x08F,
    0x024, 0x000, 0x000, 0x000, 0x031, 0x000, 0x000, 0x06D, 0x000, 0x033, 0x001, 0x04C, 0x000,
    0x001, 0x000, 0x000, 0x008, 0x07C, 0x006, 0x04C, 0x045, 0x02A, 0x002, 0x000, 0x000, 0x000,
    0x00A, 0x000, 0x000, 0x059, 0x000, 0x010, 0x003, 0x009, 0x00E, 0x006, 0x001, 0x00C, 0x010,
    0x000, 0x000, 0x000, 0x03D, 0x000, 0x000, 0x02A, 0x000, 0x000, 0x001, 0x020, 0x00A, 0x000,
    0x001, 0x00E, 0x002, 0x010, 0x022, 0x000, 0x061, 0x000, 0x004, 0x015, 0x000, 0x004, 0x003,
    0x000, 0x000, 0x003, 0x000, 0x00D, 0x001, 0x001, 0x024, 0x003, 0x004, 0x000, 0x000, 0x018,
    0x058, 0x000, 0x000, 0x00A, 0x019, 0x010, 0x000, 0x002, 0x000, 0x000, 0x012, 0x015, 0x000,
    0x00C, 0x007, 0x003, 0x000, 0x01A, 0x007, 0x00C, 0x001, 0x005, 0x004, 0x021, 0x001, 0x002,
    0x000, 0x000, 0x001, 0x00A, 0x000, 0x00A, 0x000, 0x004, 0x009, 0x005, 0x00D, 0x005, 0x000,
    0x003, 0x006, 0x026, 0x00B, 0x000, 0x004, 0x006, 0x000, 0x013, 0x000, 0x000, 0x004, 0x001,
    0x000, 0x000, 0x000, 0x024, 0x001, 0x01D, 0x001, 0x000, 0x000, 0x010, 0x000, 0x001, 0x001,
    0x001, 0x000, 0x000, 0x00A, 0x000, 0x00D, 0x000, 0x010, 0x000, 0x006, 0x005, 0x000, 0x000,
    0x009, 0x003, 0x001, 0x000, 0x000, 0x000, 0x000, 0x002, 0x001, 0x002, 0x000, 0x000, 0x016,
    0x001, 0x002, 0x000, 0x001, 0x000, 0x006, 0x001, 0x025, 0x005, 0x000, 0x00A, 0x00D, 0x002,
    0x000, 0x001, 0x000, 0x000, 0x012, 0x000, 0x000, 0x001, 0x000, 0x001, 0x000, 0x001, 0x000,
    0x004, 0x009, 0x000, 0x001, 0x004, 0x000, 0x004, 0x001, 0x006, 0x00B, 0x003, 0x006, 0x007,
    0x000, 0x000, 0x000, 0x00D, 0x00F, 0x00E, 0x000, 0x001, 0x001, 0x004, 0x00F, 0x010, 0x000,
    0x005, 0x000, 0x019, 0x001, 0x00E, 0x000, 0x008, 0x001, 0x003, 0x000, 0x000, 0x005, 0x001,
    0x000, 0x000, 0x011, 0x000, 0x004, 0x005, 0x000, 0x001, 0x000, 0x000, 0x000, 0x000, 0x002,
    0x001, 0x000, 0x000, 0x002, 0x001, 0x001, 0x005, 0x008, 0x000, 0x000, 0x00C, 0x00A, 0x000,
    0x006, 0x009, 0x003, 0x001, 0x006, 0x001, 0x000, 0x01B, 0x001, 0x00E, 0x000, 0x008, 0x005,
    0x003, 0x015, 0x000, 0x002, 0x007, 0x00B, 0x003, 0x000, 0x00A, 0x003, 0x000, 0x006, 0x000,
    0x00A, 0x000, 0x001, 0x003, 0x008, 0x000, 0x009, 0x000, 0x001, 0x002, 0x000, 0x005, 0x000,
    0x001, 0x000, 0x000, 0x000, 0x017, 0x000, 0x000, 0x002, 0x000, 0x005, 0x016, 0x000, 0x010,
    0x003, 0x004, 0x011, 0x001, 0x003, 0x000, 0x000, 0x000, 0x004, 0x001, 0x000, 0x005, 0x000,
    0x002, 0x001, 0x000, 0x002, 0x000, 0x002, 0x002, 0x000, 0x000, 0x000, 0x000, 0x002, 0x000,
    0x012, 0x001, 0x004, 0x00A, 0x00B, 0x004, 0x000, 0x002, 0x000, 0x003, 0x000, 0x004, 0x005,
    0x000, 0x000, 0x011, 0x001, 0x006, 0x006, 0x000, 0x002, 0x000, 0x001, 0x000, 0x004, 0x000,
    0x000, 0x001, 0x001, 0x007, 0x000, 0x003, 0x00A, 0x000, 0x001, 0x00A, 0x002, 0x000, 0x001,
    0x000, 0x000, 0x00D, 0x005, 0x001, 0x001, 0x000, 0x000, 0x005, 0x006, 0x008, 0x004, 0x005,
    0x000, 0x00B, 0x000, 0x004, 0x00B, 0x000, 0x000, 0x001, 0x005, 0x000, 0x00B, 0x000, 0x006,
    0x000, 0x000, 0x000, 0x000, 0x001, 0x000, 0x004, 0x000, 0x006, 0x000, 0x000, 0x007, 0x013,
    0x004, 0x019, 0x003, 0x001, 0x000, 0x001, 0x006, 0x006, 0x000, 0x000, 0x000, 0x000, 0x00C,
    0x002, 0x003, 0x000, 0x004, 0x000, 0x001, 0x000, 0x001, 0x005, 0x001, 0x001, 0x002, 0x001,
    0x000, 0x000, 0x000, 0x000, 0x009, 0x000, 0x000, 0x007, 0x001, 0x009, 0x006, 0x004, 0x001,
    0x005, 0x000, 0x001, 0x002, 0x008, 0x000, 0x009, 0x000, 0x000, 0x001, 0x003, 0x00B, 0x000,
    0x001, 0x000, 0x000, 0x005, 0x000, 0x000, 0x000, 0x000, 0x000, 0x003, 0x000, 0x002, 0x001,
    0x002, 0x000, 0x000, 0x000, 0x004, 0x001, 0x000, 0x006, 0x002, 0x005, 0x008, 0x012, 0x000,
    0x000, 0x000, 0x003, 0x001, 0x000, 0x000, 0x000, 0x002, 0x003, 0x003, 0x000, 0x000, 0x001,
    0x000, 0x001, 0x000, 0x003, 0x000, 0x000, 0x002, 0x001, 0x004, 0x00D, 0x000, 0x000, 0x00B,
    0x000, 0x001, 0x000, 0x000, 0x00C, 0x000, 0x000, 0x000, 0x005, 0x008, 0x002, 0x000, 0x002,
    0x001, 0x006, 0x001, 0x001, 0x001, 0x000, 0x002, 0x000, 0x005, 0x001, 0x001, 0x000, 0x002,
    0x000, 0x000, 0x000, 0x000, 0x00E, 0x010, 0x000, 0x005, 0x004, 0x002, 0x001, 0x000, 0x000,
    0x003, 0x001, 0x000, 0x002, 0x001, 0x004, 0x000, 0x000, 0x003, 0x000, 0x001, 0x001, 0x003,
    0x001, 0x005, 0x002, 0x003, 0x004, 0x000, 0x003, 0x003, 0x006, 0x000, 0x000, 0x001, 0x000,
    0x002, 0x00E, 0x001, 0x002, 0x001, 0x004, 0x002, 0x005, 0x002, 0x001, 0x001, 0x000, 0x001,
    0x000, 0x005, 0x005, 0x006, 0x006, 0x005, 0x000, 0x002, 0x001, 0x000, 0x002, 0x004, 0x001,
    0x000, 0x005, 0x000, 0x006, 0x002, 0x008, 0x000, 0x000, 0x007, 0x001, 0x002, 0x002, 0x005,
    0x004, 0x011, 0x000, 0x003, 0x000, 0x001, 0x000, 0x001, 0x004, 0x000, 0x003, 0x002, 0x000,
    0x001, 0x003, 0x000, 0x00B, 0x006, 0x000, 0x006, 0x000, 0x004, 0x001, 0x002, 0x000, 0x001,
    0x000, 0x002, 0x001, 0x002, 0x000, 0x005, 0x001, 0x000, 0x000, 0x000, 0x001, 0x003, 0x002,
    0x006, 0x000, 0x000, 0x002, 0x004, 0x006, 0x000, 0x000, 0x000, 0x000, 0x00C, 0x00C, 0x000,
    0x000, 0x000, 0x004, 0x004, 0x000, 0x008, 0x003, 0x001, 0x000, 0x001, 0x000, 0x003, 0x000,
    0x000, 0x005, 0x000, 0x005, 0x001, 0x000, 0x003, 0x004, 0x001, 0x002, 0x003, 0x000, 0x001,
    0x007, 0x000, 0x000, 0x007, 0x000, 0x002, 0x002, 0x000, 0x000, 0x001, 0x001, 0x001, 0x001,
    0x00B, 0x000, 0x004, 0x000, 0x001, 0x001, 0x000, 0x002, 0x001, 0x001, 0x005, 0x000, 0x000,
    0x003, 0x006, 0x000, 0x000, 0x004, 0x002, 0x001, 0x003, 0x003, 0x00A, 0x007, 0x000, 0x004,
    0x001, 0x006, 0x000, 0x001, 0x000, 0x000, 0x002, 0x001, 0x001, 0x000, 0x000, 0x000, 0x000,
    0x000, 0x002, 0x001, 0x001, 0x001, 0x004, 0x000, 0x003, 0x000, 0x001, 0x000, 0x000, 0x001,
    0x000, 0x001, 0x000, 0x004, 0x000, 0x001, 0x000, 0x006, 0x000, 0x001, 0x000, 0x004, 0x000,
    0x001, 0x002, 0x006, 0x000, 0x002, 0x000, 0x003, 0x007, 0x000, 0x003, 0x000, 0x001, 0x001,
    0x000, 0x000, 0x003, 0x005, 0x002, 0x000, 0x001, 0x001, 0x002, 0x002, 0x004, 0x001, 0x000,
    0x000, 0x001, 0x000, 0x003, 0x002, 0x000, 0x001, 0x000, 0x002, 0x004, 0x002, 0x000, 0x001,
    0x005, 0x000, 0x000, 0x002, 0x001, 0x001, 0x000, 0x000, 0x001, 0x000, 0x005, 0x002, 0x000,
    0x008, 0x003, 0x001, 0x001, 0x001, 0x003, 0x004, 0x000, 0x002, 0x000, 0x001, 0x002, 0x000,
    0x000, 0x000, 0x000, 0x000, 0x001, 0x000, 0x006, 0x000, 0x000, 0x000, 0x003, 0x000, 0x000,
    0x002, 0x002, 0x000, 0x001, 0x003, 0x001, 0x003, 0x001, 0x002, 0x000, 0x001, 0x002, 0x000,
    0x000, 0x001, 0x000, 0x003, 0x001, 0x002, 0x000, 0x002, 0x001, 0x000, 0x002, 0x004, 0x000,
    0x005, 0x005, 0x000, 0x005, 0x002, 0x000, 0x001, 0x003, 0x001, 0x000, 0x002, 0x006, 0x002,
    0x001, 0x000, 0x000, 0x000, 0x003,
];
pub(crate) const COMPOSITION_TABLE_KV: &[(u32, char)] = &[
    (0x064A0654, '\u{000626}'),
    (0x00690309, '\u{001EC9}'),
    (0x00650306, '\u{000115}'),
    (0x0423030B, '\u{0004F2}'),
    (0x0047030C, '\u{0001E6}'),
    (0x00570301, '\u{001E82}'),
    (0x00C50301, '\u{0001FA}'),
    (0x21D20338, '\u{0021CF}'),
    (0x00430307, '\u{00010A}'),
    (0x007A0307, '\u{00017C}'),
    (0x0049030C, '\u{0001CF}'),
    (0x00720307, '\u{001E59}'),
    (0x304B3099, '\u{00304C}'),
    (0x1F610345, '\u{001FA1}'),
    (0x00410307, '\u{000226}'),
    (0x006B0323, '\u{001E33}'),
    (0x03990304, '\u{001FD9}'),
    (0x1F490301, '\u{001F4D}'),
    (0x03CA0342, '\u{001FD7}'),
    (0x00550304, '\u{00016A}'),
    (0x30DB309A, '\u{0030DD}'),
    (0x1F6E0345, '\u{001FAE}'),
    (0x00420331, '\u{001E06}'),
    (0x041E0308, '\u{0004E6}'),
    (0x00410325, '\u{001E00}'),
    (0x00520331, '\u{001E5E}'),
    (0x1FF60345, '\u{001FF7}'),
    (0x22720338, '\u{002274}'),
    (0x22480338, '\u{002249}'),
    (0x1FBF0301, '\u{001FCE}'),
    (0x30C63099, '\u{0030C7}'),
    (0x00760323, '\u{001E7F}'),
    (0x00700307, '\u{001E57}'),
    (0x1F510301, '\u{001F55}'),
    (0x00750328, '\u{000173}'),
    (0x305B3099, '\u{00305C}'),
    (0x0041030A, '\u{0000C5}'),
    (0x01A10323, '\u{001EE3}'),
    (0x00550311, '\u{000216}'),
    (0x00530307, '\u{001E60}'),
    (0x00DC030C, '\u{0001D9}'),
    (0x004F0300, '\u{0000D2}'),
    (0x006F0307, '\u{00022F}'),
    (0x00470301, '\u{0001F4}'),
    (0x00610309, '\u{001EA3}'),
    (0x1F080301, '\u{001F0C}'),
    (0x03B90301, '\u{0003AF}'),
    (0x04330301, '\u{000453}'),
    (0x1F200345, '\u{001F90}'),
    (0x00620307, '\u{001E03}'),
    (0x1F030345, '\u{001F83}'),
    (0x00570308, '\u{001E84}'),
    (0x005A0307, '\u{00017B}'),
    (0x30C13099, '\u{0030C2}'),
    (0x01A10309, '\u{001EDF}'),
    (0x06270655, '\u{000625}'),
    (0x03BF0314, '\u{001F41}'),
    (0x00670301, '\u{0001F5}'),
    (0x039F0301, '\u{00038C}'),
    (0x00EA0301, '\u{001EBF}'),
    (0x0063030C, '\u{00010D}'),
    (0x1F000345, '\u{001F80}'),
    (0x04130301, '\u{000403}'),
    (0x004B0323, '\u{001E32}'),
    (0x00790301, '\u{0000FD}'),
    (0x00770301, '\u{001E83}'),
    (0x1F0E0345, '\u{001F8E}'),
    (0x00480308, '\u{001E26}'),
    (0x30A63099, '\u{0030F4}'),
    (0x01020300, '\u{001EB0}'),
    (0x006C0301, '\u{00013A}'),
    (0x00450309, '\u{001EBA}'),
    (0x1F390301, '\u{001F3D}'),
    (0x00690311, '\u{00020B}'),
    (0x04230304, '\u{0004EE}'),
    (0x0061030C, '\u{0001CE}'),
    (0x1F100300, '\u{001F12}'),
    (0x04380300, '\u{00045D}'),
    (0x00480323, '\u{001E24}'),
    (0x1B111B35, '\u{001B12}'),
    (0x00430301, '\u{000106}'),
    (0x00540323, '\u{001E6C}'),
    (0x00490303, '\u{000128}'),
    (0x1EA10302, '\u{001EAD}'),
    (0x04350308, '\u{000451}'),
    (0x00610307, '\u{000227}'),
    (0x1F000300, '\u{001F02}'),
    (0x006D0307, '\u{001E41}'),
    (0x00760303, '\u{001E7D}'),
    (0x00730327, '\u{00015F}'),
    (0x00470304, '\u{001E20}'),
    (0x00470306, '\u{00011E}'),
    (0x1F6D0345, '\u{001FAD}'),
    (0x006F0303, '\u{0000F5}'),
    (0x006B0331, '\u{001E35}'),
    (0x00720331, '\u{001E5F}'),
    (0x01B00300, '\u{001EEB}'),
    (0x1B0B1B35, '\u{001B0C}'),
    (0x0055032D, '\u{001E76}'),
    (0x0061030A, '\u{0000E5}'),
    (0x30463099, '\u{003094}'),
    (0x1B3A1B35, '\u{001B3B}'),
    (0x0055030A, '\u{00016E}'),
    (0x0928093C, '\u{000929}'),
    (0x03C90313, '\u{001F60}'),
    (0x00650330, '\u{001E1B}'),
    (0x00590303, '\u{001EF8}'),
    (0x00450330, '\u{001E1A}'),
    (0x00640331, '\u{001E0F}'),
    (0x03B90308, '\u{0003CA}'),
    (0x309D3099, '\u{00309E}'),
    (0x0443030B, '\u{0004F3}'),
    (0x0B470B3E, '\u{000B4B}'),
    (0x006F030F, '\u{00020D}'),
    (0x006E0323, '\u{001E47}'),
    (0x00690308, '\u{0000EF}'),
    (0x0065032D, '\u{001E19}'),
    (0x015A0307, '\u{001E64}'),
    (0x1F180301, '\u{001F1C}'),
    (0x1F090301, '\u{001F0D}'),
    (0x1F270345, '\u{001F97}'),
    (0x007A0302, '\u{001E91}'),
    (0x00590301, '\u{0000DD}'),
    (0x004C0331, '\u{001E3A}'),
    (0x1F640345, '\u{001FA4}'),
    (0x1EB90302, '\u{001EC7}'),
    (0x1F240345, '\u{001F94}'),
    (0x01130300, '\u{001E15}'),
    (0x0069030F, '\u{000209}'),
    (0x00740331, '\u{001E6F}'),
    (0x1F480301, '\u{001F4C}'),
    (0x007A0331, '\u{001E95}'),
    (0x1F290345, '\u{001F99}'),
    (0x00D40301, '\u{001ED0}'),
    (0x00C40304, '\u{0001DE}'),
    (0x03970301, '\u{000389}'),
    (0x0072030C, '\u{000159}'),
    (0x1F110301, '\u{001F15}'),
    (0x00F40309, '\u{001ED5}'),
    (0x00450327, '\u{000228}'),
    (0x006F031B, '\u{0001A1}'),
    (0x00C60304, '\u{0001E2}'),
    (0x03990308, '\u{0003AA}'),
    (0x03CE0345, '\u{001FF4}'),
    (0x006D0301, '\u{001E3F}'),
    (0x01030309, '\u{001EB3}'),
    (0x006F0302, '\u{0000F4}'),
    (0x0073030C, '\u{000161}'),
    (0x00750301, '\u{0000FA}'),
    (0x1F690301, '\u{001F6D}'),
    (0x03A90301, '\u{00038F}'),
    (0x003D0338, '\u{002260}'),
    (0x1FC60345, '\u{001FC7}'),
    (0x00770300, '\u{001E81}'),
    (0x02280306, '\u{001E1C}'),
    (0x006C0331, '\u{001E3B}'),
    (0x30AD3099, '\u{0030AE}'),
    (0x1EB80302, '\u{001EC6}'),
    (0x00550302, '\u{0000DB}'),
    (0x0DD90DCF, '\u{000DDC}'),
    (0x03A50304, '\u{001FE9}'),
    (0x03A90314, '\u{001F69}'),
    (0x00740327, '\u{000163}'),
    (0x00530326, '\u{000218}'),
    (0x0055030B, '\u{000170}'),
    (0x306F309A, '\u{003071}'),
    (0x006B0327, '\u{000137}'),
    (0x00750330, '\u{001E75}'),
    (0x00730301, '\u{00015B}'),
    (0x1F300342, '\u{001F36}'),
    (0x00470307, '\u{000120}'),
    (0x0CC60CD5, '\u{000CC7}'),
    (0x1F690300, '\u{001F6B}'),
    (0x01030301, '\u{001EAF}'),
    (0x00750311, '\u{000217}'),
    (0x0930093C, '\u{000931}'),
    (0x30613099, '\u{003062}'),
    (0x00770323, '\u{001E89}'),
    (0x00F50301, '\u{001E4D}'),
    (0x00FC0300, '\u{0001DC}'),
    (0x0049030F, '\u{000208}'),
    (0x00690302, '\u{0000EE}'),
    (0x1F230345, '\u{001F93}'),
    (0x00F40300, '\u{001ED3}'),
    (0x044B0308, '\u{0004F9}'),
    (0x1F2E0345, '\u{001F9E}'),
    (0x00650300, '\u{0000E8}'),
    (0x00490308, '\u{0000CF}'),
    (0x1F280301, '\u{001F2C}'),
    (0x1F180300, '\u{001F1A}'),
    (0x06270653, '\u{000622}'),
    (0x1F200301, '\u{001F24}'),
    (0x22030338, '\u{002204}'),
    (0x00790304, '\u{000233}'),
    (0x1F390300, '\u{001F3B}'),
    (0x00610325, '\u{001E01}'),
    (0x00790309, '\u{001EF7}'),
    (0x01AF0303, '\u{001EEE}'),
    (0x006F0301, '\u{0000F3}'),
    (0x00640323, '\u{001E0D}'),
    (0x304F3099, '\u{003050}'),
    (0x1F010345, '\u{001F81}'),
    (0x00CA0309, '\u{001EC2}'),
    (0x03D20308, '\u{0003D4}'),
    (0x1F500301, '\u{001F54}'),
    (0x1F010300, '\u{001F03}'),
    (0x03A90345, '\u{001FFC}'),
    (0x04270308, '\u{0004F4}'),
    (0x00530302, '\u{00015C}'),
    (0x00520301, '\u{000154}'),
    (0x00450306, '\u{000114}'),
    (0x00530323, '\u{001E62}'),
    (0x00670306, '\u{00011F}'),
    (0x22760338, '\u{002278}'),
    (0x04350300, '\u{000450}'),
    (0x30B53099, '\u{0030B6}'),
    (0x006F030B, '\u{000151}'),
    (0x04180304, '\u{0004E2}'),
    (0x00630307, '\u{00010B}'),
    (0x03D20301, '\u{0003D3}'),
    (0x227C0338, '\u{0022E0}'),
    (0x00610304, '\u{000101}'),
    (0x00A80300, '\u{001FED}'),
    (0x00440331, '\u{001E0E}'),
    (0x00650311, '\u{000207}'),
    (0x00F80301, '\u{0001FF}'),
    (0x0075030C, '\u{0001D4}'),
    (0x00530327, '\u{00015E}'),
    (0x30573099, '\u{003058}'),
    (0x03B70345, '\u{001FC3}'),
    (0x0069030C, '\u{0001D0}'),
    (0x006E0327, '\u{000146}'),
    (0x00780307, '\u{001E8B}'),
    (0x1F000342, '\u{001F06}'),
    (0x01B00303, '\u{001EEF}'),
    (0x00470327, '\u{000122}'),
    (0x00C20309, '\u{001EA8}'),
    (0x006C032D, '\u{001E3D}'),
    (0x304D3099, '\u{00304E}'),
    (0x00690303, '\u{000129}'),
    (0x01AF0323, '\u{001EF0}'),
    (0x004F0302, '\u{0000D4}'),
    (0x01020301, '\u{001EAE}'),
    (0x04470308, '\u{0004F5}'),
    (0x22A80338, '\u{0022AD}'),
    (0x03C50300, '\u{001F7A}'),
    (0x03910313, '\u{001F08}'),
    (0x0064032D, '\u{001E13}'),
    (0x00CF0301, '\u{001E2E}'),
    (0x0061030F, '\u{000201}'),
    (0x1EA10306, '\u{001EB7}'),
    (0x00790323, '\u{001EF5}'),
    (0x21900338, '\u{00219A}'),
    (0x1F250345, '\u{001F95}'),
    (0x004F0304, '\u{00014C}'),
    (0x004F0306, '\u{00014E}'),
    (0x30B33099, '\u{0030B4}'),
    (0x00440327, '\u{001E10}'),
    (0x0B920BD7, '\u{000B94}'),
    (0x00550308, '\u{0000DC}'),
    (0x00650323, '\u{001EB9}'),
    (0x307B3099, '\u{00307C}'),
    (0x004F030C, '\u{0001D1}'),
    (0x00670304, '\u{001E21}'),
    (0x006A030C, '\u{0001F0}'),
    (0x00550323, '\u{001EE4}'),
    (0x01A10301, '\u{001EDB}'),
    (0x00590323, '\u{001EF4}'),
    (0x00410300, '\u{0000C0}'),
    (0x30B93099, '\u{0030BA}'),
    (0x04230308, '\u{0004F0}'),
    (0x00530301, '\u{00015A}'),
    (0x30D8309A, '\u{0030DA}'),
    (0x00750309, '\u{001EE7}'),
    (0x00550330, '\u{001E74}'),
    (0x00520327, '\u{000156}'),
    (0x04370308, '\u{0004DF}'),
    (0x00CA0300, '\u{001EC0}'),
    (0x21940338, '\u{0021AE}'),
    (0x03B10306, '\u{001FB0}'),
    (0x1F610342, '\u{001F67}'),
    (0x223C0338, '\u{002241}'),
    (0x30D23099, '\u{0030D3}'),
    (0x1F6B0345, '\u{001FAB}'),
    (0x00490307, '\u{000130}'),
    (0x00410323, '\u{001EA0}'),
    (0x00550309, '\u{001EE6}'),
    (0x0075030B, '\u{000171}'),
    (0x30533099, '\u{003054}'),
    (0x305D3099, '\u{00305E}'),
    (0x004C0323, '\u{001E36}'),
    (0x02260304, '\u{0001E0}'),
    (0x0475030F, '\u{000477}'),
    (0x00490328, '\u{00012E}'),
    (0x1F210300, '\u{001F23}'),
    (0x1F610301, '\u{001F65}'),
    (0x1F210342, '\u{001F27}'),
    (0x00670302, '\u{00011D}'),
    (0x004E0301, '\u{000143}'),
    (0x004E0303, '\u{0000D1}'),
    (0x03990300, '\u{001FDA}'),
    (0x03BF0301, '\u{0003CC}'),
    (0x04150300, '\u{000400}'),
    (0x03C90314, '\u{001F61}'),
    (0x22A20338, '\u{0022AC}'),
    (0x30DB3099, '\u{0030DC}'),
    (0x03A50314, '\u{001F59}'),
    (0x0052030F, '\u{000210}'),
    (0x004E0323, '\u{001E46}'),
    (0x1F0D0345, '\u{001F8D}'),
    (0x1ECD0302, '\u{001ED9}'),
    (0x00FC030C, '\u{0001DA}'),
    (0x00D60304, '\u{00022A}'),
    (0x1F000301, '\u{001F04}'),
    (0x30CF3099, '\u{0030D0}'),
    (0x04350306, '\u{0004D7}'),
    (0x220B0338, '\u{00220C}'),
    (0x00590300, '\u{001EF2}'),
    (0x04170308, '\u{0004DE}'),
    (0x006E030C, '\u{000148}'),
    (0x004C030C, '\u{00013D}'),
    (0x01690301, '\u{001E79}'),
    (0x04100308, '\u{0004D2}'),
    (0x01A00301, '\u{001EDA}'),
    (0x0041030F, '\u{000200}'),
    (0x00720301, '\u{000155}'),
    (0x00450303, '\u{001EBC}'),
    (0x1B0D1B35, '\u{001B0E}'),
    (0x01120301, '\u{001E16}'),
    (0x004A0302, '\u{000134}'),
    (0x03BF0300, '\u{001F78}'),
    (0x30593099, '\u{00305A}'),
    (0x004F030B, '\u{000150}'),
    (0x00610328, '\u{000105}'),
    (0x30D83099, '\u{0030D9}'),
    (0x1F2B0345, '\u{001F9B}'),
    (0x1F400301, '\u{001F44}'),
    (0x0065030F, '\u{000205}'),
    (0x03AE0345, '\u{001FC4}'),
    (0x01680301, '\u{001E78}'),
    (0x00740326, '\u{00021B}'),
    (0x03B90342, '\u{001FD6}'),
    (0x1F6F0345, '\u{001FAF}'),
    (0x03A50301, '\u{00038E}'),
    (0x1F090345, '\u{001F89}'),
    (0x00550300, '\u{0000D9}'),
    (0x0041030C, '\u{0001CD}'),
    (0x00430327, '\u{0000C7}'),
    (0x00460307, '\u{001E1E}'),
    (0x03B50301, '\u{0003AD}'),
    (0x0D470D3E, '\u{000D4B}'),
    (0x00610311, '\u{000203}'),
    (0x00D50308, '\u{001E4E}'),
    (0x03C90300, '\u{001F7C}'),
    (0x04430306, '\u{00045E}'),
    (0x1FFE0301, '\u{001FDE}'),
    (0x03990301, '\u{00038A}'),
    (0x00790307, '\u{001E8F}'),
    (0x1E5A0304, '\u{001E5C}'),
    (0x0075030F, '\u{000215}'),
    (0x09C709BE, '\u{0009CB}'),
    (0x1B071B35, '\u{001B08}'),
    (0x00690330, '\u{001E2D}'),
    (0x307B309A, '\u{00307D}'),
    (0x30C83099, '\u{0030C9}'),
    (0x22B30338, '\u{0022EB}'),
    (0x01B00301, '\u{001EE9}'),
    (0x00790300, '\u{001EF3}'),
    (0x00570307, '\u{001E86}'),
    (0x00690328, '\u{00012F}'),
    (0x005A0323, '\u{001E92}'),
    (0x03C50342, '\u{001FE6}'),
    (0x004F0309, '\u{001ECE}'),
    (0x1F290342, '\u{001F2F}'),
    (0x01A00300, '\u{001EDC}'),
    (0x1F2A0345, '\u{001F9A}'),
    (0x014D0301, '\u{001E53}'),
    (0x21D00338, '\u{0021CD}'),
    (0x00550328, '\u{000172}'),
    (0x00680331, '\u{001E96}'),
    (0x0068030C, '\u{00021F}'),
    (0x004C0301, '\u{000139}'),
    (0x22860338, '\u{002288}'),
    (0x039F0314, '\u{001F49}'),
    (0x03A50306, '\u{001FE8}'),
    (0x0B470B56, '\u{000B48}'),
    (0x30753099, '\u{003076}'),
    (0x1E5B0304, '\u{001E5D}'),
    (0x1F6A0345, '\u{001FAA}'),
    (0x00540327, '\u{000162}'),
    (0x01020303, '\u{001EB4}'),
    (0x039F0313, '\u{001F48}'),
    (0x1F090342, '\u{001F0F}'),
    (0x04100306, '\u{0004D0}'),
    (0x014D0300, '\u{001E51}'),
    (0x04430304, '\u{0004EF}'),
    (0x21920338, '\u{00219B}'),
    (0x22610338, '\u{002262}'),
    (0x00F50304, '\u{00022D}'),
    (0x03B90313, '\u{001F30}'),
    (0x006F0308, '\u{0000F6}'),
    (0x00730307, '\u{001E61}'),
    (0x0075031B, '\u{0001B0}'),
    (0x30B73099, '\u{0030B8}'),
    (0x1E620307, '\u{001E68}'),
    (0x00410306, '\u{000102}'),
    (0x03970314, '\u{001F29}'),
    (0x00630302, '\u{000109}'),
    (0x006A0302, '\u{000135}'),
    (0x00E50301, '\u{0001FB}'),
    (0x00730326, '\u{000219}'),
    (0x1F740345, '\u{001FC2}'),
    (0x00650309, '\u{001EBB}'),
    (0x005A030C, '\u{00017D}'),
    (0x22250338, '\u{002226}'),
    (0x03A90313, '\u{001F68}'),
    (0x00720327, '\u{000157}'),
    (0x1F090300, '\u{001F0B}'),
    (0x04360308, '\u{0004DD}'),
    (0x1F080345, '\u{001F88}'),
    (0x00620331, '\u{001E07}'),
    (0x22730338, '\u{002275}'),
    (0x00560323, '\u{001E7E}'),
    (0x004F0323, '\u{001ECC}'),
    (0x022E0304, '\u{000230}'),
    (0x06D50654, '\u{0006C0}'),
    (0x03B10313, '\u{001F00}'),
    (0x004F0303, '\u{0000D5}'),
    (0x1F010301, '\u{001F05}'),
    (0x00650304, '\u{000113}'),
    (0x00450323, '\u{001EB8}'),
    (0x0BC60BBE, '\u{000BCA}'),
    (0x22650338, '\u{002271}'),
    (0x03910314, '\u{001F09}'),
    (0x01120300, '\u{001E14}'),
    (0x004E0307, '\u{001E44}'),
    (0x00680308, '\u{001E27}'),
    (0x004F0311, '\u{00020E}'),
    (0x00550303, '\u{000168}'),
    (0x03A10314, '\u{001FEC}'),
    (0x03B10301, '\u{0003AC}'),
    (0x0055030F, '\u{000214}'),
    (0x003E0338, '\u{00226F}'),
    (0x01610307, '\u{001E67}'),
    (0x1F040345, '\u{001F84}'),
    (0x00450300, '\u{0000C8}'),
    (0x1B091B35, '\u{001B0A}'),
    (0x30FD3099, '\u{0030FE}'),
    (0x1F680301, '\u{001F6C}'),
    (0x00650303, '\u{001EBD}'),
    (0x03B90304, '\u{001FD1}'),
    (0x09C709D7, '\u{0009CC}'),
    (0x042B0308, '\u{0004F8}'),
    (0x004E0327, '\u{000145}'),
    (0x1F630345, '\u{001FA3}'),
    (0x04380306, '\u{000439}'),
    (0x03B10314, '\u{001F01}'),
    (0x00540326, '\u{00021A}'),
    (0x00740307, '\u{001E6B}'),
    (0x03C90301, '\u{0003CE}'),
    (0x03990314, '\u{001F39}'),
    (0x30B13099, '\u{0030B2}'),
    (0x00750302, '\u{0000FB}'),
    (0x0CC60CD6, '\u{000CC8}'),
    (0x30BD3099, '\u{0030BE}'),
    (0x006E0300, '\u{0001F9}'),
    (0x1F390342, '\u{001F3F}'),
    (0x02270304, '\u{0001E1}'),
    (0x22080338, '\u{002209}'),
    (0x04180306, '\u{000419}'),
    (0x0044030C, '\u{00010E}'),
    (0x0075030A, '\u{00016F}'),
    (0x06270654, '\u{000623}'),
    (0x00750306, '\u{00016D}'),
    (0x03B70300, '\u{001F74}'),
    (0x1F660345, '\u{001FA6}'),
    (0x1F690345, '\u{001FA9}'),
    (0x015B0307, '\u{001E65}'),
    (0x1F280342, '\u{001F2E}'),
    (0x1F700345, '\u{001FB2}'),
    (0x1F0F0345, '\u{001F8F}'),
    (0x00540331, '\u{001E6E}'),
    (0x227B0338, '\u{002281}'),
    (0x22870338, '\u{002289}'),
    (0x1F010342, '\u{001F07}'),
    (0x03A50308, '\u{0003AB}'),
    (0x1F650345, '\u{001FA5}'),
    (0x00D40300, '\u{001ED2}'),
    (0x00F60304, '\u{00022B}'),
    (0x0CBF0CD5, '\u{000CC0}'),
    (0x1F380342, '\u{001F3E}'),
    (0x22B20338, '\u{0022EA}'),
    (0x0072030F, '\u{000211}'),
    (0x30BF3099, '\u{0030C0}'),
    (0x04E90308, '\u{0004EB}'),
    (0x22830338, '\u{002285}'),
    (0x03CB0300, '\u{001FE2}'),
    (0x00CA0301, '\u{001EBE}'),
    (0x00590304, '\u{000232}'),
    (0x00690301, '\u{0000ED}'),
    (0x305F3099, '\u{003060}'),
    (0x00440307, '\u{001E0A}'),
    (0x1ECC0302, '\u{001ED8}'),
    (0x1F210345, '\u{001F91}'),
    (0x00410311, '\u{000202}'),
    (0x00720311, '\u{000213}'),
    (0x03A50300, '\u{001FEA}'),
    (0x1F590300, '\u{001F5B}'),
    (0x00E40304, '\u{0001DF}'),
    (0x1F500300, '\u{001F52}'),
    (0x224D0338, '\u{00226D}'),
    (0x006E0301, '\u{000144}'),
    (0x0075032D, '\u{001E77}'),
    (0x00F40301, '\u{001ED1}'),
    (0x03C90342, '\u{001FF6}'),
    (0x03B70301, '\u{0003AE}'),
    (0x006E0307, '\u{001E45}'),
    (0x00410304, '\u{000100}'),
    (0x1F190301, '\u{001F1D}'),
    (0x03B10304, '\u{001FB1}'),
    (0x3078309A, '\u{00307A}'),
    (0x00570323, '\u{001E88}'),
    (0x04430308, '\u{0004F1}'),
    (0x0045032D, '\u{001E18}'),
    (0x04150308, '\u{000401}'),
    (0x004F0328, '\u{0001EA}'),
    (0x04D90308, '\u{0004DB}'),
    (0x04060308, '\u{000407}'),
    (0x00F40303, '\u{001ED7}'),
    (0x03B90306, '\u{001FD0}'),
    (0x00650307, '\u{000117}'),
    (0x1F680342, '\u{001F6E}'),
    (0x04380304, '\u{0004E3}'),
    (0x1F410300, '\u{001F43}'),
    (0x1FFE0300, '\u{001FDD}'),
    (0x004F0301, '\u{0000D3}'),
    (0x00640327, '\u{001E11}'),
    (0x02290306, '\u{001E1D}'),
    (0x007A0301, '\u{00017A}'),
    (0x00620323, '\u{001E05}'),
    (0x1F7C0345, '\u{001FF2}'),
    (0x01B00323, '\u{001EF1}'),
    (0x1F600301, '\u{001F64}'),
    (0x30663099, '\u{003067}'),
    (0x22640338, '\u{002270}'),
    (0x1F310300, '\u{001F33}'),
    (0x00610323, '\u{001EA1}'),
    (0x1F480300, '\u{001F4A}'),
    (0x00550301, '\u{0000DA}'),
    (0x0C460C56, '\u{000C48}'),
    (0x03CA0300, '\u{001FD2}'),
    (0x01B7030C, '\u{0001EE}'),
    (0x00720323, '\u{001E5B}'),
    (0x1F200342, '\u{001F26}'),
    (0x04300308, '\u{0004D3}'),
    (0x22820338, '\u{002284}'),
    (0x1F590301, '\u{001F5D}'),
    (0x1F080342, '\u{001F0E}'),
    (0x00440323, '\u{001E0C}'),
    (0x1025102E, '\u{001026}'),
    (0x03910304, '\u{001FB9}'),
    (0x004B0331, '\u{001E34}'),
    (0x00690300, '\u{0000EC}'),
    (0x0048032E, '\u{001E2A}'),
    (0x00630301, '\u{000107}'),
    (0x1F690342, '\u{001F6F}'),
    (0x03B50313, '\u{001F10}'),
    (0x30CF309A, '\u{0030D1}'),
    (0x004E030C, '\u{000147}'),
    (0x0B470B57, '\u{000B4C}'),
    (0x03910301, '\u{000386}'),
    (0x00650328, '\u{000119}'),
    (0x1FBF0300, '\u{001FCD}'),
    (0x03B70342, '\u{001FC6}'),
    (0x00450307, '\u{000116}'),
    (0x1F380301, '\u{001F3C}'),
    (0x3075309A, '\u{003077}'),
    (0x004B0301, '\u{001E30}'),
    (0x01030300, '\u{001EB1}'),
    (0x00E20303, '\u{001EAB}'),
    (0x00410302, '\u{0000C2}'),
    (0x00650308, '\u{0000EB}'),
    (0x00580307, '\u{001E8A}'),
    (0x0054030C, '\u{000164}'),
    (0x03C50313, '\u{001F50}'),
    (0x03B50314, '\u{001F11}'),
    (0x1B3E1B35, '\u{001B40}'),
    (0x1F100301, '\u{001F14}'),
    (0x3072309A, '\u{003074}'),
    (0x1F280345, '\u{001F98}'),
    (0x22770338, '\u{002279}'),
    (0x227A0338, '\u{002280}'),
    (0x00470302, '\u{00011C}'),
    (0x00450308, '\u{0000CB}'),
    (0x00550324, '\u{001E72}'),
    (0x1F2C0345, '\u{001F9C}'),
    (0x004B0327, '\u{000136}'),
    (0x00490302, '\u{0000CE}'),
    (0x00680302, '\u{000125}'),
    (0x00520307, '\u{001E58}'),
    (0x00610301, '\u{0000E1}'),
    (0x004B030C, '\u{0001E8}'),
    (0x00490309, '\u{001EC8}'),
    (0x006C030C, '\u{00013E}'),
    (0x004D0307, '\u{001E40}'),
    (0x1E360304, '\u{001E38}'),
    (0x03C50304, '\u{001FE1}'),
    (0x0079030A, '\u{001E99}'),
    (0x03970313, '\u{001F28}'),
    (0x0054032D, '\u{001E70}'),
    (0x1F490300, '\u{001F4B}'),
    (0x1B421B35, '\u{001B43}'),
    (0x03B70313, '\u{001F20}'),
    (0x00EF0301, '\u{001E2F}'),
    (0x00E70301, '\u{001E09}'),
    (0x016A0308, '\u{001E7A}'),
    (0x00CA0303, '\u{001EC4}'),
    (0x03B10300, '\u{001F70}'),
    (0x06D20654, '\u{0006D3}'),
    (0x30D53099, '\u{0030D6}'),
    (0x1F2F0345, '\u{001F9F}'),
    (0x03B50300, '\u{001F72}'),
    (0x00750324, '\u{001E73}'),
    (0x04150306, '\u{0004D6}'),
    (0x0065030C, '\u{00011B}'),
    (0x00570302, '\u{000174}'),
    (0x1EA00306, '\u{001EB6}'),
    (0x1F070345, '\u{001F87}'),
    (0x00A80301, '\u{000385}'),
    (0x00790302, '\u{000177}'),
    (0x006E032D, '\u{001E4B}'),
    (0x006F030C, '\u{0001D2}'),
    (0x03C90345, '\u{001FF3}'),
    (0x00430302, '\u{000108}'),
    (0x00790303, '\u{001EF9}'),
    (0x00740323, '\u{001E6D}'),
    (0x00E20309, '\u{001EA9}'),
    (0x1F300300, '\u{001F32}'),
    (0x006B0301, '\u{001E31}'),
    (0x22920338, '\u{0022E3}'),
    (0x03950314, '\u{001F19}'),
    (0x1F290301, '\u{001F2D}'),
    (0x00450328, '\u{000118}'),
    (0x1FB60345, '\u{001FB7}'),
    (0x00D50304, '\u{00022C}'),
    (0x04300306, '\u{0004D1}'),
    (0x00F50308, '\u{001E4F}'),
    (0x1EA00302, '\u{001EAC}'),
    (0x1F680300, '\u{001F6A}'),
    (0x03970300, '\u{001FCA}'),
    (0x00450301, '\u{0000C9}'),
    (0x00690304, '\u{00012B}'),
    (0x0BC60BD7, '\u{000BCC}'),
    (0x006F0304, '\u{00014D}'),
    (0x004F0308, '\u{0000D6}'),
    (0x0BC70BBE, '\u{000BCB}'),
    (0x0055030C, '\u{0001D3}'),
    (0x03AC0345, '\u{001FB4}'),
    (0x1FBF0342, '\u{001FCF}'),
    (0x30D2309A, '\u{0030D4}'),
    (0x00660307, '\u{001E1F}'),
    (0x004E0300, '\u{0001F8}'),
    (0x00790308, '\u{0000FF}'),
    (0x0068032E, '\u{001E2B}'),
    (0x0064030C, '\u{00010F}'),
    (0x004F0307, '\u{00022E}'),
    (0x1F590342, '\u{001F5F}'),
    (0x30AF3099, '\u{0030B0}'),
    (0x00E60304, '\u{0001E3}'),
    (0x03C50301, '\u{0003CD}'),
    (0x00770308, '\u{001E85}'),
    (0x03B90314, '\u{001F31}'),
    (0x00750323, '\u{001EE5}'),
    (0x00590309, '\u{001EF6}'),
    (0x0292030C, '\u{0001EF}'),
    (0x00550306, '\u{00016C}'),
    (0x00E60301, '\u{0001FD}'),
    (0x016B0308, '\u{001E7B}'),
    (0x004F030F, '\u{00020C}'),
    (0x03BF0313, '\u{001F40}'),
    (0x00D80301, '\u{0001FE}'),
    (0x00C20303, '\u{001EAA}'),
    (0x1F510300, '\u{001F53}'),
    (0x01B00309, '\u{001EED}'),
    (0x004E032D, '\u{001E4A}'),
    (0x006F0309, '\u{001ECF}'),
    (0x04180300, '\u{00040D}'),
    (0x22A90338, '\u{0022AE}'),
    (0x1F680345, '\u{001FA8}'),
    (0x1B3C1B35, '\u{001B3D}'),
    (0x1F400300, '\u{001F42}'),
    (0x1F0B0345, '\u{001F8B}'),
    (0x03C50306, '\u{001FE0}'),
    (0x0044032D, '\u{001E12}'),
    (0x0CCA0CD5, '\u{000CCB}'),
    (0x00EA0303, '\u{001EC5}'),
    (0x04230306, '\u{00040E}'),
    (0x00C70301, '\u{001E08}'),
    (0x007A030C, '\u{00017E}'),
    (0x00670307, '\u{000121}'),
    (0x00450311, '\u{000206}'),
    (0x006F0300, '\u{0000F2}'),
    (0x30BB3099, '\u{0030BC}'),
    (0x04180308, '\u{0004E4}'),
    (0x30513099, '\u{003052}'),
    (0x006C0323, '\u{001E37}'),
    (0x03B70314, '\u{001F21}'),
    (0x0077030A, '\u{001E98}'),
    (0x00690323, '\u{001ECB}'),
    (0x00610303, '\u{0000E3}'),
    (0x30F13099, '\u{0030F9}'),
    (0x03B10345, '\u{001FB3}'),
    (0x0D460D3E, '\u{000D4A}'),
    (0x03B90300, '\u{001F76}'),
    (0x21D40338, '\u{0021CE}'),
    (0x1F620345, '\u{001FA2}'),
    (0x00770302, '\u{000175}'),
    (0x00FC0304, '\u{0001D6}'),
    (0x01130301, '\u{001E17}'),
    (0x30683099, '\u{003069}'),
    (0x1F600342, '\u{001F66}'),
    (0x00680323, '\u{001E25}'),
    (0x03950313, '\u{001F18}'),
    (0x00EA0300, '\u{001EC1}'),
    (0x03CB0342, '\u{001FE7}'),
    (0x22430338, '\u{002244}'),
    (0x30783099, '\u{003079}'),
    (0x03990313, '\u{001F38}'),
    (0x00490330, '\u{001E2C}'),
    (0x00770307, '\u{001E87}'),
    (0x00650301, '\u{0000E9}'),
    (0x00680327, '\u{001E29}'),
    (0x22B50338, '\u{0022ED}'),
    (0x03B10342, '\u{001FB6}'),
    (0x03910306, '\u{001FB8}'),
    (0x004D0301, '\u{001E3E}'),
    (0x00410309, '\u{001EA2}'),
    (0x1B051B35, '\u{001B06}'),
    (0x003C0338, '\u{00226E}'),
    (0x00590308, '\u{000178}'),
    (0x01030303, '\u{001EB5}'),
    (0x00480327, '\u{001E28}'),
    (0x006D0323, '\u{001E43}'),
    (0x30643099, '\u{003065}'),
    (0x04560308, '\u{000457}'),
    (0x00590302, '\u{000176}'),
    (0x06C10654, '\u{0006C2}'),
    (0x043A0301, '\u{00045C}'),
    (0x00E20300, '\u{001EA7}'),
    (0x03950301, '\u{000388}'),
    (0x00630327, '\u{0000E7}'),
    (0x017F0307, '\u{001E9B}'),
    (0x06480654, '\u{000624}'),
    (0x30AB3099, '\u{0030AC}'),
    (0x01A00323, '\u{001EE2}'),
    (0x04D80308, '\u{0004DA}'),
    (0x005A0331, '\u{001E94}'),
    (0x0067030C, '\u{0001E7}'),
    (0x039F0300, '\u{001FF8}'),
    (0x00650327, '\u{000229}'),
    (0x00490323, '\u{001ECA}'),
    (0x1F110300, '\u{001F13}'),
    (0x1F510342, '\u{001F57}'),
    (0x004D0323, '\u{001E42}'),
    (0x1F300301, '\u{001F34}'),
    (0x006C0327, '\u{00013C}'),
    (0x1F050345, '\u{001F85}'),
    (0x01A10300, '\u{001EDD}'),
    (0x04160308, '\u{0004DC}'),
    (0x00640307, '\u{001E0B}'),
    (0x004C032D, '\u{001E3C}'),
    (0x03C10314, '\u{001FE5}'),
    (0x01EA0304, '\u{0001EC}'),
    (0x1F080300, '\u{001F0A}'),
    (0x00650302, '\u{0000EA}'),
    (0x03910300, '\u{001FBA}'),
    (0x00700301, '\u{001E55}'),
    (0x1F020345, '\u{001F82}'),
    (0x01020309, '\u{001EB2}'),
    (0x00750303, '\u{000169}'),
    (0x1F0C0345, '\u{001F8C}'),
    (0x03CB0301, '\u{0003B0}'),
    (0x00740308, '\u{001E97}'),
    (0x03950300, '\u{001FC8}'),
    (0x227D0338, '\u{0022E1}'),
    (0x007A0323, '\u{001E93}'),
    (0x006F0311, '\u{00020F}'),
    (0x006F0328, '\u{0001EB}'),
    (0x1F200300, '\u{001F22}'),
    (0x1F190300, '\u{001F1B}'),
    (0x00560303, '\u{001E7C}'),
    (0x006B030C, '\u{0001E9}'),
    (0x04E80308, '\u{0004EA}'),
    (0x03A90300, '\u{001FFA}'),
    (0x00A80342, '\u{001FC1}'),
    (0x04360306, '\u{0004C2}'),
    (0x00DC0301, '\u{0001D7}'),
    (0x00750304, '\u{00016B}'),
    (0x22450338, '\u{002247}'),
    (0x00490304, '\u{00012A}'),
    (0x04380308, '\u{0004E5}'),
    (0x0D460D57, '\u{000D4C}'),
    (0x00750300, '\u{0000F9}'),
    (0x22B40338, '\u{0022EC}'),
    (0x00750308, '\u{0000FC}'),
    (0x03C50314, '\u{001F51}'),
    (0x01600307, '\u{001E66}'),
    (0x04160306, '\u{0004C1}'),
    (0x0055031B, '\u{0001AF}'),
    (0x22AB0338, '\u{0022AF}'),
    (0x014C0300, '\u{001E50}'),
    (0x1F310342, '\u{001F37}'),
    (0x1F260345, '\u{001F96}'),
    (0x22910338, '\u{0022E2}'),
    (0x00500301, '\u{001E54}'),
    (0x004C0327, '\u{00013B}'),
    (0x005A0301, '\u{000179}'),
    (0x00420307, '\u{001E02}'),
    (0x03C10313, '\u{001FE4}'),
    (0x1F410301, '\u{001F45}'),
    (0x00500307, '\u{001E56}'),
    (0x0043030C, '\u{00010C}'),
    (0x00730323, '\u{001E63}'),
    (0x30553099, '\u{003056}'),
    (0x306F3099, '\u{003070}'),
    (0x044D0308, '\u{0004ED}'),
    (0x1F670345, '\u{001FA7}'),
    (0x01AF0301, '\u{001EE8}'),
    (0x1F290300, '\u{001F2B}'),
    (0x1B3F1B35, '\u{001B41}'),
    (0x00450302, '\u{0000CA}'),
    (0x006F0306, '\u{00014F}'),
    (0x00FC0301, '\u{0001D8}'),
    (0x30F23099, '\u{0030FA}'),
    (0x1F2D0345, '\u{001F9D}'),
    (0x014C0301, '\u{001E52}'),
    (0x00610308, '\u{0000E4}'),
    (0x1F600345, '\u{001FA0}'),
    (0x1F0A0345, '\u{001F8A}'),
    (0x00610306, '\u{000103}'),
    (0x1F600300, '\u{001F62}'),
    (0x01AF0300, '\u{001EEA}'),
    (0x043E0308, '\u{0004E7}'),
    (0x22230338, '\u{002224}'),
    (0x03CA0301, '\u{000390}'),
    (0x30D5309A, '\u{0030D7}'),
    (0x1F220345, '\u{001F92}'),
    (0x00D50301, '\u{001E4C}'),
    (0x1F6C0345, '\u{001FAC}'),
    (0x00540307, '\u{001E6A}'),
    (0x1E370304, '\u{001E39}'),
    (0x0DD90DCA, '\u{000DDA}'),
    (0x01A10303, '\u{001EE1}'),
    (0x0048030C, '\u{00021E}'),
    (0x00EA0309, '\u{001EC3}'),
    (0x0052030C, '\u{000158}'),
    (0x00D40303, '\u{001ED6}'),
    (0x0045030C, '\u{00011A}'),
    (0x30EF3099, '\u{0030F7}'),
    (0x00480302, '\u{000124}'),
    (0x00520323, '\u{001E5A}'),
    (0x00C20300, '\u{001EA6}'),
    (0x0074032D, '\u{001E71}'),
    (0x042D0308, '\u{0004EC}'),
    (0x0DD90DDF, '\u{000DDE}'),
    (0x00410308, '\u{0000C4}'),
    (0x0474030F, '\u{000476}'),
    (0x00C60301, '\u{0001FC}'),
    (0x1F310301, '\u{001F35}'),
    (0x1F610300, '\u{001F63}'),
    (0x0CC60CC2, '\u{000CCA}'),
    (0x00C20301, '\u{001EA4}'),
    (0x03C50308, '\u{0003CB}'),
    (0x00E20301, '\u{001EA5}'),
    (0x1F500342, '\u{001F56}'),
    (0x00610300, '\u{0000E0}'),
    (0x00490311, '\u{00020A}'),
    (0x00670327, '\u{000123}'),
    (0x00590307, '\u{001E8E}'),
    (0x03970345, '\u{001FCC}'),
    (0x00D40309, '\u{001ED4}'),
    (0x01A00303, '\u{001EE0}'),
    (0x1FFE0342, '\u{001FDF}'),
    (0x041A0301, '\u{00040C}'),
    (0x0074030C, '\u{000165}'),
    (0x00DC0300, '\u{0001DB}'),
    (0x00780308, '\u{001E8D}'),
    (0x00DC0304, '\u{0001D5}'),
    (0x00610302, '\u{0000E2}'),
    (0x005A0302, '\u{001E90}'),
    (0x0933093C, '\u{000934}'),
    (0x004F031B, '\u{0001A0}'),
    (0x00520311, '\u{000212}'),
    (0x006E0303, '\u{0000F1}'),
    (0x0045030F, '\u{000204}'),
    (0x01AF0309, '\u{001EEC}'),
    (0x00450304, '\u{000112}'),
    (0x1F210301, '\u{001F25}'),
    (0x022F0304, '\u{000231}'),
    (0x03990306, '\u{001FD8}'),
    (0x004E0331, '\u{001E48}'),
    (0x1F380300, '\u{001F3A}'),
    (0x00490306, '\u{00012C}'),
    (0x00690306, '\u{00012D}'),
    (0x1F060345, '\u{001F86}'),
    (0x00490301, '\u{0000CD}'),
    (0x00570300, '\u{001E80}'),
    (0x30F03099, '\u{0030F8}'),
    (0x0053030C, '\u{000160}'),
    (0x00490300, '\u{0000CC}'),
    (0x30723099, '\u{003073}'),
    (0x1F280300, '\u{001F2A}'),
    (0x00480307, '\u{001E22}'),
    (0x01A00309, '\u{001EDE}'),
    (0x01EB0304, '\u{0001ED}'),
    (0x1E630307, '\u{001E69}'),
    (0x006F0323, '\u{001ECD}'),
    (0x00410303, '\u{0000C3}'),
    (0x03910345, '\u{001FBC}'),
    (0x00410328, '\u{000104}'),
    (0x00680307, '\u{001E23}'),
    (0x006E0331, '\u{001E49}'),
    (0x0DDC0DCA, '\u{000DDD}'),
    (0x00580308, '\u{001E8C}'),
    (0x00410301, '\u{0000C1}'),
    (0x30C43099, '\u{0030C5}'),
    (0x00420323, '\u{001E04}'),
    (0x00730302, '\u{00015D}'),
];
pub(crate) fn composition_table_astral(c1: char, c2: char) -> Option<char> {
    match (c1, c2) {
        ('\u{105D2}', '\u{0307}') => Some('\u{105C9}'),
        ('\u{105DA}', '\u{0307}') => Some('\u{105E4}'),
        ('\u{11099}', '\u{110BA}') => Some('\u{1109A}'),
        ('\u{1109B}', '\u{110BA}') => Some('\u{1109C}'),
        ('\u{110A5}', '\u{110BA}') => Some('\u{110AB}'),
        ('\u{11131}', '\u{11127}') => Some('\u{1112E}'),
        ('\u{11132}', '\u{11127}') => Some('\u{1112F}'),
        ('\u{11347}', '\u{1133E}') => Some('\u{1134B}'),
        ('\u{11347}', '\u{11357}') => Some('\u{1134C}'),
        ('\u{11382}', '\u{113C9}') => Some('\u{11383}'),
        ('\u{11384}', '\u{113BB}') => Some('\u{11385}'),
        ('\u{1138B}', '\u{113C2}') => Some('\u{1138E}'),
        ('\u{11390}', '\u{113C9}') => Some('\u{11391}'),
        ('\u{113C2}', '\u{113B8}') => Some('\u{113C7}'),
        ('\u{113C2}', '\u{113C2}') => Some('\u{113C5}'),
        ('\u{113C2}', '\u{113C9}') => Some('\u{113C8}'),
        ('\u{114B9}', '\u{114B0}') => Some('\u{114BC}'),
        ('\u{114B9}', '\u{114BA}') => Some('\u{114BB}'),
        ('\u{114B9}', '\u{114BD}') => Some('\u{114BE}'),
        ('\u{115B8}', '\u{115AF}') => Some('\u{115BA}'),
        ('\u{115B9}', '\u{115AF}') => Some('\u{115BB}'),
        ('\u{11935}', '\u{11930}') => Some('\u{11938}'),
        ('\u{1611E}', '\u{1611E}') => Some('\u{16121}'),
        ('\u{1611E}', '\u{1611F}') => Some('\u{16123}'),
        ('\u{1611E}', '\u{16120}') => Some('\u{16125}'),
        ('\u{1611E}', '\u{16129}') => Some('\u{16122}'),
        ('\u{16121}', '\u{1611F}') => Some('\u{16126}'),
        ('\u{16121}', '\u{16120}') => Some('\u{16128}'),
        ('\u{16122}', '\u{1611F}') => Some('\u{16127}'),
        ('\u{16129}', '\u{1611F}') => Some('\u{16124}'),
        ('\u{16D63}', '\u{16D67}') => Some('\u{16D69}'),
        ('\u{16D67}', '\u{16D67}') => Some('\u{16D68}'),
        ('\u{16D69}', '\u{16D67}') => Some('\u{16D6A}'),
        _ => None,
    }
}
pub(crate) const CANONICAL_DECOMPOSED_CHARS: &[char] = &[
    '\u{0041}',
    '\u{0300}',
    '\u{0041}',
    '\u{0301}',
    '\u{0041}',
    '\u{0302}',
    '\u{0041}',
    '\u{0303}',
    '\u{0041}',
    '\u{0308}',
    '\u{0041}',
    '\u{030A}',
    '\u{0043}',
    '\u{0327}',
    '\u{0045}',
    '\u{0300}',
    '\u{0045}',
    '\u{0301}',
    '\u{0045}',
    '\u{0302}',
    '\u{0045}',
    '\u{0308}',
    '\u{0049}',
    '\u{0300}',
    '\u{0049}',
    '\u{0301}',
    '\u{0049}',
    '\u{0302}',
    '\u{0049}',
    '\u{0308}',
    '\u{004E}',
    '\u{0303}',
    '\u{004F}',
    '\u{0300}',
    '\u{004F}',
    '\u{0301}',
    '\u{004F}',
    '\u{0302}',
    '\u{004F}',
    '\u{0303}',
    '\u{004F}',
    '\u{0308}',
    '\u{0055}',
    '\u{0300}',
    '\u{0055}',
    '\u{0301}',
    '\u{0055}',
    '\u{0302}',
    '\u{0055}',
    '\u{0308}',
    '\u{0059}',
    '\u{0301}',
    '\u{0061}',
    '\u{0300}',
    '\u{0061}',
    '\u{0301}',
    '\u{0061}',
    '\u{0302}',
    '\u{0061}',
    '\u{0303}',
    '\u{0061}',
    '\u{0308}',
    '\u{0061}',
    '\u{030A}',
    '\u{0063}',
    '\u{0327}',
    '\u{0065}',
    '\u{0300}',
    '\u{0065}',
    '\u{0301}',
    '\u{0065}',
    '\u{0302}',
    '\u{0065}',
    '\u{0308}',
    '\u{0069}',
    '\u{0300}',
    '\u{0069}',
    '\u{0301}',
    '\u{0069}',
    '\u{0302}',
    '\u{0069}',
    '\u{0308}',
    '\u{006E}',
    '\u{0303}',
    '\u{006F}',
    '\u{0300}',
    '\u{006F}',
    '\u{0301}',
    '\u{006F}',
    '\u{0302}',
    '\u{006F}',
    '\u{0303}',
    '\u{006F}',
    '\u{0308}',
    '\u{0075}',
    '\u{0300}',
    '\u{0075}',
    '\u{0301}',
    '\u{0075}',
    '\u{0302}',
    '\u{0075}',
    '\u{0308}',
    '\u{0079}',
    '\u{0301}',
    '\u{0079}',
    '\u{0308}',
    '\u{0041}',
    '\u{0304}',
    '\u{0061}',
    '\u{0304}',
    '\u{0041}',
    '\u{0306}',
    '\u{0061}',
    '\u{0306}',
    '\u{0041}',
    '\u{0328}',
    '\u{0061}',
    '\u{0328}',
    '\u{0043}',
    '\u{0301}',
    '\u{0063}',
    '\u{0301}',
    '\u{0043}',
    '\u{0302}',
    '\u{0063}',
    '\u{0302}',
    '\u{0043}',
    '\u{0307}',
    '\u{0063}',
    '\u{0307}',
    '\u{0043}',
    '\u{030C}',
    '\u{0063}',
    '\u{030C}',
    '\u{0044}',
    '\u{030C}',
    '\u{0064}',
    '\u{030C}',
    '\u{0045}',
    '\u{0304}',
    '\u{0065}',
    '\u{0304}',
    '\u{0045}',
    '\u{0306}',
    '\u{0065}',
    '\u{0306}',
    '\u{0045}',
    '\u{0307}',
    '\u{0065}',
    '\u{0307}',
    '\u{0045}',
    '\u{0328}',
    '\u{0065}',
    '\u{0328}',
    '\u{0045}',
    '\u{030C}',
    '\u{0065}',
    '\u{030C}',
    '\u{0047}',
    '\u{0302}',
    '\u{0067}',
    '\u{0302}',
    '\u{0047}',
    '\u{0306}',
    '\u{0067}',
    '\u{0306}',
    '\u{0047}',
    '\u{0307}',
    '\u{0067}',
    '\u{0307}',
    '\u{0047}',
    '\u{0327}',
    '\u{0067}',
    '\u{0327}',
    '\u{0048}',
    '\u{0302}',
    '\u{0068}',
    '\u{0302}',
    '\u{0049}',
    '\u{0303}',
    '\u{0069}',
    '\u{0303}',
    '\u{0049}',
    '\u{0304}',
    '\u{0069}',
    '\u{0304}',
    '\u{0049}',
    '\u{0306}',
    '\u{0069}',
    '\u{0306}',
    '\u{0049}',
    '\u{0328}',
    '\u{0069}',
    '\u{0328}',
    '\u{0049}',
    '\u{0307}',
    '\u{004A}',
    '\u{0302}',
    '\u{006A}',
    '\u{0302}',
    '\u{004B}',
    '\u{0327}',
    '\u{006B}',
    '\u{0327}',
    '\u{004C}',
    '\u{0301}',
    '\u{006C}',
    '\u{0301}',
    '\u{004C}',
    '\u{0327}',
    '\u{006C}',
    '\u{0327}',
    '\u{004C}',
    '\u{030C}',
    '\u{006C}',
    '\u{030C}',
    '\u{004E}',
    '\u{0301}',
    '\u{006E}',
    '\u{0301}',
    '\u{004E}',
    '\u{0327}',
    '\u{006E}',
    '\u{0327}',
    '\u{004E}',
    '\u{030C}',
    '\u{006E}',
    '\u{030C}',
    '\u{004F}',
    '\u{0304}',
    '\u{006F}',
    '\u{0304}',
    '\u{004F}',
    '\u{0306}',
    '\u{006F}',
    '\u{0306}',
    '\u{004F}',
    '\u{030B}',
    '\u{006F}',
    '\u{030B}',
    '\u{0052}',
    '\u{0301}',
    '\u{0072}',
    '\u{0301}',
    '\u{0052}',
    '\u{0327}',
    '\u{0072}',
    '\u{0327}',
    '\u{0052}',
    '\u{030C}',
    '\u{0072}',
    '\u{030C}',
    '\u{0053}',
    '\u{0301}',
    '\u{0073}',
    '\u{0301}',
    '\u{0053}',
    '\u{0302}',
    '\u{0073}',
    '\u{0302}',
    '\u{0053}',
    '\u{0327}',
    '\u{0073}',
    '\u{0327}',
    '\u{0053}',
    '\u{030C}',
    '\u{0073}',
    '\u{030C}',
    '\u{0054}',
    '\u{0327}',
    '\u{0074}',
    '\u{0327}',
    '\u{0054}',
    '\u{030C}',
    '\u{0074}',
    '\u{030C}',
    '\u{0055}',
    '\u{0303}',
    '\u{0075}',
    '\u{0303}',
    '\u{0055}',
    '\u{0304}',
    '\u{0075}',
    '\u{0304}',
    '\u{0055}',
    '\u{0306}',
    '\u{0075}',
    '\u{0306}',
    '\u{0055}',
    '\u{030A}',
    '\u{0075}',
    '\u{030A}',
    '\u{0055}',
    '\u{030B}',
    '\u{0075}',
    '\u{030B}',
    '\u{0055}',
    '\u{0328}',
    '\u{0075}',
    '\u{0328}',
    '\u{0057}',
    '\u{0302}',
    '\u{0077}',
    '\u{0302}',
    '\u{0059}',
    '\u{0302}',
    '\u{0079}',
    '\u{0302}',
    '\u{0059}',
    '\u{0308}',
    '\u{005A}',
    '\u{0301}',
    '\u{007A}',
    '\u{0301}',
    '\u{005A}',
    '\u{0307}',
    '\u{007A}',
    '\u{0307}',
    '\u{005A}',
    '\u{030C}',
    '\u{007A}',
    '\u{030C}',
    '\u{004F}',
    '\u{031B}',
    '\u{006F}',
    '\u{031B}',
    '\u{0055}',
    '\u{031B}',
    '\u{0075}',
    '\u{031B}',
    '\u{0041}',
    '\u{030C}',
    '\u{0061}',
    '\u{030C}',
    '\u{0049}',
    '\u{030C}',
    '\u{0069}',
    '\u{030C}',
    '\u{004F}',
    '\u{030C}',
    '\u{006F}',
    '\u{030C}',
    '\u{0055}',
    '\u{030C}',
    '\u{0075}',
    '\u{030C}',
    '\u{0055}',
    '\u{0308}',
    '\u{0304}',
    '\u{0075}',
    '\u{0308}',
    '\u{0304}',
    '\u{0055}',
    '\u{0308}',
    '\u{0301}',
    '\u{0075}',
    '\u{0308}',
    '\u{0301}',
    '\u{0055}',
    '\u{0308}',
    '\u{030C}',
    '\u{0075}',
    '\u{0308}',
    '\u{030C}',
    '\u{0055}',
    '\u{0308}',
    '\u{0300}',
    '\u{0075}',
    '\u{0308}',
    '\u{0300}',
    '\u{0041}',
    '\u{0308}',
    '\u{0304}',
    '\u{0061}',
    '\u{0308}',
    '\u{0304}',
    '\u{0041}',
    '\u{0307}',
    '\u{0304}',
    '\u{0061}',
    '\u{0307}',
    '\u{0304}',
    '\u{00C6}',
    '\u{0304}',
    '\u{00E6}',
    '\u{0304}',
    '\u{0047}',
    '\u{030C}',
    '\u{0067}',
    '\u{030C}',
    '\u{004B}',
    '\u{030C}',
    '\u{006B}',
    '\u{030C}',
    '\u{004F}',
    '\u{0328}',
    '\u{006F}',
    '\u{0328}',
    '\u{004F}',
    '\u{0328}',
    '\u{0304}',
    '\u{006F}',
    '\u{0328}',
    '\u{0304}',
    '\u{01B7}',
    '\u{030C}',
    '\u{0292}',
    '\u{030C}',
    '\u{006A}',
    '\u{030C}',
    '\u{0047}',
    '\u{0301}',
    '\u{0067}',
    '\u{0301}',
    '\u{004E}',
    '\u{0300}',
    '\u{006E}',
    '\u{0300}',
    '\u{0041}',
    '\u{030A}',
    '\u{0301}',
    '\u{0061}',
    '\u{030A}',
    '\u{0301}',
    '\u{00C6}',
    '\u{0301}',
    '\u{00E6}',
    '\u{0301}',
    '\u{00D8}',
    '\u{0301}',
    '\u{00F8}',
    '\u{0301}',
    '\u{0041}',
    '\u{030F}',
    '\u{0061}',
    '\u{030F}',
    '\u{0041}',
    '\u{0311}',
    '\u{0061}',
    '\u{0311}',
    '\u{0045}',
    '\u{030F}',
    '\u{0065}',
    '\u{030F}',
    '\u{0045}',
    '\u{0311}',
    '\u{0065}',
    '\u{0311}',
    '\u{0049}',
    '\u{030F}',
    '\u{0069}',
    '\u{030F}',
    '\u{0049}',
    '\u{0311}',
    '\u{0069}',
    '\u{0311}',
    '\u{004F}',
    '\u{030F}',
    '\u{006F}',
    '\u{030F}',
    '\u{004F}',
    '\u{0311}',
    '\u{006F}',
    '\u{0311}',
    '\u{0052}',
    '\u{030F}',
    '\u{0072}',
    '\u{030F}',
    '\u{0052}',
    '\u{0311}',
    '\u{0072}',
    '\u{0311}',
    '\u{0055}',
    '\u{030F}',
    '\u{0075}',
    '\u{030F}',
    '\u{0055}',
    '\u{0311}',
    '\u{0075}',
    '\u{0311}',
    '\u{0053}',
    '\u{0326}',
    '\u{0073}',
    '\u{0326}',
    '\u{0054}',
    '\u{0326}',
    '\u{0074}',
    '\u{0326}',
    '\u{0048}',
    '\u{030C}',
    '\u{0068}',
    '\u{030C}',
    '\u{0041}',
    '\u{0307}',
    '\u{0061}',
    '\u{0307}',
    '\u{0045}',
    '\u{0327}',
    '\u{0065}',
    '\u{0327}',
    '\u{004F}',
    '\u{0308}',
    '\u{0304}',
    '\u{006F}',
    '\u{0308}',
    '\u{0304}',
    '\u{004F}',
    '\u{0303}',
    '\u{0304}',
    '\u{006F}',
    '\u{0303}',
    '\u{0304}',
    '\u{004F}',
    '\u{0307}',
    '\u{006F}',
    '\u{0307}',
    '\u{004F}',
    '\u{0307}',
    '\u{0304}',
    '\u{006F}',
    '\u{0307}',
    '\u{0304}',
    '\u{0059}',
    '\u{0304}',
    '\u{0079}',
    '\u{0304}',
    '\u{0300}',
    '\u{0301}',
    '\u{0313}',
    '\u{0308}',
    '\u{0301}',
    '\u{02B9}',
    '\u{003B}',
    '\u{00A8}',
    '\u{0301}',
    '\u{0391}',
    '\u{0301}',
    '\u{00B7}',
    '\u{0395}',
    '\u{0301}',
    '\u{0397}',
    '\u{0301}',
    '\u{0399}',
    '\u{0301}',
    '\u{039F}',
    '\u{0301}',
    '\u{03A5}',
    '\u{0301}',
    '\u{03A9}',
    '\u{0301}',
    '\u{03B9}',
    '\u{0308}',
    '\u{0301}',
    '\u{0399}',
    '\u{0308}',
    '\u{03A5}',
    '\u{0308}',
    '\u{03B1}',
    '\u{0301}',
    '\u{03B5}',
    '\u{0301}',
    '\u{03B7}',
    '\u{0301}',
    '\u{03B9}',
    '\u{0301}',
    '\u{03C5}',
    '\u{0308}',
    '\u{0301}',
    '\u{03B9}',
    '\u{0308}',
    '\u{03C5}',
    '\u{0308}',
    '\u{03BF}',
    '\u{0301}',
    '\u{03C5}',
    '\u{0301}',
    '\u{03C9}',
    '\u{0301}',
    '\u{03D2}',
    '\u{0301}',
    '\u{03D2}',
    '\u{0308}',
    '\u{0415}',
    '\u{0300}',
    '\u{0415}',
    '\u{0308}',
    '\u{0413}',
    '\u{0301}',
    '\u{0406}',
    '\u{0308}',
    '\u{041A}',
    '\u{0301}',
    '\u{0418}',
    '\u{0300}',
    '\u{0423}',
    '\u{0306}',
    '\u{0418}',
    '\u{0306}',
    '\u{0438}',
    '\u{0306}',
    '\u{0435}',
    '\u{0300}',
    '\u{0435}',
    '\u{0308}',
    '\u{0433}',
    '\u{0301}',
    '\u{0456}',
    '\u{0308}',
    '\u{043A}',
    '\u{0301}',
    '\u{0438}',
    '\u{0300}',
    '\u{0443}',
    '\u{0306}',
    '\u{0474}',
    '\u{030F}',
    '\u{0475}',
    '\u{030F}',
    '\u{0416}',
    '\u{0306}',
    '\u{0436}',
    '\u{0306}',
    '\u{0410}',
    '\u{0306}',
    '\u{0430}',
    '\u{0306}',
    '\u{0410}',
    '\u{0308}',
    '\u{0430}',
    '\u{0308}',
    '\u{0415}',
    '\u{0306}',
    '\u{0435}',
    '\u{0306}',
    '\u{04D8}',
    '\u{0308}',
    '\u{04D9}',
    '\u{0308}',
    '\u{0416}',
    '\u{0308}',
    '\u{0436}',
    '\u{0308}',
    '\u{0417}',
    '\u{0308}',
    '\u{0437}',
    '\u{0308}',
    '\u{0418}',
    '\u{0304}',
    '\u{0438}',
    '\u{0304}',
    '\u{0418}',
    '\u{0308}',
    '\u{0438}',
    '\u{0308}',
    '\u{041E}',
    '\u{0308}',
    '\u{043E}',
    '\u{0308}',
    '\u{04E8}',
    '\u{0308}',
    '\u{04E9}',
    '\u{0308}',
    '\u{042D}',
    '\u{0308}',
    '\u{044D}',
    '\u{0308}',
    '\u{0423}',
    '\u{0304}',
    '\u{0443}',
    '\u{0304}',
    '\u{0423}',
    '\u{0308}',
    '\u{0443}',
    '\u{0308}',
    '\u{0423}',
    '\u{030B}',
    '\u{0443}',
    '\u{030B}',
    '\u{0427}',
    '\u{0308}',
    '\u{0447}',
    '\u{0308}',
    '\u{042B}',
    '\u{0308}',
    '\u{044B}',
    '\u{0308}',
    '\u{0627}',
    '\u{0653}',
    '\u{0627}',
    '\u{0654}',
    '\u{0648}',
    '\u{0654}',
    '\u{0627}',
    '\u{0655}',
    '\u{064A}',
    '\u{0654}',
    '\u{06D5}',
    '\u{0654}',
    '\u{06C1}',
    '\u{0654}',
    '\u{06D2}',
    '\u{0654}',
    '\u{0928}',
    '\u{093C}',
    '\u{0930}',
    '\u{093C}',
    '\u{0933}',
    '\u{093C}',
    '\u{0915}',
    '\u{093C}',
    '\u{0916}',
    '\u{093C}',
    '\u{0917}',
    '\u{093C}',
    '\u{091C}',
    '\u{093C}',
    '\u{0921}',
    '\u{093C}',
    '\u{0922}',
    '\u{093C}',
    '\u{092B}',
    '\u{093C}',
    '\u{092F}',
    '\u{093C}',
    '\u{09C7}',
    '\u{09BE}',
    '\u{09C7}',
    '\u{09D7}',
    '\u{09A1}',
    '\u{09BC}',
    '\u{09A2}',
    '\u{09BC}',
    '\u{09AF}',
    '\u{09BC}',
    '\u{0A32}',
    '\u{0A3C}',
    '\u{0A38}',
    '\u{0A3C}',
    '\u{0A16}',
    '\u{0A3C}',
    '\u{0A17}',
    '\u{0A3C}',
    '\u{0A1C}',
    '\u{0A3C}',
    '\u{0A2B}',
    '\u{0A3C}',
    '\u{0B47}',
    '\u{0B56}',
    '\u{0B47}',
    '\u{0B3E}',
    '\u{0B47}',
    '\u{0B57}',
    '\u{0B21}',
    '\u{0B3C}',
    '\u{0B22}',
    '\u{0B3C}',
    '\u{0B92}',
    '\u{0BD7}',
    '\u{0BC6}',
    '\u{0BBE}',
    '\u{0BC7}',
    '\u{0BBE}',
    '\u{0BC6}',
    '\u{0BD7}',
    '\u{0C46}',
    '\u{0C56}',
    '\u{0CBF}',
    '\u{0CD5}',
    '\u{0CC6}',
    '\u{0CD5}',
    '\u{0CC6}',
    '\u{0CD6}',
    '\u{0CC6}',
    '\u{0CC2}',
    '\u{0CC6}',
    '\u{0CC2}',
    '\u{0CD5}',
    '\u{0D46}',
    '\u{0D3E}',
    '\u{0D47}',
    '\u{0D3E}',
    '\u{0D46}',
    '\u{0D57}',
    '\u{0DD9}',
    '\u{0DCA}',
    '\u{0DD9}',
    '\u{0DCF}',
    '\u{0DD9}',
    '\u{0DCF}',
    '\u{0DCA}',
    '\u{0DD9}',
    '\u{0DDF}',
    '\u{0F42}',
    '\u{0FB7}',
    '\u{0F4C}',
    '\u{0FB7}',
    '\u{0F51}',
    '\u{0FB7}',
    '\u{0F56}',
    '\u{0FB7}',
    '\u{0F5B}',
    '\u{0FB7}',
    '\u{0F40}',
    '\u{0FB5}',
    '\u{0F71}',
    '\u{0F72}',
    '\u{0F71}',
    '\u{0F74}',
    '\u{0FB2}',
    '\u{0F80}',
    '\u{0FB3}',
    '\u{0F80}',
    '\u{0F71}',
    '\u{0F80}',
    '\u{0F92}',
    '\u{0FB7}',
    '\u{0F9C}',
    '\u{0FB7}',
    '\u{0FA1}',
    '\u{0FB7}',
    '\u{0FA6}',
    '\u{0FB7}',
    '\u{0FAB}',
    '\u{0FB7}',
    '\u{0F90}',
    '\u{0FB5}',
    '\u{1025}',
    '\u{102E}',
    '\u{1B05}',
    '\u{1B35}',
    '\u{1B07}',
    '\u{1B35}',
    '\u{1B09}',
    '\u{1B35}',
    '\u{1B0B}',
    '\u{1B35}',
    '\u{1B0D}',
    '\u{1B35}',
    '\u{1B11}',
    '\u{1B35}',
    '\u{1B3A}',
    '\u{1B35}',
    '\u{1B3C}',
    '\u{1B35}',
    '\u{1B3E}',
    '\u{1B35}',
    '\u{1B3F}',
    '\u{1B35}',
    '\u{1B42}',
    '\u{1B35}',
    '\u{0041}',
    '\u{0325}',
    '\u{0061}',
    '\u{0325}',
    '\u{0042}',
    '\u{0307}',
    '\u{0062}',
    '\u{0307}',
    '\u{0042}',
    '\u{0323}',
    '\u{0062}',
    '\u{0323}',
    '\u{0042}',
    '\u{0331}',
    '\u{0062}',
    '\u{0331}',
    '\u{0043}',
    '\u{0327}',
    '\u{0301}',
    '\u{0063}',
    '\u{0327}',
    '\u{0301}',
    '\u{0044}',
    '\u{0307}',
    '\u{0064}',
    '\u{0307}',
    '\u{0044}',
    '\u{0323}',
    '\u{0064}',
    '\u{0323}',
    '\u{0044}',
    '\u{0331}',
    '\u{0064}',
    '\u{0331}',
    '\u{0044}',
    '\u{0327}',
    '\u{0064}',
    '\u{0327}',
    '\u{0044}',
    '\u{032D}',
    '\u{0064}',
    '\u{032D}',
    '\u{0045}',
    '\u{0304}',
    '\u{0300}',
    '\u{0065}',
    '\u{0304}',
    '\u{0300}',
    '\u{0045}',
    '\u{0304}',
    '\u{0301}',
    '\u{0065}',
    '\u{0304}',
    '\u{0301}',
    '\u{0045}',
    '\u{032D}',
    '\u{0065}',
    '\u{032D}',
    '\u{0045}',
    '\u{0330}',
    '\u{0065}',
    '\u{0330}',
    '\u{0045}',
    '\u{0327}',
    '\u{0306}',
    '\u{0065}',
    '\u{0327}',
    '\u{0306}',
    '\u{0046}',
    '\u{0307}',
    '\u{0066}',
    '\u{0307}',
    '\u{0047}',
    '\u{0304}',
    '\u{0067}',
    '\u{0304}',
    '\u{0048}',
    '\u{0307}',
    '\u{0068}',
    '\u{0307}',
    '\u{0048}',
    '\u{0323}',
    '\u{0068}',
    '\u{0323}',
    '\u{0048}',
    '\u{0308}',
    '\u{0068}',
    '\u{0308}',
    '\u{0048}',
    '\u{0327}',
    '\u{0068}',
    '\u{0327}',
    '\u{0048}',
    '\u{032E}',
    '\u{0068}',
    '\u{032E}',
    '\u{0049}',
    '\u{0330}',
    '\u{0069}',
    '\u{0330}',
    '\u{0049}',
    '\u{0308}',
    '\u{0301}',
    '\u{0069}',
    '\u{0308}',
    '\u{0301}',
    '\u{004B}',
    '\u{0301}',
    '\u{006B}',
    '\u{0301}',
    '\u{004B}',
    '\u{0323}',
    '\u{006B}',
    '\u{0323}',
    '\u{004B}',
    '\u{0331}',
    '\u{006B}',
    '\u{0331}',
    '\u{004C}',
    '\u{0323}',
    '\u{006C}',
    '\u{0323}',
    '\u{004C}',
    '\u{0323}',
    '\u{0304}',
    '\u{006C}',
    '\u{0323}',
    '\u{0304}',
    '\u{004C}',
    '\u{0331}',
    '\u{006C}',
    '\u{0331}',
    '\u{004C}',
    '\u{032D}',
    '\u{006C}',
    '\u{032D}',
    '\u{004D}',
    '\u{0301}',
    '\u{006D}',
    '\u{0301}',
    '\u{004D}',
    '\u{0307}',
    '\u{006D}',
    '\u{0307}',
    '\u{004D}',
    '\u{0323}',
    '\u{006D}',
    '\u{0323}',
    '\u{004E}',
    '\u{0307}',
    '\u{006E}',
    '\u{0307}',
    '\u{004E}',
    '\u{0323}',
    '\u{006E}',
    '\u{0323}',
    '\u{004E}',
    '\u{0331}',
    '\u{006E}',
    '\u{0331}',
    '\u{004E}',
    '\u{032D}',
    '\u{006E}',
    '\u{032D}',
    '\u{004F}',
    '\u{0303}',
    '\u{0301}',
    '\u{006F}',
    '\u{0303}',
    '\u{0301}',
    '\u{004F}',
    '\u{0303}',
    '\u{0308}',
    '\u{006F}',
    '\u{0303}',
    '\u{0308}',
    '\u{004F}',
    '\u{0304}',
    '\u{0300}',
    '\u{006F}',
    '\u{0304}',
    '\u{0300}',
    '\u{004F}',
    '\u{0304}',
    '\u{0301}',
    '\u{006F}',
    '\u{0304}',
    '\u{0301}',
    '\u{0050}',
    '\u{0301}',
    '\u{0070}',
    '\u{0301}',
    '\u{0050}',
    '\u{0307}',
    '\u{0070}',
    '\u{0307}',
    '\u{0052}',
    '\u{0307}',
    '\u{0072}',
    '\u{0307}',
    '\u{0052}',
    '\u{0323}',
    '\u{0072}',
    '\u{0323}',
    '\u{0052}',
    '\u{0323}',
    '\u{0304}',
    '\u{0072}',
    '\u{0323}',
    '\u{0304}',
    '\u{0052}',
    '\u{0331}',
    '\u{0072}',
    '\u{0331}',
    '\u{0053}',
    '\u{0307}',
    '\u{0073}',
    '\u{0307}',
    '\u{0053}',
    '\u{0323}',
    '\u{0073}',
    '\u{0323}',
    '\u{0053}',
    '\u{0301}',
    '\u{0307}',
    '\u{0073}',
    '\u{0301}',
    '\u{0307}',
    '\u{0053}',
    '\u{030C}',
    '\u{0307}',
    '\u{0073}',
    '\u{030C}',
    '\u{0307}',
    '\u{0053}',
    '\u{0323}',
    '\u{0307}',
    '\u{0073}',
    '\u{0323}',
    '\u{0307}',
    '\u{0054}',
    '\u{0307}',
    '\u{0074}',
    '\u{0307}',
    '\u{0054}',
    '\u{0323}',
    '\u{0074}',
    '\u{0323}',
    '\u{0054}',
    '\u{0331}',
    '\u{0074}',
    '\u{0331}',
    '\u{0054}',
    '\u{032D}',
    '\u{0074}',
    '\u{032D}',
    '\u{0055}',
    '\u{0324}',
    '\u{0075}',
    '\u{0324}',
    '\u{0055}',
    '\u{0330}',
    '\u{0075}',
    '\u{0330}',
    '\u{0055}',
    '\u{032D}',
    '\u{0075}',
    '\u{032D}',
    '\u{0055}',
    '\u{0303}',
    '\u{0301}',
    '\u{0075}',
    '\u{0303}',
    '\u{0301}',
    '\u{0055}',
    '\u{0304}',
    '\u{0308}',
    '\u{0075}',
    '\u{0304}',
    '\u{0308}',
    '\u{0056}',
    '\u{0303}',
    '\u{0076}',
    '\u{0303}',
    '\u{0056}',
    '\u{0323}',
    '\u{0076}',
    '\u{0323}',
    '\u{0057}',
    '\u{0300}',
    '\u{0077}',
    '\u{0300}',
    '\u{0057}',
    '\u{0301}',
    '\u{0077}',
    '\u{0301}',
    '\u{0057}',
    '\u{0308}',
    '\u{0077}',
    '\u{0308}',
    '\u{0057}',
    '\u{0307}',
    '\u{0077}',
    '\u{0307}',
    '\u{0057}',
    '\u{0323}',
    '\u{0077}',
    '\u{0323}',
    '\u{0058}',
    '\u{0307}',
    '\u{0078}',
    '\u{0307}',
    '\u{0058}',
    '\u{0308}',
    '\u{0078}',
    '\u{0308}',
    '\u{0059}',
    '\u{0307}',
    '\u{0079}',
    '\u{0307}',
    '\u{005A}',
    '\u{0302}',
    '\u{007A}',
    '\u{0302}',
    '\u{005A}',
    '\u{0323}',
    '\u{007A}',
    '\u{0323}',
    '\u{005A}',
    '\u{0331}',
    '\u{007A}',
    '\u{0331}',
    '\u{0068}',
    '\u{0331}',
    '\u{0074}',
    '\u{0308}',
    '\u{0077}',
    '\u{030A}',
    '\u{0079}',
    '\u{030A}',
    '\u{017F}',
    '\u{0307}',
    '\u{0041}',
    '\u{0323}',
    '\u{0061}',
    '\u{0323}',
    '\u{0041}',
    '\u{0309}',
    '\u{0061}',
    '\u{0309}',
    '\u{0041}',
    '\u{0302}',
    '\u{0301}',
    '\u{0061}',
    '\u{0302}',
    '\u{0301}',
    '\u{0041}',
    '\u{0302}',
    '\u{0300}',
    '\u{0061}',
    '\u{0302}',
    '\u{0300}',
    '\u{0041}',
    '\u{0302}',
    '\u{0309}',
    '\u{0061}',
    '\u{0302}',
    '\u{0309}',
    '\u{0041}',
    '\u{0302}',
    '\u{0303}',
    '\u{0061}',
    '\u{0302}',
    '\u{0303}',
    '\u{0041}',
    '\u{0323}',
    '\u{0302}',
    '\u{0061}',
    '\u{0323}',
    '\u{0302}',
    '\u{0041}',
    '\u{0306}',
    '\u{0301}',
    '\u{0061}',
    '\u{0306}',
    '\u{0301}',
    '\u{0041}',
    '\u{0306}',
    '\u{0300}',
    '\u{0061}',
    '\u{0306}',
    '\u{0300}',
    '\u{0041}',
    '\u{0306}',
    '\u{0309}',
    '\u{0061}',
    '\u{0306}',
    '\u{0309}',
    '\u{0041}',
    '\u{0306}',
    '\u{0303}',
    '\u{0061}',
    '\u{0306}',
    '\u{0303}',
    '\u{0041}',
    '\u{0323}',
    '\u{0306}',
    '\u{0061}',
    '\u{0323}',
    '\u{0306}',
    '\u{0045}',
    '\u{0323}',
    '\u{0065}',
    '\u{0323}',
    '\u{0045}',
    '\u{0309}',
    '\u{0065}',
    '\u{0309}',
    '\u{0045}',
    '\u{0303}',
    '\u{0065}',
    '\u{0303}',
    '\u{0045}',
    '\u{0302}',
    '\u{0301}',
    '\u{0065}',
    '\u{0302}',
    '\u{0301}',
    '\u{0045}',
    '\u{0302}',
    '\u{0300}',
    '\u{0065}',
    '\u{0302}',
    '\u{0300}',
    '\u{0045}',
    '\u{0302}',
    '\u{0309}',
    '\u{0065}',
    '\u{0302}',
    '\u{0309}',
    '\u{0045}',
    '\u{0302}',
    '\u{0303}',
    '\u{0065}',
    '\u{0302}',
    '\u{0303}',
    '\u{0045}',
    '\u{0323}',
    '\u{0302}',
    '\u{0065}',
    '\u{0323}',
    '\u{0302}',
    '\u{0049}',
    '\u{0309}',
    '\u{0069}',
    '\u{0309}',
    '\u{0049}',
    '\u{0323}',
    '\u{0069}',
    '\u{0323}',
    '\u{004F}',
    '\u{0323}',
    '\u{006F}',
    '\u{0323}',
    '\u{004F}',
    '\u{0309}',
    '\u{006F}',
    '\u{0309}',
    '\u{004F}',
    '\u{0302}',
    '\u{0301}',
    '\u{006F}',
    '\u{0302}',
    '\u{0301}',
    '\u{004F}',
    '\u{0302}',
    '\u{0300}',
    '\u{006F}',
    '\u{0302}',
    '\u{0300}',
    '\u{004F}',
    '\u{0302}',
    '\u{0309}',
    '\u{006F}',
    '\u{0302}',
    '\u{0309}',
    '\u{004F}',
    '\u{0302}',
    '\u{0303}',
    '\u{006F}',
    '\u{0302}',
    '\u{0303}',
    '\u{004F}',
    '\u{0323}',
    '\u{0302}',
    '\u{006F}',
    '\u{0323}',
    '\u{0302}',
    '\u{004F}',
    '\u{031B}',
    '\u{0301}',
    '\u{006F}',
    '\u{031B}',
    '\u{0301}',
    '\u{004F}',
    '\u{031B}',
    '\u{0300}',
    '\u{006F}',
    '\u{031B}',
    '\u{0300}',
    '\u{004F}',
    '\u{031B}',
    '\u{0309}',
    '\u{006F}',
    '\u{031B}',
    '\u{0309}',
    '\u{004F}',
    '\u{031B}',
    '\u{0303}',
    '\u{006F}',
    '\u{031B}',
    '\u{0303}',
    '\u{004F}',
    '\u{031B}',
    '\u{0323}',
    '\u{006F}',
    '\u{031B}',
    '\u{0323}',
    '\u{0055}',
    '\u{0323}',
    '\u{0075}',
    '\u{0323}',
    '\u{0055}',
    '\u{0309}',
    '\u{0075}',
    '\u{0309}',
    '\u{0055}',
    '\u{031B}',
    '\u{0301}',
    '\u{0075}',
    '\u{031B}',
    '\u{0301}',
    '\u{0055}',
    '\u{031B}',
    '\u{0300}',
    '\u{0075}',
    '\u{031B}',
    '\u{0300}',
    '\u{0055}',
    '\u{031B}',
    '\u{0309}',
    '\u{0075}',
    '\u{031B}',
    '\u{0309}',
    '\u{0055}',
    '\u{031B}',
    '\u{0303}',
    '\u{0075}',
    '\u{031B}',
    '\u{0303}',
    '\u{0055}',
    '\u{031B}',
    '\u{0323}',
    '\u{0075}',
    '\u{031B}',
    '\u{0323}',
    '\u{0059}',
    '\u{0300}',
    '\u{0079}',
    '\u{0300}',
    '\u{0059}',
    '\u{0323}',
    '\u{0079}',
    '\u{0323}',
    '\u{0059}',
    '\u{0309}',
    '\u{0079}',
    '\u{0309}',
    '\u{0059}',
    '\u{0303}',
    '\u{0079}',
    '\u{0303}',
    '\u{03B1}',
    '\u{0313}',
    '\u{03B1}',
    '\u{0314}',
    '\u{03B1}',
    '\u{0313}',
    '\u{0300}',
    '\u{03B1}',
    '\u{0314}',
    '\u{0300}',
    '\u{03B1}',
    '\u{0313}',
    '\u{0301}',
    '\u{03B1}',
    '\u{0314}',
    '\u{0301}',
    '\u{03B1}',
    '\u{0313}',
    '\u{0342}',
    '\u{03B1}',
    '\u{0314}',
    '\u{0342}',
    '\u{0391}',
    '\u{0313}',
    '\u{0391}',
    '\u{0314}',
    '\u{0391}',
    '\u{0313}',
    '\u{0300}',
    '\u{0391}',
    '\u{0314}',
    '\u{0300}',
    '\u{0391}',
    '\u{0313}',
    '\u{0301}',
    '\u{0391}',
    '\u{0314}',
    '\u{0301}',
    '\u{0391}',
    '\u{0313}',
    '\u{0342}',
    '\u{0391}',
    '\u{0314}',
    '\u{0342}',
    '\u{03B5}',
    '\u{0313}',
    '\u{03B5}',
    '\u{0314}',
    '\u{03B5}',
    '\u{0313}',
    '\u{0300}',
    '\u{03B5}',
    '\u{0314}',
    '\u{0300}',
    '\u{03B5}',
    '\u{0313}',
    '\u{0301}',
    '\u{03B5}',
    '\u{0314}',
    '\u{0301}',
    '\u{0395}',
    '\u{0313}',
    '\u{0395}',
    '\u{0314}',
    '\u{0395}',
    '\u{0313}',
    '\u{0300}',
    '\u{0395}',
    '\u{0314}',
    '\u{0300}',
    '\u{0395}',
    '\u{0313}',
    '\u{0301}',
    '\u{0395}',
    '\u{0314}',
    '\u{0301}',
    '\u{03B7}',
    '\u{0313}',
    '\u{03B7}',
    '\u{0314}',
    '\u{03B7}',
    '\u{0313}',
    '\u{0300}',
    '\u{03B7}',
    '\u{0314}',
    '\u{0300}',
    '\u{03B7}',
    '\u{0313}',
    '\u{0301}',
    '\u{03B7}',
    '\u{0314}',
    '\u{0301}',
    '\u{03B7}',
    '\u{0313}',
    '\u{0342}',
    '\u{03B7}',
    '\u{0314}',
    '\u{0342}',
    '\u{0397}',
    '\u{0313}',
    '\u{0397}',
    '\u{0314}',
    '\u{0397}',
    '\u{0313}',
    '\u{0300}',
    '\u{0397}',
    '\u{0314}',
    '\u{0300}',
    '\u{0397}',
    '\u{0313}',
    '\u{0301}',
    '\u{0397}',
    '\u{0314}',
    '\u{0301}',
    '\u{0397}',
    '\u{0313}',
    '\u{0342}',
    '\u{0397}',
    '\u{0314}',
    '\u{0342}',
    '\u{03B9}',
    '\u{0313}',
    '\u{03B9}',
    '\u{0314}',
    '\u{03B9}',
    '\u{0313}',
    '\u{0300}',
    '\u{03B9}',
    '\u{0314}',
    '\u{0300}',
    '\u{03B9}',
    '\u{0313}',
    '\u{0301}',
    '\u{03B9}',
    '\u{0314}',
    '\u{0301}',
    '\u{03B9}',
    '\u{0313}',
    '\u{0342}',
    '\u{03B9}',
    '\u{0314}',
    '\u{0342}',
    '\u{0399}',
    '\u{0313}',
    '\u{0399}',
    '\u{0314}',
    '\u{0399}',
    '\u{0313}',
    '\u{0300}',
    '\u{0399}',
    '\u{0314}',
    '\u{0300}',
    '\u{0399}',
    '\u{0313}',
    '\u{0301}',
    '\u{0399}',
    '\u{0314}',
    '\u{0301}',
    '\u{0399}',
    '\u{0313}',
    '\u{0342}',
    '\u{0399}',
    '\u{0314}',
    '\u{0342}',
    '\u{03BF}',
    '\u{0313}',
    '\u{03BF}',
    '\u{0314}',
    '\u{03BF}',
    '\u{0313}',
    '\u{0300}',
    '\u{03BF}',
    '\u{0314}',
    '\u{0300}',
    '\u{03BF}',
    '\u{0313}',
    '\u{0301}',
    '\u{03BF}',
    '\u{0314}',
    '\u{0301}',
    '\u{039F}',
    '\u{0313}',
    '\u{039F}',
    '\u{0314}',
    '\u{039F}',
    '\u{0313}',
    '\u{0300}',
    '\u{039F}',
    '\u{0314}',
    '\u{0300}',
    '\u{039F}',
    '\u{0313}',
    '\u{0301}',
    '\u{039F}',
    '\u{0314}',
    '\u{0301}',
    '\u{03C5}',
    '\u{0313}',
    '\u{03C5}',
    '\u{0314}',
    '\u{03C5}',
    '\u{0313}',
    '\u{0300}',
    '\u{03C5}',
    '\u{0314}',
    '\u{0300}',
    '\u{03C5}',
    '\u{0313}',
    '\u{0301}',
    '\u{03C5}',
    '\u{0314}',
    '\u{0301}',
    '\u{03C5}',
    '\u{0313}',
    '\u{0342}',
    '\u{03C5}',
    '\u{0314}',
    '\u{0342}',
    '\u{03A5}',
    '\u{0314}',
    '\u{03A5}',
    '\u{0314}',
    '\u{0300}',
    '\u{03A5}',
    '\u{0314}',
    '\u{0301}',
    '\u{03A5}',
    '\u{0314}',
    '\u{0342}',
    '\u{03C9}',
    '\u{0313}',
    '\u{03C9}',
    '\u{0314}',
    '\u{03C9}',
    '\u{0313}',
    '\u{0300}',
    '\u{03C9}',
    '\u{0314}',
    '\u{0300}',
    '\u{03C9}',
    '\u{0313}',
    '\u{0301}',
    '\u{03C9}',
    '\u{0314}',
    '\u{0301}',
    '\u{03C9}',
    '\u{0313}',
    '\u{0342}',
    '\u{03C9}',
    '\u{0314}',
    '\u{0342}',
    '\u{03A9}',
    '\u{0313}',
    '\u{03A9}',
    '\u{0314}',
    '\u{03A9}',
    '\u{0313}',
    '\u{0300}',
    '\u{03A9}',
    '\u{0314}',
    '\u{0300}',
    '\u{03A9}',
    '\u{0313}',
    '\u{0301}',
    '\u{03A9}',
    '\u{0314}',
    '\u{0301}',
    '\u{03A9}',
    '\u{0313}',
    '\u{0342}',
    '\u{03A9}',
    '\u{0314}',
    '\u{0342}',
    '\u{03B1}',
    '\u{0300}',
    '\u{03B1}',
    '\u{0301}',
    '\u{03B5}',
    '\u{0300}',
    '\u{03B5}',
    '\u{0301}',
    '\u{03B7}',
    '\u{0300}',
    '\u{03B7}',
    '\u{0301}',
    '\u{03B9}',
    '\u{0300}',
    '\u{03B9}',
    '\u{0301}',
    '\u{03BF}',
    '\u{0300}',
    '\u{03BF}',
    '\u{0301}',
    '\u{03C5}',
    '\u{0300}',
    '\u{03C5}',
    '\u{0301}',
    '\u{03C9}',
    '\u{0300}',
    '\u{03C9}',
    '\u{0301}',
    '\u{03B1}',
    '\u{0313}',
    '\u{0345}',
    '\u{03B1}',
    '\u{0314}',
    '\u{0345}',
    '\u{03B1}',
    '\u{0313}',
    '\u{0300}',
    '\u{0345}',
    '\u{03B1}',
    '\u{0314}',
    '\u{0300}',
    '\u{0345}',
    '\u{03B1}',
    '\u{0313}',
    '\u{0301}',
    '\u{0345}',
    '\u{03B1}',
    '\u{0314}',
    '\u{0301}',
    '\u{0345}',
    '\u{03B1}',
    '\u{0313}',
    '\u{0342}',
    '\u{0345}',
    '\u{03B1}',
    '\u{0314}',
    '\u{0342}',
    '\u{0345}',
    '\u{0391}',
    '\u{0313}',
    '\u{0345}',
    '\u{0391}',
    '\u{0314}',
    '\u{0345}',
    '\u{0391}',
    '\u{0313}',
    '\u{0300}',
    '\u{0345}',
    '\u{0391}',
    '\u{0314}',
    '\u{0300}',
    '\u{0345}',
    '\u{0391}',
    '\u{0313}',
    '\u{0301}',
    '\u{0345}',
    '\u{0391}',
    '\u{0314}',
    '\u{0301}',
    '\u{0345}',
    '\u{0391}',
    '\u{0313}',
    '\u{0342}',
    '\u{0345}',
    '\u{0391}',
    '\u{0314}',
    '\u{0342}',
    '\u{0345}',
    '\u{03B7}',
    '\u{0313}',
    '\u{0345}',
    '\u{03B7}',
    '\u{0314}',
    '\u{0345}',
    '\u{03B7}',
    '\u{0313}',
    '\u{0300}',
    '\u{0345}',
    '\u{03B7}',
    '\u{0314}',
    '\u{0300}',
    '\u{0345}',
    '\u{03B7}',
    '\u{0313}',
    '\u{0301}',
    '\u{0345}',
    '\u{03B7}',
    '\u{0314}',
    '\u{0301}',
    '\u{0345}',
    '\u{03B7}',
    '\u{0313}',
    '\u{0342}',
    '\u{0345}',
    '\u{03B7}',
    '\u{0314}',
    '\u{0342}',
    '\u{0345}',
    '\u{0397}',
    '\u{0313}',
    '\u{0345}',
    '\u{0397}',
    '\u{0314}',
    '\u{0345}',
    '\u{0397}',
    '\u{0313}',
    '\u{0300}',
    '\u{0345}',
    '\u{0397}',
    '\u{0314}',
    '\u{0300}',
    '\u{0345}',
    '\u{0397}',
    '\u{0313}',
    '\u{0301}',
    '\u{0345}',
    '\u{0397}',
    '\u{0314}',
    '\u{0301}',
    '\u{0345}',
    '\u{0397}',
    '\u{0313}',
    '\u{0342}',
    '\u{0345}',
    '\u{0397}',
    '\u{0314}',
    '\u{0342}',
    '\u{0345}',
    '\u{03C9}',
    '\u{0313}',
    '\u{0345}',
    '\u{03C9}',
    '\u{0314}',
    '\u{0345}',
    '\u{03C9}',
    '\u{0313}',
    '\u{0300}',
    '\u{0345}',
    '\u{03C9}',
    '\u{0314}',
    '\u{0300}',
    '\u{0345}',
    '\u{03C9}',
    '\u{0313}',
    '\u{0301}',
    '\u{0345}',
    '\u{03C9}',
    '\u{0314}',
    '\u{0301}',
    '\u{0345}',
    '\u{03C9}',
    '\u{0313}',
    '\u{0342}',
    '\u{0345}',
    '\u{03C9}',
    '\u{0314}',
    '\u{0342}',
    '\u{0345}',
    '\u{03A9}',
    '\u{0313}',
    '\u{0345}',
    '\u{03A9}',
    '\u{0314}',
    '\u{0345}',
    '\u{03A9}',
    '\u{0313}',
    '\u{0300}',
    '\u{0345}',
    '\u{03A9}',
    '\u{0314}',
    '\u{0300}',
    '\u{0345}',
    '\u{03A9}',
    '\u{0313}',
    '\u{0301}',
    '\u{0345}',
    '\u{03A9}',
    '\u{0314}',
    '\u{0301}',
    '\u{0345}',
    '\u{03A9}',
    '\u{0313}',
    '\u{0342}',
    '\u{0345}',
    '\u{03A9}',
    '\u{0314}',
    '\u{0342}',
    '\u{0345}',
    '\u{03B1}',
    '\u{0306}',
    '\u{03B1}',
    '\u{0304}',
    '\u{03B1}',
    '\u{0300}',
    '\u{0345}',
    '\u{03B1}',
    '\u{0345}',
    '\u{03B1}',
    '\u{0301}',
    '\u{0345}',
    '\u{03B1}',
    '\u{0342}',
    '\u{03B1}',
    '\u{0342}',
    '\u{0345}',
    '\u{0391}',
    '\u{0306}',
    '\u{0391}',
    '\u{0304}',
    '\u{0391}',
    '\u{0300}',
    '\u{0391}',
    '\u{0301}',
    '\u{0391}',
    '\u{0345}',
    '\u{03B9}',
    '\u{00A8}',
    '\u{0342}',
    '\u{03B7}',
    '\u{0300}',
    '\u{0345}',
    '\u{03B7}',
    '\u{0345}',
    '\u{03B7}',
    '\u{0301}',
    '\u{0345}',
    '\u{03B7}',
    '\u{0342}',
    '\u{03B7}',
    '\u{0342}',
    '\u{0345}',
    '\u{0395}',
    '\u{0300}',
    '\u{0395}',
    '\u{0301}',
    '\u{0397}',
    '\u{0300}',
    '\u{0397}',
    '\u{0301}',
    '\u{0397}',
    '\u{0345}',
    '\u{1FBF}',
    '\u{0300}',
    '\u{1FBF}',
    '\u{0301}',
    '\u{1FBF}',
    '\u{0342}',
    '\u{03B9}',
    '\u{0306}',
    '\u{03B9}',
    '\u{0304}',
    '\u{03B9}',
    '\u{0308}',
    '\u{0300}',
    '\u{03B9}',
    '\u{0308}',
    '\u{0301}',
    '\u{03B9}',
    '\u{0342}',
    '\u{03B9}',
    '\u{0308}',
    '\u{0342}',
    '\u{0399}',
    '\u{0306}',
    '\u{0399}',
    '\u{0304}',
    '\u{0399}',
    '\u{0300}',
    '\u{0399}',
    '\u{0301}',
    '\u{1FFE}',
    '\u{0300}',
    '\u{1FFE}',
    '\u{0301}',
    '\u{1FFE}',
    '\u{0342}',
    '\u{03C5}',
    '\u{0306}',
    '\u{03C5}',
    '\u{0304}',
    '\u{03C5}',
    '\u{0308}',
    '\u{0300}',
    '\u{03C5}',
    '\u{0308}',
    '\u{0301}',
    '\u{03C1}',
    '\u{0313}',
    '\u{03C1}',
    '\u{0314}',
    '\u{03C5}',
    '\u{0342}',
    '\u{03C5}',
    '\u{0308}',
    '\u{0342}',
    '\u{03A5}',
    '\u{0306}',
    '\u{03A5}',
    '\u{0304}',
    '\u{03A5}',
    '\u{0300}',
    '\u{03A5}',
    '\u{0301}',
    '\u{03A1}',
    '\u{0314}',
    '\u{00A8}',
    '\u{0300}',
    '\u{00A8}',
    '\u{0301}',
    '\u{0060}',
    '\u{03C9}',
    '\u{0300}',
    '\u{0345}',
    '\u{03C9}',
    '\u{0345}',
    '\u{03C9}',
    '\u{0301}',
    '\u{0345}',
    '\u{03C9}',
    '\u{0342}',
    '\u{03C9}',
    '\u{0342}',
    '\u{0345}',
    '\u{039F}',
    '\u{0300}',
    '\u{039F}',
    '\u{0301}',
    '\u{03A9}',
    '\u{0300}',
    '\u{03A9}',
    '\u{0301}',
    '\u{03A9}',
    '\u{0345}',
    '\u{00B4}',
    '\u{2002}',
    '\u{2003}',
    '\u{03A9}',
    '\u{004B}',
    '\u{0041}',
    '\u{030A}',
    '\u{2190}',
    '\u{0338}',
    '\u{2192}',
    '\u{0338}',
    '\u{2194}',
    '\u{0338}',
    '\u{21D0}',
    '\u{0338}',
    '\u{21D4}',
    '\u{0338}',
    '\u{21D2}',
    '\u{0338}',
    '\u{2203}',
    '\u{0338}',
    '\u{2208}',
    '\u{0338}',
    '\u{220B}',
    '\u{0338}',
    '\u{2223}',
    '\u{0338}',
    '\u{2225}',
    '\u{0338}',
    '\u{223C}',
    '\u{0338}',
    '\u{2243}',
    '\u{0338}',
    '\u{2245}',
    '\u{0338}',
    '\u{2248}',
    '\u{0338}',
    '\u{003D}',
    '\u{0338}',
    '\u{2261}',
    '\u{0338}',
    '\u{224D}',
    '\u{0338}',
    '\u{003C}',
    '\u{0338}',
    '\u{003E}',
    '\u{0338}',
    '\u{2264}',
    '\u{0338}',
    '\u{2265}',
    '\u{0338}',
    '\u{2272}',
    '\u{0338}',
    '\u{2273}',
    '\u{0338}',
    '\u{2276}',
    '\u{0338}',
    '\u{2277}',
    '\u{0338}',
    '\u{227A}',
    '\u{0338}',
    '\u{227B}',
    '\u{0338}',
    '\u{2282}',
    '\u{0338}',
    '\u{2283}',
    '\u{0338}',
    '\u{2286}',
    '\u{0338}',
    '\u{2287}',
    '\u{0338}',
    '\u{22A2}',
    '\u{0338}',
    '\u{22A8}',
    '\u{0338}',
    '\u{22A9}',
    '\u{0338}',
    '\u{22AB}',
    '\u{0338}',
    '\u{227C}',
    '\u{0338}',
    '\u{227D}',
    '\u{0338}',
    '\u{2291}',
    '\u{0338}',
    '\u{2292}',
    '\u{0338}',
    '\u{22B2}',
    '\u{0338}',
    '\u{22B3}',
    '\u{0338}',
    '\u{22B4}',
    '\u{0338}',
    '\u{22B5}',
    '\u{0338}',
    '\u{3008}',
    '\u{3009}',
    '\u{2ADD}',
    '\u{0338}',
    '\u{304B}',
    '\u{3099}',
    '\u{304D}',
    '\u{3099}',
    '\u{304F}',
    '\u{3099}',
    '\u{3051}',
    '\u{3099}',
    '\u{3053}',
    '\u{3099}',
    '\u{3055}',
    '\u{3099}',
    '\u{3057}',
    '\u{3099}',
    '\u{3059}',
    '\u{3099}',
    '\u{305B}',
    '\u{3099}',
    '\u{305D}',
    '\u{3099}',
    '\u{305F}',
    '\u{3099}',
    '\u{3061}',
    '\u{3099}',
    '\u{3064}',
    '\u{3099}',
    '\u{3066}',
    '\u{3099}',
    '\u{3068}',
    '\u{3099}',
    '\u{306F}',
    '\u{3099}',
    '\u{306F}',
    '\u{309A}',
    '\u{3072}',
    '\u{3099}',
    '\u{3072}',
    '\u{309A}',
    '\u{3075}',
    '\u{3099}',
    '\u{3075}',
    '\u{309A}',
    '\u{3078}',
    '\u{3099}',
    '\u{3078}',
    '\u{309A}',
    '\u{307B}',
    '\u{3099}',
    '\u{307B}',
    '\u{309A}',
    '\u{3046}',
    '\u{3099}',
    '\u{309D}',
    '\u{3099}',
    '\u{30AB}',
    '\u{3099}',
    '\u{30AD}',
    '\u{3099}',
    '\u{30AF}',
    '\u{3099}',
    '\u{30B1}',
    '\u{3099}',
    '\u{30B3}',
    '\u{3099}',
    '\u{30B5}',
    '\u{3099}',
    '\u{30B7}',
    '\u{3099}',
    '\u{30B9}',
    '\u{3099}',
    '\u{30BB}',
    '\u{3099}',
    '\u{30BD}',
    '\u{3099}',
    '\u{30BF}',
    '\u{3099}',
    '\u{30C1}',
    '\u{3099}',
    '\u{30C4}',
    '\u{3099}',
    '\u{30C6}',
    '\u{3099}',
    '\u{30C8}',
    '\u{3099}',
    '\u{30CF}',
    '\u{3099}',
    '\u{30CF}',
    '\u{309A}',
    '\u{30D2}',
    '\u{3099}',
    '\u{30D2}',
    '\u{309A}',
    '\u{30D5}',
    '\u{3099}',
    '\u{30D5}',
    '\u{309A}',
    '\u{30D8}',
    '\u{3099}',
    '\u{30D8}',
    '\u{309A}',
    '\u{30DB}',
    '\u{3099}',
    '\u{30DB}',
    '\u{309A}',
    '\u{30A6}',
    '\u{3099}',
    '\u{30EF}',
    '\u{3099}',
    '\u{30F0}',
    '\u{3099}',
    '\u{30F1}',
    '\u{3099}',
    '\u{30F2}',
    '\u{3099}',
    '\u{30FD}',
    '\u{3099}',
    '\u{8C48}',
    '\u{66F4}',
    '\u{8ECA}',
    '\u{8CC8}',
    '\u{6ED1}',
    '\u{4E32}',
    '\u{53E5}',
    '\u{9F9C}',
    '\u{9F9C}',
    '\u{5951}',
    '\u{91D1}',
    '\u{5587}',
    '\u{5948}',
    '\u{61F6}',
    '\u{7669}',
    '\u{7F85}',
    '\u{863F}',
    '\u{87BA}',
    '\u{88F8}',
    '\u{908F}',
    '\u{6A02}',
    '\u{6D1B}',
    '\u{70D9}',
    '\u{73DE}',
    '\u{843D}',
    '\u{916A}',
    '\u{99F1}',
    '\u{4E82}',
    '\u{5375}',
    '\u{6B04}',
    '\u{721B}',
    '\u{862D}',
    '\u{9E1E}',
    '\u{5D50}',
    '\u{6FEB}',
    '\u{85CD}',
    '\u{8964}',
    '\u{62C9}',
    '\u{81D8}',
    '\u{881F}',
    '\u{5ECA}',
    '\u{6717}',
    '\u{6D6A}',
    '\u{72FC}',
    '\u{90CE}',
    '\u{4F86}',
    '\u{51B7}',
    '\u{52DE}',
    '\u{64C4}',
    '\u{6AD3}',
    '\u{7210}',
    '\u{76E7}',
    '\u{8001}',
    '\u{8606}',
    '\u{865C}',
    '\u{8DEF}',
    '\u{9732}',
    '\u{9B6F}',
    '\u{9DFA}',
    '\u{788C}',
    '\u{797F}',
    '\u{7DA0}',
    '\u{83C9}',
    '\u{9304}',
    '\u{9E7F}',
    '\u{8AD6}',
    '\u{58DF}',
    '\u{5F04}',
    '\u{7C60}',
    '\u{807E}',
    '\u{7262}',
    '\u{78CA}',
    '\u{8CC2}',
    '\u{96F7}',
    '\u{58D8}',
    '\u{5C62}',
    '\u{6A13}',
    '\u{6DDA}',
    '\u{6F0F}',
    '\u{7D2F}',
    '\u{7E37}',
    '\u{964B}',
    '\u{52D2}',
    '\u{808B}',
    '\u{51DC}',
    '\u{51CC}',
    '\u{7A1C}',
    '\u{7DBE}',
    '\u{83F1}',
    '\u{9675}',
    '\u{8B80}',
    '\u{62CF}',
    '\u{6A02}',
    '\u{8AFE}',
    '\u{4E39}',
    '\u{5BE7}',
    '\u{6012}',
    '\u{7387}',
    '\u{7570}',
    '\u{5317}',
    '\u{78FB}',
    '\u{4FBF}',
    '\u{5FA9}',
    '\u{4E0D}',
    '\u{6CCC}',
    '\u{6578}',
    '\u{7D22}',
    '\u{53C3}',
    '\u{585E}',
    '\u{7701}',
    '\u{8449}',
    '\u{8AAA}',
    '\u{6BBA}',
    '\u{8FB0}',
    '\u{6C88}',
    '\u{62FE}',
    '\u{82E5}',
    '\u{63A0}',
    '\u{7565}',
    '\u{4EAE}',
    '\u{5169}',
    '\u{51C9}',
    '\u{6881}',
    '\u{7CE7}',
    '\u{826F}',
    '\u{8AD2}',
    '\u{91CF}',
    '\u{52F5}',
    '\u{5442}',
    '\u{5973}',
    '\u{5EEC}',
    '\u{65C5}',
    '\u{6FFE}',
    '\u{792A}',
    '\u{95AD}',
    '\u{9A6A}',
    '\u{9E97}',
    '\u{9ECE}',
    '\u{529B}',
    '\u{66C6}',
    '\u{6B77}',
    '\u{8F62}',
    '\u{5E74}',
    '\u{6190}',
    '\u{6200}',
    '\u{649A}',
    '\u{6F23}',
    '\u{7149}',
    '\u{7489}',
    '\u{79CA}',
    '\u{7DF4}',
    '\u{806F}',
    '\u{8F26}',
    '\u{84EE}',
    '\u{9023}',
    '\u{934A}',
    '\u{5217}',
    '\u{52A3}',
    '\u{54BD}',
    '\u{70C8}',
    '\u{88C2}',
    '\u{8AAA}',
    '\u{5EC9}',
    '\u{5FF5}',
    '\u{637B}',
    '\u{6BAE}',
    '\u{7C3E}',
    '\u{7375}',
    '\u{4EE4}',
    '\u{56F9}',
    '\u{5BE7}',
    '\u{5DBA}',
    '\u{601C}',
    '\u{73B2}',
    '\u{7469}',
    '\u{7F9A}',
    '\u{8046}',
    '\u{9234}',
    '\u{96F6}',
    '\u{9748}',
    '\u{9818}',
    '\u{4F8B}',
    '\u{79AE}',
    '\u{91B4}',
    '\u{96B8}',
    '\u{60E1}',
    '\u{4E86}',
    '\u{50DA}',
    '\u{5BEE}',
    '\u{5C3F}',
    '\u{6599}',
    '\u{6A02}',
    '\u{71CE}',
    '\u{7642}',
    '\u{84FC}',
    '\u{907C}',
    '\u{9F8D}',
    '\u{6688}',
    '\u{962E}',
    '\u{5289}',
    '\u{677B}',
    '\u{67F3}',
    '\u{6D41}',
    '\u{6E9C}',
    '\u{7409}',
    '\u{7559}',
    '\u{786B}',
    '\u{7D10}',
    '\u{985E}',
    '\u{516D}',
    '\u{622E}',
    '\u{9678}',
    '\u{502B}',
    '\u{5D19}',
    '\u{6DEA}',
    '\u{8F2A}',
    '\u{5F8B}',
    '\u{6144}',
    '\u{6817}',
    '\u{7387}',
    '\u{9686}',
    '\u{5229}',
    '\u{540F}',
    '\u{5C65}',
    '\u{6613}',
    '\u{674E}',
    '\u{68A8}',
    '\u{6CE5}',
    '\u{7406}',
    '\u{75E2}',
    '\u{7F79}',
    '\u{88CF}',
    '\u{88E1}',
    '\u{91CC}',
    '\u{96E2}',
    '\u{533F}',
    '\u{6EBA}',
    '\u{541D}',
    '\u{71D0}',
    '\u{7498}',
    '\u{85FA}',
    '\u{96A3}',
    '\u{9C57}',
    '\u{9E9F}',
    '\u{6797}',
    '\u{6DCB}',
    '\u{81E8}',
    '\u{7ACB}',
    '\u{7B20}',
    '\u{7C92}',
    '\u{72C0}',
    '\u{7099}',
    '\u{8B58}',
    '\u{4EC0}',
    '\u{8336}',
    '\u{523A}',
    '\u{5207}',
    '\u{5EA6}',
    '\u{62D3}',
    '\u{7CD6}',
    '\u{5B85}',
    '\u{6D1E}',
    '\u{66B4}',
    '\u{8F3B}',
    '\u{884C}',
    '\u{964D}',
    '\u{898B}',
    '\u{5ED3}',
    '\u{5140}',
    '\u{55C0}',
    '\u{585A}',
    '\u{6674}',
    '\u{51DE}',
    '\u{732A}',
    '\u{76CA}',
    '\u{793C}',
    '\u{795E}',
    '\u{7965}',
    '\u{798F}',
    '\u{9756}',
    '\u{7CBE}',
    '\u{7FBD}',
    '\u{8612}',
    '\u{8AF8}',
    '\u{9038}',
    '\u{90FD}',
    '\u{98EF}',
    '\u{98FC}',
    '\u{9928}',
    '\u{9DB4}',
    '\u{90DE}',
    '\u{96B7}',
    '\u{4FAE}',
    '\u{50E7}',
    '\u{514D}',
    '\u{52C9}',
    '\u{52E4}',
    '\u{5351}',
    '\u{559D}',
    '\u{5606}',
    '\u{5668}',
    '\u{5840}',
    '\u{58A8}',
    '\u{5C64}',
    '\u{5C6E}',
    '\u{6094}',
    '\u{6168}',
    '\u{618E}',
    '\u{61F2}',
    '\u{654F}',
    '\u{65E2}',
    '\u{6691}',
    '\u{6885}',
    '\u{6D77}',
    '\u{6E1A}',
    '\u{6F22}',
    '\u{716E}',
    '\u{722B}',
    '\u{7422}',
    '\u{7891}',
    '\u{793E}',
    '\u{7949}',
    '\u{7948}',
    '\u{7950}',
    '\u{7956}',
    '\u{795D}',
    '\u{798D}',
    '\u{798E}',
    '\u{7A40}',
    '\u{7A81}',
    '\u{7BC0}',
    '\u{7DF4}',
    '\u{7E09}',
    '\u{7E41}',
    '\u{7F72}',
    '\u{8005}',
    '\u{81ED}',
    '\u{8279}',
    '\u{8279}',
    '\u{8457}',
    '\u{8910}',
    '\u{8996}',
    '\u{8B01}',
    '\u{8B39}',
    '\u{8CD3}',
    '\u{8D08}',
    '\u{8FB6}',
    '\u{9038}',
    '\u{96E3}',
    '\u{97FF}',
    '\u{983B}',
    '\u{6075}',
    '\u{242EE}',
    '\u{8218}',
    '\u{4E26}',
    '\u{51B5}',
    '\u{5168}',
    '\u{4F80}',
    '\u{5145}',
    '\u{5180}',
    '\u{52C7}',
    '\u{52FA}',
    '\u{559D}',
    '\u{5555}',
    '\u{5599}',
    '\u{55E2}',
    '\u{585A}',
    '\u{58B3}',
    '\u{5944}',
    '\u{5954}',
    '\u{5A62}',
    '\u{5B28}',
    '\u{5ED2}',
    '\u{5ED9}',
    '\u{5F69}',
    '\u{5FAD}',
    '\u{60D8}',
    '\u{614E}',
    '\u{6108}',
    '\u{618E}',
    '\u{6160}',
    '\u{61F2}',
    '\u{6234}',
    '\u{63C4}',
    '\u{641C}',
    '\u{6452}',
    '\u{6556}',
    '\u{6674}',
    '\u{6717}',
    '\u{671B}',
    '\u{6756}',
    '\u{6B79}',
    '\u{6BBA}',
    '\u{6D41}',
    '\u{6EDB}',
    '\u{6ECB}',
    '\u{6F22}',
    '\u{701E}',
    '\u{716E}',
    '\u{77A7}',
    '\u{7235}',
    '\u{72AF}',
    '\u{732A}',
    '\u{7471}',
    '\u{7506}',
    '\u{753B}',
    '\u{761D}',
    '\u{761F}',
    '\u{76CA}',
    '\u{76DB}',
    '\u{76F4}',
    '\u{774A}',
    '\u{7740}',
    '\u{78CC}',
    '\u{7AB1}',
    '\u{7BC0}',
    '\u{7C7B}',
    '\u{7D5B}',
    '\u{7DF4}',
    '\u{7F3E}',
    '\u{8005}',
    '\u{8352}',
    '\u{83EF}',
    '\u{8779}',
    '\u{8941}',
    '\u{8986}',
    '\u{8996}',
    '\u{8ABF}',
    '\u{8AF8}',
    '\u{8ACB}',
    '\u{8B01}',
    '\u{8AFE}',
    '\u{8AED}',
    '\u{8B39}',
    '\u{8B8A}',
    '\u{8D08}',
    '\u{8F38}',
    '\u{9072}',
    '\u{9199}',
    '\u{9276}',
    '\u{967C}',
    '\u{96E3}',
    '\u{9756}',
    '\u{97DB}',
    '\u{97FF}',
    '\u{980B}',
    '\u{983B}',
    '\u{9B12}',
    '\u{9F9C}',
    '\u{2284A}',
    '\u{22844}',
    '\u{233D5}',
    '\u{3B9D}',
    '\u{4018}',
    '\u{4039}',
    '\u{25249}',
    '\u{25CD0}',
    '\u{27ED3}',
    '\u{9F43}',
    '\u{9F8E}',
    '\u{05D9}',
    '\u{05B4}',
    '\u{05F2}',
    '\u{05B7}',
    '\u{05E9}',
    '\u{05C1}',
    '\u{05E9}',
    '\u{05C2}',
    '\u{05E9}',
    '\u{05BC}',
    '\u{05C1}',
    '\u{05E9}',
    '\u{05BC}',
    '\u{05C2}',
    '\u{05D0}',
    '\u{05B7}',
    '\u{05D0}',
    '\u{05B8}',
    '\u{05D0}',
    '\u{05BC}',
    '\u{05D1}',
    '\u{05BC}',
    '\u{05D2}',
    '\u{05BC}',
    '\u{05D3}',
    '\u{05BC}',
    '\u{05D4}',
    '\u{05BC}',
    '\u{05D5}',
    '\u{05BC}',
    '\u{05D6}',
    '\u{05BC}',
    '\u{05D8}',
    '\u{05BC}',
    '\u{05D9}',
    '\u{05BC}',
    '\u{05DA}',
    '\u{05BC}',
    '\u{05DB}',
    '\u{05BC}',
    '\u{05DC}',
    '\u{05BC}',
    '\u{05DE}',
    '\u{05BC}',
    '\u{05E0}',
    '\u{05BC}',
    '\u{05E1}',
    '\u{05BC}',
    '\u{05E3}',
    '\u{05BC}',
    '\u{05E4}',
    '\u{05BC}',
    '\u{05E6}',
    '\u{05BC}',
    '\u{05E7}',
    '\u{05BC}',
    '\u{05E8}',
    '\u{05BC}',
    '\u{05E9}',
    '\u{05BC}',
    '\u{05EA}',
    '\u{05BC}',
    '\u{05D5}',
    '\u{05B9}',
    '\u{05D1}',
    '\u{05BF}',
    '\u{05DB}',
    '\u{05BF}',
    '\u{05E4}',
    '\u{05BF}',
    '\u{105D2}',
    '\u{0307}',
    '\u{105DA}',
    '\u{0307}',
    '\u{11099}',
    '\u{110BA}',
    '\u{1109B}',
    '\u{110BA}',
    '\u{110A5}',
    '\u{110BA}',
    '\u{11131}',
    '\u{11127}',
    '\u{11132}',
    '\u{11127}',
    '\u{11347}',
    '\u{1133E}',
    '\u{11347}',
    '\u{11357}',
    '\u{11382}',
    '\u{113C9}',
    '\u{11384}',
    '\u{113BB}',
    '\u{1138B}',
    '\u{113C2}',
    '\u{11390}',
    '\u{113C9}',
    '\u{113C2}',
    '\u{113C2}',
    '\u{113C2}',
    '\u{113B8}',
    '\u{113C2}',
    '\u{113C9}',
    '\u{114B9}',
    '\u{114BA}',
    '\u{114B9}',
    '\u{114B0}',
    '\u{114B9}',
    '\u{114BD}',
    '\u{115B8}',
    '\u{115AF}',
    '\u{115B9}',
    '\u{115AF}',
    '\u{11935}',
    '\u{11930}',
    '\u{1611E}',
    '\u{1611E}',
    '\u{1611E}',
    '\u{16129}',
    '\u{1611E}',
    '\u{1611F}',
    '\u{16129}',
    '\u{1611F}',
    '\u{1611E}',
    '\u{16120}',
    '\u{1611E}',
    '\u{1611E}',
    '\u{1611F}',
    '\u{1611E}',
    '\u{16129}',
    '\u{1611F}',
    '\u{1611E}',
    '\u{1611E}',
    '\u{16120}',
    '\u{16D67}',
    '\u{16D67}',
    '\u{16D63}',
    '\u{16D67}',
    '\u{16D63}',
    '\u{16D67}',
    '\u{16D67}',
    '\u{1D157}',
    '\u{1D165}',
    '\u{1D158}',
    '\u{1D165}',
    '\u{1D158}',
    '\u{1D165}',
    '\u{1D16E}',
    '\u{1D158}',
    '\u{1D165}',
    '\u{1D16F}',
    '\u{1D158}',
    '\u{1D165}',
    '\u{1D170}',
    '\u{1D158}',
    '\u{1D165}',
    '\u{1D171}',
    '\u{1D158}',
    '\u{1D165}',
    '\u{1D172}',
    '\u{1D1B9}',
    '\u{1D165}',
    '\u{1D1BA}',
    '\u{1D165}',
    '\u{1D1B9}',
    '\u{1D165}',
    '\u{1D16E}',
    '\u{1D1BA}',
    '\u{1D165}',
    '\u{1D16E}',
    '\u{1D1B9}',
    '\u{1D165}',
    '\u{1D16F}',
    '\u{1D1BA}',
    '\u{1D165}',
    '\u{1D16F}',
    '\u{4E3D}',
    '\u{4E38}',
    '\u{4E41}',
    '\u{20122}',
    '\u{4F60}',
    '\u{4FAE}',
    '\u{4FBB}',
    '\u{5002}',
    '\u{507A}',
    '\u{5099}',
    '\u{50E7}',
    '\u{50CF}',
    '\u{349E}',
    '\u{2063A}',
    '\u{514D}',
    '\u{5154}',
    '\u{5164}',
    '\u{5177}',
    '\u{2051C}',
    '\u{34B9}',
    '\u{5167}',
    '\u{518D}',
    '\u{2054B}',
    '\u{5197}',
    '\u{51A4}',
    '\u{4ECC}',
    '\u{51AC}',
    '\u{51B5}',
    '\u{291DF}',
    '\u{51F5}',
    '\u{5203}',
    '\u{34DF}',
    '\u{523B}',
    '\u{5246}',
    '\u{5272}',
    '\u{5277}',
    '\u{3515}',
    '\u{52C7}',
    '\u{52C9}',
    '\u{52E4}',
    '\u{52FA}',
    '\u{5305}',
    '\u{5306}',
    '\u{5317}',
    '\u{5349}',
    '\u{5351}',
    '\u{535A}',
    '\u{5373}',
    '\u{537D}',
    '\u{537F}',
    '\u{537F}',
    '\u{537F}',
    '\u{20A2C}',
    '\u{7070}',
    '\u{53CA}',
    '\u{53DF}',
    '\u{20B63}',
    '\u{53EB}',
    '\u{53F1}',
    '\u{5406}',
    '\u{549E}',
    '\u{5438}',
    '\u{5448}',
    '\u{5468}',
    '\u{54A2}',
    '\u{54F6}',
    '\u{5510}',
    '\u{5553}',
    '\u{5563}',
    '\u{5584}',
    '\u{5584}',
    '\u{5599}',
    '\u{55AB}',
    '\u{55B3}',
    '\u{55C2}',
    '\u{5716}',
    '\u{5606}',
    '\u{5717}',
    '\u{5651}',
    '\u{5674}',
    '\u{5207}',
    '\u{58EE}',
    '\u{57CE}',
    '\u{57F4}',
    '\u{580D}',
    '\u{578B}',
    '\u{5832}',
    '\u{5831}',
    '\u{58AC}',
    '\u{214E4}',
    '\u{58F2}',
    '\u{58F7}',
    '\u{5906}',
    '\u{591A}',
    '\u{5922}',
    '\u{5962}',
    '\u{216A8}',
    '\u{216EA}',
    '\u{59EC}',
    '\u{5A1B}',
    '\u{5A27}',
    '\u{59D8}',
    '\u{5A66}',
    '\u{36EE}',
    '\u{36FC}',
    '\u{5B08}',
    '\u{5B3E}',
    '\u{5B3E}',
    '\u{219C8}',
    '\u{5BC3}',
    '\u{5BD8}',
    '\u{5BE7}',
    '\u{5BF3}',
    '\u{21B18}',
    '\u{5BFF}',
    '\u{5C06}',
    '\u{5F53}',
    '\u{5C22}',
    '\u{3781}',
    '\u{5C60}',
    '\u{5C6E}',
    '\u{5CC0}',
    '\u{5C8D}',
    '\u{21DE4}',
    '\u{5D43}',
    '\u{21DE6}',
    '\u{5D6E}',
    '\u{5D6B}',
    '\u{5D7C}',
    '\u{5DE1}',
    '\u{5DE2}',
    '\u{382F}',
    '\u{5DFD}',
    '\u{5E28}',
    '\u{5E3D}',
    '\u{5E69}',
    '\u{3862}',
    '\u{22183}',
    '\u{387C}',
    '\u{5EB0}',
    '\u{5EB3}',
    '\u{5EB6}',
    '\u{5ECA}',
    '\u{2A392}',
    '\u{5EFE}',
    '\u{22331}',
    '\u{22331}',
    '\u{8201}',
    '\u{5F22}',
    '\u{5F22}',
    '\u{38C7}',
    '\u{232B8}',
    '\u{261DA}',
    '\u{5F62}',
    '\u{5F6B}',
    '\u{38E3}',
    '\u{5F9A}',
    '\u{5FCD}',
    '\u{5FD7}',
    '\u{5FF9}',
    '\u{6081}',
    '\u{393A}',
    '\u{391C}',
    '\u{6094}',
    '\u{226D4}',
    '\u{60C7}',
    '\u{6148}',
    '\u{614C}',
    '\u{614E}',
    '\u{614C}',
    '\u{617A}',
    '\u{618E}',
    '\u{61B2}',
    '\u{61A4}',
    '\u{61AF}',
    '\u{61DE}',
    '\u{61F2}',
    '\u{61F6}',
    '\u{6210}',
    '\u{621B}',
    '\u{625D}',
    '\u{62B1}',
    '\u{62D4}',
    '\u{6350}',
    '\u{22B0C}',
    '\u{633D}',
    '\u{62FC}',
    '\u{6368}',
    '\u{6383}',
    '\u{63E4}',
    '\u{22BF1}',
    '\u{6422}',
    '\u{63C5}',
    '\u{63A9}',
    '\u{3A2E}',
    '\u{6469}',
    '\u{647E}',
    '\u{649D}',
    '\u{6477}',
    '\u{3A6C}',
    '\u{654F}',
    '\u{656C}',
    '\u{2300A}',
    '\u{65E3}',
    '\u{66F8}',
    '\u{6649}',
    '\u{3B19}',
    '\u{6691}',
    '\u{3B08}',
    '\u{3AE4}',
    '\u{5192}',
    '\u{5195}',
    '\u{6700}',
    '\u{669C}',
    '\u{80AD}',
    '\u{43D9}',
    '\u{6717}',
    '\u{671B}',
    '\u{6721}',
    '\u{675E}',
    '\u{6753}',
    '\u{233C3}',
    '\u{3B49}',
    '\u{67FA}',
    '\u{6785}',
    '\u{6852}',
    '\u{6885}',
    '\u{2346D}',
    '\u{688E}',
    '\u{681F}',
    '\u{6914}',
    '\u{3B9D}',
    '\u{6942}',
    '\u{69A3}',
    '\u{69EA}',
    '\u{6AA8}',
    '\u{236A3}',
    '\u{6ADB}',
    '\u{3C18}',
    '\u{6B21}',
    '\u{238A7}',
    '\u{6B54}',
    '\u{3C4E}',
    '\u{6B72}',
    '\u{6B9F}',
    '\u{6BBA}',
    '\u{6BBB}',
    '\u{23A8D}',
    '\u{21D0B}',
    '\u{23AFA}',
    '\u{6C4E}',
    '\u{23CBC}',
    '\u{6CBF}',
    '\u{6CCD}',
    '\u{6C67}',
    '\u{6D16}',
    '\u{6D3E}',
    '\u{6D77}',
    '\u{6D41}',
    '\u{6D69}',
    '\u{6D78}',
    '\u{6D85}',
    '\u{23D1E}',
    '\u{6D34}',
    '\u{6E2F}',
    '\u{6E6E}',
    '\u{3D33}',
    '\u{6ECB}',
    '\u{6EC7}',
    '\u{23ED1}',
    '\u{6DF9}',
    '\u{6F6E}',
    '\u{23F5E}',
    '\u{23F8E}',
    '\u{6FC6}',
    '\u{7039}',
    '\u{701E}',
    '\u{701B}',
    '\u{3D96}',
    '\u{704A}',
    '\u{707D}',
    '\u{7077}',
    '\u{70AD}',
    '\u{20525}',
    '\u{7145}',
    '\u{24263}',
    '\u{719C}',
    '\u{243AB}',
    '\u{7228}',
    '\u{7235}',
    '\u{7250}',
    '\u{24608}',
    '\u{7280}',
    '\u{7295}',
    '\u{24735}',
    '\u{24814}',
    '\u{737A}',
    '\u{738B}',
    '\u{3EAC}',
    '\u{73A5}',
    '\u{3EB8}',
    '\u{3EB8}',
    '\u{7447}',
    '\u{745C}',
    '\u{7471}',
    '\u{7485}',
    '\u{74CA}',
    '\u{3F1B}',
    '\u{7524}',
    '\u{24C36}',
    '\u{753E}',
    '\u{24C92}',
    '\u{7570}',
    '\u{2219F}',
    '\u{7610}',
    '\u{24FA1}',
    '\u{24FB8}',
    '\u{25044}',
    '\u{3FFC}',
    '\u{4008}',
    '\u{76F4}',
    '\u{250F3}',
    '\u{250F2}',
    '\u{25119}',
    '\u{25133}',
    '\u{771E}',
    '\u{771F}',
    '\u{771F}',
    '\u{774A}',
    '\u{4039}',
    '\u{778B}',
    '\u{4046}',
    '\u{4096}',
    '\u{2541D}',
    '\u{784E}',
    '\u{788C}',
    '\u{78CC}',
    '\u{40E3}',
    '\u{25626}',
    '\u{7956}',
    '\u{2569A}',
    '\u{256C5}',
    '\u{798F}',
    '\u{79EB}',
    '\u{412F}',
    '\u{7A40}',
    '\u{7A4A}',
    '\u{7A4F}',
    '\u{2597C}',
    '\u{25AA7}',
    '\u{25AA7}',
    '\u{7AEE}',
    '\u{4202}',
    '\u{25BAB}',
    '\u{7BC6}',
    '\u{7BC9}',
    '\u{4227}',
    '\u{25C80}',
    '\u{7CD2}',
    '\u{42A0}',
    '\u{7CE8}',
    '\u{7CE3}',
    '\u{7D00}',
    '\u{25F86}',
    '\u{7D63}',
    '\u{4301}',
    '\u{7DC7}',
    '\u{7E02}',
    '\u{7E45}',
    '\u{4334}',
    '\u{26228}',
    '\u{26247}',
    '\u{4359}',
    '\u{262D9}',
    '\u{7F7A}',
    '\u{2633E}',
    '\u{7F95}',
    '\u{7FFA}',
    '\u{8005}',
    '\u{264DA}',
    '\u{26523}',
    '\u{8060}',
    '\u{265A8}',
    '\u{8070}',
    '\u{2335F}',
    '\u{43D5}',
    '\u{80B2}',
    '\u{8103}',
    '\u{440B}',
    '\u{813E}',
    '\u{5AB5}',
    '\u{267A7}',
    '\u{267B5}',
    '\u{23393}',
    '\u{2339C}',
    '\u{8201}',
    '\u{8204}',
    '\u{8F9E}',
    '\u{446B}',
    '\u{8291}',
    '\u{828B}',
    '\u{829D}',
    '\u{52B3}',
    '\u{82B1}',
    '\u{82B3}',
    '\u{82BD}',
    '\u{82E6}',
    '\u{26B3C}',
    '\u{82E5}',
    '\u{831D}',
    '\u{8363}',
    '\u{83AD}',
    '\u{8323}',
    '\u{83BD}',
    '\u{83E7}',
    '\u{8457}',
    '\u{8353}',
    '\u{83CA}',
    '\u{83CC}',
    '\u{83DC}',
    '\u{26C36}',
    '\u{26D6B}',
    '\u{26CD5}',
    '\u{452B}',
    '\u{84F1}',
    '\u{84F3}',
    '\u{8516}',
    '\u{273CA}',
    '\u{8564}',
    '\u{26F2C}',
    '\u{455D}',
    '\u{4561}',
    '\u{26FB1}',
    '\u{270D2}',
    '\u{456B}',
    '\u{8650}',
    '\u{865C}',
    '\u{8667}',
    '\u{8669}',
    '\u{86A9}',
    '\u{8688}',
    '\u{870E}',
    '\u{86E2}',
    '\u{8779}',
    '\u{8728}',
    '\u{876B}',
    '\u{8786}',
    '\u{45D7}',
    '\u{87E1}',
    '\u{8801}',
    '\u{45F9}',
    '\u{8860}',
    '\u{8863}',
    '\u{27667}',
    '\u{88D7}',
    '\u{88DE}',
    '\u{4635}',
    '\u{88FA}',
    '\u{34BB}',
    '\u{278AE}',
    '\u{27966}',
    '\u{46BE}',
    '\u{46C7}',
    '\u{8AA0}',
    '\u{8AED}',
    '\u{8B8A}',
    '\u{8C55}',
    '\u{27CA8}',
    '\u{8CAB}',
    '\u{8CC1}',
    '\u{8D1B}',
    '\u{8D77}',
    '\u{27F2F}',
    '\u{20804}',
    '\u{8DCB}',
    '\u{8DBC}',
    '\u{8DF0}',
    '\u{208DE}',
    '\u{8ED4}',
    '\u{8F38}',
    '\u{285D2}',
    '\u{285ED}',
    '\u{9094}',
    '\u{90F1}',
    '\u{9111}',
    '\u{2872E}',
    '\u{911B}',
    '\u{9238}',
    '\u{92D7}',
    '\u{92D8}',
    '\u{927C}',
    '\u{93F9}',
    '\u{9415}',
    '\u{28BFA}',
    '\u{958B}',
    '\u{4995}',
    '\u{95B7}',
    '\u{28D77}',
    '\u{49E6}',
    '\u{96C3}',
    '\u{5DB2}',
    '\u{9723}',
    '\u{29145}',
    '\u{2921A}',
    '\u{4A6E}',
    '\u{4A76}',
    '\u{97E0}',
    '\u{2940A}',
    '\u{4AB2}',
    '\u{29496}',
    '\u{980B}',
    '\u{980B}',
    '\u{9829}',
    '\u{295B6}',
    '\u{98E2}',
    '\u{4B33}',
    '\u{9929}',
    '\u{99A7}',
    '\u{99C2}',
    '\u{99FE}',
    '\u{4BCE}',
    '\u{29B30}',
    '\u{9B12}',
    '\u{9C40}',
    '\u{9CFD}',
    '\u{4CCE}',
    '\u{4CED}',
    '\u{9D67}',
    '\u{2A0CE}',
    '\u{4CF8}',
    '\u{2A105}',
    '\u{2A20E}',
    '\u{2A291}',
    '\u{9EBB}',
    '\u{4D56}',
    '\u{9EF9}',
    '\u{9EFE}',
    '\u{9F05}',
    '\u{9F0F}',
    '\u{9F16}',
    '\u{9F3B}',
    '\u{2A600}',
];

pub(crate) const CANONICAL_DECOMPOSED_SALT: &[u16] = &[
    0x571, 0x003, 0x000, 0x000, 0x03D, 0x160, 0x000, 0x27F, 0x0F7, 0x1B1, 0x000, 0x002, 0x004,
    0x033, 0x136, 0x017, 0x001, 0x000, 0x193, 0x1EE, 0x000, 0x006, 0x000, 0x054, 0x034, 0x002,
    0x054, 0x248, 0x008, 0x006, 0x003, 0x000, 0x000, 0x000, 0x064, 0x001, 0x000, 0x000, 0x002,
    0x005, 0x000, 0x000, 0x01E, 0x035, 0x009, 0x07D, 0x004, 0x012, 0x058, 0x000, 0x000, 0x000,
    0x002, 0x04C, 0x000, 0x000, 0x006, 0x068, 0x000, 0x006, 0x000, 0x00A, 0x006, 0x001, 0x0F6,
    0x000, 0x000, 0x002, 0x046, 0x000, 0x001, 0x000, 0x003, 0x000, 0x140, 0x000, 0x00A, 0x0DF,
    0x001, 0x000, 0x003, 0x004, 0x008, 0x005, 0x004, 0x014, 0x030, 0x05B, 0x000, 0x018, 0x0A8,
    0x000, 0x048, 0x004, 0x000, 0x005, 0x000, 0x042, 0x000, 0x068, 0x000, 0x000, 0x02D, 0x000,
    0x000, 0x000, 0x032, 0x006, 0x000, 0x01F, 0x061, 0x000, 0x00D, 0x000, 0x013, 0x005, 0x027,
    0x002, 0x002, 0x002, 0x002, 0x013, 0x037, 0x010, 0x000, 0x019, 0x006, 0x000, 0x02C, 0x05F,
    0x05F, 0x000, 0x001, 0x000, 0x005, 0x000, 0x000, 0x005, 0x006, 0x022, 0x03C, 0x010, 0x000,
    0x000, 0x000, 0x012, 0x002, 0x004, 0x051, 0x000, 0x000, 0x002, 0x032, 0x006, 0x001, 0x000,
    0x011, 0x005, 0x004, 0x075, 0x032, 0x00A, 0x000, 0x016, 0x00E, 0x001, 0x00F, 0x027, 0x000,
    0x005, 0x001, 0x00A, 0x007, 0x010, 0x004, 0x001, 0x000, 0x007, 0x00F, 0x002, 0x005, 0x05E,
    0x000, 0x048, 0x017, 0x000, 0x000, 0x004, 0x000, 0x002, 0x03C, 0x01C, 0x00B, 0x000, 0x004,
    0x023, 0x001, 0x00C, 0x00E, 0x005, 0x01C, 0x000, 0x020, 0x001, 0x003, 0x000, 0x007, 0x008,
    0x004, 0x000, 0x000, 0x02D, 0x008, 0x000, 0x000, 0x033, 0x013, 0x002, 0x000, 0x003, 0x000,
    0x006, 0x03C, 0x020, 0x000, 0x009, 0x000, 0x025, 0x012, 0x009, 0x000, 0x000, 0x03A, 0x022,
    0x000, 0x002, 0x001, 0x01E, 0x009, 0x002, 0x002, 0x003, 0x000, 0x000, 0x000, 0x000, 0x000,
    0x000, 0x00B, 0x001, 0x001, 0x01B, 0x004, 0x007, 0x00E, 0x003, 0x000, 0x003, 0x007, 0x000,
    0x002, 0x002, 0x026, 0x000, 0x008, 0x003, 0x004, 0x002, 0x002, 0x008, 0x009, 0x000, 0x001,
    0x006, 0x001, 0x003, 0x002, 0x001, 0x008, 0x000, 0x004, 0x009, 0x00C, 0x013, 0x000, 0x000,
    0x005, 0x000, 0x00A, 0x000, 0x014, 0x000, 0x014, 0x000, 0x001, 0x000, 0x000, 0x000, 0x01C,
    0x016, 0x000, 0x000, 0x002, 0x004, 0x000, 0x000, 0x000, 0x00A, 0x000, 0x000, 0x007, 0x002,
    0x000, 0x000, 0x004, 0x001, 0x00A, 0x000, 0x000, 0x009, 0x005, 0x029, 0x000, 0x000, 0x001,
    0x020, 0x003, 0x006, 0x002, 0x001, 0x00E, 0x013, 0x001, 0x024, 0x000, 0x001, 0x001, 0x003,
    0x004, 0x002, 0x002, 0x00A, 0x006, 0x008, 0x000, 0x00A, 0x000, 0x004, 0x000, 0x00D, 0x00B,
    0x000, 0x013, 0x009, 0x000, 0x000, 0x012, 0x000, 0x006, 0x000, 0x000, 0x002, 0x000, 0x000,
    0x00C, 0x000, 0x000, 0x000, 0x000, 0x000, 0x002, 0x000, 0x013, 0x002, 0x000, 0x002, 0x000,
    0x000, 0x000, 0x000, 0x008, 0x000, 0x000, 0x001, 0x001, 0x004, 0x010, 0x000, 0x00B, 0x00B,
    0x002, 0x001, 0x000, 0x001, 0x001, 0x002, 0x002, 0x001, 0x001, 0x002, 0x004, 0x008, 0x000,
    0x000, 0x001, 0x029, 0x001, 0x00E, 0x000, 0x000, 0x00E, 0x000, 0x00B, 0x000, 0x017, 0x005,
    0x000, 0x015, 0x008, 0x006, 0x008, 0x000, 0x002, 0x00C, 0x000, 0x000, 0x000, 0x008, 0x000,
    0x000, 0x000, 0x000, 0x00C, 0x000, 0x000, 0x004, 0x000, 0x000, 0x000, 0x00F, 0x000, 0x000,
    0x001, 0x007, 0x000, 0x011, 0x000, 0x00D, 0x008, 0x00E, 0x00B, 0x000, 0x002, 0x001, 0x000,
    0x004, 0x005, 0x003, 0x003, 0x001, 0x003, 0x008, 0x001, 0x01A, 0x001, 0x005, 0x001, 0x005,
    0x006, 0x000, 0x001, 0x000, 0x000, 0x000, 0x010, 0x00F, 0x002, 0x004, 0x006, 0x002, 0x002,
    0x00C, 0x017, 0x003, 0x000, 0x003, 0x000, 0x001, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
    0x000, 0x000, 0x022, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x01C, 0x014, 0x001, 0x000,
    0x002, 0x004, 0x00F, 0x000, 0x007, 0x001, 0x000, 0x002, 0x001, 0x000, 0x000, 0x000, 0x006,
    0x009, 0x003, 0x02C, 0x009, 0x005, 0x000, 0x000, 0x00B, 0x008, 0x01D, 0x000, 0x001, 0x000,
    0x000, 0x000, 0x001, 0x008, 0x003, 0x005, 0x000, 0x004, 0x000, 0x000, 0x003, 0x00A, 0x003,
    0x000, 0x005, 0x002, 0x004, 0x00A, 0x000, 0x000, 0x003, 0x002, 0x000, 0x002, 0x000, 0x00E,
    0x000, 0x000, 0x005, 0x000, 0x009, 0x017, 0x003, 0x004, 0x000, 0x001, 0x004, 0x000, 0x000,
    0x007, 0x015, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x009, 0x003, 0x001, 0x001,
    0x001, 0x006, 0x00A, 0x000, 0x000, 0x006, 0x000, 0x001, 0x000, 0x000, 0x002, 0x000, 0x000,
    0x001, 0x001, 0x002, 0x000, 0x000, 0x000, 0x003, 0x003, 0x012, 0x001, 0x006, 0x004, 0x007,
    0x000, 0x001, 0x000, 0x02E, 0x002, 0x001, 0x00B, 0x008, 0x000, 0x005, 0x000, 0x002, 0x004,
    0x009, 0x000, 0x000, 0x008, 0x005, 0x003, 0x001, 0x006, 0x000, 0x000, 0x003, 0x000, 0x003,
    0x006, 0x006, 0x000, 0x003, 0x007, 0x000, 0x006, 0x001, 0x000, 0x000, 0x006, 0x004, 0x000,
    0x000, 0x001, 0x000, 0x002, 0x000, 0x005, 0x000, 0x022, 0x014, 0x006, 0x002, 0x000, 0x000,
    0x000, 0x000, 0x00C, 0x000, 0x00A, 0x001, 0x002, 0x007, 0x000, 0x002, 0x001, 0x001, 0x004,
    0x000, 0x000, 0x012, 0x002, 0x001, 0x000, 0x000, 0x000, 0x003, 0x003, 0x000, 0x005, 0x000,
    0x000, 0x003, 0x000, 0x003, 0x000, 0x006, 0x000, 0x005, 0x001, 0x000, 0x008, 0x004, 0x000,
    0x009, 0x001, 0x00A, 0x00E, 0x000, 0x005, 0x00E, 0x007, 0x000, 0x000, 0x008, 0x000, 0x000,
    0x000, 0x000, 0x004, 0x000, 0x001, 0x001, 0x000, 0x000, 0x002, 0x000, 0x001, 0x000, 0x010,
    0x016, 0x001, 0x001, 0x000, 0x000, 0x000, 0x011, 0x000, 0x000, 0x000, 0x001, 0x000, 0x000,
    0x000, 0x002, 0x000, 0x001, 0x006, 0x002, 0x01A, 0x000, 0x00B, 0x004, 0x000, 0x000, 0x003,
    0x006, 0x001, 0x009, 0x00F, 0x002, 0x005, 0x001, 0x01A, 0x000, 0x000, 0x000, 0x001, 0x002,
    0x002, 0x00F, 0x000, 0x000, 0x00A, 0x002, 0x003, 0x002, 0x007, 0x006, 0x000, 0x007, 0x004,
    0x00C, 0x000, 0x000, 0x001, 0x007, 0x000, 0x000, 0x000, 0x000, 0x000, 0x004, 0x000, 0x000,
    0x000, 0x002, 0x000, 0x000, 0x000, 0x00A, 0x006, 0x000, 0x002, 0x000, 0x000, 0x000, 0x00D,
    0x000, 0x003, 0x001, 0x00A, 0x000, 0x00C, 0x000, 0x001, 0x000, 0x007, 0x003, 0x002, 0x001,
    0x002, 0x001, 0x007, 0x003, 0x002, 0x001, 0x004, 0x001, 0x000, 0x000, 0x008, 0x006, 0x000,
    0x000, 0x001, 0x00D, 0x004, 0x001, 0x002, 0x001, 0x004, 0x000, 0x000, 0x000, 0x007, 0x002,
    0x000, 0x000, 0x000, 0x000, 0x013, 0x000, 0x000, 0x000, 0x000, 0x003, 0x011, 0x001, 0x001,
    0x003, 0x006, 0x000, 0x006, 0x003, 0x001, 0x000, 0x000, 0x000, 0x00B, 0x000, 0x004, 0x006,
    0x000, 0x000, 0x005, 0x000, 0x002, 0x000, 0x001, 0x001, 0x005, 0x001, 0x007, 0x005, 0x000,
    0x001, 0x001, 0x000, 0x001, 0x001, 0x007, 0x009, 0x001, 0x00C, 0x004, 0x002, 0x001, 0x000,
    0x005, 0x000, 0x000, 0x001, 0x002, 0x001, 0x008, 0x005, 0x00B, 0x002, 0x000, 0x007, 0x001,
    0x004, 0x016, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x016, 0x000,
    0x000, 0x00E, 0x000, 0x000, 0x002, 0x004, 0x000, 0x000, 0x002, 0x000, 0x004, 0x006, 0x001,
    0x000, 0x000, 0x000, 0x00C, 0x007, 0x009, 0x004, 0x003, 0x001, 0x001, 0x009, 0x00D, 0x001,
    0x002, 0x003, 0x000, 0x004, 0x004, 0x004, 0x002, 0x000, 0x001, 0x00B, 0x000, 0x012, 0x000,
    0x003, 0x003, 0x001, 0x001, 0x001, 0x00E, 0x000, 0x001, 0x001, 0x004, 0x001, 0x002, 0x000,
    0x000, 0x000, 0x001, 0x000, 0x001, 0x000, 0x000, 0x000, 0x000, 0x013, 0x000, 0x000, 0x000,
    0x000, 0x003, 0x000, 0x000, 0x000, 0x009, 0x000, 0x001, 0x007, 0x000, 0x002, 0x000, 0x00C,
    0x001, 0x003, 0x000, 0x001, 0x000, 0x005, 0x001, 0x000, 0x001, 0x003, 0x002, 0x009, 0x001,
    0x000, 0x008, 0x001, 0x005, 0x002, 0x000, 0x004, 0x000, 0x001, 0x005, 0x000, 0x008, 0x003,
    0x000, 0x004, 0x000, 0x000, 0x006, 0x003, 0x003, 0x002, 0x000, 0x002, 0x000, 0x002, 0x002,
    0x008, 0x000, 0x00A, 0x004, 0x012, 0x006, 0x002, 0x003, 0x002, 0x000, 0x001, 0x000, 0x000,
    0x000, 0x007, 0x001, 0x006, 0x000, 0x001, 0x005, 0x00B, 0x000, 0x00D, 0x012, 0x005, 0x002,
    0x004, 0x000, 0x005, 0x00B, 0x000, 0x007, 0x004, 0x001, 0x003, 0x008, 0x003, 0x002, 0x005,
    0x001, 0x000, 0x002, 0x002, 0x000, 0x000, 0x001, 0x002, 0x000, 0x001, 0x000, 0x000, 0x001,
    0x008, 0x003, 0x000, 0x000, 0x000, 0x000, 0x002, 0x008, 0x000, 0x002, 0x000, 0x001, 0x00E,
    0x000, 0x000, 0x003, 0x002, 0x006, 0x000, 0x001, 0x008, 0x002, 0x005, 0x000, 0x001, 0x001,
    0x007, 0x006, 0x001, 0x000, 0x000, 0x000, 0x002, 0x000, 0x000, 0x002, 0x001, 0x001, 0x005,
    0x000, 0x003, 0x009, 0x002, 0x000, 0x001, 0x000, 0x009, 0x001, 0x001, 0x002, 0x001, 0x002,
    0x003, 0x002, 0x000, 0x000, 0x000, 0x006, 0x001, 0x000, 0x001, 0x006, 0x000, 0x000, 0x000,
    0x000, 0x001, 0x000, 0x000, 0x001, 0x001, 0x000, 0x000, 0x001, 0x000, 0x000, 0x000, 0x001,
    0x014, 0x000, 0x000, 0x000, 0x001, 0x000, 0x006, 0x001, 0x000, 0x000, 0x012, 0x000, 0x004,
    0x012, 0x003, 0x004, 0x002, 0x000, 0x000, 0x000, 0x005, 0x006, 0x000, 0x001, 0x001, 0x000,
    0x000, 0x006, 0x002, 0x004, 0x004, 0x002, 0x000, 0x000, 0x002, 0x001, 0x001, 0x000, 0x001,
    0x00B, 0x000, 0x006, 0x000, 0x000, 0x000, 0x002, 0x001, 0x009, 0x001, 0x002, 0x010, 0x001,
    0x002, 0x002, 0x001, 0x000, 0x001, 0x00F, 0x009, 0x001, 0x001, 0x000, 0x000, 0x001, 0x001,
    0x001, 0x000, 0x000, 0x000, 0x002, 0x000, 0x002, 0x000, 0x000, 0x000, 0x003, 0x001, 0x007,
    0x00F, 0x005, 0x005, 0x000, 0x000, 0x000, 0x001, 0x004, 0x000, 0x002, 0x004, 0x003, 0x001,
    0x001, 0x002, 0x004, 0x001, 0x002, 0x001, 0x002, 0x002, 0x009, 0x000, 0x001, 0x000, 0x005,
    0x00B, 0x001, 0x000, 0x002, 0x00B, 0x000, 0x004, 0x000, 0x001, 0x001, 0x001, 0x000, 0x009,
    0x002, 0x005, 0x000, 0x004, 0x003, 0x002, 0x001, 0x001, 0x002, 0x000, 0x006, 0x00A, 0x000,
    0x002, 0x001, 0x009, 0x001, 0x001, 0x001, 0x008, 0x001, 0x002, 0x001, 0x001, 0x000, 0x001,
    0x003, 0x001, 0x001, 0x001, 0x003, 0x001, 0x005, 0x001, 0x003, 0x001, 0x000, 0x000, 0x006,
    0x000, 0x004, 0x001, 0x003, 0x001, 0x003, 0x000, 0x001, 0x000, 0x000, 0x000, 0x000, 0x000,
    0x000, 0x000, 0x000, 0x00B, 0x000, 0x000, 0x000, 0x000, 0x000, 0x003, 0x006, 0x000, 0x000,
    0x002, 0x003, 0x003, 0x002, 0x002, 0x000, 0x004, 0x002, 0x000, 0x001, 0x001, 0x00A, 0x003,
    0x000, 0x003, 0x004, 0x001, 0x001, 0x003, 0x000, 0x000, 0x004, 0x004, 0x001, 0x002, 0x005,
    0x00C, 0x001, 0x000, 0x007, 0x002, 0x001, 0x002, 0x005, 0x001, 0x000, 0x004, 0x001, 0x000,
    0x000, 0x001, 0x000, 0x000, 0x00B, 0x00D, 0x002, 0x003, 0x000, 0x000, 0x000, 0x000, 0x005,
    0x005, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x006, 0x002, 0x002,
    0x002, 0x001, 0x001, 0x001, 0x000, 0x000, 0x000, 0x001, 0x000, 0x001, 0x00B, 0x001, 0x001,
    0x001, 0x002, 0x005, 0x001, 0x001, 0x003, 0x004, 0x001, 0x002, 0x002, 0x008, 0x000, 0x001,
    0x004, 0x003, 0x003, 0x001, 0x008, 0x001, 0x008, 0x001, 0x000, 0x004, 0x008, 0x000, 0x002,
    0x003, 0x003, 0x000, 0x000, 0x002, 0x001, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
    0x004, 0x000, 0x000, 0x000, 0x00A, 0x000, 0x001, 0x000, 0x000, 0x000, 0x001, 0x003, 0x009,
    0x000, 0x002, 0x001, 0x00A, 0x000, 0x001, 0x000, 0x000, 0x003, 0x000, 0x001, 0x001, 0x000,
    0x009, 0x007, 0x001, 0x002, 0x008, 0x001, 0x005, 0x003, 0x002, 0x001, 0x001, 0x002, 0x002,
    0x001, 0x001, 0x001, 0x005, 0x000, 0x000, 0x001, 0x000, 0x00A, 0x003, 0x000, 0x000, 0x001,
    0x000, 0x00C, 0x000, 0x007, 0x003, 0x001, 0x000, 0x000, 0x000, 0x000, 0x000, 0x002, 0x000,
    0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x001, 0x000, 0x000, 0x003,
    0x001, 0x000, 0x001, 0x004, 0x00F, 0x000, 0x001, 0x000, 0x001, 0x000, 0x000, 0x000, 0x008,
    0x000, 0x002, 0x006, 0x001, 0x000, 0x004, 0x002, 0x000, 0x001, 0x004, 0x000, 0x002, 0x002,
    0x002, 0x001, 0x000, 0x000, 0x002, 0x001, 0x000, 0x003, 0x001, 0x000, 0x001, 0x000, 0x001,
    0x001, 0x002, 0x002, 0x002, 0x00A, 0x001, 0x001, 0x001, 0x001, 0x002, 0x002, 0x000, 0x001,
    0x000, 0x000, 0x000, 0x000, 0x001, 0x000, 0x002, 0x008, 0x001, 0x002, 0x006, 0x001, 0x000,
    0x002, 0x001, 0x000, 0x000, 0x000, 0x001, 0x002, 0x001, 0x004, 0x004, 0x001, 0x000, 0x005,
    0x001, 0x001, 0x001, 0x000, 0x002, 0x001, 0x000, 0x000, 0x000, 0x002, 0x000, 0x001, 0x000,
    0x000, 0x001, 0x004, 0x000, 0x009, 0x002, 0x00C, 0x008, 0x000, 0x001, 0x000, 0x004, 0x000,
    0x000, 0x001, 0x003, 0x004, 0x002, 0x000, 0x001, 0x003, 0x004, 0x000, 0x001, 0x000, 0x007,
    0x002, 0x001, 0x004, 0x000, 0x004, 0x000, 0x000, 0x000, 0x000, 0x000, 0x009, 0x001, 0x001,
    0x002, 0x000, 0x004, 0x001, 0x001, 0x001, 0x000, 0x001, 0x001, 0x001, 0x001, 0x000, 0x000,
    0x001, 0x001, 0x003, 0x001, 0x001, 0x001, 0x002, 0x000, 0x003, 0x001, 0x000, 0x002, 0x000,
    0x004, 0x001, 0x000, 0x000, 0x000, 0x001, 0x007, 0x000, 0x000, 0x000, 0x000, 0x004, 0x000,
    0x001, 0x007, 0x000, 0x000, 0x000, 0x001, 0x004, 0x001, 0x000, 0x004, 0x002, 0x002, 0x001,
    0x000, 0x001, 0x001, 0x001, 0x002, 0x001, 0x000, 0x007, 0x000, 0x000, 0x006, 0x000, 0x003,
    0x002, 0x002, 0x001, 0x000, 0x000, 0x002, 0x000, 0x001, 0x003, 0x005, 0x001, 0x001, 0x000,
    0x000, 0x000, 0x000, 0x000, 0x001, 0x006, 0x001, 0x001, 0x003, 0x009, 0x000, 0x001, 0x001,
    0x000, 0x006, 0x000, 0x003, 0x001, 0x002, 0x000, 0x001, 0x002, 0x005, 0x005, 0x002, 0x000,
    0x001, 0x004, 0x000, 0x001, 0x001, 0x001, 0x001, 0x000, 0x001, 0x000, 0x000, 0x000, 0x000,
    0x002, 0x000, 0x000, 0x001, 0x002, 0x001, 0x000, 0x000, 0x002, 0x000, 0x001, 0x006, 0x006,
    0x002, 0x002, 0x000, 0x003, 0x002, 0x003, 0x001, 0x001, 0x002, 0x001, 0x002, 0x00B, 0x000,
    0x001, 0x000, 0x001, 0x002, 0x002, 0x004, 0x000, 0x000, 0x000, 0x000, 0x000, 0x002, 0x000,
    0x000, 0x000, 0x003, 0x000, 0x000, 0x001, 0x006, 0x000, 0x002, 0x001, 0x000, 0x003, 0x004,
    0x000, 0x003, 0x000, 0x001, 0x004, 0x001, 0x003, 0x002, 0x000, 0x000, 0x002, 0x001, 0x000,
    0x001, 0x001, 0x001, 0x005, 0x006, 0x004, 0x000, 0x000, 0x000, 0x002, 0x001, 0x000, 0x001,
    0x001, 0x004, 0x001, 0x001, 0x009, 0x000, 0x002, 0x000, 0x002, 0x003, 0x005, 0x002, 0x000,
    0x000, 0x000, 0x000, 0x000, 0x002, 0x000, 0x000, 0x000, 0x000, 0x001, 0x000, 0x001, 0x003,
    0x000, 0x000, 0x000, 0x000, 0x001, 0x002, 0x007, 0x001, 0x000, 0x000, 0x000, 0x001, 0x000,
    0x000, 0x00A, 0x001, 0x000, 0x001, 0x010, 0x002, 0x008, 0x001, 0x001, 0x002, 0x001, 0x002,
    0x001, 0x000, 0x003, 0x002, 0x004, 0x000, 0x002, 0x002, 0x000, 0x001, 0x002, 0x001, 0x001,
    0x001, 0x001, 0x000, 0x000, 0x000, 0x006, 0x002, 0x005, 0x000, 0x000, 0x004, 0x004, 0x001,
    0x005, 0x000, 0x005, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x001, 0x000, 0x001, 0x000,
    0x005, 0x000, 0x000, 0x000, 0x005, 0x002, 0x001, 0x003, 0x009, 0x001, 0x003, 0x000, 0x000,
    0x002, 0x000, 0x001, 0x001, 0x004, 0x002, 0x000, 0x008, 0x002, 0x001, 0x006, 0x000, 0x002,
    0x002, 0x003, 0x000, 0x003, 0x001, 0x001, 0x002, 0x002, 0x000, 0x003, 0x001, 0x000, 0x000,
    0x000, 0x002, 0x002, 0x000, 0x002, 0x005, 0x001, 0x000, 0x000, 0x000, 0x002, 0x002, 0x001,
    0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x001, 0x000, 0x000, 0x000,
    0x000, 0x001, 0x000, 0x007, 0x001, 0x000, 0x002, 0x002, 0x000, 0x001, 0x000, 0x002, 0x000,
    0x006, 0x002, 0x001, 0x008, 0x000, 0x002, 0x002, 0x001, 0x004, 0x001, 0x000, 0x001, 0x001,
    0x002, 0x009, 0x001, 0x001, 0x001, 0x004, 0x001, 0x005, 0x002, 0x001, 0x001, 0x004, 0x003,
    0x000, 0x000, 0x001, 0x000, 0x001, 0x001, 0x000, 0x001, 0x000, 0x001, 0x001, 0x000, 0x004,
    0x004,
];
pub(crate) const CANONICAL_DECOMPOSED_KV: &[(u32, (u16, u16))] = &[
    (0x2F93B, (0xC97, 0x1)),
    (0x2F869, (0xBC5, 0x1)),
    (0x0F93E, (0x91F, 0x1)),
    (0x01F2E, (0x60A, 0x3)),
    (0x2F90A, (0xC66, 0x1)),
    (0x0FACB, (0xA9E, 0x1)),
    (0x0FA87, (0xA5A, 0x1)),
    (0x2F95B, (0xCB7, 0x1)),
    (0x0F965, (0x946, 0x1)),
    (0x2F8FB, (0xC57, 0x1)),
    (0x2F83A, (0xB96, 0x1)),
    (0x0095B, (0x2CA, 0x2)),
    (0x01FAF, (0x775, 0x4)),
    (0x2F92C, (0xC88, 0x1)),
    (0x01E88, (0x482, 0x2)),
    (0x009CB, (0x2D4, 0x2)),
    (0x01F0A, (0x5B2, 0x3)),
    (0x00229, (0x1F2, 0x2)),
    (0x0FA8B, (0xA5E, 0x1)),
    (0x2F8FD, (0xC59, 0x1)),
    (0x2F9AD, (0xD09, 0x1)),
    (0x01E7A, (0x464, 0x3)),
    (0x0F994, (0x975, 0x1)),
    (0x2F9EF, (0xD4B, 0x1)),
    (0x2F8CE, (0xC2A, 0x1)),
    (0x003AF, (0x233, 0x2)),
    (0x00211, (0x1D2, 0x2)),
    (0x0F9C8, (0x9A9, 0x1)),
    (0x0FA95, (0xA68, 0x1)),
    (0x2F9C0, (0xD1C, 0x1)),
    (0x01EA9, (0x4BF, 0x3)),
    (0x000F5, (0x05A, 0x2)),
    (0x2F833, (0xB8F, 0x1)),
    (0x0F94A, (0x92B, 0x1)),
    (0x0F96C, (0x94D, 0x1)),
    (0x0FA3E, (0xA13, 0x1)),
    (0x0FA5E, (0xA33, 0x1)),
    (0x01E72, (0x452, 0x2)),
    (0x0FA1E, (0x9FA, 0x1)),
    (0x0015F, (0x106, 0x2)),
    (0x01F64, (0x687, 0x3)),
    (0x01F07, (0x5AB, 0x3)),
    (0x01E87, (0x480, 0x2)),
    (0x0FA86, (0xA59, 0x1)),
    (0x0F92F, (0x910, 0x1)),
    (0x2F8DD, (0xC39, 0x1)),
    (0x2FA17, (0xD73, 0x1)),
    (0x00F73, (0x324, 0x2)),
    (0x01ED0, (0x526, 0x3)),
    (0x0F9CA, (0x9AB, 0x1)),
    (0x113C8, (0xB11, 0x2)),
    (0x2F83F, (0xB9B, 0x1)),
    (0x2F999, (0xCF5, 0x1)),
    (0x2F9F6, (0xD52, 0x1)),
    (0x01FC2, (0x797, 0x3)),
    (0x0FABC, (0xA8F, 0x1)),
    (0x01FDA, (0x7C7, 0x2)),
    (0x2F9B9, (0xD15, 0x1)),
    (0x0F9F5, (0x9D6, 0x1)),
    (0x01E73, (0x454, 0x2)),
    (0x0FA9D, (0xA70, 0x1)),
    (0x01E29, (0x3AC, 0x2)),
    (0x0FA5F, (0xA34, 0x1)),
    (0x2F849, (0xBA5, 0x1)),
    (0x00F43, (0x318, 0x2)),
    (0x01EA2, (0x4AC, 0x2)),
    (0x0F99C, (0x97D, 0x1)),
    (0x00129, (0x0B4, 0x2)),
    (0x01F85, (0x6D7, 0x4)),
    (0x2F8C0, (0xC1C, 0x1)),
    (0x01E93, (0x498, 0x2)),
    (0x02280, (0x845, 0x2)),
    (0x2F821, (0xB7D, 0x1)),
    (0x0FA50, (0xA25, 0x1)),
    (0x03077, (0x895, 0x2)),
    (0x001FD, (0x1AA, 0x2)),
    (0x00230, (0x204, 0x3)),
    (0x0016D, (0x11E, 0x2)),
    (0x0F9A2, (0x983, 0x1)),
    (0x01EA8, (0x4BC, 0x3)),
    (0x1D161, (0xB40, 0x3)),
    (0x0FA94, (0xA67, 0x1)),
    (0x01F1A, (0x5D8, 0x3)),
    (0x001A1, (0x144, 0x2)),
    (0x2F922, (0xC7E, 0x1)),
    (0x01FF9, (0x802, 0x2)),
    (0x0F93D, (0x91E, 0x1)),
    (0x030AC, (0x8A3, 0x2)),
    (0x0F9E9, (0x9CA, 0x1)),
    (0x01E89, (0x484, 0x2)),
    (0x01F35, (0x61D, 0x3)),
    (0x0FA2F, (0xA04, 0x1)),
    (0x0F90A, (0x8EB, 0x1)),
    (0x0F9FC, (0x9DD, 0x1)),
    (0x2F891, (0xBED, 0x1)),
    (0x0307D, (0x89D, 0x2)),
    (0x01FA5, (0x74F, 0x4)),
    (0x00173, (0x12A, 0x2)),
    (0x0FB49, (0xAE7, 0x2)),
    (0x0FACA, (0xA9D, 0x1)),
    (0x0F97B, (0x95C, 0x1)),
    (0x2F9FD, (0xD59, 0x1)),
    (0x2F90B, (0xC67, 0x1)),
    (0x0F9A3, (0x984, 0x1)),
    (0x01E2A, (0x3AE, 0x2)),
    (0x01FBB, (0x790, 0x2)),
    (0x2F9A0, (0xCFC, 0x1)),
    (0x0F924, (0x905, 0x1)),
    (0x01E7B, (0x467, 0x3)),
    (0x2F8CB, (0xC27, 0x1)),
    (0x2F8F6, (0xC52, 0x1)),
    (0x004F1, (0x2A0, 0x2)),
    (0x01FD0, (0x7B4, 0x2)),
    (0x01EF5, (0x58E, 0x2)),
    (0x00146, (0x0DE, 0x2)),
    (0x01E2E, (0x3B6, 0x3)),
    (0x0F95E, (0x93F, 0x1)),
    (0x0F916, (0x8F7, 0x1)),
    (0x0FA44, (0xA19, 0x1)),
    (0x0FA16, (0x9F2, 0x1)),
    (0x01F1C, (0x5DE, 0x3)),
    (0x105E4, (0xAF5, 0x2)),
    (0x2F94D, (0xCA9, 0x1)),
    (0x0FAB9, (0xA8C, 0x1)),
    (0x0F907, (0x8E8, 0x1)),
    (0x0305E, (0x87F, 0x2)),
    (0x01E0D, (0x36E, 0x2)),
    (0x01F4A, (0x650, 0x3)),
    (0x0F9F9, (0x9DA, 0x1)),
    (0x2F9C7, (0xD23, 0x1)),
    (0x0F94B, (0x92C, 0x1)),
    (0x2F87E, (0xBDA, 0x1)),
    (0x00D4C, (0x30D, 0x2)),
    (0x0F9EC, (0x9CD, 0x1)),
    (0x001AF, (0x146, 0x2)),
    (0x2F91D, (0xC79, 0x1)),
    (0x01EE8, (0x56A, 0x3)),
    (0x022AD, (0x853, 0x2)),
    (0x2F834, (0xB90, 0x1)),
    (0x01EC8, (0x516, 0x2)),
    (0x01F52, (0x660, 0x3)),
    (0x2F84F, (0xBAB, 0x1)),
    (0x01E27, (0x3A8, 0x2)),
    (0x01F48, (0x64C, 0x2)),
    (0x01FEB, (0x7EA, 0x2)),
    (0x0F9C4, (0x9A5, 0x1)),
    (0x01EE5, (0x564, 0x2)),
    (0x01EBB, (0x4F2, 0x2)),
    (0x0F9B5, (0x996, 0x1)),
    (0x01F8D, (0x6F5, 0x4)),
    (0x01EAF, (0x4D1, 0x3)),
    (0x0FA78, (0xA4B, 0x1)),
    (0x2F975, (0xCD1, 0x1)),
    (0x2F9BA, (0xD16, 0x1)),
    (0x01E22, (0x39E, 0x2)),
    (0x01EEA, (0x570, 0x3)),
    (0x0FB2A, (0xAB1, 0x2)),
    (0x2F951, (0xCAD, 0x1)),
    (0x00A33, (0x2DE, 0x2)),
    (0x2F8DC, (0xC38, 0x1)),
    (0x000E7, (0x040, 0x2)),
    (0x2F8F7, (0xC53, 0x1)),
    (0x2F9EB, (0xD47, 0x1)),
    (0x00174, (0x12C, 0x2)),
    (0x0011D, (0x0A0, 0x2)),
    (0x0F966, (0x947, 0x1)),
    (0x0FB36, (0xACB, 0x2)),
    (0x2F88A, (0xBE6, 0x1)),
    (0x00450, (0x258, 0x2)),
    (0x0305C, (0x87D, 0x2)),
    (0x0F9F6, (0x9D7, 0x1)),
    (0x0F9A7, (0x988, 0x1)),
    (0x0FA82, (0xA55, 0x1)),
    (0x0FAD7, (0xAAA, 0x1)),
    (0x01B41, (0x34E, 0x2)),
    (0x01E5D, (0x421, 0x3)),
    (0x01F12, (0x5C8, 0x3)),
    (0x00108, (0x07A, 0x2)),
    (0x01EAC, (0x4C8, 0x3)),
    (0x2F9F0, (0xD4C, 0x1)),
    (0x00100, (0x06A, 0x2)),
    (0x0FAA2, (0xA75, 0x1)),
    (0x003D3, (0x242, 0x2)),
    (0x0F973, (0x954, 0x1)),
    (0x00407, (0x24C, 0x2)),
    (0x03070, (0x88B, 0x2)),
    (0x01E79, (0x461, 0x3)),
    (0x0F964, (0x945, 0x1)),
    (0x00F52, (0x31C, 0x2)),
    (0x0F9EF, (0x9D0, 0x1)),
    (0x01E58, (0x416, 0x2)),
    (0x2F949, (0xCA5, 0x1)),
    (0x00171, (0x126, 0x2)),
    (0x01F2A, (0x5FE, 0x3)),
    (0x00388, (0x21A, 0x2)),
    (0x00157, (0x0F6, 0x2)),
    (0x01F3D, (0x633, 0x3)),
    (0x0F98B, (0x96C, 0x1)),
    (0x030BE, (0x8B5, 0x2)),
    (0x2F816, (0xB72, 0x1)),
    (0x01E95, (0x49C, 0x2)),
    (0x0F991, (0x972, 0x1)),
    (0x2F8B5, (0xC11, 0x1)),
    (0x2F810, (0xB6C, 0x1)),
    (0x0FAB8, (0xA8B, 0x1)),
    (0x001EC, (0x18E, 0x3)),
    (0x01E09, (0x365, 0x3)),
    (0x2F8BB, (0xC17, 0x1)),
    (0x2F9E1, (0xD3D, 0x1)),
    (0x2F94E, (0xCAA, 0x1)),
    (0x01FAE, (0x771, 0x4)),
    (0x01FFD, (0x80A, 0x1)),
    (0x0FA00, (0x9E1, 0x1)),
    (0x00BCC, (0x2FA, 0x2)),
    (0x0FA4B, (0xA20, 0x1)),
    (0x0FAC3, (0xA96, 0x1)),
    (0x021CE, (0x819, 0x2)),
    (0x02271, (0x83B, 0x2)),
    (0x000CB, (0x014, 0x2)),
    (0x01F51, (0x65E, 0x2)),
    (0x0FA99, (0xA6C, 0x1)),
    (0x030B8, (0x8AF, 0x2)),
    (0x01E7E, (0x46E, 0x2)),
    (0x0FA75, (0xA48, 0x1)),
    (0x16128, (0xB2F, 0x3)),
    (0x0F978, (0x959, 0x1)),
    (0x001E6, (0x182, 0x2)),
    (0x01E8E, (0x48E, 0x2)),
    (0x2F9E6, (0xD42, 0x1)),
    (0x2F8E3, (0xC3F, 0x1)),
    (0x0045D, (0x262, 0x2)),
    (0x001DE, (0x172, 0x3)),
    (0x01F63, (0x684, 0x3)),
    (0x01E48, (0x3EE, 0x2)),
    (0x2F8D0, (0xC2C, 0x1)),
    (0x0FA22, (0x9FC, 0x1)),
    (0x0FACF, (0xAA2, 0x1)),
    (0x01EA3, (0x4AE, 0x2)),
    (0x022E3, (0x85F, 0x2)),
    (0x0FAD4, (0xAA7, 0x1)),
    (0x0304C, (0x86D, 0x2)),
    (0x0FA8D, (0xA60, 0x1)),
    (0x004D6, (0x276, 0x2)),
    (0x01F00, (0x598, 0x2)),
    (0x0FA36, (0xA0B, 0x1)),
    (0x0FA72, (0xA45, 0x1)),
    (0x2F9A3, (0xCFF, 0x1)),
    (0x01F1B, (0x5DB, 0x3)),
    (0x01F5D, (0x677, 0x3)),
    (0x2F9AB, (0xD07, 0x1)),
    (0x0FA15, (0x9F1, 0x1)),
    (0x0F9BE, (0x99F, 0x1)),
    (0x1D1BF, (0xB56, 0x3)),
    (0x0010D, (0x084, 0x2)),
    (0x01FB4, (0x782, 0x3)),
    (0x0F942, (0x923, 0x1)),
    (0x00934, (0x2C2, 0x2)),
    (0x0FAAE, (0xA81, 0x1)),
    (0x2F98A, (0xCE6, 0x1)),
    (0x01F3C, (0x630, 0x3)),
    (0x2F9D1, (0xD2D, 0x1)),
    (0x01FD9, (0x7C5, 0x2)),
    (0x01F38, (0x626, 0x2)),
    (0x030BC, (0x8B3, 0x2)),
    (0x000FC, (0x064, 0x2)),
    (0x01F05, (0x5A5, 0x3)),
    (0x01EE4, (0x562, 0x2)),
    (0x0F90C, (0x8ED, 0x1)),
    (0x01EB3, (0x4DD, 0x3)),
    (0x2F8E0, (0xC3C, 0x1)),
    (0x0016B, (0x11A, 0x2)),
    (0x01E12, (0x378, 0x2)),
    (0x0F99F, (0x980, 0x1)),
    (0x01FB3, (0x780, 0x2)),
    (0x1D160, (0xB3D, 0x3)),
    (0x000CF, (0x01C, 0x2)),
    (0x000CD, (0x018, 0x2)),
    (0x2F835, (0xB91, 0x1)),
    (0x0F902, (0x8E3, 0x1)),
    (0x00B4C, (0x2EE, 0x2)),
    (0x2F99C, (0xCF8, 0x1)),
    (0x0FA41, (0xA16, 0x1)),
    (0x0F9C5, (0x9A6, 0x1)),
    (0x0F9C7, (0x9A8, 0x1)),
    (0x030FE, (0x8DF, 0x2)),
    (0x01EE0, (0x556, 0x3)),
    (0x2F882, (0xBDE, 0x1)),
    (0x2F973, (0xCCF, 0x1)),
    (0x0FA0D, (0x9EE, 0x1)),
    (0x0FA5C, (0xA31, 0x1)),
    (0x2F900, (0xC5C, 0x1)),
    (0x0F9FD, (0x9DE, 0x1)),
    (0x01F62, (0x681, 0x3)),
    (0x2F8B9, (0xC15, 0x1)),
    (0x001F5, (0x19C, 0x2)),
    (0x01EF3, (0x58A, 0x2)),
    (0x2F84C, (0xBA8, 0x1)),
    (0x001D5, (0x15A, 0x3)),
    (0x0F9BC, (0x99D, 0x1)),
    (0x01FE5, (0x7DD, 0x2)),
    (0x01F5B, (0x674, 0x3)),
    (0x03071, (0x88D, 0x2)),
    (0x2F9BB, (0xD17, 0x1)),
    (0x01FAA, (0x761, 0x4)),
    (0x01F94, (0x70F, 0x4)),
    (0x01E4E, (0x3FC, 0x3)),
    (0x001EE, (0x194, 0x2)),
    (0x0F9ED, (0x9CE, 0x1)),
    (0x2F9B4, (0xD10, 0x1)),
    (0x2FA0F, (0xD6B, 0x1)),
    (0x00DDE, (0x316, 0x2)),
    (0x0F915, (0x8F6, 0x1)),
    (0x01F87, (0x6DF, 0x4)),
    (0x0F9B2, (0x993, 0x1)),
    (0x01B06, (0x33C, 0x2)),
    (0x2F84B, (0xBA7, 0x1)),
    (0x2F93D, (0xC99, 0x1)),
    (0x00113, (0x08C, 0x2)),
    (0x01F69, (0x695, 0x2)),
    (0x2F8C6, (0xC22, 0x1)),
    (0x000FF, (0x068, 0x2)),
    (0x01E77, (0x45C, 0x2)),
    (0x2FA12, (0xD6E, 0x1)),
    (0x00341, (0x20F, 0x1)),
    (0x2F827, (0xB83, 0x1)),
    (0x01B43, (0x350, 0x2)),
    (0x2F8BA, (0xC16, 0x1)),
    (0x0F987, (0x968, 0x1)),
    (0x01B12, (0x346, 0x2)),
    (0x022EA, (0x861, 0x2)),
    (0x2F97D, (0xCD9, 0x1)),
    (0x16D68, (0xB32, 0x2)),
    (0x0FB4C, (0xAED, 0x2)),
    (0x01E4A, (0x3F2, 0x2)),
    (0x01E1E, (0x396, 0x2)),
    (0x00B48, (0x2EA, 0x2)),
    (0x009DC, (0x2D8, 0x2)),
    (0x000DD, (0x032, 0x2)),
    (0x2F971, (0xCCD, 0x1)),
    (0x0FA9F, (0xA72, 0x1)),
    (0x0045E, (0x264, 0x2)),
    (0x01FA3, (0x747, 0x4)),
    (0x004DF, (0x284, 0x2)),
    (0x004DC, (0x27E, 0x2)),
    (0x00150, (0x0EC, 0x2)),
    (0x000DA, (0x02C, 0x2)),
    (0x001E7, (0x184, 0x2)),
    (0x2F92E, (0xC8A, 0x1)),
    (0x0F918, (0x8F9, 0x1)),
    (0x01FCE, (0x7B0, 0x2)),
    (0x0232A, (0x86A, 0x1)),
    (0x02281, (0x847, 0x2)),
    (0x01E0F, (0x372, 0x2)),
    (0x000E3, (0x03A, 0x2)),
    (0x0FB48, (0xAE5, 0x2)),
    (0x2FA0B, (0xD67, 0x1)),
    (0x0FB1D, (0xAAD, 0x2)),
    (0x01E90, (0x492, 0x2)),
    (0x003AA, (0x229, 0x2)),
    (0x0F981, (0x962, 0x1)),
    (0x01E30, (0x3BC, 0x2)),
    (0x01EBD, (0x4F6, 0x2)),
    (0x01E0B, (0x36A, 0x2)),
    (0x01E62, (0x42C, 0x2)),
    (0x2F85D, (0xBB9, 0x1)),
    (0x00401, (0x248, 0x2)),
    (0x2F87F, (0xBDB, 0x1)),
    (0x01F22, (0x5E8, 0x3)),
    (0x2F9A4, (0xD00, 0x1)),
    (0x2F855, (0xBB1, 0x1)),
    (0x2F98F, (0xCEB, 0x1)),
    (0x0F9D0, (0x9B1, 0x1)),
    (0x021CD, (0x817, 0x2)),
    (0x2F87A, (0xBD6, 0x1)),
    (0x01FB9, (0x78C, 0x2)),
    (0x2F8C8, (0xC24, 0x1)),
    (0x0FA65, (0xA3A, 0x1)),
    (0x01EA4, (0x4B0, 0x3)),
    (0x0014C, (0x0E4, 0x2)),
    (0x004F0, (0x29E, 0x2)),
    (0x01FB0, (0x779, 0x2)),
    (0x01FAD, (0x76D, 0x4)),
    (0x2F94F, (0xCAB, 0x1)),
    (0x01F75, (0x6B3, 0x2)),
    (0x0F905, (0x8E6, 0x1)),
    (0x0FA71, (0xA44, 0x1)),
    (0x000CE, (0x01A, 0x2)),
    (0x2F89E, (0xBFA, 0x1)),
    (0x2F903, (0xC5F, 0x1)),
    (0x0F939, (0x91A, 0x1)),
    (0x00B94, (0x2F4, 0x2)),
    (0x2F926, (0xC82, 0x1)),
    (0x0FA20, (0x9FB, 0x1)),
    (0x01EAB, (0x4C5, 0x3)),
    (0x004EF, (0x29C, 0x2)),
    (0x01F4D, (0x659, 0x3)),
    (0x1134B, (0xB01, 0x2)),
    (0x01F28, (0x5FA, 0x2)),
    (0x2F955, (0xCB1, 0x1)),
    (0x01FBC, (0x792, 0x2)),
    (0x01E42, (0x3E2, 0x2)),
    (0x0F935, (0x916, 0x1)),
    (0x114BB, (0xB13, 0x2)),
    (0x2F9E0, (0xD3C, 0x1)),
    (0x0015E, (0x104, 0x2)),
    (0x0017B, (0x13A, 0x2)),
    (0x01E3B, (0x3D4, 0x2)),
    (0x01E6A, (0x442, 0x2)),
    (0x00214, (0x1D8, 0x2)),
    (0x01B0A, (0x340, 0x2)),
    (0x2F825, (0xB81, 0x1)),
    (0x01E78, (0x45E, 0x3)),
    (0x001E8, (0x186, 0x2)),
    (0x022ED, (0x867, 0x2)),
    (0x00387, (0x219, 0x1)),
    (0x2F9CE, (0xD2A, 0x1)),
    (0x2F984, (0xCE0, 0x1)),
    (0x022EB, (0x863, 0x2)),
    (0x01FCB, (0x7AA, 0x2)),
    (0x0FAC5, (0xA98, 0x1)),
    (0x2F806, (0xB62, 0x1)),
    (0x0F960, (0x941, 0x1)),
    (0x0F9B3, (0x994, 0x1)),
    (0x0FA02, (0x9E3, 0x1)),
    (0x01EB9, (0x4EE, 0x2)),
    (0x01F3E, (0x636, 0x3)),
    (0x01EB1, (0x4D7, 0x3)),
    (0x2FA15, (0xD71, 0x1)),
    (0x0FB31, (0xAC1, 0x2)),
    (0x01F0D, (0x5BB, 0x3)),
    (0x0F9AB, (0x98C, 0x1)),
    (0x0FB39, (0xACF, 0x2)),
    (0x0305A, (0x87B, 0x2)),
    (0x0F9B0, (0x991, 0x1)),
    (0x0F91A, (0x8FB, 0x1)),
    (0x2F9F8, (0xD54, 0x1)),
    (0x2F977, (0xCD3, 0x1)),
    (0x001CF, (0x14E, 0x2)),
    (0x01E20, (0x39A, 0x2)),
    (0x0F9A4, (0x985, 0x1)),
    (0x00176, (0x130, 0x2)),
    (0x2FA1D, (0xD79, 0x1)),
    (0x004F4, (0x2A6, 0x2)),
    (0x2FA10, (0xD6C, 0x1)),
    (0x0F96E, (0x94F, 0x1)),
    (0x0F9BF, (0x9A0, 0x1)),
    (0x01F9E, (0x735, 0x4)),
    (0x2F84D, (0xBA9, 0x1)),
    (0x2FA0E, (0xD6A, 0x1)),
    (0x0FA07, (0x9E8, 0x1)),
    (0x004E7, (0x290, 0x2)),
    (0x01FE3, (0x7D8, 0x3)),
    (0x003CC, (0x23C, 0x2)),
    (0x01FA6, (0x753, 0x4)),
    (0x0020F, (0x1CE, 0x2)),
    (0x0FA5D, (0xA32, 0x1)),
    (0x00107, (0x078, 0x2)),
    (0x0FA4F, (0xA24, 0x1)),
    (0x0FA64, (0xA39, 0x1)),
    (0x1D1BC, (0xB4E, 0x2)),
    (0x0F99A, (0x97B, 0x1)),
    (0x2F9D5, (0xD31, 0x1)),
    (0x01EA7, (0x4B9, 0x3)),
    (0x2F8F9, (0xC55, 0x1)),
    (0x0F9F0, (0x9D1, 0x1)),
    (0x00476, (0x266, 0x2)),
    (0x000EA, (0x046, 0x2)),
    (0x2F86F, (0xBCB, 0x1)),
    (0x2F992, (0xCEE, 0x1)),
    (0x01E0E, (0x370, 0x2)),
    (0x0F95D, (0x93E, 0x1)),
    (0x0FA89, (0xA5C, 0x1)),
    (0x0022F, (0x202, 0x2)),
    (0x00CCB, (0x306, 0x3)),
    (0x2F841, (0xB9D, 0x1)),
    (0x004E6, (0x28E, 0x2)),
    (0x01E5F, (0x426, 0x2)),
    (0x004C2, (0x26C, 0x2)),
    (0x004EC, (0x296, 0x2)),
    (0x01B0E, (0x344, 0x2)),
    (0x00390, (0x226, 0x3)),
    (0x00105, (0x074, 0x2)),
    (0x00419, (0x254, 0x2)),
    (0x0F959, (0x93A, 0x1)),
    (0x030F8, (0x8D9, 0x2)),
    (0x01F25, (0x5F1, 0x3)),
    (0x01EC0, (0x4FE, 0x3)),
    (0x00124, (0x0AE, 0x2)),
    (0x00101, (0x06C, 0x2)),
    (0x000C7, (0x00C, 0x2)),
    (0x2F9FC, (0xD58, 0x1)),
    (0x0F92E, (0x90F, 0x1)),
    (0x2F910, (0xC6C, 0x1)),
    (0x02284, (0x849, 0x2)),
    (0x01EE3, (0x55F, 0x3)),
    (0x01E34, (0x3C4, 0x2)),
    (0x003AD, (0x22F, 0x2)),
    (0x0FA2C, (0xA01, 0x1)),
    (0x2F877, (0xBD3, 0x1)),
    (0x0F99B, (0x97C, 0x1)),
    (0x000E8, (0x042, 0x2)),
    (0x01E28, (0x3AA, 0x2)),
    (0x01EA1, (0x4AA, 0x2)),
    (0x2F94A, (0xCA6, 0x1)),
    (0x1D15E, (0xB39, 0x2)),
    (0x2F83B, (0xB97, 0x1)),
    (0x1D164, (0xB49, 0x3)),
    (0x2F854, (0xBB0, 0x1)),
    (0x2F892, (0xBEE, 0x1)),
    (0x1D1BB, (0xB4C, 0x2)),
    (0x0010F, (0x088, 0x2)),
    (0x01E63, (0x42E, 0x2)),
    (0x01FD3, (0x7BB, 0x3)),
    (0x01FB6, (0x785, 0x2)),
    (0x0F944, (0x925, 0x1)),
    (0x2F92B, (0xC87, 0x1)),
    (0x001FF, (0x1AE, 0x2)),
    (0x00386, (0x217, 0x2)),
    (0x2F95F, (0xCBB, 0x1)),
    (0x0FA32, (0xA07, 0x1)),
    (0x0FA17, (0x9F3, 0x1)),
    (0x01E17, (0x385, 0x3)),
    (0x01F31, (0x612, 0x2)),
    (0x2F980, (0xCDC, 0x1)),
    (0x0FA2D, (0xA02, 0x1)),
    (0x2F88E, (0xBEA, 0x1)),
    (0x01FAC, (0x769, 0x4)),
    (0x0FA3C, (0xA11, 0x1)),
    (0x01F09, (0x5B0, 0x2)),
    (0x01FDB, (0x7C9, 0x2)),
    (0x2F9CA, (0xD26, 0x1)),
    (0x01F2F, (0x60D, 0x3)),
    (0x00623, (0x2B0, 0x2)),
    (0x2F9F9, (0xD55, 0x1)),
    (0x0FAB4, (0xA87, 0x1)),
    (0x01EBF, (0x4FB, 0x3)),
    (0x0F985, (0x966, 0x1)),
    (0x01F6E, (0x6A3, 0x3)),
    (0x2F965, (0xCC1, 0x1)),
    (0x2F829, (0xB85, 0x1)),
    (0x01E24, (0x3A2, 0x2)),
    (0x2F8A2, (0xBFE, 0x1)),
    (0x2F8CC, (0xC28, 0x1)),
    (0x02ADC, (0x86B, 0x2)),
    (0x004F3, (0x2A4, 0x2)),
    (0x01F9D, (0x731, 0x4)),
    (0x01F24, (0x5EE, 0x3)),
    (0x2F9AF, (0xD0B, 0x1)),
    (0x0FA77, (0xA4A, 0x1)),
    (0x0FA93, (0xA66, 0x1)),
    (0x01E61, (0x42A, 0x2)),
    (0x00121, (0x0A8, 0x2)),
    (0x01FCC, (0x7AC, 0x2)),
    (0x2F9B6, (0xD12, 0x1)),
    (0x2F963, (0xCBF, 0x1)),
    (0x01EDB, (0x547, 0x3)),
    (0x01FAB, (0x765, 0x4)),
    (0x01E5A, (0x41A, 0x2)),
    (0x2F80E, (0xB6A, 0x1)),
    (0x0FA0A, (0x9EB, 0x1)),
    (0x2F994, (0xCF0, 0x1)),
    (0x2F91B, (0xC77, 0x1)),
    (0x01EEE, (0x57C, 0x3)),
    (0x01F67, (0x690, 0x3)),
    (0x0F9B9, (0x99A, 0x1)),
    (0x0FA63, (0xA38, 0x1)),
    (0x2F972, (0xCCE, 0x1)),
    (0x03079, (0x897, 0x2)),
    (0x0F9EA, (0x9CB, 0x1)),
    (0x0FB38, (0xACD, 0x2)),
    (0x0FA9E, (0xA71, 0x1)),
    (0x01E02, (0x356, 0x2)),
    (0x01ECE, (0x522, 0x2)),
    (0x01E75, (0x458, 0x2)),
    (0x0FA46, (0xA1B, 0x1)),
    (0x0FB43, (0xADD, 0x2)),
    (0x2F80A, (0xB66, 0x1)),
    (0x00115, (0x090, 0x2)),
    (0x2F959, (0xCB5, 0x1)),
    (0x030D1, (0x8C3, 0x2)),
    (0x2F9B2, (0xD0E, 0x1)),
    (0x2F98D, (0xCE9, 0x1)),
    (0x0FA7E, (0xA51, 0x1)),
    (0x00177, (0x132, 0x2)),
    (0x2F867, (0xBC3, 0x1)),
    (0x0FAA8, (0xA7B, 0x1)),
    (0x0F97D, (0x95E, 0x1)),
    (0x0F9B8, (0x999, 0x1)),
    (0x0F968, (0x949, 0x1)),
    (0x00D4B, (0x30B, 0x2)),
    (0x0FA5A, (0xA2F, 0x1)),
    (0x00104, (0x072, 0x2)),
    (0x01F4C, (0x656, 0x3)),
    (0x01F8E, (0x6F9, 0x4)),
    (0x105C9, (0xAF3, 0x2)),
    (0x01F2D, (0x607, 0x3)),
    (0x0FA2B, (0xA00, 0x1)),
    (0x2F8C5, (0xC21, 0x1)),
    (0x01F73, (0x6AF, 0x2)),
    (0x0FA73, (0xA46, 0x1)),
    (0x0014E, (0x0E8, 0x2)),
    (0x0F998, (0x979, 0x1)),
    (0x0F94D, (0x92E, 0x1)),
    (0x2F966, (0xCC2, 0x1)),
    (0x2F91E, (0xC7A, 0x1)),
    (0x00439, (0x256, 0x2)),
    (0x01E98, (0x4A2, 0x2)),
    (0x0FA8A, (0xA5D, 0x1)),
    (0x000E9, (0x044, 0x2)),
    (0x01FE9, (0x7E6, 0x2)),
    (0x00170, (0x124, 0x2)),
    (0x1109A, (0xAF7, 0x2)),
    (0x11383, (0xB05, 0x2)),
    (0x02270, (0x839, 0x2)),
    (0x2F982, (0xCDE, 0x1)),
    (0x0F9AF, (0x990, 0x1)),
    (0x0FAB3, (0xA86, 0x1)),
    (0x0F9E2, (0x9C3, 0x1)),
    (0x2F9CB, (0xD27, 0x1)),
    (0x0F947, (0x928, 0x1)),
    (0x00F78, (0x32A, 0x2)),
    (0x0021F, (0x1EA, 0x2)),
    (0x2F928, (0xC84, 0x1)),
    (0x004D2, (0x272, 0x2)),
    (0x2F845, (0xBA1, 0x1)),
    (0x01F23, (0x5EB, 0x3)),
    (0x02285, (0x84B, 0x2)),
    (0x0F903, (0x8E4, 0x1)),
    (0x2F84A, (0xBA6, 0x1)),
    (0x01F3F, (0x639, 0x3)),
    (0x01E07, (0x360, 0x2)),
    (0x2F823, (0xB7F, 0x1)),
    (0x2F8D1, (0xC2D, 0x1)),
    (0x01E11, (0x376, 0x2)),
    (0x01FD2, (0x7B8, 0x3)),
    (0x0017C, (0x13C, 0x2)),
    (0x000E4, (0x03C, 0x2)),
    (0x0F962, (0x943, 0x1)),
    (0x001F4, (0x19A, 0x2)),
    (0x0017A, (0x138, 0x2)),
    (0x0F948, (0x929, 0x1)),
    (0x001FE, (0x1AC, 0x2)),
    (0x2F90F, (0xC6B, 0x1)),
    (0x2F838, (0xB94, 0x1)),
    (0x2F800, (0xB5C, 0x1)),
    (0x0212B, (0x80F, 0x2)),
    (0x2F83E, (0xB9A, 0x1)),
    (0x0FA90, (0xA63, 0x1)),
    (0x0095D, (0x2CE, 0x2)),
    (0x2F96C, (0xCC8, 0x1)),
    (0x0FA4D, (0xA22, 0x1)),
    (0x0F906, (0x8E7, 0x1)),
    (0x01F37, (0x623, 0x3)),
    (0x0F9AC, (0x98D, 0x1)),
    (0x01FE1, (0x7D3, 0x2)),
    (0x01EC5, (0x50D, 0x3)),
    (0x01ECB, (0x51C, 0x2)),
    (0x2F947, (0xCA3, 0x1)),
    (0x01F6D, (0x6A0, 0x3)),
    (0x01E4C, (0x3F6, 0x3)),
    (0x01FE6, (0x7DF, 0x2)),
    (0x2F93C, (0xC98, 0x1)),
    (0x2F9C4, (0xD20, 0x1)),
    (0x001ED, (0x191, 0x3)),
    (0x030F9, (0x8DB, 0x2)),
    (0x2F898, (0xBF4, 0x1)),
    (0x0FA0C, (0x9ED, 0x1)),
    (0x000E0, (0x034, 0x2)),
    (0x2F986, (0xCE2, 0x1)),
    (0x01F61, (0x67F, 0x2)),
    (0x01F7C, (0x6C1, 0x2)),
    (0x01FA1, (0x740, 0x3)),
    (0x0307C, (0x89B, 0x2)),
    (0x01FEE, (0x7F0, 0x2)),
    (0x2F8E6, (0xC42, 0x1)),
    (0x00451, (0x25A, 0x2)),
    (0x01E16, (0x382, 0x3)),
    (0x00179, (0x136, 0x2)),
    (0x00114, (0x08E, 0x2)),
    (0x01F32, (0x614, 0x3)),
    (0x0FB3E, (0xAD7, 0x2)),
    (0x0F949, (0x92A, 0x1)),
    (0x2F937, (0xC93, 0x1)),
    (0x0F932, (0x913, 0x1)),
    (0x0219B, (0x813, 0x2)),
    (0x01E4F, (0x3FF, 0x3)),
    (0x01E51, (0x405, 0x3)),
    (0x01E8F, (0x490, 0x2)),
    (0x030D4, (0x8C7, 0x2)),
    (0x2FA0D, (0xD69, 0x1)),
    (0x01EE1, (0x559, 0x3)),
    (0x01026, (0x33A, 0x2)),
    (0x0F9C2, (0x9A3, 0x1)),
    (0x0012D, (0x0BC, 0x2)),
    (0x2F864, (0xBC0, 0x1)),
    (0x2F88D, (0xBE9, 0x1)),
    (0x2F9CC, (0xD28, 0x1)),
    (0x16124, (0xB25, 0x2)),
    (0x0FA98, (0xA6B, 0x1)),
    (0x2F901, (0xC5D, 0x1)),
    (0x2F9D3, (0xD2F, 0x1)),
    (0x01E96, (0x49E, 0x2)),
    (0x0FA60, (0xA35, 0x1)),
    (0x0FA62, (0xA37, 0x1)),
    (0x000FD, (0x066, 0x2)),
    (0x2FA00, (0xD5C, 0x1)),
    (0x01F06, (0x5A8, 0x3)),
    (0x00128, (0x0B2, 0x2)),
    (0x01F0B, (0x5B5, 0x3)),
    (0x2F99A, (0xCF6, 0x1)),
    (0x2F970, (0xCCC, 0x1)),
    (0x2FA13, (0xD6F, 0x1)),
    (0x01F0F, (0x5C1, 0x3)),
    (0x000F1, (0x052, 0x2)),
    (0x2F8D3, (0xC2F, 0x1)),
    (0x0F919, (0x8FA, 0x1)),
    (0x02329, (0x869, 0x1)),
    (0x0FB32, (0xAC3, 0x2)),
    (0x0FA48, (0xA1D, 0x1)),
    (0x0F953, (0x934, 0x1)),
    (0x2F873, (0xBCF, 0x1)),
    (0x0012E, (0x0BE, 0x2)),
    (0x0F963, (0x944, 0x1)),
    (0x01F53, (0x663, 0x3)),
    (0x0F94E, (0x92F, 0x1)),
    (0x0095A, (0x2C8, 0x2)),
    (0x2F929, (0xC85, 0x1)),
    (0x0012C, (0x0BA, 0x2)),
    (0x00119, (0x098, 0x2)),
    (0x2F997, (0xCF3, 0x1)),
    (0x0FACD, (0xAA0, 0x1)),
    (0x01E1B, (0x38E, 0x2)),
    (0x01ED6, (0x538, 0x3)),
    (0x0F945, (0x926, 0x1)),
    (0x01FA8, (0x75B, 0x3)),
    (0x0FA3A, (0xA0F, 0x1)),
    (0x2F94C, (0xCA8, 0x1)),
    (0x0F9C6, (0x9A7, 0x1)),
    (0x0FB4E, (0xAF1, 0x2)),
    (0x01F20, (0x5E4, 0x2)),
    (0x0FAD3, (0xAA6, 0x1)),
    (0x02278, (0x841, 0x2)),
    (0x01E86, (0x47E, 0x2)),
    (0x0F92D, (0x90E, 0x1)),
    (0x0FA5B, (0xA30, 0x1)),
    (0x0FA49, (0xA1E, 0x1)),
    (0x0FAC7, (0xA9A, 0x1)),
    (0x0F91D, (0x8FE, 0x1)),
    (0x2F852, (0xBAE, 0x1)),
    (0x01E3C, (0x3D6, 0x2)),
    (0x01E25, (0x3A4, 0x2)),
    (0x0F938, (0x919, 0x1)),
    (0x2F919, (0xC75, 0x1)),
    (0x00205, (0x1BA, 0x2)),
    (0x2F843, (0xB9F, 0x1)),
    (0x0FB33, (0xAC5, 0x2)),
    (0x01FB8, (0x78A, 0x2)),
    (0x0F9D7, (0x9B8, 0x1)),
    (0x0FB4A, (0xAE9, 0x2)),
    (0x00147, (0x0E0, 0x2)),
    (0x0FAAA, (0xA7D, 0x1)),
    (0x2F858, (0xBB4, 0x1)),
    (0x01E8A, (0x486, 0x2)),
    (0x001E1, (0x17B, 0x3)),
    (0x2F950, (0xCAC, 0x1)),
    (0x2FA19, (0xD75, 0x1)),
    (0x0FA6C, (0xA41, 0x1)),
    (0x01F93, (0x70B, 0x4)),
    (0x0FA74, (0xA47, 0x1)),
    (0x00109, (0x07C, 0x2)),
    (0x01F59, (0x672, 0x2)),
    (0x0F9D5, (0x9B6, 0x1)),
    (0x0FA70, (0xA43, 0x1)),
    (0x0FAA9, (0xA7C, 0x1)),
    (0x2F9F4, (0xD50, 0x1)),
    (0x2F948, (0xCA4, 0x1)),
    (0x0F9DB, (0x9BC, 0x1)),
    (0x01E2B, (0x3B0, 0x2)),
    (0x2F9F3, (0xD4F, 0x1)),
    (0x0016F, (0x122, 0x2)),
    (0x01F97, (0x71B, 0x4)),
    (0x01FA2, (0x743, 0x4)),
    (0x2F956, (0xCB2, 0x1)),
    (0x00F81, (0x32C, 0x2)),
    (0x01EDF, (0x553, 0x3)),
    (0x01E41, (0x3E0, 0x2)),
    (0x1D15F, (0xB3B, 0x2)),
    (0x01E66, (0x436, 0x3)),
    (0x2F8E7, (0xC43, 0x1)),
    (0x0FABD, (0xA90, 0x1)),
    (0x0F92A, (0x90B, 0x1)),
    (0x0FABA, (0xA8D, 0x1)),
    (0x01ED5, (0x535, 0x3)),
    (0x01F29, (0x5FC, 0x2)),
    (0x01EB0, (0x4D4, 0x3)),
    (0x01FF6, (0x7FB, 0x2)),
    (0x0FA69, (0xA3E, 0x1)),
    (0x00231, (0x207, 0x3)),
    (0x0011A, (0x09A, 0x2)),
    (0x2F916, (0xC72, 0x1)),
    (0x000D2, (0x020, 0x2)),
    (0x01E26, (0x3A6, 0x2)),
    (0x2F9E8, (0xD44, 0x1)),
    (0x00233, (0x20C, 0x2)),
    (0x0F936, (0x917, 0x1)),
    (0x01FEC, (0x7EC, 0x2)),
    (0x00202, (0x1B4, 0x2)),
    (0x0F9AD, (0x98E, 0x1)),
    (0x2F927, (0xC83, 0x1)),
    (0x2F856, (0xBB2, 0x1)),
    (0x00931, (0x2C0, 0x2)),
    (0x01E70, (0x44E, 0x2)),
    (0x00135, (0x0C6, 0x2)),
    (0x01E33, (0x3C2, 0x2)),
    (0x01F82, (0x6CB, 0x4)),
    (0x01F27, (0x5F7, 0x3)),
    (0x2F809, (0xB65, 0x1)),
    (0x0F920, (0x901, 0x1)),
    (0x2F936, (0xC92, 0x1)),
    (0x00340, (0x20E, 0x1)),
    (0x003AB, (0x22B, 0x2)),
    (0x2F86C, (0xBC8, 0x1)),
    (0x01ED3, (0x52F, 0x3)),
    (0x00103, (0x070, 0x2)),
    (0x0F9A8, (0x989, 0x1)),
    (0x0011C, (0x09E, 0x2)),
    (0x0F92C, (0x90D, 0x1)),
    (0x000C9, (0x010, 0x2)),
    (0x0F9B4, (0x995, 0x1)),
    (0x2F939, (0xC95, 0x1)),
    (0x0F913, (0x8F4, 0x1)),
    (0x0FA52, (0xA27, 0x1)),
    (0x00210, (0x1D0, 0x2)),
    (0x000F3, (0x056, 0x2)),
    (0x2F804, (0xB60, 0x1)),
    (0x2F87D, (0xBD9, 0x1)),
    (0x0FAC9, (0xA9C, 0x1)),
    (0x01E1C, (0x390, 0x3)),
    (0x0011E, (0x0A2, 0x2)),
    (0x0016C, (0x11C, 0x2)),
    (0x00A59, (0x2E2, 0x2)),
    (0x0FA26, (0x9FE, 0x1)),
    (0x0FA45, (0xA1A, 0x1)),
    (0x00112, (0x08A, 0x2)),
    (0x2F82E, (0xB8A, 0x1)),
    (0x0FA33, (0xA08, 0x1)),
    (0x1112F, (0xAFF, 0x2)),
    (0x00206, (0x1BC, 0x2)),
    (0x030DC, (0x8D1, 0x2)),
    (0x003CB, (0x23A, 0x2)),
    (0x0F986, (0x967, 0x1)),
    (0x0FB2D, (0xAB8, 0x3)),
    (0x01FA9, (0x75E, 0x3)),
    (0x0304E, (0x86F, 0x2)),
    (0x0F9E6, (0x9C7, 0x1)),
    (0x115BB, (0xB1B, 0x2)),
    (0x11391, (0xB0B, 0x2)),
    (0x01B3D, (0x34A, 0x2)),
    (0x00DDA, (0x30F, 0x2)),
    (0x0F992, (0x973, 0x1)),
    (0x0015D, (0x102, 0x2)),
    (0x00477, (0x268, 0x2)),
    (0x0F9B1, (0x992, 0x1)),
    (0x0040D, (0x250, 0x2)),
    (0x030F7, (0x8D7, 0x2)),
    (0x0F977, (0x958, 0x1)),
    (0x0FAC4, (0xA97, 0x1)),
    (0x0FA3B, (0xA10, 0x1)),
    (0x2F88B, (0xBE7, 0x1)),
    (0x02279, (0x843, 0x2)),
    (0x0FA01, (0x9E2, 0x1)),
    (0x01F79, (0x6BB, 0x2)),
    (0x03062, (0x883, 0x2)),
    (0x2F9D6, (0xD32, 0x1)),
    (0x004ED, (0x298, 0x2)),
    (0x2FA05, (0xD61, 0x1)),
    (0x110AB, (0xAFB, 0x2)),
    (0x0F9F1, (0x9D2, 0x1)),
    (0x01E54, (0x40E, 0x2)),
    (0x2F8B6, (0xC12, 0x1)),
    (0x0FA25, (0x9FD, 0x1)),
    (0x001D3, (0x156, 0x2)),
    (0x01E2D, (0x3B4, 0x2)),
    (0x00622, (0x2AE, 0x2)),
    (0x0F9A9, (0x98A, 0x1)),
    (0x00CC7, (0x300, 0x2)),
    (0x01F7A, (0x6BD, 0x2)),
    (0x0FA57, (0xA2C, 0x1)),
    (0x2F9A8, (0xD04, 0x1)),
    (0x001E0, (0x178, 0x3)),
    (0x2F904, (0xC60, 0x1)),
    (0x01FA7, (0x757, 0x4)),
    (0x01EC3, (0x507, 0x3)),
    (0x2F983, (0xCDF, 0x1)),
    (0x009CC, (0x2D6, 0x2)),
    (0x000D4, (0x024, 0x2)),
    (0x0FAD9, (0xAAC, 0x1)),
    (0x01F04, (0x5A2, 0x3)),
    (0x2F8B0, (0xC0C, 0x1)),
    (0x2F8D7, (0xC33, 0x1)),
    (0x0F9FB, (0x9DC, 0x1)),
    (0x2F9FB, (0xD57, 0x1)),
    (0x00217, (0x1DE, 0x2)),
    (0x2F9C1, (0xD1D, 0x1)),
    (0x2F98B, (0xCE7, 0x1)),
    (0x01F56, (0x66C, 0x3)),
    (0x2F9E2, (0xD3E, 0x1)),
    (0x00625, (0x2B4, 0x2)),
    (0x0307A, (0x899, 0x2)),
    (0x2F818, (0xB74, 0x1)),
    (0x01E83, (0x478, 0x2)),
    (0x01FB7, (0x787, 0x3)),
    (0x01ECA, (0x51A, 0x2)),
    (0x2F8F2, (0xC4E, 0x1)),
    (0x2F990, (0xCEC, 0x1)),
    (0x2F9DF, (0xD3B, 0x1)),
    (0x2F859, (0xBB5, 0x1)),
    (0x2FA09, (0xD65, 0x1)),
    (0x2F883, (0xBDF, 0x1)),
    (0x01FD7, (0x7C0, 0x3)),
    (0x2F872, (0xBCE, 0x1)),
    (0x2F85E, (0xBBA, 0x1)),
    (0x2F9B5, (0xD11, 0x1)),
    (0x0F9F4, (0x9D5, 0x1)),
    (0x00213, (0x1D6, 0x2)),
    (0x01EF4, (0x58C, 0x2)),
    (0x2F9DA, (0xD36, 0x1)),
    (0x01E36, (0x3C8, 0x2)),
    (0x006D3, (0x2BC, 0x2)),
    (0x2F9FF, (0xD5B, 0x1)),
    (0x2F97C, (0xCD8, 0x1)),
    (0x01FFC, (0x808, 0x2)),
    (0x2F8AD, (0xC09, 0x1)),
    (0x2F8FC, (0xC58, 0x1)),
    (0x01E31, (0x3BE, 0x2)),
    (0x003AC, (0x22D, 0x2)),
    (0x01E80, (0x472, 0x2)),
    (0x001D2, (0x154, 0x2)),
    (0x0F901, (0x8E2, 0x1)),
    (0x0F9DF, (0x9C0, 0x1)),
    (0x0FA83, (0xA56, 0x1)),
    (0x2F946, (0xCA2, 0x1)),
    (0x2F863, (0xBBF, 0x1)),
    (0x01F8B, (0x6ED, 0x4)),
    (0x0FA7C, (0xA4F, 0x1)),
    (0x00151, (0x0EE, 0x2)),
    (0x01FC1, (0x795, 0x2)),
    (0x2F8F8, (0xC54, 0x1)),
    (0x2F9B3, (0xD0F, 0x1)),
    (0x2F8A6, (0xC02, 0x1)),
    (0x003AE, (0x231, 0x2)),
    (0x2F9C9, (0xD25, 0x1)),
    (0x2F9D8, (0xD34, 0x1)),
    (0x2F81C, (0xB78, 0x1)),
    (0x01EBA, (0x4F0, 0x2)),
    (0x2F853, (0xBAF, 0x1)),
    (0x00118, (0x096, 0x2)),
    (0x2F8B7, (0xC13, 0x1)),
    (0x2F9B8, (0xD14, 0x1)),
    (0x2F93F, (0xC9B, 0x1)),
    (0x0F9E0, (0x9C1, 0x1)),
    (0x00385, (0x215, 0x2)),
    (0x2F888, (0xBE4, 0x1)),
    (0x0F99D, (0x97E, 0x1)),
    (0x01E5B, (0x41C, 0x2)),
    (0x000C4, (0x008, 0x2)),
    (0x16122, (0xB21, 0x2)),
    (0x03058, (0x879, 0x2)),
    (0x01E68, (0x43C, 0x3)),
    (0x0212A, (0x80E, 0x1)),
    (0x2F921, (0xC7D, 0x1)),
    (0x02260, (0x82F, 0x2)),
    (0x0FB1F, (0xAAF, 0x2)),
    (0x02001, (0x80C, 0x1)),
    (0x01F88, (0x6E3, 0x3)),
    (0x01F9C, (0x72D, 0x4)),
    (0x00137, (0x0CA, 0x2)),
    (0x0FA30, (0xA05, 0x1)),
    (0x01E49, (0x3F0, 0x2)),
    (0x0F9E1, (0x9C2, 0x1)),
    (0x0FA8F, (0xA62, 0x1)),
    (0x11938, (0xB1D, 0x2)),
    (0x0F9D1, (0x9B2, 0x1)),
    (0x0020B, (0x1C6, 0x2)),
    (0x0FA9C, (0xA6F, 0x1)),
    (0x0F982, (0x963, 0x1)),
    (0x2F97B, (0xCD7, 0x1)),
    (0x00400, (0x246, 0x2)),
    (0x0FA40, (0xA15, 0x1)),
    (0x0F96D, (0x94E, 0x1)),
    (0x02241, (0x827, 0x2)),
    (0x2F924, (0xC80, 0x1)),
    (0x00172, (0x128, 0x2)),
    (0x01E1F, (0x398, 0x2)),
    (0x2F993, (0xCEF, 0x1)),
    (0x001FB, (0x1A5, 0x3)),
    (0x00F75, (0x326, 0x2)),
    (0x00162, (0x10C, 0x2)),
    (0x001E2, (0x17E, 0x2)),
    (0x00374, (0x213, 0x1)),
    (0x0F997, (0x978, 0x1)),
    (0x004DE, (0x282, 0x2)),
    (0x000D9, (0x02A, 0x2)),
    (0x2F9EA, (0xD46, 0x1)),
    (0x2F8AB, (0xC07, 0x1)),
    (0x0FA7A, (0xA4D, 0x1)),
    (0x2F8FA, (0xC56, 0x1)),
    (0x0F90E, (0x8EF, 0x1)),
    (0x0F983, (0x964, 0x1)),
    (0x0016A, (0x118, 0x2)),
    (0x0FA68, (0xA3D, 0x1)),
    (0x000FB, (0x062, 0x2)),
    (0x2FA16, (0xD72, 0x1)),
    (0x01FFA, (0x804, 0x2)),
    (0x01F02, (0x59C, 0x3)),
    (0x2FA02, (0xD5E, 0x1)),
    (0x01E3A, (0x3D2, 0x2)),
    (0x01E69, (0x43F, 0x3)),
    (0x0FAAD, (0xA80, 0x1)),
    (0x004F8, (0x2AA, 0x2)),
    (0x004D3, (0x274, 0x2)),
    (0x01EF1, (0x585, 0x3)),
    (0x1138E, (0xB09, 0x2)),
    (0x2F8A5, (0xC01, 0x1)),
    (0x2F837, (0xB93, 0x1)),
    (0x01E0A, (0x368, 0x2)),
    (0x0FA96, (0xA69, 0x1)),
    (0x0014D, (0x0E6, 0x2)),
    (0x1D162, (0xB43, 0x3)),
    (0x0F923, (0x904, 0x1)),
    (0x0FAB7, (0xA8A, 0x1)),
    (0x01F11, (0x5C6, 0x2)),
    (0x000EE, (0x04E, 0x2)),
    (0x030C2, (0x8B9, 0x2)),
    (0x0FA31, (0xA06, 0x1)),
    (0x001D6, (0x15D, 0x3)),
    (0x0FB4D, (0xAEF, 0x2)),
    (0x000EC, (0x04A, 0x2)),
    (0x2F969, (0xCC5, 0x1)),
    (0x0F921, (0x902, 0x1)),
    (0x00F76, (0x328, 0x2)),
    (0x01EB5, (0x4E3, 0x3)),
    (0x00155, (0x0F2, 0x2)),
    (0x0FA61, (0xA36, 0x1)),
    (0x0020E, (0x1CC, 0x2)),
    (0x01F54, (0x666, 0x3)),
    (0x2F8D9, (0xC35, 0x1)),
    (0x0FAA1, (0xA74, 0x1)),
    (0x2F985, (0xCE1, 0x1)),
    (0x0F96F, (0x950, 0x1)),
    (0x2F974, (0xCD0, 0x1)),
    (0x01EC4, (0x50A, 0x3)),
    (0x01E44, (0x3E6, 0x2)),
    (0x2F8F0, (0xC4C, 0x1)),
    (0x0FA81, (0xA54, 0x1)),
    (0x0F9DE, (0x9BF, 0x1)),
    (0x2F9A5, (0xD01, 0x1)),
    (0x01FEA, (0x7E8, 0x2)),
    (0x0FABF, (0xA92, 0x1)),
    (0x00457, (0x25E, 0x2)),
    (0x01E21, (0x39C, 0x2)),
    (0x0FAB0, (0xA83, 0x1)),
    (0x01E55, (0x410, 0x2)),
    (0x01EF8, (0x594, 0x2)),
    (0x0F91B, (0x8FC, 0x1)),
    (0x01E50, (0x402, 0x3)),
    (0x000EB, (0x048, 0x2)),
    (0x2FA0A, (0xD66, 0x1)),
    (0x0F94F, (0x930, 0x1)),
    (0x004E4, (0x28A, 0x2)),
    (0x0013B, (0x0D0, 0x2)),
    (0x00169, (0x116, 0x2)),
    (0x2FA01, (0xD5D, 0x1)),
    (0x0F9E5, (0x9C6, 0x1)),
    (0x0FA1A, (0x9F6, 0x1)),
    (0x2F8AC, (0xC08, 0x1)),
    (0x01F6A, (0x697, 0x3)),
    (0x00CC8, (0x302, 0x2)),
    (0x0F911, (0x8F2, 0x1)),
    (0x0F928, (0x909, 0x1)),
    (0x01E6C, (0x446, 0x2)),
    (0x02226, (0x825, 0x2)),
    (0x2F8E9, (0xC45, 0x1)),
    (0x0F9FA, (0x9DB, 0x1)),
    (0x01EE9, (0x56D, 0x3)),
    (0x01F80, (0x6C5, 0x3)),
    (0x01F13, (0x5CB, 0x3)),
    (0x2F98C, (0xCE8, 0x1)),
    (0x2F96B, (0xCC7, 0x1)),
    (0x01FFB, (0x806, 0x2)),
    (0x2F920, (0xC7C, 0x1)),
    (0x0F951, (0x932, 0x1)),
    (0x1112E, (0xAFD, 0x2)),
    (0x000DC, (0x030, 0x2)),
    (0x2FA1C, (0xD78, 0x1)),
    (0x2F940, (0xC9C, 0x1)),
    (0x2F84E, (0xBAA, 0x1)),
    (0x0FA03, (0x9E4, 0x1)),
    (0x0F914, (0x8F5, 0x1)),
    (0x0F931, (0x912, 0x1)),
    (0x0F98A, (0x96B, 0x1)),
    (0x00F69, (0x322, 0x2)),
    (0x0F9BD, (0x99E, 0x1)),
    (0x030B2, (0x8A9, 0x2)),
    (0x01FBE, (0x794, 0x1)),
    (0x2F8C2, (0xC1E, 0x1)),
    (0x0FAD8, (0xAAB, 0x1)),
    (0x01FDE, (0x7CD, 0x2)),
    (0x01F8F, (0x6FD, 0x4)),
    (0x2FA11, (0xD6D, 0x1)),
    (0x01E5E, (0x424, 0x2)),
    (0x2F9C6, (0xD22, 0x1)),
    (0x0014F, (0x0EA, 0x2)),
    (0x030D6, (0x8C9, 0x2)),
    (0x2F968, (0xCC4, 0x1)),
    (0x0F952, (0x933, 0x1)),
    (0x2F8E8, (0xC44, 0x1)),
    (0x01F50, (0x65C, 0x2)),
    (0x01E56, (0x412, 0x2)),
    (0x0F9CC, (0x9AD, 0x1)),
    (0x001D4, (0x158, 0x2)),
    (0x0FABE, (0xA91, 0x1)),
    (0x00123, (0x0AC, 0x2)),
    (0x0FB3C, (0xAD5, 0x2)),
    (0x0F996, (0x977, 0x1)),
    (0x01E8D, (0x48C, 0x2)),
    (0x2F8DB, (0xC37, 0x1)),
    (0x00215, (0x1DA, 0x2)),
    (0x0F909, (0x8EA, 0x1)),
    (0x16123, (0xB23, 0x2)),
    (0x0FA6B, (0xA40, 0x1)),
    (0x02247, (0x82B, 0x2)),
    (0x030D0, (0x8C1, 0x2)),
    (0x1D1BE, (0xB53, 0x3)),
    (0x004D1, (0x270, 0x2)),
    (0x0FA79, (0xA4C, 0x1)),
    (0x01E7F, (0x470, 0x2)),
    (0x0FA12, (0x9F0, 0x1)),
    (0x022AC, (0x851, 0x2)),
    (0x0F9D4, (0x9B5, 0x1)),
    (0x01EDA, (0x544, 0x3)),
    (0x0F90D, (0x8EE, 0x1)),
    (0x0F922, (0x903, 0x1)),
    (0x01F8C, (0x6F1, 0x4)),
    (0x01E13, (0x37A, 0x2)),
    (0x030F4, (0x8D5, 0x2)),
    (0x0FA88, (0xA5B, 0x1)),
    (0x000CA, (0x012, 0x2)),
    (0x01E0C, (0x36C, 0x2)),
    (0x114BE, (0xB17, 0x2)),
    (0x2F964, (0xCC0, 0x1)),
    (0x030D9, (0x8CD, 0x2)),
    (0x2F907, (0xC63, 0x1)),
    (0x00161, (0x10A, 0x2)),
    (0x0FAD0, (0xAA3, 0x1)),
    (0x2FA03, (0xD5F, 0x1)),
    (0x01FD6, (0x7BE, 0x2)),
    (0x2F8B4, (0xC10, 0x1)),
    (0x2F893, (0xBEF, 0x1)),
    (0x01E45, (0x3E8, 0x2)),
    (0x16127, (0xB2C, 0x3)),
    (0x000ED, (0x04C, 0x2)),
    (0x0FA35, (0xA0A, 0x1)),
    (0x001FC, (0x1A8, 0x2)),
    (0x01E60, (0x428, 0x2)),
    (0x01E7D, (0x46C, 0x2)),
    (0x0FA4C, (0xA21, 0x1)),
    (0x00200, (0x1B0, 0x2)),
    (0x0F93F, (0x920, 0x1)),
    (0x2F911, (0xC6D, 0x1)),
    (0x00168, (0x114, 0x2)),
    (0x0F993, (0x974, 0x1)),
    (0x00136, (0x0C8, 0x2)),
    (0x01EAA, (0x4C2, 0x3)),
    (0x0F969, (0x94A, 0x1)),
    (0x2F8D5, (0xC31, 0x1)),
    (0x01E99, (0x4A4, 0x2)),
    (0x01E6F, (0x44C, 0x2)),
    (0x0FA1B, (0x9F7, 0x1)),
    (0x01E9B, (0x4A6, 0x2)),
    (0x2F808, (0xB64, 0x1)),
    (0x01F43, (0x643, 0x3)),
    (0x0F980, (0x961, 0x1)),
    (0x0FA58, (0xA2D, 0x1)),
    (0x2F8A8, (0xC04, 0x1)),
    (0x03052, (0x873, 0x2)),
    (0x2F9E9, (0xD45, 0x1)),
    (0x00344, (0x211, 0x2)),
    (0x0FA38, (0xA0D, 0x1)),
    (0x2F935, (0xC91, 0x1)),
    (0x01F14, (0x5CE, 0x3)),
    (0x01F39, (0x628, 0x2)),
    (0x01E71, (0x450, 0x2)),
    (0x0F96B, (0x94C, 0x1)),
    (0x0F9F3, (0x9D4, 0x1)),
    (0x0FAB6, (0xA89, 0x1)),
    (0x01FD8, (0x7C3, 0x2)),
    (0x0F995, (0x976, 0x1)),
    (0x01EF9, (0x596, 0x2)),
    (0x2F82F, (0xB8B, 0x1)),
    (0x2F9BF, (0xD1B, 0x1)),
    (0x0FA2E, (0xA03, 0x1)),
    (0x2F814, (0xB70, 0x1)),
    (0x0FAD1, (0xAA4, 0x1)),
    (0x01E1D, (0x393, 0x3)),
    (0x0038F, (0x224, 0x2)),
    (0x2F8A1, (0xBFD, 0x1)),
    (0x00228, (0x1F0, 0x2)),
    (0x2F81E, (0xB7A, 0x1)),
    (0x2F811, (0xB6D, 0x1)),
    (0x001CD, (0x14A, 0x2)),
    (0x01FC7, (0x7A1, 0x3)),
    (0x0022A, (0x1F4, 0x3)),
    (0x01F6B, (0x69A, 0x3)),
    (0x00624, (0x2B2, 0x2)),
    (0x01FC8, (0x7A4, 0x2)),
    (0x0FAC2, (0xA95, 0x1)),
    (0x0F9E7, (0x9C8, 0x1)),
    (0x2F8FE, (0xC5A, 0x1)),
    (0x030C9, (0x8BF, 0x2)),
    (0x2F908, (0xC64, 0x1)),
    (0x2F9E7, (0xD43, 0x1)),
    (0x0FABB, (0xA8E, 0x1)),
    (0x2FA1B, (0xD77, 0x1)),
    (0x00139, (0x0CC, 0x2)),
    (0x0FA1D, (0x9F9, 0x1)),
    (0x01EF2, (0x588, 0x2)),
    (0x2F998, (0xCF4, 0x1)),
    (0x2F91F, (0xC7B, 0x1)),
    (0x0FA9B, (0xA6E, 0x1)),
    (0x0FA80, (0xA53, 0x1)),
    (0x2F95C, (0xCB8, 0x1)),
    (0x2F9F5, (0xD51, 0x1)),
    (0x2F91A, (0xC76, 0x1)),
    (0x01F70, (0x6A9, 0x2)),
    (0x2F86B, (0xBC7, 0x1)),
    (0x2F85A, (0xBB6, 0x1)),
    (0x0013E, (0x0D6, 0x2)),
    (0x2F850, (0xBAC, 0x1)),
    (0x004DB, (0x27C, 0x2)),
    (0x2F871, (0xBCD, 0x1)),
    (0x0F970, (0x951, 0x1)),
    (0x004DD, (0x280, 0x2)),
    (0x01E1A, (0x38C, 0x2)),
    (0x2F90E, (0xC6A, 0x1)),
    (0x01F65, (0x68A, 0x3)),
    (0x0F929, (0x90A, 0x1)),
    (0x01EDD, (0x54D, 0x3)),
    (0x01F89, (0x6E6, 0x3)),
    (0x004D7, (0x278, 0x2)),
    (0x01E2F, (0x3B9, 0x3)),
    (0x2F860, (0xBBC, 0x1)),
    (0x01F55, (0x669, 0x3)),
    (0x0FAA4, (0xA77, 0x1)),
    (0x0FA59, (0xA2E, 0x1)),
    (0x0FB4B, (0xAEB, 0x2)),
    (0x2F8BF, (0xC1B, 0x1)),
    (0x01EE7, (0x568, 0x2)),
    (0x004F9, (0x2AC, 0x2)),
    (0x2F995, (0xCF1, 0x1)),
    (0x022AF, (0x857, 0x2)),
    (0x0F9B6, (0x997, 0x1)),
    (0x01EBC, (0x4F4, 0x2)),
    (0x004F5, (0x2A8, 0x2)),
    (0x2F826, (0xB82, 0x1)),
    (0x00116, (0x092, 0x2)),
    (0x00453, (0x25C, 0x2)),
    (0x0FB47, (0xAE3, 0x2)),
    (0x01E08, (0x362, 0x3)),
    (0x2F8E1, (0xC3D, 0x1)),
    (0x001DC, (0x16F, 0x3)),
    (0x0FA05, (0x9E6, 0x1)),
    (0x0F908, (0x8E9, 0x1)),
    (0x2F839, (0xB95, 0x1)),
    (0x0F95F, (0x940, 0x1)),
    (0x0012A, (0x0B6, 0x2)),
    (0x0040E, (0x252, 0x2)),
    (0x000D3, (0x022, 0x2)),
    (0x03069, (0x889, 0x2)),
    (0x2F944, (0xCA0, 0x1)),
    (0x0F90F, (0x8F0, 0x1)),
    (0x0F9A1, (0x982, 0x1)),
    (0x001D0, (0x150, 0x2)),
    (0x01F9B, (0x729, 0x4)),
    (0x2FA04, (0xD60, 0x1)),
    (0x01F74, (0x6B1, 0x2)),
    (0x01F1D, (0x5E1, 0x3)),
    (0x0F9F8, (0x9D9, 0x1)),
    (0x2F9E3, (0xD3F, 0x1)),
    (0x01FE2, (0x7D5, 0x3)),
    (0x02288, (0x84D, 0x2)),
    (0x2F9C2, (0xD1E, 0x1)),
    (0x030D3, (0x8C5, 0x2)),
    (0x030C0, (0x8B7, 0x2)),
    (0x0226F, (0x837, 0x2)),
    (0x2F9C8, (0xD24, 0x1)),
    (0x2F8ED, (0xC49, 0x1)),
    (0x2F85C, (0xBB8, 0x1)),
    (0x01F0C, (0x5B8, 0x3)),
    (0x01FC3, (0x79A, 0x2)),
    (0x01FF2, (0x7F3, 0x3)),
    (0x2F8EC, (0xC48, 0x1)),
    (0x2F885, (0xBE1, 0x1)),
    (0x2FA1A, (0xD76, 0x1)),
    (0x00216, (0x1DC, 0x2)),
    (0x2F8C7, (0xC23, 0x1)),
    (0x01F71, (0x6AB, 0x2)),
    (0x00209, (0x1C2, 0x2)),
    (0x0F999, (0x97A, 0x1)),
    (0x01FD1, (0x7B6, 0x2)),
    (0x03094, (0x89F, 0x2)),
    (0x2F878, (0xBD4, 0x1)),
    (0x01E5C, (0x41E, 0x3)),
    (0x01FED, (0x7EE, 0x2)),
    (0x0F9F7, (0x9D8, 0x1)),
    (0x2F9DE, (0xD3A, 0x1)),
    (0x0F925, (0x906, 0x1)),
    (0x001DA, (0x169, 0x3)),
    (0x000D5, (0x026, 0x2)),
    (0x0FA08, (0x9E9, 0x1)),
    (0x01EC9, (0x518, 0x2)),
    (0x00117, (0x094, 0x2)),
    (0x01F3A, (0x62A, 0x3)),
    (0x2F9FE, (0xD5A, 0x1)),
    (0x01F2C, (0x604, 0x3)),
    (0x0F94C, (0x92D, 0x1)),
    (0x01E52, (0x408, 0x3)),
    (0x02249, (0x82D, 0x2)),
    (0x0021E, (0x1E8, 0x2)),
    (0x01F44, (0x646, 0x3)),
    (0x0F988, (0x969, 0x1)),
    (0x01E4B, (0x3F4, 0x2)),
    (0x01FE0, (0x7D1, 0x2)),
    (0x01F6C, (0x69D, 0x3)),
    (0x0FA66, (0xA3B, 0x1)),
    (0x2F82B, (0xB87, 0x1)),
    (0x01E67, (0x439, 0x3)),
    (0x2F976, (0xCD2, 0x1)),
    (0x0FA43, (0xA18, 0x1)),
    (0x01E35, (0x3C6, 0x2)),
    (0x2F83D, (0xB99, 0x1)),
    (0x2F8DE, (0xC3A, 0x1)),
    (0x2F813, (0xB6F, 0x1)),
    (0x00175, (0x12E, 0x2)),
    (0x0F979, (0x95A, 0x1)),
    (0x2F942, (0xC9E, 0x1)),
    (0x0F9FE, (0x9DF, 0x1)),
    (0x0FAA3, (0xA76, 0x1)),
    (0x0F974, (0x955, 0x1)),
    (0x0F9AA, (0x98B, 0x1)),
    (0x0F9C1, (0x9A2, 0x1)),
    (0x02000, (0x80B, 0x1)),
    (0x2F905, (0xC61, 0x1)),
    (0x1109C, (0xAF9, 0x2)),
    (0x0FA7F, (0xA52, 0x1)),
    (0x2F890, (0xBEC, 0x1)),
    (0x03073, (0x88F, 0x2)),
    (0x0F9E8, (0x9C9, 0x1)),
    (0x2F887, (0xBE3, 0x1)),
    (0x000FA, (0x060, 0x2)),
    (0x2F803, (0xB5F, 0x1)),
    (0x2F9CF, (0xD2B, 0x1)),
    (0x2F8A7, (0xC03, 0x1)),
    (0x2F820, (0xB7C, 0x1)),
    (0x0FB30, (0xABF, 0x2)),
    (0x000EF, (0x050, 0x2)),
    (0x1D1C0, (0xB59, 0x3)),
    (0x01E37, (0x3CA, 0x2)),
    (0x2F932, (0xC8E, 0x1)),
    (0x021AE, (0x815, 0x2)),
    (0x0FAC6, (0xA99, 0x1)),
    (0x01F2B, (0x601, 0x3)),
    (0x0FA3F, (0xA14, 0x1)),
    (0x0FA54, (0xA29, 0x1)),
    (0x001DB, (0x16C, 0x3)),
    (0x01F26, (0x5F4, 0x3)),
    (0x2F80F, (0xB6B, 0x1)),
    (0x001F0, (0x198, 0x2)),
    (0x0FA0B, (0x9EC, 0x1)),
    (0x2F857, (0xBB3, 0x1)),
    (0x0FA10, (0x9EF, 0x1)),
    (0x2FA14, (0xD70, 0x1)),
    (0x2F8F4, (0xC50, 0x1)),
    (0x003B0, (0x235, 0x3)),
    (0x0F9D2, (0x9B3, 0x1)),
    (0x2F842, (0xB9E, 0x1)),
    (0x01F9A, (0x725, 0x4)),
    (0x01EED, (0x579, 0x3)),
    (0x01ED8, (0x53E, 0x3)),
    (0x00144, (0x0DA, 0x2)),
    (0x003D4, (0x244, 0x2)),
    (0x2F870, (0xBCC, 0x1)),
    (0x0F95C, (0x93D, 0x1)),
    (0x0FA92, (0xA65, 0x1)),
    (0x2F962, (0xCBE, 0x1)),
    (0x2F8E4, (0xC40, 0x1)),
    (0x01E15, (0x37F, 0x3)),
    (0x022E0, (0x859, 0x2)),
    (0x001D1, (0x152, 0x2)),
    (0x00165, (0x112, 0x2)),
    (0x0FAD2, (0xAA5, 0x1)),
    (0x0FB2C, (0xAB5, 0x3)),
    (0x01E39, (0x3CF, 0x3)),
    (0x2F9AE, (0xD0A, 0x1)),
    (0x000C8, (0x00E, 0x2)),
    (0x2F8BC, (0xC18, 0x1)),
    (0x01EEB, (0x573, 0x3)),
    (0x2F96A, (0xCC6, 0x1)),
    (0x001FA, (0x1A2, 0x3)),
    (0x2F8CD, (0xC29, 0x1)),
    (0x2F8A4, (0xC00, 0x1)),
    (0x0F91E, (0x8FF, 0x1)),
    (0x113C7, (0xB0F, 0x2)),
    (0x01FEF, (0x7F2, 0x1)),
    (0x2F899, (0xBF5, 0x1)),
    (0x2F8D8, (0xC34, 0x1)),
    (0x01E47, (0x3EC, 0x2)),
    (0x022AE, (0x855, 0x2)),
    (0x00389, (0x21C, 0x2)),
    (0x0FA8E, (0xA61, 0x1)),
    (0x000CC, (0x016, 0x2)),
    (0x2F81D, (0xB79, 0x1)),
    (0x0F941, (0x922, 0x1)),
    (0x0F975, (0x956, 0x1)),
    (0x00A5A, (0x2E4, 0x2)),
    (0x00FA2, (0x332, 0x2)),
    (0x01FB1, (0x77B, 0x2)),
    (0x00106, (0x076, 0x2)),
    (0x2F954, (0xCB0, 0x1)),
    (0x004EB, (0x294, 0x2)),
    (0x01F72, (0x6AD, 0x2)),
    (0x2F8AE, (0xC0A, 0x1)),
    (0x01ED4, (0x532, 0x3)),
    (0x01E81, (0x474, 0x2)),
    (0x0FA42, (0xA17, 0x1)),
    (0x00626, (0x2B6, 0x2)),
    (0x01E43, (0x3E4, 0x2)),
    (0x01F77, (0x6B7, 0x2)),
    (0x001EA, (0x18A, 0x2)),
    (0x0F9D3, (0x9B4, 0x1)),
    (0x2F819, (0xB75, 0x1)),
    (0x2F8BE, (0xC1A, 0x1)),
    (0x01ED9, (0x541, 0x3)),
    (0x0F930, (0x911, 0x1)),
    (0x0FA91, (0xA64, 0x1)),
    (0x0095F, (0x2D2, 0x2)),
    (0x2F930, (0xC8C, 0x1)),
    (0x2F86D, (0xBC9, 0x1)),
    (0x004EA, (0x292, 0x2)),
    (0x01EE6, (0x566, 0x2)),
    (0x01F01, (0x59A, 0x2)),
    (0x022E2, (0x85D, 0x2)),
    (0x01FDD, (0x7CB, 0x2)),
    (0x2FA18, (0xD74, 0x1)),
    (0x03076, (0x893, 0x2)),
    (0x2F906, (0xC62, 0x1)),
    (0x2F9C3, (0xD1F, 0x1)),
    (0x01F08, (0x5AE, 0x2)),
    (0x01B3B, (0x348, 0x2)),
    (0x0022B, (0x1F7, 0x3)),
    (0x01F86, (0x6DB, 0x4)),
    (0x000C3, (0x006, 0x2)),
    (0x0038E, (0x222, 0x2)),
    (0x004D0, (0x26E, 0x2)),
    (0x030C7, (0x8BD, 0x2)),
    (0x00A5B, (0x2E6, 0x2)),
    (0x000F9, (0x05E, 0x2)),
    (0x0017D, (0x13E, 0x2)),
    (0x01E94, (0x49A, 0x2)),
    (0x01E3D, (0x3D8, 0x2)),
    (0x0FAB1, (0xA84, 0x1)),
    (0x2F8DA, (0xC36, 0x1)),
    (0x01F6F, (0x6A6, 0x3)),
    (0x0F937, (0x918, 0x1)),
    (0x2F8EE, (0xC4A, 0x1)),
    (0x2F8C1, (0xC1D, 0x1)),
    (0x2F913, (0xC6F, 0x1)),
    (0x0F912, (0x8F3, 0x1)),
    (0x2F978, (0xCD4, 0x1)),
    (0x2F97F, (0xCDB, 0x1)),
    (0x001EF, (0x196, 0x2)),
    (0x01E65, (0x433, 0x3)),
    (0x0012F, (0x0C0, 0x2)),
    (0x01FC6, (0x79F, 0x2)),
    (0x0FAC0, (0xA93, 0x1)),
    (0x0020A, (0x1C4, 0x2)),
    (0x000C0, (0x000, 0x2)),
    (0x02209, (0x81F, 0x2)),
    (0x003CE, (0x240, 0x2)),
    (0x0020D, (0x1CA, 0x2)),
    (0x2F99E, (0xCFA, 0x1)),
    (0x00FA7, (0x334, 0x2)),
    (0x0F98E, (0x96F, 0x1)),
    (0x2F805, (0xB61, 0x1)),
    (0x01EC1, (0x501, 0x3)),
    (0x00159, (0x0FA, 0x2)),
    (0x01FCD, (0x7AE, 0x2)),
    (0x01F40, (0x63C, 0x2)),
    (0x2F933, (0xC8F, 0x1)),
    (0x030B0, (0x8A7, 0x2)),
    (0x01F30, (0x610, 0x2)),
    (0x00F93, (0x32E, 0x2)),
    (0x1134C, (0xB03, 0x2)),
    (0x2FA06, (0xD62, 0x1)),
    (0x2F9A2, (0xCFE, 0x1)),
    (0x2F80C, (0xB68, 0x1)),
    (0x2F9D9, (0xD35, 0x1)),
    (0x01E19, (0x38A, 0x2)),
    (0x000C5, (0x00A, 0x2)),
    (0x01F9F, (0x739, 0x4)),
    (0x2F95D, (0xCB9, 0x1)),
    (0x00DDC, (0x311, 0x2)),
    (0x01F81, (0x6C8, 0x3)),
    (0x01E76, (0x45A, 0x2)),
    (0x0F957, (0x938, 0x1)),
    (0x00134, (0x0C4, 0x2)),
    (0x01E97, (0x4A0, 0x2)),
    (0x01EB2, (0x4DA, 0x3)),
    (0x2F89A, (0xBF6, 0x1)),
    (0x2F828, (0xB84, 0x1)),
    (0x0015C, (0x100, 0x2)),
    (0x0F967, (0x948, 0x1)),
    (0x00122, (0x0AA, 0x2)),
    (0x2F967, (0xCC3, 0x1)),
    (0x00163, (0x10E, 0x2)),
    (0x0FA2A, (0x9FF, 0x1)),
    (0x00207, (0x1BE, 0x2)),
    (0x001D8, (0x163, 0x3)),
    (0x01F78, (0x6B9, 0x2)),
    (0x0FA51, (0xA26, 0x1)),
    (0x2F988, (0xCE4, 0x1)),
    (0x2F918, (0xC74, 0x1)),
    (0x030D7, (0x8CB, 0x2)),
    (0x2F92D, (0xC89, 0x1)),
    (0x2F9A1, (0xCFD, 0x1)),
    (0x01F42, (0x640, 0x3)),
    (0x00160, (0x108, 0x2)),
    (0x00CC0, (0x2FE, 0x2)),
    (0x030BA, (0x8B1, 0x2)),
    (0x01EBE, (0x4F8, 0x3)),
    (0x01E10, (0x374, 0x2)),
    (0x01EDE, (0x550, 0x3)),
    (0x01F57, (0x66F, 0x3)),
    (0x0F940, (0x921, 0x1)),
    (0x01E06, (0x35E, 0x2)),
    (0x0010A, (0x07E, 0x2)),
    (0x01E46, (0x3EA, 0x2)),
    (0x0F900, (0x8E1, 0x1)),
    (0x004EE, (0x29A, 0x2)),
    (0x2F88C, (0xBE8, 0x1)),
    (0x2F889, (0xBE5, 0x1)),
    (0x00FB9, (0x338, 0x2)),
    (0x2F90C, (0xC68, 0x1)),
    (0x2F8F1, (0xC4D, 0x1)),
    (0x00C48, (0x2FC, 0x2)),
    (0x03067, (0x887, 0x2)),
    (0x2F917, (0xC73, 0x1)),
    (0x2F8F3, (0xC4F, 0x1)),
    (0x2F97A, (0xCD6, 0x1)),
    (0x0F961, (0x942, 0x1)),
    (0x0F97C, (0x95D, 0x1)),
    (0x0037E, (0x214, 0x1)),
    (0x2F824, (0xB80, 0x1)),
    (0x004DA, (0x27A, 0x2)),
    (0x2F89D, (0xBF9, 0x1)),
    (0x2F960, (0xCBC, 0x1)),
    (0x0022C, (0x1FA, 0x3)),
    (0x2F96F, (0xCCB, 0x1)),
    (0x01F33, (0x617, 0x3)),
    (0x0FAD5, (0xAA8, 0x1)),
    (0x2F9F7, (0xD53, 0x1)),
    (0x16125, (0xB27, 0x2)),
    (0x2F9AA, (0xD06, 0x1)),
    (0x022EC, (0x865, 0x2)),
    (0x00204, (0x1B8, 0x2)),
    (0x01F3B, (0x62D, 0x3)),
    (0x2F925, (0xC81, 0x1)),
    (0x2F8B8, (0xC14, 0x1)),
    (0x01E8B, (0x488, 0x2)),
    (0x2F840, (0xB9C, 0x1)),
    (0x2F931, (0xC8D, 0x1)),
    (0x00218, (0x1E0, 0x2)),
    (0x001EB, (0x18C, 0x2)),
    (0x0F9A6, (0x987, 0x1)),
    (0x0F976, (0x957, 0x1)),
    (0x01EA0, (0x4A8, 0x2)),
    (0x2F86E, (0xBCA, 0x1)),
    (0x0FA97, (0xA6A, 0x1)),
    (0x02204, (0x81D, 0x2)),
    (0x0F9A5, (0x986, 0x1)),
    (0x01F99, (0x722, 0x3)),
    (0x01E82, (0x476, 0x2)),
    (0x01F7D, (0x6C3, 0x2)),
    (0x001E9, (0x188, 0x2)),
    (0x2F884, (0xBE0, 0x1)),
    (0x0020C, (0x1C8, 0x2)),
    (0x16D69, (0xB34, 0x2)),
    (0x2F9BC, (0xD18, 0x1)),
    (0x2F847, (0xBA3, 0x1)),
    (0x2F8C4, (0xC20, 0x1)),
    (0x00BCB, (0x2F8, 0x2)),
    (0x2F830, (0xB8C, 0x1)),
    (0x01E03, (0x358, 0x2)),
    (0x01E18, (0x388, 0x2)),
    (0x030B6, (0x8AD, 0x2)),
    (0x2F9D4, (0xD30, 0x1)),
    (0x0F9B7, (0x998, 0x1)),
    (0x001CE, (0x14C, 0x2)),
    (0x0F934, (0x915, 0x1)),
    (0x001B0, (0x148, 0x2)),
    (0x0011F, (0x0A4, 0x2)),
    (0x03074, (0x891, 0x2)),
    (0x2F89C, (0xBF8, 0x1)),
    (0x00227, (0x1EE, 0x2)),
    (0x2F979, (0xCD5, 0x1)),
    (0x2F9F2, (0xD4E, 0x1)),
    (0x01FA4, (0x74B, 0x4)),
    (0x2F862, (0xBBE, 0x1)),
    (0x2F8E5, (0xC41, 0x1)),
    (0x0016E, (0x120, 0x2)),
    (0x0F98C, (0x96D, 0x1)),
    (0x2F95E, (0xCBA, 0x1)),
    (0x2F996, (0xCF2, 0x1)),
    (0x01F84, (0x6D3, 0x4)),
    (0x2F945, (0xCA1, 0x1)),
    (0x00929, (0x2BE, 0x2)),
    (0x2F89B, (0xBF7, 0x1)),
    (0x02224, (0x823, 0x2)),
    (0x01B08, (0x33E, 0x2)),
    (0x0F9D6, (0x9B7, 0x1)),
    (0x01F60, (0x67D, 0x2)),
    (0x2F953, (0xCAF, 0x1)),
    (0x01E6E, (0x44A, 0x2)),
    (0x2F861, (0xBBD, 0x1)),
    (0x00B5D, (0x2F2, 0x2)),
    (0x2F938, (0xC94, 0x1)),
    (0x2F9BD, (0xD19, 0x1)),
    (0x2F9E4, (0xD40, 0x1)),
    (0x2F943, (0xC9F, 0x1)),
    (0x01E3F, (0x3DC, 0x2)),
    (0x03060, (0x881, 0x2)),
    (0x2F92F, (0xC8B, 0x1)),
    (0x2F880, (0xBDC, 0x1)),
    (0x02262, (0x831, 0x2)),
    (0x0F9EB, (0x9CC, 0x1)),
    (0x0F9DC, (0x9BD, 0x1)),
    (0x01F45, (0x649, 0x3)),
    (0x0FA6D, (0xA42, 0x1)),
    (0x01E53, (0x40B, 0x3)),
    (0x2F88F, (0xBEB, 0x1)),
    (0x0F956, (0x937, 0x1)),
    (0x0FA84, (0xA57, 0x1)),
    (0x001D7, (0x160, 0x3)),
    (0x113C5, (0xB0D, 0x2)),
    (0x000E5, (0x03E, 0x2)),
    (0x01F90, (0x701, 0x3)),
    (0x2F9A6, (0xD02, 0x1)),
    (0x01F0E, (0x5BE, 0x3)),
    (0x0095E, (0x2D0, 0x2)),
    (0x01E4D, (0x3F9, 0x3)),
    (0x000D6, (0x028, 0x2)),
    (0x01F96, (0x717, 0x4)),
    (0x01EA6, (0x4B6, 0x3)),
    (0x2F874, (0xBD0, 0x1)),
    (0x2F9C5, (0xD21, 0x1)),
    (0x2F981, (0xCDD, 0x1)),
    (0x0F92B, (0x90C, 0x1)),
    (0x0FA04, (0x9E5, 0x1)),
    (0x2F987, (0xCE3, 0x1)),
    (0x01E64, (0x430, 0x3)),
    (0x0FB2B, (0xAB3, 0x2)),
    (0x0FAAB, (0xA7E, 0x1)),
    (0x2F915, (0xC71, 0x1)),
    (0x2F81B, (0xB77, 0x1)),
    (0x00958, (0x2C4, 0x2)),
    (0x2FA07, (0xD63, 0x1)),
    (0x0022E, (0x200, 0x2)),
    (0x0FACC, (0xA9F, 0x1)),
    (0x2F895, (0xBF1, 0x1)),
    (0x001E3, (0x180, 0x2)),
    (0x11385, (0xB07, 0x2)),
    (0x0FA34, (0xA09, 0x1)),
    (0x0FAA7, (0xA7A, 0x1)),
    (0x01F92, (0x707, 0x4)),
    (0x2F8C9, (0xC25, 0x1)),
    (0x0FA18, (0x9F4, 0x1)),
    (0x0F9DA, (0x9BB, 0x1)),
    (0x2F94B, (0xCA7, 0x1)),
    (0x0220C, (0x821, 0x2)),
    (0x0F99E, (0x97F, 0x1)),
    (0x00F57, (0x31E, 0x2)),
    (0x00226, (0x1EC, 0x2)),
    (0x01EB8, (0x4EC, 0x2)),
    (0x00CCA, (0x304, 0x2)),
    (0x2F8DF, (0xC3B, 0x1)),
    (0x0040C, (0x24E, 0x2)),
    (0x0F926, (0x907, 0x1)),
    (0x01E85, (0x47C, 0x2)),
    (0x0015B, (0x0FE, 0x2)),
    (0x0FA7B, (0xA4E, 0x1)),
    (0x0FA67, (0xA3C, 0x1)),
    (0x0F946, (0x927, 0x1)),
    (0x2F9CD, (0xD29, 0x1)),
    (0x03054, (0x875, 0x2)),
    (0x2F868, (0xBC4, 0x1)),
    (0x0FA7D, (0xA50, 0x1)),
    (0x01EA5, (0x4B3, 0x3)),
    (0x2F832, (0xB8E, 0x1)),
    (0x0FAA0, (0xA73, 0x1)),
    (0x01FE8, (0x7E4, 0x2)),
    (0x2F8B1, (0xC0D, 0x1)),
    (0x00219, (0x1E2, 0x2)),
    (0x0F9DD, (0x9BE, 0x1)),
    (0x001DF, (0x175, 0x3)),
    (0x0FA56, (0xA2B, 0x1)),
    (0x2F9EC, (0xD48, 0x1)),
    (0x2F8F5, (0xC51, 0x1)),
    (0x03050, (0x871, 0x2)),
    (0x1D163, (0xB46, 0x3)),
    (0x01EB4, (0x4E0, 0x3)),
    (0x0F95A, (0x93B, 0x1)),
    (0x00DDD, (0x313, 0x3)),
    (0x0FA76, (0xA49, 0x1)),
    (0x00203, (0x1B6, 0x2)),
    (0x01B40, (0x34C, 0x2)),
    (0x004E2, (0x286, 0x2)),
    (0x01E91, (0x494, 0x2)),
    (0x2F95A, (0xCB6, 0x1)),
    (0x0F9E4, (0x9C5, 0x1)),
    (0x16D6A, (0xB36, 0x3)),
    (0x0F989, (0x96A, 0x1)),
    (0x01F03, (0x59F, 0x3)),
    (0x00154, (0x0F0, 0x2)),
    (0x000DB, (0x02E, 0x2)),
    (0x2F923, (0xC7F, 0x1)),
    (0x00232, (0x20A, 0x2)),
    (0x00148, (0x0E2, 0x2)),
    (0x2F87C, (0xBD8, 0x1)),
    (0x0F9A0, (0x981, 0x1)),
    (0x0F9CE, (0x9AF, 0x1)),
    (0x006C2, (0x2BA, 0x2)),
    (0x0FB41, (0xADB, 0x2)),
    (0x2F8AA, (0xC06, 0x1)),
    (0x2F91C, (0xC78, 0x1)),
    (0x0F990, (0x971, 0x1)),
    (0x01EE2, (0x55C, 0x3)),
    (0x01F68, (0x693, 0x2)),
    (0x01F21, (0x5E6, 0x2)),
    (0x2F9B7, (0xD13, 0x1)),
    (0x01FF8, (0x800, 0x2)),
    (0x0FA09, (0x9EA, 0x1)),
    (0x030B4, (0x8AB, 0x2)),
    (0x0FB34, (0xAC7, 0x2)),
    (0x000C2, (0x004, 0x2)),
    (0x004E3, (0x288, 0x2)),
    (0x01E59, (0x418, 0x2)),
    (0x01B0C, (0x342, 0x2)),
    (0x2F894, (0xBF0, 0x1)),
    (0x01E57, (0x414, 0x2)),
    (0x0021A, (0x1E4, 0x2)),
    (0x0F9CB, (0x9AC, 0x1)),
    (0x0226E, (0x835, 0x2)),
    (0x114BC, (0xB15, 0x2)),
    (0x2F896, (0xBF2, 0x1)),
    (0x02274, (0x83D, 0x2)),
    (0x0FAD6, (0xAA9, 0x1)),
    (0x02275, (0x83F, 0x2)),
    (0x0010C, (0x082, 0x2)),
    (0x2F9B1, (0xD0D, 0x1)),
    (0x0FB3B, (0xAD3, 0x2)),
    (0x2F9F1, (0xD4D, 0x1)),
    (0x00A36, (0x2E0, 0x2)),
    (0x00BCA, (0x2F6, 0x2)),
    (0x01ECC, (0x51E, 0x2)),
    (0x2F958, (0xCB4, 0x1)),
    (0x0FB35, (0xAC9, 0x2)),
    (0x001A0, (0x142, 0x2)),
    (0x0FA19, (0x9F5, 0x1)),
    (0x0013D, (0x0D4, 0x2)),
    (0x01EF6, (0x590, 0x2)),
    (0x0038C, (0x220, 0x2)),
    (0x2F881, (0xBDD, 0x1)),
    (0x0F9D9, (0x9BA, 0x1)),
    (0x01ECD, (0x520, 0x2)),
    (0x01E7C, (0x46A, 0x2)),
    (0x2F9DD, (0xD39, 0x1)),
    (0x16126, (0xB29, 0x3)),
    (0x2F9ED, (0xD49, 0x1)),
    (0x2F952, (0xCAE, 0x1)),
    (0x0F91F, (0x900, 0x1)),
    (0x2F902, (0xC5E, 0x1)),
    (0x0F97A, (0x95B, 0x1)),
    (0x2F8FF, (0xC5B, 0x1)),
    (0x0FA37, (0xA0C, 0x1)),
    (0x0FB44, (0xADF, 0x2)),
    (0x2F9EE, (0xD4A, 0x1)),
    (0x00A5E, (0x2E8, 0x2)),
    (0x01F4B, (0x653, 0x3)),
    (0x0F9F2, (0x9D3, 0x1)),
    (0x01E6D, (0x448, 0x2)),
    (0x00164, (0x110, 0x2)),
    (0x003CD, (0x23E, 0x2)),
    (0x030FA, (0x8DD, 0x2)),
    (0x0FAB2, (0xA85, 0x1)),
    (0x01E40, (0x3DE, 0x2)),
    (0x00156, (0x0F4, 0x2)),
    (0x0FA53, (0xA28, 0x1)),
    (0x2F99F, (0xCFB, 0x1)),
    (0x2F96D, (0xCC9, 0x1)),
    (0x2F9A7, (0xD03, 0x1)),
    (0x01F19, (0x5D6, 0x2)),
    (0x0F9BA, (0x99B, 0x1)),
    (0x01EF0, (0x582, 0x3)),
    (0x2F8D2, (0xC2E, 0x1)),
    (0x00F5C, (0x320, 0x2)),
    (0x1D1BD, (0xB50, 0x3)),
    (0x01FB2, (0x77D, 0x3)),
    (0x03065, (0x885, 0x2)),
    (0x2F9DB, (0xD37, 0x1)),
    (0x0038A, (0x21E, 0x2)),
    (0x01F91, (0x704, 0x3)),
    (0x0FB3A, (0xAD1, 0x2)),
    (0x2F9BE, (0xD1A, 0x1)),
    (0x01FBA, (0x78E, 0x2)),
    (0x000F4, (0x058, 0x2)),
    (0x00B4B, (0x2EC, 0x2)),
    (0x0F910, (0x8F1, 0x1)),
    (0x0F95B, (0x93C, 0x1)),
    (0x2F876, (0xBD2, 0x1)),
    (0x2F81F, (0xB7B, 0x1)),
    (0x2F8BD, (0xC19, 0x1)),
    (0x0F954, (0x935, 0x1)),
    (0x2F822, (0xB7E, 0x1)),
    (0x00201, (0x1B2, 0x2)),
    (0x01E84, (0x47A, 0x2)),
    (0x2FA08, (0xD64, 0x1)),
    (0x0F9CF, (0x9B0, 0x1)),
    (0x2F9A9, (0xD05, 0x1)),
    (0x01F76, (0x6B5, 0x2)),
    (0x0F96A, (0x94B, 0x1)),
    (0x0F9E3, (0x9C4, 0x1)),
    (0x2F844, (0xBA0, 0x1)),
    (0x0FB2E, (0xABB, 0x2)),
    (0x0FAB5, (0xA88, 0x1)),
    (0x000C1, (0x002, 0x2)),
    (0x00178, (0x134, 0x2)),
    (0x2F8D6, (0xC32, 0x1)),
    (0x00343, (0x210, 0x1)),
    (0x2F815, (0xB71, 0x1)),
    (0x2F85F, (0xBBB, 0x1)),
    (0x0F93B, (0x91C, 0x1)),
    (0x001F8, (0x19E, 0x2)),
    (0x01EB6, (0x4E6, 0x3)),
    (0x01FE7, (0x7E1, 0x3)),
    (0x0FA47, (0xA1C, 0x1)),
    (0x2F99B, (0xCF7, 0x1)),
    (0x004C1, (0x26A, 0x2)),
    (0x01F49, (0x64E, 0x2)),
    (0x2F8A9, (0xC05, 0x1)),
    (0x01E32, (0x3C0, 0x2)),
    (0x000F2, (0x054, 0x2)),
    (0x0FA9A, (0xA6D, 0x1)),
    (0x2F85B, (0xBB7, 0x1)),
    (0x0F9CD, (0x9AE, 0x1)),
    (0x030AE, (0x8A5, 0x2)),
    (0x01F7B, (0x6BF, 0x2)),
    (0x01E92, (0x496, 0x2)),
    (0x2F8B2, (0xC0E, 0x1)),
    (0x0F97E, (0x95F, 0x1)),
    (0x01EB7, (0x4E9, 0x3)),
    (0x0FA06, (0x9E7, 0x1)),
    (0x01FCF, (0x7B2, 0x2)),
    (0x2F8EA, (0xC46, 0x1)),
    (0x2F97E, (0xCDA, 0x1)),
    (0x2F8E2, (0xC3E, 0x1)),
    (0x01F18, (0x5D4, 0x2)),
    (0x0F98D, (0x96E, 0x1)),
    (0x03056, (0x877, 0x2)),
    (0x2F93A, (0xC96, 0x1)),
    (0x0FACE, (0xAA1, 0x1)),
    (0x01E8C, (0x48A, 0x2)),
    (0x00158, (0x0F8, 0x2)),
    (0x0FA55, (0xA2A, 0x1)),
    (0x01FC4, (0x79C, 0x3)),
    (0x115BA, (0xB19, 0x2)),
    (0x0017E, (0x140, 0x2)),
    (0x0010E, (0x086, 0x2)),
    (0x0F950, (0x931, 0x1)),
    (0x2F886, (0xBE2, 0x1)),
    (0x01EF7, (0x592, 0x2)),
    (0x2F9DC, (0xD38, 0x1)),
    (0x009DF, (0x2DC, 0x2)),
    (0x01F8A, (0x6E9, 0x4)),
    (0x0FAC1, (0xA94, 0x1)),
    (0x2F934, (0xC90, 0x1)),
    (0x01EEC, (0x576, 0x3)),
    (0x01EEF, (0x57F, 0x3)),
    (0x01F41, (0x63E, 0x2)),
    (0x0F943, (0x924, 0x1)),
    (0x01EC7, (0x513, 0x3)),
    (0x01F66, (0x68D, 0x3)),
    (0x01F10, (0x5C4, 0x2)),
    (0x2F8CF, (0xC2B, 0x1)),
    (0x01FA0, (0x73D, 0x3)),
    (0x2F909, (0xC65, 0x1)),
    (0x00FAC, (0x336, 0x2)),
    (0x004E5, (0x28C, 0x2)),
    (0x2F991, (0xCED, 0x1)),
    (0x0F958, (0x939, 0x1)),
    (0x01FCA, (0x7A8, 0x2)),
    (0x003CA, (0x238, 0x2)),
    (0x2F817, (0xB73, 0x1)),
    (0x00F4D, (0x31A, 0x2)),
    (0x00143, (0x0D8, 0x2)),
    (0x0013C, (0x0D2, 0x2)),
    (0x001F9, (0x1A0, 0x2)),
    (0x2F9D2, (0xD2E, 0x1)),
    (0x2F866, (0xBC2, 0x1)),
    (0x2F9D0, (0xD2C, 0x1)),
    (0x01E01, (0x354, 0x2)),
    (0x2F90D, (0xC69, 0x1)),
    (0x0015A, (0x0FC, 0x2)),
    (0x00125, (0x0B0, 0x2)),
    (0x0F984, (0x965, 0x1)),
    (0x0F91C, (0x8FD, 0x1)),
    (0x0FA8C, (0xA5F, 0x1)),
    (0x01E14, (0x37C, 0x3)),
    (0x0226D, (0x833, 0x2)),
    (0x0045C, (0x260, 0x2)),
    (0x00102, (0x06E, 0x2)),
    (0x0FAAF, (0xA82, 0x1)),
    (0x2F836, (0xB92, 0x1)),
    (0x006C0, (0x2B8, 0x2)),
    (0x0F9FF, (0x9E0, 0x1)),
    (0x0F97F, (0x960, 0x1)),
    (0x2F8CA, (0xC26, 0x1)),
    (0x2F92A, (0xC86, 0x1)),
    (0x0012B, (0x0B8, 0x2)),
    (0x0309E, (0x8A1, 0x2)),
    (0x0FA4E, (0xA23, 0x1)),
    (0x0FAC8, (0xA9B, 0x1)),
    (0x01FDF, (0x7CF, 0x2)),
    (0x2F96E, (0xCCA, 0x1)),
    (0x00F9D, (0x330, 0x2)),
    (0x2F802, (0xB5E, 0x1)),
    (0x01E05, (0x35C, 0x2)),
    (0x2F80D, (0xB69, 0x1)),
    (0x2F941, (0xC9D, 0x1)),
    (0x0021B, (0x1E6, 0x2)),
    (0x2F82C, (0xB88, 0x1)),
    (0x0FB46, (0xAE1, 0x2)),
    (0x0F971, (0x952, 0x1)),
    (0x0F9C3, (0x9A4, 0x1)),
    (0x2F83C, (0xB98, 0x1)),
    (0x2F81A, (0xB76, 0x1)),
    (0x0F9BB, (0x99C, 0x1)),
    (0x0FAAC, (0xA7F, 0x1)),
    (0x01F5F, (0x67A, 0x3)),
    (0x0FA6A, (0xA3F, 0x1)),
    (0x2F8B3, (0xC0F, 0x1)),
    (0x0F9C9, (0x9AA, 0x1)),
    (0x0F9EE, (0x9CF, 0x1)),
    (0x01E6B, (0x444, 0x2)),
    (0x01E2C, (0x3B2, 0x2)),
    (0x2F851, (0xBAD, 0x1)),
    (0x2F812, (0xB6E, 0x1)),
    (0x01F15, (0x5D1, 0x3)),
    (0x0FA4A, (0xA1F, 0x1)),
    (0x030DA, (0x8CF, 0x2)),
    (0x01EC6, (0x510, 0x3)),
    (0x00208, (0x1C0, 0x2)),
    (0x0F90B, (0x8EC, 0x1)),
    (0x01E00, (0x352, 0x2)),
    (0x0FB40, (0xAD9, 0x2)),
    (0x2F82D, (0xB89, 0x1)),
    (0x001D9, (0x166, 0x3)),
    (0x0FAA5, (0xA78, 0x1)),
    (0x000F6, (0x05C, 0x2)),
    (0x022E1, (0x85B, 0x2)),
    (0x2F961, (0xCBD, 0x1)),
    (0x021CF, (0x81B, 0x2)),
    (0x0F9D8, (0x9B9, 0x1)),
    (0x0FA3D, (0xA12, 0x1)),
    (0x0FB2F, (0xABD, 0x2)),
    (0x0FA85, (0xA58, 0x1)),
    (0x0095C, (0x2CC, 0x2)),
    (0x01FF7, (0x7FD, 0x3)),
    (0x01EAE, (0x4CE, 0x3)),
    (0x2F98E, (0xCEA, 0x1)),
    (0x01F83, (0x6CF, 0x4)),
    (0x030C5, (0x8BB, 0x2)),
    (0x00403, (0x24A, 0x2)),
    (0x00120, (0x0A6, 0x2)),
    (0x004F2, (0x2A2, 0x2)),
    (0x0F98F, (0x970, 0x1)),
    (0x2F9B0, (0xD0C, 0x1)),
    (0x01FF3, (0x7F6, 0x2)),
    (0x00D4A, (0x309, 0x2)),
    (0x0013A, (0x0CE, 0x2)),
    (0x01E74, (0x456, 0x2)),
    (0x2F831, (0xB8D, 0x1)),
    (0x2F80B, (0xB67, 0x1)),
    (0x2F8A3, (0xBFF, 0x1)),
    (0x0F955, (0x936, 0x1)),
    (0x2F89F, (0xBFB, 0x1)),
    (0x0011B, (0x09C, 0x2)),
    (0x0F93C, (0x91D, 0x1)),
    (0x009DD, (0x2DA, 0x2)),
    (0x2F9AC, (0xD08, 0x1)),
    (0x0F933, (0x914, 0x1)),
    (0x2F8C3, (0xC1F, 0x1)),
    (0x16121, (0xB1F, 0x2)),
    (0x2F82A, (0xB86, 0x1)),
    (0x2F93E, (0xC9A, 0x1)),
    (0x0022D, (0x1FD, 0x3)),
    (0x01ED2, (0x52C, 0x3)),
    (0x2F99D, (0xCF9, 0x1)),
    (0x01F36, (0x620, 0x3)),
    (0x2F9D7, (0xD33, 0x1)),
    (0x01EAD, (0x4CB, 0x3)),
    (0x2F914, (0xC70, 0x1)),
    (0x01FE4, (0x7DB, 0x2)),
    (0x00B5C, (0x2F0, 0x2)),
    (0x01F95, (0x713, 0x4)),
    (0x00959, (0x2C6, 0x2)),
    (0x0F9C0, (0x9A1, 0x1)),
    (0x01ED7, (0x53B, 0x3)),
    (0x2F865, (0xBC1, 0x1)),
    (0x2F801, (0xB5D, 0x1)),
    (0x01E3E, (0x3DA, 0x2)),
    (0x2F848, (0xBA4, 0x1)),
    (0x2F8EF, (0xC4B, 0x1)),
    (0x2F875, (0xBD1, 0x1)),
    (0x01E04, (0x35A, 0x2)),
    (0x0FA1C, (0x9F8, 0x1)),
    (0x2F807, (0xB63, 0x1)),
    (0x01ECF, (0x524, 0x2)),
    (0x01ED1, (0x529, 0x3)),
    (0x0F927, (0x908, 0x1)),
    (0x2F8D4, (0xC30, 0x1)),
    (0x0FA39, (0xA0E, 0x1)),
    (0x2F989, (0xCE5, 0x1)),
    (0x2FA0C, (0xD68, 0x1)),
    (0x2F86A, (0xBC6, 0x1)),
    (0x01EDC, (0x54A, 0x3)),
    (0x0F917, (0x8F8, 0x1)),
    (0x2F8A0, (0xBFC, 0x1)),
    (0x2F897, (0xBF3, 0x1)),
    (0x01E38, (0x3CC, 0x3)),
    (0x000E2, (0x038, 0x2)),
    (0x01FC9, (0x7A6, 0x2)),
    (0x01F34, (0x61A, 0x3)),
    (0x02289, (0x84F, 0x2)),
    (0x2F9FA, (0xD56, 0x1)),
    (0x02244, (0x829, 0x2)),
    (0x0FAA6, (0xA79, 0x1)),
    (0x2F846, (0xBA2, 0x1)),
    (0x02126, (0x80D, 0x1)),
    (0x0010B, (0x080, 0x2)),
    (0x00145, (0x0DC, 0x2)),
    (0x00130, (0x0C2, 0x2)),
    (0x2F9E5, (0xD41, 0x1)),
    (0x2F912, (0xC6E, 0x1)),
    (0x0F9AE, (0x98F, 0x1)),
    (0x2F957, (0xCB3, 0x1)),
    (0x0F904, (0x8E5, 0x1)),
    (0x01F98, (0x71F, 0x3)),
    (0x0F93A, (0x91B, 0x1)),
    (0x2F8AF, (0xC0B, 0x1)),
    (0x2F879, (0xBD5, 0x1)),
    (0x01FF4, (0x7F8, 0x3)),
    (0x01E23, (0x3A0, 0x2)),
    (0x00212, (0x1D4, 0x2)),
    (0x030DD, (0x8D3, 0x2)),
    (0x2F87B, (0xBD7, 0x1)),
    (0x2F8EB, (0xC47, 0x1)),
    (0x01EC2, (0x504, 0x3)),
    (0x0219A, (0x811, 0x2)),
    (0x000E1, (0x036, 0x2)),
    (0x000D1, (0x01E, 0x2)),
    (0x0F972, (0x953, 0x1)),
];
pub(crate) const COMPATIBILITY_DECOMPOSED_CHARS: &[char] = &[
    '\u{0020}',
    '\u{0020}',
    '\u{0308}',
    '\u{0061}',
    '\u{0020}',
    '\u{0304}',
    '\u{0032}',
    '\u{0033}',
    '\u{0020}',
    '\u{0301}',
    '\u{03BC}',
    '\u{0020}',
    '\u{0327}',
    '\u{0031}',
    '\u{006F}',
    '\u{0031}',
    '\u{2044}',
    '\u{0034}',
    '\u{0031}',
    '\u{2044}',
    '\u{0032}',
    '\u{0033}',
    '\u{2044}',
    '\u{0034}',
    '\u{0049}',
    '\u{004A}',
    '\u{0069}',
    '\u{006A}',
    '\u{004C}',
    '\u{00B7}',
    '\u{006C}',
    '\u{00B7}',
    '\u{02BC}',
    '\u{006E}',
    '\u{0073}',
    '\u{0044}',
    '\u{005A}',
    '\u{030C}',
    '\u{0044}',
    '\u{007A}',
    '\u{030C}',
    '\u{0064}',
    '\u{007A}',
    '\u{030C}',
    '\u{004C}',
    '\u{004A}',
    '\u{004C}',
    '\u{006A}',
    '\u{006C}',
    '\u{006A}',
    '\u{004E}',
    '\u{004A}',
    '\u{004E}',
    '\u{006A}',
    '\u{006E}',
    '\u{006A}',
    '\u{0044}',
    '\u{005A}',
    '\u{0044}',
    '\u{007A}',
    '\u{0064}',
    '\u{007A}',
    '\u{0068}',
    '\u{0266}',
    '\u{006A}',
    '\u{0072}',
    '\u{0279}',
    '\u{027B}',
    '\u{0281}',
    '\u{0077}',
    '\u{0079}',
    '\u{0020}',
    '\u{0306}',
    '\u{0020}',
    '\u{0307}',
    '\u{0020}',
    '\u{030A}',
    '\u{0020}',
    '\u{0328}',
    '\u{0020}',
    '\u{0303}',
    '\u{0020}',
    '\u{030B}',
    '\u{0263}',
    '\u{006C}',
    '\u{0073}',
    '\u{0078}',
    '\u{0295}',
    '\u{0020}',
    '\u{0345}',
    '\u{0020}',
    '\u{0301}',
    '\u{0020}',
    '\u{0308}',
    '\u{0301}',
    '\u{03B2}',
    '\u{03B8}',
    '\u{03A5}',
    '\u{03A5}',
    '\u{0301}',
    '\u{03A5}',
    '\u{0308}',
    '\u{03C6}',
    '\u{03C0}',
    '\u{03BA}',
    '\u{03C1}',
    '\u{03C2}',
    '\u{0398}',
    '\u{03B5}',
    '\u{03A3}',
    '\u{0565}',
    '\u{0582}',
    '\u{0627}',
    '\u{0674}',
    '\u{0648}',
    '\u{0674}',
    '\u{06C7}',
    '\u{0674}',
    '\u{064A}',
    '\u{0674}',
    '\u{0E4D}',
    '\u{0E32}',
    '\u{0ECD}',
    '\u{0EB2}',
    '\u{0EAB}',
    '\u{0E99}',
    '\u{0EAB}',
    '\u{0EA1}',
    '\u{0F0B}',
    '\u{0FB2}',
    '\u{0F71}',
    '\u{0F80}',
    '\u{0FB3}',
    '\u{0F71}',
    '\u{0F80}',
    '\u{10DC}',
    '\u{0041}',
    '\u{00C6}',
    '\u{0042}',
    '\u{0044}',
    '\u{0045}',
    '\u{018E}',
    '\u{0047}',
    '\u{0048}',
    '\u{0049}',
    '\u{004A}',
    '\u{004B}',
    '\u{004C}',
    '\u{004D}',
    '\u{004E}',
    '\u{004F}',
    '\u{0222}',
    '\u{0050}',
    '\u{0052}',
    '\u{0054}',
    '\u{0055}',
    '\u{0057}',
    '\u{0061}',
    '\u{0250}',
    '\u{0251}',
    '\u{1D02}',
    '\u{0062}',
    '\u{0064}',
    '\u{0065}',
    '\u{0259}',
    '\u{025B}',
    '\u{025C}',
    '\u{0067}',
    '\u{006B}',
    '\u{006D}',
    '\u{014B}',
    '\u{006F}',
    '\u{0254}',
    '\u{1D16}',
    '\u{1D17}',
    '\u{0070}',
    '\u{0074}',
    '\u{0075}',
    '\u{1D1D}',
    '\u{026F}',
    '\u{0076}',
    '\u{1D25}',
    '\u{03B2}',
    '\u{03B3}',
    '\u{03B4}',
    '\u{03C6}',
    '\u{03C7}',
    '\u{0069}',
    '\u{0072}',
    '\u{0075}',
    '\u{0076}',
    '\u{03B2}',
    '\u{03B3}',
    '\u{03C1}',
    '\u{03C6}',
    '\u{03C7}',
    '\u{043D}',
    '\u{0252}',
    '\u{0063}',
    '\u{0255}',
    '\u{00F0}',
    '\u{025C}',
    '\u{0066}',
    '\u{025F}',
    '\u{0261}',
    '\u{0265}',
    '\u{0268}',
    '\u{0269}',
    '\u{026A}',
    '\u{1D7B}',
    '\u{029D}',
    '\u{026D}',
    '\u{1D85}',
    '\u{029F}',
    '\u{0271}',
    '\u{0270}',
    '\u{0272}',
    '\u{0273}',
    '\u{0274}',
    '\u{0275}',
    '\u{0278}',
    '\u{0282}',
    '\u{0283}',
    '\u{01AB}',
    '\u{0289}',
    '\u{028A}',
    '\u{1D1C}',
    '\u{028B}',
    '\u{028C}',
    '\u{007A}',
    '\u{0290}',
    '\u{0291}',
    '\u{0292}',
    '\u{03B8}',
    '\u{0061}',
    '\u{02BE}',
    '\u{0073}',
    '\u{0307}',
    '\u{0020}',
    '\u{0313}',
    '\u{0020}',
    '\u{0313}',
    '\u{0020}',
    '\u{0342}',
    '\u{0020}',
    '\u{0308}',
    '\u{0342}',
    '\u{0020}',
    '\u{0313}',
    '\u{0300}',
    '\u{0020}',
    '\u{0313}',
    '\u{0301}',
    '\u{0020}',
    '\u{0313}',
    '\u{0342}',
    '\u{0020}',
    '\u{0314}',
    '\u{0300}',
    '\u{0020}',
    '\u{0314}',
    '\u{0301}',
    '\u{0020}',
    '\u{0314}',
    '\u{0342}',
    '\u{0020}',
    '\u{0308}',
    '\u{0300}',
    '\u{0020}',
    '\u{0308}',
    '\u{0301}',
    '\u{0020}',
    '\u{0301}',
    '\u{0020}',
    '\u{0314}',
    '\u{0020}',
    '\u{0020}',
    '\u{0020}',
    '\u{0020}',
    '\u{0020}',
    '\u{0020}',
    '\u{0020}',
    '\u{0020}',
    '\u{0020}',
    '\u{0020}',
    '\u{0020}',
    '\u{2010}',
    '\u{0020}',
    '\u{0333}',
    '\u{002E}',
    '\u{002E}',
    '\u{002E}',
    '\u{002E}',
    '\u{002E}',
    '\u{002E}',
    '\u{0020}',
    '\u{2032}',
    '\u{2032}',
    '\u{2032}',
    '\u{2032}',
    '\u{2032}',
    '\u{2035}',
    '\u{2035}',
    '\u{2035}',
    '\u{2035}',
    '\u{2035}',
    '\u{0021}',
    '\u{0021}',
    '\u{0020}',
    '\u{0305}',
    '\u{003F}',
    '\u{003F}',
    '\u{003F}',
    '\u{0021}',
    '\u{0021}',
    '\u{003F}',
    '\u{2032}',
    '\u{2032}',
    '\u{2032}',
    '\u{2032}',
    '\u{0020}',
    '\u{0030}',
    '\u{0069}',
    '\u{0034}',
    '\u{0035}',
    '\u{0036}',
    '\u{0037}',
    '\u{0038}',
    '\u{0039}',
    '\u{002B}',
    '\u{2212}',
    '\u{003D}',
    '\u{0028}',
    '\u{0029}',
    '\u{006E}',
    '\u{0030}',
    '\u{0031}',
    '\u{0032}',
    '\u{0033}',
    '\u{0034}',
    '\u{0035}',
    '\u{0036}',
    '\u{0037}',
    '\u{0038}',
    '\u{0039}',
    '\u{002B}',
    '\u{2212}',
    '\u{003D}',
    '\u{0028}',
    '\u{0029}',
    '\u{0061}',
    '\u{0065}',
    '\u{006F}',
    '\u{0078}',
    '\u{0259}',
    '\u{0068}',
    '\u{006B}',
    '\u{006C}',
    '\u{006D}',
    '\u{006E}',
    '\u{0070}',
    '\u{0073}',
    '\u{0074}',
    '\u{0052}',
    '\u{0073}',
    '\u{0061}',
    '\u{002F}',
    '\u{0063}',
    '\u{0061}',
    '\u{002F}',
    '\u{0073}',
    '\u{0043}',
    '\u{00B0}',
    '\u{0043}',
    '\u{0063}',
    '\u{002F}',
    '\u{006F}',
    '\u{0063}',
    '\u{002F}',
    '\u{0075}',
    '\u{0190}',
    '\u{00B0}',
    '\u{0046}',
    '\u{0067}',
    '\u{0048}',
    '\u{0048}',
    '\u{0048}',
    '\u{0068}',
    '\u{0127}',
    '\u{0049}',
    '\u{0049}',
    '\u{004C}',
    '\u{006C}',
    '\u{004E}',
    '\u{004E}',
    '\u{006F}',
    '\u{0050}',
    '\u{0051}',
    '\u{0052}',
    '\u{0052}',
    '\u{0052}',
    '\u{0053}',
    '\u{004D}',
    '\u{0054}',
    '\u{0045}',
    '\u{004C}',
    '\u{0054}',
    '\u{004D}',
    '\u{005A}',
    '\u{005A}',
    '\u{0042}',
    '\u{0043}',
    '\u{0065}',
    '\u{0045}',
    '\u{0046}',
    '\u{004D}',
    '\u{006F}',
    '\u{05D0}',
    '\u{05D1}',
    '\u{05D2}',
    '\u{05D3}',
    '\u{0069}',
    '\u{0046}',
    '\u{0041}',
    '\u{0058}',
    '\u{03C0}',
    '\u{03B3}',
    '\u{0393}',
    '\u{03A0}',
    '\u{2211}',
    '\u{0044}',
    '\u{0064}',
    '\u{0065}',
    '\u{0069}',
    '\u{006A}',
    '\u{0031}',
    '\u{2044}',
    '\u{0037}',
    '\u{0031}',
    '\u{2044}',
    '\u{0039}',
    '\u{0031}',
    '\u{2044}',
    '\u{0031}',
    '\u{0030}',
    '\u{0031}',
    '\u{2044}',
    '\u{0033}',
    '\u{0032}',
    '\u{2044}',
    '\u{0033}',
    '\u{0031}',
    '\u{2044}',
    '\u{0035}',
    '\u{0032}',
    '\u{2044}',
    '\u{0035}',
    '\u{0033}',
    '\u{2044}',
    '\u{0035}',
    '\u{0034}',
    '\u{2044}',
    '\u{0035}',
    '\u{0031}',
    '\u{2044}',
    '\u{0036}',
    '\u{0035}',
    '\u{2044}',
    '\u{0036}',
    '\u{0031}',
    '\u{2044}',
    '\u{0038}',
    '\u{0033}',
    '\u{2044}',
    '\u{0038}',
    '\u{0035}',
    '\u{2044}',
    '\u{0038}',
    '\u{0037}',
    '\u{2044}',
    '\u{0038}',
    '\u{0031}',
    '\u{2044}',
    '\u{0049}',
    '\u{0049}',
    '\u{0049}',
    '\u{0049}',
    '\u{0049}',
    '\u{0049}',
    '\u{0049}',
    '\u{0056}',
    '\u{0056}',
    '\u{0056}',
    '\u{0049}',
    '\u{0056}',
    '\u{0049}',
    '\u{0049}',
    '\u{0056}',
    '\u{0049}',
    '\u{0049}',
    '\u{0049}',
    '\u{0049}',
    '\u{0058}',
    '\u{0058}',
    '\u{0058}',
    '\u{0049}',
    '\u{0058}',
    '\u{0049}',
    '\u{0049}',
    '\u{004C}',
    '\u{0043}',
    '\u{0044}',
    '\u{004D}',
    '\u{0069}',
    '\u{0069}',
    '\u{0069}',
    '\u{0069}',
    '\u{0069}',
    '\u{0069}',
    '\u{0069}',
    '\u{0076}',
    '\u{0076}',
    '\u{0076}',
    '\u{0069}',
    '\u{0076}',
    '\u{0069}',
    '\u{0069}',
    '\u{0076}',
    '\u{0069}',
    '\u{0069}',
    '\u{0069}',
    '\u{0069}',
    '\u{0078}',
    '\u{0078}',
    '\u{0078}',
    '\u{0069}',
    '\u{0078}',
    '\u{0069}',
    '\u{0069}',
    '\u{006C}',
    '\u{0063}',
    '\u{0064}',
    '\u{006D}',
    '\u{0030}',
    '\u{2044}',
    '\u{0033}',
    '\u{222B}',
    '\u{222B}',
    '\u{222B}',
    '\u{222B}',
    '\u{222B}',
    '\u{222E}',
    '\u{222E}',
    '\u{222E}',
    '\u{222E}',
    '\u{222E}',
    '\u{0031}',
    '\u{0032}',
    '\u{0033}',
    '\u{0034}',
    '\u{0035}',
    '\u{0036}',
    '\u{0037}',
    '\u{0038}',
    '\u{0039}',
    '\u{0031}',
    '\u{0030}',
    '\u{0031}',
    '\u{0031}',
    '\u{0031}',
    '\u{0032}',
    '\u{0031}',
    '\u{0033}',
    '\u{0031}',
    '\u{0034}',
    '\u{0031}',
    '\u{0035}',
    '\u{0031}',
    '\u{0036}',
    '\u{0031}',
    '\u{0037}',
    '\u{0031}',
    '\u{0038}',
    '\u{0031}',
    '\u{0039}',
    '\u{0032}',
    '\u{0030}',
    '\u{0028}',
    '\u{0031}',
    '\u{0029}',
    '\u{0028}',
    '\u{0032}',
    '\u{0029}',
    '\u{0028}',
    '\u{0033}',
    '\u{0029}',
    '\u{0028}',
    '\u{0034}',
    '\u{0029}',
    '\u{0028}',
    '\u{0035}',
    '\u{0029}',
    '\u{0028}',
    '\u{0036}',
    '\u{0029}',
    '\u{0028}',
    '\u{0037}',
    '\u{0029}',
    '\u{0028}',
    '\u{0038}',
    '\u{0029}',
    '\u{0028}',
    '\u{0039}',
    '\u{0029}',
    '\u{0028}',
    '\u{0031}',
    '\u{0030}',
    '\u{0029}',
    '\u{0028}',
    '\u{0031}',
    '\u{0031}',
    '\u{0029}',
    '\u{0028}',
    '\u{0031}',
    '\u{0032}',
    '\u{0029}',
    '\u{0028}',
    '\u{0031}',
    '\u{0033}',
    '\u{0029}',
    '\u{0028}',
    '\u{0031}',
    '\u{0034}',
    '\u{0029}',
    '\u{0028}',
    '\u{0031}',
    '\u{0035}',
    '\u{0029}',
    '\u{0028}',
    '\u{0031}',
    '\u{0036}',
    '\u{0029}',
    '\u{0028}',
    '\u{0031}',
    '\u{0037}',
    '\u{0029}',
    '\u{0028}',
    '\u{0031}',
    '\u{0038}',
    '\u{0029}',
    '\u{0028}',
    '\u{0031}',
    '\u{0039}',
    '\u{0029}',
    '\u{0028}',
    '\u{0032}',
    '\u{0030}',
    '\u{0029}',
    '\u{0031}',
    '\u{002E}',
    '\u{0032}',
    '\u{002E}',
    '\u{0033}',
    '\u{002E}',
    '\u{0034}',
    '\u{002E}',
    '\u{0035}',
    '\u{002E}',
    '\u{0036}',
    '\u{002E}',
    '\u{0037}',
    '\u{002E}',
    '\u{0038}',
    '\u{002E}',
    '\u{0039}',
    '\u{002E}',
    '\u{0031}',
    '\u{0030}',
    '\u{002E}',
    '\u{0031}',
    '\u{0031}',
    '\u{002E}',
    '\u{0031}',
    '\u{0032}',
    '\u{002E}',
    '\u{0031}',
    '\u{0033}',
    '\u{002E}',
    '\u{0031}',
    '\u{0034}',
    '\u{002E}',
    '\u{0031}',
    '\u{0035}',
    '\u{002E}',
    '\u{0031}',
    '\u{0036}',
    '\u{002E}',
    '\u{0031}',
    '\u{0037}',
    '\u{002E}',
    '\u{0031}',
    '\u{0038}',
    '\u{002E}',
    '\u{0031}',
    '\u{0039}',
    '\u{002E}',
    '\u{0032}',
    '\u{0030}',
    '\u{002E}',
    '\u{0028}',
    '\u{0061}',
    '\u{0029}',
    '\u{0028}',
    '\u{0062}',
    '\u{0029}',
    '\u{0028}',
    '\u{0063}',
    '\u{0029}',
    '\u{0028}',
    '\u{0064}',
    '\u{0029}',
    '\u{0028}',
    '\u{0065}',
    '\u{0029}',
    '\u{0028}',
    '\u{0066}',
    '\u{0029}',
    '\u{0028}',
    '\u{0067}',
    '\u{0029}',
    '\u{0028}',
    '\u{0068}',
    '\u{0029}',
    '\u{0028}',
    '\u{0069}',
    '\u{0029}',
    '\u{0028}',
    '\u{006A}',
    '\u{0029}',
    '\u{0028}',
    '\u{006B}',
    '\u{0029}',
    '\u{0028}',
    '\u{006C}',
    '\u{0029}',
    '\u{0028}',
    '\u{006D}',
    '\u{0029}',
    '\u{0028}',
    '\u{006E}',
    '\u{0029}',
    '\u{0028}',
    '\u{006F}',
    '\u{0029}',
    '\u{0028}',
    '\u{0070}',
    '\u{0029}',
    '\u{0028}',
    '\u{0071}',
    '\u{0029}',
    '\u{0028}',
    '\u{0072}',
    '\u{0029}',
    '\u{0028}',
    '\u{0073}',
    '\u{0029}',
    '\u{0028}',
    '\u{0074}',
    '\u{0029}',
    '\u{0028}',
    '\u{0075}',
    '\u{0029}',
    '\u{0028}',
    '\u{0076}',
    '\u{0029}',
    '\u{0028}',
    '\u{0077}',
    '\u{0029}',
    '\u{0028}',
    '\u{0078}',
    '\u{0029}',
    '\u{0028}',
    '\u{0079}',
    '\u{0029}',
    '\u{0028}',
    '\u{007A}',
    '\u{0029}',
    '\u{0041}',
    '\u{0042}',
    '\u{0043}',
    '\u{0044}',
    '\u{0045}',
    '\u{0046}',
    '\u{0047}',
    '\u{0048}',
    '\u{0049}',
    '\u{004A}',
    '\u{004B}',
    '\u{004C}',
    '\u{004D}',
    '\u{004E}',
    '\u{004F}',
    '\u{0050}',
    '\u{0051}',
    '\u{0052}',
    '\u{0053}',
    '\u{0054}',
    '\u{0055}',
    '\u{0056}',
    '\u{0057}',
    '\u{0058}',
    '\u{0059}',
    '\u{005A}',
    '\u{0061}',
    '\u{0062}',
    '\u{0063}',
    '\u{0064}',
    '\u{0065}',
    '\u{0066}',
    '\u{0067}',
    '\u{0068}',
    '\u{0069}',
    '\u{006A}',
    '\u{006B}',
    '\u{006C}',
    '\u{006D}',
    '\u{006E}',
    '\u{006F}',
    '\u{0070}',
    '\u{0071}',
    '\u{0072}',
    '\u{0073}',
    '\u{0074}',
    '\u{0075}',
    '\u{0076}',
    '\u{0077}',
    '\u{0078}',
    '\u{0079}',
    '\u{007A}',
    '\u{0030}',
    '\u{222B}',
    '\u{222B}',
    '\u{222B}',
    '\u{222B}',
    '\u{003A}',
    '\u{003A}',
    '\u{003D}',
    '\u{003D}',
    '\u{003D}',
    '\u{003D}',
    '\u{003D}',
    '\u{003D}',
    '\u{006A}',
    '\u{0056}',
    '\u{2D61}',
    '\u{6BCD}',
    '\u{9F9F}',
    '\u{4E00}',
    '\u{4E28}',
    '\u{4E36}',
    '\u{4E3F}',
    '\u{4E59}',
    '\u{4E85}',
    '\u{4E8C}',
    '\u{4EA0}',
    '\u{4EBA}',
    '\u{513F}',
    '\u{5165}',
    '\u{516B}',
    '\u{5182}',
    '\u{5196}',
    '\u{51AB}',
    '\u{51E0}',
    '\u{51F5}',
    '\u{5200}',
    '\u{529B}',
    '\u{52F9}',
    '\u{5315}',
    '\u{531A}',
    '\u{5338}',
    '\u{5341}',
    '\u{535C}',
    '\u{5369}',
    '\u{5382}',
    '\u{53B6}',
    '\u{53C8}',
    '\u{53E3}',
    '\u{56D7}',
    '\u{571F}',
    '\u{58EB}',
    '\u{5902}',
    '\u{590A}',
    '\u{5915}',
    '\u{5927}',
    '\u{5973}',
    '\u{5B50}',
    '\u{5B80}',
    '\u{5BF8}',
    '\u{5C0F}',
    '\u{5C22}',
    '\u{5C38}',
    '\u{5C6E}',
    '\u{5C71}',
    '\u{5DDB}',
    '\u{5DE5}',
    '\u{5DF1}',
    '\u{5DFE}',
    '\u{5E72}',
    '\u{5E7A}',
    '\u{5E7F}',
    '\u{5EF4}',
    '\u{5EFE}',
    '\u{5F0B}',
    '\u{5F13}',
    '\u{5F50}',
    '\u{5F61}',
    '\u{5F73}',
    '\u{5FC3}',
    '\u{6208}',
    '\u{6236}',
    '\u{624B}',
    '\u{652F}',
    '\u{6534}',
    '\u{6587}',
    '\u{6597}',
    '\u{65A4}',
    '\u{65B9}',
    '\u{65E0}',
    '\u{65E5}',
    '\u{66F0}',
    '\u{6708}',
    '\u{6728}',
    '\u{6B20}',
    '\u{6B62}',
    '\u{6B79}',
    '\u{6BB3}',
    '\u{6BCB}',
    '\u{6BD4}',
    '\u{6BDB}',
    '\u{6C0F}',
    '\u{6C14}',
    '\u{6C34}',
    '\u{706B}',
    '\u{722A}',
    '\u{7236}',
    '\u{723B}',
    '\u{723F}',
    '\u{7247}',
    '\u{7259}',
    '\u{725B}',
    '\u{72AC}',
    '\u{7384}',
    '\u{7389}',
    '\u{74DC}',
    '\u{74E6}',
    '\u{7518}',
    '\u{751F}',
    '\u{7528}',
    '\u{7530}',
    '\u{758B}',
    '\u{7592}',
    '\u{7676}',
    '\u{767D}',
    '\u{76AE}',
    '\u{76BF}',
    '\u{76EE}',
    '\u{77DB}',
    '\u{77E2}',
    '\u{77F3}',
    '\u{793A}',
    '\u{79B8}',
    '\u{79BE}',
    '\u{7A74}',
    '\u{7ACB}',
    '\u{7AF9}',
    '\u{7C73}',
    '\u{7CF8}',
    '\u{7F36}',
    '\u{7F51}',
    '\u{7F8A}',
    '\u{7FBD}',
    '\u{8001}',
    '\u{800C}',
    '\u{8012}',
    '\u{8033}',
    '\u{807F}',
    '\u{8089}',
    '\u{81E3}',
    '\u{81EA}',
    '\u{81F3}',
    '\u{81FC}',
    '\u{820C}',
    '\u{821B}',
    '\u{821F}',
    '\u{826E}',
    '\u{8272}',
    '\u{8278}',
    '\u{864D}',
    '\u{866B}',
    '\u{8840}',
    '\u{884C}',
    '\u{8863}',
    '\u{897E}',
    '\u{898B}',
    '\u{89D2}',
    '\u{8A00}',
    '\u{8C37}',
    '\u{8C46}',
    '\u{8C55}',
    '\u{8C78}',
    '\u{8C9D}',
    '\u{8D64}',
    '\u{8D70}',
    '\u{8DB3}',
    '\u{8EAB}',
    '\u{8ECA}',
    '\u{8F9B}',
    '\u{8FB0}',
    '\u{8FB5}',
    '\u{9091}',
    '\u{9149}',
    '\u{91C6}',
    '\u{91CC}',
    '\u{91D1}',
    '\u{9577}',
    '\u{9580}',
    '\u{961C}',
    '\u{96B6}',
    '\u{96B9}',
    '\u{96E8}',
    '\u{9751}',
    '\u{975E}',
    '\u{9762}',
    '\u{9769}',
    '\u{97CB}',
    '\u{97ED}',
    '\u{97F3}',
    '\u{9801}',
    '\u{98A8}',
    '\u{98DB}',
    '\u{98DF}',
    '\u{9996}',
    '\u{9999}',
    '\u{99AC}',
    '\u{9AA8}',
    '\u{9AD8}',
    '\u{9ADF}',
    '\u{9B25}',
    '\u{9B2F}',
    '\u{9B32}',
    '\u{9B3C}',
    '\u{9B5A}',
    '\u{9CE5}',
    '\u{9E75}',
    '\u{9E7F}',
    '\u{9EA5}',
    '\u{9EBB}',
    '\u{9EC3}',
    '\u{9ECD}',
    '\u{9ED1}',
    '\u{9EF9}',
    '\u{9EFD}',
    '\u{9F0E}',
    '\u{9F13}',
    '\u{9F20}',
    '\u{9F3B}',
    '\u{9F4A}',
    '\u{9F52}',
    '\u{9F8D}',
    '\u{9F9C}',
    '\u{9FA0}',
    '\u{0020}',
    '\u{3012}',
    '\u{5341}',
    '\u{5344}',
    '\u{5345}',
    '\u{0020}',
    '\u{3099}',
    '\u{0020}',
    '\u{309A}',
    '\u{3088}',
    '\u{308A}',
    '\u{30B3}',
    '\u{30C8}',
    '\u{1100}',
    '\u{1101}',
    '\u{11AA}',
    '\u{1102}',
    '\u{11AC}',
    '\u{11AD}',
    '\u{1103}',
    '\u{1104}',
    '\u{1105}',
    '\u{11B0}',
    '\u{11B1}',
    '\u{11B2}',
    '\u{11B3}',
    '\u{11B4}',
    '\u{11B5}',
    '\u{111A}',
    '\u{1106}',
    '\u{1107}',
    '\u{1108}',
    '\u{1121}',
    '\u{1109}',
    '\u{110A}',
    '\u{110B}',
    '\u{110C}',
    '\u{110D}',
    '\u{110E}',
    '\u{110F}',
    '\u{1110}',
    '\u{1111}',
    '\u{1112}',
    '\u{1161}',
    '\u{1162}',
    '\u{1163}',
    '\u{1164}',
    '\u{1165}',
    '\u{1166}',
    '\u{1167}',
    '\u{1168}',
    '\u{1169}',
    '\u{116A}',
    '\u{116B}',
    '\u{116C}',
    '\u{116D}',
    '\u{116E}',
    '\u{116F}',
    '\u{1170}',
    '\u{1171}',
    '\u{1172}',
    '\u{1173}',
    '\u{1174}',
    '\u{1175}',
    '\u{1160}',
    '\u{1114}',
    '\u{1115}',
    '\u{11C7}',
    '\u{11C8}',
    '\u{11CC}',
    '\u{11CE}',
    '\u{11D3}',
    '\u{11D7}',
    '\u{11D9}',
    '\u{111C}',
    '\u{11DD}',
    '\u{11DF}',
    '\u{111D}',
    '\u{111E}',
    '\u{1120}',
    '\u{1122}',
    '\u{1123}',
    '\u{1127}',
    '\u{1129}',
    '\u{112B}',
    '\u{112C}',
    '\u{112D}',
    '\u{112E}',
    '\u{112F}',
    '\u{1132}',
    '\u{1136}',
    '\u{1140}',
    '\u{1147}',
    '\u{114C}',
    '\u{11F1}',
    '\u{11F2}',
    '\u{1157}',
    '\u{1158}',
    '\u{1159}',
    '\u{1184}',
    '\u{1185}',
    '\u{1188}',
    '\u{1191}',
    '\u{1192}',
    '\u{1194}',
    '\u{119E}',
    '\u{11A1}',
    '\u{4E00}',
    '\u{4E8C}',
    '\u{4E09}',
    '\u{56DB}',
    '\u{4E0A}',
    '\u{4E2D}',
    '\u{4E0B}',
    '\u{7532}',
    '\u{4E59}',
    '\u{4E19}',
    '\u{4E01}',
    '\u{5929}',
    '\u{5730}',
    '\u{4EBA}',
    '\u{0028}',
    '\u{1100}',
    '\u{0029}',
    '\u{0028}',
    '\u{1102}',
    '\u{0029}',
    '\u{0028}',
    '\u{1103}',
    '\u{0029}',
    '\u{0028}',
    '\u{1105}',
    '\u{0029}',
    '\u{0028}',
    '\u{1106}',
    '\u{0029}',
    '\u{0028}',
    '\u{1107}',
    '\u{0029}',
    '\u{0028}',
    '\u{1109}',
    '\u{0029}',
    '\u{0028}',
    '\u{110B}',
    '\u{0029}',
    '\u{0028}',
    '\u{110C}',
    '\u{0029}',
    '\u{0028}',
    '\u{110E}',
    '\u{0029}',
    '\u{0028}',
    '\u{110F}',
    '\u{0029}',
    '\u{0028}',
    '\u{1110}',
    '\u{0029}',
    '\u{0028}',
    '\u{1111}',
    '\u{0029}',
    '\u{0028}',
    '\u{1112}',
    '\u{0029}',
    '\u{0028}',
    '\u{1100}',
    '\u{1161}',
    '\u{0029}',
    '\u{0028}',
    '\u{1102}',
    '\u{1161}',
    '\u{0029}',
    '\u{0028}',
    '\u{1103}',
    '\u{1161}',
    '\u{0029}',
    '\u{0028}',
    '\u{1105}',
    '\u{1161}',
    '\u{0029}',
    '\u{0028}',
    '\u{1106}',
    '\u{1161}',
    '\u{0029}',
    '\u{0028}',
    '\u{1107}',
    '\u{1161}',
    '\u{0029}',
    '\u{0028}',
    '\u{1109}',
    '\u{1161}',
    '\u{0029}',
    '\u{0028}',
    '\u{110B}',
    '\u{1161}',
    '\u{0029}',
    '\u{0028}',
    '\u{110C}',
    '\u{1161}',
    '\u{0029}',
    '\u{0028}',
    '\u{110E}',
    '\u{1161}',
    '\u{0029}',
    '\u{0028}',
    '\u{110F}',
    '\u{1161}',
    '\u{0029}',
    '\u{0028}',
    '\u{1110}',
    '\u{1161}',
    '\u{0029}',
    '\u{0028}',
    '\u{1111}',
    '\u{1161}',
    '\u{0029}',
    '\u{0028}',
    '\u{1112}',
    '\u{1161}',
    '\u{0029}',
    '\u{0028}',
    '\u{110C}',
    '\u{116E}',
    '\u{0029}',
    '\u{0028}',
    '\u{110B}',
    '\u{1169}',
    '\u{110C}',
    '\u{1165}',
    '\u{11AB}',
    '\u{0029}',
    '\u{0028}',
    '\u{110B}',
    '\u{1169}',
    '\u{1112}',
    '\u{116E}',
    '\u{0029}',
    '\u{0028}',
    '\u{4E00}',
    '\u{0029}',
    '\u{0028}',
    '\u{4E8C}',
    '\u{0029}',
    '\u{0028}',
    '\u{4E09}',
    '\u{0029}',
    '\u{0028}',
    '\u{56DB}',
    '\u{0029}',
    '\u{0028}',
    '\u{4E94}',
    '\u{0029}',
    '\u{0028}',
    '\u{516D}',
    '\u{0029}',
    '\u{0028}',
    '\u{4E03}',
    '\u{0029}',
    '\u{0028}',
    '\u{516B}',
    '\u{0029}',
    '\u{0028}',
    '\u{4E5D}',
    '\u{0029}',
    '\u{0028}',
    '\u{5341}',
    '\u{0029}',
    '\u{0028}',
    '\u{6708}',
    '\u{0029}',
    '\u{0028}',
    '\u{706B}',
    '\u{0029}',
    '\u{0028}',
    '\u{6C34}',
    '\u{0029}',
    '\u{0028}',
    '\u{6728}',
    '\u{0029}',
    '\u{0028}',
    '\u{91D1}',
    '\u{0029}',
    '\u{0028}',
    '\u{571F}',
    '\u{0029}',
    '\u{0028}',
    '\u{65E5}',
    '\u{0029}',
    '\u{0028}',
    '\u{682A}',
    '\u{0029}',
    '\u{0028}',
    '\u{6709}',
    '\u{0029}',
    '\u{0028}',
    '\u{793E}',
    '\u{0029}',
    '\u{0028}',
    '\u{540D}',
    '\u{0029}',
    '\u{0028}',
    '\u{7279}',
    '\u{0029}',
    '\u{0028}',
    '\u{8CA1}',
    '\u{0029}',
    '\u{0028}',
    '\u{795D}',
    '\u{0029}',
    '\u{0028}',
    '\u{52B4}',
    '\u{0029}',
    '\u{0028}',
    '\u{4EE3}',
    '\u{0029}',
    '\u{0028}',
    '\u{547C}',
    '\u{0029}',
    '\u{0028}',
    '\u{5B66}',
    '\u{0029}',
    '\u{0028}',
    '\u{76E3}',
    '\u{0029}',
    '\u{0028}',
    '\u{4F01}',
    '\u{0029}',
    '\u{0028}',
    '\u{8CC7}',
    '\u{0029}',
    '\u{0028}',
    '\u{5354}',
    '\u{0029}',
    '\u{0028}',
    '\u{796D}',
    '\u{0029}',
    '\u{0028}',
    '\u{4F11}',
    '\u{0029}',
    '\u{0028}',
    '\u{81EA}',
    '\u{0029}',
    '\u{0028}',
    '\u{81F3}',
    '\u{0029}',
    '\u{554F}',
    '\u{5E7C}',
    '\u{6587}',
    '\u{7B8F}',
    '\u{0050}',
    '\u{0054}',
    '\u{0045}',
    '\u{0032}',
    '\u{0031}',
    '\u{0032}',
    '\u{0032}',
    '\u{0032}',
    '\u{0033}',
    '\u{0032}',
    '\u{0034}',
    '\u{0032}',
    '\u{0035}',
    '\u{0032}',
    '\u{0036}',
    '\u{0032}',
    '\u{0037}',
    '\u{0032}',
    '\u{0038}',
    '\u{0032}',
    '\u{0039}',
    '\u{0033}',
    '\u{0030}',
    '\u{0033}',
    '\u{0031}',
    '\u{0033}',
    '\u{0032}',
    '\u{0033}',
    '\u{0033}',
    '\u{0033}',
    '\u{0034}',
    '\u{0033}',
    '\u{0035}',
    '\u{1100}',
    '\u{1102}',
    '\u{1103}',
    '\u{1105}',
    '\u{1106}',
    '\u{1107}',
    '\u{1109}',
    '\u{110B}',
    '\u{110C}',
    '\u{110E}',
    '\u{110F}',
    '\u{1110}',
    '\u{1111}',
    '\u{1112}',
    '\u{1100}',
    '\u{1161}',
    '\u{1102}',
    '\u{1161}',
    '\u{1103}',
    '\u{1161}',
    '\u{1105}',
    '\u{1161}',
    '\u{1106}',
    '\u{1161}',
    '\u{1107}',
    '\u{1161}',
    '\u{1109}',
    '\u{1161}',
    '\u{110B}',
    '\u{1161}',
    '\u{110C}',
    '\u{1161}',
    '\u{110E}',
    '\u{1161}',
    '\u{110F}',
    '\u{1161}',
    '\u{1110}',
    '\u{1161}',
    '\u{1111}',
    '\u{1161}',
    '\u{1112}',
    '\u{1161}',
    '\u{110E}',
    '\u{1161}',
    '\u{11B7}',
    '\u{1100}',
    '\u{1169}',
    '\u{110C}',
    '\u{116E}',
    '\u{110B}',
    '\u{1174}',
    '\u{110B}',
    '\u{116E}',
    '\u{4E00}',
    '\u{4E8C}',
    '\u{4E09}',
    '\u{56DB}',
    '\u{4E94}',
    '\u{516D}',
    '\u{4E03}',
    '\u{516B}',
    '\u{4E5D}',
    '\u{5341}',
    '\u{6708}',
    '\u{706B}',
    '\u{6C34}',
    '\u{6728}',
    '\u{91D1}',
    '\u{571F}',
    '\u{65E5}',
    '\u{682A}',
    '\u{6709}',
    '\u{793E}',
    '\u{540D}',
    '\u{7279}',
    '\u{8CA1}',
    '\u{795D}',
    '\u{52B4}',
    '\u{79D8}',
    '\u{7537}',
    '\u{5973}',
    '\u{9069}',
    '\u{512A}',
    '\u{5370}',
    '\u{6CE8}',
    '\u{9805}',
    '\u{4F11}',
    '\u{5199}',
    '\u{6B63}',
    '\u{4E0A}',
    '\u{4E2D}',
    '\u{4E0B}',
    '\u{5DE6}',
    '\u{53F3}',
    '\u{533B}',
    '\u{5B97}',
    '\u{5B66}',
    '\u{76E3}',
    '\u{4F01}',
    '\u{8CC7}',
    '\u{5354}',
    '\u{591C}',
    '\u{0033}',
    '\u{0036}',
    '\u{0033}',
    '\u{0037}',
    '\u{0033}',
    '\u{0038}',
    '\u{0033}',
    '\u{0039}',
    '\u{0034}',
    '\u{0030}',
    '\u{0034}',
    '\u{0031}',
    '\u{0034}',
    '\u{0032}',
    '\u{0034}',
    '\u{0033}',
    '\u{0034}',
    '\u{0034}',
    '\u{0034}',
    '\u{0035}',
    '\u{0034}',
    '\u{0036}',
    '\u{0034}',
    '\u{0037}',
    '\u{0034}',
    '\u{0038}',
    '\u{0034}',
    '\u{0039}',
    '\u{0035}',
    '\u{0030}',
    '\u{0031}',
    '\u{6708}',
    '\u{0032}',
    '\u{6708}',
    '\u{0033}',
    '\u{6708}',
    '\u{0034}',
    '\u{6708}',
    '\u{0035}',
    '\u{6708}',
    '\u{0036}',
    '\u{6708}',
    '\u{0037}',
    '\u{6708}',
    '\u{0038}',
    '\u{6708}',
    '\u{0039}',
    '\u{6708}',
    '\u{0031}',
    '\u{0030}',
    '\u{6708}',
    '\u{0031}',
    '\u{0031}',
    '\u{6708}',
    '\u{0031}',
    '\u{0032}',
    '\u{6708}',
    '\u{0048}',
    '\u{0067}',
    '\u{0065}',
    '\u{0072}',
    '\u{0067}',
    '\u{0065}',
    '\u{0056}',
    '\u{004C}',
    '\u{0054}',
    '\u{0044}',
    '\u{30A2}',
    '\u{30A4}',
    '\u{30A6}',
    '\u{30A8}',
    '\u{30AA}',
    '\u{30AB}',
    '\u{30AD}',
    '\u{30AF}',
    '\u{30B1}',
    '\u{30B3}',
    '\u{30B5}',
    '\u{30B7}',
    '\u{30B9}',
    '\u{30BB}',
    '\u{30BD}',
    '\u{30BF}',
    '\u{30C1}',
    '\u{30C4}',
    '\u{30C6}',
    '\u{30C8}',
    '\u{30CA}',
    '\u{30CB}',
    '\u{30CC}',
    '\u{30CD}',
    '\u{30CE}',
    '\u{30CF}',
    '\u{30D2}',
    '\u{30D5}',
    '\u{30D8}',
    '\u{30DB}',
    '\u{30DE}',
    '\u{30DF}',
    '\u{30E0}',
    '\u{30E1}',
    '\u{30E2}',
    '\u{30E4}',
    '\u{30E6}',
    '\u{30E8}',
    '\u{30E9}',
    '\u{30EA}',
    '\u{30EB}',
    '\u{30EC}',
    '\u{30ED}',
    '\u{30EF}',
    '\u{30F0}',
    '\u{30F1}',
    '\u{30F2}',
    '\u{4EE4}',
    '\u{548C}',
    '\u{30A2}',
    '\u{30CF}',
    '\u{309A}',
    '\u{30FC}',
    '\u{30C8}',
    '\u{30A2}',
    '\u{30EB}',
    '\u{30D5}',
    '\u{30A1}',
    '\u{30A2}',
    '\u{30F3}',
    '\u{30D8}',
    '\u{309A}',
    '\u{30A2}',
    '\u{30A2}',
    '\u{30FC}',
    '\u{30EB}',
    '\u{30A4}',
    '\u{30CB}',
    '\u{30F3}',
    '\u{30AF}',
    '\u{3099}',
    '\u{30A4}',
    '\u{30F3}',
    '\u{30C1}',
    '\u{30A6}',
    '\u{30A9}',
    '\u{30F3}',
    '\u{30A8}',
    '\u{30B9}',
    '\u{30AF}',
    '\u{30FC}',
    '\u{30C8}',
    '\u{3099}',
    '\u{30A8}',
    '\u{30FC}',
    '\u{30AB}',
    '\u{30FC}',
    '\u{30AA}',
    '\u{30F3}',
    '\u{30B9}',
    '\u{30AA}',
    '\u{30FC}',
    '\u{30E0}',
    '\u{30AB}',
    '\u{30A4}',
    '\u{30EA}',
    '\u{30AB}',
    '\u{30E9}',
    '\u{30C3}',
    '\u{30C8}',
    '\u{30AB}',
    '\u{30ED}',
    '\u{30EA}',
    '\u{30FC}',
    '\u{30AB}',
    '\u{3099}',
    '\u{30ED}',
    '\u{30F3}',
    '\u{30AB}',
    '\u{3099}',
    '\u{30F3}',
    '\u{30DE}',
    '\u{30AD}',
    '\u{3099}',
    '\u{30AB}',
    '\u{3099}',
    '\u{30AD}',
    '\u{3099}',
    '\u{30CB}',
    '\u{30FC}',
    '\u{30AD}',
    '\u{30E5}',
    '\u{30EA}',
    '\u{30FC}',
    '\u{30AD}',
    '\u{3099}',
    '\u{30EB}',
    '\u{30BF}',
    '\u{3099}',
    '\u{30FC}',
    '\u{30AD}',
    '\u{30ED}',
    '\u{30AD}',
    '\u{30ED}',
    '\u{30AF}',
    '\u{3099}',
    '\u{30E9}',
    '\u{30E0}',
    '\u{30AD}',
    '\u{30ED}',
    '\u{30E1}',
    '\u{30FC}',
    '\u{30C8}',
    '\u{30EB}',
    '\u{30AD}',
    '\u{30ED}',
    '\u{30EF}',
    '\u{30C3}',
    '\u{30C8}',
    '\u{30AF}',
    '\u{3099}',
    '\u{30E9}',
    '\u{30E0}',
    '\u{30AF}',
    '\u{3099}',
    '\u{30E9}',
    '\u{30E0}',
    '\u{30C8}',
    '\u{30F3}',
    '\u{30AF}',
    '\u{30EB}',
    '\u{30BB}',
    '\u{3099}',
    '\u{30A4}',
    '\u{30ED}',
    '\u{30AF}',
    '\u{30ED}',
    '\u{30FC}',
    '\u{30CD}',
    '\u{30B1}',
    '\u{30FC}',
    '\u{30B9}',
    '\u{30B3}',
    '\u{30EB}',
    '\u{30CA}',
    '\u{30B3}',
    '\u{30FC}',
    '\u{30DB}',
    '\u{309A}',
    '\u{30B5}',
    '\u{30A4}',
    '\u{30AF}',
    '\u{30EB}',
    '\u{30B5}',
    '\u{30F3}',
    '\u{30C1}',
    '\u{30FC}',
    '\u{30E0}',
    '\u{30B7}',
    '\u{30EA}',
    '\u{30F3}',
    '\u{30AF}',
    '\u{3099}',
    '\u{30BB}',
    '\u{30F3}',
    '\u{30C1}',
    '\u{30BB}',
    '\u{30F3}',
    '\u{30C8}',
    '\u{30BF}',
    '\u{3099}',
    '\u{30FC}',
    '\u{30B9}',
    '\u{30C6}',
    '\u{3099}',
    '\u{30B7}',
    '\u{30C8}',
    '\u{3099}',
    '\u{30EB}',
    '\u{30C8}',
    '\u{30F3}',
    '\u{30CA}',
    '\u{30CE}',
    '\u{30CE}',
    '\u{30C3}',
    '\u{30C8}',
    '\u{30CF}',
    '\u{30A4}',
    '\u{30C4}',
    '\u{30CF}',
    '\u{309A}',
    '\u{30FC}',
    '\u{30BB}',
    '\u{30F3}',
    '\u{30C8}',
    '\u{30CF}',
    '\u{309A}',
    '\u{30FC}',
    '\u{30C4}',
    '\u{30CF}',
    '\u{3099}',
    '\u{30FC}',
    '\u{30EC}',
    '\u{30EB}',
    '\u{30D2}',
    '\u{309A}',
    '\u{30A2}',
    '\u{30B9}',
    '\u{30C8}',
    '\u{30EB}',
    '\u{30D2}',
    '\u{309A}',
    '\u{30AF}',
    '\u{30EB}',
    '\u{30D2}',
    '\u{309A}',
    '\u{30B3}',
    '\u{30D2}',
    '\u{3099}',
    '\u{30EB}',
    '\u{30D5}',
    '\u{30A1}',
    '\u{30E9}',
    '\u{30C3}',
    '\u{30C8}',
    '\u{3099}',
    '\u{30D5}',
    '\u{30A3}',
    '\u{30FC}',
    '\u{30C8}',
    '\u{30D5}',
    '\u{3099}',
    '\u{30C3}',
    '\u{30B7}',
    '\u{30A7}',
    '\u{30EB}',
    '\u{30D5}',
    '\u{30E9}',
    '\u{30F3}',
    '\u{30D8}',
    '\u{30AF}',
    '\u{30BF}',
    '\u{30FC}',
    '\u{30EB}',
    '\u{30D8}',
    '\u{309A}',
    '\u{30BD}',
    '\u{30D8}',
    '\u{309A}',
    '\u{30CB}',
    '\u{30D2}',
    '\u{30D8}',
    '\u{30EB}',
    '\u{30C4}',
    '\u{30D8}',
    '\u{309A}',
    '\u{30F3}',
    '\u{30B9}',
    '\u{30D8}',
    '\u{309A}',
    '\u{30FC}',
    '\u{30B7}',
    '\u{3099}',
    '\u{30D8}',
    '\u{3099}',
    '\u{30FC}',
    '\u{30BF}',
    '\u{30DB}',
    '\u{309A}',
    '\u{30A4}',
    '\u{30F3}',
    '\u{30C8}',
    '\u{30DB}',
    '\u{3099}',
    '\u{30EB}',
    '\u{30C8}',
    '\u{30DB}',
    '\u{30F3}',
    '\u{30DB}',
    '\u{309A}',
    '\u{30F3}',
    '\u{30C8}',
    '\u{3099}',
    '\u{30DB}',
    '\u{30FC}',
    '\u{30EB}',
    '\u{30DB}',
    '\u{30FC}',
    '\u{30F3}',
    '\u{30DE}',
    '\u{30A4}',
    '\u{30AF}',
    '\u{30ED}',
    '\u{30DE}',
    '\u{30A4}',
    '\u{30EB}',
    '\u{30DE}',
    '\u{30C3}',
    '\u{30CF}',
    '\u{30DE}',
    '\u{30EB}',
    '\u{30AF}',
    '\u{30DE}',
    '\u{30F3}',
    '\u{30B7}',
    '\u{30E7}',
    '\u{30F3}',
    '\u{30DF}',
    '\u{30AF}',
    '\u{30ED}',
    '\u{30F3}',
    '\u{30DF}',
    '\u{30EA}',
    '\u{30DF}',
    '\u{30EA}',
    '\u{30CF}',
    '\u{3099}',
    '\u{30FC}',
    '\u{30EB}',
    '\u{30E1}',
    '\u{30AB}',
    '\u{3099}',
    '\u{30E1}',
    '\u{30AB}',
    '\u{3099}',
    '\u{30C8}',
    '\u{30F3}',
    '\u{30E1}',
    '\u{30FC}',
    '\u{30C8}',
    '\u{30EB}',
    '\u{30E4}',
    '\u{30FC}',
    '\u{30C8}',
    '\u{3099}',
    '\u{30E4}',
    '\u{30FC}',
    '\u{30EB}',
    '\u{30E6}',
    '\u{30A2}',
    '\u{30F3}',
    '\u{30EA}',
    '\u{30C3}',
    '\u{30C8}',
    '\u{30EB}',
    '\u{30EA}',
    '\u{30E9}',
    '\u{30EB}',
    '\u{30D2}',
    '\u{309A}',
    '\u{30FC}',
    '\u{30EB}',
    '\u{30FC}',
    '\u{30D5}',
    '\u{3099}',
    '\u{30EB}',
    '\u{30EC}',
    '\u{30E0}',
    '\u{30EC}',
    '\u{30F3}',
    '\u{30C8}',
    '\u{30B1}',
    '\u{3099}',
    '\u{30F3}',
    '\u{30EF}',
    '\u{30C3}',
    '\u{30C8}',
    '\u{0030}',
    '\u{70B9}',
    '\u{0031}',
    '\u{70B9}',
    '\u{0032}',
    '\u{70B9}',
    '\u{0033}',
    '\u{70B9}',
    '\u{0034}',
    '\u{70B9}',
    '\u{0035}',
    '\u{70B9}',
    '\u{0036}',
    '\u{70B9}',
    '\u{0037}',
    '\u{70B9}',
    '\u{0038}',
    '\u{70B9}',
    '\u{0039}',
    '\u{70B9}',
    '\u{0031}',
    '\u{0030}',
    '\u{70B9}',
    '\u{0031}',
    '\u{0031}',
    '\u{70B9}',
    '\u{0031}',
    '\u{0032}',
    '\u{70B9}',
    '\u{0031}',
    '\u{0033}',
    '\u{70B9}',
    '\u{0031}',
    '\u{0034}',
    '\u{70B9}',
    '\u{0031}',
    '\u{0035}',
    '\u{70B9}',
    '\u{0031}',
    '\u{0036}',
    '\u{70B9}',
    '\u{0031}',
    '\u{0037}',
    '\u{70B9}',
    '\u{0031}',
    '\u{0038}',
    '\u{70B9}',
    '\u{0031}',
    '\u{0039}',
    '\u{70B9}',
    '\u{0032}',
    '\u{0030}',
    '\u{70B9}',
    '\u{0032}',
    '\u{0031}',
    '\u{70B9}',
    '\u{0032}',
    '\u{0032}',
    '\u{70B9}',
    '\u{0032}',
    '\u{0033}',
    '\u{70B9}',
    '\u{0032}',
    '\u{0034}',
    '\u{70B9}',
    '\u{0068}',
    '\u{0050}',
    '\u{0061}',
    '\u{0064}',
    '\u{0061}',
    '\u{0041}',
    '\u{0055}',
    '\u{0062}',
    '\u{0061}',
    '\u{0072}',
    '\u{006F}',
    '\u{0056}',
    '\u{0070}',
    '\u{0063}',
    '\u{0064}',
    '\u{006D}',
    '\u{0064}',
    '\u{006D}',
    '\u{0032}',
    '\u{0064}',
    '\u{006D}',
    '\u{0033}',
    '\u{0049}',
    '\u{0055}',
    '\u{5E73}',
    '\u{6210}',
    '\u{662D}',
    '\u{548C}',
    '\u{5927}',
    '\u{6B63}',
    '\u{660E}',
    '\u{6CBB}',
    '\u{682A}',
    '\u{5F0F}',
    '\u{4F1A}',
    '\u{793E}',
    '\u{0070}',
    '\u{0041}',
    '\u{006E}',
    '\u{0041}',
    '\u{03BC}',
    '\u{0041}',
    '\u{006D}',
    '\u{0041}',
    '\u{006B}',
    '\u{0041}',
    '\u{004B}',
    '\u{0042}',
    '\u{004D}',
    '\u{0042}',
    '\u{0047}',
    '\u{0042}',
    '\u{0063}',
    '\u{0061}',
    '\u{006C}',
    '\u{006B}',
    '\u{0063}',
    '\u{0061}',
    '\u{006C}',
    '\u{0070}',
    '\u{0046}',
    '\u{006E}',
    '\u{0046}',
    '\u{03BC}',
    '\u{0046}',
    '\u{03BC}',
    '\u{0067}',
    '\u{006D}',
    '\u{0067}',
    '\u{006B}',
    '\u{0067}',
    '\u{0048}',
    '\u{007A}',
    '\u{006B}',
    '\u{0048}',
    '\u{007A}',
    '\u{004D}',
    '\u{0048}',
    '\u{007A}',
    '\u{0047}',
    '\u{0048}',
    '\u{007A}',
    '\u{0054}',
    '\u{0048}',
    '\u{007A}',
    '\u{03BC}',
    '\u{006C}',
    '\u{006D}',
    '\u{006C}',
    '\u{0064}',
    '\u{006C}',
    '\u{006B}',
    '\u{006C}',
    '\u{0066}',
    '\u{006D}',
    '\u{006E}',
    '\u{006D}',
    '\u{03BC}',
    '\u{006D}',
    '\u{006D}',
    '\u{006D}',
    '\u{0063}',
    '\u{006D}',
    '\u{006B}',
    '\u{006D}',
    '\u{006D}',
    '\u{006D}',
    '\u{0032}',
    '\u{0063}',
    '\u{006D}',
    '\u{0032}',
    '\u{006D}',
    '\u{0032}',
    '\u{006B}',
    '\u{006D}',
    '\u{0032}',
    '\u{006D}',
    '\u{006D}',
    '\u{0033}',
    '\u{0063}',
    '\u{006D}',
    '\u{0033}',
    '\u{006D}',
    '\u{0033}',
    '\u{006B}',
    '\u{006D}',
    '\u{0033}',
    '\u{006D}',
    '\u{2215}',
    '\u{0073}',
    '\u{006D}',
    '\u{2215}',
    '\u{0073}',
    '\u{0032}',
    '\u{0050}',
    '\u{0061}',
    '\u{006B}',
    '\u{0050}',
    '\u{0061}',
    '\u{004D}',
    '\u{0050}',
    '\u{0061}',
    '\u{0047}',
    '\u{0050}',
    '\u{0061}',
    '\u{0072}',
    '\u{0061}',
    '\u{0064}',
    '\u{0072}',
    '\u{0061}',
    '\u{0064}',
    '\u{2215}',
    '\u{0073}',
    '\u{0072}',
    '\u{0061}',
    '\u{0064}',
    '\u{2215}',
    '\u{0073}',
    '\u{0032}',
    '\u{0070}',
    '\u{0073}',
    '\u{006E}',
    '\u{0073}',
    '\u{03BC}',
    '\u{0073}',
    '\u{006D}',
    '\u{0073}',
    '\u{0070}',
    '\u{0056}',
    '\u{006E}',
    '\u{0056}',
    '\u{03BC}',
    '\u{0056}',
    '\u{006D}',
    '\u{0056}',
    '\u{006B}',
    '\u{0056}',
    '\u{004D}',
    '\u{0056}',
    '\u{0070}',
    '\u{0057}',
    '\u{006E}',
    '\u{0057}',
    '\u{03BC}',
    '\u{0057}',
    '\u{006D}',
    '\u{0057}',
    '\u{006B}',
    '\u{0057}',
    '\u{004D}',
    '\u{0057}',
    '\u{006B}',
    '\u{03A9}',
    '\u{004D}',
    '\u{03A9}',
    '\u{0061}',
    '\u{002E}',
    '\u{006D}',
    '\u{002E}',
    '\u{0042}',
    '\u{0071}',
    '\u{0063}',
    '\u{0063}',
    '\u{0063}',
    '\u{0064}',
    '\u{0043}',
    '\u{2215}',
    '\u{006B}',
    '\u{0067}',
    '\u{0043}',
    '\u{006F}',
    '\u{002E}',
    '\u{0064}',
    '\u{0042}',
    '\u{0047}',
    '\u{0079}',
    '\u{0068}',
    '\u{0061}',
    '\u{0048}',
    '\u{0050}',
    '\u{0069}',
    '\u{006E}',
    '\u{004B}',
    '\u{004B}',
    '\u{004B}',
    '\u{004D}',
    '\u{006B}',
    '\u{0074}',
    '\u{006C}',
    '\u{006D}',
    '\u{006C}',
    '\u{006E}',
    '\u{006C}',
    '\u{006F}',
    '\u{0067}',
    '\u{006C}',
    '\u{0078}',
    '\u{006D}',
    '\u{0062}',
    '\u{006D}',
    '\u{0069}',
    '\u{006C}',
    '\u{006D}',
    '\u{006F}',
    '\u{006C}',
    '\u{0050}',
    '\u{0048}',
    '\u{0070}',
    '\u{002E}',
    '\u{006D}',
    '\u{002E}',
    '\u{0050}',
    '\u{0050}',
    '\u{004D}',
    '\u{0050}',
    '\u{0052}',
    '\u{0073}',
    '\u{0072}',
    '\u{0053}',
    '\u{0076}',
    '\u{0057}',
    '\u{0062}',
    '\u{0056}',
    '\u{2215}',
    '\u{006D}',
    '\u{0041}',
    '\u{2215}',
    '\u{006D}',
    '\u{0031}',
    '\u{65E5}',
    '\u{0032}',
    '\u{65E5}',
    '\u{0033}',
    '\u{65E5}',
    '\u{0034}',
    '\u{65E5}',
    '\u{0035}',
    '\u{65E5}',
    '\u{0036}',
    '\u{65E5}',
    '\u{0037}',
    '\u{65E5}',
    '\u{0038}',
    '\u{65E5}',
    '\u{0039}',
    '\u{65E5}',
    '\u{0031}',
    '\u{0030}',
    '\u{65E5}',
    '\u{0031}',
    '\u{0031}',
    '\u{65E5}',
    '\u{0031}',
    '\u{0032}',
    '\u{65E5}',
    '\u{0031}',
    '\u{0033}',
    '\u{65E5}',
    '\u{0031}',
    '\u{0034}',
    '\u{65E5}',
    '\u{0031}',
    '\u{0035}',
    '\u{65E5}',
    '\u{0031}',
    '\u{0036}',
    '\u{65E5}',
    '\u{0031}',
    '\u{0037}',
    '\u{65E5}',
    '\u{0031}',
    '\u{0038}',
    '\u{65E5}',
    '\u{0031}',
    '\u{0039}',
    '\u{65E5}',
    '\u{0032}',
    '\u{0030}',
    '\u{65E5}',
    '\u{0032}',
    '\u{0031}',
    '\u{65E5}',
    '\u{0032}',
    '\u{0032}',
    '\u{65E5}',
    '\u{0032}',
    '\u{0033}',
    '\u{65E5}',
    '\u{0032}',
    '\u{0034}',
    '\u{65E5}',
    '\u{0032}',
    '\u{0035}',
    '\u{65E5}',
    '\u{0032}',
    '\u{0036}',
    '\u{65E5}',
    '\u{0032}',
    '\u{0037}',
    '\u{65E5}',
    '\u{0032}',
    '\u{0038}',
    '\u{65E5}',
    '\u{0032}',
    '\u{0039}',
    '\u{65E5}',
    '\u{0033}',
    '\u{0030}',
    '\u{65E5}',
    '\u{0033}',
    '\u{0031}',
    '\u{65E5}',
    '\u{0067}',
    '\u{0061}',
    '\u{006C}',
    '\u{044A}',
    '\u{044C}',
    '\u{A76F}',
    '\u{0043}',
    '\u{0046}',
    '\u{0051}',
    '\u{0126}',
    '\u{0153}',
    '\u{A727}',
    '\u{AB37}',
    '\u{026B}',
    '\u{AB52}',
    '\u{028D}',
    '\u{0066}',
    '\u{0066}',
    '\u{0066}',
    '\u{0069}',
    '\u{0066}',
    '\u{006C}',
    '\u{0066}',
    '\u{0066}',
    '\u{0069}',
    '\u{0066}',
    '\u{0066}',
    '\u{006C}',
    '\u{0073}',
    '\u{0074}',
    '\u{0073}',
    '\u{0074}',
    '\u{0574}',
    '\u{0576}',
    '\u{0574}',
    '\u{0565}',
    '\u{0574}',
    '\u{056B}',
    '\u{057E}',
    '\u{0576}',
    '\u{0574}',
    '\u{056D}',
    '\u{05E2}',
    '\u{05D0}',
    '\u{05D3}',
    '\u{05D4}',
    '\u{05DB}',
    '\u{05DC}',
    '\u{05DD}',
    '\u{05E8}',
    '\u{05EA}',
    '\u{002B}',
    '\u{05D0}',
    '\u{05DC}',
    '\u{0671}',
    '\u{0671}',
    '\u{067B}',
    '\u{067B}',
    '\u{067B}',
    '\u{067B}',
    '\u{067E}',
    '\u{067E}',
    '\u{067E}',
    '\u{067E}',
    '\u{0680}',
    '\u{0680}',
    '\u{0680}',
    '\u{0680}',
    '\u{067A}',
    '\u{067A}',
    '\u{067A}',
    '\u{067A}',
    '\u{067F}',
    '\u{067F}',
    '\u{067F}',
    '\u{067F}',
    '\u{0679}',
    '\u{0679}',
    '\u{0679}',
    '\u{0679}',
    '\u{06A4}',
    '\u{06A4}',
    '\u{06A4}',
    '\u{06A4}',
    '\u{06A6}',
    '\u{06A6}',
    '\u{06A6}',
    '\u{06A6}',
    '\u{0684}',
    '\u{0684}',
    '\u{0684}',
    '\u{0684}',
    '\u{0683}',
    '\u{0683}',
    '\u{0683}',
    '\u{0683}',
    '\u{0686}',
    '\u{0686}',
    '\u{0686}',
    '\u{0686}',
    '\u{0687}',
    '\u{0687}',
    '\u{0687}',
    '\u{0687}',
    '\u{068D}',
    '\u{068D}',
    '\u{068C}',
    '\u{068C}',
    '\u{068E}',
    '\u{068E}',
    '\u{0688}',
    '\u{0688}',
    '\u{0698}',
    '\u{0698}',
    '\u{0691}',
    '\u{0691}',
    '\u{06A9}',
    '\u{06A9}',
    '\u{06A9}',
    '\u{06A9}',
    '\u{06AF}',
    '\u{06AF}',
    '\u{06AF}',
    '\u{06AF}',
    '\u{06B3}',
    '\u{06B3}',
    '\u{06B3}',
    '\u{06B3}',
    '\u{06B1}',
    '\u{06B1}',
    '\u{06B1}',
    '\u{06B1}',
    '\u{06BA}',
    '\u{06BA}',
    '\u{06BB}',
    '\u{06BB}',
    '\u{06BB}',
    '\u{06BB}',
    '\u{06D5}',
    '\u{0654}',
    '\u{06D5}',
    '\u{0654}',
    '\u{06C1}',
    '\u{06C1}',
    '\u{06C1}',
    '\u{06C1}',
    '\u{06BE}',
    '\u{06BE}',
    '\u{06BE}',
    '\u{06BE}',
    '\u{06D2}',
    '\u{06D2}',
    '\u{06D2}',
    '\u{0654}',
    '\u{06D2}',
    '\u{0654}',
    '\u{06AD}',
    '\u{06AD}',
    '\u{06AD}',
    '\u{06AD}',
    '\u{06C7}',
    '\u{06C7}',
    '\u{06C6}',
    '\u{06C6}',
    '\u{06C8}',
    '\u{06C8}',
    '\u{06C7}',
    '\u{0674}',
    '\u{06CB}',
    '\u{06CB}',
    '\u{06C5}',
    '\u{06C5}',
    '\u{06C9}',
    '\u{06C9}',
    '\u{06D0}',
    '\u{06D0}',
    '\u{06D0}',
    '\u{06D0}',
    '\u{0649}',
    '\u{0649}',
    '\u{064A}',
    '\u{0654}',
    '\u{0627}',
    '\u{064A}',
    '\u{0654}',
    '\u{0627}',
    '\u{064A}',
    '\u{0654}',
    '\u{06D5}',
    '\u{064A}',
    '\u{0654}',
    '\u{06D5}',
    '\u{064A}',
    '\u{0654}',
    '\u{0648}',
    '\u{064A}',
    '\u{0654}',
    '\u{0648}',
    '\u{064A}',
    '\u{0654}',
    '\u{06C7}',
    '\u{064A}',
    '\u{0654}',
    '\u{06C7}',
    '\u{064A}',
    '\u{0654}',
    '\u{06C6}',
    '\u{064A}',
    '\u{0654}',
    '\u{06C6}',
    '\u{064A}',
    '\u{0654}',
    '\u{06C8}',
    '\u{064A}',
    '\u{0654}',
    '\u{06C8}',
    '\u{064A}',
    '\u{0654}',
    '\u{06D0}',
    '\u{064A}',
    '\u{0654}',
    '\u{06D0}',
    '\u{064A}',
    '\u{0654}',
    '\u{06D0}',
    '\u{064A}',
    '\u{0654}',
    '\u{0649}',
    '\u{064A}',
    '\u{0654}',
    '\u{0649}',
    '\u{064A}',
    '\u{0654}',
    '\u{0649}',
    '\u{06CC}',
    '\u{06CC}',
    '\u{06CC}',
    '\u{06CC}',
    '\u{064A}',
    '\u{0654}',
    '\u{062C}',
    '\u{064A}',
    '\u{0654}',
    '\u{062D}',
    '\u{064A}',
    '\u{0654}',
    '\u{0645}',
    '\u{064A}',
    '\u{0654}',
    '\u{0649}',
    '\u{064A}',
    '\u{0654}',
    '\u{064A}',
    '\u{0628}',
    '\u{062C}',
    '\u{0628}',
    '\u{062D}',
    '\u{0628}',
    '\u{062E}',
    '\u{0628}',
    '\u{0645}',
    '\u{0628}',
    '\u{0649}',
    '\u{0628}',
    '\u{064A}',
    '\u{062A}',
    '\u{062C}',
    '\u{062A}',
    '\u{062D}',
    '\u{062A}',
    '\u{062E}',
    '\u{062A}',
    '\u{0645}',
    '\u{062A}',
    '\u{0649}',
    '\u{062A}',
    '\u{064A}',
    '\u{062B}',
    '\u{062C}',
    '\u{062B}',
    '\u{0645}',
    '\u{062B}',
    '\u{0649}',
    '\u{062B}',
    '\u{064A}',
    '\u{062C}',
    '\u{062D}',
    '\u{062C}',
    '\u{0645}',
    '\u{062D}',
    '\u{062C}',
    '\u{062D}',
    '\u{0645}',
    '\u{062E}',
    '\u{062C}',
    '\u{062E}',
    '\u{062D}',
    '\u{062E}',
    '\u{0645}',
    '\u{0633}',
    '\u{062C}',
    '\u{0633}',
    '\u{062D}',
    '\u{0633}',
    '\u{062E}',
    '\u{0633}',
    '\u{0645}',
    '\u{0635}',
    '\u{062D}',
    '\u{0635}',
    '\u{0645}',
    '\u{0636}',
    '\u{062C}',
    '\u{0636}',
    '\u{062D}',
    '\u{0636}',
    '\u{062E}',
    '\u{0636}',
    '\u{0645}',
    '\u{0637}',
    '\u{062D}',
    '\u{0637}',
    '\u{0645}',
    '\u{0638}',
    '\u{0645}',
    '\u{0639}',
    '\u{062C}',
    '\u{0639}',
    '\u{0645}',
    '\u{063A}',
    '\u{062C}',
    '\u{063A}',
    '\u{0645}',
    '\u{0641}',
    '\u{062C}',
    '\u{0641}',
    '\u{062D}',
    '\u{0641}',
    '\u{062E}',
    '\u{0641}',
    '\u{0645}',
    '\u{0641}',
    '\u{0649}',
    '\u{0641}',
    '\u{064A}',
    '\u{0642}',
    '\u{062D}',
    '\u{0642}',
    '\u{0645}',
    '\u{0642}',
    '\u{0649}',
    '\u{0642}',
    '\u{064A}',
    '\u{0643}',
    '\u{0627}',
    '\u{0643}',
    '\u{062C}',
    '\u{0643}',
    '\u{062D}',
    '\u{0643}',
    '\u{062E}',
    '\u{0643}',
    '\u{0644}',
    '\u{0643}',
    '\u{0645}',
    '\u{0643}',
    '\u{0649}',
    '\u{0643}',
    '\u{064A}',
    '\u{0644}',
    '\u{062C}',
    '\u{0644}',
    '\u{062D}',
    '\u{0644}',
    '\u{062E}',
    '\u{0644}',
    '\u{0645}',
    '\u{0644}',
    '\u{0649}',
    '\u{0644}',
    '\u{064A}',
    '\u{0645}',
    '\u{062C}',
    '\u{0645}',
    '\u{062D}',
    '\u{0645}',
    '\u{062E}',
    '\u{0645}',
    '\u{0645}',
    '\u{0645}',
    '\u{0649}',
    '\u{0645}',
    '\u{064A}',
    '\u{0646}',
    '\u{062C}',
    '\u{0646}',
    '\u{062D}',
    '\u{0646}',
    '\u{062E}',
    '\u{0646}',
    '\u{0645}',
    '\u{0646}',
    '\u{0649}',
    '\u{0646}',
    '\u{064A}',
    '\u{0647}',
    '\u{062C}',
    '\u{0647}',
    '\u{0645}',
    '\u{0647}',
    '\u{0649}',
    '\u{0647}',
    '\u{064A}',
    '\u{064A}',
    '\u{062C}',
    '\u{064A}',
    '\u{062D}',
    '\u{064A}',
    '\u{062E}',
    '\u{064A}',
    '\u{0645}',
    '\u{064A}',
    '\u{0649}',
    '\u{064A}',
    '\u{064A}',
    '\u{0630}',
    '\u{0670}',
    '\u{0631}',
    '\u{0670}',
    '\u{0649}',
    '\u{0670}',
    '\u{0020}',
    '\u{064C}',
    '\u{0651}',
    '\u{0020}',
    '\u{064D}',
    '\u{0651}',
    '\u{0020}',
    '\u{064E}',
    '\u{0651}',
    '\u{0020}',
    '\u{064F}',
    '\u{0651}',
    '\u{0020}',
    '\u{0650}',
    '\u{0651}',
    '\u{0020}',
    '\u{0651}',
    '\u{0670}',
    '\u{064A}',
    '\u{0654}',
    '\u{0631}',
    '\u{064A}',
    '\u{0654}',
    '\u{0632}',
    '\u{064A}',
    '\u{0654}',
    '\u{0645}',
    '\u{064A}',
    '\u{0654}',
    '\u{0646}',
    '\u{064A}',
    '\u{0654}',
    '\u{0649}',
    '\u{064A}',
    '\u{0654}',
    '\u{064A}',
    '\u{0628}',
    '\u{0631}',
    '\u{0628}',
    '\u{0632}',
    '\u{0628}',
    '\u{0645}',
    '\u{0628}',
    '\u{0646}',
    '\u{0628}',
    '\u{0649}',
    '\u{0628}',
    '\u{064A}',
    '\u{062A}',
    '\u{0631}',
    '\u{062A}',
    '\u{0632}',
    '\u{062A}',
    '\u{0645}',
    '\u{062A}',
    '\u{0646}',
    '\u{062A}',
    '\u{0649}',
    '\u{062A}',
    '\u{064A}',
    '\u{062B}',
    '\u{0631}',
    '\u{062B}',
    '\u{0632}',
    '\u{062B}',
    '\u{0645}',
    '\u{062B}',
    '\u{0646}',
    '\u{062B}',
    '\u{0649}',
    '\u{062B}',
    '\u{064A}',
    '\u{0641}',
    '\u{0649}',
    '\u{0641}',
    '\u{064A}',
    '\u{0642}',
    '\u{0649}',
    '\u{0642}',
    '\u{064A}',
    '\u{0643}',
    '\u{0627}',
    '\u{0643}',
    '\u{0644}',
    '\u{0643}',
    '\u{0645}',
    '\u{0643}',
    '\u{0649}',
    '\u{0643}',
    '\u{064A}',
    '\u{0644}',
    '\u{0645}',
    '\u{0644}',
    '\u{0649}',
    '\u{0644}',
    '\u{064A}',
    '\u{0645}',
    '\u{0627}',
    '\u{0645}',
    '\u{0645}',
    '\u{0646}',
    '\u{0631}',
    '\u{0646}',
    '\u{0632}',
    '\u{0646}',
    '\u{0645}',
    '\u{0646}',
    '\u{0646}',
    '\u{0646}',
    '\u{0649}',
    '\u{0646}',
    '\u{064A}',
    '\u{0649}',
    '\u{0670}',
    '\u{064A}',
    '\u{0631}',
    '\u{064A}',
    '\u{0632}',
    '\u{064A}',
    '\u{0645}',
    '\u{064A}',
    '\u{0646}',
    '\u{064A}',
    '\u{0649}',
    '\u{064A}',
    '\u{064A}',
    '\u{064A}',
    '\u{0654}',
    '\u{062C}',
    '\u{064A}',
    '\u{0654}',
    '\u{062D}',
    '\u{064A}',
    '\u{0654}',
    '\u{062E}',
    '\u{064A}',
    '\u{0654}',
    '\u{0645}',
    '\u{064A}',
    '\u{0654}',
    '\u{0647}',
    '\u{0628}',
    '\u{062C}',
    '\u{0628}',
    '\u{062D}',
    '\u{0628}',
    '\u{062E}',
    '\u{0628}',
    '\u{0645}',
    '\u{0628}',
    '\u{0647}',
    '\u{062A}',
    '\u{062C}',
    '\u{062A}',
    '\u{062D}',
    '\u{062A}',
    '\u{062E}',
    '\u{062A}',
    '\u{0645}',
    '\u{062A}',
    '\u{0647}',
    '\u{062B}',
    '\u{0645}',
    '\u{062C}',
    '\u{062D}',
    '\u{062C}',
    '\u{0645}',
    '\u{062D}',
    '\u{062C}',
    '\u{062D}',
    '\u{0645}',
    '\u{062E}',
    '\u{062C}',
    '\u{062E}',
    '\u{0645}',
    '\u{0633}',
    '\u{062C}',
    '\u{0633}',
    '\u{062D}',
    '\u{0633}',
    '\u{062E}',
    '\u{0633}',
    '\u{0645}',
    '\u{0635}',
    '\u{062D}',
    '\u{0635}',
    '\u{062E}',
    '\u{0635}',
    '\u{0645}',
    '\u{0636}',
    '\u{062C}',
    '\u{0636}',
    '\u{062D}',
    '\u{0636}',
    '\u{062E}',
    '\u{0636}',
    '\u{0645}',
    '\u{0637}',
    '\u{062D}',
    '\u{0638}',
    '\u{0645}',
    '\u{0639}',
    '\u{062C}',
    '\u{0639}',
    '\u{0645}',
    '\u{063A}',
    '\u{062C}',
    '\u{063A}',
    '\u{0645}',
    '\u{0641}',
    '\u{062C}',
    '\u{0641}',
    '\u{062D}',
    '\u{0641}',
    '\u{062E}',
    '\u{0641}',
    '\u{0645}',
    '\u{0642}',
    '\u{062D}',
    '\u{0642}',
    '\u{0645}',
    '\u{0643}',
    '\u{062C}',
    '\u{0643}',
    '\u{062D}',
    '\u{0643}',
    '\u{062E}',
    '\u{0643}',
    '\u{0644}',
    '\u{0643}',
    '\u{0645}',
    '\u{0644}',
    '\u{062C}',
    '\u{0644}',
    '\u{062D}',
    '\u{0644}',
    '\u{062E}',
    '\u{0644}',
    '\u{0645}',
    '\u{0644}',
    '\u{0647}',
    '\u{0645}',
    '\u{062C}',
    '\u{0645}',
    '\u{062D}',
    '\u{0645}',
    '\u{062E}',
    '\u{0645}',
    '\u{0645}',
    '\u{0646}',
    '\u{062C}',
    '\u{0646}',
    '\u{062D}',
    '\u{0646}',
    '\u{062E}',
    '\u{0646}',
    '\u{0645}',
    '\u{0646}',
    '\u{0647}',
    '\u{0647}',
    '\u{062C}',
    '\u{0647}',
    '\u{0645}',
    '\u{0647}',
    '\u{0670}',
    '\u{064A}',
    '\u{062C}',
    '\u{064A}',
    '\u{062D}',
    '\u{064A}',
    '\u{062E}',
    '\u{064A}',
    '\u{0645}',
    '\u{064A}',
    '\u{0647}',
    '\u{064A}',
    '\u{0654}',
    '\u{0645}',
    '\u{064A}',
    '\u{0654}',
    '\u{0647}',
    '\u{0628}',
    '\u{0645}',
    '\u{0628}',
    '\u{0647}',
    '\u{062A}',
    '\u{0645}',
    '\u{062A}',
    '\u{0647}',
    '\u{062B}',
    '\u{0645}',
    '\u{062B}',
    '\u{0647}',
    '\u{0633}',
    '\u{0645}',
    '\u{0633}',
    '\u{0647}',
    '\u{0634}',
    '\u{0645}',
    '\u{0634}',
    '\u{0647}',
    '\u{0643}',
    '\u{0644}',
    '\u{0643}',
    '\u{0645}',
    '\u{0644}',
    '\u{0645}',
    '\u{0646}',
    '\u{0645}',
    '\u{0646}',
    '\u{0647}',
    '\u{064A}',
    '\u{0645}',
    '\u{064A}',
    '\u{0647}',
    '\u{0640}',
    '\u{064E}',
    '\u{0651}',
    '\u{0640}',
    '\u{064F}',
    '\u{0651}',
    '\u{0640}',
    '\u{0650}',
    '\u{0651}',
    '\u{0637}',
    '\u{0649}',
    '\u{0637}',
    '\u{064A}',
    '\u{0639}',
    '\u{0649}',
    '\u{0639}',
    '\u{064A}',
    '\u{063A}',
    '\u{0649}',
    '\u{063A}',
    '\u{064A}',
    '\u{0633}',
    '\u{0649}',
    '\u{0633}',
    '\u{064A}',
    '\u{0634}',
    '\u{0649}',
    '\u{0634}',
    '\u{064A}',
    '\u{062D}',
    '\u{0649}',
    '\u{062D}',
    '\u{064A}',
    '\u{062C}',
    '\u{0649}',
    '\u{062C}',
    '\u{064A}',
    '\u{062E}',
    '\u{0649}',
    '\u{062E}',
    '\u{064A}',
    '\u{0635}',
    '\u{0649}',
    '\u{0635}',
    '\u{064A}',
    '\u{0636}',
    '\u{0649}',
    '\u{0636}',
    '\u{064A}',
    '\u{0634}',
    '\u{062C}',
    '\u{0634}',
    '\u{062D}',
    '\u{0634}',
    '\u{062E}',
    '\u{0634}',
    '\u{0645}',
    '\u{0634}',
    '\u{0631}',
    '\u{0633}',
    '\u{0631}',
    '\u{0635}',
    '\u{0631}',
    '\u{0636}',
    '\u{0631}',
    '\u{0637}',
    '\u{0649}',
    '\u{0637}',
    '\u{064A}',
    '\u{0639}',
    '\u{0649}',
    '\u{0639}',
    '\u{064A}',
    '\u{063A}',
    '\u{0649}',
    '\u{063A}',
    '\u{064A}',
    '\u{0633}',
    '\u{0649}',
    '\u{0633}',
    '\u{064A}',
    '\u{0634}',
    '\u{0649}',
    '\u{0634}',
    '\u{064A}',
    '\u{062D}',
    '\u{0649}',
    '\u{062D}',
    '\u{064A}',
    '\u{062C}',
    '\u{0649}',
    '\u{062C}',
    '\u{064A}',
    '\u{062E}',
    '\u{0649}',
    '\u{062E}',
    '\u{064A}',
    '\u{0635}',
    '\u{0649}',
    '\u{0635}',
    '\u{064A}',
    '\u{0636}',
    '\u{0649}',
    '\u{0636}',
    '\u{064A}',
    '\u{0634}',
    '\u{062C}',
    '\u{0634}',
    '\u{062D}',
    '\u{0634}',
    '\u{062E}',
    '\u{0634}',
    '\u{0645}',
    '\u{0634}',
    '\u{0631}',
    '\u{0633}',
    '\u{0631}',
    '\u{0635}',
    '\u{0631}',
    '\u{0636}',
    '\u{0631}',
    '\u{0634}',
    '\u{062C}',
    '\u{0634}',
    '\u{062D}',
    '\u{0634}',
    '\u{062E}',
    '\u{0634}',
    '\u{0645}',
    '\u{0633}',
    '\u{0647}',
    '\u{0634}',
    '\u{0647}',
    '\u{0637}',
    '\u{0645}',
    '\u{0633}',
    '\u{062C}',
    '\u{0633}',
    '\u{062D}',
    '\u{0633}',
    '\u{062E}',
    '\u{0634}',
    '\u{062C}',
    '\u{0634}',
    '\u{062D}',
    '\u{0634}',
    '\u{062E}',
    '\u{0637}',
    '\u{0645}',
    '\u{0638}',
    '\u{0645}',
    '\u{0627}',
    '\u{064B}',
    '\u{0627}',
    '\u{064B}',
    '\u{062A}',
    '\u{062C}',
    '\u{0645}',
    '\u{062A}',
    '\u{062D}',
    '\u{062C}',
    '\u{062A}',
    '\u{062D}',
    '\u{062C}',
    '\u{062A}',
    '\u{062D}',
    '\u{0645}',
    '\u{062A}',
    '\u{062E}',
    '\u{0645}',
    '\u{062A}',
    '\u{0645}',
    '\u{062C}',
    '\u{062A}',
    '\u{0645}',
    '\u{062D}',
    '\u{062A}',
    '\u{0645}',
    '\u{062E}',
    '\u{062C}',
    '\u{0645}',
    '\u{062D}',
    '\u{062C}',
    '\u{0645}',
    '\u{062D}',
    '\u{062D}',
    '\u{0645}',
    '\u{064A}',
    '\u{062D}',
    '\u{0645}',
    '\u{0649}',
    '\u{0633}',
    '\u{062D}',
    '\u{062C}',
    '\u{0633}',
    '\u{062C}',
    '\u{062D}',
    '\u{0633}',
    '\u{062C}',
    '\u{0649}',
    '\u{0633}',
    '\u{0645}',
    '\u{062D}',
    '\u{0633}',
    '\u{0645}',
    '\u{062D}',
    '\u{0633}',
    '\u{0645}',
    '\u{062C}',
    '\u{0633}',
    '\u{0645}',
    '\u{0645}',
    '\u{0633}',
    '\u{0645}',
    '\u{0645}',
    '\u{0635}',
    '\u{062D}',
    '\u{062D}',
    '\u{0635}',
    '\u{062D}',
    '\u{062D}',
    '\u{0635}',
    '\u{0645}',
    '\u{0645}',
    '\u{0634}',
    '\u{062D}',
    '\u{0645}',
    '\u{0634}',
    '\u{062D}',
    '\u{0645}',
    '\u{0634}',
    '\u{062C}',
    '\u{064A}',
    '\u{0634}',
    '\u{0645}',
    '\u{062E}',
    '\u{0634}',
    '\u{0645}',
    '\u{062E}',
    '\u{0634}',
    '\u{0645}',
    '\u{0645}',
    '\u{0634}',
    '\u{0645}',
    '\u{0645}',
    '\u{0636}',
    '\u{062D}',
    '\u{0649}',
    '\u{0636}',
    '\u{062E}',
    '\u{0645}',
    '\u{0636}',
    '\u{062E}',
    '\u{0645}',
    '\u{0637}',
    '\u{0645}',
    '\u{062D}',
    '\u{0637}',
    '\u{0645}',
    '\u{062D}',
    '\u{0637}',
    '\u{0645}',
    '\u{0645}',
    '\u{0637}',
    '\u{0645}',
    '\u{064A}',
    '\u{0639}',
    '\u{062C}',
    '\u{0645}',
    '\u{0639}',
    '\u{0645}',
    '\u{0645}',
    '\u{0639}',
    '\u{0645}',
    '\u{0645}',
    '\u{0639}',
    '\u{0645}',
    '\u{0649}',
    '\u{063A}',
    '\u{0645}',
    '\u{0645}',
    '\u{063A}',
    '\u{0645}',
    '\u{064A}',
    '\u{063A}',
    '\u{0645}',
    '\u{0649}',
    '\u{0641}',
    '\u{062E}',
    '\u{0645}',
    '\u{0641}',
    '\u{062E}',
    '\u{0645}',
    '\u{0642}',
    '\u{0645}',
    '\u{062D}',
    '\u{0642}',
    '\u{0645}',
    '\u{0645}',
    '\u{0644}',
    '\u{062D}',
    '\u{0645}',
    '\u{0644}',
    '\u{062D}',
    '\u{064A}',
    '\u{0644}',
    '\u{062D}',
    '\u{0649}',
    '\u{0644}',
    '\u{062C}',
    '\u{062C}',
    '\u{0644}',
    '\u{062C}',
    '\u{062C}',
    '\u{0644}',
    '\u{062E}',
    '\u{0645}',
    '\u{0644}',
    '\u{062E}',
    '\u{0645}',
    '\u{0644}',
    '\u{0645}',
    '\u{062D}',
    '\u{0644}',
    '\u{0645}',
    '\u{062D}',
    '\u{0645}',
    '\u{062D}',
    '\u{062C}',
    '\u{0645}',
    '\u{062D}',
    '\u{0645}',
    '\u{0645}',
    '\u{062D}',
    '\u{064A}',
    '\u{0645}',
    '\u{062C}',
    '\u{062D}',
    '\u{0645}',
    '\u{062C}',
    '\u{0645}',
    '\u{0645}',
    '\u{062E}',
    '\u{062C}',
    '\u{0645}',
    '\u{062E}',
    '\u{0645}',
    '\u{0645}',
    '\u{062C}',
    '\u{062E}',
    '\u{0647}',
    '\u{0645}',
    '\u{062C}',
    '\u{0647}',
    '\u{0645}',
    '\u{0645}',
    '\u{0646}',
    '\u{062D}',
    '\u{0645}',
    '\u{0646}',
    '\u{062D}',
    '\u{0649}',
    '\u{0646}',
    '\u{062C}',
    '\u{0645}',
    '\u{0646}',
    '\u{062C}',
    '\u{0645}',
    '\u{0646}',
    '\u{062C}',
    '\u{0649}',
    '\u{0646}',
    '\u{0645}',
    '\u{064A}',
    '\u{0646}',
    '\u{0645}',
    '\u{0649}',
    '\u{064A}',
    '\u{0645}',
    '\u{0645}',
    '\u{064A}',
    '\u{0645}',
    '\u{0645}',
    '\u{0628}',
    '\u{062E}',
    '\u{064A}',
    '\u{062A}',
    '\u{062C}',
    '\u{064A}',
    '\u{062A}',
    '\u{062C}',
    '\u{0649}',
    '\u{062A}',
    '\u{062E}',
    '\u{064A}',
    '\u{062A}',
    '\u{062E}',
    '\u{0649}',
    '\u{062A}',
    '\u{0645}',
    '\u{064A}',
    '\u{062A}',
    '\u{0645}',
    '\u{0649}',
    '\u{062C}',
    '\u{0645}',
    '\u{064A}',
    '\u{062C}',
    '\u{062D}',
    '\u{0649}',
    '\u{062C}',
    '\u{0645}',
    '\u{0649}',
    '\u{0633}',
    '\u{062E}',
    '\u{0649}',
    '\u{0635}',
    '\u{062D}',
    '\u{064A}',
    '\u{0634}',
    '\u{062D}',
    '\u{064A}',
    '\u{0636}',
    '\u{062D}',
    '\u{064A}',
    '\u{0644}',
    '\u{062C}',
    '\u{064A}',
    '\u{0644}',
    '\u{0645}',
    '\u{064A}',
    '\u{064A}',
    '\u{062D}',
    '\u{064A}',
    '\u{064A}',
    '\u{062C}',
    '\u{064A}',
    '\u{064A}',
    '\u{0645}',
    '\u{064A}',
    '\u{0645}',
    '\u{0645}',
    '\u{064A}',
    '\u{0642}',
    '\u{0645}',
    '\u{064A}',
    '\u{0646}',
    '\u{062D}',
    '\u{064A}',
    '\u{0642}',
    '\u{0645}',
    '\u{062D}',
    '\u{0644}',
    '\u{062D}',
    '\u{0645}',
    '\u{0639}',
    '\u{0645}',
    '\u{064A}',
    '\u{0643}',
    '\u{0645}',
    '\u{064A}',
    '\u{0646}',
    '\u{062C}',
    '\u{062D}',
    '\u{0645}',
    '\u{062E}',
    '\u{064A}',
    '\u{0644}',
    '\u{062C}',
    '\u{0645}',
    '\u{0643}',
    '\u{0645}',
    '\u{0645}',
    '\u{0644}',
    '\u{062C}',
    '\u{0645}',
    '\u{0646}',
    '\u{062C}',
    '\u{062D}',
    '\u{062C}',
    '\u{062D}',
    '\u{064A}',
    '\u{062D}',
    '\u{062C}',
    '\u{064A}',
    '\u{0645}',
    '\u{062C}',
    '\u{064A}',
    '\u{0641}',
    '\u{0645}',
    '\u{064A}',
    '\u{0628}',
    '\u{062D}',
    '\u{064A}',
    '\u{0643}',
    '\u{0645}',
    '\u{0645}',
    '\u{0639}',
    '\u{062C}',
    '\u{0645}',
    '\u{0635}',
    '\u{0645}',
    '\u{0645}',
    '\u{0633}',
    '\u{062E}',
    '\u{064A}',
    '\u{0646}',
    '\u{062C}',
    '\u{064A}',
    '\u{0635}',
    '\u{0644}',
    '\u{06D2}',
    '\u{0642}',
    '\u{0644}',
    '\u{06D2}',
    '\u{0627}',
    '\u{0644}',
    '\u{0644}',
    '\u{0647}',
    '\u{0627}',
    '\u{0643}',
    '\u{0628}',
    '\u{0631}',
    '\u{0645}',
    '\u{062D}',
    '\u{0645}',
    '\u{062F}',
    '\u{0635}',
    '\u{0644}',
    '\u{0639}',
    '\u{0645}',
    '\u{0631}',
    '\u{0633}',
    '\u{0648}',
    '\u{0644}',
    '\u{0639}',
    '\u{0644}',
    '\u{064A}',
    '\u{0647}',
    '\u{0648}',
    '\u{0633}',
    '\u{0644}',
    '\u{0645}',
    '\u{0635}',
    '\u{0644}',
    '\u{0649}',
    '\u{0635}',
    '\u{0644}',
    '\u{0649}',
    '\u{0020}',
    '\u{0627}',
    '\u{0644}',
    '\u{0644}',
    '\u{0647}',
    '\u{0020}',
    '\u{0639}',
    '\u{0644}',
    '\u{064A}',
    '\u{0647}',
    '\u{0020}',
    '\u{0648}',
    '\u{0633}',
    '\u{0644}',
    '\u{0645}',
    '\u{062C}',
    '\u{0644}',
    '\u{0020}',
    '\u{062C}',
    '\u{0644}',
    '\u{0627}',
    '\u{0644}',
    '\u{0647}',
    '\u{0631}',
    '\u{06CC}',
    '\u{0627}',
    '\u{0644}',
    '\u{002C}',
    '\u{3001}',
    '\u{3002}',
    '\u{003A}',
    '\u{003B}',
    '\u{0021}',
    '\u{003F}',
    '\u{3016}',
    '\u{3017}',
    '\u{002E}',
    '\u{002E}',
    '\u{002E}',
    '\u{002E}',
    '\u{002E}',
    '\u{2014}',
    '\u{2013}',
    '\u{005F}',
    '\u{005F}',
    '\u{0028}',
    '\u{0029}',
    '\u{007B}',
    '\u{007D}',
    '\u{3014}',
    '\u{3015}',
    '\u{3010}',
    '\u{3011}',
    '\u{300A}',
    '\u{300B}',
    '\u{3008}',
    '\u{3009}',
    '\u{300C}',
    '\u{300D}',
    '\u{300E}',
    '\u{300F}',
    '\u{005B}',
    '\u{005D}',
    '\u{0020}',
    '\u{0305}',
    '\u{0020}',
    '\u{0305}',
    '\u{0020}',
    '\u{0305}',
    '\u{0020}',
    '\u{0305}',
    '\u{005F}',
    '\u{005F}',
    '\u{005F}',
    '\u{002C}',
    '\u{3001}',
    '\u{002E}',
    '\u{003B}',
    '\u{003A}',
    '\u{003F}',
    '\u{0021}',
    '\u{2014}',
    '\u{0028}',
    '\u{0029}',
    '\u{007B}',
    '\u{007D}',
    '\u{3014}',
    '\u{3015}',
    '\u{0023}',
    '\u{0026}',
    '\u{002A}',
    '\u{002B}',
    '\u{002D}',
    '\u{003C}',
    '\u{003E}',
    '\u{003D}',
    '\u{005C}',
    '\u{0024}',
    '\u{0025}',
    '\u{0040}',
    '\u{0020}',
    '\u{064B}',
    '\u{0640}',
    '\u{064B}',
    '\u{0020}',
    '\u{064C}',
    '\u{0020}',
    '\u{064D}',
    '\u{0020}',
    '\u{064E}',
    '\u{0640}',
    '\u{064E}',
    '\u{0020}',
    '\u{064F}',
    '\u{0640}',
    '\u{064F}',
    '\u{0020}',
    '\u{0650}',
    '\u{0640}',
    '\u{0650}',
    '\u{0020}',
    '\u{0651}',
    '\u{0640}',
    '\u{0651}',
    '\u{0020}',
    '\u{0652}',
    '\u{0640}',
    '\u{0652}',
    '\u{0621}',
    '\u{0627}',
    '\u{0653}',
    '\u{0627}',
    '\u{0653}',
    '\u{0627}',
    '\u{0654}',
    '\u{0627}',
    '\u{0654}',
    '\u{0648}',
    '\u{0654}',
    '\u{0648}',
    '\u{0654}',
    '\u{0627}',
    '\u{0655}',
    '\u{0627}',
    '\u{0655}',
    '\u{064A}',
    '\u{0654}',
    '\u{064A}',
    '\u{0654}',
    '\u{064A}',
    '\u{0654}',
    '\u{064A}',
    '\u{0654}',
    '\u{0627}',
    '\u{0627}',
    '\u{0628}',
    '\u{0628}',
    '\u{0628}',
    '\u{0628}',
    '\u{0629}',
    '\u{0629}',
    '\u{062A}',
    '\u{062A}',
    '\u{062A}',
    '\u{062A}',
    '\u{062B}',
    '\u{062B}',
    '\u{062B}',
    '\u{062B}',
    '\u{062C}',
    '\u{062C}',
    '\u{062C}',
    '\u{062C}',
    '\u{062D}',
    '\u{062D}',
    '\u{062D}',
    '\u{062D}',
    '\u{062E}',
    '\u{062E}',
    '\u{062E}',
    '\u{062E}',
    '\u{062F}',
    '\u{062F}',
    '\u{0630}',
    '\u{0630}',
    '\u{0631}',
    '\u{0631}',
    '\u{0632}',
    '\u{0632}',
    '\u{0633}',
    '\u{0633}',
    '\u{0633}',
    '\u{0633}',
    '\u{0634}',
    '\u{0634}',
    '\u{0634}',
    '\u{0634}',
    '\u{0635}',
    '\u{0635}',
    '\u{0635}',
    '\u{0635}',
    '\u{0636}',
    '\u{0636}',
    '\u{0636}',
    '\u{0636}',
    '\u{0637}',
    '\u{0637}',
    '\u{0637}',
    '\u{0637}',
    '\u{0638}',
    '\u{0638}',
    '\u{0638}',
    '\u{0638}',
    '\u{0639}',
    '\u{0639}',
    '\u{0639}',
    '\u{0639}',
    '\u{063A}',
    '\u{063A}',
    '\u{063A}',
    '\u{063A}',
    '\u{0641}',
    '\u{0641}',
    '\u{0641}',
    '\u{0641}',
    '\u{0642}',
    '\u{0642}',
    '\u{0642}',
    '\u{0642}',
    '\u{0643}',
    '\u{0643}',
    '\u{0643}',
    '\u{0643}',
    '\u{0644}',
    '\u{0644}',
    '\u{0644}',
    '\u{0644}',
    '\u{0645}',
    '\u{0645}',
    '\u{0645}',
    '\u{0645}',
    '\u{0646}',
    '\u{0646}',
    '\u{0646}',
    '\u{0646}',
    '\u{0647}',
    '\u{0647}',
    '\u{0647}',
    '\u{0647}',
    '\u{0648}',
    '\u{0648}',
    '\u{0649}',
    '\u{0649}',
    '\u{064A}',
    '\u{064A}',
    '\u{064A}',
    '\u{064A}',
    '\u{0644}',
    '\u{0627}',
    '\u{0653}',
    '\u{0644}',
    '\u{0627}',
    '\u{0653}',
    '\u{0644}',
    '\u{0627}',
    '\u{0654}',
    '\u{0644}',
    '\u{0627}',
    '\u{0654}',
    '\u{0644}',
    '\u{0627}',
    '\u{0655}',
    '\u{0644}',
    '\u{0627}',
    '\u{0655}',
    '\u{0644}',
    '\u{0627}',
    '\u{0644}',
    '\u{0627}',
    '\u{0021}',
    '\u{0022}',
    '\u{0023}',
    '\u{0024}',
    '\u{0025}',
    '\u{0026}',
    '\u{0027}',
    '\u{0028}',
    '\u{0029}',
    '\u{002A}',
    '\u{002B}',
    '\u{002C}',
    '\u{002D}',
    '\u{002E}',
    '\u{002F}',
    '\u{0030}',
    '\u{0031}',
    '\u{0032}',
    '\u{0033}',
    '\u{0034}',
    '\u{0035}',
    '\u{0036}',
    '\u{0037}',
    '\u{0038}',
    '\u{0039}',
    '\u{003A}',
    '\u{003B}',
    '\u{003C}',
    '\u{003D}',
    '\u{003E}',
    '\u{003F}',
    '\u{0040}',
    '\u{0041}',
    '\u{0042}',
    '\u{0043}',
    '\u{0044}',
    '\u{0045}',
    '\u{0046}',
    '\u{0047}',
    '\u{0048}',
    '\u{0049}',
    '\u{004A}',
    '\u{004B}',
    '\u{004C}',
    '\u{004D}',
    '\u{004E}',
    '\u{004F}',
    '\u{0050}',
    '\u{0051}',
    '\u{0052}',
    '\u{0053}',
    '\u{0054}',
    '\u{0055}',
    '\u{0056}',
    '\u{0057}',
    '\u{0058}',
    '\u{0059}',
    '\u{005A}',
    '\u{005B}',
    '\u{005C}',
    '\u{005D}',
    '\u{005E}',
    '\u{005F}',
    '\u{0060}',
    '\u{0061}',
    '\u{0062}',
    '\u{0063}',
    '\u{0064}',
    '\u{0065}',
    '\u{0066}',
    '\u{0067}',
    '\u{0068}',
    '\u{0069}',
    '\u{006A}',
    '\u{006B}',
    '\u{006C}',
    '\u{006D}',
    '\u{006E}',
    '\u{006F}',
    '\u{0070}',
    '\u{0071}',
    '\u{0072}',
    '\u{0073}',
    '\u{0074}',
    '\u{0075}',
    '\u{0076}',
    '\u{0077}',
    '\u{0078}',
    '\u{0079}',
    '\u{007A}',
    '\u{007B}',
    '\u{007C}',
    '\u{007D}',
    '\u{007E}',
    '\u{2985}',
    '\u{2986}',
    '\u{3002}',
    '\u{300C}',
    '\u{300D}',
    '\u{3001}',
    '\u{30FB}',
    '\u{30F2}',
    '\u{30A1}',
    '\u{30A3}',
    '\u{30A5}',
    '\u{30A7}',
    '\u{30A9}',
    '\u{30E3}',
    '\u{30E5}',
    '\u{30E7}',
    '\u{30C3}',
    '\u{30FC}',
    '\u{30A2}',
    '\u{30A4}',
    '\u{30A6}',
    '\u{30A8}',
    '\u{30AA}',
    '\u{30AB}',
    '\u{30AD}',
    '\u{30AF}',
    '\u{30B1}',
    '\u{30B3}',
    '\u{30B5}',
    '\u{30B7}',
    '\u{30B9}',
    '\u{30BB}',
    '\u{30BD}',
    '\u{30BF}',
    '\u{30C1}',
    '\u{30C4}',
    '\u{30C6}',
    '\u{30C8}',
    '\u{30CA}',
    '\u{30CB}',
    '\u{30CC}',
    '\u{30CD}',
    '\u{30CE}',
    '\u{30CF}',
    '\u{30D2}',
    '\u{30D5}',
    '\u{30D8}',
    '\u{30DB}',
    '\u{30DE}',
    '\u{30DF}',
    '\u{30E0}',
    '\u{30E1}',
    '\u{30E2}',
    '\u{30E4}',
    '\u{30E6}',
    '\u{30E8}',
    '\u{30E9}',
    '\u{30EA}',
    '\u{30EB}',
    '\u{30EC}',
    '\u{30ED}',
    '\u{30EF}',
    '\u{30F3}',
    '\u{3099}',
    '\u{309A}',
    '\u{1160}',
    '\u{1100}',
    '\u{1101}',
    '\u{11AA}',
    '\u{1102}',
    '\u{11AC}',
    '\u{11AD}',
    '\u{1103}',
    '\u{1104}',
    '\u{1105}',
    '\u{11B0}',
    '\u{11B1}',
    '\u{11B2}',
    '\u{11B3}',
    '\u{11B4}',
    '\u{11B5}',
    '\u{111A}',
    '\u{1106}',
    '\u{1107}',
    '\u{1108}',
    '\u{1121}',
    '\u{1109}',
    '\u{110A}',
    '\u{110B}',
    '\u{110C}',
    '\u{110D}',
    '\u{110E}',
    '\u{110F}',
    '\u{1110}',
    '\u{1111}',
    '\u{1112}',
    '\u{1161}',
    '\u{1162}',
    '\u{1163}',
    '\u{1164}',
    '\u{1165}',
    '\u{1166}',
    '\u{1167}',
    '\u{1168}',
    '\u{1169}',
    '\u{116A}',
    '\u{116B}',
    '\u{116C}',
    '\u{116D}',
    '\u{116E}',
    '\u{116F}',
    '\u{1170}',
    '\u{1171}',
    '\u{1172}',
    '\u{1173}',
    '\u{1174}',
    '\u{1175}',
    '\u{00A2}',
    '\u{00A3}',
    '\u{00AC}',
    '\u{0020}',
    '\u{0304}',
    '\u{00A6}',
    '\u{00A5}',
    '\u{20A9}',
    '\u{2502}',
    '\u{2190}',
    '\u{2191}',
    '\u{2192}',
    '\u{2193}',
    '\u{25A0}',
    '\u{25CB}',
    '\u{02D0}',
    '\u{02D1}',
    '\u{00E6}',
    '\u{0299}',
    '\u{0253}',
    '\u{02A3}',
    '\u{AB66}',
    '\u{02A5}',
    '\u{02A4}',
    '\u{0256}',
    '\u{0257}',
    '\u{1D91}',
    '\u{0258}',
    '\u{025E}',
    '\u{02A9}',
    '\u{0264}',
    '\u{0262}',
    '\u{0260}',
    '\u{029B}',
    '\u{0127}',
    '\u{029C}',
    '\u{0267}',
    '\u{0284}',
    '\u{02AA}',
    '\u{02AB}',
    '\u{026C}',
    '\u{1DF04}',
    '\u{A78E}',
    '\u{026E}',
    '\u{1DF05}',
    '\u{028E}',
    '\u{1DF06}',
    '\u{00F8}',
    '\u{0276}',
    '\u{0277}',
    '\u{0071}',
    '\u{027A}',
    '\u{1DF08}',
    '\u{027D}',
    '\u{027E}',
    '\u{0280}',
    '\u{02A8}',
    '\u{02A6}',
    '\u{AB67}',
    '\u{02A7}',
    '\u{0288}',
    '\u{2C71}',
    '\u{028F}',
    '\u{02A1}',
    '\u{02A2}',
    '\u{0298}',
    '\u{01C0}',
    '\u{01C1}',
    '\u{01C2}',
    '\u{1DF0A}',
    '\u{1DF1E}',
    '\u{0041}',
    '\u{0042}',
    '\u{0043}',
    '\u{0044}',
    '\u{0045}',
    '\u{0046}',
    '\u{0047}',
    '\u{0048}',
    '\u{0049}',
    '\u{004A}',
    '\u{004B}',
    '\u{004C}',
    '\u{004D}',
    '\u{004E}',
    '\u{004F}',
    '\u{0050}',
    '\u{0051}',
    '\u{0052}',
    '\u{0053}',
    '\u{0054}',
    '\u{0055}',
    '\u{0056}',
    '\u{0057}',
    '\u{0058}',
    '\u{0059}',
    '\u{005A}',
    '\u{0030}',
    '\u{0031}',
    '\u{0032}',
    '\u{0033}',
    '\u{0034}',
    '\u{0035}',
    '\u{0036}',
    '\u{0037}',
    '\u{0038}',
    '\u{0039}',
    '\u{0041}',
    '\u{0042}',
    '\u{0043}',
    '\u{0044}',
    '\u{0045}',
    '\u{0046}',
    '\u{0047}',
    '\u{0048}',
    '\u{0049}',
    '\u{004A}',
    '\u{004B}',
    '\u{004C}',
    '\u{004D}',
    '\u{004E}',
    '\u{004F}',
    '\u{0050}',
    '\u{0051}',
    '\u{0052}',
    '\u{0053}',
    '\u{0054}',
    '\u{0055}',
    '\u{0056}',
    '\u{0057}',
    '\u{0058}',
    '\u{0059}',
    '\u{005A}',
    '\u{0061}',
    '\u{0062}',
    '\u{0063}',
    '\u{0064}',
    '\u{0065}',
    '\u{0066}',
    '\u{0067}',
    '\u{0068}',
    '\u{0069}',
    '\u{006A}',
    '\u{006B}',
    '\u{006C}',
    '\u{006D}',
    '\u{006E}',
    '\u{006F}',
    '\u{0070}',
    '\u{0071}',
    '\u{0072}',
    '\u{0073}',
    '\u{0074}',
    '\u{0075}',
    '\u{0076}',
    '\u{0077}',
    '\u{0078}',
    '\u{0079}',
    '\u{007A}',
    '\u{0041}',
    '\u{0042}',
    '\u{0043}',
    '\u{0044}',
    '\u{0045}',
    '\u{0046}',
    '\u{0047}',
    '\u{0048}',
    '\u{0049}',
    '\u{004A}',
    '\u{004B}',
    '\u{004C}',
    '\u{004D}',
    '\u{004E}',
    '\u{004F}',
    '\u{0050}',
    '\u{0051}',
    '\u{0052}',
    '\u{0053}',
    '\u{0054}',
    '\u{0055}',
    '\u{0056}',
    '\u{0057}',
    '\u{0058}',
    '\u{0059}',
    '\u{005A}',
    '\u{0061}',
    '\u{0062}',
    '\u{0063}',
    '\u{0064}',
    '\u{0065}',
    '\u{0066}',
    '\u{0067}',
    '\u{0069}',
    '\u{006A}',
    '\u{006B}',
    '\u{006C}',
    '\u{006D}',
    '\u{006E}',
    '\u{006F}',
    '\u{0070}',
    '\u{0071}',
    '\u{0072}',
    '\u{0073}',
    '\u{0074}',
    '\u{0075}',
    '\u{0076}',
    '\u{0077}',
    '\u{0078}',
    '\u{0079}',
    '\u{007A}',
    '\u{0041}',
    '\u{0042}',
    '\u{0043}',
    '\u{0044}',
    '\u{0045}',
    '\u{0046}',
    '\u{0047}',
    '\u{0048}',
    '\u{0049}',
    '\u{004A}',
    '\u{004B}',
    '\u{004C}',
    '\u{004D}',
    '\u{004E}',
    '\u{004F}',
    '\u{0050}',
    '\u{0051}',
    '\u{0052}',
    '\u{0053}',
    '\u{0054}',
    '\u{0055}',
    '\u{0056}',
    '\u{0057}',
    '\u{0058}',
    '\u{0059}',
    '\u{005A}',
    '\u{0061}',
    '\u{0062}',
    '\u{0063}',
    '\u{0064}',
    '\u{0065}',
    '\u{0066}',
    '\u{0067}',
    '\u{0068}',
    '\u{0069}',
    '\u{006A}',
    '\u{006B}',
    '\u{006C}',
    '\u{006D}',
    '\u{006E}',
    '\u{006F}',
    '\u{0070}',
    '\u{0071}',
    '\u{0072}',
    '\u{0073}',
    '\u{0074}',
    '\u{0075}',
    '\u{0076}',
    '\u{0077}',
    '\u{0078}',
    '\u{0079}',
    '\u{007A}',
    '\u{0041}',
    '\u{0043}',
    '\u{0044}',
    '\u{0047}',
    '\u{004A}',
    '\u{004B}',
    '\u{004E}',
    '\u{004F}',
    '\u{0050}',
    '\u{0051}',
    '\u{0053}',
    '\u{0054}',
    '\u{0055}',
    '\u{0056}',
    '\u{0057}',
    '\u{0058}',
    '\u{0059}',
    '\u{005A}',
    '\u{0061}',
    '\u{0062}',
    '\u{0063}',
    '\u{0064}',
    '\u{0066}',
    '\u{0068}',
    '\u{0069}',
    '\u{006A}',
    '\u{006B}',
    '\u{006C}',
    '\u{006D}',
    '\u{006E}',
    '\u{0070}',
    '\u{0071}',
    '\u{0072}',
    '\u{0073}',
    '\u{0074}',
    '\u{0075}',
    '\u{0076}',
    '\u{0077}',
    '\u{0078}',
    '\u{0079}',
    '\u{007A}',
    '\u{0041}',
    '\u{0042}',
    '\u{0043}',
    '\u{0044}',
    '\u{0045}',
    '\u{0046}',
    '\u{0047}',
    '\u{0048}',
    '\u{0049}',
    '\u{004A}',
    '\u{004B}',
    '\u{004C}',
    '\u{004D}',
    '\u{004E}',
    '\u{004F}',
    '\u{0050}',
    '\u{0051}',
    '\u{0052}',
    '\u{0053}',
    '\u{0054}',
    '\u{0055}',
    '\u{0056}',
    '\u{0057}',
    '\u{0058}',
    '\u{0059}',
    '\u{005A}',
    '\u{0061}',
    '\u{0062}',
    '\u{0063}',
    '\u{0064}',
    '\u{0065}',
    '\u{0066}',
    '\u{0067}',
    '\u{0068}',
    '\u{0069}',
    '\u{006A}',
    '\u{006B}',
    '\u{006C}',
    '\u{006D}',
    '\u{006E}',
    '\u{006F}',
    '\u{0070}',
    '\u{0071}',
    '\u{0072}',
    '\u{0073}',
    '\u{0074}',
    '\u{0075}',
    '\u{0076}',
    '\u{0077}',
    '\u{0078}',
    '\u{0079}',
    '\u{007A}',
    '\u{0041}',
    '\u{0042}',
    '\u{0044}',
    '\u{0045}',
    '\u{0046}',
    '\u{0047}',
    '\u{004A}',
    '\u{004B}',
    '\u{004C}',
    '\u{004D}',
    '\u{004E}',
    '\u{004F}',
    '\u{0050}',
    '\u{0051}',
    '\u{0053}',
    '\u{0054}',
    '\u{0055}',
    '\u{0056}',
    '\u{0057}',
    '\u{0058}',
    '\u{0059}',
    '\u{0061}',
    '\u{0062}',
    '\u{0063}',
    '\u{0064}',
    '\u{0065}',
    '\u{0066}',
    '\u{0067}',
    '\u{0068}',
    '\u{0069}',
    '\u{006A}',
    '\u{006B}',
    '\u{006C}',
    '\u{006D}',
    '\u{006E}',
    '\u{006F}',
    '\u{0070}',
    '\u{0071}',
    '\u{0072}',
    '\u{0073}',
    '\u{0074}',
    '\u{0075}',
    '\u{0076}',
    '\u{0077}',
    '\u{0078}',
    '\u{0079}',
    '\u{007A}',
    '\u{0041}',
    '\u{0042}',
    '\u{0044}',
    '\u{0045}',
    '\u{0046}',
    '\u{0047}',
    '\u{0049}',
    '\u{004A}',
    '\u{004B}',
    '\u{004C}',
    '\u{004D}',
    '\u{004F}',
    '\u{0053}',
    '\u{0054}',
    '\u{0055}',
    '\u{0056}',
    '\u{0057}',
    '\u{0058}',
    '\u{0059}',
    '\u{0061}',
    '\u{0062}',
    '\u{0063}',
    '\u{0064}',
    '\u{0065}',
    '\u{0066}',
    '\u{0067}',
    '\u{0068}',
    '\u{0069}',
    '\u{006A}',
    '\u{006B}',
    '\u{006C}',
    '\u{006D}',
    '\u{006E}',
    '\u{006F}',
    '\u{0070}',
    '\u{0071}',
    '\u{0072}',
    '\u{0073}',
    '\u{0074}',
    '\u{0075}',
    '\u{0076}',
    '\u{0077}',
    '\u{0078}',
    '\u{0079}',
    '\u{007A}',
    '\u{0041}',
    '\u{0042}',
    '\u{0043}',
    '\u{0044}',
    '\u{0045}',
    '\u{0046}',
    '\u{0047}',
    '\u{0048}',
    '\u{0049}',
    '\u{004A}',
    '\u{004B}',
    '\u{004C}',
    '\u{004D}',
    '\u{004E}',
    '\u{004F}',
    '\u{0050}',
    '\u{0051}',
    '\u{0052}',
    '\u{0053}',
    '\u{0054}',
    '\u{0055}',
    '\u{0056}',
    '\u{0057}',
    '\u{0058}',
    '\u{0059}',
    '\u{005A}',
    '\u{0061}',
    '\u{0062}',
    '\u{0063}',
    '\u{0064}',
    '\u{0065}',
    '\u{0066}',
    '\u{0067}',
    '\u{0068}',
    '\u{0069}',
    '\u{006A}',
    '\u{006B}',
    '\u{006C}',
    '\u{006D}',
    '\u{006E}',
    '\u{006F}',
    '\u{0070}',
    '\u{0071}',
    '\u{0072}',
    '\u{0073}',
    '\u{0074}',
    '\u{0075}',
    '\u{0076}',
    '\u{0077}',
    '\u{0078}',
    '\u{0079}',
    '\u{007A}',
    '\u{0041}',
    '\u{0042}',
    '\u{0043}',
    '\u{0044}',
    '\u{0045}',
    '\u{0046}',
    '\u{0047}',
    '\u{0048}',
    '\u{0049}',
    '\u{004A}',
    '\u{004B}',
    '\u{004C}',
    '\u{004D}',
    '\u{004E}',
    '\u{004F}',
    '\u{0050}',
    '\u{0051}',
    '\u{0052}',
    '\u{0053}',
    '\u{0054}',
    '\u{0055}',
    '\u{0056}',
    '\u{0057}',
    '\u{0058}',
    '\u{0059}',
    '\u{005A}',
    '\u{0061}',
    '\u{0062}',
    '\u{0063}',
    '\u{0064}',
    '\u{0065}',
    '\u{0066}',
    '\u{0067}',
    '\u{0068}',
    '\u{0069}',
    '\u{006A}',
    '\u{006B}',
    '\u{006C}',
    '\u{006D}',
    '\u{006E}',
    '\u{006F}',
    '\u{0070}',
    '\u{0071}',
    '\u{0072}',
    '\u{0073}',
    '\u{0074}',
    '\u{0075}',
    '\u{0076}',
    '\u{0077}',
    '\u{0078}',
    '\u{0079}',
    '\u{007A}',
    '\u{0041}',
    '\u{0042}',
    '\u{0043}',
    '\u{0044}',
    '\u{0045}',
    '\u{0046}',
    '\u{0047}',
    '\u{0048}',
    '\u{0049}',
    '\u{004A}',
    '\u{004B}',
    '\u{004C}',
    '\u{004D}',
    '\u{004E}',
    '\u{004F}',
    '\u{0050}',
    '\u{0051}',
    '\u{0052}',
    '\u{0053}',
    '\u{0054}',
    '\u{0055}',
    '\u{0056}',
    '\u{0057}',
    '\u{0058}',
    '\u{0059}',
    '\u{005A}',
    '\u{0061}',
    '\u{0062}',
    '\u{0063}',
    '\u{0064}',
    '\u{0065}',
    '\u{0066}',
    '\u{0067}',
    '\u{0068}',
    '\u{0069}',
    '\u{006A}',
    '\u{006B}',
    '\u{006C}',
    '\u{006D}',
    '\u{006E}',
    '\u{006F}',
    '\u{0070}',
    '\u{0071}',
    '\u{0072}',
    '\u{0073}',
    '\u{0074}',
    '\u{0075}',
    '\u{0076}',
    '\u{0077}',
    '\u{0078}',
    '\u{0079}',
    '\u{007A}',
    '\u{0041}',
    '\u{0042}',
    '\u{0043}',
    '\u{0044}',
    '\u{0045}',
    '\u{0046}',
    '\u{0047}',
    '\u{0048}',
    '\u{0049}',
    '\u{004A}',
    '\u{004B}',
    '\u{004C}',
    '\u{004D}',
    '\u{004E}',
    '\u{004F}',
    '\u{0050}',
    '\u{0051}',
    '\u{0052}',
    '\u{0053}',
    '\u{0054}',
    '\u{0055}',
    '\u{0056}',
    '\u{0057}',
    '\u{0058}',
    '\u{0059}',
    '\u{005A}',
    '\u{0061}',
    '\u{0062}',
    '\u{0063}',
    '\u{0064}',
    '\u{0065}',
    '\u{0066}',
    '\u{0067}',
    '\u{0068}',
    '\u{0069}',
    '\u{006A}',
    '\u{006B}',
    '\u{006C}',
    '\u{006D}',
    '\u{006E}',
    '\u{006F}',
    '\u{0070}',
    '\u{0071}',
    '\u{0072}',
    '\u{0073}',
    '\u{0074}',
    '\u{0075}',
    '\u{0076}',
    '\u{0077}',
    '\u{0078}',
    '\u{0079}',
    '\u{007A}',
    '\u{0041}',
    '\u{0042}',
    '\u{0043}',
    '\u{0044}',
    '\u{0045}',
    '\u{0046}',
    '\u{0047}',
    '\u{0048}',
    '\u{0049}',
    '\u{004A}',
    '\u{004B}',
    '\u{004C}',
    '\u{004D}',
    '\u{004E}',
    '\u{004F}',
    '\u{0050}',
    '\u{0051}',
    '\u{0052}',
    '\u{0053}',
    '\u{0054}',
    '\u{0055}',
    '\u{0056}',
    '\u{0057}',
    '\u{0058}',
    '\u{0059}',
    '\u{005A}',
    '\u{0061}',
    '\u{0062}',
    '\u{0063}',
    '\u{0064}',
    '\u{0065}',
    '\u{0066}',
    '\u{0067}',
    '\u{0068}',
    '\u{0069}',
    '\u{006A}',
    '\u{006B}',
    '\u{006C}',
    '\u{006D}',
    '\u{006E}',
    '\u{006F}',
    '\u{0070}',
    '\u{0071}',
    '\u{0072}',
    '\u{0073}',
    '\u{0074}',
    '\u{0075}',
    '\u{0076}',
    '\u{0077}',
    '\u{0078}',
    '\u{0079}',
    '\u{007A}',
    '\u{0041}',
    '\u{0042}',
    '\u{0043}',
    '\u{0044}',
    '\u{0045}',
    '\u{0046}',
    '\u{0047}',
    '\u{0048}',
    '\u{0049}',
    '\u{004A}',
    '\u{004B}',
    '\u{004C}',
    '\u{004D}',
    '\u{004E}',
    '\u{004F}',
    '\u{0050}',
    '\u{0051}',
    '\u{0052}',
    '\u{0053}',
    '\u{0054}',
    '\u{0055}',
    '\u{0056}',
    '\u{0057}',
    '\u{0058}',
    '\u{0059}',
    '\u{005A}',
    '\u{0061}',
    '\u{0062}',
    '\u{0063}',
    '\u{0064}',
    '\u{0065}',
    '\u{0066}',
    '\u{0067}',
    '\u{0068}',
    '\u{0069}',
    '\u{006A}',
    '\u{006B}',
    '\u{006C}',
    '\u{006D}',
    '\u{006E}',
    '\u{006F}',
    '\u{0070}',
    '\u{0071}',
    '\u{0072}',
    '\u{0073}',
    '\u{0074}',
    '\u{0075}',
    '\u{0076}',
    '\u{0077}',
    '\u{0078}',
    '\u{0079}',
    '\u{007A}',
    '\u{0131}',
    '\u{0237}',
    '\u{0391}',
    '\u{0392}',
    '\u{0393}',
    '\u{0394}',
    '\u{0395}',
    '\u{0396}',
    '\u{0397}',
    '\u{0398}',
    '\u{0399}',
    '\u{039A}',
    '\u{039B}',
    '\u{039C}',
    '\u{039D}',
    '\u{039E}',
    '\u{039F}',
    '\u{03A0}',
    '\u{03A1}',
    '\u{0398}',
    '\u{03A3}',
    '\u{03A4}',
    '\u{03A5}',
    '\u{03A6}',
    '\u{03A7}',
    '\u{03A8}',
    '\u{03A9}',
    '\u{2207}',
    '\u{03B1}',
    '\u{03B2}',
    '\u{03B3}',
    '\u{03B4}',
    '\u{03B5}',
    '\u{03B6}',
    '\u{03B7}',
    '\u{03B8}',
    '\u{03B9}',
    '\u{03BA}',
    '\u{03BB}',
    '\u{03BC}',
    '\u{03BD}',
    '\u{03BE}',
    '\u{03BF}',
    '\u{03C0}',
    '\u{03C1}',
    '\u{03C2}',
    '\u{03C3}',
    '\u{03C4}',
    '\u{03C5}',
    '\u{03C6}',
    '\u{03C7}',
    '\u{03C8}',
    '\u{03C9}',
    '\u{2202}',
    '\u{03B5}',
    '\u{03B8}',
    '\u{03BA}',
    '\u{03C6}',
    '\u{03C1}',
    '\u{03C0}',
    '\u{0391}',
    '\u{0392}',
    '\u{0393}',
    '\u{0394}',
    '\u{0395}',
    '\u{0396}',
    '\u{0397}',
    '\u{0398}',
    '\u{0399}',
    '\u{039A}',
    '\u{039B}',
    '\u{039C}',
    '\u{039D}',
    '\u{039E}',
    '\u{039F}',
    '\u{03A0}',
    '\u{03A1}',
    '\u{0398}',
    '\u{03A3}',
    '\u{03A4}',
    '\u{03A5}',
    '\u{03A6}',
    '\u{03A7}',
    '\u{03A8}',
    '\u{03A9}',
    '\u{2207}',
    '\u{03B1}',
    '\u{03B2}',
    '\u{03B3}',
    '\u{03B4}',
    '\u{03B5}',
    '\u{03B6}',
    '\u{03B7}',
    '\u{03B8}',
    '\u{03B9}',
    '\u{03BA}',
    '\u{03BB}',
    '\u{03BC}',
    '\u{03BD}',
    '\u{03BE}',
    '\u{03BF}',
    '\u{03C0}',
    '\u{03C1}',
    '\u{03C2}',
    '\u{03C3}',
    '\u{03C4}',
    '\u{03C5}',
    '\u{03C6}',
    '\u{03C7}',
    '\u{03C8}',
    '\u{03C9}',
    '\u{2202}',
    '\u{03B5}',
    '\u{03B8}',
    '\u{03BA}',
    '\u{03C6}',
    '\u{03C1}',
    '\u{03C0}',
    '\u{0391}',
    '\u{0392}',
    '\u{0393}',
    '\u{0394}',
    '\u{0395}',
    '\u{0396}',
    '\u{0397}',
    '\u{0398}',
    '\u{0399}',
    '\u{039A}',
    '\u{039B}',
    '\u{039C}',
    '\u{039D}',
    '\u{039E}',
    '\u{039F}',
    '\u{03A0}',
    '\u{03A1}',
    '\u{0398}',
    '\u{03A3}',
    '\u{03A4}',
    '\u{03A5}',
    '\u{03A6}',
    '\u{03A7}',
    '\u{03A8}',
    '\u{03A9}',
    '\u{2207}',
    '\u{03B1}',
    '\u{03B2}',
    '\u{03B3}',
    '\u{03B4}',
    '\u{03B5}',
    '\u{03B6}',
    '\u{03B7}',
    '\u{03B8}',
    '\u{03B9}',
    '\u{03BA}',
    '\u{03BB}',
    '\u{03BC}',
    '\u{03BD}',
    '\u{03BE}',
    '\u{03BF}',
    '\u{03C0}',
    '\u{03C1}',
    '\u{03C2}',
    '\u{03C3}',
    '\u{03C4}',
    '\u{03C5}',
    '\u{03C6}',
    '\u{03C7}',
    '\u{03C8}',
    '\u{03C9}',
    '\u{2202}',
    '\u{03B5}',
    '\u{03B8}',
    '\u{03BA}',
    '\u{03C6}',
    '\u{03C1}',
    '\u{03C0}',
    '\u{0391}',
    '\u{0392}',
    '\u{0393}',
    '\u{0394}',
    '\u{0395}',
    '\u{0396}',
    '\u{0397}',
    '\u{0398}',
    '\u{0399}',
    '\u{039A}',
    '\u{039B}',
    '\u{039C}',
    '\u{039D}',
    '\u{039E}',
    '\u{039F}',
    '\u{03A0}',
    '\u{03A1}',
    '\u{0398}',
    '\u{03A3}',
    '\u{03A4}',
    '\u{03A5}',
    '\u{03A6}',
    '\u{03A7}',
    '\u{03A8}',
    '\u{03A9}',
    '\u{2207}',
    '\u{03B1}',
    '\u{03B2}',
    '\u{03B3}',
    '\u{03B4}',
    '\u{03B5}',
    '\u{03B6}',
    '\u{03B7}',
    '\u{03B8}',
    '\u{03B9}',
    '\u{03BA}',
    '\u{03BB}',
    '\u{03BC}',
    '\u{03BD}',
    '\u{03BE}',
    '\u{03BF}',
    '\u{03C0}',
    '\u{03C1}',
    '\u{03C2}',
    '\u{03C3}',
    '\u{03C4}',
    '\u{03C5}',
    '\u{03C6}',
    '\u{03C7}',
    '\u{03C8}',
    '\u{03C9}',
    '\u{2202}',
    '\u{03B5}',
    '\u{03B8}',
    '\u{03BA}',
    '\u{03C6}',
    '\u{03C1}',
    '\u{03C0}',
    '\u{0391}',
    '\u{0392}',
    '\u{0393}',
    '\u{0394}',
    '\u{0395}',
    '\u{0396}',
    '\u{0397}',
    '\u{0398}',
    '\u{0399}',
    '\u{039A}',
    '\u{039B}',
    '\u{039C}',
    '\u{039D}',
    '\u{039E}',
    '\u{039F}',
    '\u{03A0}',
    '\u{03A1}',
    '\u{0398}',
    '\u{03A3}',
    '\u{03A4}',
    '\u{03A5}',
    '\u{03A6}',
    '\u{03A7}',
    '\u{03A8}',
    '\u{03A9}',
    '\u{2207}',
    '\u{03B1}',
    '\u{03B2}',
    '\u{03B3}',
    '\u{03B4}',
    '\u{03B5}',
    '\u{03B6}',
    '\u{03B7}',
    '\u{03B8}',
    '\u{03B9}',
    '\u{03BA}',
    '\u{03BB}',
    '\u{03BC}',
    '\u{03BD}',
    '\u{03BE}',
    '\u{03BF}',
    '\u{03C0}',
    '\u{03C1}',
    '\u{03C2}',
    '\u{03C3}',
    '\u{03C4}',
    '\u{03C5}',
    '\u{03C6}',
    '\u{03C7}',
    '\u{03C8}',
    '\u{03C9}',
    '\u{2202}',
    '\u{03B5}',
    '\u{03B8}',
    '\u{03BA}',
    '\u{03C6}',
    '\u{03C1}',
    '\u{03C0}',
    '\u{03DC}',
    '\u{03DD}',
    '\u{0030}',
    '\u{0031}',
    '\u{0032}',
    '\u{0033}',
    '\u{0034}',
    '\u{0035}',
    '\u{0036}',
    '\u{0037}',
    '\u{0038}',
    '\u{0039}',
    '\u{0030}',
    '\u{0031}',
    '\u{0032}',
    '\u{0033}',
    '\u{0034}',
    '\u{0035}',
    '\u{0036}',
    '\u{0037}',
    '\u{0038}',
    '\u{0039}',
    '\u{0030}',
    '\u{0031}',
    '\u{0032}',
    '\u{0033}',
    '\u{0034}',
    '\u{0035}',
    '\u{0036}',
    '\u{0037}',
    '\u{0038}',
    '\u{0039}',
    '\u{0030}',
    '\u{0031}',
    '\u{0032}',
    '\u{0033}',
    '\u{0034}',
    '\u{0035}',
    '\u{0036}',
    '\u{0037}',
    '\u{0038}',
    '\u{0039}',
    '\u{0030}',
    '\u{0031}',
    '\u{0032}',
    '\u{0033}',
    '\u{0034}',
    '\u{0035}',
    '\u{0036}',
    '\u{0037}',
    '\u{0038}',
    '\u{0039}',
    '\u{0430}',
    '\u{0431}',
    '\u{0432}',
    '\u{0433}',
    '\u{0434}',
    '\u{0435}',
    '\u{0436}',
    '\u{0437}',
    '\u{0438}',
    '\u{043A}',
    '\u{043B}',
    '\u{043C}',
    '\u{043E}',
    '\u{043F}',
    '\u{0440}',
    '\u{0441}',
    '\u{0442}',
    '\u{0443}',
    '\u{0444}',
    '\u{0445}',
    '\u{0446}',
    '\u{0447}',
    '\u{0448}',
    '\u{044B}',
    '\u{044D}',
    '\u{044E}',
    '\u{A689}',
    '\u{04D9}',
    '\u{0456}',
    '\u{0458}',
    '\u{04E9}',
    '\u{04AF}',
    '\u{04CF}',
    '\u{0430}',
    '\u{0431}',
    '\u{0432}',
    '\u{0433}',
    '\u{0434}',
    '\u{0435}',
    '\u{0436}',
    '\u{0437}',
    '\u{0438}',
    '\u{043A}',
    '\u{043B}',
    '\u{043E}',
    '\u{043F}',
    '\u{0441}',
    '\u{0443}',
    '\u{0444}',
    '\u{0445}',
    '\u{0446}',
    '\u{0447}',
    '\u{0448}',
    '\u{044A}',
    '\u{044B}',
    '\u{0491}',
    '\u{0456}',
    '\u{0455}',
    '\u{045F}',
    '\u{04AB}',
    '\u{A651}',
    '\u{04B1}',
    '\u{0627}',
    '\u{0628}',
    '\u{062C}',
    '\u{062F}',
    '\u{0648}',
    '\u{0632}',
    '\u{062D}',
    '\u{0637}',
    '\u{064A}',
    '\u{0643}',
    '\u{0644}',
    '\u{0645}',
    '\u{0646}',
    '\u{0633}',
    '\u{0639}',
    '\u{0641}',
    '\u{0635}',
    '\u{0642}',
    '\u{0631}',
    '\u{0634}',
    '\u{062A}',
    '\u{062B}',
    '\u{062E}',
    '\u{0630}',
    '\u{0636}',
    '\u{0638}',
    '\u{063A}',
    '\u{066E}',
    '\u{06BA}',
    '\u{06A1}',
    '\u{066F}',
    '\u{0628}',
    '\u{062C}',
    '\u{0647}',
    '\u{062D}',
    '\u{064A}',
    '\u{0643}',
    '\u{0644}',
    '\u{0645}',
    '\u{0646}',
    '\u{0633}',
    '\u{0639}',
    '\u{0641}',
    '\u{0635}',
    '\u{0642}',
    '\u{0634}',
    '\u{062A}',
    '\u{062B}',
    '\u{062E}',
    '\u{0636}',
    '\u{063A}',
    '\u{062C}',
    '\u{062D}',
    '\u{064A}',
    '\u{0644}',
    '\u{0646}',
    '\u{0633}',
    '\u{0639}',
    '\u{0635}',
    '\u{0642}',
    '\u{0634}',
    '\u{062E}',
    '\u{0636}',
    '\u{063A}',
    '\u{06BA}',
    '\u{066F}',
    '\u{0628}',
    '\u{062C}',
    '\u{0647}',
    '\u{062D}',
    '\u{0637}',
    '\u{064A}',
    '\u{0643}',
    '\u{0645}',
    '\u{0646}',
    '\u{0633}',
    '\u{0639}',
    '\u{0641}',
    '\u{0635}',
    '\u{0642}',
    '\u{0634}',
    '\u{062A}',
    '\u{062B}',
    '\u{062E}',
    '\u{0636}',
    '\u{0638}',
    '\u{063A}',
    '\u{066E}',
    '\u{06A1}',
    '\u{0627}',
    '\u{0628}',
    '\u{062C}',
    '\u{062F}',
    '\u{0647}',
    '\u{0648}',
    '\u{0632}',
    '\u{062D}',
    '\u{0637}',
    '\u{064A}',
    '\u{0644}',
    '\u{0645}',
    '\u{0646}',
    '\u{0633}',
    '\u{0639}',
    '\u{0641}',
    '\u{0635}',
    '\u{0642}',
    '\u{0631}',
    '\u{0634}',
    '\u{062A}',
    '\u{062B}',
    '\u{062E}',
    '\u{0630}',
    '\u{0636}',
    '\u{0638}',
    '\u{063A}',
    '\u{0628}',
    '\u{062C}',
    '\u{062F}',
    '\u{0648}',
    '\u{0632}',
    '\u{062D}',
    '\u{0637}',
    '\u{064A}',
    '\u{0644}',
    '\u{0645}',
    '\u{0646}',
    '\u{0633}',
    '\u{0639}',
    '\u{0641}',
    '\u{0635}',
    '\u{0642}',
    '\u{0631}',
    '\u{0634}',
    '\u{062A}',
    '\u{062B}',
    '\u{062E}',
    '\u{0630}',
    '\u{0636}',
    '\u{0638}',
    '\u{063A}',
    '\u{0030}',
    '\u{002E}',
    '\u{0030}',
    '\u{002C}',
    '\u{0031}',
    '\u{002C}',
    '\u{0032}',
    '\u{002C}',
    '\u{0033}',
    '\u{002C}',
    '\u{0034}',
    '\u{002C}',
    '\u{0035}',
    '\u{002C}',
    '\u{0036}',
    '\u{002C}',
    '\u{0037}',
    '\u{002C}',
    '\u{0038}',
    '\u{002C}',
    '\u{0039}',
    '\u{002C}',
    '\u{0028}',
    '\u{0041}',
    '\u{0029}',
    '\u{0028}',
    '\u{0042}',
    '\u{0029}',
    '\u{0028}',
    '\u{0043}',
    '\u{0029}',
    '\u{0028}',
    '\u{0044}',
    '\u{0029}',
    '\u{0028}',
    '\u{0045}',
    '\u{0029}',
    '\u{0028}',
    '\u{0046}',
    '\u{0029}',
    '\u{0028}',
    '\u{0047}',
    '\u{0029}',
    '\u{0028}',
    '\u{0048}',
    '\u{0029}',
    '\u{0028}',
    '\u{0049}',
    '\u{0029}',
    '\u{0028}',
    '\u{004A}',
    '\u{0029}',
    '\u{0028}',
    '\u{004B}',
    '\u{0029}',
    '\u{0028}',
    '\u{004C}',
    '\u{0029}',
    '\u{0028}',
    '\u{004D}',
    '\u{0029}',
    '\u{0028}',
    '\u{004E}',
    '\u{0029}',
    '\u{0028}',
    '\u{004F}',
    '\u{0029}',
    '\u{0028}',
    '\u{0050}',
    '\u{0029}',
    '\u{0028}',
    '\u{0051}',
    '\u{0029}',
    '\u{0028}',
    '\u{0052}',
    '\u{0029}',
    '\u{0028}',
    '\u{0053}',
    '\u{0029}',
    '\u{0028}',
    '\u{0054}',
    '\u{0029}',
    '\u{0028}',
    '\u{0055}',
    '\u{0029}',
    '\u{0028}',
    '\u{0056}',
    '\u{0029}',
    '\u{0028}',
    '\u{0057}',
    '\u{0029}',
    '\u{0028}',
    '\u{0058}',
    '\u{0029}',
    '\u{0028}',
    '\u{0059}',
    '\u{0029}',
    '\u{0028}',
    '\u{005A}',
    '\u{0029}',
    '\u{3014}',
    '\u{0053}',
    '\u{3015}',
    '\u{0043}',
    '\u{0052}',
    '\u{0043}',
    '\u{0044}',
    '\u{0057}',
    '\u{005A}',
    '\u{0041}',
    '\u{0042}',
    '\u{0043}',
    '\u{0044}',
    '\u{0045}',
    '\u{0046}',
    '\u{0047}',
    '\u{0048}',
    '\u{0049}',
    '\u{004A}',
    '\u{004B}',
    '\u{004C}',
    '\u{004D}',
    '\u{004E}',
    '\u{004F}',
    '\u{0050}',
    '\u{0051}',
    '\u{0052}',
    '\u{0053}',
    '\u{0054}',
    '\u{0055}',
    '\u{0056}',
    '\u{0057}',
    '\u{0058}',
    '\u{0059}',
    '\u{005A}',
    '\u{0048}',
    '\u{0056}',
    '\u{004D}',
    '\u{0056}',
    '\u{0053}',
    '\u{0044}',
    '\u{0053}',
    '\u{0053}',
    '\u{0050}',
    '\u{0050}',
    '\u{0056}',
    '\u{0057}',
    '\u{0043}',
    '\u{004D}',
    '\u{0043}',
    '\u{004D}',
    '\u{0044}',
    '\u{004D}',
    '\u{0052}',
    '\u{0044}',
    '\u{004A}',
    '\u{307B}',
    '\u{304B}',
    '\u{30B3}',
    '\u{30B3}',
    '\u{30B5}',
    '\u{624B}',
    '\u{5B57}',
    '\u{53CC}',
    '\u{30C6}',
    '\u{3099}',
    '\u{4E8C}',
    '\u{591A}',
    '\u{89E3}',
    '\u{5929}',
    '\u{4EA4}',
    '\u{6620}',
    '\u{7121}',
    '\u{6599}',
    '\u{524D}',
    '\u{5F8C}',
    '\u{518D}',
    '\u{65B0}',
    '\u{521D}',
    '\u{7D42}',
    '\u{751F}',
    '\u{8CA9}',
    '\u{58F0}',
    '\u{5439}',
    '\u{6F14}',
    '\u{6295}',
    '\u{6355}',
    '\u{4E00}',
    '\u{4E09}',
    '\u{904A}',
    '\u{5DE6}',
    '\u{4E2D}',
    '\u{53F3}',
    '\u{6307}',
    '\u{8D70}',
    '\u{6253}',
    '\u{7981}',
    '\u{7A7A}',
    '\u{5408}',
    '\u{6E80}',
    '\u{6709}',
    '\u{6708}',
    '\u{7533}',
    '\u{5272}',
    '\u{55B6}',
    '\u{914D}',
    '\u{3014}',
    '\u{672C}',
    '\u{3015}',
    '\u{3014}',
    '\u{4E09}',
    '\u{3015}',
    '\u{3014}',
    '\u{4E8C}',
    '\u{3015}',
    '\u{3014}',
    '\u{5B89}',
    '\u{3015}',
    '\u{3014}',
    '\u{70B9}',
    '\u{3015}',
    '\u{3014}',
    '\u{6253}',
    '\u{3015}',
    '\u{3014}',
    '\u{76D7}',
    '\u{3015}',
    '\u{3014}',
    '\u{52DD}',
    '\u{3015}',
    '\u{3014}',
    '\u{6557}',
    '\u{3015}',
    '\u{5F97}',
    '\u{53EF}',
    '\u{0030}',
    '\u{0031}',
    '\u{0032}',
    '\u{0033}',
    '\u{0034}',
    '\u{0035}',
    '\u{0036}',
    '\u{0037}',
    '\u{0038}',
    '\u{0039}',
];

pub(crate) const COMPATIBILITY_DECOMPOSED_SALT: &[u16] = &[
    0x000, 0x000, 0x00A, 0x000, 0x000, 0x000, 0x001, 0x1B9F, 0x004, 0xF3F, 0x005, 0x185, 0x000,
    0x000, 0x001, 0x000, 0x001, 0x002, 0x19D, 0x000, 0x099, 0x000, 0x03E, 0x000, 0x00A, 0x3FC,
    0x0A1, 0x000, 0x000, 0x000, 0x000, 0x001, 0x1EA, 0x000, 0x59B, 0x001, 0x3D6, 0x000, 0x078,
    0x000, 0x2F7, 0x017, 0x00E, 0x0BA, 0x0B8, 0x000, 0x0A3, 0x089, 0x007, 0x014, 0x000, 0x000,
    0x000, 0x003, 0x000, 0x000, 0x000, 0x243, 0x047, 0x005, 0x000, 0x000, 0x13F, 0x009, 0x001,
    0x000, 0x000, 0x004, 0x015, 0x001, 0x0D6, 0x01C, 0x000, 0x002, 0x0FF, 0x1B5, 0x000, 0x000,
    0x002, 0x001, 0x006, 0x000, 0x0EC, 0x004, 0x038, 0x0F3, 0x000, 0x00A, 0x01A, 0x001, 0x000,
    0x0A1, 0x000, 0x000, 0x013, 0x0CC, 0x05C, 0x007, 0x000, 0x052, 0x000, 0x00D, 0x000, 0x000,
    0x043, 0x001, 0x004, 0x003, 0x05D, 0x11C, 0x004, 0x001, 0x000, 0x000, 0x053, 0x008, 0x000,
    0x000, 0x002, 0x000, 0x01E, 0x04D, 0x000, 0x022, 0x001, 0x01F, 0x000, 0x001, 0x000, 0x000,
    0x000, 0x01E, 0x022, 0x013, 0x007, 0x004, 0x000, 0x060, 0x005, 0x000, 0x000, 0x000, 0x004,
    0x06A, 0x000, 0x000, 0x000, 0x088, 0x001, 0x000, 0x07F, 0x000, 0x002, 0x000, 0x000, 0x00D,
    0x038, 0x0A7, 0x049, 0x0D5, 0x001, 0x028, 0x004, 0x002, 0x000, 0x030, 0x00A, 0x001, 0x0F0,
    0x024, 0x002, 0x031, 0x09B, 0x000, 0x090, 0x003, 0x00B, 0x003, 0x002, 0x000, 0x057, 0x000,
    0x004, 0x000, 0x000, 0x000, 0x000, 0x005, 0x000, 0x03A, 0x006, 0x00E, 0x007, 0x000, 0x089,
    0x000, 0x000, 0x001, 0x005, 0x006, 0x02F, 0x000, 0x068, 0x001, 0x000, 0x043, 0x000, 0x028,
    0x000, 0x000, 0x0A4, 0x035, 0x013, 0x01F, 0x02F, 0x002, 0x011, 0x052, 0x008, 0x000, 0x000,
    0x013, 0x014, 0x000, 0x024, 0x000, 0x000, 0x001, 0x02C, 0x001, 0x000, 0x000, 0x014, 0x00C,
    0x016, 0x000, 0x000, 0x008, 0x00A, 0x006, 0x000, 0x000, 0x00D, 0x000, 0x0A9, 0x000, 0x000,
    0x000, 0x000, 0x009, 0x000, 0x000, 0x001, 0x000, 0x000, 0x002, 0x012, 0x000, 0x000, 0x036,
    0x002, 0x01E, 0x004, 0x00C, 0x000, 0x002, 0x000, 0x012, 0x001, 0x035, 0x000, 0x000, 0x00A,
    0x007, 0x015, 0x005, 0x01C, 0x024, 0x07A, 0x000, 0x005, 0x001, 0x012, 0x000, 0x004, 0x001,
    0x005, 0x010, 0x009, 0x000, 0x020, 0x01B, 0x006, 0x01E, 0x005, 0x04A, 0x000, 0x004, 0x000,
    0x014, 0x000, 0x009, 0x065, 0x000, 0x001, 0x000, 0x074, 0x000, 0x000, 0x045, 0x001, 0x000,
    0x000, 0x008, 0x000, 0x000, 0x017, 0x000, 0x000, 0x006, 0x000, 0x002, 0x000, 0x005, 0x000,
    0x01B, 0x000, 0x017, 0x000, 0x001, 0x003, 0x029, 0x002, 0x002, 0x007, 0x007, 0x001, 0x001,
    0x03A, 0x001, 0x001, 0x000, 0x003, 0x000, 0x004, 0x001, 0x011, 0x016, 0x000, 0x002, 0x000,
    0x002, 0x002, 0x002, 0x006, 0x000, 0x046, 0x000, 0x002, 0x000, 0x000, 0x00D, 0x011, 0x000,
    0x000, 0x01B, 0x03D, 0x007, 0x024, 0x019, 0x008, 0x05C, 0x000, 0x028, 0x004, 0x014, 0x002,
    0x004, 0x001, 0x001, 0x001, 0x000, 0x008, 0x008, 0x012, 0x002, 0x052, 0x00F, 0x000, 0x000,
    0x000, 0x007, 0x006, 0x000, 0x01E, 0x01D, 0x001, 0x010, 0x000, 0x000, 0x000, 0x001, 0x001,
    0x000, 0x004, 0x006, 0x017, 0x006, 0x004, 0x003, 0x003, 0x03E, 0x000, 0x002, 0x007, 0x023,
    0x000, 0x000, 0x001, 0x000, 0x000, 0x004, 0x007, 0x021, 0x010, 0x019, 0x005, 0x000, 0x007,
    0x000, 0x001, 0x000, 0x000, 0x000, 0x00C, 0x012, 0x02E, 0x000, 0x013, 0x027, 0x000, 0x013,
    0x000, 0x000, 0x006, 0x02C, 0x000, 0x006, 0x000, 0x00E, 0x001, 0x001, 0x005, 0x002, 0x004,
    0x016, 0x00D, 0x012, 0x008, 0x000, 0x001, 0x003, 0x000, 0x000, 0x001, 0x000, 0x000, 0x010,
    0x000, 0x000, 0x00B, 0x000, 0x000, 0x007, 0x004, 0x00F, 0x008, 0x001, 0x006, 0x001, 0x004,
    0x004, 0x00A, 0x002, 0x000, 0x002, 0x003, 0x005, 0x000, 0x000, 0x00B, 0x00B, 0x000, 0x005,
    0x003, 0x000, 0x000, 0x004, 0x004, 0x01C, 0x020, 0x000, 0x000, 0x000, 0x000, 0x013, 0x00D,
    0x00A, 0x003, 0x000, 0x00C, 0x00B, 0x000, 0x001, 0x000, 0x000, 0x003, 0x001, 0x001, 0x03E,
    0x000, 0x001, 0x017, 0x000, 0x019, 0x010, 0x003, 0x000, 0x000, 0x000, 0x000, 0x003, 0x000,
    0x008, 0x001, 0x000, 0x007, 0x003, 0x010, 0x001, 0x000, 0x002, 0x009, 0x000, 0x08B, 0x000,
    0x005, 0x000, 0x008, 0x000, 0x005, 0x012, 0x00F, 0x000, 0x000, 0x000, 0x000, 0x001, 0x000,
    0x001, 0x046, 0x000, 0x004, 0x00C, 0x000, 0x001, 0x006, 0x000, 0x014, 0x005, 0x01A, 0x007,
    0x000, 0x002, 0x005, 0x000, 0x007, 0x001, 0x020, 0x00D, 0x00B, 0x02B, 0x000, 0x01B, 0x000,
    0x003, 0x000, 0x001, 0x01A, 0x001, 0x004, 0x000, 0x000, 0x007, 0x000, 0x00C, 0x01B, 0x023,
    0x002, 0x000, 0x019, 0x01F, 0x001, 0x010, 0x008, 0x00A, 0x000, 0x000, 0x006, 0x002, 0x002,
    0x002, 0x012, 0x009, 0x01E, 0x004, 0x000, 0x00B, 0x004, 0x008, 0x01E, 0x003, 0x006, 0x00C,
    0x000, 0x000, 0x002, 0x000, 0x00A, 0x000, 0x01B, 0x000, 0x001, 0x009, 0x000, 0x00F, 0x002,
    0x000, 0x00A, 0x000, 0x008, 0x000, 0x001, 0x000, 0x000, 0x001, 0x001, 0x00C, 0x00C, 0x001,
    0x000, 0x000, 0x004, 0x000, 0x005, 0x000, 0x022, 0x002, 0x00F, 0x015, 0x00D, 0x000, 0x000,
    0x001, 0x000, 0x016, 0x000, 0x000, 0x000, 0x000, 0x008, 0x000, 0x000, 0x001, 0x000, 0x000,
    0x004, 0x001, 0x001, 0x004, 0x002, 0x002, 0x00F, 0x00A, 0x014, 0x000, 0x000, 0x001, 0x002,
    0x000, 0x002, 0x00F, 0x000, 0x000, 0x007, 0x000, 0x026, 0x000, 0x035, 0x009, 0x000, 0x005,
    0x002, 0x000, 0x00F, 0x003, 0x003, 0x006, 0x000, 0x02F, 0x002, 0x000, 0x007, 0x000, 0x000,
    0x001, 0x008, 0x016, 0x003, 0x000, 0x000, 0x016, 0x000, 0x002, 0x000, 0x00D, 0x000, 0x001,
    0x000, 0x005, 0x001, 0x00A, 0x000, 0x000, 0x002, 0x00A, 0x001, 0x000, 0x000, 0x006, 0x001,
    0x000, 0x003, 0x002, 0x015, 0x000, 0x002, 0x000, 0x000, 0x003, 0x001, 0x008, 0x002, 0x000,
    0x006, 0x000, 0x001, 0x001, 0x000, 0x000, 0x000, 0x000, 0x000, 0x00D, 0x014, 0x000, 0x001,
    0x000, 0x004, 0x000, 0x003, 0x002, 0x000, 0x000, 0x004, 0x019, 0x006, 0x007, 0x013, 0x019,
    0x003, 0x00B, 0x008, 0x013, 0x007, 0x002, 0x009, 0x000, 0x000, 0x019, 0x016, 0x002, 0x015,
    0x000, 0x004, 0x000, 0x007, 0x000, 0x008, 0x000, 0x000, 0x007, 0x001, 0x006, 0x01E, 0x01B,
    0x000, 0x00C, 0x003, 0x00F, 0x000, 0x000, 0x001, 0x00A, 0x000, 0x000, 0x000, 0x006, 0x016,
    0x006, 0x002, 0x000, 0x015, 0x006, 0x004, 0x002, 0x009, 0x000, 0x009, 0x002, 0x000, 0x00A,
    0x000, 0x000, 0x005, 0x00C, 0x000, 0x005, 0x001, 0x004, 0x000, 0x00A, 0x001, 0x004, 0x008,
    0x00E, 0x000, 0x001, 0x002, 0x006, 0x001, 0x000, 0x024, 0x000, 0x000, 0x003, 0x001, 0x000,
    0x004, 0x002, 0x000, 0x016, 0x001, 0x009, 0x000, 0x007, 0x000, 0x017, 0x001, 0x000, 0x005,
    0x016, 0x002, 0x01F, 0x000, 0x000, 0x002, 0x000, 0x000, 0x00A, 0x001, 0x00A, 0x000, 0x007,
    0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x005, 0x000, 0x005, 0x00B, 0x00C, 0x000, 0x000,
    0x001, 0x004, 0x006, 0x003, 0x001, 0x016, 0x001, 0x000, 0x000, 0x001, 0x004, 0x000, 0x001,
    0x019, 0x003, 0x003, 0x004, 0x005, 0x001, 0x01D, 0x000, 0x000, 0x007, 0x001, 0x001, 0x01F,
    0x000, 0x000, 0x001, 0x02B, 0x006, 0x010, 0x000, 0x009, 0x006, 0x00C, 0x00A, 0x002, 0x000,
    0x000, 0x001, 0x00C, 0x000, 0x000, 0x000, 0x016, 0x000, 0x000, 0x016, 0x00C, 0x00F, 0x000,
    0x010, 0x002, 0x000, 0x00C, 0x01C, 0x002, 0x000, 0x000, 0x000, 0x000, 0x001, 0x002, 0x000,
    0x003, 0x017, 0x004, 0x01C, 0x005, 0x00C, 0x001, 0x007, 0x004, 0x000, 0x001, 0x002, 0x000,
    0x00E, 0x00F, 0x002, 0x009, 0x001, 0x006, 0x020, 0x00B, 0x000, 0x000, 0x001, 0x00B, 0x002,
    0x002, 0x000, 0x000, 0x000, 0x007, 0x000, 0x001, 0x000, 0x000, 0x001, 0x001, 0x000, 0x007,
    0x000, 0x003, 0x006, 0x000, 0x000, 0x000, 0x000, 0x002, 0x000, 0x00B, 0x002, 0x000, 0x006,
    0x001, 0x001, 0x000, 0x00E, 0x00C, 0x000, 0x006, 0x000, 0x000, 0x00E, 0x000, 0x003, 0x001,
    0x000, 0x000, 0x023, 0x009, 0x007, 0x000, 0x000, 0x011, 0x012, 0x000, 0x000, 0x006, 0x001,
    0x001, 0x000, 0x00D, 0x008, 0x007, 0x002, 0x029, 0x003, 0x008, 0x004, 0x002, 0x00C, 0x001,
    0x000, 0x001, 0x00E, 0x001, 0x000, 0x000, 0x000, 0x001, 0x000, 0x000, 0x002, 0x000, 0x007,
    0x005, 0x004, 0x000, 0x000, 0x002, 0x005, 0x005, 0x005, 0x001, 0x007, 0x002, 0x00C, 0x000,
    0x003, 0x008, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x006, 0x003, 0x008,
    0x000, 0x000, 0x006, 0x003, 0x004, 0x015, 0x000, 0x007, 0x005, 0x004, 0x000, 0x008, 0x000,
    0x006, 0x000, 0x006, 0x004, 0x002, 0x000, 0x00F, 0x001, 0x000, 0x000, 0x000, 0x002, 0x007,
    0x000, 0x01A, 0x008, 0x000, 0x000, 0x001, 0x003, 0x000, 0x00C, 0x000, 0x000, 0x001, 0x005,
    0x00C, 0x000, 0x000, 0x004, 0x002, 0x000, 0x003, 0x006, 0x001, 0x004, 0x00A, 0x000, 0x002,
    0x000, 0x000, 0x005, 0x007, 0x001, 0x013, 0x01A, 0x001, 0x003, 0x000, 0x003, 0x000, 0x000,
    0x006, 0x010, 0x000, 0x002, 0x019, 0x00B, 0x001, 0x00E, 0x000, 0x006, 0x016, 0x014, 0x000,
    0x000, 0x000, 0x004, 0x000, 0x000, 0x005, 0x002, 0x00B, 0x002, 0x016, 0x000, 0x000, 0x003,
    0x001, 0x000, 0x001, 0x000, 0x00C, 0x002, 0x014, 0x000, 0x000, 0x004, 0x003, 0x009, 0x009,
    0x000, 0x001, 0x000, 0x000, 0x002, 0x001, 0x001, 0x000, 0x001, 0x000, 0x001, 0x007, 0x005,
    0x005, 0x000, 0x000, 0x001, 0x003, 0x003, 0x002, 0x011, 0x01C, 0x002, 0x011, 0x003, 0x000,
    0x00D, 0x002, 0x001, 0x001, 0x030, 0x00B, 0x007, 0x000, 0x000, 0x01C, 0x001, 0x001, 0x003,
    0x002, 0x000, 0x001, 0x00D, 0x000, 0x009, 0x000, 0x001, 0x001, 0x006, 0x006, 0x002, 0x000,
    0x001, 0x003, 0x00D, 0x004, 0x003, 0x011, 0x005, 0x000, 0x009, 0x000, 0x000, 0x000, 0x002,
    0x002, 0x014, 0x000, 0x000, 0x000, 0x001, 0x004, 0x001, 0x000, 0x001, 0x003, 0x000, 0x000,
    0x002, 0x000, 0x009, 0x003, 0x000, 0x000, 0x000, 0x002, 0x000, 0x007, 0x003, 0x001, 0x000,
    0x003, 0x005, 0x010, 0x001, 0x000, 0x013, 0x000, 0x003, 0x005, 0x000, 0x002, 0x000, 0x000,
    0x001, 0x001, 0x001, 0x001, 0x003, 0x004, 0x003, 0x001, 0x00D, 0x000, 0x001, 0x002, 0x000,
    0x008, 0x007, 0x001, 0x003, 0x000, 0x000, 0x000, 0x00E, 0x004, 0x000, 0x006, 0x00D, 0x000,
    0x000, 0x000, 0x003, 0x000, 0x000, 0x003, 0x000, 0x000, 0x020, 0x00A, 0x000, 0x001, 0x002,
    0x000, 0x000, 0x000, 0x007, 0x008, 0x000, 0x008, 0x01F, 0x001, 0x000, 0x013, 0x008, 0x001,
    0x00A, 0x005, 0x004, 0x008, 0x001, 0x001, 0x000, 0x001, 0x004, 0x003, 0x006, 0x002, 0x001,
    0x000, 0x000, 0x000, 0x005, 0x000, 0x001, 0x000, 0x000, 0x000, 0x004, 0x000, 0x000, 0x00C,
    0x002, 0x007, 0x000, 0x000, 0x00C, 0x003, 0x000, 0x000, 0x009, 0x002, 0x001, 0x004, 0x000,
    0x000, 0x000, 0x000, 0x008, 0x001, 0x000, 0x000, 0x000, 0x000, 0x000, 0x009, 0x007, 0x00F,
    0x001, 0x024, 0x00C, 0x002, 0x001, 0x000, 0x000, 0x000, 0x008, 0x001, 0x009, 0x00B, 0x000,
    0x00F, 0x002, 0x001, 0x000, 0x000, 0x000, 0x01C, 0x002, 0x001, 0x001, 0x003, 0x001, 0x001,
    0x000, 0x000, 0x005, 0x001, 0x000, 0x000, 0x000, 0x001, 0x006, 0x009, 0x002, 0x007, 0x005,
    0x00C, 0x002, 0x001, 0x006, 0x003, 0x002, 0x003, 0x002, 0x004, 0x003, 0x003, 0x007, 0x000,
    0x001, 0x004, 0x00A, 0x000, 0x001, 0x004, 0x001, 0x002, 0x000, 0x000, 0x000, 0x000, 0x003,
    0x003, 0x001, 0x001, 0x008, 0x035, 0x000, 0x003, 0x002, 0x000, 0x002, 0x001, 0x000, 0x001,
    0x001, 0x002, 0x000, 0x00B, 0x002, 0x001, 0x000, 0x000, 0x006, 0x000, 0x004, 0x007, 0x001,
    0x004, 0x004, 0x002, 0x000, 0x000, 0x003, 0x002, 0x001, 0x000, 0x000, 0x00C, 0x002, 0x00B,
    0x001, 0x00C, 0x000, 0x000, 0x001, 0x000, 0x003, 0x014, 0x001, 0x003, 0x001, 0x001, 0x009,
    0x000, 0x005, 0x003, 0x00A, 0x000, 0x001, 0x009, 0x007, 0x000, 0x005, 0x000, 0x003, 0x002,
    0x000, 0x000, 0x00C, 0x00C, 0x00C, 0x00E, 0x000, 0x004, 0x001, 0x000, 0x002, 0x000, 0x000,
    0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x001, 0x001, 0x000, 0x001, 0x003, 0x004, 0x001,
    0x002, 0x002, 0x000, 0x005, 0x000, 0x005, 0x00C, 0x000, 0x000, 0x004, 0x001, 0x000, 0x000,
    0x034, 0x007, 0x003, 0x00A, 0x000, 0x000, 0x000, 0x002, 0x004, 0x005, 0x000, 0x002, 0x008,
    0x000, 0x000, 0x000, 0x006, 0x001, 0x000, 0x003, 0x000, 0x008, 0x010, 0x000, 0x004, 0x000,
    0x000, 0x000, 0x004, 0x000, 0x002, 0x002, 0x000, 0x003, 0x003, 0x001, 0x004, 0x000, 0x005,
    0x011, 0x001, 0x001, 0x002, 0x00C, 0x009, 0x00A, 0x000, 0x002, 0x004, 0x001, 0x021, 0x000,
    0x000, 0x000, 0x001, 0x005, 0x000, 0x006, 0x000, 0x001, 0x000, 0x000, 0x000, 0x001, 0x000,
    0x001, 0x00C, 0x000, 0x001, 0x001, 0x000, 0x000, 0x007, 0x000, 0x000, 0x000, 0x002, 0x001,
    0x000, 0x001, 0x001, 0x002, 0x000, 0x008, 0x009, 0x005, 0x001, 0x003, 0x005, 0x002, 0x000,
    0x004, 0x002, 0x000, 0x000, 0x001, 0x002, 0x006, 0x007, 0x006, 0x003, 0x009, 0x000, 0x006,
    0x000, 0x006, 0x006, 0x007, 0x004, 0x000, 0x022, 0x002, 0x002, 0x002, 0x002, 0x008, 0x004,
    0x000, 0x004, 0x000, 0x009, 0x003, 0x001, 0x00A, 0x005, 0x002, 0x000, 0x000, 0x002, 0x007,
    0x001, 0x001, 0x006, 0x000, 0x001, 0x003, 0x000, 0x002, 0x001, 0x000, 0x005, 0x007, 0x001,
    0x027, 0x002, 0x008, 0x000, 0x001, 0x002, 0x003, 0x000, 0x000, 0x002, 0x001, 0x009, 0x002,
    0x001, 0x000, 0x002, 0x001, 0x011, 0x009, 0x000, 0x002, 0x001, 0x000, 0x00C, 0x007, 0x003,
    0x004, 0x007, 0x001, 0x00C, 0x001, 0x009, 0x000, 0x005, 0x002, 0x000, 0x009, 0x001, 0x001,
    0x003, 0x000, 0x007, 0x000, 0x00F, 0x000, 0x000, 0x000, 0x002, 0x002, 0x009, 0x000, 0x00A,
    0x002, 0x000, 0x000, 0x007, 0x005, 0x000, 0x001, 0x000, 0x005, 0x000, 0x009, 0x000, 0x001,
    0x002, 0x000, 0x000, 0x005, 0x009, 0x004, 0x003, 0x004, 0x000, 0x002, 0x001, 0x004, 0x001,
    0x000, 0x000, 0x002, 0x000, 0x000, 0x000, 0x000, 0x009, 0x007, 0x000, 0x001, 0x005, 0x009,
    0x002, 0x00F, 0x001, 0x003, 0x001, 0x000, 0x000, 0x003, 0x000, 0x002, 0x000, 0x003, 0x005,
    0x000, 0x002, 0x000, 0x004, 0x001, 0x000, 0x000, 0x000, 0x001, 0x000, 0x001, 0x007, 0x000,
    0x002, 0x000, 0x002, 0x008, 0x000, 0x000, 0x009, 0x001, 0x000, 0x000, 0x000, 0x000, 0x000,
    0x002, 0x001, 0x002, 0x006, 0x000, 0x000, 0x00F, 0x000, 0x001, 0x007, 0x000, 0x001, 0x000,
    0x00D, 0x000, 0x002, 0x006, 0x000, 0x003, 0x003, 0x001, 0x007, 0x00D, 0x006, 0x004, 0x001,
    0x001, 0x000, 0x001, 0x000, 0x001, 0x005, 0x002, 0x000, 0x000, 0x000, 0x018, 0x002, 0x002,
    0x000, 0x000, 0x007, 0x000, 0x000, 0x003, 0x001, 0x008, 0x010, 0x003, 0x000, 0x000, 0x000,
    0x000, 0x000, 0x004, 0x007, 0x000, 0x001, 0x000, 0x002, 0x004, 0x000, 0x008, 0x000, 0x000,
    0x000, 0x00B, 0x000, 0x001, 0x000, 0x008, 0x00A, 0x001, 0x005, 0x001, 0x000, 0x007, 0x006,
    0x000, 0x001, 0x000, 0x000, 0x001, 0x004, 0x000, 0x00B, 0x004, 0x003, 0x000, 0x000, 0x00C,
    0x001, 0x000, 0x003, 0x008, 0x000, 0x001, 0x001, 0x000, 0x003, 0x00B, 0x006, 0x000, 0x001,
    0x002, 0x001, 0x000, 0x000, 0x000, 0x000, 0x000, 0x001, 0x000, 0x000, 0x009, 0x003, 0x006,
    0x000, 0x003, 0x003, 0x001, 0x001, 0x001, 0x000, 0x000, 0x005, 0x000, 0x000, 0x007, 0x003,
    0x008, 0x002, 0x004, 0x000, 0x004, 0x006, 0x001, 0x002, 0x001, 0x002, 0x003, 0x000, 0x000,
    0x000, 0x000, 0x000, 0x000, 0x002, 0x001, 0x000, 0x002, 0x000, 0x007, 0x003, 0x00A, 0x003,
    0x001, 0x004, 0x001, 0x004, 0x002, 0x006, 0x003, 0x002, 0x000, 0x000, 0x008, 0x011, 0x000,
    0x000, 0x00D, 0x000, 0x000, 0x000, 0x000, 0x000, 0x006, 0x005, 0x000, 0x001, 0x000, 0x000,
    0x001, 0x004, 0x000, 0x000, 0x004, 0x001, 0x001, 0x000, 0x000, 0x00F, 0x004, 0x002, 0x003,
    0x000, 0x000, 0x002, 0x002, 0x002, 0x000, 0x000, 0x000, 0x005, 0x002, 0x008, 0x002, 0x000,
    0x002, 0x000, 0x005, 0x006, 0x001, 0x009, 0x000, 0x001, 0x001, 0x004, 0x002, 0x001, 0x000,
    0x000, 0x000, 0x002, 0x002, 0x003, 0x001, 0x005, 0x002, 0x000, 0x000, 0x004, 0x005, 0x001,
    0x000, 0x001, 0x000, 0x009, 0x000, 0x002, 0x001, 0x000, 0x003, 0x000, 0x002, 0x002, 0x003,
    0x000, 0x000, 0x009, 0x001, 0x003, 0x000, 0x001, 0x006, 0x003, 0x000, 0x002, 0x001, 0x007,
    0x003, 0x000, 0x005, 0x000, 0x001, 0x000, 0x000, 0x000, 0x004, 0x005, 0x000, 0x001, 0x000,
    0x003, 0x002, 0x001, 0x000, 0x002, 0x000, 0x001, 0x011, 0x001, 0x001, 0x004, 0x000, 0x001,
    0x000, 0x001, 0x001, 0x000, 0x004, 0x003, 0x000, 0x000, 0x000, 0x002, 0x001, 0x000, 0x017,
    0x004, 0x000, 0x000, 0x000, 0x003, 0x00C, 0x000, 0x008, 0x003, 0x002, 0x003, 0x005, 0x000,
    0x002, 0x003, 0x002, 0x001, 0x000, 0x003, 0x000, 0x001, 0x001, 0x000, 0x001, 0x000, 0x004,
    0x001, 0x006, 0x002, 0x01D, 0x004, 0x004, 0x000, 0x000, 0x000, 0x001, 0x000, 0x000, 0x009,
    0x002, 0x007, 0x002, 0x005, 0x000, 0x000, 0x009, 0x001, 0x004, 0x000, 0x001, 0x000, 0x000,
    0x004, 0x007, 0x000, 0x006, 0x005, 0x000, 0x001, 0x001, 0x000, 0x003, 0x001, 0x001, 0x002,
    0x000, 0x000, 0x000, 0x002, 0x000, 0x000, 0x000, 0x001, 0x000, 0x002, 0x003, 0x005, 0x001,
    0x007, 0x001, 0x001, 0x003, 0x002, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x001, 0x000,
    0x000, 0x002, 0x002, 0x000, 0x000, 0x000, 0x000, 0x000, 0x001, 0x000, 0x004, 0x003, 0x002,
    0x004, 0x000, 0x000, 0x001, 0x000, 0x000, 0x002, 0x00B, 0x008, 0x000, 0x004, 0x003, 0x001,
    0x009, 0x003, 0x002, 0x001, 0x003, 0x000, 0x002, 0x005, 0x000, 0x005, 0x001, 0x003, 0x005,
    0x002, 0x001, 0x003, 0x000, 0x010, 0x002, 0x000, 0x000, 0x000, 0x001, 0x000, 0x006, 0x000,
    0x001, 0x003, 0x000, 0x008, 0x000, 0x000, 0x002, 0x006, 0x000, 0x004, 0x000, 0x000, 0x001,
    0x000, 0x004, 0x000, 0x003, 0x001, 0x003, 0x000, 0x002, 0x003, 0x001, 0x005, 0x003, 0x005,
    0x005, 0x001, 0x001, 0x001, 0x000, 0x006, 0x003, 0x001, 0x000, 0x001, 0x001, 0x000, 0x003,
    0x002, 0x001, 0x006, 0x000, 0x005, 0x002, 0x003, 0x009, 0x007, 0x004, 0x000, 0x002, 0x002,
    0x001, 0x002, 0x006, 0x000, 0x000, 0x000, 0x002, 0x000, 0x001, 0x000, 0x004, 0x003, 0x000,
    0x002, 0x005, 0x012, 0x005, 0x002, 0x000, 0x001, 0x00D, 0x003, 0x004, 0x000, 0x000, 0x001,
    0x002, 0x000, 0x00D, 0x000, 0x00D, 0x001, 0x000, 0x001, 0x000, 0x001, 0x001, 0x001, 0x001,
    0x001, 0x001, 0x002, 0x000, 0x001, 0x005, 0x003, 0x000, 0x005, 0x000, 0x001, 0x000, 0x000,
    0x004, 0x000, 0x002, 0x001, 0x000, 0x001, 0x002, 0x000, 0x000, 0x005, 0x000, 0x001, 0x000,
    0x000, 0x000, 0x001, 0x000, 0x003, 0x000, 0x001, 0x002, 0x002, 0x000, 0x000, 0x001, 0x000,
    0x005, 0x000, 0x00D, 0x000, 0x001, 0x002, 0x00A, 0x003, 0x000, 0x000, 0x002, 0x002, 0x001,
    0x002, 0x000, 0x002, 0x001, 0x001, 0x005, 0x000, 0x00A, 0x000, 0x000, 0x003, 0x003, 0x009,
    0x001, 0x004, 0x002, 0x002, 0x000, 0x000, 0x003, 0x006, 0x000, 0x000, 0x00A, 0x001, 0x003,
    0x001, 0x00C, 0x000, 0x000, 0x000, 0x002, 0x001, 0x006, 0x001, 0x000, 0x001, 0x002, 0x007,
    0x000, 0x000, 0x005, 0x002, 0x001, 0x000, 0x001, 0x001, 0x001, 0x000, 0x004, 0x000, 0x000,
    0x001, 0x000, 0x001, 0x000, 0x001, 0x006, 0x000, 0x008, 0x000, 0x002, 0x004, 0x002, 0x004,
    0x002, 0x002, 0x000, 0x002, 0x000, 0x000, 0x000, 0x000, 0x002, 0x000, 0x005, 0x002, 0x006,
    0x000, 0x001, 0x002, 0x005, 0x000, 0x000, 0x001, 0x000, 0x002, 0x000, 0x005, 0x000, 0x001,
    0x001, 0x002, 0x003, 0x000, 0x000, 0x000, 0x000, 0x005, 0x000, 0x000, 0x001, 0x00D, 0x001,
    0x000, 0x000, 0x000, 0x001, 0x000, 0x005, 0x002, 0x000, 0x007, 0x009, 0x001, 0x002, 0x002,
    0x000, 0x001, 0x009, 0x007, 0x000, 0x005, 0x002, 0x000, 0x001, 0x001, 0x005, 0x006, 0x002,
    0x000, 0x00F, 0x000, 0x001, 0x000, 0x005, 0x001, 0x002, 0x001, 0x002, 0x000, 0x000, 0x002,
    0x003, 0x000, 0x007, 0x003, 0x000, 0x000, 0x003, 0x000, 0x002, 0x002, 0x001, 0x002, 0x001,
    0x002, 0x005, 0x001, 0x000, 0x009, 0x000, 0x000, 0x000, 0x006, 0x009, 0x001, 0x00A, 0x001,
    0x001, 0x000, 0x000, 0x003, 0x006, 0x000, 0x000, 0x000, 0x001, 0x002, 0x000, 0x000, 0x007,
    0x002, 0x000, 0x000, 0x001, 0x000, 0x000, 0x000, 0x003, 0x001, 0x000, 0x004, 0x001, 0x006,
    0x002, 0x002, 0x000, 0x000, 0x004, 0x00B, 0x001, 0x000, 0x000, 0x005, 0x001, 0x003, 0x000,
    0x002, 0x006, 0x008, 0x002, 0x000, 0x006, 0x000, 0x004, 0x001, 0x006, 0x000, 0x002, 0x003,
    0x001, 0x001, 0x001, 0x003, 0x002, 0x002, 0x002, 0x002, 0x00C, 0x001, 0x000, 0x004, 0x005,
    0x000, 0x004, 0x000, 0x000, 0x001, 0x000, 0x000, 0x000, 0x001, 0x000, 0x002, 0x000, 0x000,
    0x000, 0x001, 0x002, 0x000, 0x000, 0x008, 0x004, 0x001, 0x002, 0x000, 0x003, 0x001, 0x002,
    0x000, 0x003, 0x003, 0x007, 0x000, 0x000, 0x000, 0x000, 0x001, 0x00B, 0x000, 0x001, 0x000,
    0x000, 0x002, 0x001, 0x002, 0x001, 0x007, 0x001, 0x002, 0x003, 0x002, 0x000, 0x000, 0x001,
    0x004, 0x001, 0x001, 0x001, 0x001, 0x001, 0x000, 0x00A, 0x001, 0x005, 0x000, 0x006, 0x000,
    0x000, 0x000, 0x001, 0x003, 0x001, 0x007, 0x002, 0x000, 0x000, 0x001, 0x002, 0x001, 0x002,
    0x000, 0x001, 0x001, 0x001, 0x001, 0x000, 0x006, 0x000, 0x000, 0x000, 0x000, 0x003, 0x005,
    0x000, 0x003, 0x001, 0x002, 0x006, 0x001, 0x000, 0x001, 0x002, 0x000, 0x002, 0x003, 0x000,
    0x001, 0x000, 0x003, 0x002, 0x00C, 0x001, 0x006, 0x008, 0x007, 0x002, 0x001, 0x003, 0x000,
    0x006, 0x002, 0x000, 0x000, 0x001, 0x000, 0x000, 0x002, 0x000, 0x000, 0x000, 0x000, 0x005,
    0x000, 0x005, 0x000, 0x000, 0x001, 0x002, 0x001, 0x000, 0x001, 0x001, 0x000, 0x00A, 0x002,
    0x000, 0x000, 0x00C, 0x000, 0x001, 0x000, 0x002, 0x003, 0x001, 0x004, 0x001, 0x002, 0x001,
    0x000, 0x007, 0x001, 0x001, 0x008, 0x009, 0x002, 0x000, 0x002, 0x002, 0x003, 0x003, 0x001,
    0x003, 0x002, 0x000, 0x000, 0x001, 0x000, 0x006, 0x005, 0x000, 0x002, 0x002, 0x000, 0x001,
    0x002, 0x005, 0x004, 0x002, 0x001, 0x002, 0x000, 0x000, 0x001, 0x000, 0x001, 0x001, 0x002,
    0x000, 0x007, 0x005, 0x003, 0x000, 0x000, 0x001, 0x000, 0x004, 0x003, 0x000, 0x002, 0x007,
    0x001, 0x000, 0x002, 0x000, 0x002, 0x004, 0x002, 0x000, 0x000, 0x002, 0x000, 0x00E, 0x001,
    0x001, 0x000, 0x000, 0x003, 0x000, 0x003, 0x000, 0x000, 0x002, 0x000, 0x000, 0x006, 0x003,
    0x003, 0x003, 0x001, 0x000, 0x001, 0x000, 0x000, 0x003, 0x000, 0x000, 0x000, 0x000, 0x001,
    0x000, 0x007, 0x005, 0x001, 0x000, 0x001, 0x001, 0x003, 0x001, 0x009, 0x000, 0x000, 0x008,
    0x000, 0x000, 0x00F, 0x002, 0x002, 0x000, 0x004, 0x000, 0x000, 0x000, 0x002, 0x000, 0x001,
    0x007, 0x002, 0x001, 0x000, 0x001, 0x001, 0x002, 0x000, 0x000, 0x002, 0x000, 0x000, 0x002,
    0x000, 0x002, 0x002, 0x001, 0x006, 0x000, 0x001, 0x000, 0x001, 0x004, 0x000, 0x002, 0x003,
    0x001, 0x002, 0x000, 0x003, 0x002, 0x001, 0x000, 0x001, 0x000, 0x000, 0x000, 0x002, 0x000,
    0x001, 0x004, 0x001, 0x00E, 0x003, 0x003, 0x000, 0x005, 0x001, 0x000, 0x000, 0x002, 0x001,
    0x002, 0x000, 0x000, 0x003, 0x000, 0x002, 0x001, 0x000, 0x001, 0x000, 0x001, 0x002, 0x000,
    0x001, 0x000, 0x001, 0x001, 0x001, 0x001, 0x005, 0x003, 0x000, 0x00A, 0x002, 0x002, 0x001,
    0x000, 0x000, 0x004, 0x000, 0x002, 0x00A, 0x000, 0x000, 0x008, 0x004, 0x000, 0x001, 0x004,
    0x005, 0x005, 0x002, 0x001, 0x000, 0x000, 0x000, 0x006, 0x000, 0x001, 0x001, 0x000, 0x000,
    0x001, 0x001, 0x002, 0x001, 0x000, 0x001, 0x002, 0x002, 0x002, 0x000, 0x001, 0x001, 0x001,
    0x002, 0x000, 0x001, 0x000, 0x001, 0x000, 0x001, 0x002, 0x001, 0x000, 0x001, 0x002, 0x000,
    0x002, 0x002, 0x000, 0x000, 0x000, 0x003, 0x000, 0x001, 0x003, 0x001, 0x002, 0x007, 0x000,
    0x002, 0x004, 0x004, 0x000, 0x005, 0x000, 0x000, 0x001, 0x003, 0x003, 0x000, 0x009, 0x001,
    0x000, 0x001, 0x002, 0x004, 0x003, 0x001, 0x000, 0x001, 0x001, 0x002, 0x003, 0x001, 0x006,
    0x003, 0x001, 0x003, 0x001, 0x005, 0x004, 0x001, 0x000, 0x001, 0x001, 0x000, 0x005, 0x001,
    0x000, 0x001, 0x001, 0x002, 0x000, 0x005, 0x008, 0x001, 0x000, 0x007, 0x000, 0x000, 0x000,
    0x005, 0x001, 0x000, 0x000, 0x001, 0x000, 0x001, 0x000, 0x000, 0x002, 0x002, 0x000, 0x000,
    0x00A, 0x000, 0x000, 0x000, 0x001, 0x000, 0x001, 0x007, 0x002, 0x004, 0x000, 0x001, 0x005,
    0x000, 0x001, 0x000, 0x000, 0x000, 0x004, 0x000, 0x000, 0x004, 0x002, 0x000, 0x002, 0x001,
    0x001, 0x000, 0x002, 0x001, 0x000, 0x000, 0x000, 0x000, 0x000, 0x001, 0x002, 0x000, 0x000,
    0x004, 0x000, 0x001, 0x000, 0x003, 0x003, 0x000, 0x001, 0x003, 0x001, 0x000, 0x001, 0x000,
    0x000, 0x002, 0x000, 0x00A, 0x000, 0x001, 0x000, 0x000, 0x003, 0x001, 0x001, 0x005, 0x004,
    0x003, 0x000, 0x000, 0x002, 0x001, 0x000, 0x001, 0x000, 0x001, 0x002, 0x002, 0x001, 0x000,
    0x004, 0x001, 0x000, 0x003, 0x001, 0x001, 0x005, 0x001, 0x001, 0x007, 0x001, 0x003, 0x000,
    0x000, 0x004, 0x003, 0x001, 0x002, 0x00B, 0x002, 0x001, 0x000, 0x000, 0x000, 0x001, 0x002,
    0x001, 0x004, 0x003, 0x001, 0x001, 0x002, 0x000, 0x000, 0x002, 0x002, 0x000, 0x000, 0x000,
    0x002, 0x002, 0x001, 0x000, 0x002, 0x000, 0x000, 0x001, 0x001, 0x008, 0x002, 0x001, 0x000,
    0x003, 0x000, 0x001, 0x001, 0x001, 0x000, 0x003, 0x004, 0x002, 0x007, 0x003, 0x001, 0x009,
    0x002, 0x005, 0x002, 0x002, 0x003, 0x000, 0x00F, 0x000, 0x002, 0x001, 0x003, 0x004, 0x001,
    0x000, 0x003, 0x009, 0x002, 0x001, 0x008, 0x000, 0x001, 0x001, 0x000, 0x009, 0x000, 0x000,
    0x001, 0x000, 0x00A, 0x000, 0x004, 0x001, 0x000, 0x002, 0x003, 0x009, 0x002, 0x000, 0x000,
    0x005, 0x001, 0x002, 0x003, 0x002, 0x000, 0x001, 0x002, 0x002, 0x001, 0x003, 0x000, 0x000,
    0x002, 0x001, 0x001, 0x000, 0x001, 0x005, 0x001, 0x002, 0x002, 0x002, 0x002, 0x002, 0x002,
    0x008, 0x005, 0x000, 0x001, 0x001, 0x002, 0x000, 0x001, 0x000, 0x00B, 0x004, 0x000, 0x002,
    0x002, 0x004, 0x000, 0x001, 0x002, 0x000, 0x000, 0x001, 0x001, 0x001, 0x001, 0x002, 0x000,
    0x002, 0x000, 0x002, 0x005, 0x004, 0x000, 0x000, 0x000, 0x005, 0x000, 0x000, 0x003, 0x002,
    0x001, 0x000, 0x000, 0x000, 0x003, 0x000, 0x002, 0x000, 0x000, 0x001, 0x002, 0x002, 0x001,
    0x000, 0x001, 0x004, 0x001, 0x001, 0x000, 0x000, 0x000, 0x000, 0x000, 0x001, 0x002, 0x000,
    0x004, 0x000, 0x001, 0x002, 0x000, 0x001, 0x002, 0x000, 0x000, 0x001, 0x000, 0x002, 0x002,
    0x001, 0x001, 0x001, 0x000, 0x003, 0x001, 0x000, 0x000, 0x000, 0x000, 0x000, 0x001, 0x000,
    0x001, 0x008, 0x004, 0x001, 0x002, 0x007, 0x005, 0x000, 0x003, 0x002, 0x000, 0x002, 0x002,
    0x004, 0x000, 0x004, 0x000, 0x004, 0x002, 0x001, 0x002, 0x002, 0x002, 0x001, 0x000, 0x000,
    0x001, 0x003, 0x003, 0x001, 0x001, 0x002, 0x002, 0x000, 0x001, 0x001, 0x000, 0x001, 0x000,
    0x001, 0x001, 0x003, 0x004, 0x001, 0x002, 0x002, 0x004, 0x000, 0x003, 0x001, 0x001, 0x001,
    0x000, 0x003, 0x001, 0x000, 0x003, 0x002, 0x001, 0x000, 0x003, 0x002, 0x001, 0x006, 0x006,
    0x000, 0x000, 0x002, 0x001, 0x000, 0x001, 0x002, 0x003, 0x002, 0x001, 0x003, 0x001, 0x000,
    0x001, 0x005, 0x003, 0x001, 0x002, 0x004, 0x00D, 0x000, 0x001, 0x000, 0x000, 0x001, 0x000,
    0x000, 0x001, 0x001, 0x001, 0x000, 0x000, 0x001, 0x001, 0x002, 0x000, 0x003, 0x003, 0x000,
    0x001, 0x000, 0x002, 0x000, 0x005, 0x000, 0x001, 0x000, 0x001, 0x000, 0x000, 0x004, 0x001,
    0x002, 0x000, 0x000, 0x002, 0x002, 0x000, 0x000, 0x001, 0x004, 0x002, 0x000, 0x000, 0x004,
    0x001, 0x002, 0x000, 0x000, 0x000, 0x000, 0x001, 0x001, 0x002, 0x003, 0x000, 0x001, 0x002,
    0x003, 0x001, 0x000, 0x002, 0x001, 0x001, 0x000, 0x003, 0x002, 0x001, 0x001, 0x000, 0x000,
    0x003, 0x000, 0x003, 0x000, 0x000, 0x000, 0x003, 0x000, 0x002, 0x001, 0x001, 0x002, 0x000,
    0x004, 0x000, 0x001, 0x000, 0x001, 0x006, 0x000, 0x004, 0x001, 0x002, 0x000, 0x000, 0x000,
    0x000, 0x001, 0x002, 0x000, 0x002, 0x000, 0x002, 0x000, 0x001, 0x002, 0x001, 0x002, 0x000,
    0x000, 0x000, 0x000, 0x000, 0x000, 0x003, 0x000, 0x002, 0x001, 0x001, 0x000, 0x002, 0x000,
    0x000, 0x003, 0x008, 0x003, 0x000, 0x000, 0x000, 0x002, 0x001, 0x000, 0x000, 0x000, 0x000,
    0x001, 0x003, 0x003, 0x004, 0x000, 0x003, 0x001, 0x000, 0x001, 0x001, 0x000, 0x002, 0x004,
    0x001, 0x002, 0x001, 0x004, 0x002, 0x001, 0x000, 0x000, 0x001, 0x000, 0x000, 0x000, 0x001,
    0x001, 0x008, 0x000, 0x003, 0x000, 0x001, 0x001, 0x004, 0x001, 0x002, 0x000, 0x001, 0x001,
    0x000, 0x003, 0x001, 0x000, 0x008, 0x000, 0x000, 0x002, 0x001, 0x004, 0x005, 0x006, 0x001,
    0x002, 0x000, 0x003, 0x003, 0x000, 0x001, 0x000, 0x003, 0x000, 0x004, 0x000, 0x005, 0x001,
    0x002, 0x001, 0x003, 0x002, 0x004, 0x001, 0x001, 0x002, 0x001, 0x003, 0x005, 0x001, 0x003,
    0x001, 0x000, 0x000, 0x003, 0x000, 0x003, 0x001, 0x005, 0x000, 0x001, 0x000, 0x001, 0x002,
    0x001, 0x000, 0x004, 0x002, 0x002, 0x001, 0x002, 0x001, 0x005, 0x000, 0x001, 0x002, 0x001,
    0x000, 0x000, 0x001, 0x00A, 0x003, 0x002, 0x002, 0x000, 0x004, 0x001, 0x000, 0x001, 0x000,
    0x003, 0x000, 0x001, 0x001, 0x000, 0x001, 0x001, 0x002, 0x000, 0x001, 0x002, 0x000, 0x002,
    0x000, 0x001, 0x002, 0x002, 0x003, 0x000, 0x003, 0x003, 0x004, 0x003, 0x000, 0x000, 0x007,
    0x000, 0x002, 0x002, 0x000, 0x001, 0x002, 0x000, 0x000, 0x002, 0x000, 0x002, 0x000, 0x000,
    0x001, 0x000, 0x001, 0x003, 0x002, 0x003, 0x002, 0x000, 0x000, 0x002, 0x000, 0x000, 0x000,
    0x000, 0x000, 0x001, 0x000, 0x001, 0x001, 0x001, 0x002, 0x001, 0x000, 0x001, 0x001, 0x000,
];
pub(crate) const COMPATIBILITY_DECOMPOSED_KV: &[(u32, (u16, u16))] = &[
    (0x1D5E5, (0x12B4, 0x1)),
    (0x1D430, (0x1117, 0x1)),
    (0x0FDF1, (0xE6D, 0x3)),
    (0x024DF, (0x33C, 0x1)),
    (0x0FF18, (0xFC0, 0x1)),
    (0x0FD72, (0xD6E, 0x3)),
    (0x1D5A3, (0x1272, 0x1)),
    (0x02000, (0x113, 0x1)),
    (0x1D43F, (0x1126, 0x1)),
    (0x03197, (0x49F, 0x1)),
    (0x0FCCC, (0xC1F, 0x2)),
    (0x033DA, (0x921, 0x2)),
    (0x03289, (0x5EA, 0x1)),
    (0x0FFEA, (0x1086, 0x1)),
    (0x024E1, (0x33E, 0x1)),
    (0x02155, (0x1C3, 0x3)),
    (0x03298, (0x5F9, 0x1)),
    (0x0FEF8, (0xF9C, 0x3)),
    (0x0FF47, (0xFEF, 0x1)),
    (0x0FBEC, (0xA3D, 0x3)),
    (0x1D410, (0x10F7, 0x1)),
    (0x02177, (0x20F, 0x4)),
    (0x1D4D3, (0x11AE, 0x1)),
    (0x0FD63, (0xD41, 0x3)),
    (0x0335B, (0x7E8, 0x2)),
    (0x0FED8, (0xF76, 0x1)),
    (0x032B8, (0x620, 0x2)),
    (0x1D5F4, (0x12C3, 0x1)),
    (0x0FF27, (0xFCF, 0x1)),
    (0x1E055, (0x14F0, 0x1)),
    (0x0FFAC, (0x1054, 0x1)),
    (0x01E9A, (0x0EA, 0x2)),
    (0x1D532, (0x1208, 0x1)),
    (0x0337A, (0x839, 0x2)),
    (0x1E041, (0x14DC, 0x1)),
    (0x02148, (0x1B1, 0x1)),
    (0x1F21D, (0x1645, 0x1)),
    (0x1D73C, (0x1409, 0x1)),
    (0x01DA8, (0x0D2, 0x1)),
    (0x02F4A, (0x3A3, 0x1)),
    (0x0FF35, (0xFDD, 0x1)),
    (0x1D48E, (0x1174, 0x1)),
    (0x1EE10, (0x1518, 0x1)),
    (0x02F7D, (0x3D6, 0x1)),
    (0x02492, (0x2A7, 0x3)),
    (0x0FB58, (0x9C1, 0x1)),
    (0x1F227, (0x164F, 0x1)),
    (0x02F4E, (0x3A7, 0x1)),
    (0x1D652, (0x1321, 0x1)),
    (0x1F106, (0x15A2, 0x2)),
    (0x1D724, (0x13F1, 0x1)),
    (0x1D6DA, (0x13A7, 0x1)),
    (0x03204, (0x4B4, 0x3)),
    (0x0FEE9, (0xF87, 0x1)),
    (0x1F135, (0x1608, 0x1)),
    (0x0203E, (0x134, 0x2)),
    (0x1D46E, (0x1154, 0x1)),
    (0x1D750, (0x141D, 0x1)),
    (0x03399, (0x880, 0x2)),
    (0x0FFD7, (0x1078, 0x1)),
    (0x03211, (0x4DE, 0x4)),
    (0x1D538, (0x120E, 0x1)),
    (0x1E065, (0x1500, 0x1)),
    (0x03315, (0x6D9, 0x6)),
    (0x03382, (0x84B, 0x2)),
    (0x03161, (0x46C, 0x1)),
    (0x1D60A, (0x12D9, 0x1)),
    (0x1D4E5, (0x11C0, 0x1)),
    (0x02F24, (0x37D, 0x1)),
    (0x0FE6B, (0xEF5, 0x1)),
    (0x1D58F, (0x125E, 0x1)),
    (0x0FEC2, (0xF60, 0x1)),
    (0x0FC2E, (0xAD2, 0x2)),
    (0x032F2, (0x677, 0x1)),
    (0x0FF0C, (0xFB4, 0x1)),
    (0x1E037, (0x14D2, 0x1)),
    (0x1D7A1, (0x146E, 0x1)),
    (0x03362, (0x7F6, 0x3)),
    (0x0FB50, (0x9B9, 0x1)),
    (0x1D7F2, (0x14BD, 0x1)),
    (0x0FCA7, (0xBD5, 0x2)),
    (0x1E059, (0x14F4, 0x1)),
    (0x0FD99, (0xDDD, 0x3)),
    (0x1D464, (0x114A, 0x1)),
    (0x0FB78, (0x9E1, 0x1)),
    (0x0FE58, (0xEE3, 0x1)),
    (0x032EE, (0x673, 0x1)),
    (0x107A8, (0x10B1, 0x1)),
    (0x0FD5C, (0xD2C, 0x3)),
    (0x0207E, (0x14D, 0x1)),
    (0x0321A, (0x502, 0x4)),
    (0x1D7D8, (0x14A3, 0x1)),
    (0x01D40, (0x09A, 0x1)),
    (0x0FCDE, (0xC43, 0x2)),
    (0x1CCF7, (0x10E4, 0x1)),
    (0x032A5, (0x606, 0x1)),
    (0x0FC0C, (0xA8E, 0x2)),
    (0x0FF40, (0xFE8, 0x1)),
    (0x033C0, (0x8E2, 0x2)),
    (0x0FC40, (0xAF6, 0x2)),
    (0x1D5CD, (0x129C, 0x1)),
    (0x1D7F8, (0x14C3, 0x1)),
    (0x01DA1, (0x0CB, 0x1)),
    (0x02F26, (0x37F, 0x1)),
    (0x1D706, (0x13D3, 0x1)),
    (0x0FF36, (0xFDE, 0x1)),
    (0x0325A, (0x5A0, 0x2)),
    (0x02F84, (0x3DD, 0x1)),
    (0x0317D, (0x488, 0x1)),
    (0x0FC16, (0xAA2, 0x2)),
    (0x1D5B6, (0x1285, 0x1)),
    (0x0FD3B, (0xD02, 0x2)),
    (0x0313E, (0x449, 0x1)),
    (0x1D69F, (0x136E, 0x1)),
    (0x024A8, (0x2E9, 0x3)),
    (0x1D50F, (0x11E7, 0x1)),
    (0x0FD52, (0xD0E, 0x3)),
    (0x02112, (0x187, 0x1)),
    (0x0FDF0, (0xE6A, 0x3)),
    (0x1D77A, (0x1447, 0x1)),
    (0x0FF7E, (0x1026, 0x1)),
    (0x1D7E0, (0x14AB, 0x1)),
    (0x0FC07, (0xA84, 0x2)),
    (0x0FB5B, (0x9C4, 0x1)),
    (0x1D49C, (0x1182, 0x1)),
    (0x0FE48, (0xED0, 0x1)),
    (0x1F220, (0x1648, 0x1)),
    (0x02F8B, (0x3E4, 0x1)),
    (0x02048, (0x138, 0x2)),
    (0x0FCEC, (0xC61, 0x2)),
    (0x02F89, (0x3E2, 0x1)),
    (0x0FC49, (0xB08, 0x2)),
    (0x03293, (0x5F4, 0x1)),
    (0x00385, (0x05C, 0x3)),
    (0x0222C, (0x222, 0x2)),
    (0x02FBA, (0x413, 0x1)),
    (0x032C6, (0x63C, 0x2)),
    (0x1D600, (0x12CF, 0x1)),
    (0x1D58C, (0x125B, 0x1)),
    (0x0FB71, (0x9DA, 0x1)),
    (0x1D55F, (0x122E, 0x1)),
    (0x1D494, (0x117A, 0x1)),
    (0x0320C, (0x4CC, 0x3)),
    (0x1D4E4, (0x11BF, 0x1)),
    (0x01DB4, (0x0DE, 0x1)),
    (0x0FF82, (0x102A, 0x1)),
    (0x032B1, (0x612, 0x2)),
    (0x02475, (0x24E, 0x3)),
    (0x1D46B, (0x1151, 0x1)),
    (0x01DA0, (0x0CA, 0x1)),
    (0x1D4D4, (0x11AF, 0x1)),
    (0x0FB8F, (0x9F8, 0x1)),
    (0x1D7A2, (0x146F, 0x1)),
    (0x02084, (0x153, 0x1)),
    (0x1079A, (0x10A3, 0x1)),
    (0x1D6F0, (0x13BD, 0x1)),
    (0x107AF, (0x10B8, 0x1)),
    (0x1D597, (0x1266, 0x1)),
    (0x0FC14, (0xA9E, 0x2)),
    (0x0319E, (0x4A6, 0x1)),
    (0x03282, (0x5E3, 0x1)),
    (0x10788, (0x1091, 0x1)),
    (0x1EE22, (0x1529, 0x1)),
    (0x0FD2A, (0xCE0, 0x2)),
    (0x1F139, (0x160C, 0x1)),
    (0x0FF0A, (0xFB2, 0x1)),
    (0x03290, (0x5F1, 0x1)),
    (0x1E039, (0x14D4, 0x1)),
    (0x1F21E, (0x1646, 0x1)),
    (0x03304, (0x697, 0x5)),
    (0x1D6A1, (0x1370, 0x1)),
    (0x024B3, (0x30A, 0x3)),
    (0x03198, (0x4A0, 0x1)),
    (0x1EE96, (0x1577, 0x1)),
    (0x0FC41, (0xAF8, 0x2)),
    (0x0FE3D, (0xEC7, 0x1)),
    (0x1D73B, (0x1408, 0x1)),
    (0x0A69D, (0x987, 0x1)),
    (0x1D5AF, (0x127E, 0x1)),
    (0x0316F, (0x47A, 0x1)),
    (0x0FEF7, (0xF99, 0x3)),
    (0x033E8, (0x93F, 0x2)),
    (0x024BE, (0x31B, 0x1)),
    (0x033BB, (0x8D8, 0x2)),
    (0x033EC, (0x94A, 0x3)),
    (0x0329F, (0x600, 0x1)),
    (0x1D402, (0x10E9, 0x1)),
    (0x02092, (0x160, 0x1)),
    (0x033EE, (0x950, 0x3)),
    (0x0FEA2, (0xF40, 0x1)),
    (0x1D4D2, (0x11AD, 0x1)),
    (0x0328A, (0x5EB, 0x1)),
    (0x0FFA5, (0x104D, 0x1)),
    (0x03299, (0x5FA, 0x1)),
    (0x1D5C4, (0x1293, 0x1)),
    (0x1D6B6, (0x1383, 0x1)),
    (0x0FF08, (0xFB0, 0x1)),
    (0x1D7EA, (0x14B5, 0x1)),
    (0x02F15, (0x36E, 0x1)),
    (0x024AB, (0x2F2, 0x3)),
    (0x033D9, (0x91E, 0x3)),
    (0x0FFE3, (0x107F, 0x2)),
    (0x1D6E2, (0x13AF, 0x1)),
    (0x1D728, (0x13F5, 0x1)),
    (0x0FCAE, (0xBE3, 0x2)),
    (0x02121, (0x193, 0x3)),
    (0x1D422, (0x1109, 0x1)),
    (0x1D41E, (0x1105, 0x1)),
    (0x01D3F, (0x099, 0x1)),
    (0x0FF86, (0x102E, 0x1)),
    (0x0FDC1, (0xE55, 0x3)),
    (0x0FC45, (0xB00, 0x2)),
    (0x1CCDB, (0x10C8, 0x1)),
    (0x1D50A, (0x11E4, 0x1)),
    (0x1079D, (0x10A6, 0x1)),
    (0x00140, (0x01E, 0x2)),
    (0x1D76C, (0x1439, 0x1)),
    (0x0FED4, (0xF72, 0x1)),
    (0x1D67A, (0x1349, 0x1)),
    (0x1F11B, (0x15CD, 0x3)),
    (0x002B7, (0x045, 0x1)),
    (0x1D458, (0x113E, 0x1)),
    (0x0FD8E, (0xDC2, 0x3)),
    (0x0FEB3, (0xF51, 0x1)),
    (0x0FB5F, (0x9C8, 0x1)),
    (0x02FC9, (0x422, 0x1)),
    (0x024CC, (0x329, 0x1)),
    (0x1D4A9, (0x1188, 0x1)),
    (0x0FD31, (0xCEE, 0x2)),
    (0x001C4, (0x023, 0x3)),
    (0x03156, (0x461, 0x1)),
    (0x1D4F3, (0x11CE, 0x1)),
    (0x024C8, (0x325, 0x1)),
    (0x0FB02, (0x997, 0x2)),
    (0x0FBDD, (0xA29, 0x2)),
    (0x1D768, (0x1435, 0x1)),
    (0x002B6, (0x044, 0x1)),
    (0x0FB7C, (0x9E5, 0x1)),
    (0x02146, (0x1AF, 0x1)),
    (0x0FFC2, (0x1067, 0x1)),
    (0x1D6A2, (0x1371, 0x1)),
    (0x02006, (0x119, 0x1)),
    (0x1D445, (0x112C, 0x1)),
    (0x0FF0B, (0xFB3, 0x1)),
    (0x1D5FA, (0x12C9, 0x1)),
    (0x02F0A, (0x363, 0x1)),
    (0x02F14, (0x36D, 0x1)),
    (0x0FE6A, (0xEF4, 0x1)),
    (0x1D6C2, (0x138F, 0x1)),
    (0x0FD7D, (0xD8F, 0x3)),
    (0x03370, (0x820, 0x3)),
    (0x0326F, (0x5BC, 0x2)),
    (0x1EE2A, (0x152D, 0x1)),
    (0x0FC86, (0xB8E, 0x2)),
    (0x0FF12, (0xFBA, 0x1)),
    (0x02F05, (0x35E, 0x1)),
    (0x0FBE1, (0xA2E, 0x1)),
    (0x1EE1B, (0x1523, 0x1)),
    (0x0216A, (0x1F8, 0x2)),
    (0x0FC78, (0xB72, 0x2)),
    (0x1D4BE, (0x119A, 0x1)),
    (0x03366, (0x802, 0x3)),
    (0x1D69E, (0x136D, 0x1)),
    (0x03182, (0x48D, 0x1)),
    (0x1D425, (0x110C, 0x1)),
    (0x1D760, (0x142D, 0x1)),
    (0x02139, (0x1A5, 0x1)),
    (0x0FDA5, (0xE01, 0x3)),
    (0x033B8, (0x8D2, 0x2)),
    (0x0FB03, (0x999, 0x3)),
    (0x1D461, (0x1147, 0x1)),
    (0x1D58B, (0x125A, 0x1)),
    (0x0FC7E, (0xB7E, 0x2)),
    (0x1D7ED, (0x14B8, 0x1)),
    (0x1E047, (0x14E2, 0x1)),
    (0x033C4, (0x8EC, 0x2)),
    (0x1EEB0, (0x158A, 0x1)),
    (0x02467, (0x233, 0x1)),
    (0x1D4C8, (0x11A3, 0x1)),
    (0x0FF70, (0x1018, 0x1)),
    (0x0FC30, (0xAD6, 0x2)),
    (0x1EE79, (0x155D, 0x1)),
    (0x0FDC5, (0xE61, 0x3)),
    (0x1D70D, (0x13DA, 0x1)),
    (0x0FF61, (0x1009, 0x1)),
    (0x1D7DE, (0x14A9, 0x1)),
    (0x1D416, (0x10FD, 0x1)),
    (0x0FF90, (0x1038, 0x1)),
    (0x03390, (0x86A, 0x2)),
    (0x1CCDD, (0x10CA, 0x1)),
    (0x1078D, (0x1096, 0x1)),
    (0x1EEA8, (0x1583, 0x1)),
    (0x0FC50, (0xB16, 0x2)),
    (0x1D572, (0x1241, 0x1)),
    (0x0FED7, (0xF75, 0x1)),
    (0x1D629, (0x12F8, 0x1)),
    (0x1D693, (0x1362, 0x1)),
    (0x0FDAC, (0xE16, 0x3)),
    (0x033C3, (0x8EA, 0x2)),
    (0x0FEF2, (0xF90, 0x1)),
    (0x02156, (0x1C6, 0x3)),
    (0x1F241, (0x1667, 0x3)),
    (0x0203C, (0x132, 0x2)),
    (0x1D40F, (0x10F6, 0x1)),
    (0x02165, (0x1EC, 0x2)),
    (0x003F1, (0x069, 0x1)),
    (0x107A2, (0x10AB, 0x1)),
    (0x0FB8D, (0x9F6, 0x1)),
    (0x0FC24, (0xABE, 0x2)),
    (0x1D510, (0x11E8, 0x1)),
    (0x03239, (0x566, 0x3)),
    (0x1D67E, (0x134D, 0x1)),
    (0x0320D, (0x4CF, 0x3)),
    (0x03330, (0x749, 0x3)),
    (0x1D735, (0x1402, 0x1)),
    (0x0FB72, (0x9DB, 0x1)),
    (0x1EE51, (0x1543, 0x1)),
    (0x1D635, (0x1304, 0x1)),
    (0x0FC26, (0xAC2, 0x2)),
    (0x1F218, (0x1640, 0x1)),
    (0x02145, (0x1AE, 0x1)),
    (0x01DB8, (0x0E2, 0x1)),
    (0x1D79B, (0x1468, 0x1)),
    (0x0314C, (0x457, 0x1)),
    (0x0FC9C, (0xBBF, 0x2)),
    (0x0FCEF, (0xC67, 0x2)),
    (0x032DD, (0x662, 0x1)),
    (0x0212C, (0x19A, 0x1)),
    (0x1D488, (0x116E, 0x1)),
    (0x02F68, (0x3C1, 0x1)),
    (0x1E05B, (0x14F6, 0x1)),
    (0x1E03D, (0x14D8, 0x1)),
    (0x032B2, (0x614, 0x2)),
    (0x0FD76, (0xD7A, 0x3)),
    (0x0FD6F, (0xD65, 0x3)),
    (0x1F141, (0x1614, 0x1)),
    (0x1D627, (0x12F6, 0x1)),
    (0x0FF97, (0x103F, 0x1)),
    (0x02F9E, (0x3F7, 0x1)),
    (0x0FD1A, (0xCC0, 0x2)),
    (0x1F10A, (0x15AA, 0x2)),
    (0x02FB7, (0x410, 0x1)),
    (0x0FCDD, (0xC41, 0x2)),
    (0x0FC10, (0xA96, 0x2)),
    (0x03347, (0x7A1, 0x5)),
    (0x03369, (0x80B, 0x3)),
    (0x033C6, (0x8F0, 0x4)),
    (0x0330F, (0x6C1, 0x4)),
    (0x02F98, (0x3F1, 0x1)),
    (0x0FB8A, (0x9F3, 0x1)),
    (0x0FD56, (0xD1A, 0x3)),
    (0x1D44C, (0x1133, 0x1)),
    (0x1D68C, (0x135B, 0x1)),
    (0x0FDB3, (0xE2B, 0x3)),
    (0x02FAE, (0x407, 0x1)),
    (0x1CCD6, (0x10C3, 0x1)),
    (0x0FFB0, (0x1058, 0x1)),
    (0x1D60E, (0x12DD, 0x1)),
    (0x02070, (0x141, 0x1)),
    (0x0AB69, (0x992, 0x1)),
    (0x1E068, (0x1503, 0x1)),
    (0x03140, (0x44B, 0x1)),
    (0x0FFAE, (0x1056, 0x1)),
    (0x03155, (0x460, 0x1)),
    (0x0FB51, (0x9BA, 0x1)),
    (0x01DBB, (0x0E5, 0x1)),
    (0x02466, (0x232, 0x1)),
    (0x1D729, (0x13F6, 0x1)),
    (0x0FBFF, (0xA70, 0x1)),
    (0x003D0, (0x05F, 0x1)),
    (0x033D2, (0x90B, 0x3)),
    (0x1F112, (0x15B2, 0x3)),
    (0x01D37, (0x092, 0x1)),
    (0x02057, (0x13C, 0x4)),
    (0x0314F, (0x45A, 0x1)),
    (0x002B3, (0x041, 0x1)),
    (0x0FF64, (0x100C, 0x1)),
    (0x0FEAE, (0xF4C, 0x1)),
    (0x1F244, (0x1670, 0x3)),
    (0x02F71, (0x3CA, 0x1)),
    (0x0FE13, (0xEB0, 0x1)),
    (0x02135, (0x1A1, 0x1)),
    (0x0FF5A, (0x1002, 0x1)),
    (0x03143, (0x44E, 0x1)),
    (0x1D552, (0x1221, 0x1)),
    (0x03339, (0x76E, 0x3)),
    (0x0FCCA, (0xC1B, 0x2)),
    (0x0FD19, (0xCBE, 0x2)),
    (0x1D487, (0x116D, 0x1)),
    (0x003F4, (0x06B, 0x1)),
    (0x1E035, (0x14D0, 0x1)),
    (0x0FD84, (0xDA4, 0x3)),
    (0x1D4FA, (0x11D5, 0x1)),
    (0x1D51B, (0x11F2, 0x1)),
    (0x0FB7A, (0x9E3, 0x1)),
    (0x0FFC7, (0x106C, 0x1)),
    (0x1EE6D, (0x1553, 0x1)),
    (0x024D3, (0x330, 0x1)),
    (0x0FFEE, (0x108A, 0x1)),
    (0x1D777, (0x1444, 0x1)),
    (0x0FF34, (0xFDC, 0x1)),
    (0x1D5DE, (0x12AD, 0x1)),
    (0x1D482, (0x1168, 0x1)),
    (0x1EE2B, (0x152E, 0x1)),
    (0x024E6, (0x343, 0x1)),
    (0x1EE67, (0x154E, 0x1)),
    (0x0210B, (0x180, 0x1)),
    (0x0FB75, (0x9DE, 0x1)),
    (0x0FFD6, (0x1077, 0x1)),
    (0x1D5E8, (0x12B7, 0x1)),
    (0x01D56, (0x0AF, 0x1)),
    (0x0FBE4, (0xA31, 0x1)),
    (0x1F23A, (0x1662, 0x1)),
    (0x0FD6B, (0xD59, 0x3)),
    (0x1F235, (0x165D, 0x1)),
    (0x0FDFC, (0xEA9, 0x4)),
    (0x0FF9F, (0x1047, 0x1)),
    (0x1EE80, (0x1562, 0x1)),
    (0x1D485, (0x116B, 0x1)),
    (0x0FD59, (0xD23, 0x3)),
    (0x0FE34, (0xEBE, 0x1)),
    (0x0FF41, (0xFE9, 0x1)),
    (0x0FD6A, (0xD56, 0x3)),
    (0x01DAF, (0x0D9, 0x1)),
    (0x03176, (0x481, 0x1)),
    (0x0FBD8, (0xA24, 0x1)),
    (0x0FBA2, (0xA0B, 0x1)),
    (0x02F2F, (0x388, 0x1)),
    (0x1F13B, (0x160E, 0x1)),
    (0x1D440, (0x1127, 0x1)),
    (0x0FECD, (0xF6B, 0x1)),
    (0x03138, (0x443, 0x1)),
    (0x0FDC7, (0xE67, 0x3)),
    (0x1D74A, (0x1417, 0x1)),
    (0x0FEEC, (0xF8A, 0x1)),
    (0x0316A, (0x475, 0x1)),
    (0x02F8C, (0x3E5, 0x1)),
    (0x033B1, (0x8C4, 0x2)),
    (0x0FF2E, (0xFD6, 0x1)),
    (0x02F3B, (0x394, 0x1)),
    (0x1D63F, (0x130E, 0x1)),
    (0x1D5C9, (0x1298, 0x1)),
    (0x1D4B8, (0x1196, 0x1)),
    (0x024B1, (0x304, 0x3)),
    (0x1D45B, (0x1141, 0x1)),
    (0x03170, (0x47B, 0x1)),
    (0x1D7E3, (0x14AE, 0x1)),
    (0x0FEB5, (0xF53, 0x1)),
    (0x0339C, (0x886, 0x2)),
    (0x0FC8C, (0xB9A, 0x2)),
    (0x0FBDE, (0xA2B, 0x1)),
    (0x0FD0A, (0xCA0, 0x2)),
    (0x1E052, (0x14ED, 0x1)),
    (0x0FD9B, (0xDE3, 0x3)),
    (0x0331E, (0x704, 0x4)),
    (0x02FB3, (0x40C, 0x1)),
    (0x024E8, (0x345, 0x1)),
    (0x033AF, (0x8BC, 0x6)),
    (0x1D7AD, (0x147A, 0x1)),
    (0x1EEAE, (0x1588, 0x1)),
    (0x03303, (0x694, 0x3)),
    (0x02470, (0x243, 0x2)),
    (0x1D6DF, (0x13AC, 0x1)),
    (0x0FF8B, (0x1033, 0x1)),
    (0x1079E, (0x10A7, 0x1)),
    (0x1D5C1, (0x1290, 0x1)),
    (0x0FB24, (0x9B1, 0x1)),
    (0x1D79C, (0x1469, 0x1)),
    (0x1F133, (0x1606, 0x1)),
    (0x0335A, (0x7E6, 0x2)),
    (0x0FE19, (0xEB6, 0x3)),
    (0x0208C, (0x15B, 0x1)),
    (0x1D680, (0x134F, 0x1)),
    (0x1D5D6, (0x12A5, 0x1)),
    (0x1EEB8, (0x1592, 0x1)),
    (0x01D58, (0x0B1, 0x1)),
    (0x032F9, (0x67E, 0x1)),
    (0x0FD86, (0xDAA, 0x3)),
    (0x107B4, (0x10BC, 0x1)),
    (0x0338E, (0x866, 0x2)),
    (0x0FC35, (0xAE0, 0x2)),
    (0x02C7D, (0x355, 0x1)),
    (0x1EE35, (0x1537, 0x1)),
    (0x0FD0E, (0xCA8, 0x2)),
    (0x0325F, (0x5AA, 0x2)),
    (0x033F2, (0x95C, 0x3)),
    (0x01D4F, (0x0A8, 0x1)),
    (0x1D6D2, (0x139F, 0x1)),
    (0x0FC76, (0xB6E, 0x2)),
    (0x1D406, (0x10ED, 0x1)),
    (0x000BC, (0x00F, 0x3)),
    (0x1F231, (0x1659, 0x1)),
    (0x1EE89, (0x156B, 0x1)),
    (0x1D415, (0x10FC, 0x1)),
    (0x0FDF8, (0xE88, 0x4)),
    (0x1D42B, (0x1112, 0x1)),
    (0x0FCD5, (0xC31, 0x2)),
    (0x0FCA5, (0xBD1, 0x2)),
    (0x1D701, (0x13CE, 0x1)),
    (0x0FF13, (0xFBB, 0x1)),
    (0x1D41A, (0x1101, 0x1)),
    (0x1D775, (0x1442, 0x1)),
    (0x1D469, (0x114F, 0x1)),
    (0x03284, (0x5E5, 0x1)),
    (0x032BF, (0x62E, 0x2)),
    (0x03322, (0x716, 0x3)),
    (0x0FCF9, (0xC7E, 0x2)),
    (0x02F45, (0x39E, 0x1)),
    (0x0FD28, (0xCDC, 0x2)),
    (0x03376, (0x82F, 0x2)),
    (0x1D771, (0x143E, 0x1)),
    (0x02F78, (0x3D1, 0x1)),
    (0x0FF80, (0x1028, 0x1)),
    (0x1D498, (0x117E, 0x1)),
    (0x1F13F, (0x1612, 0x1)),
    (0x1D710, (0x13DD, 0x1)),
    (0x0FEBF, (0xF5D, 0x1)),
    (0x032D1, (0x656, 0x1)),
    (0x024BA, (0x317, 0x1)),
    (0x1D6DC, (0x13A9, 0x1)),
    (0x1D556, (0x1225, 0x1)),
    (0x0FF38, (0xFE0, 0x1)),
    (0x1D700, (0x13CD, 0x1)),
    (0x0FC7B, (0xB78, 0x2)),
    (0x02025, (0x122, 0x2)),
    (0x0FD5E, (0xD32, 0x3)),
    (0x0FE90, (0xF2E, 0x1)),
    (0x1D78E, (0x145B, 0x1)),
    (0x1D7DD, (0x14A8, 0x1)),
    (0x0FF51, (0xFF9, 0x1)),
    (0x1D648, (0x1317, 0x1)),
    (0x1D73F, (0x140C, 0x1)),
    (0x0328E, (0x5EF, 0x1)),
    (0x1D795, (0x1462, 0x1)),
    (0x02488, (0x292, 0x2)),
    (0x024A6, (0x2E3, 0x3)),
    (0x0319C, (0x4A4, 0x1)),
    (0x1D717, (0x13E4, 0x1)),
    (0x1D409, (0x10F0, 0x1)),
    (0x1D4D8, (0x11B3, 0x1)),
    (0x1D7FE, (0x14C9, 0x1)),
    (0x03367, (0x805, 0x3)),
    (0x0FF78, (0x1020, 0x1)),
    (0x1D404, (0x10EB, 0x1)),
    (0x1D43A, (0x1121, 0x1)),
    (0x0FF88, (0x1030, 0x1)),
    (0x0202F, (0x127, 0x1)),
    (0x1D418, (0x10FF, 0x1)),
    (0x0338C, (0x862, 0x2)),
    (0x00EDD, (0x07E, 0x2)),
    (0x1D5F1, (0x12C0, 0x1)),
    (0x1D4C2, (0x119E, 0x1)),
    (0x0FF24, (0xFCC, 0x1)),
    (0x0FE49, (0xED1, 0x2)),
    (0x0246E, (0x23F, 0x2)),
    (0x0FFCF, (0x1072, 0x1)),
    (0x02F0B, (0x364, 0x1)),
    (0x01FDF, (0x106, 0x3)),
    (0x1D6FA, (0x13C7, 0x1)),
    (0x1D616, (0x12E5, 0x1)),
    (0x0246D, (0x23D, 0x2)),
    (0x0FEE7, (0xF85, 0x1)),
    (0x0FC5B, (0xB2C, 0x2)),
    (0x003D2, (0x061, 0x1)),
    (0x1D524, (0x11FA, 0x1)),
    (0x0336F, (0x81D, 0x3)),
    (0x0FBB1, (0xA1D, 0x2)),
    (0x0FCAF, (0xBE5, 0x2)),
    (0x02151, (0x1B6, 0x3)),
    (0x02F7F, (0x3D8, 0x1)),
    (0x0337B, (0x83B, 0x2)),
    (0x1F219, (0x1641, 0x1)),
    (0x1EEA7, (0x1582, 0x1)),
    (0x0334A, (0x7AC, 0x6)),
    (0x1E05C, (0x14F7, 0x1)),
    (0x03235, (0x55A, 0x3)),
    (0x0FF5B, (0x1003, 0x1)),
    (0x1D608, (0x12D7, 0x1)),
    (0x03375, (0x82D, 0x2)),
    (0x02F6C, (0x3C5, 0x1)),
    (0x1CCF2, (0x10DF, 0x1)),
    (0x1D47B, (0x1161, 0x1)),
    (0x1D62F, (0x12FE, 0x1)),
    (0x032F3, (0x678, 0x1)),
    (0x032AC, (0x60D, 0x1)),
    (0x1D721, (0x13EE, 0x1)),
    (0x1EE70, (0x1556, 0x1)),
    (0x000BE, (0x015, 0x3)),
    (0x033E5, (0x939, 0x2)),
    (0x0FE7F, (0xF10, 0x2)),
    (0x1D55D, (0x122C, 0x1)),
    (0x0337C, (0x83D, 0x2)),
    (0x0FBA7, (0xA12, 0x1)),
    (0x1D5B1, (0x1280, 0x1)),
    (0x033FC, (0x97A, 0x3)),
    (0x1D6AA, (0x1377, 0x1)),
    (0x1D4DF, (0x11BA, 0x1)),
    (0x1D45F, (0x1145, 0x1)),
    (0x1E032, (0x14CD, 0x1)),
    (0x01D48, (0x0A2, 0x1)),
    (0x1D769, (0x1436, 0x1)),
    (0x1D704, (0x13D1, 0x1)),
    (0x1D621, (0x12F0, 0x1)),
    (0x033D1, (0x909, 0x2)),
    (0x0FDBF, (0xE4F, 0x3)),
    (0x1D73E, (0x140B, 0x1)),
    (0x0322D, (0x542, 0x3)),
    (0x0FB27, (0x9B4, 0x1)),
    (0x1F22A, (0x1652, 0x1)),
    (0x0FE17, (0xEB4, 0x1)),
    (0x01D31, (0x08C, 0x1)),
    (0x0FCFC, (0xC84, 0x2)),
    (0x03218, (0x4FA, 0x4)),
    (0x1F14D, (0x1623, 0x2)),
    (0x0FD07, (0xC9A, 0x2)),
    (0x0330A, (0x6AF, 0x3)),
    (0x02F64, (0x3BD, 0x1)),
    (0x02F60, (0x3B9, 0x1)),
    (0x02002, (0x115, 0x1)),
    (0x0FF72, (0x101A, 0x1)),
    (0x0FD11, (0xCAE, 0x2)),
    (0x1D66F, (0x133E, 0x1)),
    (0x1EEBB, (0x1595, 0x1)),
    (0x01DA6, (0x0D0, 0x1)),
    (0x0FB21, (0x9AE, 0x1)),
    (0x1D450, (0x1137, 0x1)),
    (0x1D670, (0x133F, 0x1)),
    (0x02477, (0x254, 0x3)),
    (0x0FD36, (0xCF8, 0x2)),
    (0x0FC44, (0xAFE, 0x2)),
    (0x1EEB5, (0x158F, 0x1)),
    (0x02153, (0x1BD, 0x3)),
    (0x1D787, (0x1454, 0x1)),
    (0x0FC8D, (0xB9C, 0x2)),
    (0x1D40C, (0x10F3, 0x1)),
    (0x0FC62, (0xB3E, 0x3)),
    (0x107B9, (0x10C1, 0x1)),
    (0x03384, (0x84F, 0x2)),
    (0x1EE77, (0x155C, 0x1)),
    (0x0FCC1, (0xC09, 0x2)),
    (0x0FCB8, (0xBF7, 0x2)),
    (0x0335D, (0x7EC, 0x2)),
    (0x1F11C, (0x15D0, 0x3)),
    (0x1D5AD, (0x127C, 0x1)),
    (0x0FB9B, (0xA04, 0x1)),
    (0x01FCE, (0x0FA, 0x3)),
    (0x01D5D, (0x0B6, 0x1)),
    (0x032FA, (0x67F, 0x1)),
    (0x032DB, (0x660, 0x1)),
    (0x0FEE5, (0xF83, 0x1)),
    (0x0FE41, (0xECB, 0x1)),
    (0x0FF04, (0xFAC, 0x1)),
    (0x0208D, (0x15C, 0x1)),
    (0x024CE, (0x32B, 0x1)),
    (0x0FD92, (0xDC8, 0x3)),
    (0x1D441, (0x1128, 0x1)),
    (0x1078A, (0x1093, 0x1)),
    (0x02F73, (0x3CC, 0x1)),
    (0x02111, (0x186, 0x1)),
    (0x1078E, (0x1097, 0x1)),
    (0x033CD, (0x901, 0x2)),
    (0x0249A, (0x2BF, 0x3)),
    (0x1D7CE, (0x1499, 0x1)),
    (0x0FF67, (0x100F, 0x1)),
    (0x0FC74, (0xB6A, 0x2)),
    (0x0FC89, (0xB94, 0x2)),
    (0x0217F, (0x21E, 0x1)),
    (0x02168, (0x1F5, 0x2)),
    (0x1D59D, (0x126C, 0x1)),
    (0x03261, (0x5AD, 0x1)),
    (0x1D68F, (0x135E, 0x1)),
    (0x0FB63, (0x9CC, 0x1)),
    (0x1EE37, (0x1539, 0x1)),
    (0x1D56C, (0x123B, 0x1)),
    (0x03171, (0x47C, 0x1)),
    (0x1D56D, (0x123C, 0x1)),
    (0x0FE4A, (0xED3, 0x2)),
    (0x1EEA2, (0x157E, 0x1)),
    (0x0FE5E, (0xEE9, 0x1)),
    (0x1D6B4, (0x1381, 0x1)),
    (0x1D69B, (0x136A, 0x1)),
    (0x0208E, (0x15D, 0x1)),
    (0x0FE98, (0xF36, 0x1)),
    (0x1D61E, (0x12ED, 0x1)),
    (0x1D439, (0x1120, 0x1)),
    (0x02172, (0x204, 0x3)),
    (0x02F30, (0x389, 0x1)),
    (0x1D52B, (0x1201, 0x1)),
    (0x1D49B, (0x1181, 0x1)),
    (0x02109, (0x17D, 0x2)),
    (0x0FF50, (0xFF8, 0x1)),
    (0x0315C, (0x467, 0x1)),
    (0x0335F, (0x7F0, 0x2)),
    (0x0314E, (0x459, 0x1)),
    (0x03267, (0x5B3, 0x1)),
    (0x02F74, (0x3CD, 0x1)),
    (0x0FC93, (0xBA8, 0x2)),
    (0x1EE98, (0x1579, 0x1)),
    (0x1F243, (0x166D, 0x3)),
    (0x01D60, (0x0B9, 0x1)),
    (0x0FF62, (0x100A, 0x1)),
    (0x1D6D9, (0x13A6, 0x1)),
    (0x03167, (0x472, 0x1)),
    (0x02480, (0x272, 0x4)),
    (0x0FD69, (0xD53, 0x3)),
    (0x033E0, (0x92F, 0x2)),
    (0x03175, (0x480, 0x1)),
    (0x0FC15, (0xAA0, 0x2)),
    (0x1D536, (0x120C, 0x1)),
    (0x0FBF8, (0xA61, 0x3)),
    (0x0FE3B, (0xEC5, 0x1)),
    (0x0211B, (0x18E, 0x1)),
    (0x024AD, (0x2F8, 0x3)),
    (0x1CCE3, (0x10D0, 0x1)),
    (0x0331F, (0x708, 0x4)),
    (0x0FE72, (0xEFA, 0x2)),
    (0x1D65D, (0x132C, 0x1)),
    (0x0FC6B, (0xB58, 0x2)),
    (0x1D56B, (0x123A, 0x1)),
    (0x0217C, (0x21B, 0x1)),
    (0x1D7E4, (0x14AF, 0x1)),
    (0x1D586, (0x1255, 0x1)),
    (0x0FC8B, (0xB98, 0x2)),
    (0x1D4A2, (0x1185, 0x1)),
    (0x0FD53, (0xD11, 0x3)),
    (0x0A770, (0x988, 0x1)),
    (0x1D517, (0x11EE, 0x1)),
    (0x1D7AA, (0x1477, 0x1)),
    (0x1EE6F, (0x1555, 0x1)),
    (0x1D559, (0x1228, 0x1)),
    (0x00675, (0x070, 0x2)),
    (0x03337, (0x767, 0x3)),
    (0x107B6, (0x10BE, 0x1)),
    (0x0FED0, (0xF6E, 0x1)),
    (0x001F3, (0x03C, 0x2)),
    (0x1CCD8, (0x10C5, 0x1)),
    (0x0FF17, (0xFBF, 0x1)),
    (0x1F22D, (0x1655, 0x1)),
    (0x10791, (0x109A, 0x1)),
    (0x1D78A, (0x1457, 0x1)),
    (0x1EE2D, (0x1530, 0x1)),
    (0x033D0, (0x907, 0x2)),
    (0x0FB04, (0x99C, 0x3)),
    (0x01D66, (0x0BF, 0x1)),
    (0x0332B, (0x730, 0x6)),
    (0x1F16A, (0x162A, 0x2)),
    (0x1D7AF, (0x147C, 0x1)),
    (0x0FC90, (0xBA2, 0x2)),
    (0x0FF1E, (0xFC6, 0x1)),
    (0x1D6F1, (0x13BE, 0x1)),
    (0x0FD6C, (0xD5C, 0x3)),
    (0x0FB59, (0x9C2, 0x1)),
    (0x0FEAA, (0xF48, 0x1)),
    (0x0FE7E, (0xF0E, 0x2)),
    (0x0315D, (0x468, 0x1)),
    (0x02F7C, (0x3D5, 0x1)),
    (0x1D7C4, (0x1491, 0x1)),
    (0x02D6F, (0x356, 0x1)),
    (0x1D653, (0x1322, 0x1)),
    (0x0FE36, (0xEC0, 0x1)),
    (0x0FEC3, (0xF61, 0x1)),
    (0x03220, (0x51B, 0x3)),
    (0x1D74F, (0x141C, 0x1)),
    (0x02F63, (0x3BC, 0x1)),
    (0x1D658, (0x1327, 0x1)),
    (0x1D7CF, (0x149A, 0x1)),
    (0x0FC04, (0xA7D, 0x3)),
    (0x1D682, (0x1351, 0x1)),
    (0x1D622, (0x12F1, 0x1)),
    (0x033FA, (0x974, 0x3)),
    (0x1D6EC, (0x13B9, 0x1)),
    (0x01D5B, (0x0B4, 0x1)),
    (0x0FCBA, (0xBFB, 0x2)),
    (0x033F8, (0x96E, 0x3)),
    (0x1D5BF, (0x128E, 0x1)),
    (0x0FCA4, (0xBCF, 0x2)),
    (0x1EEB4, (0x158E, 0x1)),
    (0x1F217, (0x163F, 0x1)),
    (0x01DA7, (0x0D1, 0x1)),
    (0x1D736, (0x1403, 0x1)),
    (0x1D720, (0x13ED, 0x1)),
    (0x0FD94, (0xDCE, 0x3)),
    (0x1D519, (0x11F0, 0x1)),
    (0x1E03F, (0x14DA, 0x1)),
    (0x1D7EF, (0x14BA, 0x1)),
    (0x033A1, (0x892, 0x2)),
    (0x1F143, (0x1616, 0x1)),
    (0x1D4A5, (0x1186, 0x1)),
    (0x02F9C, (0x3F5, 0x1)),
    (0x0330B, (0x6B2, 0x3)),
    (0x107A7, (0x10B0, 0x1)),
    (0x0FF21, (0xFC9, 0x1)),
    (0x02FC1, (0x41A, 0x1)),
    (0x0FECA, (0xF68, 0x1)),
    (0x1D63B, (0x130A, 0x1)),
    (0x1F146, (0x1619, 0x1)),
    (0x1CCF3, (0x10E0, 0x1)),
    (0x1D633, (0x1302, 0x1)),
    (0x024B9, (0x316, 0x1)),
    (0x0334D, (0x7BA, 0x4)),
    (0x032E9, (0x66E, 0x1)),
    (0x033CF, (0x905, 0x2)),
    (0x1D5E9, (0x12B8, 0x1)),
    (0x024C0, (0x31D, 0x1)),
    (0x1D64C, (0x131B, 0x1)),
    (0x1D6C4, (0x1391, 0x1)),
    (0x1E044, (0x14DF, 0x1)),
    (0x1D407, (0x10EE, 0x1)),
    (0x1D4AA, (0x1189, 0x1)),
    (0x0328F, (0x5F0, 0x1)),
    (0x1D529, (0x11FF, 0x1)),
    (0x0249B, (0x2C2, 0x3)),
    (0x03348, (0x7A6, 0x4)),
    (0x02F08, (0x361, 0x1)),
    (0x1D49E, (0x1183, 0x1)),
    (0x03189, (0x494, 0x1)),
    (0x1D42C, (0x1113, 0x1)),
    (0x0207A, (0x149, 0x1)),
    (0x1D6C5, (0x1392, 0x1)),
    (0x02005, (0x118, 0x1)),
    (0x1D5C2, (0x1291, 0x1)),
    (0x0FB76, (0x9DF, 0x1)),
    (0x1D6F9, (0x13C6, 0x1)),
    (0x03147, (0x452, 0x1)),
    (0x03184, (0x48F, 0x1)),
    (0x02F92, (0x3EB, 0x1)),
    (0x1D5D7, (0x12A6, 0x1)),
    (0x0FB83, (0x9EC, 0x1)),
    (0x02090, (0x15E, 0x1)),
    (0x0FEA5, (0xF43, 0x1)),
    (0x1D79D, (0x146A, 0x1)),
    (0x1D7D9, (0x14A4, 0x1)),
    (0x0FCC0, (0xC07, 0x2)),
    (0x03279, (0x5D0, 0x2)),
    (0x1D78F, (0x145C, 0x1)),
    (0x0321D, (0x50E, 0x7)),
    (0x1D6C7, (0x1394, 0x1)),
    (0x1CCF5, (0x10E2, 0x1)),
    (0x1EE8F, (0x1570, 0x1)),
    (0x1EE0F, (0x1517, 0x1)),
    (0x0FCDF, (0xC45, 0x3)),
    (0x1D501, (0x11DC, 0x1)),
    (0x1D610, (0x12DF, 0x1)),
    (0x1CCE0, (0x10CD, 0x1)),
    (0x0FD21, (0xCCE, 0x2)),
    (0x032E4, (0x669, 0x1)),
    (0x1F13D, (0x1610, 0x1)),
    (0x0FCF7, (0xC7A, 0x2)),
    (0x0313D, (0x448, 0x1)),
    (0x01D9D, (0x0C7, 0x1)),
    (0x02474, (0x24B, 0x3)),
    (0x0FFBD, (0x1065, 0x1)),
    (0x1D7D0, (0x149B, 0x1)),
    (0x1F232, (0x165A, 0x1)),
    (0x1F225, (0x164D, 0x1)),
    (0x1D7F1, (0x14BC, 0x1)),
    (0x03232, (0x551, 0x3)),
    (0x0249E, (0x2CB, 0x3)),
    (0x02F75, (0x3CE, 0x1)),
    (0x1F210, (0x1637, 0x1)),
    (0x1D4D5, (0x11B0, 0x1)),
    (0x03222, (0x521, 0x3)),
    (0x1D782, (0x144F, 0x1)),
    (0x10789, (0x1092, 0x1)),
    (0x03305, (0x69C, 0x3)),
    (0x0FF4B, (0xFF3, 0x1)),
    (0x0FCB2, (0xBEB, 0x2)),
    (0x03199, (0x4A1, 0x1)),
    (0x0FEEA, (0xF88, 0x1)),
    (0x03396, (0x87A, 0x2)),
    (0x03247, (0x58A, 0x1)),
    (0x0FC88, (0xB92, 0x2)),
    (0x0FBA6, (0xA11, 0x1)),
    (0x01D9C, (0x0C6, 0x1)),
    (0x0FC82, (0xB86, 0x2)),
    (0x1EE6A, (0x1551, 0x1)),
    (0x0FD38, (0xCFC, 0x2)),
    (0x03325, (0x720, 0x3)),
    (0x1D6BF, (0x138C, 0x1)),
    (0x1D4B4, (0x1192, 0x1)),
    (0x1D6CA, (0x1397, 0x1)),
    (0x0339E, (0x88A, 0x2)),
    (0x1D641, (0x1310, 0x1)),
    (0x0FE63, (0xEEE, 0x1)),
    (0x024D0, (0x32D, 0x1)),
    (0x0FC9B, (0xBBC, 0x3)),
    (0x0FE8D, (0xF2B, 0x1)),
    (0x01DA5, (0x0CF, 0x1)),
    (0x0A7F9, (0x98D, 0x1)),
    (0x1D43B, (0x1122, 0x1)),
    (0x0FDBA, (0xE40, 0x3)),
    (0x1F134, (0x1607, 0x1)),
    (0x0FC77, (0xB70, 0x2)),
    (0x02FB0, (0x409, 0x1)),
    (0x1D426, (0x110D, 0x1)),
    (0x1D453, (0x113A, 0x1)),
    (0x1D5DC, (0x12AB, 0x1)),
    (0x1D6F3, (0x13C0, 0x1)),
    (0x1D5EC, (0x12BB, 0x1)),
    (0x024C5, (0x322, 0x1)),
    (0x03168, (0x473, 0x1)),
    (0x1D6CF, (0x139C, 0x1)),
    (0x024B0, (0x301, 0x3)),
    (0x1D568, (0x1237, 0x1)),
    (0x1F122, (0x15E2, 0x3)),
    (0x1D52E, (0x1204, 0x1)),
    (0x1D511, (0x11E9, 0x1)),
    (0x02FB1, (0x40A, 0x1)),
    (0x1F137, (0x160A, 0x1)),
    (0x0FFAA, (0x1052, 0x1)),
    (0x0FB69, (0x9D2, 0x1)),
    (0x01FCF, (0x0FD, 0x3)),
    (0x1D5AA, (0x1279, 0x1)),
    (0x1D6F6, (0x13C3, 0x1)),
    (0x1D4EC, (0x11C7, 0x1)),
    (0x1D5CF, (0x129E, 0x1)),
    (0x032A4, (0x605, 0x1)),
    (0x033CE, (0x903, 0x2)),
    (0x10781, (0x108B, 0x1)),
    (0x02F6F, (0x3C8, 0x1)),
    (0x1F126, (0x15EE, 0x3)),
    (0x02F5A, (0x3B3, 0x1)),
    (0x0FF68, (0x1010, 0x1)),
    (0x02F88, (0x3E1, 0x1)),
    (0x01DB0, (0x0DA, 0x1)),
    (0x0FCD0, (0xC27, 0x2)),
    (0x033B0, (0x8C2, 0x2)),
    (0x0333D, (0x77E, 0x5)),
    (0x1E069, (0x1504, 0x1)),
    (0x0FF8D, (0x1035, 0x1)),
    (0x1D70C, (0x13D9, 0x1)),
    (0x1D643, (0x1312, 0x1)),
    (0x0FBA0, (0xA09, 0x1)),
    (0x03157, (0x462, 0x1)),
    (0x1D457, (0x113D, 0x1)),
    (0x0FE95, (0xF33, 0x1)),
    (0x0FD83, (0xDA1, 0x3)),
    (0x1D56F, (0x123E, 0x1)),
    (0x02F16, (0x36F, 0x1)),
    (0x1D731, (0x13FE, 0x1)),
    (0x1D459, (0x113F, 0x1)),
    (0x1D698, (0x1367, 0x1)),
    (0x1D740, (0x140D, 0x1)),
    (0x033F5, (0x965, 0x3)),
    (0x0339D, (0x888, 0x2)),
    (0x03224, (0x527, 0x3)),
    (0x0FC1C, (0xAAE, 0x2)),
    (0x1F116, (0x15BE, 0x3)),
    (0x0213F, (0x1AC, 0x1)),
    (0x0FC39, (0xAE8, 0x2)),
    (0x0FF2C, (0xFD4, 0x1)),
    (0x1D5C7, (0x1296, 0x1)),
    (0x03377, (0x831, 0x2)),
    (0x1D788, (0x1455, 0x1)),
    (0x02FD5, (0x42E, 0x1)),
    (0x1D75E, (0x142B, 0x1)),
    (0x1D743, (0x1410, 0x1)),
    (0x0320B, (0x4C9, 0x3)),
    (0x1F238, (0x1660, 0x1)),
    (0x033A2, (0x894, 0x3)),
    (0x0FE78, (0xF02, 0x2)),
    (0x0FE93, (0xF31, 0x1)),
    (0x1D683, (0x1352, 0x1)),
    (0x0FD64, (0xD44, 0x3)),
    (0x1D634, (0x1303, 0x1)),
    (0x0FF3B, (0xFE3, 0x1)),
    (0x01D9E, (0x0C8, 0x1)),
    (0x03327, (0x726, 0x2)),
    (0x1F236, (0x165E, 0x1)),
    (0x1D5C0, (0x128F, 0x1)),
    (0x02FCC, (0x425, 0x1)),
    (0x1D431, (0x1118, 0x1)),
    (0x1EE0B, (0x1513, 0x1)),
    (0x1D7BA, (0x1487, 0x1)),
    (0x0FC48, (0xB06, 0x2)),
    (0x0FEF3, (0xF91, 0x1)),
    (0x1D4CE, (0x11A9, 0x1)),
    (0x0FFC3, (0x1068, 0x1)),
    (0x1D4FD, (0x11D8, 0x1)),
    (0x0FC1B, (0xAAC, 0x2)),
    (0x1EE8C, (0x156D, 0x1)),
    (0x1D784, (0x1451, 0x1)),
    (0x03264, (0x5B0, 0x1)),
    (0x0FF7B, (0x1023, 0x1)),
    (0x1EE59, (0x1547, 0x1)),
    (0x1D790, (0x145D, 0x1)),
    (0x02F31, (0x38A, 0x1)),
    (0x0FF22, (0xFCA, 0x1)),
    (0x0211D, (0x190, 0x1)),
    (0x1E057, (0x14F2, 0x1)),
    (0x1D6FE, (0x13CB, 0x1)),
    (0x1D484, (0x116A, 0x1)),
    (0x1D668, (0x1337, 0x1)),
    (0x0FE5F, (0xEEA, 0x1)),
    (0x1D562, (0x1231, 0x1)),
    (0x0319F, (0x4A7, 0x1)),
    (0x02074, (0x143, 0x1)),
    (0x1D5EF, (0x12BE, 0x1)),
    (0x107AB, (0x10B4, 0x1)),
    (0x020A8, (0x16B, 0x2)),
    (0x1E063, (0x14FE, 0x1)),
    (0x0FC57, (0xB24, 0x2)),
    (0x03356, (0x7D9, 0x6)),
    (0x1D43D, (0x1124, 0x1)),
    (0x0FCCF, (0xC25, 0x2)),
    (0x01D47, (0x0A1, 0x1)),
    (0x1D654, (0x1323, 0x1)),
    (0x0FFE8, (0x1084, 0x1)),
    (0x03302, (0x68F, 0x5)),
    (0x0FCD9, (0xC39, 0x2)),
    (0x1D639, (0x1308, 0x1)),
    (0x1D79F, (0x146C, 0x1)),
    (0x1D6B2, (0x137F, 0x1)),
    (0x0FE8E, (0xF2C, 0x1)),
    (0x1E048, (0x14E3, 0x1)),
    (0x03039, (0x432, 0x1)),
    (0x1E064, (0x14FF, 0x1)),
    (0x033A0, (0x88F, 0x3)),
    (0x1D49F, (0x1184, 0x1)),
    (0x02F4C, (0x3A5, 0x1)),
    (0x0FC31, (0xAD8, 0x2)),
    (0x1D491, (0x1177, 0x1)),
    (0x1E04D, (0x14E8, 0x1)),
    (0x0FF16, (0xFBE, 0x1)),
    (0x01D68, (0x0C1, 0x1)),
    (0x0FF71, (0x1019, 0x1)),
    (0x1EE76, (0x155B, 0x1)),
    (0x1D423, (0x110A, 0x1)),
    (0x01FCD, (0x0F7, 0x3)),
    (0x0FE44, (0xECE, 0x1)),
    (0x1F132, (0x1605, 0x1)),
    (0x1D77C, (0x1449, 0x1)),
    (0x0FF93, (0x103B, 0x1)),
    (0x0331B, (0x6FA, 0x4)),
    (0x1D7F5, (0x14C0, 0x1)),
    (0x0FF8F, (0x1037, 0x1)),
    (0x032A2, (0x603, 0x1)),
    (0x1EE0E, (0x1516, 0x1)),
    (0x1D6E8, (0x13B5, 0x1)),
    (0x1D520, (0x11F6, 0x1)),
    (0x033E4, (0x937, 0x2)),
    (0x1D44E, (0x1135, 0x1)),
    (0x1CCD9, (0x10C6, 0x1)),
    (0x02FC4, (0x41D, 0x1)),
    (0x02024, (0x121, 0x1)),
    (0x010FC, (0x087, 0x1)),
    (0x0FDB0, (0xE22, 0x3)),
    (0x1EE87, (0x1569, 0x1)),
    (0x03000, (0x42F, 0x1)),
    (0x1FBF6, (0x1687, 0x1)),
    (0x1D76F, (0x143C, 0x1)),
    (0x03385, (0x851, 0x2)),
    (0x0325D, (0x5A6, 0x2)),
    (0x1D6C3, (0x1390, 0x1)),
    (0x0FC0A, (0xA8A, 0x2)),
    (0x1D67C, (0x134B, 0x1)),
    (0x0FF9B, (0x1043, 0x1)),
    (0x0FE7A, (0xF06, 0x2)),
    (0x02FB4, (0x40D, 0x1)),
    (0x02096, (0x164, 0x1)),
    (0x0247C, (0x263, 0x3)),
    (0x1D64A, (0x1319, 0x1)),
    (0x1D785, (0x1452, 0x1)),
    (0x1D7DA, (0x14A5, 0x1)),
    (0x0FB17, (0x9AB, 0x2)),
    (0x1D761, (0x142E, 0x1)),
    (0x032C7, (0x63E, 0x2)),
    (0x01FC0, (0x0F2, 0x2)),
    (0x033E3, (0x935, 0x2)),
    (0x0FCDB, (0xC3D, 0x2)),
    (0x1D5B4, (0x1283, 0x1)),
    (0x1D48F, (0x1175, 0x1)),
    (0x0FC2A, (0xACA, 0x2)),
    (0x1D55B, (0x122A, 0x1)),
    (0x1D68A, (0x1359, 0x1)),
    (0x1D637, (0x1306, 0x1)),
    (0x0FFB6, (0x105E, 0x1)),
    (0x1D770, (0x143D, 0x1)),
    (0x107A4, (0x10AD, 0x1)),
    (0x03186, (0x491, 0x1)),
    (0x0FE18, (0xEB5, 0x1)),
    (0x03253, (0x592, 0x2)),
    (0x02163, (0x1E9, 0x2)),
    (0x02F51, (0x3AA, 0x1)),
    (0x003F5, (0x06C, 0x1)),
    (0x0329B, (0x5FC, 0x1)),
    (0x0FFB8, (0x1060, 0x1)),
    (0x03215, (0x4EE, 0x4)),
    (0x0FFA3, (0x104B, 0x1)),
    (0x1D4CA, (0x11A5, 0x1)),
    (0x0FBAB, (0xA16, 0x1)),
    (0x0FF65, (0x100D, 0x1)),
    (0x0FE5C, (0xEE7, 0x1)),
    (0x0FC52, (0xB1A, 0x2)),
    (0x02F9B, (0x3F4, 0x1)),
    (0x1D51A, (0x11F1, 0x1)),
    (0x03234, (0x557, 0x3)),
    (0x00E33, (0x078, 0x2)),
    (0x0FD8A, (0xDB6, 0x3)),
    (0x0FD5A, (0xD26, 0x3)),
    (0x02494, (0x2AD, 0x3)),
    (0x02F80, (0x3D9, 0x1)),
    (0x0FB67, (0x9D0, 0x1)),
    (0x032A1, (0x602, 0x1)),
    (0x1D797, (0x1464, 0x1)),
    (0x0309C, (0x436, 0x2)),
    (0x0FFE1, (0x107D, 0x1)),
    (0x0FD7B, (0xD89, 0x3)),
    (0x0FB61, (0x9CA, 0x1)),
    (0x0FF10, (0xFB8, 0x1)),
    (0x03280, (0x5E1, 0x1)),
    (0x1F138, (0x160B, 0x1)),
    (0x033AE, (0x8B7, 0x5)),
    (0x10798, (0x10A1, 0x1)),
    (0x1D738, (0x1405, 0x1)),
    (0x0FC5D, (0xB30, 0x2)),
    (0x1D50E, (0x11E6, 0x1)),
    (0x02F4B, (0x3A4, 0x1)),
    (0x02FA4, (0x3FD, 0x1)),
    (0x032B6, (0x61C, 0x2)),
    (0x032EB, (0x670, 0x1)),
    (0x03135, (0x440, 0x1)),
    (0x1D5C3, (0x1292, 0x1)),
    (0x0FB97, (0xA00, 0x1)),
    (0x0FCE8, (0xC59, 0x2)),
    (0x0322B, (0x53C, 0x3)),
    (0x0FC43, (0xAFC, 0x2)),
    (0x032E5, (0x66A, 0x1)),
    (0x0FBA5, (0xA0F, 0x2)),
    (0x1D6EE, (0x13BB, 0x1)),
    (0x0FD80, (0xD98, 0x3)),
    (0x01DAC, (0x0D6, 0x1)),
    (0x1CCDF, (0x10CC, 0x1)),
    (0x1E03C, (0x14D7, 0x1)),
    (0x02037, (0x12F, 0x3)),
    (0x1D5F8, (0x12C7, 0x1)),
    (0x1D66C, (0x133B, 0x1)),
    (0x03150, (0x45B, 0x1)),
    (0x03276, (0x5CA, 0x2)),
    (0x1D4EA, (0x11C5, 0x1)),
    (0x032BC, (0x628, 0x2)),
    (0x1F145, (0x1618, 0x1)),
    (0x0213E, (0x1AB, 0x1)),
    (0x1D412, (0x10F9, 0x1)),
    (0x10790, (0x1099, 0x1)),
    (0x0FEDA, (0xF78, 0x1)),
    (0x1F12E, (0x1601, 0x2)),
    (0x1D4F1, (0x11CC, 0x1)),
    (0x0FED2, (0xF70, 0x1)),
    (0x0FD81, (0xD9B, 0x3)),
    (0x03306, (0x69F, 0x3)),
    (0x02473, (0x249, 0x2)),
    (0x1D6B0, (0x137D, 0x1)),
    (0x0FB9F, (0xA08, 0x1)),
    (0x033B4, (0x8CA, 0x2)),
    (0x03214, (0x4EA, 0x4)),
    (0x1D7E2, (0x14AD, 0x1)),
    (0x0331D, (0x701, 0x3)),
    (0x1D578, (0x1247, 0x1)),
    (0x02122, (0x196, 0x2)),
    (0x0FF44, (0xFEC, 0x1)),
    (0x1D4F7, (0x11D2, 0x1)),
    (0x0FCD3, (0xC2D, 0x2)),
    (0x0FFCA, (0x106D, 0x1)),
    (0x000B5, (0x00A, 0x1)),
    (0x0FC32, (0xADA, 0x2)),
    (0x1D7C5, (0x1492, 0x1)),
    (0x1D625, (0x12F4, 0x1)),
    (0x032A3, (0x604, 0x1)),
    (0x03311, (0x6C9, 0x4)),
    (0x1EE2C, (0x152F, 0x1)),
    (0x03180, (0x48B, 0x1)),
    (0x0FB5D, (0x9C6, 0x1)),
    (0x0FB25, (0x9B2, 0x1)),
    (0x0FBEE, (0xA43, 0x3)),
    (0x02FC7, (0x420, 0x1)),
    (0x0322F, (0x548, 0x3)),
    (0x1D5FE, (0x12CD, 0x1)),
    (0x02F36, (0x38F, 0x1)),
    (0x1D74D, (0x141A, 0x1)),
    (0x1D5A5, (0x1274, 0x1)),
    (0x02FC3, (0x41C, 0x1)),
    (0x1E06C, (0x1507, 0x1)),
    (0x1D508, (0x11E2, 0x1)),
    (0x1D741, (0x140E, 0x1)),
    (0x03221, (0x51E, 0x3)),
    (0x1D512, (0x11EA, 0x1)),
    (0x0FECE, (0xF6C, 0x1)),
    (0x1D6D5, (0x13A2, 0x1)),
    (0x032A7, (0x608, 0x1)),
    (0x1D6B8, (0x1385, 0x1)),
    (0x0FF06, (0xFAE, 0x1)),
    (0x0FFE5, (0x1082, 0x1)),
    (0x0323C, (0x56F, 0x3)),
    (0x1CCE1, (0x10CE, 0x1)),
    (0x0FE39, (0xEC3, 0x1)),
    (0x0FBFC, (0xA6D, 0x1)),
    (0x1F11D, (0x15D3, 0x3)),
    (0x0FCCD, (0xC21, 0x2)),
    (0x0FF42, (0xFEA, 0x1)),
    (0x02189, (0x21F, 0x3)),
    (0x00149, (0x020, 0x2)),
    (0x01DB3, (0x0DD, 0x1)),
    (0x1EE4D, (0x1540, 0x1)),
    (0x1D6E7, (0x13B4, 0x1)),
    (0x107A0, (0x10A9, 0x1)),
    (0x002DD, (0x051, 0x2)),
    (0x02F97, (0x3F0, 0x1)),
    (0x1D71E, (0x13EB, 0x1)),
    (0x1D4F9, (0x11D4, 0x1)),
    (0x02102, (0x173, 0x1)),
    (0x1D7B4, (0x1481, 0x1)),
    (0x0315B, (0x466, 0x1)),
    (0x0AB5D, (0x98F, 0x1)),
    (0x001CB, (0x034, 0x2)),
    (0x0FED9, (0xF77, 0x1)),
    (0x02167, (0x1F1, 0x4)),
    (0x0FD20, (0xCCC, 0x2)),
    (0x1D69D, (0x136C, 0x1)),
    (0x1D561, (0x1230, 0x1)),
    (0x0213D, (0x1AA, 0x1)),
    (0x1D7F4, (0x14BF, 0x1)),
    (0x1D632, (0x1301, 0x1)),
    (0x0FF9A, (0x1042, 0x1)),
    (0x03389, (0x85A, 0x4)),
    (0x02034, (0x12A, 0x3)),
    (0x01D67, (0x0C0, 0x1)),
    (0x0FF23, (0xFCB, 0x1)),
    (0x1D577, (0x1246, 0x1)),
    (0x0FEDC, (0xF7A, 0x1)),
    (0x1D75B, (0x1428, 0x1)),
    (0x1D4B9, (0x1197, 0x1)),
    (0x033BA, (0x8D6, 0x2)),
    (0x1D667, (0x1336, 0x1)),
    (0x0331C, (0x6FE, 0x3)),
    (0x1CCD7, (0x10C4, 0x1)),
    (0x0FEC7, (0xF65, 0x1)),
    (0x1CCF6, (0x10E3, 0x1)),
    (0x1EE99, (0x157A, 0x1)),
    (0x1CCEE, (0x10DB, 0x1)),
    (0x1D5DA, (0x12A9, 0x1)),
    (0x1D454, (0x113B, 0x1)),
    (0x1EE94, (0x1575, 0x1)),
    (0x1D4FC, (0x11D7, 0x1)),
    (0x1D7A5, (0x1472, 0x1)),
    (0x1F120, (0x15DC, 0x3)),
    (0x1D72C, (0x13F9, 0x1)),
    (0x0FE52, (0xEDE, 0x1)),
    (0x1D684, (0x1353, 0x1)),
    (0x0FE86, (0xF1D, 0x2)),
    (0x03360, (0x7F2, 0x2)),
    (0x02F0F, (0x368, 0x1)),
    (0x1D5CE, (0x129D, 0x1)),
    (0x1D60B, (0x12DA, 0x1)),
    (0x1D5BA, (0x1289, 0x1)),
    (0x02F10, (0x369, 0x1)),
    (0x1D726, (0x13F3, 0x1)),
    (0x0FFEB, (0x1087, 0x1)),
    (0x02491, (0x2A4, 0x3)),
    (0x0FE16, (0xEB3, 0x1)),
    (0x1D754, (0x1421, 0x1)),
    (0x032AD, (0x60E, 0x1)),
    (0x02116, (0x18A, 0x2)),
    (0x1D6CE, (0x139B, 0x1)),
    (0x1D71D, (0x13EA, 0x1)),
    (0x0FEA8, (0xF46, 0x1)),
    (0x1D434, (0x111B, 0x1)),
    (0x1D483, (0x1169, 0x1)),
    (0x1D443, (0x112A, 0x1)),
    (0x0FF1C, (0xFC4, 0x1)),
    (0x0210A, (0x17F, 0x1)),
    (0x1D6C1, (0x138E, 0x1)),
    (0x1E040, (0x14DB, 0x1)),
    (0x02F41, (0x39A, 0x1)),
    (0x01DBD, (0x0E7, 0x1)),
    (0x0FC2B, (0xACC, 0x2)),
    (0x032CA, (0x645, 0x3)),
    (0x03321, (0x711, 0x5)),
    (0x03364, (0x7FC, 0x3)),
    (0x1F130, (0x1603, 0x1)),
    (0x02FBE, (0x417, 0x1)),
    (0x0FE68, (0xEF2, 0x1)),
    (0x0FCC4, (0xC0F, 0x2)),
    (0x1D719, (0x13E6, 0x1)),
    (0x1D5C8, (0x1297, 0x1)),
    (0x1D4DC, (0x11B7, 0x1)),
    (0x1D537, (0x120D, 0x1)),
    (0x0FD3A, (0xD00, 0x2)),
    (0x01D64, (0x0BD, 0x1)),
    (0x0315E, (0x469, 0x1)),
    (0x1EE19, (0x1521, 0x1)),
    (0x0FF01, (0xFA9, 0x1)),
    (0x1EE3B, (0x153B, 0x1)),
    (0x1D4FE, (0x11D9, 0x1)),
    (0x01FBF, (0x0F0, 0x2)),
    (0x0216E, (0x1FF, 0x1)),
    (0x1D5B3, (0x1282, 0x1)),
    (0x01D44, (0x09E, 0x1)),
    (0x032CD, (0x64D, 0x3)),
    (0x01D42, (0x09C, 0x1)),
    (0x1D56E, (0x123D, 0x1)),
    (0x033DF, (0x92C, 0x3)),
    (0x0FFB5, (0x105D, 0x1)),
    (0x1E042, (0x14DD, 0x1)),
    (0x02F81, (0x3DA, 0x1)),
    (0x0FB6B, (0x9D4, 0x1)),
    (0x0FCBF, (0xC05, 0x2)),
    (0x0FD58, (0xD20, 0x3)),
    (0x1D64E, (0x131D, 0x1)),
    (0x0FEFC, (0xFA7, 0x2)),
    (0x03246, (0x589, 0x1)),
    (0x03162, (0x46D, 0x1)),
    (0x02F65, (0x3BE, 0x1)),
    (0x0FD96, (0xDD4, 0x3)),
    (0x1D5E7, (0x12B6, 0x1)),
    (0x03273, (0x5C4, 0x2)),
    (0x0FCCE, (0xC23, 0x2)),
    (0x003D5, (0x066, 0x1)),
    (0x0326B, (0x5B7, 0x1)),
    (0x032D0, (0x655, 0x1)),
    (0x0FFE9, (0x1085, 0x1)),
    (0x1D5D5, (0x12A4, 0x1)),
    (0x1F21F, (0x1647, 0x1)),
    (0x0FB8B, (0x9F4, 0x1)),
    (0x0FEE0, (0xF7E, 0x1)),
    (0x02F99, (0x3F2, 0x1)),
    (0x02FA3, (0x3FC, 0x1)),
    (0x0FBF5, (0xA58, 0x3)),
    (0x1D43C, (0x1123, 0x1)),
    (0x1D7B6, (0x1483, 0x1)),
    (0x0FBE0, (0xA2D, 0x1)),
    (0x1D40D, (0x10F4, 0x1)),
    (0x1F144, (0x1617, 0x1)),
    (0x03165, (0x470, 0x1)),
    (0x0323D, (0x572, 0x3)),
    (0x1D46C, (0x1152, 0x1)),
    (0x1D4AE, (0x118C, 0x1)),
    (0x02085, (0x154, 0x1)),
    (0x02F86, (0x3DF, 0x1)),
    (0x1EE95, (0x1576, 0x1)),
    (0x0FDA8, (0xE0A, 0x3)),
    (0x03228, (0x533, 0x3)),
    (0x03213, (0x4E6, 0x4)),
    (0x02485, (0x286, 0x4)),
    (0x1D70A, (0x13D7, 0x1)),
    (0x02F57, (0x3B0, 0x1)),
    (0x1F14E, (0x1625, 0x3)),
    (0x0FB96, (0x9FF, 0x1)),
    (0x0FCE5, (0xC53, 0x2)),
    (0x0317A, (0x485, 0x1)),
    (0x03294, (0x5F5, 0x1)),
    (0x1D786, (0x1453, 0x1)),
    (0x024E4, (0x341, 0x1)),
    (0x02495, (0x2B0, 0x3)),
    (0x1F124, (0x15E8, 0x3)),
    (0x03272, (0x5C2, 0x2)),
    (0x02F9A, (0x3F3, 0x1)),
    (0x0FD61, (0xD3B, 0x3)),
    (0x0FCB0, (0xBE7, 0x2)),
    (0x0FD02, (0xC90, 0x2)),
    (0x1EEAB, (0x1585, 0x1)),
    (0x1079F, (0x10A8, 0x1)),
    (0x1D5AE, (0x127D, 0x1)),
    (0x1D7B1, (0x147E, 0x1)),
    (0x024C3, (0x320, 0x1)),
    (0x0FC8E, (0xB9E, 0x2)),
    (0x1D5E0, (0x12AF, 0x1)),
    (0x0FFA9, (0x1051, 0x1)),
    (0x01D33, (0x08E, 0x1)),
    (0x1D505, (0x11E0, 0x1)),
    (0x1D767, (0x1434, 0x1)),
    (0x1D53D, (0x1212, 0x1)),
    (0x1078F, (0x1098, 0x1)),
    (0x0FC3F, (0xAF4, 0x2)),
    (0x1D6A9, (0x1376, 0x1)),
    (0x1D47A, (0x1160, 0x1)),
    (0x0FC72, (0xB66, 0x2)),
    (0x03151, (0x45C, 0x1)),
    (0x03335, (0x75F, 0x3)),
    (0x1D579, (0x1248, 0x1)),
    (0x02F72, (0x3CB, 0x1)),
    (0x0222F, (0x227, 0x2)),
    (0x000BA, (0x00E, 0x1)),
    (0x1D6BB, (0x1388, 0x1)),
    (0x0FF03, (0xFAB, 0x1)),
    (0x033B6, (0x8CE, 0x2)),
    (0x1D419, (0x1100, 0x1)),
    (0x1D763, (0x1430, 0x1)),
    (0x02171, (0x202, 0x2)),
    (0x02017, (0x11F, 0x2)),
    (0x032B5, (0x61A, 0x2)),
    (0x00132, (0x018, 0x2)),
    (0x1EE8D, (0x156E, 0x1)),
    (0x0319B, (0x4A3, 0x1)),
    (0x1D5ED, (0x12BC, 0x1)),
    (0x0FF58, (0x1000, 0x1)),
    (0x0313C, (0x447, 0x1)),
    (0x0FB7D, (0x9E6, 0x1)),
    (0x03394, (0x875, 0x3)),
    (0x02124, (0x198, 0x1)),
    (0x02F50, (0x3A9, 0x1)),
    (0x1D522, (0x11F8, 0x1)),
    (0x0FF66, (0x100E, 0x1)),
    (0x0FDFA, (0xE8F, 0x12)),
    (0x0FC71, (0xB64, 0x2)),
    (0x1D772, (0x143F, 0x1)),
    (0x1D65A, (0x1329, 0x1)),
    (0x1D7C6, (0x1493, 0x1)),
    (0x0FEB8, (0xF56, 0x1)),
    (0x0FEEE, (0xF8C, 0x1)),
    (0x1EE61, (0x154B, 0x1)),
    (0x0FB68, (0x9D1, 0x1)),
    (0x1F103, (0x159C, 0x2)),
    (0x1D585, (0x1254, 0x1)),
    (0x03352, (0x7CC, 0x2)),
    (0x0FDF2, (0xE70, 0x4)),
    (0x0331A, (0x6F4, 0x6)),
    (0x1D52C, (0x1202, 0x1)),
    (0x0013F, (0x01C, 0x2)),
    (0x02FAF, (0x408, 0x1)),
    (0x032C1, (0x632, 0x2)),
    (0x03320, (0x70C, 0x5)),
    (0x1D5FD, (0x12CC, 0x1)),
    (0x0FEB7, (0xF55, 0x1)),
    (0x0FFE6, (0x1083, 0x1)),
    (0x0FCE9, (0xC5B, 0x2)),
    (0x0FD7A, (0xD86, 0x3)),
    (0x0FF87, (0x102F, 0x1)),
    (0x1EE1A, (0x1522, 0x1)),
    (0x1F248, (0x167C, 0x3)),
    (0x1D7C2, (0x148F, 0x1)),
    (0x1D694, (0x1363, 0x1)),
    (0x033B5, (0x8CC, 0x2)),
    (0x03245, (0x588, 0x1)),
    (0x1EE27, (0x152B, 0x1)),
    (0x0FDBE, (0xE4C, 0x3)),
    (0x1EE91, (0x1572, 0x1)),
    (0x03329, (0x72A, 0x3)),
    (0x1D4CF, (0x11AA, 0x1)),
    (0x0FED3, (0xF71, 0x1)),
    (0x02134, (0x1A0, 0x1)),
    (0x03287, (0x5E8, 0x1)),
    (0x024AE, (0x2FB, 0x3)),
    (0x0FEB9, (0xF57, 0x1)),
    (0x032AB, (0x60C, 0x1)),
    (0x1D596, (0x1265, 0x1)),
    (0x1D4F8, (0x11D3, 0x1)),
    (0x0FEC9, (0xF67, 0x1)),
    (0x1F22C, (0x1654, 0x1)),
    (0x1F13A, (0x160D, 0x1)),
    (0x032EF, (0x674, 0x1)),
    (0x1D77F, (0x144C, 0x1)),
    (0x02F82, (0x3DB, 0x1)),
    (0x1D6E1, (0x13AE, 0x1)),
    (0x03314, (0x6D7, 0x2)),
    (0x0FEA4, (0xF42, 0x1)),
    (0x1F115, (0x15BB, 0x3)),
    (0x0222D, (0x224, 0x3)),
    (0x1D4C9, (0x11A4, 0x1)),
    (0x1D567, (0x1236, 0x1)),
    (0x1D7EE, (0x14B9, 0x1)),
    (0x032F1, (0x676, 0x1)),
    (0x0FF8C, (0x1034, 0x1)),
    (0x1D5A6, (0x1275, 0x1)),
    (0x0FE61, (0xEEC, 0x1)),
    (0x033EF, (0x953, 0x3)),
    (0x02140, (0x1AD, 0x1)),
    (0x1D659, (0x1328, 0x1)),
    (0x1D542, (0x1216, 0x1)),
    (0x03137, (0x442, 0x1)),
    (0x02F2D, (0x386, 0x1)),
    (0x1D4EE, (0x11C9, 0x1)),
    (0x0FFE0, (0x107C, 0x1)),
    (0x1D4E0, (0x11BB, 0x1)),
    (0x01D34, (0x08F, 0x1)),
    (0x1D6ED, (0x13BA, 0x1)),
    (0x01DAD, (0x0D7, 0x1)),
    (0x1D766, (0x1433, 0x1)),
    (0x03380, (0x847, 0x2)),
    (0x02170, (0x201, 0x1)),
    (0x0FE35, (0xEBF, 0x1)),
    (0x033A8, (0x8A5, 0x4)),
    (0x1D650, (0x131F, 0x1)),
    (0x01DB2, (0x0DC, 0x1)),
    (0x1D4DD, (0x11B8, 0x1)),
    (0x1F222, (0x164A, 0x1)),
    (0x00587, (0x06E, 0x2)),
    (0x02080, (0x14F, 0x1)),
    (0x0FC8A, (0xB96, 0x2)),
    (0x1D71C, (0x13E9, 0x1)),
    (0x1D52A, (0x1200, 0x1)),
    (0x1D557, (0x1226, 0x1)),
    (0x0A69C, (0x986, 0x1)),
    (0x0FD66, (0xD4A, 0x3)),
    (0x02A74, (0x34C, 0x3)),
    (0x1D764, (0x1431, 0x1)),
    (0x1D45D, (0x1143, 0x1)),
    (0x0FCBE, (0xC03, 0x2)),
    (0x1D7F0, (0x14BB, 0x1)),
    (0x0FBEA, (0xA37, 0x3)),
    (0x02036, (0x12D, 0x2)),
    (0x01FBD, (0x0EE, 0x2)),
    (0x1D527, (0x11FD, 0x1)),
    (0x1D5FB, (0x12CA, 0x1)),
    (0x0FD57, (0xD1D, 0x3)),
    (0x0318B, (0x496, 0x1)),
    (0x0FDF5, (0xE7C, 0x4)),
    (0x1078C, (0x1095, 0x1)),
    (0x1CCF9, (0x10E6, 0x1)),
    (0x1EEB6, (0x1590, 0x1)),
    (0x1D6E3, (0x13B0, 0x1)),
    (0x03166, (0x471, 0x1)),
    (0x0338A, (0x85E, 0x2)),
    (0x1D5EE, (0x12BD, 0x1)),
    (0x03241, (0x57E, 0x3)),
    (0x03365, (0x7FF, 0x3)),
    (0x0FD39, (0xCFE, 0x2)),
    (0x1EE17, (0x151F, 0x1)),
    (0x1D432, (0x1119, 0x1)),
    (0x1D56A, (0x1239, 0x1)),
    (0x1D606, (0x12D5, 0x1)),
    (0x0FEDD, (0xF7B, 0x1)),
    (0x0FE64, (0xEEF, 0x1)),
    (0x1D496, (0x117C, 0x1)),
    (0x1CCEB, (0x10D8, 0x1)),
    (0x1D7FA, (0x14C5, 0x1)),
    (0x1D4BB, (0x1198, 0x1)),
    (0x1D75C, (0x1429, 0x1)),
    (0x001C9, (0x030, 0x2)),
    (0x1FBF3, (0x1684, 0x1)),
    (0x01D45, (0x09F, 0x1)),
    (0x1D708, (0x13D5, 0x1)),
    (0x1D781, (0x144E, 0x1)),
    (0x01FDE, (0x103, 0x3)),
    (0x1D64F, (0x131E, 0x1)),
    (0x02FBD, (0x416, 0x1)),
    (0x1D500, (0x11DB, 0x1)),
    (0x033D7, (0x918, 0x2)),
    (0x033A3, (0x897, 0x3)),
    (0x1D502, (0x11DD, 0x1)),
    (0x1D444, (0x112B, 0x1)),
    (0x1D7C0, (0x148D, 0x1)),
    (0x1D489, (0x116F, 0x1)),
    (0x0FC4A, (0xB0A, 0x2)),
    (0x0FCC3, (0xC0D, 0x2)),
    (0x033A5, (0x89D, 0x2)),
    (0x1D6C6, (0x1393, 0x1)),
    (0x03258, (0x59C, 0x2)),
    (0x02149, (0x1B2, 0x1)),
    (0x107BA, (0x10C2, 0x1)),
    (0x0FED6, (0xF74, 0x1)),
    (0x1EE05, (0x150D, 0x1)),
    (0x02EF3, (0x358, 0x1)),
    (0x0FF94, (0x103C, 0x1)),
    (0x0FC65, (0xB47, 0x3)),
    (0x1E04E, (0x14E9, 0x1)),
    (0x0FB91, (0x9FA, 0x1)),
    (0x0FD12, (0xCB0, 0x2)),
    (0x1D6C8, (0x1395, 0x1)),
    (0x0FE4B, (0xED5, 0x2)),
    (0x0249F, (0x2CE, 0x3)),
    (0x01DA3, (0x0CD, 0x1)),
    (0x032C2, (0x634, 0x2)),
    (0x01D51, (0x0AA, 0x1)),
    (0x1D7FF, (0x14CA, 0x1)),
    (0x02076, (0x145, 0x1)),
    (0x02F3C, (0x395, 0x1)),
    (0x0FF63, (0x100B, 0x1)),
    (0x01D3C, (0x096, 0x1)),
    (0x1E03E, (0x14D9, 0x1)),
    (0x1FBF5, (0x1686, 0x1)),
    (0x001CC, (0x036, 0x2)),
    (0x03286, (0x5E7, 0x1)),
    (0x1D4EB, (0x11C6, 0x1)),
    (0x1F230, (0x1658, 0x1)),
    (0x0FCAA, (0xBDB, 0x2)),
    (0x02FC5, (0x41E, 0x1)),
    (0x03227, (0x530, 0x3)),
    (0x0FB00, (0x993, 0x2)),
    (0x1F13E, (0x1611, 0x1)),
    (0x0FE77, (0xF00, 0x2)),
    (0x1D7B5, (0x1482, 0x1)),
    (0x0FFBB, (0x1063, 0x1)),
    (0x03353, (0x7CE, 0x4)),
    (0x01D9B, (0x0C5, 0x1)),
    (0x1D72B, (0x13F8, 0x1)),
    (0x1F21B, (0x1643, 0x1)),
    (0x0338B, (0x860, 0x2)),
    (0x02F61, (0x3BA, 0x1)),
    (0x02C7C, (0x354, 0x1)),
    (0x0FC00, (0xA71, 0x3)),
    (0x0FF96, (0x103E, 0x1)),
    (0x003F0, (0x068, 0x1)),
    (0x1EE0D, (0x1515, 0x1)),
    (0x0FF6D, (0x1015, 0x1)),
    (0x0FD54, (0xD14, 0x3)),
    (0x0FE33, (0xEBD, 0x1)),
    (0x02F09, (0x362, 0x1)),
    (0x1D5A1, (0x1270, 0x1)),
    (0x03233, (0x554, 0x3)),
    (0x02F21, (0x37A, 0x1)),
    (0x1D4F4, (0x11CF, 0x1)),
    (0x02FAA, (0x403, 0x1)),
    (0x02F55, (0x3AE, 0x1)),
    (0x1D49A, (0x1180, 0x1)),
    (0x1F234, (0x165C, 0x1)),
    (0x1E060, (0x14FB, 0x1)),
    (0x1D6E0, (0x13AD, 0x1)),
    (0x1D433, (0x111A, 0x1)),
    (0x1D77B, (0x1448, 0x1)),
    (0x0FD22, (0xCD0, 0x2)),
    (0x03141, (0x44C, 0x1)),
    (0x0FE9C, (0xF3A, 0x1)),
    (0x1D46D, (0x1153, 0x1)),
    (0x0329D, (0x5FE, 0x1)),
    (0x032EC, (0x671, 0x1)),
    (0x0FFBC, (0x1064, 0x1)),
    (0x0FC5F, (0xB35, 0x3)),
    (0x1EE7B, (0x155F, 0x1)),
    (0x03236, (0x55D, 0x3)),
    (0x1D67B, (0x134A, 0x1)),
    (0x033E1, (0x931, 0x2)),
    (0x1EE18, (0x1520, 0x1)),
    (0x024E3, (0x340, 0x1)),
    (0x1F22E, (0x1656, 0x1)),
    (0x1D657, (0x1326, 0x1)),
    (0x1D4B7, (0x1195, 0x1)),
    (0x030FF, (0x43A, 0x2)),
    (0x0FB64, (0x9CD, 0x1)),
    (0x0FCFF, (0xC8A, 0x2)),
    (0x000B9, (0x00D, 0x1)),
    (0x03139, (0x444, 0x1)),
    (0x01D3E, (0x098, 0x1)),
    (0x003D6, (0x067, 0x1)),
    (0x02088, (0x157, 0x1)),
    (0x0FE54, (0xEDF, 0x1)),
    (0x03263, (0x5AF, 0x1)),
    (0x0FFC4, (0x1069, 0x1)),
    (0x1D7CB, (0x1498, 0x1)),
    (0x1D584, (0x1253, 0x1)),
    (0x02100, (0x16D, 0x3)),
    (0x03332, (0x74F, 0x6)),
    (0x0FBF2, (0xA4F, 0x3)),
    (0x0317B, (0x486, 0x1)),
    (0x0FBF1, (0xA4C, 0x3)),
    (0x001C6, (0x029, 0x3)),
    (0x0FC83, (0xB88, 0x2)),
    (0x024A7, (0x2E6, 0x3)),
    (0x1D6C9, (0x1396, 0x1)),
    (0x01D53, (0x0AC, 0x1)),
    (0x032BA, (0x624, 0x2)),
    (0x1F13C, (0x160F, 0x1)),
    (0x02178, (0x213, 0x2)),
    (0x1F237, (0x165F, 0x1)),
    (0x1D751, (0x141E, 0x1)),
    (0x1D479, (0x115F, 0x1)),
    (0x0215D, (0x1DB, 0x3)),
    (0x02F17, (0x370, 0x1)),
    (0x0FF48, (0xFF0, 0x1)),
    (0x0FC38, (0xAE6, 0x2)),
    (0x1D465, (0x114B, 0x1)),
    (0x02FCD, (0x426, 0x1)),
    (0x01D59, (0x0B2, 0x1)),
    (0x1D65F, (0x132E, 0x1)),
    (0x03393, (0x872, 0x3)),
    (0x024E9, (0x346, 0x1)),
    (0x024DB, (0x338, 0x1)),
    (0x0FD0B, (0xCA2, 0x2)),
    (0x0208A, (0x159, 0x1)),
    (0x0FE5A, (0xEE5, 0x1)),
    (0x01D4B, (0x0A5, 0x1)),
    (0x0FD0D, (0xCA6, 0x2)),
    (0x01D2E, (0x08A, 0x1)),
    (0x03288, (0x5E9, 0x1)),
    (0x1D699, (0x1368, 0x1)),
    (0x0FE92, (0xF30, 0x1)),
    (0x1F11A, (0x15CA, 0x3)),
    (0x1D589, (0x1258, 0x1)),
    (0x1E04B, (0x14E6, 0x1)),
    (0x02F3D, (0x396, 0x1)),
    (0x1D45A, (0x1140, 0x1)),
    (0x0FF4C, (0xFF4, 0x1)),
    (0x1D789, (0x1456, 0x1)),
    (0x0A7F2, (0x989, 0x1)),
    (0x02497, (0x2B6, 0x3)),
    (0x0FF7C, (0x1024, 0x1)),
    (0x033D6, (0x915, 0x3)),
    (0x0FFA6, (0x104E, 0x1)),
    (0x1E033, (0x14CE, 0x1)),
    (0x1D581, (0x1250, 0x1)),
    (0x0FF2D, (0xFD5, 0x1)),
    (0x1D46F, (0x1155, 0x1)),
    (0x1D5F5, (0x12C4, 0x1)),
    (0x1EE7E, (0x1561, 0x1)),
    (0x1D497, (0x117D, 0x1)),
    (0x1D594, (0x1263, 0x1)),
    (0x1D499, (0x117F, 0x1)),
    (0x1D57C, (0x124B, 0x1)),
    (0x01D32, (0x08D, 0x1)),
    (0x1D5CB, (0x129A, 0x1)),
    (0x1D783, (0x1450, 0x1)),
    (0x1D4E8, (0x11C3, 0x1)),
    (0x1D58E, (0x125D, 0x1)),
    (0x0FF0D, (0xFB5, 0x1)),
    (0x0FB88, (0x9F1, 0x1)),
    (0x1D474, (0x115A, 0x1)),
    (0x02F52, (0x3AB, 0x1)),
    (0x1D68E, (0x135D, 0x1)),
    (0x03297, (0x5F8, 0x1)),
    (0x1EE83, (0x1565, 0x1)),
    (0x02FCB, (0x424, 0x1)),
    (0x0FF32, (0xFDA, 0x1)),
    (0x0FFAB, (0x1053, 0x1)),
    (0x1CCEF, (0x10DC, 0x1)),
    (0x0FC95, (0xBAC, 0x2)),
    (0x02A76, (0x351, 0x3)),
    (0x0FE74, (0xEFC, 0x2)),
    (0x1D63A, (0x1309, 0x1)),
    (0x1D4CB, (0x11A6, 0x1)),
    (0x033BF, (0x8E0, 0x2)),
    (0x1D664, (0x1333, 0x1)),
    (0x1F224, (0x164C, 0x1)),
    (0x00676, (0x072, 0x2)),
    (0x03277, (0x5CC, 0x2)),
    (0x1D6AC, (0x1379, 0x1)),
    (0x033E9, (0x941, 0x3)),
    (0x0FEBE, (0xF5C, 0x1)),
    (0x0FEE8, (0xF86, 0x1)),
    (0x0FF3C, (0xFE4, 0x1)),
    (0x1D7BE, (0x148B, 0x1)),
    (0x0FDA0, (0xDF2, 0x3)),
    (0x0314B, (0x456, 0x1)),
    (0x02F79, (0x3D2, 0x1)),
    (0x0FC66, (0xB4A, 0x3)),
    (0x0FD1F, (0xCCA, 0x2)),
    (0x0FB81, (0x9EA, 0x1)),
    (0x0FCC9, (0xC19, 0x2)),
    (0x1D5B5, (0x1284, 0x1)),
    (0x0FEF4, (0xF92, 0x1)),
    (0x0339F, (0x88C, 0x3)),
    (0x1D6FD, (0x13CA, 0x1)),
    (0x02107, (0x17C, 0x1)),
    (0x0FE9E, (0xF3C, 0x1)),
    (0x1D745, (0x1412, 0x1)),
    (0x0249D, (0x2C8, 0x3)),
    (0x02F8F, (0x3E8, 0x1)),
    (0x1EE31, (0x1534, 0x1)),
    (0x1D5B0, (0x127F, 0x1)),
    (0x1D5F3, (0x12C2, 0x1)),
    (0x01D5F, (0x0B8, 0x1)),
    (0x1D7BB, (0x1488, 0x1)),
    (0x0FF33, (0xFDB, 0x1)),
    (0x1EE5B, (0x1548, 0x1)),
    (0x1D747, (0x1414, 0x1)),
    (0x0337D, (0x83F, 0x2)),
    (0x0FCF8, (0xC7C, 0x2)),
    (0x1D796, (0x1463, 0x1)),
    (0x03194, (0x49C, 0x1)),
    (0x03196, (0x49E, 0x1)),
    (0x03292, (0x5F3, 0x1)),
    (0x0FD3D, (0xD06, 0x2)),
    (0x1D535, (0x120B, 0x1)),
    (0x03149, (0x454, 0x1)),
    (0x1D62D, (0x12FC, 0x1)),
    (0x0FF55, (0xFFD, 0x1)),
    (0x0FDB6, (0xE34, 0x3)),
    (0x1D604, (0x12D3, 0x1)),
    (0x02095, (0x163, 0x1)),
    (0x03219, (0x4FE, 0x4)),
    (0x032C8, (0x640, 0x2)),
    (0x1CCDA, (0x10C7, 0x1)),
    (0x0210E, (0x183, 0x1)),
    (0x0FC2C, (0xACE, 0x2)),
    (0x1F108, (0x15A6, 0x2)),
    (0x1D687, (0x1356, 0x1)),
    (0x1D702, (0x13CF, 0x1)),
    (0x1D615, (0x12E4, 0x1)),
    (0x02F0C, (0x365, 0x1)),
    (0x03185, (0x490, 0x1)),
    (0x1D42A, (0x1111, 0x1)),
    (0x03254, (0x594, 0x2)),
    (0x0FFB9, (0x1061, 0x1)),
    (0x1D428, (0x110F, 0x1)),
    (0x1D72E, (0x13FB, 0x1)),
    (0x0209A, (0x168, 0x1)),
    (0x1D689, (0x1358, 0x1)),
    (0x033E2, (0x933, 0x2)),
    (0x0FC75, (0xB6C, 0x2)),
    (0x0FBF6, (0xA5B, 0x3)),
    (0x0FBDA, (0xA26, 0x1)),
    (0x1D44A, (0x1131, 0x1)),
    (0x0FF5C, (0x1004, 0x1)),
    (0x0FEE3, (0xF81, 0x1)),
    (0x02162, (0x1E6, 0x3)),
    (0x03181, (0x48C, 0x1)),
    (0x0321E, (0x515, 0x6)),
    (0x032BE, (0x62C, 0x2)),
    (0x1F201, (0x1634, 0x2)),
    (0x0FDF7, (0xE84, 0x4)),
    (0x107A5, (0x10AE, 0x1)),
    (0x0FC1F, (0xAB4, 0x2)),
    (0x0FC84, (0xB8A, 0x2)),
    (0x033C2, (0x8E6, 0x4)),
    (0x0FDF6, (0xE80, 0x4)),
    (0x02FA0, (0x3F9, 0x1)),
    (0x1F109, (0x15A8, 0x2)),
    (0x024B4, (0x30D, 0x3)),
    (0x1D5B7, (0x1286, 0x1)),
    (0x0248F, (0x2A0, 0x2)),
    (0x0247A, (0x25D, 0x3)),
    (0x0AB5E, (0x990, 0x1)),
    (0x032DA, (0x65F, 0x1)),
    (0x0FD50, (0xD08, 0x3)),
    (0x0336B, (0x811, 0x3)),
    (0x024D9, (0x336, 0x1)),
    (0x0FD16, (0xCB8, 0x2)),
    (0x03251, (0x58E, 0x2)),
    (0x02F90, (0x3E9, 0x1)),
    (0x0FE8F, (0xF2D, 0x1)),
    (0x03398, (0x87E, 0x2)),
    (0x02F1C, (0x375, 0x1)),
    (0x0FCE1, (0xC4B, 0x2)),
    (0x0249C, (0x2C5, 0x3)),
    (0x1D7C9, (0x1496, 0x1)),
    (0x0FD62, (0xD3E, 0x3)),
    (0x0FD1B, (0xCC2, 0x2)),
    (0x03373, (0x828, 0x2)),
    (0x1E054, (0x14EF, 0x1)),
    (0x0FD06, (0xC98, 0x2)),
    (0x02FCA, (0x423, 0x1)),
    (0x1D526, (0x11FC, 0x1)),
    (0x02461, (0x22D, 0x1)),
    (0x03136, (0x441, 0x1)),
    (0x0FC7D, (0xB7C, 0x2)),
    (0x0FB87, (0x9F0, 0x1)),
    (0x0FEAC, (0xF4A, 0x1)),
    (0x0317E, (0x489, 0x1)),
    (0x032E7, (0x66C, 0x1)),
    (0x1D76B, (0x1438, 0x1)),
    (0x0FB9C, (0xA05, 0x1)),
    (0x1D44B, (0x1132, 0x1)),
    (0x1EE06, (0x150E, 0x1)),
    (0x03216, (0x4F2, 0x4)),
    (0x033BD, (0x8DC, 0x2)),
    (0x1F148, (0x161B, 0x1)),
    (0x1F216, (0x163E, 0x1)),
    (0x1D4AC, (0x118B, 0x1)),
    (0x0FB13, (0x9A3, 0x2)),
    (0x1D5CC, (0x129B, 0x1)),
    (0x1F214, (0x163C, 0x1)),
    (0x0FC20, (0xAB6, 0x2)),
    (0x02F04, (0x35D, 0x1)),
    (0x1D78D, (0x145A, 0x1)),
    (0x0FCA9, (0xBD9, 0x2)),
    (0x0FE62, (0xEED, 0x1)),
    (0x0FC7A, (0xB76, 0x2)),
    (0x1D4F6, (0x11D1, 0x1)),
    (0x1E034, (0x14CF, 0x1)),
    (0x0FC1E, (0xAB2, 0x2)),
    (0x01D5C, (0x0B5, 0x1)),
    (0x01D4C, (0x0A6, 0x1)),
    (0x0246A, (0x237, 0x2)),
    (0x0FBD6, (0xA22, 0x1)),
    (0x02F7B, (0x3D4, 0x1)),
    (0x033CB, (0x8FD, 0x2)),
    (0x0FD08, (0xC9C, 0x2)),
    (0x1F190, (0x1630, 0x2)),
    (0x1CCE4, (0x10D1, 0x1)),
    (0x0FD78, (0xD80, 0x3)),
    (0x0336D, (0x817, 0x3)),
    (0x0A7F4, (0x98B, 0x1)),
    (0x0FCF3, (0xC70, 0x3)),
    (0x0217D, (0x21C, 0x1)),
    (0x1D5A0, (0x126F, 0x1)),
    (0x0FD5F, (0xD35, 0x3)),
    (0x000B4, (0x008, 0x2)),
    (0x0322E, (0x545, 0x3)),
    (0x1EEBA, (0x1594, 0x1)),
    (0x1F229, (0x1651, 0x1)),
    (0x1D5DD, (0x12AC, 0x1)),
    (0x1E067, (0x1502, 0x1)),
    (0x0FC5A, (0xB2A, 0x2)),
    (0x0FD95, (0xDD1, 0x3)),
    (0x1F118, (0x15C4, 0x3)),
    (0x1EE08, (0x1510, 0x1)),
    (0x02FC8, (0x421, 0x1)),
    (0x0FCC6, (0xC13, 0x2)),
    (0x1D6B1, (0x137E, 0x1)),
    (0x1D4CD, (0x11A8, 0x1)),
    (0x1D472, (0x1158, 0x1)),
    (0x1D74C, (0x1419, 0x1)),
    (0x1D54C, (0x121C, 0x1)),
    (0x1E031, (0x14CC, 0x1)),
    (0x02490, (0x2A2, 0x2)),
    (0x0FC09, (0xA88, 0x2)),
    (0x1FBF4, (0x1685, 0x1)),
    (0x02460, (0x22C, 0x1)),
    (0x0FF07, (0xFAF, 0x1)),
    (0x0FBF9, (0xA64, 0x3)),
    (0x02154, (0x1C0, 0x3)),
    (0x1D679, (0x1348, 0x1)),
    (0x03223, (0x524, 0x3)),
    (0x1D712, (0x13DF, 0x1)),
    (0x0FE99, (0xF37, 0x1)),
    (0x1D6D8, (0x13A5, 0x1)),
    (0x1D677, (0x1346, 0x1)),
    (0x1CCE7, (0x10D4, 0x1)),
    (0x1D470, (0x1156, 0x1)),
    (0x0FC69, (0xB53, 0x3)),
    (0x02FC6, (0x41F, 0x1)),
    (0x1D541, (0x1215, 0x1)),
    (0x1D7E1, (0x14AC, 0x1)),
    (0x0FF75, (0x101D, 0x1)),
    (0x032D4, (0x659, 0x1)),
    (0x01DAE, (0x0D8, 0x1)),
    (0x0FFDC, (0x107B, 0x1)),
    (0x033D4, (0x910, 0x2)),
    (0x0FC94, (0xBAA, 0x2)),
    (0x0FB28, (0x9B5, 0x1)),
    (0x0FD67, (0xD4D, 0x3)),
    (0x1CCE2, (0x10CF, 0x1)),
    (0x0211A, (0x18D, 0x1)),
    (0x0FE38, (0xEC2, 0x1)),
    (0x01D39, (0x094, 0x1)),
    (0x1D7F3, (0x14BE, 0x1)),
    (0x1F11F, (0x15D9, 0x3)),
    (0x0FF91, (0x1039, 0x1)),
    (0x032E2, (0x667, 0x1)),
    (0x0212D, (0x19B, 0x1)),
    (0x1D467, (0x114D, 0x1)),
    (0x02FA2, (0x3FB, 0x1)),
    (0x0FC36, (0xAE2, 0x2)),
    (0x1D730, (0x13FD, 0x1)),
    (0x02F25, (0x37E, 0x1)),
    (0x1D7D3, (0x149E, 0x1)),
    (0x0FC27, (0xAC4, 0x2)),
    (0x02079, (0x148, 0x1)),
    (0x1D5A7, (0x1276, 0x1)),
    (0x1D478, (0x115E, 0x1)),
    (0x1F242, (0x166A, 0x3)),
    (0x1EE71, (0x1557, 0x1)),
    (0x1D59B, (0x126A, 0x1)),
    (0x1078B, (0x1094, 0x1)),
    (0x1D6F2, (0x13BF, 0x1)),
    (0x0FDBC, (0xE46, 0x3)),
    (0x0FB73, (0x9DC, 0x1)),
    (0x02F69, (0x3C2, 0x1)),
    (0x0200A, (0x11D, 0x1)),
    (0x1EE69, (0x1550, 0x1)),
    (0x1D57B, (0x124A, 0x1)),
    (0x0FCEA, (0xC5D, 0x2)),
    (0x0323F, (0x578, 0x3)),
    (0x1D45C, (0x1142, 0x1)),
    (0x0FFA0, (0x1048, 0x1)),
    (0x1D429, (0x1110, 0x1)),
    (0x1D5CA, (0x1299, 0x1)),
    (0x1079C, (0x10A5, 0x1)),
    (0x02F29, (0x382, 0x1)),
    (0x0FD8D, (0xDBF, 0x3)),
    (0x0FE50, (0xEDC, 0x1)),
    (0x1D793, (0x1460, 0x1)),
    (0x0209C, (0x16A, 0x1)),
    (0x03340, (0x789, 0x5)),
    (0x1EE7A, (0x155E, 0x1)),
    (0x0326E, (0x5BA, 0x2)),
    (0x1D69C, (0x136B, 0x1)),
    (0x0317C, (0x487, 0x1)),
    (0x1D424, (0x110B, 0x1)),
    (0x0FCBB, (0xBFD, 0x2)),
    (0x0FB7E, (0x9E7, 0x1)),
    (0x1D678, (0x1347, 0x1)),
    (0x024C6, (0x323, 0x1)),
    (0x1E06B, (0x1506, 0x1)),
    (0x1F110, (0x15AC, 0x3)),
    (0x01D43, (0x09D, 0x1)),
    (0x02498, (0x2B9, 0x3)),
    (0x1D6AB, (0x1378, 0x1)),
    (0x0FD7E, (0xD92, 0x3)),
    (0x0FD9A, (0xDE0, 0x3)),
    (0x1D449, (0x1130, 0x1)),
    (0x1D5D9, (0x12A8, 0x1)),
    (0x10784, (0x108E, 0x1)),
    (0x01D5A, (0x0B3, 0x1)),
    (0x0FC05, (0xA80, 0x2)),
    (0x024BC, (0x319, 0x1)),
    (0x033FB, (0x977, 0x3)),
    (0x02F42, (0x39B, 0x1)),
    (0x0338F, (0x868, 0x2)),
    (0x0FC70, (0xB62, 0x2)),
    (0x02091, (0x15F, 0x1)),
    (0x03183, (0x48E, 0x1)),
    (0x0336E, (0x81A, 0x3)),
    (0x02093, (0x161, 0x1)),
    (0x1D78C, (0x1459, 0x1)),
    (0x1D5C6, (0x1295, 0x1)),
    (0x0FDB5, (0xE31, 0x3)),
    (0x1D5F9, (0x12C8, 0x1)),
    (0x1D4BF, (0x119B, 0x1)),
    (0x02F9F, (0x3F8, 0x1)),
    (0x0319A, (0x4A2, 0x1)),
    (0x03275, (0x5C8, 0x2)),
    (0x1D5D1, (0x12A0, 0x1)),
    (0x0FFED, (0x1089, 0x1)),
    (0x0FDA4, (0xDFE, 0x3)),
    (0x0FED1, (0xF6F, 0x1)),
    (0x0FEA7, (0xF45, 0x1)),
    (0x1D6A3, (0x1372, 0x1)),
    (0x0FCE3, (0xC4F, 0x2)),
    (0x1EEB1, (0x158B, 0x1)),
    (0x03317, (0x6E5, 0x5)),
    (0x0FE80, (0xF12, 0x1)),
    (0x02101, (0x170, 0x3)),
    (0x0328C, (0x5ED, 0x1)),
    (0x0FBFD, (0xA6E, 0x1)),
    (0x02F5F, (0x3B8, 0x1)),
    (0x03278, (0x5CE, 0x2)),
    (0x0FF11, (0xFB9, 0x1)),
    (0x02F1A, (0x373, 0x1)),
    (0x1EE90, (0x1571, 0x1)),
    (0x024D5, (0x332, 0x1)),
    (0x0247E, (0x26A, 0x4)),
    (0x0FB93, (0x9FC, 0x1)),
    (0x0FD10, (0xCAC, 0x2)),
    (0x1D68D, (0x135C, 0x1)),
    (0x1CCE8, (0x10D5, 0x1)),
    (0x003F2, (0x06A, 0x1)),
    (0x01DB9, (0x0E3, 0x1)),
    (0x02F18, (0x371, 0x1)),
    (0x1F149, (0x161C, 0x1)),
    (0x01D65, (0x0BE, 0x1)),
    (0x0FE8A, (0xF25, 0x2)),
    (0x1F129, (0x15F7, 0x3)),
    (0x0210D, (0x182, 0x1)),
    (0x1D40E, (0x10F5, 0x1)),
    (0x0333E, (0x783, 0x4)),
    (0x1EE09, (0x1511, 0x1)),
    (0x033DC, (0x925, 0x2)),
    (0x0FDB4, (0xE2E, 0x3)),
    (0x02099, (0x167, 0x1)),
    (0x0FD2D, (0xCE6, 0x2)),
    (0x032A0, (0x601, 0x1)),
    (0x0FEBD, (0xF5B, 0x1)),
    (0x0FF73, (0x101B, 0x1)),
    (0x032D8, (0x65D, 0x1)),
    (0x10794, (0x109D, 0x1)),
    (0x0FBAA, (0xA15, 0x1)),
    (0x0FE37, (0xEC1, 0x1)),
    (0x0FF1A, (0xFC2, 0x1)),
    (0x0FCA2, (0xBCB, 0x2)),
    (0x0FD85, (0xDA7, 0x3)),
    (0x1D78B, (0x1458, 0x1)),
    (0x1D6A8, (0x1375, 0x1)),
    (0x1D778, (0x1445, 0x1)),
    (0x02F1B, (0x374, 0x1)),
    (0x000B2, (0x006, 0x1)),
    (0x03359, (0x7E4, 0x2)),
    (0x03179, (0x484, 0x1)),
    (0x0FB99, (0xA02, 0x1)),
    (0x1D5B2, (0x1281, 0x1)),
    (0x107A3, (0x10AC, 0x1)),
    (0x1D626, (0x12F5, 0x1)),
    (0x0318A, (0x495, 0x1)),
    (0x1D4C0, (0x119C, 0x1)),
    (0x0FBDF, (0xA2C, 0x1)),
    (0x1D686, (0x1355, 0x1)),
    (0x0FE40, (0xECA, 0x1)),
    (0x02F2C, (0x385, 0x1)),
    (0x1F136, (0x1609, 0x1)),
    (0x02FCF, (0x428, 0x1)),
    (0x02F3F, (0x398, 0x1)),
    (0x0FE3E, (0xEC8, 0x1)),
    (0x0327C, (0x5D6, 0x5)),
    (0x0FF14, (0xFBC, 0x1)),
    (0x1D53E, (0x1213, 0x1)),
    (0x0314A, (0x455, 0x1)),
    (0x1D636, (0x1305, 0x1)),
    (0x0FDC3, (0xE5B, 0x3)),
    (0x02F95, (0x3EE, 0x1)),
    (0x1F113, (0x15B5, 0x3)),
    (0x1D481, (0x1167, 0x1)),
    (0x01DAA, (0x0D4, 0x1)),
    (0x1D5F2, (0x12C1, 0x1)),
    (0x1D5BD, (0x128C, 0x1)),
    (0x1E045, (0x14E0, 0x1)),
    (0x02F6A, (0x3C3, 0x1)),
    (0x0FB8C, (0x9F5, 0x1)),
    (0x02F5B, (0x3B4, 0x1)),
    (0x1D7D4, (0x149F, 0x1)),
    (0x0335E, (0x7EE, 0x2)),
    (0x1D565, (0x1234, 0x1)),
    (0x1D442, (0x1129, 0x1)),
    (0x1D48A, (0x1170, 0x1)),
    (0x0FCF2, (0xC6D, 0x3)),
    (0x1F142, (0x1615, 0x1)),
    (0x1D544, (0x1218, 0x1)),
    (0x1D452, (0x1139, 0x1)),
    (0x002D9, (0x049, 0x2)),
    (0x1D573, (0x1242, 0x1)),
    (0x0FF54, (0xFFC, 0x1)),
    (0x0FCDC, (0xC3F, 0x2)),
    (0x0FC4F, (0xB14, 0x2)),
    (0x1D540, (0x1214, 0x1)),
    (0x0FEAD, (0xF4B, 0x1)),
    (0x0FCE0, (0xC48, 0x3)),
    (0x0FDA6, (0xE04, 0x3)),
    (0x0FB23, (0x9B0, 0x1)),
    (0x1D446, (0x112D, 0x1)),
    (0x1D66E, (0x133D, 0x1)),
    (0x1EE07, (0x150F, 0x1)),
    (0x01D36, (0x091, 0x1)),
    (0x0FD1E, (0xCC8, 0x2)),
    (0x10782, (0x108C, 0x1)),
    (0x03160, (0x46B, 0x1)),
    (0x03338, (0x76A, 0x4)),
    (0x1D7C3, (0x1490, 0x1)),
    (0x1F14F, (0x1628, 0x2)),
    (0x1D41C, (0x1103, 0x1)),
    (0x0FF60, (0x1008, 0x1)),
    (0x1D7C1, (0x148E, 0x1)),
    (0x1D473, (0x1159, 0x1)),
    (0x0313F, (0x44A, 0x1)),
    (0x1D582, (0x1251, 0x1)),
    (0x0FC0F, (0xA94, 0x2)),
    (0x1D569, (0x1238, 0x1)),
    (0x03336, (0x762, 0x5)),
    (0x03355, (0x7D7, 0x2)),
    (0x1EE4B, (0x153F, 0x1)),
    (0x03169, (0x474, 0x1)),
    (0x0FB65, (0x9CE, 0x1)),
    (0x0FFA7, (0x104F, 0x1)),
    (0x03323, (0x719, 0x3)),
    (0x1D6BC, (0x1389, 0x1)),
    (0x01D4D, (0x0A7, 0x1)),
    (0x1D7FB, (0x14C6, 0x1)),
    (0x03300, (0x686, 0x5)),
    (0x0FDF9, (0xE8C, 0x3)),
    (0x1EE24, (0x152A, 0x1)),
    (0x1EE03, (0x150C, 0x1)),
    (0x03230, (0x54B, 0x3)),
    (0x0FC19, (0xAA8, 0x2)),
    (0x024A3, (0x2DA, 0x3)),
    (0x1F239, (0x1661, 0x1)),
    (0x0318C, (0x497, 0x1)),
    (0x1D588, (0x1257, 0x1)),
    (0x0FF69, (0x1011, 0x1)),
    (0x0246F, (0x241, 0x2)),
    (0x02F13, (0x36C, 0x1)),
    (0x024C4, (0x321, 0x1)),
    (0x03178, (0x483, 0x1)),
    (0x1EE81, (0x1563, 0x1)),
    (0x02E9F, (0x357, 0x1)),
    (0x1D6AD, (0x137A, 0x1)),
    (0x0FC4D, (0xB10, 0x2)),
    (0x0FEAF, (0xF4D, 0x1)),
    (0x033F4, (0x962, 0x3)),
    (0x032E1, (0x666, 0x1)),
    (0x03319, (0x6EE, 0x6)),
    (0x033C1, (0x8E4, 0x2)),
    (0x1F100, (0x1596, 0x2)),
    (0x02F34, (0x38D, 0x1)),
    (0x1E030, (0x14CB, 0x1)),
    (0x0FD9D, (0xDE9, 0x3)),
    (0x1D47F, (0x1165, 0x1)),
    (0x0FBA1, (0xA0A, 0x1)),
    (0x1D48D, (0x1173, 0x1)),
    (0x1F228, (0x1650, 0x1)),
    (0x02120, (0x191, 0x2)),
    (0x0FE88, (0xF21, 0x2)),
    (0x0FB4F, (0x9B7, 0x2)),
    (0x0205F, (0x140, 0x1)),
    (0x033C9, (0x8F9, 0x2)),
    (0x0207F, (0x14E, 0x1)),
    (0x1D716, (0x13E3, 0x1)),
    (0x1D673, (0x1342, 0x1)),
    (0x1EE9A, (0x157B, 0x1)),
    (0x1D7D5, (0x14A0, 0x1)),
    (0x1D649, (0x1318, 0x1)),
    (0x1EE5F, (0x154A, 0x1)),
    (0x1D75A, (0x1427, 0x1)),
    (0x1D5D4, (0x12A3, 0x1)),
    (0x002E2, (0x055, 0x1)),
    (0x0FEC1, (0xF5F, 0x1)),
    (0x0309F, (0x438, 0x2)),
    (0x0FB5E, (0x9C7, 0x1)),
    (0x1D47E, (0x1164, 0x1)),
    (0x1D707, (0x13D4, 0x1)),
    (0x02F5E, (0x3B7, 0x1)),
    (0x0FB9D, (0xA06, 0x1)),
    (0x03326, (0x723, 0x3)),
    (0x0FEA3, (0xF41, 0x1)),
    (0x1E038, (0x14D3, 0x1)),
    (0x01FC1, (0x0F4, 0x3)),
    (0x1D71B, (0x13E8, 0x1)),
    (0x032F4, (0x679, 0x1)),
    (0x03346, (0x79E, 0x3)),
    (0x1D7A0, (0x146D, 0x1)),
    (0x02F4F, (0x3A8, 0x1)),
    (0x03361, (0x7F4, 0x2)),
    (0x1F211, (0x1638, 0x1)),
    (0x1EE2F, (0x1532, 0x1)),
    (0x1D4ED, (0x11C8, 0x1)),
    (0x0FC9A, (0xBB9, 0x3)),
    (0x1D4E1, (0x11BC, 0x1)),
    (0x032A8, (0x609, 0x1)),
    (0x1F226, (0x164E, 0x1)),
    (0x000B8, (0x00B, 0x2)),
    (0x1EE54, (0x1545, 0x1)),
    (0x01D69, (0x0C2, 0x1)),
    (0x0207B, (0x14A, 0x1)),
    (0x1079B, (0x10A4, 0x1)),
    (0x0FC0E, (0xA92, 0x2)),
    (0x1EE1E, (0x1526, 0x1)),
    (0x1D518, (0x11EF, 0x1)),
    (0x1D420, (0x1107, 0x1)),
    (0x0FBA3, (0xA0C, 0x1)),
    (0x02FD0, (0x429, 0x1)),
    (0x1D4C6, (0x11A1, 0x1)),
    (0x03133, (0x43E, 0x1)),
    (0x0FD33, (0xCF2, 0x2)),
    (0x0FC12, (0xA9A, 0x2)),
    (0x0FFBA, (0x1062, 0x1)),
    (0x01D50, (0x0A9, 0x1)),
    (0x0248A, (0x296, 0x2)),
    (0x0FD05, (0xC96, 0x2)),
    (0x0FDB9, (0xE3D, 0x3)),
    (0x0210C, (0x181, 0x1)),
    (0x0339B, (0x884, 0x2)),
    (0x033E6, (0x93B, 0x2)),
    (0x1D613, (0x12E2, 0x1)),
    (0x1D7B2, (0x147F, 0x1)),
    (0x0FBAF, (0xA1A, 0x1)),
    (0x01DA2, (0x0CC, 0x1)),
    (0x0316E, (0x479, 0x1)),
    (0x02F48, (0x3A1, 0x1)),
    (0x000AF, (0x004, 0x2)),
    (0x10799, (0x10A2, 0x1)),
    (0x0FBEB, (0xA3A, 0x3)),
    (0x0315F, (0x46A, 0x1)),
    (0x1EEB2, (0x158C, 0x1)),
    (0x1D468, (0x114E, 0x1)),
    (0x1D42F, (0x1116, 0x1)),
    (0x0FC55, (0xB20, 0x2)),
    (0x1D51C, (0x11F3, 0x1)),
    (0x0FF92, (0x103A, 0x1)),
    (0x03395, (0x878, 0x2)),
    (0x1D674, (0x1343, 0x1)),
    (0x1D722, (0x13EF, 0x1)),
    (0x0FBE6, (0xA33, 0x1)),
    (0x033A4, (0x89A, 0x3)),
    (0x033F7, (0x96B, 0x3)),
    (0x02001, (0x114, 0x1)),
    (0x1F14B, (0x161F, 0x2)),
    (0x1D733, (0x1400, 0x1)),
    (0x0FEC0, (0xF5E, 0x1)),
    (0x1D67D, (0x134C, 0x1)),
    (0x0FC23, (0xABC, 0x2)),
    (0x1D601, (0x12D0, 0x1)),
    (0x02F85, (0x3DE, 0x1)),
    (0x0037A, (0x058, 0x2)),
    (0x032CF, (0x652, 0x3)),
    (0x1F200, (0x1632, 0x2)),
    (0x02499, (0x2BC, 0x3)),
    (0x1D490, (0x1176, 0x1)),
    (0x032F0, (0x675, 0x1)),
    (0x02F19, (0x372, 0x1)),
    (0x1D696, (0x1365, 0x1)),
    (0x1D55E, (0x122D, 0x1)),
    (0x0FCF5, (0xC76, 0x2)),
    (0x0FC7F, (0xB80, 0x2)),
    (0x0FC64, (0xB44, 0x3)),
    (0x0FFB3, (0x105B, 0x1)),
    (0x1F105, (0x15A0, 0x2)),
    (0x1D748, (0x1415, 0x1)),
    (0x1D405, (0x10EC, 0x1)),
    (0x02113, (0x188, 0x1)),
    (0x0FEE1, (0xF7F, 0x1)),
    (0x1E05F, (0x14FA, 0x1)),
    (0x0FCFD, (0xC86, 0x2)),
    (0x0FF4E, (0xFF6, 0x1)),
    (0x1D7F7, (0x14C2, 0x1)),
    (0x0FFD5, (0x1076, 0x1)),
    (0x0FCB3, (0xBED, 0x2)),
    (0x0FB52, (0x9BB, 0x1)),
    (0x1D595, (0x1264, 0x1)),
    (0x1F147, (0x161A, 0x1)),
    (0x0FE5D, (0xEE8, 0x1)),
    (0x1D655, (0x1324, 0x1)),
    (0x1D6B5, (0x1382, 0x1)),
    (0x024BF, (0x31C, 0x1)),
    (0x03256, (0x598, 0x2)),
    (0x01FFE, (0x111, 0x2)),
    (0x024BB, (0x318, 0x1)),
    (0x1D6AF, (0x137C, 0x1)),
    (0x03260, (0x5AC, 0x1)),
    (0x02F01, (0x35A, 0x1)),
    (0x0FC80, (0xB82, 0x2)),
    (0x0325C, (0x5A4, 0x2)),
    (0x1D6A0, (0x136F, 0x1)),
    (0x03383, (0x84D, 0x2)),
    (0x0FB22, (0x9AF, 0x1)),
    (0x1D61C, (0x12EB, 0x1)),
    (0x0216F, (0x200, 0x1)),
    (0x01D57, (0x0B0, 0x1)),
    (0x024D8, (0x335, 0x1)),
    (0x1D773, (0x1440, 0x1)),
    (0x0FC5E, (0xB32, 0x3)),
    (0x1F213, (0x163A, 0x2)),
    (0x1D70F, (0x13DC, 0x1)),
    (0x1D5E6, (0x12B5, 0x1)),
    (0x0FFA4, (0x104C, 0x1)),
    (0x1F12D, (0x15FF, 0x2)),
    (0x0FB16, (0x9A9, 0x2)),
    (0x1E05A, (0x14F5, 0x1)),
    (0x0FC79, (0xB74, 0x2)),
    (0x02FA7, (0x400, 0x1)),
    (0x0327A, (0x5D2, 0x2)),
    (0x032FB, (0x680, 0x1)),
    (0x002D8, (0x047, 0x2)),
    (0x1EEA5, (0x1580, 0x1)),
    (0x1CCEA, (0x10D7, 0x1)),
    (0x02493, (0x2AA, 0x3)),
    (0x1E04A, (0x14E5, 0x1)),
    (0x1D598, (0x1267, 0x1)),
    (0x02FAB, (0x404, 0x1)),
    (0x1D758, (0x1425, 0x1)),
    (0x1D4DA, (0x11B5, 0x1)),
    (0x0FBDB, (0xA27, 0x1)),
    (0x02164, (0x1EB, 0x1)),
    (0x0FF83, (0x102B, 0x1)),
    (0x02F94, (0x3ED, 0x1)),
    (0x02483, (0x27E, 0x4)),
    (0x032ED, (0x672, 0x1)),
    (0x0334F, (0x7C2, 0x3)),
    (0x1D737, (0x1404, 0x1)),
    (0x0FDC4, (0xE5E, 0x3)),
    (0x0FE55, (0xEE0, 0x1)),
    (0x0FF7D, (0x1025, 0x1)),
    (0x02489, (0x294, 0x2)),
    (0x02FB5, (0x40E, 0x1)),
    (0x0FE3C, (0xEC6, 0x1)),
    (0x1D628, (0x12F7, 0x1)),
    (0x032F5, (0x67A, 0x1)),
    (0x0FF05, (0xFAD, 0x1)),
    (0x0FFA8, (0x1050, 0x1)),
    (0x1EE1D, (0x1525, 0x1)),
    (0x03159, (0x464, 0x1)),
    (0x02A0C, (0x348, 0x4)),
    (0x1D746, (0x1413, 0x1)),
    (0x0FECF, (0xF6D, 0x1)),
    (0x0FBFB, (0xA6A, 0x3)),
    (0x1D6D6, (0x13A3, 0x1)),
    (0x02152, (0x1B9, 0x4)),
    (0x1E043, (0x14DE, 0x1)),
    (0x03172, (0x47D, 0x1)),
    (0x107AA, (0x10B3, 0x1)),
    (0x0FBDC, (0xA28, 0x1)),
    (0x02158, (0x1CC, 0x3)),
    (0x1D63D, (0x130C, 0x1)),
    (0x0FEE2, (0xF80, 0x1)),
    (0x024DC, (0x339, 0x1)),
    (0x0FDC0, (0xE52, 0x3)),
    (0x02F1E, (0x377, 0x1)),
    (0x01D54, (0x0AD, 0x1)),
    (0x1D759, (0x1426, 0x1)),
    (0x1D553, (0x1222, 0x1)),
    (0x10795, (0x109E, 0x1)),
    (0x033B9, (0x8D4, 0x2)),
    (0x1D5D2, (0x12A1, 0x1)),
    (0x1D451, (0x1138, 0x1)),
    (0x0335C, (0x7EA, 0x2)),
    (0x03283, (0x5E4, 0x1)),
    (0x032E6, (0x66B, 0x1)),
    (0x03281, (0x5E2, 0x1)),
    (0x107B0, (0x10B9, 0x1)),
    (0x03371, (0x823, 0x3)),
    (0x0FCF1, (0xC6B, 0x2)),
    (0x1EE86, (0x1568, 0x1)),
    (0x0FFDB, (0x107A, 0x1)),
    (0x1D647, (0x1316, 0x1)),
    (0x03210, (0x4DA, 0x4)),
    (0x1D7CA, (0x1497, 0x1)),
    (0x0FDF4, (0xE78, 0x4)),
    (0x0FD0C, (0xCA4, 0x2)),
    (0x02007, (0x11A, 0x1)),
    (0x0333B, (0x775, 0x5)),
    (0x02A75, (0x34F, 0x2)),
    (0x03231, (0x54E, 0x3)),
    (0x02F8D, (0x3E6, 0x1)),
    (0x1D6DD, (0x13AA, 0x1)),
    (0x107B5, (0x10BD, 0x1)),
    (0x02F54, (0x3AD, 0x1)),
    (0x0FB98, (0xA01, 0x1)),
    (0x0FD60, (0xD38, 0x3)),
    (0x1D495, (0x117B, 0x1)),
    (0x0FF4D, (0xFF5, 0x1)),
    (0x0313B, (0x446, 0x1)),
    (0x0A7F3, (0x98A, 0x1)),
    (0x1D7E5, (0x14B0, 0x1)),
    (0x1D4F2, (0x11CD, 0x1)),
    (0x1D65E, (0x132D, 0x1)),
    (0x02F6D, (0x3C6, 0x1)),
    (0x1EE00, (0x1509, 0x1)),
    (0x02103, (0x174, 0x2)),
    (0x0FF5D, (0x1005, 0x1)),
    (0x1F16B, (0x162C, 0x2)),
    (0x0FF8A, (0x1032, 0x1)),
    (0x1D4B3, (0x1191, 0x1)),
    (0x032FD, (0x682, 0x1)),
    (0x1D74B, (0x1418, 0x1)),
    (0x0FD03, (0xC92, 0x2)),
    (0x1D471, (0x1157, 0x1)),
    (0x1D576, (0x1245, 0x1)),
    (0x1D493, (0x1179, 0x1)),
    (0x0FF6A, (0x1012, 0x1)),
    (0x0FE31, (0xEBB, 0x1)),
    (0x0323A, (0x569, 0x3)),
    (0x01D49, (0x0A3, 0x1)),
    (0x1D7E9, (0x14B4, 0x1)),
    (0x0FB6E, (0x9D7, 0x1)),
    (0x0FC51, (0xB18, 0x2)),
    (0x033ED, (0x94D, 0x3)),
    (0x0FE15, (0xEB2, 0x1)),
    (0x02F28, (0x381, 0x1)),
    (0x1D6A4, (0x1373, 0x1)),
    (0x1D4E2, (0x11BD, 0x1)),
    (0x032CE, (0x650, 0x2)),
    (0x02094, (0x162, 0x1)),
    (0x1D6FC, (0x13C9, 0x1)),
    (0x032F6, (0x67B, 0x1)),
    (0x0FE9A, (0xF38, 0x1)),
    (0x01DBE, (0x0E8, 0x1)),
    (0x01DB7, (0x0E1, 0x1)),
    (0x1D4BD, (0x1199, 0x1)),
    (0x0FDA1, (0xDF5, 0x3)),
    (0x1D6D7, (0x13A4, 0x1)),
    (0x1D7BF, (0x148C, 0x1)),
    (0x03316, (0x6DF, 0x6)),
    (0x03391, (0x86C, 0x3)),
    (0x1D744, (0x1411, 0x1)),
    (0x1D41F, (0x1106, 0x1)),
    (0x1EE84, (0x1566, 0x1)),
    (0x0FFBE, (0x1066, 0x1)),
    (0x03244, (0x587, 0x1)),
    (0x1D58D, (0x125C, 0x1)),
    (0x02FD1, (0x42A, 0x1)),
    (0x0FF19, (0xFC1, 0x1)),
    (0x1D5C5, (0x1294, 0x1)),
    (0x1D663, (0x1332, 0x1)),
    (0x1D723, (0x13F0, 0x1)),
    (0x1F247, (0x1679, 0x3)),
    (0x1F23B, (0x1663, 0x1)),
    (0x0FCD6, (0xC33, 0x2)),
    (0x01DB5, (0x0DF, 0x1)),
    (0x02083, (0x152, 0x1)),
    (0x024C9, (0x326, 0x1)),
    (0x1D6CD, (0x139A, 0x1)),
    (0x1D5A9, (0x1278, 0x1)),
    (0x03307, (0x6A2, 0x6)),
    (0x1D7DF, (0x14AA, 0x1)),
    (0x1D692, (0x1361, 0x1)),
    (0x1D509, (0x11E3, 0x1)),
    (0x024AF, (0x2FE, 0x3)),
    (0x1CCDE, (0x10CB, 0x1)),
    (0x1EE93, (0x1574, 0x1)),
    (0x0FD14, (0xCB4, 0x2)),
    (0x0316C, (0x477, 0x1)),
    (0x0FC42, (0xAFA, 0x2)),
    (0x0FB70, (0x9D9, 0x1)),
    (0x02F06, (0x35F, 0x1)),
    (0x0FD8B, (0xDB9, 0x3)),
    (0x03271, (0x5C0, 0x2)),
    (0x03342, (0x791, 0x3)),
    (0x03269, (0x5B5, 0x1)),
    (0x1FBF1, (0x1682, 0x1)),
    (0x032D6, (0x65B, 0x1)),
    (0x0209B, (0x169, 0x1)),
    (0x1D7B8, (0x1485, 0x1)),
    (0x0FF56, (0xFFE, 0x1)),
    (0x0FE60, (0xEEB, 0x1)),
    (0x1D5E4, (0x12B3, 0x1)),
    (0x1F233, (0x165B, 0x1)),
    (0x0FF1D, (0xFC5, 0x1)),
    (0x0FCF6, (0xC78, 0x2)),
    (0x1D4DB, (0x11B6, 0x1)),
    (0x02F67, (0x3C0, 0x1)),
    (0x1D53B, (0x1210, 0x1)),
    (0x0FBA4, (0xA0D, 0x2)),
    (0x0336A, (0x80E, 0x3)),
    (0x0FD1C, (0xCC4, 0x2)),
    (0x1E061, (0x14FC, 0x1)),
    (0x0FB95, (0x9FE, 0x1)),
    (0x03257, (0x59A, 0x2)),
    (0x1D560, (0x122F, 0x1)),
    (0x032C5, (0x63A, 0x2)),
    (0x1EE30, (0x1533, 0x1)),
    (0x1D466, (0x114C, 0x1)),
    (0x0FE9F, (0xF3D, 0x1)),
    (0x03038, (0x431, 0x1)),
    (0x032AE, (0x60F, 0x1)),
    (0x1D7B0, (0x147D, 0x1)),
    (0x1CCF0, (0x10DD, 0x1)),
    (0x1D7E6, (0x14B1, 0x1)),
    (0x0FCA0, (0xBC7, 0x2)),
    (0x0336C, (0x814, 0x3)),
    (0x0FD2B, (0xCE2, 0x2)),
    (0x0FBAE, (0xA19, 0x1)),
    (0x0FFB4, (0x105C, 0x1)),
    (0x02F33, (0x38C, 0x1)),
    (0x0FD3C, (0xD04, 0x2)),
    (0x0FF31, (0xFD9, 0x1)),
    (0x0332C, (0x736, 0x4)),
    (0x1F12B, (0x15FD, 0x1)),
    (0x033FE, (0x980, 0x3)),
    (0x01D41, (0x09B, 0x1)),
    (0x107B8, (0x10C0, 0x1)),
    (0x1D62A, (0x12F9, 0x1)),
    (0x1D631, (0x1300, 0x1)),
    (0x1EEAC, (0x1586, 0x1)),
    (0x02FB8, (0x411, 0x1)),
    (0x1D4FB, (0x11D6, 0x1)),
    (0x0FF76, (0x101E, 0x1)),
    (0x0FC37, (0xAE4, 0x2)),
    (0x0FC29, (0xAC8, 0x2)),
    (0x1D6E6, (0x13B3, 0x1)),
    (0x107A1, (0x10AA, 0x1)),
    (0x0319D, (0x4A5, 0x1)),
    (0x0FCAC, (0xBDF, 0x2)),
    (0x03344, (0x798, 0x3)),
    (0x0FE4C, (0xED7, 0x2)),
    (0x0208B, (0x15A, 0x1)),
    (0x107A9, (0x10B2, 0x1)),
    (0x0FE96, (0xF34, 0x1)),
    (0x0FC56, (0xB22, 0x2)),
    (0x0FBFA, (0xA67, 0x3)),
    (0x0FB85, (0x9EE, 0x1)),
    (0x0FD89, (0xDB3, 0x3)),
    (0x03295, (0x5F6, 0x1)),
    (0x0FCA8, (0xBD7, 0x2)),
    (0x002E0, (0x053, 0x1)),
    (0x03350, (0x7C5, 0x3)),
    (0x02147, (0x1B0, 0x1)),
    (0x01D30, (0x08B, 0x1)),
    (0x03387, (0x855, 0x2)),
    (0x0317F, (0x48A, 0x1)),
    (0x1F107, (0x15A4, 0x2)),
    (0x1D555, (0x1224, 0x1)),
    (0x1D6BE, (0x138B, 0x1)),
    (0x0FEF5, (0xF93, 0x3)),
    (0x03351, (0x7C8, 0x4)),
    (0x1D4AB, (0x118A, 0x1)),
    (0x02479, (0x25A, 0x3)),
    (0x024CB, (0x328, 0x1)),
    (0x0FF1F, (0xFC7, 0x1)),
    (0x03212, (0x4E2, 0x4)),
    (0x032C0, (0x630, 0x2)),
    (0x1EE75, (0x155A, 0x1)),
    (0x0A7F8, (0x98C, 0x1)),
    (0x1F245, (0x1673, 0x3)),
    (0x0FB57, (0x9C0, 0x1)),
    (0x1F215, (0x163D, 0x1)),
    (0x0FEA9, (0xF47, 0x1)),
    (0x02484, (0x282, 0x4)),
    (0x02FBF, (0x418, 0x1)),
    (0x0FED5, (0xF73, 0x1)),
    (0x1D4D6, (0x11B1, 0x1)),
    (0x02F7A, (0x3D3, 0x1)),
    (0x03242, (0x581, 0x3)),
    (0x1D456, (0x113C, 0x1)),
    (0x0FE14, (0xEB1, 0x1)),
    (0x0FC59, (0xB28, 0x2)),
    (0x0FCD7, (0xC35, 0x2)),
    (0x0FE43, (0xECD, 0x1)),
    (0x1D7D1, (0x149C, 0x1)),
    (0x1D563, (0x1232, 0x1)),
    (0x0FC4E, (0xB12, 0x2)),
    (0x1F250, (0x167F, 0x1)),
    (0x1D4F5, (0x11D0, 0x1)),
    (0x0FBD5, (0xA21, 0x1)),
    (0x1D661, (0x1330, 0x1)),
    (0x03252, (0x590, 0x2)),
    (0x0FECC, (0xF6A, 0x1)),
    (0x0FF85, (0x102D, 0x1)),
    (0x0FD51, (0xD0B, 0x3)),
    (0x1D605, (0x12D4, 0x1)),
    (0x0FBE5, (0xA32, 0x1)),
    (0x1D4CC, (0x11A7, 0x1)),
    (0x1F119, (0x15C7, 0x3)),
    (0x1D638, (0x1307, 0x1)),
    (0x0FDAF, (0xE1F, 0x3)),
    (0x1D739, (0x1406, 0x1)),
    (0x1F21A, (0x1642, 0x1)),
    (0x0318E, (0x499, 0x1)),
    (0x0316D, (0x478, 0x1)),
    (0x03374, (0x82A, 0x3)),
    (0x02469, (0x235, 0x2)),
    (0x0FB29, (0x9B6, 0x1)),
    (0x1EE01, (0x150A, 0x1)),
    (0x0248E, (0x29E, 0x2)),
    (0x1D623, (0x12F2, 0x1)),
    (0x032D9, (0x65E, 0x1)),
    (0x1D531, (0x1207, 0x1)),
    (0x03146, (0x451, 0x1)),
    (0x1E051, (0x14EC, 0x1)),
    (0x1D48C, (0x1172, 0x1)),
    (0x0FCF0, (0xC69, 0x2)),
    (0x0FB80, (0x9E9, 0x1)),
    (0x0FEB1, (0xF4F, 0x1)),
    (0x02FD3, (0x42C, 0x1)),
    (0x0FD77, (0xD7D, 0x3)),
    (0x02482, (0x27A, 0x4)),
    (0x03152, (0x45D, 0x1)),
    (0x02176, (0x20C, 0x3)),
    (0x024B8, (0x315, 0x1)),
    (0x0322C, (0x53F, 0x3)),
    (0x0FE56, (0xEE1, 0x1)),
    (0x03397, (0x87C, 0x2)),
    (0x02476, (0x251, 0x3)),
    (0x10796, (0x109F, 0x1)),
    (0x1D4D0, (0x11AB, 0x1)),
    (0x107B3, (0x10BB, 0x1)),
    (0x1D779, (0x1446, 0x1)),
    (0x0FD7C, (0xD8C, 0x3)),
    (0x02F22, (0x37B, 0x1)),
    (0x0FC34, (0xADE, 0x2)),
    (0x0FCB9, (0xBF9, 0x2)),
    (0x1D676, (0x1345, 0x1)),
    (0x1D408, (0x10EF, 0x1)),
    (0x0FB74, (0x9DD, 0x1)),
    (0x0332A, (0x72D, 0x3)),
    (0x1D7B3, (0x1480, 0x1)),
    (0x03202, (0x4AE, 0x3)),
    (0x02230, (0x229, 0x3)),
    (0x0FE65, (0xEF0, 0x1)),
    (0x032DF, (0x664, 0x1)),
    (0x03177, (0x482, 0x1)),
    (0x0FD2C, (0xCE4, 0x2)),
    (0x0FEED, (0xF8B, 0x1)),
    (0x1F12A, (0x15FA, 0x3)),
    (0x02F62, (0x3BB, 0x1)),
    (0x02FA6, (0x3FF, 0x1)),
    (0x0248C, (0x29A, 0x2)),
    (0x0FF6B, (0x1013, 0x1)),
    (0x0FEF1, (0xF8F, 0x1)),
    (0x1D4B5, (0x1193, 0x1)),
    (0x1D6E4, (0x13B1, 0x1)),
    (0x03312, (0x6CD, 0x4)),
    (0x1EE21, (0x1528, 0x1)),
    (0x0FD18, (0xCBC, 0x2)),
    (0x1D57A, (0x1249, 0x1)),
    (0x0216C, (0x1FD, 0x1)),
    (0x03131, (0x43C, 0x1)),
    (0x03217, (0x4F6, 0x4)),
    (0x03386, (0x853, 0x2)),
    (0x1D711, (0x13DE, 0x1)),
    (0x03200, (0x4A8, 0x3)),
    (0x1D62C, (0x12FB, 0x1)),
    (0x1D590, (0x125F, 0x1)),
    (0x1D53C, (0x1211, 0x1)),
    (0x032CB, (0x648, 0x3)),
    (0x0FD29, (0xCDE, 0x2)),
    (0x1EEA1, (0x157D, 0x1)),
    (0x0FE4F, (0xEDB, 0x1)),
    (0x0FB54, (0x9BD, 0x1)),
    (0x0322A, (0x539, 0x3)),
    (0x1F14A, (0x161D, 0x2)),
    (0x02136, (0x1A2, 0x1)),
    (0x0FF2B, (0xFD3, 0x1)),
    (0x0FCFB, (0xC82, 0x2)),
    (0x0FDB2, (0xE28, 0x3)),
    (0x1EE36, (0x1538, 0x1)),
    (0x0FD2E, (0xCE8, 0x2)),
    (0x0FF46, (0xFEE, 0x1)),
    (0x1CCF8, (0x10E5, 0x1)),
    (0x1D60C, (0x12DB, 0x1)),
    (0x033AB, (0x8AE, 0x3)),
    (0x1D7BC, (0x1489, 0x1)),
    (0x1D4C1, (0x119D, 0x1)),
    (0x0FDBD, (0xE49, 0x3)),
    (0x03331, (0x74C, 0x3)),
    (0x1EE34, (0x1536, 0x1)),
    (0x1D6CC, (0x1399, 0x1)),
    (0x1D44F, (0x1136, 0x1)),
    (0x0332E, (0x73F, 0x6)),
    (0x0FF6E, (0x1016, 0x1)),
    (0x01D78, (0x0C4, 0x1)),
    (0x1D780, (0x144D, 0x1)),
    (0x1D765, (0x1432, 0x1)),
    (0x0FE71, (0xEF8, 0x2)),
    (0x02496, (0x2B3, 0x3)),
    (0x1D460, (0x1146, 0x1)),
    (0x1D756, (0x1423, 0x1)),
    (0x0FC5C, (0xB2E, 0x2)),
    (0x0337F, (0x843, 0x4)),
    (0x0FC2D, (0xAD0, 0x2)),
    (0x024AA, (0x2EF, 0x3)),
    (0x1D546, (0x1219, 0x1)),
    (0x1D624, (0x12F3, 0x1)),
    (0x1EEB9, (0x1593, 0x1)),
    (0x01D63, (0x0BC, 0x1)),
    (0x001CA, (0x032, 0x2)),
    (0x03240, (0x57B, 0x3)),
    (0x1D4E3, (0x11BE, 0x1)),
    (0x1E062, (0x14FD, 0x1)),
    (0x03225, (0x52A, 0x3)),
    (0x0FE79, (0xF04, 0x2)),
    (0x02F20, (0x379, 0x1)),
    (0x0FCAD, (0xBE1, 0x2)),
    (0x0FC85, (0xB8C, 0x2)),
    (0x02FB9, (0x412, 0x1)),
    (0x1D7D2, (0x149D, 0x1)),
    (0x0332D, (0x73A, 0x5)),
    (0x1D4E6, (0x11C1, 0x1)),
    (0x024E2, (0x33F, 0x1)),
    (0x1EEAF, (0x1589, 0x1)),
    (0x032B0, (0x611, 0x1)),
    (0x1D575, (0x1244, 0x1)),
    (0x0FD6E, (0xD62, 0x3)),
    (0x0FD71, (0xD6B, 0x3)),
    (0x1D521, (0x11F7, 0x1)),
    (0x0FF9D, (0x1045, 0x1)),
    (0x1D671, (0x1340, 0x1)),
    (0x0247B, (0x260, 0x3)),
    (0x1D7D7, (0x14A2, 0x1)),
    (0x03174, (0x47F, 0x1)),
    (0x1D7A8, (0x1475, 0x1)),
    (0x1F16C, (0x162E, 0x2)),
    (0x0FB14, (0x9A5, 0x2)),
    (0x1D5D3, (0x12A2, 0x1)),
    (0x1F123, (0x15E5, 0x3)),
    (0x0FBAD, (0xA18, 0x1)),
    (0x03308, (0x6A8, 0x4)),
    (0x03164, (0x46F, 0x1)),
    (0x02033, (0x128, 0x2)),
    (0x1D644, (0x1313, 0x1)),
    (0x0FCD8, (0xC37, 0x2)),
    (0x0FC22, (0xABA, 0x2)),
    (0x0215A, (0x1D2, 0x3)),
    (0x1D64B, (0x131A, 0x1)),
    (0x0FBEF, (0xA46, 0x3)),
    (0x01DBF, (0x0E9, 0x1)),
    (0x033A6, (0x89F, 0x3)),
    (0x0FD74, (0xD74, 0x3)),
    (0x1D533, (0x1209, 0x1)),
    (0x01DA4, (0x0CE, 0x1)),
    (0x1D40A, (0x10F1, 0x1)),
    (0x0FEA0, (0xF3E, 0x1)),
    (0x01D61, (0x0BA, 0x1)),
    (0x1E03A, (0x14D5, 0x1)),
    (0x0FCB5, (0xBF1, 0x2)),
    (0x1D4D7, (0x11B2, 0x1)),
    (0x03145, (0x450, 0x1)),
    (0x0FC98, (0xBB3, 0x3)),
    (0x1D539, (0x120F, 0x1)),
    (0x1EE72, (0x1558, 0x1)),
    (0x001F2, (0x03A, 0x2)),
    (0x1D51E, (0x11F4, 0x1)),
    (0x024A0, (0x2D1, 0x3)),
    (0x0FB56, (0x9BF, 0x1)),
    (0x024BD, (0x31A, 0x1)),
    (0x0FFB7, (0x105F, 0x1)),
    (0x1D77D, (0x144A, 0x1)),
    (0x0217E, (0x21D, 0x1)),
    (0x1D43E, (0x1125, 0x1)),
    (0x033D3, (0x90E, 0x2)),
    (0x0FE7D, (0xF0C, 0x2)),
    (0x000AA, (0x003, 0x1)),
    (0x0309B, (0x434, 0x2)),
    (0x01D4A, (0x0A4, 0x1)),
    (0x1EE52, (0x1544, 0x1)),
    (0x032A6, (0x607, 0x1)),
    (0x1EE7C, (0x1560, 0x1)),
    (0x0332F, (0x745, 0x4)),
    (0x01D46, (0x0A0, 0x1)),
    (0x1D792, (0x145F, 0x1)),
    (0x1D593, (0x1262, 0x1)),
    (0x032BB, (0x626, 0x2)),
    (0x03343, (0x794, 0x4)),
    (0x02FD4, (0x42D, 0x1)),
    (0x0FCD2, (0xC2B, 0x2)),
    (0x1D66B, (0x133A, 0x1)),
    (0x107AE, (0x10B7, 0x1)),
    (0x0FC3C, (0xAEE, 0x2)),
    (0x1D656, (0x1325, 0x1)),
    (0x02464, (0x230, 0x1)),
    (0x02105, (0x176, 0x3)),
    (0x0FB5C, (0x9C5, 0x1)),
    (0x0FE47, (0xECF, 0x1)),
    (0x0329A, (0x5FB, 0x1)),
    (0x1EE42, (0x153C, 0x1)),
    (0x01D3D, (0x097, 0x1)),
    (0x033D8, (0x91A, 0x4)),
    (0x1D666, (0x1335, 0x1)),
    (0x03358, (0x7E2, 0x2)),
    (0x0FB6C, (0x9D5, 0x1)),
    (0x1D5A8, (0x1277, 0x1)),
    (0x02F7E, (0x3D7, 0x1)),
    (0x0FF3D, (0xFE5, 0x1)),
    (0x033FD, (0x97D, 0x3)),
    (0x0FD70, (0xD68, 0x3)),
    (0x032A9, (0x60A, 0x1)),
    (0x02F2B, (0x384, 0x1)),
    (0x1D48B, (0x1171, 0x1)),
    (0x02081, (0x150, 0x1)),
    (0x0FE9D, (0xF3B, 0x1)),
    (0x00F79, (0x084, 0x3)),
    (0x0329E, (0x5FF, 0x1)),
    (0x0247F, (0x26E, 0x4)),
    (0x01D52, (0x0AB, 0x1)),
    (0x02F5D, (0x3B6, 0x1)),
    (0x02133, (0x19F, 0x1)),
    (0x0FEAB, (0xF49, 0x1)),
    (0x1D463, (0x1149, 0x1)),
    (0x0FBE7, (0xA34, 0x1)),
    (0x000BD, (0x012, 0x3)),
    (0x0329C, (0x5FD, 0x1)),
    (0x01D5E, (0x0B7, 0x1)),
    (0x0FC3A, (0xAEA, 0x2)),
    (0x002E3, (0x056, 0x1)),
    (0x1D675, (0x1344, 0x1)),
    (0x03354, (0x7D2, 0x5)),
    (0x1D5E3, (0x12B2, 0x1)),
    (0x0FE8B, (0xF27, 0x2)),
    (0x0FF77, (0x101F, 0x1)),
    (0x032B7, (0x61E, 0x2)),
    (0x0FD65, (0xD47, 0x3)),
    (0x03203, (0x4B1, 0x3)),
    (0x1D54B, (0x121B, 0x1)),
    (0x024CD, (0x32A, 0x1)),
    (0x002DA, (0x04B, 0x2)),
    (0x1D62B, (0x12FA, 0x1)),
    (0x1EE82, (0x1564, 0x1)),
    (0x1E04C, (0x14E7, 0x1)),
    (0x0248B, (0x298, 0x2)),
    (0x0FB62, (0x9CB, 0x1)),
    (0x1F212, (0x1639, 0x1)),
    (0x1D7FC, (0x14C7, 0x1)),
    (0x0FFA2, (0x104A, 0x1)),
    (0x0FC96, (0xBAE, 0x2)),
    (0x0FCED, (0xC63, 0x2)),
    (0x0FBA9, (0xA14, 0x1)),
    (0x1D5A2, (0x1271, 0x1)),
    (0x0FF9E, (0x1046, 0x1)),
    (0x0FB5A, (0x9C3, 0x1)),
    (0x024A4, (0x2DD, 0x3)),
    (0x1D4B2, (0x1190, 0x1)),
    (0x1EE11, (0x1519, 0x1)),
    (0x0FCC8, (0xC17, 0x2)),
    (0x03250, (0x58B, 0x3)),
    (0x1D421, (0x1108, 0x1)),
    (0x1D7E7, (0x14B2, 0x1)),
    (0x033F3, (0x95F, 0x3)),
    (0x107AC, (0x10B5, 0x1)),
    (0x033A9, (0x8A9, 0x2)),
    (0x1EE9B, (0x157C, 0x1)),
    (0x02F77, (0x3D0, 0x1)),
    (0x0FF20, (0xFC8, 0x1)),
    (0x02089, (0x158, 0x1)),
    (0x0FE5B, (0xEE6, 0x1)),
    (0x0FCA3, (0xBCD, 0x2)),
    (0x1D6B7, (0x1384, 0x1)),
    (0x0FE76, (0xEFE, 0x2)),
    (0x0FE59, (0xEE4, 0x1)),
    (0x1D6D4, (0x13A1, 0x1)),
    (0x02F6B, (0x3C4, 0x1)),
    (0x1EE1F, (0x1527, 0x1)),
    (0x1D74E, (0x141B, 0x1)),
    (0x0FFD4, (0x1075, 0x1)),
    (0x001C5, (0x026, 0x3)),
    (0x01D2D, (0x089, 0x1)),
    (0x02F35, (0x38E, 0x1)),
    (0x1F104, (0x159E, 0x2)),
    (0x0FBF4, (0xA55, 0x3)),
    (0x1D411, (0x10F8, 0x1)),
    (0x1D42E, (0x1115, 0x1)),
    (0x01FEE, (0x10C, 0x3)),
    (0x0FC54, (0xB1E, 0x2)),
    (0x1F22F, (0x1657, 0x1)),
    (0x1D5E2, (0x12B1, 0x1)),
    (0x1D60F, (0x12DE, 0x1)),
    (0x0FC6F, (0xB60, 0x2)),
    (0x1D476, (0x115C, 0x1)),
    (0x033CA, (0x8FB, 0x2)),
    (0x02FCE, (0x427, 0x1)),
    (0x1D59A, (0x1269, 0x1)),
    (0x02175, (0x20A, 0x2)),
    (0x1D6D0, (0x139D, 0x1)),
    (0x02150, (0x1B3, 0x3)),
    (0x1D7AE, (0x147B, 0x1)),
    (0x1D6CB, (0x1398, 0x1)),
    (0x0FC02, (0xA77, 0x3)),
    (0x0FFC5, (0x106A, 0x1)),
    (0x1D76A, (0x1437, 0x1)),
    (0x0FE69, (0xEF3, 0x1)),
    (0x0326C, (0x5B8, 0x1)),
    (0x0FE89, (0xF23, 0x2)),
    (0x02FBB, (0x414, 0x1)),
    (0x1D514, (0x11EC, 0x1)),
    (0x03036, (0x430, 0x1)),
    (0x0FD97, (0xDD7, 0x3)),
    (0x0FC11, (0xA98, 0x2)),
    (0x02F44, (0x39D, 0x1)),
    (0x0FBD3, (0xA1F, 0x1)),
    (0x0FFCD, (0x1070, 0x1)),
    (0x0FD88, (0xDB0, 0x3)),
    (0x1D507, (0x11E1, 0x1)),
    (0x0FF02, (0xFAA, 0x1)),
    (0x1EEB3, (0x158D, 0x1)),
    (0x1D7D6, (0x14A1, 0x1)),
    (0x032BD, (0x62A, 0x2)),
    (0x1D603, (0x12D2, 0x1)),
    (0x0FC4C, (0xB0E, 0x2)),
    (0x0FCC5, (0xC11, 0x2)),
    (0x02F8E, (0x3E7, 0x1)),
    (0x0FFAD, (0x1055, 0x1)),
    (0x0FD68, (0xD50, 0x3)),
    (0x1D435, (0x111C, 0x1)),
    (0x0FE4E, (0xEDA, 0x1)),
    (0x0318D, (0x498, 0x1)),
    (0x1D75F, (0x142C, 0x1)),
    (0x032C9, (0x642, 0x3)),
    (0x0313A, (0x445, 0x1)),
    (0x1D7A4, (0x1471, 0x1)),
    (0x1F117, (0x15C1, 0x3)),
    (0x033C7, (0x8F4, 0x3)),
    (0x1D6E5, (0x13B2, 0x1)),
    (0x03207, (0x4BD, 0x3)),
    (0x1D614, (0x12E3, 0x1)),
    (0x1D571, (0x1240, 0x1)),
    (0x1D6F7, (0x13C4, 0x1)),
    (0x1D52F, (0x1205, 0x1)),
    (0x032FE, (0x683, 0x1)),
    (0x0FDC6, (0xE64, 0x3)),
    (0x1EE29, (0x152C, 0x1)),
    (0x1D5EA, (0x12B9, 0x1)),
    (0x002DB, (0x04D, 0x2)),
    (0x0FCCB, (0xC1D, 0x2)),
    (0x02137, (0x1A3, 0x1)),
    (0x0FCA6, (0xBD3, 0x2)),
    (0x02166, (0x1EE, 0x3)),
    (0x033BC, (0x8DA, 0x2)),
    (0x0FBD9, (0xA25, 0x1)),
    (0x02FA9, (0x402, 0x1)),
    (0x03206, (0x4BA, 0x3)),
    (0x0FBE2, (0xA2F, 0x1)),
    (0x1CCED, (0x10DA, 0x1)),
    (0x0FCD4, (0xC2F, 0x2)),
    (0x1EEA9, (0x1584, 0x1)),
    (0x01D6A, (0x0C3, 0x1)),
    (0x1E05E, (0x14F9, 0x1)),
    (0x1D64D, (0x131C, 0x1)),
    (0x1D504, (0x11DF, 0x1)),
    (0x0FBAC, (0xA17, 0x1)),
    (0x01D35, (0x090, 0x1)),
    (0x0FC25, (0xAC0, 0x2)),
    (0x002B5, (0x043, 0x1)),
    (0x0FC8F, (0xBA0, 0x2)),
    (0x1D79A, (0x1467, 0x1)),
    (0x003D4, (0x064, 0x2)),
    (0x03392, (0x86F, 0x3)),
    (0x02486, (0x28A, 0x4)),
    (0x02F1F, (0x378, 0x1)),
    (0x03313, (0x6D1, 0x6)),
    (0x1D4C7, (0x11A2, 0x1)),
    (0x0325E, (0x5A8, 0x2)),
    (0x03238, (0x563, 0x3)),
    (0x0FD32, (0xCF0, 0x2)),
    (0x0FF53, (0xFFB, 0x1)),
    (0x0FE66, (0xEF1, 0x1)),
    (0x0AB5C, (0x98E, 0x1)),
    (0x024D7, (0x334, 0x1)),
    (0x10783, (0x108D, 0x1)),
    (0x024B2, (0x307, 0x3)),
    (0x02487, (0x28E, 0x4)),
    (0x0FF6F, (0x1017, 0x1)),
    (0x0FC63, (0xB41, 0x3)),
    (0x0FD6D, (0xD5F, 0x3)),
    (0x02110, (0x185, 0x1)),
    (0x0FBA8, (0xA13, 0x1)),
    (0x1F251, (0x1680, 0x1)),
    (0x0FBED, (0xA40, 0x3)),
    (0x033BE, (0x8DE, 0x2)),
    (0x0FB05, (0x99F, 0x2)),
    (0x0FC99, (0xBB6, 0x3)),
    (0x1EE15, (0x151D, 0x1)),
    (0x1EE13, (0x151B, 0x1)),
    (0x024A1, (0x2D4, 0x3)),
    (0x033DE, (0x929, 0x3)),
    (0x1D5B9, (0x1288, 0x1)),
    (0x1D690, (0x135F, 0x1)),
    (0x01D2C, (0x088, 0x1)),
    (0x0FB90, (0x9F9, 0x1)),
    (0x1D42D, (0x1114, 0x1)),
    (0x024C2, (0x31F, 0x1)),
    (0x1D4FF, (0x11DA, 0x1)),
    (0x01DBC, (0x0E6, 0x1)),
    (0x0FCB7, (0xBF5, 0x2)),
    (0x0FC67, (0xB4D, 0x3)),
    (0x000B3, (0x007, 0x1)),
    (0x0FC2F, (0xAD4, 0x2)),
    (0x03345, (0x79B, 0x3)),
    (0x01FFD, (0x10F, 0x2)),
    (0x1D7EC, (0x14B7, 0x1)),
    (0x033A7, (0x8A2, 0x3)),
    (0x1D51F, (0x11F5, 0x1)),
    (0x032CC, (0x64B, 0x2)),
    (0x02130, (0x19D, 0x1)),
    (0x0FF5F, (0x1007, 0x1)),
    (0x02174, (0x209, 0x1)),
    (0x0337E, (0x841, 0x2)),
    (0x1D523, (0x11F9, 0x1)),
    (0x0207C, (0x14B, 0x1)),
    (0x033D5, (0x912, 0x3)),
    (0x1D65C, (0x132B, 0x1)),
    (0x024A9, (0x2EC, 0x3)),
    (0x0FD9F, (0xDEF, 0x3)),
    (0x1D762, (0x142F, 0x1)),
    (0x03154, (0x45F, 0x1)),
    (0x0215F, (0x1E1, 0x2)),
    (0x0FF4A, (0xFF2, 0x1)),
    (0x1D477, (0x115D, 0x1)),
    (0x1D400, (0x10E7, 0x1)),
    (0x1D525, (0x11FB, 0x1)),
    (0x03255, (0x596, 0x2)),
    (0x1F111, (0x15AF, 0x3)),
    (0x0FF8E, (0x1036, 0x1)),
    (0x1D709, (0x13D6, 0x1)),
    (0x1E06A, (0x1505, 0x1)),
    (0x1D4E9, (0x11C4, 0x1)),
    (0x1CCE9, (0x10D6, 0x1)),
    (0x003F9, (0x06D, 0x1)),
    (0x0FE3A, (0xEC4, 0x1)),
    (0x03259, (0x59E, 0x2)),
    (0x1D6A5, (0x1374, 0x1)),
    (0x02F02, (0x35B, 0x1)),
    (0x0FD01, (0xC8E, 0x2)),
    (0x0325B, (0x5A2, 0x2)),
    (0x02008, (0x11B, 0x1)),
    (0x0FD8F, (0xDC5, 0x3)),
    (0x1D7DC, (0x14A7, 0x1)),
    (0x1D447, (0x112E, 0x1)),
    (0x02086, (0x155, 0x1)),
    (0x1D492, (0x1178, 0x1)),
    (0x1D70B, (0x13D8, 0x1)),
    (0x1D5FC, (0x12CB, 0x1)),
    (0x0FE81, (0xF13, 0x2)),
    (0x0FB86, (0x9EF, 0x1)),
    (0x0FD30, (0xCEC, 0x2)),
    (0x02F3A, (0x393, 0x1)),
    (0x1D5BB, (0x128A, 0x1)),
    (0x0FC9D, (0xBC1, 0x2)),
    (0x0FC3E, (0xAF2, 0x2)),
    (0x0FE7B, (0xF08, 0x2)),
    (0x0FFAF, (0x1057, 0x1)),
    (0x0FF57, (0xFFF, 0x1)),
    (0x0FBFE, (0xA6F, 0x1)),
    (0x1D59F, (0x126E, 0x1)),
    (0x1D646, (0x1315, 0x1)),
    (0x0FBF0, (0xA49, 0x3)),
    (0x0315A, (0x465, 0x1)),
    (0x0FEA6, (0xF44, 0x1)),
    (0x0FCE6, (0xC55, 0x2)),
    (0x1D554, (0x1223, 0x1)),
    (0x1D791, (0x145E, 0x1)),
    (0x02F1D, (0x376, 0x1)),
    (0x03363, (0x7F9, 0x3)),
    (0x0FC60, (0xB38, 0x3)),
    (0x03268, (0x5B4, 0x1)),
    (0x1D695, (0x1364, 0x1)),
    (0x0FF29, (0xFD1, 0x1)),
    (0x0FE57, (0xEE2, 0x1)),
    (0x02F47, (0x3A0, 0x1)),
    (0x0210F, (0x184, 0x1)),
    (0x01D55, (0x0AE, 0x1)),
    (0x1D4EF, (0x11CA, 0x1)),
    (0x033B2, (0x8C6, 0x2)),
    (0x024D2, (0x32F, 0x1)),
    (0x1E049, (0x14E4, 0x1)),
    (0x02F32, (0x38B, 0x1)),
    (0x1CCF4, (0x10E1, 0x1)),
    (0x1EE85, (0x1567, 0x1)),
    (0x02F4D, (0x3A6, 0x1)),
    (0x0FF84, (0x102C, 0x1)),
    (0x1F114, (0x15B8, 0x3)),
    (0x0FD7F, (0xD95, 0x3)),
    (0x0314D, (0x458, 0x1)),
    (0x01D62, (0x0BB, 0x1)),
    (0x1D697, (0x1366, 0x1)),
    (0x1F102, (0x159A, 0x2)),
    (0x0333F, (0x787, 0x2)),
    (0x02138, (0x1A4, 0x1)),
    (0x1D54A, (0x121A, 0x1)),
    (0x0FB7F, (0x9E8, 0x1)),
    (0x0FB06, (0x9A1, 0x2)),
    (0x0FD24, (0xCD4, 0x2)),
    (0x1D66A, (0x1339, 0x1)),
    (0x0FC53, (0xB1C, 0x2)),
    (0x1D45E, (0x1144, 0x1)),
    (0x1D76E, (0x143B, 0x1)),
    (0x03378, (0x833, 0x3)),
    (0x1D61F, (0x12EE, 0x1)),
    (0x1D7A6, (0x1473, 0x1)),
    (0x1D7C7, (0x1494, 0x1)),
    (0x0FF2F, (0xFD7, 0x1)),
    (0x0FC1D, (0xAB0, 0x2)),
    (0x1D65B, (0x132A, 0x1)),
    (0x0213B, (0x1A6, 0x3)),
    (0x1D6BA, (0x1387, 0x1)),
    (0x0333C, (0x77A, 0x4)),
    (0x002B4, (0x042, 0x1)),
    (0x0FD26, (0xCD8, 0x2)),
    (0x0FF25, (0xFCD, 0x1)),
    (0x0217A, (0x216, 0x2)),
    (0x0FC13, (0xA9C, 0x2)),
    (0x1D54E, (0x121E, 0x1)),
    (0x00678, (0x076, 0x2)),
    (0x1D7E8, (0x14B3, 0x1)),
    (0x1D6D1, (0x139E, 0x1)),
    (0x03274, (0x5C6, 0x2)),
    (0x032E3, (0x668, 0x1)),
    (0x1D6FF, (0x13CC, 0x1)),
    (0x1D58A, (0x1259, 0x1)),
    (0x0FDBB, (0xE43, 0x3)),
    (0x1E04F, (0x14EA, 0x1)),
    (0x0FD09, (0xC9E, 0x2)),
    (0x024DD, (0x33A, 0x1)),
    (0x0FCE4, (0xC51, 0x2)),
    (0x1D47C, (0x1162, 0x1)),
    (0x0AB5F, (0x991, 0x1)),
    (0x0FF98, (0x1040, 0x1)),
    (0x0FBF7, (0xA5E, 0x3)),
    (0x03187, (0x492, 0x1)),
    (0x0FF37, (0xFDF, 0x1)),
    (0x02FA1, (0x3FA, 0x1)),
    (0x0FB9E, (0xA07, 0x1)),
    (0x03237, (0x560, 0x3)),
    (0x0FCE7, (0xC57, 0x2)),
    (0x1CCDC, (0x10C9, 0x1)),
    (0x1D755, (0x1422, 0x1)),
    (0x02011, (0x11E, 0x1)),
    (0x1EEB7, (0x1591, 0x1)),
    (0x0FC46, (0xB02, 0x2)),
    (0x033DB, (0x923, 0x2)),
    (0x0334B, (0x7B2, 0x3)),
    (0x0339A, (0x882, 0x2)),
    (0x0FE83, (0xF17, 0x2)),
    (0x0FEC8, (0xF66, 0x1)),
    (0x0FFDA, (0x1079, 0x1)),
    (0x01D38, (0x093, 0x1)),
    (0x0FBE8, (0xA35, 0x1)),
    (0x1D55C, (0x122B, 0x1)),
    (0x024A2, (0x2D7, 0x3)),
    (0x1F131, (0x1604, 0x1)),
    (0x0FFE2, (0x107E, 0x1)),
    (0x0303A, (0x433, 0x1)),
    (0x0FD35, (0xCF6, 0x2)),
    (0x03301, (0x68B, 0x4)),
    (0x1FBF0, (0x1681, 0x1)),
    (0x002DC, (0x04F, 0x2)),
    (0x0FE85, (0xF1B, 0x2)),
    (0x01D3A, (0x095, 0x1)),
    (0x0FC17, (0xAA4, 0x2)),
    (0x1FBF7, (0x1688, 0x1)),
    (0x0FB66, (0x9CF, 0x1)),
    (0x1EEA3, (0x157F, 0x1)),
    (0x0FD04, (0xC94, 0x2)),
    (0x0323E, (0x575, 0x3)),
    (0x0328D, (0x5EE, 0x1)),
    (0x1D7BD, (0x148A, 0x1)),
    (0x1D6C0, (0x138D, 0x1)),
    (0x03328, (0x728, 0x2)),
    (0x1D602, (0x12D1, 0x1)),
    (0x1D607, (0x12D6, 0x1)),
    (0x1F125, (0x15EB, 0x3)),
    (0x02468, (0x234, 0x1)),
    (0x0FE11, (0xEAE, 0x1)),
    (0x02098, (0x166, 0x1)),
    (0x0FD98, (0xDDA, 0x3)),
    (0x0FC6E, (0xB5E, 0x2)),
    (0x1CCF1, (0x10DE, 0x1)),
    (0x03310, (0x6C5, 0x4)),
    (0x1D530, (0x1206, 0x1)),
    (0x02179, (0x215, 0x1)),
    (0x00F77, (0x081, 0x3)),
    (0x1D7B7, (0x1484, 0x1)),
    (0x033EB, (0x947, 0x3)),
    (0x0326D, (0x5B9, 0x1)),
    (0x03372, (0x826, 0x2)),
    (0x0FBD4, (0xA20, 0x1)),
    (0x1D550, (0x1220, 0x1)),
    (0x03144, (0x44F, 0x1)),
    (0x002B8, (0x046, 0x1)),
    (0x1D725, (0x13F2, 0x1)),
    (0x1EE32, (0x1535, 0x1)),
    (0x02131, (0x19E, 0x1)),
    (0x033C5, (0x8EE, 0x2)),
    (0x1CCE5, (0x10D2, 0x1)),
    (0x0FE51, (0xEDD, 0x1)),
    (0x0334E, (0x7BE, 0x4)),
    (0x10785, (0x108F, 0x1)),
    (0x1D427, (0x110E, 0x1)),
    (0x1D6F4, (0x13C1, 0x1)),
    (0x02075, (0x144, 0x1)),
    (0x1D660, (0x132F, 0x1)),
    (0x0FF5E, (0x1006, 0x1)),
    (0x0FC0B, (0xA8C, 0x2)),
    (0x0FD37, (0xCFA, 0x2)),
    (0x02F03, (0x35C, 0x1)),
    (0x024B7, (0x314, 0x1)),
    (0x02F43, (0x39C, 0x1)),
    (0x0FD1D, (0xCC6, 0x2)),
    (0x03142, (0x44D, 0x1)),
    (0x0247D, (0x266, 0x4)),
    (0x0FF3E, (0xFE6, 0x1)),
    (0x1D776, (0x1443, 0x1)),
    (0x01D9F, (0x0C9, 0x1)),
    (0x1EE16, (0x151E, 0x1)),
    (0x1D6BD, (0x138A, 0x1)),
    (0x02F46, (0x39F, 0x1)),
    (0x0FF7A, (0x1022, 0x1)),
    (0x0FEBC, (0xF5A, 0x1)),
    (0x0FF59, (0x1001, 0x1)),
    (0x1D665, (0x1334, 0x1)),
    (0x1F12C, (0x15FE, 0x1)),
    (0x02F59, (0x3B2, 0x1)),
    (0x1D7B9, (0x1486, 0x1)),
    (0x0321B, (0x506, 0x4)),
    (0x0FFD2, (0x1073, 0x1)),
    (0x02F2A, (0x383, 0x1)),
    (0x002E1, (0x054, 0x1)),
    (0x0FC68, (0xB50, 0x3)),
    (0x1F128, (0x15F4, 0x3)),
    (0x02003, (0x116, 0x1)),
    (0x0FEC4, (0xF62, 0x1)),
    (0x0FD75, (0xD77, 0x3)),
    (0x02F12, (0x36B, 0x1)),
    (0x1D6B9, (0x1386, 0x1)),
    (0x0FD17, (0xCBA, 0x2)),
    (0x0FDB1, (0xE25, 0x3)),
    (0x0330D, (0x6B9, 0x4)),
    (0x02F9D, (0x3F6, 0x1)),
    (0x0FF43, (0xFEB, 0x1)),
    (0x032B4, (0x618, 0x2)),
    (0x1D72D, (0x13FA, 0x1)),
    (0x1D669, (0x1338, 0x1)),
    (0x0FE87, (0xF1F, 0x2)),
    (0x1EE92, (0x1573, 0x1)),
    (0x000A0, (0x000, 0x1)),
    (0x1F140, (0x1613, 0x1)),
    (0x1D685, (0x1354, 0x1)),
    (0x02087, (0x156, 0x1)),
    (0x1D6E9, (0x13B6, 0x1)),
    (0x1D75D, (0x142A, 0x1)),
    (0x02F40, (0x399, 0x1)),
    (0x0FD5B, (0xD29, 0x3)),
    (0x0FCBC, (0xBFF, 0x2)),
    (0x02097, (0x165, 0x1)),
    (0x033F6, (0x968, 0x3)),
    (0x1D794, (0x1461, 0x1)),
    (0x1D44D, (0x1134, 0x1)),
    (0x1D6EF, (0x13BC, 0x1)),
    (0x0FE70, (0xEF6, 0x2)),
    (0x0FCFE, (0xC88, 0x2)),
    (0x1D448, (0x112F, 0x1)),
    (0x0FC92, (0xBA6, 0x2)),
    (0x1D40B, (0x10F2, 0x1)),
    (0x02161, (0x1E4, 0x2)),
    (0x02047, (0x136, 0x2)),
    (0x1D7F6, (0x14C1, 0x1)),
    (0x1D691, (0x1360, 0x1)),
    (0x1F11E, (0x15D6, 0x3)),
    (0x0FD55, (0xD17, 0x3)),
    (0x0FEE4, (0xF82, 0x1)),
    (0x1D69A, (0x1369, 0x1)),
    (0x032D2, (0x657, 0x1)),
    (0x0FFEC, (0x1088, 0x1)),
    (0x0FF1B, (0xFC3, 0x1)),
    (0x03266, (0x5B2, 0x1)),
    (0x1E056, (0x14F1, 0x1)),
    (0x0FE10, (0xEAD, 0x1)),
    (0x03388, (0x857, 0x3)),
    (0x1EE97, (0x1578, 0x1)),
    (0x03173, (0x47E, 0x1)),
    (0x1D583, (0x1252, 0x1)),
    (0x1FBF9, (0x168A, 0x1)),
    (0x0FE4D, (0xED9, 0x1)),
    (0x024DE, (0x33B, 0x1)),
    (0x1D543, (0x1217, 0x1)),
    (0x1D57D, (0x124C, 0x1)),
    (0x0FF7F, (0x1027, 0x1)),
    (0x1F240, (0x1664, 0x3)),
    (0x1D534, (0x120A, 0x1)),
    (0x0FD23, (0xCD2, 0x2)),
    (0x0FF45, (0xFED, 0x1)),
    (0x033AD, (0x8B4, 0x3)),
    (0x1D618, (0x12E7, 0x1)),
    (0x0FC6D, (0xB5C, 0x2)),
    (0x000A8, (0x001, 0x2)),
    (0x0FB77, (0x9E0, 0x1)),
    (0x0FEFA, (0xFA2, 0x3)),
    (0x1EE5D, (0x1549, 0x1)),
    (0x032EA, (0x66F, 0x1)),
    (0x02F23, (0x37C, 0x1)),
    (0x01DAB, (0x0D5, 0x1)),
    (0x00EDC, (0x07C, 0x2)),
    (0x0FE97, (0xF35, 0x1)),
    (0x0FCB4, (0xBEF, 0x2)),
    (0x02FA5, (0x3FE, 0x1)),
    (0x1D438, (0x111F, 0x1)),
    (0x03195, (0x49D, 0x1)),
    (0x1D727, (0x13F4, 0x1)),
    (0x1D662, (0x1331, 0x1)),
    (0x1D70E, (0x13DB, 0x1)),
    (0x1D417, (0x10FE, 0x1)),
    (0x1D436, (0x111D, 0x1)),
    (0x0FC1A, (0xAAA, 0x2)),
    (0x1D7DB, (0x14A6, 0x1)),
    (0x1D6FB, (0x13C8, 0x1)),
    (0x0FEF6, (0xF96, 0x3)),
    (0x03193, (0x49B, 0x1)),
    (0x10787, (0x1090, 0x1)),
    (0x1E053, (0x14EE, 0x1)),
    (0x1D651, (0x1320, 0x1)),
    (0x1E046, (0x14E1, 0x1)),
    (0x0FE3F, (0xEC9, 0x1)),
    (0x0FF49, (0xFF1, 0x1)),
    (0x02026, (0x124, 0x3)),
    (0x033E7, (0x93D, 0x2)),
    (0x0211C, (0x18F, 0x1)),
    (0x02F58, (0x3B1, 0x1)),
    (0x1D5FF, (0x12CE, 0x1)),
    (0x0FE9B, (0xF39, 0x1)),
    (0x0FD2F, (0xCEA, 0x2)),
    (0x0FF09, (0xFB1, 0x1)),
    (0x1D61A, (0x12E9, 0x1)),
    (0x1D7AB, (0x1478, 0x1)),
    (0x1D5A4, (0x1273, 0x1)),
    (0x0328B, (0x5EC, 0x1)),
    (0x1D4C3, (0x119F, 0x1)),
    (0x1CCE6, (0x10D3, 0x1)),
    (0x0FF0E, (0xFB6, 0x1)),
    (0x00677, (0x074, 0x2)),
    (0x02F00, (0x359, 0x1)),
    (0x0248D, (0x29C, 0x2)),
    (0x0FD27, (0xCDA, 0x2)),
    (0x01DB6, (0x0E0, 0x1)),
    (0x0326A, (0x5B6, 0x1)),
    (0x1D566, (0x1235, 0x1)),
    (0x024C7, (0x324, 0x1)),
    (0x032FF, (0x684, 0x2)),
    (0x10797, (0x10A0, 0x1)),
    (0x024A5, (0x2E0, 0x3)),
    (0x0FE30, (0xEB9, 0x2)),
    (0x1D437, (0x111E, 0x1)),
    (0x0FF0F, (0xFB7, 0x1)),
    (0x0FC58, (0xB26, 0x2)),
    (0x1D7A7, (0x1474, 0x1)),
    (0x0215C, (0x1D8, 0x3)),
    (0x0FDA3, (0xDFB, 0x3)),
    (0x1D516, (0x11ED, 0x1)),
    (0x02F8A, (0x3E3, 0x1)),
    (0x0FD0F, (0xCAA, 0x2)),
    (0x1D403, (0x10EA, 0x1)),
    (0x1D413, (0x10FA, 0x1)),
    (0x03262, (0x5AE, 0x1)),
    (0x1EE0A, (0x1512, 0x1)),
    (0x0FFB1, (0x1059, 0x1)),
    (0x1F22B, (0x1653, 0x1)),
    (0x1D703, (0x13D0, 0x1)),
    (0x02F6E, (0x3C7, 0x1)),
    (0x024EA, (0x347, 0x1)),
    (0x1D73D, (0x140A, 0x1)),
    (0x0FCDA, (0xC3B, 0x2)),
    (0x02F49, (0x3A2, 0x1)),
    (0x03148, (0x453, 0x1)),
    (0x0FC0D, (0xA90, 0x2)),
    (0x02F93, (0x3EC, 0x1)),
    (0x033AA, (0x8AB, 0x3)),
    (0x02F27, (0x380, 0x1)),
    (0x032E8, (0x66D, 0x1)),
    (0x1FBF8, (0x1689, 0x1)),
    (0x1F101, (0x1598, 0x2)),
    (0x1D462, (0x1148, 0x1)),
    (0x1D749, (0x1416, 0x1)),
    (0x1D7A9, (0x1476, 0x1)),
    (0x1D57F, (0x124E, 0x1)),
    (0x03132, (0x43D, 0x1)),
    (0x0FF6C, (0x1014, 0x1)),
    (0x0FD9C, (0xDE6, 0x3)),
    (0x03192, (0x49A, 0x1)),
    (0x02FC2, (0x41B, 0x1)),
    (0x1D799, (0x1466, 0x1)),
    (0x0213C, (0x1A9, 0x1)),
    (0x1E06D, (0x1508, 0x1)),
    (0x1D4E7, (0x11C2, 0x1)),
    (0x0FB15, (0x9A7, 0x2)),
    (0x02FBC, (0x415, 0x1)),
    (0x024E0, (0x33D, 0x1)),
    (0x03209, (0x4C3, 0x3)),
    (0x033EA, (0x944, 0x3)),
    (0x0FC6C, (0xB5A, 0x2)),
    (0x02FAC, (0x405, 0x1)),
    (0x1F202, (0x1636, 0x1)),
    (0x0FBF3, (0xA52, 0x3)),
    (0x0327B, (0x5D4, 0x2)),
    (0x02F38, (0x391, 0x1)),
    (0x02F2E, (0x387, 0x1)),
    (0x00F0C, (0x080, 0x1)),
    (0x0FDAB, (0xE13, 0x3)),
    (0x1EE64, (0x154D, 0x1)),
    (0x0FC3B, (0xAEC, 0x2)),
    (0x1EE6E, (0x1554, 0x1)),
    (0x1D63E, (0x130D, 0x1)),
    (0x1D47D, (0x1163, 0x1)),
    (0x0FF28, (0xFD0, 0x1)),
    (0x0FCF4, (0xC73, 0x3)),
    (0x0FC9E, (0xBC3, 0x2)),
    (0x1D7AC, (0x1479, 0x1)),
    (0x1D7FD, (0x14C8, 0x1)),
    (0x0FB01, (0x995, 0x2)),
    (0x0FDAE, (0xE1C, 0x3)),
    (0x0316B, (0x476, 0x1)),
    (0x1D63C, (0x130B, 0x1)),
    (0x0FDB7, (0xE37, 0x3)),
    (0x1D66D, (0x133C, 0x1)),
    (0x03334, (0x759, 0x6)),
    (0x0FC6A, (0xB56, 0x2)),
    (0x1EE62, (0x154C, 0x1)),
    (0x0338D, (0x864, 0x2)),
    (0x033AC, (0x8B1, 0x3)),
    (0x0330E, (0x6BD, 0x4)),
    (0x0FE82, (0xF15, 0x2)),
    (0x03333, (0x755, 0x4)),
    (0x0246C, (0x23B, 0x2)),
    (0x1D73A, (0x1407, 0x1)),
    (0x0FC87, (0xB90, 0x2)),
    (0x1E066, (0x1501, 0x1)),
    (0x0FD00, (0xC8C, 0x2)),
    (0x03291, (0x5F2, 0x1)),
    (0x1D732, (0x13FF, 0x1)),
    (0x0216B, (0x1FA, 0x3)),
    (0x02FB6, (0x40F, 0x1)),
    (0x024E7, (0x344, 0x1)),
    (0x02FC0, (0x419, 0x1)),
    (0x033F9, (0x971, 0x3)),
    (0x0FC9F, (0xBC5, 0x2)),
    (0x03188, (0x493, 0x1)),
    (0x0FD79, (0xD83, 0x3)),
    (0x03229, (0x536, 0x3)),
    (0x1D4C5, (0x11A0, 0x1)),
    (0x024B5, (0x310, 0x3)),
    (0x1D591, (0x1260, 0x1)),
    (0x03163, (0x46E, 0x1)),
    (0x033DD, (0x927, 0x2)),
    (0x032C3, (0x636, 0x2)),
    (0x01DA9, (0x0D3, 0x1)),
    (0x0FC4B, (0xB0C, 0x2)),
    (0x0FBE9, (0xA36, 0x1)),
    (0x1D71F, (0x13EC, 0x1)),
    (0x0334C, (0x7B5, 0x5)),
    (0x10793, (0x109C, 0x1)),
    (0x02F56, (0x3AF, 0x1)),
    (0x1D4D1, (0x11AC, 0x1)),
    (0x0FB53, (0x9BC, 0x1)),
    (0x00EB3, (0x07A, 0x2)),
    (0x02F11, (0x36A, 0x1)),
    (0x0FB89, (0x9F2, 0x1)),
    (0x03201, (0x4AB, 0x3)),
    (0x0FD82, (0xD9E, 0x3)),
    (0x1D503, (0x11DE, 0x1)),
    (0x0FEC5, (0xF63, 0x1)),
    (0x1D486, (0x116C, 0x1)),
    (0x1D753, (0x1420, 0x1)),
    (0x0FF3F, (0xFE7, 0x1)),
    (0x03349, (0x7AA, 0x2)),
    (0x1D5F7, (0x12C6, 0x1)),
    (0x1D599, (0x1268, 0x1)),
    (0x1D558, (0x1227, 0x1)),
    (0x1D5B8, (0x1287, 0x1)),
    (0x02F07, (0x360, 0x1)),
    (0x03381, (0x849, 0x2)),
    (0x0FC47, (0xB04, 0x2)),
    (0x0330C, (0x6B5, 0x4)),
    (0x02169, (0x1F7, 0x1)),
    (0x03285, (0x5E6, 0x1)),
    (0x1D612, (0x12E1, 0x1)),
    (0x0FB55, (0x9BE, 0x1)),
    (0x1D68B, (0x135A, 0x1)),
    (0x1D798, (0x1465, 0x1)),
    (0x033F0, (0x956, 0x3)),
    (0x0FEBA, (0xF58, 0x1)),
    (0x1D4B1, (0x118F, 0x1)),
    (0x0FF99, (0x1041, 0x1)),
    (0x02159, (0x1CF, 0x3)),
    (0x0FF39, (0xFE1, 0x1)),
    (0x1D5F0, (0x12BF, 0x1)),
    (0x1D480, (0x1166, 0x1)),
    (0x0FEEB, (0xF89, 0x1)),
    (0x1EE8E, (0x156F, 0x1)),
    (0x02128, (0x199, 0x1)),
    (0x1E036, (0x14D1, 0x1)),
    (0x0FEFB, (0xFA5, 0x2)),
    (0x1D6DB, (0x13A8, 0x1)),
    (0x1D6EA, (0x13B7, 0x1)),
    (0x0FEC6, (0xF64, 0x1)),
    (0x1EE6C, (0x1552, 0x1)),
    (0x024C1, (0x31E, 0x1)),
    (0x1D6B3, (0x1380, 0x1)),
    (0x1D713, (0x13E0, 0x1)),
    (0x0FE8C, (0xF29, 0x2)),
    (0x0FCC2, (0xC0B, 0x2)),
    (0x024E5, (0x342, 0x1)),
    (0x0FCC7, (0xC15, 0x2)),
    (0x00133, (0x01A, 0x2)),
    (0x1D640, (0x130F, 0x1)),
    (0x0FFCB, (0x106E, 0x1)),
    (0x0FDAD, (0xE19, 0x3)),
    (0x1D57E, (0x124D, 0x1)),
    (0x1D757, (0x1424, 0x1)),
    (0x032D3, (0x658, 0x1)),
    (0x02F76, (0x3CF, 0x1)),
    (0x02465, (0x231, 0x1)),
    (0x1EE1C, (0x1524, 0x1)),
    (0x032D5, (0x65A, 0x1)),
    (0x0FD73, (0xD71, 0x3)),
    (0x0FBB0, (0xA1B, 0x2)),
    (0x02F66, (0x3BF, 0x1)),
    (0x1D5F6, (0x12C5, 0x1)),
    (0x0FEBB, (0xF59, 0x1)),
    (0x002B1, (0x03F, 0x1)),
    (0x1EE2E, (0x1531, 0x1)),
    (0x02071, (0x142, 0x1)),
    (0x0FDFB, (0xEA1, 0x8)),
    (0x0FC81, (0xB84, 0x2)),
    (0x0FEEF, (0xF8D, 0x1)),
    (0x02173, (0x207, 0x2)),
    (0x1EEA6, (0x1581, 0x1)),
    (0x02478, (0x257, 0x3)),
    (0x1D6F8, (0x13C5, 0x1)),
    (0x1EEAD, (0x1587, 0x1)),
    (0x1D5BC, (0x128B, 0x1)),
    (0x1D6AE, (0x137B, 0x1)),
    (0x0FEDF, (0xF7D, 0x1)),
    (0x1D5BE, (0x128D, 0x1)),
    (0x1D672, (0x1341, 0x1)),
    (0x0FD25, (0xCD6, 0x2)),
    (0x01DBA, (0x0E4, 0x1)),
    (0x02463, (0x22F, 0x1)),
    (0x0FCE2, (0xC4D, 0x2)),
    (0x0215B, (0x1D5, 0x3)),
    (0x1D7F9, (0x14C4, 0x1)),
    (0x032D7, (0x65C, 0x1)),
    (0x1D4AF, (0x118D, 0x1)),
    (0x02F91, (0x3EA, 0x1)),
    (0x0246B, (0x239, 0x2)),
    (0x107AD, (0x10B6, 0x1)),
    (0x003D1, (0x060, 0x1)),
    (0x0FFCC, (0x106F, 0x1)),
    (0x0FD9E, (0xDEC, 0x3)),
    (0x02115, (0x189, 0x1)),
    (0x1D715, (0x13E2, 0x1)),
    (0x1D5DB, (0x12AA, 0x1)),
    (0x1D774, (0x1441, 0x1)),
    (0x0FC61, (0xB3B, 0x3)),
    (0x1D401, (0x10E8, 0x1)),
    (0x03309, (0x6AC, 0x3)),
    (0x1EE68, (0x154F, 0x1)),
    (0x1EE49, (0x153E, 0x1)),
    (0x02119, (0x18C, 0x1)),
    (0x0FB82, (0x9EB, 0x1)),
    (0x1D642, (0x1311, 0x1)),
    (0x0FC97, (0xBB0, 0x3)),
    (0x107B7, (0x10BF, 0x1)),
    (0x0FB9A, (0xA03, 0x1)),
    (0x0FFC6, (0x106B, 0x1)),
    (0x03265, (0x5B1, 0x1)),
    (0x0333A, (0x771, 0x4)),
    (0x1D61D, (0x12EC, 0x1)),
    (0x02F53, (0x3AC, 0x1)),
    (0x02082, (0x151, 0x1)),
    (0x1D734, (0x1401, 0x1)),
    (0x02106, (0x179, 0x3)),
    (0x10792, (0x109B, 0x1)),
    (0x1D61B, (0x12EA, 0x1)),
    (0x1D513, (0x11EB, 0x1)),
    (0x0FFA1, (0x1049, 0x1)),
    (0x0FE12, (0xEAF, 0x1)),
    (0x0FDA2, (0xDF8, 0x3)),
    (0x0FC91, (0xBA4, 0x2)),
    (0x01FED, (0x109, 0x3)),
    (0x1D5DF, (0x12AE, 0x1)),
    (0x032F8, (0x67D, 0x1)),
    (0x02FB2, (0x40B, 0x1)),
    (0x032C4, (0x638, 0x2)),
    (0x03158, (0x463, 0x1)),
    (0x1D6D3, (0x13A0, 0x1)),
    (0x0FB84, (0x9ED, 0x1)),
    (0x024CA, (0x327, 0x1)),
    (0x03208, (0x4C0, 0x3)),
    (0x032FC, (0x681, 0x1)),
    (0x0FE94, (0xF32, 0x1)),
    (0x02157, (0x1C9, 0x3)),
    (0x03357, (0x7DF, 0x3)),
    (0x0320A, (0x4C6, 0x3)),
    (0x024DA, (0x337, 0x1)),
    (0x0FDC2, (0xE58, 0x3)),
    (0x1D617, (0x12E6, 0x1)),
    (0x1D5E1, (0x12B0, 0x1)),
    (0x1D570, (0x123F, 0x1)),
    (0x0327E, (0x5DF, 0x2)),
    (0x01FDD, (0x100, 0x3)),
    (0x0FD5D, (0xD2F, 0x3)),
    (0x02F83, (0x3DC, 0x1)),
    (0x0FFE4, (0x1081, 0x1)),
    (0x0FD87, (0xDAD, 0x3)),
    (0x024D1, (0x32E, 0x1)),
    (0x00384, (0x05A, 0x2)),
    (0x024D6, (0x333, 0x1)),
    (0x1EE47, (0x153D, 0x1)),
    (0x003D3, (0x062, 0x2)),
    (0x032F7, (0x67C, 0x1)),
    (0x1D609, (0x12D8, 0x1)),
    (0x024AC, (0x2F5, 0x3)),
    (0x02F39, (0x392, 0x1)),
    (0x0FBD7, (0xA23, 0x1)),
    (0x0FB6F, (0x9D8, 0x1)),
    (0x0FD13, (0xCB2, 0x2)),
    (0x0320F, (0x4D6, 0x4)),
    (0x0FCEE, (0xC65, 0x2)),
    (0x1D52D, (0x1203, 0x1)),
    (0x1D62E, (0x12FD, 0x1)),
    (0x02FAD, (0x406, 0x1)),
    (0x1D414, (0x10FB, 0x1)),
    (0x0FE84, (0xF19, 0x2)),
    (0x1D76D, (0x143A, 0x1)),
    (0x1F223, (0x164B, 0x1)),
    (0x02F87, (0x3E0, 0x1)),
    (0x02FD2, (0x42B, 0x1)),
    (0x0FF95, (0x103D, 0x1)),
    (0x1EE02, (0x150B, 0x1)),
    (0x02471, (0x245, 0x2)),
    (0x1D714, (0x13E1, 0x1)),
    (0x1D718, (0x13E5, 0x1)),
    (0x0FFCE, (0x1071, 0x1)),
    (0x002B0, (0x03E, 0x1)),
    (0x1EE57, (0x1546, 0x1)),
    (0x01DB1, (0x0DB, 0x1)),
    (0x0FBE3, (0xA30, 0x1)),
    (0x1E058, (0x14F3, 0x1)),
    (0x03153, (0x45E, 0x1)),
    (0x0FF52, (0xFFA, 0x1)),
    (0x03243, (0x584, 0x3)),
    (0x03226, (0x52D, 0x3)),
    (0x0FB6A, (0x9D3, 0x1)),
    (0x1EE74, (0x1559, 0x1)),
    (0x032DC, (0x661, 0x1)),
    (0x0FC03, (0xA7A, 0x3)),
    (0x01E9B, (0x0EC, 0x2)),
    (0x0FDA7, (0xE07, 0x3)),
    (0x0FD15, (0xCB6, 0x2)),
    (0x0FC01, (0xA74, 0x3)),
    (0x0FC7C, (0xB7A, 0x2)),
    (0x03341, (0x78E, 0x3)),
    (0x03324, (0x71C, 0x4)),
    (0x02FA8, (0x401, 0x1)),
    (0x02F3E, (0x397, 0x1)),
    (0x0FF9C, (0x1044, 0x1)),
    (0x0FB20, (0x9AD, 0x1)),
    (0x02F0D, (0x366, 0x1)),
    (0x1D5EB, (0x12BA, 0x1)),
    (0x1D59C, (0x126B, 0x1)),
    (0x0017F, (0x022, 0x1)),
    (0x1D79E, (0x146B, 0x1)),
    (0x1EE14, (0x151C, 0x1)),
    (0x0FD8C, (0xDBC, 0x3)),
    (0x0FCBD, (0xC01, 0x2)),
    (0x1F221, (0x1649, 0x1)),
    (0x02049, (0x13A, 0x2)),
    (0x1D4D9, (0x11B4, 0x1)),
    (0x0FDAA, (0xE10, 0x3)),
    (0x0320E, (0x4D2, 0x4)),
    (0x1EE39, (0x153A, 0x1)),
    (0x1D72A, (0x13F7, 0x1)),
    (0x032AF, (0x610, 0x1)),
    (0x0FB8E, (0x9F7, 0x1)),
    (0x02077, (0x146, 0x1)),
    (0x1D4A6, (0x1187, 0x1)),
    (0x02F70, (0x3C9, 0x1)),
    (0x03368, (0x808, 0x3)),
    (0x0FB6D, (0x9D6, 0x1)),
    (0x02F5C, (0x3B5, 0x1)),
    (0x03134, (0x43F, 0x1)),
    (0x024B6, (0x313, 0x1)),
    (0x1D630, (0x12FF, 0x1)),
    (0x033CC, (0x8FF, 0x2)),
    (0x0FB92, (0x9FB, 0x1)),
    (0x024D4, (0x331, 0x1)),
    (0x1D46A, (0x1150, 0x1)),
    (0x0FF30, (0xFD8, 0x1)),
    (0x0FC08, (0xA86, 0x2)),
    (0x0FFB2, (0x105A, 0x1)),
    (0x033FF, (0x983, 0x3)),
    (0x0217B, (0x218, 0x3)),
    (0x0FEDE, (0xF7C, 0x1)),
    (0x02004, (0x117, 0x1)),
    (0x0FCD1, (0xC29, 0x2)),
    (0x0207D, (0x14C, 0x1)),
    (0x0FB94, (0x9FD, 0x1)),
    (0x02078, (0x147, 0x1)),
    (0x1D4DE, (0x11B9, 0x1)),
    (0x0FC06, (0xA82, 0x2)),
    (0x1D5AB, (0x127A, 0x1)),
    (0x1D6EB, (0x13B8, 0x1)),
    (0x0FF79, (0x1021, 0x1)),
    (0x1D705, (0x13D2, 0x1)),
    (0x02462, (0x22E, 0x1)),
    (0x0FCA1, (0xBC9, 0x2)),
    (0x0FC28, (0xAC6, 0x2)),
    (0x1D77E, (0x144B, 0x1)),
    (0x0FEE6, (0xF84, 0x1)),
    (0x1F127, (0x15F1, 0x3)),
    (0x1D580, (0x124F, 0x1)),
    (0x1EE4F, (0x1542, 0x1)),
    (0x1D619, (0x12E8, 0x1)),
    (0x0323B, (0x56C, 0x3)),
    (0x001C8, (0x02E, 0x2)),
    (0x1F21C, (0x1644, 0x1)),
    (0x1FBF2, (0x1683, 0x1)),
    (0x0FB26, (0x9B3, 0x1)),
    (0x1E03B, (0x14D6, 0x1)),
    (0x0FDB8, (0xE3A, 0x3)),
    (0x1D54F, (0x121F, 0x1)),
    (0x1D564, (0x1233, 0x1)),
    (0x1D7EB, (0x14B6, 0x1)),
    (0x1E050, (0x14EB, 0x1)),
    (0x1D5D8, (0x12A7, 0x1)),
    (0x1D4F0, (0x11CB, 0x1)),
    (0x0FFD3, (0x1074, 0x1)),
    (0x032DE, (0x663, 0x1)),
    (0x1D574, (0x1243, 0x1)),
    (0x002E4, (0x057, 0x1)),
    (0x1D59E, (0x126D, 0x1)),
    (0x0FF74, (0x101C, 0x1)),
    (0x0215E, (0x1DE, 0x3)),
    (0x0FD34, (0xCF4, 0x2)),
    (0x0FF2A, (0xFD2, 0x1)),
    (0x0FF15, (0xFBD, 0x1)),
    (0x1D50D, (0x11E5, 0x1)),
    (0x0FC21, (0xAB8, 0x2)),
    (0x0FF4F, (0xFF7, 0x1)),
    (0x0FEA1, (0xF3F, 0x1)),
    (0x1D60D, (0x12DC, 0x1)),
    (0x0FF3A, (0xFE2, 0x1)),
    (0x1EE12, (0x151A, 0x1)),
    (0x03318, (0x6EA, 0x4)),
    (0x0FE7C, (0xF0A, 0x2)),
    (0x0FCAB, (0xBDD, 0x2)),
    (0x03205, (0x4B7, 0x3)),
    (0x001F1, (0x038, 0x2)),
    (0x0FE42, (0xECC, 0x1)),
    (0x0FE91, (0xF2F, 0x1)),
    (0x001C7, (0x02C, 0x2)),
    (0x1D681, (0x1350, 0x1)),
    (0x1D6DE, (0x13AB, 0x1)),
    (0x1D4B0, (0x118E, 0x1)),
    (0x1D742, (0x140F, 0x1)),
    (0x1D67F, (0x134E, 0x1)),
    (0x1D645, (0x1314, 0x1)),
    (0x0FEB0, (0xF4E, 0x1)),
    (0x1F121, (0x15DF, 0x3)),
    (0x1D611, (0x12E0, 0x1)),
    (0x1D752, (0x141F, 0x1)),
    (0x0FE32, (0xEBC, 0x1)),
    (0x0FF81, (0x1029, 0x1)),
    (0x02009, (0x11C, 0x1)),
    (0x1F14C, (0x1621, 0x2)),
    (0x0FEDB, (0xF79, 0x1)),
    (0x1D5D0, (0x129F, 0x1)),
    (0x0FCFA, (0xC80, 0x2)),
    (0x03296, (0x5F7, 0x1)),
    (0x1D71A, (0x13E7, 0x1)),
    (0x107A6, (0x10AF, 0x1)),
    (0x1D5AC, (0x127B, 0x1)),
    (0x0FD93, (0xDCB, 0x3)),
    (0x1EE8B, (0x156C, 0x1)),
    (0x0FECB, (0xF69, 0x1)),
    (0x1D7A3, (0x1470, 0x1)),
    (0x02F96, (0x3EF, 0x1)),
    (0x1EE4E, (0x1541, 0x1)),
    (0x024CF, (0x32C, 0x1)),
    (0x032AA, (0x60B, 0x1)),
    (0x1EE88, (0x156A, 0x1)),
    (0x03270, (0x5BE, 0x2)),
    (0x0FCEB, (0xC5F, 0x2)),
    (0x032E0, (0x665, 0x1)),
    (0x1D587, (0x1256, 0x1)),
    (0x1CCEC, (0x10D9, 0x1)),
    (0x1D7C8, (0x1495, 0x1)),
    (0x0FEB2, (0xF50, 0x1)),
    (0x03379, (0x836, 0x3)),
    (0x1D688, (0x1357, 0x1)),
    (0x107B2, (0x10BA, 0x1)),
    (0x033C8, (0x8F7, 0x2)),
    (0x1D620, (0x12EF, 0x1)),
    (0x0FC3D, (0xAF0, 0x2)),
    (0x0FDA9, (0xE0D, 0x3)),
    (0x1F246, (0x1676, 0x3)),
    (0x0FEF9, (0xF9F, 0x3)),
    (0x02160, (0x1E3, 0x1)),
    (0x1D72F, (0x13FC, 0x1)),
    (0x0FC73, (0xB68, 0x2)),
    (0x02481, (0x276, 0x4)),
    (0x1D528, (0x11FE, 0x1)),
    (0x0327D, (0x5DB, 0x4)),
    (0x0FB60, (0x9C9, 0x1)),
    (0x033B3, (0x8C8, 0x2)),
    (0x02F37, (0x390, 0x1)),
    (0x1D54D, (0x121D, 0x1)),
    (0x0FC33, (0xADC, 0x2)),
    (0x032B3, (0x616, 0x2)),
    (0x1D41B, (0x1102, 0x1)),
    (0x1D475, (0x115B, 0x1)),
    (0x0216D, (0x1FE, 0x1)),
    (0x0FEB4, (0xF52, 0x1)),
    (0x1D41D, (0x1104, 0x1)),
    (0x1EE0C, (0x1514, 0x1)),
    (0x0FEB6, (0xF54, 0x1)),
    (0x1E05D, (0x14F8, 0x1)),
    (0x0FF26, (0xFCE, 0x1)),
    (0x1D592, (0x1261, 0x1)),
    (0x0212F, (0x19C, 0x1)),
    (0x0FC18, (0xAA6, 0x2)),
    (0x0FDF3, (0xE74, 0x4)),
    (0x033F1, (0x959, 0x3)),
    (0x0FCB6, (0xBF3, 0x2)),
    (0x032B9, (0x622, 0x2)),
    (0x0FB79, (0x9E2, 0x1)),
    (0x1D4B6, (0x1194, 0x1)),
    (0x0FEF0, (0xF8E, 0x1)),
    (0x033B7, (0x8D0, 0x2)),
    (0x0FB7B, (0x9E4, 0x1)),
    (0x1D55A, (0x1229, 0x1)),
    (0x0FCB1, (0xBE9, 0x2)),
    (0x02472, (0x247, 0x2)),
    (0x0321C, (0x50A, 0x4)),
    (0x002B2, (0x040, 0x1)),
    (0x02F0E, (0x367, 0x1)),
    (0x0FF89, (0x1031, 0x1)),
    (0x1D6F5, (0x13C2, 0x1)),
];
pub(crate) const CJK_COMPAT_VARIANTS_DECOMPOSED_CHARS: &[char] = &[
    '\u{349E}',
    '\u{FE00}',
    '\u{34B9}',
    '\u{FE00}',
    '\u{34BB}',
    '\u{FE00}',
    '\u{34DF}',
    '\u{FE00}',
    '\u{3515}',
    '\u{FE00}',
    '\u{36EE}',
    '\u{FE00}',
    '\u{36FC}',
    '\u{FE00}',
    '\u{3781}',
    '\u{FE00}',
    '\u{382F}',
    '\u{FE00}',
    '\u{3862}',
    '\u{FE00}',
    '\u{387C}',
    '\u{FE00}',
    '\u{38C7}',
    '\u{FE00}',
    '\u{38E3}',
    '\u{FE00}',
    '\u{391C}',
    '\u{FE00}',
    '\u{393A}',
    '\u{FE00}',
    '\u{3A2E}',
    '\u{FE00}',
    '\u{3A6C}',
    '\u{FE00}',
    '\u{3AE4}',
    '\u{FE00}',
    '\u{3B08}',
    '\u{FE00}',
    '\u{3B19}',
    '\u{FE00}',
    '\u{3B49}',
    '\u{FE00}',
    '\u{3B9D}',
    '\u{FE00}',
    '\u{3B9D}',
    '\u{FE01}',
    '\u{3C18}',
    '\u{FE00}',
    '\u{3C4E}',
    '\u{FE00}',
    '\u{3D33}',
    '\u{FE00}',
    '\u{3D96}',
    '\u{FE00}',
    '\u{3EAC}',
    '\u{FE00}',
    '\u{3EB8}',
    '\u{FE00}',
    '\u{3EB8}',
    '\u{FE01}',
    '\u{3F1B}',
    '\u{FE00}',
    '\u{3FFC}',
    '\u{FE00}',
    '\u{4008}',
    '\u{FE00}',
    '\u{4018}',
    '\u{FE00}',
    '\u{4039}',
    '\u{FE00}',
    '\u{4039}',
    '\u{FE01}',
    '\u{4046}',
    '\u{FE00}',
    '\u{4096}',
    '\u{FE00}',
    '\u{40E3}',
    '\u{FE00}',
    '\u{412F}',
    '\u{FE00}',
    '\u{4202}',
    '\u{FE00}',
    '\u{4227}',
    '\u{FE00}',
    '\u{42A0}',
    '\u{FE00}',
    '\u{4301}',
    '\u{FE00}',
    '\u{4334}',
    '\u{FE00}',
    '\u{4359}',
    '\u{FE00}',
    '\u{43D5}',
    '\u{FE00}',
    '\u{43D9}',
    '\u{FE00}',
    '\u{440B}',
    '\u{FE00}',
    '\u{446B}',
    '\u{FE00}',
    '\u{452B}',
    '\u{FE00}',
    '\u{455D}',
    '\u{FE00}',
    '\u{4561}',
    '\u{FE00}',
    '\u{456B}',
    '\u{FE00}',
    '\u{45D7}',
    '\u{FE00}',
    '\u{45F9}',
    '\u{FE00}',
    '\u{4635}',
    '\u{FE00}',
    '\u{46BE}',
    '\u{FE00}',
    '\u{46C7}',
    '\u{FE00}',
    '\u{4995}',
    '\u{FE00}',
    '\u{49E6}',
    '\u{FE00}',
    '\u{4A6E}',
    '\u{FE00}',
    '\u{4A76}',
    '\u{FE00}',
    '\u{4AB2}',
    '\u{FE00}',
    '\u{4B33}',
    '\u{FE00}',
    '\u{4BCE}',
    '\u{FE00}',
    '\u{4CCE}',
    '\u{FE00}',
    '\u{4CED}',
    '\u{FE00}',
    '\u{4CF8}',
    '\u{FE00}',
    '\u{4D56}',
    '\u{FE00}',
    '\u{4E0D}',
    '\u{FE00}',
    '\u{4E26}',
    '\u{FE00}',
    '\u{4E32}',
    '\u{FE00}',
    '\u{4E38}',
    '\u{FE00}',
    '\u{4E39}',
    '\u{FE00}',
    '\u{4E3D}',
    '\u{FE00}',
    '\u{4E41}',
    '\u{FE00}',
    '\u{4E82}',
    '\u{FE00}',
    '\u{4E86}',
    '\u{FE00}',
    '\u{4EAE}',
    '\u{FE00}',
    '\u{4EC0}',
    '\u{FE00}',
    '\u{4ECC}',
    '\u{FE00}',
    '\u{4EE4}',
    '\u{FE00}',
    '\u{4F60}',
    '\u{FE00}',
    '\u{4F80}',
    '\u{FE00}',
    '\u{4F86}',
    '\u{FE00}',
    '\u{4F8B}',
    '\u{FE00}',
    '\u{4FAE}',
    '\u{FE00}',
    '\u{4FAE}',
    '\u{FE01}',
    '\u{4FBB}',
    '\u{FE00}',
    '\u{4FBF}',
    '\u{FE00}',
    '\u{5002}',
    '\u{FE00}',
    '\u{502B}',
    '\u{FE00}',
    '\u{507A}',
    '\u{FE00}',
    '\u{5099}',
    '\u{FE00}',
    '\u{50CF}',
    '\u{FE00}',
    '\u{50DA}',
    '\u{FE00}',
    '\u{50E7}',
    '\u{FE00}',
    '\u{50E7}',
    '\u{FE01}',
    '\u{5140}',
    '\u{FE00}',
    '\u{5145}',
    '\u{FE00}',
    '\u{514D}',
    '\u{FE00}',
    '\u{514D}',
    '\u{FE01}',
    '\u{5154}',
    '\u{FE00}',
    '\u{5164}',
    '\u{FE00}',
    '\u{5167}',
    '\u{FE00}',
    '\u{5168}',
    '\u{FE00}',
    '\u{5169}',
    '\u{FE00}',
    '\u{516D}',
    '\u{FE00}',
    '\u{5177}',
    '\u{FE00}',
    '\u{5180}',
    '\u{FE00}',
    '\u{518D}',
    '\u{FE00}',
    '\u{5192}',
    '\u{FE00}',
    '\u{5195}',
    '\u{FE00}',
    '\u{5197}',
    '\u{FE00}',
    '\u{51A4}',
    '\u{FE00}',
    '\u{51AC}',
    '\u{FE00}',
    '\u{51B5}',
    '\u{FE00}',
    '\u{51B5}',
    '\u{FE01}',
    '\u{51B7}',
    '\u{FE00}',
    '\u{51C9}',
    '\u{FE00}',
    '\u{51CC}',
    '\u{FE00}',
    '\u{51DC}',
    '\u{FE00}',
    '\u{51DE}',
    '\u{FE00}',
    '\u{51F5}',
    '\u{FE00}',
    '\u{5203}',
    '\u{FE00}',
    '\u{5207}',
    '\u{FE00}',
    '\u{5207}',
    '\u{FE01}',
    '\u{5217}',
    '\u{FE00}',
    '\u{5229}',
    '\u{FE00}',
    '\u{523A}',
    '\u{FE00}',
    '\u{523B}',
    '\u{FE00}',
    '\u{5246}',
    '\u{FE00}',
    '\u{5272}',
    '\u{FE00}',
    '\u{5277}',
    '\u{FE00}',
    '\u{5289}',
    '\u{FE00}',
    '\u{529B}',
    '\u{FE00}',
    '\u{52A3}',
    '\u{FE00}',
    '\u{52B3}',
    '\u{FE00}',
    '\u{52C7}',
    '\u{FE00}',
    '\u{52C7}',
    '\u{FE01}',
    '\u{52C9}',
    '\u{FE00}',
    '\u{52C9}',
    '\u{FE01}',
    '\u{52D2}',
    '\u{FE00}',
    '\u{52DE}',
    '\u{FE00}',
    '\u{52E4}',
    '\u{FE00}',
    '\u{52E4}',
    '\u{FE01}',
    '\u{52F5}',
    '\u{FE00}',
    '\u{52FA}',
    '\u{FE00}',
    '\u{52FA}',
    '\u{FE01}',
    '\u{5305}',
    '\u{FE00}',
    '\u{5306}',
    '\u{FE00}',
    '\u{5317}',
    '\u{FE00}',
    '\u{5317}',
    '\u{FE01}',
    '\u{533F}',
    '\u{FE00}',
    '\u{5349}',
    '\u{FE00}',
    '\u{5351}',
    '\u{FE00}',
    '\u{5351}',
    '\u{FE01}',
    '\u{535A}',
    '\u{FE00}',
    '\u{5373}',
    '\u{FE00}',
    '\u{5375}',
    '\u{FE00}',
    '\u{537D}',
    '\u{FE00}',
    '\u{537F}',
    '\u{FE00}',
    '\u{537F}',
    '\u{FE01}',
    '\u{537F}',
    '\u{FE02}',
    '\u{53C3}',
    '\u{FE00}',
    '\u{53CA}',
    '\u{FE00}',
    '\u{53DF}',
    '\u{FE00}',
    '\u{53E5}',
    '\u{FE00}',
    '\u{53EB}',
    '\u{FE00}',
    '\u{53F1}',
    '\u{FE00}',
    '\u{5406}',
    '\u{FE00}',
    '\u{540F}',
    '\u{FE00}',
    '\u{541D}',
    '\u{FE00}',
    '\u{5438}',
    '\u{FE00}',
    '\u{5442}',
    '\u{FE00}',
    '\u{5448}',
    '\u{FE00}',
    '\u{5468}',
    '\u{FE00}',
    '\u{549E}',
    '\u{FE00}',
    '\u{54A2}',
    '\u{FE00}',
    '\u{54BD}',
    '\u{FE00}',
    '\u{54F6}',
    '\u{FE00}',
    '\u{5510}',
    '\u{FE00}',
    '\u{5553}',
    '\u{FE00}',
    '\u{5555}',
    '\u{FE00}',
    '\u{5563}',
    '\u{FE00}',
    '\u{5584}',
    '\u{FE00}',
    '\u{5584}',
    '\u{FE01}',
    '\u{5587}',
    '\u{FE00}',
    '\u{5599}',
    '\u{FE00}',
    '\u{5599}',
    '\u{FE01}',
    '\u{559D}',
    '\u{FE00}',
    '\u{559D}',
    '\u{FE01}',
    '\u{55AB}',
    '\u{FE00}',
    '\u{55B3}',
    '\u{FE00}',
    '\u{55C0}',
    '\u{FE00}',
    '\u{55C2}',
    '\u{FE00}',
    '\u{55E2}',
    '\u{FE00}',
    '\u{5606}',
    '\u{FE00}',
    '\u{5606}',
    '\u{FE01}',
    '\u{5651}',
    '\u{FE00}',
    '\u{5668}',
    '\u{FE00}',
    '\u{5674}',
    '\u{FE00}',
    '\u{56F9}',
    '\u{FE00}',
    '\u{5716}',
    '\u{FE00}',
    '\u{5717}',
    '\u{FE00}',
    '\u{578B}',
    '\u{FE00}',
    '\u{57CE}',
    '\u{FE00}',
    '\u{57F4}',
    '\u{FE00}',
    '\u{580D}',
    '\u{FE00}',
    '\u{5831}',
    '\u{FE00}',
    '\u{5832}',
    '\u{FE00}',
    '\u{5840}',
    '\u{FE00}',
    '\u{585A}',
    '\u{FE00}',
    '\u{585A}',
    '\u{FE01}',
    '\u{585E}',
    '\u{FE00}',
    '\u{58A8}',
    '\u{FE00}',
    '\u{58AC}',
    '\u{FE00}',
    '\u{58B3}',
    '\u{FE00}',
    '\u{58D8}',
    '\u{FE00}',
    '\u{58DF}',
    '\u{FE00}',
    '\u{58EE}',
    '\u{FE00}',
    '\u{58F2}',
    '\u{FE00}',
    '\u{58F7}',
    '\u{FE00}',
    '\u{5906}',
    '\u{FE00}',
    '\u{591A}',
    '\u{FE00}',
    '\u{5922}',
    '\u{FE00}',
    '\u{5944}',
    '\u{FE00}',
    '\u{5948}',
    '\u{FE00}',
    '\u{5951}',
    '\u{FE00}',
    '\u{5954}',
    '\u{FE00}',
    '\u{5962}',
    '\u{FE00}',
    '\u{5973}',
    '\u{FE00}',
    '\u{59D8}',
    '\u{FE00}',
    '\u{59EC}',
    '\u{FE00}',
    '\u{5A1B}',
    '\u{FE00}',
    '\u{5A27}',
    '\u{FE00}',
    '\u{5A62}',
    '\u{FE00}',
    '\u{5A66}',
    '\u{FE00}',
    '\u{5AB5}',
    '\u{FE00}',
    '\u{5B08}',
    '\u{FE00}',
    '\u{5B28}',
    '\u{FE00}',
    '\u{5B3E}',
    '\u{FE00}',
    '\u{5B3E}',
    '\u{FE01}',
    '\u{5B85}',
    '\u{FE00}',
    '\u{5BC3}',
    '\u{FE00}',
    '\u{5BD8}',
    '\u{FE00}',
    '\u{5BE7}',
    '\u{FE00}',
    '\u{5BE7}',
    '\u{FE01}',
    '\u{5BE7}',
    '\u{FE02}',
    '\u{5BEE}',
    '\u{FE00}',
    '\u{5BF3}',
    '\u{FE00}',
    '\u{5BFF}',
    '\u{FE00}',
    '\u{5C06}',
    '\u{FE00}',
    '\u{5C22}',
    '\u{FE00}',
    '\u{5C3F}',
    '\u{FE00}',
    '\u{5C60}',
    '\u{FE00}',
    '\u{5C62}',
    '\u{FE00}',
    '\u{5C64}',
    '\u{FE00}',
    '\u{5C65}',
    '\u{FE00}',
    '\u{5C6E}',
    '\u{FE00}',
    '\u{5C6E}',
    '\u{FE01}',
    '\u{5C8D}',
    '\u{FE00}',
    '\u{5CC0}',
    '\u{FE00}',
    '\u{5D19}',
    '\u{FE00}',
    '\u{5D43}',
    '\u{FE00}',
    '\u{5D50}',
    '\u{FE00}',
    '\u{5D6B}',
    '\u{FE00}',
    '\u{5D6E}',
    '\u{FE00}',
    '\u{5D7C}',
    '\u{FE00}',
    '\u{5DB2}',
    '\u{FE00}',
    '\u{5DBA}',
    '\u{FE00}',
    '\u{5DE1}',
    '\u{FE00}',
    '\u{5DE2}',
    '\u{FE00}',
    '\u{5DFD}',
    '\u{FE00}',
    '\u{5E28}',
    '\u{FE00}',
    '\u{5E3D}',
    '\u{FE00}',
    '\u{5E69}',
    '\u{FE00}',
    '\u{5E74}',
    '\u{FE00}',
    '\u{5EA6}',
    '\u{FE00}',
    '\u{5EB0}',
    '\u{FE00}',
    '\u{5EB3}',
    '\u{FE00}',
    '\u{5EB6}',
    '\u{FE00}',
    '\u{5EC9}',
    '\u{FE00}',
    '\u{5ECA}',
    '\u{FE00}',
    '\u{5ECA}',
    '\u{FE01}',
    '\u{5ED2}',
    '\u{FE00}',
    '\u{5ED3}',
    '\u{FE00}',
    '\u{5ED9}',
    '\u{FE00}',
    '\u{5EEC}',
    '\u{FE00}',
    '\u{5EFE}',
    '\u{FE00}',
    '\u{5F04}',
    '\u{FE00}',
    '\u{5F22}',
    '\u{FE00}',
    '\u{5F22}',
    '\u{FE01}',
    '\u{5F53}',
    '\u{FE00}',
    '\u{5F62}',
    '\u{FE00}',
    '\u{5F69}',
    '\u{FE00}',
    '\u{5F6B}',
    '\u{FE00}',
    '\u{5F8B}',
    '\u{FE00}',
    '\u{5F9A}',
    '\u{FE00}',
    '\u{5FA9}',
    '\u{FE00}',
    '\u{5FAD}',
    '\u{FE00}',
    '\u{5FCD}',
    '\u{FE00}',
    '\u{5FD7}',
    '\u{FE00}',
    '\u{5FF5}',
    '\u{FE00}',
    '\u{5FF9}',
    '\u{FE00}',
    '\u{6012}',
    '\u{FE00}',
    '\u{601C}',
    '\u{FE00}',
    '\u{6075}',
    '\u{FE00}',
    '\u{6081}',
    '\u{FE00}',
    '\u{6094}',
    '\u{FE00}',
    '\u{6094}',
    '\u{FE01}',
    '\u{60C7}',
    '\u{FE00}',
    '\u{60D8}',
    '\u{FE00}',
    '\u{60E1}',
    '\u{FE00}',
    '\u{6108}',
    '\u{FE00}',
    '\u{6144}',
    '\u{FE00}',
    '\u{6148}',
    '\u{FE00}',
    '\u{614C}',
    '\u{FE00}',
    '\u{614C}',
    '\u{FE01}',
    '\u{614E}',
    '\u{FE00}',
    '\u{614E}',
    '\u{FE01}',
    '\u{6160}',
    '\u{FE00}',
    '\u{6168}',
    '\u{FE00}',
    '\u{617A}',
    '\u{FE00}',
    '\u{618E}',
    '\u{FE00}',
    '\u{618E}',
    '\u{FE01}',
    '\u{618E}',
    '\u{FE02}',
    '\u{6190}',
    '\u{FE00}',
    '\u{61A4}',
    '\u{FE00}',
    '\u{61AF}',
    '\u{FE00}',
    '\u{61B2}',
    '\u{FE00}',
    '\u{61DE}',
    '\u{FE00}',
    '\u{61F2}',
    '\u{FE00}',
    '\u{61F2}',
    '\u{FE01}',
    '\u{61F2}',
    '\u{FE02}',
    '\u{61F6}',
    '\u{FE00}',
    '\u{61F6}',
    '\u{FE01}',
    '\u{6200}',
    '\u{FE00}',
    '\u{6210}',
    '\u{FE00}',
    '\u{621B}',
    '\u{FE00}',
    '\u{622E}',
    '\u{FE00}',
    '\u{6234}',
    '\u{FE00}',
    '\u{625D}',
    '\u{FE00}',
    '\u{62B1}',
    '\u{FE00}',
    '\u{62C9}',
    '\u{FE00}',
    '\u{62CF}',
    '\u{FE00}',
    '\u{62D3}',
    '\u{FE00}',
    '\u{62D4}',
    '\u{FE00}',
    '\u{62FC}',
    '\u{FE00}',
    '\u{62FE}',
    '\u{FE00}',
    '\u{633D}',
    '\u{FE00}',
    '\u{6350}',
    '\u{FE00}',
    '\u{6368}',
    '\u{FE00}',
    '\u{637B}',
    '\u{FE00}',
    '\u{6383}',
    '\u{FE00}',
    '\u{63A0}',
    '\u{FE00}',
    '\u{63A9}',
    '\u{FE00}',
    '\u{63C4}',
    '\u{FE00}',
    '\u{63C5}',
    '\u{FE00}',
    '\u{63E4}',
    '\u{FE00}',
    '\u{641C}',
    '\u{FE00}',
    '\u{6422}',
    '\u{FE00}',
    '\u{6452}',
    '\u{FE00}',
    '\u{6469}',
    '\u{FE00}',
    '\u{6477}',
    '\u{FE00}',
    '\u{647E}',
    '\u{FE00}',
    '\u{649A}',
    '\u{FE00}',
    '\u{649D}',
    '\u{FE00}',
    '\u{64C4}',
    '\u{FE00}',
    '\u{654F}',
    '\u{FE00}',
    '\u{654F}',
    '\u{FE01}',
    '\u{6556}',
    '\u{FE00}',
    '\u{656C}',
    '\u{FE00}',
    '\u{6578}',
    '\u{FE00}',
    '\u{6599}',
    '\u{FE00}',
    '\u{65C5}',
    '\u{FE00}',
    '\u{65E2}',
    '\u{FE00}',
    '\u{65E3}',
    '\u{FE00}',
    '\u{6613}',
    '\u{FE00}',
    '\u{6649}',
    '\u{FE00}',
    '\u{6674}',
    '\u{FE00}',
    '\u{6674}',
    '\u{FE01}',
    '\u{6688}',
    '\u{FE00}',
    '\u{6691}',
    '\u{FE00}',
    '\u{6691}',
    '\u{FE01}',
    '\u{669C}',
    '\u{FE00}',
    '\u{66B4}',
    '\u{FE00}',
    '\u{66C6}',
    '\u{FE00}',
    '\u{66F4}',
    '\u{FE00}',
    '\u{66F8}',
    '\u{FE00}',
    '\u{6700}',
    '\u{FE00}',
    '\u{6717}',
    '\u{FE00}',
    '\u{6717}',
    '\u{FE01}',
    '\u{6717}',
    '\u{FE02}',
    '\u{671B}',
    '\u{FE00}',
    '\u{671B}',
    '\u{FE01}',
    '\u{6721}',
    '\u{FE00}',
    '\u{674E}',
    '\u{FE00}',
    '\u{6753}',
    '\u{FE00}',
    '\u{6756}',
    '\u{FE00}',
    '\u{675E}',
    '\u{FE00}',
    '\u{677B}',
    '\u{FE00}',
    '\u{6785}',
    '\u{FE00}',
    '\u{6797}',
    '\u{FE00}',
    '\u{67F3}',
    '\u{FE00}',
    '\u{67FA}',
    '\u{FE00}',
    '\u{6817}',
    '\u{FE00}',
    '\u{681F}',
    '\u{FE00}',
    '\u{6852}',
    '\u{FE00}',
    '\u{6881}',
    '\u{FE00}',
    '\u{6885}',
    '\u{FE00}',
    '\u{6885}',
    '\u{FE01}',
    '\u{688E}',
    '\u{FE00}',
    '\u{68A8}',
    '\u{FE00}',
    '\u{6914}',
    '\u{FE00}',
    '\u{6942}',
    '\u{FE00}',
    '\u{69A3}',
    '\u{FE00}',
    '\u{69EA}',
    '\u{FE00}',
    '\u{6A02}',
    '\u{FE00}',
    '\u{6A02}',
    '\u{FE01}',
    '\u{6A02}',
    '\u{FE02}',
    '\u{6A13}',
    '\u{FE00}',
    '\u{6AA8}',
    '\u{FE00}',
    '\u{6AD3}',
    '\u{FE00}',
    '\u{6ADB}',
    '\u{FE00}',
    '\u{6B04}',
    '\u{FE00}',
    '\u{6B21}',
    '\u{FE00}',
    '\u{6B54}',
    '\u{FE00}',
    '\u{6B72}',
    '\u{FE00}',
    '\u{6B77}',
    '\u{FE00}',
    '\u{6B79}',
    '\u{FE00}',
    '\u{6B9F}',
    '\u{FE00}',
    '\u{6BAE}',
    '\u{FE00}',
    '\u{6BBA}',
    '\u{FE00}',
    '\u{6BBA}',
    '\u{FE01}',
    '\u{6BBA}',
    '\u{FE02}',
    '\u{6BBB}',
    '\u{FE00}',
    '\u{6C4E}',
    '\u{FE00}',
    '\u{6C67}',
    '\u{FE00}',
    '\u{6C88}',
    '\u{FE00}',
    '\u{6CBF}',
    '\u{FE00}',
    '\u{6CCC}',
    '\u{FE00}',
    '\u{6CCD}',
    '\u{FE00}',
    '\u{6CE5}',
    '\u{FE00}',
    '\u{6D16}',
    '\u{FE00}',
    '\u{6D1B}',
    '\u{FE00}',
    '\u{6D1E}',
    '\u{FE00}',
    '\u{6D34}',
    '\u{FE00}',
    '\u{6D3E}',
    '\u{FE00}',
    '\u{6D41}',
    '\u{FE00}',
    '\u{6D41}',
    '\u{FE01}',
    '\u{6D41}',
    '\u{FE02}',
    '\u{6D69}',
    '\u{FE00}',
    '\u{6D6A}',
    '\u{FE00}',
    '\u{6D77}',
    '\u{FE00}',
    '\u{6D77}',
    '\u{FE01}',
    '\u{6D78}',
    '\u{FE00}',
    '\u{6D85}',
    '\u{FE00}',
    '\u{6DCB}',
    '\u{FE00}',
    '\u{6DDA}',
    '\u{FE00}',
    '\u{6DEA}',
    '\u{FE00}',
    '\u{6DF9}',
    '\u{FE00}',
    '\u{6E1A}',
    '\u{FE00}',
    '\u{6E2F}',
    '\u{FE00}',
    '\u{6E6E}',
    '\u{FE00}',
    '\u{6E9C}',
    '\u{FE00}',
    '\u{6EBA}',
    '\u{FE00}',
    '\u{6EC7}',
    '\u{FE00}',
    '\u{6ECB}',
    '\u{FE00}',
    '\u{6ECB}',
    '\u{FE01}',
    '\u{6ED1}',
    '\u{FE00}',
    '\u{6EDB}',
    '\u{FE00}',
    '\u{6F0F}',
    '\u{FE00}',
    '\u{6F22}',
    '\u{FE00}',
    '\u{6F22}',
    '\u{FE01}',
    '\u{6F23}',
    '\u{FE00}',
    '\u{6F6E}',
    '\u{FE00}',
    '\u{6FC6}',
    '\u{FE00}',
    '\u{6FEB}',
    '\u{FE00}',
    '\u{6FFE}',
    '\u{FE00}',
    '\u{701B}',
    '\u{FE00}',
    '\u{701E}',
    '\u{FE00}',
    '\u{701E}',
    '\u{FE01}',
    '\u{7039}',
    '\u{FE00}',
    '\u{704A}',
    '\u{FE00}',
    '\u{7070}',
    '\u{FE00}',
    '\u{7077}',
    '\u{FE00}',
    '\u{707D}',
    '\u{FE00}',
    '\u{7099}',
    '\u{FE00}',
    '\u{70AD}',
    '\u{FE00}',
    '\u{70C8}',
    '\u{FE00}',
    '\u{70D9}',
    '\u{FE00}',
    '\u{7145}',
    '\u{FE00}',
    '\u{7149}',
    '\u{FE00}',
    '\u{716E}',
    '\u{FE00}',
    '\u{716E}',
    '\u{FE01}',
    '\u{719C}',
    '\u{FE00}',
    '\u{71CE}',
    '\u{FE00}',
    '\u{71D0}',
    '\u{FE00}',
    '\u{7210}',
    '\u{FE00}',
    '\u{721B}',
    '\u{FE00}',
    '\u{7228}',
    '\u{FE00}',
    '\u{722B}',
    '\u{FE00}',
    '\u{7235}',
    '\u{FE00}',
    '\u{7235}',
    '\u{FE01}',
    '\u{7250}',
    '\u{FE00}',
    '\u{7262}',
    '\u{FE00}',
    '\u{7280}',
    '\u{FE00}',
    '\u{7295}',
    '\u{FE00}',
    '\u{72AF}',
    '\u{FE00}',
    '\u{72C0}',
    '\u{FE00}',
    '\u{72FC}',
    '\u{FE00}',
    '\u{732A}',
    '\u{FE00}',
    '\u{732A}',
    '\u{FE01}',
    '\u{7375}',
    '\u{FE00}',
    '\u{737A}',
    '\u{FE00}',
    '\u{7387}',
    '\u{FE00}',
    '\u{7387}',
    '\u{FE01}',
    '\u{738B}',
    '\u{FE00}',
    '\u{73A5}',
    '\u{FE00}',
    '\u{73B2}',
    '\u{FE00}',
    '\u{73DE}',
    '\u{FE00}',
    '\u{7406}',
    '\u{FE00}',
    '\u{7409}',
    '\u{FE00}',
    '\u{7422}',
    '\u{FE00}',
    '\u{7447}',
    '\u{FE00}',
    '\u{745C}',
    '\u{FE00}',
    '\u{7469}',
    '\u{FE00}',
    '\u{7471}',
    '\u{FE00}',
    '\u{7471}',
    '\u{FE01}',
    '\u{7485}',
    '\u{FE00}',
    '\u{7489}',
    '\u{FE00}',
    '\u{7498}',
    '\u{FE00}',
    '\u{74CA}',
    '\u{FE00}',
    '\u{7506}',
    '\u{FE00}',
    '\u{7524}',
    '\u{FE00}',
    '\u{753B}',
    '\u{FE00}',
    '\u{753E}',
    '\u{FE00}',
    '\u{7559}',
    '\u{FE00}',
    '\u{7565}',
    '\u{FE00}',
    '\u{7570}',
    '\u{FE00}',
    '\u{7570}',
    '\u{FE01}',
    '\u{75E2}',
    '\u{FE00}',
    '\u{7610}',
    '\u{FE00}',
    '\u{761D}',
    '\u{FE00}',
    '\u{761F}',
    '\u{FE00}',
    '\u{7642}',
    '\u{FE00}',
    '\u{7669}',
    '\u{FE00}',
    '\u{76CA}',
    '\u{FE00}',
    '\u{76CA}',
    '\u{FE01}',
    '\u{76DB}',
    '\u{FE00}',
    '\u{76E7}',
    '\u{FE00}',
    '\u{76F4}',
    '\u{FE00}',
    '\u{76F4}',
    '\u{FE01}',
    '\u{7701}',
    '\u{FE00}',
    '\u{771E}',
    '\u{FE00}',
    '\u{771F}',
    '\u{FE00}',
    '\u{771F}',
    '\u{FE01}',
    '\u{7740}',
    '\u{FE00}',
    '\u{774A}',
    '\u{FE00}',
    '\u{774A}',
    '\u{FE01}',
    '\u{778B}',
    '\u{FE00}',
    '\u{77A7}',
    '\u{FE00}',
    '\u{784E}',
    '\u{FE00}',
    '\u{786B}',
    '\u{FE00}',
    '\u{788C}',
    '\u{FE00}',
    '\u{788C}',
    '\u{FE01}',
    '\u{7891}',
    '\u{FE00}',
    '\u{78CA}',
    '\u{FE00}',
    '\u{78CC}',
    '\u{FE00}',
    '\u{78CC}',
    '\u{FE01}',
    '\u{78FB}',
    '\u{FE00}',
    '\u{792A}',
    '\u{FE00}',
    '\u{793C}',
    '\u{FE00}',
    '\u{793E}',
    '\u{FE00}',
    '\u{7948}',
    '\u{FE00}',
    '\u{7949}',
    '\u{FE00}',
    '\u{7950}',
    '\u{FE00}',
    '\u{7956}',
    '\u{FE00}',
    '\u{7956}',
    '\u{FE01}',
    '\u{795D}',
    '\u{FE00}',
    '\u{795E}',
    '\u{FE00}',
    '\u{7965}',
    '\u{FE00}',
    '\u{797F}',
    '\u{FE00}',
    '\u{798D}',
    '\u{FE00}',
    '\u{798E}',
    '\u{FE00}',
    '\u{798F}',
    '\u{FE00}',
    '\u{798F}',
    '\u{FE01}',
    '\u{79AE}',
    '\u{FE00}',
    '\u{79CA}',
    '\u{FE00}',
    '\u{79EB}',
    '\u{FE00}',
    '\u{7A1C}',
    '\u{FE00}',
    '\u{7A40}',
    '\u{FE00}',
    '\u{7A40}',
    '\u{FE01}',
    '\u{7A4A}',
    '\u{FE00}',
    '\u{7A4F}',
    '\u{FE00}',
    '\u{7A81}',
    '\u{FE00}',
    '\u{7AB1}',
    '\u{FE00}',
    '\u{7ACB}',
    '\u{FE00}',
    '\u{7AEE}',
    '\u{FE00}',
    '\u{7B20}',
    '\u{FE00}',
    '\u{7BC0}',
    '\u{FE00}',
    '\u{7BC0}',
    '\u{FE01}',
    '\u{7BC6}',
    '\u{FE00}',
    '\u{7BC9}',
    '\u{FE00}',
    '\u{7C3E}',
    '\u{FE00}',
    '\u{7C60}',
    '\u{FE00}',
    '\u{7C7B}',
    '\u{FE00}',
    '\u{7C92}',
    '\u{FE00}',
    '\u{7CBE}',
    '\u{FE00}',
    '\u{7CD2}',
    '\u{FE00}',
    '\u{7CD6}',
    '\u{FE00}',
    '\u{7CE3}',
    '\u{FE00}',
    '\u{7CE7}',
    '\u{FE00}',
    '\u{7CE8}',
    '\u{FE00}',
    '\u{7D00}',
    '\u{FE00}',
    '\u{7D10}',
    '\u{FE00}',
    '\u{7D22}',
    '\u{FE00}',
    '\u{7D2F}',
    '\u{FE00}',
    '\u{7D5B}',
    '\u{FE00}',
    '\u{7D63}',
    '\u{FE00}',
    '\u{7DA0}',
    '\u{FE00}',
    '\u{7DBE}',
    '\u{FE00}',
    '\u{7DC7}',
    '\u{FE00}',
    '\u{7DF4}',
    '\u{FE00}',
    '\u{7DF4}',
    '\u{FE01}',
    '\u{7DF4}',
    '\u{FE02}',
    '\u{7E02}',
    '\u{FE00}',
    '\u{7E09}',
    '\u{FE00}',
    '\u{7E37}',
    '\u{FE00}',
    '\u{7E41}',
    '\u{FE00}',
    '\u{7E45}',
    '\u{FE00}',
    '\u{7F3E}',
    '\u{FE00}',
    '\u{7F72}',
    '\u{FE00}',
    '\u{7F79}',
    '\u{FE00}',
    '\u{7F7A}',
    '\u{FE00}',
    '\u{7F85}',
    '\u{FE00}',
    '\u{7F95}',
    '\u{FE00}',
    '\u{7F9A}',
    '\u{FE00}',
    '\u{7FBD}',
    '\u{FE00}',
    '\u{7FFA}',
    '\u{FE00}',
    '\u{8001}',
    '\u{FE00}',
    '\u{8005}',
    '\u{FE00}',
    '\u{8005}',
    '\u{FE01}',
    '\u{8005}',
    '\u{FE02}',
    '\u{8046}',
    '\u{FE00}',
    '\u{8060}',
    '\u{FE00}',
    '\u{806F}',
    '\u{FE00}',
    '\u{8070}',
    '\u{FE00}',
    '\u{807E}',
    '\u{FE00}',
    '\u{808B}',
    '\u{FE00}',
    '\u{80AD}',
    '\u{FE00}',
    '\u{80B2}',
    '\u{FE00}',
    '\u{8103}',
    '\u{FE00}',
    '\u{813E}',
    '\u{FE00}',
    '\u{81D8}',
    '\u{FE00}',
    '\u{81E8}',
    '\u{FE00}',
    '\u{81ED}',
    '\u{FE00}',
    '\u{8201}',
    '\u{FE00}',
    '\u{8201}',
    '\u{FE01}',
    '\u{8204}',
    '\u{FE00}',
    '\u{8218}',
    '\u{FE00}',
    '\u{826F}',
    '\u{FE00}',
    '\u{8279}',
    '\u{FE00}',
    '\u{8279}',
    '\u{FE01}',
    '\u{828B}',
    '\u{FE00}',
    '\u{8291}',
    '\u{FE00}',
    '\u{829D}',
    '\u{FE00}',
    '\u{82B1}',
    '\u{FE00}',
    '\u{82B3}',
    '\u{FE00}',
    '\u{82BD}',
    '\u{FE00}',
    '\u{82E5}',
    '\u{FE00}',
    '\u{82E5}',
    '\u{FE01}',
    '\u{82E6}',
    '\u{FE00}',
    '\u{831D}',
    '\u{FE00}',
    '\u{8323}',
    '\u{FE00}',
    '\u{8336}',
    '\u{FE00}',
    '\u{8352}',
    '\u{FE00}',
    '\u{8353}',
    '\u{FE00}',
    '\u{8363}',
    '\u{FE00}',
    '\u{83AD}',
    '\u{FE00}',
    '\u{83BD}',
    '\u{FE00}',
    '\u{83C9}',
    '\u{FE00}',
    '\u{83CA}',
    '\u{FE00}',
    '\u{83CC}',
    '\u{FE00}',
    '\u{83DC}',
    '\u{FE00}',
    '\u{83E7}',
    '\u{FE00}',
    '\u{83EF}',
    '\u{FE00}',
    '\u{83F1}',
    '\u{FE00}',
    '\u{843D}',
    '\u{FE00}',
    '\u{8449}',
    '\u{FE00}',
    '\u{8457}',
    '\u{FE00}',
    '\u{8457}',
    '\u{FE01}',
    '\u{84EE}',
    '\u{FE00}',
    '\u{84F1}',
    '\u{FE00}',
    '\u{84F3}',
    '\u{FE00}',
    '\u{84FC}',
    '\u{FE00}',
    '\u{8516}',
    '\u{FE00}',
    '\u{8564}',
    '\u{FE00}',
    '\u{85CD}',
    '\u{FE00}',
    '\u{85FA}',
    '\u{FE00}',
    '\u{8606}',
    '\u{FE00}',
    '\u{8612}',
    '\u{FE00}',
    '\u{862D}',
    '\u{FE00}',
    '\u{863F}',
    '\u{FE00}',
    '\u{8650}',
    '\u{FE00}',
    '\u{865C}',
    '\u{FE00}',
    '\u{865C}',
    '\u{FE01}',
    '\u{8667}',
    '\u{FE00}',
    '\u{8669}',
    '\u{FE00}',
    '\u{8688}',
    '\u{FE00}',
    '\u{86A9}',
    '\u{FE00}',
    '\u{86E2}',
    '\u{FE00}',
    '\u{870E}',
    '\u{FE00}',
    '\u{8728}',
    '\u{FE00}',
    '\u{876B}',
    '\u{FE00}',
    '\u{8779}',
    '\u{FE00}',
    '\u{8779}',
    '\u{FE01}',
    '\u{8786}',
    '\u{FE00}',
    '\u{87BA}',
    '\u{FE00}',
    '\u{87E1}',
    '\u{FE00}',
    '\u{8801}',
    '\u{FE00}',
    '\u{881F}',
    '\u{FE00}',
    '\u{884C}',
    '\u{FE00}',
    '\u{8860}',
    '\u{FE00}',
    '\u{8863}',
    '\u{FE00}',
    '\u{88C2}',
    '\u{FE00}',
    '\u{88CF}',
    '\u{FE00}',
    '\u{88D7}',
    '\u{FE00}',
    '\u{88DE}',
    '\u{FE00}',
    '\u{88E1}',
    '\u{FE00}',
    '\u{88F8}',
    '\u{FE00}',
    '\u{88FA}',
    '\u{FE00}',
    '\u{8910}',
    '\u{FE00}',
    '\u{8941}',
    '\u{FE00}',
    '\u{8964}',
    '\u{FE00}',
    '\u{8986}',
    '\u{FE00}',
    '\u{898B}',
    '\u{FE00}',
    '\u{8996}',
    '\u{FE00}',
    '\u{8996}',
    '\u{FE01}',
    '\u{8AA0}',
    '\u{FE00}',
    '\u{8AAA}',
    '\u{FE00}',
    '\u{8AAA}',
    '\u{FE01}',
    '\u{8ABF}',
    '\u{FE00}',
    '\u{8ACB}',
    '\u{FE00}',
    '\u{8AD2}',
    '\u{FE00}',
    '\u{8AD6}',
    '\u{FE00}',
    '\u{8AED}',
    '\u{FE00}',
    '\u{8AED}',
    '\u{FE01}',
    '\u{8AF8}',
    '\u{FE00}',
    '\u{8AF8}',
    '\u{FE01}',
    '\u{8AFE}',
    '\u{FE00}',
    '\u{8AFE}',
    '\u{FE01}',
    '\u{8B01}',
    '\u{FE00}',
    '\u{8B01}',
    '\u{FE01}',
    '\u{8B39}',
    '\u{FE00}',
    '\u{8B39}',
    '\u{FE01}',
    '\u{8B58}',
    '\u{FE00}',
    '\u{8B80}',
    '\u{FE00}',
    '\u{8B8A}',
    '\u{FE00}',
    '\u{8B8A}',
    '\u{FE01}',
    '\u{8C48}',
    '\u{FE00}',
    '\u{8C55}',
    '\u{FE00}',
    '\u{8CAB}',
    '\u{FE00}',
    '\u{8CC1}',
    '\u{FE00}',
    '\u{8CC2}',
    '\u{FE00}',
    '\u{8CC8}',
    '\u{FE00}',
    '\u{8CD3}',
    '\u{FE00}',
    '\u{8D08}',
    '\u{FE00}',
    '\u{8D08}',
    '\u{FE01}',
    '\u{8D1B}',
    '\u{FE00}',
    '\u{8D77}',
    '\u{FE00}',
    '\u{8DBC}',
    '\u{FE00}',
    '\u{8DCB}',
    '\u{FE00}',
    '\u{8DEF}',
    '\u{FE00}',
    '\u{8DF0}',
    '\u{FE00}',
    '\u{8ECA}',
    '\u{FE00}',
    '\u{8ED4}',
    '\u{FE00}',
    '\u{8F26}',
    '\u{FE00}',
    '\u{8F2A}',
    '\u{FE00}',
    '\u{8F38}',
    '\u{FE00}',
    '\u{8F38}',
    '\u{FE01}',
    '\u{8F3B}',
    '\u{FE00}',
    '\u{8F62}',
    '\u{FE00}',
    '\u{8F9E}',
    '\u{FE00}',
    '\u{8FB0}',
    '\u{FE00}',
    '\u{8FB6}',
    '\u{FE00}',
    '\u{9023}',
    '\u{FE00}',
    '\u{9038}',
    '\u{FE00}',
    '\u{9038}',
    '\u{FE01}',
    '\u{9072}',
    '\u{FE00}',
    '\u{907C}',
    '\u{FE00}',
    '\u{908F}',
    '\u{FE00}',
    '\u{9094}',
    '\u{FE00}',
    '\u{90CE}',
    '\u{FE00}',
    '\u{90DE}',
    '\u{FE00}',
    '\u{90F1}',
    '\u{FE00}',
    '\u{90FD}',
    '\u{FE00}',
    '\u{9111}',
    '\u{FE00}',
    '\u{911B}',
    '\u{FE00}',
    '\u{916A}',
    '\u{FE00}',
    '\u{9199}',
    '\u{FE00}',
    '\u{91B4}',
    '\u{FE00}',
    '\u{91CC}',
    '\u{FE00}',
    '\u{91CF}',
    '\u{FE00}',
    '\u{91D1}',
    '\u{FE00}',
    '\u{9234}',
    '\u{FE00}',
    '\u{9238}',
    '\u{FE00}',
    '\u{9276}',
    '\u{FE00}',
    '\u{927C}',
    '\u{FE00}',
    '\u{92D7}',
    '\u{FE00}',
    '\u{92D8}',
    '\u{FE00}',
    '\u{9304}',
    '\u{FE00}',
    '\u{934A}',
    '\u{FE00}',
    '\u{93F9}',
    '\u{FE00}',
    '\u{9415}',
    '\u{FE00}',
    '\u{958B}',
    '\u{FE00}',
    '\u{95AD}',
    '\u{FE00}',
    '\u{95B7}',
    '\u{FE00}',
    '\u{962E}',
    '\u{FE00}',
    '\u{964B}',
    '\u{FE00}',
    '\u{964D}',
    '\u{FE00}',
    '\u{9675}',
    '\u{FE00}',
    '\u{9678}',
    '\u{FE00}',
    '\u{967C}',
    '\u{FE00}',
    '\u{9686}',
    '\u{FE00}',
    '\u{96A3}',
    '\u{FE00}',
    '\u{96B7}',
    '\u{FE00}',
    '\u{96B8}',
    '\u{FE00}',
    '\u{96C3}',
    '\u{FE00}',
    '\u{96E2}',
    '\u{FE00}',
    '\u{96E3}',
    '\u{FE00}',
    '\u{96E3}',
    '\u{FE01}',
    '\u{96F6}',
    '\u{FE00}',
    '\u{96F7}',
    '\u{FE00}',
    '\u{9723}',
    '\u{FE00}',
    '\u{9732}',
    '\u{FE00}',
    '\u{9748}',
    '\u{FE00}',
    '\u{9756}',
    '\u{FE00}',
    '\u{9756}',
    '\u{FE01}',
    '\u{97DB}',
    '\u{FE00}',
    '\u{97E0}',
    '\u{FE00}',
    '\u{97FF}',
    '\u{FE00}',
    '\u{97FF}',
    '\u{FE01}',
    '\u{980B}',
    '\u{FE00}',
    '\u{980B}',
    '\u{FE01}',
    '\u{980B}',
    '\u{FE02}',
    '\u{9818}',
    '\u{FE00}',
    '\u{9829}',
    '\u{FE00}',
    '\u{983B}',
    '\u{FE00}',
    '\u{983B}',
    '\u{FE01}',
    '\u{985E}',
    '\u{FE00}',
    '\u{98E2}',
    '\u{FE00}',
    '\u{98EF}',
    '\u{FE00}',
    '\u{98FC}',
    '\u{FE00}',
    '\u{9928}',
    '\u{FE00}',
    '\u{9929}',
    '\u{FE00}',
    '\u{99A7}',
    '\u{FE00}',
    '\u{99C2}',
    '\u{FE00}',
    '\u{99F1}',
    '\u{FE00}',
    '\u{99FE}',
    '\u{FE00}',
    '\u{9A6A}',
    '\u{FE00}',
    '\u{9B12}',
    '\u{FE00}',
    '\u{9B12}',
    '\u{FE01}',
    '\u{9B6F}',
    '\u{FE00}',
    '\u{9C40}',
    '\u{FE00}',
    '\u{9C57}',
    '\u{FE00}',
    '\u{9CFD}',
    '\u{FE00}',
    '\u{9D67}',
    '\u{FE00}',
    '\u{9DB4}',
    '\u{FE00}',
    '\u{9DFA}',
    '\u{FE00}',
    '\u{9E1E}',
    '\u{FE00}',
    '\u{9E7F}',
    '\u{FE00}',
    '\u{9E97}',
    '\u{FE00}',
    '\u{9E9F}',
    '\u{FE00}',
    '\u{9EBB}',
    '\u{FE00}',
    '\u{9ECE}',
    '\u{FE00}',
    '\u{9EF9}',
    '\u{FE00}',
    '\u{9EFE}',
    '\u{FE00}',
    '\u{9F05}',
    '\u{FE00}',
    '\u{9F0F}',
    '\u{FE00}',
    '\u{9F16}',
    '\u{FE00}',
    '\u{9F3B}',
    '\u{FE00}',
    '\u{9F43}',
    '\u{FE00}',
    '\u{9F8D}',
    '\u{FE00}',
    '\u{9F8E}',
    '\u{FE00}',
    '\u{9F9C}',
    '\u{FE00}',
    '\u{9F9C}',
    '\u{FE01}',
    '\u{9F9C}',
    '\u{FE02}',
    '\u{20122}',
    '\u{FE00}',
    '\u{2051C}',
    '\u{FE00}',
    '\u{20525}',
    '\u{FE00}',
    '\u{2054B}',
    '\u{FE00}',
    '\u{2063A}',
    '\u{FE00}',
    '\u{20804}',
    '\u{FE00}',
    '\u{208DE}',
    '\u{FE00}',
    '\u{20A2C}',
    '\u{FE00}',
    '\u{20B63}',
    '\u{FE00}',
    '\u{214E4}',
    '\u{FE00}',
    '\u{216A8}',
    '\u{FE00}',
    '\u{216EA}',
    '\u{FE00}',
    '\u{219C8}',
    '\u{FE00}',
    '\u{21B18}',
    '\u{FE00}',
    '\u{21D0B}',
    '\u{FE00}',
    '\u{21DE4}',
    '\u{FE00}',
    '\u{21DE6}',
    '\u{FE00}',
    '\u{22183}',
    '\u{FE00}',
    '\u{2219F}',
    '\u{FE00}',
    '\u{22331}',
    '\u{FE00}',
    '\u{22331}',
    '\u{FE01}',
    '\u{226D4}',
    '\u{FE00}',
    '\u{22844}',
    '\u{FE00}',
    '\u{2284A}',
    '\u{FE00}',
    '\u{22B0C}',
    '\u{FE00}',
    '\u{22BF1}',
    '\u{FE00}',
    '\u{2300A}',
    '\u{FE00}',
    '\u{232B8}',
    '\u{FE00}',
    '\u{2335F}',
    '\u{FE00}',
    '\u{23393}',
    '\u{FE00}',
    '\u{2339C}',
    '\u{FE00}',
    '\u{233C3}',
    '\u{FE00}',
    '\u{233D5}',
    '\u{FE00}',
    '\u{2346D}',
    '\u{FE00}',
    '\u{236A3}',
    '\u{FE00}',
    '\u{238A7}',
    '\u{FE00}',
    '\u{23A8D}',
    '\u{FE00}',
    '\u{23AFA}',
    '\u{FE00}',
    '\u{23CBC}',
    '\u{FE00}',
    '\u{23D1E}',
    '\u{FE00}',
    '\u{23ED1}',
    '\u{FE00}',
    '\u{23F5E}',
    '\u{FE00}',
    '\u{23F8E}',
    '\u{FE00}',
    '\u{24263}',
    '\u{FE00}',
    '\u{242EE}',
    '\u{FE00}',
    '\u{243AB}',
    '\u{FE00}',
    '\u{24608}',
    '\u{FE00}',
    '\u{24735}',
    '\u{FE00}',
    '\u{24814}',
    '\u{FE00}',
    '\u{24C36}',
    '\u{FE00}',
    '\u{24C92}',
    '\u{FE00}',
    '\u{24FA1}',
    '\u{FE00}',
    '\u{24FB8}',
    '\u{FE00}',
    '\u{25044}',
    '\u{FE00}',
    '\u{250F2}',
    '\u{FE00}',
    '\u{250F3}',
    '\u{FE00}',
    '\u{25119}',
    '\u{FE00}',
    '\u{25133}',
    '\u{FE00}',
    '\u{25249}',
    '\u{FE00}',
    '\u{2541D}',
    '\u{FE00}',
    '\u{25626}',
    '\u{FE00}',
    '\u{2569A}',
    '\u{FE00}',
    '\u{256C5}',
    '\u{FE00}',
    '\u{2597C}',
    '\u{FE00}',
    '\u{25AA7}',
    '\u{FE00}',
    '\u{25AA7}',
    '\u{FE01}',
    '\u{25BAB}',
    '\u{FE00}',
    '\u{25C80}',
    '\u{FE00}',
    '\u{25CD0}',
    '\u{FE00}',
    '\u{25F86}',
    '\u{FE00}',
    '\u{261DA}',
    '\u{FE00}',
    '\u{26228}',
    '\u{FE00}',
    '\u{26247}',
    '\u{FE00}',
    '\u{262D9}',
    '\u{FE00}',
    '\u{2633E}',
    '\u{FE00}',
    '\u{264DA}',
    '\u{FE00}',
    '\u{26523}',
    '\u{FE00}',
    '\u{265A8}',
    '\u{FE00}',
    '\u{267A7}',
    '\u{FE00}',
    '\u{267B5}',
    '\u{FE00}',
    '\u{26B3C}',
    '\u{FE00}',
    '\u{26C36}',
    '\u{FE00}',
    '\u{26CD5}',
    '\u{FE00}',
    '\u{26D6B}',
    '\u{FE00}',
    '\u{26F2C}',
    '\u{FE00}',
    '\u{26FB1}',
    '\u{FE00}',
    '\u{270D2}',
    '\u{FE00}',
    '\u{273CA}',
    '\u{FE00}',
    '\u{27667}',
    '\u{FE00}',
    '\u{278AE}',
    '\u{FE00}',
    '\u{27966}',
    '\u{FE00}',
    '\u{27CA8}',
    '\u{FE00}',
    '\u{27ED3}',
    '\u{FE00}',
    '\u{27F2F}',
    '\u{FE00}',
    '\u{285D2}',
    '\u{FE00}',
    '\u{285ED}',
    '\u{FE00}',
    '\u{2872E}',
    '\u{FE00}',
    '\u{28BFA}',
    '\u{FE00}',
    '\u{28D77}',
    '\u{FE00}',
    '\u{29145}',
    '\u{FE00}',
    '\u{291DF}',
    '\u{FE00}',
    '\u{2921A}',
    '\u{FE00}',
    '\u{2940A}',
    '\u{FE00}',
    '\u{29496}',
    '\u{FE00}',
    '\u{295B6}',
    '\u{FE00}',
    '\u{29B30}',
    '\u{FE00}',
    '\u{2A0CE}',
    '\u{FE00}',
    '\u{2A105}',
    '\u{FE00}',
    '\u{2A20E}',
    '\u{FE00}',
    '\u{2A291}',
    '\u{FE00}',
    '\u{2A392}',
    '\u{FE00}',
    '\u{2A600}',
    '\u{FE00}',
];

pub(crate) const CJK_COMPAT_VARIANTS_DECOMPOSED_SALT: &[u16] = &[
    0x005, 0x000, 0x000, 0x000, 0x162, 0x014, 0x0B6, 0x000, 0x183, 0x00D, 0x000, 0x000, 0x035,
    0x011, 0x007, 0x000, 0x01C, 0x000, 0x001, 0x000, 0x0D3, 0x00B, 0x00A, 0x0E1, 0x000, 0x000,
    0x000, 0x048, 0x072, 0x0C7, 0x002, 0x021, 0x015, 0x02C, 0x000, 0x000, 0x000, 0x005, 0x01F,
    0x008, 0x007, 0x000, 0x004, 0x000, 0x007, 0x010, 0x000, 0x000, 0x000, 0x04E, 0x000, 0x006,
    0x000, 0x011, 0x014, 0x004, 0x01A, 0x002, 0x058, 0x000, 0x017, 0x000, 0x000, 0x000, 0x004,
    0x000, 0x001, 0x000, 0x001, 0x000, 0x004, 0x006, 0x016, 0x020, 0x004, 0x000, 0x01E, 0x030,
    0x000, 0x024, 0x01A, 0x017, 0x000, 0x0A0, 0x029, 0x034, 0x002, 0x000, 0x004, 0x000, 0x023,
    0x029, 0x021, 0x000, 0x000, 0x00B, 0x000, 0x020, 0x001, 0x007, 0x008, 0x009, 0x008, 0x000,
    0x001, 0x000, 0x001, 0x004, 0x003, 0x01D, 0x000, 0x000, 0x000, 0x001, 0x029, 0x00D, 0x007,
    0x000, 0x000, 0x002, 0x00E, 0x009, 0x004, 0x00C, 0x001, 0x013, 0x005, 0x006, 0x005, 0x001,
    0x009, 0x001, 0x00A, 0x002, 0x000, 0x008, 0x029, 0x000, 0x008, 0x002, 0x000, 0x000, 0x000,
    0x000, 0x000, 0x000, 0x000, 0x00D, 0x000, 0x009, 0x010, 0x00F, 0x000, 0x011, 0x00F, 0x000,
    0x008, 0x001, 0x001, 0x005, 0x000, 0x001, 0x026, 0x005, 0x039, 0x008, 0x001, 0x017, 0x00D,
    0x004, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x00E, 0x000, 0x005, 0x000,
    0x000, 0x000, 0x000, 0x004, 0x000, 0x001, 0x002, 0x004, 0x003, 0x035, 0x001, 0x002, 0x001,
    0x007, 0x000, 0x000, 0x003, 0x002, 0x011, 0x000, 0x00D, 0x003, 0x000, 0x000, 0x000, 0x000,
    0x000, 0x000, 0x000, 0x000, 0x004, 0x005, 0x000, 0x00E, 0x000, 0x000, 0x003, 0x006, 0x002,
    0x00B, 0x002, 0x001, 0x003, 0x012, 0x00B, 0x000, 0x000, 0x000, 0x002, 0x00B, 0x001, 0x004,
    0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x02F, 0x001,
    0x013, 0x00B, 0x004, 0x002, 0x004, 0x004, 0x000, 0x00B, 0x004, 0x000, 0x00B, 0x004, 0x00D,
    0x00C, 0x000, 0x01E, 0x000, 0x021, 0x00D, 0x002, 0x007, 0x000, 0x000, 0x000, 0x001, 0x002,
    0x000, 0x020, 0x000, 0x000, 0x000, 0x000, 0x000, 0x01F, 0x001, 0x002, 0x000, 0x000, 0x005,
    0x000, 0x000, 0x004, 0x000, 0x011, 0x002, 0x008, 0x007, 0x000, 0x000, 0x00C, 0x003, 0x000,
    0x004, 0x00E, 0x023, 0x004, 0x001, 0x000, 0x002, 0x000, 0x004, 0x008, 0x010, 0x002, 0x000,
    0x013, 0x00D, 0x000, 0x00B, 0x009, 0x006, 0x000, 0x000, 0x009, 0x00C, 0x00A, 0x004, 0x01A,
    0x003, 0x001, 0x003, 0x000, 0x001, 0x000, 0x006, 0x003, 0x00A, 0x000, 0x00A, 0x006, 0x008,
    0x008, 0x003, 0x019, 0x000, 0x000, 0x000, 0x000, 0x00C, 0x005, 0x000, 0x005, 0x001, 0x000,
    0x002, 0x000, 0x008, 0x000, 0x00C, 0x000, 0x002, 0x000, 0x001, 0x000, 0x000, 0x000, 0x000,
    0x004, 0x002, 0x015, 0x000, 0x004, 0x001, 0x012, 0x004, 0x003, 0x00C, 0x004, 0x000, 0x000,
    0x000, 0x000, 0x000, 0x000, 0x000, 0x003, 0x000, 0x005, 0x002, 0x000, 0x001, 0x002, 0x001,
    0x010, 0x004, 0x000, 0x005, 0x002, 0x001, 0x006, 0x000, 0x000, 0x000, 0x000, 0x00A, 0x008,
    0x002, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x004, 0x004, 0x00C, 0x002,
    0x000, 0x006, 0x003, 0x003, 0x00F, 0x000, 0x003, 0x005, 0x001, 0x000, 0x000, 0x008, 0x000,
    0x002, 0x004, 0x002, 0x013, 0x000, 0x000, 0x000, 0x00A, 0x006, 0x001, 0x000, 0x000, 0x000,
    0x000, 0x000, 0x000, 0x000, 0x00A, 0x000, 0x005, 0x000, 0x005, 0x000, 0x006, 0x000, 0x001,
    0x001, 0x005, 0x001, 0x00A, 0x009, 0x005, 0x001, 0x000, 0x007, 0x001, 0x001, 0x007, 0x001,
    0x01F, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x002,
    0x011, 0x005, 0x003, 0x005, 0x003, 0x001, 0x001, 0x000, 0x004, 0x001, 0x004, 0x001, 0x008,
    0x000, 0x019, 0x000, 0x004, 0x003, 0x005, 0x006, 0x000, 0x011, 0x00E, 0x005, 0x001, 0x000,
    0x01A, 0x004, 0x000, 0x003, 0x000, 0x000, 0x005, 0x000, 0x000, 0x001, 0x017, 0x000, 0x006,
    0x003, 0x00F, 0x001, 0x006, 0x009, 0x000, 0x005, 0x000, 0x003, 0x001, 0x017, 0x007, 0x000,
    0x002, 0x005, 0x003, 0x002, 0x000, 0x007, 0x001, 0x000, 0x004, 0x000, 0x000, 0x005, 0x015,
    0x004, 0x000, 0x003, 0x001, 0x003, 0x007, 0x000, 0x000, 0x001, 0x000, 0x000, 0x000, 0x000,
    0x009, 0x000, 0x000, 0x000, 0x000, 0x000, 0x009, 0x000, 0x000, 0x000, 0x001, 0x003, 0x000,
    0x000, 0x003, 0x001, 0x000, 0x000, 0x000, 0x001, 0x000, 0x000, 0x000, 0x003, 0x008, 0x000,
    0x002, 0x002, 0x003, 0x005, 0x000, 0x000, 0x000, 0x008, 0x003, 0x002, 0x000, 0x009, 0x004,
    0x000, 0x006, 0x00F, 0x001, 0x000, 0x000, 0x004, 0x002, 0x002, 0x004, 0x004, 0x00D, 0x000,
    0x000, 0x000, 0x001, 0x000, 0x002, 0x005, 0x000, 0x000, 0x00C, 0x004, 0x009, 0x002, 0x008,
    0x001, 0x000, 0x005, 0x004, 0x001, 0x002, 0x001, 0x005, 0x002, 0x00B, 0x004, 0x00D, 0x004,
    0x000, 0x001, 0x018, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x003,
    0x000, 0x002, 0x00A, 0x002, 0x004, 0x004, 0x000, 0x000, 0x000, 0x001, 0x000, 0x00C, 0x001,
    0x00C, 0x001, 0x009, 0x00B, 0x000, 0x001, 0x000, 0x002, 0x000, 0x005, 0x000, 0x000, 0x000,
    0x000, 0x000, 0x000, 0x000, 0x000, 0x007, 0x002, 0x000, 0x006, 0x004, 0x00A, 0x001, 0x001,
    0x005, 0x002, 0x006, 0x004, 0x003, 0x00D, 0x002, 0x002, 0x000, 0x001, 0x002, 0x003, 0x002,
    0x000, 0x001, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x002, 0x000, 0x001,
    0x000, 0x000, 0x003, 0x002, 0x000, 0x005, 0x002, 0x005, 0x002, 0x001, 0x004, 0x001, 0x001,
    0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x007, 0x002, 0x000, 0x000, 0x000, 0x000, 0x000,
    0x000, 0x000, 0x000, 0x000, 0x000, 0x001, 0x000, 0x002, 0x000, 0x000, 0x004, 0x008, 0x000,
    0x003, 0x002, 0x002, 0x002, 0x002, 0x004, 0x001, 0x004, 0x002, 0x000, 0x001, 0x004, 0x001,
    0x001, 0x002, 0x000, 0x000, 0x00C, 0x000, 0x001, 0x002, 0x000, 0x006, 0x002, 0x000, 0x000,
    0x008, 0x001, 0x009, 0x001, 0x003, 0x000, 0x004, 0x001, 0x000, 0x006, 0x000, 0x003, 0x007,
    0x000, 0x000, 0x002, 0x001, 0x000, 0x003, 0x002, 0x000, 0x002, 0x007, 0x000, 0x000, 0x000,
    0x000, 0x005, 0x003, 0x001, 0x003, 0x000, 0x005, 0x000, 0x001, 0x000, 0x003, 0x001, 0x001,
    0x002, 0x003, 0x000, 0x002, 0x003, 0x000, 0x000, 0x001, 0x000, 0x000, 0x000, 0x000, 0x001,
    0x000, 0x004, 0x003, 0x002, 0x004, 0x003, 0x005, 0x002, 0x000, 0x000, 0x001, 0x003, 0x002,
    0x000, 0x000, 0x004, 0x003, 0x000, 0x001, 0x006, 0x001, 0x004, 0x000, 0x002, 0x002, 0x001,
    0x000, 0x00D, 0x001, 0x000, 0x000, 0x001, 0x000, 0x002, 0x003, 0x008, 0x005, 0x007, 0x006,
    0x000, 0x001, 0x006, 0x001, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
    0x000, 0x002, 0x000, 0x001, 0x000, 0x000, 0x001, 0x001, 0x002, 0x004, 0x002, 0x001, 0x001,
    0x002, 0x000, 0x000, 0x000, 0x001, 0x005, 0x001, 0x000, 0x002, 0x000, 0x000, 0x000, 0x000,
    0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x001, 0x004, 0x000, 0x002, 0x000, 0x001, 0x003,
    0x003, 0x001, 0x000, 0x004, 0x000, 0x001, 0x001, 0x001, 0x001, 0x001, 0x004, 0x000, 0x000,
    0x003, 0x001, 0x003, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x001, 0x002,
    0x000, 0x000, 0x001, 0x003, 0x002, 0x001, 0x002, 0x001, 0x009, 0x001, 0x000, 0x001, 0x003,
    0x004, 0x000, 0x000, 0x000, 0x002, 0x000, 0x003, 0x001, 0x000, 0x000, 0x000, 0x000, 0x000,
    0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x002, 0x001, 0x004, 0x001, 0x001, 0x001, 0x002,
    0x001, 0x006, 0x001, 0x001, 0x002, 0x001, 0x000, 0x000, 0x000, 0x003, 0x001, 0x000, 0x005,
    0x001,
];
pub(crate) const CJK_COMPAT_VARIANTS_DECOMPOSED_KV: &[(u32, (u16, u16))] = &[
    (0x0FA08, (0x5A8, 0x2)),
    (0x2F825, (0x118, 0x2)),
    (0x2F838, (0x704, 0x2)),
    (0x2F95B, (0x4A8, 0x2)),
    (0x2F8FB, (0x740, 0x2)),
    (0x2F83A, (0x154, 0x2)),
    (0x2F8A7, (0x27C, 0x2)),
    (0x2F856, (0x1A6, 0x2)),
    (0x2F810, (0x0D0, 0x2)),
    (0x0FA8B, (0x29C, 0x2)),
    (0x0FA7A, (0x17A, 0x2)),
    (0x2F9EF, (0x076, 0x2)),
    (0x2F959, (0x4A4, 0x2)),
    (0x0F9C8, (0x324, 0x2)),
    (0x0F9C4, (0x6EA, 0x2)),
    (0x2F833, (0x148, 0x2)),
    (0x0F96C, (0x1AE, 0x2)),
    (0x0F9A1, (0x5CE, 0x2)),
    (0x0F906, (0x150, 0x2)),
    (0x2FA01, (0x7C4, 0x2)),
    (0x0F94C, (0x34C, 0x2)),
    (0x0F90F, (0x4FA, 0x2)),
    (0x2F8DD, (0x732, 0x2)),
    (0x0FA55, (0x4AA, 0x2)),
    (0x2F860, (0x708, 0x2)),
    (0x2F999, (0x546, 0x2)),
    (0x0FABC, (0x5E6, 0x2)),
    (0x2F9B9, (0x594, 0x2)),
    (0x0F943, (0x246, 0x2)),
    (0x2F952, (0x76C, 0x2)),
    (0x2F8F1, (0x358, 0x2)),
    (0x0F99C, (0x100, 0x2)),
    (0x0F969, (0x2EC, 0x2)),
    (0x0F98D, (0x620, 0x2)),
    (0x0FA7F, (0x1CC, 0x2)),
    (0x2F9D6, (0x606, 0x2)),
    (0x2F81B, (0x0EC, 0x2)),
    (0x0FA9D, (0x466, 0x2)),
    (0x2F8E4, (0x33A, 0x2)),
    (0x0FA94, (0x320, 0x2)),
    (0x2F890, (0x244, 0x2)),
    (0x0F93D, (0x4DC, 0x2)),
    (0x2F924, (0x3F8, 0x2)),
    (0x2F983, (0x51C, 0x2)),
    (0x0FA2F, (0x678, 0x2)),
    (0x2F891, (0x71A, 0x2)),
    (0x2F934, (0x430, 0x2)),
    (0x2F835, (0x3CC, 0x2)),
    (0x2F899, (0x24E, 0x2)),
    (0x2F8AE, (0x294, 0x2)),
    (0x0F9D6, (0x39A, 0x2)),
    (0x2F9A0, (0x54E, 0x2)),
    (0x0FAC2, (0x61A, 0x2)),
    (0x2F851, (0x1BA, 0x2)),
    (0x2F804, (0x0A6, 0x2)),
    (0x2F90D, (0x744, 0x2)),
    (0x0F95E, (0x094, 0x2)),
    (0x2F8DA, (0x31A, 0x2)),
    (0x2F885, (0x226, 0x2)),
    (0x2F96A, (0x4D0, 0x2)),
    (0x0F907, (0x6EE, 0x2)),
    (0x0F9F9, (0x4C2, 0x2)),
    (0x0F94B, (0x202, 0x2)),
    (0x2F915, (0x3C2, 0x2)),
    (0x0F9F1, (0x676, 0x2)),
    (0x2F86D, (0x1EA, 0x2)),
    (0x2F921, (0x3F2, 0x2)),
    (0x0FA96, (0x366, 0x2)),
    (0x0F9E0, (0x2F6, 0x2)),
    (0x0F921, (0x214, 0x2)),
    (0x2F99F, (0x56A, 0x2)),
    (0x2F8B2, (0x2A6, 0x2)),
    (0x0FAB1, (0x4F2, 0x2)),
    (0x0FA6C, (0x74C, 0x2)),
    (0x2F819, (0x0A2, 0x2)),
    (0x2F910, (0x746, 0x2)),
    (0x2F8DC, (0x31E, 0x2)),
    (0x2F9D3, (0x7AA, 0x2)),
    (0x2F8A3, (0x26E, 0x2)),
    (0x0F915, (0x37C, 0x2)),
    (0x2F88A, (0x014, 0x2)),
    (0x0F9F6, (0x522, 0x2)),
    (0x2F9F1, (0x7B8, 0x2)),
    (0x0F98E, (0x22C, 0x2)),
    (0x0FAD5, (0x768, 0x2)),
    (0x0F93B, (0x46C, 0x2)),
    (0x2F91E, (0x3E2, 0x2)),
    (0x0F9EB, (0x134, 0x2)),
    (0x0FA42, (0x2F2, 0x2)),
    (0x2F958, (0x04E, 0x2)),
    (0x0FA19, (0x48C, 0x2)),
    (0x0FAAA, (0x45E, 0x2)),
    (0x2F949, (0x046, 0x2)),
    (0x2F978, (0x4FC, 0x2)),
    (0x2F8A9, (0x27E, 0x2)),
    (0x2F90A, (0x032, 0x2)),
    (0x2F89A, (0x252, 0x2)),
    (0x2F8B5, (0x2B0, 0x2)),
    (0x2F94C, (0x04A, 0x2)),
    (0x0FA43, (0x300, 0x2)),
    (0x0F997, (0x510, 0x2)),
    (0x2F8BA, (0x2BA, 0x2)),
    (0x0FA00, (0x0FC, 0x2)),
    (0x0FAC3, (0x62E, 0x2)),
    (0x2F948, (0x462, 0x2)),
    (0x2F9F4, (0x21C, 0x2)),
    (0x0FA99, (0x3AA, 0x2)),
    (0x2F976, (0x4F8, 0x2)),
    (0x0F978, (0x0D6, 0x2)),
    (0x2F8FE, (0x36E, 0x2)),
    (0x2F8E3, (0x736, 0x2)),
    (0x0F919, (0x642, 0x2)),
    (0x2F8EF, (0x356, 0x2)),
    (0x0F939, (0x6C2, 0x2)),
    (0x2F8C9, (0x2EA, 0x2)),
    (0x2F844, (0x172, 0x2)),
    (0x0FABB, (0x5D2, 0x2)),
    (0x2F9C4, (0x5AC, 0x2)),
    (0x2F984, (0x060, 0x2)),
    (0x2F802, (0x098, 0x2)),
    (0x0FA15, (0x0F6, 0x2)),
    (0x0F9BE, (0x2EE, 0x2)),
    (0x0F942, (0x1B8, 0x2)),
    (0x2F852, (0x19E, 0x2)),
    (0x0FAAE, (0x4C0, 0x2)),
    (0x2FA17, (0x6DC, 0x2)),
    (0x2F92D, (0x03A, 0x2)),
    (0x2F83F, (0x162, 0x2)),
    (0x0F90C, (0x1C8, 0x2)),
    (0x0F931, (0x350, 0x2)),
    (0x0F9C1, (0x446, 0x2)),
    (0x2F873, (0x1FA, 0x2)),
    (0x2F965, (0x77A, 0x2)),
    (0x0F902, (0x612, 0x2)),
    (0x2F805, (0x0B0, 0x2)),
    (0x2F8CA, (0x728, 0x2)),
    (0x0F9C7, (0x10E, 0x2)),
    (0x2F8F4, (0x360, 0x2)),
    (0x0FA0D, (0x186, 0x2)),
    (0x0FA5C, (0x524, 0x2)),
    (0x0FA4C, (0x47E, 0x2)),
    (0x2F865, (0x1D2, 0x2)),
    (0x2F876, (0x00E, 0x2)),
    (0x2F9D7, (0x608, 0x2)),
    (0x0F975, (0x2C8, 0x2)),
    (0x2F9BB, (0x59C, 0x2)),
    (0x2F9D2, (0x5F6, 0x2)),
    (0x0F9ED, (0x15A, 0x2)),
    (0x2F9B4, (0x588, 0x2)),
    (0x0FA6D, (0x52C, 0x2)),
    (0x0F9E5, (0x43E, 0x2)),
    (0x2F8D8, (0x314, 0x2)),
    (0x2F93D, (0x75E, 0x2)),
    (0x0FA03, (0x4C8, 0x2)),
    (0x0F9A0, (0x5AE, 0x2)),
    (0x2FA12, (0x7CA, 0x2)),
    (0x0FA63, (0x5E8, 0x2)),
    (0x0F920, (0x6D0, 0x2)),
    (0x0F91F, (0x580, 0x2)),
    (0x2F97D, (0x50E, 0x2)),
    (0x0F990, (0x2A4, 0x2)),
    (0x0FA57, (0x4E4, 0x2)),
    (0x2F975, (0x786, 0x2)),
    (0x0FAD8, (0x6E8, 0x2)),
    (0x0FAB3, (0x54C, 0x2)),
    (0x2F9F3, (0x67C, 0x2)),
    (0x0F9FB, (0x3D2, 0x2)),
    (0x0F918, (0x564, 0x2)),
    (0x2F8C3, (0x2D8, 0x2)),
    (0x0F9CA, (0x384, 0x2)),
    (0x0F952, (0x11E, 0x2)),
    (0x2FA0B, (0x6C4, 0x2)),
    (0x2F941, (0x762, 0x2)),
    (0x2F862, (0x1D4, 0x2)),
    (0x2F8FF, (0x37A, 0x2)),
    (0x2F85D, (0x1C2, 0x2)),
    (0x0F9D9, (0x278, 0x2)),
    (0x2F855, (0x19C, 0x2)),
    (0x2F98F, (0x536, 0x2)),
    (0x0F9D4, (0x0B8, 0x2)),
    (0x0F99E, (0x168, 0x2)),
    (0x2F850, (0x0FE, 0x2)),
    (0x0FA22, (0x5DC, 0x2)),
    (0x2F94F, (0x46E, 0x2)),
    (0x0FAA9, (0x460, 0x2)),
    (0x0FA71, (0x0EA, 0x2)),
    (0x0F95D, (0x5E0, 0x2)),
    (0x2F8BD, (0x2D0, 0x2)),
    (0x2FA02, (0x6AA, 0x2)),
    (0x2F93F, (0x040, 0x2)),
    (0x2F808, (0x0BA, 0x2)),
    (0x2F950, (0x476, 0x2)),
    (0x2F933, (0x03C, 0x2)),
    (0x2F853, (0x1A0, 0x2)),
    (0x2F8F0, (0x73A, 0x2)),
    (0x0F967, (0x08C, 0x2)),
    (0x0FA16, (0x402, 0x2)),
    (0x0FAA6, (0x44C, 0x2)),
    (0x2F8B3, (0x2A8, 0x2)),
    (0x2F9F7, (0x7BE, 0x2)),
    (0x0F986, (0x664, 0x2)),
    (0x2F99D, (0x554, 0x2)),
    (0x2F9B8, (0x58E, 0x2)),
    (0x0F998, (0x616, 0x2)),
    (0x2F82B, (0x132, 0x2)),
    (0x2F872, (0x1F8, 0x2)),
    (0x0FAB9, (0x5D0, 0x2)),
    (0x0FA9B, (0x3C4, 0x2)),
    (0x0F9B0, (0x50C, 0x2)),
    (0x0F98B, (0x308, 0x2)),
    (0x0FAD1, (0x734, 0x2)),
    (0x0F917, (0x414, 0x2)),
    (0x2F989, (0x72E, 0x2)),
    (0x2F866, (0x1DC, 0x2)),
    (0x0F932, (0x3E8, 0x2)),
    (0x2FA0E, (0x086, 0x2)),
    (0x0FA07, (0x61E, 0x2)),
    (0x0F9BD, (0x1FE, 0x2)),
    (0x2F88C, (0x232, 0x2)),
    (0x0FA56, (0x4B4, 0x2)),
    (0x0FA64, (0x600, 0x2)),
    (0x0FA04, (0x1E8, 0x2)),
    (0x0FA9E, (0x3F0, 0x2)),
    (0x2F9E0, (0x7B0, 0x2)),
    (0x2F89D, (0x25C, 0x2)),
    (0x2F9EE, (0x662, 0x2)),
    (0x0F9DB, (0x40C, 0x2)),
    (0x0F923, (0x578, 0x2)),
    (0x2F841, (0x16A, 0x2)),
    (0x2F81A, (0x0E8, 0x2)),
    (0x0F911, (0x5A0, 0x2)),
    (0x0FAAD, (0x4B6, 0x2)),
    (0x0FAC1, (0x604, 0x2)),
    (0x2F928, (0x408, 0x2)),
    (0x2F935, (0x756, 0x2)),
    (0x2F8D5, (0x304, 0x2)),
    (0x0F92E, (0x0EE, 0x2)),
    (0x0FA59, (0x4EE, 0x2)),
    (0x2F96B, (0x77E, 0x2)),
    (0x2F8B9, (0x2BE, 0x2)),
    (0x2F877, (0x200, 0x2)),
    (0x2FA00, (0x6A2, 0x2)),
    (0x0FA05, (0x37E, 0x2)),
    (0x0F9E8, (0x5B6, 0x2)),
    (0x2F8C6, (0x2DA, 0x2)),
    (0x0F97A, (0x334, 0x2)),
    (0x2F9EA, (0x654, 0x2)),
    (0x0F944, (0x4BE, 0x2)),
    (0x2F8C4, (0x2DC, 0x2)),
    (0x2F9CD, (0x072, 0x2)),
    (0x2F8E5, (0x330, 0x2)),
    (0x2F9D9, (0x6FE, 0x2)),
    (0x2F980, (0x72C, 0x2)),
    (0x2F9A8, (0x56E, 0x2)),
    (0x2F92F, (0x41E, 0x2)),
    (0x2F951, (0x04C, 0x2)),
    (0x2F9F9, (0x07C, 0x2)),
    (0x0FAB4, (0x560, 0x2)),
    (0x0F985, (0x47A, 0x2)),
    (0x2F829, (0x12C, 0x2)),
    (0x2F8A2, (0x01A, 0x2)),
    (0x2F9C3, (0x5AA, 0x2)),
    (0x2F936, (0x434, 0x2)),
    (0x2F9AF, (0x068, 0x2)),
    (0x0FA77, (0x128, 0x2)),
    (0x0F956, (0x4A0, 0x2)),
    (0x0FA5F, (0x568, 0x2)),
    (0x2F93B, (0x75A, 0x2)),
    (0x0F914, (0x346, 0x2)),
    (0x2F994, (0x53C, 0x2)),
    (0x2F91B, (0x6F8, 0x2)),
    (0x2F880, (0x21A, 0x2)),
    (0x2F956, (0x498, 0x2)),
    (0x0F958, (0x562, 0x2)),
    (0x2F99B, (0x552, 0x2)),
    (0x2FA06, (0x6B6, 0x2)),
    (0x0FABF, (0x5EA, 0x2)),
    (0x2F8B6, (0x2B8, 0x2)),
    (0x2F8A0, (0x26A, 0x2)),
    (0x0FA87, (0x280, 0x2)),
    (0x2F8EA, (0x344, 0x2)),
    (0x2F867, (0x00A, 0x2)),
    (0x0F97D, (0x5D4, 0x2)),
    (0x0F968, (0x374, 0x2)),
    (0x0FA5A, (0x4F4, 0x2)),
    (0x0F97B, (0x4CC, 0x2)),
    (0x2FA10, (0x7C8, 0x2)),
    (0x0FA2B, (0x6AE, 0x2)),
    (0x0FA75, (0x0DC, 0x2)),
    (0x0F94D, (0x398, 0x2)),
    (0x0FAD4, (0x044, 0x2)),
    (0x2F8CC, (0x30C, 0x2)),
    (0x0FA8A, (0x284, 0x2)),
    (0x0F9F4, (0x328, 0x2)),
    (0x0FAC6, (0x672, 0x2)),
    (0x0FA9C, (0x3E0, 0x2)),
    (0x0FA10, (0x1AA, 0x2)),
    (0x0F9E2, (0x33C, 0x2)),
    (0x0F947, (0x472, 0x2)),
    (0x0F941, (0x5D6, 0x2)),
    (0x0FA4E, (0x480, 0x2)),
    (0x2F9DA, (0x60C, 0x2)),
    (0x2F893, (0x526, 0x2)),
    (0x0F96F, (0x5CC, 0x2)),
    (0x0F983, (0x2F0, 0x2)),
    (0x0F9F5, (0x396, 0x2)),
    (0x0F962, (0x43A, 0x2)),
    (0x2F968, (0x4CE, 0x2)),
    (0x2F923, (0x750, 0x2)),
    (0x2FA18, (0x6DE, 0x2)),
    (0x2F930, (0x424, 0x2)),
    (0x0FA90, (0x2E8, 0x2)),
    (0x0FA54, (0x4A2, 0x2)),
    (0x0F9D8, (0x254, 0x2)),
    (0x2F9E4, (0x63E, 0x2)),
    (0x2FA05, (0x6B4, 0x2)),
    (0x2F964, (0x052, 0x2)),
    (0x0F99F, (0x3D6, 0x2)),
    (0x2F94B, (0x048, 0x2)),
    (0x2F9A9, (0x570, 0x2)),
    (0x0FA0C, (0x0C6, 0x2)),
    (0x2F986, (0x1DE, 0x2)),
    (0x0FA85, (0x25A, 0x2)),
    (0x2F95F, (0x4B0, 0x2)),
    (0x0F9F8, (0x4B2, 0x2)),
    (0x0F9B4, (0x6A0, 0x2)),
    (0x2F82E, (0x13C, 0x2)),
    (0x0FAD9, (0x6EC, 0x2)),
    (0x2F937, (0x758, 0x2)),
    (0x0F9CF, (0x4D2, 0x2)),
    (0x0FAA1, (0x422, 0x2)),
    (0x2F917, (0x3CA, 0x2)),
    (0x0FAA5, (0x444, 0x2)),
    (0x0FA3B, (0x204, 0x2)),
    (0x2F88D, (0x234, 0x2)),
    (0x2F906, (0x742, 0x2)),
    (0x2F901, (0x390, 0x2)),
    (0x2F97A, (0x50A, 0x2)),
    (0x0FA60, (0x5BC, 0x2)),
    (0x2F92C, (0x038, 0x2)),
    (0x2F80A, (0x0C4, 0x2)),
    (0x2F99A, (0x550, 0x2)),
    (0x2FA13, (0x7CC, 0x2)),
    (0x2F938, (0x43C, 0x2)),
    (0x2F813, (0x002, 0x2)),
    (0x2F831, (0x144, 0x2)),
    (0x0FA1C, (0x68E, 0x2)),
    (0x0FACC, (0x6A6, 0x2)),
    (0x0FA5E, (0x532, 0x2)),
    (0x2F995, (0x53E, 0x2)),
    (0x2F8D3, (0x0E2, 0x2)),
    (0x0FACD, (0x6BE, 0x2)),
    (0x2F81D, (0x0F8, 0x2)),
    (0x2F97B, (0x78A, 0x2)),
    (0x0FA3A, (0x1B0, 0x2)),
    (0x0F9C6, (0x668, 0x2)),
    (0x0FABD, (0x5E2, 0x2)),
    (0x0F92D, (0x0AA, 0x2)),
    (0x0F99B, (0x65C, 0x2)),
    (0x0F91D, (0x354, 0x2)),
    (0x2F84D, (0x19A, 0x2)),
    (0x2F8AD, (0x292, 0x2)),
    (0x0F9D3, (0x670, 0x2)),
    (0x2F843, (0x16E, 0x2)),
    (0x0F97C, (0x52E, 0x2)),
    (0x0FA30, (0x0AE, 0x2)),
    (0x2F858, (0x1B2, 0x2)),
    (0x2F8A5, (0x270, 0x2)),
    (0x2F988, (0x792, 0x2)),
    (0x2F9E1, (0x7B2, 0x2)),
    (0x0FA74, (0x0C8, 0x2)),
    (0x2F882, (0x222, 0x2)),
    (0x2F879, (0x20E, 0x2)),
    (0x2F8B7, (0x2C0, 0x2)),
    (0x0F940, (0x6D2, 0x2)),
    (0x2F9E5, (0x7B4, 0x2)),
    (0x2F9CF, (0x5CA, 0x2)),
    (0x0FA8E, (0x2D2, 0x2)),
    (0x2F90C, (0x3A8, 0x2)),
    (0x2F985, (0x51E, 0x2)),
    (0x2F849, (0x184, 0x2)),
    (0x2F960, (0x050, 0x2)),
    (0x2F8C2, (0x01E, 0x2)),
    (0x2F85F, (0x1CE, 0x2)),
    (0x2F916, (0x034, 0x2)),
    (0x0F9FA, (0x3FE, 0x2)),
    (0x2F824, (0x008, 0x2)),
    (0x0F936, (0x586, 0x2)),
    (0x2F94A, (0x464, 0x2)),
    (0x2F80E, (0x0CC, 0x2)),
    (0x2F913, (0x3C8, 0x2)),
    (0x2F94D, (0x76A, 0x2)),
    (0x0F999, (0x56C, 0x2)),
    (0x2F979, (0x502, 0x2)),
    (0x2F926, (0x752, 0x2)),
    (0x0F9EA, (0x67E, 0x2)),
    (0x0FA3F, (0x28A, 0x2)),
    (0x2F83B, (0x156, 0x2)),
    (0x0FA5B, (0x506, 0x2)),
    (0x0FA93, (0x316, 0x2)),
    (0x0F913, (0x632, 0x2)),
    (0x0F98C, (0x35C, 0x2)),
    (0x2F8C0, (0x2CE, 0x2)),
    (0x0FAD7, (0x7AC, 0x2)),
    (0x0F98A, (0x110, 0x2)),
    (0x0FA26, (0x63C, 0x2)),
    (0x0FABE, (0x5D8, 0x2)),
    (0x2F977, (0x788, 0x2)),
    (0x0F954, (0x0F4, 0x2)),
    (0x0F91A, (0x6B8, 0x2)),
    (0x2F8CD, (0x2F8, 0x2)),
    (0x2F8A4, (0x71E, 0x2)),
    (0x0FA84, (0x250, 0x2)),
    (0x2F85E, (0x1C4, 0x2)),
    (0x0FA9F, (0x3FC, 0x2)),
    (0x0F9B1, (0x64E, 0x2)),
    (0x2F9CA, (0x004, 0x2)),
    (0x0FAC4, (0x644, 0x2)),
    (0x0F927, (0x5A6, 0x2)),
    (0x0FA01, (0x22E, 0x2)),
    (0x0F929, (0x310, 0x2)),
    (0x0F9F3, (0x6D6, 0x2)),
    (0x2F9E6, (0x640, 0x2)),
    (0x0FA70, (0x08E, 0x2)),
    (0x2F820, (0x106, 0x2)),
    (0x0F9A9, (0x196, 0x2)),
    (0x2F9BF, (0x06C, 0x2)),
    (0x2F922, (0x3F4, 0x2)),
    (0x2F9DE, (0x614, 0x2)),
    (0x2F8EC, (0x738, 0x2)),
    (0x0F9B5, (0x0AC, 0x2)),
    (0x2F9B7, (0x590, 0x2)),
    (0x2F981, (0x05C, 0x2)),
    (0x0FA31, (0x0C2, 0x2)),
    (0x2F9C1, (0x5A4, 0x2)),
    (0x2F874, (0x24C, 0x2)),
    (0x0F9D0, (0x6A8, 0x2)),
    (0x0F94A, (0x1B6, 0x2)),
    (0x2F998, (0x542, 0x2)),
    (0x2F91C, (0x3DA, 0x2)),
    (0x2F9DF, (0x61C, 0x2)),
    (0x2F859, (0x706, 0x2)),
    (0x2F883, (0x010, 0x2)),
    (0x0F9CC, (0x418, 0x2)),
    (0x2F9B5, (0x58A, 0x2)),
    (0x2F970, (0x4F0, 0x2)),
    (0x2F814, (0x0D2, 0x2)),
    (0x2F9FF, (0x69E, 0x2)),
    (0x2F84C, (0x18E, 0x2)),
    (0x2F9A4, (0x796, 0x2)),
    (0x2F966, (0x4C6, 0x2)),
    (0x0FA1E, (0x500, 0x2)),
    (0x2FA0C, (0x6C8, 0x2)),
    (0x2F863, (0x1D6, 0x2)),
    (0x0FAA2, (0x42E, 0x2)),
    (0x2F91A, (0x3D4, 0x2)),
    (0x2F8F8, (0x710, 0x2)),
    (0x2F8A6, (0x27A, 0x2)),
    (0x2F895, (0x24A, 0x2)),
    (0x0F90B, (0x178, 0x2)),
    (0x2F993, (0x53A, 0x2)),
    (0x2F8BE, (0x726, 0x2)),
    (0x0F948, (0x5FC, 0x2)),
    (0x2F80D, (0x6FC, 0x2)),
    (0x2F81F, (0x006, 0x2)),
    (0x0F9E4, (0x416, 0x2)),
    (0x2F823, (0x10C, 0x2)),
    (0x2F9FA, (0x694, 0x2)),
    (0x2F8FA, (0x36C, 0x2)),
    (0x0FA6A, (0x6A4, 0x2)),
    (0x2F9F0, (0x666, 0x2)),
    (0x2F967, (0x054, 0x2)),
    (0x0FA8F, (0x2D6, 0x2)),
    (0x0FA06, (0x306, 0x2)),
    (0x0F982, (0x242, 0x2)),
    (0x0F989, (0x6DA, 0x2)),
    (0x2F990, (0x534, 0x2)),
    (0x0FAC9, (0x692, 0x2)),
    (0x2F8ED, (0x352, 0x2)),
    (0x2F822, (0x10A, 0x2)),
    (0x0F9CB, (0x3A4, 0x2)),
    (0x0FA4D, (0x482, 0x2)),
    (0x2F944, (0x766, 0x2)),
    (0x2F9E8, (0x656, 0x2)),
    (0x2F8D2, (0x0E0, 0x2)),
    (0x2F97C, (0x78C, 0x2)),
    (0x0FA68, (0x680, 0x2)),
    (0x0FA53, (0x494, 0x2)),
    (0x2F8F5, (0x368, 0x2)),
    (0x2F945, (0x458, 0x2)),
    (0x0FA95, (0x35E, 0x2)),
    (0x0FA2E, (0x638, 0x2)),
    (0x0F91B, (0x09A, 0x2)),
    (0x2F837, (0x14E, 0x2)),
    (0x2F894, (0x248, 0x2)),
    (0x2FA09, (0x7C6, 0x2)),
    (0x2F974, (0x05A, 0x2)),
    (0x0F9BA, (0x09C, 0x2)),
    (0x2F80B, (0x0BE, 0x2)),
    (0x0FACA, (0x698, 0x2)),
    (0x2F969, (0x4CA, 0x2)),
    (0x2F8B1, (0x2A2, 0x2)),
    (0x2F8D1, (0x022, 0x2)),
    (0x2F91D, (0x74A, 0x2)),
    (0x2F9D4, (0x5F8, 0x2)),
    (0x2FA15, (0x6D8, 0x2)),
    (0x2F954, (0x76E, 0x2)),
    (0x0FA81, (0x1E2, 0x2)),
    (0x2F9A5, (0x79A, 0x2)),
    (0x2F90F, (0x3BA, 0x2)),
    (0x0F92A, (0x38C, 0x2)),
    (0x2FA19, (0x6E0, 0x2)),
    (0x2F943, (0x764, 0x2)),
    (0x2F947, (0x45C, 0x2)),
    (0x2FA0A, (0x6C0, 0x2)),
    (0x2F963, (0x4BA, 0x2)),
    (0x0F9BB, (0x0C0, 0x2)),
    (0x2F8AC, (0x296, 0x2)),
    (0x0F9C5, (0x2FE, 0x2)),
    (0x2F97E, (0x78E, 0x2)),
    (0x2F889, (0x716, 0x2)),
    (0x2F8E9, (0x342, 0x2)),
    (0x0F9DA, (0x32E, 0x2)),
    (0x0FACE, (0x6F2, 0x2)),
    (0x2F920, (0x3EC, 0x2)),
    (0x0F951, (0x66A, 0x2)),
    (0x0F9BC, (0x1F4, 0x2)),
    (0x2F940, (0x454, 0x2)),
    (0x2F84E, (0x190, 0x2)),
    (0x0FA48, (0x3DE, 0x2)),
    (0x2FA08, (0x082, 0x2)),
    (0x0F9E6, (0x4F6, 0x2)),
    (0x2F8C8, (0x2E6, 0x2)),
    (0x0F912, (0x5B8, 0x2)),
    (0x2F8F7, (0x73C, 0x2)),
    (0x2F904, (0x392, 0x2)),
    (0x0FA76, (0x116, 0x2)),
    (0x2F8E8, (0x340, 0x2)),
    (0x2F9E2, (0x634, 0x2)),
    (0x0F903, (0x5FE, 0x2)),
    (0x0FA9A, (0x3B6, 0x2)),
    (0x0F996, (0x4E2, 0x2)),
    (0x2F8DB, (0x322, 0x2)),
    (0x0FA4A, (0x41A, 0x2)),
    (0x0FA6B, (0x268, 0x2)),
    (0x2F8FD, (0x376, 0x2)),
    (0x0FA79, (0x170, 0x2)),
    (0x0F987, (0x6BC, 0x2)),
    (0x2F8F2, (0x030, 0x2)),
    (0x0F90D, (0x2A0, 0x2)),
    (0x0F922, (0x3BE, 0x2)),
    (0x0FA88, (0x276, 0x2)),
    (0x0F91C, (0x140, 0x2)),
    (0x2F870, (0x1F6, 0x2)),
    (0x2F9AC, (0x576, 0x2)),
    (0x2F839, (0x152, 0x2)),
    (0x2FA03, (0x080, 0x2)),
    (0x2F854, (0x1A2, 0x2)),
    (0x2F92A, (0x036, 0x2)),
    (0x0FA35, (0x138, 0x2)),
    (0x2F9E7, (0x650, 0x2)),
    (0x2F9A6, (0x798, 0x2)),
    (0x0FAAF, (0x4D8, 0x2)),
    (0x2F911, (0x748, 0x2)),
    (0x2F95D, (0x774, 0x2)),
    (0x2F89C, (0x256, 0x2)),
    (0x0FA45, (0x38E, 0x2)),
    (0x0FA1B, (0x496, 0x2)),
    (0x0FA3D, (0x26C, 0x2)),
    (0x0F980, (0x15E, 0x2)),
    (0x0FA8C, (0x2AC, 0x2)),
    (0x2F9E9, (0x658, 0x2)),
    (0x2F9F8, (0x07A, 0x2)),
    (0x2F902, (0x388, 0x2)),
    (0x2FA1D, (0x7D2, 0x2)),
    (0x0FAB6, (0x5BE, 0x2)),
    (0x0F995, (0x49C, 0x2)),
    (0x2F832, (0x146, 0x2)),
    (0x2F955, (0x770, 0x2)),
    (0x2F8FC, (0x372, 0x2)),
    (0x2F875, (0x1FC, 0x2)),
    (0x2F82A, (0x12E, 0x2)),
    (0x2F811, (0x0DA, 0x2)),
    (0x2F868, (0x00C, 0x2)),
    (0x2F925, (0x3FA, 0x2)),
    (0x0FA20, (0x57E, 0x2)),
    (0x2F83E, (0x160, 0x2)),
    (0x0F9AF, (0x4FE, 0x2)),
    (0x2F997, (0x794, 0x2)),
    (0x2F9EC, (0x660, 0x2)),
    (0x0F9AB, (0x21E, 0x2)),
    (0x0F935, (0x57C, 0x2)),
    (0x0FA80, (0x1DA, 0x2)),
    (0x2F95C, (0x772, 0x2)),
    (0x0FA92, (0x312, 0x2)),
    (0x0F95B, (0x2B4, 0x2)),
    (0x0F93E, (0x556, 0x2)),
    (0x0F9DE, (0x158, 0x2)),
    (0x0F9F0, (0x57A, 0x2)),
    (0x2F847, (0x17C, 0x2)),
    (0x0FA98, (0x3B0, 0x2)),
    (0x0F90E, (0x448, 0x2)),
    (0x0FA4F, (0x484, 0x2)),
    (0x0FAA4, (0x442, 0x2)),
    (0x2F9C0, (0x5A2, 0x2)),
    (0x2F8BF, (0x2D4, 0x2)),
    (0x0FA62, (0x5E4, 0x2)),
    (0x0F9B6, (0x49A, 0x2)),
    (0x2F826, (0x11C, 0x2)),
    (0x0F9C9, (0x32A, 0x2)),
    (0x2F992, (0x114, 0x2)),
    (0x2F8E1, (0x332, 0x2)),
    (0x0F959, (0x66E, 0x2)),
    (0x2F892, (0x71C, 0x2)),
    (0x0FA18, (0x47C, 0x2)),
    (0x2F87D, (0x714, 0x2)),
    (0x0F970, (0x364, 0x2)),
    (0x2F92B, (0x410, 0x2)),
    (0x2FA04, (0x6B2, 0x2)),
    (0x0FA89, (0x28C, 0x2)),
    (0x2F9E3, (0x63A, 0x2)),
    (0x2F9C2, (0x06E, 0x2)),
    (0x0FACB, (0x69A, 0x2)),
    (0x2F9C8, (0x070, 0x2)),
    (0x2F908, (0x3A0, 0x2)),
    (0x2F86F, (0x1F2, 0x2)),
    (0x2F98A, (0x730, 0x2)),
    (0x0F9A8, (0x0A4, 0x2)),
    (0x2F8C7, (0x020, 0x2)),
    (0x2FA16, (0x08A, 0x2)),
    (0x0FA4B, (0x470, 0x2)),
    (0x2F878, (0x20A, 0x2)),
    (0x2F8BB, (0x2C2, 0x2)),
    (0x2F816, (0x6FA, 0x2)),
    (0x2F86A, (0x1E4, 0x2)),
    (0x0F9C3, (0x630, 0x2)),
    (0x0F945, (0x514, 0x2)),
    (0x2F9FE, (0x69C, 0x2)),
    (0x0FA86, (0x272, 0x2)),
    (0x2F82C, (0x136, 0x2)),
    (0x0F988, (0x6D4, 0x2)),
    (0x0FAC5, (0x652, 0x2)),
    (0x0FA66, (0x626, 0x2)),
    (0x2F840, (0x166, 0x2)),
    (0x0F9EE, (0x3E6, 0x2)),
    (0x2F830, (0x142, 0x2)),
    (0x2F914, (0x3C6, 0x2)),
    (0x2F942, (0x760, 0x2)),
    (0x0FAA3, (0x432, 0x2)),
    (0x0F974, (0x540, 0x2)),
    (0x2F807, (0x0B6, 0x2)),
    (0x2F905, (0x394, 0x2)),
    (0x2F9B2, (0x06A, 0x2)),
    (0x2F887, (0x22A, 0x2)),
    (0x2F912, (0x3BC, 0x2)),
    (0x0F9AE, (0x420, 0x2)),
    (0x0F96A, (0x4D4, 0x2)),
    (0x0F9B7, (0x646, 0x2)),
    (0x2F932, (0x42C, 0x2)),
    (0x2F98D, (0x622, 0x2)),
    (0x0FA25, (0x62A, 0x2)),
    (0x0F993, (0x3DC, 0x2)),
    (0x2F9F5, (0x688, 0x2)),
    (0x0F9DF, (0x206, 0x2)),
    (0x2F9C7, (0x5B4, 0x2)),
    (0x2F996, (0x544, 0x2)),
    (0x2F842, (0x16C, 0x2)),
    (0x2F869, (0x1E0, 0x2)),
    (0x2F861, (0x70A, 0x2)),
    (0x2F8AF, (0x298, 0x2)),
    (0x2F8C5, (0x2E0, 0x2)),
    (0x2F962, (0x4B8, 0x2)),
    (0x2F98B, (0x528, 0x2)),
    (0x2F9A1, (0x558, 0x2)),
    (0x0FAD2, (0x02A, 0x2)),
    (0x2F9AE, (0x066, 0x2)),
    (0x2F8BC, (0x2C6, 0x2)),
    (0x0F9B3, (0x68C, 0x2)),
    (0x2F88F, (0x7D0, 0x2)),
    (0x0F965, (0x0B4, 0x2)),
    (0x2F953, (0x488, 0x2)),
    (0x2F84B, (0x198, 0x2)),
    (0x2F90B, (0x3AC, 0x2)),
    (0x2F834, (0x702, 0x2)),
    (0x0FA2D, (0x6CC, 0x2)),
    (0x2F8E6, (0x33E, 0x2)),
    (0x0F971, (0x624, 0x2)),
    (0x2FA1C, (0x6E6, 0x2)),
    (0x0FA61, (0x5C6, 0x2)),
    (0x2F98E, (0x062, 0x2)),
    (0x2F9C9, (0x5BA, 0x2)),
    (0x0FA0B, (0x23E, 0x2)),
    (0x2F86B, (0x1E6, 0x2)),
    (0x0F949, (0x686, 0x2)),
    (0x0FAC7, (0x682, 0x2)),
    (0x0F96E, (0x566, 0x2)),
    (0x0F966, (0x258, 0x2)),
    (0x0F955, (0x0F2, 0x2)),
    (0x2F8D0, (0x024, 0x2)),
    (0x2F93A, (0x440, 0x2)),
    (0x0F9FF, (0x104, 0x2)),
    (0x0FAC8, (0x690, 0x2)),
    (0x0F93C, (0x490, 0x2)),
    (0x2F845, (0x174, 0x2)),
    (0x2F9CE, (0x074, 0x2)),
    (0x0FAD6, (0x77C, 0x2)),
    (0x2F95A, (0x4A6, 0x2)),
    (0x0F9E9, (0x648, 0x2)),
    (0x2F91F, (0x74E, 0x2)),
    (0x0F950, (0x4EC, 0x2)),
    (0x2F8C1, (0x2CA, 0x2)),
    (0x2F9AD, (0x79C, 0x2)),
    (0x2F97F, (0x512, 0x2)),
    (0x0FA83, (0x240, 0x2)),
    (0x2F82D, (0x13A, 0x2)),
    (0x2F8DF, (0x32C, 0x2)),
    (0x2F87C, (0x212, 0x2)),
    (0x0FA58, (0x4EA, 0x2)),
    (0x2F846, (0x176, 0x2)),
    (0x0FA37, (0x18C, 0x2)),
    (0x0FA78, (0x180, 0x2)),
    (0x2F9F6, (0x7BA, 0x2)),
    (0x2F99E, (0x55E, 0x2)),
    (0x0FAD3, (0x042, 0x2)),
    (0x0FAD0, (0x720, 0x2)),
    (0x0F9D5, (0x210, 0x2)),
    (0x0FAB7, (0x5C2, 0x2)),
    (0x0FA09, (0x66C, 0x2)),
    (0x2F8CE, (0x026, 0x2)),
    (0x0F957, (0x4DE, 0x2)),
    (0x0F991, (0x2DE, 0x2)),
    (0x0FAB8, (0x5C8, 0x2)),
    (0x2F8EB, (0x34E, 0x2)),
    (0x2F9B1, (0x7A0, 0x2)),
    (0x0FA2A, (0x6AC, 0x2)),
    (0x2F93C, (0x75C, 0x2)),
    (0x0FA72, (0x0D4, 0x2)),
    (0x2F96F, (0x4E8, 0x2)),
    (0x2F8D6, (0x518, 0x2)),
    (0x2F886, (0x228, 0x2)),
    (0x0F9FD, (0x0A0, 0x2)),
    (0x0F9C0, (0x3E4, 0x2)),
    (0x2F9BE, (0x59E, 0x2)),
    (0x0F9B8, (0x67A, 0x2)),
    (0x2F81E, (0x0FA, 0x2)),
    (0x0F900, (0x5F4, 0x2)),
    (0x2F98C, (0x52A, 0x2)),
    (0x2F93E, (0x03E, 0x2)),
    (0x0FAA0, (0x404, 0x2)),
    (0x2F8F3, (0x35A, 0x2)),
    (0x0F961, (0x40A, 0x2)),
    (0x2F83D, (0x15C, 0x2)),
    (0x2F8F6, (0x36A, 0x2)),
    (0x0F9D2, (0x2AA, 0x2)),
    (0x2F84A, (0x188, 0x2)),
    (0x0F9E1, (0x31C, 0x2)),
    (0x0FA7C, (0x1AC, 0x2)),
    (0x2F9AA, (0x574, 0x2)),
    (0x0FA51, (0x48A, 0x2)),
    (0x2F8B8, (0x724, 0x2)),
    (0x2F931, (0x426, 0x2)),
    (0x0FA7E, (0x1C6, 0x2)),
    (0x0F9A6, (0x4BC, 0x2)),
    (0x0F976, (0x438, 0x2)),
    (0x0FA97, (0x386, 0x2)),
    (0x2F8E7, (0x02C, 0x2)),
    (0x2F88B, (0x230, 0x2)),
    (0x2F9C6, (0x5B2, 0x2)),
    (0x2F8D9, (0x318, 0x2)),
    (0x0FA52, (0x492, 0x2)),
    (0x2FA0D, (0x084, 0x2)),
    (0x2F900, (0x382, 0x2)),
    (0x2F836, (0x14C, 0x2)),
    (0x0F9AD, (0x412, 0x2)),
    (0x0F934, (0x504, 0x2)),
    (0x0FAB0, (0x4E6, 0x2)),
    (0x2F809, (0x0BC, 0x2)),
    (0x2F9F2, (0x078, 0x2)),
    (0x2F86C, (0x70C, 0x2)),
    (0x0F9FC, (0x5EC, 0x2)),
    (0x2F95E, (0x776, 0x2)),
    (0x0F9A3, (0x260, 0x2)),
    (0x2F971, (0x058, 0x2)),
    (0x2F89B, (0x018, 0x2)),
    (0x0F977, (0x09E, 0x2)),
    (0x0FA1A, (0x48E, 0x2)),
    (0x0FA3C, (0x208, 0x2)),
    (0x2F9BD, (0x598, 0x2)),
    (0x0F928, (0x238, 0x2)),
    (0x2F864, (0x1D8, 0x2)),
    (0x2F9D1, (0x5F2, 0x2)),
    (0x2F982, (0x51A, 0x2)),
    (0x0F9DC, (0x674, 0x2)),
    (0x2F972, (0x782, 0x2)),
    (0x2F8CB, (0x2F4, 0x2)),
    (0x0F960, (0x264, 0x2)),
    (0x0F992, (0x3B8, 0x2)),
    (0x2F8B4, (0x2AE, 0x2)),
    (0x2F803, (0x6F4, 0x2)),
    (0x2F818, (0x0E6, 0x2)),
    (0x0F9F7, (0x4AE, 0x2)),
    (0x2F827, (0x124, 0x2)),
    (0x2F9FB, (0x7C0, 0x2)),
    (0x2F987, (0x790, 0x2)),
    (0x0FAAB, (0x474, 0x2)),
    (0x0FA39, (0x1A8, 0x2)),
    (0x2FA07, (0x6BA, 0x2)),
    (0x0F9B9, (0x274, 0x2)),
    (0x2F86E, (0x1EC, 0x2)),
    (0x2F8E0, (0x326, 0x2)),
    (0x0FAA7, (0x44E, 0x2)),
    (0x2F8A8, (0x282, 0x2)),
    (0x0FA0A, (0x5C4, 0x2)),
    (0x2FA14, (0x7CE, 0x2)),
    (0x2F888, (0x012, 0x2)),
    (0x2F9A2, (0x55A, 0x2)),
    (0x2F848, (0x182, 0x2)),
    (0x0FAA8, (0x452, 0x2)),
    (0x0FA67, (0x62C, 0x2)),
    (0x0F946, (0x3F6, 0x2)),
    (0x2F946, (0x45A, 0x2)),
    (0x0FA7D, (0x1B4, 0x2)),
    (0x0FA1D, (0x4C4, 0x2)),
    (0x2FA11, (0x088, 0x2)),
    (0x0FA2C, (0x6B0, 0x2)),
    (0x0F924, (0x5C0, 0x2)),
    (0x2F96E, (0x4E0, 0x2)),
    (0x0F96D, (0x456, 0x2)),
    (0x0F95A, (0x5EE, 0x2)),
    (0x2F85C, (0x1C0, 0x2)),
    (0x0F92B, (0x400, 0x2)),
    (0x0FAC0, (0x5F0, 0x2)),
    (0x0FA8D, (0x2CC, 0x2)),
    (0x2F9D8, (0x7AE, 0x2)),
    (0x0F938, (0x68A, 0x2)),
    (0x2F821, (0x108, 0x2)),
    (0x0F9AA, (0x1F0, 0x2)),
    (0x0F9CE, (0x46A, 0x2)),
    (0x0FA47, (0x3B4, 0x2)),
    (0x2F8AA, (0x288, 0x2)),
    (0x2F918, (0x3D0, 0x2)),
    (0x2F8EE, (0x02E, 0x2)),
    (0x0F96B, (0x14A, 0x2)),
    (0x0F909, (0x1CA, 0x2)),
    (0x2F87F, (0x216, 0x2)),
    (0x0F908, (0x6F0, 0x2)),
    (0x0FA5D, (0x530, 0x2)),
    (0x0F9AC, (0x266, 0x2)),
    (0x2F896, (0x016, 0x2)),
    (0x2F9B0, (0x79E, 0x2)),
    (0x0F9A7, (0x406, 0x2)),
    (0x0F99D, (0x112, 0x2)),
    (0x2F957, (0x49E, 0x2)),
    (0x0F905, (0x090, 0x2)),
    (0x2F9BC, (0x596, 0x2)),
    (0x2F8F9, (0x73E, 0x2)),
    (0x2F8B0, (0x29E, 0x2)),
    (0x2F881, (0x220, 0x2)),
    (0x2FA1B, (0x6E4, 0x2)),
    (0x2F9DD, (0x700, 0x2)),
    (0x2F9ED, (0x7B6, 0x2)),
    (0x2F871, (0x70E, 0x2)),
    (0x2F8AB, (0x28E, 0x2)),
    (0x2F812, (0x6F6, 0x2)),
    (0x0F933, (0x450, 0x2)),
    (0x0F9F2, (0x6C6, 0x2)),
    (0x0F984, (0x3C0, 0x2)),
    (0x2F90E, (0x39C, 0x2)),
    (0x0FAB2, (0x508, 0x2)),
    (0x0FA32, (0x0CA, 0x2)),
    (0x2F96D, (0x056, 0x2)),
    (0x2F9A7, (0x064, 0x2)),
    (0x0F94F, (0x4D6, 0x2)),
    (0x2FA0F, (0x6CA, 0x2)),
    (0x0F925, (0x2B2, 0x2)),
    (0x0FA91, (0x2FC, 0x2)),
    (0x0F972, (0x370, 0x2)),
    (0x0F90A, (0x64C, 0x2)),
    (0x0FA02, (0x2B6, 0x2)),
    (0x0F92F, (0x120, 0x2)),
    (0x0F9DD, (0x102, 0x2)),
    (0x0FA17, (0x44A, 0x2)),
    (0x0F93F, (0x65A, 0x2)),
    (0x2F898, (0x780, 0x2)),
    (0x2F907, (0x380, 0x2)),
    (0x0F9EC, (0x3A6, 0x2)),
    (0x0F9E3, (0x378, 0x2)),
    (0x0FAB5, (0x59A, 0x2)),
    (0x0FA40, (0x29A, 0x2)),
    (0x2F815, (0x0DE, 0x2)),
    (0x2F9DB, (0x60A, 0x2)),
    (0x0F91E, (0x3EA, 0x2)),
    (0x0F92C, (0x636, 0x2)),
    (0x2F884, (0x224, 0x2)),
    (0x0FA46, (0x39E, 0x2)),
    (0x2F9B3, (0x584, 0x2)),
    (0x2F85B, (0x1BE, 0x2)),
    (0x0F9CD, (0x436, 0x2)),
    (0x0F93A, (0x6CE, 0x2)),
    (0x0F97E, (0x64A, 0x2)),
    (0x0FA3E, (0x286, 0x2)),
    (0x2F9EB, (0x65E, 0x2)),
    (0x2F8E2, (0x338, 0x2)),
    (0x2F9B6, (0x58C, 0x2)),
    (0x0F916, (0x3D8, 0x2)),
    (0x2F8DE, (0x028, 0x2)),
    (0x0F98F, (0x290, 0x2)),
    (0x0FA12, (0x2FA, 0x2)),
    (0x0FA44, (0x336, 0x2)),
    (0x0F981, (0x1D0, 0x2)),
    (0x2F9DC, (0x610, 0x2)),
    (0x0F95C, (0x348, 0x2)),
    (0x0F937, (0x60E, 0x2)),
    (0x2F87A, (0x20C, 0x2)),
    (0x2F903, (0x38A, 0x2)),
    (0x2F9C5, (0x7A4, 0x2)),
    (0x2F8CF, (0x302, 0x2)),
    (0x2F909, (0x3A2, 0x2)),
    (0x2F991, (0x538, 0x2)),
    (0x0FA65, (0x602, 0x2)),
    (0x0FA73, (0x0A8, 0x2)),
    (0x2F88E, (0x23A, 0x2)),
    (0x0F9EF, (0x42A, 0x2)),
    (0x2F9CB, (0x7A6, 0x2)),
    (0x2F9A3, (0x55C, 0x2)),
    (0x2F99C, (0x548, 0x2)),
    (0x2F919, (0x3CE, 0x2)),
    (0x2F857, (0x1A4, 0x2)),
    (0x2F96C, (0x4DA, 0x2)),
    (0x2F800, (0x096, 0x2)),
    (0x2FA1A, (0x6E2, 0x2)),
    (0x0F97F, (0x126, 0x2)),
    (0x0FABA, (0x5DE, 0x2)),
    (0x0FA82, (0x23C, 0x2)),
    (0x2F92E, (0x41C, 0x2)),
    (0x0F9FE, (0x54A, 0x2)),
    (0x0F994, (0x428, 0x2)),
    (0x2F83C, (0x164, 0x2)),
    (0x0FA50, (0x486, 0x2)),
    (0x2F817, (0x0E4, 0x2)),
    (0x0FA38, (0x192, 0x2)),
    (0x0FA69, (0x696, 0x2)),
    (0x0FAAC, (0x4AC, 0x2)),
    (0x0F901, (0x30A, 0x2)),
    (0x0FA33, (0x11A, 0x2)),
    (0x0F9BF, (0x34A, 0x2)),
    (0x0F9D1, (0x0D8, 0x2)),
    (0x0F95F, (0x1EE, 0x2)),
    (0x2F82F, (0x13E, 0x2)),
    (0x0F9A4, (0x2C4, 0x2)),
    (0x2F89E, (0x25E, 0x2)),
    (0x2F801, (0x092, 0x2)),
    (0x2F84F, (0x194, 0x2)),
    (0x2F961, (0x778, 0x2)),
    (0x2F87E, (0x218, 0x2)),
    (0x2F9D5, (0x5FA, 0x2)),
    (0x0F9E7, (0x5B0, 0x2)),
    (0x0F973, (0x2BC, 0x2)),
    (0x0F9C2, (0x572, 0x2)),
    (0x2F9D0, (0x5DA, 0x2)),
    (0x0F9A5, (0x362, 0x2)),
    (0x2F80C, (0x000, 0x2)),
    (0x0F930, (0x2E2, 0x2)),
    (0x2F8A1, (0x01C, 0x2)),
    (0x2F828, (0x12A, 0x2)),
    (0x2F89F, (0x262, 0x2)),
    (0x0F964, (0x478, 0x2)),
    (0x0F94E, (0x3B2, 0x2)),
    (0x2F8D7, (0x05E, 0x2)),
    (0x2F806, (0x0B2, 0x2)),
    (0x2F9CC, (0x7A8, 0x2)),
    (0x2F94E, (0x468, 0x2)),
    (0x2F929, (0x40E, 0x2)),
    (0x0FA34, (0x122, 0x2)),
    (0x2F939, (0x718, 0x2)),
    (0x0F910, (0x582, 0x2)),
    (0x0F926, (0x520, 0x2)),
    (0x0F9A2, (0x236, 0x2)),
    (0x0FA49, (0x3EE, 0x2)),
    (0x0F953, (0x516, 0x2)),
    (0x2F80F, (0x0CE, 0x2)),
    (0x0F963, (0x130, 0x2)),
    (0x2F8D4, (0x30E, 0x2)),
    (0x0F9B2, (0x684, 0x2)),
    (0x2F973, (0x784, 0x2)),
    (0x2F897, (0x72A, 0x2)),
    (0x2F9FC, (0x07E, 0x2)),
    (0x0F99A, (0x628, 0x2)),
    (0x2F85A, (0x1BC, 0x2)),
    (0x0FACF, (0x722, 0x2)),
    (0x2F9AB, (0x7A2, 0x2)),
    (0x2F927, (0x754, 0x2)),
    (0x2F9FD, (0x7C2, 0x2)),
    (0x0FA36, (0x17E, 0x2)),
    (0x0F904, (0x3AE, 0x2)),
    (0x2F81C, (0x7BC, 0x2)),
    (0x0FA7B, (0x18A, 0x2)),
    (0x0FA41, (0x2E4, 0x2)),
    (0x2F87B, (0x712, 0x2)),
    (0x2F9BA, (0x592, 0x2)),
    (0x0F979, (0x0F0, 0x2)),
    (0x0F9D7, (0x618, 0x2)),
];

pub(crate) const COMBINING_MARK_SALT: &[u16] = &[
    0x000, 0x000, 0x002, 0x001, 0x008, 0x005, 0x969, 0x1EE, 0x007, 0x0CD, 0x2D9, 0x012, 0x003,
    0x000, 0x000, 0x2D4, 0x000, 0x0C7, 0x14A, 0x000, 0x001, 0x38A, 0x000, 0x000, 0x007, 0x083,
    0x00A, 0x000, 0x000, 0x000, 0x001, 0x02B, 0x05D, 0x000, 0x000, 0x000, 0x0A0, 0x000, 0x005,
    0x000, 0x04B, 0x15D, 0x000, 0x023, 0x0BA, 0x000, 0x000, 0x000, 0x000, 0x058, 0x005, 0x002,
    0x005, 0x000, 0x064, 0x002, 0x000, 0x002, 0x019, 0x000, 0x001, 0x0EC, 0x001, 0x103, 0x026,
    0x011, 0x000, 0x001, 0x000, 0x000, 0x040, 0x003, 0x01C, 0x001, 0x023, 0x000, 0x002, 0x001,
    0x014, 0x000, 0x0B4, 0x000, 0x0A0, 0x0D8, 0x000, 0x003, 0x003, 0x08C, 0x02E, 0x000, 0x000,
    0x00E, 0x009, 0x000, 0x000, 0x02E, 0x001, 0x001, 0x000, 0x000, 0x000, 0x079, 0x001, 0x000,
    0x000, 0x036, 0x000, 0x001, 0x000, 0x000, 0x004, 0x03A, 0x000, 0x001, 0x01C, 0x180, 0x002,
    0x006, 0x0CA, 0x002, 0x000, 0x000, 0x000, 0x000, 0x076, 0x083, 0x000, 0x007, 0x07A, 0x000,
    0x018, 0x009, 0x070, 0x0AA, 0x000, 0x00F, 0x03C, 0x002, 0x000, 0x008, 0x000, 0x021, 0x008,
    0x03D, 0x019, 0x017, 0x003, 0x003, 0x017, 0x003, 0x018, 0x000, 0x000, 0x006, 0x001, 0x002,
    0x000, 0x004, 0x000, 0x004, 0x011, 0x034, 0x000, 0x004, 0x000, 0x000, 0x000, 0x000, 0x013,
    0x002, 0x000, 0x003, 0x016, 0x000, 0x007, 0x033, 0x006, 0x021, 0x007, 0x008, 0x024, 0x000,
    0x000, 0x003, 0x00B, 0x003, 0x006, 0x000, 0x0CB, 0x001, 0x000, 0x012, 0x000, 0x000, 0x000,
    0x01F, 0x00A, 0x024, 0x014, 0x054, 0x000, 0x000, 0x000, 0x000, 0x00D, 0x001, 0x029, 0x000,
    0x00B, 0x000, 0x001, 0x000, 0x017, 0x001, 0x012, 0x01B, 0x003, 0x000, 0x005, 0x000, 0x001,
    0x003, 0x001, 0x047, 0x000, 0x02C, 0x006, 0x000, 0x05B, 0x01F, 0x000, 0x000, 0x000, 0x004,
    0x001, 0x000, 0x003, 0x000, 0x008, 0x001, 0x028, 0x001, 0x001, 0x000, 0x000, 0x000, 0x005,
    0x003, 0x005, 0x02A, 0x001, 0x002, 0x000, 0x016, 0x015, 0x022, 0x000, 0x000, 0x01A, 0x009,
    0x00A, 0x000, 0x000, 0x001, 0x00D, 0x000, 0x005, 0x001, 0x001, 0x001, 0x000, 0x000, 0x000,
    0x000, 0x001, 0x005, 0x03A, 0x000, 0x010, 0x002, 0x004, 0x000, 0x000, 0x03A, 0x000, 0x015,
    0x002, 0x004, 0x000, 0x000, 0x01A, 0x00A, 0x000, 0x00B, 0x000, 0x000, 0x006, 0x002, 0x000,
    0x012, 0x000, 0x012, 0x000, 0x003, 0x01F, 0x006, 0x00C, 0x000, 0x000, 0x022, 0x000, 0x002,
    0x0A0, 0x00C, 0x003, 0x001, 0x039, 0x004, 0x003, 0x00B, 0x008, 0x009, 0x002, 0x000, 0x000,
    0x000, 0x000, 0x003, 0x002, 0x000, 0x004, 0x00B, 0x003, 0x000, 0x000, 0x005, 0x000, 0x005,
    0x000, 0x01B, 0x000, 0x000, 0x02A, 0x01E, 0x001, 0x001, 0x000, 0x003, 0x031, 0x001, 0x004,
    0x010, 0x000, 0x005, 0x001, 0x00D, 0x000, 0x00F, 0x002, 0x000, 0x000, 0x002, 0x000, 0x008,
    0x00C, 0x000, 0x00E, 0x003, 0x000, 0x000, 0x017, 0x000, 0x001, 0x000, 0x001, 0x001, 0x000,
    0x000, 0x002, 0x008, 0x007, 0x002, 0x037, 0x000, 0x01C, 0x00D, 0x000, 0x00A, 0x000, 0x000,
    0x007, 0x023, 0x000, 0x004, 0x000, 0x000, 0x000, 0x019, 0x006, 0x000, 0x002, 0x000, 0x048,
    0x005, 0x000, 0x000, 0x020, 0x000, 0x000, 0x00A, 0x002, 0x000, 0x01C, 0x008, 0x031, 0x000,
    0x000, 0x000, 0x00C, 0x00B, 0x002, 0x000, 0x000, 0x000, 0x000, 0x000, 0x004, 0x000, 0x01E,
    0x000, 0x016, 0x000, 0x000, 0x016, 0x028, 0x000, 0x000, 0x000, 0x03A, 0x000, 0x001, 0x000,
    0x004, 0x000, 0x000, 0x000, 0x006, 0x002, 0x000, 0x011, 0x00B, 0x000, 0x007, 0x004, 0x000,
    0x00C, 0x000, 0x026, 0x036, 0x007, 0x002, 0x007, 0x00E, 0x002, 0x001, 0x00A, 0x000, 0x00E,
    0x002, 0x005, 0x008, 0x002, 0x002, 0x000, 0x000, 0x023, 0x005, 0x005, 0x00E, 0x005, 0x009,
    0x000, 0x00A, 0x004, 0x001, 0x006, 0x000, 0x000, 0x011, 0x000, 0x002, 0x000, 0x00E, 0x005,
    0x001, 0x000, 0x002, 0x00F, 0x001, 0x005, 0x000, 0x002, 0x00F, 0x001, 0x000, 0x002, 0x006,
    0x000, 0x03F, 0x009, 0x000, 0x000, 0x003, 0x003, 0x007, 0x000, 0x000, 0x000, 0x031, 0x00E,
    0x001, 0x000, 0x000, 0x001, 0x000, 0x002, 0x017, 0x003, 0x026, 0x000, 0x027, 0x000, 0x000,
    0x00C, 0x001, 0x006, 0x000, 0x003, 0x001, 0x000, 0x000, 0x002, 0x002, 0x000, 0x003, 0x000,
    0x008, 0x000, 0x01B, 0x000, 0x000, 0x00B, 0x013, 0x002, 0x001, 0x000, 0x002, 0x008, 0x000,
    0x001, 0x009, 0x000, 0x00D, 0x000, 0x004, 0x01B, 0x000, 0x000, 0x000, 0x003, 0x002, 0x000,
    0x001, 0x008, 0x00B, 0x015, 0x006, 0x001, 0x00B, 0x000, 0x008, 0x00A, 0x000, 0x000, 0x02B,
    0x000, 0x002, 0x000, 0x003, 0x005, 0x00B, 0x000, 0x00C, 0x000, 0x004, 0x004, 0x000, 0x000,
    0x001, 0x000, 0x000, 0x000, 0x007, 0x00A, 0x008, 0x002, 0x000, 0x001, 0x006, 0x014, 0x000,
    0x000, 0x003, 0x000, 0x000, 0x001, 0x000, 0x000, 0x000, 0x003, 0x000, 0x000, 0x006, 0x003,
    0x000, 0x003, 0x000, 0x002, 0x000, 0x000, 0x000, 0x006, 0x000, 0x000, 0x004, 0x001, 0x004,
    0x000, 0x003, 0x001, 0x001, 0x004, 0x001, 0x000, 0x000, 0x003, 0x000, 0x000, 0x001, 0x002,
    0x001, 0x003, 0x002, 0x002, 0x000, 0x004, 0x00A, 0x008, 0x01E, 0x000, 0x000, 0x000, 0x000,
    0x001, 0x006, 0x004, 0x000, 0x000, 0x004, 0x000, 0x000, 0x002, 0x00F, 0x00B, 0x014, 0x000,
    0x002, 0x001, 0x000, 0x000, 0x000, 0x004, 0x000, 0x004, 0x002, 0x000, 0x006, 0x00B, 0x000,
    0x009, 0x018, 0x006, 0x006, 0x005, 0x001, 0x002, 0x000, 0x000, 0x000, 0x000, 0x006, 0x000,
    0x000, 0x00E, 0x001, 0x001, 0x000, 0x003, 0x000, 0x016, 0x003, 0x015, 0x000, 0x000, 0x006,
    0x006, 0x002, 0x000, 0x003, 0x001, 0x000, 0x00B, 0x005, 0x005, 0x001, 0x000, 0x000, 0x003,
    0x000, 0x004, 0x000, 0x010, 0x000, 0x000, 0x000, 0x000, 0x001, 0x003, 0x000, 0x000, 0x002,
    0x002, 0x000, 0x00B, 0x000, 0x001, 0x005, 0x002, 0x000, 0x000, 0x011, 0x00F, 0x000, 0x001,
    0x00D, 0x00C, 0x001, 0x00B, 0x002, 0x010, 0x008, 0x001, 0x001, 0x004, 0x005, 0x011, 0x001,
    0x00B, 0x010, 0x000, 0x001, 0x006, 0x000, 0x00C, 0x000, 0x00E, 0x00B, 0x001, 0x000, 0x003,
    0x022, 0x004, 0x000, 0x001, 0x000, 0x007, 0x001, 0x004, 0x006, 0x001, 0x001, 0x000, 0x001,
    0x007, 0x003, 0x004, 0x007, 0x006, 0x001, 0x010, 0x00D, 0x000, 0x000, 0x000, 0x007, 0x003,
    0x000, 0x008, 0x001, 0x007, 0x003, 0x003, 0x000, 0x000, 0x010, 0x003, 0x002, 0x000, 0x000,
    0x000, 0x000, 0x005, 0x001, 0x000, 0x002, 0x000, 0x003, 0x000, 0x001, 0x010, 0x001, 0x000,
    0x015, 0x003, 0x007, 0x001, 0x00D, 0x005, 0x002, 0x015, 0x000, 0x001, 0x009, 0x000, 0x006,
    0x000, 0x003, 0x001, 0x000, 0x000, 0x002, 0x000, 0x002, 0x000, 0x000, 0x00F, 0x000, 0x001,
    0x015, 0x004, 0x002, 0x002, 0x001, 0x008, 0x000, 0x000, 0x000, 0x00C, 0x000, 0x004, 0x000,
    0x005, 0x007, 0x00F, 0x001, 0x003, 0x006, 0x001, 0x000, 0x004, 0x000, 0x00C, 0x004, 0x012,
    0x002, 0x002, 0x000, 0x001, 0x018, 0x004, 0x000, 0x000, 0x001, 0x00C, 0x000, 0x000, 0x00E,
    0x001, 0x000, 0x007, 0x002, 0x000, 0x000, 0x001, 0x017, 0x002, 0x002, 0x000, 0x000, 0x004,
    0x001, 0x000, 0x002, 0x006, 0x002, 0x003, 0x00A, 0x000, 0x005, 0x000, 0x003, 0x001, 0x002,
    0x002, 0x000, 0x001, 0x005, 0x003, 0x000, 0x00D, 0x00C, 0x001, 0x000, 0x001, 0x004, 0x000,
    0x002, 0x000, 0x001, 0x000, 0x000, 0x001, 0x005, 0x000, 0x000, 0x000, 0x000, 0x001, 0x01D,
    0x003, 0x002, 0x00C, 0x000, 0x000, 0x003, 0x009, 0x000, 0x000, 0x005, 0x003, 0x000, 0x001,
    0x002, 0x006, 0x001, 0x008, 0x001, 0x001, 0x00D, 0x004, 0x006, 0x008, 0x001, 0x00B, 0x007,
    0x00A, 0x006, 0x002, 0x00F, 0x005, 0x000, 0x00B, 0x006, 0x001, 0x001, 0x001, 0x004, 0x009,
    0x000, 0x001, 0x000, 0x003, 0x000, 0x009, 0x009, 0x004, 0x001, 0x001, 0x009, 0x006, 0x002,
    0x008, 0x007, 0x003, 0x000, 0x008, 0x007, 0x000, 0x014, 0x001, 0x001, 0x013, 0x003, 0x004,
    0x000, 0x000, 0x003, 0x001, 0x000, 0x001, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
    0x005, 0x00A, 0x000, 0x000, 0x000, 0x012, 0x000, 0x000, 0x000, 0x002, 0x000, 0x008, 0x000,
    0x016, 0x011, 0x007, 0x003, 0x000, 0x009, 0x001, 0x002, 0x000, 0x000, 0x000, 0x000, 0x000,
    0x000, 0x001, 0x000, 0x000, 0x009, 0x00C, 0x004, 0x000, 0x002, 0x000, 0x000, 0x002, 0x001,
    0x007, 0x000, 0x000, 0x001, 0x000, 0x003, 0x000, 0x000, 0x000, 0x000, 0x009, 0x003, 0x002,
    0x008, 0x002, 0x000, 0x001, 0x001, 0x00A, 0x013, 0x002, 0x003, 0x001, 0x003, 0x006, 0x000,
    0x003, 0x001, 0x004, 0x002, 0x000, 0x000, 0x004, 0x004, 0x000, 0x000, 0x000, 0x00D, 0x002,
    0x009, 0x002, 0x000, 0x007, 0x007, 0x001, 0x000, 0x002, 0x006, 0x002, 0x000, 0x001, 0x002,
    0x003, 0x000, 0x000, 0x009, 0x003, 0x007, 0x001, 0x000, 0x000, 0x00F, 0x001, 0x00C, 0x000,
    0x003, 0x000, 0x002, 0x000, 0x000, 0x009, 0x002, 0x002, 0x000, 0x001, 0x000, 0x006, 0x000,
    0x002, 0x002, 0x003, 0x002, 0x001, 0x00F, 0x001, 0x008, 0x002, 0x002, 0x009, 0x009, 0x00B,
    0x007, 0x002, 0x000, 0x000, 0x005, 0x00E, 0x001, 0x004, 0x007, 0x002, 0x001, 0x000, 0x003,
    0x00A, 0x000, 0x000, 0x00E, 0x000, 0x009, 0x003, 0x003, 0x001, 0x000, 0x000, 0x000, 0x007,
    0x000, 0x008, 0x00E, 0x000, 0x000, 0x000, 0x000, 0x002, 0x010, 0x002, 0x001, 0x002, 0x000,
    0x009, 0x000, 0x000, 0x002, 0x006, 0x000, 0x001, 0x000, 0x002, 0x000, 0x00D, 0x003, 0x001,
    0x00B, 0x001, 0x001, 0x000, 0x007, 0x000, 0x000, 0x003, 0x002, 0x004, 0x006, 0x004, 0x000,
    0x001, 0x008, 0x001, 0x005, 0x005, 0x00B, 0x011, 0x004, 0x002, 0x000, 0x02A, 0x000, 0x001,
    0x004, 0x008, 0x004, 0x000, 0x001, 0x001, 0x000, 0x000, 0x001, 0x007, 0x00B, 0x003, 0x000,
    0x002, 0x000, 0x005, 0x004, 0x002, 0x000, 0x001, 0x00A, 0x009, 0x001, 0x002, 0x000, 0x006,
    0x003, 0x001, 0x006, 0x003, 0x000, 0x001, 0x003, 0x000, 0x000, 0x005, 0x002, 0x006, 0x002,
    0x001, 0x000, 0x000, 0x000, 0x000, 0x003, 0x001, 0x000, 0x004, 0x000, 0x007, 0x001, 0x000,
    0x000, 0x002, 0x008, 0x000, 0x004, 0x001, 0x015, 0x000, 0x004, 0x000, 0x000, 0x005, 0x000,
    0x009, 0x002, 0x008, 0x006, 0x001, 0x000, 0x001, 0x001, 0x002, 0x000, 0x001, 0x003, 0x000,
    0x000, 0x003, 0x000, 0x003, 0x001, 0x000, 0x000, 0x000, 0x000, 0x001, 0x001, 0x001, 0x008,
    0x000, 0x001, 0x001, 0x001, 0x009, 0x003, 0x002, 0x000, 0x000, 0x001, 0x00C, 0x007, 0x003,
    0x002, 0x00A, 0x000, 0x005, 0x008, 0x00A, 0x006, 0x005, 0x006, 0x001, 0x000, 0x003, 0x000,
    0x006, 0x003, 0x000, 0x002, 0x002, 0x004, 0x005, 0x003, 0x002, 0x001, 0x000, 0x001, 0x005,
    0x001, 0x000, 0x003, 0x001, 0x007, 0x001, 0x001, 0x000, 0x000, 0x003, 0x003, 0x007, 0x001,
    0x000, 0x001, 0x001, 0x003, 0x00A, 0x003, 0x00A, 0x000, 0x000, 0x000, 0x001, 0x003, 0x001,
    0x000, 0x004, 0x000, 0x002, 0x003, 0x006, 0x000, 0x000, 0x005, 0x001, 0x000, 0x000, 0x003,
    0x005, 0x003, 0x001, 0x001, 0x003, 0x000, 0x000, 0x000, 0x001, 0x001, 0x001, 0x001, 0x000,
    0x000, 0x001, 0x000, 0x001, 0x003, 0x001, 0x003, 0x004, 0x001, 0x009, 0x002, 0x002, 0x002,
    0x003, 0x006, 0x001, 0x000, 0x000, 0x001, 0x007, 0x000, 0x004, 0x000, 0x001, 0x000, 0x00B,
    0x000, 0x002, 0x001, 0x004, 0x000, 0x007, 0x002, 0x004, 0x008, 0x005, 0x001, 0x003, 0x001,
    0x000, 0x002, 0x000, 0x003, 0x000, 0x006, 0x003, 0x002, 0x000, 0x000, 0x008, 0x00D, 0x001,
    0x001, 0x000, 0x007, 0x001, 0x005, 0x008, 0x001, 0x009, 0x003, 0x000, 0x000, 0x003, 0x000,
    0x000, 0x000, 0x000, 0x000, 0x000, 0x001, 0x004, 0x000, 0x000, 0x004, 0x003, 0x001, 0x004,
    0x000, 0x000, 0x000, 0x003, 0x003, 0x009, 0x003, 0x001, 0x000, 0x00A, 0x000, 0x001, 0x004,
    0x000, 0x001, 0x000, 0x000, 0x00C, 0x002, 0x000, 0x000, 0x007, 0x005, 0x000, 0x005, 0x000,
    0x000, 0x004, 0x000, 0x003, 0x000, 0x001, 0x006, 0x004, 0x004, 0x000, 0x002, 0x000, 0x003,
    0x001, 0x000, 0x005, 0x000, 0x002, 0x004, 0x000, 0x001, 0x000, 0x012, 0x001, 0x000, 0x008,
    0x003, 0x000, 0x002, 0x000, 0x005, 0x001, 0x001, 0x002, 0x001, 0x008, 0x003, 0x000, 0x006,
    0x001, 0x006, 0x001, 0x001, 0x002, 0x001, 0x000, 0x000, 0x000, 0x001, 0x003, 0x001, 0x004,
    0x000, 0x003, 0x008, 0x000, 0x005, 0x000, 0x000, 0x002, 0x000, 0x000, 0x001, 0x000, 0x000,
    0x00E, 0x001, 0x000, 0x000, 0x001, 0x003, 0x005, 0x000, 0x000, 0x001, 0x001, 0x003, 0x002,
    0x000, 0x002, 0x000, 0x007, 0x000, 0x000, 0x007, 0x001, 0x001, 0x000, 0x003, 0x000, 0x004,
    0x001, 0x002, 0x000, 0x000, 0x002, 0x003, 0x003, 0x000, 0x011, 0x000, 0x001, 0x001, 0x002,
    0x006, 0x003, 0x000, 0x002, 0x004, 0x002, 0x005, 0x000, 0x000, 0x000, 0x006, 0x000, 0x003,
    0x001, 0x007, 0x002, 0x000, 0x000, 0x000, 0x008, 0x000, 0x000, 0x001, 0x002, 0x000, 0x003,
    0x001, 0x001, 0x003, 0x000, 0x001, 0x001, 0x00E, 0x001, 0x000, 0x001, 0x008, 0x001, 0x001,
    0x001, 0x005, 0x008, 0x002, 0x003, 0x001, 0x000, 0x001, 0x003, 0x000, 0x001, 0x000, 0x003,
    0x001, 0x003, 0x000, 0x000, 0x000, 0x002, 0x000, 0x000, 0x001, 0x000, 0x000, 0x000, 0x001,
    0x001, 0x002, 0x000, 0x004, 0x002, 0x001, 0x000, 0x007, 0x000, 0x003, 0x001, 0x000, 0x000,
    0x000, 0x008, 0x001, 0x001, 0x000, 0x003, 0x001, 0x000, 0x000, 0x001, 0x001, 0x000, 0x000,
    0x001, 0x005, 0x000, 0x001, 0x003, 0x002, 0x003, 0x001, 0x000, 0x00D, 0x001, 0x000, 0x003,
    0x002, 0x001, 0x004, 0x003, 0x001, 0x002, 0x002, 0x001, 0x002, 0x001, 0x003, 0x008, 0x000,
    0x003, 0x001, 0x000, 0x000, 0x000, 0x001, 0x000, 0x003, 0x002, 0x006, 0x002, 0x008, 0x000,
    0x000, 0x000, 0x000, 0x003, 0x000, 0x001, 0x000, 0x001, 0x005, 0x002, 0x005, 0x000, 0x001,
    0x000, 0x000, 0x000, 0x002, 0x000, 0x001, 0x006, 0x000, 0x001, 0x003, 0x000, 0x000, 0x002,
    0x000, 0x000, 0x001, 0x003, 0x00A, 0x004, 0x009, 0x000, 0x002, 0x000, 0x003, 0x003, 0x001,
    0x001, 0x00A, 0x000, 0x006, 0x004, 0x003, 0x003, 0x002, 0x001, 0x004, 0x002, 0x002, 0x003,
    0x005, 0x003, 0x000, 0x002, 0x000, 0x001, 0x001, 0x000, 0x002, 0x002, 0x001, 0x000, 0x004,
    0x002, 0x004, 0x000, 0x000, 0x000, 0x001, 0x007, 0x000, 0x000, 0x002, 0x003, 0x002, 0x003,
    0x000, 0x002, 0x001, 0x002, 0x000, 0x000, 0x000, 0x000, 0x003, 0x000, 0x004, 0x003, 0x008,
    0x008, 0x000, 0x001, 0x000, 0x000, 0x001, 0x000, 0x004, 0x000, 0x000, 0x001, 0x00C, 0x001,
    0x003, 0x000, 0x005, 0x001, 0x00A, 0x004, 0x001, 0x003, 0x001, 0x000, 0x001, 0x001, 0x000,
    0x003, 0x003, 0x003, 0x000, 0x000, 0x000, 0x007, 0x000, 0x005, 0x001, 0x000, 0x002, 0x000,
    0x003, 0x000, 0x002, 0x002, 0x001, 0x001, 0x001, 0x001, 0x004, 0x001, 0x005, 0x001, 0x000,
    0x001, 0x002, 0x001, 0x002, 0x002, 0x000, 0x000, 0x002, 0x001, 0x001, 0x003, 0x000, 0x000,
    0x004, 0x000, 0x00E, 0x004, 0x001, 0x002, 0x003, 0x001, 0x000, 0x002, 0x003, 0x000, 0x000,
    0x000, 0x000, 0x000, 0x000, 0x001, 0x000, 0x000, 0x001, 0x000, 0x001, 0x000, 0x000, 0x00A,
    0x002, 0x000, 0x000, 0x000, 0x000, 0x012, 0x000, 0x000, 0x004, 0x003, 0x000, 0x003, 0x003,
    0x001, 0x001, 0x000, 0x000, 0x006, 0x005, 0x000, 0x001, 0x003, 0x002, 0x000, 0x001, 0x006,
    0x000, 0x000, 0x000, 0x001, 0x003, 0x002, 0x000, 0x002, 0x000, 0x000, 0x001, 0x000, 0x000,
    0x000, 0x003, 0x000, 0x005, 0x001, 0x002, 0x000, 0x000, 0x004, 0x000, 0x006, 0x000, 0x000,
    0x003, 0x004, 0x002, 0x000, 0x002, 0x002, 0x001, 0x008, 0x000, 0x001, 0x001, 0x001, 0x000,
    0x000, 0x001, 0x003, 0x000, 0x001, 0x003, 0x001, 0x000, 0x002, 0x000, 0x001, 0x000, 0x003,
    0x005, 0x000, 0x004, 0x001, 0x005, 0x000, 0x000, 0x001, 0x004, 0x002, 0x000, 0x000, 0x000,
    0x000, 0x004, 0x000, 0x000, 0x000, 0x001, 0x000, 0x010, 0x000, 0x001, 0x001, 0x000, 0x000,
    0x000, 0x001, 0x000, 0x001, 0x001, 0x006, 0x003, 0x005, 0x001, 0x000, 0x001, 0x001, 0x002,
    0x00E, 0x005, 0x003, 0x001, 0x001, 0x001, 0x002, 0x000, 0x001, 0x000, 0x004, 0x005, 0x002,
    0x003, 0x005, 0x003, 0x004, 0x000, 0x005, 0x001, 0x002, 0x001, 0x001, 0x002, 0x000, 0x005,
    0x001, 0x001, 0x001, 0x000, 0x002, 0x000, 0x006, 0x000, 0x001, 0x000, 0x002, 0x003, 0x002,
    0x003, 0x001, 0x000, 0x007, 0x001, 0x002, 0x003, 0x002, 0x001, 0x003, 0x000, 0x000, 0x000,
    0x001, 0x001, 0x005, 0x001, 0x000, 0x002, 0x001, 0x001, 0x001, 0x000, 0x000, 0x006, 0x000,
    0x001, 0x002, 0x001, 0x002, 0x001, 0x000, 0x000, 0x002, 0x001, 0x000, 0x002, 0x002, 0x001,
    0x002, 0x001, 0x003, 0x000, 0x002, 0x000, 0x000, 0x002, 0x000, 0x000, 0x002, 0x001, 0x001,
    0x005, 0x004, 0x004, 0x001, 0x003, 0x007, 0x001, 0x000, 0x000, 0x001, 0x002, 0x002, 0x003,
    0x001, 0x004, 0x005, 0x001, 0x001, 0x004, 0x001, 0x000, 0x008, 0x002, 0x000, 0x000, 0x003,
    0x002, 0x000, 0x001, 0x001, 0x001, 0x006, 0x002, 0x000, 0x004, 0x004, 0x001, 0x000, 0x004,
    0x002, 0x000, 0x000, 0x002, 0x000, 0x000, 0x000, 0x001, 0x000, 0x004, 0x001, 0x009, 0x001,
    0x004, 0x000, 0x001, 0x000, 0x001, 0x005, 0x000, 0x000, 0x000, 0x005, 0x003, 0x002, 0x003,
    0x004, 0x008, 0x002, 0x002, 0x000, 0x006, 0x001, 0x001, 0x002, 0x001, 0x000, 0x000, 0x002,
    0x000, 0x002, 0x002, 0x000, 0x002, 0x000, 0x002, 0x003, 0x000, 0x004, 0x002, 0x001, 0x002,
    0x003, 0x005, 0x001, 0x002, 0x001, 0x000, 0x000, 0x000, 0x000, 0x000, 0x002, 0x002, 0x00B,
    0x000, 0x000, 0x000, 0x001, 0x006, 0x005, 0x000, 0x000, 0x000, 0x002, 0x002, 0x000, 0x003,
    0x003, 0x002, 0x001, 0x000, 0x001, 0x000, 0x000, 0x001, 0x001, 0x000, 0x000, 0x001, 0x001,
    0x004, 0x001, 0x000, 0x002, 0x002, 0x003, 0x003, 0x000, 0x000, 0x002, 0x004, 0x001, 0x002,
    0x005, 0x001, 0x001, 0x000, 0x001, 0x001, 0x001, 0x000, 0x004, 0x001, 0x000, 0x002, 0x000,
    0x001, 0x000, 0x003, 0x002, 0x002, 0x007, 0x003, 0x001, 0x001, 0x001, 0x002, 0x001, 0x001,
    0x003, 0x002, 0x000, 0x001, 0x002, 0x005, 0x001, 0x002, 0x001, 0x000, 0x003, 0x001, 0x000,
    0x003, 0x000, 0x000, 0x000, 0x003, 0x001, 0x000, 0x002, 0x000, 0x001, 0x000, 0x001, 0x000,
    0x001, 0x00A, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x001, 0x000,
    0x000, 0x000, 0x000, 0x000, 0x000, 0x001, 0x003, 0x000, 0x000, 0x001, 0x005, 0x004, 0x000,
    0x000, 0x000, 0x007, 0x000, 0x001, 0x000, 0x003, 0x004, 0x003, 0x002, 0x000, 0x000, 0x001,
    0x000, 0x001, 0x001, 0x000, 0x000, 0x003, 0x001, 0x001, 0x000, 0x000, 0x000, 0x005, 0x001,
    0x000, 0x001, 0x001, 0x000, 0x003, 0x008, 0x000, 0x000, 0x003, 0x001, 0x000, 0x001, 0x004,
    0x001, 0x002, 0x001, 0x002, 0x002, 0x002, 0x000, 0x000, 0x000, 0x002, 0x000, 0x002, 0x000,
    0x001, 0x001, 0x001, 0x002, 0x003, 0x001, 0x004, 0x001, 0x001, 0x000, 0x001, 0x000, 0x003,
    0x000, 0x002, 0x002, 0x002, 0x002, 0x000, 0x002, 0x002, 0x001, 0x000, 0x000, 0x002, 0x003,
    0x000, 0x001, 0x000, 0x000, 0x003, 0x001, 0x001, 0x002, 0x002, 0x001, 0x003, 0x000, 0x009,
    0x001, 0x000, 0x001, 0x001, 0x002, 0x001, 0x002, 0x000, 0x001, 0x001, 0x000, 0x001, 0x001,
    0x001, 0x001, 0x001, 0x000, 0x001, 0x000, 0x008, 0x001, 0x001, 0x000, 0x001, 0x001, 0x004,
    0x000, 0x000, 0x003, 0x001, 0x001, 0x000, 0x001, 0x000, 0x002, 0x000, 0x000, 0x002, 0x001,
    0x002, 0x000, 0x001, 0x001, 0x000,
];
pub(crate) const COMBINING_MARK_KV: &[u32] = &[
    0x1D165, 0x01B71, 0x0093B, 0x00D57, 0x00328, 0x11CB1, 0x1CF11, 0x11A0A, 0x01B82, 0xE01DC,
    0x01ABD, 0x02DEB, 0x11CAF, 0x1D172, 0x1CF3E, 0x114B8, 0x1CF40, 0x0A950, 0x114BA, 0x00748,
    0x16F7F, 0x020F0, 0x0A981, 0x101FD, 0x00FB1, 0x0102F, 0x01CD6, 0x1DA08, 0x00FA2, 0x11A57,
    0x1612D, 0x00A41, 0x006E3, 0x00898, 0x01BA4, 0x112E7, 0x16F70, 0x01BF3, 0x16F6B, 0x0106B,
    0x0A675, 0x1DA5B, 0x10D6B, 0x11EF3, 0x1CF25, 0x02DF7, 0x11A97, 0x0A8EB, 0x1BC9E, 0x0FE2E,
    0x1133E, 0x00334, 0x111B7, 0x16F5F, 0x0105E, 0xE0112, 0x00656, 0x11C98, 0x10D6A, 0x11726,
    0x0A94B, 0x0FE2D, 0x1DA50, 0x00A4B, 0x119DD, 0x0032F, 0x00A3F, 0x00C02, 0x11835, 0xE0128,
    0x11300, 0x01ACB, 0x1DA19, 0x0A802, 0x01DD5, 0x11C3A, 0x112E0, 0x0A8B7, 0x00EB7, 0x017DD,
    0x01A7B, 0x02DE5, 0x00EB1, 0x1DA69, 0x00FA9, 0x0A8E6, 0x00C3F, 0x0A8EA, 0xE0156, 0x1DAAD,
    0x0109B, 0xE017F, 0x11A90, 0x017BF, 0x02DF1, 0x01A66, 0x006D6, 0x007AC, 0xE01E9, 0x01934,
    0x0A92A, 0x1DA04, 0xE01CE, 0x111BE, 0x10A01, 0x01DFD, 0xE0141, 0x11236, 0x00D3E, 0x0FE25,
    0x00741, 0x1E947, 0xE0191, 0x00311, 0x16F82, 0x01A75, 0x02DEC, 0x00F3E, 0x020D7, 0x1DA48,
    0x1D182, 0x00303, 0x01B37, 0x1DA9F, 0x11A8F, 0x01036, 0x00AC0, 0x01BA1, 0xE0120, 0x116B6,
    0x110B7, 0x01DEC, 0x00351, 0x00B02, 0x16F61, 0x01A7C, 0x114B5, 0x16F80, 0x11182, 0x00CF3,
    0x11CAA, 0xE0198, 0x00DD8, 0x0A9B7, 0x00ECA, 0x02DF8, 0x0A8C5, 0x0AA4C, 0x008DC, 0x01064,
    0x01C29, 0x0093E, 0x009BC, 0x01CD1, 0x1145E, 0x1DA42, 0x1143D, 0x110B1, 0x1E08F, 0x11A04,
    0x1CF26, 0x1CF13, 0x00ACC, 0x10F4D, 0xE0104, 0x00823, 0xE01D4, 0x005A6, 0x11442, 0x00AC7,
    0x11C9A, 0x0AABE, 0x11369, 0x16F72, 0xE01C7, 0x10A0F, 0x01A76, 0x11A03, 0x0061A, 0x11044,
    0x01733, 0x00318, 0x0A826, 0x1CF31, 0x11F41, 0x10F4A, 0x00315, 0x00F37, 0x017B6, 0x111CA,
    0x1171F, 0x10D69, 0x01CD7, 0x00364, 0x10F48, 0x00C81, 0x01A5A, 0x1DA11, 0x01CF4, 0x01DEF,
    0x11937, 0x11A53, 0x0103A, 0x1CF32, 0x01082, 0xE018C, 0x01AC5, 0x11CB6, 0x11635, 0xE010D,
    0xE0164, 0x1DA33, 0x0180D, 0x01AB1, 0x11370, 0x11C3E, 0x11CAE, 0x0ABE7, 0x11C95, 0x112E6,
    0x0033D, 0x0A8EE, 0x1DA0F, 0x01773, 0x0033C, 0x020D5, 0x0034A, 0x1DA34, 0x00819, 0x11362,
    0x00301, 0x01DFB, 0x00488, 0xE0165, 0x017B8, 0xE015B, 0x16122, 0x01DD4, 0x00F94, 0x00F7F,
    0x1DA58, 0x11A8B, 0x01DDA, 0xE017A, 0x01BE6, 0x1DA5E, 0x00E4B, 0x11720, 0x0A9B8, 0x10F82,
    0x0A9B6, 0x00744, 0x00C63, 0x11231, 0x00327, 0x00E38, 0x01939, 0x11F37, 0x00F18, 0x00340,
    0x116B3, 0x11002, 0x02DFF, 0xE0183, 0x1CF1D, 0x00FAD, 0x1DA2E, 0x115BF, 0x02DF0, 0x00337,
    0x1CF2D, 0x00B03, 0x1143B, 0x11373, 0x113C9, 0x16F92, 0x005BB, 0x00CCC, 0x01AC0, 0x01DF1,
    0xE01A4, 0x017CD, 0x13455, 0x11CA5, 0x007EF, 0x1DA28, 0x01073, 0x00F71, 0x11C9F, 0xE018F,
    0x1E001, 0x01ABA, 0x01933, 0x110B0, 0x1E948, 0xE01BB, 0x10378, 0x01ACD, 0x1E8D0, 0x11038,
    0x00BC7, 0x0093A, 0x01CE0, 0x00F77, 0x16F64, 0x02DEF, 0x1E2AE, 0xE0134, 0x01BEC, 0x11146,
    0x1DA64, 0x00D02, 0x114B2, 0x0FE2B, 0x0A928, 0x00AC9, 0x020DE, 0x01BEE, 0xE013D, 0xE0114,
    0x0A94D, 0x11A34, 0x1DA0D, 0xE01D7, 0x113B9, 0x0081F, 0x116B4, 0x0A8E4, 0x10AE6, 0x017B7,
    0xE0103, 0x00940, 0x11636, 0x00C62, 0x119D6, 0x16FF1, 0x01DE1, 0x01A68, 0x0065B, 0x00316,
    0xE0154, 0x0081C, 0x0A670, 0x1DA4B, 0x1E945, 0x1D17B, 0x01920, 0x16F5A, 0x0A80B, 0xE0148,
    0x0A8F1, 0x1DA4D, 0x009BE, 0x017C6, 0x1CF0A, 0x01A5E, 0x112E5, 0x00BBF, 0xE01E8, 0x114BF,
    0x01AC6, 0x00746, 0x1DA75, 0x1112B, 0x1E000, 0x00ECC, 0x00822, 0x1D1AA, 0x16F77, 0x11348,
    0x00FAC, 0x017BA, 0x00AC1, 0x01DE3, 0x0059F, 0xE01A8, 0x01AC3, 0x00FAE, 0x111B3, 0x11728,
    0x0AABF, 0xE012A, 0x116AC, 0x00F76, 0x119E0, 0xE0106, 0x0030B, 0x02DF9, 0x005B3, 0x00341,
    0x1DA62, 0x01A60, 0x1E8D1, 0x01CF8, 0x1E5EF, 0x112E4, 0x1DA32, 0x1163E, 0x00F84, 0xE017C,
    0x00611, 0x008FD, 0x01ABF, 0x1DA53, 0x00483, 0x1CF41, 0x0085A, 0x017C4, 0x1DA1D, 0xE01E7,
    0x00326, 0x1DA10, 0xE01D8, 0x11C9E, 0x11832, 0x01DC4, 0x00366, 0x11D8C, 0x16AF2, 0x11C3F,
    0x11A8A, 0x0ABEC, 0x11D47, 0x01DE0, 0x00597, 0xE014F, 0x006DF, 0x111BC, 0x0AA2F, 0x0ABEA,
    0x01B42, 0x00D62, 0x01087, 0xE01D0, 0x1DA06, 0x115C0, 0x0089B, 0x11933, 0x017C2, 0x0A69F,
    0x01926, 0x110B5, 0x017CA, 0x11073, 0x11102, 0x1D180, 0x01B6F, 0x0AAEB, 0x00ABE, 0x10EFD,
    0x02DFB, 0x00AE3, 0x00C4D, 0x01930, 0x01ACC, 0x00ABC, 0x01032, 0x00DF3, 0xE01EF, 0x00A03,
    0x1DA57, 0x0030F, 0x1DAA1, 0x008F9, 0x020E5, 0x1DA23, 0x10F83, 0x008F5, 0x00343, 0x005B2,
    0x02D7F, 0x11932, 0x020E2, 0x11F39, 0x1E018, 0x00D00, 0x0031A, 0x017BE, 0x10D27, 0x01753,
    0x020D3, 0x00FB5, 0x02DEE, 0x00D82, 0x0033F, 0x00734, 0x1CF35, 0x11235, 0x116AE, 0xE016E,
    0x0036A, 0x16F65, 0xE01BD, 0x0AA43, 0x11D35, 0xE0195, 0x01DF8, 0x00B3E, 0x00F86, 0x113BD,
    0xE018E, 0x11A8E, 0x0A8BA, 0xE016C, 0x01A71, 0x11F34, 0x01084, 0x01DC9, 0x1CF37, 0x1CF1A,
    0x113BA, 0xE0122, 0x11C3C, 0x00304, 0x008E6, 0x11A35, 0x01CE4, 0x017B9, 0x0FE2C, 0x0FE0F,
    0x1DA27, 0x11A51, 0x1DA1B, 0x16AF0, 0x11A07, 0x00DDB, 0x1DAA5, 0x10A02, 0x0FE0C, 0x01DCF,
    0xE01DE, 0x006EC, 0x1DA14, 0x112E1, 0x0A927, 0x11A38, 0x007AB, 0x005B5, 0x1D244, 0x0A9BE,
    0x1E002, 0x11831, 0x01886, 0xE0169, 0xE0184, 0x1DA4A, 0x10A3F, 0x11128, 0x00595, 0x008DF,
    0x16B31, 0x113BC, 0x0064C, 0x00658, 0x01DC2, 0x1E020, 0x113CC, 0x02DE6, 0x006DB, 0x007A8,
    0x00821, 0x11633, 0x0A8B4, 0x008CF, 0xE0102, 0x0A823, 0x017D3, 0x01AC4, 0x11836, 0xE0151,
    0x005BD, 0xE0117, 0x01BA2, 0x1CF3C, 0x00CBC, 0x16F81, 0x1D18B, 0x017BD, 0x00346, 0x1DA5D,
    0x11CA7, 0xE0171, 0x0AAC1, 0x00CBE, 0x0A953, 0x01C30, 0x00329, 0x0089F, 0x008FA, 0x11725,
    0x1136B, 0x01CDC, 0x11070, 0x008F6, 0x00308, 0x01BEB, 0x11233, 0xE0136, 0x00F3F, 0x1CF09,
    0xE0100, 0x01DF3, 0x01035, 0x0102D, 0x00314, 0x008E1, 0x01DCE, 0x00A02, 0xE0157, 0xE0193,
    0x13451, 0x11D3A, 0x00CC4, 0x0034E, 0x00733, 0x11C2F, 0x16F62, 0x111BB, 0x01B72, 0x007AF,
    0x0036B, 0x00731, 0x008D3, 0x13453, 0x16F60, 0x01CF9, 0xE012D, 0xE0197, 0x00CCA, 0x00616,
    0x0FE01, 0x01BE7, 0xE0177, 0x10A0D, 0x01B6E, 0x01DCD, 0x1E004, 0x008D8, 0x11723, 0xE0168,
    0x11130, 0x01C28, 0x11C3D, 0x0064F, 0x0AAEC, 0x1DA40, 0x11C31, 0x01DCB, 0x01923, 0x11D34,
    0x008FF, 0xE01D5, 0x0034F, 0x16121, 0x01B44, 0x0A948, 0xE01DA, 0x1612F, 0x00650, 0x0AA35,
    0x00305, 0x020E8, 0x01752, 0x00AC4, 0x0A827, 0x1172A, 0x005AF, 0x01DC1, 0x11F3E, 0x1D189,
    0x1DA49, 0x11D45, 0x01C2E, 0x01037, 0xE01BE, 0xE01A3, 0x0A672, 0x0A8E3, 0x115B4, 0x11CAD,
    0x01DD2, 0x10EFF, 0x0064E, 0x0082C, 0x1611E, 0x0FE29, 0x00323, 0x00899, 0x00CD6, 0x00489,
    0x008CC, 0x01922, 0x00A82, 0x0ABE8, 0x01B01, 0x16F63, 0x0064D, 0x1DAAB, 0x017D2, 0x0FE26,
    0x00D3C, 0xE010A, 0x119DF, 0x1D171, 0x0A881, 0x01A56, 0x114C2, 0xE0113, 0x1D186, 0x11CB4,
    0x10377, 0x11A3C, 0x1E015, 0x00F9F, 0x0A8C1, 0x00B57, 0x16127, 0x0AA7C, 0x115BA, 0xE0127,
    0x00332, 0x11145, 0xE0179, 0xE0135, 0x00C4C, 0x008CE, 0x01A7F, 0x0031C, 0x006E1, 0x1E8D6,
    0xE0145, 0x00F93, 0x00362, 0x00596, 0x00347, 0x00317, 0x00670, 0xE0160, 0x00735, 0x10F4F,
    0x111C9, 0x11041, 0x1DA0E, 0x01928, 0x0FE06, 0x005C2, 0x005C4, 0x113E2, 0x1CF0D, 0x1CF1C,
    0x020DF, 0x00B4D, 0x0A67C, 0x00C41, 0xE0125, 0x11234, 0x0032C, 0x11D8E, 0x0106A, 0x00D3B,
    0x115DD, 0x00946, 0x00AC2, 0x01BAD, 0xE0196, 0x01714, 0x1344D, 0x0A94F, 0x1CF01, 0x00599,
    0x01ABB, 0x1DA29, 0x00FBA, 0x11437, 0x020EA, 0x00B3C, 0x10A39, 0x113C7, 0x1CF43, 0x005AB,
    0x00EC8, 0x020E1, 0x008D0, 0x1D168, 0xE0176, 0xE0133, 0x0192A, 0x0082A, 0x1193D, 0x01772,
    0x1E949, 0x00DD1, 0xE01E5, 0x0A980, 0x111CE, 0x01DC0, 0x1E8D3, 0x1DA02, 0xE01CC, 0x00FB0,
    0x0094B, 0x0135F, 0xE01B3, 0x008D7, 0x00313, 0x16F5B, 0x00E4A, 0x00610, 0x114BB, 0x00CCB,
    0x1171D, 0x1DA2C, 0x01C37, 0x0180C, 0x00FAB, 0x0065A, 0x115B2, 0x01A74, 0x113CE, 0x00CD5,
    0x00BD7, 0x0105F, 0x00C43, 0x00947, 0x0FE2F, 0x0032E, 0x1E4ED, 0xE010C, 0x01DC7, 0x01A18,
    0x1612A, 0x0A951, 0x006E7, 0x111B9, 0x00F90, 0x0032A, 0x02DEA, 0x16124, 0x0A8F0, 0x00FA1,
    0xE01A9, 0x0036F, 0x00ECB, 0x0093C, 0x110B8, 0x00BBE, 0x11C99, 0x008E8, 0x0A8B5, 0x01B39,
    0x0035C, 0x1DA4F, 0x0036E, 0x00740, 0x01A70, 0x01062, 0x0033A, 0x1E5EE, 0x1122D, 0x00FB9,
    0x11D42, 0x017CC, 0x1D166, 0x11D91, 0x00CC8, 0x01A6B, 0x119D4, 0x112E9, 0x017C9, 0x1CF2C,
    0xE0126, 0x00AFD, 0x1DA15, 0x1E010, 0x01B04, 0x0A8BE, 0x00BC0, 0x017B4, 0x01071, 0x11C94,
    0x119DC, 0x11371, 0x005C5, 0x11363, 0x11A54, 0x01CD4, 0x008D4, 0x11301, 0x1E2EC, 0x01A5B,
    0x11134, 0x005BF, 0x00B4C, 0x01A65, 0xE0180, 0x1182C, 0x16F73, 0x11C35, 0x00FA4, 0x01DCC,
    0x115BD, 0xE016D, 0xE0159, 0xE010E, 0x00D40, 0x1CF19, 0xE015F, 0x00903, 0x00C48, 0x01734,
    0x1DA43, 0x00825, 0x0FE22, 0x00ECD, 0x00333, 0x01B3A, 0x0089D, 0x018A9, 0x00E4D, 0x00312,
    0x1172B, 0x119DE, 0x0034C, 0x1103C, 0x00829, 0x1CF42, 0x1DAA2, 0x009C7, 0x00957, 0x119D1,
    0x11CA3, 0x1CF08, 0x00AC3, 0xE0166, 0x00D81, 0xE01D3, 0x1DA09, 0x00BCC, 0x02DED, 0x11A8D,
    0x008E4, 0x00FA0, 0x1E135, 0x00F7E, 0x102E0, 0x00659, 0x00D63, 0x16F66, 0x008EA, 0x00A3E,
    0x00732, 0xE01AB, 0x01072, 0x020ED, 0x00E35, 0x11639, 0x00F7B, 0x110C2, 0x01CDE, 0x1E028,
    0x113E1, 0x113BE, 0x11368, 0x114B0, 0x1136A, 0x008E7, 0x1DA66, 0x01088, 0x1E4EC, 0x0A952,
    0x0073C, 0x11374, 0x0073F, 0x1171E, 0x00B3F, 0xE01B5, 0x1182F, 0x11082, 0xE0146, 0x005B6,
    0x1E2ED, 0x11D8D, 0x01063, 0x1DAA6, 0x01B3F, 0x115B1, 0x00A3C, 0x01A5C, 0x113D2, 0x1D1AC,
    0x0A8EF, 0x0FE21, 0x115BB, 0x11830, 0x00FBB, 0x0ABED, 0x00C04, 0x020D4, 0x0A6F0, 0x0089E,
    0x0059B, 0x16B32, 0xE018B, 0x00FAA, 0x0109C, 0x00827, 0x01DD9, 0x13440, 0x01925, 0x0031B,
    0x01712, 0xE014A, 0x020D2, 0x0A677, 0x114C1, 0x1E003, 0x00CC1, 0x1112F, 0x00DCA, 0x1143F,
    0x11C30, 0x00613, 0x0AAF5, 0x10F4C, 0x02DE9, 0x1E131, 0xE018A, 0x1037A, 0x01DFF, 0x00816,
    0x16123, 0x00747, 0x00B47, 0x1136C, 0x111B8, 0x00D03, 0x112EA, 0x01038, 0xE01B9, 0x11133,
    0x1CF23, 0x0AA4D, 0x11230, 0x00C83, 0x00743, 0xE0150, 0x11F36, 0x0193A, 0x017CE, 0x01C31,
    0x01AB5, 0x11D94, 0x0A983, 0x00CCD, 0x00AFC, 0x11931, 0x1CF07, 0x1134B, 0x13452, 0x00CC3,
    0x0089C, 0x00F87, 0x00AC8, 0xE016B, 0x0102C, 0x1DA00, 0x00486, 0x00EB6, 0x11D43, 0x01031,
    0x114B9, 0x11040, 0x0A8FF, 0x11935, 0x1CF3D, 0x119D2, 0x10EAC, 0x11A08, 0x00F8E, 0x00DD0,
    0x00730, 0x0A9E5, 0xE0194, 0x00DD4, 0x11940, 0x1CF04, 0x1344E, 0xE0190, 0x017C8, 0xE01CF,
    0x00820, 0x009C2, 0x02DFE, 0x11080, 0x0A671, 0x1E009, 0x1DA61, 0x00C3C, 0x00944, 0x0034D,
    0x00FB3, 0x119DA, 0x0A9BB, 0x008F2, 0x01DF6, 0x00A42, 0x116B0, 0x11729, 0x0302C, 0x01A58,
    0x16F76, 0x1E00E, 0x01AB4, 0x01DE7, 0x020EC, 0x10A38, 0x00A51, 0xE01C5, 0x10F47, 0x01938,
    0x00D44, 0x005A2, 0x1E01D, 0x01DCA, 0x007AD, 0x1DA59, 0x1163C, 0x16F7B, 0x01C34, 0x116B5,
    0x00306, 0xE01CD, 0x02DFD, 0x1DAAE, 0x00E4C, 0x1CF1F, 0x00BCA, 0x1133F, 0x11938, 0x11344,
    0x16125, 0x1E944, 0x01DDE, 0xE010B, 0xE011D, 0x10F4B, 0x00B48, 0x00DDD, 0x11727, 0x00592,
    0x16B30, 0x005B7, 0x00355, 0x00D4B, 0x1D1AD, 0xE012B, 0x13447, 0xE0101, 0x01DF2, 0x02DFA,
    0x01C2B, 0x01B40, 0x11357, 0x11100, 0x008ED, 0xE0109, 0x1DA03, 0x0FE28, 0x11722, 0x01CE6,
    0x005B0, 0x00615, 0x1DAA8, 0x00342, 0x00BCB, 0x11042, 0x01CD8, 0x01A17, 0x01C2A, 0x00F79,
    0x1112A, 0x11C3B, 0x01CE8, 0x1DA24, 0xE0189, 0xE01EE, 0x11D3D, 0x00FBC, 0x00367, 0x116B1,
    0x11074, 0x0A66F, 0x0031F, 0x11237, 0x01DF9, 0x01DE5, 0x01ABE, 0x0074A, 0x00F75, 0x10376,
    0x115B3, 0x0AA2C, 0x00DCF, 0xE013A, 0xE019F, 0x11C38, 0x1183A, 0x00A75, 0x00484, 0x119D7,
    0x00D46, 0x008DB, 0x0032B, 0x0FB1E, 0x1123E, 0x110B4, 0x11C9D, 0x1CF46, 0x1D16D, 0x00AE2,
    0x01058, 0x0106D, 0x1143C, 0x01DDF, 0x16120, 0xE015A, 0x00338, 0x01CDA, 0x00591, 0x00B56,
    0x1D187, 0x00737, 0x00F9A, 0x00CC2, 0x01B6C, 0x01DD0, 0x00CC0, 0x00A83, 0x11D97, 0x006D8,
    0x01B34, 0x00FA6, 0x116AD, 0x00DF2, 0x1163D, 0x0192B, 0x020E4, 0x10F84, 0xE0119, 0x008DD,
    0x006EB, 0x01059, 0x16F75, 0x00983, 0x00963, 0x02CF1, 0x1E130, 0x00300, 0x113CD, 0x0A6F1,
    0xE0143, 0x0FE0B, 0x02DF2, 0x006ED, 0x017C1, 0x01C2C, 0x005A7, 0x16F86, 0x00952, 0x01A62,
    0x01A19, 0x16FE4, 0x01DEE, 0x0180F, 0x1DA65, 0x0109D, 0x03099, 0x11A91, 0x006E8, 0x01AB7,
    0x01DD3, 0x1D16E, 0x007B0, 0xE0105, 0x00352, 0x0A9BF, 0x1E017, 0x00D41, 0x0059D, 0x01DF7,
    0x0A8BC, 0x005C1, 0x0A8ED, 0x11101, 0x11438, 0x11EF5, 0x007A7, 0x1DA35, 0x11A59, 0x00307,
    0x1E008, 0x10A05, 0xE01C8, 0x1CF14, 0x11444, 0x0033E, 0x008E9, 0x00ACB, 0x16F58, 0xE01C1,
    0x16F6D, 0x00B62, 0x01A73, 0x01CE7, 0x16F57, 0x01C36, 0x01060, 0x11D93, 0x11C96, 0x0035E,
    0x00F9C, 0x11A92, 0xE0181, 0x16AF4, 0x1DAA9, 0x00F7C, 0x1DA55, 0x1E01E, 0x01ACE, 0x11CA4,
    0x0135D, 0x00357, 0x0094E, 0x020D0, 0x11343, 0xE01AD, 0x1D1AB, 0x00EB9, 0xE0172, 0x00593,
    0x00D4A, 0x0AA31, 0xE01ED, 0x0089A, 0xE01A0, 0x11D96, 0x00948, 0x0A67A, 0x1E4EF, 0x01BEF,
    0x00F8F, 0x0A824, 0xE017E, 0x1DA4E, 0x00B82, 0x00CC7, 0x020DB, 0x13448, 0x00A40, 0x0A94E,
    0x11837, 0x10F49, 0x01083, 0xE0188, 0x1DA1F, 0x1D17C, 0x0A678, 0x00DDA, 0x006D7, 0x110B2,
    0x00826, 0x0A82C, 0x01CDF, 0x0AA2D, 0x009C4, 0x008E5, 0xE011C, 0x00E4E, 0x0A8E0, 0x1612B,
    0xE015C, 0x11F00, 0x01B02, 0x0A9BD, 0x11443, 0x1E026, 0x0A9B9, 0x0A94A, 0xE01D6, 0x01B73,
    0x1DA63, 0x13454, 0x11A96, 0x1D167, 0x11001, 0x1DA51, 0x113C5, 0x11F3A, 0x1D17E, 0x11D3F,
    0x00D01, 0x01A1A, 0x11439, 0x11A06, 0x01DF0, 0xE013B, 0x00F19, 0x00DD6, 0xE0167, 0x16F6F,
    0x00F72, 0x16F79, 0x00F81, 0x00A71, 0x119D5, 0x1103D, 0x1DA41, 0x01DDB, 0x0093F, 0x0FE00,
    0x008F7, 0x00B40, 0x00949, 0x0A9C0, 0x1103A, 0xE014E, 0x0A67B, 0xE0118, 0x01DEA, 0xE0107,
    0x1193C, 0x115BC, 0x01BA3, 0x00E34, 0x11366, 0x1CF3A, 0xE01DB, 0x0A929, 0xE01B1, 0xE0163,
    0x119E4, 0x00324, 0x01B6D, 0x017C0, 0x020DD, 0x01DD8, 0x0FE27, 0x11A93, 0x10D24, 0x114BD,
    0x0302A, 0x1CF1B, 0x1344F, 0x0081B, 0x1DA2A, 0x00309, 0x1CF29, 0x01DE4, 0x0A8BB, 0x113BB,
    0x00FC6, 0x11045, 0xE0147, 0x00FA8, 0x017CF, 0x00EBC, 0x00C55, 0x01A6A, 0x0A92C, 0x00941,
    0x11046, 0x01DE8, 0xE019C, 0x10D6C, 0x11EF4, 0x020E9, 0x0059A, 0x00D4C, 0x0031D, 0x01C33,
    0xE0140, 0x1107F, 0x00E39, 0x01CED, 0x1DA47, 0x005AD, 0xE01C9, 0x01AC8, 0x00901, 0x1D185,
    0x1DA1A, 0x1D181, 0x01ACA, 0x11CA9, 0x10A0C, 0x11A3B, 0x00953, 0xE01E0, 0x00ABF, 0xE011F,
    0x009E2, 0xE0111, 0x005A0, 0x11833, 0x1DA05, 0x115AF, 0x0302D, 0x113C2, 0xE012C, 0x0082D,
    0x1143E, 0xE01D2, 0x00B41, 0x01A55, 0x00302, 0x113CF, 0x00FB4, 0x0AAB0, 0x16F87, 0x01DC6,
    0x0AA32, 0xE0130, 0x020E7, 0x008DE, 0x007A9, 0x00739, 0x10F46, 0xE01AE, 0x114BC, 0x02CF0,
    0x11A47, 0x01A67, 0x1D170, 0x01A61, 0x00DDE, 0x1E012, 0x0135E, 0x0065E, 0x00DD9, 0xE0199,
    0xE013C, 0x1DA68, 0x11A05, 0x01929, 0x16F6C, 0x11F03, 0x16B35, 0x0A8C0, 0x005AA, 0x10AE5,
    0x00B01, 0x16AF3, 0x0FE07, 0x00FAF, 0x1DA26, 0x10D26, 0x1E00C, 0x0081E, 0x1DA3F, 0x01CD0,
    0x01BAC, 0xE0178, 0x01B36, 0x00C47, 0x0180B, 0x00654, 0x01DDC, 0x008EC, 0x1DA5F, 0x16F90,
    0x01DFC, 0x0103E, 0x11F38, 0x16FF0, 0x01DD7, 0xE015E, 0x00B55, 0x00614, 0x0030A, 0x1163B,
    0x11D95, 0x01074, 0xE0142, 0x00F99, 0xE01A6, 0x1163A, 0x1CF45, 0x1CF0F, 0xE0158, 0x0FE0E,
    0x0A825, 0x0108B, 0x00E49, 0x020D9, 0x1E00A, 0x1CF16, 0x0AAEE, 0x1E01B, 0x16F78, 0x10F4E,
    0xE019E, 0x16B34, 0x008EE, 0xE01C3, 0x00320, 0x11C33, 0x16F69, 0xE0132, 0x1103E, 0x0ABE3,
    0x00945, 0x00902, 0x1DA5A, 0x11446, 0x00C40, 0x1DA30, 0x0073E, 0xE012F, 0x11C9B, 0x11C36,
    0x007FD, 0x00360, 0x00E3A, 0x116AF, 0x01C32, 0x0A8E2, 0x005B1, 0x1122C, 0x0103B, 0xE013F,
    0x00BC2, 0x11C34, 0x11081, 0x02DF4, 0x119DB, 0x11631, 0x01A6D, 0x16F55, 0x00B44, 0x16B36,
    0x01DFE, 0x11A02, 0x1E8D4, 0x0AAEF, 0x00AFE, 0x020EB, 0x005A5, 0x1CF18, 0x00ACD, 0x11445,
    0x115B5, 0x16F53, 0x005A1, 0x00F95, 0x0FE09, 0xE01E3, 0x111B6, 0x00EB8, 0x1CF10, 0x1DA3E,
    0x1E00B, 0x0102E, 0x006EA, 0x11A95, 0x11435, 0x00D47, 0x00CE2, 0x00F74, 0x11043, 0xE0124,
    0x113BF, 0x008D6, 0x11A52, 0x11A8C, 0xE01CA, 0x00FA3, 0x1E00F, 0x11EF6, 0x16F7A, 0x111BA,
    0x1CF2B, 0x0A8E7, 0x1E00D, 0x1CF3F, 0x0ABE6, 0x005A3, 0x00A70, 0x01885, 0x0034B, 0x1E011,
    0x00FB8, 0x01A6F, 0x01CD2, 0xE011A, 0x01030, 0x16F7E, 0x16F5D, 0x11D90, 0x00349, 0x01AB9,
    0x1E02A, 0x007EE, 0x01B3D, 0x0106C, 0x11CA6, 0x0033B, 0x01039, 0x020E3, 0x11A55, 0x00736,
    0x01B6B, 0x1344C, 0x007AA, 0x00BCD, 0x008CD, 0x11039, 0x01AB3, 0x1DAAA, 0x0030D, 0x01089,
    0x0302B, 0x01A6C, 0x11131, 0x0A8E9, 0xE01EB, 0x1DA21, 0x1DA45, 0x00C4B, 0x02DF3, 0x1DAAF,
    0x020D6, 0x0A94C, 0x00C03, 0x01A78, 0x00EB5, 0xE011B, 0x02DE7, 0xE0138, 0x11232, 0x16F56,
    0x1CF0B, 0xE0144, 0x13449, 0x1DA0C, 0x01BED, 0x0A982, 0xE01A5, 0x1CF06, 0x16F85, 0x0A679,
    0x008CB, 0x0A8BF, 0x0064B, 0x1DA3D, 0x1E8D5, 0x00E47, 0x01069, 0x008D2, 0x113B8, 0x00335,
    0x01713, 0x01A5D, 0x00C82, 0x0A67D, 0x1CF33, 0x11CB0, 0xE0153, 0x00897, 0x16F8F, 0x11A5A,
    0x11724, 0x1E016, 0x0103D, 0x01B3E, 0x01DC8, 0x16B33, 0x01937, 0x01A6E, 0x10A3A, 0x01BAA,
    0x01B43, 0x0FE0A, 0x020D8, 0xE014C, 0x02DF6, 0x1CF15, 0x020EE, 0x00942, 0xE0162, 0x009C1,
    0x00653, 0x0FE08, 0x1D17F, 0x017C5, 0x008CA, 0x1DA9B, 0x005BA, 0x00BC6, 0x00C42, 0x00738,
    0x11632, 0x1DA18, 0x008F8, 0x005AE, 0x116B7, 0x1134C, 0x11834, 0x0085B, 0x005C7, 0x11943,
    0x0A9B4, 0x1E029, 0x11A01, 0x020E0, 0x1103F, 0x00612, 0x01BA7, 0x00365, 0x0073B, 0x009D7,
    0x0193B, 0x11838, 0x01067, 0x0FE04, 0x11D32, 0x01DD6, 0x1DA2B, 0x0FE24, 0x01A7A, 0xE016A,
    0x0FE02, 0x16F6A, 0x1344B, 0x113CA, 0x11241, 0x110BA, 0x00C3E, 0x007AE, 0x0030C, 0xE0185,
    0x01AC9, 0x01C26, 0x1DA6A, 0x11436, 0x00331, 0x1CF27, 0x11367, 0xE0139, 0x00859, 0x01927,
    0x1CF02, 0x1DA9C, 0xE01B0, 0x111BF, 0x16128, 0x01DEB, 0x0AA30, 0xE0174, 0x1DAA4, 0x01ABC,
    0x00CC6, 0x01B38, 0x1DA5C, 0x020DC, 0x00C4A, 0x1CF34, 0x11D8B, 0x16129, 0x00955, 0x0AAED,
    0x10EAB, 0x017C7, 0x01BA8, 0x0AA2E, 0x1D16F, 0xE0116, 0x017BC, 0x0AAB3, 0xE01B7, 0x01BE9,
    0x1E006, 0x1E4EE, 0x01B70, 0x00325, 0xE0186, 0x0A92D, 0x11930, 0x111B5, 0x01A72, 0x1DA44,
    0xE01E6, 0x1DA1C, 0x005AC, 0x01B41, 0x10A03, 0x00363, 0x114C0, 0xE0123, 0x008E0, 0x01936,
    0x00D4D, 0x00C56, 0x00DDC, 0x11A39, 0x1E2EF, 0x006DC, 0x017D0, 0x1D242, 0x00359, 0x0A8E1,
    0x1CF05, 0x0094C, 0x01BF1, 0x008EF, 0x16AF1, 0x11634, 0xE0161, 0x1DA12, 0x020DA, 0x008D1,
    0x0094A, 0x008FB, 0x01BA6, 0x00D48, 0xE0108, 0x1E946, 0x00319, 0x017B5, 0x00339, 0x01DE2,
    0x11638, 0x0073A, 0x01057, 0x01CF7, 0x11173, 0x0309A, 0x1133B, 0x020EF, 0x112E2, 0x1E133,
    0x1DA52, 0x005B8, 0x00E37, 0x1D18A, 0x16F67, 0x1133C, 0x00598, 0x11A37, 0x00EBA, 0x111CB,
    0x0AAF6, 0x005B4, 0x02DF5, 0x11441, 0x114B7, 0x00353, 0x1163F, 0x008E3, 0x00651, 0x007F1,
    0x113D0, 0x0032D, 0x008FE, 0x115BE, 0x0AA34, 0x02DE1, 0x01B00, 0x006E4, 0x01CDB, 0x1CF03,
    0x01C25, 0x115B8, 0x11129, 0x00330, 0x00C01, 0x00943, 0x0A926, 0x1DA0A, 0x10D25, 0x008D9,
    0x0A9BC, 0x00322, 0x11C9C, 0xE0110, 0x13450, 0x00A47, 0x11F40, 0x01DC3, 0x01B3C, 0x1CF0E,
    0x01924, 0x0A676, 0x0036C, 0x007EC, 0x1D169, 0xE01E4, 0x00F7A, 0x00DD2, 0x1CF20, 0x11630,
    0x11347, 0x112E3, 0x01A59, 0x11D41, 0x11A36, 0xE0192, 0x0035B, 0x0065D, 0x00619, 0x00954,
    0xE0137, 0xE0149, 0x11F42, 0x00749, 0x01DF4, 0x1112D, 0x01CE1, 0x1CF3B, 0x1103B, 0x007F0,
    0xE01C0, 0x11D33, 0x00AFB, 0xE0175, 0x0AA33, 0x1DA3C, 0x0ABE5, 0x0ABE4, 0x02DE3, 0x1134D,
    0x009CC, 0x1DA9D, 0x01AC2, 0xE01A2, 0x11D44, 0xE0129, 0x11127, 0x115DC, 0x01B3B, 0x1CF36,
    0x00F97, 0x01CD5, 0x11D31, 0x00EB4, 0x1DA22, 0xE01EC, 0x10EFE, 0x00B63, 0x111C0, 0x1E013,
    0x11A56, 0x116B2, 0x0A947, 0x00BC8, 0x1DA16, 0x1DA6C, 0x008F0, 0x01BF2, 0x009BF, 0x11CA1,
    0x01CE2, 0xE01B4, 0xE012E, 0x01C2D, 0xE019D, 0x00F39, 0xE01AF, 0x1D188, 0x00D42, 0x01DD1,
    0x00BC1, 0x112DF, 0x0108A, 0x1182D, 0x1E014, 0xE01D1, 0x115B9, 0x16F4F, 0xE01C2, 0x11180,
    0xE017D, 0x01A57, 0x1CF00, 0x11A3D, 0x01921, 0x113C0, 0x00F82, 0xE01CB, 0x01CDD, 0x1DA01,
    0x0ABE9, 0x11303, 0x1E005, 0x11341, 0x00B4B, 0x11C39, 0x01AB2, 0x16F74, 0x114C3, 0x0A949,
    0x00617, 0x1CF17, 0x008EB, 0x005B9, 0x00745, 0x11CAB, 0x1DA36, 0x006E2, 0x16F54, 0x00C00,
    0x114BE, 0x01B81, 0x0102B, 0x1CF1E, 0x0A806, 0x0A880, 0x020E6, 0x01DF5, 0xE01D9, 0x0FE23,
    0x00487, 0x00F73, 0x01CE5, 0x11D36, 0x0081D, 0x1CF28, 0x11D40, 0x020D1, 0x0AA36, 0x0A8E5,
    0x110B6, 0x0A8C2, 0x11F5A, 0x11181, 0x00F35, 0x00D43, 0x0094D, 0x1193E, 0x1143A, 0xE0115,
    0x017D1, 0x1CF38, 0x0082B, 0x119D3, 0x00F80, 0x16F52, 0x005A4, 0xE0121, 0x008F4, 0xE01B2,
    0x00F83, 0x10EFC, 0x00ECE, 0x16F5E, 0x10A06, 0x11A98, 0x0A9BA, 0xE01B6, 0x1DA0B, 0x00F96,
    0x16F68, 0x00361, 0x00900, 0x16F7D, 0x00A81, 0x1612C, 0x1CF44, 0x0108C, 0x1DA60, 0x01B03,
    0x0A69E, 0x0094F, 0x11F01, 0x1CF24, 0x00951, 0x02DE4, 0x11A94, 0x11A58, 0x02DE8, 0xE01BF,
    0x111BD, 0x00EC9, 0x017C3, 0x0AA2A, 0x01B35, 0x00817, 0x1112C, 0x006DA, 0x009E3, 0x11372,
    0x00D83, 0x11CAC, 0x01BA9, 0x16F71, 0x1DAAC, 0x0AAB8, 0x00CE3, 0x00652, 0x11340, 0x16F5C,
    0x11000, 0x00FA7, 0x007A6, 0x11640, 0x11637, 0x11A3E, 0x008F1, 0x009FE, 0x11CA2, 0x0A8B9,
    0x01A79, 0x0A8BD, 0x01C2F, 0x01068, 0x01DE9, 0x0AA7D, 0x00A48, 0x01A77, 0x11132, 0x00345,
    0x110B9, 0x01931, 0x10379, 0x0FE2A, 0x1DA6B, 0x01AC1, 0xE01BC, 0x00354, 0x01085, 0x11942,
    0x11F35, 0x009C0, 0x00344, 0xE01EA, 0x1DA20, 0x0302F, 0x0031E, 0x00FA5, 0x1CF0C, 0xE01A1,
    0xE01C6, 0x00350, 0x01CE3, 0x0103C, 0x02DFC, 0x11342, 0x01A63, 0xE0173, 0x1CF21, 0xE019B,
    0x00A01, 0xE014D, 0x00DDF, 0xE019A, 0x01AC7, 0x1D243, 0xE01DF, 0x0FE0D, 0x11302, 0xE01E1,
    0x1D17D, 0x1DA17, 0x111CC, 0x0035F, 0x00962, 0x11D8A, 0x113C8, 0x0A9B3, 0x00818, 0x00356,
    0x00B43, 0x1DAA7, 0x11721, 0x0AAB7, 0x111CF, 0x00956, 0xE01C4, 0xE013E, 0x008DA, 0x00B42,
    0x1CF12, 0x0FE03, 0x11A99, 0x01DFA, 0x01DC5, 0x11CB3, 0x1DA67, 0xE0155, 0xE0131, 0x16F51,
    0x1182E, 0x1DAA3, 0x00657, 0x16F84, 0x00982, 0x114B3, 0x005BC, 0x00594, 0x008FC, 0x01B80,
    0xE017B, 0x01BF0, 0x02CEF, 0x007F2, 0x00D3F, 0x009C8, 0x01BAB, 0x1CF39, 0x00F91, 0x00AFA,
    0xE016F, 0x0109A, 0x16F7C, 0x005A9, 0x00FB6, 0x00A4D, 0x0A8C3, 0x008F3, 0x10F85, 0x1193B,
    0x00A4C, 0x11CA0, 0x0A9B5, 0x1E01C, 0x0A8E8, 0x0108D, 0x1DA46, 0x006D9, 0xE0152, 0x00711,
    0x01DE6, 0x01A64, 0x01AB0, 0x01CD9, 0x00F9B, 0x00F9D, 0x00E31, 0x110B3, 0xE011E, 0x10F50,
    0x01932, 0x00742, 0x0108F, 0x0AA2B, 0x01BA5, 0x1BC9D, 0x00E36, 0x00310, 0x1E134, 0x0065F,
    0x16F59, 0x0FE20, 0x1CF22, 0xE01A7, 0x0059C, 0x0035A, 0x1611F, 0x1E027, 0xE0182, 0x00321,
    0x0302E, 0x1CF30, 0xE015D, 0x00FB7, 0x01056, 0x00E48, 0xE01AC, 0x114B1, 0x01AB8, 0x00F92,
    0x1DA31, 0x16F6E, 0x11C92, 0x16126, 0x00368, 0x00C46, 0x00FB2, 0x11A33, 0x00655, 0x01A69,
    0x11440, 0x02DE2, 0x00369, 0x1344A, 0x1DA2D, 0x1E024, 0x0FE05, 0x112E8, 0x0A8B8, 0x0A92B,
    0x11839, 0x0059E, 0x116AB, 0x0AA29, 0x017BB, 0x01C35, 0x00336, 0x1DA25, 0x16F91, 0x00618,
    0x00F78, 0x0035D, 0x1DA2F, 0x0073D, 0x01033, 0x111B4, 0x1612E, 0x01715, 0x1DA54, 0x11CB5,
    0x1122F, 0x1DA13, 0xE01DD, 0x11C32, 0x1DA1E, 0x1DA56, 0x0AAB4, 0x00358, 0x11C97, 0x01DDD,
    0x00981, 0x00F8D, 0xE0187, 0x008D5, 0x01A1B, 0x00EBB, 0x00485, 0x11934, 0x02DE0, 0x1112E,
    0x01034, 0x11C93, 0x007ED, 0x0A674, 0x0A8B6, 0x00C44, 0x1CF2A, 0x115B0, 0x11A5B, 0x11D3C,
    0xE014B, 0x00DD3, 0xE01AA, 0xE01E2, 0x0A8EC, 0xE0170, 0xE01B8, 0x1122E, 0x10A0E, 0xE01BA,
    0x006E0, 0x00CBF, 0x005A8, 0xE018D, 0xE010F, 0x1DA4C, 0x007F3, 0x00F9E, 0x1E136, 0x1DA84,
    0x1E8D2, 0x11F3F, 0x00348, 0x1E132, 0x009C3, 0x1E2EE, 0x0030E, 0x0065C, 0x0036D, 0x11CB2,
    0x01BEA, 0x01935, 0x0AA7B, 0x01732, 0x11A09, 0x00AC5, 0x0A8C4, 0x01C24, 0x01AB6, 0x007EB,
    0x017CB, 0x01DED, 0x1DA3B, 0x1E021, 0x00F7D, 0x1E01F, 0x01086, 0x009CD, 0x10D6D, 0x1DA07,
    0x114B4, 0x01BE8, 0x16F83, 0x009CB, 0x01C27, 0x1DA9E, 0x114B6, 0x00AFF, 0x0AAB2, 0x1E94A,
    0x1E023,
];
#[inline]
pub fn is_public_assigned(c: char) -> bool {
    match c {
        '\u{0000}'..='\u{0377}'
        | '\u{037A}'..='\u{037F}'
        | '\u{0384}'..='\u{038A}'
        | '\u{038C}'
        | '\u{038E}'..='\u{03A1}'
        | '\u{03A3}'..='\u{052F}'
        | '\u{0531}'..='\u{0556}'
        | '\u{0559}'..='\u{058A}'
        | '\u{058D}'..='\u{058F}'
        | '\u{0591}'..='\u{05C7}'
        | '\u{05D0}'..='\u{05EA}'
        | '\u{05EF}'..='\u{05F4}'
        | '\u{0600}'..='\u{070D}'
        | '\u{070F}'..='\u{074A}'
        | '\u{074D}'..='\u{07B1}'
        | '\u{07C0}'..='\u{07FA}'
        | '\u{07FD}'..='\u{082D}'
        | '\u{0830}'..='\u{083E}'
        | '\u{0840}'..='\u{085B}'
        | '\u{085E}'
        | '\u{0860}'..='\u{086A}'
        | '\u{0870}'..='\u{088E}'
        | '\u{0890}'..='\u{0891}'
        | '\u{0897}'..='\u{0983}'
        | '\u{0985}'..='\u{098C}'
        | '\u{098F}'..='\u{0990}'
        | '\u{0993}'..='\u{09A8}'
        | '\u{09AA}'..='\u{09B0}'
        | '\u{09B2}'
        | '\u{09B6}'..='\u{09B9}'
        | '\u{09BC}'..='\u{09C4}'
        | '\u{09C7}'..='\u{09C8}'
        | '\u{09CB}'..='\u{09CE}'
        | '\u{09D7}'
        | '\u{09DC}'..='\u{09DD}'
        | '\u{09DF}'..='\u{09E3}'
        | '\u{09E6}'..='\u{09FE}'
        | '\u{0A01}'..='\u{0A03}'
        | '\u{0A05}'..='\u{0A0A}'
        | '\u{0A0F}'..='\u{0A10}'
        | '\u{0A13}'..='\u{0A28}'
        | '\u{0A2A}'..='\u{0A30}'
        | '\u{0A32}'..='\u{0A33}'
        | '\u{0A35}'..='\u{0A36}'
        | '\u{0A38}'..='\u{0A39}'
        | '\u{0A3C}'
        | '\u{0A3E}'..='\u{0A42}'
        | '\u{0A47}'..='\u{0A48}'
        | '\u{0A4B}'..='\u{0A4D}'
        | '\u{0A51}'
        | '\u{0A59}'..='\u{0A5C}'
        | '\u{0A5E}'
        | '\u{0A66}'..='\u{0A76}'
        | '\u{0A81}'..='\u{0A83}'
        | '\u{0A85}'..='\u{0A8D}'
        | '\u{0A8F}'..='\u{0A91}'
        | '\u{0A93}'..='\u{0AA8}'
        | '\u{0AAA}'..='\u{0AB0}'
        | '\u{0AB2}'..='\u{0AB3}'
        | '\u{0AB5}'..='\u{0AB9}'
        | '\u{0ABC}'..='\u{0AC5}'
        | '\u{0AC7}'..='\u{0AC9}'
        | '\u{0ACB}'..='\u{0ACD}'
        | '\u{0AD0}'
        | '\u{0AE0}'..='\u{0AE3}'
        | '\u{0AE6}'..='\u{0AF1}'
        | '\u{0AF9}'..='\u{0AFF}'
        | '\u{0B01}'..='\u{0B03}'
        | '\u{0B05}'..='\u{0B0C}'
        | '\u{0B0F}'..='\u{0B10}'
        | '\u{0B13}'..='\u{0B28}'
        | '\u{0B2A}'..='\u{0B30}'
        | '\u{0B32}'..='\u{0B33}'
        | '\u{0B35}'..='\u{0B39}'
        | '\u{0B3C}'..='\u{0B44}'
        | '\u{0B47}'..='\u{0B48}'
        | '\u{0B4B}'..='\u{0B4D}'
        | '\u{0B55}'..='\u{0B57}'
        | '\u{0B5C}'..='\u{0B5D}'
        | '\u{0B5F}'..='\u{0B63}'
        | '\u{0B66}'..='\u{0B77}'
        | '\u{0B82}'..='\u{0B83}'
        | '\u{0B85}'..='\u{0B8A}'
        | '\u{0B8E}'..='\u{0B90}'
        | '\u{0B92}'..='\u{0B95}'
        | '\u{0B99}'..='\u{0B9A}'
        | '\u{0B9C}'
        | '\u{0B9E}'..='\u{0B9F}'
        | '\u{0BA3}'..='\u{0BA4}'
        | '\u{0BA8}'..='\u{0BAA}'
        | '\u{0BAE}'..='\u{0BB9}'
        | '\u{0BBE}'..='\u{0BC2}'
        | '\u{0BC6}'..='\u{0BC8}'
        | '\u{0BCA}'..='\u{0BCD}'
        | '\u{0BD0}'
        | '\u{0BD7}'
        | '\u{0BE6}'..='\u{0BFA}'
        | '\u{0C00}'..='\u{0C0C}'
        | '\u{0C0E}'..='\u{0C10}'
        | '\u{0C12}'..='\u{0C28}'
        | '\u{0C2A}'..='\u{0C39}'
        | '\u{0C3C}'..='\u{0C44}'
        | '\u{0C46}'..='\u{0C48}'
        | '\u{0C4A}'..='\u{0C4D}'
        | '\u{0C55}'..='\u{0C56}'
        | '\u{0C58}'..='\u{0C5A}'
        | '\u{0C5D}'
        | '\u{0C60}'..='\u{0C63}'
        | '\u{0C66}'..='\u{0C6F}'
        | '\u{0C77}'..='\u{0C8C}'
        | '\u{0C8E}'..='\u{0C90}'
        | '\u{0C92}'..='\u{0CA8}'
        | '\u{0CAA}'..='\u{0CB3}'
        | '\u{0CB5}'..='\u{0CB9}'
        | '\u{0CBC}'..='\u{0CC4}'
        | '\u{0CC6}'..='\u{0CC8}'
        | '\u{0CCA}'..='\u{0CCD}'
        | '\u{0CD5}'..='\u{0CD6}'
        | '\u{0CDD}'..='\u{0CDE}'
        | '\u{0CE0}'..='\u{0CE3}'
        | '\u{0CE6}'..='\u{0CEF}'
        | '\u{0CF1}'..='\u{0CF3}'
        | '\u{0D00}'..='\u{0D0C}'
        | '\u{0D0E}'..='\u{0D10}'
        | '\u{0D12}'..='\u{0D44}'
        | '\u{0D46}'..='\u{0D48}'
        | '\u{0D4A}'..='\u{0D4F}'
        | '\u{0D54}'..='\u{0D63}'
        | '\u{0D66}'..='\u{0D7F}'
        | '\u{0D81}'..='\u{0D83}'
        | '\u{0D85}'..='\u{0D96}'
        | '\u{0D9A}'..='\u{0DB1}'
        | '\u{0DB3}'..='\u{0DBB}'
        | '\u{0DBD}'
        | '\u{0DC0}'..='\u{0DC6}'
        | '\u{0DCA}'
        | '\u{0DCF}'..='\u{0DD4}'
        | '\u{0DD6}'
        | '\u{0DD8}'..='\u{0DDF}'
        | '\u{0DE6}'..='\u{0DEF}'
        | '\u{0DF2}'..='\u{0DF4}'
        | '\u{0E01}'..='\u{0E3A}'
        | '\u{0E3F}'..='\u{0E5B}'
        | '\u{0E81}'..='\u{0E82}'
        | '\u{0E84}'
        | '\u{0E86}'..='\u{0E8A}'
        | '\u{0E8C}'..='\u{0EA3}'
        | '\u{0EA5}'
        | '\u{0EA7}'..='\u{0EBD}'
        | '\u{0EC0}'..='\u{0EC4}'
        | '\u{0EC6}'
        | '\u{0EC8}'..='\u{0ECE}'
        | '\u{0ED0}'..='\u{0ED9}'
        | '\u{0EDC}'..='\u{0EDF}'
        | '\u{0F00}'..='\u{0F47}'
        | '\u{0F49}'..='\u{0F6C}'
        | '\u{0F71}'..='\u{0F97}'
        | '\u{0F99}'..='\u{0FBC}'
        | '\u{0FBE}'..='\u{0FCC}'
        | '\u{0FCE}'..='\u{0FDA}'
        | '\u{1000}'..='\u{10C5}'
        | '\u{10C7}'
        | '\u{10CD}'
        | '\u{10D0}'..='\u{1248}'
        | '\u{124A}'..='\u{124D}'
        | '\u{1250}'..='\u{1256}'
        | '\u{1258}'
        | '\u{125A}'..='\u{125D}'
        | '\u{1260}'..='\u{1288}'
        | '\u{128A}'..='\u{128D}'
        | '\u{1290}'..='\u{12B0}'
        | '\u{12B2}'..='\u{12B5}'
        | '\u{12B8}'..='\u{12BE}'
        | '\u{12C0}'
        | '\u{12C2}'..='\u{12C5}'
        | '\u{12C8}'..='\u{12D6}'
        | '\u{12D8}'..='\u{1310}'
        | '\u{1312}'..='\u{1315}'
        | '\u{1318}'..='\u{135A}'
        | '\u{135D}'..='\u{137C}'
        | '\u{1380}'..='\u{1399}'
        | '\u{13A0}'..='\u{13F5}'
        | '\u{13F8}'..='\u{13FD}'
        | '\u{1400}'..='\u{169C}'
        | '\u{16A0}'..='\u{16F8}'
        | '\u{1700}'..='\u{1715}'
        | '\u{171F}'..='\u{1736}'
        | '\u{1740}'..='\u{1753}'
        | '\u{1760}'..='\u{176C}'
        | '\u{176E}'..='\u{1770}'
        | '\u{1772}'..='\u{1773}'
        | '\u{1780}'..='\u{17DD}'
        | '\u{17E0}'..='\u{17E9}'
        | '\u{17F0}'..='\u{17F9}'
        | '\u{1800}'..='\u{1819}'
        | '\u{1820}'..='\u{1878}'
        | '\u{1880}'..='\u{18AA}'
        | '\u{18B0}'..='\u{18F5}'
        | '\u{1900}'..='\u{191E}'
        | '\u{1920}'..='\u{192B}'
        | '\u{1930}'..='\u{193B}'
        | '\u{1940}'
        | '\u{1944}'..='\u{196D}'
        | '\u{1970}'..='\u{1974}'
        | '\u{1980}'..='\u{19AB}'
        | '\u{19B0}'..='\u{19C9}'
        | '\u{19D0}'..='\u{19DA}'
        | '\u{19DE}'..='\u{1A1B}'
        | '\u{1A1E}'..='\u{1A5E}'
        | '\u{1A60}'..='\u{1A7C}'
        | '\u{1A7F}'..='\u{1A89}'
        | '\u{1A90}'..='\u{1A99}'
        | '\u{1AA0}'..='\u{1AAD}'
        | '\u{1AB0}'..='\u{1ACE}'
        | '\u{1B00}'..='\u{1B4C}'
        | '\u{1B4E}'..='\u{1BF3}'
        | '\u{1BFC}'..='\u{1C37}'
        | '\u{1C3B}'..='\u{1C49}'
        | '\u{1C4D}'..='\u{1C8A}'
        | '\u{1C90}'..='\u{1CBA}'
        | '\u{1CBD}'..='\u{1CC7}'
        | '\u{1CD0}'..='\u{1CFA}'
        | '\u{1D00}'..='\u{1F15}'
        | '\u{1F18}'..='\u{1F1D}'
        | '\u{1F20}'..='\u{1F45}'
        | '\u{1F48}'..='\u{1F4D}'
        | '\u{1F50}'..='\u{1F57}'
        | '\u{1F59}'
        | '\u{1F5B}'
        | '\u{1F5D}'
        | '\u{1F5F}'..='\u{1F7D}'
        | '\u{1F80}'..='\u{1FB4}'
        | '\u{1FB6}'..='\u{1FC4}'
        | '\u{1FC6}'..='\u{1FD3}'
        | '\u{1FD6}'..='\u{1FDB}'
        | '\u{1FDD}'..='\u{1FEF}'
        | '\u{1FF2}'..='\u{1FF4}'
        | '\u{1FF6}'..='\u{1FFE}'
        | '\u{2000}'..='\u{2064}'
        | '\u{2066}'..='\u{2071}'
        | '\u{2074}'..='\u{208E}'
        | '\u{2090}'..='\u{209C}'
        | '\u{20A0}'..='\u{20C0}'
        | '\u{20D0}'..='\u{20F0}'
        | '\u{2100}'..='\u{218B}'
        | '\u{2190}'..='\u{2429}'
        | '\u{2440}'..='\u{244A}'
        | '\u{2460}'..='\u{2B73}'
        | '\u{2B76}'..='\u{2B95}'
        | '\u{2B97}'..='\u{2CF3}'
        | '\u{2CF9}'..='\u{2D25}'
        | '\u{2D27}'
        | '\u{2D2D}'
        | '\u{2D30}'..='\u{2D67}'
        | '\u{2D6F}'..='\u{2D70}'
        | '\u{2D7F}'..='\u{2D96}'
        | '\u{2DA0}'..='\u{2DA6}'
        | '\u{2DA8}'..='\u{2DAE}'
        | '\u{2DB0}'..='\u{2DB6}'
        | '\u{2DB8}'..='\u{2DBE}'
        | '\u{2DC0}'..='\u{2DC6}'
        | '\u{2DC8}'..='\u{2DCE}'
        | '\u{2DD0}'..='\u{2DD6}'
        | '\u{2DD8}'..='\u{2DDE}'
        | '\u{2DE0}'..='\u{2E5D}'
        | '\u{2E80}'..='\u{2E99}'
        | '\u{2E9B}'..='\u{2EF3}'
        | '\u{2F00}'..='\u{2FD5}'
        | '\u{2FF0}'..='\u{303F}'
        | '\u{3041}'..='\u{3096}'
        | '\u{3099}'..='\u{30FF}'
        | '\u{3105}'..='\u{312F}'
        | '\u{3131}'..='\u{318E}'
        | '\u{3190}'..='\u{31E5}'
        | '\u{31EF}'..='\u{321E}'
        | '\u{3220}'..='\u{A48C}'
        | '\u{A490}'..='\u{A4C6}'
        | '\u{A4D0}'..='\u{A62B}'
        | '\u{A640}'..='\u{A6F7}'
        | '\u{A700}'..='\u{A7CD}'
        | '\u{A7D0}'..='\u{A7D1}'
        | '\u{A7D3}'
        | '\u{A7D5}'..='\u{A7DC}'
        | '\u{A7F2}'..='\u{A82C}'
        | '\u{A830}'..='\u{A839}'
        | '\u{A840}'..='\u{A877}'
        | '\u{A880}'..='\u{A8C5}'
        | '\u{A8CE}'..='\u{A8D9}'
        | '\u{A8E0}'..='\u{A953}'
        | '\u{A95F}'..='\u{A97C}'
        | '\u{A980}'..='\u{A9CD}'
        | '\u{A9CF}'..='\u{A9D9}'
        | '\u{A9DE}'..='\u{A9FE}'
        | '\u{AA00}'..='\u{AA36}'
        | '\u{AA40}'..='\u{AA4D}'
        | '\u{AA50}'..='\u{AA59}'
        | '\u{AA5C}'..='\u{AAC2}'
        | '\u{AADB}'..='\u{AAF6}'
        | '\u{AB01}'..='\u{AB06}'
        | '\u{AB09}'..='\u{AB0E}'
        | '\u{AB11}'..='\u{AB16}'
        | '\u{AB20}'..='\u{AB26}'
        | '\u{AB28}'..='\u{AB2E}'
        | '\u{AB30}'..='\u{AB6B}'
        | '\u{AB70}'..='\u{ABED}'
        | '\u{ABF0}'..='\u{ABF9}'
        | '\u{AC00}'..='\u{D7A3}'
        | '\u{D7B0}'..='\u{D7C6}'
        | '\u{D7CB}'..='\u{D7FB}'
        | '\u{F900}'..='\u{FA6D}'
        | '\u{FA70}'..='\u{FAD9}'
        | '\u{FB00}'..='\u{FB06}'
        | '\u{FB13}'..='\u{FB17}'
        | '\u{FB1D}'..='\u{FB36}'
        | '\u{FB38}'..='\u{FB3C}'
        | '\u{FB3E}'
        | '\u{FB40}'..='\u{FB41}'
        | '\u{FB43}'..='\u{FB44}'
        | '\u{FB46}'..='\u{FBC2}'
        | '\u{FBD3}'..='\u{FD8F}'
        | '\u{FD92}'..='\u{FDC7}'
        | '\u{FDCF}'
        | '\u{FDF0}'..='\u{FE19}'
        | '\u{FE20}'..='\u{FE52}'
        | '\u{FE54}'..='\u{FE66}'
        | '\u{FE68}'..='\u{FE6B}'
        | '\u{FE70}'..='\u{FE74}'
        | '\u{FE76}'..='\u{FEFC}'
        | '\u{FEFF}'
        | '\u{FF01}'..='\u{FFBE}'
        | '\u{FFC2}'..='\u{FFC7}'
        | '\u{FFCA}'..='\u{FFCF}'
        | '\u{FFD2}'..='\u{FFD7}'
        | '\u{FFDA}'..='\u{FFDC}'
        | '\u{FFE0}'..='\u{FFE6}'
        | '\u{FFE8}'..='\u{FFEE}'
        | '\u{FFF9}'..='\u{FFFD}'
        | '\u{10000}'..='\u{1000B}'
        | '\u{1000D}'..='\u{10026}'
        | '\u{10028}'..='\u{1003A}'
        | '\u{1003C}'..='\u{1003D}'
        | '\u{1003F}'..='\u{1004D}'
        | '\u{10050}'..='\u{1005D}'
        | '\u{10080}'..='\u{100FA}'
        | '\u{10100}'..='\u{10102}'
        | '\u{10107}'..='\u{10133}'
        | '\u{10137}'..='\u{1018E}'
        | '\u{10190}'..='\u{1019C}'
        | '\u{101A0}'
        | '\u{101D0}'..='\u{101FD}'
        | '\u{10280}'..='\u{1029C}'
        | '\u{102A0}'..='\u{102D0}'
        | '\u{102E0}'..='\u{102FB}'
        | '\u{10300}'..='\u{10323}'
        | '\u{1032D}'..='\u{1034A}'
        | '\u{10350}'..='\u{1037A}'
        | '\u{10380}'..='\u{1039D}'
        | '\u{1039F}'..='\u{103C3}'
        | '\u{103C8}'..='\u{103D5}'
        | '\u{10400}'..='\u{1049D}'
        | '\u{104A0}'..='\u{104A9}'
        | '\u{104B0}'..='\u{104D3}'
        | '\u{104D8}'..='\u{104FB}'
        | '\u{10500}'..='\u{10527}'
        | '\u{10530}'..='\u{10563}'
        | '\u{1056F}'..='\u{1057A}'
        | '\u{1057C}'..='\u{1058A}'
        | '\u{1058C}'..='\u{10592}'
        | '\u{10594}'..='\u{10595}'
        | '\u{10597}'..='\u{105A1}'
        | '\u{105A3}'..='\u{105B1}'
        | '\u{105B3}'..='\u{105B9}'
        | '\u{105BB}'..='\u{105BC}'
        | '\u{105C0}'..='\u{105F3}'
        | '\u{10600}'..='\u{10736}'
        | '\u{10740}'..='\u{10755}'
        | '\u{10760}'..='\u{10767}'
        | '\u{10780}'..='\u{10785}'
        | '\u{10787}'..='\u{107B0}'
        | '\u{107B2}'..='\u{107BA}'
        | '\u{10800}'..='\u{10805}'
        | '\u{10808}'
        | '\u{1080A}'..='\u{10835}'
        | '\u{10837}'..='\u{10838}'
        | '\u{1083C}'
        | '\u{1083F}'..='\u{10855}'
        | '\u{10857}'..='\u{1089E}'
        | '\u{108A7}'..='\u{108AF}'
        | '\u{108E0}'..='\u{108F2}'
        | '\u{108F4}'..='\u{108F5}'
        | '\u{108FB}'..='\u{1091B}'
        | '\u{1091F}'..='\u{10939}'
        | '\u{1093F}'
        | '\u{10980}'..='\u{109B7}'
        | '\u{109BC}'..='\u{109CF}'
        | '\u{109D2}'..='\u{10A03}'
        | '\u{10A05}'..='\u{10A06}'
        | '\u{10A0C}'..='\u{10A13}'
        | '\u{10A15}'..='\u{10A17}'
        | '\u{10A19}'..='\u{10A35}'
        | '\u{10A38}'..='\u{10A3A}'
        | '\u{10A3F}'..='\u{10A48}'
        | '\u{10A50}'..='\u{10A58}'
        | '\u{10A60}'..='\u{10A9F}'
        | '\u{10AC0}'..='\u{10AE6}'
        | '\u{10AEB}'..='\u{10AF6}'
        | '\u{10B00}'..='\u{10B35}'
        | '\u{10B39}'..='\u{10B55}'
        | '\u{10B58}'..='\u{10B72}'
        | '\u{10B78}'..='\u{10B91}'
        | '\u{10B99}'..='\u{10B9C}'
        | '\u{10BA9}'..='\u{10BAF}'
        | '\u{10C00}'..='\u{10C48}'
        | '\u{10C80}'..='\u{10CB2}'
        | '\u{10CC0}'..='\u{10CF2}'
        | '\u{10CFA}'..='\u{10D27}'
        | '\u{10D30}'..='\u{10D39}'
        | '\u{10D40}'..='\u{10D65}'
        | '\u{10D69}'..='\u{10D85}'
        | '\u{10D8E}'..='\u{10D8F}'
        | '\u{10E60}'..='\u{10E7E}'
        | '\u{10E80}'..='\u{10EA9}'
        | '\u{10EAB}'..='\u{10EAD}'
        | '\u{10EB0}'..='\u{10EB1}'
        | '\u{10EC2}'..='\u{10EC4}'
        | '\u{10EFC}'..='\u{10F27}'
        | '\u{10F30}'..='\u{10F59}'
        | '\u{10F70}'..='\u{10F89}'
        | '\u{10FB0}'..='\u{10FCB}'
        | '\u{10FE0}'..='\u{10FF6}'
        | '\u{11000}'..='\u{1104D}'
        | '\u{11052}'..='\u{11075}'
        | '\u{1107F}'..='\u{110C2}'
        | '\u{110CD}'
        | '\u{110D0}'..='\u{110E8}'
        | '\u{110F0}'..='\u{110F9}'
        | '\u{11100}'..='\u{11134}'
        | '\u{11136}'..='\u{11147}'
        | '\u{11150}'..='\u{11176}'
        | '\u{11180}'..='\u{111DF}'
        | '\u{111E1}'..='\u{111F4}'
        | '\u{11200}'..='\u{11211}'
        | '\u{11213}'..='\u{11241}'
        | '\u{11280}'..='\u{11286}'
        | '\u{11288}'
        | '\u{1128A}'..='\u{1128D}'
        | '\u{1128F}'..='\u{1129D}'
        | '\u{1129F}'..='\u{112A9}'
        | '\u{112B0}'..='\u{112EA}'
        | '\u{112F0}'..='\u{112F9}'
        | '\u{11300}'..='\u{11303}'
        | '\u{11305}'..='\u{1130C}'
        | '\u{1130F}'..='\u{11310}'
        | '\u{11313}'..='\u{11328}'
        | '\u{1132A}'..='\u{11330}'
        | '\u{11332}'..='\u{11333}'
        | '\u{11335}'..='\u{11339}'
        | '\u{1133B}'..='\u{11344}'
        | '\u{11347}'..='\u{11348}'
        | '\u{1134B}'..='\u{1134D}'
        | '\u{11350}'
        | '\u{11357}'
        | '\u{1135D}'..='\u{11363}'
        | '\u{11366}'..='\u{1136C}'
        | '\u{11370}'..='\u{11374}'
        | '\u{11380}'..='\u{11389}'
        | '\u{1138B}'
        | '\u{1138E}'
        | '\u{11390}'..='\u{113B5}'
        | '\u{113B7}'..='\u{113C0}'
        | '\u{113C2}'
        | '\u{113C5}'
        | '\u{113C7}'..='\u{113CA}'
        | '\u{113CC}'..='\u{113D5}'
        | '\u{113D7}'..='\u{113D8}'
        | '\u{113E1}'..='\u{113E2}'
        | '\u{11400}'..='\u{1145B}'
        | '\u{1145D}'..='\u{11461}'
        | '\u{11480}'..='\u{114C7}'
        | '\u{114D0}'..='\u{114D9}'
        | '\u{11580}'..='\u{115B5}'
        | '\u{115B8}'..='\u{115DD}'
        | '\u{11600}'..='\u{11644}'
        | '\u{11650}'..='\u{11659}'
        | '\u{11660}'..='\u{1166C}'
        | '\u{11680}'..='\u{116B9}'
        | '\u{116C0}'..='\u{116C9}'
        | '\u{116D0}'..='\u{116E3}'
        | '\u{11700}'..='\u{1171A}'
        | '\u{1171D}'..='\u{1172B}'
        | '\u{11730}'..='\u{11746}'
        | '\u{11800}'..='\u{1183B}'
        | '\u{118A0}'..='\u{118F2}'
        | '\u{118FF}'..='\u{11906}'
        | '\u{11909}'
        | '\u{1190C}'..='\u{11913}'
        | '\u{11915}'..='\u{11916}'
        | '\u{11918}'..='\u{11935}'
        | '\u{11937}'..='\u{11938}'
        | '\u{1193B}'..='\u{11946}'
        | '\u{11950}'..='\u{11959}'
        | '\u{119A0}'..='\u{119A7}'
        | '\u{119AA}'..='\u{119D7}'
        | '\u{119DA}'..='\u{119E4}'
        | '\u{11A00}'..='\u{11A47}'
        | '\u{11A50}'..='\u{11AA2}'
        | '\u{11AB0}'..='\u{11AF8}'
        | '\u{11B00}'..='\u{11B09}'
        | '\u{11BC0}'..='\u{11BE1}'
        | '\u{11BF0}'..='\u{11BF9}'
        | '\u{11C00}'..='\u{11C08}'
        | '\u{11C0A}'..='\u{11C36}'
        | '\u{11C38}'..='\u{11C45}'
        | '\u{11C50}'..='\u{11C6C}'
        | '\u{11C70}'..='\u{11C8F}'
        | '\u{11C92}'..='\u{11CA7}'
        | '\u{11CA9}'..='\u{11CB6}'
        | '\u{11D00}'..='\u{11D06}'
        | '\u{11D08}'..='\u{11D09}'
        | '\u{11D0B}'..='\u{11D36}'
        | '\u{11D3A}'
        | '\u{11D3C}'..='\u{11D3D}'
        | '\u{11D3F}'..='\u{11D47}'
        | '\u{11D50}'..='\u{11D59}'
        | '\u{11D60}'..='\u{11D65}'
        | '\u{11D67}'..='\u{11D68}'
        | '\u{11D6A}'..='\u{11D8E}'
        | '\u{11D90}'..='\u{11D91}'
        | '\u{11D93}'..='\u{11D98}'
        | '\u{11DA0}'..='\u{11DA9}'
        | '\u{11EE0}'..='\u{11EF8}'
        | '\u{11F00}'..='\u{11F10}'
        | '\u{11F12}'..='\u{11F3A}'
        | '\u{11F3E}'..='\u{11F5A}'
        | '\u{11FB0}'
        | '\u{11FC0}'..='\u{11FF1}'
        | '\u{11FFF}'..='\u{12399}'
        | '\u{12400}'..='\u{1246E}'
        | '\u{12470}'..='\u{12474}'
        | '\u{12480}'..='\u{12543}'
        | '\u{12F90}'..='\u{12FF2}'
        | '\u{13000}'..='\u{13455}'
        | '\u{13460}'..='\u{143FA}'
        | '\u{14400}'..='\u{14646}'
        | '\u{16100}'..='\u{16139}'
        | '\u{16800}'..='\u{16A38}'
        | '\u{16A40}'..='\u{16A5E}'
        | '\u{16A60}'..='\u{16A69}'
        | '\u{16A6E}'..='\u{16ABE}'
        | '\u{16AC0}'..='\u{16AC9}'
        | '\u{16AD0}'..='\u{16AED}'
        | '\u{16AF0}'..='\u{16AF5}'
        | '\u{16B00}'..='\u{16B45}'
        | '\u{16B50}'..='\u{16B59}'
        | '\u{16B5B}'..='\u{16B61}'
        | '\u{16B63}'..='\u{16B77}'
        | '\u{16B7D}'..='\u{16B8F}'
        | '\u{16D40}'..='\u{16D79}'
        | '\u{16E40}'..='\u{16E9A}'
        | '\u{16F00}'..='\u{16F4A}'
        | '\u{16F4F}'..='\u{16F87}'
        | '\u{16F8F}'..='\u{16F9F}'
        | '\u{16FE0}'..='\u{16FE4}'
        | '\u{16FF0}'..='\u{16FF1}'
        | '\u{17000}'..='\u{187F7}'
        | '\u{18800}'..='\u{18CD5}'
        | '\u{18CFF}'..='\u{18D08}'
        | '\u{1AFF0}'..='\u{1AFF3}'
        | '\u{1AFF5}'..='\u{1AFFB}'
        | '\u{1AFFD}'..='\u{1AFFE}'
        | '\u{1B000}'..='\u{1B122}'
        | '\u{1B132}'
        | '\u{1B150}'..='\u{1B152}'
        | '\u{1B155}'
        | '\u{1B164}'..='\u{1B167}'
        | '\u{1B170}'..='\u{1B2FB}'
        | '\u{1BC00}'..='\u{1BC6A}'
        | '\u{1BC70}'..='\u{1BC7C}'
        | '\u{1BC80}'..='\u{1BC88}'
        | '\u{1BC90}'..='\u{1BC99}'
        | '\u{1BC9C}'..='\u{1BCA3}'
        | '\u{1CC00}'..='\u{1CCF9}'
        | '\u{1CD00}'..='\u{1CEB3}'
        | '\u{1CF00}'..='\u{1CF2D}'
        | '\u{1CF30}'..='\u{1CF46}'
        | '\u{1CF50}'..='\u{1CFC3}'
        | '\u{1D000}'..='\u{1D0F5}'
        | '\u{1D100}'..='\u{1D126}'
        | '\u{1D129}'..='\u{1D1EA}'
        | '\u{1D200}'..='\u{1D245}'
        | '\u{1D2C0}'..='\u{1D2D3}'
        | '\u{1D2E0}'..='\u{1D2F3}'
        | '\u{1D300}'..='\u{1D356}'
        | '\u{1D360}'..='\u{1D378}'
        | '\u{1D400}'..='\u{1D454}'
        | '\u{1D456}'..='\u{1D49C}'
        | '\u{1D49E}'..='\u{1D49F}'
        | '\u{1D4A2}'
        | '\u{1D4A5}'..='\u{1D4A6}'
        | '\u{1D4A9}'..='\u{1D4AC}'
        | '\u{1D4AE}'..='\u{1D4B9}'
        | '\u{1D4BB}'
        | '\u{1D4BD}'..='\u{1D4C3}'
        | '\u{1D4C5}'..='\u{1D505}'
        | '\u{1D507}'..='\u{1D50A}'
        | '\u{1D50D}'..='\u{1D514}'
        | '\u{1D516}'..='\u{1D51C}'
        | '\u{1D51E}'..='\u{1D539}'
        | '\u{1D53B}'..='\u{1D53E}'
        | '\u{1D540}'..='\u{1D544}'
        | '\u{1D546}'
        | '\u{1D54A}'..='\u{1D550}'
        | '\u{1D552}'..='\u{1D6A5}'
        | '\u{1D6A8}'..='\u{1D7CB}'
        | '\u{1D7CE}'..='\u{1DA8B}'
        | '\u{1DA9B}'..='\u{1DA9F}'
        | '\u{1DAA1}'..='\u{1DAAF}'
        | '\u{1DF00}'..='\u{1DF1E}'
        | '\u{1DF25}'..='\u{1DF2A}'
        | '\u{1E000}'..='\u{1E006}'
        | '\u{1E008}'..='\u{1E018}'
        | '\u{1E01B}'..='\u{1E021}'
        | '\u{1E023}'..='\u{1E024}'
        | '\u{1E026}'..='\u{1E02A}'
        | '\u{1E030}'..='\u{1E06D}'
        | '\u{1E08F}'
        | '\u{1E100}'..='\u{1E12C}'
        | '\u{1E130}'..='\u{1E13D}'
        | '\u{1E140}'..='\u{1E149}'
        | '\u{1E14E}'..='\u{1E14F}'
        | '\u{1E290}'..='\u{1E2AE}'
        | '\u{1E2C0}'..='\u{1E2F9}'
        | '\u{1E2FF}'
        | '\u{1E4D0}'..='\u{1E4F9}'
        | '\u{1E5D0}'..='\u{1E5FA}'
        | '\u{1E5FF}'
        | '\u{1E7E0}'..='\u{1E7E6}'
        | '\u{1E7E8}'..='\u{1E7EB}'
        | '\u{1E7ED}'..='\u{1E7EE}'
        | '\u{1E7F0}'..='\u{1E7FE}'
        | '\u{1E800}'..='\u{1E8C4}'
        | '\u{1E8C7}'..='\u{1E8D6}'
        | '\u{1E900}'..='\u{1E94B}'
        | '\u{1E950}'..='\u{1E959}'
        | '\u{1E95E}'..='\u{1E95F}'
        | '\u{1EC71}'..='\u{1ECB4}'
        | '\u{1ED01}'..='\u{1ED3D}'
        | '\u{1EE00}'..='\u{1EE03}'
        | '\u{1EE05}'..='\u{1EE1F}'
        | '\u{1EE21}'..='\u{1EE22}'
        | '\u{1EE24}'
        | '\u{1EE27}'
        | '\u{1EE29}'..='\u{1EE32}'
        | '\u{1EE34}'..='\u{1EE37}'
        | '\u{1EE39}'
        | '\u{1EE3B}'
        | '\u{1EE42}'
        | '\u{1EE47}'
        | '\u{1EE49}'
        | '\u{1EE4B}'
        | '\u{1EE4D}'..='\u{1EE4F}'
        | '\u{1EE51}'..='\u{1EE52}'
        | '\u{1EE54}'
        | '\u{1EE57}'
        | '\u{1EE59}'
        | '\u{1EE5B}'
        | '\u{1EE5D}'
        | '\u{1EE5F}'
        | '\u{1EE61}'..='\u{1EE62}'
        | '\u{1EE64}'
        | '\u{1EE67}'..='\u{1EE6A}'
        | '\u{1EE6C}'..='\u{1EE72}'
        | '\u{1EE74}'..='\u{1EE77}'
        | '\u{1EE79}'..='\u{1EE7C}'
        | '\u{1EE7E}'
        | '\u{1EE80}'..='\u{1EE89}'
        | '\u{1EE8B}'..='\u{1EE9B}'
        | '\u{1EEA1}'..='\u{1EEA3}'
        | '\u{1EEA5}'..='\u{1EEA9}'
        | '\u{1EEAB}'..='\u{1EEBB}'
        | '\u{1EEF0}'..='\u{1EEF1}'
        | '\u{1F000}'..='\u{1F02B}'
        | '\u{1F030}'..='\u{1F093}'
        | '\u{1F0A0}'..='\u{1F0AE}'
        | '\u{1F0B1}'..='\u{1F0BF}'
        | '\u{1F0C1}'..='\u{1F0CF}'
        | '\u{1F0D1}'..='\u{1F0F5}'
        | '\u{1F100}'..='\u{1F1AD}'
        | '\u{1F1E6}'..='\u{1F202}'
        | '\u{1F210}'..='\u{1F23B}'
        | '\u{1F240}'..='\u{1F248}'
        | '\u{1F250}'..='\u{1F251}'
        | '\u{1F260}'..='\u{1F265}'
        | '\u{1F300}'..='\u{1F6D7}'
        | '\u{1F6DC}'..='\u{1F6EC}'
        | '\u{1F6F0}'..='\u{1F6FC}'
        | '\u{1F700}'..='\u{1F776}'
        | '\u{1F77B}'..='\u{1F7D9}'
        | '\u{1F7E0}'..='\u{1F7EB}'
        | '\u{1F7F0}'
        | '\u{1F800}'..='\u{1F80B}'
        | '\u{1F810}'..='\u{1F847}'
        | '\u{1F850}'..='\u{1F859}'
        | '\u{1F860}'..='\u{1F887}'
        | '\u{1F890}'..='\u{1F8AD}'
        | '\u{1F8B0}'..='\u{1F8BB}'
        | '\u{1F8C0}'..='\u{1F8C1}'
        | '\u{1F900}'..='\u{1FA53}'
        | '\u{1FA60}'..='\u{1FA6D}'
        | '\u{1FA70}'..='\u{1FA7C}'
        | '\u{1FA80}'..='\u{1FA89}'
        | '\u{1FA8F}'..='\u{1FAC6}'
        | '\u{1FACE}'..='\u{1FADC}'
        | '\u{1FADF}'..='\u{1FAE9}'
        | '\u{1FAF0}'..='\u{1FAF8}'
        | '\u{1FB00}'..='\u{1FB92}'
        | '\u{1FB94}'..='\u{1FBF9}'
        | '\u{20000}'..='\u{2A6DF}'
        | '\u{2A700}'..='\u{2B739}'
        | '\u{2B740}'..='\u{2B81D}'
        | '\u{2B820}'..='\u{2CEA1}'
        | '\u{2CEB0}'..='\u{2EBE0}'
        | '\u{2EBF0}'..='\u{2EE5D}'
        | '\u{2F800}'..='\u{2FA1D}'
        | '\u{30000}'..='\u{3134A}'
        | '\u{31350}'..='\u{323AF}'
        | '\u{E0001}'
        | '\u{E0020}'..='\u{E007F}'
        | '\u{E0100}'..='\u{E01EF}' => true,
        _ => false,
    }
}

#[inline]
#[allow(ellipsis_inclusive_range_patterns)]
pub fn qc_nfc(c: char) -> IsNormalized {
    match c {
        '\u{0340}'..='\u{0341}' => No,
        '\u{0343}'..='\u{0344}' => No,
        '\u{0374}' => No,
        '\u{037E}' => No,
        '\u{0387}' => No,
        '\u{0958}'..='\u{095F}' => No,
        '\u{09DC}'..='\u{09DD}' => No,
        '\u{09DF}' => No,
        '\u{0A33}' => No,
        '\u{0A36}' => No,
        '\u{0A59}'..='\u{0A5B}' => No,
        '\u{0A5E}' => No,
        '\u{0B5C}'..='\u{0B5D}' => No,
        '\u{0F43}' => No,
        '\u{0F4D}' => No,
        '\u{0F52}' => No,
        '\u{0F57}' => No,
        '\u{0F5C}' => No,
        '\u{0F69}' => No,
        '\u{0F73}' => No,
        '\u{0F75}'..='\u{0F76}' => No,
        '\u{0F78}' => No,
        '\u{0F81}' => No,
        '\u{0F93}' => No,
        '\u{0F9D}' => No,
        '\u{0FA2}' => No,
        '\u{0FA7}' => No,
        '\u{0FAC}' => No,
        '\u{0FB9}' => No,
        '\u{1F71}' => No,
        '\u{1F73}' => No,
        '\u{1F75}' => No,
        '\u{1F77}' => No,
        '\u{1F79}' => No,
        '\u{1F7B}' => No,
        '\u{1F7D}' => No,
        '\u{1FBB}' => No,
        '\u{1FBE}' => No,
        '\u{1FC9}' => No,
        '\u{1FCB}' => No,
        '\u{1FD3}' => No,
        '\u{1FDB}' => No,
        '\u{1FE3}' => No,
        '\u{1FEB}' => No,
        '\u{1FEE}'..='\u{1FEF}' => No,
        '\u{1FF9}' => No,
        '\u{1FFB}' => No,
        '\u{1FFD}' => No,
        '\u{2000}'..='\u{2001}' => No,
        '\u{2126}' => No,
        '\u{212A}'..='\u{212B}' => No,
        '\u{2329}' => No,
        '\u{232A}' => No,
        '\u{2ADC}' => No,
        '\u{F900}'..='\u{FA0D}' => No,
        '\u{FA10}' => No,
        '\u{FA12}' => No,
        '\u{FA15}'..='\u{FA1E}' => No,
        '\u{FA20}' => No,
        '\u{FA22}' => No,
        '\u{FA25}'..='\u{FA26}' => No,
        '\u{FA2A}'..='\u{FA6D}' => No,
        '\u{FA70}'..='\u{FAD9}' => No,
        '\u{FB1D}' => No,
        '\u{FB1F}' => No,
        '\u{FB2A}'..='\u{FB36}' => No,
        '\u{FB38}'..='\u{FB3C}' => No,
        '\u{FB3E}' => No,
        '\u{FB40}'..='\u{FB41}' => No,
        '\u{FB43}'..='\u{FB44}' => No,
        '\u{FB46}'..='\u{FB4E}' => No,
        '\u{1D15E}'..='\u{1D164}' => No,
        '\u{1D1BB}'..='\u{1D1C0}' => No,
        '\u{2F800}'..='\u{2FA1D}' => No,
        '\u{0300}'..='\u{0304}' => Maybe,
        '\u{0306}'..='\u{030C}' => Maybe,
        '\u{030F}' => Maybe,
        '\u{0311}' => Maybe,
        '\u{0313}'..='\u{0314}' => Maybe,
        '\u{031B}' => Maybe,
        '\u{0323}'..='\u{0328}' => Maybe,
        '\u{032D}'..='\u{032E}' => Maybe,
        '\u{0330}'..='\u{0331}' => Maybe,
        '\u{0338}' => Maybe,
        '\u{0342}' => Maybe,
        '\u{0345}' => Maybe,
        '\u{0653}'..='\u{0655}' => Maybe,
        '\u{093C}' => Maybe,
        '\u{09BE}' => Maybe,
        '\u{09D7}' => Maybe,
        '\u{0B3E}' => Maybe,
        '\u{0B56}' => Maybe,
        '\u{0B57}' => Maybe,
        '\u{0BBE}' => Maybe,
        '\u{0BD7}' => Maybe,
        '\u{0C56}' => Maybe,
        '\u{0CC2}' => Maybe,
        '\u{0CD5}'..='\u{0CD6}' => Maybe,
        '\u{0D3E}' => Maybe,
        '\u{0D57}' => Maybe,
        '\u{0DCA}' => Maybe,
        '\u{0DCF}' => Maybe,
        '\u{0DDF}' => Maybe,
        '\u{102E}' => Maybe,
        '\u{1161}'..='\u{1175}' => Maybe,
        '\u{11A8}'..='\u{11C2}' => Maybe,
        '\u{1B35}' => Maybe,
        '\u{3099}'..='\u{309A}' => Maybe,
        '\u{110BA}' => Maybe,
        '\u{11127}' => Maybe,
        '\u{1133E}' => Maybe,
        '\u{11357}' => Maybe,
        '\u{113B8}' => Maybe,
        '\u{113BB}' => Maybe,
        '\u{113C2}' => Maybe,
        '\u{113C5}' => Maybe,
        '\u{113C7}'..='\u{113C9}' => Maybe,
        '\u{114B0}' => Maybe,
        '\u{114BA}' => Maybe,
        '\u{114BD}' => Maybe,
        '\u{115AF}' => Maybe,
        '\u{11930}' => Maybe,
        '\u{1611E}'..='\u{16129}' => Maybe,
        '\u{16D67}'..='\u{16D68}' => Maybe,
        _ => Yes,
    }
}
#[inline]
#[allow(ellipsis_inclusive_range_patterns)]
pub fn qc_nfkc(c: char) -> IsNormalized {
    match c {
        '\u{00A0}' => No,
        '\u{00A8}' => No,
        '\u{00AA}' => No,
        '\u{00AF}' => No,
        '\u{00B2}'..='\u{00B3}' => No,
        '\u{00B4}' => No,
        '\u{00B5}' => No,
        '\u{00B8}' => No,
        '\u{00B9}' => No,
        '\u{00BA}' => No,
        '\u{00BC}'..='\u{00BE}' => No,
        '\u{0132}'..='\u{0133}' => No,
        '\u{013F}'..='\u{0140}' => No,
        '\u{0149}' => No,
        '\u{017F}' => No,
        '\u{01C4}'..='\u{01CC}' => No,
        '\u{01F1}'..='\u{01F3}' => No,
        '\u{02B0}'..='\u{02B8}' => No,
        '\u{02D8}'..='\u{02DD}' => No,
        '\u{02E0}'..='\u{02E4}' => No,
        '\u{0340}'..='\u{0341}' => No,
        '\u{0343}'..='\u{0344}' => No,
        '\u{0374}' => No,
        '\u{037A}' => No,
        '\u{037E}' => No,
        '\u{0384}'..='\u{0385}' => No,
        '\u{0387}' => No,
        '\u{03D0}'..='\u{03D6}' => No,
        '\u{03F0}'..='\u{03F2}' => No,
        '\u{03F4}'..='\u{03F5}' => No,
        '\u{03F9}' => No,
        '\u{0587}' => No,
        '\u{0675}'..='\u{0678}' => No,
        '\u{0958}'..='\u{095F}' => No,
        '\u{09DC}'..='\u{09DD}' => No,
        '\u{09DF}' => No,
        '\u{0A33}' => No,
        '\u{0A36}' => No,
        '\u{0A59}'..='\u{0A5B}' => No,
        '\u{0A5E}' => No,
        '\u{0B5C}'..='\u{0B5D}' => No,
        '\u{0E33}' => No,
        '\u{0EB3}' => No,
        '\u{0EDC}'..='\u{0EDD}' => No,
        '\u{0F0C}' => No,
        '\u{0F43}' => No,
        '\u{0F4D}' => No,
        '\u{0F52}' => No,
        '\u{0F57}' => No,
        '\u{0F5C}' => No,
        '\u{0F69}' => No,
        '\u{0F73}' => No,
        '\u{0F75}'..='\u{0F79}' => No,
        '\u{0F81}' => No,
        '\u{0F93}' => No,
        '\u{0F9D}' => No,
        '\u{0FA2}' => No,
        '\u{0FA7}' => No,
        '\u{0FAC}' => No,
        '\u{0FB9}' => No,
        '\u{10FC}' => No,
        '\u{1D2C}'..='\u{1D2E}' => No,
        '\u{1D30}'..='\u{1D3A}' => No,
        '\u{1D3C}'..='\u{1D4D}' => No,
        '\u{1D4F}'..='\u{1D6A}' => No,
        '\u{1D78}' => No,
        '\u{1D9B}'..='\u{1DBF}' => No,
        '\u{1E9A}'..='\u{1E9B}' => No,
        '\u{1F71}' => No,
        '\u{1F73}' => No,
        '\u{1F75}' => No,
        '\u{1F77}' => No,
        '\u{1F79}' => No,
        '\u{1F7B}' => No,
        '\u{1F7D}' => No,
        '\u{1FBB}' => No,
        '\u{1FBD}' => No,
        '\u{1FBE}' => No,
        '\u{1FBF}'..='\u{1FC1}' => No,
        '\u{1FC9}' => No,
        '\u{1FCB}' => No,
        '\u{1FCD}'..='\u{1FCF}' => No,
        '\u{1FD3}' => No,
        '\u{1FDB}' => No,
        '\u{1FDD}'..='\u{1FDF}' => No,
        '\u{1FE3}' => No,
        '\u{1FEB}' => No,
        '\u{1FED}'..='\u{1FEF}' => No,
        '\u{1FF9}' => No,
        '\u{1FFB}' => No,
        '\u{1FFD}'..='\u{1FFE}' => No,
        '\u{2000}'..='\u{200A}' => No,
        '\u{2011}' => No,
        '\u{2017}' => No,
        '\u{2024}'..='\u{2026}' => No,
        '\u{202F}' => No,
        '\u{2033}'..='\u{2034}' => No,
        '\u{2036}'..='\u{2037}' => No,
        '\u{203C}' => No,
        '\u{203E}' => No,
        '\u{2047}'..='\u{2049}' => No,
        '\u{2057}' => No,
        '\u{205F}' => No,
        '\u{2070}' => No,
        '\u{2071}' => No,
        '\u{2074}'..='\u{2079}' => No,
        '\u{207A}'..='\u{207C}' => No,
        '\u{207D}' => No,
        '\u{207E}' => No,
        '\u{207F}' => No,
        '\u{2080}'..='\u{2089}' => No,
        '\u{208A}'..='\u{208C}' => No,
        '\u{208D}' => No,
        '\u{208E}' => No,
        '\u{2090}'..='\u{209C}' => No,
        '\u{20A8}' => No,
        '\u{2100}'..='\u{2101}' => No,
        '\u{2102}' => No,
        '\u{2103}' => No,
        '\u{2105}'..='\u{2106}' => No,
        '\u{2107}' => No,
        '\u{2109}' => No,
        '\u{210A}'..='\u{2113}' => No,
        '\u{2115}' => No,
        '\u{2116}' => No,
        '\u{2119}'..='\u{211D}' => No,
        '\u{2120}'..='\u{2122}' => No,
        '\u{2124}' => No,
        '\u{2126}' => No,
        '\u{2128}' => No,
        '\u{212A}'..='\u{212D}' => No,
        '\u{212F}'..='\u{2131}' => No,
        '\u{2133}'..='\u{2134}' => No,
        '\u{2135}'..='\u{2138}' => No,
        '\u{2139}' => No,
        '\u{213B}' => No,
        '\u{213C}'..='\u{213F}' => No,
        '\u{2140}' => No,
        '\u{2145}'..='\u{2149}' => No,
        '\u{2150}'..='\u{215F}' => No,
        '\u{2160}'..='\u{217F}' => No,
        '\u{2189}' => No,
        '\u{222C}'..='\u{222D}' => No,
        '\u{222F}'..='\u{2230}' => No,
        '\u{2329}' => No,
        '\u{232A}' => No,
        '\u{2460}'..='\u{249B}' => No,
        '\u{249C}'..='\u{24E9}' => No,
        '\u{24EA}' => No,
        '\u{2A0C}' => No,
        '\u{2A74}'..='\u{2A76}' => No,
        '\u{2ADC}' => No,
        '\u{2C7C}'..='\u{2C7D}' => No,
        '\u{2D6F}' => No,
        '\u{2E9F}' => No,
        '\u{2EF3}' => No,
        '\u{2F00}'..='\u{2FD5}' => No,
        '\u{3000}' => No,
        '\u{3036}' => No,
        '\u{3038}'..='\u{303A}' => No,
        '\u{309B}'..='\u{309C}' => No,
        '\u{309F}' => No,
        '\u{30FF}' => No,
        '\u{3131}'..='\u{318E}' => No,
        '\u{3192}'..='\u{3195}' => No,
        '\u{3196}'..='\u{319F}' => No,
        '\u{3200}'..='\u{321E}' => No,
        '\u{3220}'..='\u{3229}' => No,
        '\u{322A}'..='\u{3247}' => No,
        '\u{3250}' => No,
        '\u{3251}'..='\u{325F}' => No,
        '\u{3260}'..='\u{327E}' => No,
        '\u{3280}'..='\u{3289}' => No,
        '\u{328A}'..='\u{32B0}' => No,
        '\u{32B1}'..='\u{32BF}' => No,
        '\u{32C0}'..='\u{33FF}' => No,
        '\u{A69C}'..='\u{A69D}' => No,
        '\u{A770}' => No,
        '\u{A7F2}'..='\u{A7F4}' => No,
        '\u{A7F8}'..='\u{A7F9}' => No,
        '\u{AB5C}'..='\u{AB5F}' => No,
        '\u{AB69}' => No,
        '\u{F900}'..='\u{FA0D}' => No,
        '\u{FA10}' => No,
        '\u{FA12}' => No,
        '\u{FA15}'..='\u{FA1E}' => No,
        '\u{FA20}' => No,
        '\u{FA22}' => No,
        '\u{FA25}'..='\u{FA26}' => No,
        '\u{FA2A}'..='\u{FA6D}' => No,
        '\u{FA70}'..='\u{FAD9}' => No,
        '\u{FB00}'..='\u{FB06}' => No,
        '\u{FB13}'..='\u{FB17}' => No,
        '\u{FB1D}' => No,
        '\u{FB1F}'..='\u{FB28}' => No,
        '\u{FB29}' => No,
        '\u{FB2A}'..='\u{FB36}' => No,
        '\u{FB38}'..='\u{FB3C}' => No,
        '\u{FB3E}' => No,
        '\u{FB40}'..='\u{FB41}' => No,
        '\u{FB43}'..='\u{FB44}' => No,
        '\u{FB46}'..='\u{FBB1}' => No,
        '\u{FBD3}'..='\u{FD3D}' => No,
        '\u{FD50}'..='\u{FD8F}' => No,
        '\u{FD92}'..='\u{FDC7}' => No,
        '\u{FDF0}'..='\u{FDFB}' => No,
        '\u{FDFC}' => No,
        '\u{FE10}'..='\u{FE16}' => No,
        '\u{FE17}' => No,
        '\u{FE18}' => No,
        '\u{FE19}' => No,
        '\u{FE30}' => No,
        '\u{FE31}'..='\u{FE32}' => No,
        '\u{FE33}'..='\u{FE34}' => No,
        '\u{FE35}' => No,
        '\u{FE36}' => No,
        '\u{FE37}' => No,
        '\u{FE38}' => No,
        '\u{FE39}' => No,
        '\u{FE3A}' => No,
        '\u{FE3B}' => No,
        '\u{FE3C}' => No,
        '\u{FE3D}' => No,
        '\u{FE3E}' => No,
        '\u{FE3F}' => No,
        '\u{FE40}' => No,
        '\u{FE41}' => No,
        '\u{FE42}' => No,
        '\u{FE43}' => No,
        '\u{FE44}' => No,
        '\u{FE47}' => No,
        '\u{FE48}' => No,
        '\u{FE49}'..='\u{FE4C}' => No,
        '\u{FE4D}'..='\u{FE4F}' => No,
        '\u{FE50}'..='\u{FE52}' => No,
        '\u{FE54}'..='\u{FE57}' => No,
        '\u{FE58}' => No,
        '\u{FE59}' => No,
        '\u{FE5A}' => No,
        '\u{FE5B}' => No,
        '\u{FE5C}' => No,
        '\u{FE5D}' => No,
        '\u{FE5E}' => No,
        '\u{FE5F}'..='\u{FE61}' => No,
        '\u{FE62}' => No,
        '\u{FE63}' => No,
        '\u{FE64}'..='\u{FE66}' => No,
        '\u{FE68}' => No,
        '\u{FE69}' => No,
        '\u{FE6A}'..='\u{FE6B}' => No,
        '\u{FE70}'..='\u{FE72}' => No,
        '\u{FE74}' => No,
        '\u{FE76}'..='\u{FEFC}' => No,
        '\u{FF01}'..='\u{FF03}' => No,
        '\u{FF04}' => No,
        '\u{FF05}'..='\u{FF07}' => No,
        '\u{FF08}' => No,
        '\u{FF09}' => No,
        '\u{FF0A}' => No,
        '\u{FF0B}' => No,
        '\u{FF0C}' => No,
        '\u{FF0D}' => No,
        '\u{FF0E}'..='\u{FF0F}' => No,
        '\u{FF10}'..='\u{FF19}' => No,
        '\u{FF1A}'..='\u{FF1B}' => No,
        '\u{FF1C}'..='\u{FF1E}' => No,
        '\u{FF1F}'..='\u{FF20}' => No,
        '\u{FF21}'..='\u{FF3A}' => No,
        '\u{FF3B}' => No,
        '\u{FF3C}' => No,
        '\u{FF3D}' => No,
        '\u{FF3E}' => No,
        '\u{FF3F}' => No,
        '\u{FF40}' => No,
        '\u{FF41}'..='\u{FF5A}' => No,
        '\u{FF5B}' => No,
        '\u{FF5C}' => No,
        '\u{FF5D}' => No,
        '\u{FF5E}' => No,
        '\u{FF5F}' => No,
        '\u{FF60}' => No,
        '\u{FF61}' => No,
        '\u{FF62}' => No,
        '\u{FF63}' => No,
        '\u{FF64}'..='\u{FF65}' => No,
        '\u{FF66}'..='\u{FF6F}' => No,
        '\u{FF70}' => No,
        '\u{FF71}'..='\u{FF9D}' => No,
        '\u{FF9E}'..='\u{FF9F}' => No,
        '\u{FFA0}'..='\u{FFBE}' => No,
        '\u{FFC2}'..='\u{FFC7}' => No,
        '\u{FFCA}'..='\u{FFCF}' => No,
        '\u{FFD2}'..='\u{FFD7}' => No,
        '\u{FFDA}'..='\u{FFDC}' => No,
        '\u{FFE0}'..='\u{FFE1}' => No,
        '\u{FFE2}' => No,
        '\u{FFE3}' => No,
        '\u{FFE4}' => No,
        '\u{FFE5}'..='\u{FFE6}' => No,
        '\u{FFE8}' => No,
        '\u{FFE9}'..='\u{FFEC}' => No,
        '\u{FFED}'..='\u{FFEE}' => No,
        '\u{10781}'..='\u{10785}' => No,
        '\u{10787}'..='\u{107B0}' => No,
        '\u{107B2}'..='\u{107BA}' => No,
        '\u{1CCD6}'..='\u{1CCEF}' => No,
        '\u{1CCF0}'..='\u{1CCF9}' => No,
        '\u{1D15E}'..='\u{1D164}' => No,
        '\u{1D1BB}'..='\u{1D1C0}' => No,
        '\u{1D400}'..='\u{1D454}' => No,
        '\u{1D456}'..='\u{1D49C}' => No,
        '\u{1D49E}'..='\u{1D49F}' => No,
        '\u{1D4A2}' => No,
        '\u{1D4A5}'..='\u{1D4A6}' => No,
        '\u{1D4A9}'..='\u{1D4AC}' => No,
        '\u{1D4AE}'..='\u{1D4B9}' => No,
        '\u{1D4BB}' => No,
        '\u{1D4BD}'..='\u{1D4C3}' => No,
        '\u{1D4C5}'..='\u{1D505}' => No,
        '\u{1D507}'..='\u{1D50A}' => No,
        '\u{1D50D}'..='\u{1D514}' => No,
        '\u{1D516}'..='\u{1D51C}' => No,
        '\u{1D51E}'..='\u{1D539}' => No,
        '\u{1D53B}'..='\u{1D53E}' => No,
        '\u{1D540}'..='\u{1D544}' => No,
        '\u{1D546}' => No,
        '\u{1D54A}'..='\u{1D550}' => No,
        '\u{1D552}'..='\u{1D6A5}' => No,
        '\u{1D6A8}'..='\u{1D6C0}' => No,
        '\u{1D6C1}' => No,
        '\u{1D6C2}'..='\u{1D6DA}' => No,
        '\u{1D6DB}' => No,
        '\u{1D6DC}'..='\u{1D6FA}' => No,
        '\u{1D6FB}' => No,
        '\u{1D6FC}'..='\u{1D714}' => No,
        '\u{1D715}' => No,
        '\u{1D716}'..='\u{1D734}' => No,
        '\u{1D735}' => No,
        '\u{1D736}'..='\u{1D74E}' => No,
        '\u{1D74F}' => No,
        '\u{1D750}'..='\u{1D76E}' => No,
        '\u{1D76F}' => No,
        '\u{1D770}'..='\u{1D788}' => No,
        '\u{1D789}' => No,
        '\u{1D78A}'..='\u{1D7A8}' => No,
        '\u{1D7A9}' => No,
        '\u{1D7AA}'..='\u{1D7C2}' => No,
        '\u{1D7C3}' => No,
        '\u{1D7C4}'..='\u{1D7CB}' => No,
        '\u{1D7CE}'..='\u{1D7FF}' => No,
        '\u{1E030}'..='\u{1E06D}' => No,
        '\u{1EE00}'..='\u{1EE03}' => No,
        '\u{1EE05}'..='\u{1EE1F}' => No,
        '\u{1EE21}'..='\u{1EE22}' => No,
        '\u{1EE24}' => No,
        '\u{1EE27}' => No,
        '\u{1EE29}'..='\u{1EE32}' => No,
        '\u{1EE34}'..='\u{1EE37}' => No,
        '\u{1EE39}' => No,
        '\u{1EE3B}' => No,
        '\u{1EE42}' => No,
        '\u{1EE47}' => No,
        '\u{1EE49}' => No,
        '\u{1EE4B}' => No,
        '\u{1EE4D}'..='\u{1EE4F}' => No,
        '\u{1EE51}'..='\u{1EE52}' => No,
        '\u{1EE54}' => No,
        '\u{1EE57}' => No,
        '\u{1EE59}' => No,
        '\u{1EE5B}' => No,
        '\u{1EE5D}' => No,
        '\u{1EE5F}' => No,
        '\u{1EE61}'..='\u{1EE62}' => No,
        '\u{1EE64}' => No,
        '\u{1EE67}'..='\u{1EE6A}' => No,
        '\u{1EE6C}'..='\u{1EE72}' => No,
        '\u{1EE74}'..='\u{1EE77}' => No,
        '\u{1EE79}'..='\u{1EE7C}' => No,
        '\u{1EE7E}' => No,
        '\u{1EE80}'..='\u{1EE89}' => No,
        '\u{1EE8B}'..='\u{1EE9B}' => No,
        '\u{1EEA1}'..='\u{1EEA3}' => No,
        '\u{1EEA5}'..='\u{1EEA9}' => No,
        '\u{1EEAB}'..='\u{1EEBB}' => No,
        '\u{1F100}'..='\u{1F10A}' => No,
        '\u{1F110}'..='\u{1F12E}' => No,
        '\u{1F130}'..='\u{1F14F}' => No,
        '\u{1F16A}'..='\u{1F16C}' => No,
        '\u{1F190}' => No,
        '\u{1F200}'..='\u{1F202}' => No,
        '\u{1F210}'..='\u{1F23B}' => No,
        '\u{1F240}'..='\u{1F248}' => No,
        '\u{1F250}'..='\u{1F251}' => No,
        '\u{1FBF0}'..='\u{1FBF9}' => No,
        '\u{2F800}'..='\u{2FA1D}' => No,
        '\u{0300}'..='\u{0304}' => Maybe,
        '\u{0306}'..='\u{030C}' => Maybe,
        '\u{030F}' => Maybe,
        '\u{0311}' => Maybe,
        '\u{0313}'..='\u{0314}' => Maybe,
        '\u{031B}' => Maybe,
        '\u{0323}'..='\u{0328}' => Maybe,
        '\u{032D}'..='\u{032E}' => Maybe,
        '\u{0330}'..='\u{0331}' => Maybe,
        '\u{0338}' => Maybe,
        '\u{0342}' => Maybe,
        '\u{0345}' => Maybe,
        '\u{0653}'..='\u{0655}' => Maybe,
        '\u{093C}' => Maybe,
        '\u{09BE}' => Maybe,
        '\u{09D7}' => Maybe,
        '\u{0B3E}' => Maybe,
        '\u{0B56}' => Maybe,
        '\u{0B57}' => Maybe,
        '\u{0BBE}' => Maybe,
        '\u{0BD7}' => Maybe,
        '\u{0C56}' => Maybe,
        '\u{0CC2}' => Maybe,
        '\u{0CD5}'..='\u{0CD6}' => Maybe,
        '\u{0D3E}' => Maybe,
        '\u{0D57}' => Maybe,
        '\u{0DCA}' => Maybe,
        '\u{0DCF}' => Maybe,
        '\u{0DDF}' => Maybe,
        '\u{102E}' => Maybe,
        '\u{1161}'..='\u{1175}' => Maybe,
        '\u{11A8}'..='\u{11C2}' => Maybe,
        '\u{1B35}' => Maybe,
        '\u{3099}'..='\u{309A}' => Maybe,
        '\u{110BA}' => Maybe,
        '\u{11127}' => Maybe,
        '\u{1133E}' => Maybe,
        '\u{11357}' => Maybe,
        '\u{113B8}' => Maybe,
        '\u{113BB}' => Maybe,
        '\u{113C2}' => Maybe,
        '\u{113C5}' => Maybe,
        '\u{113C7}'..='\u{113C9}' => Maybe,
        '\u{114B0}' => Maybe,
        '\u{114BA}' => Maybe,
        '\u{114BD}' => Maybe,
        '\u{115AF}' => Maybe,
        '\u{11930}' => Maybe,
        '\u{1611E}'..='\u{16129}' => Maybe,
        '\u{16D67}'..='\u{16D68}' => Maybe,
        _ => Yes,
    }
}
#[inline]
#[allow(ellipsis_inclusive_range_patterns)]
pub fn qc_nfd(c: char) -> IsNormalized {
    match c {
        '\u{00C0}'..='\u{00C5}' => No,
        '\u{00C7}'..='\u{00CF}' => No,
        '\u{00D1}'..='\u{00D6}' => No,
        '\u{00D9}'..='\u{00DD}' => No,
        '\u{00E0}'..='\u{00E5}' => No,
        '\u{00E7}'..='\u{00EF}' => No,
        '\u{00F1}'..='\u{00F6}' => No,
        '\u{00F9}'..='\u{00FD}' => No,
        '\u{00FF}'..='\u{010F}' => No,
        '\u{0112}'..='\u{0125}' => No,
        '\u{0128}'..='\u{0130}' => No,
        '\u{0134}'..='\u{0137}' => No,
        '\u{0139}'..='\u{013E}' => No,
        '\u{0143}'..='\u{0148}' => No,
        '\u{014C}'..='\u{0151}' => No,
        '\u{0154}'..='\u{0165}' => No,
        '\u{0168}'..='\u{017E}' => No,
        '\u{01A0}'..='\u{01A1}' => No,
        '\u{01AF}'..='\u{01B0}' => No,
        '\u{01CD}'..='\u{01DC}' => No,
        '\u{01DE}'..='\u{01E3}' => No,
        '\u{01E6}'..='\u{01F0}' => No,
        '\u{01F4}'..='\u{01F5}' => No,
        '\u{01F8}'..='\u{021B}' => No,
        '\u{021E}'..='\u{021F}' => No,
        '\u{0226}'..='\u{0233}' => No,
        '\u{0340}'..='\u{0341}' => No,
        '\u{0343}'..='\u{0344}' => No,
        '\u{0374}' => No,
        '\u{037E}' => No,
        '\u{0385}' => No,
        '\u{0386}' => No,
        '\u{0387}' => No,
        '\u{0388}'..='\u{038A}' => No,
        '\u{038C}' => No,
        '\u{038E}'..='\u{0390}' => No,
        '\u{03AA}'..='\u{03B0}' => No,
        '\u{03CA}'..='\u{03CE}' => No,
        '\u{03D3}'..='\u{03D4}' => No,
        '\u{0400}'..='\u{0401}' => No,
        '\u{0403}' => No,
        '\u{0407}' => No,
        '\u{040C}'..='\u{040E}' => No,
        '\u{0419}' => No,
        '\u{0439}' => No,
        '\u{0450}'..='\u{0451}' => No,
        '\u{0453}' => No,
        '\u{0457}' => No,
        '\u{045C}'..='\u{045E}' => No,
        '\u{0476}'..='\u{0477}' => No,
        '\u{04C1}'..='\u{04C2}' => No,
        '\u{04D0}'..='\u{04D3}' => No,
        '\u{04D6}'..='\u{04D7}' => No,
        '\u{04DA}'..='\u{04DF}' => No,
        '\u{04E2}'..='\u{04E7}' => No,
        '\u{04EA}'..='\u{04F5}' => No,
        '\u{04F8}'..='\u{04F9}' => No,
        '\u{0622}'..='\u{0626}' => No,
        '\u{06C0}' => No,
        '\u{06C2}' => No,
        '\u{06D3}' => No,
        '\u{0929}' => No,
        '\u{0931}' => No,
        '\u{0934}' => No,
        '\u{0958}'..='\u{095F}' => No,
        '\u{09CB}'..='\u{09CC}' => No,
        '\u{09DC}'..='\u{09DD}' => No,
        '\u{09DF}' => No,
        '\u{0A33}' => No,
        '\u{0A36}' => No,
        '\u{0A59}'..='\u{0A5B}' => No,
        '\u{0A5E}' => No,
        '\u{0B48}' => No,
        '\u{0B4B}'..='\u{0B4C}' => No,
        '\u{0B5C}'..='\u{0B5D}' => No,
        '\u{0B94}' => No,
        '\u{0BCA}'..='\u{0BCC}' => No,
        '\u{0C48}' => No,
        '\u{0CC0}' => No,
        '\u{0CC7}'..='\u{0CC8}' => No,
        '\u{0CCA}'..='\u{0CCB}' => No,
        '\u{0D4A}'..='\u{0D4C}' => No,
        '\u{0DDA}' => No,
        '\u{0DDC}'..='\u{0DDE}' => No,
        '\u{0F43}' => No,
        '\u{0F4D}' => No,
        '\u{0F52}' => No,
        '\u{0F57}' => No,
        '\u{0F5C}' => No,
        '\u{0F69}' => No,
        '\u{0F73}' => No,
        '\u{0F75}'..='\u{0F76}' => No,
        '\u{0F78}' => No,
        '\u{0F81}' => No,
        '\u{0F93}' => No,
        '\u{0F9D}' => No,
        '\u{0FA2}' => No,
        '\u{0FA7}' => No,
        '\u{0FAC}' => No,
        '\u{0FB9}' => No,
        '\u{1026}' => No,
        '\u{1B06}' => No,
        '\u{1B08}' => No,
        '\u{1B0A}' => No,
        '\u{1B0C}' => No,
        '\u{1B0E}' => No,
        '\u{1B12}' => No,
        '\u{1B3B}' => No,
        '\u{1B3D}' => No,
        '\u{1B40}'..='\u{1B41}' => No,
        '\u{1B43}' => No,
        '\u{1E00}'..='\u{1E99}' => No,
        '\u{1E9B}' => No,
        '\u{1EA0}'..='\u{1EF9}' => No,
        '\u{1F00}'..='\u{1F15}' => No,
        '\u{1F18}'..='\u{1F1D}' => No,
        '\u{1F20}'..='\u{1F45}' => No,
        '\u{1F48}'..='\u{1F4D}' => No,
        '\u{1F50}'..='\u{1F57}' => No,
        '\u{1F59}' => No,
        '\u{1F5B}' => No,
        '\u{1F5D}' => No,
        '\u{1F5F}'..='\u{1F7D}' => No,
        '\u{1F80}'..='\u{1FB4}' => No,
        '\u{1FB6}'..='\u{1FBC}' => No,
        '\u{1FBE}' => No,
        '\u{1FC1}' => No,
        '\u{1FC2}'..='\u{1FC4}' => No,
        '\u{1FC6}'..='\u{1FCC}' => No,
        '\u{1FCD}'..='\u{1FCF}' => No,
        '\u{1FD0}'..='\u{1FD3}' => No,
        '\u{1FD6}'..='\u{1FDB}' => No,
        '\u{1FDD}'..='\u{1FDF}' => No,
        '\u{1FE0}'..='\u{1FEC}' => No,
        '\u{1FED}'..='\u{1FEF}' => No,
        '\u{1FF2}'..='\u{1FF4}' => No,
        '\u{1FF6}'..='\u{1FFC}' => No,
        '\u{1FFD}' => No,
        '\u{2000}'..='\u{2001}' => No,
        '\u{2126}' => No,
        '\u{212A}'..='\u{212B}' => No,
        '\u{219A}'..='\u{219B}' => No,
        '\u{21AE}' => No,
        '\u{21CD}' => No,
        '\u{21CE}'..='\u{21CF}' => No,
        '\u{2204}' => No,
        '\u{2209}' => No,
        '\u{220C}' => No,
        '\u{2224}' => No,
        '\u{2226}' => No,
        '\u{2241}' => No,
        '\u{2244}' => No,
        '\u{2247}' => No,
        '\u{2249}' => No,
        '\u{2260}' => No,
        '\u{2262}' => No,
        '\u{226D}'..='\u{2271}' => No,
        '\u{2274}'..='\u{2275}' => No,
        '\u{2278}'..='\u{2279}' => No,
        '\u{2280}'..='\u{2281}' => No,
        '\u{2284}'..='\u{2285}' => No,
        '\u{2288}'..='\u{2289}' => No,
        '\u{22AC}'..='\u{22AF}' => No,
        '\u{22E0}'..='\u{22E3}' => No,
        '\u{22EA}'..='\u{22ED}' => No,
        '\u{2329}' => No,
        '\u{232A}' => No,
        '\u{2ADC}' => No,
        '\u{304C}' => No,
        '\u{304E}' => No,
        '\u{3050}' => No,
        '\u{3052}' => No,
        '\u{3054}' => No,
        '\u{3056}' => No,
        '\u{3058}' => No,
        '\u{305A}' => No,
        '\u{305C}' => No,
        '\u{305E}' => No,
        '\u{3060}' => No,
        '\u{3062}' => No,
        '\u{3065}' => No,
        '\u{3067}' => No,
        '\u{3069}' => No,
        '\u{3070}'..='\u{3071}' => No,
        '\u{3073}'..='\u{3074}' => No,
        '\u{3076}'..='\u{3077}' => No,
        '\u{3079}'..='\u{307A}' => No,
        '\u{307C}'..='\u{307D}' => No,
        '\u{3094}' => No,
        '\u{309E}' => No,
        '\u{30AC}' => No,
        '\u{30AE}' => No,
        '\u{30B0}' => No,
        '\u{30B2}' => No,
        '\u{30B4}' => No,
        '\u{30B6}' => No,
        '\u{30B8}' => No,
        '\u{30BA}' => No,
        '\u{30BC}' => No,
        '\u{30BE}' => No,
        '\u{30C0}' => No,
        '\u{30C2}' => No,
        '\u{30C5}' => No,
        '\u{30C7}' => No,
        '\u{30C9}' => No,
        '\u{30D0}'..='\u{30D1}' => No,
        '\u{30D3}'..='\u{30D4}' => No,
        '\u{30D6}'..='\u{30D7}' => No,
        '\u{30D9}'..='\u{30DA}' => No,
        '\u{30DC}'..='\u{30DD}' => No,
        '\u{30F4}' => No,
        '\u{30F7}'..='\u{30FA}' => No,
        '\u{30FE}' => No,
        '\u{AC00}'..='\u{D7A3}' => No,
        '\u{F900}'..='\u{FA0D}' => No,
        '\u{FA10}' => No,
        '\u{FA12}' => No,
        '\u{FA15}'..='\u{FA1E}' => No,
        '\u{FA20}' => No,
        '\u{FA22}' => No,
        '\u{FA25}'..='\u{FA26}' => No,
        '\u{FA2A}'..='\u{FA6D}' => No,
        '\u{FA70}'..='\u{FAD9}' => No,
        '\u{FB1D}' => No,
        '\u{FB1F}' => No,
        '\u{FB2A}'..='\u{FB36}' => No,
        '\u{FB38}'..='\u{FB3C}' => No,
        '\u{FB3E}' => No,
        '\u{FB40}'..='\u{FB41}' => No,
        '\u{FB43}'..='\u{FB44}' => No,
        '\u{FB46}'..='\u{FB4E}' => No,
        '\u{105C9}' => No,
        '\u{105E4}' => No,
        '\u{1109A}' => No,
        '\u{1109C}' => No,
        '\u{110AB}' => No,
        '\u{1112E}'..='\u{1112F}' => No,
        '\u{1134B}'..='\u{1134C}' => No,
        '\u{11383}' => No,
        '\u{11385}' => No,
        '\u{1138E}' => No,
        '\u{11391}' => No,
        '\u{113C5}' => No,
        '\u{113C7}'..='\u{113C8}' => No,
        '\u{114BB}'..='\u{114BC}' => No,
        '\u{114BE}' => No,
        '\u{115BA}'..='\u{115BB}' => No,
        '\u{11938}' => No,
        '\u{16121}'..='\u{16128}' => No,
        '\u{16D68}'..='\u{16D6A}' => No,
        '\u{1D15E}'..='\u{1D164}' => No,
        '\u{1D1BB}'..='\u{1D1C0}' => No,
        '\u{2F800}'..='\u{2FA1D}' => No,
        _ => Yes,
    }
}
#[inline]
#[allow(ellipsis_inclusive_range_patterns)]
pub fn qc_nfkd(c: char) -> IsNormalized {
    match c {
        '\u{00A0}' => No,
        '\u{00A8}' => No,
        '\u{00AA}' => No,
        '\u{00AF}' => No,
        '\u{00B2}'..='\u{00B3}' => No,
        '\u{00B4}' => No,
        '\u{00B5}' => No,
        '\u{00B8}' => No,
        '\u{00B9}' => No,
        '\u{00BA}' => No,
        '\u{00BC}'..='\u{00BE}' => No,
        '\u{00C0}'..='\u{00C5}' => No,
        '\u{00C7}'..='\u{00CF}' => No,
        '\u{00D1}'..='\u{00D6}' => No,
        '\u{00D9}'..='\u{00DD}' => No,
        '\u{00E0}'..='\u{00E5}' => No,
        '\u{00E7}'..='\u{00EF}' => No,
        '\u{00F1}'..='\u{00F6}' => No,
        '\u{00F9}'..='\u{00FD}' => No,
        '\u{00FF}'..='\u{010F}' => No,
        '\u{0112}'..='\u{0125}' => No,
        '\u{0128}'..='\u{0130}' => No,
        '\u{0132}'..='\u{0137}' => No,
        '\u{0139}'..='\u{0140}' => No,
        '\u{0143}'..='\u{0149}' => No,
        '\u{014C}'..='\u{0151}' => No,
        '\u{0154}'..='\u{0165}' => No,
        '\u{0168}'..='\u{017F}' => No,
        '\u{01A0}'..='\u{01A1}' => No,
        '\u{01AF}'..='\u{01B0}' => No,
        '\u{01C4}'..='\u{01DC}' => No,
        '\u{01DE}'..='\u{01E3}' => No,
        '\u{01E6}'..='\u{01F5}' => No,
        '\u{01F8}'..='\u{021B}' => No,
        '\u{021E}'..='\u{021F}' => No,
        '\u{0226}'..='\u{0233}' => No,
        '\u{02B0}'..='\u{02B8}' => No,
        '\u{02D8}'..='\u{02DD}' => No,
        '\u{02E0}'..='\u{02E4}' => No,
        '\u{0340}'..='\u{0341}' => No,
        '\u{0343}'..='\u{0344}' => No,
        '\u{0374}' => No,
        '\u{037A}' => No,
        '\u{037E}' => No,
        '\u{0384}'..='\u{0385}' => No,
        '\u{0386}' => No,
        '\u{0387}' => No,
        '\u{0388}'..='\u{038A}' => No,
        '\u{038C}' => No,
        '\u{038E}'..='\u{0390}' => No,
        '\u{03AA}'..='\u{03B0}' => No,
        '\u{03CA}'..='\u{03CE}' => No,
        '\u{03D0}'..='\u{03D6}' => No,
        '\u{03F0}'..='\u{03F2}' => No,
        '\u{03F4}'..='\u{03F5}' => No,
        '\u{03F9}' => No,
        '\u{0400}'..='\u{0401}' => No,
        '\u{0403}' => No,
        '\u{0407}' => No,
        '\u{040C}'..='\u{040E}' => No,
        '\u{0419}' => No,
        '\u{0439}' => No,
        '\u{0450}'..='\u{0451}' => No,
        '\u{0453}' => No,
        '\u{0457}' => No,
        '\u{045C}'..='\u{045E}' => No,
        '\u{0476}'..='\u{0477}' => No,
        '\u{04C1}'..='\u{04C2}' => No,
        '\u{04D0}'..='\u{04D3}' => No,
        '\u{04D6}'..='\u{04D7}' => No,
        '\u{04DA}'..='\u{04DF}' => No,
        '\u{04E2}'..='\u{04E7}' => No,
        '\u{04EA}'..='\u{04F5}' => No,
        '\u{04F8}'..='\u{04F9}' => No,
        '\u{0587}' => No,
        '\u{0622}'..='\u{0626}' => No,
        '\u{0675}'..='\u{0678}' => No,
        '\u{06C0}' => No,
        '\u{06C2}' => No,
        '\u{06D3}' => No,
        '\u{0929}' => No,
        '\u{0931}' => No,
        '\u{0934}' => No,
        '\u{0958}'..='\u{095F}' => No,
        '\u{09CB}'..='\u{09CC}' => No,
        '\u{09DC}'..='\u{09DD}' => No,
        '\u{09DF}' => No,
        '\u{0A33}' => No,
        '\u{0A36}' => No,
        '\u{0A59}'..='\u{0A5B}' => No,
        '\u{0A5E}' => No,
        '\u{0B48}' => No,
        '\u{0B4B}'..='\u{0B4C}' => No,
        '\u{0B5C}'..='\u{0B5D}' => No,
        '\u{0B94}' => No,
        '\u{0BCA}'..='\u{0BCC}' => No,
        '\u{0C48}' => No,
        '\u{0CC0}' => No,
        '\u{0CC7}'..='\u{0CC8}' => No,
        '\u{0CCA}'..='\u{0CCB}' => No,
        '\u{0D4A}'..='\u{0D4C}' => No,
        '\u{0DDA}' => No,
        '\u{0DDC}'..='\u{0DDE}' => No,
        '\u{0E33}' => No,
        '\u{0EB3}' => No,
        '\u{0EDC}'..='\u{0EDD}' => No,
        '\u{0F0C}' => No,
        '\u{0F43}' => No,
        '\u{0F4D}' => No,
        '\u{0F52}' => No,
        '\u{0F57}' => No,
        '\u{0F5C}' => No,
        '\u{0F69}' => No,
        '\u{0F73}' => No,
        '\u{0F75}'..='\u{0F79}' => No,
        '\u{0F81}' => No,
        '\u{0F93}' => No,
        '\u{0F9D}' => No,
        '\u{0FA2}' => No,
        '\u{0FA7}' => No,
        '\u{0FAC}' => No,
        '\u{0FB9}' => No,
        '\u{1026}' => No,
        '\u{10FC}' => No,
        '\u{1B06}' => No,
        '\u{1B08}' => No,
        '\u{1B0A}' => No,
        '\u{1B0C}' => No,
        '\u{1B0E}' => No,
        '\u{1B12}' => No,
        '\u{1B3B}' => No,
        '\u{1B3D}' => No,
        '\u{1B40}'..='\u{1B41}' => No,
        '\u{1B43}' => No,
        '\u{1D2C}'..='\u{1D2E}' => No,
        '\u{1D30}'..='\u{1D3A}' => No,
        '\u{1D3C}'..='\u{1D4D}' => No,
        '\u{1D4F}'..='\u{1D6A}' => No,
        '\u{1D78}' => No,
        '\u{1D9B}'..='\u{1DBF}' => No,
        '\u{1E00}'..='\u{1E9B}' => No,
        '\u{1EA0}'..='\u{1EF9}' => No,
        '\u{1F00}'..='\u{1F15}' => No,
        '\u{1F18}'..='\u{1F1D}' => No,
        '\u{1F20}'..='\u{1F45}' => No,
        '\u{1F48}'..='\u{1F4D}' => No,
        '\u{1F50}'..='\u{1F57}' => No,
        '\u{1F59}' => No,
        '\u{1F5B}' => No,
        '\u{1F5D}' => No,
        '\u{1F5F}'..='\u{1F7D}' => No,
        '\u{1F80}'..='\u{1FB4}' => No,
        '\u{1FB6}'..='\u{1FBC}' => No,
        '\u{1FBD}' => No,
        '\u{1FBE}' => No,
        '\u{1FBF}'..='\u{1FC1}' => No,
        '\u{1FC2}'..='\u{1FC4}' => No,
        '\u{1FC6}'..='\u{1FCC}' => No,
        '\u{1FCD}'..='\u{1FCF}' => No,
        '\u{1FD0}'..='\u{1FD3}' => No,
        '\u{1FD6}'..='\u{1FDB}' => No,
        '\u{1FDD}'..='\u{1FDF}' => No,
        '\u{1FE0}'..='\u{1FEC}' => No,
        '\u{1FED}'..='\u{1FEF}' => No,
        '\u{1FF2}'..='\u{1FF4}' => No,
        '\u{1FF6}'..='\u{1FFC}' => No,
        '\u{1FFD}'..='\u{1FFE}' => No,
        '\u{2000}'..='\u{200A}' => No,
        '\u{2011}' => No,
        '\u{2017}' => No,
        '\u{2024}'..='\u{2026}' => No,
        '\u{202F}' => No,
        '\u{2033}'..='\u{2034}' => No,
        '\u{2036}'..='\u{2037}' => No,
        '\u{203C}' => No,
        '\u{203E}' => No,
        '\u{2047}'..='\u{2049}' => No,
        '\u{2057}' => No,
        '\u{205F}' => No,
        '\u{2070}' => No,
        '\u{2071}' => No,
        '\u{2074}'..='\u{2079}' => No,
        '\u{207A}'..='\u{207C}' => No,
        '\u{207D}' => No,
        '\u{207E}' => No,
        '\u{207F}' => No,
        '\u{2080}'..='\u{2089}' => No,
        '\u{208A}'..='\u{208C}' => No,
        '\u{208D}' => No,
        '\u{208E}' => No,
        '\u{2090}'..='\u{209C}' => No,
        '\u{20A8}' => No,
        '\u{2100}'..='\u{2101}' => No,
        '\u{2102}' => No,
        '\u{2103}' => No,
        '\u{2105}'..='\u{2106}' => No,
        '\u{2107}' => No,
        '\u{2109}' => No,
        '\u{210A}'..='\u{2113}' => No,
        '\u{2115}' => No,
        '\u{2116}' => No,
        '\u{2119}'..='\u{211D}' => No,
        '\u{2120}'..='\u{2122}' => No,
        '\u{2124}' => No,
        '\u{2126}' => No,
        '\u{2128}' => No,
        '\u{212A}'..='\u{212D}' => No,
        '\u{212F}'..='\u{2131}' => No,
        '\u{2133}'..='\u{2134}' => No,
        '\u{2135}'..='\u{2138}' => No,
        '\u{2139}' => No,
        '\u{213B}' => No,
        '\u{213C}'..='\u{213F}' => No,
        '\u{2140}' => No,
        '\u{2145}'..='\u{2149}' => No,
        '\u{2150}'..='\u{215F}' => No,
        '\u{2160}'..='\u{217F}' => No,
        '\u{2189}' => No,
        '\u{219A}'..='\u{219B}' => No,
        '\u{21AE}' => No,
        '\u{21CD}' => No,
        '\u{21CE}'..='\u{21CF}' => No,
        '\u{2204}' => No,
        '\u{2209}' => No,
        '\u{220C}' => No,
        '\u{2224}' => No,
        '\u{2226}' => No,
        '\u{222C}'..='\u{222D}' => No,
        '\u{222F}'..='\u{2230}' => No,
        '\u{2241}' => No,
        '\u{2244}' => No,
        '\u{2247}' => No,
        '\u{2249}' => No,
        '\u{2260}' => No,
        '\u{2262}' => No,
        '\u{226D}'..='\u{2271}' => No,
        '\u{2274}'..='\u{2275}' => No,
        '\u{2278}'..='\u{2279}' => No,
        '\u{2280}'..='\u{2281}' => No,
        '\u{2284}'..='\u{2285}' => No,
        '\u{2288}'..='\u{2289}' => No,
        '\u{22AC}'..='\u{22AF}' => No,
        '\u{22E0}'..='\u{22E3}' => No,
        '\u{22EA}'..='\u{22ED}' => No,
        '\u{2329}' => No,
        '\u{232A}' => No,
        '\u{2460}'..='\u{249B}' => No,
        '\u{249C}'..='\u{24E9}' => No,
        '\u{24EA}' => No,
        '\u{2A0C}' => No,
        '\u{2A74}'..='\u{2A76}' => No,
        '\u{2ADC}' => No,
        '\u{2C7C}'..='\u{2C7D}' => No,
        '\u{2D6F}' => No,
        '\u{2E9F}' => No,
        '\u{2EF3}' => No,
        '\u{2F00}'..='\u{2FD5}' => No,
        '\u{3000}' => No,
        '\u{3036}' => No,
        '\u{3038}'..='\u{303A}' => No,
        '\u{304C}' => No,
        '\u{304E}' => No,
        '\u{3050}' => No,
        '\u{3052}' => No,
        '\u{3054}' => No,
        '\u{3056}' => No,
        '\u{3058}' => No,
        '\u{305A}' => No,
        '\u{305C}' => No,
        '\u{305E}' => No,
        '\u{3060}' => No,
        '\u{3062}' => No,
        '\u{3065}' => No,
        '\u{3067}' => No,
        '\u{3069}' => No,
        '\u{3070}'..='\u{3071}' => No,
        '\u{3073}'..='\u{3074}' => No,
        '\u{3076}'..='\u{3077}' => No,
        '\u{3079}'..='\u{307A}' => No,
        '\u{307C}'..='\u{307D}' => No,
        '\u{3094}' => No,
        '\u{309B}'..='\u{309C}' => No,
        '\u{309E}' => No,
        '\u{309F}' => No,
        '\u{30AC}' => No,
        '\u{30AE}' => No,
        '\u{30B0}' => No,
        '\u{30B2}' => No,
        '\u{30B4}' => No,
        '\u{30B6}' => No,
        '\u{30B8}' => No,
        '\u{30BA}' => No,
        '\u{30BC}' => No,
        '\u{30BE}' => No,
        '\u{30C0}' => No,
        '\u{30C2}' => No,
        '\u{30C5}' => No,
        '\u{30C7}' => No,
        '\u{30C9}' => No,
        '\u{30D0}'..='\u{30D1}' => No,
        '\u{30D3}'..='\u{30D4}' => No,
        '\u{30D6}'..='\u{30D7}' => No,
        '\u{30D9}'..='\u{30DA}' => No,
        '\u{30DC}'..='\u{30DD}' => No,
        '\u{30F4}' => No,
        '\u{30F7}'..='\u{30FA}' => No,
        '\u{30FE}' => No,
        '\u{30FF}' => No,
        '\u{3131}'..='\u{318E}' => No,
        '\u{3192}'..='\u{3195}' => No,
        '\u{3196}'..='\u{319F}' => No,
        '\u{3200}'..='\u{321E}' => No,
        '\u{3220}'..='\u{3229}' => No,
        '\u{322A}'..='\u{3247}' => No,
        '\u{3250}' => No,
        '\u{3251}'..='\u{325F}' => No,
        '\u{3260}'..='\u{327E}' => No,
        '\u{3280}'..='\u{3289}' => No,
        '\u{328A}'..='\u{32B0}' => No,
        '\u{32B1}'..='\u{32BF}' => No,
        '\u{32C0}'..='\u{33FF}' => No,
        '\u{A69C}'..='\u{A69D}' => No,
        '\u{A770}' => No,
        '\u{A7F2}'..='\u{A7F4}' => No,
        '\u{A7F8}'..='\u{A7F9}' => No,
        '\u{AB5C}'..='\u{AB5F}' => No,
        '\u{AB69}' => No,
        '\u{AC00}'..='\u{D7A3}' => No,
        '\u{F900}'..='\u{FA0D}' => No,
        '\u{FA10}' => No,
        '\u{FA12}' => No,
        '\u{FA15}'..='\u{FA1E}' => No,
        '\u{FA20}' => No,
        '\u{FA22}' => No,
        '\u{FA25}'..='\u{FA26}' => No,
        '\u{FA2A}'..='\u{FA6D}' => No,
        '\u{FA70}'..='\u{FAD9}' => No,
        '\u{FB00}'..='\u{FB06}' => No,
        '\u{FB13}'..='\u{FB17}' => No,
        '\u{FB1D}' => No,
        '\u{FB1F}'..='\u{FB28}' => No,
        '\u{FB29}' => No,
        '\u{FB2A}'..='\u{FB36}' => No,
        '\u{FB38}'..='\u{FB3C}' => No,
        '\u{FB3E}' => No,
        '\u{FB40}'..='\u{FB41}' => No,
        '\u{FB43}'..='\u{FB44}' => No,
        '\u{FB46}'..='\u{FBB1}' => No,
        '\u{FBD3}'..='\u{FD3D}' => No,
        '\u{FD50}'..='\u{FD8F}' => No,
        '\u{FD92}'..='\u{FDC7}' => No,
        '\u{FDF0}'..='\u{FDFB}' => No,
        '\u{FDFC}' => No,
        '\u{FE10}'..='\u{FE16}' => No,
        '\u{FE17}' => No,
        '\u{FE18}' => No,
        '\u{FE19}' => No,
        '\u{FE30}' => No,
        '\u{FE31}'..='\u{FE32}' => No,
        '\u{FE33}'..='\u{FE34}' => No,
        '\u{FE35}' => No,
        '\u{FE36}' => No,
        '\u{FE37}' => No,
        '\u{FE38}' => No,
        '\u{FE39}' => No,
        '\u{FE3A}' => No,
        '\u{FE3B}' => No,
        '\u{FE3C}' => No,
        '\u{FE3D}' => No,
        '\u{FE3E}' => No,
        '\u{FE3F}' => No,
        '\u{FE40}' => No,
        '\u{FE41}' => No,
        '\u{FE42}' => No,
        '\u{FE43}' => No,
        '\u{FE44}' => No,
        '\u{FE47}' => No,
        '\u{FE48}' => No,
        '\u{FE49}'..='\u{FE4C}' => No,
        '\u{FE4D}'..='\u{FE4F}' => No,
        '\u{FE50}'..='\u{FE52}' => No,
        '\u{FE54}'..='\u{FE57}' => No,
        '\u{FE58}' => No,
        '\u{FE59}' => No,
        '\u{FE5A}' => No,
        '\u{FE5B}' => No,
        '\u{FE5C}' => No,
        '\u{FE5D}' => No,
        '\u{FE5E}' => No,
        '\u{FE5F}'..='\u{FE61}' => No,
        '\u{FE62}' => No,
        '\u{FE63}' => No,
        '\u{FE64}'..='\u{FE66}' => No,
        '\u{FE68}' => No,
        '\u{FE69}' => No,
        '\u{FE6A}'..='\u{FE6B}' => No,
        '\u{FE70}'..='\u{FE72}' => No,
        '\u{FE74}' => No,
        '\u{FE76}'..='\u{FEFC}' => No,
        '\u{FF01}'..='\u{FF03}' => No,
        '\u{FF04}' => No,
        '\u{FF05}'..='\u{FF07}' => No,
        '\u{FF08}' => No,
        '\u{FF09}' => No,
        '\u{FF0A}' => No,
        '\u{FF0B}' => No,
        '\u{FF0C}' => No,
        '\u{FF0D}' => No,
        '\u{FF0E}'..='\u{FF0F}' => No,
        '\u{FF10}'..='\u{FF19}' => No,
        '\u{FF1A}'..='\u{FF1B}' => No,
        '\u{FF1C}'..='\u{FF1E}' => No,
        '\u{FF1F}'..='\u{FF20}' => No,
        '\u{FF21}'..='\u{FF3A}' => No,
        '\u{FF3B}' => No,
        '\u{FF3C}' => No,
        '\u{FF3D}' => No,
        '\u{FF3E}' => No,
        '\u{FF3F}' => No,
        '\u{FF40}' => No,
        '\u{FF41}'..='\u{FF5A}' => No,
        '\u{FF5B}' => No,
        '\u{FF5C}' => No,
        '\u{FF5D}' => No,
        '\u{FF5E}' => No,
        '\u{FF5F}' => No,
        '\u{FF60}' => No,
        '\u{FF61}' => No,
        '\u{FF62}' => No,
        '\u{FF63}' => No,
        '\u{FF64}'..='\u{FF65}' => No,
        '\u{FF66}'..='\u{FF6F}' => No,
        '\u{FF70}' => No,
        '\u{FF71}'..='\u{FF9D}' => No,
        '\u{FF9E}'..='\u{FF9F}' => No,
        '\u{FFA0}'..='\u{FFBE}' => No,
        '\u{FFC2}'..='\u{FFC7}' => No,
        '\u{FFCA}'..='\u{FFCF}' => No,
        '\u{FFD2}'..='\u{FFD7}' => No,
        '\u{FFDA}'..='\u{FFDC}' => No,
        '\u{FFE0}'..='\u{FFE1}' => No,
        '\u{FFE2}' => No,
        '\u{FFE3}' => No,
        '\u{FFE4}' => No,
        '\u{FFE5}'..='\u{FFE6}' => No,
        '\u{FFE8}' => No,
        '\u{FFE9}'..='\u{FFEC}' => No,
        '\u{FFED}'..='\u{FFEE}' => No,
        '\u{105C9}' => No,
        '\u{105E4}' => No,
        '\u{10781}'..='\u{10785}' => No,
        '\u{10787}'..='\u{107B0}' => No,
        '\u{107B2}'..='\u{107BA}' => No,
        '\u{1109A}' => No,
        '\u{1109C}' => No,
        '\u{110AB}' => No,
        '\u{1112E}'..='\u{1112F}' => No,
        '\u{1134B}'..='\u{1134C}' => No,
        '\u{11383}' => No,
        '\u{11385}' => No,
        '\u{1138E}' => No,
        '\u{11391}' => No,
        '\u{113C5}' => No,
        '\u{113C7}'..='\u{113C8}' => No,
        '\u{114BB}'..='\u{114BC}' => No,
        '\u{114BE}' => No,
        '\u{115BA}'..='\u{115BB}' => No,
        '\u{11938}' => No,
        '\u{16121}'..='\u{16128}' => No,
        '\u{16D68}'..='\u{16D6A}' => No,
        '\u{1CCD6}'..='\u{1CCEF}' => No,
        '\u{1CCF0}'..='\u{1CCF9}' => No,
        '\u{1D15E}'..='\u{1D164}' => No,
        '\u{1D1BB}'..='\u{1D1C0}' => No,
        '\u{1D400}'..='\u{1D454}' => No,
        '\u{1D456}'..='\u{1D49C}' => No,
        '\u{1D49E}'..='\u{1D49F}' => No,
        '\u{1D4A2}' => No,
        '\u{1D4A5}'..='\u{1D4A6}' => No,
        '\u{1D4A9}'..='\u{1D4AC}' => No,
        '\u{1D4AE}'..='\u{1D4B9}' => No,
        '\u{1D4BB}' => No,
        '\u{1D4BD}'..='\u{1D4C3}' => No,
        '\u{1D4C5}'..='\u{1D505}' => No,
        '\u{1D507}'..='\u{1D50A}' => No,
        '\u{1D50D}'..='\u{1D514}' => No,
        '\u{1D516}'..='\u{1D51C}' => No,
        '\u{1D51E}'..='\u{1D539}' => No,
        '\u{1D53B}'..='\u{1D53E}' => No,
        '\u{1D540}'..='\u{1D544}' => No,
        '\u{1D546}' => No,
        '\u{1D54A}'..='\u{1D550}' => No,
        '\u{1D552}'..='\u{1D6A5}' => No,
        '\u{1D6A8}'..='\u{1D6C0}' => No,
        '\u{1D6C1}' => No,
        '\u{1D6C2}'..='\u{1D6DA}' => No,
        '\u{1D6DB}' => No,
        '\u{1D6DC}'..='\u{1D6FA}' => No,
        '\u{1D6FB}' => No,
        '\u{1D6FC}'..='\u{1D714}' => No,
        '\u{1D715}' => No,
        '\u{1D716}'..='\u{1D734}' => No,
        '\u{1D735}' => No,
        '\u{1D736}'..='\u{1D74E}' => No,
        '\u{1D74F}' => No,
        '\u{1D750}'..='\u{1D76E}' => No,
        '\u{1D76F}' => No,
        '\u{1D770}'..='\u{1D788}' => No,
        '\u{1D789}' => No,
        '\u{1D78A}'..='\u{1D7A8}' => No,
        '\u{1D7A9}' => No,
        '\u{1D7AA}'..='\u{1D7C2}' => No,
        '\u{1D7C3}' => No,
        '\u{1D7C4}'..='\u{1D7CB}' => No,
        '\u{1D7CE}'..='\u{1D7FF}' => No,
        '\u{1E030}'..='\u{1E06D}' => No,
        '\u{1EE00}'..='\u{1EE03}' => No,
        '\u{1EE05}'..='\u{1EE1F}' => No,
        '\u{1EE21}'..='\u{1EE22}' => No,
        '\u{1EE24}' => No,
        '\u{1EE27}' => No,
        '\u{1EE29}'..='\u{1EE32}' => No,
        '\u{1EE34}'..='\u{1EE37}' => No,
        '\u{1EE39}' => No,
        '\u{1EE3B}' => No,
        '\u{1EE42}' => No,
        '\u{1EE47}' => No,
        '\u{1EE49}' => No,
        '\u{1EE4B}' => No,
        '\u{1EE4D}'..='\u{1EE4F}' => No,
        '\u{1EE51}'..='\u{1EE52}' => No,
        '\u{1EE54}' => No,
        '\u{1EE57}' => No,
        '\u{1EE59}' => No,
        '\u{1EE5B}' => No,
        '\u{1EE5D}' => No,
        '\u{1EE5F}' => No,
        '\u{1EE61}'..='\u{1EE62}' => No,
        '\u{1EE64}' => No,
        '\u{1EE67}'..='\u{1EE6A}' => No,
        '\u{1EE6C}'..='\u{1EE72}' => No,
        '\u{1EE74}'..='\u{1EE77}' => No,
        '\u{1EE79}'..='\u{1EE7C}' => No,
        '\u{1EE7E}' => No,
        '\u{1EE80}'..='\u{1EE89}' => No,
        '\u{1EE8B}'..='\u{1EE9B}' => No,
        '\u{1EEA1}'..='\u{1EEA3}' => No,
        '\u{1EEA5}'..='\u{1EEA9}' => No,
        '\u{1EEAB}'..='\u{1EEBB}' => No,
        '\u{1F100}'..='\u{1F10A}' => No,
        '\u{1F110}'..='\u{1F12E}' => No,
        '\u{1F130}'..='\u{1F14F}' => No,
        '\u{1F16A}'..='\u{1F16C}' => No,
        '\u{1F190}' => No,
        '\u{1F200}'..='\u{1F202}' => No,
        '\u{1F210}'..='\u{1F23B}' => No,
        '\u{1F240}'..='\u{1F248}' => No,
        '\u{1F250}'..='\u{1F251}' => No,
        '\u{1FBF0}'..='\u{1FBF9}' => No,
        '\u{2F800}'..='\u{2FA1D}' => No,
        _ => Yes,
    }
}
#[inline]
pub fn stream_safe_leading_nonstarters(c: char) -> usize {
    match c {
        '\u{0340}' => 1,
        '\u{0341}' => 1,
        '\u{0343}' => 1,
        '\u{0344}' => 2,
        '\u{0F73}' => 2,
        '\u{0F75}' => 2,
        '\u{0F81}' => 2,
        '\u{FF9E}' => 1,
        '\u{FF9F}' => 1,
        _ => 0,
    }
}

pub(crate) const TRAILING_NONSTARTERS_SALT: &[u16] = &[
    0x4B0, 0x000, 0x012, 0x151, 0x000, 0x051, 0x000, 0x166, 0x00E, 0x000, 0x000, 0x00A, 0x004,
    0x008, 0x000, 0x012, 0x002, 0x000, 0x002, 0x000, 0x00E, 0x000, 0x000, 0x127, 0x000, 0x000,
    0x000, 0x004, 0x18C, 0x019, 0x000, 0x000, 0x001, 0x005, 0x000, 0x06A, 0x001, 0x0C5, 0x010,
    0x000, 0x000, 0x002, 0x003, 0x011, 0x002, 0x000, 0x000, 0x003, 0x008, 0x026, 0x104, 0x0BC,
    0x033, 0x043, 0x033, 0x00E, 0x000, 0x000, 0x02D, 0x020, 0x000, 0x00D, 0x002, 0x000, 0x027,
    0x000, 0x023, 0x038, 0x008, 0x00D, 0x060, 0x026, 0x000, 0x01B, 0x000, 0x000, 0x05A, 0x002,
    0x000, 0x007, 0x048, 0x00F, 0x003, 0x001, 0x00F, 0x04A, 0x002, 0x003, 0x000, 0x003, 0x004,
    0x002, 0x037, 0x00C, 0x001, 0x044, 0x000, 0x000, 0x006, 0x012, 0x000, 0x001, 0x001, 0x000,
    0x035, 0x00C, 0x00B, 0x000, 0x000, 0x001, 0x000, 0x000, 0x000, 0x00B, 0x000, 0x005, 0x00F,
    0x000, 0x000, 0x00F, 0x012, 0x000, 0x00B, 0x009, 0x001, 0x001, 0x016, 0x000, 0x000, 0x000,
    0x003, 0x02C, 0x007, 0x00C, 0x002, 0x001, 0x003, 0x002, 0x008, 0x00C, 0x002, 0x01B, 0x004,
    0x002, 0x002, 0x001, 0x005, 0x001, 0x000, 0x000, 0x015, 0x000, 0x000, 0x00D, 0x008, 0x000,
    0x000, 0x005, 0x026, 0x008, 0x000, 0x000, 0x000, 0x000, 0x013, 0x001, 0x001, 0x000, 0x032,
    0x000, 0x003, 0x00B, 0x006, 0x002, 0x000, 0x000, 0x000, 0x002, 0x003, 0x001, 0x002, 0x000,
    0x033, 0x000, 0x002, 0x004, 0x01D, 0x000, 0x001, 0x003, 0x000, 0x000, 0x000, 0x030, 0x00C,
    0x006, 0x000, 0x000, 0x000, 0x001, 0x000, 0x001, 0x001, 0x005, 0x000, 0x002, 0x001, 0x002,
    0x003, 0x00D, 0x008, 0x000, 0x003, 0x001, 0x000, 0x002, 0x000, 0x000, 0x000, 0x001, 0x008,
    0x000, 0x007, 0x000, 0x000, 0x000, 0x00A, 0x000, 0x003, 0x000, 0x019, 0x000, 0x006, 0x007,
    0x007, 0x005, 0x001, 0x001, 0x001, 0x001, 0x000, 0x004, 0x003, 0x006, 0x00A, 0x000, 0x000,
    0x000, 0x000, 0x001, 0x001, 0x000, 0x003, 0x000, 0x000, 0x002, 0x000, 0x000, 0x000, 0x003,
    0x00A, 0x012, 0x000, 0x000, 0x001, 0x000, 0x009, 0x002, 0x003, 0x001, 0x007, 0x000, 0x000,
    0x005, 0x005, 0x000, 0x002, 0x00C, 0x008, 0x016, 0x003, 0x000, 0x000, 0x000, 0x000, 0x007,
    0x009, 0x001, 0x000, 0x000, 0x00A, 0x000, 0x002, 0x000, 0x014, 0x000, 0x002, 0x001, 0x007,
    0x000, 0x004, 0x000, 0x000, 0x000, 0x004, 0x010, 0x002, 0x001, 0x00A, 0x00C, 0x004, 0x000,
    0x003, 0x000, 0x001, 0x00B, 0x000, 0x005, 0x001, 0x00B, 0x000, 0x005, 0x007, 0x005, 0x000,
    0x002, 0x008, 0x002, 0x000, 0x005, 0x006, 0x000, 0x000, 0x000, 0x001, 0x000, 0x006, 0x00C,
    0x021, 0x005, 0x004, 0x000, 0x003, 0x000, 0x000, 0x006, 0x003, 0x000, 0x00B, 0x000, 0x002,
    0x001, 0x000, 0x002, 0x000, 0x000, 0x007, 0x000, 0x001, 0x000, 0x006, 0x000, 0x000, 0x000,
    0x002, 0x004, 0x013, 0x000, 0x013, 0x001, 0x000, 0x007, 0x002, 0x005, 0x000, 0x000, 0x00A,
    0x001, 0x010, 0x009, 0x000, 0x001, 0x003, 0x001, 0x000, 0x000, 0x000, 0x001, 0x000, 0x00C,
    0x001, 0x003, 0x000, 0x009, 0x00E, 0x003, 0x006, 0x001, 0x003, 0x003, 0x000, 0x002, 0x003,
    0x004, 0x000, 0x00C, 0x002, 0x004, 0x010, 0x002, 0x005, 0x001, 0x000, 0x000, 0x004, 0x000,
    0x006, 0x000, 0x000, 0x006, 0x000, 0x000, 0x00C, 0x000, 0x002, 0x000, 0x000, 0x003, 0x000,
    0x004, 0x002, 0x003, 0x001, 0x001, 0x000, 0x001, 0x000, 0x002, 0x001, 0x001, 0x001, 0x000,
    0x001, 0x000, 0x000, 0x003, 0x000, 0x000, 0x004, 0x004, 0x003, 0x000, 0x003, 0x000, 0x000,
    0x010, 0x000, 0x000, 0x001, 0x006, 0x001, 0x003, 0x000, 0x004, 0x001, 0x000, 0x00F, 0x002,
    0x007, 0x001, 0x000, 0x000, 0x006, 0x003, 0x002, 0x000, 0x014, 0x002, 0x02B, 0x000, 0x000,
    0x00E, 0x000, 0x003, 0x000, 0x000, 0x00C, 0x000, 0x006, 0x004, 0x010, 0x007, 0x002, 0x006,
    0x00D, 0x000, 0x003, 0x001, 0x00C, 0x004, 0x001, 0x000, 0x005, 0x002, 0x000, 0x001, 0x00B,
    0x001, 0x001, 0x000, 0x001, 0x000, 0x000, 0x012, 0x000, 0x000, 0x007, 0x000, 0x000, 0x001,
    0x000, 0x004, 0x005, 0x004, 0x000, 0x001, 0x000, 0x002, 0x00C, 0x005, 0x00C, 0x001, 0x007,
    0x001, 0x003, 0x000, 0x005, 0x004, 0x001, 0x000, 0x000, 0x004, 0x000, 0x001, 0x005, 0x004,
    0x001, 0x000, 0x00A, 0x002, 0x001, 0x001, 0x000, 0x001, 0x001, 0x007, 0x000, 0x004, 0x001,
    0x006, 0x005, 0x003, 0x002, 0x001, 0x001, 0x003, 0x000, 0x004, 0x000, 0x005, 0x004, 0x000,
    0x006, 0x002, 0x000, 0x000, 0x007, 0x004, 0x002, 0x000, 0x000, 0x008, 0x000, 0x003, 0x002,
    0x007, 0x002, 0x003, 0x000, 0x000, 0x000, 0x002, 0x003, 0x003, 0x001, 0x000, 0x000, 0x004,
    0x002, 0x003, 0x002, 0x000, 0x000, 0x005, 0x000, 0x001, 0x000, 0x001, 0x000, 0x006, 0x002,
    0x001, 0x003, 0x001, 0x001, 0x000, 0x007, 0x001, 0x000, 0x005, 0x000, 0x001, 0x002, 0x000,
    0x004, 0x000, 0x001, 0x000, 0x004, 0x002, 0x003, 0x002, 0x001, 0x001, 0x003, 0x000, 0x000,
    0x000, 0x003, 0x000, 0x007, 0x002, 0x000, 0x008, 0x004, 0x001, 0x000, 0x001, 0x003, 0x000,
    0x000, 0x00A, 0x000, 0x000, 0x01D, 0x002, 0x000, 0x000, 0x011, 0x000, 0x001, 0x001, 0x003,
    0x000, 0x007, 0x001, 0x000, 0x001, 0x000, 0x002, 0x00B, 0x000, 0x002, 0x003, 0x003, 0x004,
    0x00D, 0x000, 0x001, 0x00A, 0x000, 0x002, 0x008, 0x001, 0x005, 0x001, 0x005, 0x001, 0x000,
    0x003, 0x005, 0x000, 0x002, 0x000, 0x000, 0x000, 0x003, 0x003, 0x001, 0x001, 0x000, 0x000,
    0x000, 0x000, 0x001, 0x000, 0x000, 0x001, 0x000, 0x000, 0x011, 0x001, 0x000, 0x003, 0x001,
    0x002, 0x004, 0x000, 0x004, 0x000, 0x000, 0x00A, 0x000, 0x001, 0x000, 0x001, 0x001, 0x002,
    0x001, 0x000, 0x00C, 0x000, 0x000, 0x001, 0x000, 0x000, 0x002, 0x004, 0x000, 0x000, 0x000,
    0x000, 0x003, 0x005, 0x001, 0x004, 0x000, 0x002, 0x005, 0x001, 0x003, 0x005, 0x001, 0x001,
    0x001, 0x00F, 0x000, 0x000, 0x001, 0x000, 0x001, 0x001, 0x002, 0x003, 0x003, 0x000, 0x005,
    0x003, 0x000, 0x000, 0x000, 0x00A, 0x000, 0x002, 0x003, 0x000, 0x001, 0x006, 0x000, 0x004,
    0x004, 0x000, 0x001, 0x002, 0x000, 0x003, 0x001, 0x000, 0x001, 0x003, 0x003, 0x003, 0x002,
    0x001, 0x007, 0x002, 0x002, 0x003, 0x000, 0x003, 0x001, 0x000, 0x000, 0x001, 0x000, 0x000,
    0x000, 0x000, 0x000, 0x006, 0x000, 0x001, 0x005, 0x002, 0x003, 0x003, 0x008, 0x000, 0x000,
    0x000, 0x002, 0x004, 0x001, 0x000, 0x003, 0x002, 0x006, 0x000, 0x00B, 0x002, 0x001, 0x000,
    0x001, 0x000, 0x001, 0x008, 0x004, 0x006, 0x001, 0x000, 0x000, 0x002, 0x009, 0x001, 0x005,
    0x003, 0x002, 0x000, 0x001, 0x001, 0x009, 0x001, 0x007, 0x001, 0x000, 0x001, 0x000, 0x001,
    0x000, 0x002, 0x007, 0x001, 0x002, 0x002, 0x003, 0x001, 0x000, 0x00A, 0x004, 0x000, 0x001,
    0x002, 0x001, 0x005, 0x000, 0x00B, 0x001, 0x000, 0x001, 0x002, 0x000, 0x001, 0x007, 0x000,
    0x001, 0x001, 0x001, 0x005, 0x003, 0x001, 0x000, 0x000, 0x001, 0x000, 0x001, 0x000, 0x000,
    0x000, 0x000, 0x003, 0x003, 0x000, 0x000, 0x001, 0x007, 0x001, 0x004, 0x001, 0x002, 0x001,
    0x000, 0x008, 0x000, 0x003, 0x000, 0x003, 0x004, 0x006, 0x002, 0x001, 0x000, 0x000, 0x000,
    0x001, 0x003, 0x003, 0x003, 0x005, 0x000, 0x002, 0x003, 0x003, 0x003, 0x001, 0x003, 0x003,
    0x001, 0x002, 0x000, 0x002, 0x000, 0x000, 0x000, 0x001, 0x001, 0x000, 0x001, 0x006, 0x002,
    0x001, 0x000, 0x000, 0x003, 0x001, 0x002, 0x008, 0x001, 0x002, 0x000, 0x000, 0x000, 0x002,
    0x000, 0x001, 0x001, 0x001, 0x001, 0x000, 0x002, 0x002, 0x003, 0x003, 0x003, 0x000, 0x003,
    0x001, 0x001, 0x006, 0x000, 0x000, 0x002, 0x002, 0x001, 0x001, 0x001, 0x005, 0x000, 0x003,
    0x002, 0x000, 0x004, 0x008, 0x000, 0x000, 0x001, 0x002, 0x000, 0x000, 0x004, 0x001, 0x002,
    0x000, 0x000, 0x001, 0x000, 0x001, 0x001, 0x001, 0x001, 0x000, 0x002, 0x001, 0x000, 0x001,
    0x000, 0x000, 0x001, 0x000, 0x004, 0x002, 0x000, 0x000, 0x002, 0x001, 0x003, 0x000, 0x000,
    0x000, 0x001, 0x003, 0x003, 0x000, 0x003, 0x004, 0x002, 0x002, 0x000, 0x000, 0x001, 0x001,
    0x000, 0x006, 0x000, 0x002, 0x000, 0x00C, 0x001, 0x001, 0x002, 0x001, 0x000, 0x002, 0x001,
    0x001, 0x000, 0x000, 0x002, 0x000, 0x000, 0x000, 0x000, 0x000, 0x001, 0x000, 0x000, 0x005,
    0x001, 0x000, 0x005, 0x000, 0x000, 0x003, 0x001, 0x000, 0x000, 0x001, 0x000, 0x000, 0x005,
    0x001, 0x001, 0x000, 0x001, 0x001, 0x007, 0x003, 0x002, 0x004, 0x000, 0x003, 0x002, 0x001,
];
pub(crate) const TRAILING_NONSTARTERS_KV: &[u32] = &[
    0x030D401, 0x01F2E02, 0x01F1D02, 0x0227801, 0x0224901, 0x000E101, 0x01FFE01, 0x001A001,
    0x01F0A02, 0x0022901, 0x0307401, 0x01F6C02, 0x01E7601, 0x030B001, 0x004D001, 0x0FB3801,
    0x01EA902, 0x0FEF901, 0x0038F01, 0x01F3101, 0x0011701, 0x0034301, 0x0226201, 0x01FF801,
    0x00F7302, 0x0FE8B01, 0x0307601, 0x003AE01, 0x01FC202, 0x0FC6002, 0x0224101, 0x0012B01,
    0x01F0402, 0x0220401, 0x003B002, 0x01F9A03, 0x01EB702, 0x01E9301, 0x00A5B01, 0x01F5602,
    0x0021B01, 0x1D1C002, 0x1D16102, 0x0016E01, 0x01FD202, 0x01EEF02, 0x030AC01, 0x01F3502,
    0x01FE101, 0x01E6802, 0x004E701, 0x0010801, 0x0309E01, 0x01F3302, 0x01EC901, 0x001FA02,
    0x01E7B02, 0x01EDE02, 0x01FE702, 0x01FD001, 0x01E2E02, 0x01EBF02, 0x0034101, 0x0227001,
    0x01FBF01, 0x001C401, 0x01F9403, 0x01FAB03, 0x01E5102, 0x01F0101, 0x001AF01, 0x0045101,
    0x004F001, 0x0038E01, 0x0016401, 0x01F4801, 0x004EA01, 0x01EBB01, 0x01EAF02, 0x0FB4801,
    0x01E2201, 0x01EEA02, 0x01F7A01, 0x0FB4A01, 0x000E701, 0x01E1B01, 0x0011D01, 0x0FB3601,
    0x0017901, 0x0012201, 0x0FB3B01, 0x01E5D02, 0x0012A01, 0x0FC5F02, 0x01EF102, 0x003D301,
    0x0227401, 0x01FA802, 0x01FC301, 0x0FEF501, 0x0047601, 0x0022D02, 0x004DC01, 0x001FB02,
    0x0014D01, 0x030DA01, 0x0020A01, 0x01FFC01, 0x0016201, 0x01FC901, 0x0FC5C01, 0x01FB202,
    0x030BA01, 0x01F2702, 0x000CB01, 0x01FEA01, 0x003CA01, 0x0021601, 0x0015601, 0x003AC01,
    0x004D301, 0x0045D01, 0x01E4801, 0x01EAD02, 0x030D701, 0x022E301, 0x01F9303, 0x001DA02,
    0x01FC702, 0x0017501, 0x030BC01, 0x01E6602, 0x0010D01, 0x01FB402, 0x030FE01, 0x0FC6102,
    0x01FE801, 0x01FFB01, 0x000FC01, 0x01EE401, 0x000C301, 0x01E3701, 0x000EB01, 0x001D301,
    0x000CD01, 0x0FB1F01, 0x01E0802, 0x0FE8C01, 0x0FB4701, 0x01EE002, 0x01E6402, 0x01E9801,
    0x0FB4101, 0x01ECE01, 0x0011201, 0x01EF301, 0x001D001, 0x0307101, 0x01E3C01, 0x01FC001,
    0x0FCD901, 0x01E8401, 0x01E8201, 0x0FB3301, 0x01F8703, 0x01E6C01, 0x0FB4001, 0x01F6901,
    0x01E7701, 0x01FBB01, 0x0FE7D01, 0x01E8D01, 0x0220901, 0x01E5C02, 0x0011301, 0x01E1E01,
    0x009DC01, 0x01F1A02, 0x01FCD02, 0x0FCF202, 0x0309C01, 0x01E4D02, 0x030C701, 0x01FCE02,
    0x01E8101, 0x000E301, 0x01E5601, 0x0FB1D01, 0x00F8102, 0x01E8701, 0x01E6201, 0x0040101,
    0x01F2202, 0x0062601, 0x0015B01, 0x01F3901, 0x01FB901, 0x0020B01, 0x0014C01, 0x01F9203,
    0x01E0902, 0x01E3F01, 0x01F7901, 0x01F2F02, 0x0226E01, 0x01F3B02, 0x030D101, 0x004EF01,
    0x000B801, 0x0227901, 0x01E6001, 0x000D601, 0x0017B01, 0x01E6A01, 0x0015101, 0x01F4B02,
    0x0010001, 0x022ED01, 0x030D601, 0x01FCB01, 0x01E3902, 0x0040701, 0x004ED01, 0x01ED202,
    0x01EE202, 0x0304E01, 0x0FB3901, 0x0305A01, 0x01ECF01, 0x0011601, 0x01E2001, 0x0017601,
    0x0FB3401, 0x0093101, 0x004EE01, 0x0330401, 0x0012301, 0x01FE302, 0x0020F01, 0x01FA403,
    0x01F8F03, 0x00F7702, 0x01F5502, 0x001EF01, 0x000EA01, 0x01FAF03, 0x000FA01, 0x0022F01,
    0x01E2901, 0x004E201, 0x004C201, 0x004EC01, 0x0039002, 0x01FB702, 0x0FC5E02, 0x0012401,
    0x01F3A02, 0x0FB2C02, 0x01F9102, 0x0228401, 0x01EC102, 0x000F901, 0x000E801, 0x01EA101,
    0x004E401, 0x0021A01, 0x0FB4901, 0x0017A01, 0x0010F01, 0x01FB601, 0x001FF01, 0x001E201,
    0x004D701, 0x01F5302, 0x01EB801, 0x01FAA03, 0x0FCF402, 0x01F0901, 0x0017801, 0x0305401,
    0x01F6202, 0x01F6E02, 0x000A801, 0x01EAB02, 0x0016B01, 0x01EA201, 0x01F9D03, 0x01F2101,
    0x00F7601, 0x01FCC01, 0x01E3A01, 0x0013C01, 0x01E5A01, 0x001EC02, 0x0021401, 0x01EEE02,
    0x01F8503, 0x0307901, 0x0015E01, 0x0FE8401, 0x01E7501, 0x0306501, 0x0013B01, 0x0305801,
    0x01E8901, 0x0FC6202, 0x01E9201, 0x0011A01, 0x105E401, 0x0222601, 0x0010401, 0x01F2602,
    0x0227501, 0x0095901, 0x01F7301, 0x0014E01, 0x01EF701, 0x0043901, 0x01E2501, 0x0FB4C01,
    0x1109A01, 0x01F6101, 0x01E4101, 0x0010E01, 0x01FED02, 0x01EA402, 0x0021F01, 0x004D201,
    0x01F0302, 0x003D401, 0x0307701, 0x01FB101, 0x01E1101, 0x01F1402, 0x0014401, 0x0332101,
    0x0010C01, 0x01F4402, 0x0038502, 0x0305C01, 0x01E4301, 0x001DE02, 0x01F3702, 0x01EC502,
    0x004DE01, 0x0306001, 0x01FE601, 0x01EC002, 0x001ED02, 0x0015401, 0x000E001, 0x01F9C03,
    0x0021701, 0x1D15F01, 0x01E1602, 0x01ED902, 0x0FB2D02, 0x0FB3E01, 0x0020101, 0x01E4F02,
    0x01E4001, 0x0015501, 0x004E501, 0x01FA303, 0x01EE501, 0x0020701, 0x0FC6302, 0x01E9601,
    0x01FCF02, 0x0228001, 0x001A101, 0x0017301, 0x0022E01, 0x01F0F02, 0x01F9F03, 0x001D602,
    0x0FB3201, 0x1D1BD02, 0x00F7902, 0x003AB01, 0x01EC202, 0x01F0B02, 0x000E401, 0x0016A01,
    0x01F7001, 0x030D301, 0x01FA203, 0x0FF9E01, 0x01EE802, 0x01FF202, 0x01F6A02, 0x01E4E02,
    0x01E0E01, 0x01E2701, 0x0201701, 0x030DD01, 0x00C4801, 0x01EAC02, 0x01E9B01, 0x01EF801,
    0x021CD01, 0x00B5C01, 0x0305201, 0x0034402, 0x01F5901, 0x030B801, 0x0045301, 0x01E2B01,
    0x0016801, 0x01F9703, 0x01FA902, 0x01EDF02, 0x030F401, 0x0FBB101, 0x01F6302, 0x01E7F01,
    0x01EB002, 0x0017001, 0x01EE902, 0x0224401, 0x000C701, 0x01EEC02, 0x01FEC01, 0x0FE7F01,
    0x0FEF801, 0x01EB402, 0x01EBD01, 0x01F8902, 0x01FA002, 0x01EAE02, 0x0034001, 0x01F1B02,
    0x0010301, 0x0011C01, 0x01E1201, 0x0020E01, 0x0021001, 0x01F4001, 0x0FE8901, 0x01E1C02,
    0x0011E01, 0x00A5901, 0x004DF01, 0x0307C01, 0x0020601, 0x003CB01, 0x0FB3A01, 0x0022B02,
    0x002D901, 0x01F6F02, 0x00DDA01, 0x0015D01, 0x0047701, 0x030F701, 0x0FD3D01, 0x0FE7B01,
    0x000CE01, 0x0023102, 0x0FB3001, 0x110AB01, 0x0228501, 0x0334001, 0x01E5801, 0x004F301,
    0x001F801, 0x01F7101, 0x0017401, 0x001C601, 0x0040301, 0x01E4B01, 0x000D401, 0x01F9802,
    0x004D601, 0x01F1101, 0x030BE01, 0x0FE7901, 0x001E102, 0x000DD01, 0x000F101, 0x01EA001,
    0x002DA01, 0x01F3E02, 0x022AD01, 0x01F8403, 0x0045C01, 0x01EF401, 0x01E3601, 0x006D301,
    0x01E6301, 0x004F401, 0x01E3101, 0x01E8001, 0x01FAD03, 0x01F4302, 0x0011401, 0x0016F01,
    0x01F1202, 0x0013901, 0x01F9E03, 0x00A3301, 0x01EA502, 0x0011801, 0x01F0E02, 0x01E9101,
    0x0203E01, 0x01E5B01, 0x000C401, 0x0021E01, 0x0017C01, 0x0226001, 0x0FEF701, 0x01F8802,
    0x0334E01, 0x01F2502, 0x01FD302, 0x0095D01, 0x0038C01, 0x0012F01, 0x0040001, 0x01E7C01,
    0x0017201, 0x0FB4D01, 0x01E6702, 0x00F7502, 0x01E0201, 0x0045701, 0x000D901, 0x01F0001,
    0x01E1D02, 0x000C501, 0x0FCF302, 0x0333B01, 0x000B401, 0x01FBD01, 0x030C001, 0x004F801,
    0x022AF01, 0x004D101, 0x001F901, 0x01E0C01, 0x0FE7001, 0x000EE01, 0x01EDD02, 0x01E7D01,
    0x01F7801, 0x1D15E01, 0x01EB502, 0x0FB4401, 0x000E901, 0x022E201, 0x001EB01, 0x0015A01,
    0x01F6702, 0x0219B01, 0x002DD01, 0x0017D01, 0x01E2101, 0x0022C02, 0x01E1001, 0x01E5002,
    0x01E0601, 0x01E3001, 0x01F7601, 0x001D802, 0x0095E01, 0x0045001, 0x004F101, 0x01FDD02,
    0x0307301, 0x004EB01, 0x01E8E01, 0x1D1BE02, 0x0020501, 0x000DC01, 0x0FE8601, 0x01F7401,
    0x0FE4901, 0x01FA703, 0x030B201, 0x01E5501, 0x01FF301, 0x01E4901, 0x01E5E01, 0x01EB901,
    0x01E0D01, 0x01F7C01, 0x01F5001, 0x0FBB001, 0x01ED002, 0x0FB3C01, 0x0222401, 0x003AA01,
    0x003AF01, 0x01FB301, 0x01ECA01, 0x01E4C02, 0x0015701, 0x0040C01, 0x01EDA02, 0x01E3401,
    0x01E1301, 0x01F0502, 0x0020C01, 0x01FEE02, 0x01F5B02, 0x004F901, 0x01FD601, 0x0FB2E01,
    0x01E4501, 0x000ED01, 0x0045E01, 0x01FE901, 0x0020001, 0x0012101, 0x01E8F01, 0x0013601,
    0x0020301, 0x1D16302, 0x001E801, 0x001F401, 0x01E8A01, 0x01FC102, 0x01EDB02, 0x01F2D02,
    0x0016301, 0x01F2801, 0x000E201, 0x000C201, 0x01EF901, 0x01FBC01, 0x01FB801, 0x021CF01,
    0x009DF01, 0x01E3D01, 0x01EB602, 0x01F8603, 0x0022A02, 0x0010501, 0x01FC801, 0x0040E01,
    0x0037A01, 0x01F8B03, 0x01F4A02, 0x01F0D02, 0x01ED102, 0x01E8C01, 0x01EB102, 0x01E3B01,
    0x0FC5B01, 0x021CE01, 0x01E3E01, 0x004DD01, 0x01E4401, 0x01F6502, 0x0FEF601, 0x004F201,
    0x030F801, 0x002D801, 0x01EC801, 0x01EE701, 0x000FD01, 0x01ED702, 0x01EBC01, 0x0011501,
    0x01F5F02, 0x0FE7801, 0x01E7802, 0x1D16002, 0x0038901, 0x1D1BB01, 0x0010701, 0x0306901,
    0x0FB4301, 0x0016C01, 0x01EF501, 0x01FB001, 0x01F3801, 0x0228801, 0x01FDE02, 0x0226F01,
    0x0FE8501, 0x0FE7201, 0x003CD01, 0x0021801, 0x0013501, 0x01F8203, 0x0020901, 0x01FD101,
    0x000F201, 0x0021101, 0x0014601, 0x1D16202, 0x01E5F01, 0x004DB01, 0x0015F01, 0x02ADC01,
    0x0095B01, 0x01F6001, 0x01FDB01, 0x0FB4E01, 0x0228901, 0x01E2301, 0x0305601, 0x022AC01,
    0x01E7301, 0x01E7A02, 0x01E7401, 0x01FBA01, 0x001FE01, 0x01EB302, 0x01F2402, 0x0FD3C01,
    0x01E7201, 0x0038401, 0x0012E01, 0x0013701, 0x000EF01, 0x01E0101, 0x021AE01, 0x0333201,
    0x000DA01, 0x001DB02, 0x001F001, 0x01E5202, 0x0307D01, 0x000F301, 0x001EA01, 0x0012D01,
    0x01ED802, 0x01F2001, 0x00B5D01, 0x0021901, 0x01E1502, 0x0FE4A01, 0x01FD801, 0x01F1C02,
    0x0020201, 0x000C801, 0x01EEB02, 0x01E2401, 0x004F501, 0x01FAC03, 0x030DC01, 0x022AE01,
    0x030F901, 0x01E2A01, 0x01EF002, 0x01E0701, 0x01F3D02, 0x01FE001, 0x01F7201, 0x01ED402,
    0x001FC01, 0x0012001, 0x01F7701, 0x0304C01, 0x01E4201, 0x0062201, 0x004E301, 0x01FEB01,
    0x01ECD01, 0x01FC402, 0x01E8501, 0x01F5202, 0x01F6D02, 0x01EA301, 0x030C201, 0x0095A01,
    0x01F3202, 0x01F8102, 0x01E2801, 0x006C201, 0x01E9901, 0x0017101, 0x01F2A02, 0x01ED602,
    0x001E601, 0x01F3001, 0x01F3F02, 0x000C001, 0x000DB01, 0x000F601, 0x1D16402, 0x01EBA01,
    0x0015901, 0x0331E01, 0x000C901, 0x030C901, 0x0FC5D01, 0x01F8A03, 0x0020401, 0x01E1901,
    0x01F4D02, 0x01F2C02, 0x01FF901, 0x0013401, 0x01EB202, 0x0015C01, 0x01E6F01, 0x0FE8301,
    0x001D401, 0x001F501, 0x01F8D03, 0x0093401, 0x0041901, 0x0038801, 0x009DD01, 0x01EBE02,
    0x01EC602, 0x01F5702, 0x01E6101, 0x0010A01, 0x002DB01, 0x001C501, 0x001E002, 0x0014701,
    0x0306701, 0x0012C01, 0x022E101, 0x01F4202, 0x004DA01, 0x0023301, 0x01E2601, 0x01F1302,
    0x01F8C03, 0x022EC01, 0x0062501, 0x01F5D02, 0x01E8B01, 0x1F21301, 0x0010101, 0x01ED502,
    0x01FE202, 0x003AD01, 0x000D201, 0x01FF601, 0x001E901, 0x000C101, 0x01F1001, 0x01E9701,
    0x01E0301, 0x030B601, 0x01E1A01, 0x001CE01, 0x001B001, 0x0011F01, 0x0022701, 0x01E3501,
    0x01F0602, 0x001E701, 0x01ED302, 0x01FFD01, 0x01E2D01, 0x0092901, 0x01E8301, 0x0062301,
    0x01E6E01, 0x0306201, 0x0021501, 0x0228101, 0x000CA01, 0x01E5701, 0x01FDA01, 0x01F4502,
    0x0FE8101, 0x01E5302, 0x0022601, 0x000E501, 0x0FE8A01, 0x01E9001, 0x022E001, 0x01F9603,
    0x01EA602, 0x001D902, 0x01F2901, 0x01F5402, 0x0FB2B01, 0x01FD702, 0x001D502, 0x0FF9F01,
    0x0FE7101, 0x001E301, 0x000CF01, 0x01FCA01, 0x01F8E03, 0x01E4701, 0x000AF01, 0x0FE7E01,
    0x0FE7401, 0x0FB2A01, 0x01F7501, 0x0334B01, 0x001D201, 0x022EA01, 0x001CF01, 0x01E6502,
    0x002DC01, 0x01F3C02, 0x0307A01, 0x001DF02, 0x001EE01, 0x0305001, 0x01E7902, 0x00DDD01,
    0x01EA802, 0x0021201, 0x01E2F02, 0x0FE4C01, 0x0040D01, 0x01F4101, 0x0023201, 0x01E8801,
    0x01F2302, 0x01EED02, 0x01F0C02, 0x0FB4601, 0x01F6801, 0x0062401, 0x01E2C01, 0x01ECB01,
    0x0FE8701, 0x01E5901, 0x01E0A01, 0x01E1F01, 0x00A5A01, 0x0017701, 0x01E5401, 0x0FB2F01,
    0x01FAE03, 0x00A3601, 0x01ECC01, 0x0FB3501, 0x000D301, 0x01EF601, 0x01F8303, 0x0FEFA01,
    0x0095F01, 0x01FFA01, 0x01E3301, 0x01E1801, 0x0FB4B01, 0x01E7E01, 0x00A5E01, 0x0330701,
    0x01E6D01, 0x030FA01, 0x000EC01, 0x01F0202, 0x0038601, 0x01F5101, 0x01F1901, 0x01F1502,
    0x0016001, 0x01E4601, 0x0038A01, 0x0FC9001, 0x0016901, 0x01F1801, 0x0220C01, 0x01E0B01,
    0x030C501, 0x0020D01, 0x01F9B03, 0x0021301, 0x0010601, 0x0FE7A01, 0x00F7801, 0x0013A01,
    0x01E6B01, 0x01FE501, 0x0012801, 0x001FD01, 0x01E6902, 0x0FE8201, 0x01F4901, 0x01E3201,
    0x01E0001, 0x1109C01, 0x01F7B01, 0x0FE8801, 0x0FE4B01, 0x0010B01, 0x000D501, 0x01F6402,
    0x001CD01, 0x01E1702, 0x01FA503, 0x01FD901, 0x01EC402, 0x004E601, 0x0014801, 0x001D101,
    0x01F9902, 0x01F6B02, 0x01F8002, 0x0FBA501, 0x01EC702, 0x01F6602, 0x0015001, 0x0212B01,
    0x0013E01, 0x01EDC02, 0x01EA702, 0x0023002, 0x004C101, 0x0016D01, 0x01F0702, 0x01F2B02,
    0x0012501, 0x01F4C02, 0x030D001, 0x0305E01, 0x0010201, 0x006C001, 0x0309401, 0x0012901,
    0x0016101, 0x0224701, 0x0011901, 0x0FFE301, 0x01E0501, 0x105C901, 0x1D1BC01, 0x0307001,
    0x0017E01, 0x01FA603, 0x01FA102, 0x01E9401, 0x0309B01, 0x0022801, 0x01E0F01, 0x0016501,
    0x01EC302, 0x0020801, 0x000CC01, 0x01F9002, 0x003CC01, 0x01FC601, 0x01EE302, 0x01E4A01,
    0x003CE01, 0x0095C01, 0x01FF702, 0x001D702, 0x0227101, 0x01EE102, 0x01E7101, 0x000FB01,
    0x0095801, 0x01EAA02, 0x000F501, 0x1D1BF02, 0x0011B01, 0x01F7D01, 0x022EB01, 0x0013D01,
    0x01F0801, 0x0014F01, 0x01F3602, 0x0FB3101, 0x01FE401, 0x01F9503, 0x0014301, 0x0015801,
    0x01EE601, 0x0FE7C01, 0x01FDF02, 0x01E0401, 0x01E7001, 0x0331001, 0x000F401, 0x0FE7701,
    0x01E1402, 0x0FE7601, 0x01E3802, 0x030B401, 0x01F3402, 0x0226D01, 0x000FF01, 0x01E8601,
    0x0014501, 0x0013001, 0x030D901, 0x001DC02, 0x01EF201, 0x0FBA401, 0x01FF402, 0x01E9501,
    0x030AE01, 0x0010901, 0x0219A01, 0x000D101,
];
