# 2022-12-06 Triage Log

A mixed bag of a week. 2 of the 3 regressions are connected to changes to the
query system that underlies incremental compilation. The third regression is
still being investigated. For all three, the impact on cycle counts that are
within our noise tolerance levels There were several small-ish improvements,
though PR #104963 is worth calling out: a well-factored change to
how we lower the AST into HIR that had a broad positive impact. One final
note: the summary-opt max-rss seems to gone up by 1.5% over the past month
([perf](https://perf.rust-lang.org/?start=2022-11-06&end=2022-12-06&kind=percentfromfirst&stat=max-rss)),
via a gradual climb; just something to keep our eyes on going forward.


Triage done by **@pnkfelix**.
Revision range: [8a09420a..9db224fc](https://perf.rust-lang.org/?start=8a09420ac48658cad726e0a6997687ceac4151e3&end=9db224fc908059986c179fc6ec433944e9cfce50&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6%  | [0.2%, 1.5%]   | 52    |
| Regressions ❌ <br /> (secondary)  | 1.2%  | [0.2%, 5.6%]   | 80    |
| Improvements ✅ <br /> (primary)   | -0.8% | [-1.7%, -0.2%] | 34    |
| Improvements ✅ <br /> (secondary) | -2.2% | [-4.8%, -0.2%] | 29    |
| All ❌✅ (primary)                 | 0.0%  | [-1.7%, 1.5%]  | 86    |


3 Regressions, 7 Improvements, 4 Mixed; 3 of them in rollups
50 artifact comparisons made in total

#### Regressions

Allow to feed a value in another query's cache [#104940](https://github.com/rust-lang/rust/pull/104940) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=90711a86e5bdd4b0b65d293f0c2c48fd2db761b3&end=c97b539e408ea353f4fde2f9251d598291fec421&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.2%, 0.4%] | 44    |
| Regressions ❌ <br /> (secondary)  | 0.3% | [0.2%, 0.4%] | 12    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.2%, 0.4%] | 44    |

* Many primary benchmarks regressed, but the regression is contained solely to incremental builds, and the magnitude is also well-contained.
* [oli-obk investigated](https://github.com/rust-lang/rust/pull/104940#issuecomment-1333435955) and determined that
  the bulk of the regression is time spent in try_mark_previous_green and incremental_verify_ich calls.
* The impact on cycle-counts (rather than instruction counts) was well within noise tolerance levels.
* Therefore, marked as triaged.

Reduce macro usage for lints [#104863](https://github.com/rust-lang/rust/pull/104863) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=cef44f53034eac46be3a0e3eec7b2b3d4ef5140b&end=e960b5e7749e95c6a6b2fdec7250a48105664efb&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5% | [0.2%, 1.4%] | 116   |
| Regressions ❌ <br /> (secondary)  | 0.9% | [0.1%, 2.3%] | 83    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.5% | [0.2%, 1.4%] | 116   |

* [nnethercote is investigating](https://github.com/rust-lang/rust/pull/104863#issuecomment-1335853746)
* they have already put up [PR 105291](https://github.com/rust-lang/rust/pull/105291) which fixed a few cases but the bulk remain
* they have also [posted a separate idea](https://github.com/rust-lang/rust/pull/104863#issuecomment-1338224753), to avoid calling empty `check_*` methods.
* not marking as triaged yet

feed resolver_for_lowering instead of storing it in a field [#105220](https://github.com/rust-lang/rust/pull/105220) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=226202d9026b0f24b4f7aad4de398bd8378774cd&end=ed61c139c2bc778ebb91f5dd6a5393aa20467f78&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.3%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.1%, 0.8%]   | 15    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.3%] | 1     |
| All ❌✅ (primary)                 | 0.2%  | [0.2%, 0.3%]   | 2     |


* the original timer run said [this had no problem](https://github.com/rust-lang/rust/pull/105220#issuecomment-1336312355)
* (though to be fair, I don't know what changes occurred to the commit series between that timer run and what landed)
* oli-obj investigated and found [cachegrind shows this to be artifacts from inlining decisions](https://github.com/rust-lang/rust/pull/105220#issuecomment-1338942653)
* The impact on cycle-counts (rather than instruction counts) was well within noise tolerance levels.
* Therefore, marked as triaged.

#### Improvements

Also cache the stable hash of interned Predicates [#94487](https://github.com/rust-lang/rust/pull/94487) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e0098a5cc3a87d857e597af824d0ce1ed1ad85e0&end=bddad597feb997a4e5d2cd174a76c3b07a84e4d6&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.6%, -0.2%] | 12    |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.4% | [-0.6%, -0.2%] | 12    |


Some initial normalization method changes [#104905](https://github.com/rust-lang/rust/pull/104905) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a569a88f5500e8780c7cc65fa53fc8b098517674&end=24606deaf48e56f604a6125fa11fb9f70cf4f1f4&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.9% | [-1.0%, -0.8%] | 2     |
| Improvements ✅ <br /> (secondary) | -2.2% | [-2.8%, -0.3%] | 7     |
| All ❌✅ (primary)                 | -0.9% | [-1.0%, -0.8%] | 2     |


Attribute cleanups [#104861](https://github.com/rust-lang/rust/pull/104861) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=744a97b98c3f2722e1a43486c05203b04e499e21&end=d6c4de0fb22fe8f3cc5a27e94b6b6d88fb504a91&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.1%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.7% | [-0.9%, -0.5%] | 6     |
| All ❌✅ (primary)                 | -0.2% | [-0.2%, -0.1%] | 3     |


rustc_ast_lowering: Stop lowering imports into multiple items [#104963](https://github.com/rust-lang/rust/pull/104963) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=56c241c86212d84b9528dca1628bc06e32c742c1&end=11663b1b4857ffeafbd85a9a36c234d117373b76&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.6%, 0.6%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-1.2%, -0.3%] | 54    |
| Improvements ✅ <br /> (secondary) | -4.2% | [-5.4%, -2.0%] | 13    |
| All ❌✅ (primary)                 | -0.5% | [-1.2%, -0.3%] | 54    |

* Wow, I would not have expected this to have this significant of an impact.
* bravo petrochenkov

Ensure query backtraces work for `DefId`s created after ast lowering [#105133](https://github.com/rust-lang/rust/pull/105133) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=24f2704e96c9d3a4f887d2d0a7d79ecffd79bd65&end=703d95e183fbb678249d8f61cabc732e46884e00&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.3%, -0.2%] | 5     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.3%, -0.2%] | 2     |
| All ❌✅ (primary)                 | -0.2% | [-0.3%, -0.2%] | 5     |


Rewrite LLVM's archive writer in Rust  [#97485](https://github.com/rust-lang/rust/pull/97485) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4bb15759d7eb519be70c9a955dba9be09e13c06d&end=cab4fd678c5b148a330f2bf255bf28a67dfea0fc&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.6%, -0.2%] | 12    |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.4% | [-0.6%, -0.2%] | 12    |


Cheaper `dump_mir` take two [#105121](https://github.com/rust-lang/rust/pull/105121) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1195b672fb58364e4ca7022fbbe62a9a7a451b60&end=fd02567705326884ddb94535d2ab230a9595dc2a&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.9%  | [0.9%, 0.9%]   | 1     |
| Improvements ✅ <br /> (primary)   | -1.1% | [-1.9%, -0.6%] | 17    |
| Improvements ✅ <br /> (secondary) | -1.4% | [-1.9%, -0.6%] | 9     |
| All ❌✅ (primary)                 | -1.1% | [-1.9%, -0.6%] | 17    |


#### Mixed

Rollup of 9 pull requests [#105017](https://github.com/rust-lang/rust/pull/105017) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8a09420ac48658cad726e0a6997687ceac4151e3&end=2585bcea0bc2a9c42a4be2c1eba5c61137f2b167&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.9%  | [0.9%, 1.0%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 3.7%  | [2.2%, 5.6%]   | 12    |
| Improvements ✅ <br /> (primary)   | -0.6% | [-0.8%, -0.4%] | 7     |
| Improvements ✅ <br /> (secondary) | -1.1% | [-1.3%, -0.9%] | 4     |
| All ❌✅ (primary)                 | -0.3% | [-0.8%, 1.0%]  | 9     |

* nnethercote already [marked as triaged](https://github.com/rust-lang/rust/pull/105017#issuecomment-1333117104)

Rollup of 14 pull requests [#105070](https://github.com/rust-lang/rust/pull/105070) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=bddad597feb997a4e5d2cd174a76c3b07a84e4d6&end=d38a99078cd3c4dadac1ba8b729ea77e8d1d5a82&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6%  | [0.4%, 0.9%]   | 7     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.2%, 0.4%]   | 7     |
| Improvements ✅ <br /> (primary)   | -0.9% | [-1.0%, -0.8%] | 2     |
| Improvements ✅ <br /> (secondary) | -2.1% | [-2.7%, -1.4%] | 8     |
| All ❌✅ (primary)                 | 0.3%  | [-1.0%, 0.9%]  | 9     |

* lqd [already investigated](https://github.com/rust-lang/rust/pull/105070#issuecomment-1332141661)
* all the primary regressions were deemed noise.
* marking as triaged.

Rollup of 5 pull requests [#105080](https://github.com/rust-lang/rust/pull/105080) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8de4b138455add55bde6de5553a933a2ab79b71f&end=a569a88f5500e8780c7cc65fa53fc8b098517674&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.9%  | [0.8%, 1.0%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 2.4%  | [2.1%, 2.8%]   | 6     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-0.9%, -0.5%] | 7     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.3% | [-0.9%, 1.0%]  | 9     |


° lqd already [marked as triaged](https://github.com/rust-lang/rust/pull/105080#issuecomment-1332124349)

Disable top down MIR inlining [#105119](https://github.com/rust-lang/rust/pull/105119) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8e440b03761f725d452120a992723c7e261822b2&end=226202d9026b0f24b4f7aad4de398bd8378774cd&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.2%, 1.0%]   | 12    |
| Regressions ❌ <br /> (secondary)  | 1.0%  | [0.2%, 2.1%]   | 15    |
| Improvements ✅ <br /> (primary)   | -0.4% | [-1.0%, -0.2%] | 8     |
| Improvements ✅ <br /> (secondary) | -0.7% | [-1.0%, -0.1%] | 18    |
| All ❌✅ (primary)                 | 0.1%  | [-1.0%, 1.0%]  | 20    |


* nnethercote already [marked as triaged](https://github.com/rust-lang/rust/pull/105119#issuecomment-1338814158)

#### Untriaged Pull Requests

- [#105220 feed resolver_for_lowering instead of storing it in a field](https://github.com/rust-lang/rust/pull/105220)
- [#105070 Rollup of 14 pull requests](https://github.com/rust-lang/rust/pull/105070)
- [#104940 Allow to feed a value in another query's cache](https://github.com/rust-lang/rust/pull/104940)
- [#104863 Reduce macro usage for lints](https://github.com/rust-lang/rust/pull/104863)
- [#104566 couple of clippy::perf fixes](https://github.com/rust-lang/rust/pull/104566)
- [#104533 Clean up and harden various methods around trait substs](https://github.com/rust-lang/rust/pull/104533)
- [#104017 Rollup of 5 pull requests](https://github.com/rust-lang/rust/pull/104017)
- [#103998 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/103998)
- [#103975 Some tracing and comment cleanups](https://github.com/rust-lang/rust/pull/103975)
- [#103934 std: sync "Dependencies of the `backtrace` crate" with `backtrace`](https://github.com/rust-lang/rust/pull/103934)
- [#103841 Rollup of 5 pull requests](https://github.com/rust-lang/rust/pull/103841)
- [#103650 rustdoc: change `.src-line-numbers > span` to `.src-line-numbers > a`](https://github.com/rust-lang/rust/pull/103650)
- [#103562 Rollup of 10 pull requests](https://github.com/rust-lang/rust/pull/103562)
- [#103439 Show note where the macro failed to match](https://github.com/rust-lang/rust/pull/103439)
- [#103295 ci: Bring back ninja for dist builders](https://github.com/rust-lang/rust/pull/103295)
- [#103071 Fix line numbers for MIR inlined code](https://github.com/rust-lang/rust/pull/103071)
- [#102975 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/102975)
- [#102915 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/102915)
- [#102895 Get rid of `rustc_query_description!`](https://github.com/rust-lang/rust/pull/102895)
- [#102867 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/102867)
- [#102809 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/102809)
- [#102570 Perform simple scalar replacement of aggregates (SROA) MIR opt](https://github.com/rust-lang/rust/pull/102570)
- [#102548 Mark Cell::replace() as #[inline]](https://github.com/rust-lang/rust/pull/102548)
- [#102026 Populate effective visibilities in 'rustc_resolve'](https://github.com/rust-lang/rust/pull/102026)
- [#101858 derive various impls instead of hand-rolling them](https://github.com/rust-lang/rust/pull/101858)
- [#101857 change `FnMutDelegate` to trait objects](https://github.com/rust-lang/rust/pull/101857)
- [#101702 rustdoc: add hash to filename of toolchain files](https://github.com/rust-lang/rust/pull/101702)
- [#101632 Remove `TypeckResults` from `InferCtxt`](https://github.com/rust-lang/rust/pull/101632)
- [#101620 Compute lint levels by definition](https://github.com/rust-lang/rust/pull/101620)
- [#101433 Emit a note that static bounds from HRTBs are a bug](https://github.com/rust-lang/rust/pull/101433)
