package com.kreative.keyedit;

import java.util.HashMap;

public final class XkbKeySym {
	public static final XkbKeySym MAP = new XkbKeySym();
	
	private final HashMap<Integer,String> u2n;
	private final HashMap<String,Integer> n2u;
	
	private XkbKeySym() {
		this.u2n = new HashMap<Integer,String>();
		this.n2u = new HashMap<String,Integer>();
		
		// Latin 1
		m(0x0020, "space");
		m(0x0021, "exclam");
		m(0x0022, "quotedbl");
		m(0x0023, "numbersign");
		m(0x0024, "dollar");
		m(0x0025, "percent");
		m(0x0026, "ampersand");
		m(0x0027, "apostrophe");
		m(0x0028, "parenleft");
		m(0x0029, "parenright");
		m(0x002A, "asterisk");
		m(0x002B, "plus");
		m(0x002C, "comma");
		m(0x002D, "minus");
		m(0x002E, "period");
		m(0x002F, "slash");
		m(0x0030, "0");
		m(0x0031, "1");
		m(0x0032, "2");
		m(0x0033, "3");
		m(0x0034, "4");
		m(0x0035, "5");
		m(0x0036, "6");
		m(0x0037, "7");
		m(0x0038, "8");
		m(0x0039, "9");
		m(0x003A, "colon");
		m(0x003B, "semicolon");
		m(0x003C, "less");
		m(0x003D, "equal");
		m(0x003E, "greater");
		m(0x003F, "question");
		m(0x0040, "at");
		m(0x0041, "A");
		m(0x0042, "B");
		m(0x0043, "C");
		m(0x0044, "D");
		m(0x0045, "E");
		m(0x0046, "F");
		m(0x0047, "G");
		m(0x0048, "H");
		m(0x0049, "I");
		m(0x004A, "J");
		m(0x004B, "K");
		m(0x004C, "L");
		m(0x004D, "M");
		m(0x004E, "N");
		m(0x004F, "O");
		m(0x0050, "P");
		m(0x0051, "Q");
		m(0x0052, "R");
		m(0x0053, "S");
		m(0x0054, "T");
		m(0x0055, "U");
		m(0x0056, "V");
		m(0x0057, "W");
		m(0x0058, "X");
		m(0x0059, "Y");
		m(0x005A, "Z");
		m(0x005B, "bracketleft");
		m(0x005C, "backslash");
		m(0x005D, "bracketright");
		m(0x005E, "asciicircum");
		m(0x005F, "underscore");
		m(0x0060, "grave");
		m(0x0061, "a");
		m(0x0062, "b");
		m(0x0063, "c");
		m(0x0064, "d");
		m(0x0065, "e");
		m(0x0066, "f");
		m(0x0067, "g");
		m(0x0068, "h");
		m(0x0069, "i");
		m(0x006A, "j");
		m(0x006B, "k");
		m(0x006C, "l");
		m(0x006D, "m");
		m(0x006E, "n");
		m(0x006F, "o");
		m(0x0070, "p");
		m(0x0071, "q");
		m(0x0072, "r");
		m(0x0073, "s");
		m(0x0074, "t");
		m(0x0075, "u");
		m(0x0076, "v");
		m(0x0077, "w");
		m(0x0078, "x");
		m(0x0079, "y");
		m(0x007A, "z");
		m(0x007B, "braceleft");
		m(0x007C, "bar");
		m(0x007D, "braceright");
		m(0x007E, "asciitilde");
		m(0x00A0, "nobreakspace");
		m(0x00A1, "exclamdown");
		m(0x00A2, "cent");
		m(0x00A3, "sterling");
		m(0x00A4, "currency");
		m(0x00A5, "yen");
		m(0x00A6, "brokenbar");
		m(0x00A7, "section");
		m(0x00A8, "diaeresis");
		m(0x00A9, "copyright");
		m(0x00AA, "ordfeminine");
		m(0x00AB, "guillemotleft");
		m(0x00AC, "notsign");
		rom(0x00AD, "hyphen");
		m(0x00AE, "registered");
		m(0x00AF, "macron");
		m(0x00B0, "degree");
		m(0x00B1, "plusminus");
		m(0x00B2, "twosuperior");
		m(0x00B3, "threesuperior");
		m(0x00B4, "acute");
		m(0x00B5, "mu");
		m(0x00B6, "paragraph");
		m(0x00B7, "periodcentered");
		m(0x00B8, "cedilla");
		m(0x00B9, "onesuperior");
		m(0x00BA, "masculine");
		m(0x00BB, "guillemotright");
		m(0x00BC, "onequarter");
		m(0x00BD, "onehalf");
		m(0x00BE, "threequarters");
		m(0x00BF, "questiondown");
		m(0x00C0, "Agrave");
		m(0x00C1, "Aacute");
		m(0x00C2, "Acircumflex");
		m(0x00C3, "Atilde");
		m(0x00C4, "Adiaeresis");
		m(0x00C5, "Aring");
		m(0x00C6, "AE");
		m(0x00C7, "Ccedilla");
		m(0x00C8, "Egrave");
		m(0x00C9, "Eacute");
		m(0x00CA, "Ecircumflex");
		m(0x00CB, "Ediaeresis");
		m(0x00CC, "Igrave");
		m(0x00CD, "Iacute");
		m(0x00CE, "Icircumflex");
		m(0x00CF, "Idiaeresis");
		m(0x00D0, "ETH");
		m(0x00D1, "Ntilde");
		m(0x00D2, "Ograve");
		m(0x00D3, "Oacute");
		m(0x00D4, "Ocircumflex");
		m(0x00D5, "Otilde");
		m(0x00D6, "Odiaeresis");
		m(0x00D7, "multiply");
		m(0x00D8, "Oslash");
		m(0x00D8, "Ooblique");
		m(0x00D9, "Ugrave");
		m(0x00DA, "Uacute");
		m(0x00DB, "Ucircumflex");
		m(0x00DC, "Udiaeresis");
		m(0x00DD, "Yacute");
		m(0x00DE, "THORN");
		m(0x00DF, "ssharp");
		m(0x00E0, "agrave");
		m(0x00E1, "aacute");
		m(0x00E2, "acircumflex");
		m(0x00E3, "atilde");
		m(0x00E4, "adiaeresis");
		m(0x00E5, "aring");
		m(0x00E6, "ae");
		m(0x00E7, "ccedilla");
		m(0x00E8, "egrave");
		m(0x00E9, "eacute");
		m(0x00EA, "ecircumflex");
		m(0x00EB, "ediaeresis");
		m(0x00EC, "igrave");
		m(0x00ED, "iacute");
		m(0x00EE, "icircumflex");
		m(0x00EF, "idiaeresis");
		m(0x00F0, "eth");
		m(0x00F1, "ntilde");
		m(0x00F2, "ograve");
		m(0x00F3, "oacute");
		m(0x00F4, "ocircumflex");
		m(0x00F5, "otilde");
		m(0x00F6, "odiaeresis");
		m(0x00F7, "division");
		m(0x00F8, "oslash");
		m(0x00F8, "ooblique");
		m(0x00F9, "ugrave");
		m(0x00FA, "uacute");
		m(0x00FB, "ucircumflex");
		m(0x00FC, "udiaeresis");
		m(0x00FD, "yacute");
		m(0x00FE, "thorn");
		m(0x00FF, "ydiaeresis");
		
		// Latin 2
		m(0x0104, "Aogonek");
		m(0x02D8, "breve");
		m(0x0141, "Lstroke");
		m(0x013D, "Lcaron");
		m(0x015A, "Sacute");
		m(0x0160, "Scaron");
		m(0x015E, "Scedilla");
		m(0x0164, "Tcaron");
		m(0x0179, "Zacute");
		m(0x017D, "Zcaron");
		m(0x017B, "Zabovedot");
		m(0x0105, "aogonek");
		m(0x02DB, "ogonek");
		m(0x0142, "lstroke");
		m(0x013E, "lcaron");
		m(0x015B, "sacute");
		m(0x02C7, "caron");
		m(0x0161, "scaron");
		m(0x015F, "scedilla");
		m(0x0165, "tcaron");
		m(0x017A, "zacute");
		m(0x02DD, "doubleacute");
		m(0x017E, "zcaron");
		m(0x017C, "zabovedot");
		m(0x0154, "Racute");
		m(0x0102, "Abreve");
		m(0x0139, "Lacute");
		m(0x0106, "Cacute");
		m(0x010C, "Ccaron");
		m(0x0118, "Eogonek");
		m(0x011A, "Ecaron");
		m(0x010E, "Dcaron");
		m(0x0110, "Dstroke");
		m(0x0143, "Nacute");
		m(0x0147, "Ncaron");
		m(0x0150, "Odoubleacute");
		m(0x0158, "Rcaron");
		m(0x016E, "Uring");
		m(0x0170, "Udoubleacute");
		m(0x0162, "Tcedilla");
		m(0x0155, "racute");
		m(0x0103, "abreve");
		m(0x013A, "lacute");
		m(0x0107, "cacute");
		m(0x010D, "ccaron");
		m(0x0119, "eogonek");
		m(0x011B, "ecaron");
		m(0x010F, "dcaron");
		m(0x0111, "dstroke");
		m(0x0144, "nacute");
		m(0x0148, "ncaron");
		m(0x0151, "odoubleacute");
		m(0x0159, "rcaron");
		m(0x016F, "uring");
		m(0x0171, "udoubleacute");
		m(0x0163, "tcedilla");
		m(0x02D9, "abovedot");
		
		// Latin 3
		m(0x0126, "Hstroke");
		m(0x0124, "Hcircumflex");
		m(0x0130, "Iabovedot");
		m(0x011E, "Gbreve");
		m(0x0134, "Jcircumflex");
		m(0x0127, "hstroke");
		m(0x0125, "hcircumflex");
		m(0x0131, "idotless");
		m(0x011F, "gbreve");
		m(0x0135, "jcircumflex");
		m(0x010A, "Cabovedot");
		m(0x0108, "Ccircumflex");
		m(0x0120, "Gabovedot");
		m(0x011C, "Gcircumflex");
		m(0x016C, "Ubreve");
		m(0x015C, "Scircumflex");
		m(0x010B, "cabovedot");
		m(0x0109, "ccircumflex");
		m(0x0121, "gabovedot");
		m(0x011D, "gcircumflex");
		m(0x016D, "ubreve");
		m(0x015D, "scircumflex");
		
		// Latin 4
		m(0x0138, "kra");
		m(0x0156, "Rcedilla");
		m(0x0128, "Itilde");
		m(0x013B, "Lcedilla");
		m(0x0112, "Emacron");
		m(0x0122, "Gcedilla");
		m(0x0166, "Tslash");
		m(0x0157, "rcedilla");
		m(0x0129, "itilde");
		m(0x013C, "lcedilla");
		m(0x0113, "emacron");
		m(0x0123, "gcedilla");
		m(0x0167, "tslash");
		m(0x014A, "ENG");
		m(0x014B, "eng");
		m(0x0100, "Amacron");
		m(0x012E, "Iogonek");
		m(0x0116, "Eabovedot");
		m(0x012A, "Imacron");
		m(0x0145, "Ncedilla");
		m(0x014C, "Omacron");
		m(0x0136, "Kcedilla");
		m(0x0172, "Uogonek");
		m(0x0168, "Utilde");
		m(0x016A, "Umacron");
		m(0x0101, "amacron");
		m(0x012F, "iogonek");
		m(0x0117, "eabovedot");
		m(0x012B, "imacron");
		m(0x0146, "ncedilla");
		m(0x014D, "omacron");
		m(0x0137, "kcedilla");
		m(0x0173, "uogonek");
		m(0x0169, "utilde");
		m(0x016B, "umacron");
		
		// Latin 8
		m(0x0174, "Wcircumflex");
		m(0x0175, "wcircumflex");
		m(0x0176, "Ycircumflex");
		m(0x0177, "ycircumflex");
		m(0x1E02, "Babovedot");
		m(0x1E03, "babovedot");
		m(0x1E0A, "Dabovedot");
		m(0x1E0B, "dabovedot");
		m(0x1E1E, "Fabovedot");
		m(0x1E1F, "fabovedot");
		m(0x1E40, "Mabovedot");
		m(0x1E41, "mabovedot");
		m(0x1E56, "Pabovedot");
		m(0x1E57, "pabovedot");
		m(0x1E60, "Sabovedot");
		m(0x1E61, "sabovedot");
		m(0x1E6A, "Tabovedot");
		m(0x1E6B, "tabovedot");
		m(0x1E80, "Wgrave");
		m(0x1E81, "wgrave");
		m(0x1E82, "Wacute");
		m(0x1E83, "wacute");
		m(0x1E84, "Wdiaeresis");
		m(0x1E85, "wdiaeresis");
		m(0x1EF2, "Ygrave");
		m(0x1EF3, "ygrave");
		
		// Latin 9
		m(0x0152, "OE");
		m(0x0153, "oe");
		m(0x0178, "Ydiaeresis");
		
		// Katakana
		rom(0x203E, "overline");
		rom(0x3002, "kana_fullstop");
		rom(0x300C, "kana_openingbracket");
		rom(0x300D, "kana_closingbracket");
		rom(0x3001, "kana_comma");
		rom(0x30FB, "kana_conjunctive");
		rom(0x30F2, "kana_WO");
		rom(0x30A1, "kana_a");
		rom(0x30A3, "kana_i");
		rom(0x30A5, "kana_u");
		rom(0x30A7, "kana_e");
		rom(0x30A9, "kana_o");
		rom(0x30E3, "kana_ya");
		rom(0x30E5, "kana_yu");
		rom(0x30E7, "kana_yo");
		rom(0x30C3, "kana_tsu");
		rom(0x30FC, "prolongedsound");
		rom(0x30A2, "kana_A");
		rom(0x30A4, "kana_I");
		rom(0x30A6, "kana_U");
		rom(0x30A8, "kana_E");
		rom(0x30AA, "kana_O");
		rom(0x30AB, "kana_KA");
		rom(0x30AD, "kana_KI");
		rom(0x30AF, "kana_KU");
		rom(0x30B1, "kana_KE");
		rom(0x30B3, "kana_KO");
		rom(0x30B5, "kana_SA");
		rom(0x30B7, "kana_SHI");
		rom(0x30B9, "kana_SU");
		rom(0x30BB, "kana_SE");
		rom(0x30BD, "kana_SO");
		rom(0x30BF, "kana_TA");
		rom(0x30C1, "kana_CHI");
		rom(0x30C4, "kana_TSU");
		rom(0x30C6, "kana_TE");
		rom(0x30C8, "kana_TO");
		rom(0x30CA, "kana_NA");
		rom(0x30CB, "kana_NI");
		rom(0x30CC, "kana_NU");
		rom(0x30CD, "kana_NE");
		rom(0x30CE, "kana_NO");
		rom(0x30CF, "kana_HA");
		rom(0x30D2, "kana_HI");
		rom(0x30D5, "kana_FU");
		rom(0x30D8, "kana_HE");
		rom(0x30DB, "kana_HO");
		rom(0x30DE, "kana_MA");
		rom(0x30DF, "kana_MI");
		rom(0x30E0, "kana_MU");
		rom(0x30E1, "kana_ME");
		rom(0x30E2, "kana_MO");
		rom(0x30E4, "kana_YA");
		rom(0x30E6, "kana_YU");
		rom(0x30E8, "kana_YO");
		rom(0x30E9, "kana_RA");
		rom(0x30EA, "kana_RI");
		rom(0x30EB, "kana_RU");
		rom(0x30EC, "kana_RE");
		rom(0x30ED, "kana_RO");
		rom(0x30EF, "kana_WA");
		rom(0x30F3, "kana_N");
		rom(0x309B, "voicedsound");
		rom(0x309C, "semivoicedsound");
		
		// Arabic
		rom(0x06F0, "Farsi_0");
		rom(0x06F1, "Farsi_1");
		rom(0x06F2, "Farsi_2");
		rom(0x06F3, "Farsi_3");
		rom(0x06F4, "Farsi_4");
		rom(0x06F5, "Farsi_5");
		rom(0x06F6, "Farsi_6");
		rom(0x06F7, "Farsi_7");
		rom(0x06F8, "Farsi_8");
		rom(0x06F9, "Farsi_9");
		rom(0x066A, "Arabic_percent");
		rom(0x0670, "Arabic_superscript_alef");
		rom(0x0679, "Arabic_tteh");
		rom(0x067E, "Arabic_peh");
		rom(0x0686, "Arabic_tcheh");
		rom(0x0688, "Arabic_ddal");
		rom(0x0691, "Arabic_rreh");
		rom(0x060C, "Arabic_comma");
		rom(0x06D4, "Arabic_fullstop");
		rom(0x0660, "Arabic_0");
		rom(0x0661, "Arabic_1");
		rom(0x0662, "Arabic_2");
		rom(0x0663, "Arabic_3");
		rom(0x0664, "Arabic_4");
		rom(0x0665, "Arabic_5");
		rom(0x0666, "Arabic_6");
		rom(0x0667, "Arabic_7");
		rom(0x0668, "Arabic_8");
		rom(0x0669, "Arabic_9");
		rom(0x061B, "Arabic_semicolon");
		rom(0x061F, "Arabic_question_mark");
		rom(0x0621, "Arabic_hamza");
		rom(0x0622, "Arabic_maddaonalef");
		rom(0x0623, "Arabic_hamzaonalef");
		rom(0x0624, "Arabic_hamzaonwaw");
		rom(0x0625, "Arabic_hamzaunderalef");
		rom(0x0626, "Arabic_hamzaonyeh");
		rom(0x0627, "Arabic_alef");
		rom(0x0628, "Arabic_beh");
		rom(0x0629, "Arabic_tehmarbuta");
		rom(0x062A, "Arabic_teh");
		rom(0x062B, "Arabic_theh");
		rom(0x062C, "Arabic_jeem");
		rom(0x062D, "Arabic_hah");
		rom(0x062E, "Arabic_khah");
		rom(0x062F, "Arabic_dal");
		rom(0x0630, "Arabic_thal");
		rom(0x0631, "Arabic_ra");
		rom(0x0632, "Arabic_zain");
		rom(0x0633, "Arabic_seen");
		rom(0x0634, "Arabic_sheen");
		rom(0x0635, "Arabic_sad");
		rom(0x0636, "Arabic_dad");
		rom(0x0637, "Arabic_tah");
		rom(0x0638, "Arabic_zah");
		rom(0x0639, "Arabic_ain");
		rom(0x063A, "Arabic_ghain");
		rom(0x0640, "Arabic_tatweel");
		rom(0x0641, "Arabic_feh");
		rom(0x0642, "Arabic_qaf");
		rom(0x0643, "Arabic_kaf");
		rom(0x0644, "Arabic_lam");
		rom(0x0645, "Arabic_meem");
		rom(0x0646, "Arabic_noon");
		rom(0x0647, "Arabic_ha");
		rom(0x0648, "Arabic_waw");
		rom(0x0649, "Arabic_alefmaksura");
		rom(0x064A, "Arabic_yeh");
		rom(0x064B, "Arabic_fathatan");
		rom(0x064C, "Arabic_dammatan");
		rom(0x064D, "Arabic_kasratan");
		rom(0x064E, "Arabic_fatha");
		rom(0x064F, "Arabic_damma");
		rom(0x0650, "Arabic_kasra");
		rom(0x0651, "Arabic_shadda");
		rom(0x0652, "Arabic_sukun");
		rom(0x0653, "Arabic_madda_above");
		rom(0x0654, "Arabic_hamza_above");
		rom(0x0655, "Arabic_hamza_below");
		rom(0x0698, "Arabic_jeh");
		rom(0x06A4, "Arabic_veh");
		rom(0x06A9, "Arabic_keheh");
		rom(0x06AF, "Arabic_gaf");
		rom(0x06BA, "Arabic_noon_ghunna");
		rom(0x06BE, "Arabic_heh_doachashmee");
		rom(0x06CC, "Farsi_yeh");
		rom(0x06CC, "Arabic_farsi_yeh");
		rom(0x06D2, "Arabic_yeh_baree");
		rom(0x06C1, "Arabic_heh_goal");
		
		// Cyrillic
		m(0x0492, "Cyrillic_GHE_bar");
		m(0x0493, "Cyrillic_ghe_bar");
		m(0x0496, "Cyrillic_ZHE_descender");
		m(0x0497, "Cyrillic_zhe_descender");
		m(0x049A, "Cyrillic_KA_descender");
		m(0x049B, "Cyrillic_ka_descender");
		m(0x049C, "Cyrillic_KA_vertstroke");
		m(0x049D, "Cyrillic_ka_vertstroke");
		m(0x04A2, "Cyrillic_EN_descender");
		m(0x04A3, "Cyrillic_en_descender");
		m(0x04AE, "Cyrillic_U_straight");
		m(0x04AF, "Cyrillic_u_straight");
		m(0x04B0, "Cyrillic_U_straight_bar");
		m(0x04B1, "Cyrillic_u_straight_bar");
		m(0x04B2, "Cyrillic_HA_descender");
		m(0x04B3, "Cyrillic_ha_descender");
		m(0x04B6, "Cyrillic_CHE_descender");
		m(0x04B7, "Cyrillic_che_descender");
		m(0x04B8, "Cyrillic_CHE_vertstroke");
		m(0x04B9, "Cyrillic_che_vertstroke");
		m(0x04BA, "Cyrillic_SHHA");
		m(0x04BB, "Cyrillic_shha");
		m(0x04D8, "Cyrillic_SCHWA");
		m(0x04D9, "Cyrillic_schwa");
		m(0x04E2, "Cyrillic_I_macron");
		m(0x04E3, "Cyrillic_i_macron");
		m(0x04E8, "Cyrillic_O_bar");
		m(0x04E9, "Cyrillic_o_bar");
		m(0x04EE, "Cyrillic_U_macron");
		m(0x04EF, "Cyrillic_u_macron");
		m(0x0452, "Serbian_dje");
		m(0x0453, "Macedonia_gje");
		m(0x0451, "Cyrillic_io");
		m(0x0454, "Ukrainian_ie");
		m(0x0455, "Macedonia_dse");
		m(0x0456, "Ukrainian_i");
		m(0x0457, "Ukrainian_yi");
		m(0x0458, "Cyrillic_je");
		m(0x0459, "Cyrillic_lje");
		m(0x045A, "Cyrillic_nje");
		m(0x045B, "Serbian_tshe");
		m(0x045C, "Macedonia_kje");
		m(0x0491, "Ukrainian_ghe_with_upturn");
		m(0x045E, "Byelorussian_shortu");
		m(0x045F, "Cyrillic_dzhe");
		m(0x2116, "numerosign");
		m(0x0402, "Serbian_DJE");
		m(0x0403, "Macedonia_GJE");
		m(0x0401, "Cyrillic_IO");
		m(0x0404, "Ukrainian_IE");
		m(0x0405, "Macedonia_DSE");
		m(0x0406, "Ukrainian_I");
		m(0x0407, "Ukrainian_YI");
		m(0x0408, "Cyrillic_JE");
		m(0x0409, "Cyrillic_LJE");
		m(0x040A, "Cyrillic_NJE");
		m(0x040B, "Serbian_TSHE");
		m(0x040C, "Macedonia_KJE");
		m(0x0490, "Ukrainian_GHE_WITH_UPTURN");
		m(0x040E, "Byelorussian_SHORTU");
		m(0x040F, "Cyrillic_DZHE");
		m(0x044E, "Cyrillic_yu");
		m(0x0430, "Cyrillic_a");
		m(0x0431, "Cyrillic_be");
		m(0x0446, "Cyrillic_tse");
		m(0x0434, "Cyrillic_de");
		m(0x0435, "Cyrillic_ie");
		m(0x0444, "Cyrillic_ef");
		m(0x0433, "Cyrillic_ghe");
		m(0x0445, "Cyrillic_ha");
		m(0x0438, "Cyrillic_i");
		m(0x0439, "Cyrillic_shorti");
		m(0x043A, "Cyrillic_ka");
		m(0x043B, "Cyrillic_el");
		m(0x043C, "Cyrillic_em");
		m(0x043D, "Cyrillic_en");
		m(0x043E, "Cyrillic_o");
		m(0x043F, "Cyrillic_pe");
		m(0x044F, "Cyrillic_ya");
		m(0x0440, "Cyrillic_er");
		m(0x0441, "Cyrillic_es");
		m(0x0442, "Cyrillic_te");
		m(0x0443, "Cyrillic_u");
		m(0x0436, "Cyrillic_zhe");
		m(0x0432, "Cyrillic_ve");
		m(0x044C, "Cyrillic_softsign");
		m(0x044B, "Cyrillic_yeru");
		m(0x0437, "Cyrillic_ze");
		m(0x0448, "Cyrillic_sha");
		m(0x044D, "Cyrillic_e");
		m(0x0449, "Cyrillic_shcha");
		m(0x0447, "Cyrillic_che");
		m(0x044A, "Cyrillic_hardsign");
		m(0x042E, "Cyrillic_YU");
		m(0x0410, "Cyrillic_A");
		m(0x0411, "Cyrillic_BE");
		m(0x0426, "Cyrillic_TSE");
		m(0x0414, "Cyrillic_DE");
		m(0x0415, "Cyrillic_IE");
		m(0x0424, "Cyrillic_EF");
		m(0x0413, "Cyrillic_GHE");
		m(0x0425, "Cyrillic_HA");
		m(0x0418, "Cyrillic_I");
		m(0x0419, "Cyrillic_SHORTI");
		m(0x041A, "Cyrillic_KA");
		m(0x041B, "Cyrillic_EL");
		m(0x041C, "Cyrillic_EM");
		m(0x041D, "Cyrillic_EN");
		m(0x041E, "Cyrillic_O");
		m(0x041F, "Cyrillic_PE");
		m(0x042F, "Cyrillic_YA");
		m(0x0420, "Cyrillic_ER");
		m(0x0421, "Cyrillic_ES");
		m(0x0422, "Cyrillic_TE");
		m(0x0423, "Cyrillic_U");
		m(0x0416, "Cyrillic_ZHE");
		m(0x0412, "Cyrillic_VE");
		m(0x042C, "Cyrillic_SOFTSIGN");
		m(0x042B, "Cyrillic_YERU");
		m(0x0417, "Cyrillic_ZE");
		m(0x0428, "Cyrillic_SHA");
		m(0x042D, "Cyrillic_E");
		m(0x0429, "Cyrillic_SHCHA");
		m(0x0427, "Cyrillic_CHE");
		m(0x042A, "Cyrillic_HARDSIGN");
		
		// Greek
		m(0x0386, "Greek_ALPHAaccent");
		m(0x0388, "Greek_EPSILONaccent");
		m(0x0389, "Greek_ETAaccent");
		m(0x038A, "Greek_IOTAaccent");
		m(0x03AA, "Greek_IOTAdieresis");
		m(0x038C, "Greek_OMICRONaccent");
		m(0x038E, "Greek_UPSILONaccent");
		m(0x03AB, "Greek_UPSILONdieresis");
		m(0x038F, "Greek_OMEGAaccent");
		m(0x0385, "Greek_accentdieresis");
		m(0x2015, "Greek_horizbar");
		m(0x03AC, "Greek_alphaaccent");
		m(0x03AD, "Greek_epsilonaccent");
		m(0x03AE, "Greek_etaaccent");
		m(0x03AF, "Greek_iotaaccent");
		m(0x03CA, "Greek_iotadieresis");
		m(0x0390, "Greek_iotaaccentdieresis");
		m(0x03CC, "Greek_omicronaccent");
		m(0x03CD, "Greek_upsilonaccent");
		m(0x03CB, "Greek_upsilondieresis");
		m(0x03B0, "Greek_upsilonaccentdieresis");
		m(0x03CE, "Greek_omegaaccent");
		m(0x0391, "Greek_ALPHA");
		m(0x0392, "Greek_BETA");
		m(0x0393, "Greek_GAMMA");
		m(0x0394, "Greek_DELTA");
		m(0x0395, "Greek_EPSILON");
		m(0x0396, "Greek_ZETA");
		m(0x0397, "Greek_ETA");
		m(0x0398, "Greek_THETA");
		m(0x0399, "Greek_IOTA");
		m(0x039A, "Greek_KAPPA");
		m(0x039B, "Greek_LAMDA");
		m(0x039B, "Greek_LAMBDA");
		m(0x039C, "Greek_MU");
		m(0x039D, "Greek_NU");
		m(0x039E, "Greek_XI");
		m(0x039F, "Greek_OMICRON");
		m(0x03A0, "Greek_PI");
		m(0x03A1, "Greek_RHO");
		m(0x03A3, "Greek_SIGMA");
		m(0x03A4, "Greek_TAU");
		m(0x03A5, "Greek_UPSILON");
		m(0x03A6, "Greek_PHI");
		m(0x03A7, "Greek_CHI");
		m(0x03A8, "Greek_PSI");
		m(0x03A9, "Greek_OMEGA");
		m(0x03B1, "Greek_alpha");
		m(0x03B2, "Greek_beta");
		m(0x03B3, "Greek_gamma");
		m(0x03B4, "Greek_delta");
		m(0x03B5, "Greek_epsilon");
		m(0x03B6, "Greek_zeta");
		m(0x03B7, "Greek_eta");
		m(0x03B8, "Greek_theta");
		m(0x03B9, "Greek_iota");
		m(0x03BA, "Greek_kappa");
		m(0x03BB, "Greek_lamda");
		m(0x03BB, "Greek_lambda");
		m(0x03BC, "Greek_mu");
		m(0x03BD, "Greek_nu");
		m(0x03BE, "Greek_xi");
		m(0x03BF, "Greek_omicron");
		m(0x03C0, "Greek_pi");
		m(0x03C1, "Greek_rho");
		m(0x03C3, "Greek_sigma");
		m(0x03C2, "Greek_finalsmallsigma");
		m(0x03C4, "Greek_tau");
		m(0x03C5, "Greek_upsilon");
		m(0x03C6, "Greek_phi");
		m(0x03C7, "Greek_chi");
		m(0x03C8, "Greek_psi");
		m(0x03C9, "Greek_omega");
		
		// Technical
		rom(0x23B7, "leftradical");
		rom(0x2320, "topintegral");
		rom(0x2321, "botintegral");
		rom(0x23A1, "topleftsqbracket");
		rom(0x23A3, "botleftsqbracket");
		rom(0x23A4, "toprightsqbracket");
		rom(0x23A6, "botrightsqbracket");
		rom(0x239B, "topleftparens");
		rom(0x239D, "botleftparens");
		rom(0x239E, "toprightparens");
		rom(0x23A0, "botrightparens");
		rom(0x23A8, "leftmiddlecurlybrace");
		rom(0x23AC, "rightmiddlecurlybrace");
		m(0x2264, "lessthanequal");
		m(0x2260, "notequal");
		m(0x2265, "greaterthanequal");
		m(0x222B, "integral");
		rom(0x2234, "therefore");
		rom(0x221D, "variation");
		m(0x221E, "infinity");
		m(0x2207, "nabla");
		rom(0x223C, "approximate");
		rom(0x2243, "similarequal");
		rom(0x21D4, "ifonlyif");
		rom(0x21D2, "implies");
		rom(0x2261, "identical");
		rom(0x221A, "radical");
		rom(0x2282, "includedin");
		rom(0x2283, "includes");
		rom(0x2229, "intersection");
		rom(0x222A, "union");
		rom(0x2227, "logicaland");
		rom(0x2228, "logicalor");
		m(0x2202, "partialderivative");
		rom(0x0192, "function");
		rom(0x2190, "leftarrow");
		rom(0x2191, "uparrow");
		rom(0x2192, "rightarrow");
		rom(0x2193, "downarrow");
		
		// Special
		rom(0x25C6, "soliddiamond");
		rom(0x2592, "checkerboard");
		rom(0x2409, "ht");
		rom(0x240C, "ff");
		rom(0x240D, "cr");
		rom(0x240A, "lf");
		rom(0x2424, "nl");
		rom(0x240B, "vt");
		rom(0x2518, "lowrightcorner");
		rom(0x2510, "uprightcorner");
		rom(0x250C, "upleftcorner");
		rom(0x2514, "lowleftcorner");
		rom(0x253C, "crossinglines");
		rom(0x23BA, "horizlinescan1");
		rom(0x23BB, "horizlinescan3");
		rom(0x2500, "horizlinescan5");
		rom(0x23BC, "horizlinescan7");
		rom(0x23BD, "horizlinescan9");
		rom(0x251C, "leftt");
		rom(0x2524, "rightt");
		rom(0x2534, "bott");
		rom(0x252C, "topt");
		rom(0x2502, "vertbar");
		
		// Publishing
		rom(0x2003, "emspace");
		rom(0x2002, "enspace");
		rom(0x2004, "em3space");
		rom(0x2005, "em4space");
		rom(0x2007, "digitspace");
		rom(0x2008, "punctspace");
		rom(0x2009, "thinspace");
		rom(0x200A, "hairspace");
		m(0x2014, "emdash");
		m(0x2013, "endash");
		m(0x2026, "ellipsis");
		rom(0x2025, "doubbaselinedot");
		rom(0x2153, "onethird");
		rom(0x2154, "twothirds");
		rom(0x2155, "onefifth");
		rom(0x2156, "twofifths");
		rom(0x2157, "threefifths");
		rom(0x2158, "fourfifths");
		rom(0x2159, "onesixth");
		rom(0x215A, "fivesixths");
		rom(0x2105, "careof");
		rom(0x2012, "figdash");
		rom(0x215B, "oneeighth");
		rom(0x215C, "threeeighths");
		rom(0x215D, "fiveeighths");
		rom(0x215E, "seveneighths");
		m(0x2122, "trademark");
		m(0x2018, "leftsinglequotemark");
		m(0x2019, "rightsinglequotemark");
		m(0x201C, "leftdoublequotemark");
		m(0x201D, "rightdoublequotemark");
		rom(0x211E, "prescription");
		rom(0x2030, "permille");
		rom(0x2032, "minutes");
		rom(0x2033, "seconds");
		rom(0x271D, "latincross");
		rom(0x2663, "club");
		rom(0x2666, "diamond");
		rom(0x2665, "heart");
		rom(0x2720, "maltesecross");
		m(0x2020, "dagger");
		m(0x2021, "doubledagger");
		rom(0x2713, "checkmark");
		rom(0x2717, "ballotcross");
		rom(0x266F, "musicalsharp");
		rom(0x266D, "musicalflat");
		rom(0x2642, "malesymbol");
		rom(0x2640, "femalesymbol");
		rom(0x260E, "telephone");
		rom(0x2315, "telephonerecorder");
		rom(0x2117, "phonographcopyright");
		rom(0x2038, "caret");
		m(0x201A, "singlelowquotemark");
		m(0x201E, "doublelowquotemark");
		
		// APL
		rom(0x22A4, "downtack");
		rom(0x230A, "downstile");
		rom(0x2218, "jot");
		rom(0x2395, "quad");
		rom(0x22A5, "uptack");
		rom(0x25CB, "circle");
		rom(0x2308, "upstile");
		rom(0x22A3, "lefttack");
		rom(0x22A2, "righttack");
		
		// Hebrew
		rom(0x2017, "hebrew_doublelowline");
		rom(0x05D0, "hebrew_aleph");
		rom(0x05D1, "hebrew_bet");
		rom(0x05D2, "hebrew_gimel");
		rom(0x05D3, "hebrew_dalet");
		rom(0x05D4, "hebrew_he");
		rom(0x05D5, "hebrew_waw");
		rom(0x05D6, "hebrew_zain");
		rom(0x05D7, "hebrew_chet");
		rom(0x05D8, "hebrew_tet");
		rom(0x05D9, "hebrew_yod");
		rom(0x05DA, "hebrew_finalkaph");
		rom(0x05DB, "hebrew_kaph");
		rom(0x05DC, "hebrew_lamed");
		rom(0x05DD, "hebrew_finalmem");
		rom(0x05DE, "hebrew_mem");
		rom(0x05DF, "hebrew_finalnun");
		rom(0x05E0, "hebrew_nun");
		rom(0x05E1, "hebrew_samech");
		rom(0x05E2, "hebrew_ayin");
		rom(0x05E3, "hebrew_finalpe");
		rom(0x05E4, "hebrew_pe");
		rom(0x05E5, "hebrew_finalzade");
		rom(0x05E6, "hebrew_zade");
		rom(0x05E7, "hebrew_qoph");
		rom(0x05E8, "hebrew_resh");
		rom(0x05E9, "hebrew_shin");
		rom(0x05EA, "hebrew_taw");
		
		// Thai
		rom(0x0E01, "Thai_kokai");
		rom(0x0E02, "Thai_khokhai");
		rom(0x0E03, "Thai_khokhuat");
		rom(0x0E04, "Thai_khokhwai");
		rom(0x0E05, "Thai_khokhon");
		rom(0x0E06, "Thai_khorakhang");
		rom(0x0E07, "Thai_ngongu");
		rom(0x0E08, "Thai_chochan");
		rom(0x0E09, "Thai_choching");
		rom(0x0E0A, "Thai_chochang");
		rom(0x0E0B, "Thai_soso");
		rom(0x0E0C, "Thai_chochoe");
		rom(0x0E0D, "Thai_yoying");
		rom(0x0E0E, "Thai_dochada");
		rom(0x0E0F, "Thai_topatak");
		rom(0x0E10, "Thai_thothan");
		rom(0x0E11, "Thai_thonangmontho");
		rom(0x0E12, "Thai_thophuthao");
		rom(0x0E13, "Thai_nonen");
		rom(0x0E14, "Thai_dodek");
		rom(0x0E15, "Thai_totao");
		rom(0x0E16, "Thai_thothung");
		rom(0x0E17, "Thai_thothahan");
		rom(0x0E18, "Thai_thothong");
		rom(0x0E19, "Thai_nonu");
		rom(0x0E1A, "Thai_bobaimai");
		rom(0x0E1B, "Thai_popla");
		rom(0x0E1C, "Thai_phophung");
		rom(0x0E1D, "Thai_fofa");
		rom(0x0E1E, "Thai_phophan");
		rom(0x0E1F, "Thai_fofan");
		rom(0x0E20, "Thai_phosamphao");
		rom(0x0E21, "Thai_moma");
		rom(0x0E22, "Thai_yoyak");
		rom(0x0E23, "Thai_rorua");
		rom(0x0E24, "Thai_ru");
		rom(0x0E25, "Thai_loling");
		rom(0x0E26, "Thai_lu");
		rom(0x0E27, "Thai_wowaen");
		rom(0x0E28, "Thai_sosala");
		rom(0x0E29, "Thai_sorusi");
		rom(0x0E2A, "Thai_sosua");
		rom(0x0E2B, "Thai_hohip");
		rom(0x0E2C, "Thai_lochula");
		rom(0x0E2D, "Thai_oang");
		rom(0x0E2E, "Thai_honokhuk");
		rom(0x0E2F, "Thai_paiyannoi");
		rom(0x0E30, "Thai_saraa");
		rom(0x0E31, "Thai_maihanakat");
		rom(0x0E32, "Thai_saraaa");
		rom(0x0E33, "Thai_saraam");
		rom(0x0E34, "Thai_sarai");
		rom(0x0E35, "Thai_saraii");
		rom(0x0E36, "Thai_saraue");
		rom(0x0E37, "Thai_sarauee");
		rom(0x0E38, "Thai_sarau");
		rom(0x0E39, "Thai_sarauu");
		rom(0x0E3A, "Thai_phinthu");
		rom(0x0E3F, "Thai_baht");
		rom(0x0E40, "Thai_sarae");
		rom(0x0E41, "Thai_saraae");
		rom(0x0E42, "Thai_sarao");
		rom(0x0E43, "Thai_saraaimaimuan");
		rom(0x0E44, "Thai_saraaimaimalai");
		rom(0x0E45, "Thai_lakkhangyao");
		rom(0x0E46, "Thai_maiyamok");
		rom(0x0E47, "Thai_maitaikhu");
		rom(0x0E48, "Thai_maiek");
		rom(0x0E49, "Thai_maitho");
		rom(0x0E4A, "Thai_maitri");
		rom(0x0E4B, "Thai_maichattawa");
		rom(0x0E4C, "Thai_thanthakhat");
		rom(0x0E4D, "Thai_nikhahit");
		rom(0x0E50, "Thai_leksun");
		rom(0x0E51, "Thai_leknung");
		rom(0x0E52, "Thai_leksong");
		rom(0x0E53, "Thai_leksam");
		rom(0x0E54, "Thai_leksi");
		rom(0x0E55, "Thai_lekha");
		rom(0x0E56, "Thai_lekhok");
		rom(0x0E57, "Thai_lekchet");
		rom(0x0E58, "Thai_lekpaet");
		rom(0x0E59, "Thai_lekkao");
		
		// Armenian
		m(0x0587, "Armenian_ligature_ew");
		m(0x0589, "Armenian_full_stop");
		m(0x0589, "Armenian_verjaket");
		m(0x055D, "Armenian_separation_mark");
		m(0x055D, "Armenian_but");
		m(0x058A, "Armenian_hyphen");
		m(0x058A, "Armenian_yentamna");
		m(0x055C, "Armenian_exclam");
		m(0x055C, "Armenian_amanak");
		m(0x055B, "Armenian_accent");
		m(0x055B, "Armenian_shesht");
		m(0x055E, "Armenian_question");
		m(0x055E, "Armenian_paruyk");
		m(0x0531, "Armenian_AYB");
		m(0x0561, "Armenian_ayb");
		m(0x0532, "Armenian_BEN");
		m(0x0562, "Armenian_ben");
		m(0x0533, "Armenian_GIM");
		m(0x0563, "Armenian_gim");
		m(0x0534, "Armenian_DA");
		m(0x0564, "Armenian_da");
		m(0x0535, "Armenian_YECH");
		m(0x0565, "Armenian_yech");
		m(0x0536, "Armenian_ZA");
		m(0x0566, "Armenian_za");
		m(0x0537, "Armenian_E");
		m(0x0567, "Armenian_e");
		m(0x0538, "Armenian_AT");
		m(0x0568, "Armenian_at");
		m(0x0539, "Armenian_TO");
		m(0x0569, "Armenian_to");
		m(0x053A, "Armenian_ZHE");
		m(0x056A, "Armenian_zhe");
		m(0x053B, "Armenian_INI");
		m(0x056B, "Armenian_ini");
		m(0x053C, "Armenian_LYUN");
		m(0x056C, "Armenian_lyun");
		m(0x053D, "Armenian_KHE");
		m(0x056D, "Armenian_khe");
		m(0x053E, "Armenian_TSA");
		m(0x056E, "Armenian_tsa");
		m(0x053F, "Armenian_KEN");
		m(0x056F, "Armenian_ken");
		m(0x0540, "Armenian_HO");
		m(0x0570, "Armenian_ho");
		m(0x0541, "Armenian_DZA");
		m(0x0571, "Armenian_dza");
		m(0x0542, "Armenian_GHAT");
		m(0x0572, "Armenian_ghat");
		m(0x0543, "Armenian_TCHE");
		m(0x0573, "Armenian_tche");
		m(0x0544, "Armenian_MEN");
		m(0x0574, "Armenian_men");
		m(0x0545, "Armenian_HI");
		m(0x0575, "Armenian_hi");
		m(0x0546, "Armenian_NU");
		m(0x0576, "Armenian_nu");
		m(0x0547, "Armenian_SHA");
		m(0x0577, "Armenian_sha");
		m(0x0548, "Armenian_VO");
		m(0x0578, "Armenian_vo");
		m(0x0549, "Armenian_CHA");
		m(0x0579, "Armenian_cha");
		m(0x054A, "Armenian_PE");
		m(0x057A, "Armenian_pe");
		m(0x054B, "Armenian_JE");
		m(0x057B, "Armenian_je");
		m(0x054C, "Armenian_RA");
		m(0x057C, "Armenian_ra");
		m(0x054D, "Armenian_SE");
		m(0x057D, "Armenian_se");
		m(0x054E, "Armenian_VEV");
		m(0x057E, "Armenian_vev");
		m(0x054F, "Armenian_TYUN");
		m(0x057F, "Armenian_tyun");
		m(0x0550, "Armenian_RE");
		m(0x0580, "Armenian_re");
		m(0x0551, "Armenian_TSO");
		m(0x0581, "Armenian_tso");
		m(0x0552, "Armenian_VYUN");
		m(0x0582, "Armenian_vyun");
		m(0x0553, "Armenian_PYUR");
		m(0x0583, "Armenian_pyur");
		m(0x0554, "Armenian_KE");
		m(0x0584, "Armenian_ke");
		m(0x0555, "Armenian_O");
		m(0x0585, "Armenian_o");
		m(0x0556, "Armenian_FE");
		m(0x0586, "Armenian_fe");
		m(0x055A, "Armenian_apostrophe");
		
		// Georgian
		rom(0x10D0, "Georgian_an");
		rom(0x10D1, "Georgian_ban");
		rom(0x10D2, "Georgian_gan");
		rom(0x10D3, "Georgian_don");
		rom(0x10D4, "Georgian_en");
		rom(0x10D5, "Georgian_vin");
		rom(0x10D6, "Georgian_zen");
		rom(0x10D7, "Georgian_tan");
		rom(0x10D8, "Georgian_in");
		rom(0x10D9, "Georgian_kan");
		rom(0x10DA, "Georgian_las");
		rom(0x10DB, "Georgian_man");
		rom(0x10DC, "Georgian_nar");
		rom(0x10DD, "Georgian_on");
		rom(0x10DE, "Georgian_par");
		rom(0x10DF, "Georgian_zhar");
		rom(0x10E0, "Georgian_rae");
		rom(0x10E1, "Georgian_san");
		rom(0x10E2, "Georgian_tar");
		rom(0x10E3, "Georgian_un");
		rom(0x10E4, "Georgian_phar");
		rom(0x10E5, "Georgian_khar");
		rom(0x10E6, "Georgian_ghan");
		rom(0x10E7, "Georgian_qar");
		rom(0x10E8, "Georgian_shin");
		rom(0x10E9, "Georgian_chin");
		rom(0x10EA, "Georgian_can");
		rom(0x10EB, "Georgian_jil");
		rom(0x10EC, "Georgian_cil");
		rom(0x10ED, "Georgian_char");
		rom(0x10EE, "Georgian_xan");
		rom(0x10EF, "Georgian_jhan");
		rom(0x10F0, "Georgian_hae");
		rom(0x10F1, "Georgian_he");
		rom(0x10F2, "Georgian_hie");
		rom(0x10F3, "Georgian_we");
		rom(0x10F4, "Georgian_har");
		rom(0x10F5, "Georgian_hoe");
		rom(0x10F6, "Georgian_fi");
		
		// Caucasus
		m(0x1E8A, "Xabovedot");
		m(0x012C, "Ibreve");
		m(0x01B5, "Zstroke");
		m(0x01E6, "Gcaron");
		m(0x01D1, "Ocaron");
		m(0x019F, "Obarred");
		m(0x1E8B, "xabovedot");
		m(0x012D, "ibreve");
		m(0x01B6, "zstroke");
		m(0x01E7, "gcaron");
		m(0x01D2, "ocaron");
		m(0x0275, "obarred");
		m(0x018F, "SCHWA");
		m(0x0259, "schwa");
		m(0x01B7, "EZH");
		m(0x0292, "ezh");
		m(0x1E36, "Lbelowdot");
		m(0x1E37, "lbelowdot");
		
		// Vietnamese
		m(0x1EA0, "Abelowdot");
		m(0x1EA1, "abelowdot");
		m(0x1EA2, "Ahook");
		m(0x1EA3, "ahook");
		m(0x1EA4, "Acircumflexacute");
		m(0x1EA5, "acircumflexacute");
		m(0x1EA6, "Acircumflexgrave");
		m(0x1EA7, "acircumflexgrave");
		m(0x1EA8, "Acircumflexhook");
		m(0x1EA9, "acircumflexhook");
		m(0x1EAA, "Acircumflextilde");
		m(0x1EAB, "acircumflextilde");
		m(0x1EAC, "Acircumflexbelowdot");
		m(0x1EAD, "acircumflexbelowdot");
		m(0x1EAE, "Abreveacute");
		m(0x1EAF, "abreveacute");
		m(0x1EB0, "Abrevegrave");
		m(0x1EB1, "abrevegrave");
		m(0x1EB2, "Abrevehook");
		m(0x1EB3, "abrevehook");
		m(0x1EB4, "Abrevetilde");
		m(0x1EB5, "abrevetilde");
		m(0x1EB6, "Abrevebelowdot");
		m(0x1EB7, "abrevebelowdot");
		m(0x1EB8, "Ebelowdot");
		m(0x1EB9, "ebelowdot");
		m(0x1EBA, "Ehook");
		m(0x1EBB, "ehook");
		m(0x1EBC, "Etilde");
		m(0x1EBD, "etilde");
		m(0x1EBE, "Ecircumflexacute");
		m(0x1EBF, "ecircumflexacute");
		m(0x1EC0, "Ecircumflexgrave");
		m(0x1EC1, "ecircumflexgrave");
		m(0x1EC2, "Ecircumflexhook");
		m(0x1EC3, "ecircumflexhook");
		m(0x1EC4, "Ecircumflextilde");
		m(0x1EC5, "ecircumflextilde");
		m(0x1EC6, "Ecircumflexbelowdot");
		m(0x1EC7, "ecircumflexbelowdot");
		m(0x1EC8, "Ihook");
		m(0x1EC9, "ihook");
		m(0x1ECA, "Ibelowdot");
		m(0x1ECB, "ibelowdot");
		m(0x1ECC, "Obelowdot");
		m(0x1ECD, "obelowdot");
		m(0x1ECE, "Ohook");
		m(0x1ECF, "ohook");
		m(0x1ED0, "Ocircumflexacute");
		m(0x1ED1, "ocircumflexacute");
		m(0x1ED2, "Ocircumflexgrave");
		m(0x1ED3, "ocircumflexgrave");
		m(0x1ED4, "Ocircumflexhook");
		m(0x1ED5, "ocircumflexhook");
		m(0x1ED6, "Ocircumflextilde");
		m(0x1ED7, "ocircumflextilde");
		m(0x1ED8, "Ocircumflexbelowdot");
		m(0x1ED9, "ocircumflexbelowdot");
		m(0x1EDA, "Ohornacute");
		m(0x1EDB, "ohornacute");
		m(0x1EDC, "Ohorngrave");
		m(0x1EDD, "ohorngrave");
		m(0x1EDE, "Ohornhook");
		m(0x1EDF, "ohornhook");
		m(0x1EE0, "Ohorntilde");
		m(0x1EE1, "ohorntilde");
		m(0x1EE2, "Ohornbelowdot");
		m(0x1EE3, "ohornbelowdot");
		m(0x1EE4, "Ubelowdot");
		m(0x1EE5, "ubelowdot");
		m(0x1EE6, "Uhook");
		m(0x1EE7, "uhook");
		m(0x1EE8, "Uhornacute");
		m(0x1EE9, "uhornacute");
		m(0x1EEA, "Uhorngrave");
		m(0x1EEB, "uhorngrave");
		m(0x1EEC, "Uhornhook");
		m(0x1EED, "uhornhook");
		m(0x1EEE, "Uhorntilde");
		m(0x1EEF, "uhorntilde");
		m(0x1EF0, "Uhornbelowdot");
		m(0x1EF1, "uhornbelowdot");
		m(0x1EF4, "Ybelowdot");
		m(0x1EF5, "ybelowdot");
		m(0x1EF6, "Yhook");
		m(0x1EF7, "yhook");
		m(0x1EF8, "Ytilde");
		m(0x1EF9, "ytilde");
		m(0x01A0, "Ohorn");
		m(0x01A1, "ohorn");
		m(0x01AF, "Uhorn");
		m(0x01B0, "uhorn");
		
		// Currency
		rom(0x20A0, "EcuSign");
		rom(0x20A1, "ColonSign");
		rom(0x20A2, "CruzeiroSign");
		rom(0x20A3, "FFrancSign");
		rom(0x20A4, "LiraSign");
		rom(0x20A5, "MillSign");
		rom(0x20A6, "NairaSign");
		rom(0x20A7, "PesetaSign");
		rom(0x20A8, "RupeeSign");
		rom(0x20A9, "WonSign");
		rom(0x20AA, "NewSheqelSign");
		rom(0x20AB, "DongSign");
		m(0x20AC, "EuroSign");
		
		// Mathematical
		rom(0x2070, "zerosuperior");
		rom(0x2074, "foursuperior");
		rom(0x2075, "fivesuperior");
		rom(0x2076, "sixsuperior");
		rom(0x2077, "sevensuperior");
		rom(0x2078, "eightsuperior");
		rom(0x2079, "ninesuperior");
		rom(0x2080, "zerosubscript");
		rom(0x2081, "onesubscript");
		rom(0x2082, "twosubscript");
		rom(0x2083, "threesubscript");
		rom(0x2084, "foursubscript");
		rom(0x2085, "fivesubscript");
		rom(0x2086, "sixsubscript");
		rom(0x2087, "sevensubscript");
		rom(0x2088, "eightsubscript");
		rom(0x2089, "ninesubscript");
		rom(0x2202, "partdifferential");
		rom(0x2205, "emptyset");
		rom(0x2208, "elementof");
		rom(0x2209, "notelementof");
		rom(0x220B, "containsas");
		m(0x221A, "squareroot");
		rom(0x221B, "cuberoot");
		rom(0x221C, "fourthroot");
		rom(0x222C, "dintegral");
		rom(0x222D, "tintegral");
		rom(0x2235, "because");
		rom(0x2245, "approxeq");
		rom(0x2247, "notapproxeq");
		rom(0x2262, "notidentical");
		rom(0x2263, "stricteq");
		
		// Braille
		rom(0x2800, "braille_blank");
		rom(0x2801, "braille_dots_1");
		rom(0x2802, "braille_dots_2");
		rom(0x2803, "braille_dots_12");
		rom(0x2804, "braille_dots_3");
		rom(0x2805, "braille_dots_13");
		rom(0x2806, "braille_dots_23");
		rom(0x2807, "braille_dots_123");
		rom(0x2808, "braille_dots_4");
		rom(0x2809, "braille_dots_14");
		rom(0x280a, "braille_dots_24");
		rom(0x280b, "braille_dots_124");
		rom(0x280c, "braille_dots_34");
		rom(0x280d, "braille_dots_134");
		rom(0x280e, "braille_dots_234");
		rom(0x280f, "braille_dots_1234");
		rom(0x2810, "braille_dots_5");
		rom(0x2811, "braille_dots_15");
		rom(0x2812, "braille_dots_25");
		rom(0x2813, "braille_dots_125");
		rom(0x2814, "braille_dots_35");
		rom(0x2815, "braille_dots_135");
		rom(0x2816, "braille_dots_235");
		rom(0x2817, "braille_dots_1235");
		rom(0x2818, "braille_dots_45");
		rom(0x2819, "braille_dots_145");
		rom(0x281a, "braille_dots_245");
		rom(0x281b, "braille_dots_1245");
		rom(0x281c, "braille_dots_345");
		rom(0x281d, "braille_dots_1345");
		rom(0x281e, "braille_dots_2345");
		rom(0x281f, "braille_dots_12345");
		rom(0x2820, "braille_dots_6");
		rom(0x2821, "braille_dots_16");
		rom(0x2822, "braille_dots_26");
		rom(0x2823, "braille_dots_126");
		rom(0x2824, "braille_dots_36");
		rom(0x2825, "braille_dots_136");
		rom(0x2826, "braille_dots_236");
		rom(0x2827, "braille_dots_1236");
		rom(0x2828, "braille_dots_46");
		rom(0x2829, "braille_dots_146");
		rom(0x282a, "braille_dots_246");
		rom(0x282b, "braille_dots_1246");
		rom(0x282c, "braille_dots_346");
		rom(0x282d, "braille_dots_1346");
		rom(0x282e, "braille_dots_2346");
		rom(0x282f, "braille_dots_12346");
		rom(0x2830, "braille_dots_56");
		rom(0x2831, "braille_dots_156");
		rom(0x2832, "braille_dots_256");
		rom(0x2833, "braille_dots_1256");
		rom(0x2834, "braille_dots_356");
		rom(0x2835, "braille_dots_1356");
		rom(0x2836, "braille_dots_2356");
		rom(0x2837, "braille_dots_12356");
		rom(0x2838, "braille_dots_456");
		rom(0x2839, "braille_dots_1456");
		rom(0x283a, "braille_dots_2456");
		rom(0x283b, "braille_dots_12456");
		rom(0x283c, "braille_dots_3456");
		rom(0x283d, "braille_dots_13456");
		rom(0x283e, "braille_dots_23456");
		rom(0x283f, "braille_dots_123456");
		rom(0x2840, "braille_dots_7");
		rom(0x2841, "braille_dots_17");
		rom(0x2842, "braille_dots_27");
		rom(0x2843, "braille_dots_127");
		rom(0x2844, "braille_dots_37");
		rom(0x2845, "braille_dots_137");
		rom(0x2846, "braille_dots_237");
		rom(0x2847, "braille_dots_1237");
		rom(0x2848, "braille_dots_47");
		rom(0x2849, "braille_dots_147");
		rom(0x284a, "braille_dots_247");
		rom(0x284b, "braille_dots_1247");
		rom(0x284c, "braille_dots_347");
		rom(0x284d, "braille_dots_1347");
		rom(0x284e, "braille_dots_2347");
		rom(0x284f, "braille_dots_12347");
		rom(0x2850, "braille_dots_57");
		rom(0x2851, "braille_dots_157");
		rom(0x2852, "braille_dots_257");
		rom(0x2853, "braille_dots_1257");
		rom(0x2854, "braille_dots_357");
		rom(0x2855, "braille_dots_1357");
		rom(0x2856, "braille_dots_2357");
		rom(0x2857, "braille_dots_12357");
		rom(0x2858, "braille_dots_457");
		rom(0x2859, "braille_dots_1457");
		rom(0x285a, "braille_dots_2457");
		rom(0x285b, "braille_dots_12457");
		rom(0x285c, "braille_dots_3457");
		rom(0x285d, "braille_dots_13457");
		rom(0x285e, "braille_dots_23457");
		rom(0x285f, "braille_dots_123457");
		rom(0x2860, "braille_dots_67");
		rom(0x2861, "braille_dots_167");
		rom(0x2862, "braille_dots_267");
		rom(0x2863, "braille_dots_1267");
		rom(0x2864, "braille_dots_367");
		rom(0x2865, "braille_dots_1367");
		rom(0x2866, "braille_dots_2367");
		rom(0x2867, "braille_dots_12367");
		rom(0x2868, "braille_dots_467");
		rom(0x2869, "braille_dots_1467");
		rom(0x286a, "braille_dots_2467");
		rom(0x286b, "braille_dots_12467");
		rom(0x286c, "braille_dots_3467");
		rom(0x286d, "braille_dots_13467");
		rom(0x286e, "braille_dots_23467");
		rom(0x286f, "braille_dots_123467");
		rom(0x2870, "braille_dots_567");
		rom(0x2871, "braille_dots_1567");
		rom(0x2872, "braille_dots_2567");
		rom(0x2873, "braille_dots_12567");
		rom(0x2874, "braille_dots_3567");
		rom(0x2875, "braille_dots_13567");
		rom(0x2876, "braille_dots_23567");
		rom(0x2877, "braille_dots_123567");
		rom(0x2878, "braille_dots_4567");
		rom(0x2879, "braille_dots_14567");
		rom(0x287a, "braille_dots_24567");
		rom(0x287b, "braille_dots_124567");
		rom(0x287c, "braille_dots_34567");
		rom(0x287d, "braille_dots_134567");
		rom(0x287e, "braille_dots_234567");
		rom(0x287f, "braille_dots_1234567");
		rom(0x2880, "braille_dots_8");
		rom(0x2881, "braille_dots_18");
		rom(0x2882, "braille_dots_28");
		rom(0x2883, "braille_dots_128");
		rom(0x2884, "braille_dots_38");
		rom(0x2885, "braille_dots_138");
		rom(0x2886, "braille_dots_238");
		rom(0x2887, "braille_dots_1238");
		rom(0x2888, "braille_dots_48");
		rom(0x2889, "braille_dots_148");
		rom(0x288a, "braille_dots_248");
		rom(0x288b, "braille_dots_1248");
		rom(0x288c, "braille_dots_348");
		rom(0x288d, "braille_dots_1348");
		rom(0x288e, "braille_dots_2348");
		rom(0x288f, "braille_dots_12348");
		rom(0x2890, "braille_dots_58");
		rom(0x2891, "braille_dots_158");
		rom(0x2892, "braille_dots_258");
		rom(0x2893, "braille_dots_1258");
		rom(0x2894, "braille_dots_358");
		rom(0x2895, "braille_dots_1358");
		rom(0x2896, "braille_dots_2358");
		rom(0x2897, "braille_dots_12358");
		rom(0x2898, "braille_dots_458");
		rom(0x2899, "braille_dots_1458");
		rom(0x289a, "braille_dots_2458");
		rom(0x289b, "braille_dots_12458");
		rom(0x289c, "braille_dots_3458");
		rom(0x289d, "braille_dots_13458");
		rom(0x289e, "braille_dots_23458");
		rom(0x289f, "braille_dots_123458");
		rom(0x28a0, "braille_dots_68");
		rom(0x28a1, "braille_dots_168");
		rom(0x28a2, "braille_dots_268");
		rom(0x28a3, "braille_dots_1268");
		rom(0x28a4, "braille_dots_368");
		rom(0x28a5, "braille_dots_1368");
		rom(0x28a6, "braille_dots_2368");
		rom(0x28a7, "braille_dots_12368");
		rom(0x28a8, "braille_dots_468");
		rom(0x28a9, "braille_dots_1468");
		rom(0x28aa, "braille_dots_2468");
		rom(0x28ab, "braille_dots_12468");
		rom(0x28ac, "braille_dots_3468");
		rom(0x28ad, "braille_dots_13468");
		rom(0x28ae, "braille_dots_23468");
		rom(0x28af, "braille_dots_123468");
		rom(0x28b0, "braille_dots_568");
		rom(0x28b1, "braille_dots_1568");
		rom(0x28b2, "braille_dots_2568");
		rom(0x28b3, "braille_dots_12568");
		rom(0x28b4, "braille_dots_3568");
		rom(0x28b5, "braille_dots_13568");
		rom(0x28b6, "braille_dots_23568");
		rom(0x28b7, "braille_dots_123568");
		rom(0x28b8, "braille_dots_4568");
		rom(0x28b9, "braille_dots_14568");
		rom(0x28ba, "braille_dots_24568");
		rom(0x28bb, "braille_dots_124568");
		rom(0x28bc, "braille_dots_34568");
		rom(0x28bd, "braille_dots_134568");
		rom(0x28be, "braille_dots_234568");
		rom(0x28bf, "braille_dots_1234568");
		rom(0x28c0, "braille_dots_78");
		rom(0x28c1, "braille_dots_178");
		rom(0x28c2, "braille_dots_278");
		rom(0x28c3, "braille_dots_1278");
		rom(0x28c4, "braille_dots_378");
		rom(0x28c5, "braille_dots_1378");
		rom(0x28c6, "braille_dots_2378");
		rom(0x28c7, "braille_dots_12378");
		rom(0x28c8, "braille_dots_478");
		rom(0x28c9, "braille_dots_1478");
		rom(0x28ca, "braille_dots_2478");
		rom(0x28cb, "braille_dots_12478");
		rom(0x28cc, "braille_dots_3478");
		rom(0x28cd, "braille_dots_13478");
		rom(0x28ce, "braille_dots_23478");
		rom(0x28cf, "braille_dots_123478");
		rom(0x28d0, "braille_dots_578");
		rom(0x28d1, "braille_dots_1578");
		rom(0x28d2, "braille_dots_2578");
		rom(0x28d3, "braille_dots_12578");
		rom(0x28d4, "braille_dots_3578");
		rom(0x28d5, "braille_dots_13578");
		rom(0x28d6, "braille_dots_23578");
		rom(0x28d7, "braille_dots_123578");
		rom(0x28d8, "braille_dots_4578");
		rom(0x28d9, "braille_dots_14578");
		rom(0x28da, "braille_dots_24578");
		rom(0x28db, "braille_dots_124578");
		rom(0x28dc, "braille_dots_34578");
		rom(0x28dd, "braille_dots_134578");
		rom(0x28de, "braille_dots_234578");
		rom(0x28df, "braille_dots_1234578");
		rom(0x28e0, "braille_dots_678");
		rom(0x28e1, "braille_dots_1678");
		rom(0x28e2, "braille_dots_2678");
		rom(0x28e3, "braille_dots_12678");
		rom(0x28e4, "braille_dots_3678");
		rom(0x28e5, "braille_dots_13678");
		rom(0x28e6, "braille_dots_23678");
		rom(0x28e7, "braille_dots_123678");
		rom(0x28e8, "braille_dots_4678");
		rom(0x28e9, "braille_dots_14678");
		rom(0x28ea, "braille_dots_24678");
		rom(0x28eb, "braille_dots_124678");
		rom(0x28ec, "braille_dots_34678");
		rom(0x28ed, "braille_dots_134678");
		rom(0x28ee, "braille_dots_234678");
		rom(0x28ef, "braille_dots_1234678");
		rom(0x28f0, "braille_dots_5678");
		rom(0x28f1, "braille_dots_15678");
		rom(0x28f2, "braille_dots_25678");
		rom(0x28f3, "braille_dots_125678");
		rom(0x28f4, "braille_dots_35678");
		rom(0x28f5, "braille_dots_135678");
		rom(0x28f6, "braille_dots_235678");
		rom(0x28f7, "braille_dots_1235678");
		rom(0x28f8, "braille_dots_45678");
		rom(0x28f9, "braille_dots_145678");
		rom(0x28fa, "braille_dots_245678");
		rom(0x28fb, "braille_dots_1245678");
		rom(0x28fc, "braille_dots_345678");
		rom(0x28fd, "braille_dots_1345678");
		rom(0x28fe, "braille_dots_2345678");
		rom(0x28ff, "braille_dots_12345678");
		
		// Sinhala
		m(0x0D82, "Sinh_ng");
		m(0x0D83, "Sinh_h2");
		m(0x0D85, "Sinh_a");
		m(0x0D86, "Sinh_aa");
		m(0x0D87, "Sinh_ae");
		m(0x0D88, "Sinh_aee");
		m(0x0D89, "Sinh_i");
		m(0x0D8A, "Sinh_ii");
		m(0x0D8B, "Sinh_u");
		m(0x0D8C, "Sinh_uu");
		m(0x0D8D, "Sinh_ri");
		m(0x0D8E, "Sinh_rii");
		m(0x0D8F, "Sinh_lu");
		m(0x0D90, "Sinh_luu");
		m(0x0D91, "Sinh_e");
		m(0x0D92, "Sinh_ee");
		m(0x0D93, "Sinh_ai");
		m(0x0D94, "Sinh_o");
		m(0x0D95, "Sinh_oo");
		m(0x0D96, "Sinh_au");
		m(0x0D9A, "Sinh_ka");
		m(0x0D9B, "Sinh_kha");
		m(0x0D9C, "Sinh_ga");
		m(0x0D9D, "Sinh_gha");
		m(0x0D9E, "Sinh_ng2");
		m(0x0D9F, "Sinh_nga");
		m(0x0DA0, "Sinh_ca");
		m(0x0DA1, "Sinh_cha");
		m(0x0DA2, "Sinh_ja");
		m(0x0DA3, "Sinh_jha");
		m(0x0DA4, "Sinh_nya");
		m(0x0DA5, "Sinh_jnya");
		m(0x0DA6, "Sinh_nja");
		m(0x0DA7, "Sinh_tta");
		m(0x0DA8, "Sinh_ttha");
		m(0x0DA9, "Sinh_dda");
		m(0x0DAA, "Sinh_ddha");
		m(0x0DAB, "Sinh_nna");
		m(0x0DAC, "Sinh_ndda");
		m(0x0DAD, "Sinh_tha");
		m(0x0DAE, "Sinh_thha");
		m(0x0DAF, "Sinh_dha");
		m(0x0DB0, "Sinh_dhha");
		m(0x0DB1, "Sinh_na");
		m(0x0DB3, "Sinh_ndha");
		m(0x0DB4, "Sinh_pa");
		m(0x0DB5, "Sinh_pha");
		m(0x0DB6, "Sinh_ba");
		m(0x0DB7, "Sinh_bha");
		m(0x0DB8, "Sinh_ma");
		m(0x0DB9, "Sinh_mba");
		m(0x0DBA, "Sinh_ya");
		m(0x0DBB, "Sinh_ra");
		m(0x0DBD, "Sinh_la");
		m(0x0DC0, "Sinh_va");
		m(0x0DC1, "Sinh_sha");
		m(0x0DC2, "Sinh_ssha");
		m(0x0DC3, "Sinh_sa");
		m(0x0DC4, "Sinh_ha");
		m(0x0DC5, "Sinh_lla");
		m(0x0DC6, "Sinh_fa");
		m(0x0DCA, "Sinh_al");
		m(0x0DCF, "Sinh_aa2");
		m(0x0DD0, "Sinh_ae2");
		m(0x0DD1, "Sinh_aee2");
		m(0x0DD2, "Sinh_i2");
		m(0x0DD3, "Sinh_ii2");
		m(0x0DD4, "Sinh_u2");
		m(0x0DD6, "Sinh_uu2");
		m(0x0DD8, "Sinh_ru2");
		m(0x0DD9, "Sinh_e2");
		m(0x0DDA, "Sinh_ee2");
		m(0x0DDB, "Sinh_ai2");
		m(0x0DDC, "Sinh_o2");
		m(0x0DDD, "Sinh_oo2");
		m(0x0DDE, "Sinh_au2");
		m(0x0DDF, "Sinh_lu2");
		m(0x0DF2, "Sinh_ruu2");
		m(0x0DF3, "Sinh_luu2");
		m(0x0DF4, "Sinh_kunddaliya");
	}
	
	private void m(int u, String n) {
		if (!u2n.containsKey(u)) u2n.put(u, n);
		if (!n2u.containsKey(n)) n2u.put(n, u);
	}
	
	private void rom(int u, String n) {
		if (!n2u.containsKey(n)) n2u.put(n, u);
	}
	
	public String getKeySym(int u) {
		if (u2n.containsKey(u)) return u2n.get(u);
		return getUKeySym(u);
	}
	
	public String getUKeySym(int u) {
		String s = Integer.toHexString(u).toUpperCase();
		while (s.length() < 4) s = "0" + s;
		return "U" + s;
	}
	
	public int resolveKeySym(String n) {
		if (n2u.containsKey(n)) return n2u.get(n);
		if (!n.startsWith("U")) return -1;
		try { return Integer.parseInt(n.substring(1), 16); }
		catch (NumberFormatException nfe) { return -1; }
	}
}
