/* $Id: tstRTBigNum-uint128-div-test-data.h $ */
/** @file
 * IPRT - 128-bit division test data.
 */

/*
 * Copyright (C) 2006-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * The contents of this file may alternatively be used under the terms
 * of the Common Development and Distribution License Version 1.0
 * (CDDL), a copy of it is provided in the "COPYING.CDDL" file included
 * in the VirtualBox distribution, in which case the provisions of the
 * CDDL are applicable instead of those of the GPL.
 *
 * You may elect to license modified versions of this file under the
 * terms and conditions of either the GPL or the CDDL or both.
 *
 * SPDX-License-Identifier: GPL-3.0-only OR CDDL-1.0
 */
    { /* i=0; 30 / 30 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000a2f6b94), RTUINT128_INIT_C(0x0000000000000000, 0x000000003501a176),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000000000a2f6b94)
    },
    { /* i=1; 99 / 99 */
        RTUINT128_INIT_C(0x000000001f9d79d1, 0x152dedb924f4f733), RTUINT128_INIT_C(0x000000008694ce9e, 0xe0893be1f05c4054),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000000001f9d79d1, 0x152dedb924f4f733)
    },
    { /* i=2; 48 / 48 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000fa026eb8a356), RTUINT128_INIT_C(0x0000000000000000, 0x0000a1fd404839a1),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x0000000000000000, 0x000058052e7069b5)
    },
    { /* i=3; 96 / 96 */
        RTUINT128_INIT_C(0x00000000b9f24580, 0xcd4512c15a25398d), RTUINT128_INIT_C(0x0000000043a403d9, 0x54a4314b807a4573),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002), RTUINT128_INIT_C(0x0000000032aa3dce, 0x23fcb02a5930aea7)
    },
    { /* i=4; 102 / 102 */
        RTUINT128_INIT_C(0x000000251ce8fe85, 0x580083920b6a28ce), RTUINT128_INIT_C(0x0000000301f41b4d, 0x7ebab8fb30b4dc0a),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000c), RTUINT128_INIT_C(0x000000010577b6e3, 0x673fd7cbc2efd856)
    },
    { /* i=5; 22 / 22 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000002fa4aa), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000274ddb),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000856cf)
    },
    { /* i=6; 125 / 125 */
        RTUINT128_INIT_C(0x01700eb99bd71932, 0x7bac612d6a2e8904), RTUINT128_INIT_C(0x06c58e859b34985d, 0x4a7954ea8e05a5bb),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x01700eb99bd71932, 0x7bac612d6a2e8904)
    },
    { /* i=7; 109 / 109 */
        RTUINT128_INIT_C(0x000016f640fe18ba, 0x2606af001ec87edd), RTUINT128_INIT_C(0x000008ae4862f998, 0x43852254c06ea010),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002), RTUINT128_INIT_C(0x00000599b0382589, 0x9efc6a569deb3ebd)
    },
    { /* i=8; 20 / 20 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000d4ad7), RTUINT128_INIT_C(0x0000000000000000, 0x000000000006eca3),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000065e34)
    },
    { /* i=9; 85 / 83 */
        RTUINT128_INIT_C(0x00000000001ac23a, 0x4cc49e865366f30d), RTUINT128_INIT_C(0x0000000000001e75, 0x375bdd8ba4051dbf),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000e0), RTUINT128_INIT_C(0x0000000000001ba9, 0xdc62c456ceecebed)
    },
    { /* i=10; 87 / 76 */
        RTUINT128_INIT_C(0x00000000007baf91, 0x1647ebf886e95926), RTUINT128_INIT_C(0x00000000000000b7, 0xce6a76494015aa2a),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000ac44), RTUINT128_INIT_C(0x000000000000000e, 0xba874974f2d3edfe)
    },
    { /* i=11; 120 / 28 */
        RTUINT128_INIT_C(0x0091ea14a6dbcf27, 0x6fd76d317e5f7039), RTUINT128_INIT_C(0x0000000000000000, 0x000000000cae1f64),
        RTUINT128_INIT_C(0x000000000b81dde2, 0x86493851d145f224), RTUINT128_INIT_C(0x0000000000000000, 0x0000000002427e29)
    },
    { /* i=12; 57 / 100 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0127de1a25b46c4d), RTUINT128_INIT_C(0x00000003d4646a43, 0x7de562db58c48078),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0127de1a25b46c4d)
    },
    { /* i=13; 127 / 120 */
        RTUINT128_INIT_C(0x3413daee95f95613, 0x63e56dc8b9882278), RTUINT128_INIT_C(0x00849017d08c927e, 0xacb55eaaf1671adc),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000064), RTUINT128_INIT_C(0x004b91a11f101c97, 0xed0c73026d41a488)
    },
    { /* i=14; 112 / 54 */
        RTUINT128_INIT_C(0x0000235c0e4f3229, 0x0c1f549b7e46666c), RTUINT128_INIT_C(0x0000000000000000, 0x00063dce6a7414a1),
        RTUINT128_INIT_C(0x0000000000000000, 0x05aa5141ad9c5df7), RTUINT128_INIT_C(0x0000000000000000, 0x000237383dac0215)
    },
    { /* i=15; 85 / 37 */
        RTUINT128_INIT_C(0x00000000000f2c20, 0xbfb41db2ace91ae8), RTUINT128_INIT_C(0x0000000000000000, 0x0000001204a2f46f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000d791673c6ebc), RTUINT128_INIT_C(0x0000000000000000, 0x000000104d31e764)
    },
    { /* i=16; 103 / 127 */
        RTUINT128_INIT_C(0x0000005a7d4aad8d, 0x99b65ce8070506cc), RTUINT128_INIT_C(0x23f4eb8b54ffb7d6, 0x84b772579051ae12),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000005a7d4aad8d, 0x99b65ce8070506cc)
    },
    { /* i=17; 121 / 23 */
        RTUINT128_INIT_C(0x01efa481959d5208, 0xcfe07716f432c914), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000dc73f),
        RTUINT128_INIT_C(0x00000023f901c39f, 0xc49b49362ded64ba), RTUINT128_INIT_C(0x0000000000000000, 0x000000000008694e)
    },
    { /* i=18; 89 / 10 */
        RTUINT128_INIT_C(0x0000000001aff8ca, 0x3e69bc811ea4b48a), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000011a),
        RTUINT128_INIT_C(0x0000000000018825, 0x077bd60075370d59), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000080)
    },
    { /* i=19; 89 / 33 */
        RTUINT128_INIT_C(0x000000000104f317, 0x120ccbc67aea1363), RTUINT128_INIT_C(0x0000000000000000, 0x0000000015244c65),
        RTUINT128_INIT_C(0x0000000000000000, 0x0c57c3d69fbb28f5), RTUINT128_INIT_C(0x0000000000000000, 0x000000000a762eba)
    },
    { /* i=20; 115 / 110 */
        RTUINT128_INIT_C(0x000372c165049c14, 0xcec2e5d843952cf8), RTUINT128_INIT_C(0x00000bd26c9eca02, 0xb36285de97e29d8b),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000004a), RTUINT128_INIT_C(0x000007edff1e374c, 0xf44833805c13a2ca)
    },
    { /* i=21; 127 / 7 */
        RTUINT128_INIT_C(0x3535b57aca5d2556, 0x450c54b51436f395), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000057),
        RTUINT128_INIT_C(0x009c924516ec7912, 0xa59344a6dcec08af), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000001c)
    },
    { /* i=22; 114 / 93 */
        RTUINT128_INIT_C(0x0002d15bd939e5d7, 0x18464bfc09876ce0), RTUINT128_INIT_C(0x00000000051e8e59, 0xcfc6a9b5665c7e98),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000008ce873), RTUINT128_INIT_C(0x000000000260ee8d, 0xe907b0260020ce98)
    },
    { /* i=23; 115 / 121 */
        RTUINT128_INIT_C(0x00063ebc2c417277, 0x44c103d69f19f753), RTUINT128_INIT_C(0x00db2a026c231778, 0x0fd1cabdee74b0fe),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00063ebc2c417277, 0x44c103d69f19f753)
    },
    { /* i=24; 116 / 120 */
        RTUINT128_INIT_C(0x0003cb916149e7cd, 0xb032bb7b3d42ee01), RTUINT128_INIT_C(0x008353ed2e1b4fc7, 0x52a905c2cc29dcc7),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0003cb916149e7cd, 0xb032bb7b3d42ee01)
    },
    { /* i=25; 115 / 94 */
        RTUINT128_INIT_C(0x0003e1827032b5fa, 0xab5102c3a832ad0b), RTUINT128_INIT_C(0x00000000256e2957, 0x5866a77adb46f403),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000001a8afc), RTUINT128_INIT_C(0x000000000299f3eb, 0x4d81a66ac682dc17)
    },
    { /* i=26; 127 / 2 */
        RTUINT128_INIT_C(0x0ce41c12a736102d, 0xae9e2972fa8f3f06), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002),
        RTUINT128_INIT_C(0x06720e09539b0816, 0xd74f14b97d479f83), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=27; 115 / 89 */
        RTUINT128_INIT_C(0x0007b3038e10ef18, 0x5f79bb3e44df4c89), RTUINT128_INIT_C(0x0000000000ec1eec, 0x12eacfed9679212e),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000858f489), RTUINT128_INIT_C(0x00000000007d8983, 0x8b427f00729cb2eb)
    },
    { /* i=28; 114 / 114 */
        RTUINT128_INIT_C(0x00003623ea932cc7, 0xe9130886ecbae7fd), RTUINT128_INIT_C(0x000057251527d662, 0x4879855dfdb2b5cb),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00003623ea932cc7, 0xe9130886ecbae7fd)
    },
    { /* i=29; 113 / 72 */
        RTUINT128_INIT_C(0x000046f3afdd2b23, 0x6a939fa147a8a152), RTUINT128_INIT_C(0x000000000000005b, 0x5029b44e473a94db),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000c6ea9def81), RTUINT128_INIT_C(0x000000000000005a, 0xddce535039dc29f7)
    },
    { /* i=30; 126 / 100 */
        RTUINT128_INIT_C(0x32e8dcdea832c0b2, 0x9c6085d5835f3bb6), RTUINT128_INIT_C(0x0000000c2ffe45ae, 0xcacbcd8e95cd380e),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000042d5d8b), RTUINT128_INIT_C(0x000000083eed9615, 0x19a3930b8d1eb61c)
    },
    { /* i=31; 89 / 41 */
        RTUINT128_INIT_C(0x0000000000f1396a, 0x8ffc94c49dd1d756), RTUINT128_INIT_C(0x0000000000000000, 0x000001914b84b61a),
        RTUINT128_INIT_C(0x0000000000000000, 0x000099e2a598083b), RTUINT128_INIT_C(0x0000000000000000, 0x000000cd2f1b0f58)
    },
    { /* i=32; 1 / 89 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x0000000001fcfdc3, 0x577b89f4676aa5e8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001)
    },
    { /* i=33; 122 / 4 */
        RTUINT128_INIT_C(0x02c922866187e504, 0xd7ea412a4a457512), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000c),
        RTUINT128_INIT_C(0x003b6d8b32cb5315, 0xbca8dac38630746c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002)
    },
    { /* i=34; 94 / 63 */
        RTUINT128_INIT_C(0x0000000022f64d72, 0xb9c0086f06b24dc7), RTUINT128_INIT_C(0x0000000000000000, 0x20f49d4582ed3800),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000010f965a5d), RTUINT128_INIT_C(0x0000000000000000, 0x0544a0e040d4f5c7)
    },
    { /* i=35; 121 / 56 */
        RTUINT128_INIT_C(0x00f4d8ee92b33cd7, 0xcd681282a89b63e8), RTUINT128_INIT_C(0x0000000000000000, 0x00969b5c1e606296),
        RTUINT128_INIT_C(0x0000000000000001, 0xa0306590181b8a6a), RTUINT128_INIT_C(0x0000000000000000, 0x007f3635a9bbb5cc)
    },
    { /* i=36; 121 / 64 */
        RTUINT128_INIT_C(0x01cde28dd5446923, 0x52bfb82e627c5f00), RTUINT128_INIT_C(0x0000000000000000, 0x95ab7df6f7b286d4),
        RTUINT128_INIT_C(0x0000000000000000, 0x031605b69cf3245b), RTUINT128_INIT_C(0x0000000000000000, 0x48ef4f380fd4a1a4)
    },
    { /* i=37; 127 / 94 */
        RTUINT128_INIT_C(0x2a1bfe968343314b, 0x0dc003819accb065), RTUINT128_INIT_C(0x0000000014e626c1, 0x4243b81a86c4e4a3),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000203d02c6a), RTUINT128_INIT_C(0x0000000007f9db7f, 0x0765a16e488a00e7)
    },
    { /* i=38; 125 / 114 */
        RTUINT128_INIT_C(0x165e570de31ed113, 0xad9971e6a402ebed), RTUINT128_INIT_C(0x0000e51469759b98, 0x22c8f9872fed194b),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000018ff), RTUINT128_INIT_C(0x00003dd5d0629146, 0x300437bfac77b238)
    },
    { /* i=39; 115 / 53 */
        RTUINT128_INIT_C(0x000791dfd98ab2b2, 0x6ae9a36291fa1d39), RTUINT128_INIT_C(0x0000000000000000, 0x001d4edd8c0adfe5),
        RTUINT128_INIT_C(0x0000000000000000, 0x421ef01ee7d41cef), RTUINT128_INIT_C(0x0000000000000000, 0x0014115c96b20a6e)
    },
    { /* i=40; 125 / 54 */
        RTUINT128_INIT_C(0x16694ae4301eec57, 0x801e66e280a285f0), RTUINT128_INIT_C(0x0000000000000000, 0x003915e6e3d18796),
        RTUINT128_INIT_C(0x0000000000000064, 0x80df19708dc5cf58), RTUINT128_INIT_C(0x0000000000000000, 0x000e7dc2cf8ba060)
    },
    { /* i=41; 36 / 8 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000009648b478a), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000ce),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000bac2bd7), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000088)
    },
    { /* i=42; 119 / 81 */
        RTUINT128_INIT_C(0x007322517bc76124, 0x11d51e2be5e700a4), RTUINT128_INIT_C(0x000000000000d845, 0x7997a2d67e9a6a5a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000008848b0c85a), RTUINT128_INIT_C(0x00000000000051b9, 0x523353f852a74d00)
    },
    { /* i=43; 114 / 80 */
        RTUINT128_INIT_C(0x0002c130f7d8a768, 0xde4434b180e209c9), RTUINT128_INIT_C(0x0000000000003633, 0x5b910d85b918d60e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000d02c14257), RTUINT128_INIT_C(0x0000000000002418, 0xb6f6866bb5b3af07)
    },
    { /* i=44; 122 / 85 */
        RTUINT128_INIT_C(0x03477dc50beae1a2, 0xc63633c7bdf11e95), RTUINT128_INIT_C(0x000000000006027a, 0xff49cfb31de725d8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000008bb08bc0c7), RTUINT128_INIT_C(0x000000000003926e, 0xd0bdb6501698b3ad)
    },
    { /* i=45; 98 / 30 */
        RTUINT128_INIT_C(0x00000000730e0559, 0xea132754d663b808), RTUINT128_INIT_C(0x0000000000000000, 0x00000000256a6e04),
        RTUINT128_INIT_C(0x0000000000000003, 0x1335973e03f5a5b1), RTUINT128_INIT_C(0x0000000000000000, 0x0000000009111344)
    },
    { /* i=46; 117 / 104 */
        RTUINT128_INIT_C(0x000ad3732d2e5cc5, 0x6ef0731a621f898e), RTUINT128_INIT_C(0x000000138c3e55ae, 0x2f096b2eb20187a4),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000008dc7), RTUINT128_INIT_C(0x00000002d388d276, 0xae9569c32b39c512)
    },
    { /* i=47; 23 / 22 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000004cf433), RTUINT128_INIT_C(0x0000000000000000, 0x00000000001eba46),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000f7fa7)
    },
    { /* i=48; 46 / 28 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00001996980424c7), RTUINT128_INIT_C(0x0000000000000000, 0x0000000005e5c90e),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000456b8), RTUINT128_INIT_C(0x0000000000000000, 0x000000000518eeb7)
    },
    { /* i=49; 15 / 127 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000007bed), RTUINT128_INIT_C(0x5ae0442322a680c1, 0x714cf62bbaad17ea),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000007bed)
    },
    { /* i=50; 122 / 34 */
        RTUINT128_INIT_C(0x01e2db58ca5858dc, 0x4c4d4f4cb1ca4ae5), RTUINT128_INIT_C(0x0000000000000000, 0x00000001eb0bf9f8),
        RTUINT128_INIT_C(0x0000000000fbbaf3, 0xfc6e929f7e8c9dcd), RTUINT128_INIT_C(0x0000000000000000, 0x000000005d46074d)
    },
    { /* i=51; 67 / 12 */
        RTUINT128_INIT_C(0x0000000000000007, 0x424cd53dc2d2aad6), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000009ca),
        RTUINT128_INIT_C(0x0000000000000000, 0x00bdd596b3f8eee7), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000990)
    },
    { /* i=52; 124 / 83 */
        RTUINT128_INIT_C(0x02afebf4c397a9b2, 0x236a9e7cdbcadd43), RTUINT128_INIT_C(0x0000000000007af6, 0x4a2cbdf581882c74),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000059836b2d53c), RTUINT128_INIT_C(0x00000000000053c7, 0x1721613cd23bee13)
    },
    { /* i=53; 37 / 24 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000001bb9c5cfbf), RTUINT128_INIT_C(0x0000000000000000, 0x000000000007c42e),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000391ea), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000046fb3)
    },
    { /* i=54; 20 / 9 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000065aa1), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000001f3),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000342), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000fb)
    },
    { /* i=55; 123 / 104 */
        RTUINT128_INIT_C(0x004a1d446a0ba544, 0x1382ac20f74c3dc4), RTUINT128_INIT_C(0x0000008d3771266a, 0xb86dce0a63a6839c),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000865b), RTUINT128_INIT_C(0x0000000c7ab720cb, 0x0aa0fe466237cd50)
    },
    { /* i=56; 113 / 91 */
        RTUINT128_INIT_C(0x000113b675712a8a, 0x7fc16fb56f18f317), RTUINT128_INIT_C(0x0000000000ecda8d, 0xcf2fab3e43b90282),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000012a000d), RTUINT128_INIT_C(0x000000000056e3d9, 0xa3dae82f135fd27d)
    },
    { /* i=57; 128 / 115 */
        RTUINT128_INIT_C(0x6b1b7921dd7df4ec, 0x303144f832f9f8cb), RTUINT128_INIT_C(0x000349d0bc3da2dc, 0x3f4f4114e008e90c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000002092), RTUINT128_INIT_C(0x0001488ecdfb8b66, 0x2cdb8b0f50c38ff3)
    },
    { /* i=58; 122 / 77 */
        RTUINT128_INIT_C(0x00f1afe32f8ec487, 0x800ad63d31c5bfd5), RTUINT128_INIT_C(0x0000000000000c61, 0x222c977907e28480),
        RTUINT128_INIT_C(0x0000000000000000, 0x00001385f5d22476), RTUINT128_INIT_C(0x00000000000003f1, 0x7bd7683883baacd5)
    },
    { /* i=59; 86 / 19 */
        RTUINT128_INIT_C(0x00000000003cf8b7, 0x27846e326ddf25b9), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001c5f),
        RTUINT128_INIT_C(0x0000000000000226, 0x29a1df846e329c41), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000d9a)
    },
    { /* i=60; 95 / 40 */
        RTUINT128_INIT_C(0x0000000070b43969, 0x30f17cb48db14ef6), RTUINT128_INIT_C(0x0000000000000000, 0x000000eb4f320400),
        RTUINT128_INIT_C(0x0000000000000000, 0x007a9d2fe030f833), RTUINT128_INIT_C(0x0000000000000000, 0x0000003a92da82f6)
    },
    { /* i=61; 111 / 90 */
        RTUINT128_INIT_C(0x000048d1038866ad, 0x128c3e87d86a75fc), RTUINT128_INIT_C(0x000000000004d156, 0x0fb5250b9ed63ffa),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000f1d42ce), RTUINT128_INIT_C(0x0000000000045eae, 0xda9be435e63286d0)
    },
    { /* i=62; 123 / 82 */
        RTUINT128_INIT_C(0x0725659f35534451, 0xd494a71a81dcc2e4), RTUINT128_INIT_C(0x0000000000033b28, 0xa3ff5cb13c1240ea),
        RTUINT128_INIT_C(0x0000000000000000, 0x000002362f9714f0), RTUINT128_INIT_C(0x00000000000113e9, 0x1b029a3583a79f84)
    },
    { /* i=63; 124 / 67 */
        RTUINT128_INIT_C(0x0605ff621940a36a, 0x72ee68f1d09bab14), RTUINT128_INIT_C(0x0000000000000000, 0x91debe084d371cb7),
        RTUINT128_INIT_C(0x0000000000000000, 0x0a922f41d0f1a793), RTUINT128_INIT_C(0x0000000000000000, 0x7de08420cdf3ccff)
    },
    { /* i=64; 40 / 84 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000a2b21c37e5), RTUINT128_INIT_C(0x000000000008e26b, 0x0b5e173f944a23e4),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000000a2b21c37e5)
    },
    { /* i=65; 114 / 123 */
        RTUINT128_INIT_C(0x0003810ec1177ad9, 0x090f0647e65ae44e), RTUINT128_INIT_C(0x052577cc1e86ae58, 0x8b42fdc64816183e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0003810ec1177ad9, 0x090f0647e65ae44e)
    },
    { /* i=66; 118 / 125 */
        RTUINT128_INIT_C(0x002975f2038a9d6d, 0x648b712abaebb98e), RTUINT128_INIT_C(0x17612e38c9248cef, 0x515e897775638604),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x002975f2038a9d6d, 0x648b712abaebb98e)
    },
    { /* i=67; 33 / 27 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000087f3ee87), RTUINT128_INIT_C(0x0000000000000000, 0x00000000068eca77),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000014), RTUINT128_INIT_C(0x0000000000000000, 0x0000000004cc1d3b)
    },
    { /* i=68; 107 / 58 */
        RTUINT128_INIT_C(0x00000371db73a2b4, 0x151755b4b1154a17), RTUINT128_INIT_C(0x0000000000000000, 0x014cb0341a7157da),
        RTUINT128_INIT_C(0x0000000000000000, 0x0002a69459168a03), RTUINT128_INIT_C(0x0000000000000000, 0x00575b86f1a9be89)
    },
    { /* i=69; 93 / 23 */
        RTUINT128_INIT_C(0x000000001a4f7c8d, 0x4eabf7638d7095ea), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000098c4a),
        RTUINT128_INIT_C(0x00000000000002c1, 0x6f190df9eac07de2), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000029a96)
    },
    { /* i=70; 71 / 66 */
        RTUINT128_INIT_C(0x0000000000000052, 0x4114d8f0bb0dfa4b), RTUINT128_INIT_C(0x0000000000000001, 0x4de04ed593ba0a9b),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000003f), RTUINT128_INIT_C(0x0000000000000000, 0x16e1726160455e26)
    },
    { /* i=71; 125 / 112 */
        RTUINT128_INIT_C(0x09f93c57c5474a4f, 0x8e86731191f32f55), RTUINT128_INIT_C(0x00007d3048ec4076, 0xb4fe5eed52b0847a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001465), RTUINT128_INIT_C(0x000012988b089556, 0x46c074fa27f56333)
    },
    { /* i=72; 61 / 45 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0e8072b12b332f48), RTUINT128_INIT_C(0x0000000000000000, 0x0000102c3444d0eb),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000e58c), RTUINT128_INIT_C(0x0000000000000000, 0x00000fc306aeb7c4)
    },
    { /* i=73; 122 / 101 */
        RTUINT128_INIT_C(0x03f0fb129735547c, 0x32bd58d28493816a), RTUINT128_INIT_C(0x00000002ca642e41, 0x624981c022b20953),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000016990b3), RTUINT128_INIT_C(0x000000017ef09bd3, 0x286a9ee6f6cd4c61)
    },
    { /* i=74; 127 / 6 */
        RTUINT128_INIT_C(0x0da27fce861275c3, 0x47fd6944539f0425), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000002b),
        RTUINT128_INIT_C(0x00512ca58c0c5616, 0x66e22c1f5b3f3ba1), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000001a)
    },
    { /* i=75; 123 / 40 */
        RTUINT128_INIT_C(0x0695656c355b69b1, 0x78e303010817f361), RTUINT128_INIT_C(0x0000000000000000, 0x000000e74f8ef90e),
        RTUINT128_INIT_C(0x0000000000074949, 0xf5a1a22d789d36da), RTUINT128_INIT_C(0x0000000000000000, 0x0000005bd238e975)
    },
    { /* i=76; 114 / 116 */
        RTUINT128_INIT_C(0x000275350c7e9e1d, 0x9477e51f4a2e6660), RTUINT128_INIT_C(0x000c52e789ea091e, 0xa3ecb42b0a0e3ed8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000275350c7e9e1d, 0x9477e51f4a2e6660)
    },
    { /* i=77; 56 / 25 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00bb397782ce1e4a), RTUINT128_INIT_C(0x0000000000000000, 0x000000000035e624),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000003793f0414), RTUINT128_INIT_C(0x0000000000000000, 0x000000000023937a)
    },
    { /* i=78; 127 / 25 */
        RTUINT128_INIT_C(0x1d609f98318731e2, 0x766b629b9784d935), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000b31250),
        RTUINT128_INIT_C(0x00000029ff74921d, 0xc8da091aa9b61f1b), RTUINT128_INIT_C(0x0000000000000000, 0x00000000008a3ac5)
    },
    { /* i=79; 87 / 8 */
        RTUINT128_INIT_C(0x00000000007aa42b, 0x962e7c8bd607c5c6), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000003d),
        RTUINT128_INIT_C(0x00000000000202b0, 0xfa118c889664d946), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000018)
    },
    { /* i=80; 55 / 41 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0060800b7e96653c), RTUINT128_INIT_C(0x0000000000000000, 0x000001feb095d5e9),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000305f), RTUINT128_INIT_C(0x0000000000000000, 0x0000016bdee053c5)
    },
    { /* i=81; 52 / 15 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0003eae0b348c59c), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000049a5),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000d9e293e14), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000eb8)
    },
    { /* i=82; 63 / 46 */
        RTUINT128_INIT_C(0x0000000000000000, 0x60020c91b9d12429), RTUINT128_INIT_C(0x0000000000000000, 0x00000bd99df42154),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000081a15), RTUINT128_INIT_C(0x0000000000000000, 0x00000a0beec7e045)
    },
    { /* i=83; 18 / 49 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000291fa), RTUINT128_INIT_C(0x0000000000000000, 0x000031ffec3e4230),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000291fa)
    },
    { /* i=84; 107 / 7 */
        RTUINT128_INIT_C(0x000001c94d3540f9, 0xb06c4c783634b2f7), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000031),
        RTUINT128_INIT_C(0x00000009552ae1fa, 0xa58f457a9dd74792), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000005)
    },
    { /* i=85; 58 / 1 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0300278461153cae), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001),
        RTUINT128_INIT_C(0x0000000000000000, 0x0300278461153cae), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=86; 124 / 34 */
        RTUINT128_INIT_C(0x0d511ac2431e56fa, 0x3c24055d64fa4f1c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000286249941),
        RTUINT128_INIT_C(0x000000000546ad70, 0x43a84ca12ac7064b), RTUINT128_INIT_C(0x0000000000000000, 0x000000027122e311)
    },
    { /* i=87; 117 / 126 */
        RTUINT128_INIT_C(0x0001d2b6a39fe5af, 0x6e3cc94d0f4f5105), RTUINT128_INIT_C(0x1e5cac644582e116, 0xdff75d9f890cfb97),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0001d2b6a39fe5af, 0x6e3cc94d0f4f5105)
    },
    { /* i=88; 122 / 57 */
        RTUINT128_INIT_C(0x02f62edec3f6b678, 0x16fb58445a6f0491), RTUINT128_INIT_C(0x0000000000000000, 0x01ed1e7ca61833c5),
        RTUINT128_INIT_C(0x0000000000000001, 0x899b426cd6ec718a), RTUINT128_INIT_C(0x0000000000000000, 0x001ce90fbaed275f)
    },
    { /* i=89; 115 / 112 */
        RTUINT128_INIT_C(0x0001cb9a68f2e8ad, 0x9d3bde122b5b3fec), RTUINT128_INIT_C(0x000070803b608826, 0x5af540d1455e91ce),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000004), RTUINT128_INIT_C(0x000009997b70c814, 0x3166dacd15e0f8b4)
    },
    { /* i=90; 124 / 88 */
        RTUINT128_INIT_C(0x00125f194c3d9df4, 0x0b06701e58461b19), RTUINT128_INIT_C(0x00000000004de6bc, 0xbd1eed26d37f4b16),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000003c5f5d73), RTUINT128_INIT_C(0x00000000000ef867, 0xbf007b0212a66237)
    },
    { /* i=91; 121 / 86 */
        RTUINT128_INIT_C(0x00ea720c68a22ead, 0x6e5f95c8cf1989fd), RTUINT128_INIT_C(0x00000000000e1484, 0xadcd244689cc27a6),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000010a699a82a), RTUINT128_INIT_C(0x00000000000a9551, 0x42a420aee36018c1)
    },
    { /* i=92; 128 / 25 */
        RTUINT128_INIT_C(0xdad13139645c96f5, 0x3cef0cb476e9d44c), RTUINT128_INIT_C(0x0000000000000000, 0x00000000009c853c),
        RTUINT128_INIT_C(0x00000165e3fc8cb7, 0xe5dafa6b80d4a3c4), RTUINT128_INIT_C(0x0000000000000000, 0x00000000008e9e5c)
    },
    { /* i=93; 119 / 114 */
        RTUINT128_INIT_C(0x002ad657c03fa301, 0xa6321843091d0d8f), RTUINT128_INIT_C(0x0000008c9290b39b, 0x0a814e4b09c9aa73),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000004e03), RTUINT128_INIT_C(0x00000009f1d44afd, 0x20d3506679d10436)
    },
    { /* i=94; 117 / 97 */
        RTUINT128_INIT_C(0x000f53e1b95234e8, 0x3ae821ca4563283f), RTUINT128_INIT_C(0x0000000054ba1a88, 0xbfa85d341e14c6b5),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000002e4fe4), RTUINT128_INIT_C(0x0000000010cfefb7, 0xd4d4a25b5d0a540b)
    },
    { /* i=95; 99 / 71 */
        RTUINT128_INIT_C(0x00000007e667e57d, 0x3403da45aff3c489), RTUINT128_INIT_C(0x0000000000000037, 0x565e1f45e7a6aa70),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000248bfd5a), RTUINT128_INIT_C(0x000000000000002d, 0x027c8e4c3e1b2929)
    },
    { /* i=96; 92 / 8 */
        RTUINT128_INIT_C(0x000000000ffa5518, 0xde063118fba2f532), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000054),
        RTUINT128_INIT_C(0x000000000030b1c6, 0x642abd8970b5bfdf), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000006)
    },
    { /* i=97; 79 / 33 */
        RTUINT128_INIT_C(0x000000000000062f, 0x676e141342782b6b), RTUINT128_INIT_C(0x0000000000000000, 0x00000000d8e1b10e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000074cffa6cffd), RTUINT128_INIT_C(0x0000000000000000, 0x00000000ac2dde95)
    },
    { /* i=98; 125 / 121 */
        RTUINT128_INIT_C(0x063dfa1eb5f39c25, 0xc48297bcc0425df3), RTUINT128_INIT_C(0x0061250bd1503bad, 0x0176c4194c4de4b5),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000010), RTUINT128_INIT_C(0x002ba961a0efe155, 0xad165627fb6412a3)
    },
    { /* i=99; 115 / 16 */
        RTUINT128_INIT_C(0x00006589b5473f70, 0xa9912992106a8940), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000c2b),
        RTUINT128_INIT_C(0x00000008583d93f3, 0x22290e502ce08ee0), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000009a0)
    },
    { /* i=100; 89 / 127 */
        RTUINT128_INIT_C(0x0000000001acd135, 0x5cbe3f2e8d42cf38), RTUINT128_INIT_C(0x1bc0363b8734e497, 0x462d5e8fa6823052),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000001acd135, 0x5cbe3f2e8d42cf38)
    },
    { /* i=101; 46 / 22 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000ed49d7a8935), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000b3dfd),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000151b67a), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000020a3)
    },
    { /* i=102; 123 / 53 */
        RTUINT128_INIT_C(0x0104b1050e839d9d, 0x3d40ce26645e1a8e), RTUINT128_INIT_C(0x0000000000000000, 0x0010303ee0c91290),
        RTUINT128_INIT_C(0x0000000000000010, 0x1a81836aa7cb8e99), RTUINT128_INIT_C(0x0000000000000000, 0x00004db4dbb6227e)
    },
    { /* i=103; 111 / 21 */
        RTUINT128_INIT_C(0x000026c3bd29de38, 0x290a704df91531d7), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000381eb),
        RTUINT128_INIT_C(0x000000000b0d4c30, 0x3636e87e6f5f883e), RTUINT128_INIT_C(0x0000000000000000, 0x000000000001e2ed)
    },
    { /* i=104; 120 / 33 */
        RTUINT128_INIT_C(0x00d5ee3a1c58bdaa, 0xc021aca087997156), RTUINT128_INIT_C(0x0000000000000000, 0x00000001720d7bfd),
        RTUINT128_INIT_C(0x000000000093feea, 0x324f6241a8ea2aae), RTUINT128_INIT_C(0x0000000000000000, 0x000000006ed5a960)
    },
    { /* i=105; 123 / 125 */
        RTUINT128_INIT_C(0x00e4acfb07be536f, 0x3eb35dc5e22a153d), RTUINT128_INIT_C(0x047dc7b3676eca8c, 0x507d20d645060393),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00e4acfb07be536f, 0x3eb35dc5e22a153d)
    },
    { /* i=106; 98 / 92 */
        RTUINT128_INIT_C(0x0000000133220884, 0x623a7347c8e5a61d), RTUINT128_INIT_C(0x000000000b282f63, 0x4c4627e47f9823a0),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000001b), RTUINT128_INIT_C(0x0000000005e5090b, 0x56d43e2e53d9e43d)
    },
    { /* i=107; 123 / 59 */
        RTUINT128_INIT_C(0x016af1ed0a34f0d8, 0x226f0beadfc982ba), RTUINT128_INIT_C(0x0000000000000000, 0x03fe384141bc86f3),
        RTUINT128_INIT_C(0x0000000000000000, 0x5ae4ef6a4c9b9efd), RTUINT128_INIT_C(0x0000000000000000, 0x01f9aa06b40d2a93)
    },
    { /* i=108; 16 / 1 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000a8f4), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000a8f4), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=109; 115 / 126 */
        RTUINT128_INIT_C(0x0007327ad5e71bea, 0x5663dd803cd14047), RTUINT128_INIT_C(0x063e0f5f55d3d479, 0x048c60c2a437fcd3),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0007327ad5e71bea, 0x5663dd803cd14047)
    },
    { /* i=110; 84 / 57 */
        RTUINT128_INIT_C(0x00000000000af2b7, 0xd94bda7a87cb62ce), RTUINT128_INIT_C(0x0000000000000000, 0x0073ab00ba65929b),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000183b104f), RTUINT128_INIT_C(0x0000000000000000, 0x00458e73579074f9)
    },
    { /* i=111; 31 / 16 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000005c2061cf), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000513e),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000001224c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000767)
    },
    { /* i=112; 74 / 115 */
        RTUINT128_INIT_C(0x000000000000014d, 0x445e92d7e07c3037), RTUINT128_INIT_C(0x00014a98b1ad0ca8, 0xe6ce339b5038b095),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000000000000014d, 0x445e92d7e07c3037)
    },
    { /* i=113; 121 / 68 */
        RTUINT128_INIT_C(0x01664bafea5658eb, 0x2600b4fe4d36d336), RTUINT128_INIT_C(0x000000000000000d, 0x64d38fffd8a60006),
        RTUINT128_INIT_C(0x0000000000000000, 0x001ac03152908dbd), RTUINT128_INIT_C(0x000000000000000d, 0x43c9f03ffd4580c8)
    },
    { /* i=114; 114 / 75 */
        RTUINT128_INIT_C(0x0000406847afd4f5, 0x65a04f31f4dc9567), RTUINT128_INIT_C(0x0000000000000122, 0x94269a40709d8245),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000038be2ef21d), RTUINT128_INIT_C(0x0000000000000079, 0xf1d2495baf799996)
    },
    { /* i=115; 118 / 34 */
        RTUINT128_INIT_C(0x001fa416a8f1369a, 0x3c7b51b9d91245dc), RTUINT128_INIT_C(0x0000000000000000, 0x0000000123825d44),
        RTUINT128_INIT_C(0x00000000001bc967, 0x287a015b0759dec7), RTUINT128_INIT_C(0x0000000000000000, 0x00000000e936ce00)
    },
    { /* i=116; 120 / 71 */
        RTUINT128_INIT_C(0x0081ea0e47b1aac8, 0xb75057af668bb4f3), RTUINT128_INIT_C(0x000000000000005b, 0x95b4c6006a8f0847),
        RTUINT128_INIT_C(0x0000000000000000, 0x00016b23b708f379), RTUINT128_INIT_C(0x000000000000000c, 0x7e71fa3f40dd6664)
    },
    { /* i=117; 105 / 89 */
        RTUINT128_INIT_C(0x0000018f2fb5775e, 0xd70cb73117ff0076), RTUINT128_INIT_C(0x0000000000af93ad, 0x962bea608dc71f32),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000024608), RTUINT128_INIT_C(0x00000000007c368a, 0x4ed5e1d9f8da5ae6)
    },
    { /* i=118; 77 / 47 */
        RTUINT128_INIT_C(0x000000000000164e, 0xdc875cebac7f8268), RTUINT128_INIT_C(0x0000000000000000, 0x00000ede91b5ec1f),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000018011593a), RTUINT128_INIT_C(0x0000000000000000, 0x00000e933c223c62)
    },
    { /* i=119; 118 / 82 */
        RTUINT128_INIT_C(0x002df8c378a20653, 0xa5f8d967b87af976), RTUINT128_INIT_C(0x0000000000026f92, 0x2bb031755abbe780),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000012df8853f8), RTUINT128_INIT_C(0x000000000000619f, 0x51a7b9d16a643576)
    },
    { /* i=120; 115 / 124 */
        RTUINT128_INIT_C(0x000738618291f279, 0xe3f223c3746b4395), RTUINT128_INIT_C(0x06a8a75e25686dd0, 0x821926884ea0f518),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000738618291f279, 0xe3f223c3746b4395)
    },
    { /* i=121; 82 / 38 */
        RTUINT128_INIT_C(0x000000000002e854, 0xc9838f1dfedad341), RTUINT128_INIT_C(0x0000000000000000, 0x000000147176cdb6),
        RTUINT128_INIT_C(0x0000000000000000, 0x00002468e13992b2), RTUINT128_INIT_C(0x0000000000000000, 0x000000009567feb5)
    },
    { /* i=122; 56 / 42 */
        RTUINT128_INIT_C(0x0000000000000000, 0x008b8a803a9b5b17), RTUINT128_INIT_C(0x0000000000000000, 0x000001b7bb08b7a1),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000513c), RTUINT128_INIT_C(0x0000000000000000, 0x00000142a276605b)
    },
    { /* i=123; 103 / 92 */
        RTUINT128_INIT_C(0x00000000a055f9bb, 0x75c1ab0461463ef7), RTUINT128_INIT_C(0x000000000cc667d7, 0xe0622b23eef672a4),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000c), RTUINT128_INIT_C(0x0000000007091b9c, 0xf127a5552db8df47)
    },
    { /* i=124; 96 / 8 */
        RTUINT128_INIT_C(0x000000009ee0eaea, 0x57d07bb0f9885a07), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002),
        RTUINT128_INIT_C(0x000000004f707575, 0x2be83dd87cc42d03), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001)
    },
    { /* i=125; 116 / 119 */
        RTUINT128_INIT_C(0x000c324b2a2dd692, 0xc572248e8a6d2779), RTUINT128_INIT_C(0x0064c42299c131c2, 0x115ce6947ee54676),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000c324b2a2dd692, 0xc572248e8a6d2779)
    },
    { /* i=126; 122 / 32 */
        RTUINT128_INIT_C(0x00cc18bd5d5bd193, 0x92c92af4cf307f13), RTUINT128_INIT_C(0x0000000000000000, 0x000000009012ef55),
        RTUINT128_INIT_C(0x00000000016aa6f6, 0x5f8d99f892bf6544), RTUINT128_INIT_C(0x0000000000000000, 0x000000000751637f)
    },
    { /* i=127; 95 / 36 */
        RTUINT128_INIT_C(0x000000005ca11b58, 0x22f1d128da0d9dff), RTUINT128_INIT_C(0x0000000000000000, 0x00000005785c4900),
        RTUINT128_INIT_C(0x0000000000000000, 0x10eefea6da0863d5), RTUINT128_INIT_C(0x0000000000000000, 0x00000003bd09e0ff)
    },
    { /* i=128; 77 / 36 */
        RTUINT128_INIT_C(0x0000000000001218, 0x4384df2ee4d41f8a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000360adc5b1),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000055b71f37e6f), RTUINT128_INIT_C(0x0000000000000000, 0x00000001aa2b49cb)
    },
    { /* i=129; 12 / 46 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000052a), RTUINT128_INIT_C(0x0000000000000000, 0x000024e941bdf2b1),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000052a)
    },
    { /* i=130; 110 / 49 */
        RTUINT128_INIT_C(0x00002734910c4702, 0xc935f32fcf2d588e), RTUINT128_INIT_C(0x0000000000000000, 0x00015d254b1113aa),
        RTUINT128_INIT_C(0x0000000000000000, 0x1cbefe8b1654d395), RTUINT128_INIT_C(0x0000000000000000, 0x00008d02fb3fc89c)
    },
    { /* i=131; 103 / 22 */
        RTUINT128_INIT_C(0x0000007125423eb7, 0xfff64394490a139b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000298095),
        RTUINT128_INIT_C(0x000000000002b9eb, 0x787f7da1fab4c17d), RTUINT128_INIT_C(0x0000000000000000, 0x000000000011f5da)
    },
    { /* i=132; 100 / 17 */
        RTUINT128_INIT_C(0x0000000954438860, 0xf0929044932d4646), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000e090),
        RTUINT128_INIT_C(0x00000000000aa29b, 0x81098cccfc8775b1), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000032b6)
    },
    { /* i=133; 76 / 1 */
        RTUINT128_INIT_C(0x00000000000007f1, 0x7bc2da3cc23efd7a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001),
        RTUINT128_INIT_C(0x00000000000007f1, 0x7bc2da3cc23efd7a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=134; 58 / 34 */
        RTUINT128_INIT_C(0x0000000000000000, 0x01a32e050e82495a), RTUINT128_INIT_C(0x0000000000000000, 0x00000001b8e1db38),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000f365fb), RTUINT128_INIT_C(0x0000000000000000, 0x00000000976b4172)
    },
    { /* i=135; 122 / 51 */
        RTUINT128_INIT_C(0x01f61a35665bca1b, 0xb1e144982a667288), RTUINT128_INIT_C(0x0000000000000000, 0x0006f8b9e2f4c778),
        RTUINT128_INIT_C(0x0000000000000048, 0x0570bc0399d78703), RTUINT128_INIT_C(0x0000000000000000, 0x0005f6892e8fd420)
    },
    { /* i=136; 117 / 24 */
        RTUINT128_INIT_C(0x0004cac5e5d27fe0, 0x10800c58ce41cd5a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000adaf9c),
        RTUINT128_INIT_C(0x0000000007102bb6, 0x24093f4f4bdb4224), RTUINT128_INIT_C(0x0000000000000000, 0x00000000001ae36a)
    },
    { /* i=137; 113 / 120 */
        RTUINT128_INIT_C(0x000143e7c274d19c, 0x4099ac4f60795f67), RTUINT128_INIT_C(0x008d5d38b6c0eb88, 0x2aa51c4011648dd9),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000143e7c274d19c, 0x4099ac4f60795f67)
    },
    { /* i=138; 121 / 69 */
        RTUINT128_INIT_C(0x00701cf788ef51e4, 0xbf296e39a614d99a), RTUINT128_INIT_C(0x000000000000001a, 0x47ed5046991cc6c8),
        RTUINT128_INIT_C(0x0000000000000000, 0x00044414f99beeef), RTUINT128_INIT_C(0x0000000000000015, 0xfc218093105154e2)
    },
    { /* i=139; 118 / 37 */
        RTUINT128_INIT_C(0x0011c6369a887785, 0xbfe1b73087784237), RTUINT128_INIT_C(0x0000000000000000, 0x0000001f8fb49883),
        RTUINT128_INIT_C(0x000000000000902b, 0xa14129570f3c0535), RTUINT128_INIT_C(0x0000000000000000, 0x00000010d4662018)
    },
    { /* i=140; 120 / 116 */
        RTUINT128_INIT_C(0x00815c8d06b1e68d, 0xb56c0404ad2fbef9), RTUINT128_INIT_C(0x0005bb419a232a91, 0x4c8e523f77eb1111),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000016), RTUINT128_INIT_C(0x000344e9c7ac3e11, 0x2130f2905efc4783)
    },
    { /* i=141; 113 / 123 */
        RTUINT128_INIT_C(0x000110c63095adf1, 0x7845012a93958d9f), RTUINT128_INIT_C(0x06ca225e7e743252, 0xc73b86ef12dd6510),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000110c63095adf1, 0x7845012a93958d9f)
    },
    { /* i=142; 120 / 125 */
        RTUINT128_INIT_C(0x00a72d3a9e2cd4ff, 0x72cba5f92a82ef45), RTUINT128_INIT_C(0x13df78b07065ff02, 0x78a5160d044ddc44),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00a72d3a9e2cd4ff, 0x72cba5f92a82ef45)
    },
    { /* i=143; 78 / 3 */
        RTUINT128_INIT_C(0x00000000000000e5, 0x8a36ebffaddb012b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001),
        RTUINT128_INIT_C(0x00000000000000e5, 0x8a36ebffaddb012b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=144; 69 / 55 */
        RTUINT128_INIT_C(0x0000000000000012, 0x7a6220b4e7d179d6), RTUINT128_INIT_C(0x0000000000000000, 0x0044a98bbd1dbc41),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000044e4), RTUINT128_INIT_C(0x0000000000000000, 0x0032020493548bf2)
    },
    { /* i=145; 12 / 110 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000d2c), RTUINT128_INIT_C(0x000038c10966ec65, 0xa08a8895d1813a16),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000d2c)
    },
    { /* i=146; 89 / 28 */
        RTUINT128_INIT_C(0x0000000000253f5d, 0xf66eff3c6f7cee69), RTUINT128_INIT_C(0x0000000000000000, 0x0000000002b39d26),
        RTUINT128_INIT_C(0x0000000000000000, 0x0dc9810d1b57a048), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000d6fbb9)
    },
    { /* i=147; 80 / 28 */
        RTUINT128_INIT_C(0x00000000000063f3, 0x2ebf8c3ce495d55d), RTUINT128_INIT_C(0x0000000000000000, 0x000000000893a89c),
        RTUINT128_INIT_C(0x0000000000000000, 0x000ba74e01e9c6a7), RTUINT128_INIT_C(0x0000000000000000, 0x0000000005de2f99)
    },
    { /* i=148; 116 / 18 */
        RTUINT128_INIT_C(0x0002954c41be9a8c, 0xb4aac06c65656491), RTUINT128_INIT_C(0x0000000000000000, 0x000000000002fe1c),
        RTUINT128_INIT_C(0x00000000dcfa0379, 0xb98fd8352c516518), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000085f1)
    },
    { /* i=149; 122 / 108 */
        RTUINT128_INIT_C(0x0273ace4f33f924b, 0x27ad16ef6c329d68), RTUINT128_INIT_C(0x000005bc6eb082f1, 0x5cb076813b194695),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000006d6d), RTUINT128_INIT_C(0x00000088aa570d0f, 0x8e159bbf7f621ef7)
    },
    { /* i=150; 121 / 73 */
        RTUINT128_INIT_C(0x014d63b6062c4d7b, 0x4a41859e408897c9), RTUINT128_INIT_C(0x00000000000001af, 0xc6e6586390f375a5),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000c5aa8c547081), RTUINT128_INIT_C(0x000000000000004e, 0x3a5e9f3cdc3e1fa4)
    },
    { /* i=151; 119 / 30 */
        RTUINT128_INIT_C(0x0004d6966f68e1ab, 0x778f27b3f79040c4), RTUINT128_INIT_C(0x0000000000000000, 0x0000000039291a8f),
        RTUINT128_INIT_C(0x000000000015ab27, 0x6a0a48ebd5f37165), RTUINT128_INIT_C(0x0000000000000000, 0x0000000014e2a759)
    },
    { /* i=152; 44 / 14 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000944bd1586e5), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000026c0),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000003d3b6200), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000006e5)
    },
    { /* i=153; 123 / 118 */
        RTUINT128_INIT_C(0x05a709336a52d91a, 0x95f04622342dd1c9), RTUINT128_INIT_C(0x00255a9488938f2b, 0xeb8cc541c50ebebc),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000026), RTUINT128_INIT_C(0x001b9727246b9895, 0x9f0afe5ef3fd81e1)
    },
    { /* i=154; 128 / 68 */
        RTUINT128_INIT_C(0x9dfebc1d402ec3f0, 0xb0af92a114825ec5), RTUINT128_INIT_C(0x000000000000000a, 0x579fff9b30b635ac),
        RTUINT128_INIT_C(0x0000000000000000, 0x0f46cfec02c6bcb7), RTUINT128_INIT_C(0x0000000000000007, 0xa6c93b0297cfb0d1)
    },
    { /* i=155; 128 / 111 */
        RTUINT128_INIT_C(0xb71774cdab890e48, 0x86de26ca6337cb5c), RTUINT128_INIT_C(0x00002b26cae3e6c0, 0x08cff12fe6ddcd22),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000043e34), RTUINT128_INIT_C(0x00002039a85b89e4, 0x9b77f3ae91f3e474)
    },
    { /* i=156; 116 / 56 */
        RTUINT128_INIT_C(0x0009fe7a1d246432, 0xdd86b1d9111edf7a), RTUINT128_INIT_C(0x0000000000000000, 0x00b4b2cb700cfa80),
        RTUINT128_INIT_C(0x0000000000000000, 0x0e28a8a9db136313), RTUINT128_INIT_C(0x0000000000000000, 0x000ef6a8a3c8c7fa)
    },
    { /* i=157; 126 / 95 */
        RTUINT128_INIT_C(0x1d4a02463f80c2d7, 0x0655723fc367007e), RTUINT128_INIT_C(0x0000000061b1e818, 0x71e484912c6fe17e),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000004cbfcb70), RTUINT128_INIT_C(0x00000000029304fa, 0xfbbaf614f5a36f5e)
    },
    { /* i=158; 122 / 126 */
        RTUINT128_INIT_C(0x006060ac4b9596fe, 0x0531427a6dc153ad), RTUINT128_INIT_C(0x2fc26c673b8a351d, 0xc803e0632406dfab),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x006060ac4b9596fe, 0x0531427a6dc153ad)
    },
    { /* i=159; 117 / 106 */
        RTUINT128_INIT_C(0x0009ba7e2eaf9cae, 0x6aea863332acee3e), RTUINT128_INIT_C(0x000001c7c928c078, 0xec2cc8ffcffcb37a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000576), RTUINT128_INIT_C(0x00000179aa248854, 0xae58e13964b0d202)
    },
    { /* i=160; 124 / 89 */
        RTUINT128_INIT_C(0x046687caacece558, 0xd97e0af7ffefc05b), RTUINT128_INIT_C(0x0000000001663dd6, 0x07955ef1c0a16b75),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000325053fea), RTUINT128_INIT_C(0x000000000139da5f, 0x1b23698830a8bc69)
    },
    { /* i=161; 72 / 108 */
        RTUINT128_INIT_C(0x00000000000000c7, 0x89f6ed8d29080766), RTUINT128_INIT_C(0x000009da8471d4f0, 0x0b61ae0bcde05379),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00000000000000c7, 0x89f6ed8d29080766)
    },
    { /* i=162; 122 / 92 */
        RTUINT128_INIT_C(0x01b976f6eb82be89, 0xc8bd8598195fafeb), RTUINT128_INIT_C(0x0000000006f3c468, 0xa302a07e3da5f432),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000003f7ff6a5), RTUINT128_INIT_C(0x0000000001a216a7, 0x8206589071f33fb1)
    },
    { /* i=163; 101 / 90 */
        RTUINT128_INIT_C(0x0000001d25d57f77, 0x64edb2ec17a98181), RTUINT128_INIT_C(0x0000000003ad42ad, 0xc8dbc5f5bfea8b44),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000007ed), RTUINT128_INIT_C(0x00000000019c0416, 0x6f0db62a01b7b78d)
    },
    { /* i=164; 114 / 69 */
        RTUINT128_INIT_C(0x00002d16ba8cc6bf, 0x72f817d07eabbd63), RTUINT128_INIT_C(0x000000000000001e, 0x25fa170c580bf95b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000017edd48e39c), RTUINT128_INIT_C(0x000000000000000c, 0x06c8eacc88ac18ef)
    },
    { /* i=165; 75 / 25 */
        RTUINT128_INIT_C(0x000000000000015c, 0xd781828e126aff9d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000001258464),
        RTUINT128_INIT_C(0x0000000000000000, 0x00013040cbcbb7d9), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000ae4ad9)
    },
    { /* i=166; 20 / 14 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000f4c99), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000904),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000001b2), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000003d1)
    },
    { /* i=167; 127 / 103 */
        RTUINT128_INIT_C(0x63ec329b771c8534, 0xdb826da0a25b2689), RTUINT128_INIT_C(0x0000006711e52fb7, 0xe62336be3c3753dd),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000f82ed8), RTUINT128_INIT_C(0x00000066f5024493, 0x51abb8b2a482ae11)
    },
    { /* i=168; 125 / 30 */
        RTUINT128_INIT_C(0x136a59766aaaad95, 0xf53300892f377a9b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000034d5deb8),
        RTUINT128_INIT_C(0x000000005e12811a, 0x479b29d92fa70f50), RTUINT128_INIT_C(0x0000000000000000, 0x00000000124d191b)
    },
    { /* i=169; 83 / 25 */
        RTUINT128_INIT_C(0x0000000000019573, 0x988adb30eb53ce75), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000754125),
        RTUINT128_INIT_C(0x0000000000000000, 0x0375376e8dba7ab8), RTUINT128_INIT_C(0x0000000000000000, 0x00000000001f59dd)
    },
    { /* i=170; 73 / 42 */
        RTUINT128_INIT_C(0x0000000000000068, 0x1143766416afc359), RTUINT128_INIT_C(0x0000000000000000, 0x000002b14118d624),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000026a6fd24), RTUINT128_INIT_C(0x0000000000000000, 0x0000023d30381249)
    },
    { /* i=171; 114 / 26 */
        RTUINT128_INIT_C(0x0002be48ce56d781, 0xe469969e237c3aba), RTUINT128_INIT_C(0x0000000000000000, 0x0000000001829a29),
        RTUINT128_INIT_C(0x0000000001d109ca, 0xec3cf255784801b2), RTUINT128_INIT_C(0x0000000000000000, 0x00000000008ae138)
    },
    { /* i=172; 56 / 22 */
        RTUINT128_INIT_C(0x0000000000000000, 0x001b0d0623030bfa), RTUINT128_INIT_C(0x0000000000000000, 0x00000000001e3ea2),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000e4f7828f), RTUINT128_INIT_C(0x0000000000000000, 0x000000000001cb7c)
    },
    { /* i=173; 126 / 50 */
        RTUINT128_INIT_C(0x01dfbdf00d4f34b8, 0x94101543b4357b28), RTUINT128_INIT_C(0x0000000000000000, 0x000113a8794bcd02),
        RTUINT128_INIT_C(0x00000000000001bd, 0x87aa49177aa7b4de), RTUINT128_INIT_C(0x0000000000000000, 0x0000568d88064b6c)
    },
    { /* i=174; 70 / 25 */
        RTUINT128_INIT_C(0x0000000000000033, 0x548660b904ee30c3), RTUINT128_INIT_C(0x0000000000000000, 0x00000000008c22d8),
        RTUINT128_INIT_C(0x0000000000000000, 0x00005dc50cf66192), RTUINT128_INIT_C(0x0000000000000000, 0x00000000003e7993)
    },
    { /* i=175; 116 / 83 */
        RTUINT128_INIT_C(0x000429f6dd3bbcb7, 0xe7e062e2c76ffd57), RTUINT128_INIT_C(0x0000000000053803, 0x9bdba6369b0b8203),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000cc412594), RTUINT128_INIT_C(0x00000000000139e2, 0x5673dd62143b649b)
    },
    { /* i=176; 41 / 63 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000016098ace4f6), RTUINT128_INIT_C(0x0000000000000000, 0x468cb8153bb0211d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000016098ace4f6)
    },
    { /* i=177; 84 / 16 */
        RTUINT128_INIT_C(0x000000000007fd22, 0x24f24f49e3bc58f9), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000ca61),
        RTUINT128_INIT_C(0x000000000000000a, 0x1affe41a76318f27), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000005532)
    },
    { /* i=178; 72 / 31 */
        RTUINT128_INIT_C(0x00000000000000bc, 0x59a66e0088ea7908), RTUINT128_INIT_C(0x0000000000000000, 0x00000000378ffc1b),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000363cf664213), RTUINT128_INIT_C(0x0000000000000000, 0x000000000279cd07)
    },
    { /* i=179; 87 / 74 */
        RTUINT128_INIT_C(0x0000000000387ebf, 0x704c57c212cc8f92), RTUINT128_INIT_C(0x0000000000000050, 0xdb2583f99f373947),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000b2de), RTUINT128_INIT_C(0x0000000000000041, 0x500054959b158600)
    },
    { /* i=180; 89 / 42 */
        RTUINT128_INIT_C(0x00000000019acef7, 0xbb24febc22577a92), RTUINT128_INIT_C(0x0000000000000000, 0x000002a02bd07215),
        RTUINT128_INIT_C(0x0000000000000000, 0x00009c7567da8235), RTUINT128_INIT_C(0x0000000000000000, 0x000000529d5f3239)
    },
    { /* i=181; 116 / 55 */
        RTUINT128_INIT_C(0x000655ce7bc0d045, 0x38d2b02fb6adc121), RTUINT128_INIT_C(0x0000000000000000, 0x00314d24debfc24b),
        RTUINT128_INIT_C(0x0000000000000000, 0x20e55263ca38f6b7), RTUINT128_INIT_C(0x0000000000000000, 0x0023ea85887dcb84)
    },
    { /* i=182; 51 / 11 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0001bbd29c2b4b98), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000004f3),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000059ace0b752), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000c2)
    },
    { /* i=183; 74 / 23 */
        RTUINT128_INIT_C(0x0000000000000248, 0x0c695be461935dcb), RTUINT128_INIT_C(0x0000000000000000, 0x000000000060dbb9),
        RTUINT128_INIT_C(0x0000000000000000, 0x000607a9553c4892), RTUINT128_INIT_C(0x0000000000000000, 0x00000000002e0649)
    },
    { /* i=184; 123 / 124 */
        RTUINT128_INIT_C(0x025c696159dc29bb, 0xa9397a7f1c9920b8), RTUINT128_INIT_C(0x0972c477b0e493e8, 0x23c8a81d07a83226),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x025c696159dc29bb, 0xa9397a7f1c9920b8)
    },
    { /* i=185; 117 / 96 */
        RTUINT128_INIT_C(0x0005a5cf9b6d7930, 0xc313080dd83baaa8), RTUINT128_INIT_C(0x000000005c3c115c, 0x4d90dae916883896),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000face4), RTUINT128_INIT_C(0x0000000015db7361, 0x87532356f01a7d10)
    },
    { /* i=186; 128 / 119 */
        RTUINT128_INIT_C(0x7c54657fbfb02d03, 0x13a2584d861db566), RTUINT128_INIT_C(0x0079a7e153cde82b, 0x9fb1ba008784217c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000105), RTUINT128_INIT_C(0x004c3cc54ec27889, 0x436fb5c35c6791fa)
    },
    { /* i=187; 38 / 27 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000003d20844814), RTUINT128_INIT_C(0x0000000000000000, 0x0000000003e31b52),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000fb9), RTUINT128_INIT_C(0x0000000000000000, 0x0000000002cbbbd2)
    },
    { /* i=188; 113 / 117 */
        RTUINT128_INIT_C(0x0001b32e2befd42e, 0x0baf3e8dc7d004c3), RTUINT128_INIT_C(0x00106e029e0c209a, 0xfdc5e24fa8f76ea9),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0001b32e2befd42e, 0x0baf3e8dc7d004c3)
    },
    { /* i=189; 98 / 87 */
        RTUINT128_INIT_C(0x0000000154c36d28, 0x83f276e385df4292), RTUINT128_INIT_C(0x00000000002dc4cd, 0xefcba276272352ff),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000772), RTUINT128_INIT_C(0x00000000000027e5, 0x29d2e33420df5404)
    },
    { /* i=190; 89 / 54 */
        RTUINT128_INIT_C(0x0000000001b01c7f, 0x0ce5816c9e334afa), RTUINT128_INIT_C(0x0000000000000000, 0x003ef59bc3769498),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000006dd0351d2), RTUINT128_INIT_C(0x0000000000000000, 0x00319a92cc214e4a)
    },
    { /* i=191; 120 / 85 */
        RTUINT128_INIT_C(0x00ced85b0c336038, 0x61f1895643e037e4), RTUINT128_INIT_C(0x0000000000081802, 0x4fd6c2a44f23792e),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000198e58f408), RTUINT128_INIT_C(0x000000000002d837, 0x6adf21decf749674)
    },
    { /* i=192; 2 / 114 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x000206b755b430cc, 0x47d165b71e4789b4),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001)
    },
    { /* i=193; 113 / 92 */
        RTUINT128_INIT_C(0x0000b183c1a6527a, 0xb05d95a4f9d0b467), RTUINT128_INIT_C(0x000000000a001672, 0xe6fa9e71d8c8a615),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000011c038), RTUINT128_INIT_C(0x000000000329e577, 0xad2624d409f79fcf)
    },
    { /* i=194; 74 / 18 */
        RTUINT128_INIT_C(0x00000000000003c2, 0x5ff1d968cf345234), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000b616),
        RTUINT128_INIT_C(0x0000000000000000, 0x054907f932a0ff1c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000007dcc)
    },
    { /* i=195; 125 / 96 */
        RTUINT128_INIT_C(0x073fd6cd35d9d4c7, 0x297f0d4a34091246), RTUINT128_INIT_C(0x00000000527a5809, 0x7d6d75ec073a0911),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000001680447b), RTUINT128_INIT_C(0x000000004028e409, 0x93f2192b523e331b)
    },
    { /* i=196; 121 / 126 */
        RTUINT128_INIT_C(0x01e30c85d074c59e, 0x5bf6e4dbd062c692), RTUINT128_INIT_C(0x27b5da81720ae4dc, 0x4209fe9e2191e75a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x01e30c85d074c59e, 0x5bf6e4dbd062c692)
    },
    { /* i=197; 123 / 87 */
        RTUINT128_INIT_C(0x02df3dc96786ca41, 0xf45fd60034749e91), RTUINT128_INIT_C(0x00000000004fa8bc, 0x15ddd2140de9094a),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000093ad7245a), RTUINT128_INIT_C(0x0000000000140376, 0x9ba95a92fa12f28d)
    },
    { /* i=198; 118 / 12 */
        RTUINT128_INIT_C(0x00125681adb2efb8, 0xe95a613cb4f0311a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000e20),
        RTUINT128_INIT_C(0x0000014c5abd0157, 0x339ab71b45ff3784), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000089a)
    },
    { /* i=199; 53 / 31 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000698fd7bea27b3), RTUINT128_INIT_C(0x0000000000000000, 0x0000000052f2c63e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000145ca8), RTUINT128_INIT_C(0x0000000000000000, 0x000000005081c703)
    },
    { /* i=200; 77 / 32 */
        RTUINT128_INIT_C(0x00000000000000a6, 0xbe0c51a100982298), RTUINT128_INIT_C(0x0000000000000000, 0x00000000dc3a9579),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000c1d36c819a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000035fc3ece)
    },
    { /* i=201; 126 / 75 */
        RTUINT128_INIT_C(0x34635c7c4e8826d2, 0x1b7c878625f30fa0), RTUINT128_INIT_C(0x00000000000005a0, 0x8f02ecd20d34b67b),
        RTUINT128_INIT_C(0x0000000000000000, 0x00094f5141e647bd), RTUINT128_INIT_C(0x0000000000000578, 0xc0427d2c99ea39d1)
    },
    { /* i=202; 56 / 35 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00725e036fb0a2ab), RTUINT128_INIT_C(0x0000000000000000, 0x00000002cb244934),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000028f0ad), RTUINT128_INIT_C(0x0000000000000000, 0x00000002b36a6a87)
    },
    { /* i=203; 98 / 97 */
        RTUINT128_INIT_C(0x00000002caf4f0f3, 0xaebee2941ade643f), RTUINT128_INIT_C(0x0000000039a3bd96, 0xe49d3ff32baae96d),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000c), RTUINT128_INIT_C(0x0000000017480de0, 0xf75fe32e0edb7323)
    },
    { /* i=204; 124 / 119 */
        RTUINT128_INIT_C(0x0fb019475e0f18a1, 0xbdc3523bfc62aae7), RTUINT128_INIT_C(0x00717ff49dc8fc89, 0x6d920a851a406767),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000023), RTUINT128_INIT_C(0x002b9ad5cb9491d7, 0xc2cbe209659487d2)
    },
    { /* i=205; 92 / 64 */
        RTUINT128_INIT_C(0x000000000a4b6afa, 0xad01619d7842082d), RTUINT128_INIT_C(0x0000000000000000, 0x1ab70555cde9958f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000062a64f25), RTUINT128_INIT_C(0x0000000000000000, 0x077130f3e79e4982)
    },
    { /* i=206; 91 / 15 */
        RTUINT128_INIT_C(0x0000000002b789c6, 0x09204dcf4820a308), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001538),
        RTUINT128_INIT_C(0x00000000000020c7, 0x87a2ed8a43d4a5eb), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000010a0)
    },
    { /* i=207; 119 / 89 */
        RTUINT128_INIT_C(0x00775090b3be9ae6, 0x314385fcf254eec2), RTUINT128_INIT_C(0x0000000001efc04a, 0xa54e02ca1c6d66dc),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000003d9cd9c7), RTUINT128_INIT_C(0x000000000180888c, 0xb552a49b03097dbe)
    },
    { /* i=208; 38 / 52 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000059d1dbc93), RTUINT128_INIT_C(0x0000000000000000, 0x000e582469a1d393),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000000059d1dbc93)
    },
    { /* i=209; 123 / 106 */
        RTUINT128_INIT_C(0x0408e3d1d1eaeed3, 0x394eaa334aef247e), RTUINT128_INIT_C(0x0000026dd1fc39c4, 0x912ae791f607332b),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000001a93c), RTUINT128_INIT_C(0x00000078dee60fc0, 0xf8cf128bad4cc36a)
    },
    { /* i=210; 88 / 29 */
        RTUINT128_INIT_C(0x0000000000e23e00, 0x5eb75a93bdfb89d3), RTUINT128_INIT_C(0x0000000000000000, 0x000000001af3fa8a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0864d9331aea77f0), RTUINT128_INIT_C(0x0000000000000000, 0x0000000009a68273)
    },
    { /* i=211; 83 / 7 */
        RTUINT128_INIT_C(0x0000000000012c61, 0x681c75f3a445a95f), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000026),
        RTUINT128_INIT_C(0x00000000000007e7, 0x9dafe828188891ee), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000b)
    },
    { /* i=212; 121 / 91 */
        RTUINT128_INIT_C(0x008b45d3b1795383, 0xa1d3111f574a7026), RTUINT128_INIT_C(0x0000000007055619, 0xcf1083711ee914b9),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000013d6480b), RTUINT128_INIT_C(0x0000000000160c9b, 0xd14a773067cc8433)
    },
    { /* i=213; 80 / 64 */
        RTUINT128_INIT_C(0x0000000000001682, 0x09c81f24e8d2f95b), RTUINT128_INIT_C(0x0000000000000000, 0x9abe07156d48252d),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000253c), RTUINT128_INIT_C(0x0000000000000000, 0x4e385d53de8ac1cf)
    },
    { /* i=214; 121 / 124 */
        RTUINT128_INIT_C(0x015948fd88d11766, 0x2fdae7679e8427eb), RTUINT128_INIT_C(0x02121f97349a81cc, 0xa63a7db16e17039c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x015948fd88d11766, 0x2fdae7679e8427eb)
    },
    { /* i=215; 121 / 100 */
        RTUINT128_INIT_C(0x014b3d0a7ade69a6, 0x57dc40b19899167c), RTUINT128_INIT_C(0x00000004282c0dc6, 0xf590eb4ffb93276d),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000004faeff), RTUINT128_INIT_C(0x000000004539add6, 0x9ee2dc9ed195bae9)
    },
    { /* i=216; 114 / 81 */
        RTUINT128_INIT_C(0x000021795e8dfe28, 0x70fbe411a1f15a2f), RTUINT128_INIT_C(0x000000000001ed54, 0xa21a5a7b6ef43324),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000115ed520), RTUINT128_INIT_C(0x000000000001a304, 0xd4b6ec4269a601af)
    },
    { /* i=217; 96 / 63 */
        RTUINT128_INIT_C(0x000000007f24b53e, 0x33648120c8a23039), RTUINT128_INIT_C(0x0000000000000000, 0x1cb71055442cbcb0),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000046d81568f), RTUINT128_INIT_C(0x0000000000000000, 0x0ff462f6a791a9e9)
    },
    { /* i=218; 118 / 74 */
        RTUINT128_INIT_C(0x002abaa4f041c003, 0xf64d88a959a826ce), RTUINT128_INIT_C(0x00000000000001fe, 0x4072182cfa57a9ab),
        RTUINT128_INIT_C(0x0000000000000000, 0x000015700fbef14e), RTUINT128_INIT_C(0x0000000000000191, 0x9f75a1779a4e79b4)
    },
    { /* i=219; 119 / 52 */
        RTUINT128_INIT_C(0x0065b4a02e93f3e5, 0x7a41342da2fd29c7), RTUINT128_INIT_C(0x0000000000000000, 0x000313ce5e570b3d),
        RTUINT128_INIT_C(0x0000000000000021, 0x0cae49a826060c8d), RTUINT128_INIT_C(0x0000000000000000, 0x0000b85a47171d2e)
    },
    { /* i=220; 117 / 63 */
        RTUINT128_INIT_C(0x0006fa009e0ea312, 0x062f761918b6e2ed), RTUINT128_INIT_C(0x0000000000000000, 0x6faf5d4823b5d937),
        RTUINT128_INIT_C(0x0000000000000000, 0x000ffdcdeedf86f2), RTUINT128_INIT_C(0x0000000000000000, 0x4a080dd1ce33c2ef)
    },
    { /* i=221; 117 / 53 */
        RTUINT128_INIT_C(0x000e49d24ea1caab, 0xe33efd030c5a62a5), RTUINT128_INIT_C(0x0000000000000000, 0x001e5ee1efa62516),
        RTUINT128_INIT_C(0x0000000000000000, 0x78707d7f73425feb), RTUINT128_INIT_C(0x0000000000000000, 0x00187c44f5672d73)
    },
    { /* i=222; 125 / 123 */
        RTUINT128_INIT_C(0x10e608a4e0ab0211, 0x4b17e9d55372bfb0), RTUINT128_INIT_C(0x026255c86587bd02, 0x91fe011b75077b97),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000007), RTUINT128_INIT_C(0x0035b02a19f4d6ff, 0x4d25e215203e5e8f)
    },
    { /* i=223; 118 / 104 */
        RTUINT128_INIT_C(0x00120bcdcc97e3b5, 0x5d8e7d9ace8760ff), RTUINT128_INIT_C(0x00000031789c3c05, 0x872802d2d42270b9),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000005d62), RTUINT128_INIT_C(0x0000000cdefae77e, 0x1736d1d51665052d)
    },
    { /* i=224; 36 / 26 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000008e508c0fd), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000227122),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000421c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000199d45)
    },
    { /* i=225; 94 / 96 */
        RTUINT128_INIT_C(0x00000000184e7009, 0x5e8d724ca7b2cf98), RTUINT128_INIT_C(0x00000000a598261f, 0x4ea4be809960c58c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00000000184e7009, 0x5e8d724ca7b2cf98)
    },
    { /* i=226; 114 / 35 */
        RTUINT128_INIT_C(0x000151626f8c82ff, 0xfe8e5dd757c698ab), RTUINT128_INIT_C(0x0000000000000000, 0x00000000fea64df2),
        RTUINT128_INIT_C(0x000000000001532c, 0x725a125392da62d4), RTUINT128_INIT_C(0x0000000000000000, 0x0000000068236843)
    },
    { /* i=227; 92 / 54 */
        RTUINT128_INIT_C(0x0000000002a92b2c, 0xef94c292f0d71882), RTUINT128_INIT_C(0x0000000000000000, 0x001bd99606fbfa6c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000001875620d0b), RTUINT128_INIT_C(0x0000000000000000, 0x00167abc9ef3d9de)
    },
    { /* i=228; 126 / 70 */
        RTUINT128_INIT_C(0x2bc39650b6c5453d, 0x781a361ddd39b0c6), RTUINT128_INIT_C(0x0000000000000016, 0x3ec0e0f8a01ca4b6),
        RTUINT128_INIT_C(0x0000000000000000, 0x01f7a46926e2dbc4), RTUINT128_INIT_C(0x0000000000000007, 0x41d9866859b7e36e)
    },
    { /* i=229; 120 / 83 */
        RTUINT128_INIT_C(0x007377213265d043, 0x5f7fae1d24fc3fa8), RTUINT128_INIT_C(0x00000000000417c3, 0xd7e78adbae9495dd),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000001c362b8e99), RTUINT128_INIT_C(0x000000000001af3f, 0x251dc73d98ef1893)
    },
    { /* i=230; 115 / 46 */
        RTUINT128_INIT_C(0x00040cf5c9dab6d7, 0xf52204a637bfae6f), RTUINT128_INIT_C(0x0000000000000000, 0x000036ad4890ee44),
        RTUINT128_INIT_C(0x0000000000000012, 0xf719ba00a541faff), RTUINT128_INIT_C(0x0000000000000000, 0x000016cf136ff0b3)
    },
    { /* i=231; 117 / 117 */
        RTUINT128_INIT_C(0x001a3674222b6831, 0xfc9046a154c75088), RTUINT128_INIT_C(0x000770b2de162031, 0x6f03a83d1e4646e8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003), RTUINT128_INIT_C(0x0003e45b87e9079d, 0xaf854de9f9f47bd0)
    },
    { /* i=232; 125 / 35 */
        RTUINT128_INIT_C(0x09ee6876ba676c6a, 0x69aa205b8e7521da), RTUINT128_INIT_C(0x0000000000000000, 0x00000007e8c36b93),
        RTUINT128_INIT_C(0x00000000014172ba, 0xd8dbfc524eb212ca), RTUINT128_INIT_C(0x0000000000000000, 0x00000002907be9dc)
    },
    { /* i=233; 65 / 40 */
        RTUINT128_INIT_C(0x0000000000000000, 0xfc884aac3d8c1bba), RTUINT128_INIT_C(0x0000000000000000, 0x000000ad43d33f53),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000001751e3d), RTUINT128_INIT_C(0x0000000000000000, 0x000000a50edb4af3)
    },
    { /* i=234; 74 / 54 */
        RTUINT128_INIT_C(0x0000000000000078, 0x9d0110e5a505634e), RTUINT128_INIT_C(0x0000000000000000, 0x00224cd610309813),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000038433), RTUINT128_INIT_C(0x0000000000000000, 0x000b315594b44b85)
    },
    { /* i=235; 120 / 99 */
        RTUINT128_INIT_C(0x005502d6eab6584e, 0x89969254a6273f2e), RTUINT128_INIT_C(0x0000000027e72530, 0xe53cc1bb22214084),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000002216510), RTUINT128_INIT_C(0x000000000d7fb476, 0xcdf7f9610c9b22ee)
    },
    { /* i=236; 121 / 46 */
        RTUINT128_INIT_C(0x0193fd4f1fefc9a2, 0x1c2c1ed644d966cb), RTUINT128_INIT_C(0x0000000000000000, 0x000015a93ea49911),
        RTUINT128_INIT_C(0x00000000000012a6, 0x83e466458f24690a), RTUINT128_INIT_C(0x0000000000000000, 0x0000134d4a3f7321)
    },
    { /* i=237; 125 / 117 */
        RTUINT128_INIT_C(0x16fa911e801f92f9, 0xd2d33bcfaaa92916), RTUINT128_INIT_C(0x001e30d392a22675, 0xce865dfde52c29df),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000c2), RTUINT128_INIT_C(0x001990c9613e6db3, 0x51000167ff316e18)
    },
    { /* i=238; 102 / 83 */
        RTUINT128_INIT_C(0x00000006dcba68de, 0xf4966de3aea6c927), RTUINT128_INIT_C(0x00000000000135da, 0x3b9af417998e8fcb),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000005ab68), RTUINT128_INIT_C(0x000000000000985f, 0x782180f243b8c5af)
    },
    { /* i=239; 115 / 78 */
        RTUINT128_INIT_C(0x0004e5493a492ccf, 0xcba84e5a8c81e8b2), RTUINT128_INIT_C(0x0000000000001119, 0x5a9f2dfd03afea3e),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000494bb3093e), RTUINT128_INIT_C(0x000000000000078f, 0xeb555ca38550ffae)
    },
    { /* i=240; 25 / 68 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000001e9cec6), RTUINT128_INIT_C(0x0000000000000008, 0x9f65b2590a86ab9c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000001e9cec6)
    },
    { /* i=241; 125 / 108 */
        RTUINT128_INIT_C(0x16533338aaed86d1, 0x21eefeec8c33e942), RTUINT128_INIT_C(0x0000040037b7e125, 0x9300006802b39346),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000005947f), RTUINT128_INIT_C(0x0000004f52cf3d31, 0x32aa9c41839b6188)
    },
    { /* i=242; 126 / 97 */
        RTUINT128_INIT_C(0x16a900c9cc0d894a, 0x5a5a98bcddc2d065), RTUINT128_INIT_C(0x000000005d9644a8, 0x5236b8675815986a),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000003dfc32a0), RTUINT128_INIT_C(0x000000004371c83a, 0x226b4e5e4e26da25)
    },
    { /* i=243; 125 / 89 */
        RTUINT128_INIT_C(0x186281c183dc36b6, 0x405d0f755fd6e287), RTUINT128_INIT_C(0x00000000000130be, 0x31cc5d4efd108517),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000147c082e9c1f), RTUINT128_INIT_C(0x000000000000b5aa, 0x9541606a079ac0be)
    },
    { /* i=244; 106 / 105 */
        RTUINT128_INIT_C(0x000002c7ee11df01, 0x36b2ebe265fb86fe), RTUINT128_INIT_C(0x00000105f1a2701a, 0xd9d2dbe2321abf7c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002), RTUINT128_INIT_C(0x000000bc0accfecb, 0x830d341e01c60806)
    },
    { /* i=245; 115 / 43 */
        RTUINT128_INIT_C(0x0005f1f4a140e5df, 0x215b35df5a93d3fc), RTUINT128_INIT_C(0x0000000000000000, 0x000002af40aae6e6),
        RTUINT128_INIT_C(0x0000000000000236, 0xecc79418ae9b5eb8), RTUINT128_INIT_C(0x0000000000000000, 0x0000002ffdb36aac)
    },
    { /* i=246; 114 / 14 */
        RTUINT128_INIT_C(0x0003b4f725460f95, 0xb0dd20b647c03153), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000246),
        RTUINT128_INIT_C(0x000001a16a12279d, 0x49c2cc97a03bb630), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000033)
    },
    { /* i=247; 118 / 87 */
        RTUINT128_INIT_C(0x003a630061b948f1, 0xbefe9f5121f2d3ba), RTUINT128_INIT_C(0x00000000003d7a50, 0x3906cac629a25b8c),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000f320e4ca), RTUINT128_INIT_C(0x00000000001ebf87, 0x40bfd0ae58cde742)
    },
    { /* i=248; 61 / 37 */
        RTUINT128_INIT_C(0x0000000000000000, 0x06bdcdfc96f60ac5), RTUINT128_INIT_C(0x0000000000000000, 0x0000001c9e5b1fa7),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000003c4dbb), RTUINT128_INIT_C(0x0000000000000000, 0x0000001816bcb0c8)
    },
    { /* i=249; 102 / 2 */
        RTUINT128_INIT_C(0x0000002aecf73022, 0x4f7d7da6b8405c8a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002),
        RTUINT128_INIT_C(0x00000015767b9811, 0x27bebed35c202e45), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=250; 74 / 4 */
        RTUINT128_INIT_C(0x00000000000002a1, 0x6d38415a88e36904), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000d),
        RTUINT128_INIT_C(0x0000000000000033, 0xcd5318b831ea1bc5), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003)
    },
    { /* i=251; 116 / 103 */
        RTUINT128_INIT_C(0x000be3a1b40a81bf, 0x541dee85c9067c00), RTUINT128_INIT_C(0x000000699e27ac88, 0x601882e45dfd4dfc),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001cd1), RTUINT128_INIT_C(0x0000001b3ec7bbe6, 0x31ca17cd58b24144)
    },
    { /* i=252; 123 / 103 */
        RTUINT128_INIT_C(0x055894da3aeacf88, 0x806f2fb1eeebc5b2), RTUINT128_INIT_C(0x0000003bef143c41, 0xb6bae04a74fb1692),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000016d5b8), RTUINT128_INIT_C(0x0000001d60971f34, 0x6719f945002012c2)
    },
    { /* i=253; 122 / 96 */
        RTUINT128_INIT_C(0x00d2e977163f37aa, 0x2ca4a3854392e662), RTUINT128_INIT_C(0x00000000e520c60e, 0x4943e8f4d8bcc82f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000eba5c8), RTUINT128_INIT_C(0x0000000025e005f1, 0x51addf3e7feb36aa)
    },
    { /* i=254; 127 / 50 */
        RTUINT128_INIT_C(0x27e1b90bb8023dbb, 0x2e9a7015f692c640), RTUINT128_INIT_C(0x0000000000000000, 0x00014d58b7320ac2),
        RTUINT128_INIT_C(0x0000000000001ea0, 0xc1a0dea4d37ef6c1), RTUINT128_INIT_C(0x0000000000000000, 0x0000566292063dfe)
    },
    { /* i=255; 123 / 121 */
        RTUINT128_INIT_C(0x006b9ec733e6fb82, 0x4ed9cc82ccf18c49), RTUINT128_INIT_C(0x0058661b0b882e06, 0x13a1a448557763c4),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x001338ac285ecd7c, 0x3b38283a777a2885)
    },
    { /* i=256; 86 / 36 */
        RTUINT128_INIT_C(0x000000000031ee7c, 0x2f5d2568e33be63b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000ca78e7d27),
        RTUINT128_INIT_C(0x0000000000000000, 0x0003f21cc422f7b0), RTUINT128_INIT_C(0x0000000000000000, 0x00000008bb573a6b)
    },
    { /* i=257; 61 / 101 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0cf84efc27f75abc), RTUINT128_INIT_C(0x000000016167fbf3, 0x75f630bf75740aa1),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0cf84efc27f75abc)
    },
    { /* i=258; 92 / 33 */
        RTUINT128_INIT_C(0x0000000005e47b84, 0x83c7b03d3e0b7123), RTUINT128_INIT_C(0x0000000000000000, 0x00000000a887f559),
        RTUINT128_INIT_C(0x0000000000000000, 0x08f36576cb4b74b5), RTUINT128_INIT_C(0x0000000000000000, 0x0000000006aba536)
    },
    { /* i=259; 110 / 44 */
        RTUINT128_INIT_C(0x0000200ecaf6487e, 0x5237cb13d0e0d7ba), RTUINT128_INIT_C(0x0000000000000000, 0x00000a2b59f10153),
        RTUINT128_INIT_C(0x0000000000000003, 0x270362e01c7ce325), RTUINT128_INIT_C(0x0000000000000000, 0x0000068d64ab0dbb)
    },
    { /* i=260; 123 / 94 */
        RTUINT128_INIT_C(0x03e0a1f42c7251a7, 0xa826b4924e51128d), RTUINT128_INIT_C(0x000000002381f853, 0x20a1193b29baa2b6),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000001bf49694), RTUINT128_INIT_C(0x000000000a21f545, 0x1c70fede8b9c5d55)
    },
    { /* i=261; 121 / 126 */
        RTUINT128_INIT_C(0x01a80c04528d4f7c, 0xf46e0616571245e2), RTUINT128_INIT_C(0x1160ffccd9eedcce, 0xb8006b36b24829f1),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x01a80c04528d4f7c, 0xf46e0616571245e2)
    },
    { /* i=262; 82 / 47 */
        RTUINT128_INIT_C(0x0000000000031a4b, 0x985a4d92732028f4), RTUINT128_INIT_C(0x0000000000000000, 0x000015663ebe4019),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000251e1e71e6), RTUINT128_INIT_C(0x0000000000000000, 0x00000898a8f9897e)
    },
    { /* i=263; 113 / 60 */
        RTUINT128_INIT_C(0x00010a7dd522d899, 0xfef5202c305bafcc), RTUINT128_INIT_C(0x0000000000000000, 0x032877c1bfc04bfc),
        RTUINT128_INIT_C(0x0000000000000000, 0x00546254c5bc34b7), RTUINT128_INIT_C(0x0000000000000000, 0x02fcf75855662ea8)
    },
    { /* i=264; 73 / 21 */
        RTUINT128_INIT_C(0x000000000000008a, 0x9b5bde6d84eca98b), RTUINT128_INIT_C(0x0000000000000000, 0x00000000001db73c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0004aa179fea990d), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000f7f7f)
    },
    { /* i=265; 123 / 108 */
        RTUINT128_INIT_C(0x07317381f62a03e2, 0x2666d974a619d9f5), RTUINT128_INIT_C(0x00000b5b3028785f, 0x24bb263829c58ee6),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000a227), RTUINT128_INIT_C(0x0000042403d37825, 0x1fb47c77449388eb)
    },
    { /* i=266; 101 / 81 */
        RTUINT128_INIT_C(0x000000082905f295, 0x8ea7b2c0f48cfb67), RTUINT128_INIT_C(0x0000000000013a1b, 0xf1da78816ee40e29),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000006a68f), RTUINT128_INIT_C(0x000000000000b306, 0xf871db33cd047c80)
    },
    { /* i=267; 105 / 63 */
        RTUINT128_INIT_C(0x000001eec6e2616c, 0x5d3e3158d4ec54c7), RTUINT128_INIT_C(0x0000000000000000, 0x1998bcd9ec811088),
        RTUINT128_INIT_C(0x0000000000000000, 0x000013546b8604d0), RTUINT128_INIT_C(0x0000000000000000, 0x0fb2167f289cc647)
    },
    { /* i=268; 58 / 42 */
        RTUINT128_INIT_C(0x0000000000000000, 0x03b5d96643415b37), RTUINT128_INIT_C(0x0000000000000000, 0x00000237f004bee4),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000001ac25), RTUINT128_INIT_C(0x0000000000000000, 0x00000208a36c9443)
    },
    { /* i=269; 112 / 109 */
        RTUINT128_INIT_C(0x000062c0bf024f78, 0x88102d02be5d0a32), RTUINT128_INIT_C(0x0000131f60ccda2d, 0x22179f9cfe14f4f2),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000005), RTUINT128_INIT_C(0x00000323db020c96, 0xdd9a0ef1c7f44178)
    },
    { /* i=270; 124 / 117 */
        RTUINT128_INIT_C(0x025cc1304349019c, 0x2e13996036beca3f), RTUINT128_INIT_C(0x0017e78c3c26a12f, 0x3d40953cbab00c3c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000019), RTUINT128_INIT_C(0x0007247e638343ff, 0x32c50671fb8d9863)
    },
    { /* i=271; 115 / 56 */
        RTUINT128_INIT_C(0x00005d8fbf3d359c, 0xa1b149c49d243385), RTUINT128_INIT_C(0x0000000000000000, 0x00d017457d32d66c),
        RTUINT128_INIT_C(0x0000000000000000, 0x00731a32055ec494), RTUINT128_INIT_C(0x0000000000000000, 0x0063d1ca77ed8d15)
    },
    { /* i=272; 98 / 111 */
        RTUINT128_INIT_C(0x00000002adcb01f3, 0x6fcbbedea960befe), RTUINT128_INIT_C(0x00004d1a31190f4e, 0x3d53601c6b8a1e48),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00000002adcb01f3, 0x6fcbbedea960befe)
    },
    { /* i=273; 125 / 120 */
        RTUINT128_INIT_C(0x1e2d7c15fcfe1810, 0xec4a5a631ffdcfa2), RTUINT128_INIT_C(0x0081f074c0de3485, 0xd3740f7397e202de),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000003b), RTUINT128_INIT_C(0x003b112d89c7fd39, 0x308acabf1ee72678)
    },
    { /* i=274; 118 / 90 */
        RTUINT128_INIT_C(0x00305e00e4c9fd75, 0x7e57e9b9591a3f40), RTUINT128_INIT_C(0x0000000002ed1d46, 0x647c4d0687da77ce),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000001087631f), RTUINT128_INIT_C(0x00000000015a76b6, 0x3a91c3b35baf134e)
    },
    { /* i=275; 112 / 101 */
        RTUINT128_INIT_C(0x00000e91ba895490, 0x5b86bf4e1ca27f94), RTUINT128_INIT_C(0x0000000483a80045, 0xfb7e04bb18c9b9b2),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000033a), RTUINT128_INIT_C(0x00000000ee7872c2, 0xe6eb7ba021c15740)
    },
    { /* i=276; 60 / 57 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0bcc3a6d49cf2e08), RTUINT128_INIT_C(0x0000000000000000, 0x01ee2f1bb858322c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000006), RTUINT128_INIT_C(0x0000000000000000, 0x00371fc6f7be0100)
    },
    { /* i=277; 120 / 123 */
        RTUINT128_INIT_C(0x004d59ad0ab07cc2, 0x0bbd296d15f54f7d), RTUINT128_INIT_C(0x05c87c7470df1c5c, 0x4e33aedb79ce7d34),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x004d59ad0ab07cc2, 0x0bbd296d15f54f7d)
    },
    { /* i=278; 123 / 71 */
        RTUINT128_INIT_C(0x0312fc700b0cb202, 0xad66465196a96322), RTUINT128_INIT_C(0x0000000000000058, 0xd40295332ca9286d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0008dc11c154395a), RTUINT128_INIT_C(0x000000000000002e, 0x6e6de329c86ce7d0)
    },
    { /* i=279; 118 / 12 */
        RTUINT128_INIT_C(0x0034c01b28e62244, 0x72602e2e5ddd7df0), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000108),
        RTUINT128_INIT_C(0x00003326e408a119, 0x78acf86ad7a0d6c7), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000b8)
    },
    { /* i=280; 70 / 66 */
        RTUINT128_INIT_C(0x000000000000001e, 0x3c5935daece01085), RTUINT128_INIT_C(0x0000000000000000, 0x2f53c6b50890b935),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000a3), RTUINT128_INIT_C(0x0000000000000000, 0x1a01b09678ba23c6)
    },
    { /* i=281; 127 / 125 */
        RTUINT128_INIT_C(0x5857f776d25fcfa2, 0x1b6e46f81a87a688), RTUINT128_INIT_C(0x15bab4c98189b4d8, 0x072772b3677a4986),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000004), RTUINT128_INIT_C(0x016d2450cc38fc41, 0xfed07c2a7c9e8070)
    },
    { /* i=282; 109 / 33 */
        RTUINT128_INIT_C(0x0000102cec11ba91, 0x1b2ef1fcb7fb1762), RTUINT128_INIT_C(0x0000000000000000, 0x00000000e42332af),
        RTUINT128_INIT_C(0x0000000000001226, 0xa78338af66a84fbe), RTUINT128_INIT_C(0x0000000000000000, 0x000000008c5f7880)
    },
    { /* i=283; 114 / 115 */
        RTUINT128_INIT_C(0x00033dd21a46a44e, 0x0ea1d4e941791897), RTUINT128_INIT_C(0x0004f6b4c82f6815, 0xe823a82f317c19e0),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00033dd21a46a44e, 0x0ea1d4e941791897)
    },
    { /* i=284; 113 / 49 */
        RTUINT128_INIT_C(0x00014d16b4908f98, 0x9aea3de2b6ddbc57), RTUINT128_INIT_C(0x0000000000000000, 0x000044e5b16d1dab),
        RTUINT128_INIT_C(0x0000000000000004, 0xd5a68a928c9dcc09), RTUINT128_INIT_C(0x0000000000000000, 0x000032c1d0846d54)
    },
    { /* i=285; 121 / 92 */
        RTUINT128_INIT_C(0x017cd7db9a8a39fa, 0xf66c31881aa618c8), RTUINT128_INIT_C(0x000000000476a901, 0x7a9369b364c507aa),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000005552d62d), RTUINT128_INIT_C(0x00000000003b12f0, 0xc43af41ac927a3e6)
    },
    { /* i=286; 83 / 72 */
        RTUINT128_INIT_C(0x000000000000e096, 0x9d5b894e97c3ea0d), RTUINT128_INIT_C(0x0000000000000075, 0x4dd4c57c7e13947b),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000001ea), RTUINT128_INIT_C(0x000000000000000f, 0xa41989054649b69f)
    },
    { /* i=287; 122 / 51 */
        RTUINT128_INIT_C(0x03c0344e0e0353d4, 0x75311188a0f9d29d), RTUINT128_INIT_C(0x0000000000000000, 0x00019355b0b0b21d),
        RTUINT128_INIT_C(0x0000000000000261, 0x732bf120ef598c26), RTUINT128_INIT_C(0x0000000000000000, 0x000061d8c642864f)
    },
    { /* i=288; 20 / 13 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000f5555), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000008c9),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000001be), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000727)
    },
    { /* i=289; 9 / 64 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000016a), RTUINT128_INIT_C(0x0000000000000000, 0x6094d4c0a8105d30),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000016a)
    },
    { /* i=290; 112 / 83 */
        RTUINT128_INIT_C(0x0000b9bc51c2e9b2, 0x948ab332c01767a6), RTUINT128_INIT_C(0x0000000000036f28, 0x1ea77c27d3e2a1c8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000036158194), RTUINT128_INIT_C(0x0000000000019720, 0xe030aaaf98241806)
    },
    { /* i=291; 120 / 68 */
        RTUINT128_INIT_C(0x00e87dd960c140f2, 0x93163aa1245fb5d0), RTUINT128_INIT_C(0x0000000000000003, 0x3206d3e1b67370fa),
        RTUINT128_INIT_C(0x0000000000000000, 0x0048c201718002f0), RTUINT128_INIT_C(0x0000000000000002, 0x1442c0085a43d770)
    },
    { /* i=292; 126 / 15 */
        RTUINT128_INIT_C(0x0b20c7803bf45354, 0x30688d34fe11c784), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000005727),
        RTUINT128_INIT_C(0x000020aff645c90a, 0xe19b6c14d9d63c1f), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000015cb)
    },
    { /* i=293; 57 / 51 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00e8b397fcc5c1a1), RTUINT128_INIT_C(0x0000000000000000, 0x00076cbff93f0b71),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000001f), RTUINT128_INIT_C(0x0000000000000000, 0x00028858ce235ef2)
    },
    { /* i=294; 97 / 54 */
        RTUINT128_INIT_C(0x000000013fd9952f, 0xfa491214f4cee7e6), RTUINT128_INIT_C(0x0000000000000000, 0x0013c2f12177c150),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000102f7df175bf), RTUINT128_INIT_C(0x0000000000000000, 0x0008f31034cc1d36)
    },
    { /* i=295; 120 / 57 */
        RTUINT128_INIT_C(0x00e51bfa1e21b841, 0x72f574530a397b1b), RTUINT128_INIT_C(0x0000000000000000, 0x0005d621ff0241be),
        RTUINT128_INIT_C(0x0000000000000027, 0x413ea5a6468895f9), RTUINT128_INIT_C(0x0000000000000000, 0x00023574cfd3f34d)
    },
    { /* i=296; 118 / 56 */
        RTUINT128_INIT_C(0x00131492709e0953, 0xb7665ab0e7286db4), RTUINT128_INIT_C(0x0000000000000000, 0x007a8d1f29ae6741),
        RTUINT128_INIT_C(0x0000000000000000, 0x27db7d444f9b0ad8), RTUINT128_INIT_C(0x0000000000000000, 0x0067d80b589dc4dc)
    },
    { /* i=297; 121 / 17 */
        RTUINT128_INIT_C(0x00757a017ef68dae, 0xa30395c3b699f184), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000b12e),
        RTUINT128_INIT_C(0x000000a9bcc132fa, 0xc87d44b523066473), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000061da)
    },
    { /* i=298; 125 / 60 */
        RTUINT128_INIT_C(0x0d16beb0e1fe1ef2, 0x231dc84b2d182b0f), RTUINT128_INIT_C(0x0000000000000000, 0x06fb85d41f75ce6d),
        RTUINT128_INIT_C(0x0000000000000001, 0xdfe0756b51ac526d), RTUINT128_INIT_C(0x0000000000000000, 0x00b958dfdd945ca6)
    },
    { /* i=299; 21 / 10 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000011880c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000047),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000003f36), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000012)
    },
    { /* i=300; 77 / 46 */
        RTUINT128_INIT_C(0x0000000000000934, 0xa93e3878de38ec9c), RTUINT128_INIT_C(0x0000000000000000, 0x000029d0adb2b9f7),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000385be90e), RTUINT128_INIT_C(0x0000000000000000, 0x000029c19063f21a)
    },
    { /* i=301; 126 / 90 */
        RTUINT128_INIT_C(0x32b771bfd30dfbb3, 0x8c284056b057de99), RTUINT128_INIT_C(0x00000000019cf6cb, 0xa7c43ecaee409274),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000001f708cca5d), RTUINT128_INIT_C(0x0000000000c26bf8, 0xc749093057e32275)
    },
    { /* i=302; 125 / 102 */
        RTUINT128_INIT_C(0x19ed75089633ee27, 0x542445cbbdd95ca3), RTUINT128_INIT_C(0x0000001287f114ff, 0x05ccb31c534c2d06),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000001662e4b), RTUINT128_INIT_C(0x0000000a142ad823, 0x5f603900b00d17e1)
    },
    { /* i=303; 99 / 32 */
        RTUINT128_INIT_C(0x0000000415e192c1, 0x51f31ff68145eb18), RTUINT128_INIT_C(0x0000000000000000, 0x00000000f7d08226),
        RTUINT128_INIT_C(0x0000000000000004, 0x386d6d692d4838ab), RTUINT128_INIT_C(0x0000000000000000, 0x0000000013d6abb6)
    },
    { /* i=304; 17 / 83 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000760d), RTUINT128_INIT_C(0x0000000000002487, 0x6c8e48e0281846c2),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000760d)
    },
    { /* i=305; 16 / 16 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000006382), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000002987),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001074)
    },
    { /* i=306; 125 / 105 */
        RTUINT128_INIT_C(0x14b7c49f5e86cd8f, 0xb8e2c96314dbcd63), RTUINT128_INIT_C(0x0000006efd262bca, 0xb257051f456c669d),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000002fc957), RTUINT128_INIT_C(0x0000002253f507ac, 0xd98cbf5989a0a908)
    },
    { /* i=307; 118 / 22 */
        RTUINT128_INIT_C(0x0016d68065dbf55a, 0x67484d61968c4304), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000a26e4),
        RTUINT128_INIT_C(0x000000023fe6b949, 0x6776452b07fcb24d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000040870)
    },
    { /* i=308; 123 / 77 */
        RTUINT128_INIT_C(0x05efecbca3d8be36, 0x259bd10fc0bdccdb), RTUINT128_INIT_C(0x0000000000000137, 0x3a01f9e99d9383d8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0004e23784dd75d5), RTUINT128_INIT_C(0x0000000000000093, 0xa25c00ef08476223)
    },
    { /* i=309; 38 / 18 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000022656aec0), RTUINT128_INIT_C(0x0000000000000000, 0x000000000001ca65),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000013359), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000032a3)
    },
    { /* i=310; 79 / 52 */
        RTUINT128_INIT_C(0x0000000000001042, 0x5de6e2a08c2aad2e), RTUINT128_INIT_C(0x0000000000000000, 0x000689c971c62cb4),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000027c9eac), RTUINT128_INIT_C(0x0000000000000000, 0x000152b8bc3d8c3e)
    },
    { /* i=311; 75 / 10 */
        RTUINT128_INIT_C(0x0000000000000252, 0xefd48ff17d702cb6), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000252),
        RTUINT128_INIT_C(0x0000000000000001, 0x00675c78a6231912), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000f2)
    },
    { /* i=312; 127 / 119 */
        RTUINT128_INIT_C(0x50c370a014dbc99f, 0x4e898b46c5b97f37), RTUINT128_INIT_C(0x003fe882bb6e28db, 0xfcb4e63da17511b0),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000143), RTUINT128_INIT_C(0x002113ad98de3c0f, 0x764b0b840f042e27)
    },
    { /* i=313; 126 / 118 */
        RTUINT128_INIT_C(0x33159047358e91e2, 0xdd79041b06f41004), RTUINT128_INIT_C(0x0027fd05a8adb55e, 0x4cfa915a054dfc5b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000147), RTUINT128_INIT_C(0x00015e0cbfabe66e, 0x89695a1e4056b7c7)
    },
    { /* i=314; 127 / 84 */
        RTUINT128_INIT_C(0x036a7696250931e4, 0xe43b0ff3d13f600d), RTUINT128_INIT_C(0x00000000000c9c62, 0xd1aaf7b2b1068461),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000045578a237a), RTUINT128_INIT_C(0x00000000000a44a1, 0xa1a543f23cc106d3)
    },
    { /* i=315; 73 / 15 */
        RTUINT128_INIT_C(0x00000000000001ba, 0x37b255f1e2def678), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000004b9e),
        RTUINT128_INIT_C(0x0000000000000000, 0x05d91dae23bb2a2c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000b50)
    },
    { /* i=316; 122 / 93 */
        RTUINT128_INIT_C(0x007358705a9bb74d, 0xb7beb634ea5d6101), RTUINT128_INIT_C(0x000000000ded0817, 0xf77b879e4e721c2c),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000848657d), RTUINT128_INIT_C(0x000000000333d7fb, 0x0cf267fc4b284385)
    },
    { /* i=317; 113 / 111 */
        RTUINT128_INIT_C(0x0000f811779c1a89, 0xb467fc8bbca7a90f), RTUINT128_INIT_C(0x000029d4f9e20d7c, 0x3b5915420a9d3012),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000005), RTUINT128_INIT_C(0x000026e89631d71c, 0x8baa92418795b8b5)
    },
    { /* i=318; 119 / 62 */
        RTUINT128_INIT_C(0x00186a8107d0aebc, 0x4e977d71557b8560), RTUINT128_INIT_C(0x0000000000000000, 0x063daf2fe3520783),
        RTUINT128_INIT_C(0x0000000000000000, 0x03e987b84bbc02d2), RTUINT128_INIT_C(0x0000000000000000, 0x01b4f4c952ee55ea)
    },
    { /* i=319; 118 / 54 */
        RTUINT128_INIT_C(0x003056720a6bf8db, 0x745b23902d5f8db2), RTUINT128_INIT_C(0x0000000000000000, 0x001263aaaa330611),
        RTUINT128_INIT_C(0x0000000000000002, 0xa0ea28fba81b5280), RTUINT128_INIT_C(0x0000000000000000, 0x000799aef0201332)
    },
    { /* i=320; 101 / 44 */
        RTUINT128_INIT_C(0x00000002015c9f4b, 0x5a334f60bf5a3264), RTUINT128_INIT_C(0x0000000000000000, 0x00000d9076422b39),
        RTUINT128_INIT_C(0x0000000000000000, 0x0025d8b5f1c94aa5), RTUINT128_INIT_C(0x0000000000000000, 0x00000323cd74dca7)
    },
    { /* i=321; 92 / 48 */
        RTUINT128_INIT_C(0x000000000a3a96b7, 0x5d030ce222cdb222), RTUINT128_INIT_C(0x0000000000000000, 0x00005f3be74d1c49),
        RTUINT128_INIT_C(0x0000000000000000, 0x00001b7f11c03712), RTUINT128_INIT_C(0x0000000000000000, 0x0000280d3e8e0600)
    },
    { /* i=322; 118 / 8 */
        RTUINT128_INIT_C(0x002b8e911169f0bc, 0x60a0e0177735ca64), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000003f),
        RTUINT128_INIT_C(0x0000b0fe3d3a920b, 0x1dfa6d3532a774fd), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000021)
    },
    { /* i=323; 91 / 119 */
        RTUINT128_INIT_C(0x0000000004855b7c, 0xff20a6894340c01a), RTUINT128_INIT_C(0x00721211f0f32f6e, 0xa09772948c4558ba),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000004855b7c, 0xff20a6894340c01a)
    },
    { /* i=324; 71 / 40 */
        RTUINT128_INIT_C(0x0000000000000011, 0xc8db34d5b048c381), RTUINT128_INIT_C(0x0000000000000000, 0x000000e8a90f08fe),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000139194e9), RTUINT128_INIT_C(0x0000000000000000, 0x000000282e88bc53)
    },
    { /* i=325; 109 / 44 */
        RTUINT128_INIT_C(0x000019c26857a95e, 0x3fa765c46882b1ac), RTUINT128_INIT_C(0x0000000000000000, 0x00000923f3556490),
        RTUINT128_INIT_C(0x0000000000000002, 0xd174685c4af086ff), RTUINT128_INIT_C(0x0000000000000000, 0x000006b66cd0263c)
    },
    { /* i=326; 120 / 121 */
        RTUINT128_INIT_C(0x0006f2ad81a3a177, 0x898d7f0e1d23212f), RTUINT128_INIT_C(0x0129bb20f4a7061a, 0x83829e1b8b329ebc),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0006f2ad81a3a177, 0x898d7f0e1d23212f)
    },
    { /* i=327; 128 / 111 */
        RTUINT128_INIT_C(0x4d9c1d53074f9f7c, 0x7170073acc4ff10f), RTUINT128_INIT_C(0x00004268a8ab012d, 0x566b8ee1ed1432cc),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000012b2d), RTUINT128_INIT_C(0x000033eda6e07694, 0xa0a6099d886ebf33)
    },
    { /* i=328; 124 / 84 */
        RTUINT128_INIT_C(0x05e545109dd17956, 0x6734d6a1eb2ed517), RTUINT128_INIT_C(0x00000000000439a7, 0xbb5035ce543a6bfe),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000016534943c93), RTUINT128_INIT_C(0x0000000000017016, 0x91ac6c7dd57b4a3d)
    },
    { /* i=329; 122 / 94 */
        RTUINT128_INIT_C(0x000308cba703f43d, 0x9c1d011adb9e3964), RTUINT128_INIT_C(0x000000000e592591, 0x0fa08bbbc0603b54),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000362386), RTUINT128_INIT_C(0x00000000079e294f, 0x015e9d3a7d6aaf6c)
    },
    { /* i=330; 127 / 117 */
        RTUINT128_INIT_C(0x44500dfb455aa442, 0x27c85f32bffad091), RTUINT128_INIT_C(0x000d775f6d82118e, 0xcdb601898f6852c5),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000512), RTUINT128_INIT_C(0x0008cc2207dd9e33, 0x22f493b9a10725b7)
    },
    { /* i=331; 118 / 28 */
        RTUINT128_INIT_C(0x0001ede8e0d46da4, 0x2a0265a87289a396), RTUINT128_INIT_C(0x0000000000000000, 0x0000000002fb01b8),
        RTUINT128_INIT_C(0x0000000000a5b6c7, 0x4ced3e0d8116a13d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000002d582be)
    },
    { /* i=332; 28 / 3 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000a4e601c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000527300e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=333; 122 / 100 */
        RTUINT128_INIT_C(0x021b2cfcb471a9dd, 0xd9b1578287f52919), RTUINT128_INIT_C(0x00000009b2c26eba, 0x302ea5426918fa84),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000379851), RTUINT128_INIT_C(0x00000001e92dba53, 0x678b0aba9ff38555)
    },
    { /* i=334; 116 / 105 */
        RTUINT128_INIT_C(0x0008ddd5a89266fc, 0x2e38b2903013479a), RTUINT128_INIT_C(0x00000003770df7d0, 0xaa6010e26c18d50a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000028f10), RTUINT128_INIT_C(0x000000017aa40605, 0xbd0451d5e57160fa)
    },
    { /* i=335; 125 / 93 */
        RTUINT128_INIT_C(0x052b615b0414e83b, 0xca88f29ce069208c), RTUINT128_INIT_C(0x000000001a5e2f4a, 0xa1890c033dbd7709),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000003230658b), RTUINT128_INIT_C(0x0000000018bdbaf0, 0x20b790b886e2f1a9)
    },
    { /* i=336; 18 / 125 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000018aee), RTUINT128_INIT_C(0x017d8956ac535193, 0x834a1b4366dd09e1),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000018aee)
    },
    { /* i=337; 125 / 45 */
        RTUINT128_INIT_C(0x0d054b9cddb4528c, 0x5bbabbc812a80a5f), RTUINT128_INIT_C(0x0000000000000000, 0x000015ac9821c78d),
        RTUINT128_INIT_C(0x00000000000099ca, 0x7c0c3b274341d8ae), RTUINT128_INIT_C(0x0000000000000000, 0x000002d399867089)
    },
    { /* i=338; 126 / 87 */
        RTUINT128_INIT_C(0x2c949c3c23990b9a, 0x5bf2f7398726ad64), RTUINT128_INIT_C(0x00000000007a1031, 0x2e18a8b361cb52a4),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000005d7f5cfc0a), RTUINT128_INIT_C(0x000000000063ea96, 0x2413c34e80ec02fc)
    },
    { /* i=339; 111 / 105 */
        RTUINT128_INIT_C(0x00006b714dcf6b59, 0x54531609ba6570ca), RTUINT128_INIT_C(0x00000012ab5824e0, 0xf128f9fe4eb42974),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000005c1), RTUINT128_INIT_C(0x0000000567a3390d, 0xb78ca5c6dfc2ec56)
    },
    { /* i=340; 105 / 28 */
        RTUINT128_INIT_C(0x0000013df1aeea4b, 0x3aba2a36ec4691c8), RTUINT128_INIT_C(0x0000000000000000, 0x00000000007eca1f),
        RTUINT128_INIT_C(0x00000000000281f5, 0x80ef65041fda937e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000694986)
    },
    { /* i=341; 114 / 88 */
        RTUINT128_INIT_C(0x0000313fd84a6975, 0x6288d268c689e1ce), RTUINT128_INIT_C(0x00000000007cf79e, 0xd5a74320dbc50c4a),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000064e3a1), RTUINT128_INIT_C(0x00000000001561c7, 0x7afb9ee608cf8944)
    },
    { /* i=342; 33 / 32 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000362a0f6e), RTUINT128_INIT_C(0x0000000000000000, 0x000000003a2f6bf4),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00000000362a0f6e)
    },
    { /* i=343; 115 / 83 */
        RTUINT128_INIT_C(0x000100268ad38a0f, 0xa1551b7d33f601d3), RTUINT128_INIT_C(0x00000000000342d9, 0x3487b6204486adc8),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000004e8bf0ad), RTUINT128_INIT_C(0x000000000002dcda, 0x2e7a895d566f11ab)
    },
    { /* i=344; 118 / 94 */
        RTUINT128_INIT_C(0x001002c0efa5da76, 0x4cec804a5b1f7637), RTUINT128_INIT_C(0x000000002e4a8d29, 0xbaf18d4a057fe5db),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000588af4), RTUINT128_INIT_C(0x000000001a268ce1, 0x57160acf2808537b)
    },
    { /* i=345; 50 / 27 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00036f54a68b9b3e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000f82d85),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000038b0bbc), RTUINT128_INIT_C(0x0000000000000000, 0x00000000001e7692)
    },
    { /* i=346; 123 / 94 */
        RTUINT128_INIT_C(0x0397ebbb76a1c755, 0xea41a03001dcf6eb), RTUINT128_INIT_C(0x000000000824fd97, 0x91dfc58fedf696d9),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000070f3349a), RTUINT128_INIT_C(0x00000000062d12af, 0x35c8c834a4e72461)
    },
    { /* i=347; 128 / 79 */
        RTUINT128_INIT_C(0x31ed4984a8502af2, 0x0c39c02688e36548), RTUINT128_INIT_C(0x000000000000602e, 0xa3e1ef5f891c25d9),
        RTUINT128_INIT_C(0x0000000000000000, 0x000084e2df27893f), RTUINT128_INIT_C(0x0000000000002dca, 0x902b016fefa5f3e1)
    },
    { /* i=348; 21 / 12 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000172920), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000379),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000006ab), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000014d)
    },
    { /* i=349; 118 / 63 */
        RTUINT128_INIT_C(0x002f96525dabe3f8, 0x0357e02d079790de), RTUINT128_INIT_C(0x0000000000000000, 0x60c62d4f19d705d4),
        RTUINT128_INIT_C(0x0000000000000000, 0x007de252c5434262), RTUINT128_INIT_C(0x0000000000000000, 0x32ace291094aadb6)
    },
    { /* i=350; 120 / 33 */
        RTUINT128_INIT_C(0x00259437752e3918, 0x1f00eae092155246), RTUINT128_INIT_C(0x0000000000000000, 0x000000012e1ca962),
        RTUINT128_INIT_C(0x00000000001fd7dd, 0x0eac1f544d513886), RTUINT128_INIT_C(0x0000000000000000, 0x00000000180538fa)
    },
    { /* i=351; 126 / 90 */
        RTUINT128_INIT_C(0x3a6dfac4e4183a72, 0x7b95d3a36cb6ca47), RTUINT128_INIT_C(0x0000000001849e8b, 0xb481eca22b9bf959),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000267d74584c), RTUINT128_INIT_C(0x00000000007ec76f, 0x59bde5dd6b5e2bdb)
    },
    { /* i=352; 59 / 119 */
        RTUINT128_INIT_C(0x0000000000000000, 0x02722201e7624f0d), RTUINT128_INIT_C(0x000e80a611e7bb85, 0x9c127134899380f1),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x02722201e7624f0d)
    },
    { /* i=353; 66 / 26 */
        RTUINT128_INIT_C(0x0000000000000001, 0x84926fff38ceb256), RTUINT128_INIT_C(0x0000000000000000, 0x0000000001eaea5d),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000caa166d898), RTUINT128_INIT_C(0x0000000000000000, 0x000000000187131e)
    },
    { /* i=354; 115 / 96 */
        RTUINT128_INIT_C(0x0003b311b4cac8de, 0x46ed30502217d7dc), RTUINT128_INIT_C(0x00000000f32bc33c, 0xfffce331aea0e3ec),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000003e508), RTUINT128_INIT_C(0x00000000ac101e02, 0x663599aa156a9c7c)
    },
    { /* i=355; 122 / 103 */
        RTUINT128_INIT_C(0x02c7b6328f2c82c4, 0xca4637bf0974d129), RTUINT128_INIT_C(0x0000002e36fb57ba, 0xff2125187721469b),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000f666c), RTUINT128_INIT_C(0x00000011143a0b48, 0xc713d702623445c5)
    },
    { /* i=356; 115 / 100 */
        RTUINT128_INIT_C(0x0002267e1dc53f7c, 0x941438bcf3bde28e), RTUINT128_INIT_C(0x00000005dbb71fa3, 0xbf71bdb56d30887d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000005df7), RTUINT128_INIT_C(0x0000000599973bf2, 0x8b6b4605f854c8f3)
    },
    { /* i=357; 118 / 64 */
        RTUINT128_INIT_C(0x000a331159cbdb43, 0x8a0a7ee3d35b405b), RTUINT128_INIT_C(0x0000000000000000, 0xeb66a26e29e3034d),
        RTUINT128_INIT_C(0x0000000000000000, 0x000b178d8a0c5d32), RTUINT128_INIT_C(0x0000000000000000, 0xab9aad538335a251)
    },
    { /* i=358; 115 / 55 */
        RTUINT128_INIT_C(0x00021b11d5387d04, 0xaad1286f7b18927d), RTUINT128_INIT_C(0x0000000000000000, 0x004e4e6463ae4038),
        RTUINT128_INIT_C(0x0000000000000000, 0x06e255e5997c022e), RTUINT128_INIT_C(0x0000000000000000, 0x004cd2bda228986d)
    },
    { /* i=359; 64 / 30 */
        RTUINT128_INIT_C(0x0000000000000000, 0x8035593ebc212bb5), RTUINT128_INIT_C(0x0000000000000000, 0x000000002883341e),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000032a27416e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000026f328d1)
    },
    { /* i=360; 113 / 38 */
        RTUINT128_INIT_C(0x00013488775eaee8, 0x8ae21e500a6ca197), RTUINT128_INIT_C(0x0000000000000000, 0x0000000d23fe17b6),
        RTUINT128_INIT_C(0x000000000000177a, 0xb8c83ff8ab955b43), RTUINT128_INIT_C(0x0000000000000000, 0x00000009ed90baf5)
    },
    { /* i=361; 124 / 8 */
        RTUINT128_INIT_C(0x08e16f1e281e1643, 0x614d9d7cf126dbde), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000003a),
        RTUINT128_INIT_C(0x00273277b13e4fd5, 0x0617683b8892533d), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000c)
    },
    { /* i=362; 124 / 104 */
        RTUINT128_INIT_C(0x013c4a2b3d822fad, 0xeb11555a6cda309c), RTUINT128_INIT_C(0x000000fb986ded26, 0xfca8b6f1a65adbe6),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000141d3), RTUINT128_INIT_C(0x000000aac489d5bc, 0x1e9d8a96623b8c0a)
    },
    { /* i=363; 120 / 29 */
        RTUINT128_INIT_C(0x006c499010acd174, 0xb92141af88f0b08b), RTUINT128_INIT_C(0x0000000000000000, 0x000000000a9edf76),
        RTUINT128_INIT_C(0x000000000a322b7b, 0x8ad8aeceed33f602), RTUINT128_INIT_C(0x0000000000000000, 0x0000000006758d9f)
    },
    { /* i=364; 113 / 78 */
        RTUINT128_INIT_C(0x0000ba40a8e3cbf3, 0xb04dfb12c888efee), RTUINT128_INIT_C(0x00000000000002c3, 0x90da3e325ef360aa),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000043630b2086), RTUINT128_INIT_C(0x00000000000000dd, 0x95b6a181c3c116f2)
    },
    { /* i=365; 113 / 125 */
        RTUINT128_INIT_C(0x000029ef9026e41f, 0xdb23f4832492ae61), RTUINT128_INIT_C(0x1d1abfcca528bb21, 0x283054a1e93bdf00),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000029ef9026e41f, 0xdb23f4832492ae61)
    },
    { /* i=366; 118 / 69 */
        RTUINT128_INIT_C(0x0025c8dcdcccb212, 0x8a46a4da4f01cdac), RTUINT128_INIT_C(0x000000000000001d, 0x94664d9754185461),
        RTUINT128_INIT_C(0x0000000000000000, 0x00014702a4ab8b91), RTUINT128_INIT_C(0x0000000000000019, 0x6e463569f69e57bb)
    },
    { /* i=367; 117 / 24 */
        RTUINT128_INIT_C(0x001cef72770c2df1, 0x9df5cde4db05ccaf), RTUINT128_INIT_C(0x0000000000000000, 0x00000000004b1689),
        RTUINT128_INIT_C(0x0000000062a671e5, 0x53b194b5688ec4b7), RTUINT128_INIT_C(0x0000000000000000, 0x000000000019ccc0)
    },
    { /* i=368; 4 / 101 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000c), RTUINT128_INIT_C(0x0000000ca964dd87, 0x06a90b8d0d010610),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000c)
    },
    { /* i=369; 128 / 123 */
        RTUINT128_INIT_C(0x8e4119281e1f531e, 0xba491f40429b8d14), RTUINT128_INIT_C(0x06f8e81707ae8e4d, 0x54f1c2f3dc9b0d14),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000014), RTUINT128_INIT_C(0x02cef75b847c3514, 0x1765e433067e8784)
    },
    { /* i=370; 86 / 41 */
        RTUINT128_INIT_C(0x0000000000058b89, 0xc7f0049f16102b9c), RTUINT128_INIT_C(0x0000000000000000, 0x000000c9227c4166),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000070ec21876b2), RTUINT128_INIT_C(0x0000000000000000, 0x0000001667f5aeb0)
    },
    { /* i=371; 116 / 79 */
        RTUINT128_INIT_C(0x000c532991630b99, 0xc3d6f7192ee38380), RTUINT128_INIT_C(0x0000000000004bd5, 0x7350401552ed48c5),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000299b358c2d), RTUINT128_INIT_C(0x0000000000004230, 0x260f8c437f98fcdf)
    },
    { /* i=372; 114 / 83 */
        RTUINT128_INIT_C(0x00013dc95d39e087, 0x5d04701024d2ff25), RTUINT128_INIT_C(0x0000000000044022, 0x7c3b0442274c2133),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000004ac3992b), RTUINT128_INIT_C(0x000000000000ce4d, 0xdbcf3ee10358f094)
    },
    { /* i=373; 80 / 78 */
        RTUINT128_INIT_C(0x000000000000cc09, 0x904929cbcfce5b82), RTUINT128_INIT_C(0x0000000000003405, 0x288d506431c3ea6c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003), RTUINT128_INIT_C(0x0000000000002ffa, 0x16a1389f3a829c3e)
    },
    { /* i=374; 123 / 57 */
        RTUINT128_INIT_C(0x03177044308fdcc0, 0xfd981644f0ad5a41), RTUINT128_INIT_C(0x0000000000000000, 0x01dcfc84ee6f9948),
        RTUINT128_INIT_C(0x0000000000000001, 0xa8c47339207d2417), RTUINT128_INIT_C(0x0000000000000000, 0x00afdc1cfaf074c9)
    },
    { /* i=375; 104 / 87 */
        RTUINT128_INIT_C(0x000000e383314302, 0x7ca7c8192be0a230), RTUINT128_INIT_C(0x0000000000747764, 0xd42e0ee2363c61ec),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000001f415), RTUINT128_INIT_C(0x0000000000728953, 0x1fcebd9cc9aba9d4)
    },
    { /* i=376; 120 / 104 */
        RTUINT128_INIT_C(0x0048cd93d7eb83d2, 0x0c0c8c1cf2ba8db3), RTUINT128_INIT_C(0x000000f4749078dd, 0x6878f543f2bdd74c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000004c3d), RTUINT128_INIT_C(0x000000b92d9cfc0c, 0x3e69eedbbf93b097)
    },
    { /* i=377; 126 / 90 */
        RTUINT128_INIT_C(0x095529eb2c2039ba, 0x6b2999d1c2d8e798), RTUINT128_INIT_C(0x000000000142a823, 0x079b772d0b4b667a),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000076797ca14), RTUINT128_INIT_C(0x000000000046271b, 0x6ccdf258da22a210)
    },
    { /* i=378; 128 / 32 */
        RTUINT128_INIT_C(0x9d5efb48ef6bfd19, 0x7b351725ce721944), RTUINT128_INIT_C(0x0000000000000000, 0x000000006652419b),
        RTUINT128_INIT_C(0x0000000189bae831, 0x799b541cca3eec72), RTUINT128_INIT_C(0x0000000000000000, 0x0000000037cbfe3e)
    },
    { /* i=379; 105 / 62 */
        RTUINT128_INIT_C(0x000000dd91b3b3b9, 0x3e1bc26ccfb56691), RTUINT128_INIT_C(0x0000000000000000, 0x22ced0a89868faf8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000065d90bc646b), RTUINT128_INIT_C(0x0000000000000000, 0x0298ba104baba0e9)
    },
    { /* i=380; 25 / 17 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000001dc6833), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000af9c),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000002b6), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000574b)
    },
    { /* i=381; 118 / 113 */
        RTUINT128_INIT_C(0x001ae73aafd1265e, 0x599f08f498872b58), RTUINT128_INIT_C(0x0000ef1bc72130f0, 0x78ae6e701bd1fd41),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000001c), RTUINT128_INIT_C(0x0000c030e82fcc11, 0x268af4b18d8f783c)
    },
    { /* i=382; 60 / 25 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0f8bb9e2cd87da56), RTUINT128_INIT_C(0x0000000000000000, 0x00000000012abfea),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000d523f023e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000001178baa)
    },
    { /* i=383; 115 / 100 */
        RTUINT128_INIT_C(0x00053e03ab79a5fa, 0x125fec5f2699ceba), RTUINT128_INIT_C(0x000000005db04f2d, 0xde2745f17636158f),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000e52fd), RTUINT128_INIT_C(0x00000000465c8e57, 0x1df3fdead26cb267)
    },
    { /* i=384; 23 / 12 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000389ba0), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000003b1),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000f55), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000002db)
    },
    { /* i=385; 55 / 2 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0076ccfc8716a4ab), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001),
        RTUINT128_INIT_C(0x0000000000000000, 0x0076ccfc8716a4ab), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=386; 6 / 38 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000a), RTUINT128_INIT_C(0x0000000000000000, 0x00000009ada125d2),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000a)
    },
    { /* i=387; 22 / 12 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000082e46), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000d89),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000009a), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000009dc)
    },
    { /* i=388; 96 / 53 */
        RTUINT128_INIT_C(0x00000000d911a2a7, 0xb126cb96c3e7415f), RTUINT128_INIT_C(0x0000000000000000, 0x001d0963507bce44),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000779c6371e49), RTUINT128_INIT_C(0x0000000000000000, 0x0007149065d177fb)
    },
    { /* i=389; 125 / 14 */
        RTUINT128_INIT_C(0x1ba31d6a02b34f15, 0xbcc768b9337b0989), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001229),
        RTUINT128_INIT_C(0x0001859871c4208f, 0x8f8aa49d1641f0a3), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000096e)
    },
    { /* i=390; 118 / 118 */
        RTUINT128_INIT_C(0x00136110655052be, 0xa9785ed33046ec6b), RTUINT128_INIT_C(0x0018e684291c6d24, 0xf0dd7060116b3355),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00136110655052be, 0xa9785ed33046ec6b)
    },
    { /* i=391; 80 / 64 */
        RTUINT128_INIT_C(0x0000000000009601, 0x9b96271a0bee6495), RTUINT128_INIT_C(0x0000000000000000, 0xd583093839e1be41),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000b3db), RTUINT128_INIT_C(0x0000000000000000, 0x550af387afc92ffa)
    },
    { /* i=392; 120 / 121 */
        RTUINT128_INIT_C(0x006eb57665fbbdb7, 0xf8b2def2493fef14), RTUINT128_INIT_C(0x010ee7573b8246a4, 0x175552b07d2a166e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x006eb57665fbbdb7, 0xf8b2def2493fef14)
    },
    { /* i=393; 40 / 6 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000465b19b9ae), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000009),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000007d13bbf4c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002)
    },
    { /* i=394; 123 / 123 */
        RTUINT128_INIT_C(0x03bd4d6a41039c54, 0x57f6fa079e1491f1), RTUINT128_INIT_C(0x0342982eecc2352d, 0x956e79ffe0d107f7),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x007ab53b54416726, 0xc2888007bd4389fa)
    },
    { /* i=395; 97 / 90 */
        RTUINT128_INIT_C(0x0000000043bcb60a, 0xe1ba16e29fcdae25), RTUINT128_INIT_C(0x000000000195f122, 0xc6710bcfb251ca12),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000002a), RTUINT128_INIT_C(0x0000000001232656, 0x532e26cf5e628731)
    },
    { /* i=396; 121 / 124 */
        RTUINT128_INIT_C(0x0163eeb94d72c847, 0xcc1a39ecf9a5d481), RTUINT128_INIT_C(0x0ca06402bc8c4104, 0x8d9e250eeda67fd8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0163eeb94d72c847, 0xcc1a39ecf9a5d481)
    },
    { /* i=397; 114 / 123 */
        RTUINT128_INIT_C(0x000012efde6a3d5c, 0x296036f08ea85547), RTUINT128_INIT_C(0x055b0b89854e2e4d, 0x1c410c8fee988817),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000012efde6a3d5c, 0x296036f08ea85547)
    },
    { /* i=398; 41 / 3 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000001904979ece7), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000006),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000042b6e9a77b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000005)
    },
    { /* i=399; 119 / 120 */
        RTUINT128_INIT_C(0x00239dfa19220921, 0x99de49cc6f305f96), RTUINT128_INIT_C(0x00ea7d65dd69a5ba, 0xae6cac46397dd99f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00239dfa19220921, 0x99de49cc6f305f96)
    },
    { /* i=400; 64 / 99 */
        RTUINT128_INIT_C(0x0000000000000000, 0xaaa4d40b4cf079a2), RTUINT128_INIT_C(0x00000006908713ff, 0xd06b60f5a2c88a63),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0xaaa4d40b4cf079a2)
    },
    { /* i=401; 114 / 55 */
        RTUINT128_INIT_C(0x0003df0c51a4acf9, 0xa5cbb438bb7a3652), RTUINT128_INIT_C(0x0000000000000000, 0x006efb209bce00d5),
        RTUINT128_INIT_C(0x0000000000000000, 0x08ee0d72a829f88f), RTUINT128_INIT_C(0x0000000000000000, 0x004081ae387c6757)
    },
    { /* i=402; 115 / 16 */
        RTUINT128_INIT_C(0x0000de5fd4527286, 0x00a7d9f2c2aaf9a2), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000066c6),
        RTUINT128_INIT_C(0x0000000229ea70ee, 0xaf792f80481b94eb), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000029e0)
    },
    { /* i=403; 121 / 98 */
        RTUINT128_INIT_C(0x019475a24d030af1, 0x3fb042d1a43485ef), RTUINT128_INIT_C(0x000000035ba7b7e6, 0x67c85ecca4b7a57a),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000078720f), RTUINT128_INIT_C(0x000000010a4a044d, 0x80ce5d64a4917fc9)
    },
    { /* i=404; 116 / 113 */
        RTUINT128_INIT_C(0x00041f5d3b0ddad7, 0x1cef5e0c9994d733), RTUINT128_INIT_C(0x00019b30c84952c3, 0xe7ed283cdd9a2b61),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002), RTUINT128_INIT_C(0x0000e8fbaa7b354f, 0x4d150d92de608071)
    },
    { /* i=405; 127 / 32 */
        RTUINT128_INIT_C(0x5d1df2f50db0317b, 0xe412d95fb15114fd), RTUINT128_INIT_C(0x0000000000000000, 0x00000000ce5854b9),
        RTUINT128_INIT_C(0x00000000738652b4, 0x463a92ad5bfdf1da), RTUINT128_INIT_C(0x0000000000000000, 0x000000005481c673)
    },
    { /* i=406; 64 / 63 */
        RTUINT128_INIT_C(0x0000000000000000, 0x586a53b918d281a3), RTUINT128_INIT_C(0x0000000000000000, 0x49a856c7294a65e2),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x0000000000000000, 0x0ec1fcf1ef881bc1)
    },
    { /* i=407; 52 / 37 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0009d527ae191fd0), RTUINT128_INIT_C(0x0000000000000000, 0x00000017ff959103),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000068e3), RTUINT128_INIT_C(0x0000000000000000, 0x0000000b49905227)
    },
    { /* i=408; 124 / 32 */
        RTUINT128_INIT_C(0x00f64c5de0a1ff83, 0xfc8bd8d70c3f4dcf), RTUINT128_INIT_C(0x0000000000000000, 0x0000000036a254e0),
        RTUINT128_INIT_C(0x0000000004821595, 0xc22b236615bbd7c6), RTUINT128_INIT_C(0x0000000000000000, 0x0000000015c9888f)
    },
    { /* i=409; 54 / 13 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00177ef345532b8b), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000013a1),
        RTUINT128_INIT_C(0x0000000000000000, 0x000001326eebf1b1), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000083a)
    },
    { /* i=410; 99 / 55 */
        RTUINT128_INIT_C(0x00000001a5d06081, 0x8db51e9ade7fbfd2), RTUINT128_INIT_C(0x0000000000000000, 0x00037c52a6afa4c7),
        RTUINT128_INIT_C(0x0000000000000000, 0x00007903d1a590ff), RTUINT128_INIT_C(0x0000000000000000, 0x0001f8735d97ad99)
    },
    { /* i=411; 106 / 75 */
        RTUINT128_INIT_C(0x00000109ee50ec07, 0x4ba1495e6495134b), RTUINT128_INIT_C(0x000000000000025c, 0x5b37787a5383c2e0),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000070a55fac), RTUINT128_INIT_C(0x00000000000000aa, 0x41457901c85d04cb)
    },
    { /* i=412; 113 / 108 */
        RTUINT128_INIT_C(0x00015682726869ef, 0xfedc0a6eea81e025), RTUINT128_INIT_C(0x00000df51edf96fd, 0x6dee61c17e10276c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000018), RTUINT128_INIT_C(0x000007878d72422d, 0xb082e04b18fe2e05)
    },
    { /* i=413; 102 / 83 */
        RTUINT128_INIT_C(0x0000002d43088669, 0x2d733e511181f615), RTUINT128_INIT_C(0x00000000000283c8, 0xa695e2f1045d2c77),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000011ff92), RTUINT128_INIT_C(0x0000000000017016, 0xcce87353d12d1137)
    },
    { /* i=414; 127 / 114 */
        RTUINT128_INIT_C(0x39b3ee3c480d99dd, 0x03f54d574b216aa3), RTUINT128_INIT_C(0x000203e9911182bb, 0xd8c11ad5c2caf273),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001ca1), RTUINT128_INIT_C(0x0001ec7a21bdd604, 0x93940b9996fa5c50)
    },
    { /* i=415; 115 / 87 */
        RTUINT128_INIT_C(0x000530e179d61ef2, 0x5d8e7a424b31bdd7), RTUINT128_INIT_C(0x000000000034218b, 0x98a897a7824f5cba),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000197dbce2), RTUINT128_INIT_C(0x00000000001bfc78, 0x60d533e0883749a3)
    },
    { /* i=416; 95 / 62 */
        RTUINT128_INIT_C(0x0000000036241967, 0x48c909155ebceb2a), RTUINT128_INIT_C(0x0000000000000000, 0x3875ecde9402a6de),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000f57b83ba), RTUINT128_INIT_C(0x0000000000000000, 0x184d62a7d6c213de)
    },
    { /* i=417; 100 / 104 */
        RTUINT128_INIT_C(0x0000000dd0bfba23, 0xfe81ec7228912e09), RTUINT128_INIT_C(0x00000070369f1acf, 0x54f7fe4d4b91d200),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000dd0bfba23, 0xfe81ec7228912e09)
    },
    { /* i=418; 121 / 93 */
        RTUINT128_INIT_C(0x01d86d24f542b355, 0xcec6ce1d434368f4), RTUINT128_INIT_C(0x00000000150a2723, 0x22df5d0147dd49ba),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000016743f08), RTUINT128_INIT_C(0x000000000c64d573, 0x7f2700c82aec5524)
    },
    { /* i=419; 126 / 8 */
        RTUINT128_INIT_C(0x202ca28974185800, 0x69802c3df126ad95), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000f1),
        RTUINT128_INIT_C(0x00222d49dd6d8305, 0x501b167d99f699ae), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000c7)
    },
    { /* i=420; 120 / 87 */
        RTUINT128_INIT_C(0x00abd6fe0c1d6869, 0x5127a274f2fe00a9), RTUINT128_INIT_C(0x00000000002b15b0, 0x7d9a325686e4bea5),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000003fd08d8ba), RTUINT128_INIT_C(0x00000000000ed49f, 0x49f38a47e9c844c7)
    },
    { /* i=421; 96 / 34 */
        RTUINT128_INIT_C(0x000000008af26272, 0xcf0d9d0827741c41), RTUINT128_INIT_C(0x0000000000000000, 0x000000013ca12d61),
        RTUINT128_INIT_C(0x0000000000000000, 0x705736d568a1a2ef), RTUINT128_INIT_C(0x0000000000000000, 0x000000009c425cb2)
    },
    { /* i=422; 82 / 39 */
        RTUINT128_INIT_C(0x000000000001df72, 0xe89e7f5ab86b376c), RTUINT128_INIT_C(0x0000000000000000, 0x00000037d3cebf1c),
        RTUINT128_INIT_C(0x0000000000000000, 0x000008968b22660f), RTUINT128_INIT_C(0x0000000000000000, 0x0000000f5970dcc8)
    },
    { /* i=423; 105 / 11 */
        RTUINT128_INIT_C(0x0000004300ecd32f, 0x17d0d0d6d2e45796), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000047c),
        RTUINT128_INIT_C(0x000000000ef10ae3, 0x4643bff57bb94938), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000076)
    },
    { /* i=424; 59 / 21 */
        RTUINT128_INIT_C(0x0000000000000000, 0x05da5f468bafc9c2), RTUINT128_INIT_C(0x0000000000000000, 0x00000000001677a1),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000042b0f53d2e), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000fedd4)
    },
    { /* i=425; 119 / 70 */
        RTUINT128_INIT_C(0x0069bb68d33d30cd, 0x97303cdb2734e48e), RTUINT128_INIT_C(0x0000000000000026, 0x41581efa7493ab14),
        RTUINT128_INIT_C(0x0000000000000000, 0x0002c38c2d000ddd), RTUINT128_INIT_C(0x0000000000000018, 0x1bd306b6800a304a)
    },
    { /* i=426; 118 / 68 */
        RTUINT128_INIT_C(0x002f4189d9b3f35e, 0x9fa91e568d7acfe7), RTUINT128_INIT_C(0x0000000000000000, 0x7426a6999b9fe1df),
        RTUINT128_INIT_C(0x0000000000000000, 0x0068274ff6d54b0f), RTUINT128_INIT_C(0x0000000000000000, 0x20e48eda5f653ed6)
    },
    { /* i=427; 116 / 63 */
        RTUINT128_INIT_C(0x00056684ac4b6b52, 0xb261101fe3ae77ca), RTUINT128_INIT_C(0x0000000000000000, 0x5fe7b4248192a8c8),
        RTUINT128_INIT_C(0x0000000000000000, 0x000e6a5d1c1e8438), RTUINT128_INIT_C(0x0000000000000000, 0x1d417b0645226c0a)
    },
    { /* i=428; 123 / 76 */
        RTUINT128_INIT_C(0x01e4503721e3c707, 0xa7eea399768bd2a2), RTUINT128_INIT_C(0x0000000000000177, 0x7662cf5c0653dd5c),
        RTUINT128_INIT_C(0x0000000000000000, 0x00014a37a48ac403), RTUINT128_INIT_C(0x00000000000000f5, 0x6afd76e4ea7dca8e)
    },
    { /* i=429; 116 / 89 */
        RTUINT128_INIT_C(0x000c2f0a453b51b5, 0x74f61de19ab9ab5e), RTUINT128_INIT_C(0x0000000000cb1f97, 0x862c2eb8171f0836),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000f5afb29), RTUINT128_INIT_C(0x000000000097ef9e, 0x700131566cb868b8)
    },
    { /* i=430; 115 / 29 */
        RTUINT128_INIT_C(0x00073f1927027a96, 0x08e9af62b1d054fb), RTUINT128_INIT_C(0x0000000000000000, 0x00000000136cb9d7),
        RTUINT128_INIT_C(0x00000000005f8081, 0x7d6ca685c88e0fae), RTUINT128_INIT_C(0x0000000000000000, 0x0000000011c46bd9)
    },
    { /* i=431; 76 / 13 */
        RTUINT128_INIT_C(0x0000000000000065, 0x2707980b6f5d0e00), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000011fc),
        RTUINT128_INIT_C(0x0000000000000000, 0x059fdcd5f74b5d07), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000041c)
    },
    { /* i=432; 93 / 1 */
        RTUINT128_INIT_C(0x000000001fe05898, 0x4e9981fdd84fd3a9), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001),
        RTUINT128_INIT_C(0x000000001fe05898, 0x4e9981fdd84fd3a9), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=433; 19 / 23 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000003f980), RTUINT128_INIT_C(0x0000000000000000, 0x00000000002b420f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000000000003f980)
    },
    { /* i=434; 56 / 21 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00351c08db264646), RTUINT128_INIT_C(0x0000000000000000, 0x000000000011eb1f),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000002f6c5f4ca), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000e33d0)
    },
    { /* i=435; 113 / 80 */
        RTUINT128_INIT_C(0x00019a2e7e9c81c7, 0x648012c88278dec4), RTUINT128_INIT_C(0x000000000000c98a, 0x790fe60f055b3cc6),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000020904acd5), RTUINT128_INIT_C(0x00000000000088c5, 0xd190cc93d7a24606)
    },
    { /* i=436; 118 / 106 */
        RTUINT128_INIT_C(0x00237a8c2bbe2065, 0xc798f5f83595ee69), RTUINT128_INIT_C(0x000003df70518d18, 0x769d00461d55f397),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000929), RTUINT128_INIT_C(0x000000d050b8ab4f, 0x437173b57d419c3a)
    },
    { /* i=437; 120 / 92 */
        RTUINT128_INIT_C(0x008ee3ce7aa565bb, 0x642b3254936dd153), RTUINT128_INIT_C(0x00000000002dce73, 0xd8323f35ae326b95),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000031e92bbef), RTUINT128_INIT_C(0x0000000000151af6, 0x777774dc4ccb8a38)
    },
    { /* i=438; 88 / 12 */
        RTUINT128_INIT_C(0x000000000047c10d, 0x2d1881f30ff4283d), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000004ec),
        RTUINT128_INIT_C(0x0000000000000e94, 0x1fef27ece42d8070), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000fd)
    },
    { /* i=439; 123 / 37 */
        RTUINT128_INIT_C(0x015fd773e05377e2, 0x890ee95db2dda408), RTUINT128_INIT_C(0x0000000000000000, 0x0000000280e91590),
        RTUINT128_INIT_C(0x00000000008c8965, 0xfe781556733b2cf8), RTUINT128_INIT_C(0x0000000000000000, 0x00000001192c0088)
    },
    { /* i=440; 127 / 2 */
        RTUINT128_INIT_C(0x67fe61979f63f515, 0xa8188dc11ab4c3de), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001),
        RTUINT128_INIT_C(0x67fe61979f63f515, 0xa8188dc11ab4c3de), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=441; 101 / 81 */
        RTUINT128_INIT_C(0x0000000f1cf7b8f0, 0x2c6d236b3ef9e955), RTUINT128_INIT_C(0x0000000000013ebc, 0xd4d430bc78d0e85c),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000c236e), RTUINT128_INIT_C(0x000000000000f8c1, 0x6dc0c41fe1217dcd)
    },
    { /* i=442; 93 / 48 */
        RTUINT128_INIT_C(0x0000000012fadc99, 0x4744ec86c3a0f74d), RTUINT128_INIT_C(0x0000000000000000, 0x00008bfb2ce457cc),
        RTUINT128_INIT_C(0x0000000000000000, 0x000022b5f8ce7267), RTUINT128_INIT_C(0x0000000000000000, 0x00004071be80cc39)
    },
    { /* i=443; 120 / 33 */
        RTUINT128_INIT_C(0x000b17f51d94dc3b, 0xa971068682c4e744), RTUINT128_INIT_C(0x0000000000000000, 0x00000000cf1848e1),
        RTUINT128_INIT_C(0x00000000000db69b, 0xf09a86d397f49580), RTUINT128_INIT_C(0x0000000000000000, 0x00000000a6c181c4)
    },
    { /* i=444; 118 / 105 */
        RTUINT128_INIT_C(0x0036ed4463d155d1, 0xb0e1b7b60e2aef42), RTUINT128_INIT_C(0x0000009cf8f6bb93, 0x287086289201d9c3),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000005993), RTUINT128_INIT_C(0x00000093a6ed7742, 0x59a093a792661949)
    },
    { /* i=445; 63 / 29 */
        RTUINT128_INIT_C(0x0000000000000000, 0x43d2406ada92a265), RTUINT128_INIT_C(0x0000000000000000, 0x00000000107bbe49),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000041d51b3a8), RTUINT128_INIT_C(0x0000000000000000, 0x000000000937b77d)
    },
    { /* i=446; 127 / 112 */
        RTUINT128_INIT_C(0x7d6e9936fd612db8, 0xb3b82926020f499d), RTUINT128_INIT_C(0x0000ac184c1fb57e, 0xdcc239f1ccfc63a2),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000ba96), RTUINT128_INIT_C(0x00001bab58eea8fe, 0x3bd0868885c934b1)
    },
    { /* i=447; 113 / 82 */
        RTUINT128_INIT_C(0x000077b0af5345c9, 0x6e689962445b9292), RTUINT128_INIT_C(0x000000000001dbb9, 0x2cfe0833c2bb1d82),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000040689b70), RTUINT128_INIT_C(0x0000000000003d47, 0xaa97c8714ad0f3b2)
    },
    { /* i=448; 62 / 81 */
        RTUINT128_INIT_C(0x0000000000000000, 0x05941e2af249a975), RTUINT128_INIT_C(0x000000000001c8d2, 0x3c4a3e78705d8578),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x05941e2af249a975)
    },
    { /* i=449; 122 / 46 */
        RTUINT128_INIT_C(0x030fcbea05060ef4, 0xd319f953f87119fd), RTUINT128_INIT_C(0x0000000000000000, 0x00000df2d04d77be),
        RTUINT128_INIT_C(0x0000000000003831, 0x34b55c0590ddad22), RTUINT128_INIT_C(0x0000000000000000, 0x0000035eb535ccc1)
    },
    { /* i=450; 119 / 90 */
        RTUINT128_INIT_C(0x0063cbab8f99d4b1, 0xb00c64b7cc874bc3), RTUINT128_INIT_C(0x00000000014b46b5, 0xb67d11811e4fe05a),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000004d1e72d9), RTUINT128_INIT_C(0x00000000001ef87a, 0x6afd7aee2c5e0b79)
    },
    { /* i=451; 114 / 111 */
        RTUINT128_INIT_C(0x0000934b8101b993, 0x56e0abf7149afc33), RTUINT128_INIT_C(0x00000e1ad43ce71e, 0x55161906233d7f34),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000a), RTUINT128_INIT_C(0x0000063f36a0b264, 0x0403b1b9b434042b)
    },
    { /* i=452; 75 / 49 */
        RTUINT128_INIT_C(0x000000000000075f, 0x494f5dccea944354), RTUINT128_INIT_C(0x0000000000000000, 0x0001b43a0d2726ae),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000004538e2f), RTUINT128_INIT_C(0x0000000000000000, 0x0000338c8685a562)
    },
    { /* i=453; 126 / 88 */
        RTUINT128_INIT_C(0x27805f8a0341f8f1, 0xbbc481e80c37616c), RTUINT128_INIT_C(0x0000000000b5f993, 0x052092014dfd76f8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000003791f59d42), RTUINT128_INIT_C(0x0000000000adbdbf, 0x35f34d802b909d7c)
    },
    { /* i=454; 122 / 81 */
        RTUINT128_INIT_C(0x037541e465d05532, 0x04bd0edc14cf9837), RTUINT128_INIT_C(0x000000000001134e, 0x1f16b773a7379ab6),
        RTUINT128_INIT_C(0x0000000000000000, 0x000003372e417a26), RTUINT128_INIT_C(0x0000000000007e3e, 0xa3c4e3fbc69de533)
    },
    { /* i=455; 42 / 5 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000002226756e34a), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000001d),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000012d76ced5a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000018)
    },
    { /* i=456; 124 / 27 */
        RTUINT128_INIT_C(0x0007e3080b6f916b, 0xdd01834cae10cb3f), RTUINT128_INIT_C(0x0000000000000000, 0x000000000771788b),
        RTUINT128_INIT_C(0x00000000010f41c1, 0x8e54797afca09a08), RTUINT128_INIT_C(0x0000000000000000, 0x00000000052168e7)
    },
    { /* i=457; 63 / 53 */
        RTUINT128_INIT_C(0x0000000000000000, 0x159fd4fbf40d9dad), RTUINT128_INIT_C(0x0000000000000000, 0x001789785cfb0ffa),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000eb), RTUINT128_INIT_C(0x0000000000000000, 0x0004a37e9995f32f)
    },
    { /* i=458; 128 / 56 */
        RTUINT128_INIT_C(0x95453b2e44102fe6, 0xea6d1ee49cea3f8f), RTUINT128_INIT_C(0x0000000000000000, 0x00101162ceef311a),
        RTUINT128_INIT_C(0x000000000000094a, 0x3b74e542947059b1), RTUINT128_INIT_C(0x0000000000000000, 0x000a03e5de174295)
    },
    { /* i=459; 126 / 60 */
        RTUINT128_INIT_C(0x11cfcfe97020e1fd, 0xcb3f5a1181bb5378), RTUINT128_INIT_C(0x0000000000000000, 0x08fb2a7be5f7f563),
        RTUINT128_INIT_C(0x0000000000000001, 0xfbb605ff2d28ae23), RTUINT128_INIT_C(0x0000000000000000, 0x00157354c9937cef)
    },
    { /* i=460; 123 / 90 */
        RTUINT128_INIT_C(0x034c9e884e76ca5f, 0x8cd4308f12bcc6db), RTUINT128_INIT_C(0x00000000017ae1b2, 0x6a04af872ac98076),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000023aafad7e), RTUINT128_INIT_C(0x0000000000713ae3, 0x413c8c584b15cec7)
    },
    { /* i=461; 26 / 5 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000002aa64fb), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000012),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000025e92a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000007)
    },
    { /* i=462; 122 / 75 */
        RTUINT128_INIT_C(0x01dde77631d7c02e, 0xa5fa7766fbac23b9), RTUINT128_INIT_C(0x000000000000041f, 0x7fd994372c4b5971),
        RTUINT128_INIT_C(0x0000000000000000, 0x000073e91655eb00), RTUINT128_INIT_C(0x00000000000000b9, 0xcd097830680c68b9)
    },
    { /* i=463; 127 / 14 */
        RTUINT128_INIT_C(0x2a2187489b1fab3f, 0x29d7a462b16ead97), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000069e),
        RTUINT128_INIT_C(0x00065ded2714b8ec, 0x3d87fc51a9f7262f), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000295)
    },
    { /* i=464; 54 / 71 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000a770a8c5c1aff), RTUINT128_INIT_C(0x0000000000000076, 0xa8467d448de7486e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000a770a8c5c1aff)
    },
    { /* i=465; 114 / 59 */
        RTUINT128_INIT_C(0x000100bceeb9ed42, 0x89faf88fb856a675), RTUINT128_INIT_C(0x0000000000000000, 0x07d5a878e37a3952),
        RTUINT128_INIT_C(0x0000000000000000, 0x0020c50eee1420b7), RTUINT128_INIT_C(0x0000000000000000, 0x0537ca631e656cd7)
    },
    { /* i=466; 84 / 84 */
        RTUINT128_INIT_C(0x00000000000956b2, 0xe8888e5d4df93dc6), RTUINT128_INIT_C(0x00000000000d4d70, 0xd8147ad3ef37289a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00000000000956b2, 0xe8888e5d4df93dc6)
    },
    { /* i=467; 94 / 57 */
        RTUINT128_INIT_C(0x0000000036de99c1, 0xcdebd6d68c55d7b0), RTUINT128_INIT_C(0x0000000000000000, 0x00f7388bef603ee4),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000038d1699a4b), RTUINT128_INIT_C(0x0000000000000000, 0x0099942595ca42e4)
    },
    { /* i=468; 113 / 102 */
        RTUINT128_INIT_C(0x0001f5aaae035169, 0xa91acfe214e81876), RTUINT128_INIT_C(0x000000309137e90f, 0x57bf6892a1263256),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000a54), RTUINT128_INIT_C(0x0000000ed8903ef3, 0x6436c579b668383e)
    },
    { /* i=469; 126 / 75 */
        RTUINT128_INIT_C(0x3b614aea627444a5, 0x09157267aa1db6ff), RTUINT128_INIT_C(0x000000000000014b, 0x82990b77df72c927),
        RTUINT128_INIT_C(0x0000000000000000, 0x002ddacc7c4e4de0), RTUINT128_INIT_C(0x0000000000000120, 0x01582bd2714af9df)
    },
    { /* i=470; 42 / 10 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000728e4c42bd), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000003ac),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000001f32bc87), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000309)
    },
    { /* i=471; 41 / 8 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000001ba0c7c8d21), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000093),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000301d39181), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000e)
    },
    { /* i=472; 117 / 96 */
        RTUINT128_INIT_C(0x00020fe70204625b, 0xac90ffc63a886cf9), RTUINT128_INIT_C(0x000000002c77f8c6, 0xb151819b399a846f),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000bdf10), RTUINT128_INIT_C(0x00000000084622fa, 0x05e7354156be7509)
    },
    { /* i=473; 26 / 22 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000031e53d3), RTUINT128_INIT_C(0x0000000000000000, 0x00000000002cae62),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000011), RTUINT128_INIT_C(0x0000000000000000, 0x000000000026bf51)
    },
    { /* i=474; 118 / 99 */
        RTUINT128_INIT_C(0x00091ad60bbdfaa2, 0xf3d65e7236913517), RTUINT128_INIT_C(0x000000042f9c70a7, 0x5ca1106a65ada1de),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000022cd1), RTUINT128_INIT_C(0x00000003685a84d2, 0x84b0e2c01841e6d9)
    },
    { /* i=475; 110 / 35 */
        RTUINT128_INIT_C(0x00002a698fbeb496, 0x21d29719b1c684f0), RTUINT128_INIT_C(0x0000000000000000, 0x00000001b74fdd8c),
        RTUINT128_INIT_C(0x00000000000018b7, 0x052d3f99b948d947), RTUINT128_INIT_C(0x0000000000000000, 0x00000000ac74671c)
    },
    { /* i=476; 119 / 114 */
        RTUINT128_INIT_C(0x004dd367e30da7ca, 0x1a1eec37ad4f239a), RTUINT128_INIT_C(0x00039f041264761f, 0xb550eff1e20afae9),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000015), RTUINT128_INIT_C(0x0001c81260cff730, 0x3a7b3d6022688e7d)
    },
    { /* i=477; 128 / 114 */
        RTUINT128_INIT_C(0x5d4dc79d239c4730, 0xe337d69c65bbec5b), RTUINT128_INIT_C(0x0001932fa1e85fe7, 0xc4365ada156f3184),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000003b3e), RTUINT128_INIT_C(0x000027c35f3aa2d6, 0xd71d92da94648263)
    },
    { /* i=478; 114 / 125 */
        RTUINT128_INIT_C(0x0003c10e628994f7, 0xecbd743147735852), RTUINT128_INIT_C(0x1d241bdade8b9082, 0x6d545de1dcbe2756),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0003c10e628994f7, 0xecbd743147735852)
    },
    { /* i=479; 122 / 48 */
        RTUINT128_INIT_C(0x0395e110a895ce21, 0x25ae30d0ac571387), RTUINT128_INIT_C(0x0000000000000000, 0x000017134a833c3f),
        RTUINT128_INIT_C(0x00000000000027c7, 0x07f6780194a1a864), RTUINT128_INIT_C(0x0000000000000000, 0x000004c521eb32eb)
    },
    { /* i=480; 121 / 41 */
        RTUINT128_INIT_C(0x00fd82af83419fef, 0x4c31e192b6b774f6), RTUINT128_INIT_C(0x0000000000000000, 0x0000011d9e878c08),
        RTUINT128_INIT_C(0x000000000000e338, 0x91c6a8f67af2475b), RTUINT128_INIT_C(0x0000000000000000, 0x000000859522761e)
    },
    { /* i=481; 4 / 1 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000008), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000008), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=482; 125 / 72 */
        RTUINT128_INIT_C(0x0396fec8faa3b570, 0xbd75804d9d960381), RTUINT128_INIT_C(0x000000000000006b, 0xf63e60636df79899),
        RTUINT128_INIT_C(0x0000000000000000, 0x00088320ca2faf45), RTUINT128_INIT_C(0x0000000000000010, 0x5ce9a056fa724b44)
    },
    { /* i=483; 68 / 48 */
        RTUINT128_INIT_C(0x0000000000000007, 0x5d0be9fdb93aac88), RTUINT128_INIT_C(0x0000000000000000, 0x0000202d9a08ebb1),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000003a94e3), RTUINT128_INIT_C(0x0000000000000000, 0x00001e7b94f55a95)
    },
    { /* i=484; 48 / 107 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000bf692c82c5b5), RTUINT128_INIT_C(0x000003691302dcf1, 0x0cbbb27c72b0d0b5),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000bf692c82c5b5)
    },
    { /* i=485; 65 / 25 */
        RTUINT128_INIT_C(0x0000000000000000, 0xdbc65b715d7b9f33), RTUINT128_INIT_C(0x0000000000000000, 0x000000000129c8d1),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000bcefc01ea1), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000ebd5c2)
    },
    { /* i=486; 115 / 104 */
        RTUINT128_INIT_C(0x0001a7f95712adf1, 0xad8666b6efb5390c), RTUINT128_INIT_C(0x000000fb34d7d784, 0xcb32d4bf4ba23841),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000001b0), RTUINT128_INIT_C(0x000000102ad6fdda, 0xc7bf63e74df64b5c)
    },
    { /* i=487; 111 / 100 */
        RTUINT128_INIT_C(0x00006acf992e66d7, 0x9bcc7fefa2760a95), RTUINT128_INIT_C(0x00000003265c06c3, 0x99373d6521ad4ad8),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000021e8), RTUINT128_INIT_C(0x00000002f8e90ed4, 0xa2d2d2f1c6c45ed5)
    },
    { /* i=488; 123 / 125 */
        RTUINT128_INIT_C(0x0624bec7787ef06d, 0x6f84e17d6d514761), RTUINT128_INIT_C(0x0a3858cdf9429442, 0x7c7ae7fa5bf95186),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0624bec7787ef06d, 0x6f84e17d6d514761)
    },
    { /* i=489; 116 / 113 */
        RTUINT128_INIT_C(0x00078746b31a8860, 0x4e56f320fcdf7222), RTUINT128_INIT_C(0x0001f3fec1b38cc7, 0x2555250bad4323a9),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003), RTUINT128_INIT_C(0x0001ab4a6dffe20a, 0xde5783fdf5160727)
    },
    { /* i=490; 111 / 2 */
        RTUINT128_INIT_C(0x000027fe7f7ff5cf, 0x6a42f0a4a7645a7c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002),
        RTUINT128_INIT_C(0x000013ff3fbffae7, 0xb521785253b22d3e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=491; 26 / 21 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000002af4c5), RTUINT128_INIT_C(0x0000000000000000, 0x00000000001bc7b0),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000f2d15)
    },
    { /* i=492; 77 / 20 */
        RTUINT128_INIT_C(0x0000000000000f81, 0x9764dd8c7d4daabe), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000f23e6),
        RTUINT128_INIT_C(0x0000000000000000, 0x010630375503a40a), RTUINT128_INIT_C(0x0000000000000000, 0x000000000004ebc2)
    },
    { /* i=493; 114 / 101 */
        RTUINT128_INIT_C(0x0002d35d3f0e671f, 0x9be93df695c3bfdb), RTUINT128_INIT_C(0x0000000ed9edd340, 0xaf16363061b53164),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000030b5), RTUINT128_INIT_C(0x00000000924be98f, 0xa70bdb6f87651427)
    },
    { /* i=494; 113 / 6 */
        RTUINT128_INIT_C(0x000019cc30583b38, 0x9417cc07c657da2b), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000b),
        RTUINT128_INIT_C(0x00000258617c6279, 0x81d39e2f40939f78), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003)
    },
    { /* i=495; 123 / 105 */
        RTUINT128_INIT_C(0x00826592c3d8fcc4, 0x389f0cfdb0270e68), RTUINT128_INIT_C(0x0000016f77c44d74, 0xc379cf92d02c6ab9),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000005ad7), RTUINT128_INIT_C(0x000000da2ac0e2fb, 0x3a581b813d546309)
    },
    { /* i=496; 50 / 46 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0003a77b7b17f44a), RTUINT128_INIT_C(0x0000000000000000, 0x00003680d7eb359b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000011), RTUINT128_INIT_C(0x0000000000000000, 0x000008ed247964ff)
    },
    { /* i=497; 11 / 40 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000005fe), RTUINT128_INIT_C(0x0000000000000000, 0x000000e91d2b0d5f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000005fe)
    },
    { /* i=498; 123 / 118 */
        RTUINT128_INIT_C(0x0764c63b627818bd, 0xbec0b7a03a32fdbf), RTUINT128_INIT_C(0x003c1f3585aa3870, 0x2d592aaa20aab574),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000001f), RTUINT128_INIT_C(0x001cfec032db4328, 0x40f48d06458704b3)
    },
    { /* i=499; 123 / 41 */
        RTUINT128_INIT_C(0x0647918e6d799c14, 0x80a661f227248d9d), RTUINT128_INIT_C(0x0000000000000000, 0x0000007b6560e600),
        RTUINT128_INIT_C(0x00000000000d0718, 0x9cd448b4d6b8d11d), RTUINT128_INIT_C(0x0000000000000000, 0x0000004a3f647f9d)
    },
    { /* i=500; 60 / 59 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0d3150bf238c7095), RTUINT128_INIT_C(0x0000000000000000, 0x061c9c3d1cb18ae6),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002), RTUINT128_INIT_C(0x0000000000000000, 0x00f81844ea295ac9)
    },
    { /* i=501; 58 / 31 */
        RTUINT128_INIT_C(0x0000000000000000, 0x03f2abe94cc10646), RTUINT128_INIT_C(0x0000000000000000, 0x000000000d2edb08),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000004caa2265), RTUINT128_INIT_C(0x0000000000000000, 0x000000000cdd8c1e)
    },
    { /* i=502; 114 / 40 */
        RTUINT128_INIT_C(0x0001885650268dbc, 0xc2d08dcb5d99da90), RTUINT128_INIT_C(0x0000000000000000, 0x000000d0926a5a64),
        RTUINT128_INIT_C(0x00000000000001e1, 0x8d6929d6c849ae75), RTUINT128_INIT_C(0x0000000000000000, 0x0000006a430a92dc)
    },
    { /* i=503; 128 / 105 */
        RTUINT128_INIT_C(0xba3024bc832167ca, 0xdeffc3dd040cc5e3), RTUINT128_INIT_C(0x000000c8f837922a, 0x849f7825397b996d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000ed2bc1), RTUINT128_INIT_C(0x00000015ba5249d3, 0xdf21b7b7e12fcbb6)
    },
    { /* i=504; 127 / 97 */
        RTUINT128_INIT_C(0x523643a65ae2d46c, 0xcedda4d5292e9f3a), RTUINT128_INIT_C(0x000000002378447b, 0x3b69f4bee6cca2cc),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000002515b7ca0), RTUINT128_INIT_C(0x00000000221dc808, 0x259c25e15fea0fba)
    },
    { /* i=505; 123 / 103 */
        RTUINT128_INIT_C(0x045fe6fee2e7cc4f, 0xabce28c2c9cb3504), RTUINT128_INIT_C(0x0000004989a0425f, 0x059d47edff2193cc),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000f3a9e), RTUINT128_INIT_C(0x00000009bf63fa2d, 0x5b7de51a0ea1c51c)
    },
    { /* i=506; 33 / 25 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000dc4118c7), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000409180),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000369), RTUINT128_INIT_C(0x0000000000000000, 0x000000000010eb47)
    },
    { /* i=507; 122 / 73 */
        RTUINT128_INIT_C(0x00a6cae1b8965dbf, 0x3d406c6e0a351774), RTUINT128_INIT_C(0x00000000000000e5, 0x1ff10a350f6b6f8d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000ba5b41112ec6), RTUINT128_INIT_C(0x0000000000000021, 0x884f980a99b47a66)
    },
    { /* i=508; 123 / 95 */
        RTUINT128_INIT_C(0x05bb7df8c66f43dd, 0x494864342f612ed2), RTUINT128_INIT_C(0x00000000639b5e38, 0x019f2ce788d78961),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000ebb9b0c), RTUINT128_INIT_C(0x00000000261b0c87, 0x5f055a8a9d3e0346)
    },
    { /* i=509; 127 / 68 */
        RTUINT128_INIT_C(0x349402e0c96a75f5, 0xf0ab244d85d4471b), RTUINT128_INIT_C(0x000000000000000d, 0xc0b0140436e7b1a6),
        RTUINT128_INIT_C(0x0000000000000000, 0x03d2b7fa9a153f9f), RTUINT128_INIT_C(0x0000000000000001, 0xd694a430f8971701)
    },
    { /* i=510; 119 / 75 */
        RTUINT128_INIT_C(0x001f88c49489251f, 0x9b430d3b1f16b97d), RTUINT128_INIT_C(0x00000000000003ce, 0x95a2e5ff76ed5fab),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000084885ceef26), RTUINT128_INIT_C(0x000000000000009e, 0xa640237908efe11b)
    },
    { /* i=511; 50 / 20 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000a5d39e81b696), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000a8b1e),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000fba5be0), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000085256)
    },
    { /* i=512; 96 / 1 */
        RTUINT128_INIT_C(0x00000000a3783345, 0x2e577d35c2cf953c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001),
        RTUINT128_INIT_C(0x00000000a3783345, 0x2e577d35c2cf953c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=513; 46 / 125 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000038c2eff5ac50), RTUINT128_INIT_C(0x0fb8f8bd766308a8, 0xdc3c1d233de7800b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000038c2eff5ac50)
    },
    { /* i=514; 114 / 95 */
        RTUINT128_INIT_C(0x0001bf351efb2a15, 0x1c4398dc005c039d), RTUINT128_INIT_C(0x000000002e990205, 0xb1efff5a84c4f19c),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000998e2), RTUINT128_INIT_C(0x000000001080bdf7, 0x8c97c1315c8e17e5)
    },
    { /* i=515; 123 / 79 */
        RTUINT128_INIT_C(0x039422ddb8fb8709, 0x9c2c154011038b78), RTUINT128_INIT_C(0x0000000000006fab, 0x77d5ac14135351fb),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000083437b0360a), RTUINT128_INIT_C(0x0000000000001f82, 0xb616718272e765aa)
    },
    { /* i=516; 113 / 83 */
        RTUINT128_INIT_C(0x000130a38b6fa72b, 0x20b54e2090d28621), RTUINT128_INIT_C(0x0000000000021f7f, 0x6f6f6888dd7a459e),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000008f7deeca), RTUINT128_INIT_C(0x000000000001ae39, 0x211222a2e178b375)
    },
    { /* i=517; 115 / 47 */
        RTUINT128_INIT_C(0x000198e72246d6cd, 0xfb52ea1301f5c0b9), RTUINT128_INIT_C(0x0000000000000000, 0x00006c16f94f9937),
        RTUINT128_INIT_C(0x0000000000000003, 0xc8724ef5ecff34b4), RTUINT128_INIT_C(0x0000000000000000, 0x0000241c3915da0d)
    },
    { /* i=518; 114 / 18 */
        RTUINT128_INIT_C(0x000084f6e7395c54, 0x07b529d62c8cc4e8), RTUINT128_INIT_C(0x0000000000000000, 0x000000000002585a),
        RTUINT128_INIT_C(0x0000000038b2c2b8, 0xb4a5c4e067a7fe13), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000ea3a)
    },
    { /* i=519; 123 / 99 */
        RTUINT128_INIT_C(0x0438327bd50b65be, 0x68fe3abeb5a2a54f), RTUINT128_INIT_C(0x000000023be1dc96, 0x18c039cec518381e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000001e38b5f), RTUINT128_INIT_C(0x00000000ca4457ed, 0xc927a54d8a93882d)
    },
    { /* i=520; 90 / 10 */
        RTUINT128_INIT_C(0x0000000002fb3496, 0xf72dd1b5b5739399), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000030f),
        RTUINT128_INIT_C(0x000000000000f987, 0x38e0abea539a7786), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000bf)
    },
    { /* i=521; 41 / 15 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000014e1b324f4d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000006e92),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000003058bb6), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000006d81)
    },
    { /* i=522; 125 / 89 */
        RTUINT128_INIT_C(0x11a4154c2e861604, 0xd845434f84c538fa), RTUINT128_INIT_C(0x00000000005c83ab, 0x39a7a571994fe5e5),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000030d0a11498), RTUINT128_INIT_C(0x00000000005809b1, 0x6bd0b6e89a59d502)
    },
    { /* i=523; 123 / 74 */
        RTUINT128_INIT_C(0x06578061b8975b71, 0xc97d66b2533d7c3e), RTUINT128_INIT_C(0x0000000000000192, 0x922c379a0a9d51f7),
        RTUINT128_INIT_C(0x0000000000000000, 0x00040867bb60955f), RTUINT128_INIT_C(0x0000000000000002, 0xf77b841ba8874e95)
    },
    { /* i=524; 122 / 122 */
        RTUINT128_INIT_C(0x002d6c6f2559b5cc, 0x6d4c69df5f2b02b4), RTUINT128_INIT_C(0x023acefdea4b6cdd, 0xbe9468b37af8a93a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x002d6c6f2559b5cc, 0x6d4c69df5f2b02b4)
    },
    { /* i=525; 118 / 16 */
        RTUINT128_INIT_C(0x00185400b3ecc66b, 0xb15c762d845ad5c6), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000072fb),
        RTUINT128_INIT_C(0x000000362a6e42f5, 0x0dd12b4a2502c294), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000026aa)
    },
    { /* i=526; 123 / 113 */
        RTUINT128_INIT_C(0x0309bb4321631555, 0xe9fd461722e62a64), RTUINT128_INIT_C(0x00011910a63053a3, 0x69e7f36c5f58ae40),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000002c4), RTUINT128_INIT_C(0x0000693783bbc565, 0x04800e5f71a44164)
    },
    { /* i=527; 120 / 55 */
        RTUINT128_INIT_C(0x009b558faf843658, 0x6242a8581631b6c6), RTUINT128_INIT_C(0x0000000000000000, 0x007c66583abd21e1),
        RTUINT128_INIT_C(0x0000000000000001, 0x3fa8cefb32b7a9fc), RTUINT128_INIT_C(0x0000000000000000, 0x0057774b3ecfd44a)
    },
    { /* i=528; 57 / 27 */
        RTUINT128_INIT_C(0x0000000000000000, 0x009bd0d876136c19), RTUINT128_INIT_C(0x0000000000000000, 0x00000000066bc76c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000018443ca3), RTUINT128_INIT_C(0x0000000000000000, 0x0000000004062255)
    },
    { /* i=529; 20 / 111 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000d540b), RTUINT128_INIT_C(0x000003b9ffe8e9b3, 0x1a095100313b5a3f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000d540b)
    },
    { /* i=530; 126 / 92 */
        RTUINT128_INIT_C(0x09cad352f115d1c3, 0x58d826e288f52d69), RTUINT128_INIT_C(0x000000000d0f886c, 0x09a43c4f1d2a29d5),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000bfefd85f), RTUINT128_INIT_C(0x0000000005288035, 0xdd6455582a28ef5e)
    },
    { /* i=531; 105 / 28 */
        RTUINT128_INIT_C(0x0000013c18ec4826, 0x112a8ee35efafde1), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000f4ba73),
        RTUINT128_INIT_C(0x0000000000014aa7, 0xf96430841a00af6a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000312d43)
    },
    { /* i=532; 114 / 39 */
        RTUINT128_INIT_C(0x00011e23f384d817, 0x069981fd9953a4ea), RTUINT128_INIT_C(0x0000000000000000, 0x0000001c3be79d11),
        RTUINT128_INIT_C(0x0000000000000a22, 0x7565f346c7fd019b), RTUINT128_INIT_C(0x0000000000000000, 0x00000004fbad7a9f)
    },
    { /* i=533; 117 / 52 */
        RTUINT128_INIT_C(0x0001c4147aea9b10, 0xd53e43226b457b9c), RTUINT128_INIT_C(0x0000000000000000, 0x000c9e43d922d11c),
        RTUINT128_INIT_C(0x0000000000000000, 0x23d3da47bacc445c), RTUINT128_INIT_C(0x0000000000000000, 0x000932a228e6e58c)
    },
    { /* i=534; 50 / 45 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000b46c21399d2f), RTUINT128_INIT_C(0x0000000000000000, 0x000015adb8da2357),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000008), RTUINT128_INIT_C(0x0000000000000000, 0x000006fe5a688277)
    },
    { /* i=535; 15 / 8 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001a26), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000063),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000043), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000003d)
    },
    { /* i=536; 127 / 126 */
        RTUINT128_INIT_C(0x756f5e59fd9f8c1f, 0x07e743c9f43cd66d), RTUINT128_INIT_C(0x34a5aa04f76d169b, 0xd52a19c8ecb439e4),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002), RTUINT128_INIT_C(0x0c240a500ec55ee7, 0x5d9310381ad462a5)
    },
    { /* i=537; 120 / 115 */
        RTUINT128_INIT_C(0x003d6103ca1a365a, 0x27d425d7a175736b), RTUINT128_INIT_C(0x00000dcf27d6f188, 0xb551e249d809308a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000471), RTUINT128_INIT_C(0x00000bf3d873762c, 0xd7261bdf20a4de81)
    },
    { /* i=538; 115 / 46 */
        RTUINT128_INIT_C(0x00076ffdeedd6457, 0x8c30c6bb5e61cf83), RTUINT128_INIT_C(0x0000000000000000, 0x0000041bf099e299),
        RTUINT128_INIT_C(0x00000000000001cf, 0x5af6c205c836241f), RTUINT128_INIT_C(0x0000000000000000, 0x00000109439bdafc)
    },
    { /* i=539; 120 / 98 */
        RTUINT128_INIT_C(0x0083fde893dcc710, 0xc24dd37ea4a9014a), RTUINT128_INIT_C(0x00000000654f94c1, 0x92f55f8c8d654f2f),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000014d86e9), RTUINT128_INIT_C(0x0000000036c4e6c8, 0x47225dc6ebde5583)
    },
    { /* i=540; 120 / 51 */
        RTUINT128_INIT_C(0x0005148ad23e63ff, 0x9ae19ce157abb281), RTUINT128_INIT_C(0x0000000000000000, 0x00061cc16bb9a00b),
        RTUINT128_INIT_C(0x0000000000000000, 0xd4c610ec1f8d16af), RTUINT128_INIT_C(0x0000000000000000, 0x00054ba444f758fc)
    },
    { /* i=541; 113 / 122 */
        RTUINT128_INIT_C(0x0001cf1be3b74569, 0x6313a7ee2181e3fb), RTUINT128_INIT_C(0x005acdd9981c5ae2, 0x7add405fdd6fa35c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0001cf1be3b74569, 0x6313a7ee2181e3fb)
    },
    { /* i=542; 72 / 62 */
        RTUINT128_INIT_C(0x000000000000008d, 0x78b00ae8c7be6430), RTUINT128_INIT_C(0x0000000000000000, 0x06230a9a99af4c72),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000170d), RTUINT128_INIT_C(0x0000000000000000, 0x02f49d4039f94466)
    },
    { /* i=543; 128 / 120 */
        RTUINT128_INIT_C(0x8098b5fee693fac6, 0xd1e7fef0c6c15fd1), RTUINT128_INIT_C(0x002da33bab2545a7, 0xcfcfad53d545d03e),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000002d1), RTUINT128_INIT_C(0x000ffaf1e29acd26, 0x8a00d5d51d21e133)
    },
    { /* i=544; 35 / 97 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000054daf521f), RTUINT128_INIT_C(0x000000017f442bd5, 0xcc91ae883857f8b9),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000000054daf521f)
    },
    { /* i=545; 125 / 49 */
        RTUINT128_INIT_C(0x1dfdcd39a8b4d173, 0x8ca6ed4f1078f123), RTUINT128_INIT_C(0x0000000000000000, 0x00001ce84d45cc01),
        RTUINT128_INIT_C(0x0000000000010999, 0x7f84ae778634533c), RTUINT128_INIT_C(0x0000000000000000, 0x000018625cc4cde7)
    },
    { /* i=546; 128 / 61 */
        RTUINT128_INIT_C(0x5d16ac5aea305b37, 0xbed423cdb27fc702), RTUINT128_INIT_C(0x0000000000000000, 0x0019ca5aa86fa5d1),
        RTUINT128_INIT_C(0x000000000000039c, 0x02fdab786e5c0051), RTUINT128_INIT_C(0x0000000000000000, 0x001146c702104fe1)
    },
    { /* i=547; 46 / 15 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000251ef5c695bc), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000007f7c),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000004a8acaae), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001774)
    },
    { /* i=548; 116 / 125 */
        RTUINT128_INIT_C(0x000049307d6aecbd, 0xb91869710f81f904), RTUINT128_INIT_C(0x19ae631f4821d509, 0x930699cb386fa357),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000049307d6aecbd, 0xb91869710f81f904)
    },
    { /* i=549; 123 / 7 */
        RTUINT128_INIT_C(0x069a86a8186abfb8, 0x5aa94b189950d777), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000078),
        RTUINT128_INIT_C(0x000e167499cdb087, 0xefb05817abf1bd87), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000002f)
    },
    { /* i=550; 115 / 78 */
        RTUINT128_INIT_C(0x00025a2e7c3f2e24, 0x3b7c7caa1b90bcc2), RTUINT128_INIT_C(0x00000000000022fd, 0x0ae3f35ac0161f36),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000001135fb81e7), RTUINT128_INIT_C(0x000000000000116a, 0x64f42e3ed9ee5d08)
    },
    { /* i=551; 43 / 27 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000004a9747c93f3), RTUINT128_INIT_C(0x0000000000000000, 0x0000000002e3c828),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000019cfe), RTUINT128_INIT_C(0x0000000000000000, 0x00000000005b9c43)
    },
    { /* i=552; 55 / 42 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00031f21dea8ec16), RTUINT128_INIT_C(0x0000000000000000, 0x000003044264b2fc),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000108), RTUINT128_INIT_C(0x0000000000000000, 0x000002bd66d05836)
    },
    { /* i=553; 120 / 15 */
        RTUINT128_INIT_C(0x00c40a7bde6b52be, 0x3a0aa0e059bb5392), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000072be),
        RTUINT128_INIT_C(0x000001b5627f78d6, 0xc42563769625fa7c), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000338a)
    },
    { /* i=554; 117 / 76 */
        RTUINT128_INIT_C(0x0015d59fb1268bba, 0x5fd51c2d11f6c0d8), RTUINT128_INIT_C(0x0000000000000954, 0x9b71c60cfa2e3857),
        RTUINT128_INIT_C(0x0000000000000000, 0x000002571200c049), RTUINT128_INIT_C(0x00000000000005ba, 0x6c1cd34ff2877009)
    },
    { /* i=555; 125 / 12 */
        RTUINT128_INIT_C(0x00a92d7a4a878cc4, 0xfc7b109ea7759d41), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000003d8),
        RTUINT128_INIT_C(0x00002c0381a2ffe2, 0x0575b7f3ac65d7d5), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000289)
    },
    { /* i=556; 78 / 77 */
        RTUINT128_INIT_C(0x000000000000226a, 0x762c5a405ba56a46), RTUINT128_INIT_C(0x00000000000002a7, 0xe77d4060849bf883),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000c), RTUINT128_INIT_C(0x000000000000028b, 0x9c4d55ba2455c422)
    },
    { /* i=557; 108 / 37 */
        RTUINT128_INIT_C(0x00000f6d76663305, 0xfa2d97cd4b3ca5d7), RTUINT128_INIT_C(0x0000000000000000, 0x0000000825a44c77),
        RTUINT128_INIT_C(0x00000000000001e4, 0xc5d5d8368470991c), RTUINT128_INIT_C(0x0000000000000000, 0x000000012b8129d3)
    },
    { /* i=558; 86 / 42 */
        RTUINT128_INIT_C(0x00000000001dc22b, 0xec328bc5e84bcb61), RTUINT128_INIT_C(0x0000000000000000, 0x000003321f3ee9e1),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000094fd0bbcd1e), RTUINT128_INIT_C(0x0000000000000000, 0x0000027636483603)
    },
    { /* i=559; 50 / 3 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0002dd579de963df), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001),
        RTUINT128_INIT_C(0x0000000000000000, 0x0002dd579de963df), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=560; 10 / 25 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000db), RTUINT128_INIT_C(0x0000000000000000, 0x00000000002adaf9),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000db)
    },
    { /* i=561; 42 / 32 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000002cfbe5dc149), RTUINT128_INIT_C(0x0000000000000000, 0x0000000023e632fe),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000140c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000013978561)
    },
    { /* i=562; 114 / 119 */
        RTUINT128_INIT_C(0x0003e2e2a188e8a7, 0x74470e780410e94d), RTUINT128_INIT_C(0x00190e4ea2804b14, 0xdaa85dbb93ba5ca7),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0003e2e2a188e8a7, 0x74470e780410e94d)
    },
    { /* i=563; 125 / 95 */
        RTUINT128_INIT_C(0x173e6bc1b302c3a2, 0xbee8cda5ccae769e), RTUINT128_INIT_C(0x000000003e244b66, 0x53935942cb8b3ab1),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000005fc16cd0), RTUINT128_INIT_C(0x00000000148da506, 0x98a3fac2c05b1ace)
    },
    { /* i=564; 52 / 12 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00005941dda2d3ff), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000ebd),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000060e600d38), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000001a7)
    },
    { /* i=565; 64 / 4 */
        RTUINT128_INIT_C(0x0000000000000000, 0xcc661b6cee3c018a), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000c),
        RTUINT128_INIT_C(0x0000000000000000, 0x1108824913da5576), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002)
    },
    { /* i=566; 128 / 122 */
        RTUINT128_INIT_C(0x99acfd6297550318, 0x63ac21f6b497ca04), RTUINT128_INIT_C(0x0054d94bde572b7a, 0x07b49f43873203c8),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000001cf), RTUINT128_INIT_C(0x0037fd2b77ad6164, 0x740016d53122f34c)
    },
    { /* i=567; 36 / 28 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000f158bad1b), RTUINT128_INIT_C(0x0000000000000000, 0x000000000566d96d),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000002ca), RTUINT128_INIT_C(0x0000000000000000, 0x0000000004b14319)
    },
    { /* i=568; 81 / 34 */
        RTUINT128_INIT_C(0x000000000000bd6f, 0xc3b5bf545314687c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000282879409),
        RTUINT128_INIT_C(0x0000000000000000, 0x00004b79ef8e7699), RTUINT128_INIT_C(0x0000000000000000, 0x000000004dd2c91b)
    },
    { /* i=569; 118 / 85 */
        RTUINT128_INIT_C(0x0024d3b7f210bb17, 0x4c0b01e0466fe410), RTUINT128_INIT_C(0x0000000000043209, 0x802e6497b127e93d),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000008c720124d), RTUINT128_INIT_C(0x000000000001c87c, 0x7418a0979c6872b7)
    },
    { /* i=570; 68 / 62 */
        RTUINT128_INIT_C(0x0000000000000009, 0x67eb43bbec889899), RTUINT128_INIT_C(0x0000000000000000, 0x14a349e48fff308c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000074), RTUINT128_INIT_C(0x0000000000000000, 0x0dedc82aace69929)
    },
    { /* i=571; 117 / 112 */
        RTUINT128_INIT_C(0x00071b85ca3bba91, 0xe37605b7fa2e9fa8), RTUINT128_INIT_C(0x000077522580dc8e, 0x9f7966662cb225de),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000f), RTUINT128_INIT_C(0x00001db597aece36, 0x8b5905bb5bbe67a6)
    },
    { /* i=572; 85 / 73 */
        RTUINT128_INIT_C(0x0000000000015ede, 0x5ebf02a41a39e26a), RTUINT128_INIT_C(0x00000000000000d3, 0x4ed9452bc9eb1ddf),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000001a9), RTUINT128_INIT_C(0x0000000000000010, 0x780b2cf1e2e54b33)
    },
    { /* i=573; 81 / 40 */
        RTUINT128_INIT_C(0x00000000000175c7, 0x4a21949920ab2178), RTUINT128_INIT_C(0x0000000000000000, 0x0000003c624154f0),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000630a6c3c682), RTUINT128_INIT_C(0x0000000000000000, 0x0000001960fc5f98)
    },
    { /* i=574; 127 / 121 */
        RTUINT128_INIT_C(0x70e551390559a3a1, 0xa2dade28e2531eae), RTUINT128_INIT_C(0x007bf31965a7f12d, 0xd71f121bca5312a6),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000e9), RTUINT128_INIT_C(0x00150f1b7f7f20e8, 0xd79362ddbcb72598)
    },
    { /* i=575; 77 / 12 */
        RTUINT128_INIT_C(0x0000000000001899, 0x46a797511e1a24f6), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000b06),
        RTUINT128_INIT_C(0x0000000000000002, 0x3b433067b7875b74), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000043e)
    },
    { /* i=576; 49 / 24 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000158be9614f257), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000c321b8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000001c44839), RTUINT128_INIT_C(0x0000000000000000, 0x000000000046b05f)
    },
    { /* i=577; 68 / 126 */
        RTUINT128_INIT_C(0x000000000000000a, 0x2087c47218570fbb), RTUINT128_INIT_C(0x25479a97c0b02ef3, 0x71f98f899b9f089f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000000000000000a, 0x2087c47218570fbb)
    },
    { /* i=578; 121 / 31 */
        RTUINT128_INIT_C(0x004cfcb097e3458f, 0x13bfcf887915f38c), RTUINT128_INIT_C(0x0000000000000000, 0x000000005bcf2e12),
        RTUINT128_INIT_C(0x0000000000d6ab7c, 0x9e246d8108ee49a4), RTUINT128_INIT_C(0x0000000000000000, 0x000000002f7d4e04)
    },
    { /* i=579; 21 / 6 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000016af50), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000035),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000006d92), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000016)
    },
    { /* i=580; 117 / 119 */
        RTUINT128_INIT_C(0x0018dfc96abc9583, 0x7e5bc0d5c71ba595), RTUINT128_INIT_C(0x0031dad483a74b87, 0xee2ee1bdcaf50cbf),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0018dfc96abc9583, 0x7e5bc0d5c71ba595)
    },
    { /* i=581; 38 / 6 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000002981be0efe), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000008),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000053037c1df), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000006)
    },
    { /* i=582; 120 / 11 */
        RTUINT128_INIT_C(0x001c0aacdc7497dd, 0xf085abba2731cdf1), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000004c9),
        RTUINT128_INIT_C(0x000005dc3255c6dd, 0x1296280e2751f5ed), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000002dc)
    },
    { /* i=583; 125 / 84 */
        RTUINT128_INIT_C(0x0c9f47943f9d89ee, 0xd9abc55148290447), RTUINT128_INIT_C(0x000000000009d83b, 0x7346bb9cfd4750fc),
        RTUINT128_INIT_C(0x0000000000000000, 0x000001483a0ae08b), RTUINT128_INIT_C(0x000000000000345f, 0xf536b97319bb8b73)
    },
    { /* i=584; 120 / 60 */
        RTUINT128_INIT_C(0x00e98be61db66b4d, 0xdb0be1d0b6719a4f), RTUINT128_INIT_C(0x0000000000000000, 0x02619556013da0d7),
        RTUINT128_INIT_C(0x0000000000000000, 0x62147711ae36a602), RTUINT128_INIT_C(0x0000000000000000, 0x00cf2cbdae50eea1)
    },
    { /* i=585; 123 / 123 */
        RTUINT128_INIT_C(0x00ff7ac9b9f3f2de, 0x76d7ebd5e619ef78), RTUINT128_INIT_C(0x01ab6341fdffcbe6, 0x953cf27421c816f5),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00ff7ac9b9f3f2de, 0x76d7ebd5e619ef78)
    },
    { /* i=586; 73 / 7 */
        RTUINT128_INIT_C(0x00000000000000ec, 0xca16b63b191240a3), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000010),
        RTUINT128_INIT_C(0x000000000000000e, 0xcca16b63b191240a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003)
    },
    { /* i=587; 35 / 6 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000005b4a378c3), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000002b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000021f7e50a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000015)
    },
    { /* i=588; 83 / 49 */
        RTUINT128_INIT_C(0x000000000003b89f, 0xc099dcd3ec64c9d1), RTUINT128_INIT_C(0x0000000000000000, 0x00011d048e10b096),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000357a30e92), RTUINT128_INIT_C(0x0000000000000000, 0x0000de1093b5e045)
    },
    { /* i=589; 113 / 104 */
        RTUINT128_INIT_C(0x0001f50ce8eb32e9, 0xcdd2affb6bd6ea5b), RTUINT128_INIT_C(0x000000d71032a269, 0x94771f280fb8ea1c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000254), RTUINT128_INIT_C(0x0000005b3309151c, 0x287e26b6d155e12b)
    },
    { /* i=590; 88 / 1 */
        RTUINT128_INIT_C(0x00000000007e322e, 0x211a173efaefd41a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001),
        RTUINT128_INIT_C(0x00000000007e322e, 0x211a173efaefd41a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=591; 62 / 22 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0c3116ddea98beb3), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000281c30),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000004dd023469b), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000a8da3)
    },
    { /* i=592; 85 / 62 */
        RTUINT128_INIT_C(0x00000000000e5626, 0x734b5cf27dc29303), RTUINT128_INIT_C(0x0000000000000000, 0x2ca7d695a304f4b2),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000523018), RTUINT128_INIT_C(0x0000000000000000, 0x0f64f8c3e6664253)
    },
    { /* i=593; 86 / 109 */
        RTUINT128_INIT_C(0x0000000000273160, 0x3811b536eb885015), RTUINT128_INIT_C(0x00001c81f5e7ade3, 0x5a335ff2d887e891),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000273160, 0x3811b536eb885015)
    },
    { /* i=594; 121 / 119 */
        RTUINT128_INIT_C(0x0110a5a31d21b6d1, 0xf8fbfe306fa1dab6), RTUINT128_INIT_C(0x000ac524c49a3bad, 0x695ecbc4de42d1e4),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000019), RTUINT128_INIT_C(0x0003650bea11e2e2, 0xaeba17f6bb1b5b72)
    },
    { /* i=595; 114 / 69 */
        RTUINT128_INIT_C(0x000297adf087a765, 0xffd049727bfce388), RTUINT128_INIT_C(0x0000000000000003, 0x000ee3129acad50d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000dd35b1206d58), RTUINT128_INIT_C(0x0000000000000000, 0x3ebf63cb4aed1e10)
    },
    { /* i=596; 124 / 123 */
        RTUINT128_INIT_C(0x0ff9b8b6874f5168, 0x094f953be660083c), RTUINT128_INIT_C(0x033b4d2ddd231751, 0x7f2c91eb3eaaa156),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000004), RTUINT128_INIT_C(0x030c83ff12c2f422, 0x0c9d4d8eebb582e4)
    },
    { /* i=597; 114 / 50 */
        RTUINT128_INIT_C(0x00032af9e2c4ec78, 0x8f20e376f06ee5dc), RTUINT128_INIT_C(0x0000000000000000, 0x0001112ff4ef54f2),
        RTUINT128_INIT_C(0x0000000000000002, 0xf7f44cb757a0dd1c), RTUINT128_INIT_C(0x0000000000000000, 0x00009f5434acb164)
    },
    { /* i=598; 122 / 109 */
        RTUINT128_INIT_C(0x001b6c731b257b3a, 0x7c17ef1cf73c57bf), RTUINT128_INIT_C(0x000019005bfb3573, 0x2216103dc667a999),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000118), RTUINT128_INIT_C(0x0000140e8063054d, 0x33f62b8bf5dad867)
    },
    { /* i=599; 123 / 71 */
        RTUINT128_INIT_C(0x032476912e4b0f16, 0x8b71fe69917af585), RTUINT128_INIT_C(0x000000000000000d, 0x6b4c8b1e0164beb1),
        RTUINT128_INIT_C(0x0000000000000000, 0x003bf2ee5f836d3c), RTUINT128_INIT_C(0x0000000000000008, 0x00aee8ea1519e709)
    },
    { /* i=600; 121 / 100 */
        RTUINT128_INIT_C(0x0154e2a497e31699, 0x3f03b3ae7d8152d8), RTUINT128_INIT_C(0x0000000057128068, 0xf860b0e28ff08b2b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000003ea3b77), RTUINT128_INIT_C(0x000000003fd50a1b, 0x2a85dfb06e4fb8db)
    },
    { /* i=601; 86 / 10 */
        RTUINT128_INIT_C(0x0000000000097ec4, 0x24d7aea6324315d5), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000150),
        RTUINT128_INIT_C(0x000000000000073c, 0x032842ce357ba0d3), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000e5)
    },
    { /* i=602; 113 / 127 */
        RTUINT128_INIT_C(0x000002314ad186f2, 0x4461589a2e2e31a0), RTUINT128_INIT_C(0x4b8e99961a92c28f, 0x6963c017c4e0c463),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000002314ad186f2, 0x4461589a2e2e31a0)
    },
    { /* i=603; 73 / 45 */
        RTUINT128_INIT_C(0x0000000000000167, 0x95ad8dd9db19a6f8), RTUINT128_INIT_C(0x0000000000000000, 0x00001903982a5684),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000e60148e), RTUINT128_INIT_C(0x0000000000000000, 0x0000055c7b5b59c0)
    },
    { /* i=604; 124 / 36 */
        RTUINT128_INIT_C(0x0bc3ae407f2de2ab, 0x2ca37e7bff79494c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000a9e03c54a),
        RTUINT128_INIT_C(0x00000000011ba8ca, 0x360e65936dc85f6a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000287e322a8)
    },
    { /* i=605; 52 / 52 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000c6ce077ae22ff), RTUINT128_INIT_C(0x0000000000000000, 0x00059da83fd84604),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002), RTUINT128_INIT_C(0x0000000000000000, 0x0001318ff7fd96f7)
    },
    { /* i=606; 79 / 14 */
        RTUINT128_INIT_C(0x000000000000205f, 0x946d64a6f34bacbb), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000002cab),
        RTUINT128_INIT_C(0x0000000000000000, 0xb9899486e057d519), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000908)
    },
    { /* i=607; 108 / 50 */
        RTUINT128_INIT_C(0x0000005b861fc304, 0xfc3f4ee51fb84cc8), RTUINT128_INIT_C(0x0000000000000000, 0x000146ada6477588),
        RTUINT128_INIT_C(0x0000000000000000, 0x0047b8e9659761f1), RTUINT128_INIT_C(0x0000000000000000, 0x0000fb1d87b21fc0)
    },
    { /* i=608; 62 / 2 */
        RTUINT128_INIT_C(0x0000000000000000, 0x381b21505aa17e46), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003),
        RTUINT128_INIT_C(0x0000000000000000, 0x12b3b5c5738b2a17), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001)
    },
    { /* i=609; 8 / 59 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000e8), RTUINT128_INIT_C(0x0000000000000000, 0x001accaae9c2335d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000e8)
    },
    { /* i=610; 120 / 41 */
        RTUINT128_INIT_C(0x005d90082ef0416a, 0x2ad594a49840ddaf), RTUINT128_INIT_C(0x0000000000000000, 0x0000001c6c28d8e2),
        RTUINT128_INIT_C(0x0000000000034ab6, 0xbc9a4521bb25653a), RTUINT128_INIT_C(0x0000000000000000, 0x000000118ac4907b)
    },
    { /* i=611; 23 / 19 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000077d923), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000051fb8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000017), RTUINT128_INIT_C(0x0000000000000000, 0x000000000001ff9b)
    },
    { /* i=612; 125 / 108 */
        RTUINT128_INIT_C(0x1dd0368b52548c40, 0x6614ca5dc4a6715c), RTUINT128_INIT_C(0x00000a8c12bfd90c, 0x0e5a780642981aa0),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000002d3a0), RTUINT128_INIT_C(0x0000060bc86fd82d, 0xec9018609263ed5c)
    },
    { /* i=613; 88 / 16 */
        RTUINT128_INIT_C(0x00000000002ecb3d, 0xa955368accf08ba1), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000b022),
        RTUINT128_INIT_C(0x0000000000000044, 0x033628ee38963b9e), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000a5)
    },
    { /* i=614; 128 / 116 */
        RTUINT128_INIT_C(0x9e3c9c14b0053fd0, 0x87b34867ee7dd449), RTUINT128_INIT_C(0x00075ff1342aba91, 0x005174277d2b44cb),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001574), RTUINT128_INIT_C(0x000659818b5ad115, 0xb443693eaa3e014d)
    },
    { /* i=615; 113 / 124 */
        RTUINT128_INIT_C(0x0001ad4ffac5e043, 0x9cbe4e8cc925d9c7), RTUINT128_INIT_C(0x0b121314cba7fb0f, 0xf8e93f65b7d2fdf8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0001ad4ffac5e043, 0x9cbe4e8cc925d9c7)
    },
    { /* i=616; 116 / 38 */
        RTUINT128_INIT_C(0x000dd24ed3cb9c6b, 0x7427c0ef702b4359), RTUINT128_INIT_C(0x0000000000000000, 0x00000003d09ff4bf),
        RTUINT128_INIT_C(0x0000000000039f7c, 0xabb6120242d17c2f), RTUINT128_INIT_C(0x0000000000000000, 0x000000009a51d048)
    },
    { /* i=617; 63 / 58 */
        RTUINT128_INIT_C(0x0000000000000000, 0x554d2e7b470383eb), RTUINT128_INIT_C(0x0000000000000000, 0x01523a6d25c85f4b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000040), RTUINT128_INIT_C(0x0000000000000000, 0x00be9331d4ebb12b)
    },
    { /* i=618; 120 / 78 */
        RTUINT128_INIT_C(0x006e4a7e103d9a9a, 0x0d1e33b06ef5d5d6), RTUINT128_INIT_C(0x000000000000153e, 0xea2acad4d5604e19),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000530f276a76c), RTUINT128_INIT_C(0x00000000000005c3, 0xc55b44ccf5dc944a)
    },
    { /* i=619; 124 / 88 */
        RTUINT128_INIT_C(0x0da4150483a0b047, 0x1d938ccd55b21bc2), RTUINT128_INIT_C(0x000000000012f683, 0x25d0de9edfda78aa),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000b8272b354c), RTUINT128_INIT_C(0x00000000000c2c53, 0x27a9f5067b4d174a)
    },
    { /* i=620; 124 / 12 */
        RTUINT128_INIT_C(0x00fdf8d11610792b, 0x004c0824502a222b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000311),
        RTUINT128_INIT_C(0x000052d2efb8ed90, 0xd984d3552984c847), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000074)
    },
    { /* i=621; 109 / 5 */
        RTUINT128_INIT_C(0x00001f8576a0ea37, 0xa8c5b07a6768247a), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000f),
        RTUINT128_INIT_C(0x00000219f6d78714, 0xc6fc1cd4f5d3be2a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000004)
    },
    { /* i=622; 126 / 122 */
        RTUINT128_INIT_C(0x1ff11b1ebbfe6c88, 0xaee2586a6d725b53), RTUINT128_INIT_C(0x0398cc2e092e84de, 0xf64ed261a023e4dc),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000008), RTUINT128_INIT_C(0x032ab9ae728a4590, 0xfc6bc55d6c533473)
    },
    { /* i=623; 126 / 106 */
        RTUINT128_INIT_C(0x39b40e003a5633a3, 0x0d9ade625b34d79f), RTUINT128_INIT_C(0x00000325da371a0e, 0x566d7e04cbeaa5d2),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000001254ba), RTUINT128_INIT_C(0x00000105c4be7d29, 0x785d657d8b8b750b)
    },
    { /* i=624; 59 / 57 */
        RTUINT128_INIT_C(0x0000000000000000, 0x02009def90bf25e3), RTUINT128_INIT_C(0x0000000000000000, 0x018d8a4bdfd9add2),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x0000000000000000, 0x007313a3b0e57811)
    },
    { /* i=625; 108 / 38 */
        RTUINT128_INIT_C(0x0000037a42a8a5a7, 0xf83ced4849405788), RTUINT128_INIT_C(0x0000000000000000, 0x00000023a72109b5),
        RTUINT128_INIT_C(0x0000000000000018, 0xf8620c955df814b5), RTUINT128_INIT_C(0x0000000000000000, 0x0000002361ca568f)
    },
    { /* i=626; 52 / 93 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0007dc3eefde6126), RTUINT128_INIT_C(0x00000000075a9966, 0x3ae5c31f1deece60),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0007dc3eefde6126)
    },
    { /* i=627; 115 / 100 */
        RTUINT128_INIT_C(0x000140763bfe7394, 0x27c796b59ffad4d5), RTUINT128_INIT_C(0x000000037183ad5d, 0xbf1d61ea691901ff),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000005d10), RTUINT128_INIT_C(0x000000024dc88f4a, 0x895f4fe0f8b111e5)
    },
    { /* i=628; 123 / 34 */
        RTUINT128_INIT_C(0x06387c470034adaf, 0x778807816c8cedcc), RTUINT128_INIT_C(0x0000000000000000, 0x00000000e71943c2),
        RTUINT128_INIT_C(0x0000000006e41425, 0xcfae3fe6c69e43cd), RTUINT128_INIT_C(0x0000000000000000, 0x00000000e2d9e572)
    },
    { /* i=629; 115 / 106 */
        RTUINT128_INIT_C(0x0005ff6a52e7cfa6, 0x993a047bd9ba881c), RTUINT128_INIT_C(0x000001c75848be99, 0xfd92515fdecde64f),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000035f), RTUINT128_INIT_C(0x00000067b5ad4688, 0xc8f9b24bc19f23cb)
    },
    { /* i=630; 115 / 70 */
        RTUINT128_INIT_C(0x0000bcb2e484fb7e, 0x8e08ac0ab131ecc9), RTUINT128_INIT_C(0x0000000000000022, 0x49b589b668eff32b),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000580dc322682), RTUINT128_INIT_C(0x0000000000000015, 0x5ddf897f56da0ef3)
    },
    { /* i=631; 124 / 109 */
        RTUINT128_INIT_C(0x00626acc437d64af, 0x702e84bd0aa2becf), RTUINT128_INIT_C(0x00000b81b923d130, 0x0f3c3b7016bd99f5),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000088d), RTUINT128_INIT_C(0x000006902c39acbd, 0x2a26474a97654ade)
    },
    { /* i=632; 111 / 75 */
        RTUINT128_INIT_C(0x00003452218794db, 0x888419b4946066d8), RTUINT128_INIT_C(0x0000000000000769, 0xb8e63d07f0edc1ca),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000070ed9568c), RTUINT128_INIT_C(0x0000000000000535, 0x50b187c4a3069060)
    },
    { /* i=633; 33 / 24 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000e7982f10), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000fc44ad),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000eb), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000052441)
    },
    { /* i=634; 52 / 21 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000ae9a31f41f81b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000120673),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000009afc330a), RTUINT128_INIT_C(0x0000000000000000, 0x000000000010ce9d)
    },
    { /* i=635; 121 / 100 */
        RTUINT128_INIT_C(0x00cbdcbac752e792, 0xa0c185038f1aca26), RTUINT128_INIT_C(0x0000000ff83b5d9d, 0x23e794c1131b32a9),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000cc3fe), RTUINT128_INIT_C(0x00000004e0bfa474, 0xa19ff69e829bcb78)
    },
    { /* i=636; 126 / 67 */
        RTUINT128_INIT_C(0x22250b0a8ea2ef9c, 0x1b30878e00232ff2), RTUINT128_INIT_C(0x0000000000000007, 0x7cd618196e26d1ff),
        RTUINT128_INIT_C(0x0000000000000000, 0x048f656074d91ec0), RTUINT128_INIT_C(0x0000000000000001, 0x877a28e34942ceb2)
    },
    { /* i=637; 66 / 37 */
        RTUINT128_INIT_C(0x0000000000000002, 0xf74387206afcc12a), RTUINT128_INIT_C(0x0000000000000000, 0x000000166e8eda2b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000021d8f921), RTUINT128_INIT_C(0x0000000000000000, 0x0000000b9916ce9f)
    },
    { /* i=638; 117 / 80 */
        RTUINT128_INIT_C(0x0006bdb9a17aa7fc, 0x5bc358e0b9115fda), RTUINT128_INIT_C(0x0000000000000946, 0x47c010cff24dd11b),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000ba12469c7b), RTUINT128_INIT_C(0x00000000000008b5, 0x93cce5b6cedf73e1)
    },
    { /* i=639; 108 / 23 */
        RTUINT128_INIT_C(0x00000fc799acc13e, 0x4b9b84807295bc9c), RTUINT128_INIT_C(0x0000000000000000, 0x00000000005421e2),
        RTUINT128_INIT_C(0x00000000003003cb, 0x92c7f09597e72f5f), RTUINT128_INIT_C(0x0000000000000000, 0x000000000036abbe)
    },
    { /* i=640; 64 / 6 */
        RTUINT128_INIT_C(0x0000000000000000, 0xa66e599c9c43e7ee), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000012),
        RTUINT128_INIT_C(0x0000000000000000, 0x093f04fa7a758ce2), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000a)
    },
    { /* i=641; 52 / 100 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0005ab2156f55826), RTUINT128_INIT_C(0x00000000dc9aebe7, 0x11d7df22647dfd08),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0005ab2156f55826)
    },
    { /* i=642; 106 / 30 */
        RTUINT128_INIT_C(0x000000a8c06ccbae, 0xaeb7ed45f28f7378), RTUINT128_INIT_C(0x0000000000000000, 0x00000000251e9d9d),
        RTUINT128_INIT_C(0x000000000000048b, 0xd13c79459fd06fa6), RTUINT128_INIT_C(0x0000000000000000, 0x0000000007ce2caa)
    },
    { /* i=643; 121 / 29 */
        RTUINT128_INIT_C(0x0069a1a52c6753f0, 0xf2460c4a5241dadf), RTUINT128_INIT_C(0x0000000000000000, 0x0000000007f8580c),
        RTUINT128_INIT_C(0x000000000d40e3ab, 0x8ec49ef44195df56), RTUINT128_INIT_C(0x0000000000000000, 0x000000000525d2d7)
    },
    { /* i=644; 97 / 81 */
        RTUINT128_INIT_C(0x00000001635e67b4, 0x9e1e2e16c97a0dc8), RTUINT128_INIT_C(0x000000000000d024, 0x503ecb1120486782),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000001b514), RTUINT128_INIT_C(0x00000000000027e3, 0x289214a4ab210da0)
    },
    { /* i=645; 126 / 117 */
        RTUINT128_INIT_C(0x3ce19685c96ac89b, 0x9ca968c1a6d26b8f), RTUINT128_INIT_C(0x0014224f37f9f300, 0x79fb9e2802f1b67b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000306), RTUINT128_INIT_C(0x0001db028bb6152a, 0xcde93bc8c004b3ad)
    },
    { /* i=646; 127 / 81 */
        RTUINT128_INIT_C(0x19bcaaaabfb7e6e5, 0x61461a6614d199a7), RTUINT128_INIT_C(0x000000000000f637, 0xcdf41ad243e1be36),
        RTUINT128_INIT_C(0x0000000000000000, 0x00001ac26da67bdd), RTUINT128_INIT_C(0x0000000000005ed3, 0x030528f9af887309)
    },
    { /* i=647; 115 / 69 */
        RTUINT128_INIT_C(0x00043490b8c354d2, 0xd903242f6d3dc033), RTUINT128_INIT_C(0x0000000000000003, 0x2e892da5c46f8659),
        RTUINT128_INIT_C(0x0000000000000000, 0x0001525a64072d22), RTUINT128_INIT_C(0x0000000000000001, 0x3eea43d24b614361)
    },
    { /* i=648; 125 / 98 */
        RTUINT128_INIT_C(0x0e846244b02bf4c1, 0x10d9303936b02577), RTUINT128_INIT_C(0x0000000303291b98, 0x91bcab2d2f5cd4c3),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000004d1b7ab), RTUINT128_INIT_C(0x00000001472687f5, 0x64d46e127863a236)
    },
    { /* i=649; 114 / 107 */
        RTUINT128_INIT_C(0x0002a2f899d5cfb7, 0xad633248cb08da57), RTUINT128_INIT_C(0x000007eb5eb12f7e, 0x84a0a462baa3d01f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000055), RTUINT128_INIT_C(0x000001d229010ab5, 0xa40c9d80d2a4c00c)
    },
    { /* i=650; 115 / 63 */
        RTUINT128_INIT_C(0x0004fecbc1fcc914, 0xd3ffb599c90c884e), RTUINT128_INIT_C(0x0000000000000000, 0x3da02ce942e29d7b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0014c042f4336109), RTUINT128_INIT_C(0x0000000000000000, 0x2ffc9419f5e863fb)
    },
    { /* i=651; 126 / 71 */
        RTUINT128_INIT_C(0x106f273574b9bda0, 0x230194cc7e55a4e5), RTUINT128_INIT_C(0x0000000000000028, 0xde3db61c100171f7),
        RTUINT128_INIT_C(0x0000000000000000, 0x0066f1d13aa53268), RTUINT128_INIT_C(0x0000000000000007, 0x3ac5e7de4b4a1a8d)
    },
    { /* i=652; 120 / 110 */
        RTUINT128_INIT_C(0x0049b43947fdf49b, 0x54e3fcde74769a9c), RTUINT128_INIT_C(0x000002013b5591de, 0xc164144c46585e0a),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000024c3), RTUINT128_INIT_C(0x000000f10d4c84bb, 0xf2cdcce071ed90fe)
    },
    { /* i=653; 107 / 13 */
        RTUINT128_INIT_C(0x0000053bb4881647, 0x9f15f67e0d718351), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000004e9),
        RTUINT128_INIT_C(0x0000000110d7fcc2, 0x59203217b98b64b6), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000001ab)
    },
    { /* i=654; 117 / 34 */
        RTUINT128_INIT_C(0x0010330cb52cb3d2, 0xde93350e9ccc1f2b), RTUINT128_INIT_C(0x0000000000000000, 0x00000000f777e6cd),
        RTUINT128_INIT_C(0x000000000010c205, 0x9b4abcb50327626c), RTUINT128_INIT_C(0x0000000000000000, 0x00000000bfa146af)
    },
    { /* i=655; 18 / 4 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000168d6), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001e11), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000a)
    },
    { /* i=656; 23 / 22 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000004fd559), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000396b25),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000166a34)
    },
    { /* i=657; 34 / 94 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000003e010ec00), RTUINT128_INIT_C(0x0000000036325fd3, 0xd088495a641f9237),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00000003e010ec00)
    },
    { /* i=658; 117 / 58 */
        RTUINT128_INIT_C(0x0019a6beeb5c0a98, 0x17b77fe62934f338), RTUINT128_INIT_C(0x0000000000000000, 0x02997bf938f595f4),
        RTUINT128_INIT_C(0x0000000000000000, 0x09de1c54e3c2cf56), RTUINT128_INIT_C(0x0000000000000000, 0x01f682fb738c4740)
    },
    { /* i=659; 118 / 89 */
        RTUINT128_INIT_C(0x0004eafc17d25474, 0xb4186511cef36b0e), RTUINT128_INIT_C(0x0000000001237b03, 0xcddcf53af042bd4e),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000451bc0c), RTUINT128_INIT_C(0x0000000000662e5a, 0x463e8dca6b1f4366)
    },
    { /* i=660; 122 / 118 */
        RTUINT128_INIT_C(0x0020b9710c418f5d, 0xe26e444e6dd9387e), RTUINT128_INIT_C(0x002e5ca4592ae6b6, 0x34c11a39042f1cc5),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0020b9710c418f5d, 0xe26e444e6dd9387e)
    },
    { /* i=661; 128 / 32 */
        RTUINT128_INIT_C(0x1182820f2ff4fb43, 0x3e60d51d556d54a0), RTUINT128_INIT_C(0x0000000000000000, 0x00000000202eec22),
        RTUINT128_INIT_C(0x000000008b47d570, 0xeae2a8074091d362), RTUINT128_INIT_C(0x0000000000000000, 0x000000001794e99c)
    },
    { /* i=662; 127 / 127 */
        RTUINT128_INIT_C(0x3fe74414cde0d455, 0xab9e7c46e6bf5ab5), RTUINT128_INIT_C(0x416607e4f901bf20, 0xa0ad3099e362a4b2),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x3fe74414cde0d455, 0xab9e7c46e6bf5ab5)
    },
    { /* i=663; 120 / 126 */
        RTUINT128_INIT_C(0x002c40d8fbda161a, 0xaf0f3c468cb7691e), RTUINT128_INIT_C(0x2637766316b38cc3, 0xad31d00bb044247c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x002c40d8fbda161a, 0xaf0f3c468cb7691e)
    },
    { /* i=664; 123 / 104 */
        RTUINT128_INIT_C(0x055d1c1a9636af3c, 0x0d7daa768cc1eed6), RTUINT128_INIT_C(0x000000e532ee12b2, 0x129ef3ffc9726223),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000005fdac), RTUINT128_INIT_C(0x00000020b84dc615, 0xaf8f01493e3c6852)
    },
    { /* i=665; 114 / 125 */
        RTUINT128_INIT_C(0x0001e1bc6a213b33, 0x286fc4bade5fdf68), RTUINT128_INIT_C(0x0fe6bf54c741caf8, 0x6335a2dbd3c795a5),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0001e1bc6a213b33, 0x286fc4bade5fdf68)
    },
    { /* i=666; 113 / 97 */
        RTUINT128_INIT_C(0x0000dc523e4c6adc, 0x115c9187532bc2af), RTUINT128_INIT_C(0x00000001e6061481, 0x42094ed9fd91a617),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000740c), RTUINT128_INIT_C(0x00000000b4b8e2e0, 0xc132186971158d9b)
    },
    { /* i=667; 85 / 6 */
        RTUINT128_INIT_C(0x00000000001035cb, 0x33784ca7920add8b), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000002b),
        RTUINT128_INIT_C(0x0000000000006081, 0xbfb566fdf1892ed3), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000001a)
    },
    { /* i=668; 87 / 59 */
        RTUINT128_INIT_C(0x00000000002d1d34, 0x15900905785dc77f), RTUINT128_INIT_C(0x0000000000000000, 0x0119d6c4b77119f7),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000028fa5fee), RTUINT128_INIT_C(0x0000000000000000, 0x00128d8e015efadd)
    },
    { /* i=669; 97 / 26 */
        RTUINT128_INIT_C(0x000000007eba2ecb, 0x6c4064c0ce50d4d8), RTUINT128_INIT_C(0x0000000000000000, 0x000000000048ca00),
        RTUINT128_INIT_C(0x00000000000001bd, 0xb38b1b3b9a2e8e78), RTUINT128_INIT_C(0x0000000000000000, 0x00000000002624d8)
    },
    { /* i=670; 126 / 35 */
        RTUINT128_INIT_C(0x217aa1af4b1578aa, 0xb39bf6a04c6b79b0), RTUINT128_INIT_C(0x0000000000000000, 0x00000000e8adaa0f),
        RTUINT128_INIT_C(0x0000000024d5ad0a, 0x4419ec7e8a83d404), RTUINT128_INIT_C(0x0000000000000000, 0x00000000bd336574)
    },
    { /* i=671; 114 / 115 */
        RTUINT128_INIT_C(0x000235d57161fe47, 0xa1d68f3a70431ec6), RTUINT128_INIT_C(0x00068d4e962fa2a6, 0x08fb74f184248d76),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000235d57161fe47, 0xa1d68f3a70431ec6)
    },
    { /* i=672; 109 / 45 */
        RTUINT128_INIT_C(0x000005ed8939f0a6, 0xd90c5d40ebbdee71), RTUINT128_INIT_C(0x0000000000000000, 0x00000deefa77b100),
        RTUINT128_INIT_C(0x0000000000000000, 0x6ce9a65302b8ea2f), RTUINT128_INIT_C(0x0000000000000000, 0x000005064ffa6f71)
    },
    { /* i=673; 67 / 14 */
        RTUINT128_INIT_C(0x0000000000000000, 0x5de7489e29b2bdf9), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000003730),
        RTUINT128_INIT_C(0x0000000000000000, 0x0001b397c8e1bbeb), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000004e9)
    },
    { /* i=674; 109 / 105 */
        RTUINT128_INIT_C(0x00000d79ba94222a, 0x6fc8a7ee7f06a21d), RTUINT128_INIT_C(0x000001d8aba75154, 0x10ed19557bed367e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000007), RTUINT128_INIT_C(0x0000008d0900e8dd, 0xf94cf6981b8a24ab)
    },
    { /* i=675; 100 / 88 */
        RTUINT128_INIT_C(0x0000000bce4d7b61, 0xc11901e5b40f6e3b), RTUINT128_INIT_C(0x00000000002107ff, 0x9750891649a04e53),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000005b7f), RTUINT128_INIT_C(0x000000000012a8cc, 0x0f6a13ab31b1120e)
    },
    { /* i=676; 86 / 88 */
        RTUINT128_INIT_C(0x000000000002b324, 0x9cdf18dd5291c322), RTUINT128_INIT_C(0x00000000002794b9, 0x7448f664e0863d97),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000000000002b324, 0x9cdf18dd5291c322)
    },
    { /* i=677; 119 / 3 */
        RTUINT128_INIT_C(0x00603c64bc6d1aad, 0x66eca7bc68d72a12), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000005),
        RTUINT128_INIT_C(0x00133f4758e29eef, 0x7afc218c14f7d536), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000004)
    },
    { /* i=678; 37 / 8 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000004ccd7ff9), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000035),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000172f8c1), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000004)
    },
    { /* i=679; 93 / 58 */
        RTUINT128_INIT_C(0x0000000011ade89e, 0x196c191deb928fb7), RTUINT128_INIT_C(0x0000000000000000, 0x002a412a9ff133e0),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000006b1c4cc962), RTUINT128_INIT_C(0x0000000000000000, 0x001e23506901d3f7)
    },
    { /* i=680; 122 / 108 */
        RTUINT128_INIT_C(0x03f5454acac9a322, 0xc53e647b52decb2f), RTUINT128_INIT_C(0x0000026ab5eaf454, 0x045854f067da9438),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000001a341), RTUINT128_INIT_C(0x000000730c3c16b1, 0x17cb597633c780f7)
    },
    { /* i=681; 119 / 124 */
        RTUINT128_INIT_C(0x00607b6b17cabfde, 0x02658a9669a2c5cb), RTUINT128_INIT_C(0x0cc135caed515228, 0x1d76e6aaf81540cb),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00607b6b17cabfde, 0x02658a9669a2c5cb)
    },
    { /* i=682; 123 / 70 */
        RTUINT128_INIT_C(0x0067b08c0610cdfd, 0x90f887c21ebd9fb7), RTUINT128_INIT_C(0x0000000000000031, 0x23a7dadd4775fe9c),
        RTUINT128_INIT_C(0x0000000000000000, 0x00021c30a2e71d3d), RTUINT128_INIT_C(0x000000000000000d, 0x3e195c184304488b)
    },
    { /* i=683; 126 / 90 */
        RTUINT128_INIT_C(0x12648747cb8a6ba6, 0x3748b556664f9007), RTUINT128_INIT_C(0x0000000003cfa7b9, 0x4e882092c6809c9b),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000004d375d991), RTUINT128_INIT_C(0x000000000034bec4, 0x61deaba99ee0793c)
    },
    { /* i=684; 66 / 16 */
        RTUINT128_INIT_C(0x0000000000000000, 0xf45b11f7c59dfc7a), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000de3b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0001197cc4481cd3), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000005dd9)
    },
    { /* i=685; 123 / 108 */
        RTUINT128_INIT_C(0x04579a54ea916432, 0xa5ce1c8732363237), RTUINT128_INIT_C(0x00000330cfb26520, 0xee9ea786141c45ce),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000015c64), RTUINT128_INIT_C(0x000000ed47691ef5, 0xc41a68d0e846e5bf)
    },
    { /* i=686; 62 / 6 */
        RTUINT128_INIT_C(0x0000000000000000, 0x2e67a94508463146), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000003b),
        RTUINT128_INIT_C(0x0000000000000000, 0x00c959a60d283d94), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000002a)
    },
    { /* i=687; 103 / 64 */
        RTUINT128_INIT_C(0x0000007466369fc1, 0x9236d9a91b60142f), RTUINT128_INIT_C(0x0000000000000000, 0x2599ed088faab6a3),
        RTUINT128_INIT_C(0x0000000000000000, 0x000003187a956b04), RTUINT128_INIT_C(0x0000000000000000, 0x23248fcc878018a3)
    },
    { /* i=688; 79 / 113 */
        RTUINT128_INIT_C(0x00000000000028b3, 0x7b643aa043e23a9f), RTUINT128_INIT_C(0x0000a7a46ff5c1fa, 0xa03f50043d69f7ca),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00000000000028b3, 0x7b643aa043e23a9f)
    },
    { /* i=689; 113 / 112 */
        RTUINT128_INIT_C(0x0000e109d3e6f736, 0x772505ca75daf366), RTUINT128_INIT_C(0x00006486054939df, 0xc5c4608285193c50),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002), RTUINT128_INIT_C(0x000017fdc9548376, 0xeb9c44c56ba87ac6)
    },
    { /* i=690; 126 / 121 */
        RTUINT128_INIT_C(0x240de2f247c47d60, 0xf6fcc3aacd06aae9), RTUINT128_INIT_C(0x00201636f141e621, 0x8a946892b8cbaf0d),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000011f), RTUINT128_INIT_C(0x0014fb59cee37dc6, 0x9a9b872da0ad6b56)
    },
    { /* i=691; 110 / 77 */
        RTUINT128_INIT_C(0x00000f63f8e483fd, 0xcf74ba4b8ab4afce), RTUINT128_INIT_C(0x0000000000000f94, 0x8f2d9878152c5f99),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000fce1aa96), RTUINT128_INIT_C(0x00000000000002b4, 0x6d1b5bc509c01228)
    },
    { /* i=692; 49 / 43 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00004e8995e5d710), RTUINT128_INIT_C(0x0000000000000000, 0x0000026ec7fffeef),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000020), RTUINT128_INIT_C(0x0000000000000000, 0x000000b095e5f930)
    },
    { /* i=693; 125 / 109 */
        RTUINT128_INIT_C(0x0cadf35088706c60, 0x2d49e9b5def38097), RTUINT128_INIT_C(0x0000084b33637911, 0xd8e6376ab57041a9),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000001875f), RTUINT128_INIT_C(0x000003eb889c3c79, 0x11375dfe160203e0)
    },
    { /* i=694; 121 / 58 */
        RTUINT128_INIT_C(0x01bb142dd8ed1534, 0x044b8099be72986d), RTUINT128_INIT_C(0x0000000000000000, 0x022b0db0450c07f9),
        RTUINT128_INIT_C(0x0000000000000000, 0xcc5afc1659b85e80), RTUINT128_INIT_C(0x0000000000000000, 0x009f544b81892ded)
    },
    { /* i=695; 41 / 5 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000f7e594d18d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000009),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000001b8b496c9d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000008)
    },
    { /* i=696; 86 / 46 */
        RTUINT128_INIT_C(0x00000000002d58fb, 0xae1d6d6c53210fed), RTUINT128_INIT_C(0x0000000000000000, 0x0000205591aae902),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000016707ce5bd8), RTUINT128_INIT_C(0x0000000000000000, 0x000014bd1c7cc03d)
    },
    { /* i=697; 121 / 65 */
        RTUINT128_INIT_C(0x00681fd9a687aac7, 0xab3fad993863af4f), RTUINT128_INIT_C(0x0000000000000001, 0xa039ce197382ec6a),
        RTUINT128_INIT_C(0x0000000000000000, 0x00400ab3836f63c4), RTUINT128_INIT_C(0x0000000000000001, 0x44dd839466c3b027)
    },
    { /* i=698; 115 / 117 */
        RTUINT128_INIT_C(0x0006a4303c396d56, 0xe38043ce97e176d8), RTUINT128_INIT_C(0x0009817d0e55c358, 0x655ef755ff5a5c59),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0006a4303c396d56, 0xe38043ce97e176d8)
    },
    { /* i=699; 117 / 63 */
        RTUINT128_INIT_C(0x00027ac0bf9674b7, 0x0fdf4d4e6f7e4696), RTUINT128_INIT_C(0x0000000000000000, 0x39df722439f02018),
        RTUINT128_INIT_C(0x0000000000000000, 0x000af7d2ff732aaa), RTUINT128_INIT_C(0x0000000000000000, 0x25e5dd383dfd06a6)
    },
    { /* i=700; 96 / 73 */
        RTUINT128_INIT_C(0x00000000cb13d6a4, 0x97d507318872a455), RTUINT128_INIT_C(0x000000000000019a, 0xcfd73d6a75854229),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000007e8c8c), RTUINT128_INIT_C(0x0000000000000060, 0xfe23611dd33609e9)
    },
    { /* i=701; 31 / 11 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000007bd7abd9), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000618),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000001452a7), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000231)
    },
    { /* i=702; 113 / 126 */
        RTUINT128_INIT_C(0x0000359da58fe4fa, 0x0db3610b37f7d406), RTUINT128_INIT_C(0x31098587ef8eb9d0, 0xc20be13ae5cab44e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000359da58fe4fa, 0x0db3610b37f7d406)
    },
    { /* i=703; 38 / 8 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000010ab87d8b4), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000005f),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000002cebdf3f), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000053)
    },
    { /* i=704; 57 / 3 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0164da1122b385cd), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000004),
        RTUINT128_INIT_C(0x0000000000000000, 0x0059368448ace173), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001)
    },
    { /* i=705; 26 / 37 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000023b1013), RTUINT128_INIT_C(0x0000000000000000, 0x000000153b215ebc),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00000000023b1013)
    },
    { /* i=706; 123 / 25 */
        RTUINT128_INIT_C(0x06086291bea41278, 0x98dfb9750cf7036b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000987c11),
        RTUINT128_INIT_C(0x0000000a20cd7cb0, 0x2ae1afe2d98a2488), RTUINT128_INIT_C(0x0000000000000000, 0x000000000058b663)
    },
    { /* i=707; 58 / 54 */
        RTUINT128_INIT_C(0x0000000000000000, 0x027284b82e0b0f95), RTUINT128_INIT_C(0x0000000000000000, 0x002e1633837f84fe),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000d), RTUINT128_INIT_C(0x0000000000000000, 0x001b641a80914eaf)
    },
    { /* i=708; 114 / 111 */
        RTUINT128_INIT_C(0x0003ca60c4f95620, 0xbc159f11488eee1a), RTUINT128_INIT_C(0x00005244668bb1d8, 0x857fdce04e5142c6),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000b), RTUINT128_INIT_C(0x000041705cf8b1d2, 0xff97216deb110f98)
    },
    { /* i=709; 124 / 73 */
        RTUINT128_INIT_C(0x03da4dbac567c120, 0xfa7434b1bf2f9df7), RTUINT128_INIT_C(0x00000000000001da, 0x508173620d6b4109),
        RTUINT128_INIT_C(0x0000000000000000, 0x0002145582168a2e), RTUINT128_INIT_C(0x0000000000000157, 0xadfdb39c5c151459)
    },
    { /* i=710; 54 / 40 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00282c1266e0ce15), RTUINT128_INIT_C(0x0000000000000000, 0x00000061ac0a4f8d),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000694a), RTUINT128_INIT_C(0x0000000000000000, 0x000000467144fa53)
    },
    { /* i=711; 120 / 96 */
        RTUINT128_INIT_C(0x0084c7bf3dd2a570, 0xc3bcb57c89f959ee), RTUINT128_INIT_C(0x00000000e4ee656f, 0xe1856cb69d0c2d64),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000947aeb), RTUINT128_INIT_C(0x00000000d5f5d520, 0x4ee017f8545a0722)
    },
    { /* i=712; 125 / 89 */
        RTUINT128_INIT_C(0x06467bfdb5281e7a, 0xcbb5ca46b5455744), RTUINT128_INIT_C(0x00000000005edda8, 0x5853aee2ca0edfd1),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000010ef2c9c4f), RTUINT128_INIT_C(0x00000000002ee4e0, 0x20c40496b35ee9c5)
    },
    { /* i=713; 114 / 114 */
        RTUINT128_INIT_C(0x000397630a0e1980, 0xac4715a245a4f57e), RTUINT128_INIT_C(0x0002b68471d668a9, 0x2af8f2aa079dc5a7),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x0000e0de9837b0d7, 0x814e22f83e072fd7)
    },
    { /* i=714; 126 / 101 */
        RTUINT128_INIT_C(0x22565b8a5a750197, 0xf7ffaba9d563bef7), RTUINT128_INIT_C(0x0000000f5a00700a, 0x58f76fa2c79cd953),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000023c9a6b), RTUINT128_INIT_C(0x0000000121c12ae2, 0x7fb6141676a4fb46)
    },
    { /* i=715; 128 / 114 */
        RTUINT128_INIT_C(0x1334e32bcf20a584, 0x0304e2e270ec954b), RTUINT128_INIT_C(0x0002ea41501af1d9, 0x378a2df618d8cc36),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000696), RTUINT128_INIT_C(0x000219063dabd8f0, 0x3afa301acd1ba9a7)
    },
    { /* i=716; 124 / 44 */
        RTUINT128_INIT_C(0x0323b5bb0e82b3e0, 0xaf97db09b283b4fe), RTUINT128_INIT_C(0x0000000000000000, 0x000008bcfb36f464),
        RTUINT128_INIT_C(0x0000000000005bf9, 0xfc7985f706458430), RTUINT128_INIT_C(0x0000000000000000, 0x0000060c0b3e523e)
    },
    { /* i=717; 122 / 67 */
        RTUINT128_INIT_C(0x013d6b50195e661f, 0x7058cceced816ef4), RTUINT128_INIT_C(0x0000000000000007, 0x192b3d0262a42c64),
        RTUINT128_INIT_C(0x0000000000000000, 0x002cb7b0569636ee), RTUINT128_INIT_C(0x0000000000000003, 0x90f4a00afceb11fc)
    },
    { /* i=718; 120 / 58 */
        RTUINT128_INIT_C(0x00ffe3d26a197827, 0xb4117c2f687d0135), RTUINT128_INIT_C(0x0000000000000000, 0x00ee7b9687262460),
        RTUINT128_INIT_C(0x0000000000000001, 0x12af8e930ecf2a09), RTUINT128_INIT_C(0x0000000000000000, 0x0098f0c3bc8df9d5)
    },
    { /* i=719; 113 / 118 */
        RTUINT128_INIT_C(0x0001e06119e6c6a3, 0xdfb62201b13a3697), RTUINT128_INIT_C(0x00026bb7f4c6d30c, 0x3d6a864fb059bfc0),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0001e06119e6c6a3, 0xdfb62201b13a3697)
    },
    { /* i=720; 7 / 62 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000032), RTUINT128_INIT_C(0x0000000000000000, 0x061742267887e8bd),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000032)
    },
    { /* i=721; 120 / 73 */
        RTUINT128_INIT_C(0x007edf0085b437f6, 0xd494c7e68b69a804), RTUINT128_INIT_C(0x00000000000001ab, 0x84bb848f29d974e3),
        RTUINT128_INIT_C(0x0000000000000000, 0x00004bf892b5252a), RTUINT128_INIT_C(0x0000000000000182, 0x54a9ff0c2558abc6)
    },
    { /* i=722; 68 / 57 */
        RTUINT128_INIT_C(0x0000000000000003, 0x33506ad905dfd965), RTUINT128_INIT_C(0x0000000000000000, 0x017d61354287fc0a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000225), RTUINT128_INIT_C(0x0000000000000000, 0x016ef3a1584057f3)
    },
    { /* i=723; 122 / 79 */
        RTUINT128_INIT_C(0x02a55131f9b00afc, 0x7c6342a357892433), RTUINT128_INIT_C(0x00000000000038f4, 0xfcfa190fe16da6d0),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000be448826d43), RTUINT128_INIT_C(0x0000000000000446, 0x1cf81ea6722febc3)
    },
    { /* i=724; 56 / 12 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00b32b411fa115c7), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000bbf),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000f40e4f00c5a), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000a1)
    },
    { /* i=725; 44 / 25 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000f41a0758a0b), RTUINT128_INIT_C(0x0000000000000000, 0x000000000137a5b2),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000c883e), RTUINT128_INIT_C(0x0000000000000000, 0x00000000009cd8ef)
    },
    { /* i=726; 78 / 17 */
        RTUINT128_INIT_C(0x0000000000002a3d, 0x759b29b8d7fa5ea1), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000009d3c),
        RTUINT128_INIT_C(0x0000000000000000, 0x44c5dae0cbe11db4), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000471)
    },
    { /* i=727; 114 / 30 */
        RTUINT128_INIT_C(0x000296a60161fdb1, 0x96387906e176bec3), RTUINT128_INIT_C(0x0000000000000000, 0x00000000193bcc89),
        RTUINT128_INIT_C(0x00000000001a42b4, 0xbd9f5d8ad0e7e9a8), RTUINT128_INIT_C(0x0000000000000000, 0x000000000570d3db)
    },
    { /* i=728; 115 / 48 */
        RTUINT128_INIT_C(0x0007fdce97841411, 0xbb8f18c6f63f3f6f), RTUINT128_INIT_C(0x0000000000000000, 0x00007e3788e0c22d),
        RTUINT128_INIT_C(0x0000000000000010, 0x356a9047febdb197), RTUINT128_INIT_C(0x0000000000000000, 0x0000074ed23299e4)
    },
    { /* i=729; 106 / 105 */
        RTUINT128_INIT_C(0x000003ee544ff59e, 0xa241e9c909ce8d46), RTUINT128_INIT_C(0x000000a8c86ea224, 0xddf5c70954cb1538),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000005), RTUINT128_INIT_C(0x000000a26a26cae6, 0x4c75069a61d7232e)
    },
    { /* i=730; 90 / 43 */
        RTUINT128_INIT_C(0x000000000371bc4e, 0x9b8887ec5f93880e), RTUINT128_INIT_C(0x0000000000000000, 0x000006b67eabcb22),
        RTUINT128_INIT_C(0x0000000000000000, 0x000083599a217798), RTUINT128_INIT_C(0x0000000000000000, 0x00000585aac41dde)
    },
    { /* i=731; 56 / 51 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0012b39164caa50d), RTUINT128_INIT_C(0x0000000000000000, 0x00079f17afa9aafc),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002), RTUINT128_INIT_C(0x0000000000000000, 0x0003756205774f15)
    },
    { /* i=732; 31 / 9 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000006b9bbe59), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000027),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000002c25a36), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000001f)
    },
    { /* i=733; 56 / 56 */
        RTUINT128_INIT_C(0x0000000000000000, 0x006b5f174c8c7ffc), RTUINT128_INIT_C(0x0000000000000000, 0x0077868d9aaebc16),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x006b5f174c8c7ffc)
    },
    { /* i=734; 126 / 63 */
        RTUINT128_INIT_C(0x2f513389925b69d5, 0x11f5cd667959ce17), RTUINT128_INIT_C(0x0000000000000000, 0x2420322ffddc5e69),
        RTUINT128_INIT_C(0x0000000000000001, 0x4f4e71c13974f1f4), RTUINT128_INIT_C(0x0000000000000000, 0x12f42aa2e5daf903)
    },
    { /* i=735; 113 / 121 */
        RTUINT128_INIT_C(0x000062fedb04186b, 0x4accf17e3d429ff0), RTUINT128_INIT_C(0x00ffa22b5cf2b8b1, 0x4d5cfdb9162de3b1),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000062fedb04186b, 0x4accf17e3d429ff0)
    },
    { /* i=736; 86 / 30 */
        RTUINT128_INIT_C(0x000000000037766c, 0x30c23283b00d52c3), RTUINT128_INIT_C(0x0000000000000000, 0x00000000099761cd),
        RTUINT128_INIT_C(0x0000000000000000, 0x05c8569e2321f309), RTUINT128_INIT_C(0x0000000000000000, 0x0000000005784b8e)
    },
    { /* i=737; 23 / 99 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000001120c4), RTUINT128_INIT_C(0x0000000704388812, 0x2ab06f7ea2e0a124),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00000000001120c4)
    },
    { /* i=738; 114 / 72 */
        RTUINT128_INIT_C(0x0002939faf31a2b7, 0x5e04c6d562a5e90e), RTUINT128_INIT_C(0x0000000000000093, 0x60a18aa76f676912),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000479ca57976e), RTUINT128_INIT_C(0x0000000000000035, 0x0d7f099e9c1f2552)
    },
    { /* i=739; 106 / 85 */
        RTUINT128_INIT_C(0x000003ea9b723385, 0x6abfc21d58a3836d), RTUINT128_INIT_C(0x0000000000070453, 0xda2b45e0fce30fdb),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000008ee271), RTUINT128_INIT_C(0x0000000000043fe7, 0x2729049a78f02dc2)
    },
    { /* i=740; 73 / 30 */
        RTUINT128_INIT_C(0x000000000000009f, 0xddcf0616382031f5), RTUINT128_INIT_C(0x0000000000000000, 0x000000003b6a9669),
        RTUINT128_INIT_C(0x0000000000000000, 0x000002b0cc08030f), RTUINT128_INIT_C(0x0000000000000000, 0x000000001dd626ce)
    },
    { /* i=741; 45 / 44 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000017875e2ca949), RTUINT128_INIT_C(0x0000000000000000, 0x00000e7ccb665390),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x0000000000000000, 0x0000090a92c655b9)
    },
    { /* i=742; 126 / 84 */
        RTUINT128_INIT_C(0x1395d0c81e79117d, 0xb26e8dbdd49de717), RTUINT128_INIT_C(0x0000000000080732, 0x950b6cef39320878),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000027088350eb1), RTUINT128_INIT_C(0x000000000006df05, 0xf7b516db0bb77c1f)
    },
    { /* i=743; 103 / 6 */
        RTUINT128_INIT_C(0x000000406e30acc1, 0x710bf92b43132cb6), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000003e),
        RTUINT128_INIT_C(0x000000010a090b0b, 0x60ca8404d3a9997e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000032)
    },
    { /* i=744; 118 / 120 */
        RTUINT128_INIT_C(0x00103fb1b5b49d9d, 0x010a9d108db8a94c), RTUINT128_INIT_C(0x0099ae79160a9d29, 0x5ae2535f92d37154),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00103fb1b5b49d9d, 0x010a9d108db8a94c)
    },
    { /* i=745; 80 / 45 */
        RTUINT128_INIT_C(0x0000000000002c54, 0xc6e3bdb6a1c3d48f), RTUINT128_INIT_C(0x0000000000000000, 0x000003dc815bf7ff),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000b7b121298), RTUINT128_INIT_C(0x0000000000000000, 0x0000011d66caa727)
    },
    { /* i=746; 125 / 96 */
        RTUINT128_INIT_C(0x14571877ffafb8a5, 0x7c9cfc5de19acf80), RTUINT128_INIT_C(0x0000000074928501, 0xc3e6264bea029fca),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000002cab19c6), RTUINT128_INIT_C(0x00000000618643d5, 0xddf030952e0a7f44)
    },
    { /* i=747; 116 / 74 */
        RTUINT128_INIT_C(0x000d97be70977d0d, 0xdff84010f0316898), RTUINT128_INIT_C(0x000000000000022d, 0x34a5c33501ee56c5),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000063eb7af2746), RTUINT128_INIT_C(0x00000000000000ee, 0xd688789cf622abba)
    },
    { /* i=748; 54 / 7 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0023f055190b4156), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000001a),
        RTUINT128_INIT_C(0x0000000000000000, 0x000161dbe36cbd97), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=749; 42 / 38 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000001296e2cf2a2), RTUINT128_INIT_C(0x0000000000000000, 0x000000141b1d1c67),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000ff2956500)
    },
    { /* i=750; 127 / 57 */
        RTUINT128_INIT_C(0x4a4be9c3816b5eb6, 0x2fa4b6c5d8bbd84c), RTUINT128_INIT_C(0x0000000000000000, 0x007bdb4c0821b294),
        RTUINT128_INIT_C(0x0000000000000099, 0x905f0318a3bd0489), RTUINT128_INIT_C(0x0000000000000000, 0x00733b7fe4a4f718)
    },
    { /* i=751; 80 / 60 */
        RTUINT128_INIT_C(0x00000000000056bd, 0x9fe3aab6d85ff0c4), RTUINT128_INIT_C(0x0000000000000000, 0x0c46f677b7af707e),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000710b0), RTUINT128_INIT_C(0x0000000000000000, 0x026cb7218548ba24)
    },
    { /* i=752; 54 / 48 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00377c9b9c46cd6c), RTUINT128_INIT_C(0x0000000000000000, 0x0000df5c4793abe5),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000003f), RTUINT128_INIT_C(0x0000000000000000, 0x000084e5feef8011)
    },
    { /* i=753; 77 / 15 */
        RTUINT128_INIT_C(0x0000000000000f4c, 0x2b76c3f3d3bd9c81), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000006929),
        RTUINT128_INIT_C(0x0000000000000000, 0x253d741b3bf45baf), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000267a)
    },
    { /* i=754; 48 / 7 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000e377a137c0ce), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000005e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000026b7c44ada0), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000e)
    },
    { /* i=755; 81 / 74 */
        RTUINT128_INIT_C(0x0000000000001604, 0x45cda5ac5a996982), RTUINT128_INIT_C(0x00000000000003ff, 0x926656f155e200b8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000005), RTUINT128_INIT_C(0x0000000000000206, 0x69cdf2f5ad2f65ea)
    },
    { /* i=756; 21 / 101 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000001537df), RTUINT128_INIT_C(0x000000145f987232, 0x8ddcb00f18379704),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00000000001537df)
    },
    { /* i=757; 60 / 22 */
        RTUINT128_INIT_C(0x0000000000000000, 0x053cf5fb3c36385b), RTUINT128_INIT_C(0x0000000000000000, 0x000000000038820d),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000017baff29e4), RTUINT128_INIT_C(0x0000000000000000, 0x00000000001b4fc7)
    },
    { /* i=758; 29 / 18 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000428cffe), RTUINT128_INIT_C(0x0000000000000000, 0x000000000002a76b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000191), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000009163)
    },
    { /* i=759; 120 / 43 */
        RTUINT128_INIT_C(0x0011067b6f013746, 0xf890d7cb98729184), RTUINT128_INIT_C(0x0000000000000000, 0x00000245476e721d),
        RTUINT128_INIT_C(0x000000000000077f, 0x82ca82147cdf11d3), RTUINT128_INIT_C(0x0000000000000000, 0x00000233ef93969d)
    },
    { /* i=760; 103 / 34 */
        RTUINT128_INIT_C(0x000000291258291a, 0xd5d237bff4ee643e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000185776f8c),
        RTUINT128_INIT_C(0x000000000000001a, 0xff2d438ef9a013af), RTUINT128_INIT_C(0x0000000000000000, 0x00000000f781bf8a)
    },
    { /* i=761; 69 / 15 */
        RTUINT128_INIT_C(0x0000000000000009, 0x9118efa08a76ba9d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000006506),
        RTUINT128_INIT_C(0x0000000000000000, 0x00183e2c4d882bc7), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000030f3)
    },
    { /* i=762; 126 / 82 */
        RTUINT128_INIT_C(0x1218f8b8fd908ca4, 0xe8b76f1a04e90f41), RTUINT128_INIT_C(0x000000000002e1df, 0xf3697bc6b9753f5c),
        RTUINT128_INIT_C(0x0000000000000000, 0x000006475fb93bc1), RTUINT128_INIT_C(0x0000000000029d15, 0xb63b0ec8406e16e5)
    },
    { /* i=763; 121 / 57 */
        RTUINT128_INIT_C(0x00243e8f54bb5a9f, 0x5f3f390a06a6c60a), RTUINT128_INIT_C(0x0000000000000000, 0x00d4f52ee3fe89ad),
        RTUINT128_INIT_C(0x0000000000000000, 0x2b91e8b522662ab9), RTUINT128_INIT_C(0x0000000000000000, 0x007093baac30e605)
    },
    { /* i=764; 100 / 67 */
        RTUINT128_INIT_C(0x0000000985519897, 0x393a2659c43bf464), RTUINT128_INIT_C(0x0000000000000005, 0x2e0e8b84b4f7b264),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000001d68877d4), RTUINT128_INIT_C(0x0000000000000004, 0x8f95073a660fbd94)
    },
    { /* i=765; 120 / 98 */
        RTUINT128_INIT_C(0x00806c8de7bf63b7, 0x414e4b68228079ad), RTUINT128_INIT_C(0x0000000001488472, 0x5ee3b751dd2f2e28),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000641356cf), RTUINT128_INIT_C(0x00000000000fe0d9, 0x721db76062e0b755)
    },
    { /* i=766; 120 / 127 */
        RTUINT128_INIT_C(0x00d2421170b2dfaa, 0x93af6a0ed5ae9f12), RTUINT128_INIT_C(0x350a291f16a9619e, 0x31dfd500e945a010),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00d2421170b2dfaa, 0x93af6a0ed5ae9f12)
    },
    { /* i=767; 113 / 118 */
        RTUINT128_INIT_C(0x000088cb24fae4cb, 0x1a757a5c527cfe4b), RTUINT128_INIT_C(0x002641a0e015d74f, 0xd0c6e55a65707eac),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000088cb24fae4cb, 0x1a757a5c527cfe4b)
    },
    { /* i=768; 89 / 86 */
        RTUINT128_INIT_C(0x00000000017c84f9, 0x69b6b2e75d267ff4), RTUINT128_INIT_C(0x00000000001e358e, 0x06b426d7bde01a5f),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000c), RTUINT128_INIT_C(0x0000000000120251, 0x1944e0ca76a54380)
    },
    { /* i=769; 4 / 16 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000c), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000f4d9),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000c)
    },
    { /* i=770; 116 / 29 */
        RTUINT128_INIT_C(0x000129c3496ed78c, 0xf6d863efcdf6bffc), RTUINT128_INIT_C(0x0000000000000000, 0x000000000d818fd8),
        RTUINT128_INIT_C(0x0000000000160bea, 0x3dd46917650e58f9), RTUINT128_INIT_C(0x0000000000000000, 0x000000000baf96e4)
    },
    { /* i=771; 127 / 56 */
        RTUINT128_INIT_C(0x22206968cb4b6caf, 0x8c2350fc33b82fd4), RTUINT128_INIT_C(0x0000000000000000, 0x00f3d7311c1e688f),
        RTUINT128_INIT_C(0x0000000000000023, 0xd4104303a2890b9d), RTUINT128_INIT_C(0x0000000000000000, 0x009d4a8b340ceb21)
    },
    { /* i=772; 35 / 23 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000040423acfd), RTUINT128_INIT_C(0x0000000000000000, 0x00000000005c831a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000b1d), RTUINT128_INIT_C(0x0000000000000000, 0x000000000006b50b)
    },
    { /* i=773; 95 / 68 */
        RTUINT128_INIT_C(0x000000002679e041, 0x82edc6aef68d806a), RTUINT128_INIT_C(0x0000000000000009, 0xb033295adb3d6d00),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000003f8adf1), RTUINT128_INIT_C(0x0000000000000003, 0xef3b56357710e36a)
    },
    { /* i=774; 126 / 93 */
        RTUINT128_INIT_C(0x1b7affa246c591c8, 0x194bc528a2bb8cb9), RTUINT128_INIT_C(0x000000001b2a7ad1, 0xd111d52a916df1cf),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000102f6c638), RTUINT128_INIT_C(0x0000000000298c36, 0xd50daa04cebe8d71)
    },
    { /* i=775; 89 / 5 */
        RTUINT128_INIT_C(0x0000000000549ee1, 0x2a464c42e5f7c883), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000007),
        RTUINT128_INIT_C(0x00000000000c16b2, 0x73c0e652b32365c9), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000004)
    },
    { /* i=776; 122 / 40 */
        RTUINT128_INIT_C(0x029529997c36effc, 0xea8c3b46670175e8), RTUINT128_INIT_C(0x0000000000000000, 0x0000004035520746),
        RTUINT128_INIT_C(0x00000000000a4c12, 0x343ab306dd0e8d15), RTUINT128_INIT_C(0x0000000000000000, 0x0000003c05714f2a)
    },
    { /* i=777; 43 / 23 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000069f66322922), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000278431),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000002ae759), RTUINT128_INIT_C(0x0000000000000000, 0x000000000022fd19)
    },
    { /* i=778; 55 / 14 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0028e2d77f5a5f65), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000003a9d),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000b29317586e), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000037ef)
    },
    { /* i=779; 127 / 115 */
        RTUINT128_INIT_C(0x3da695843bc4539f, 0x8882cf5950263aad), RTUINT128_INIT_C(0x0004d9328c1222bf, 0x7b3744fd9d090872),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000cb7), RTUINT128_INIT_C(0x0000f3d1412c82f7, 0xdcc49ab1a24bd92f)
    },
    { /* i=780; 120 / 48 */
        RTUINT128_INIT_C(0x004affc188e2fd22, 0x676d4510d4b1750f), RTUINT128_INIT_C(0x0000000000000000, 0x0000fdb03ddf2eea),
        RTUINT128_INIT_C(0x000000000000004b, 0xaeb33cc3bf9f0f53), RTUINT128_INIT_C(0x0000000000000000, 0x00002b6ff83f8931)
    },
    { /* i=781; 117 / 70 */
        RTUINT128_INIT_C(0x000405b5e1cbfd4c, 0x2aea18f01730aa86), RTUINT128_INIT_C(0x000000000000002a, 0x83c377ca0adb786d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000183858b7bd71), RTUINT128_INIT_C(0x0000000000000021, 0xa9bc4a9cb67d0969)
    },
    { /* i=782; 103 / 88 */
        RTUINT128_INIT_C(0x0000000a44ef42b1, 0xf74b588a6a38a4c6), RTUINT128_INIT_C(0x0000000000d32253, 0x872c45306b3c0445),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000c73), RTUINT128_INIT_C(0x00000000007aecd6, 0x2b29fec36e0f7dc7)
    },
    { /* i=783; 119 / 104 */
        RTUINT128_INIT_C(0x006ec625c3b76e41, 0xabe6a76a2e31962d), RTUINT128_INIT_C(0x00000085a3c1f49b, 0x86f172ad35aa6a22),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000d432), RTUINT128_INIT_C(0x0000006f2944dc21, 0x5dc6d1249304b389)
    },
    { /* i=784; 78 / 73 */
        RTUINT128_INIT_C(0x000000000000021c, 0x9104b44be6bb4c7b), RTUINT128_INIT_C(0x00000000000000db, 0x7da11037a18d6ca8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002), RTUINT128_INIT_C(0x0000000000000065, 0x95c293dca3a0732b)
    },
    { /* i=785; 123 / 103 */
        RTUINT128_INIT_C(0x05106e4f671b9af6, 0xa79499ae19b1f4a5), RTUINT128_INIT_C(0x00000058daa56045, 0x1cf46597beffe689),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000e972e), RTUINT128_INIT_C(0x000000554dd3f519, 0xbd7164c23b3db907)
    },
    { /* i=786; 121 / 125 */
        RTUINT128_INIT_C(0x0177b9ddd35d1ec3, 0xa86f5471db2dd900), RTUINT128_INIT_C(0x146ab30432dfd97a, 0xe4845efd68fe7b56),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0177b9ddd35d1ec3, 0xa86f5471db2dd900)
    },
    { /* i=787; 128 / 92 */
        RTUINT128_INIT_C(0x011f7aa67e60b51f, 0x2d45974625cd6a68), RTUINT128_INIT_C(0x000000000956bbb8, 0x9b450a926f77dd79),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000001ec88616), RTUINT128_INIT_C(0x00000000003e8cce, 0x4656e6be9f0b0c02)
    },
    { /* i=788; 125 / 78 */
        RTUINT128_INIT_C(0x0d9ada4e0b8d2e9c, 0xd411df4d2eea6ab4), RTUINT128_INIT_C(0x0000000000003ad7, 0x6422064def5af768),
        RTUINT128_INIT_C(0x0000000000000000, 0x00003b30c7711942), RTUINT128_INIT_C(0x0000000000002f9b, 0x7b24e9dc8a6579e4)
    },
    { /* i=789; 35 / 9 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000240e9bc3e), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000001ad),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000015843de), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000138)
    },
    { /* i=790; 98 / 96 */
        RTUINT128_INIT_C(0x000000004ee6ea16, 0xbb375ea032076253), RTUINT128_INIT_C(0x000000000a0a1cd6, 0x308aaa675e8ad385),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000007), RTUINT128_INIT_C(0x0000000008a0203b, 0x676cb5cc9c3b99b0)
    },
    { /* i=791; 41 / 32 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000015214cfd77d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000028ac865c),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000084f), RTUINT128_INIT_C(0x0000000000000000, 0x00000000235f8119)
    },
    { /* i=792; 123 / 124 */
        RTUINT128_INIT_C(0x017c258b1899177d, 0x0023acc1117ac653), RTUINT128_INIT_C(0x0e9a4d05aefc95a3, 0xf3500926dc5521fe),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x017c258b1899177d, 0x0023acc1117ac653)
    },
    { /* i=793; 124 / 81 */
        RTUINT128_INIT_C(0x061d9bcfde41886d, 0xe3a687bbf5494d6d), RTUINT128_INIT_C(0x000000000000a80c, 0x11bfc119bd00fa4e),
        RTUINT128_INIT_C(0x0000000000000000, 0x000009510521ef01), RTUINT128_INIT_C(0x0000000000009288, 0x91816c7c848b811f)
    },
    { /* i=794; 116 / 80 */
        RTUINT128_INIT_C(0x000dc713fccf3c1b, 0xff745b70e3bf3910), RTUINT128_INIT_C(0x000000000000e4a4, 0x0525e410189b36d5),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000f6d216bc5), RTUINT128_INIT_C(0x00000000000092ce, 0x8153a7ef51ee0027)
    },
    { /* i=795; 122 / 112 */
        RTUINT128_INIT_C(0x03379a3cd4ce28c3, 0xd38ea43e2e09a62f), RTUINT128_INIT_C(0x0000d6b08af99658, 0xc94bf7b0d6799b92),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000003d6), RTUINT128_INIT_C(0x00001107bb67702f, 0xaa2683e7778ee423)
    },
    { /* i=796; 81 / 13 */
        RTUINT128_INIT_C(0x000000000001ce69, 0x7477dc00f843e888), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000796),
        RTUINT128_INIT_C(0x000000000000003c, 0xf4dae33e7c0a94af), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000fe)
    },
    { /* i=797; 61 / 40 */
        RTUINT128_INIT_C(0x0000000000000000, 0x160dc25b469aedf7), RTUINT128_INIT_C(0x0000000000000000, 0x000000f9a518edd4),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000169d7b), RTUINT128_INIT_C(0x0000000000000000, 0x00000004398da51b)
    },
    { /* i=798; 123 / 60 */
        RTUINT128_INIT_C(0x0056e828c9e2fe96, 0x25660f4855716382), RTUINT128_INIT_C(0x0000000000000000, 0x035dd36fef348741),
        RTUINT128_INIT_C(0x0000000000000000, 0x19d0ad321c177c00), RTUINT128_INIT_C(0x0000000000000000, 0x004a4335a116e782)
    },
    { /* i=799; 116 / 121 */
        RTUINT128_INIT_C(0x000db70e3ebf7b4e, 0xebdf208b400e4fc4), RTUINT128_INIT_C(0x01f06c954373fef4, 0x0b02423d92963b63),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000db70e3ebf7b4e, 0xebdf208b400e4fc4)
    },
    { /* i=800; 4 / 56 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00bbac57ce24bb8b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=801; 125 / 78 */
        RTUINT128_INIT_C(0x14b62c26f2c3ed2f, 0x9614bef83688a0d2), RTUINT128_INIT_C(0x0000000000002c99, 0x334b653555d15067),
        RTUINT128_INIT_C(0x0000000000000000, 0x000076e30f491a39), RTUINT128_INIT_C(0x0000000000001095, 0xf21d49a5e26443e3)
    },
    { /* i=802; 125 / 94 */
        RTUINT128_INIT_C(0x113a019752a7c8c1, 0x9b3be799e6a48743), RTUINT128_INIT_C(0x000000001f95dd20, 0xb1e07245fd0dd2fb),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000008b9f2409), RTUINT128_INIT_C(0x000000000b671124, 0xd0675e69bc97d070)
    },
    { /* i=803; 114 / 107 */
        RTUINT128_INIT_C(0x0002254dce6e767e, 0x293cc9c71cc38037), RTUINT128_INIT_C(0x000002bf00be8ebf, 0x1040bbc54aa1d6ec),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000c8), RTUINT128_INIT_C(0x00000015398ef139, 0x76aa17a4ce5397d7)
    },
    { /* i=804; 79 / 46 */
        RTUINT128_INIT_C(0x0000000000003775, 0x221d5f06d5142b38), RTUINT128_INIT_C(0x0000000000000000, 0x00000718b066cbdf),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000007d0995028), RTUINT128_INIT_C(0x0000000000000000, 0x000005dd1d07a060)
    },
    { /* i=805; 16 / 8 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000021c7), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000e1),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000026), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000061)
    },
    { /* i=806; 13 / 4 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000557), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000001c7), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002)
    },
    { /* i=807; 39 / 19 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000091ee47da0), RTUINT128_INIT_C(0x0000000000000000, 0x000000000007b5f8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000012ece), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000058010)
    },
    { /* i=808; 120 / 82 */
        RTUINT128_INIT_C(0x0092d7595536f808, 0x67ff0e45419bec00), RTUINT128_INIT_C(0x0000000000032e77, 0x77148ed34b42d676),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000002e2791218a), RTUINT128_INIT_C(0x00000000000246e9, 0xf4597aef9f191a64)
    },
    { /* i=809; 114 / 45 */
        RTUINT128_INIT_C(0x000123c15694463f, 0xca79456ea6cfdd5c), RTUINT128_INIT_C(0x0000000000000000, 0x00001764202dfde3),
        RTUINT128_INIT_C(0x000000000000000c, 0x791077e6b80f0a6b), RTUINT128_INIT_C(0x0000000000000000, 0x000005345f5ee17b)
    },
    { /* i=810; 124 / 63 */
        RTUINT128_INIT_C(0x0e71cbe322349983, 0x2ad4b30793f1aca7), RTUINT128_INIT_C(0x0000000000000000, 0x5a04fdbe747473ee),
        RTUINT128_INIT_C(0x0000000000000000, 0x2913e600e4c65a80), RTUINT128_INIT_C(0x0000000000000000, 0x2d49418ac6e209a7)
    },
    { /* i=811; 124 / 99 */
        RTUINT128_INIT_C(0x0483e9c0918577cd, 0x617821d3d84fd1a6), RTUINT128_INIT_C(0x00000006cbeeb2a4, 0x5fee034d2225256e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000aa126d), RTUINT128_INIT_C(0x00000002532c2503, 0x9baca0ead6d125d0)
    },
    { /* i=812; 61 / 34 */
        RTUINT128_INIT_C(0x0000000000000000, 0x1cf72c71ca6e2a2f), RTUINT128_INIT_C(0x0000000000000000, 0x0000000099239265),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000306bd484), RTUINT128_INIT_C(0x0000000000000000, 0x000000003ea40a1b)
    },
    { /* i=813; 117 / 73 */
        RTUINT128_INIT_C(0x0019d2c2b076f975, 0xe7153aa1bed74e8c), RTUINT128_INIT_C(0x0000000000000064, 0x970c5530ca9db004),
        RTUINT128_INIT_C(0x0000000000000000, 0x000041b8473d471d), RTUINT128_INIT_C(0x0000000000000017, 0xdf3581a502354218)
    },
    { /* i=814; 106 / 16 */
        RTUINT128_INIT_C(0x0000010712b49c7a, 0xcad097fdfa648617), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000f453),
        RTUINT128_INIT_C(0x000000000113a512, 0xfb18883f64221cad), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000005600)
    },
    { /* i=815; 94 / 83 */
        RTUINT128_INIT_C(0x000000002431b7fc, 0x68e532b73fd7e937), RTUINT128_INIT_C(0x0000000000020e88, 0x63d051ac326042a0),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001198), RTUINT128_INIT_C(0x0000000000020860, 0x4fc84520f243ba37)
    },
    { /* i=816; 28 / 49 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000d24847b), RTUINT128_INIT_C(0x0000000000000000, 0x0001c75ecea698b9),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000000000d24847b)
    },
    { /* i=817; 100 / 42 */
        RTUINT128_INIT_C(0x0000000dae1f70c9, 0xc7f613f8a0d1ee13), RTUINT128_INIT_C(0x0000000000000000, 0x000001923c79811c),
        RTUINT128_INIT_C(0x0000000000000000, 0x08b4e5d559d0899e), RTUINT128_INIT_C(0x0000000000000000, 0x00000072a4fc42cb)
    },
    { /* i=818; 110 / 24 */
        RTUINT128_INIT_C(0x0000059b9c81868c, 0x1671a1e74f737e6b), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000db88c),
        RTUINT128_INIT_C(0x000000000068a12f, 0xeb0821ad22ee8552), RTUINT128_INIT_C(0x0000000000000000, 0x000000000005a593)
    },
    { /* i=819; 127 / 123 */
        RTUINT128_INIT_C(0x3f878e40218479f3, 0xf22f351c29c1c21a), RTUINT128_INIT_C(0x0610077620957e0d, 0xa9e04a458a9c5666),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000a), RTUINT128_INIT_C(0x02e743a2dbad8d6b, 0x4f6c4e64bfa6621e)
    },
    { /* i=820; 54 / 49 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0026733ca03a00f9), RTUINT128_INIT_C(0x0000000000000000, 0x0000019f06fdbfcb),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000017b7), RTUINT128_INIT_C(0x0000000000000000, 0x000000edd49aa9dc)
    },
    { /* i=821; 95 / 89 */
        RTUINT128_INIT_C(0x00000000312efc83, 0x1eb6bf59e7253aa5), RTUINT128_INIT_C(0x00000000000cb0ef, 0xae8daa1a2ff1e062),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000003e0), RTUINT128_INIT_C(0x0000000000015bbe, 0xb9c399e01ddfbee5)
    },
    { /* i=822; 87 / 87 */
        RTUINT128_INIT_C(0x00000000001cf571, 0x7230800f71db05a7), RTUINT128_INIT_C(0x000000000064bc72, 0x3137e55b68b5c28c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00000000001cf571, 0x7230800f71db05a7)
    },
    { /* i=823; 120 / 121 */
        RTUINT128_INIT_C(0x007340c080d1f9b4, 0xdc5b54184257fe74), RTUINT128_INIT_C(0x015faf3a9caf90e5, 0x29bfa8d7ac9e6369),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x007340c080d1f9b4, 0xdc5b54184257fe74)
    },
    { /* i=824; 122 / 126 */
        RTUINT128_INIT_C(0x032f28472f595ddb, 0x9abb819a76358b66), RTUINT128_INIT_C(0x10344ef7d626556b, 0x242a386db4e954c4),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x032f28472f595ddb, 0x9abb819a76358b66)
    },
    { /* i=825; 124 / 79 */
        RTUINT128_INIT_C(0x044d8722927b548f, 0x5818b3fb0348cdbe), RTUINT128_INIT_C(0x0000000000000a3b, 0x77dd2c5aef4bc9b4),
        RTUINT128_INIT_C(0x0000000000000000, 0x00006ba6ed08c0a1), RTUINT128_INIT_C(0x000000000000054d, 0xa9e7f07fbbb7f38a)
    },
    { /* i=826; 83 / 47 */
        RTUINT128_INIT_C(0x000000000000dd5b, 0xd192c52569cf9b94), RTUINT128_INIT_C(0x0000000000000000, 0x0000341444bb0e57),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000004401be8a7), RTUINT128_INIT_C(0x0000000000000000, 0x000030f6cb9d68d3)
    },
    { /* i=827; 125 / 83 */
        RTUINT128_INIT_C(0x1fe017dc2d51d9ee, 0x488c2582d7850454), RTUINT128_INIT_C(0x000000000002fd37, 0x514ea5025869fb7c),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000aa9ed3fa2f2), RTUINT128_INIT_C(0x000000000001a311, 0x5e90f09582acd11c)
    },
    { /* i=828; 115 / 101 */
        RTUINT128_INIT_C(0x000465b0cfc043f4, 0xa7f17c3a44f4d590), RTUINT128_INIT_C(0x0000000af7bf3c34, 0xb3a80d6f1823cfb7),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000066a2), RTUINT128_INIT_C(0x00000009d6bf2b06, 0x023eb84eb98879c2)
    },
    { /* i=829; 121 / 48 */
        RTUINT128_INIT_C(0x00ed531ba22eea84, 0xf3a3efe035a5a110), RTUINT128_INIT_C(0x0000000000000000, 0x00009af6990ebee5),
        RTUINT128_INIT_C(0x0000000000000188, 0x0fb3c3487fe80291), RTUINT128_INIT_C(0x0000000000000000, 0x00001788cc45b75b)
    },
    { /* i=830; 123 / 67 */
        RTUINT128_INIT_C(0x066d582443d506a9, 0x024ee906a2182942), RTUINT128_INIT_C(0x0000000000000002, 0xee8270e585c486bf),
        RTUINT128_INIT_C(0x0000000000000000, 0x02313ac4ebd722b6), RTUINT128_INIT_C(0x0000000000000002, 0x6277fa1aef11ff78)
    },
    { /* i=831; 94 / 49 */
        RTUINT128_INIT_C(0x000000001f60728a, 0x240e8040c664e5d0), RTUINT128_INIT_C(0x0000000000000000, 0x000154e4d583df48),
        RTUINT128_INIT_C(0x0000000000000000, 0x000017901a02f753), RTUINT128_INIT_C(0x0000000000000000, 0x00010fd841a50978)
    },
    { /* i=832; 8 / 54 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000a8), RTUINT128_INIT_C(0x0000000000000000, 0x00205333a50431dc),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000a8)
    },
    { /* i=833; 117 / 15 */
        RTUINT128_INIT_C(0x000bdd1438a55000, 0xbc8bc80d68dfed1d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000006bdb),
        RTUINT128_INIT_C(0x0000001c28a6277d, 0xad6ef0c87db3255f), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000003fd8)
    },
    { /* i=834; 78 / 38 */
        RTUINT128_INIT_C(0x00000000000007d5, 0x8bae3e845cff8de0), RTUINT128_INIT_C(0x0000000000000000, 0x00000016799d4090),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000593bfa6427), RTUINT128_INIT_C(0x0000000000000000, 0x000000142c3277f0)
    },
    { /* i=835; 116 / 60 */
        RTUINT128_INIT_C(0x000e670eed74d5bd, 0x49b95ffcedd6feeb), RTUINT128_INIT_C(0x0000000000000000, 0x0060f5a78c4cf58d),
        RTUINT128_INIT_C(0x0000000000000000, 0x2606d94b2d3adb8e), RTUINT128_INIT_C(0x0000000000000000, 0x002d021eda252bb5)
    },
    { /* i=836; 113 / 32 */
        RTUINT128_INIT_C(0x0001422cf74560d2, 0xdb49fa1b7da3ead2), RTUINT128_INIT_C(0x0000000000000000, 0x000000001773330b),
        RTUINT128_INIT_C(0x00000000000dbd24, 0x4a8b82b3b7e916b1), RTUINT128_INIT_C(0x0000000000000000, 0x000000000e97ae37)
    },
    { /* i=837; 125 / 117 */
        RTUINT128_INIT_C(0x0eb0d23936d30ba6, 0x94e63ecd5d8bd305), RTUINT128_INIT_C(0x000d8b718ad34b15, 0x0f2ce34aab022cc0),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000115), RTUINT128_INIT_C(0x0008f05e0032cddd, 0x29544f0254316745)
    },
    { /* i=838; 128 / 31 */
        RTUINT128_INIT_C(0x8e3d386789aaa4c8, 0xde0739277e944045), RTUINT128_INIT_C(0x0000000000000000, 0x000000001d6c0a63),
        RTUINT128_INIT_C(0x00000004d59e0d59, 0x5b2806e6c194f2e8), RTUINT128_INIT_C(0x0000000000000000, 0x000000000e9d408d)
    },
    { /* i=839; 92 / 23 */
        RTUINT128_INIT_C(0x00000000099ade58, 0xb2c308b43221d866), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000117958),
        RTUINT128_INIT_C(0x000000000000008c, 0xb741a0e43a0c42f5), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000072e)
    },
    { /* i=840; 88 / 17 */
        RTUINT128_INIT_C(0x0000000000d62227, 0xf00609cdb13354f2), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000c181),
        RTUINT128_INIT_C(0x000000000000011b, 0x4ad0907baa6dd801), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000bb71)
    },
    { /* i=841; 115 / 26 */
        RTUINT128_INIT_C(0x0000f919045bcc53, 0xd658f5ae0fb10522), RTUINT128_INIT_C(0x0000000000000000, 0x000000000133f857),
        RTUINT128_INIT_C(0x0000000000cf0ff8, 0x1835010d9a9ea91e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000f67bf0)
    },
    { /* i=842; 120 / 82 */
        RTUINT128_INIT_C(0x00ab7b748622d6e5, 0xb55a126b16739f85), RTUINT128_INIT_C(0x0000000000004aa3, 0xbb42abbde6d8bd6c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000024c270be3de), RTUINT128_INIT_C(0x00000000000041a7, 0xaa18bbcf1ee497dd)
    },
    { /* i=843; 120 / 18 */
        RTUINT128_INIT_C(0x0094dd1deeb67092, 0x1e5d8a89584585ed), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000092db),
        RTUINT128_INIT_C(0x000001038036cb1d, 0x40158fa439f1945a), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000048ef)
    },
    { /* i=844; 9 / 3 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000dd), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000005),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000002c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001)
    },
    { /* i=845; 39 / 20 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000228039b5cf), RTUINT128_INIT_C(0x0000000000000000, 0x000000000009b9f8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000038c10), RTUINT128_INIT_C(0x0000000000000000, 0x000000000002764f)
    },
    { /* i=846; 120 / 31 */
        RTUINT128_INIT_C(0x005c019ed796f318, 0x75bb7dc891b6a48d), RTUINT128_INIT_C(0x0000000000000000, 0x00000000206aa866),
        RTUINT128_INIT_C(0x0000000002d69732, 0x407847b13b017e9d), RTUINT128_INIT_C(0x0000000000000000, 0x00000000070529ff)
    },
    { /* i=847; 97 / 73 */
        RTUINT128_INIT_C(0x00000001beafa61b, 0x98c4c7488c70a331), RTUINT128_INIT_C(0x00000000000001f9, 0x98786470513b4800),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000e22c13), RTUINT128_INIT_C(0x0000000000000017, 0xeb6a4ea6c4aa4b31)
    },
    { /* i=848; 91 / 68 */
        RTUINT128_INIT_C(0x0000000005050ba2, 0x033ab079f7b5a909), RTUINT128_INIT_C(0x0000000000000009, 0x62d19979c42bef6c),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000088e924), RTUINT128_INIT_C(0x0000000000000005, 0xd0611077333eb1d9)
    },
    { /* i=849; 76 / 81 */
        RTUINT128_INIT_C(0x00000000000007de, 0x0374a950086f8358), RTUINT128_INIT_C(0x0000000000005d5f, 0x304894c62e344beb),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00000000000007de, 0x0374a950086f8358)
    },
    { /* i=850; 119 / 127 */
        RTUINT128_INIT_C(0x0017f6790d08aa73, 0xf4cd002ece759744), RTUINT128_INIT_C(0x7d914b3884b60401, 0xee1cfef0124ceb60),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0017f6790d08aa73, 0xf4cd002ece759744)
    },
    { /* i=851; 128 / 84 */
        RTUINT128_INIT_C(0x515dfe3fb48a6ce3, 0x100741b09a042d7b), RTUINT128_INIT_C(0x000000000003b3ad, 0xb065c25f4d7170c1),
        RTUINT128_INIT_C(0x0000000000000000, 0x000015fae2af85a6), RTUINT128_INIT_C(0x000000000003a009, 0xdf83ad17fcf1cb55)
    },
    { /* i=852; 73 / 70 */
        RTUINT128_INIT_C(0x00000000000000cd, 0xf86dcc9d5514db59), RTUINT128_INIT_C(0x0000000000000018, 0x46d1274070eff159),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000008), RTUINT128_INIT_C(0x000000000000000b, 0xc1e49299cd955091)
    },
    { /* i=853; 110 / 109 */
        RTUINT128_INIT_C(0x00000919169fb592, 0x1f6d83b14e35dc82), RTUINT128_INIT_C(0x00000bcf1fb65e2d, 0x6db6592ab519f35c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00000919169fb592, 0x1f6d83b14e35dc82)
    },
    { /* i=854; 107 / 92 */
        RTUINT128_INIT_C(0x0000024110ef431b, 0xd432517023685fae), RTUINT128_INIT_C(0x000000000bb493bf, 0x6079983692ed5725),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000314c), RTUINT128_INIT_C(0x00000000070bc4d3, 0xe9f6af1d17446bb2)
    },
    { /* i=855; 123 / 110 */
        RTUINT128_INIT_C(0x002a155b6c6a3e65, 0x7f4211241dc78405), RTUINT128_INIT_C(0x000022bb0334880f, 0x62ccf1f029056377),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000136), RTUINT128_INIT_C(0x000006e58acd7bc3, 0xdb151852714111eb)
    },
    { /* i=856; 128 / 71 */
        RTUINT128_INIT_C(0xa6fdcaa3e2c21a90, 0x119aa2059c0b1091), RTUINT128_INIT_C(0x0000000000000069, 0xd9ff0b3f5fbf247f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0193dd9369fef503), RTUINT128_INIT_C(0x0000000000000014, 0xd582dc1a41de1814)
    },
    { /* i=857; 60 / 51 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0e1f8906ad5fc509), RTUINT128_INIT_C(0x0000000000000000, 0x0003f795adbc7038),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000038f), RTUINT128_INIT_C(0x0000000000000000, 0x00017b616bcc6dc1)
    },
    { /* i=858; 96 / 81 */
        RTUINT128_INIT_C(0x00000000b87e181d, 0xc03626e09e5dcc3f), RTUINT128_INIT_C(0x0000000000014860, 0x8b5a93b7800d12bd),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000008fd4), RTUINT128_INIT_C(0x0000000000003a52, 0xc0b052634612b4bb)
    },
    { /* i=859; 123 / 64 */
        RTUINT128_INIT_C(0x05b4da6e5941cdac, 0xa9d88bc655b56ddd), RTUINT128_INIT_C(0x0000000000000000, 0x4d74552ee44e435d),
        RTUINT128_INIT_C(0x0000000000000000, 0x12dc5e179202eb26), RTUINT128_INIT_C(0x0000000000000000, 0x4a1f3cda09870f0f)
    },
    { /* i=860; 77 / 61 */
        RTUINT128_INIT_C(0x00000000000019a2, 0xf127e5f983c6dcf8), RTUINT128_INIT_C(0x0000000000000000, 0x01574d8401e01d6d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000131df8), RTUINT128_INIT_C(0x0000000000000000, 0x0000b63f203e0260)
    },
    { /* i=861; 128 / 76 */
        RTUINT128_INIT_C(0x9b86ba99dd165598, 0x27a3fbfa2394216d), RTUINT128_INIT_C(0x0000000000000fc8, 0x570dad7e0b30a73c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0009dab38042234b), RTUINT128_INIT_C(0x000000000000005a, 0xe548af6817fdeed9)
    },
    { /* i=862; 61 / 30 */
        RTUINT128_INIT_C(0x0000000000000000, 0x1683571e2f88cb96), RTUINT128_INIT_C(0x0000000000000000, 0x000000003f13af1f),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000005b5ebd4a), RTUINT128_INIT_C(0x0000000000000000, 0x00000000192c49a0)
    },
    { /* i=863; 122 / 75 */
        RTUINT128_INIT_C(0x023ef8ce982f5cee, 0x5e9c4d0bf1f320bf), RTUINT128_INIT_C(0x0000000000000190, 0x8d8bc8887c278f76),
        RTUINT128_INIT_C(0x0000000000000000, 0x00016f795c395eb1), RTUINT128_INIT_C(0x0000000000000153, 0x14f5b3f43aa59c29)
    },
    { /* i=864; 17 / 109 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000015ed2), RTUINT128_INIT_C(0x0000108deae44e32, 0x82ccbb87280413e0),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000015ed2)
    },
    { /* i=865; 116 / 65 */
        RTUINT128_INIT_C(0x000586827343bf8a, 0x9445086bccd2dc32), RTUINT128_INIT_C(0x0000000000000000, 0x351593581ac32634),
        RTUINT128_INIT_C(0x0000000000000000, 0x001aa5802e1b76f7), RTUINT128_INIT_C(0x0000000000000000, 0x00f4c0a1a7710806)
    },
    { /* i=866; 123 / 53 */
        RTUINT128_INIT_C(0x03eda7d10292fefe, 0x42cbf462ce0a07b4), RTUINT128_INIT_C(0x0000000000000000, 0x00166c354c0cf1ae),
        RTUINT128_INIT_C(0x000000000000002c, 0xd993a6fc7a99852e), RTUINT128_INIT_C(0x0000000000000000, 0x0015781b0d293470)
    },
    { /* i=867; 124 / 58 */
        RTUINT128_INIT_C(0x07c48141e9cf2392, 0x97a4d35d134d12ba), RTUINT128_INIT_C(0x0000000000000000, 0x033637c38237d963),
        RTUINT128_INIT_C(0x0000000000000002, 0x6b2083250acf03b5), RTUINT128_INIT_C(0x0000000000000000, 0x01cb8da5b53736bb)
    },
    { /* i=868; 76 / 67 */
        RTUINT128_INIT_C(0x000000000000046d, 0xb2a2e5bb73ca5144), RTUINT128_INIT_C(0x0000000000000004, 0x789314e1644deeca),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000fd), RTUINT128_INIT_C(0x0000000000000002, 0x894742fb52c553a2)
    },
    { /* i=869; 122 / 107 */
        RTUINT128_INIT_C(0x0040c8aa987749dd, 0xc2f933dd7f4a0bec), RTUINT128_INIT_C(0x00000262344f97eb, 0xec19965e9340db4c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001b2d), RTUINT128_INIT_C(0x000001e30173b37e, 0x8f9dcbb5c5c27b90)
    },
    { /* i=870; 114 / 81 */
        RTUINT128_INIT_C(0x00038315acbaa2fd, 0xe38b01680f185060), RTUINT128_INIT_C(0x000000000000603d, 0x3c5d57858ad6c71d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000957999883), RTUINT128_INIT_C(0x0000000000002797, 0x0143f595a1a23489)
    },
    { /* i=871; 125 / 114 */
        RTUINT128_INIT_C(0x0b73c17efb699a15, 0x7e744532054ff372), RTUINT128_INIT_C(0x00002f1d3d5f6d89, 0x19a261c5de8ca0d5),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000003e3a), RTUINT128_INIT_C(0x00000001f74394d0, 0x5bfc32778a7fed30)
    },
    { /* i=872; 127 / 105 */
        RTUINT128_INIT_C(0x3dd9516bbb955aea, 0xed2caf30c3b8275b), RTUINT128_INIT_C(0x000000d259171a30, 0x892815bbb8f60f7c),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000004b45a2), RTUINT128_INIT_C(0x0000008774af847d, 0xf5f42574dc81eee3)
    },
    { /* i=873; 119 / 11 */
        RTUINT128_INIT_C(0x0071f986ede987d8, 0x4d8e8093c2dd521b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000708),
        RTUINT128_INIT_C(0x00001035b1574fdc, 0xb4f3230edf8a1419), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000253)
    },
    { /* i=874; 74 / 16 */
        RTUINT128_INIT_C(0x0000000000000148, 0x369125fe98a183f4), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000c3a),
        RTUINT128_INIT_C(0x0000000000000000, 0x1ad8221e42f3c881), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000aba)
    },
    { /* i=875; 117 / 12 */
        RTUINT128_INIT_C(0x001dfc35c7458d05, 0x4cd6ebb14ffa9e88), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000fcb),
        RTUINT128_INIT_C(0x000001e60d68dfbd, 0xf59241e90f16fbcb), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000f8f)
    },
    { /* i=876; 114 / 124 */
        RTUINT128_INIT_C(0x0002a721e3cb4146, 0xe87aaabe65cd4d99), RTUINT128_INIT_C(0x0d7203b84ad15ce2, 0x4decffc6b0048932),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0002a721e3cb4146, 0xe87aaabe65cd4d99)
    },
    { /* i=877; 126 / 93 */
        RTUINT128_INIT_C(0x2e9c4c09c77b75d1, 0xea5d479ab39c4056), RTUINT128_INIT_C(0x000000001c117290, 0xf071e4bcf78a009b),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000001a91e6277), RTUINT128_INIT_C(0x00000000015a7650, 0x06c27fd36910a249)
    },
    { /* i=878; 121 / 54 */
        RTUINT128_INIT_C(0x00a3c60d64225f43, 0xfae050da797b702e), RTUINT128_INIT_C(0x0000000000000000, 0x00071d6192c4253b),
        RTUINT128_INIT_C(0x0000000000000017, 0x04d1a8e1e22c8749), RTUINT128_INIT_C(0x0000000000000000, 0x0005a832b3c6b55b)
    },
    { /* i=879; 127 / 95 */
        RTUINT128_INIT_C(0x5798ab73e0d5a4e9, 0x02181375c98f0df8), RTUINT128_INIT_C(0x00000000233956e9, 0x00a984d1efb56cbf),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000027ca177ba), RTUINT128_INIT_C(0x000000001b979fb9, 0xa2a1813c62124232)
    },
    { /* i=880; 16 / 58 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000009782), RTUINT128_INIT_C(0x0000000000000000, 0x037efd703d70765a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000009782)
    },
    { /* i=881; 102 / 9 */
        RTUINT128_INIT_C(0x0000002472ec7b6e, 0x3afcdccc376968e5), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000009e),
        RTUINT128_INIT_C(0x000000003b0e7570, 0x7ec0ca4f108da111), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000067)
    },
    { /* i=882; 98 / 48 */
        RTUINT128_INIT_C(0x0000000015655a9b, 0x27a4b413cae707fd), RTUINT128_INIT_C(0x0000000000000000, 0x0000ceec817af55c),
        RTUINT128_INIT_C(0x0000000000000000, 0x00001a786b218da2), RTUINT128_INIT_C(0x0000000000000000, 0x00000e920d1817c5)
    },
    { /* i=883; 118 / 5 */
        RTUINT128_INIT_C(0x00332d48cdf3325a, 0x8e99bb800d0fc880), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000013),
        RTUINT128_INIT_C(0x0002b18a91938963, 0x14fa9e1436950a8d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000009)
    },
    { /* i=884; 123 / 109 */
        RTUINT128_INIT_C(0x04cb09ed1a425ff3, 0xe50bd1d53a94a1cb), RTUINT128_INIT_C(0x00001a41a8b6fdbb, 0x80966cdebbd6c0bd),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000002ebb), RTUINT128_INIT_C(0x00000fa5faff56e1, 0xef9a45616e13e1bc)
    },
    { /* i=885; 122 / 93 */
        RTUINT128_INIT_C(0x020ca26b41bc7b77, 0xb492325c4d2c652c), RTUINT128_INIT_C(0x0000000003d29bd0, 0xadfc95d8e8f8313a),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000893e01ca), RTUINT128_INIT_C(0x00000000014b68c3, 0x0f78ddd78b185368)
    },
    { /* i=886; 38 / 21 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000003a4b7ad1b3), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000194fe8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000024d93), RTUINT128_INIT_C(0x0000000000000000, 0x000000000019277b)
    },
    { /* i=887; 114 / 123 */
        RTUINT128_INIT_C(0x0000a6d386cbfb92, 0x231a544f37f87f02), RTUINT128_INIT_C(0x07633a13382450ca, 0x9768532f41417f66),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000a6d386cbfb92, 0x231a544f37f87f02)
    },
    { /* i=888; 114 / 59 */
        RTUINT128_INIT_C(0x0000a26eb3987962, 0x39928e3a187f7373), RTUINT128_INIT_C(0x0000000000000000, 0x075ce056b136e000),
        RTUINT128_INIT_C(0x0000000000000000, 0x00160fad2afea4e8), RTUINT128_INIT_C(0x0000000000000000, 0x056380f017447373)
    },
    { /* i=889; 125 / 123 */
        RTUINT128_INIT_C(0x0002a4888a58787d, 0xb21d3c940a46a94a), RTUINT128_INIT_C(0x05fc63c1ce763265, 0xce68ce02cc7c6442),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0002a4888a58787d, 0xb21d3c940a46a94a)
    },
    { /* i=890; 46 / 43 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000181d447ba295), RTUINT128_INIT_C(0x0000000000000000, 0x000007b7ad58d1f6),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003), RTUINT128_INIT_C(0x0000000000000000, 0x000000f63c712cb3)
    },
    { /* i=891; 118 / 70 */
        RTUINT128_INIT_C(0x003ea26ecc346258, 0xd65b166d513b8473), RTUINT128_INIT_C(0x0000000000000028, 0xcfdd08132e9a7747),
        RTUINT128_INIT_C(0x0000000000000000, 0x000188e2b4e54e98), RTUINT128_INIT_C(0x0000000000000016, 0xb1b9221df6aa104b)
    },
    { /* i=892; 41 / 24 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000001384c109ee1), RTUINT128_INIT_C(0x0000000000000000, 0x000000000084897e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000025b36), RTUINT128_INIT_C(0x0000000000000000, 0x00000000003fd44d)
    },
    { /* i=893; 122 / 37 */
        RTUINT128_INIT_C(0x0210ea8265777438, 0xbf55d6a9100517c0), RTUINT128_INIT_C(0x0000000000000000, 0x0000001ce696c79e),
        RTUINT128_INIT_C(0x0000000000124d16, 0x984ad1027ef83b46), RTUINT128_INIT_C(0x0000000000000000, 0x000000101db9188c)
    },
    { /* i=894; 113 / 80 */
        RTUINT128_INIT_C(0x00008cb1caddb0cf, 0xbce88c1c4e2ebea5), RTUINT128_INIT_C(0x0000000000001792, 0xf2a56b5b53562410),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000005f7dc2324), RTUINT128_INIT_C(0x0000000000000f72, 0xff6587bd61637c65)
    },
    { /* i=895; 114 / 127 */
        RTUINT128_INIT_C(0x00010d118fe66025, 0x00cd9199e440b79a), RTUINT128_INIT_C(0x74865b55ab5a627f, 0x28fad0437943f847),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00010d118fe66025, 0x00cd9199e440b79a)
    },
    { /* i=896; 72 / 119 */
        RTUINT128_INIT_C(0x000000000000000a, 0x28d5372d6ef0ef0a), RTUINT128_INIT_C(0x005a23c78969fe52, 0x8b27ac66e1645db7),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000000000000000a, 0x28d5372d6ef0ef0a)
    },
    { /* i=897; 115 / 44 */
        RTUINT128_INIT_C(0x0007fe8b46c51df8, 0xd5e0b7703f75d79d), RTUINT128_INIT_C(0x0000000000000000, 0x0000005560dd6328),
        RTUINT128_INIT_C(0x00000000000017f8, 0x64979579842feec5), RTUINT128_INIT_C(0x0000000000000000, 0x000000010e9159d5)
    },
    { /* i=898; 105 / 90 */
        RTUINT128_INIT_C(0x0000000e30c099f2, 0x3333b156aade134f), RTUINT128_INIT_C(0x0000000000feb7e8, 0x4a66a0911cad4d4e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000e43), RTUINT128_INIT_C(0x000000000007c415, 0x1d8fbbcaaf4893e5)
    },
    { /* i=899; 124 / 110 */
        RTUINT128_INIT_C(0x00577285979154be, 0x6e82beede00102e4), RTUINT128_INIT_C(0x00000f682e9f7975, 0x7cf537fb200496b2),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000005ad), RTUINT128_INIT_C(0x00000034f86cf4e8, 0x32b4029925f5b29a)
    },
    { /* i=900; 116 / 123 */
        RTUINT128_INIT_C(0x00009ec413a4a4b2, 0xc6618d4bb5b691a8), RTUINT128_INIT_C(0x05fdf83538c0b8b2, 0xd6ea6017947d99dd),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00009ec413a4a4b2, 0xc6618d4bb5b691a8)
    },
    { /* i=901; 119 / 54 */
        RTUINT128_INIT_C(0x005fda265f57b537, 0xde3da2dc6d2a2990), RTUINT128_INIT_C(0x0000000000000000, 0x0003639434195d7f),
        RTUINT128_INIT_C(0x000000000000001c, 0x48920f2a2e629a58), RTUINT128_INIT_C(0x0000000000000000, 0x0001f83aa5959fe8)
    },
    { /* i=902; 118 / 74 */
        RTUINT128_INIT_C(0x00108820d3dbc845, 0xf5e427f7e6e297fc), RTUINT128_INIT_C(0x000000000000001f, 0x1d3042036936f232),
        RTUINT128_INIT_C(0x0000000000000000, 0x000088051dc9e8d1), RTUINT128_INIT_C(0x0000000000000016, 0xef550b4762478d2a)
    },
    { /* i=903; 125 / 99 */
        RTUINT128_INIT_C(0x0d3ff6b775f8f414, 0xe2563270953a1492), RTUINT128_INIT_C(0x000000068af0a054, 0xef3fa11bd831bdb2),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000002066ea1), RTUINT128_INIT_C(0x0000000243e3851d, 0x15c0746268434ba0)
    },
    { /* i=904; 120 / 69 */
        RTUINT128_INIT_C(0x00dab88d2a846a1f, 0x99009e57ea1c0633), RTUINT128_INIT_C(0x000000000000000a, 0x22fd74969be1058d),
        RTUINT128_INIT_C(0x0000000000000000, 0x001593c1a8ce5f04), RTUINT128_INIT_C(0x0000000000000001, 0x27e3a720fa129cff)
    },
    { /* i=905; 120 / 29 */
        RTUINT128_INIT_C(0x004aa9876d56d846, 0x349f53265d65c17f), RTUINT128_INIT_C(0x0000000000000000, 0x000000001ba0b633),
        RTUINT128_INIT_C(0x0000000002b3d2a4, 0xea161e1cb2ede899), RTUINT128_INIT_C(0x0000000000000000, 0x000000001203a504)
    },
    { /* i=906; 126 / 42 */
        RTUINT128_INIT_C(0x341fffa482226130, 0xfff5886c9183f7ca), RTUINT128_INIT_C(0x0000000000000000, 0x0000008bf0f45298),
        RTUINT128_INIT_C(0x00000000005f5ab3, 0xc2cb87516e317381), RTUINT128_INIT_C(0x0000000000000000, 0x0000005146341132)
    },
    { /* i=907; 122 / 36 */
        RTUINT128_INIT_C(0x01ee010195dc23d1, 0xaa57799631222a48), RTUINT128_INIT_C(0x0000000000000000, 0x0000000be0702db4),
        RTUINT128_INIT_C(0x0000000000299826, 0x5da62f4c8a3f6f22), RTUINT128_INIT_C(0x0000000000000000, 0x00000003771f0c60)
    },
    { /* i=908; 123 / 78 */
        RTUINT128_INIT_C(0x060f0ecbd72949f8, 0x83c068fd1e44cede), RTUINT128_INIT_C(0x00000000000035e2, 0x930d9e621126bb15),
        RTUINT128_INIT_C(0x0000000000000000, 0x00001cc8d91e7200), RTUINT128_INIT_C(0x0000000000002725, 0x207871d3257f74de)
    },
    { /* i=909; 124 / 12 */
        RTUINT128_INIT_C(0x026e3756a6e4d2a6, 0xfbd55d62c21a1971), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000247),
        RTUINT128_INIT_C(0x000111385abe1651, 0x1511ee2820d3b1e1), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000020a)
    },
    { /* i=910; 123 / 127 */
        RTUINT128_INIT_C(0x04f48ca33b13e200, 0x2425041c29ca3966), RTUINT128_INIT_C(0x266a73457eb685da, 0xe9ac396508a7b658),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x04f48ca33b13e200, 0x2425041c29ca3966)
    },
    { /* i=911; 73 / 37 */
        RTUINT128_INIT_C(0x000000000000015a, 0xc03220e4478d8828), RTUINT128_INIT_C(0x0000000000000000, 0x0000000e5eb702db),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000001821560809), RTUINT128_INIT_C(0x0000000000000000, 0x0000000c0a759675)
    },
    { /* i=912; 114 / 109 */
        RTUINT128_INIT_C(0x00014f3e2f25e1a9, 0xeda1a25bde99c543), RTUINT128_INIT_C(0x0000047d243c7a43, 0xc2ada9f7d9b2c340),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000004a), RTUINT128_INIT_C(0x00000311b5aa8a13, 0xa76e80b6f0ed54c3)
    },
    { /* i=913; 82 / 35 */
        RTUINT128_INIT_C(0x0000000000037e0d, 0xee9e92cb637cc290), RTUINT128_INIT_C(0x0000000000000000, 0x000000036f37a581),
        RTUINT128_INIT_C(0x0000000000000000, 0x00010451f07b763c), RTUINT128_INIT_C(0x0000000000000000, 0x00000003372d8254)
    },
    { /* i=914; 62 / 118 */
        RTUINT128_INIT_C(0x0000000000000000, 0x112b63068667d40a), RTUINT128_INIT_C(0x002785fae2e5eff3, 0x4ed1bd0a1bb5ef97),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x112b63068667d40a)
    },
    { /* i=915; 39 / 33 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000007df3f118af), RTUINT128_INIT_C(0x0000000000000000, 0x000000018be2017c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000051), RTUINT128_INIT_C(0x0000000000000000, 0x00000000b16ea073)
    },
    { /* i=916; 118 / 107 */
        RTUINT128_INIT_C(0x0025abaa1abf05c4, 0x6d23c6b4b724aaf6), RTUINT128_INIT_C(0x000006f15ad081b5, 0xa9c7f2ea66d533fc),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000056d), RTUINT128_INIT_C(0x000000205d6f3f1a, 0x3b42c4e4c4599caa)
    },
    { /* i=917; 57 / 9 */
        RTUINT128_INIT_C(0x0000000000000000, 0x01a210701ea88296), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000085),
        RTUINT128_INIT_C(0x0000000000000000, 0x000324b1ecfb7e18), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000001e)
    },
    { /* i=918; 59 / 20 */
        RTUINT128_INIT_C(0x0000000000000000, 0x064b2c21c0b07108), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000d7eaa),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000077646acec4), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000aaae0)
    },
    { /* i=919; 121 / 88 */
        RTUINT128_INIT_C(0x014558a900a837c7, 0x02a458a40df59bd0), RTUINT128_INIT_C(0x00000000001a3920, 0xb5553d05bd63c3db),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000c682641bf), RTUINT128_INIT_C(0x000000000011e29e, 0xcf1589a16149e06b)
    },
    { /* i=920; 99 / 75 */
        RTUINT128_INIT_C(0x0000000136a26010, 0xcbb097fff8fe0ea6), RTUINT128_INIT_C(0x00000000000003ec, 0x3615f1f84ea76f00),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000004f305b), RTUINT128_INIT_C(0x000000000000002f, 0xc8e4c0515da999a6)
    },
    { /* i=921; 122 / 123 */
        RTUINT128_INIT_C(0x0377c894d2709b37, 0x9965068787999f8c), RTUINT128_INIT_C(0x05d0760676b0687a, 0xa601e733473f481d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0377c894d2709b37, 0x9965068787999f8c)
    },
    { /* i=922; 15 / 7 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000325d), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000001c),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000001cc), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000d)
    },
    { /* i=923; 127 / 71 */
        RTUINT128_INIT_C(0x17234af24bb59670, 0x986c578731b27e3c), RTUINT128_INIT_C(0x000000000000000c, 0x570466d9311d05a3),
        RTUINT128_INIT_C(0x0000000000000000, 0x01e002cfbbef9517), RTUINT128_INIT_C(0x0000000000000007, 0x0962ce6a8fa21d97)
    },
    { /* i=924; 121 / 122 */
        RTUINT128_INIT_C(0x015753407df52c58, 0xecf90c33785ef5d7), RTUINT128_INIT_C(0x026d7f14e1da24ab, 0x40b3c2887e2d7a6e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x015753407df52c58, 0xecf90c33785ef5d7)
    },
    { /* i=925; 19 / 19 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000d380), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000020272),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000d380)
    },
    { /* i=926; 128 / 93 */
        RTUINT128_INIT_C(0x3d5f56cac5aafbf3, 0x262811acd4b62451), RTUINT128_INIT_C(0x000000001b052045, 0x3511f03eced64505),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000024578602c), RTUINT128_INIT_C(0x0000000002cce580, 0x241dfa3c3aa86775)
    },
    { /* i=927; 118 / 102 */
        RTUINT128_INIT_C(0x003bdb258547cc64, 0x32026ce741e962b1), RTUINT128_INIT_C(0x0000000537194ccf, 0xab9c6c2875087711),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000b7a27), RTUINT128_INIT_C(0x00000001c4e5c13f, 0xdbe5a39a4726251a)
    },
    { /* i=928; 35 / 87 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000ed734375), RTUINT128_INIT_C(0x00000000007cdf72, 0x722e1f2dc5af3415),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00000000ed734375)
    },
    { /* i=929; 102 / 81 */
        RTUINT128_INIT_C(0x0000001d7305c86e, 0x00f7ac630e1fd31d), RTUINT128_INIT_C(0x000000000001d4cd, 0xea8ce77f011f2181),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000001014d5), RTUINT128_INIT_C(0x000000000000f9f8, 0x5fb511ae988adec8)
    },
    { /* i=930; 121 / 30 */
        RTUINT128_INIT_C(0x01abd2a461c3968d, 0x95147ec3f38d4d73), RTUINT128_INIT_C(0x0000000000000000, 0x0000000023f7d3d7),
        RTUINT128_INIT_C(0x000000000be4feef, 0x05283fd79e2191f6), RTUINT128_INIT_C(0x0000000000000000, 0x0000000003b3f5d9)
    },
    { /* i=931; 126 / 116 */
        RTUINT128_INIT_C(0x2b1009eafdcb01d4, 0xbcd82d3cd9756afd), RTUINT128_INIT_C(0x000b531575296889, 0xd5de2851e6707966),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000003cd), RTUINT128_INIT_C(0x0005415caf68adf2, 0xdf78edf3fff8024f)
    },
    { /* i=932; 62 / 48 */
        RTUINT128_INIT_C(0x0000000000000000, 0x1ea5bb672061c04d), RTUINT128_INIT_C(0x0000000000000000, 0x0000b4341ed6ce47),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000002b89), RTUINT128_INIT_C(0x0000000000000000, 0x00008a548ac76f4e)
    },
    { /* i=933; 127 / 69 */
        RTUINT128_INIT_C(0x247b8cae6c7b24c2, 0x7039f5f2296f11be), RTUINT128_INIT_C(0x000000000000000e, 0xdfdd0aae0913f0e4),
        RTUINT128_INIT_C(0x0000000000000000, 0x0273e43250829c0e), RTUINT128_INIT_C(0x0000000000000007, 0x298e5ef5efc4f546)
    },
    { /* i=934; 128 / 104 */
        RTUINT128_INIT_C(0x2846ae6433943afa, 0x3c678b01e1719a5f), RTUINT128_INIT_C(0x0000001a9001a58c, 0x674bbd075532f079),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000001842a9c), RTUINT128_INIT_C(0x00000015449dc1ae, 0x5e20055b238f36a3)
    },
    { /* i=935; 36 / 36 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000006680c1cc1), RTUINT128_INIT_C(0x0000000000000000, 0x0000000983e5042c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00000006680c1cc1)
    },
    { /* i=936; 81 / 5 */
        RTUINT128_INIT_C(0x0000000000014709, 0x03aba5184198b2ef), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000001e),
        RTUINT128_INIT_C(0x0000000000000ae6, 0xb3528580cefc8e7f), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000d)
    },
    { /* i=937; 113 / 122 */
        RTUINT128_INIT_C(0x0000e3b3f90bf466, 0xed893d06bb4ba05a), RTUINT128_INIT_C(0x0222f8f2316e90bc, 0x645ea2b9daed832e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000e3b3f90bf466, 0xed893d06bb4ba05a)
    },
    { /* i=938; 105 / 42 */
        RTUINT128_INIT_C(0x000000e227ae08d2, 0x1059ac98fad81c5b), RTUINT128_INIT_C(0x0000000000000000, 0x000001b8443e11d8),
        RTUINT128_INIT_C(0x0000000000000000, 0x83805d1f51de8fc0), RTUINT128_INIT_C(0x0000000000000000, 0x000001a64f03125b)
    },
    { /* i=939; 86 / 73 */
        RTUINT128_INIT_C(0x0000000000161d84, 0x412fe40c60d5578c), RTUINT128_INIT_C(0x00000000000001de, 0xd08aa0d173231849),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000bd2), RTUINT128_INIT_C(0x00000000000001c7, 0x3a8ef8496c0048aa)
    },
    { /* i=940; 120 / 60 */
        RTUINT128_INIT_C(0x009d2e3602220326, 0x16327694c8660daa), RTUINT128_INIT_C(0x0000000000000000, 0x00dc1d6b463dfc58),
        RTUINT128_INIT_C(0x0000000000000000, 0xb6ce334124baaac2), RTUINT128_INIT_C(0x0000000000000000, 0x003693c6abea62fa)
    },
    { /* i=941; 123 / 72 */
        RTUINT128_INIT_C(0x0757eec20087d71d, 0xfb5993e58252031e), RTUINT128_INIT_C(0x00000000000000e5, 0x64cd9d7186030961),
        RTUINT128_INIT_C(0x0000000000000000, 0x000831fa05e5fc31), RTUINT128_INIT_C(0x000000000000005e, 0x7c0d079f95bcbb8d)
    },
    { /* i=942; 105 / 50 */
        RTUINT128_INIT_C(0x000001457294a5b9, 0xac03f27393581279), RTUINT128_INIT_C(0x0000000000000000, 0x00022e8896c72a1c),
        RTUINT128_INIT_C(0x0000000000000000, 0x00952aa9ceaa8583), RTUINT128_INIT_C(0x0000000000000000, 0x0001639873f4fa25)
    },
    { /* i=943; 120 / 119 */
        RTUINT128_INIT_C(0x00e5cd836ae11ce2, 0x465b788c7e17af7d), RTUINT128_INIT_C(0x001b6a75c62592f8, 0x9e39fc636f7db649),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000008), RTUINT128_INIT_C(0x000a79d539b4851d, 0x548b95710229fd35)
    },
    { /* i=944; 63 / 53 */
        RTUINT128_INIT_C(0x0000000000000000, 0x6e2952d73b761cef), RTUINT128_INIT_C(0x0000000000000000, 0x0009012f15392049),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000c3b), RTUINT128_INIT_C(0x0000000000000000, 0x0007d7fea9c8401c)
    },
    { /* i=945; 6 / 110 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000005), RTUINT128_INIT_C(0x00003b81898fb2f8, 0xb1b7c24d26dad26a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000005)
    },
    { /* i=946; 54 / 31 */
        RTUINT128_INIT_C(0x0000000000000000, 0x003d58a5e233271d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000046bcc651),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000de036b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000020bb5042)
    },
    { /* i=947; 97 / 80 */
        RTUINT128_INIT_C(0x000000015c2935d3, 0x9db6da7e5f6ad39d), RTUINT128_INIT_C(0x0000000000008a80, 0xc451c9cd9889df7b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000028384), RTUINT128_INIT_C(0x0000000000005e54, 0xf5ab66596c01a731)
    },
    { /* i=948; 92 / 78 */
        RTUINT128_INIT_C(0x000000000ddf9ee2, 0x197a71fa6abb1cff), RTUINT128_INIT_C(0x0000000000003e4a, 0xdd300481b9e4516c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000003903), RTUINT128_INIT_C(0x00000000000038c1, 0xd0e9821166ed1cbb)
    },
    { /* i=949; 116 / 108 */
        RTUINT128_INIT_C(0x000069fa4cf87f79, 0x9d71e83b0f0d3578), RTUINT128_INIT_C(0x000004740ba6132d, 0x80e4036fa8601c29),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000017), RTUINT128_INIT_C(0x0000038d410cc663, 0x08f59932ee6aadc9)
    },
    { /* i=950; 93 / 68 */
        RTUINT128_INIT_C(0x000000001dc8d4a3, 0x8a75582b10a5f640), RTUINT128_INIT_C(0x000000000000000f, 0xfa3c871a887ca5fe),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000001dd3932), RTUINT128_INIT_C(0x0000000000000005, 0x741dbc575d11fca4)
    },
    { /* i=951; 124 / 35 */
        RTUINT128_INIT_C(0x020920d202c33a83, 0x9f0938bec0e19284), RTUINT128_INIT_C(0x0000000000000000, 0x000000077e56f4d0),
        RTUINT128_INIT_C(0x0000000000458b3c, 0xf5ffa59726cd7db8), RTUINT128_INIT_C(0x0000000000000000, 0x0000000292480d04)
    },
    { /* i=952; 114 / 12 */
        RTUINT128_INIT_C(0x0000f5bf22e6b9c7, 0x5344e402e8a6f7ec), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000dff),
        RTUINT128_INIT_C(0x000000118ee8210f, 0xa1a3c779f6a23c16), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002)
    },
    { /* i=953; 60 / 46 */
        RTUINT128_INIT_C(0x0000000000000000, 0x039e43e82a9e4ca7), RTUINT128_INIT_C(0x0000000000000000, 0x000017194190c252),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000002819), RTUINT128_INIT_C(0x0000000000000000, 0x00001032251e82a5)
    },
    { /* i=954; 127 / 97 */
        RTUINT128_INIT_C(0x388abcb601a296f6, 0xb8d423752fb4dd20), RTUINT128_INIT_C(0x00000001f1493244, 0x3fe0aa132d21fb9b),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000001d1b836c), RTUINT128_INIT_C(0x00000001b9994585, 0xb2e1f72fa94566bc)
    },
    { /* i=955; 114 / 91 */
        RTUINT128_INIT_C(0x000063d74548177b, 0x5591de62a8ee4d4f), RTUINT128_INIT_C(0x0000000001caf367, 0xb356737882c644ed),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000037b0ce), RTUINT128_INIT_C(0x000000000159672a, 0xc7ba00e84f14e699)
    },
    { /* i=956; 118 / 61 */
        RTUINT128_INIT_C(0x000e9bbb84f85161, 0x49bc48283c79ad0e), RTUINT128_INIT_C(0x0000000000000000, 0x0fa09f8f68b5efe1),
        RTUINT128_INIT_C(0x0000000000000000, 0x00ef4e3b38825387), RTUINT128_INIT_C(0x0000000000000000, 0x0e7dd4dcff803a67)
    },
    { /* i=957; 120 / 109 */
        RTUINT128_INIT_C(0x0097d00af00c1813, 0xb3099e807e0d4b20), RTUINT128_INIT_C(0x000014dddec74574, 0x6fda3ee201884f71),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000746), RTUINT128_INIT_C(0x00000a4892a8eb2e, 0x25a43ea9589b7b3a)
    },
    { /* i=958; 66 / 3 */
        RTUINT128_INIT_C(0x0000000000000000, 0x39ee02cd3210a416), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002),
        RTUINT128_INIT_C(0x0000000000000000, 0x1cf701669908520b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=959; 112 / 5 */
        RTUINT128_INIT_C(0x0000d3147c6f9f01, 0xea36500d80c0304f), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003),
        RTUINT128_INIT_C(0x0000465c297a8a55, 0xf8bcc559d595656f), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002)
    },
    { /* i=960; 50 / 85 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0002fe65af01e497), RTUINT128_INIT_C(0x00000000001b9608, 0x90d95442b8ce879a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0002fe65af01e497)
    },
    { /* i=961; 118 / 113 */
        RTUINT128_INIT_C(0x0029afe948933285, 0x2b7215e95b14d4ec), RTUINT128_INIT_C(0x000164dd65c10b58, 0x4da24d025bfeca20),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000001d), RTUINT128_INIT_C(0x000142d4c1b4e984, 0x600f5ca4ef37ef4c)
    },
    { /* i=962; 42 / 19 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000c37d4b05f6), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000051d39),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000002639a6), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000026200)
    },
    { /* i=963; 113 / 68 */
        RTUINT128_INIT_C(0x00018014560d1178, 0x298437eaa450d3ba), RTUINT128_INIT_C(0x0000000000000001, 0x12a48a4e3442f92f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0001660215c4cb9f), RTUINT128_INIT_C(0x0000000000000000, 0xbc7f1fd17023ca89)
    },
    { /* i=964; 113 / 70 */
        RTUINT128_INIT_C(0x00001664f38f8e0f, 0x12e56c8c45b3dc91), RTUINT128_INIT_C(0x0000000000000009, 0x49260b17e7f9d36f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000026964ad9851), RTUINT128_INIT_C(0x0000000000000007, 0x6861c74d4c1b0e72)
    },
    { /* i=965; 88 / 64 */
        RTUINT128_INIT_C(0x0000000000327b5c, 0x9fb8c004848a6bfd), RTUINT128_INIT_C(0x0000000000000000, 0xddb66f629d11de3e),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000003a49ee), RTUINT128_INIT_C(0x0000000000000000, 0x3e027d800b822059)
    },
    { /* i=966; 118 / 50 */
        RTUINT128_INIT_C(0x00164987be16e1e2, 0xdd4e64fc120d4b0c), RTUINT128_INIT_C(0x0000000000000000, 0x0003c42b4291ddcd),
        RTUINT128_INIT_C(0x0000000000000005, 0xeae56090d2ea08e8), RTUINT128_INIT_C(0x0000000000000000, 0x00021f1c478be144)
    },
    { /* i=967; 28 / 25 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000001fd0e1c), RTUINT128_INIT_C(0x0000000000000000, 0x000000000134f446),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000c819d6)
    },
    { /* i=968; 120 / 122 */
        RTUINT128_INIT_C(0x0052d66e5bb3961e, 0xb3007909dfc7f047), RTUINT128_INIT_C(0x035b923866433993, 0x043858bf0caea3a6),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0052d66e5bb3961e, 0xb3007909dfc7f047)
    },
    { /* i=969; 79 / 29 */
        RTUINT128_INIT_C(0x000000000000065d, 0x295ddc34382d7f44), RTUINT128_INIT_C(0x0000000000000000, 0x00000000155c726d),
        RTUINT128_INIT_C(0x0000000000000000, 0x00004c4481e9f514), RTUINT128_INIT_C(0x0000000000000000, 0x00000000013d3dc0)
    },
    { /* i=970; 121 / 99 */
        RTUINT128_INIT_C(0x00e18e1e7c073b0d, 0x61b0801facd78cd7), RTUINT128_INIT_C(0x0000000591080a11, 0x66752c8974663e8f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000288517), RTUINT128_INIT_C(0x00000003b45b46f3, 0x578be65352cfa2fe)
    },
    { /* i=971; 125 / 118 */
        RTUINT128_INIT_C(0x0e2a41f8b4721ab3, 0xe1b647c6d897a61f), RTUINT128_INIT_C(0x0031fffbcfd67295, 0x93c0a6a3c618f1cf),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000048), RTUINT128_INIT_C(0x001a43264021e0a2, 0x538769b72193a3e7)
    },
    { /* i=972; 114 / 112 */
        RTUINT128_INIT_C(0x00020b8376dbcabc, 0x056f3e8014a1dadf), RTUINT128_INIT_C(0x0000ee326a77e343, 0x05a13a60d6b0cc54),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002), RTUINT128_INIT_C(0x00002f1ea1ec0435, 0xfa2cc9be67404237)
    },
    { /* i=973; 127 / 101 */
        RTUINT128_INIT_C(0x524e6216c0c8cc2b, 0x9565fef1f8431367), RTUINT128_INIT_C(0x00000003e30838c5, 0x4a616d84faa0f72e),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000152cf2e0), RTUINT128_INIT_C(0x0000000062e9d87f, 0xab342db93fd94f27)
    },
    { /* i=974; 116 / 57 */
        RTUINT128_INIT_C(0x0008a416d9190e8d, 0x9b8a822e509b0f42), RTUINT128_INIT_C(0x0000000000000000, 0x0045ad1e9570c581),
        RTUINT128_INIT_C(0x0000000000000000, 0x1fbf84332370ba9b), RTUINT128_INIT_C(0x0000000000000000, 0x0035cf0bda63c027)
    },
    { /* i=975; 86 / 74 */
        RTUINT128_INIT_C(0x0000000000353025, 0x1f2d336c3a06d7cf), RTUINT128_INIT_C(0x000000000000034e, 0x00e9acb692e3ac8d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001018), RTUINT128_INIT_C(0x00000000000000c6, 0x6e79992039e5da97)
    },
    { /* i=976; 37 / 73 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000078b6dea8a), RTUINT128_INIT_C(0x000000000000017f, 0x78a3dc74bfefb90a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000000078b6dea8a)
    },
    { /* i=977; 113 / 103 */
        RTUINT128_INIT_C(0x000020544d897ac6, 0x77c87451f03304d7), RTUINT128_INIT_C(0x0000005c2cecbe75, 0xb841e370066e0533),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000059), RTUINT128_INIT_C(0x00000048af3b43d9, 0x68e0625fb3f3361c)
    },
    { /* i=978; 127 / 61 */
        RTUINT128_INIT_C(0x38e84fbe0bf1c71e, 0xbcb409fc32b9484a), RTUINT128_INIT_C(0x0000000000000000, 0x0a55abf1ce57e31f),
        RTUINT128_INIT_C(0x0000000000000005, 0x81a803ce40ae1d30), RTUINT128_INIT_C(0x0000000000000000, 0x087f0fcf6e722f7a)
    },
    { /* i=979; 113 / 125 */
        RTUINT128_INIT_C(0x0001753bc47e15ed, 0x05c7cda0d1a1a97b), RTUINT128_INIT_C(0x02a67807260c2655, 0x06bacff4d84c3492),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0001753bc47e15ed, 0x05c7cda0d1a1a97b)
    },
    { /* i=980; 120 / 98 */
        RTUINT128_INIT_C(0x0041ef1ff633bf65, 0x8cae7ea7c46def96), RTUINT128_INIT_C(0x00000001a3f4a59f, 0xf0f8915c45d51a36),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000283150), RTUINT128_INIT_C(0x00000001050eb973, 0xf4c37f280f6168b6)
    },
    { /* i=981; 118 / 46 */
        RTUINT128_INIT_C(0x0029a21c733b2f08, 0x94f4ad07197b3e66), RTUINT128_INIT_C(0x0000000000000000, 0x00001bf9b98bab68),
        RTUINT128_INIT_C(0x000000000000017c, 0xfaf8875ac3235dae), RTUINT128_INIT_C(0x0000000000000000, 0x000014aa980ff5b6)
    },
    { /* i=982; 123 / 84 */
        RTUINT128_INIT_C(0x067aef25c58acd42, 0x7ccddd218a3dc482), RTUINT128_INIT_C(0x00000000000aa2a4, 0x0235c105fce8daa0),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000009bfbc9bee0), RTUINT128_INIT_C(0x00000000000a7507, 0x1ada4620e49bb882)
    },
    { /* i=983; 123 / 84 */
        RTUINT128_INIT_C(0x04107b159db9c06d, 0xe0fed82430515cf1), RTUINT128_INIT_C(0x00000000000fc134, 0xc8cd8df706e74e1b),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000420ae254d1), RTUINT128_INIT_C(0x000000000007cbbf, 0xbc9d9efda603bce6)
    },
    { /* i=984; 120 / 48 */
        RTUINT128_INIT_C(0x00ffa6639d72ce65, 0xb66ec1b32c047a71), RTUINT128_INIT_C(0x0000000000000000, 0x00005f791673e5cf),
        RTUINT128_INIT_C(0x00000000000002ad, 0x7f0ea7c6e38e69de), RTUINT128_INIT_C(0x0000000000000000, 0x00004c52246f49ef)
    },
    { /* i=985; 52 / 16 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000208312799832a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000007012),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000004a443ab11), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000bf8)
    },
    { /* i=986; 123 / 34 */
        RTUINT128_INIT_C(0x02195b80a80fd14c, 0x2c27ae172f3eb7d1), RTUINT128_INIT_C(0x0000000000000000, 0x000000011b818e7e),
        RTUINT128_INIT_C(0x0000000001e538ef, 0x9d52ddeec2720126), RTUINT128_INIT_C(0x0000000000000000, 0x00000000a859131d)
    },
    { /* i=987; 121 / 109 */
        RTUINT128_INIT_C(0x01011c73d256f568, 0x879c6378e20df1a4), RTUINT128_INIT_C(0x00000a5b007d7516, 0xcc48bb730df3bcc8),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000018d4), RTUINT128_INIT_C(0x0000010ba777db60, 0x89ce5ee27a82dc04)
    },
    { /* i=988; 120 / 110 */
        RTUINT128_INIT_C(0x00bad2935a8002b2, 0x8b32a39651144e12), RTUINT128_INIT_C(0x00000cc03fc32dac, 0xd281c239e2862334),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000ea6), RTUINT128_INIT_C(0x00000a6d5570f11e, 0xf26f87aa182ca25a)
    },
    { /* i=989; 46 / 43 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000333375a96bbd), RTUINT128_INIT_C(0x0000000000000000, 0x00000417a7f4e01b),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000c), RTUINT128_INIT_C(0x0000000000000000, 0x00000217962eea79)
    },
    { /* i=990; 127 / 60 */
        RTUINT128_INIT_C(0x45f8ec2b1cbd8e1b, 0x3df8fd031cebe046), RTUINT128_INIT_C(0x0000000000000000, 0x0ee0dfbb3fcbe2fa),
        RTUINT128_INIT_C(0x0000000000000004, 0xb3f42a8a81dfae58), RTUINT128_INIT_C(0x0000000000000000, 0x0deb2089e8c9ee56)
    },
    { /* i=991; 61 / 61 */
        RTUINT128_INIT_C(0x0000000000000000, 0x1851c88021b8257e), RTUINT128_INIT_C(0x0000000000000000, 0x123749b96c8b51a1),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x0000000000000000, 0x061a7ec6b52cd3dd)
    },
    { /* i=992; 71 / 38 */
        RTUINT128_INIT_C(0x000000000000005b, 0xb1a89ec2094361a5), RTUINT128_INIT_C(0x0000000000000000, 0x0000002872ac9d24),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000024457a82b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000687e95c99)
    },
    { /* i=993; 9 / 24 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000019), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000017357),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000019)
    },
    { /* i=994; 121 / 39 */
        RTUINT128_INIT_C(0x015fae9d91db71ad, 0x5e7567eac5ff304a), RTUINT128_INIT_C(0x0000000000000000, 0x000000763613f9a5),
        RTUINT128_INIT_C(0x000000000002f99b, 0x9f0f4e751afb7095), RTUINT128_INIT_C(0x0000000000000000, 0x0000001b085fb341)
    },
    { /* i=995; 128 / 75 */
        RTUINT128_INIT_C(0x2452b217fbf007c3, 0x5435d1bc961711ba), RTUINT128_INIT_C(0x0000000000000219, 0x0da15e302d22e664),
        RTUINT128_INIT_C(0x0000000000000000, 0x00115075518bc7f3), RTUINT128_INIT_C(0x0000000000000186, 0xbbcade5ee092a4ce)
    },
    { /* i=996; 111 / 22 */
        RTUINT128_INIT_C(0x00001cf3d716409f, 0xf82dd9451aceb095), RTUINT128_INIT_C(0x0000000000000000, 0x00000000001fd9c6),
        RTUINT128_INIT_C(0x0000000000e8b4b5, 0x1090d9ca9a2066ab), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000035553)
    },
    { /* i=997; 65 / 14 */
        RTUINT128_INIT_C(0x0000000000000000, 0xf1449151feb153c5), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001d70),
        RTUINT128_INIT_C(0x0000000000000000, 0x00083228cf268bbb), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000002f5)
    },
    { /* i=998; 121 / 37 */
        RTUINT128_INIT_C(0x0044c79b5bfd3290, 0x0058fb1692edcb7a), RTUINT128_INIT_C(0x0000000000000000, 0x00000011bab11f2f),
        RTUINT128_INIT_C(0x000000000003e123, 0x53b166ccb9b29905), RTUINT128_INIT_C(0x0000000000000000, 0x000000056c27188f)
    },
    { /* i=999; 103 / 16 */
        RTUINT128_INIT_C(0x0000007ef74cd7df, 0x64c944ee196e8008), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000008a08),
        RTUINT128_INIT_C(0x0000000000eb7a53, 0x843292eeb4d099cf), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001b90)
    },
    { /* i=1000; 121 / 119 */
        RTUINT128_INIT_C(0x00879b78e0fbb725, 0xc8f341cbfeabdac9), RTUINT128_INIT_C(0x003e4193aaa47cb0, 0xedfdd91a7dde57bc),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002), RTUINT128_INIT_C(0x000b18518bb2bdc3, 0xecf78f9702ef2b51)
    },
    { /* i=1001; 124 / 7 */
        RTUINT128_INIT_C(0x0c56c34eb029d07b, 0xc833568007cc9a70), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000002b),
        RTUINT128_INIT_C(0x004975a88712d538, 0x75c5a8b59504c21a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000012)
    },
    { /* i=1002; 122 / 98 */
        RTUINT128_INIT_C(0x016ee21e924ce13a, 0x397959fbe0cf5022), RTUINT128_INIT_C(0x00000002e86b7d05, 0x98b392404ff9496b),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000007e2b0f), RTUINT128_INIT_C(0x000000015d3f74de, 0x21bb9e162f3509dd)
    },
    { /* i=1003; 122 / 79 */
        RTUINT128_INIT_C(0x0073472e345b6a20, 0x726defbfc14100f3), RTUINT128_INIT_C(0x0000000000005f37, 0xb041576b0c0a14b9),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000135ef2ef729), RTUINT128_INIT_C(0x0000000000003e95, 0xfefa1087a9673052)
    },
    { /* i=1004; 111 / 56 */
        RTUINT128_INIT_C(0x00004e73f0c0ce80, 0x18945863bd9f3b65), RTUINT128_INIT_C(0x0000000000000000, 0x0087180fc0c17e20),
        RTUINT128_INIT_C(0x0000000000000000, 0x0094aa9ac21c4852), RTUINT128_INIT_C(0x0000000000000000, 0x00175f2388abd525)
    },
    { /* i=1005; 61 / 26 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0c1b01ee59822abe), RTUINT128_INIT_C(0x0000000000000000, 0x000000000273b4d8),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000004efe16b28), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000ffa0fe)
    },
    { /* i=1006; 120 / 94 */
        RTUINT128_INIT_C(0x0079aed4874ff8b0, 0xa0c06a0428180893), RTUINT128_INIT_C(0x000000002ba8051a, 0x968728f26a1f5511),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000002c98bf6), RTUINT128_INIT_C(0x00000000220862f7, 0x8c79e02f3e730f3d)
    },
    { /* i=1007; 23 / 14 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000507bd1), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001df6),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000002af), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000014a7)
    },
    { /* i=1008; 102 / 30 */
        RTUINT128_INIT_C(0x00000008fe89d19e, 0xa7fc1b3e1aa56d22), RTUINT128_INIT_C(0x0000000000000000, 0x0000000028c8a34c),
        RTUINT128_INIT_C(0x0000000000000038, 0x750f105cfc785273), RTUINT128_INIT_C(0x0000000000000000, 0x000000002895b9fe)
    },
    { /* i=1009; 109 / 9 */
        RTUINT128_INIT_C(0x0000162a0197eacb, 0xe277ab2ea04d2f01), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000081),
        RTUINT128_INIT_C(0x0000002bfc0b19a2, 0x531eb1f2784ffa69), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000018)
    },
    { /* i=1010; 34 / 108 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000001677c295e), RTUINT128_INIT_C(0x00000dc4bcd44445, 0x10e1baa37e84515e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00000001677c295e)
    },
    { /* i=1011; 122 / 105 */
        RTUINT128_INIT_C(0x02504dfc602fe298, 0xf128068e52f18f45), RTUINT128_INIT_C(0x0000018587c8d3e1, 0x37a5fd59c0f04390),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000018543), RTUINT128_INIT_C(0x000000b5acab3518, 0x26bd55e3bd661095)
    },
    { /* i=1012; 46 / 24 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00001b56e97e6d4b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000346e42),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000857d23), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000332045)
    },
    { /* i=1013; 46 / 22 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000240b7b0b67be), RTUINT128_INIT_C(0x0000000000000000, 0x00000000003fb56b),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000090d6b5), RTUINT128_INIT_C(0x0000000000000000, 0x000000000028b117)
    },
    { /* i=1014; 124 / 119 */
        RTUINT128_INIT_C(0x031d4499bcecb6e3, 0x4e05b6f4e85eb683), RTUINT128_INIT_C(0x001dbf6b27b31b00, 0xd01a7a2f26974d33),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000001a), RTUINT128_INIT_C(0x0017d3b7b4bbf8ce, 0x2b554e2afd00df55)
    },
    { /* i=1015; 37 / 25 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000001cd128235b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000cee271),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000023a8), RTUINT128_INIT_C(0x0000000000000000, 0x00000000006e1633)
    },
    { /* i=1016; 121 / 109 */
        RTUINT128_INIT_C(0x0167a784ea2d08a8, 0x48a0dcd246857284), RTUINT128_INIT_C(0x00000f201dcca59e, 0x9af36221154ccca8),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000017c7), RTUINT128_INIT_C(0x000002e05d370a71, 0xf79e9c30d16f43ec)
    },
    { /* i=1017; 127 / 61 */
        RTUINT128_INIT_C(0x652e685963c29912, 0x2412f93d039d5c2d), RTUINT128_INIT_C(0x0000000000000000, 0x0fc59b7b18cd29c1),
        RTUINT128_INIT_C(0x0000000000000006, 0x6a503619739215e8), RTUINT128_INIT_C(0x0000000000000000, 0x01bce0093230b045)
    },
    { /* i=1018; 122 / 96 */
        RTUINT128_INIT_C(0x02f452836fc33b12, 0x7d612a35f4f2f204), RTUINT128_INIT_C(0x00000000d3a45df2, 0x6e60480baf78ed62),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000392d6e8), RTUINT128_INIT_C(0x00000000d0b75b58, 0xc02d9d305107e534)
    },
    { /* i=1019; 58 / 12 */
        RTUINT128_INIT_C(0x0000000000000000, 0x034e5ccfd50458f5), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000bf8),
        RTUINT128_INIT_C(0x0000000000000000, 0x000046b6e09221c8), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000735)
    },
    { /* i=1020; 114 / 121 */
        RTUINT128_INIT_C(0x00010f85b39c8383, 0xe4cb300fb3f58e38), RTUINT128_INIT_C(0x01d924c4ecaba1ba, 0x2f2de4fd295cc336),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00010f85b39c8383, 0xe4cb300fb3f58e38)
    },
    { /* i=1021; 124 / 85 */
        RTUINT128_INIT_C(0x02e3dbb9555f8a57, 0x1e89ddeab522a157), RTUINT128_INIT_C(0x00000000000419e4, 0x45bbedae7a84a68a),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000b467321904), RTUINT128_INIT_C(0x0000000000007df2, 0xe8bfb747c9d88d2f)
    },
    { /* i=1022; 115 / 25 */
        RTUINT128_INIT_C(0x000450891772e20d, 0x9d984b1b09b79ab1), RTUINT128_INIT_C(0x0000000000000000, 0x00000000007dd5bd),
        RTUINT128_INIT_C(0x0000000008c7146b, 0x7ba78f2c92715d62), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000791f57)
    },
    { /* i=1023; 116 / 54 */
        RTUINT128_INIT_C(0x0008fc25a645e9cc, 0x0b5329e6f5eaf31b), RTUINT128_INIT_C(0x0000000000000000, 0x002e08121c643bde),
        RTUINT128_INIT_C(0x0000000000000000, 0x31f80d2648e31bd0), RTUINT128_INIT_C(0x0000000000000000, 0x000c2b85cc4fe4bb)
    },
    { /* i=1024; 97 / 89 */
        RTUINT128_INIT_C(0x000000010e0d5a28, 0x3610de5d58c993e8), RTUINT128_INIT_C(0x000000000072f8df, 0x1dc14fc7fb7eec95),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000259), RTUINT128_INIT_C(0x000000000023165b, 0x5b3c91dfebd02a1b)
    },
    { /* i=1025; 56 / 53 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00b5a1baced2afcc), RTUINT128_INIT_C(0x0000000000000000, 0x000bc38fd3c9d9dd),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000f), RTUINT128_INIT_C(0x0000000000000000, 0x00052c4d65feebd9)
    },
    { /* i=1026; 57 / 24 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00e100f33bef684d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000db7ace),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000001067173b4), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000848575)
    },
    { /* i=1027; 13 / 62 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000275), RTUINT128_INIT_C(0x0000000000000000, 0x0667530ab4756c58),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000275)
    },
    { /* i=1028; 120 / 75 */
        RTUINT128_INIT_C(0x00c29f4749df1275, 0x26d5a056600f5d38), RTUINT128_INIT_C(0x00000000000003f7, 0x429e180bbfd3972a),
        RTUINT128_INIT_C(0x0000000000000000, 0x000031130b5e38ee), RTUINT128_INIT_C(0x0000000000000256, 0x9066ea2570dba42c)
    },
    { /* i=1029; 58 / 56 */
        RTUINT128_INIT_C(0x0000000000000000, 0x02dae192b4a73c8e), RTUINT128_INIT_C(0x0000000000000000, 0x0015ab03f365b868),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000021), RTUINT128_INIT_C(0x0000000000000000, 0x000fd610548a7726)
    },
    { /* i=1030; 57 / 41 */
        RTUINT128_INIT_C(0x0000000000000000, 0x01e9800401588973), RTUINT128_INIT_C(0x0000000000000000, 0x0000004ac99ebbd6),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000068b92), RTUINT128_INIT_C(0x0000000000000000, 0x0000002b6dd03767)
    },
    { /* i=1031; 76 / 42 */
        RTUINT128_INIT_C(0x00000000000004ca, 0xecfb1c7d68b6da35), RTUINT128_INIT_C(0x0000000000000000, 0x0000027d5d654a56),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000001eccca314), RTUINT128_INIT_C(0x0000000000000000, 0x000000a619f0497d)
    },
    { /* i=1032; 117 / 94 */
        RTUINT128_INIT_C(0x001272dee8493ffa, 0xe79267c0928ea364), RTUINT128_INIT_C(0x0000000002587ae7, 0x45198a0d0287bea9),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000007dd7afc), RTUINT128_INIT_C(0x000000000213b392, 0x2e576a572d2d6b08)
    },
    { /* i=1033; 28 / 22 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000003d6d347), RTUINT128_INIT_C(0x0000000000000000, 0x000000000004d74c),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000cb), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001a03)
    },
    { /* i=1034; 113 / 18 */
        RTUINT128_INIT_C(0x0000826caee73514, 0x9d92f136f0f7d786), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000879f),
        RTUINT128_INIT_C(0x00000000f630e0cc, 0x047cd4776e0e62ab), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000006251)
    },
    { /* i=1035; 121 / 126 */
        RTUINT128_INIT_C(0x01e7bd5c8f6b0fca, 0xd617032ab5cf78da), RTUINT128_INIT_C(0x077113d4cf1dc1e6, 0xf72a901bbd4a8705),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x01e7bd5c8f6b0fca, 0xd617032ab5cf78da)
    },
    { /* i=1036; 128 / 62 */
        RTUINT128_INIT_C(0x2eb0b1e5cd5c06e3, 0x47f944cce543546f), RTUINT128_INIT_C(0x0000000000000000, 0x3adc02bf5dacb59d),
        RTUINT128_INIT_C(0x0000000000000000, 0xcb1269782463094c), RTUINT128_INIT_C(0x0000000000000000, 0x15e5afc5b3e3e4d3)
    },
    { /* i=1037; 121 / 126 */
        RTUINT128_INIT_C(0x01a2a86ec658b7a7, 0xbcb66ea1cf6d91b6), RTUINT128_INIT_C(0x37ece4aaf9c030f4, 0xcf1aae30de926470),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x01a2a86ec658b7a7, 0xbcb66ea1cf6d91b6)
    },
    { /* i=1038; 73 / 68 */
        RTUINT128_INIT_C(0x0000000000000052, 0xa4a31c5ef12c0332), RTUINT128_INIT_C(0x000000000000000c, 0x065a8ab4d4c7db8f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000006), RTUINT128_INIT_C(0x000000000000000a, 0x7e83dc21f47cddd8)
    },
    { /* i=1039; 97 / 70 */
        RTUINT128_INIT_C(0x00000001b115db21, 0xd5549ba08d37af04), RTUINT128_INIT_C(0x0000000000000002, 0xbaebaf39e8e03e17),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000009ea14ea9), RTUINT128_INIT_C(0x0000000000000001, 0xaf346e183fccafd5)
    },
    { /* i=1040; 35 / 44 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000003bfd20072), RTUINT128_INIT_C(0x0000000000000000, 0x00000f17ead6ecd7),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00000003bfd20072)
    },
    { /* i=1041; 30 / 19 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000113f6b7a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000052be0),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000355), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000043a1a)
    },
    { /* i=1042; 126 / 104 */
        RTUINT128_INIT_C(0x3f5f89004ee5a76f, 0x153add7661486c6c), RTUINT128_INIT_C(0x000000da1d818df5, 0xc46df30d60929dbb),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000004a616c), RTUINT128_INIT_C(0x0000005abc68dc8a, 0x4be257d87d9c0688)
    },
    { /* i=1043; 120 / 124 */
        RTUINT128_INIT_C(0x009186afcf15dd3d, 0x14a472e698071035), RTUINT128_INIT_C(0x072d996396ea35ad, 0x53646ec993115000),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x009186afcf15dd3d, 0x14a472e698071035)
    },
    { /* i=1044; 125 / 90 */
        RTUINT128_INIT_C(0x0da293f54ea35978, 0x709ca4a40e396997), RTUINT128_INIT_C(0x0000000001722014, 0x5817aba94050fe02),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000096e48f101), RTUINT128_INIT_C(0x0000000000961717, 0x8bd4d17042388995)
    },
    { /* i=1045; 120 / 119 */
        RTUINT128_INIT_C(0x00dcf49620e51a34, 0xc5d19c43a000574c), RTUINT128_INIT_C(0x0015c47425ff4857, 0x7ef5f1faa770f28f),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000a), RTUINT128_INIT_C(0x0003480ca4ec46c9, 0xd03628791596ddb6)
    },
    { /* i=1046; 91 / 48 */
        RTUINT128_INIT_C(0x00000000064729ec, 0x5d06eef772afa459), RTUINT128_INIT_C(0x0000000000000000, 0x0000656fa0bfaa6a),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000fd817846d56), RTUINT128_INIT_C(0x0000000000000000, 0x00003972721542bd)
    },
    { /* i=1047; 120 / 120 */
        RTUINT128_INIT_C(0x00416301bf574975, 0xbf4ab82d829c5201), RTUINT128_INIT_C(0x00c43ce46074558c, 0xbd16ffcc04cc497d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00416301bf574975, 0xbf4ab82d829c5201)
    },
    { /* i=1048; 102 / 89 */
        RTUINT128_INIT_C(0x000000168fbce922, 0xf119c56db34c28d7), RTUINT128_INIT_C(0x000000000114a67a, 0x954be2d382f20249),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000014e0), RTUINT128_INIT_C(0x0000000000a9aa36, 0x60fac620375c74f7)
    },
    { /* i=1049; 34 / 23 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000031710a07d), RTUINT128_INIT_C(0x0000000000000000, 0x000000000056c864),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000091d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000306929)
    },
    { /* i=1050; 123 / 55 */
        RTUINT128_INIT_C(0x013c5ec0a8d59a29, 0x5ff85d7ac9d32d7f), RTUINT128_INIT_C(0x0000000000000000, 0x00032fd2352b1d80),
        RTUINT128_INIT_C(0x0000000000000063, 0x466f47114659f04e), RTUINT128_INIT_C(0x0000000000000000, 0x0000fe07e988307f)
    },
    { /* i=1051; 85 / 25 */
        RTUINT128_INIT_C(0x00000000000fe296, 0x1b77547fcc05cc98), RTUINT128_INIT_C(0x0000000000000000, 0x0000000001b6a1c0),
        RTUINT128_INIT_C(0x0000000000000000, 0x094564d42b693f26), RTUINT128_INIT_C(0x0000000000000000, 0x00000000015b8a18)
    },
    { /* i=1052; 81 / 69 */
        RTUINT128_INIT_C(0x0000000000012aff, 0x245ee89a578bb75f), RTUINT128_INIT_C(0x0000000000000004, 0xefed240491e4f5cb),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000003c8f), RTUINT128_INIT_C(0x0000000000000001, 0x8a76b7db2f0ad6fa)
    },
    { /* i=1053; 107 / 32 */
        RTUINT128_INIT_C(0x0000071bbe6eb029, 0xd084b2b398cfe552), RTUINT128_INIT_C(0x0000000000000000, 0x00000000483d3f49),
        RTUINT128_INIT_C(0x0000000000001930, 0xc5a175db2b8d6d76), RTUINT128_INIT_C(0x0000000000000000, 0x000000001a6da4ac)
    },
    { /* i=1054; 114 / 37 */
        RTUINT128_INIT_C(0x0000ae1081ad1b1e, 0xfeb691388da2b551), RTUINT128_INIT_C(0x0000000000000000, 0x00000007cbccb349),
        RTUINT128_INIT_C(0x0000000000001653, 0xbfc0044104001733), RTUINT128_INIT_C(0x0000000000000000, 0x000000056bbf6ec6)
    },
    { /* i=1055; 69 / 4 */
        RTUINT128_INIT_C(0x0000000000000004, 0x8df080edfc04637c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000008),
        RTUINT128_INIT_C(0x0000000000000000, 0x91be101dbf808c6f), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000004)
    },
    { /* i=1056; 101 / 108 */
        RTUINT128_INIT_C(0x0000001d2a3ccf39, 0x61ba897845e554e8), RTUINT128_INIT_C(0x000001e5b4cc9a1d, 0x0bfa47d2327a109b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000001d2a3ccf39, 0x61ba897845e554e8)
    },
    { /* i=1057; 118 / 101 */
        RTUINT128_INIT_C(0x003e02d4dff1ab9e, 0x28ebe9cac556429e), RTUINT128_INIT_C(0x0000001ce002fb4b, 0xe785db169b510b83),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000225c6), RTUINT128_INIT_C(0x0000001938b98767, 0x088cfb39d6f76c4c)
    },
    { /* i=1058; 63 / 58 */
        RTUINT128_INIT_C(0x0000000000000000, 0x310c8fbb00440e7a), RTUINT128_INIT_C(0x0000000000000000, 0x033825b4defc24e2),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000f), RTUINT128_INIT_C(0x0000000000000000, 0x00c25a21ef7de53c)
    },
    { /* i=1059; 114 / 23 */
        RTUINT128_INIT_C(0x0003571fa0a4151c, 0x8dcdc7ee30906961), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000042916),
        RTUINT128_INIT_C(0x00000000cd88c3e1, 0x0d2a685c7fe01406), RTUINT128_INIT_C(0x0000000000000000, 0x000000000001badd)
    },
    { /* i=1060; 66 / 59 */
        RTUINT128_INIT_C(0x0000000000000003, 0x1a24af6cda69c75a), RTUINT128_INIT_C(0x0000000000000000, 0x07fb9be63e5ffb47),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000063), RTUINT128_INIT_C(0x0000000000000000, 0x03d76562bb4b9ae5)
    },
    { /* i=1061; 76 / 18 */
        RTUINT128_INIT_C(0x0000000000000fc2, 0x2d5d682c8ef8279b), RTUINT128_INIT_C(0x0000000000000000, 0x000000000002964d),
        RTUINT128_INIT_C(0x0000000000000000, 0x061755fb91fbff4b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000006c0c)
    },
    { /* i=1062; 55 / 55 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0024e4fecc15cbcc), RTUINT128_INIT_C(0x0000000000000000, 0x00142bbdde1aabba),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x0000000000000000, 0x0010b940edfb2012)
    },
    { /* i=1063; 70 / 9 */
        RTUINT128_INIT_C(0x000000000000001e, 0x3cf3090ee218671e), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000001b5),
        RTUINT128_INIT_C(0x0000000000000000, 0x11b6be68e4fbf485), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000015)
    },
    { /* i=1064; 42 / 17 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000077f630912d), RTUINT128_INIT_C(0x0000000000000000, 0x000000000001ca2c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000430714), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000191bd)
    },
    { /* i=1065; 61 / 61 */
        RTUINT128_INIT_C(0x0000000000000000, 0x1f2f57acee5601b4), RTUINT128_INIT_C(0x0000000000000000, 0x036afdb35b5fb834),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000009), RTUINT128_INIT_C(0x0000000000000000, 0x006c6c5eb7f887e0)
    },
    { /* i=1066; 92 / 63 */
        RTUINT128_INIT_C(0x0000000006ab5fd9, 0x2264b6d746568f97), RTUINT128_INIT_C(0x0000000000000000, 0x47ff4940d8ea1567),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000017b6e651), RTUINT128_INIT_C(0x0000000000000000, 0x17370818dcd14000)
    },
    { /* i=1067; 100 / 25 */
        RTUINT128_INIT_C(0x0000000a688add4a, 0x689cfe03c829aa00), RTUINT128_INIT_C(0x0000000000000000, 0x0000000001041fdc),
        RTUINT128_INIT_C(0x0000000000000a3e, 0x4b5745043166d295), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000f8a6f4)
    },
    { /* i=1068; 91 / 59 */
        RTUINT128_INIT_C(0x000000000159f41e, 0xb81e5b40ed2d1e4b), RTUINT128_INIT_C(0x0000000000000000, 0x02bcf6bac52fa6a1),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000007e58a16a), RTUINT128_INIT_C(0x0000000000000000, 0x01737f83ca4edea1)
    },
    { /* i=1069; 118 / 65 */
        RTUINT128_INIT_C(0x003ea26537d7fd59, 0xa374f2806ec4e4c8), RTUINT128_INIT_C(0x0000000000000000, 0xef6f34d912cfbb88),
        RTUINT128_INIT_C(0x0000000000000000, 0x0042f7c1d6f5cca0), RTUINT128_INIT_C(0x0000000000000000, 0x60c1aebcfa574fc8)
    },
    { /* i=1070; 95 / 22 */
        RTUINT128_INIT_C(0x000000002f69b0af, 0xe4324f91144a3e8b), RTUINT128_INIT_C(0x0000000000000000, 0x00000000003f5c98),
        RTUINT128_INIT_C(0x00000000000000bf, 0x8fdc6ec110ef20dd), RTUINT128_INIT_C(0x0000000000000000, 0x00000000001c4f53)
    },
    { /* i=1071; 128 / 88 */
        RTUINT128_INIT_C(0xd161985aaf0196d7, 0xec97fc8ca29c84bc), RTUINT128_INIT_C(0x00000000002846e1, 0x12d7fef5db7aeb6c),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000532d402186a), RTUINT128_INIT_C(0x00000000002785c0, 0x02f8c528f4ccea04)
    },
    { /* i=1072; 50 / 90 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00008debc48dbe1a), RTUINT128_INIT_C(0x0000000001a08f58, 0xecf912c9ccd139af),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00008debc48dbe1a)
    },
    { /* i=1073; 122 / 16 */
        RTUINT128_INIT_C(0x01f24210ca45bd27, 0x8361eb6fefec874c), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000075b9),
        RTUINT128_INIT_C(0x0000043b8368a585, 0xbd479cbb6b358601), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000003b93)
    },
    { /* i=1074; 101 / 82 */
        RTUINT128_INIT_C(0x0000001e35fafeef, 0x07f15d1e78513091), RTUINT128_INIT_C(0x000000000002ad0b, 0x03220695d9ffe335),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000b4a2e), RTUINT128_INIT_C(0x0000000000019596, 0x597c7f2e91620b0b)
    },
    { /* i=1075; 42 / 2 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000001b704f9ae56), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000009256fde4c7), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001)
    },
    { /* i=1076; 119 / 109 */
        RTUINT128_INIT_C(0x003daf1155ebfc15, 0xa5016b32b2386971), RTUINT128_INIT_C(0x000001c7948a2311, 0x53369e81eefc48b1),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000022a9), RTUINT128_INIT_C(0x00000095ee128898, 0x74e585ae6c04ea98)
    },
    { /* i=1077; 52 / 8 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00028d939488af49), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000ff),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000029023b840f0), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000039)
    },
    { /* i=1078; 127 / 83 */
        RTUINT128_INIT_C(0x3c13955062c3c221, 0xd3ba73cb8954eb82), RTUINT128_INIT_C(0x0000000000060706, 0x4b382a93edaa66a2),
        RTUINT128_INIT_C(0x0000000000000000, 0x000009f7983c92a7), RTUINT128_INIT_C(0x0000000000005399, 0x9d00b69212ab93d4)
    },
    { /* i=1079; 52 / 16 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0001452caeb9bd25), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000046b1),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000499941ac9), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000422c)
    },
    { /* i=1080; 120 / 67 */
        RTUINT128_INIT_C(0x00c846d96170f55f, 0xf45f2dcb4e1222a4), RTUINT128_INIT_C(0x0000000000000007, 0x28b6420b2829097d),
        RTUINT128_INIT_C(0x0000000000000000, 0x001bf9b3cae728df), RTUINT128_INIT_C(0x0000000000000003, 0x9e6d11e1b70c56c1)
    },
    { /* i=1081; 51 / 47 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00007b910b64baab), RTUINT128_INIT_C(0x0000000000000000, 0x000020c242cea266),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003), RTUINT128_INIT_C(0x0000000000000000, 0x0000194a42f8d379)
    },
    { /* i=1082; 119 / 55 */
        RTUINT128_INIT_C(0x007afdfb842db7ff, 0x88aaf3b3cb2e813c), RTUINT128_INIT_C(0x0000000000000000, 0x002688f3ba39ece7),
        RTUINT128_INIT_C(0x0000000000000003, 0x311359cef6721e3b), RTUINT128_INIT_C(0x0000000000000000, 0x00224b619d33d5ff)
    },
    { /* i=1083; 122 / 47 */
        RTUINT128_INIT_C(0x01da13eb486a4c5b, 0x2d2f22bbe96ff7e0), RTUINT128_INIT_C(0x0000000000000000, 0x000002fec54ebaab),
        RTUINT128_INIT_C(0x0000000000009e47, 0x7edc1aef80aba5b5), RTUINT128_INIT_C(0x0000000000000000, 0x000002dd7a3cc5f9)
    },
    { /* i=1084; 113 / 123 */
        RTUINT128_INIT_C(0x000062b0f6d3bef6, 0x882741b65fd0fffe), RTUINT128_INIT_C(0x000c727468fe2816, 0x99908a27e706d184),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000062b0f6d3bef6, 0x882741b65fd0fffe)
    },
    { /* i=1085; 125 / 50 */
        RTUINT128_INIT_C(0x1eee380a3d079f8d, 0x0a1ed0b53e2447e7), RTUINT128_INIT_C(0x0000000000000000, 0x00001abfb1d3f949),
        RTUINT128_INIT_C(0x0000000000012805, 0x7960536c58d67d97), RTUINT128_INIT_C(0x0000000000000000, 0x0000151f5e5d98d8)
    },
    { /* i=1086; 83 / 18 */
        RTUINT128_INIT_C(0x000000000003ea4d, 0xf379acacbebc0ce4), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000c11),
        RTUINT128_INIT_C(0x0000000000000053, 0x10d1cb98a0d6b4d6), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000002ae)
    },
    { /* i=1087; 65 / 32 */
        RTUINT128_INIT_C(0x0000000000000000, 0x9bae7ef9c790542a), RTUINT128_INIT_C(0x0000000000000000, 0x00000000762e4645),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000001513bbe34), RTUINT128_INIT_C(0x0000000000000000, 0x00000000671bd826)
    },
    { /* i=1088; 71 / 102 */
        RTUINT128_INIT_C(0x0000000000000030, 0x8577edb0c2869f58), RTUINT128_INIT_C(0x0000002302d1fe19, 0x02c32eb930b9e8fc),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000030, 0x8577edb0c2869f58)
    },
    { /* i=1089; 55 / 16 */
        RTUINT128_INIT_C(0x0000000000000000, 0x002d32f2a2a5e103), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000009485),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000004de899963c), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000023d7)
    },
    { /* i=1090; 118 / 111 */
        RTUINT128_INIT_C(0x003ec18bac6dd2cc, 0x3d43b157e1eaf791), RTUINT128_INIT_C(0x0000201aeb404372, 0xca7e54050b5cee9a),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000001f4), RTUINT128_INIT_C(0x00000cf832ea1698, 0xbe87977db068f2c9)
    },
    { /* i=1091; 125 / 40 */
        RTUINT128_INIT_C(0x1e23ce472d7ba6b8, 0xfcf887f7552bf961), RTUINT128_INIT_C(0x0000000000000000, 0x000000e91d10faad),
        RTUINT128_INIT_C(0x0000000000211952, 0xa38383896bf81d35), RTUINT128_INIT_C(0x0000000000000000, 0x0000009b3daa7a90)
    },
    { /* i=1092; 127 / 84 */
        RTUINT128_INIT_C(0x32ebcd9239031343, 0x066be45790377437), RTUINT128_INIT_C(0x00000000000b1be4, 0x84a6189133b67c36),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000495732d4200), RTUINT128_INIT_C(0x000000000001a982, 0xb52e40b46cb38837)
    },
    { /* i=1093; 126 / 53 */
        RTUINT128_INIT_C(0x3088aa0bdefba02c, 0x63b2caf24c200a86), RTUINT128_INIT_C(0x0000000000000000, 0x000208b87d387cd8),
        RTUINT128_INIT_C(0x00000000000017dc, 0x4ad9b82f204d6b59), RTUINT128_INIT_C(0x0000000000000000, 0x0001c1379a565b6e)
    },
    { /* i=1094; 78 / 7 */
        RTUINT128_INIT_C(0x0000000000000f08, 0x8282a35be7b828b2), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000068),
        RTUINT128_INIT_C(0x0000000000000025, 0x014141921d4e1415), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000002a)
    },
    { /* i=1095; 121 / 98 */
        RTUINT128_INIT_C(0x004481a2d2675887, 0xaaa959edba022801), RTUINT128_INIT_C(0x00000001f68f5c2e, 0x6f357454b74192d6),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000022e587), RTUINT128_INIT_C(0x00000001512d6d76, 0xc128e29deda84b27)
    },
    { /* i=1096; 87 / 48 */
        RTUINT128_INIT_C(0x0000000000069583, 0xe7a609dddfdf9cd8), RTUINT128_INIT_C(0x0000000000000000, 0x00006fa0afdcda20),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000f1974c001), RTUINT128_INIT_C(0x0000000000000000, 0x00000d1795eac2b8)
    },
    { /* i=1097; 113 / 88 */
        RTUINT128_INIT_C(0x0000d8622f51db9e, 0x4a4ec64b5fbe5272), RTUINT128_INIT_C(0x0000000000a3b30a, 0xdb6d45949a946b84),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000015263c3), RTUINT128_INIT_C(0x00000000000d9138, 0x05f6365c46d460e6)
    },
    { /* i=1098; 85 / 73 */
        RTUINT128_INIT_C(0x00000000000df944, 0x9f33d8f9dd32d2a8), RTUINT128_INIT_C(0x00000000000000b7, 0x6cb6cccb6340bd18),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001380), RTUINT128_INIT_C(0x000000000000007c, 0xb29a5aea6ecb7ea8)
    },
    { /* i=1099; 27 / 5 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000c73573), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000014),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000009f5df), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000007)
    },
    { /* i=1100; 127 / 127 */
        RTUINT128_INIT_C(0x00ee14f93d2535bb, 0x9f716e86a724c831), RTUINT128_INIT_C(0x0b1f831548fd4b67, 0x6b9fba591563afbb),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00ee14f93d2535bb, 0x9f716e86a724c831)
    },
    { /* i=1101; 69 / 27 */
        RTUINT128_INIT_C(0x0000000000000012, 0x2cc1f2207a590aed), RTUINT128_INIT_C(0x0000000000000000, 0x0000000005e2c89f),
        RTUINT128_INIT_C(0x0000000000000000, 0x000003167ee31b3d), RTUINT128_INIT_C(0x0000000000000000, 0x000000000129780a)
    },
    { /* i=1102; 109 / 87 */
        RTUINT128_INIT_C(0x00001be0d0f0396e, 0x892e04c6bbbf9b86), RTUINT128_INIT_C(0x00000000003040d0, 0x7c57e76ffdb51332),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000093e74e), RTUINT128_INIT_C(0x000000000008f33b, 0x6f40c3bf048ba44a)
    },
    { /* i=1103; 64 / 49 */
        RTUINT128_INIT_C(0x0000000000000000, 0xe202851e16640a81), RTUINT128_INIT_C(0x0000000000000000, 0x00016819ac141611),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000a0ac), RTUINT128_INIT_C(0x0000000000000000, 0x00008851eb1a9715)
    },
    { /* i=1104; 41 / 104 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000015a860c9f6), RTUINT128_INIT_C(0x000000887b56042e, 0x840757658ebf82a9),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00000015a860c9f6)
    },
    { /* i=1105; 46 / 13 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00001bf131300c58), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000920),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000030fe955ec), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000002d8)
    },
    { /* i=1106; 115 / 104 */
        RTUINT128_INIT_C(0x0003b040a4591cd2, 0xd7b03c765d9b7be7), RTUINT128_INIT_C(0x00000050ef350741, 0x5539d4419e392896),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000baa), RTUINT128_INIT_C(0x0000003a83d27cc6, 0xc32a7716d6e8164b)
    },
    { /* i=1107; 34 / 34 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000039608b879), RTUINT128_INIT_C(0x0000000000000000, 0x0000000222e3c725),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x0000000000000000, 0x000000017324f154)
    },
    { /* i=1108; 45 / 32 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000054b78dc8bb7), RTUINT128_INIT_C(0x0000000000000000, 0x000000007e41d713),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000abc), RTUINT128_INIT_C(0x0000000000000000, 0x000000002e1bdbc3)
    },
    { /* i=1109; 79 / 76 */
        RTUINT128_INIT_C(0x0000000000000241, 0x171dc358fcbbf66f), RTUINT128_INIT_C(0x0000000000000452, 0x63f4ee64eec24b5a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000241, 0x171dc358fcbbf66f)
    },
    { /* i=1110; 80 / 69 */
        RTUINT128_INIT_C(0x00000000000074ca, 0x50baeca16a98ad78), RTUINT128_INIT_C(0x000000000000000f, 0x37922c634cae762c),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000007ac), RTUINT128_INIT_C(0x000000000000000b, 0xfb4e62d1202613e8)
    },
    { /* i=1111; 68 / 3 */
        RTUINT128_INIT_C(0x0000000000000001, 0x1a688907fb0486c7), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003),
        RTUINT128_INIT_C(0x0000000000000000, 0x5e22d857fe56d797), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002)
    },
    { /* i=1112; 93 / 41 */
        RTUINT128_INIT_C(0x000000000e617462, 0xee24d891e3c2bbbf), RTUINT128_INIT_C(0x0000000000000000, 0x000001cb08ed9fae),
        RTUINT128_INIT_C(0x0000000000000000, 0x0008051dff069140), RTUINT128_INIT_C(0x0000000000000000, 0x0000016b00d5423f)
    },
    { /* i=1113; 119 / 116 */
        RTUINT128_INIT_C(0x00713771a2e94fac, 0x99d3bfc4398b73cb), RTUINT128_INIT_C(0x0008313110c35474, 0x240e70c407784ffe),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000d), RTUINT128_INIT_C(0x0006b7f3c8fe05c6, 0xc51805cfd86f63e5)
    },
    { /* i=1114; 100 / 10 */
        RTUINT128_INIT_C(0x0000000770721bf9, 0xc4676254afb71116), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000002a),
        RTUINT128_INIT_C(0x000000002d580cdb, 0x47b951944d5398c9), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000001c)
    },
    { /* i=1115; 69 / 61 */
        RTUINT128_INIT_C(0x000000000000000d, 0x63206b3de2cfe8cd), RTUINT128_INIT_C(0x0000000000000000, 0x03d56e74ee2fff1a),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000037d), RTUINT128_INIT_C(0x0000000000000000, 0x039e1d5b05630b1b)
    },
    { /* i=1116; 118 / 35 */
        RTUINT128_INIT_C(0x0029ac3e9ca34488, 0x072ca1167885a6e0), RTUINT128_INIT_C(0x0000000000000000, 0x0000000431d933f1),
        RTUINT128_INIT_C(0x000000000009ef41, 0x525f00bd2e1a0ba0), RTUINT128_INIT_C(0x0000000000000000, 0x00000001670fd540)
    },
    { /* i=1117; 121 / 21 */
        RTUINT128_INIT_C(0x00d53af573e80e40, 0x3673a59de7af69d0), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000180021),
        RTUINT128_INIT_C(0x00000008e268ad84, 0x6757498221d3a5ce), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000170a42)
    },
    { /* i=1118; 116 / 100 */
        RTUINT128_INIT_C(0x00014aa13e41bddc, 0x198a788f3ec287cc), RTUINT128_INIT_C(0x0000000acec06fe7, 0xbd928e9dc6c567cc),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001e97), RTUINT128_INIT_C(0x00000006bda293f4, 0x1b61dc33de286678)
    },
    { /* i=1119; 126 / 55 */
        RTUINT128_INIT_C(0x3b6c91184ed6e7e1, 0x4c08bd50d42b89b3), RTUINT128_INIT_C(0x0000000000000000, 0x007c3e75364fe22f),
        RTUINT128_INIT_C(0x000000000000007a, 0x70eab56eaaa1441b), RTUINT128_INIT_C(0x0000000000000000, 0x005a64e46c1b32be)
    },
    { /* i=1120; 67 / 7 */
        RTUINT128_INIT_C(0x0000000000000001, 0x6d31eaae259c2dde), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000a),
        RTUINT128_INIT_C(0x0000000000000000, 0x2484fdde36f60496), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002)
    },
    { /* i=1121; 94 / 56 */
        RTUINT128_INIT_C(0x00000000220515ed, 0x03436f6e9f547537), RTUINT128_INIT_C(0x0000000000000000, 0x0041b6b0c9660300),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000008487e784cd), RTUINT128_INIT_C(0x0000000000000000, 0x001ce9630a180e37)
    },
    { /* i=1122; 79 / 93 */
        RTUINT128_INIT_C(0x0000000000006d69, 0xf9dfcae58b26bc96), RTUINT128_INIT_C(0x0000000002554f08, 0x91e9562f7d5edb56),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000006d69, 0xf9dfcae58b26bc96)
    },
    { /* i=1123; 76 / 18 */
        RTUINT128_INIT_C(0x0000000000000f71, 0x42182e7280f83c34), RTUINT128_INIT_C(0x0000000000000000, 0x000000000001666c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0b079560a7185206), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000013dac)
    },
    { /* i=1124; 125 / 93 */
        RTUINT128_INIT_C(0x0d0f776e0d70b684, 0x06c9ed46029d31f5), RTUINT128_INIT_C(0x000000001f61d5e5, 0x00637f993bd08d0d),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000006a8a5297), RTUINT128_INIT_C(0x00000000149cc9d8, 0xb1dbfbe78269d54a)
    },
    { /* i=1125; 115 / 88 */
        RTUINT128_INIT_C(0x0002682074869fe2, 0x1c6e8fc55fff60d4), RTUINT128_INIT_C(0x0000000000a61261, 0x4df2cf15c5e64b61),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000003b5c2b8), RTUINT128_INIT_C(0x000000000085b7c6, 0x694499712ec4b11c)
    },
    { /* i=1126; 39 / 3 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000004dea4b29c0), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000019f8c3b895), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001)
    },
    { /* i=1127; 117 / 83 */
        RTUINT128_INIT_C(0x00102090b9de7397, 0x9cc22a74f7d4e1cb), RTUINT128_INIT_C(0x0000000000054c13, 0x8ed6c756229be9c7),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000030b63e791), RTUINT128_INIT_C(0x000000000000e8fd, 0xb59cb6c4b89de714)
    },
    { /* i=1128; 90 / 81 */
        RTUINT128_INIT_C(0x0000000003662f30, 0xcb72e864eaa43983), RTUINT128_INIT_C(0x000000000001088f, 0xad8265c90c18d688),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000034a), RTUINT128_INIT_C(0x00000000000006a0, 0x1c90212320f29e33)
    },
    { /* i=1129; 75 / 32 */
        RTUINT128_INIT_C(0x0000000000000365, 0xb69faa8ef104aa5b), RTUINT128_INIT_C(0x0000000000000000, 0x00000000804acb49),
        RTUINT128_INIT_C(0x0000000000000000, 0x000006c7772a3bf4), RTUINT128_INIT_C(0x0000000000000000, 0x0000000023e715c7)
    },
    { /* i=1130; 116 / 92 */
        RTUINT128_INIT_C(0x00051356163b7cef, 0x4bd7fbd47b610775), RTUINT128_INIT_C(0x000000000f61b594, 0xe8a40c5305b0d96e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000547916), RTUINT128_INIT_C(0x0000000000262a59, 0xb8add0fa0f515a01)
    },
    { /* i=1131; 121 / 40 */
        RTUINT128_INIT_C(0x00a219186b47775b, 0x4513b4c22bb01f4d), RTUINT128_INIT_C(0x0000000000000000, 0x0000004b0c6d1e51),
        RTUINT128_INIT_C(0x00000000000228ef, 0xce7aee06178df5bf), RTUINT128_INIT_C(0x0000000000000000, 0x000000267ea5fbde)
    },
    { /* i=1132; 109 / 1 */
        RTUINT128_INIT_C(0x000012b3af039d58, 0xc0eb843e0891b926), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001),
        RTUINT128_INIT_C(0x000012b3af039d58, 0xc0eb843e0891b926), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=1133; 113 / 26 */
        RTUINT128_INIT_C(0x0001291fb52a688d, 0xce54115f7bf4aece), RTUINT128_INIT_C(0x0000000000000000, 0x0000000003ff80f5),
        RTUINT128_INIT_C(0x00000000004a5125, 0xa764cdc06ed7e856), RTUINT128_INIT_C(0x0000000000000000, 0x00000000037e5480)
    },
    { /* i=1134; 114 / 44 */
        RTUINT128_INIT_C(0x000011796369dd74, 0x601bd98620cbebff), RTUINT128_INIT_C(0x0000000000000000, 0x00000b955ad0c838),
        RTUINT128_INIT_C(0x0000000000000001, 0x823062eff7d3ce00), RTUINT128_INIT_C(0x0000000000000000, 0x000002e71186dbff)
    },
    { /* i=1135; 118 / 87 */
        RTUINT128_INIT_C(0x0009fee62eb09bf0, 0x2a6b62e1777ac58d), RTUINT128_INIT_C(0x00000000005ef125, 0x457c866ecf48cec6),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000001af3c62d), RTUINT128_INIT_C(0x00000000000dc9c9, 0xc751e5f855cf48bf)
    },
    { /* i=1136; 62 / 124 */
        RTUINT128_INIT_C(0x0000000000000000, 0x336a3af4dd3b8ba0), RTUINT128_INIT_C(0x068e5d92dade08cb, 0xb5cea9ee6ccecdd3),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x336a3af4dd3b8ba0)
    },
    { /* i=1137; 125 / 54 */
        RTUINT128_INIT_C(0x1df3b3947d0e39a0, 0x6931adb3d942f2ca), RTUINT128_INIT_C(0x0000000000000000, 0x003e41f76e1a0d38),
        RTUINT128_INIT_C(0x000000000000007b, 0x29258d8f239c1b5c), RTUINT128_INIT_C(0x0000000000000000, 0x001afe34d2614aaa)
    },
    { /* i=1138; 119 / 120 */
        RTUINT128_INIT_C(0x001ecbc4a3185cd5, 0xcbed59ff780632c9), RTUINT128_INIT_C(0x00a9f9f8210042d8, 0xa593a1e53f0cf447),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x001ecbc4a3185cd5, 0xcbed59ff780632c9)
    },
    { /* i=1139; 104 / 46 */
        RTUINT128_INIT_C(0x0000001ae352545d, 0x9aadca29e7ec65e7), RTUINT128_INIT_C(0x0000000000000000, 0x000013a39c4cfa0f),
        RTUINT128_INIT_C(0x0000000000000000, 0x015e7d992765b2a7), RTUINT128_INIT_C(0x0000000000000000, 0x00000d537aebd81e)
    },
    { /* i=1140; 98 / 21 */
        RTUINT128_INIT_C(0x000000039f5800c9, 0x5e183f08e45c60d9), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000184cf7),
        RTUINT128_INIT_C(0x0000000000002629, 0x49e03059f42819c0), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000068899)
    },
    { /* i=1141; 76 / 13 */
        RTUINT128_INIT_C(0x0000000000000c2c, 0x82a33430177bcd19), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000007ec),
        RTUINT128_INIT_C(0x0000000000000001, 0x8967d8028c61e434), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000129)
    },
    { /* i=1142; 118 / 105 */
        RTUINT128_INIT_C(0x001e6d2ff7c470e0, 0x98fed35570c3e976), RTUINT128_INIT_C(0x000001373dafe461, 0xa8340c1ec37ec01c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001906), RTUINT128_INIT_C(0x000000de58578d29, 0x929789857b08acce)
    },
    { /* i=1143; 88 / 53 */
        RTUINT128_INIT_C(0x00000000007ffe21, 0x3386317292a9cd10), RTUINT128_INIT_C(0x0000000000000000, 0x001d49b72f4e9b37),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000045ec20bae), RTUINT128_INIT_C(0x0000000000000000, 0x0008147c38e2f0ae)
    },
    { /* i=1144; 115 / 77 */
        RTUINT128_INIT_C(0x0007fc273ccf0008, 0x130f80a314d86894), RTUINT128_INIT_C(0x00000000000013be, 0x7fcfe6f88150a352),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000067883bc71a), RTUINT128_INIT_C(0x00000000000013ba, 0x33fc84890fcd1440)
    },
    { /* i=1145; 121 / 66 */
        RTUINT128_INIT_C(0x00e70163d69100a4, 0xd5bc7f72f1fb45d8), RTUINT128_INIT_C(0x0000000000000001, 0x146dcdc143620d16),
        RTUINT128_INIT_C(0x0000000000000000, 0x00d5eef5ef4bca12), RTUINT128_INIT_C(0x0000000000000000, 0x83d346b17750fe4c)
    },
    { /* i=1146; 121 / 66 */
        RTUINT128_INIT_C(0x0126a7abd814eb71, 0xc92b2366ab5baaff), RTUINT128_INIT_C(0x0000000000000000, 0x035baa6c3911030b),
        RTUINT128_INIT_C(0x0000000000000000, 0x57becf6f3e5a106d), RTUINT128_INIT_C(0x0000000000000000, 0x019e6a44930eaf50)
    },
    { /* i=1147; 75 / 8 */
        RTUINT128_INIT_C(0x00000000000003db, 0x6fde0ad98bd0278c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000040),
        RTUINT128_INIT_C(0x000000000000000f, 0x6dbf782b662f409e), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000c)
    },
    { /* i=1148; 120 / 69 */
        RTUINT128_INIT_C(0x004003e6f63bfc02, 0x1587246ddbf51ccd), RTUINT128_INIT_C(0x000000000000001e, 0x1d872ab9323d8cf2),
        RTUINT128_INIT_C(0x0000000000000000, 0x0002202bd294f0b4), RTUINT128_INIT_C(0x0000000000000017, 0xc04f0542d4a322a5)
    },
    { /* i=1149; 46 / 24 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000017a6585f3876), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000a39eb8),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000002500a2), RTUINT128_INIT_C(0x0000000000000000, 0x00000000003cc806)
    },
    { /* i=1150; 121 / 121 */
        RTUINT128_INIT_C(0x00a7e0e81494cb1a, 0x15c93864e7f8288c), RTUINT128_INIT_C(0x0199f6197c56b086, 0x8c301858a1fff093),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00a7e0e81494cb1a, 0x15c93864e7f8288c)
    },
    { /* i=1151; 91 / 56 */
        RTUINT128_INIT_C(0x00000000043b6ce9, 0x155bcbac2cc1028a), RTUINT128_INIT_C(0x0000000000000000, 0x00b1cdb42e8c72da),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000617e81a78), RTUINT128_INIT_C(0x0000000000000000, 0x005b93c66bb1085a)
    },
    { /* i=1152; 31 / 126 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000040a10390), RTUINT128_INIT_C(0x2b06c74a72b3cbca, 0x94c0e7584bb12e85),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000040a10390)
    },
    { /* i=1153; 114 / 95 */
        RTUINT128_INIT_C(0x0003e705902eb1d9, 0x39097cb918e60987), RTUINT128_INIT_C(0x0000000025573c43, 0x68feafa844f6550f),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000001ac112), RTUINT128_INIT_C(0x000000000cc4f915, 0xfd9c45e1e5edbf79)
    },
    { /* i=1154; 70 / 52 */
        RTUINT128_INIT_C(0x0000000000000008, 0x51f0a0479d850d4e), RTUINT128_INIT_C(0x0000000000000000, 0x000c840f0d9482a6),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000aa2d), RTUINT128_INIT_C(0x0000000000000000, 0x000b6a9d9ba7da20)
    },
    { /* i=1155; 65 / 22 */
        RTUINT128_INIT_C(0x0000000000000000, 0x1037d307333829a6), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000110ee0),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000f3649ef7ea), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000670e6)
    },
    { /* i=1156; 122 / 36 */
        RTUINT128_INIT_C(0x02474ed7d2d674d0, 0xcfb6b99d3ee17a6c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000961226f79),
        RTUINT128_INIT_C(0x00000000003e30ab, 0xb10cd8e3d3414ad0), RTUINT128_INIT_C(0x0000000000000000, 0x0000000055f4ee1c)
    },
    { /* i=1157; 78 / 30 */
        RTUINT128_INIT_C(0x00000000000034e3, 0x212d17bab5a3eb4c), RTUINT128_INIT_C(0x0000000000000000, 0x00000000026878c8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0015f6585475aa35), RTUINT128_INIT_C(0x0000000000000000, 0x00000000026619e4)
    },
    { /* i=1158; 78 / 72 */
        RTUINT128_INIT_C(0x0000000000000e1c, 0xcbc3d928532b2829), RTUINT128_INIT_C(0x000000000000003e, 0xdf009d180dfa4d7c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000039), RTUINT128_INIT_C(0x000000000000001d, 0x24a0decd366fe78d)
    },
    { /* i=1159; 121 / 64 */
        RTUINT128_INIT_C(0x01ab4f6a22c72d97, 0x01234997bea4f7b1), RTUINT128_INIT_C(0x0000000000000000, 0xb5926f579e6b4a78),
        RTUINT128_INIT_C(0x0000000000000000, 0x025a77ee9c46bbf0), RTUINT128_INIT_C(0x0000000000000000, 0xb47a30735dd97f31)
    },
    { /* i=1160; 121 / 89 */
        RTUINT128_INIT_C(0x01fe6aee8fbb895e, 0xe068e89a020aa145), RTUINT128_INIT_C(0x0000000001e01d8a, 0x3dc8eb5b4511468e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000110284804), RTUINT128_INIT_C(0x0000000000ad105f, 0xa76e6a162bbd970d)
    },
    { /* i=1161; 113 / 79 */
        RTUINT128_INIT_C(0x000181971cdc19d6, 0x4932f9555c6e46fd), RTUINT128_INIT_C(0x00000000000069e1, 0x18494ecf8a842ae6),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000003a44c77f7), RTUINT128_INIT_C(0x00000000000036ae, 0xccef2a4932aff913)
    },
    { /* i=1162; 120 / 121 */
        RTUINT128_INIT_C(0x00e41d5747a61f29, 0x169320718b362550), RTUINT128_INIT_C(0x0147cf0bcb04b058, 0xead0dab126033ffe),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00e41d5747a61f29, 0x169320718b362550)
    },
    { /* i=1163; 119 / 63 */
        RTUINT128_INIT_C(0x00059010b40bcbef, 0xc389824db7a7627d), RTUINT128_INIT_C(0x0000000000000000, 0x3bcc71e34094ddcc),
        RTUINT128_INIT_C(0x0000000000000000, 0x0017d07968ba14d7), RTUINT128_INIT_C(0x0000000000000000, 0x18b01fb6d3152c29)
    },
    { /* i=1164; 106 / 38 */
        RTUINT128_INIT_C(0x0000026a27c9e90f, 0x8a64f409ffbe9d56), RTUINT128_INIT_C(0x0000000000000000, 0x00000019337a11c8),
        RTUINT128_INIT_C(0x0000000000000018, 0x876799fe82ea11a8), RTUINT128_INIT_C(0x0000000000000000, 0x000000094ba4aa16)
    },
    { /* i=1165; 34 / 12 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000137e56254), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000d90),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000016ff37), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000864)
    },
    { /* i=1166; 121 / 23 */
        RTUINT128_INIT_C(0x00982c291047ffb3, 0x508cc972bcf4dcdf), RTUINT128_INIT_C(0x0000000000000000, 0x00000000002dad14),
        RTUINT128_INIT_C(0x0000000354e0f153, 0x32c0ddf1c1d5bc9e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000055a87)
    },
    { /* i=1167; 125 / 107 */
        RTUINT128_INIT_C(0x10f41bbc3559222a, 0x442f2a7dd7e208cb), RTUINT128_INIT_C(0x000005f05afe7722, 0x77475f0b715bc3f8),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000002dacb), RTUINT128_INIT_C(0x000002aa6dd861b4, 0x29902b2b474c7323)
    },
    { /* i=1168; 66 / 22 */
        RTUINT128_INIT_C(0x0000000000000000, 0xf6fae49bee85dac5), RTUINT128_INIT_C(0x0000000000000000, 0x000000000031f33e),
        RTUINT128_INIT_C(0x0000000000000000, 0x000004f1ccab389e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000122a81)
    },
    { /* i=1169; 48 / 96 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000658d2da289cf), RTUINT128_INIT_C(0x000000002cde49d8, 0x84ea84596272fc41),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000658d2da289cf)
    },
    { /* i=1170; 124 / 115 */
        RTUINT128_INIT_C(0x0c22a90cc1953ed5, 0xb59a5768337d1d1d), RTUINT128_INIT_C(0x00050070169611d9, 0x87af6108f767aab6),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000026d), RTUINT128_INIT_C(0x00009925f78bf227, 0x912bf4a80d04019f)
    },
    { /* i=1171; 125 / 116 */
        RTUINT128_INIT_C(0x02c263e016b8cb5c, 0x29d58809939507a7), RTUINT128_INIT_C(0x000eba015adfb7ca, 0x94c6bd938a9e2a9a),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000002f), RTUINT128_INIT_C(0x000e3da067a60d2a, 0xd958b9f3208b3561)
    },
    { /* i=1172; 113 / 117 */
        RTUINT128_INIT_C(0x0000e6e1c1cd23df, 0xb40b630bff6f7f61), RTUINT128_INIT_C(0x00028951301371e8, 0x08b3e592b4959a45),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000e6e1c1cd23df, 0xb40b630bff6f7f61)
    },
    { /* i=1173; 107 / 11 */
        RTUINT128_INIT_C(0x00000238a8a77258, 0x165c9fb222221542), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000057b),
        RTUINT128_INIT_C(0x0000000067c2cf8b, 0xa63e1ac0fe61d37e), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000001b8)
    },
    { /* i=1174; 127 / 37 */
        RTUINT128_INIT_C(0x5f65704c42e7a2ba, 0xb299ac4a9d91ab66), RTUINT128_INIT_C(0x0000000000000000, 0x0000000b2b0d9a7e),
        RTUINT128_INIT_C(0x00000000088ab2e9, 0xd77325cd8a51c989), RTUINT128_INIT_C(0x0000000000000000, 0x00000007171f0ff8)
    },
    { /* i=1175; 126 / 46 */
        RTUINT128_INIT_C(0x31940c95793f53e7, 0x617258140a8e752f), RTUINT128_INIT_C(0x0000000000000000, 0x00001321bf37f9a4),
        RTUINT128_INIT_C(0x0000000000029766, 0x5c7af90e2c9d83d6), RTUINT128_INIT_C(0x0000000000000000, 0x000005d04370da17)
    },
    { /* i=1176; 122 / 110 */
        RTUINT128_INIT_C(0x03f6e1779ad76f84, 0xe9095ac89b6446c4), RTUINT128_INIT_C(0x00003791c53c0c69, 0x96eae216a01b3583),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001243), RTUINT128_INIT_C(0x00001672c340c345, 0xe5aa979aca820f7b)
    },
    { /* i=1177; 122 / 63 */
        RTUINT128_INIT_C(0x00accc6928aced9a, 0x3523489f918fcdc0), RTUINT128_INIT_C(0x0000000000000000, 0x76a9d8f8780538a3),
        RTUINT128_INIT_C(0x0000000000000000, 0x0174c9ee6ca41ad5), RTUINT128_INIT_C(0x0000000000000000, 0x6ccacbec210b2021)
    },
    { /* i=1178; 126 / 94 */
        RTUINT128_INIT_C(0x23986cfb0d22c94f, 0xa66e80ded5a5027a), RTUINT128_INIT_C(0x000000000a4603f9, 0x9007404fc1abe3e2),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000376fbd5b2), RTUINT128_INIT_C(0x0000000008fc1143, 0x6265a30d8cef8556)
    },
    { /* i=1179; 113 / 85 */
        RTUINT128_INIT_C(0x00003ff6cadc5212, 0x61a687dfe179c908), RTUINT128_INIT_C(0x00000000000bf857, 0x410fcfe28b451c71),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000557fa08), RTUINT128_INIT_C(0x00000000000aee5f, 0xd56f1ebf2a238b80)
    },
    { /* i=1180; 92 / 76 */
        RTUINT128_INIT_C(0x00000000079448e6, 0x58bdbd08811c1712), RTUINT128_INIT_C(0x00000000000009e7, 0x4a38001c522d477d),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000c3eb), RTUINT128_INIT_C(0x000000000000040c, 0x8f40107094174053)
    },
    { /* i=1181; 50 / 12 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000637bf9e8528d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000a4e),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000009a77e890e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000449)
    },
    { /* i=1182; 116 / 43 */
        RTUINT128_INIT_C(0x000a86bc06545bd6, 0x5ea1d1a95025d909), RTUINT128_INIT_C(0x0000000000000000, 0x0000063dc18d3960),
        RTUINT128_INIT_C(0x00000000000001af, 0xc35705fe8df3683a), RTUINT128_INIT_C(0x0000000000000000, 0x00000222c0b7d949)
    },
    { /* i=1183; 125 / 126 */
        RTUINT128_INIT_C(0x1fac1d0ffdefcbe2, 0xd210e018f4b0f3a9), RTUINT128_INIT_C(0x0bd281d89e90721a, 0x00d481a656317652),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002), RTUINT128_INIT_C(0x0807195ec0cee7ae, 0xd067dccc484e0705)
    },
    { /* i=1184; 117 / 96 */
        RTUINT128_INIT_C(0x00067db7eb616dac, 0x86e2b91af3eee570), RTUINT128_INIT_C(0x00000000d6b5f523, 0x9be5e3f8e9894484),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000007bd45), RTUINT128_INIT_C(0x000000000261cdb1, 0x8ccf1fd8cabdf9dc)
    },
    { /* i=1185; 9 / 56 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000130), RTUINT128_INIT_C(0x0000000000000000, 0x00e91cc292af9770),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000130)
    },
    { /* i=1186; 91 / 29 */
        RTUINT128_INIT_C(0x00000000026d4748, 0xe0b35acd8b37b0c5), RTUINT128_INIT_C(0x0000000000000000, 0x000000000810b8d6),
        RTUINT128_INIT_C(0x0000000000000000, 0x4d07e58ec5cf4a51), RTUINT128_INIT_C(0x0000000000000000, 0x000000000575590f)
    },
    { /* i=1187; 121 / 86 */
        RTUINT128_INIT_C(0x01fa0bffacc70116, 0xf95b6f1f3a925d61), RTUINT128_INIT_C(0x0000000000318b05, 0x80d1ded8f75c70e0),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000a36db6509), RTUINT128_INIT_C(0x00000000001bc50d, 0x93a97b43402a0581)
    },
    { /* i=1188; 93 / 68 */
        RTUINT128_INIT_C(0x0000000011a8318d, 0x5511771f92605f66), RTUINT128_INIT_C(0x0000000000000002, 0xb2cc6838dee19715),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000068b1e6e), RTUINT128_INIT_C(0x0000000000000002, 0xa0ebb689d755fe60)
    },
    { /* i=1189; 25 / 22 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000138e42e), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000aba4e),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000001d), RTUINT128_INIT_C(0x0000000000000000, 0x000000000001c958)
    },
    { /* i=1190; 55 / 3 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0020d1e3bc6d33f6), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003),
        RTUINT128_INIT_C(0x0000000000000000, 0x000af0a13ecf1152), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=1191; 104 / 74 */
        RTUINT128_INIT_C(0x000000d15720e2ea, 0xb91a4f7272bf83f9), RTUINT128_INIT_C(0x0000000000000176, 0xc2827c0c4ffc8a12),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000008f005356), RTUINT128_INIT_C(0x00000000000000aa, 0x325e9440a5254bed)
    },
    { /* i=1192; 123 / 75 */
        RTUINT128_INIT_C(0x07058fdf1252a077, 0x898cbf7daf56ccfe), RTUINT128_INIT_C(0x00000000000000d5, 0x8870532aa1889ca1),
        RTUINT128_INIT_C(0x0000000000000000, 0x00086b0ec97ca2f7), RTUINT128_INIT_C(0x0000000000000047, 0x3b192a2f1a6dcba7)
    },
    { /* i=1193; 57 / 52 */
        RTUINT128_INIT_C(0x0000000000000000, 0x01d4669bb3581470), RTUINT128_INIT_C(0x0000000000000000, 0x0009bc7d21ff4d97),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000030), RTUINT128_INIT_C(0x0000000000000000, 0x00010f2553798820)
    },
    { /* i=1194; 97 / 72 */
        RTUINT128_INIT_C(0x00000000437097a6, 0x9a6f9dae0c2d1eba), RTUINT128_INIT_C(0x00000000000000eb, 0x347605d8989d383c),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000004966ff), RTUINT128_INIT_C(0x00000000000000ce, 0xa7c7f94a5a0e32f6)
    },
    { /* i=1195; 116 / 113 */
        RTUINT128_INIT_C(0x000c21bcc8e3ea94, 0x2a3a6b514773621b), RTUINT128_INIT_C(0x0000333d2b9f0589, 0x86705c6eae7b8daf),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000003c), RTUINT128_INIT_C(0x00001f668f9e9e58, 0xa7e4c160627e2d17)
    },
    { /* i=1196; 118 / 51 */
        RTUINT128_INIT_C(0x0023413334c284ca, 0xba7635a63805c63b), RTUINT128_INIT_C(0x0000000000000000, 0x0001e6dde7d12358),
        RTUINT128_INIT_C(0x0000000000000012, 0x898cff5b1f4c9da8), RTUINT128_INIT_C(0x0000000000000000, 0x00013f34adf99c7b)
    },
    { /* i=1197; 120 / 117 */
        RTUINT128_INIT_C(0x006e914477f09bbf, 0x086ca764bf5cf1e3), RTUINT128_INIT_C(0x0010149a8f0e4053, 0x9f9d493610b120ee),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000006), RTUINT128_INIT_C(0x000e15a51d9b19c9, 0x4abcf0205b362c4f)
    },
    { /* i=1198; 114 / 98 */
        RTUINT128_INIT_C(0x00030b4f023bb2a8, 0xf8c3a64de0335a3f), RTUINT128_INIT_C(0x00000002b9af82b9, 0x620e5ff4cdf9f68e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000011df3), RTUINT128_INIT_C(0x000000005c1a3a86, 0xe44b079f14723b75)
    },
    { /* i=1199; 84 / 56 */
        RTUINT128_INIT_C(0x000000000006fe1d, 0x618eaea8f06d17fe), RTUINT128_INIT_C(0x0000000000000000, 0x009887c4a1489db4),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000bbc7282), RTUINT128_INIT_C(0x0000000000000000, 0x004f9ce22722da96)
    },
    { /* i=1200; 52 / 113 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0007819c1ecb41b3), RTUINT128_INIT_C(0x0000db9a1a9ead6f, 0x2980049ec04f91f3),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0007819c1ecb41b3)
    },
    { /* i=1201; 120 / 124 */
        RTUINT128_INIT_C(0x000a095ecd580411, 0xd8eed3b8519373d3), RTUINT128_INIT_C(0x05312d297dc0066e, 0xb845b84f0f387edf),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000a095ecd580411, 0xd8eed3b8519373d3)
    },
    { /* i=1202; 79 / 47 */
        RTUINT128_INIT_C(0x0000000000000644, 0x4798c0e7ad0a5f83), RTUINT128_INIT_C(0x0000000000000000, 0x00002fe528095738),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000217ee3f3), RTUINT128_INIT_C(0x0000000000000000, 0x00002f0b3e45ed5b)
    },
    { /* i=1203; 112 / 26 */
        RTUINT128_INIT_C(0x000037944f2283d0, 0x351537aa9783bb6f), RTUINT128_INIT_C(0x0000000000000000, 0x000000000200e64a),
        RTUINT128_INIT_C(0x00000000001bbdad, 0x59f86f7f8c326b62), RTUINT128_INIT_C(0x0000000000000000, 0x000000000076a51b)
    },
    { /* i=1204; 87 / 83 */
        RTUINT128_INIT_C(0x00000000004fe75d, 0xd9a0289422748fc0), RTUINT128_INIT_C(0x00000000000296c8, 0xaa088c49cff4b615),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000001e), RTUINT128_INIT_C(0x0000000000023bd9, 0xec9fb7edc3c7394a)
    },
    { /* i=1205; 107 / 60 */
        RTUINT128_INIT_C(0x0000065bb2c5882b, 0x26e29c5752afb633), RTUINT128_INIT_C(0x0000000000000000, 0x0698e74efec5d865),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000f6b9001213ce), RTUINT128_INIT_C(0x0000000000000000, 0x003544f7695215ed)
    },
    { /* i=1206; 113 / 23 */
        RTUINT128_INIT_C(0x00015160ab8a02de, 0x26ab392d58802e8a), RTUINT128_INIT_C(0x0000000000000000, 0x000000000069a059),
        RTUINT128_INIT_C(0x000000000331ae58, 0x816bc9d916d798c3), RTUINT128_INIT_C(0x0000000000000000, 0x00000000001732bf)
    },
    { /* i=1207; 117 / 62 */
        RTUINT128_INIT_C(0x000725c648370c56, 0xa30422981379f523), RTUINT128_INIT_C(0x0000000000000000, 0x17ffc6866becd1a3),
        RTUINT128_INIT_C(0x0000000000000000, 0x004c3e4eedd72e40), RTUINT128_INIT_C(0x0000000000000000, 0x07461df693b54263)
    },
    { /* i=1208; 33 / 20 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000112c7dcee), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000004fa8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000037317), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000003cd6)
    },
    { /* i=1209; 114 / 122 */
        RTUINT128_INIT_C(0x0000f1712e2b3ec7, 0xbd7bf28e9e5b0b0a), RTUINT128_INIT_C(0x037a259033898c14, 0x43928b29f728c602),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000f1712e2b3ec7, 0xbd7bf28e9e5b0b0a)
    },
    { /* i=1210; 56 / 4 */
        RTUINT128_INIT_C(0x0000000000000000, 0x006bafd03c5b832a), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0008f9515a5cf598), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000a)
    },
    { /* i=1211; 127 / 62 */
        RTUINT128_INIT_C(0x3c9759f26b8bd2a2, 0x2b4d2afcd32e442f), RTUINT128_INIT_C(0x0000000000000000, 0x19573c85e02db2d6),
        RTUINT128_INIT_C(0x0000000000000002, 0x641c4df7a7babc56), RTUINT128_INIT_C(0x0000000000000000, 0x16bfea0a6b03084b)
    },
    { /* i=1212; 125 / 63 */
        RTUINT128_INIT_C(0x1d7a6b0e3e86e8f8, 0xdfd0e1abdb444370), RTUINT128_INIT_C(0x0000000000000000, 0x5306f28ffea39ce4),
        RTUINT128_INIT_C(0x0000000000000000, 0x5ae41768b97266cb), RTUINT128_INIT_C(0x0000000000000000, 0x28e5502b1d7c02a4)
    },
    { /* i=1213; 79 / 19 */
        RTUINT128_INIT_C(0x00000000000061c9, 0x466f5cf118e8be1e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000044b2e),
        RTUINT128_INIT_C(0x0000000000000000, 0x16c64611e21edb47), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000038a5c)
    },
    { /* i=1214; 67 / 23 */
        RTUINT128_INIT_C(0x0000000000000001, 0xa69ba1a4d292f132), RTUINT128_INIT_C(0x0000000000000000, 0x00000000006f2e7f),
        RTUINT128_INIT_C(0x0000000000000000, 0x000003cd12368370), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000599ca2)
    },
    { /* i=1215; 102 / 40 */
        RTUINT128_INIT_C(0x00000003638e970c, 0x2ef6ed40595d5d13), RTUINT128_INIT_C(0x0000000000000000, 0x000000bebe894af3),
        RTUINT128_INIT_C(0x0000000000000000, 0x048c5b97bedc27dc), RTUINT128_INIT_C(0x0000000000000000, 0x0000005bee21ef3f)
    },
    { /* i=1216; 12 / 104 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000c0c), RTUINT128_INIT_C(0x0000000fa4f00e87, 0xa42f8f58c1d7cd49),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000c0c)
    },
    { /* i=1217; 100 / 34 */
        RTUINT128_INIT_C(0x0000000701a5835e, 0xe6048614e111bca3), RTUINT128_INIT_C(0x0000000000000000, 0x000000018962f512),
        RTUINT128_INIT_C(0x0000000000000004, 0x8f3b7be59951ad3b), RTUINT128_INIT_C(0x0000000000000000, 0x000000010af4177d)
    },
    { /* i=1218; 94 / 60 */
        RTUINT128_INIT_C(0x000000003f5501da, 0x2ec19d2466f3e691), RTUINT128_INIT_C(0x0000000000000000, 0x022542db20cf6c3d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000001d8491ad33), RTUINT128_INIT_C(0x0000000000000000, 0x009f6a1beeef1d6a)
    },
    { /* i=1219; 115 / 77 */
        RTUINT128_INIT_C(0x0007b24dad0f43a8, 0xcfb9dcc55cb50a51), RTUINT128_INIT_C(0x00000000000006ad, 0xe72e7010bf584cda),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000126fc72b4d7), RTUINT128_INIT_C(0x00000000000004d4, 0xddb594d5c26f373b)
    },
    { /* i=1220; 123 / 119 */
        RTUINT128_INIT_C(0x024c0d1dbb85c862, 0x11e65bd567d6ed92), RTUINT128_INIT_C(0x0047ca8d05cf4e94, 0x83f060bb35616e4b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000008), RTUINT128_INIT_C(0x000db8b58d0b53bd, 0xf26355fbbccb7b3a)
    },
    { /* i=1221; 115 / 110 */
        RTUINT128_INIT_C(0x0005301f29ec57de, 0x492b1a3c7ffe1c0a), RTUINT128_INIT_C(0x0000179098b79706, 0x9c30f367b5ea45e3),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000038), RTUINT128_INIT_C(0x0000087dc1c34e6c, 0x1e75db8cb4bed262)
    },
    { /* i=1222; 94 / 31 */
        RTUINT128_INIT_C(0x000000002e12819f, 0xa07e1e9c7cdb2f15), RTUINT128_INIT_C(0x0000000000000000, 0x0000000018dc4be2),
        RTUINT128_INIT_C(0x0000000000000001, 0xda6d4b6a50823820), RTUINT128_INIT_C(0x0000000000000000, 0x0000000007f442d5)
    },
    { /* i=1223; 22 / 14 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000295687), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001645),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000001db), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000480)
    },
    { /* i=1224; 75 / 18 */
        RTUINT128_INIT_C(0x000000000000008a, 0x026ef8ca84765918), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000183d0),
        RTUINT128_INIT_C(0x0000000000000000, 0x005b1a1261ce6ba7), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000016c68)
    },
    { /* i=1225; 64 / 10 */
        RTUINT128_INIT_C(0x0000000000000000, 0x1160d1c3fc77b53b), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000a2),
        RTUINT128_INIT_C(0x0000000000000000, 0x001b763badce2bc9), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000009)
    },
    { /* i=1226; 81 / 28 */
        RTUINT128_INIT_C(0x000000000001edc5, 0xa089c73819c44dc7), RTUINT128_INIT_C(0x0000000000000000, 0x000000000edc170a),
        RTUINT128_INIT_C(0x0000000000000000, 0x00213a977c392527), RTUINT128_INIT_C(0x0000000000000000, 0x000000000dae5941)
    },
    { /* i=1227; 84 / 22 */
        RTUINT128_INIT_C(0x000000000005643b, 0x1dcf4e26370e3c37), RTUINT128_INIT_C(0x0000000000000000, 0x00000000002f0d78),
        RTUINT128_INIT_C(0x0000000000000000, 0x1d557287d859cad8), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000022ef7)
    },
    { /* i=1228; 113 / 110 */
        RTUINT128_INIT_C(0x000006fbfb74e475, 0xc3c14d37be60bed9), RTUINT128_INIT_C(0x00003a49ec0ac21c, 0x25f933396cebfbb4),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000006fbfb74e475, 0xc3c14d37be60bed9)
    },
    { /* i=1229; 83 / 32 */
        RTUINT128_INIT_C(0x0000000000051412, 0xfe7fcabcaa1a8d4e), RTUINT128_INIT_C(0x0000000000000000, 0x00000000e90acd25),
        RTUINT128_INIT_C(0x0000000000000000, 0x000594262a5fc42c), RTUINT128_INIT_C(0x0000000000000000, 0x000000002473f6f2)
    },
    { /* i=1230; 128 / 79 */
        RTUINT128_INIT_C(0x2cedc11ba2b83e4b, 0xc116b250b3477883), RTUINT128_INIT_C(0x0000000000005f38, 0x2f22e6a1555a7e7f),
        RTUINT128_INIT_C(0x0000000000000000, 0x000078cac366eeb1), RTUINT128_INIT_C(0x00000000000033bc, 0x2a8bf6cb6a81f0b4)
    },
    { /* i=1231; 119 / 38 */
        RTUINT128_INIT_C(0x0057e22c38ff7585, 0x175308129989ab72), RTUINT128_INIT_C(0x0000000000000000, 0x000000306ace5f1b),
        RTUINT128_INIT_C(0x000000000001d0ac, 0x4c36393e8fcd35d3), RTUINT128_INIT_C(0x0000000000000000, 0x000000219a21b131)
    },
    { /* i=1232; 19 / 58 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000539b), RTUINT128_INIT_C(0x0000000000000000, 0x00def38f72601e97),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000539b)
    },
    { /* i=1233; 113 / 105 */
        RTUINT128_INIT_C(0x000117d6bfa9cd6f, 0xb69a52c487f2b3a7), RTUINT128_INIT_C(0x000001af157e7c96, 0x1b0a36bdff88b324),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000a6), RTUINT128_INIT_C(0x0000004ecfa5041a, 0x2dfad390d54e8a4f)
    },
    { /* i=1234; 74 / 14 */
        RTUINT128_INIT_C(0x000000000000006d, 0xa2ca2968dc19384a), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000211d),
        RTUINT128_INIT_C(0x0000000000000000, 0x034f99632fe45721), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000188d)
    },
    { /* i=1235; 128 / 106 */
        RTUINT128_INIT_C(0x48622d5180938efc, 0x39f19f337a825621), RTUINT128_INIT_C(0x0000020d28ac165c, 0x10c3a3ceca2e207e),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000002348ef), RTUINT128_INIT_C(0x00000011130a7f92, 0x27f3e3f94f14907f)
    },
    { /* i=1236; 89 / 60 */
        RTUINT128_INIT_C(0x00000000004b8c39, 0xfc5f6bf47b473dcf), RTUINT128_INIT_C(0x0000000000000000, 0x0c0ff1d5918fcf5d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000006435d13), RTUINT128_INIT_C(0x0000000000000000, 0x00076bb9fbef10e8)
    },
    { /* i=1237; 110 / 15 */
        RTUINT128_INIT_C(0x00000513e133e6e9, 0x71bd5f92a62f49c2), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000003627),
        RTUINT128_INIT_C(0x0000000018010e6b, 0xa39ee6147d662424), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000003046)
    },
    { /* i=1238; 123 / 108 */
        RTUINT128_INIT_C(0x06180345e99a9df1, 0xba391d56a3fcba2b), RTUINT128_INIT_C(0x00000af977148259, 0x01c0b9c5362dfe0f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000008e26), RTUINT128_INIT_C(0x00000230dc41e5c2, 0x90922603163cb1f1)
    },
    { /* i=1239; 83 / 9 */
        RTUINT128_INIT_C(0x0000000000077823, 0x1c608eeacf583158), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000161),
        RTUINT128_INIT_C(0x000000000000056a, 0xb4a885d80da425d9), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000011f)
    },
    { /* i=1240; 61 / 3 */
        RTUINT128_INIT_C(0x0000000000000000, 0x052645d788caa650), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000005),
        RTUINT128_INIT_C(0x0000000000000000, 0x0107a79181c22143), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001)
    },
    { /* i=1241; 117 / 107 */
        RTUINT128_INIT_C(0x001d67fdaf2c0b1a, 0x174918bfa0ecf51a), RTUINT128_INIT_C(0x000005b20663cbed, 0x5527a71c30560273),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000529), RTUINT128_INIT_C(0x0000045ab634bf6d, 0xadabc84a351a51af)
    },
    { /* i=1242; 5 / 2 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=1243; 122 / 120 */
        RTUINT128_INIT_C(0x01aa503e85f19dcf, 0x7eff1fa33b1b0489), RTUINT128_INIT_C(0x00180eee54d5b4e2, 0x771abcd7fead33db),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000011), RTUINT128_INIT_C(0x0011526ae3c09ac5, 0x9638954b519a92fe)
    },
    { /* i=1244; 120 / 73 */
        RTUINT128_INIT_C(0x00332274e1e3f74a, 0xd1224c8f3238fc70), RTUINT128_INIT_C(0x00000000000000d3, 0x4145761675c79118),
        RTUINT128_INIT_C(0x0000000000000000, 0x00003df717742cab), RTUINT128_INIT_C(0x0000000000000024, 0x8f8e8cb1521af168)
    },
    { /* i=1245; 125 / 6 */
        RTUINT128_INIT_C(0x1c350594f3b5ea50, 0x00bb3113a19bda71), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000003f),
        RTUINT128_INIT_C(0x00729e909627757f, 0x3cf6c7e3ddfe690d), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000003e)
    },
    { /* i=1246; 123 / 54 */
        RTUINT128_INIT_C(0x020d3f9b51a24dcc, 0x303b3cc63672332e), RTUINT128_INIT_C(0x0000000000000000, 0x000ffd2c3652b484),
        RTUINT128_INIT_C(0x0000000000000020, 0xd9c7c420beafafd7), RTUINT128_INIT_C(0x0000000000000000, 0x000a3e7eaf5a5c52)
    },
    { /* i=1247; 55 / 21 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0016e08a3e86eba4), RTUINT128_INIT_C(0x0000000000000000, 0x000000000006acee),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000036d515412), RTUINT128_INIT_C(0x0000000000000000, 0x000000000002aae8)
    },
    { /* i=1248; 3 / 89 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000007), RTUINT128_INIT_C(0x00000000002f93b4, 0x40dcd2ef9c1b0c9b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000007)
    },
    { /* i=1249; 32 / 17 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000855d9289), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001f31),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000044695), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000504)
    },
    { /* i=1250; 119 / 73 */
        RTUINT128_INIT_C(0x0073d4ddef989826, 0xf30b1762b20bcee4), RTUINT128_INIT_C(0x000000000000002b, 0xa64b73135772eaad),
        RTUINT128_INIT_C(0x0000000000000000, 0x0002a756c721caa0), RTUINT128_INIT_C(0x0000000000000008, 0x6f919cf0a1bfa0c4)
    },
    { /* i=1251; 127 / 117 */
        RTUINT128_INIT_C(0x76be98dd040004fe, 0x1a8521c47a490d1d), RTUINT128_INIT_C(0x000ad06ab79abf48, 0x2f3007a7017d32b8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000afb), RTUINT128_INIT_C(0x0000150ef3cda75f, 0xf6211af7208d22b5)
    },
    { /* i=1252; 118 / 109 */
        RTUINT128_INIT_C(0x00240d24542990a3, 0x094be21022da5e3f), RTUINT128_INIT_C(0x000014cb98e361d5, 0x21552b4189568fa4),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000001bb), RTUINT128_INIT_C(0x000010d2c2af44d2, 0x5aea07a77a0fcd73)
    },
    { /* i=1253; 117 / 70 */
        RTUINT128_INIT_C(0x001ffebfc76b0514, 0x3590b2319e133aa5), RTUINT128_INIT_C(0x0000000000000002, 0xb93fde40059c86ae),
        RTUINT128_INIT_C(0x0000000000000000, 0x000bbf4a60b43505), RTUINT128_INIT_C(0x0000000000000000, 0xe5fab4ec27ca933f)
    },
    { /* i=1254; 82 / 79 */
        RTUINT128_INIT_C(0x000000000003b0f2, 0xa0991daf5af25531), RTUINT128_INIT_C(0x0000000000001a17, 0x79f5a063ea355556),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000024), RTUINT128_INIT_C(0x00000000000005a5, 0x7a0e8fa26b725519)
    },
    { /* i=1255; 120 / 63 */
        RTUINT128_INIT_C(0x00009677e7bf47c3, 0x500463d70ad4498a), RTUINT128_INIT_C(0x0000000000000000, 0x4edbc27fbb87d632),
        RTUINT128_INIT_C(0x0000000000000000, 0x0001e87813626422), RTUINT128_INIT_C(0x0000000000000000, 0x370e13495dfa4ee6)
    },
    { /* i=1256; 128 / 106 */
        RTUINT128_INIT_C(0xbb6d5e65cb3f3866, 0xf54e6f23dae95f87), RTUINT128_INIT_C(0x000002f2b0921330, 0xbeef29154e6aebec),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000003f93de), RTUINT128_INIT_C(0x0000009a128e99a2, 0xf113465265a444df)
    },
    { /* i=1257; 125 / 73 */
        RTUINT128_INIT_C(0x08a9c68919821489, 0xd30b9d9c3bdc35d1), RTUINT128_INIT_C(0x0000000000000105, 0x9c52c578338208ca),
        RTUINT128_INIT_C(0x0000000000000000, 0x00087a36430a0d78), RTUINT128_INIT_C(0x0000000000000017, 0x101cc8a94691d521)
    },
    { /* i=1258; 114 / 120 */
        RTUINT128_INIT_C(0x0003c4db565ab199, 0xd6e31edbd745809e), RTUINT128_INIT_C(0x002cad4546898658, 0x1d17044be399a522),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0003c4db565ab199, 0xd6e31edbd745809e)
    },
    { /* i=1259; 116 / 89 */
        RTUINT128_INIT_C(0x000ce273e6432472, 0x2b751d3ee13f2ab2), RTUINT128_INIT_C(0x0000000001e0c417, 0x07319299ed3a1ea9),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000006dc5f3b), RTUINT128_INIT_C(0x0000000000bc0f6e, 0x85c9fa12543d62bf)
    },
    { /* i=1260; 29 / 21 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000006db0c38), RTUINT128_INIT_C(0x0000000000000000, 0x00000000001d0f53),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000003c), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000b74c4)
    },
    { /* i=1261; 119 / 91 */
        RTUINT128_INIT_C(0x003f7743518d999f, 0x313197f385ff7cb5), RTUINT128_INIT_C(0x0000000001fb82f0, 0x55f6b72a7415261c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000020037a71), RTUINT128_INIT_C(0x0000000001926bc8, 0x37fe81e1422c5259)
    },
    { /* i=1262; 116 / 36 */
        RTUINT128_INIT_C(0x000907f6f7bffd65, 0x516174e208b5bc44), RTUINT128_INIT_C(0x0000000000000000, 0x000000055493d956),
        RTUINT128_INIT_C(0x000000000001b1bb, 0xc59314b79fe67afd), RTUINT128_INIT_C(0x0000000000000000, 0x000000034fc0f646)
    },
    { /* i=1263; 124 / 99 */
        RTUINT128_INIT_C(0x016eb26ed4cd7c9c, 0xfe786ef5b3bc19c3), RTUINT128_INIT_C(0x000000041e29afee, 0xd918d8cb38bda50e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000590d19), RTUINT128_INIT_C(0x000000019ac2b3a0, 0x2962374d25f74565)
    },
    { /* i=1264; 80 / 93 */
        RTUINT128_INIT_C(0x000000000000d8f6, 0x3609138f4004d960), RTUINT128_INIT_C(0x000000001b03f118, 0x6d7a53622d53f72b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000000000000d8f6, 0x3609138f4004d960)
    },
    { /* i=1265; 106 / 99 */
        RTUINT128_INIT_C(0x000001d5b9ec4f7a, 0xf876a6c02bdfd98e), RTUINT128_INIT_C(0x000000055d5f184d, 0x6c819ec37056739b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000057), RTUINT128_INIT_C(0x00000002fe9b0d2b, 0x1869b254fe7e8fe1)
    },
    { /* i=1266; 116 / 51 */
        RTUINT128_INIT_C(0x000baf20124c1c32, 0xfadf82c394602e9a), RTUINT128_INIT_C(0x0000000000000000, 0x00008b8996b927b1),
        RTUINT128_INIT_C(0x0000000000000015, 0x6f9ddeadf6445a9f), RTUINT128_INIT_C(0x0000000000000000, 0x000033623e684dab)
    },
    { /* i=1267; 116 / 24 */
        RTUINT128_INIT_C(0x000f5ae335b0a4f9, 0xcbdced057aab5c91), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000a592ea),
        RTUINT128_INIT_C(0x0000000017bdb160, 0x68c53286aa92d8ec), RTUINT128_INIT_C(0x0000000000000000, 0x00000000009e7cd9)
    },
    { /* i=1268; 120 / 117 */
        RTUINT128_INIT_C(0x00a1763f428d2e32, 0x97d686bac5bb8da0), RTUINT128_INIT_C(0x0009169ba5f3c32a, 0xafe607acbd67c3ea),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000011), RTUINT128_INIT_C(0x0006f5e93d5d385c, 0xe990044231d78b16)
    },
    { /* i=1269; 114 / 107 */
        RTUINT128_INIT_C(0x0000243404f0f2fc, 0xd901b3f09f20551c), RTUINT128_INIT_C(0x00000716d2e6cb8e, 0x0fb900ead972f517),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000005), RTUINT128_INIT_C(0x000000c1e66ef936, 0x8a64af5a5fe18ba9)
    },
    { /* i=1270; 26 / 17 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000003b70aba), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000012760),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000338), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000004dba)
    },
    { /* i=1271; 126 / 42 */
        RTUINT128_INIT_C(0x13fabe6530acf354, 0xb691a2dbf83d7f07), RTUINT128_INIT_C(0x0000000000000000, 0x00000264ecb03068),
        RTUINT128_INIT_C(0x0000000000085845, 0xf8a5664b681796da), RTUINT128_INIT_C(0x0000000000000000, 0x00000044947f5677)
    },
    { /* i=1272; 120 / 80 */
        RTUINT128_INIT_C(0x00038edba285a59d, 0xf303a63dcdfdc3d5), RTUINT128_INIT_C(0x000000000000fc3a, 0x75a1d74df0ddfb4c),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000039c7a6fba), RTUINT128_INIT_C(0x000000000000d5e5, 0x628c6b5c7a873a9d)
    },
    { /* i=1273; 115 / 21 */
        RTUINT128_INIT_C(0x0004d9a16d8dcda2, 0x24cbc946c0dfc822), RTUINT128_INIT_C(0x0000000000000000, 0x00000000001640b8),
        RTUINT128_INIT_C(0x0000000037cbecb7, 0xe5196a2e5baef5b6), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000dad52)
    },
    { /* i=1274; 115 / 66 */
        RTUINT128_INIT_C(0x0000458313da0bf0, 0x71204ba626ebf42b), RTUINT128_INIT_C(0x0000000000000003, 0x0189b2d475ee6372),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000171fd69b6bb3), RTUINT128_INIT_C(0x0000000000000002, 0x3c137c878ba5c575)
    },
    { /* i=1275; 125 / 76 */
        RTUINT128_INIT_C(0x051837068873e0e2, 0x3fb4a3110b7e23aa), RTUINT128_INIT_C(0x0000000000000a3a, 0x584dc2abfcf2f504),
        RTUINT128_INIT_C(0x0000000000000000, 0x00007f83ea561347), RTUINT128_INIT_C(0x0000000000000796, 0x69d376f7e494e38e)
    },
    { /* i=1276; 119 / 121 */
        RTUINT128_INIT_C(0x005e87fe4a9970bf, 0x793e08c5c93b5926), RTUINT128_INIT_C(0x01efc622782d1e83, 0x134938fb577c8616),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x005e87fe4a9970bf, 0x793e08c5c93b5926)
    },
    { /* i=1277; 120 / 94 */
        RTUINT128_INIT_C(0x0094dec5423c9e7b, 0xcabfc5fee09a9fd8), RTUINT128_INIT_C(0x0000000037ee7447, 0x96fee3298cdf663d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000002a96227), RTUINT128_INIT_C(0x0000000021f4d3bb, 0xed6d8475ed29b28d)
    },
    { /* i=1278; 126 / 91 */
        RTUINT128_INIT_C(0x046472954fc9851b, 0x0491684509fb5226), RTUINT128_INIT_C(0x0000000006abb644, 0x5ec98d09e76c9164),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000a8905b6e), RTUINT128_INIT_C(0x00000000038d501a, 0xcf62dc4499664d2e)
    },
    { /* i=1279; 122 / 50 */
        RTUINT128_INIT_C(0x00d7e4f1be476f8b, 0x1762f7f2fbe378ae), RTUINT128_INIT_C(0x0000000000000000, 0x00015f233e64a0e0),
        RTUINT128_INIT_C(0x000000000000009d, 0x664f0e75034746b1), RTUINT128_INIT_C(0x0000000000000000, 0x00014b5a1632fdce)
    },
    { /* i=1280; 43 / 4 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000007370abe70fe), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000008),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000e6e157ce1f), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000006)
    },
    { /* i=1281; 111 / 61 */
        RTUINT128_INIT_C(0x00006e4021ca877e, 0xc4a049df3fa17430), RTUINT128_INIT_C(0x0000000000000000, 0x11b29d91ba1802e7),
        RTUINT128_INIT_C(0x0000000000000000, 0x00063aca19226086), RTUINT128_INIT_C(0x0000000000000000, 0x047f7a0fe44b4f46)
    },
    { /* i=1282; 46 / 112 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000c5a121b317d), RTUINT128_INIT_C(0x0000bac50f76313d, 0x4b6fe0135bad40bf),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00000c5a121b317d)
    },
    { /* i=1283; 125 / 120 */
        RTUINT128_INIT_C(0x0eb8185cb4b5af9d, 0xc413567a4ae381db), RTUINT128_INIT_C(0x00642f05bdcc2709, 0x9698c668aa6a1525),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000025), RTUINT128_INIT_C(0x003d4c8846340b3a, 0xfffea959a98e7382)
    },
    { /* i=1284; 127 / 50 */
        RTUINT128_INIT_C(0x61a0abca156b3774, 0xf805132a4f06e026), RTUINT128_INIT_C(0x0000000000000000, 0x0002e84c9ebc6751),
        RTUINT128_INIT_C(0x0000000000002194, 0x2bb12ffeb8a5b472), RTUINT128_INIT_C(0x0000000000000000, 0x0002a6605746ea14)
    },
    { /* i=1285; 47 / 12 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00007f8a1cae1a6d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000b09),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000b8ebc5e6f), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000386)
    },
    { /* i=1286; 116 / 64 */
        RTUINT128_INIT_C(0x0007473ea7a8fd76, 0xcbdc4c22c4b47d5e), RTUINT128_INIT_C(0x0000000000000000, 0x3024f8d074b2e395),
        RTUINT128_INIT_C(0x0000000000000000, 0x0026b37eecdbf30c), RTUINT128_INIT_C(0x0000000000000000, 0x1ebed26b71d46362)
    },
    { /* i=1287; 36 / 2 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000fbf2d4d15), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000053fb9c45c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001)
    },
    { /* i=1288; 120 / 88 */
        RTUINT128_INIT_C(0x001e6281fd81e570, 0x7eed2bd27a0fad8c), RTUINT128_INIT_C(0x0000000000e02c15, 0x58a8b3272adb2edb),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000022b2e4f8), RTUINT128_INIT_C(0x00000000007620b4, 0x9703d31615b93d64)
    },
    { /* i=1289; 125 / 67 */
        RTUINT128_INIT_C(0x0a9eae44a8f8ecc4, 0xb5763ed7cabcd1f6), RTUINT128_INIT_C(0x0000000000000007, 0x02d0d1e24a5642ed),
        RTUINT128_INIT_C(0x0000000000000000, 0x0183c60f19939a12), RTUINT128_INIT_C(0x0000000000000005, 0x073a064219528b4c)
    },
    { /* i=1290; 127 / 70 */
        RTUINT128_INIT_C(0x5a38adc48a338dca, 0xbbde050241cb65e6), RTUINT128_INIT_C(0x0000000000000027, 0x3b3b1db53a4649dd),
        RTUINT128_INIT_C(0x0000000000000000, 0x024cbad703f813a1), RTUINT128_INIT_C(0x000000000000001e, 0x86ee01253f038ae9)
    },
    { /* i=1291; 116 / 39 */
        RTUINT128_INIT_C(0x0004c1e3b3b068fb, 0x8c3cb36e76ef116e), RTUINT128_INIT_C(0x0000000000000000, 0x00000060f547bbdd),
        RTUINT128_INIT_C(0x0000000000000c8f, 0x9ca49c7b1f96879c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000954a90bc2)
    },
    { /* i=1292; 114 / 94 */
        RTUINT128_INIT_C(0x00000a4e4dfdc2e1, 0x33b3683799b98e0a), RTUINT128_INIT_C(0x000000002bcf82d5, 0xe5e04d2bd645ac09),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000003c38), RTUINT128_INIT_C(0x0000000015ef0236, 0x588c40686629d012)
    },
    { /* i=1293; 99 / 23 */
        RTUINT128_INIT_C(0x000000003ca8f375, 0xb4a81c9f3cc34aca), RTUINT128_INIT_C(0x0000000000000000, 0x00000000001d12f0),
        RTUINT128_INIT_C(0x0000000000000216, 0x1e5d78a3b4fae4e0), RTUINT128_INIT_C(0x0000000000000000, 0x000000000014f8ca)
    },
    { /* i=1294; 117 / 119 */
        RTUINT128_INIT_C(0x00075e4c8f36b39a, 0xa39f663f707d4950), RTUINT128_INIT_C(0x0012499aeafacef1, 0xb726e2aec08f98d9),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00075e4c8f36b39a, 0xa39f663f707d4950)
    },
    { /* i=1295; 84 / 24 */
        RTUINT128_INIT_C(0x000000000005eadd, 0x151fc998ba0bae41), RTUINT128_INIT_C(0x0000000000000000, 0x000000000058088b),
        RTUINT128_INIT_C(0x0000000000000000, 0x1135349615f2ac4b), RTUINT128_INIT_C(0x0000000000000000, 0x00000000001dc988)
    },
    { /* i=1296; 32 / 3 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000063ae2663), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000005),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000013efa147), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=1297; 42 / 10 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000038281c672b0), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000003e4),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000e6f108da), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000288)
    },
    { /* i=1298; 12 / 113 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000778), RTUINT128_INIT_C(0x00004275805630af, 0x7246c718240f4939),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000778)
    },
    { /* i=1299; 123 / 119 */
        RTUINT128_INIT_C(0x07b648eda5f8c149, 0xf4fa54ea02b0d4ee), RTUINT128_INIT_C(0x007d131760f6a226, 0x4896a7956769be0e),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000f), RTUINT128_INIT_C(0x00622a8ef785410b, 0xb4268328f37eb21c)
    },
    { /* i=1300; 121 / 37 */
        RTUINT128_INIT_C(0x004f715f5247b96c, 0x5ac5b444fc13481a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000fc5d92885),
        RTUINT128_INIT_C(0x0000000000050964, 0x3a9be6f451556476), RTUINT128_INIT_C(0x0000000000000000, 0x000000066cfda6cc)
    },
    { /* i=1301; 117 / 19 */
        RTUINT128_INIT_C(0x000808c966177108, 0x6d98d623efc2ffb3), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000067631),
        RTUINT128_INIT_C(0x000000013e4e149b, 0xa08a7a713413f615), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000537ae)
    },
    { /* i=1302; 123 / 13 */
        RTUINT128_INIT_C(0x05a590d278f19e0b, 0x206ae761d3e587f1), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001793),
        RTUINT128_INIT_C(0x00003d51dc8ebd00, 0xfa3c81ed0e089075), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000011c2)
    },
    { /* i=1303; 117 / 7 */
        RTUINT128_INIT_C(0x00140e9dde40b751, 0xa338d6cf7388b958), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000007),
        RTUINT128_INIT_C(0x0002dd8444526354, 0xce2cb0f910813f0c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000004)
    },
    { /* i=1304; 116 / 90 */
        RTUINT128_INIT_C(0x00080f8bcad7620f, 0x02bddfdcb5b318c7), RTUINT128_INIT_C(0x0000000000db0f9a, 0x1c6369dd0ec8e0e3),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000096b82b6), RTUINT128_INIT_C(0x0000000000c4abce, 0x53641d5436cef165)
    },
    { /* i=1305; 65 / 7 */
        RTUINT128_INIT_C(0x0000000000000000, 0x6981da2f45a873f1), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000003c),
        RTUINT128_INIT_C(0x0000000000000000, 0x01c22a09523a4632), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000039)
    },
    { /* i=1306; 92 / 91 */
        RTUINT128_INIT_C(0x000000000b704a12, 0xd72b9090570cd212), RTUINT128_INIT_C(0x0000000006937795, 0x5b49b8234adb3dad),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x0000000004dcd27d, 0x7be1d86d0c319465)
    },
    { /* i=1307; 119 / 83 */
        RTUINT128_INIT_C(0x005585321a975302, 0x466d47d1ed21c99a), RTUINT128_INIT_C(0x000000000001a7c9, 0x9b01e751ba909a27),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000033a929283a), RTUINT128_INIT_C(0x000000000000a4d1, 0xb0cb0d75a109c4c4)
    },
    { /* i=1308; 124 / 113 */
        RTUINT128_INIT_C(0x0527e1afc164fb1f, 0xe1f3756c9660ca79), RTUINT128_INIT_C(0x00012ee3179874a1, 0x2fa9730968d7a886),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000045b), RTUINT128_INIT_C(0x0000aa97fc610115, 0x4aeb6b70f315cad7)
    },
    { /* i=1309; 42 / 19 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000003ec2e9e7c0c), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000479ff),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000e05217), RTUINT128_INIT_C(0x0000000000000000, 0x000000000003d823)
    },
    { /* i=1310; 126 / 66 */
        RTUINT128_INIT_C(0x15325d8ef923ccdf, 0x6c8a41c08655b2da), RTUINT128_INIT_C(0x0000000000000001, 0x4347ac1ed7afcf16),
        RTUINT128_INIT_C(0x0000000000000000, 0x10c90c4ba8f84d18), RTUINT128_INIT_C(0x0000000000000001, 0x2d23d2535f40aaca)
    },
    { /* i=1311; 114 / 101 */
        RTUINT128_INIT_C(0x00021df4b8b21419, 0xd51ff9fda7a879d9), RTUINT128_INIT_C(0x0000001280b8192e, 0x9f56ed0c38b5c87c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001d4a), RTUINT128_INIT_C(0x00000006a8a08492, 0xed251208ab667a01)
    },
    { /* i=1312; 7 / 103 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00000007cfb0dd68, 0x82cbd16c39f2e1f5),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=1313; 124 / 113 */
        RTUINT128_INIT_C(0x0ea38d7a1f5e3ce9, 0x77872760181fb1ba), RTUINT128_INIT_C(0x000193877e60986f, 0x57d1799b43c19df3),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000949), RTUINT128_INIT_C(0x0000b865b076db13, 0x0f8504b7f75c1c6f)
    },
    { /* i=1314; 84 / 58 */
        RTUINT128_INIT_C(0x00000000000d866a, 0x45800ca189b4502b), RTUINT128_INIT_C(0x0000000000000000, 0x00fc5cdd8a80aec5),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000db8516e), RTUINT128_INIT_C(0x0000000000000000, 0x0069f73fb084e285)
    },
    { /* i=1315; 113 / 91 */
        RTUINT128_INIT_C(0x0000d61b6f325142, 0xd4d8ccacb60b7b1f), RTUINT128_INIT_C(0x00000000037b5a26, 0xcff30633ed6471c0),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000003d7e11), RTUINT128_INIT_C(0x000000000262ad6c, 0xee48437367a36d5f)
    },
    { /* i=1316; 125 / 105 */
        RTUINT128_INIT_C(0x0f32d9768bb42346, 0xb1a73181b76441ba), RTUINT128_INIT_C(0x0000009ef07ac5a2, 0x7536b5e483e008a4),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000187ae6), RTUINT128_INIT_C(0x0000008d73fc2a54, 0x42648259a89e5662)
    },
    { /* i=1317; 116 / 127 */
        RTUINT128_INIT_C(0x000c48cd2c2a6646, 0x31d882b73d786a2a), RTUINT128_INIT_C(0x705275dbe8664c26, 0x38f54b8ec8b3aa66),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000c48cd2c2a6646, 0x31d882b73d786a2a)
    },
    { /* i=1318; 116 / 87 */
        RTUINT128_INIT_C(0x000eb27651cd0340, 0x58f7b3541b5c36f9), RTUINT128_INIT_C(0x000000000012ddd6, 0xce704d2053622253),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000c76cc82e), RTUINT128_INIT_C(0x000000000000f20a, 0xda14204b74e5340f)
    },
    { /* i=1319; 65 / 32 */
        RTUINT128_INIT_C(0x0000000000000001, 0xce61c93433d12620), RTUINT128_INIT_C(0x0000000000000000, 0x0000000038553878),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000008354156e9), RTUINT128_INIT_C(0x0000000000000000, 0x000000001ed070e8)
    },
    { /* i=1320; 113 / 61 */
        RTUINT128_INIT_C(0x0001c15643231e11, 0xe0aa7ee6cdb2c503), RTUINT128_INIT_C(0x0000000000000000, 0x09c0699fc8e4989e),
        RTUINT128_INIT_C(0x0000000000000000, 0x002e140694b318fc), RTUINT128_INIT_C(0x0000000000000000, 0x04d1ff018fe3b97b)
    },
    { /* i=1321; 64 / 9 */
        RTUINT128_INIT_C(0x0000000000000000, 0x59e9b4a82ac8f043), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000012e),
        RTUINT128_INIT_C(0x0000000000000000, 0x004c37b291f16836), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000008f)
    },
    { /* i=1322; 120 / 105 */
        RTUINT128_INIT_C(0x00d1438a303edd02, 0xb99e9e0aa7b9335a), RTUINT128_INIT_C(0x000000d212c50c68, 0xf55d613e2c82aeaa),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000ff03), RTUINT128_INIT_C(0x00000061b0932b5f, 0xd5a98bf9f635d15c)
    },
    { /* i=1323; 70 / 63 */
        RTUINT128_INIT_C(0x0000000000000005, 0x3b06d0928ffd75c6), RTUINT128_INIT_C(0x0000000000000000, 0x5d6052a1326ce438),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000e), RTUINT128_INIT_C(0x0000000000000000, 0x1fc24bc1ce08fab6)
    },
    { /* i=1324; 127 / 115 */
        RTUINT128_INIT_C(0x42f506082098510c, 0x27c69833692fcf9f), RTUINT128_INIT_C(0x0003a75032dd0f6f, 0xf7f5d26bcec8abd3),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001253), RTUINT128_INIT_C(0x0002237417d6704f, 0x7a47cab5420b4436)
    },
    { /* i=1325; 114 / 96 */
        RTUINT128_INIT_C(0x0001636c23ecc99c, 0xf60a566799403011), RTUINT128_INIT_C(0x0000000012ab9195, 0x28a1cbdc62128420),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000130971), RTUINT128_INIT_C(0x0000000010014456, 0x3519534dda0ebdf1)
    },
    { /* i=1326; 79 / 39 */
        RTUINT128_INIT_C(0x000000000000669e, 0xc22b4c3ce561fb2e), RTUINT128_INIT_C(0x0000000000000000, 0x00000028823c6bb9),
        RTUINT128_INIT_C(0x0000000000000000, 0x000002888555bd89), RTUINT128_INIT_C(0x0000000000000000, 0x00000019b617c02d)
    },
    { /* i=1327; 126 / 99 */
        RTUINT128_INIT_C(0x1f27cd1827ccffd9, 0x0d97be6f4da72a7e), RTUINT128_INIT_C(0x00000005b6a94329, 0xabf1e571b8e0afee),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000573f3c3), RTUINT128_INIT_C(0x000000025e0a51bf, 0x2cd895f385983e34)
    },
    { /* i=1328; 59 / 86 */
        RTUINT128_INIT_C(0x0000000000000000, 0x032e4e4f7d6d5c51), RTUINT128_INIT_C(0x00000000003bf176, 0x3efc23b9acaefdfb),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x032e4e4f7d6d5c51)
    },
    { /* i=1329; 122 / 111 */
        RTUINT128_INIT_C(0x02aa1be5987f5eb6, 0x3263770fbdcf5572), RTUINT128_INIT_C(0x0000070f14746df7, 0xa04584469d2d0a17),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000060a1), RTUINT128_INIT_C(0x000003be120959e0, 0x5510cbb600b35cfb)
    },
    { /* i=1330; 107 / 17 */
        RTUINT128_INIT_C(0x0000053750054ef2, 0xe65bc143ce9ee018), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000012137),
        RTUINT128_INIT_C(0x00000000049df571, 0xe4f6e229c79053cf), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000002f9f)
    },
    { /* i=1331; 128 / 80 */
        RTUINT128_INIT_C(0x127a89ba27f96358, 0xf56817a12addae29), RTUINT128_INIT_C(0x000000000000cc44, 0xf9d5473b2b44b698),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000172887fb6198), RTUINT128_INIT_C(0x00000000000018eb, 0xd4cf88b141d9abe9)
    },
    { /* i=1332; 65 / 41 */
        RTUINT128_INIT_C(0x0000000000000000, 0x3a93b4ede2d92e03), RTUINT128_INIT_C(0x0000000000000000, 0x000001ca1ff074dc),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000020bb98), RTUINT128_INIT_C(0x0000000000000000, 0x00000187ab371763)
    },
    { /* i=1333; 122 / 100 */
        RTUINT128_INIT_C(0x02fbb6b66ee4bbdf, 0xb510d0cdf8cb17a8), RTUINT128_INIT_C(0x0000000b5f9f0cfe, 0x991ba9ab28cf9f20),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000004325fd), RTUINT128_INIT_C(0x000000068b3205e3, 0xfd68b769fc3b3508)
    },
    { /* i=1334; 128 / 73 */
        RTUINT128_INIT_C(0xf49a77ca27b4b140, 0x2cefe4b4ed4cb745), RTUINT128_INIT_C(0x0000000000000120, 0x33f7296281fc55ab),
        RTUINT128_INIT_C(0x0000000000000000, 0x00d945a8204aedf3), RTUINT128_INIT_C(0x0000000000000061, 0xd2a7fcfecc0a16f4)
    },
    { /* i=1335; 100 / 33 */
        RTUINT128_INIT_C(0x000000048a92e0b5, 0xb077eea09f1e9c96), RTUINT128_INIT_C(0x0000000000000000, 0x000000000cd6c701),
        RTUINT128_INIT_C(0x000000000000005a, 0x8ce47c751471ff9a), RTUINT128_INIT_C(0x0000000000000000, 0x000000000a3fe6fc)
    },
    { /* i=1336; 116 / 122 */
        RTUINT128_INIT_C(0x000850e7169e0508, 0x0ef977ed404cada8), RTUINT128_INIT_C(0x02cd61de3571c13b, 0x61fd63a7ec76498a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000850e7169e0508, 0x0ef977ed404cada8)
    },
    { /* i=1337; 72 / 62 */
        RTUINT128_INIT_C(0x00000000000000f9, 0xb1eba6f200a44c7d), RTUINT128_INIT_C(0x0000000000000000, 0x01fe82ea4b5626d0),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000007d36), RTUINT128_INIT_C(0x0000000000000000, 0x004fa2bd0b848c9d)
    },
    { /* i=1338; 17 / 13 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000001d2bd), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001a68),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000011), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000011d5)
    },
    { /* i=1339; 114 / 90 */
        RTUINT128_INIT_C(0x00034ca4430155a6, 0x3e44dbd13ce958fe), RTUINT128_INIT_C(0x0000000002d8ccbe, 0xc0f2888b22efbdf4),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000128b0de), RTUINT128_INIT_C(0x0000000001ad8b26, 0x4d3265f07c4adf66)
    },
    { /* i=1340; 81 / 16 */
        RTUINT128_INIT_C(0x0000000000012853, 0x3c6f5f7fe40cbad4), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000b204),
        RTUINT128_INIT_C(0x0000000000000001, 0xaa2358fff9872dee), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000871c)
    },
    { /* i=1341; 118 / 43 */
        RTUINT128_INIT_C(0x001d3050ac862c3e, 0xa13eb33c127c58eb), RTUINT128_INIT_C(0x0000000000000000, 0x000005e41dd3f7aa),
        RTUINT128_INIT_C(0x00000000000004f4, 0x6966eef1a098721f), RTUINT128_INIT_C(0x0000000000000000, 0x000003a4c497a755)
    },
    { /* i=1342; 55 / 36 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0050fa633c92cf86), RTUINT128_INIT_C(0x0000000000000000, 0x00000004255b5c2e),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000013882f), RTUINT128_INIT_C(0x0000000000000000, 0x00000000006a7314)
    },
    { /* i=1343; 116 / 102 */
        RTUINT128_INIT_C(0x0009a4daf71c1376, 0x8bd9e0c03a3eddee), RTUINT128_INIT_C(0x000000059c163d9e, 0x0a2ce1fc22aa6980),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000001b81a), RTUINT128_INIT_C(0x00000002e2f22fec, 0x5ee1918fcf9c26ee)
    },
    { /* i=1344; 55 / 89 */
        RTUINT128_INIT_C(0x0000000000000000, 0x003c972cfb3174c7), RTUINT128_INIT_C(0x0000000000aa36a7, 0x49c194ec2cb19efd),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x003c972cfb3174c7)
    },
    { /* i=1345; 127 / 44 */
        RTUINT128_INIT_C(0x7bf253217f887be0, 0x5ee7a16c18f2a206), RTUINT128_INIT_C(0x0000000000000000, 0x000008b8edbe2b84),
        RTUINT128_INIT_C(0x00000000000e35ce, 0x89f8ad1fd00081f8), RTUINT128_INIT_C(0x0000000000000000, 0x00000221b4caf626)
    },
    { /* i=1346; 123 / 73 */
        RTUINT128_INIT_C(0x053769fcae243256, 0xead647489dee8546), RTUINT128_INIT_C(0x0000000000000118, 0x6df4b08cb2eb94ec),
        RTUINT128_INIT_C(0x0000000000000000, 0x0004c31474ccf66c), RTUINT128_INIT_C(0x000000000000006d, 0x343bde592560e9b6)
    },
    { /* i=1347; 35 / 16 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000011e0d7277), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000012e3),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000f254c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000813)
    },
    { /* i=1348; 114 / 70 */
        RTUINT128_INIT_C(0x0002393ed4d994b8, 0x09db52a46c48df1e), RTUINT128_INIT_C(0x0000000000000006, 0x0ad354321ec5fa7d),
        RTUINT128_INIT_C(0x0000000000000000, 0x00005e35d38a1ee7), RTUINT128_INIT_C(0x0000000000000001, 0xbdf3f3c065e73253)
    },
    { /* i=1349; 122 / 95 */
        RTUINT128_INIT_C(0x0006f8ccfeda64ef, 0x1b6a551e1c51fe84), RTUINT128_INIT_C(0x0000000075aadb9b, 0xd000d45522f8f03b),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000f2b0d), RTUINT128_INIT_C(0x000000007428e208, 0xf6b8335571dee285)
    },
    { /* i=1350; 121 / 65 */
        RTUINT128_INIT_C(0x00138a22e4e8fff5, 0x887bd4ea3535dbdc), RTUINT128_INIT_C(0x0000000000000001, 0x38a1a02c4d0ce745),
        RTUINT128_INIT_C(0x0000000000000000, 0x001000074631a17c), RTUINT128_INIT_C(0x0000000000000000, 0x1f3fc967a34e7170)
    },
    { /* i=1351; 127 / 119 */
        RTUINT128_INIT_C(0x3bb76b93b2a60f8b, 0x44c34aa0d45b916f), RTUINT128_INIT_C(0x005d4f2b7f8c723b, 0x9bebc9383aa40c49),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000a3), RTUINT128_INIT_C(0x004e02e17c395396, 0xfda22bd37de7bef4)
    },
    { /* i=1352; 124 / 81 */
        RTUINT128_INIT_C(0x070969ebc1363a2b, 0xb0914c1a431714b2), RTUINT128_INIT_C(0x0000000000001d9b, 0x5236d87519b2e480),
        RTUINT128_INIT_C(0x0000000000000000, 0x00003cd841b666f1), RTUINT128_INIT_C(0x000000000000036a, 0x356b606cd7a2f832)
    },
    { /* i=1353; 116 / 61 */
        RTUINT128_INIT_C(0x00057bde103f33f4, 0x0dc9c54147c3c13d), RTUINT128_INIT_C(0x0000000000000000, 0x11ba1218adc2090a),
        RTUINT128_INIT_C(0x0000000000000000, 0x004f31c836df6e40), RTUINT128_INIT_C(0x0000000000000000, 0x05f060ae7ba932bd)
    },
    { /* i=1354; 79 / 77 */
        RTUINT128_INIT_C(0x000000000000467d, 0x6283d9f377136c77), RTUINT128_INIT_C(0x0000000000001504, 0x3faa67cd6d740f6b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003), RTUINT128_INIT_C(0x0000000000000770, 0xa384a28b2eb73e36)
    },
    { /* i=1355; 101 / 60 */
        RTUINT128_INIT_C(0x00000010c19cf18f, 0xa5e6fe0d276a8118), RTUINT128_INIT_C(0x0000000000000000, 0x0a1e7780a0662d77),
        RTUINT128_INIT_C(0x0000000000000000, 0x000001a7ea8e9519), RTUINT128_INIT_C(0x0000000000000000, 0x0893f74506f7cd79)
    },
    { /* i=1356; 121 / 127 */
        RTUINT128_INIT_C(0x0065de307e465369, 0x29d4d4855d517a65), RTUINT128_INIT_C(0x1bb20aa6443d04e4, 0x6a8f11adc6d8f789),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0065de307e465369, 0x29d4d4855d517a65)
    },
    { /* i=1357; 86 / 58 */
        RTUINT128_INIT_C(0x000000000001366c, 0xdc6b58fb439e708c), RTUINT128_INIT_C(0x0000000000000000, 0x015bce0af52cfb57),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000e47ca6), RTUINT128_INIT_C(0x0000000000000000, 0x0154130ea5395222)
    },
    { /* i=1358; 120 / 41 */
        RTUINT128_INIT_C(0x0027a14ce31e7d93, 0x0fa8b6686b6564a6), RTUINT128_INIT_C(0x0000000000000000, 0x000001189c4919ec),
        RTUINT128_INIT_C(0x0000000000002427, 0x85ec6a199776a2ab), RTUINT128_INIT_C(0x0000000000000000, 0x000000099d61bc02)
    },
    { /* i=1359; 50 / 34 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000276a198e1664), RTUINT128_INIT_C(0x0000000000000000, 0x00000003efc2a0b6),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000a03), RTUINT128_INIT_C(0x0000000000000000, 0x00000000afff1842)
    },
    { /* i=1360; 67 / 58 */
        RTUINT128_INIT_C(0x0000000000000002, 0x798e543549b11777), RTUINT128_INIT_C(0x0000000000000000, 0x0209e6527ba25fee),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000136), RTUINT128_INIT_C(0x0000000000000000, 0x01916c539310ed43)
    },
    { /* i=1361; 53 / 87 */
        RTUINT128_INIT_C(0x0000000000000000, 0x001a4fa870770bbd), RTUINT128_INIT_C(0x000000000036a0ea, 0x0601c349d662c90e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x001a4fa870770bbd)
    },
    { /* i=1362; 122 / 30 */
        RTUINT128_INIT_C(0x02d5ab87c6c842e7, 0x99ee69ab8c966660), RTUINT128_INIT_C(0x0000000000000000, 0x000000002dab20e8),
        RTUINT128_INIT_C(0x000000000fe3d439, 0xac264d0212452f32), RTUINT128_INIT_C(0x0000000000000000, 0x0000000007976110)
    },
    { /* i=1363; 126 / 108 */
        RTUINT128_INIT_C(0x00f0786fc96b0f7b, 0x52f7d73293163808), RTUINT128_INIT_C(0x0000023ef7c74805, 0x861bf8c4da1fda21),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000006b11), RTUINT128_INIT_C(0x000000b10a14f80f, 0xba220af4c6ccf0d7)
    },
    { /* i=1364; 113 / 11 */
        RTUINT128_INIT_C(0x00013943813c9364, 0x63965b7f03264181), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000003b1),
        RTUINT128_INIT_C(0x00000054dceb79ca, 0x327e209ad1689b90), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000002f1)
    },
    { /* i=1365; 118 / 29 */
        RTUINT128_INIT_C(0x003d76c0d41bf986, 0xb8de44d860dd7344), RTUINT128_INIT_C(0x0000000000000000, 0x000000001ad12d14),
        RTUINT128_INIT_C(0x00000000024abe50, 0x2173512369391d17), RTUINT128_INIT_C(0x0000000000000000, 0x0000000008832278)
    },
    { /* i=1366; 67 / 29 */
        RTUINT128_INIT_C(0x0000000000000006, 0x6fc81d05ec66a3e0), RTUINT128_INIT_C(0x0000000000000000, 0x000000001cb1b914),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000396cf03d55), RTUINT128_INIT_C(0x0000000000000000, 0x00000000198a6c3c)
    },
    { /* i=1367; 33 / 3 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000014b988727), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000005),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000004251b4a1), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002)
    },
    { /* i=1368; 65 / 13 */
        RTUINT128_INIT_C(0x0000000000000000, 0x1a6743d1734494cf), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000033c),
        RTUINT128_INIT_C(0x0000000000000000, 0x000829d22f718d2a), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000f7)
    },
    { /* i=1369; 127 / 47 */
        RTUINT128_INIT_C(0x3f7d3a890af84d18, 0xe0a5d36f83eca9b3), RTUINT128_INIT_C(0x0000000000000000, 0x00001d18568aec2c),
        RTUINT128_INIT_C(0x0000000000022e9f, 0xf474e8350b008e89), RTUINT128_INIT_C(0x0000000000000000, 0x000004264093de27)
    },
    { /* i=1370; 117 / 72 */
        RTUINT128_INIT_C(0x0003a76d34b3e05b, 0xc030294093706f6d), RTUINT128_INIT_C(0x00000000000000d2, 0xd89470ad5d8a3c16),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000046fc1066ee2), RTUINT128_INIT_C(0x0000000000000019, 0xb54463ee9b11f001)
    },
    { /* i=1371; 14 / 9 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000033d5), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000d8),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000003d), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000005d)
    },
    { /* i=1372; 72 / 11 */
        RTUINT128_INIT_C(0x0000000000000006, 0xac0658acef1a2c5f), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000005a4),
        RTUINT128_INIT_C(0x0000000000000000, 0x012ecec6ade7bae3), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000003f3)
    },
    { /* i=1373; 120 / 67 */
        RTUINT128_INIT_C(0x0089ee866e4f2aeb, 0x8d21a5b4b44d0742), RTUINT128_INIT_C(0x0000000000000003, 0x968a15eea9aecdab),
        RTUINT128_INIT_C(0x0000000000000000, 0x002671294f745c64), RTUINT128_INIT_C(0x0000000000000002, 0xaba40f6fa39f3c76)
    },
    { /* i=1374; 91 / 37 */
        RTUINT128_INIT_C(0x0000000005651551, 0x7bb43bba7b50fc7c), RTUINT128_INIT_C(0x0000000000000000, 0x00000012f8b50618),
        RTUINT128_INIT_C(0x0000000000000000, 0x0048cc38e6e616ca), RTUINT128_INIT_C(0x0000000000000000, 0x00000005a4641d8c)
    },
    { /* i=1375; 120 / 60 */
        RTUINT128_INIT_C(0x00f88e9744850462, 0x615a4ef045c80d99), RTUINT128_INIT_C(0x0000000000000000, 0x0821f5983137f081),
        RTUINT128_INIT_C(0x0000000000000000, 0x1e90164a84e27aac), RTUINT128_INIT_C(0x0000000000000000, 0x025bde8bb5b2fced)
    },
    { /* i=1376; 19 / 117 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000006bb58), RTUINT128_INIT_C(0x000250c3bb828d1c, 0x3dc3b8d10449765b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000000000006bb58)
    },
    { /* i=1377; 111 / 40 */
        RTUINT128_INIT_C(0x000064397f2f0513, 0xaf27f7fa94c22ea2), RTUINT128_INIT_C(0x0000000000000000, 0x0000006b94c05e1f),
        RTUINT128_INIT_C(0x00000000000000ee, 0x7e9afab256e68076), RTUINT128_INIT_C(0x0000000000000000, 0x00000002db2d4c58)
    },
    { /* i=1378; 104 / 52 */
        RTUINT128_INIT_C(0x000000c64f7371d1, 0xe4004dc176c2e011), RTUINT128_INIT_C(0x0000000000000000, 0x0007f1075bde8cc9),
        RTUINT128_INIT_C(0x0000000000000000, 0x0018f8a9b4142e8c), RTUINT128_INIT_C(0x0000000000000000, 0x0007da27e80dc425)
    },
    { /* i=1379; 36 / 7 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000005b37a4df), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000047),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000148e57a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000009)
    },
    { /* i=1380; 121 / 110 */
        RTUINT128_INIT_C(0x01427ff59c046e09, 0xf5280ccc4cbad39e), RTUINT128_INIT_C(0x0000026437f08722, 0xe7b4be66a83bea75),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000086da), RTUINT128_INIT_C(0x0000015612751508, 0x09942d51acfbedfc)
    },
    { /* i=1381; 128 / 34 */
        RTUINT128_INIT_C(0xc7a39b88b3720269, 0x2e970447ee6b7f9b), RTUINT128_INIT_C(0x0000000000000000, 0x00000002e87ad156),
        RTUINT128_INIT_C(0x0000000044a614bb, 0x3dc302760a42629e), RTUINT128_INIT_C(0x0000000000000000, 0x000000021a4f6087)
    },
    { /* i=1382; 120 / 119 */
        RTUINT128_INIT_C(0x004369184a9e1e58, 0x308f92b116b99106), RTUINT128_INIT_C(0x003b87dba3e3639c, 0x84cabb18570574df),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x0007e13ca6bababb, 0xabc4d798bfb41c27)
    },
    { /* i=1383; 120 / 27 */
        RTUINT128_INIT_C(0x009aa405cb821e87, 0xd223d938fcb86196), RTUINT128_INIT_C(0x0000000000000000, 0x0000000005db277f),
        RTUINT128_INIT_C(0x000000001a682ad6, 0x0a4a97e2489619a2), RTUINT128_INIT_C(0x0000000000000000, 0x0000000004c3fc38)
    },
    { /* i=1384; 125 / 100 */
        RTUINT128_INIT_C(0x07bb4afe789e8b82, 0x9eba22f0a328d44c), RTUINT128_INIT_C(0x0000000a55498c4f, 0x57f89ecb30aff454),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000bf8c3d), RTUINT128_INIT_C(0x000000043e2a1600, 0x380bda9e84f1ac48)
    },
    { /* i=1385; 113 / 109 */
        RTUINT128_INIT_C(0x0001971e07811cce, 0x50d08bf50c8d292f), RTUINT128_INIT_C(0x000017be3340be19, 0xeef237d06dd78568),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000011), RTUINT128_INIT_C(0x0000037ca0347d15, 0x72bad71dc13d4d47)
    },
    { /* i=1386; 103 / 53 */
        RTUINT128_INIT_C(0x0000001692005b56, 0x30f8f5128d4b6043), RTUINT128_INIT_C(0x0000000000000000, 0x0011953dd50f5cc4),
        RTUINT128_INIT_C(0x0000000000000000, 0x0001489d08d7084f), RTUINT128_INIT_C(0x0000000000000000, 0x000489544a0b9fc7)
    },
    { /* i=1387; 69 / 11 */
        RTUINT128_INIT_C(0x0000000000000007, 0x60f36034e72fc3df), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000227),
        RTUINT128_INIT_C(0x0000000000000000, 0x036da00018944c16), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000085)
    },
    { /* i=1388; 54 / 43 */
        RTUINT128_INIT_C(0x0000000000000000, 0x001a9a19b57b6c73), RTUINT128_INIT_C(0x0000000000000000, 0x0000007bcce76c53),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000003702), RTUINT128_INIT_C(0x0000000000000000, 0x0000001c6366becd)
    },
    { /* i=1389; 81 / 2 */
        RTUINT128_INIT_C(0x00000000000115d4, 0x0bdfd4733e910170), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003),
        RTUINT128_INIT_C(0x0000000000005c9c, 0x03f546d114db007a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002)
    },
    { /* i=1390; 128 / 114 */
        RTUINT128_INIT_C(0x28a9b42b17ba3523, 0x5df00c0530ad90f5), RTUINT128_INIT_C(0x00025fd6ec9981d0, 0x7e4a916578130e18),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001120), RTUINT128_INIT_C(0x0000739752eb22b0, 0xa0f6225cea5c35f5)
    },
    { /* i=1391; 118 / 118 */
        RTUINT128_INIT_C(0x001d0a153c28e212, 0x477f087fb5191e60), RTUINT128_INIT_C(0x000f5a44bbbd46b3, 0xd6de99d09edd907f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x000dafd0806b9b5e, 0x70a06eaf163b8de1)
    },
    { /* i=1392; 77 / 76 */
        RTUINT128_INIT_C(0x000000000000129c, 0x207aae1995c53fcd), RTUINT128_INIT_C(0x00000000000004eb, 0xd180ecd79d6da073),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003), RTUINT128_INIT_C(0x00000000000003d8, 0xabf7e792bd7c5e74)
    },
    { /* i=1393; 19 / 105 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000032829), RTUINT128_INIT_C(0x000000ca9a5e303c, 0x6633a3f0e7265af2),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000032829)
    },
    { /* i=1394; 28 / 15 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000e3a49bd), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000004250),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000036ed), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000005ad)
    },
    { /* i=1395; 16 / 9 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000005f95), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000e),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000006d3), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000b)
    },
    { /* i=1396; 120 / 76 */
        RTUINT128_INIT_C(0x00ed40a96da95cec, 0x4884c9503a6f973f), RTUINT128_INIT_C(0x0000000000000e17, 0x00ae274f307a1b29),
        RTUINT128_INIT_C(0x0000000000000000, 0x000010d6aa9e11b4), RTUINT128_INIT_C(0x0000000000000ce3, 0x3c9e9dbe0b78c56b)
    },
    { /* i=1397; 128 / 43 */
        RTUINT128_INIT_C(0x24021cdf4f744daa, 0x5b7627a9118e83e7), RTUINT128_INIT_C(0x0000000000000000, 0x000004b63b4f9562),
        RTUINT128_INIT_C(0x000000000007a45f, 0x0414edf4ab0c1af9), RTUINT128_INIT_C(0x0000000000000000, 0x00000477d5624395)
    },
    { /* i=1398; 103 / 65 */
        RTUINT128_INIT_C(0x0000003885db9772, 0x8ac31a40596d2407), RTUINT128_INIT_C(0x0000000000000001, 0xf17f0bf173b8e243),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000001d15da1616), RTUINT128_INIT_C(0x0000000000000001, 0xc8c4fbf75809f045)
    },
    { /* i=1399; 115 / 85 */
        RTUINT128_INIT_C(0x0006611ffefed958, 0x034e63b5ddf2d525), RTUINT128_INIT_C(0x0000000000188570, 0x999250256144fd2a),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000004299b3b9), RTUINT128_INIT_C(0x0000000000152e7c, 0x311d6a2f33f983cb)
    },
    { /* i=1400; 48 / 11 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00007e8969c075dc), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000005c9),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000015df66ce78), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000001a4)
    },
    { /* i=1401; 127 / 67 */
        RTUINT128_INIT_C(0x6fb70877be878b60, 0xb83a9861c7743dd7), RTUINT128_INIT_C(0x0000000000000003, 0x10fcba5eb8e390c1),
        RTUINT128_INIT_C(0x0000000000000000, 0x246eb72b98ac8697), RTUINT128_INIT_C(0x0000000000000000, 0xe28e7778c1c8d600)
    },
    { /* i=1402; 113 / 49 */
        RTUINT128_INIT_C(0x0001f68368adda51, 0xde28ce95ebf94b60), RTUINT128_INIT_C(0x0000000000000000, 0x00000ff1c51781e6),
        RTUINT128_INIT_C(0x000000000000001f, 0x843e4ab6bfb8e6c9), RTUINT128_INIT_C(0x0000000000000000, 0x00000a5b167fa9ca)
    },
    { /* i=1403; 122 / 65 */
        RTUINT128_INIT_C(0x03be800b5408f140, 0xa559414f35330737), RTUINT128_INIT_C(0x0000000000000001, 0x093c4032e27148dd),
        RTUINT128_INIT_C(0x0000000000000000, 0x039d202e29d0ab11), RTUINT128_INIT_C(0x0000000000000000, 0x59db283fe771918a)
    },
    { /* i=1404; 124 / 91 */
        RTUINT128_INIT_C(0x09fae7982e8f95cc, 0xe1f2f90c31814473), RTUINT128_INIT_C(0x00000000013f18ff, 0x587d4786961633f5),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000801b41f29), RTUINT128_INIT_C(0x0000000000a0b79e, 0x084ffad8fa644736)
    },
    { /* i=1405; 121 / 3 */
        RTUINT128_INIT_C(0x007f8c781a9e76e8, 0x5d050f3958589614), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000005),
        RTUINT128_INIT_C(0x0019827e6bb94afb, 0x45cdcfd844de846a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002)
    },
    { /* i=1406; 64 / 40 */
        RTUINT128_INIT_C(0x0000000000000000, 0x58ffa4031095c8b4), RTUINT128_INIT_C(0x0000000000000000, 0x0000001481e3e4ab),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000456ff38), RTUINT128_INIT_C(0x0000000000000000, 0x0000000328836e4c)
    },
    { /* i=1407; 100 / 44 */
        RTUINT128_INIT_C(0x000000086f9720f2, 0xf21edf1423eb6859), RTUINT128_INIT_C(0x0000000000000000, 0x0000012f52d0f94f),
        RTUINT128_INIT_C(0x0000000000000000, 0x071ea88d31a3fd2e), RTUINT128_INIT_C(0x0000000000000000, 0x00000070dfae8927)
    },
    { /* i=1408; 41 / 4 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000001d21d7caf02), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000001f13084fef), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001)
    },
    { /* i=1409; 100 / 51 */
        RTUINT128_INIT_C(0x000000046d5bc96d, 0x6dc05b6398386962), RTUINT128_INIT_C(0x0000000000000000, 0x00061bbb481eabf0),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000b98b104f2349), RTUINT128_INIT_C(0x0000000000000000, 0x0002e099c6e791f2)
    },
    { /* i=1410; 80 / 53 */
        RTUINT128_INIT_C(0x000000000000512f, 0xc0986bf3f99ce3ed), RTUINT128_INIT_C(0x0000000000000000, 0x001f85efade065d3),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000029350f9), RTUINT128_INIT_C(0x0000000000000000, 0x0017a6d79c5ee9b2)
    },
    { /* i=1411; 74 / 51 */
        RTUINT128_INIT_C(0x0000000000000313, 0x7b2c928720e52f4d), RTUINT128_INIT_C(0x0000000000000000, 0x000772fce9c55a95),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000069b6c3), RTUINT128_INIT_C(0x0000000000000000, 0x00044bbc9a0e41ce)
    },
    { /* i=1412; 69 / 120 */
        RTUINT128_INIT_C(0x0000000000000007, 0x358cd705a41e64c2), RTUINT128_INIT_C(0x00efaf78888827d7, 0xb2ef5f16150867e8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000007, 0x358cd705a41e64c2)
    },
    { /* i=1413; 116 / 68 */
        RTUINT128_INIT_C(0x000b0eb7b9ca1bb7, 0x9ab76dc4cfa998cd), RTUINT128_INIT_C(0x0000000000000006, 0x23d3879f6d44fbb7),
        RTUINT128_INIT_C(0x0000000000000000, 0x0001cd08700b99ff), RTUINT128_INIT_C(0x0000000000000003, 0x47dcc4d9dca57e84)
    },
    { /* i=1414; 90 / 39 */
        RTUINT128_INIT_C(0x0000000002065b2f, 0xcc616257b5a96cd1), RTUINT128_INIT_C(0x0000000000000000, 0x000000680a19cbb2),
        RTUINT128_INIT_C(0x0000000000000000, 0x0004fb784658a6f5), RTUINT128_INIT_C(0x0000000000000000, 0x000000389fb40f77)
    },
    { /* i=1415; 118 / 31 */
        RTUINT128_INIT_C(0x002bc9367a0e63a5, 0x24dbfea66e436e51), RTUINT128_INIT_C(0x0000000000000000, 0x0000000067e1cfd4),
        RTUINT128_INIT_C(0x00000000006be73a, 0xc7012a54fd6e892e), RTUINT128_INIT_C(0x0000000000000000, 0x000000001a5fa239)
    },
    { /* i=1416; 88 / 79 */
        RTUINT128_INIT_C(0x00000000006ce200, 0x63f4b9492f4f3739), RTUINT128_INIT_C(0x0000000000000d3f, 0x7da9068bd5f3caa3),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000838), RTUINT128_INIT_C(0x000000000000002f, 0x9ec6ec02c3a5cb91)
    },
    { /* i=1417; 124 / 87 */
        RTUINT128_INIT_C(0x056bc74ededed583, 0x9db6f2e89530c7d0), RTUINT128_INIT_C(0x000000000026a9a8, 0xd3c3f278b4176d38),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000023e4fc6d92), RTUINT128_INIT_C(0x00000000000011b9, 0x9b4f32668333a5e0)
    },
    { /* i=1418; 119 / 86 */
        RTUINT128_INIT_C(0x004ad0a16d2608f2, 0x82f65a463b37b160), RTUINT128_INIT_C(0x00000000000fd24a, 0x63e8eccdbba29d01),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000004ba8c6e3e), RTUINT128_INIT_C(0x00000000000b915a, 0x516b62ce53d33d22)
    },
    { /* i=1419; 86 / 50 */
        RTUINT128_INIT_C(0x0000000000326d53, 0xd26bc0b57e736faa), RTUINT128_INIT_C(0x0000000000000000, 0x0003b19040f2437a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000da70bc174), RTUINT128_INIT_C(0x0000000000000000, 0x000348c1ef8fe262)
    },
    { /* i=1420; 115 / 88 */
        RTUINT128_INIT_C(0x0003b15c58b2e552, 0xfffa4c1acde50e3c), RTUINT128_INIT_C(0x00000000000c1a11, 0xbcb516b351608aef),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000004e1dfd9d), RTUINT128_INIT_C(0x000000000001d385, 0x18608670ed4ea6a9)
    },
    { /* i=1421; 61 / 25 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0735cda568eb8789), RTUINT128_INIT_C(0x0000000000000000, 0x00000000007db84a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000eae8f3b66), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000050c0d)
    },
    { /* i=1422; 93 / 59 */
        RTUINT128_INIT_C(0x000000001fea3c52, 0x7b9e28dcb7831dfd), RTUINT128_INIT_C(0x0000000000000000, 0x000361303b94ecd8),
        RTUINT128_INIT_C(0x0000000000000000, 0x000009717c4144c7), RTUINT128_INIT_C(0x0000000000000000, 0x000165aa14fda215)
    },
    { /* i=1423; 115 / 65 */
        RTUINT128_INIT_C(0x000215722515631d, 0x8e9aa120a3022bf5), RTUINT128_INIT_C(0x0000000000000000, 0xba75a4511e7fb18c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0002dc6545c8509a), RTUINT128_INIT_C(0x0000000000000000, 0x3bd6d3f2f1559dbd)
    },
    { /* i=1424; 25 / 41 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000b4f399), RTUINT128_INIT_C(0x0000000000000000, 0x0000012a1e84ea42),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000b4f399)
    },
    { /* i=1425; 44 / 19 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000084ad0cbda29), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000020966),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000004124684), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000011d91)
    },
    { /* i=1426; 122 / 120 */
        RTUINT128_INIT_C(0x00de9cd0dfc2d948, 0x61cfb06a06a8b907), RTUINT128_INIT_C(0x001684924a8d4a14, 0x8c7ee8593ae2304a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000009), RTUINT128_INIT_C(0x0013f3ac40cb3e8f, 0x71598546f4b5066d)
    },
    { /* i=1427; 128 / 124 */
        RTUINT128_INIT_C(0x6660cc133c2251d7, 0xdb2d90c09e34f8a7), RTUINT128_INIT_C(0x0e7f30a672659271, 0x8baa506ebca025d8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000007), RTUINT128_INIT_C(0x00e677861b5b50bd, 0x09855db975d3efbf)
    },
    { /* i=1428; 114 / 126 */
        RTUINT128_INIT_C(0x00019ea2b656365a, 0x091dffb136708e2f), RTUINT128_INIT_C(0x3e92d972ff26a086, 0xcf98d24c2448464e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00019ea2b656365a, 0x091dffb136708e2f)
    },
    { /* i=1429; 115 / 126 */
        RTUINT128_INIT_C(0x000593590310b8ff, 0x95872e3676deb091), RTUINT128_INIT_C(0x2486aa04180c37d9, 0xda157d55e4ffc424),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000593590310b8ff, 0x95872e3676deb091)
    },
    { /* i=1430; 84 / 80 */
        RTUINT128_INIT_C(0x0000000000049f71, 0xab50464af942db64), RTUINT128_INIT_C(0x0000000000004105, 0xe010ab054879af01),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000012), RTUINT128_INIT_C(0x0000000000000d07, 0xea243febe0b48d52)
    },
    { /* i=1431; 125 / 69 */
        RTUINT128_INIT_C(0x1b983e3a0b5ccd12, 0xf087574f3acad8a5), RTUINT128_INIT_C(0x0000000000000001, 0x406ee83b02a6942c),
        RTUINT128_INIT_C(0x0000000000000000, 0x160bc0f11ff88315), RTUINT128_INIT_C(0x0000000000000001, 0x3444dd5fe6ae2d09)
    },
    { /* i=1432; 113 / 59 */
        RTUINT128_INIT_C(0x0000993ee09b6502, 0x4ea04fd41b7bb734), RTUINT128_INIT_C(0x0000000000000000, 0x06bed9e8bc4034d0),
        RTUINT128_INIT_C(0x0000000000000000, 0x0016b7d92831e61c), RTUINT128_INIT_C(0x0000000000000000, 0x04f5dc6339331074)
    },
    { /* i=1433; 113 / 9 */
        RTUINT128_INIT_C(0x0000d961d773bd54, 0x4132bead41e6664c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000136),
        RTUINT128_INIT_C(0x000000b383ff8c2c, 0x0a1eb7f1b1c2cec8), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000001c)
    },
    { /* i=1434; 116 / 51 */
        RTUINT128_INIT_C(0x0004e3ca68d637d7, 0x8229155264163b36), RTUINT128_INIT_C(0x0000000000000000, 0x0000b2d15ae8a9cb),
        RTUINT128_INIT_C(0x0000000000000007, 0x00183a7a939df681), RTUINT128_INIT_C(0x0000000000000000, 0x0000898a4f3099eb)
    },
    { /* i=1435; 58 / 44 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00ad45010c492eda), RTUINT128_INIT_C(0x0000000000000000, 0x000005776e13b18a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001fb2), RTUINT128_INIT_C(0x0000000000000000, 0x000001a2201806e6)
    },
    { /* i=1436; 7 / 2 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000003b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000003b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=1437; 73 / 58 */
        RTUINT128_INIT_C(0x0000000000000082, 0xcf68132624a6ea50), RTUINT128_INIT_C(0x0000000000000000, 0x03ef559da2316770),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000213e), RTUINT128_INIT_C(0x0000000000000000, 0x016805107e5a6d30)
    },
    { /* i=1438; 114 / 40 */
        RTUINT128_INIT_C(0x00011405331cb534, 0xd57bbcfd53c9e804), RTUINT128_INIT_C(0x0000000000000000, 0x000000b886df968b),
        RTUINT128_INIT_C(0x000000000000017e, 0xee8ada80437383ca), RTUINT128_INIT_C(0x0000000000000000, 0x000000077be2fd56)
    },
    { /* i=1439; 118 / 19 */
        RTUINT128_INIT_C(0x00200b8abfaa9fc5, 0xdd146fd881aca4ff), RTUINT128_INIT_C(0x0000000000000000, 0x000000000007c666),
        RTUINT128_INIT_C(0x000000041f1e67a0, 0xf9c72f0c0d835c47), RTUINT128_INIT_C(0x0000000000000000, 0x000000000005f6b5)
    },
    { /* i=1440; 44 / 20 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000f9cf9655ec8), RTUINT128_INIT_C(0x0000000000000000, 0x000000000002dcd8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000005743d50), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000e348)
    },
    { /* i=1441; 66 / 48 */
        RTUINT128_INIT_C(0x0000000000000000, 0x398a0902ff018970), RTUINT128_INIT_C(0x0000000000000000, 0x000036edd78f4268),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000010c2a), RTUINT128_INIT_C(0x0000000000000000, 0x00000853a7fbc460)
    },
    { /* i=1442; 33 / 20 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000011bf98ca3), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000570d5),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000003431), RTUINT128_INIT_C(0x0000000000000000, 0x000000000003afde)
    },
    { /* i=1443; 4 / 53 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000f), RTUINT128_INIT_C(0x0000000000000000, 0x001138fd306d9f5a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000f)
    },
    { /* i=1444; 58 / 13 */
        RTUINT128_INIT_C(0x0000000000000000, 0x013222ebdbe1f8e5), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000009a1),
        RTUINT128_INIT_C(0x0000000000000000, 0x00001fcb21528d3d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000088)
    },
    { /* i=1445; 69 / 6 */
        RTUINT128_INIT_C(0x0000000000000012, 0x6460d39ab528a5ed), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000b),
        RTUINT128_INIT_C(0x0000000000000001, 0xac08cd6b27bde089), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000a)
    },
    { /* i=1446; 118 / 110 */
        RTUINT128_INIT_C(0x002ad99f5ae7a511, 0x6882e2b03d8c0336), RTUINT128_INIT_C(0x00003a95ba32ebf6, 0xe825cf901c4897d5),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000bb), RTUINT128_INIT_C(0x00000e4057b547b5, 0xd4e4446b94851a9f)
    },
    { /* i=1447; 126 / 79 */
        RTUINT128_INIT_C(0x336b4af52359d607, 0x8ec3a9170e949c3d), RTUINT128_INIT_C(0x00000000000014d0, 0x4bd1345fefa6a21a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0002786f7473b14e), RTUINT128_INIT_C(0x0000000000001232, 0x86aebc953a0d3e51)
    },
    { /* i=1448; 97 / 52 */
        RTUINT128_INIT_C(0x00000001fed9b5b8, 0x6aa2b4bf917d9c70), RTUINT128_INIT_C(0x0000000000000000, 0x000b2c58254e5ff7),
        RTUINT128_INIT_C(0x0000000000000000, 0x00002db891549178), RTUINT128_INIT_C(0x0000000000000000, 0x0006f7b24c59b9a8)
    },
    { /* i=1449; 126 / 61 */
        RTUINT128_INIT_C(0x0ca7dba396cf4f77, 0x9d5c4d9e3f2c50f9), RTUINT128_INIT_C(0x0000000000000000, 0x00cd688f5da0860d),
        RTUINT128_INIT_C(0x000000000000000f, 0xc5d3978c3a97f460), RTUINT128_INIT_C(0x0000000000000000, 0x0053e0741f8aa819)
    },
    { /* i=1450; 84 / 71 */
        RTUINT128_INIT_C(0x000000000008fb3d, 0xc8de908acfe861fb), RTUINT128_INIT_C(0x0000000000000019, 0x75e59a84a75489bf),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000005a4e), RTUINT128_INIT_C(0x0000000000000009, 0x2496d94c1bb943c9)
    },
    { /* i=1451; 116 / 59 */
        RTUINT128_INIT_C(0x000a2865354ba253, 0x5ae8a688e3aa7705), RTUINT128_INIT_C(0x0000000000000000, 0x06c6a43664060c1d),
        RTUINT128_INIT_C(0x0000000000000000, 0x017fc4cdc1c05930), RTUINT128_INIT_C(0x0000000000000000, 0x02de78ac15921c95)
    },
    { /* i=1452; 125 / 93 */
        RTUINT128_INIT_C(0x039bebfe3d039e9f, 0xaecfb02c832b64d8), RTUINT128_INIT_C(0x0000000015b2888d, 0xa5e5593a0be0b539),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000002a9507ff), RTUINT128_INIT_C(0x0000000006c88add, 0xb52f7182b5355211)
    },
    { /* i=1453; 126 / 41 */
        RTUINT128_INIT_C(0x03aa84ba5ec16d94, 0xaf37fb17337de7d9), RTUINT128_INIT_C(0x0000000000000000, 0x0000007da7799708),
        RTUINT128_INIT_C(0x0000000000077814, 0x2b1cbfca61b3d12a), RTUINT128_INIT_C(0x0000000000000000, 0x00000030d2a59889)
    },
    { /* i=1454; 72 / 71 */
        RTUINT128_INIT_C(0x000000000000009a, 0x95481c1401955db5), RTUINT128_INIT_C(0x000000000000004b, 0xeaf6f745bf7dc95d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002), RTUINT128_INIT_C(0x0000000000000002, 0xbf5a2d888299cafb)
    },
    { /* i=1455; 120 / 7 */
        RTUINT128_INIT_C(0x00f64f6537b643fd, 0x0bc4762ff0c714a1), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000073),
        RTUINT128_INIT_C(0x0002244ecb0ef102, 0x334d65339deb7863), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000028)
    },
    { /* i=1456; 98 / 38 */
        RTUINT128_INIT_C(0x00000000b5855b53, 0xfebd6d4d5e4db737), RTUINT128_INIT_C(0x0000000000000000, 0x0000003ec9613410),
        RTUINT128_INIT_C(0x0000000000000000, 0x02e41d88bda0260b), RTUINT128_INIT_C(0x0000000000000000, 0x00000005ef661a87)
    },
    { /* i=1457; 38 / 24 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000039e1a80331), RTUINT128_INIT_C(0x0000000000000000, 0x000000000071fb33),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000008200), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000181d31)
    },
    { /* i=1458; 84 / 100 */
        RTUINT128_INIT_C(0x00000000000b08e1, 0xf81f29be3f01bcf6), RTUINT128_INIT_C(0x0000000e9ead39fa, 0xa24b1e7ee3898696),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00000000000b08e1, 0xf81f29be3f01bcf6)
    },
    { /* i=1459; 120 / 81 */
        RTUINT128_INIT_C(0x008099946ba69b14, 0xcf2a0efcd9ac4622), RTUINT128_INIT_C(0x000000000001d38d, 0xd3b9cc3c6fd08526),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000046699031f3), RTUINT128_INIT_C(0x0000000000008020, 0x06d5cbec51e19d10)
    },
    { /* i=1460; 45 / 17 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000145447299c79), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000a20a),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000201e0fc8), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000006ea9)
    },
    { /* i=1461; 104 / 93 */
        RTUINT128_INIT_C(0x000000b7d8f1867c, 0xb8fdbf48423256f2), RTUINT128_INIT_C(0x00000000168f317a, 0x6cfbf26dcb272417),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000826), RTUINT128_INIT_C(0x0000000006245ae8, 0xac0454a2e1424388)
    },
    { /* i=1462; 85 / 70 */
        RTUINT128_INIT_C(0x00000000000c8a1a, 0x000500e682c9f993), RTUINT128_INIT_C(0x000000000000000b, 0x873e21be39c4cc4e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000011674), RTUINT128_INIT_C(0x0000000000000003, 0x3f3923f89fc0b23b)
    },
    { /* i=1463; 120 / 114 */
        RTUINT128_INIT_C(0x00f66287283a0980, 0x030bf0600c2e5f73), RTUINT128_INIT_C(0x00025fc9757f806c, 0x5f4e61410ef67071),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000067), RTUINT128_INIT_C(0x0001d878e1ed5de5, 0xaa82cf33070721fc)
    },
    { /* i=1464; 118 / 90 */
        RTUINT128_INIT_C(0x000d1bae7e2df71c, 0xd9c6945a002ba754), RTUINT128_INIT_C(0x00000000024e835e, 0xedf6d922287cb778),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000005aec25e), RTUINT128_INIT_C(0x0000000000a039e7, 0x289502c693c75944)
    },
    { /* i=1465; 76 / 49 */
        RTUINT128_INIT_C(0x0000000000000e29, 0x6bd8c9f58eb925fb), RTUINT128_INIT_C(0x0000000000000000, 0x000042c0c8dc1ca7),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000364f9958), RTUINT128_INIT_C(0x0000000000000000, 0x000035ace4667d93)
    },
    { /* i=1466; 125 / 104 */
        RTUINT128_INIT_C(0x01cd7600c0a3ea66, 0xbb4d1e184ed2897b), RTUINT128_INIT_C(0x00000062d788e9fa, 0xf176eb54454490f5),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000004ab2e), RTUINT128_INIT_C(0x00000021e9d37a29, 0x3b6c759ccbd8d675)
    },
    { /* i=1467; 68 / 20 */
        RTUINT128_INIT_C(0x000000000000000e, 0x2c8eb52f18b398ca), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000064e42),
        RTUINT128_INIT_C(0x0000000000000000, 0x00023f70fcd61cc9), RTUINT128_INIT_C(0x0000000000000000, 0x000000000004eef8)
    },
    { /* i=1468; 118 / 86 */
        RTUINT128_INIT_C(0x001403c607134bf2, 0xd72efeb8700ed463), RTUINT128_INIT_C(0x000000000000aea3, 0xa05081eeece3e777),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000001d56d5dec0), RTUINT128_INIT_C(0x0000000000004581, 0x94ef783c92650923)
    },
    { /* i=1469; 20 / 10 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000ae969), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000297),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000436), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000018f)
    },
    { /* i=1470; 87 / 69 */
        RTUINT128_INIT_C(0x0000000000689e74, 0xad5496772a06ae95), RTUINT128_INIT_C(0x0000000000000011, 0x09ad2ab9a7408c3a),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000623f1), RTUINT128_INIT_C(0x0000000000000008, 0xe41e104f99babdfb)
    },
    { /* i=1471; 113 / 99 */
        RTUINT128_INIT_C(0x00007e2ae89a7205, 0x09b1836a793f667b), RTUINT128_INIT_C(0x0000000080e82592, 0x147a3f2d4683f2a2),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000fa8f), RTUINT128_INIT_C(0x00000000323ccd6c, 0x37b602433a98a9fd)
    },
    { /* i=1472; 24 / 59 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000003f2366), RTUINT128_INIT_C(0x0000000000000000, 0x05f63b235c4550a9),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00000000003f2366)
    },
    { /* i=1473; 20 / 13 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000cd81a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001c22),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000074), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000018b2)
    },
    { /* i=1474; 34 / 16 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000227f360ca), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000005059),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000006de99), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000002d99)
    },
    { /* i=1475; 120 / 36 */
        RTUINT128_INIT_C(0x002a9d6fb13e8587, 0xb3c0893a0d258cb6), RTUINT128_INIT_C(0x0000000000000000, 0x000000033eafef26),
        RTUINT128_INIT_C(0x00000000000d220d, 0xec904564b0f45c8a), RTUINT128_INIT_C(0x0000000000000000, 0x00000000f824fa3a)
    },
    { /* i=1476; 44 / 1 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000b04141aa135), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000b04141aa135), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=1477; 117 / 49 */
        RTUINT128_INIT_C(0x00006ff0de2a293c, 0x81266df6391812c7), RTUINT128_INIT_C(0x0000000000000000, 0x00009b58839fc3c9),
        RTUINT128_INIT_C(0x0000000000000000, 0xb878b562f503a20e), RTUINT128_INIT_C(0x0000000000000000, 0x00006aa3441b2bc9)
    },
    { /* i=1478; 79 / 14 */
        RTUINT128_INIT_C(0x0000000000002890, 0xd7481fa934fc08ad), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000027db),
        RTUINT128_INIT_C(0x0000000000000001, 0x0490009af38f6af6), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000e3b)
    },
    { /* i=1479; 124 / 17 */
        RTUINT128_INIT_C(0x052e9b15fd080d90, 0x7eaca6b2f814f58b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000015b61),
        RTUINT128_INIT_C(0x000003d1a3864a9f, 0x30df8584d6f49496), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000156b5)
    },
    { /* i=1480; 113 / 120 */
        RTUINT128_INIT_C(0x0001704147e7ec3d, 0x5486ca306e3810de), RTUINT128_INIT_C(0x0083ea8b80cc3f09, 0xa9d0f3d0ae08ac5e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0001704147e7ec3d, 0x5486ca306e3810de)
    },
    { /* i=1481; 115 / 79 */
        RTUINT128_INIT_C(0x0002e83fe2b80e79, 0x25882d7d8a1fbab8), RTUINT128_INIT_C(0x0000000000001291, 0x85184c2d271e9759),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000002814d8bd75), RTUINT128_INIT_C(0x0000000000000932, 0x7740fb6e6c4fda0b)
    },
    { /* i=1482; 128 / 50 */
        RTUINT128_INIT_C(0x91db834097aa893a, 0x934188a0dd5685de), RTUINT128_INIT_C(0x0000000000000000, 0x0000be512985eea3),
        RTUINT128_INIT_C(0x000000000000c432, 0x456bb27abbb3d79c), RTUINT128_INIT_C(0x0000000000000000, 0x000077a72755358a)
    },
    { /* i=1483; 119 / 73 */
        RTUINT128_INIT_C(0x00274fe29e5c6d90, 0x05031549ec7c85dd), RTUINT128_INIT_C(0x00000000000001d1, 0x651544bdf3bcc31f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000159fd8c73f9a), RTUINT128_INIT_C(0x0000000000000137, 0x66be846b03d18437)
    },
    { /* i=1484; 98 / 48 */
        RTUINT128_INIT_C(0x000000009fc13b16, 0x5114c28e0b617fe1), RTUINT128_INIT_C(0x0000000000000000, 0x00005d55f6184644),
        RTUINT128_INIT_C(0x0000000000000000, 0x0001b62c5040cbc5), RTUINT128_INIT_C(0x0000000000000000, 0x00003d8b99fb818d)
    },
    { /* i=1485; 43 / 14 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000006f08a63d3ca), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000010de),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000695342fb), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000e20)
    },
    { /* i=1486; 125 / 108 */
        RTUINT128_INIT_C(0x1f7c05797644cf9e, 0xaef2bdf06d5ee00f), RTUINT128_INIT_C(0x00000df0da6bdb1c, 0xbfaaef0cd1347a02),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000024228), RTUINT128_INIT_C(0x00000aafd0b3aa60, 0xcc82739741b34bbf)
    },
    { /* i=1487; 77 / 56 */
        RTUINT128_INIT_C(0x0000000000000784, 0x369e9085f3cb7aac), RTUINT128_INIT_C(0x0000000000000000, 0x00193a550b8e4437),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000004c45fa), RTUINT128_INIT_C(0x0000000000000000, 0x00033f1f122609f6)
    },
    { /* i=1488; 125 / 46 */
        RTUINT128_INIT_C(0x1ed4bd578e10f7f7, 0x9e48725a00dc2316), RTUINT128_INIT_C(0x0000000000000000, 0x000006af55cd286d),
        RTUINT128_INIT_C(0x0000000000049cae, 0x668eb973edb1b749), RTUINT128_INIT_C(0x0000000000000000, 0x000004c80518b101)
    },
    { /* i=1489; 91 / 54 */
        RTUINT128_INIT_C(0x0000000001cf9cae, 0x91291ae40f0d1364), RTUINT128_INIT_C(0x0000000000000000, 0x00356bbdedd24925),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000008adb10165), RTUINT128_INIT_C(0x0000000000000000, 0x000f080cd53812cb)
    },
    { /* i=1490; 31 / 90 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000001d9ac025), RTUINT128_INIT_C(0x00000000034cd690, 0xf5391e11a5f1c45c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000000001d9ac025)
    },
    { /* i=1491; 115 / 90 */
        RTUINT128_INIT_C(0x00042534ce5d071a, 0x3ae0f4587cda990b), RTUINT128_INIT_C(0x0000000003bfe9a7, 0xca6378fb02e55b79),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000011b039a), RTUINT128_INIT_C(0x0000000000b0c4d4, 0x932308c3f00c2741)
    },
    { /* i=1492; 56 / 43 */
        RTUINT128_INIT_C(0x0000000000000000, 0x009b007fa86e0b49), RTUINT128_INIT_C(0x0000000000000000, 0x00000633dfdb5641),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000018fd), RTUINT128_INIT_C(0x0000000000000000, 0x0000023edc93b50c)
    },
    { /* i=1493; 26 / 11 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000004d53f6), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000656),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000c34), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000027e)
    },
    { /* i=1494; 114 / 35 */
        RTUINT128_INIT_C(0x0000a7d3b40d7dc0, 0xe8cc6c53d7818285), RTUINT128_INIT_C(0x0000000000000000, 0x00000002e5f0e8d5),
        RTUINT128_INIT_C(0x00000000000039e8, 0x3bff842ed0810d47), RTUINT128_INIT_C(0x0000000000000000, 0x0000000072891e72)
    },
    { /* i=1495; 128 / 124 */
        RTUINT128_INIT_C(0x3206cfd95e4c02c1, 0x3b3d70d73d33ce6a), RTUINT128_INIT_C(0x08d770a714feafdb, 0xb10ca2c4e23a1f32),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000005), RTUINT128_INIT_C(0x05d19c95f5529376, 0xc5fe42fed2113270)
    },
    { /* i=1496; 127 / 98 */
        RTUINT128_INIT_C(0x4097339045e53eaa, 0x8e7010699efd6ccb), RTUINT128_INIT_C(0x00000003c46ea090, 0xb0dd5219ee7ac0ca),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000011251f90), RTUINT128_INIT_C(0x000000019191256b, 0xae6b1f675566852b)
    },
    { /* i=1497; 25 / 25 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000001118bd5), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000c7a609),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x0000000000000000, 0x000000000049e5cc)
    },
    { /* i=1498; 113 / 102 */
        RTUINT128_INIT_C(0x000073302602158f, 0xd82bfc1303c3ad85), RTUINT128_INIT_C(0x00000020f197c021, 0x97cd6cba1422167b),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000037f), RTUINT128_INIT_C(0x000000038479601e, 0x20fcdd86a0971580)
    },
    { /* i=1499; 116 / 30 */
        RTUINT128_INIT_C(0x000b156af4fe8f51, 0x87532c5f1083d57e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000009c60918),
        RTUINT128_INIT_C(0x00000000012250b1, 0x4fae710dd0059a6f), RTUINT128_INIT_C(0x0000000000000000, 0x0000000004b57416)
    },
    { /* i=1500; 84 / 18 */
        RTUINT128_INIT_C(0x0000000000083068, 0x3c3abdc25c5d0585), RTUINT128_INIT_C(0x0000000000000000, 0x000000000003b748),
        RTUINT128_INIT_C(0x0000000000000002, 0x342a6a244f8eef9f), RTUINT128_INIT_C(0x0000000000000000, 0x000000000001f7cd)
    },
    { /* i=1501; 53 / 14 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000c6cdea3df7a15), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000002937),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000004d2d8243f8), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000027cd)
    },
    { /* i=1502; 63 / 17 */
        RTUINT128_INIT_C(0x0000000000000000, 0x383564c0d0d841d1), RTUINT128_INIT_C(0x0000000000000000, 0x000000000001d51b),
        RTUINT128_INIT_C(0x0000000000000000, 0x00001eac92964cf5), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000014afa)
    },
    { /* i=1503; 119 / 68 */
        RTUINT128_INIT_C(0x006d811080c4f27a, 0xf5c6077727f31434), RTUINT128_INIT_C(0x0000000000000006, 0x0506244378d93e0b),
        RTUINT128_INIT_C(0x0000000000000000, 0x001230f2023ab83e), RTUINT128_INIT_C(0x0000000000000005, 0x4038f6299a40258a)
    },
    { /* i=1504; 121 / 53 */
        RTUINT128_INIT_C(0x016a3069ec3f06b8, 0x044e11a286072f1e), RTUINT128_INIT_C(0x0000000000000000, 0x0012bca589e2127a),
        RTUINT128_INIT_C(0x0000000000000013, 0x548bbe7f7d2cd3e7), RTUINT128_INIT_C(0x0000000000000000, 0x00069b3706d5f508)
    },
    { /* i=1505; 22 / 65 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000280d54), RTUINT128_INIT_C(0x0000000000000001, 0xc0bb859fc60cfccf),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000280d54)
    },
    { /* i=1506; 74 / 29 */
        RTUINT128_INIT_C(0x000000000000028f, 0x1175b44e732cc57e), RTUINT128_INIT_C(0x0000000000000000, 0x000000000069f563),
        RTUINT128_INIT_C(0x0000000000000000, 0x00062eaba6b7c350), RTUINT128_INIT_C(0x0000000000000000, 0x000000000060ad8e)
    },
    { /* i=1507; 112 / 66 */
        RTUINT128_INIT_C(0x000050b5f87abf72, 0x5b0f543fe5144bb2), RTUINT128_INIT_C(0x0000000000000000, 0x8e0f9156dd5a8cdd),
        RTUINT128_INIT_C(0x0000000000000000, 0x00009171cdf3250f), RTUINT128_INIT_C(0x0000000000000000, 0x44ad47dd27a319bf)
    },
    { /* i=1508; 128 / 127 */
        RTUINT128_INIT_C(0xc976fc36188f71c1, 0xe09883d1b2775132), RTUINT128_INIT_C(0x6ab9a72416aedf9b, 0x419ef421299f834b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x5ebd551201e09226, 0x9ef98fb088d7cde7)
    },
    { /* i=1509; 114 / 109 */
        RTUINT128_INIT_C(0x0002355d77326187, 0xe2ba565e732ae41b), RTUINT128_INIT_C(0x00000206a595bd4e, 0x3ecfc49ed707ab55),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000117), RTUINT128_INIT_C(0x0000001f01011141, 0x6e4b0d4219cf2a78)
    },
    { /* i=1510; 90 / 50 */
        RTUINT128_INIT_C(0x00000000023300f7, 0xbf7ba7578d813199), RTUINT128_INIT_C(0x0000000000000000, 0x0000c171ccde3716),
        RTUINT128_INIT_C(0x0000000000000000, 0x000002e910ed76a1), RTUINT128_INIT_C(0x0000000000000000, 0x0000ae26e8fe68c3)
    },
    { /* i=1511; 117 / 121 */
        RTUINT128_INIT_C(0x0017a09d3249959e, 0x7edddf5437c9169c), RTUINT128_INIT_C(0x0062d57817165374, 0x41ee9c31cade5409),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0017a09d3249959e, 0x7edddf5437c9169c)
    },
    { /* i=1512; 126 / 119 */
        RTUINT128_INIT_C(0x2fda10c18ad9dfd4, 0x293f9c570d08f864), RTUINT128_INIT_C(0x0050e5b22a79ae63, 0x3c859f69f8867b02),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000097), RTUINT128_INIT_C(0x002294aa7d14034b, 0x766e94d575b66a36)
    },
    { /* i=1513; 121 / 93 */
        RTUINT128_INIT_C(0x00cc22f50dcfcd95, 0x42e1f8666eee9c46), RTUINT128_INIT_C(0x0000000011123ff1, 0xf8bff74a5dc2253c),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000bf53824), RTUINT128_INIT_C(0x0000000010fe91cc, 0x6d97db0791103fd6)
    },
    { /* i=1514; 117 / 117 */
        RTUINT128_INIT_C(0x001d10229bbcc6ac, 0x0b1d67ee44e04fe4), RTUINT128_INIT_C(0x0005ea965e1af79f, 0xd1d6088cf0d7f687),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000004), RTUINT128_INIT_C(0x000565c92350e82c, 0xc3c545ba818075c8)
    },
    { /* i=1515; 115 / 124 */
        RTUINT128_INIT_C(0x00027cf84e167e0f, 0xaefa3b2defa46fa2), RTUINT128_INIT_C(0x0dcd705d7308c8f7, 0x312586354fda7379),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00027cf84e167e0f, 0xaefa3b2defa46fa2)
    },
    { /* i=1516; 112 / 45 */
        RTUINT128_INIT_C(0x0000f06aed5a56b4, 0x3076f6a3cc450a62), RTUINT128_INIT_C(0x0000000000000000, 0x00000d651a6b32d9),
        RTUINT128_INIT_C(0x0000000000000011, 0xf2ca8f05d07a2805), RTUINT128_INIT_C(0x0000000000000000, 0x000001e5fcd12425)
    },
    { /* i=1517; 126 / 54 */
        RTUINT128_INIT_C(0x02d05640d90594b3, 0xbd9c3962136d4c04), RTUINT128_INIT_C(0x0000000000000000, 0x00199002be7ddddb),
        RTUINT128_INIT_C(0x000000000000001c, 0x2decbbfad1b773d8), RTUINT128_INIT_C(0x0000000000000000, 0x0000ec876c03ba3c)
    },
    { /* i=1518; 123 / 103 */
        RTUINT128_INIT_C(0x06ce25e90291dd41, 0xa6a34a4244e678be), RTUINT128_INIT_C(0x0000000b304aa9d7, 0x25bf238e9597845e),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000009bb4f5), RTUINT128_INIT_C(0x0000000a766e3115, 0x9a616ee16ce8b2c8)
    },
    { /* i=1519; 73 / 60 */
        RTUINT128_INIT_C(0x000000000000019f, 0x550eea0314c6d2e6), RTUINT128_INIT_C(0x0000000000000000, 0x04e75aca06b01abb),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000054b2), RTUINT128_INIT_C(0x0000000000000000, 0x02677f58a58ee0e0)
    },
    { /* i=1520; 118 / 47 */
        RTUINT128_INIT_C(0x0034eb3702f01d20, 0xabdf2780d915268a), RTUINT128_INIT_C(0x0000000000000000, 0x000050e2a1b72f4d),
        RTUINT128_INIT_C(0x00000000000000a7, 0x7c9d6f263eed84d6), RTUINT128_INIT_C(0x0000000000000000, 0x00003231c546e82c)
    },
    { /* i=1521; 1 / 55 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x002a9ac862dd9cac),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=1522; 41 / 4 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000e2bdab4f16), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000e),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000010321e85a6), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002)
    },
    { /* i=1523; 118 / 120 */
        RTUINT128_INIT_C(0x003c2656a6ae3208, 0x7fe0953e8cc6e497), RTUINT128_INIT_C(0x00a8871eba8db2ac, 0x9fbd636a8196425f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x003c2656a6ae3208, 0x7fe0953e8cc6e497)
    },
    { /* i=1524; 128 / 87 */
        RTUINT128_INIT_C(0x30ddbcd4d130b002, 0x62f0997cbac5d679), RTUINT128_INIT_C(0x00000000002fccef, 0x36f19224140be9fb),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000105b5059ee0), RTUINT128_INIT_C(0x000000000012dcf5, 0x6a5817facd0930d9)
    },
    { /* i=1525; 76 / 3 */
        RTUINT128_INIT_C(0x0000000000000e1c, 0x3721fdfc3750abac), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000005),
        RTUINT128_INIT_C(0x00000000000002d2, 0x716d32cc0b102255), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003)
    },
    { /* i=1526; 101 / 10 */
        RTUINT128_INIT_C(0x0000001839677223, 0x05f8d97c6e364043), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000117),
        RTUINT128_INIT_C(0x00000000163a2d5e, 0xa26e14f7453654a5), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000070)
    },
    { /* i=1527; 114 / 110 */
        RTUINT128_INIT_C(0x00010915309a1a15, 0x95cc65b398cc1406), RTUINT128_INIT_C(0x000000f538a5b680, 0x5c63939fcc73f113),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000114), RTUINT128_INIT_C(0x000000b41df157b1, 0xfa713d6b2bcc2b8a)
    },
    { /* i=1528; 98 / 48 */
        RTUINT128_INIT_C(0x00000000c8b5f70e, 0x7ee9149088a484b2), RTUINT128_INIT_C(0x0000000000000000, 0x00003335cfe3186e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0003eb5aa32ef690), RTUINT128_INIT_C(0x0000000000000000, 0x00000c7ef1a912d2)
    },
    { /* i=1529; 78 / 72 */
        RTUINT128_INIT_C(0x0000000000000a6c, 0x939b857a337acec7), RTUINT128_INIT_C(0x000000000000008f, 0x0ccc15f2ec20742a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000012), RTUINT128_INIT_C(0x000000000000005d, 0xad41fa659932a3d3)
    },
    { /* i=1530; 127 / 62 */
        RTUINT128_INIT_C(0x13bbf8e3ef4f0804, 0xfaa9cebda30d550b), RTUINT128_INIT_C(0x0000000000000000, 0x075b955d938964bd),
        RTUINT128_INIT_C(0x0000000000000002, 0xae9e8f1d0dac902b), RTUINT128_INIT_C(0x0000000000000000, 0x0669fe324a53194c)
    },
    { /* i=1531; 69 / 2 */
        RTUINT128_INIT_C(0x000000000000000b, 0xdb74905b8077b0bc), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002),
        RTUINT128_INIT_C(0x0000000000000005, 0xedba482dc03bd85e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=1532; 127 / 48 */
        RTUINT128_INIT_C(0x1cdec0dfbd13ac7a, 0x23dcb3cbc8640d6f), RTUINT128_INIT_C(0x0000000000000000, 0x000069a5eb924d8f),
        RTUINT128_INIT_C(0x00000000000045f4, 0xd0f713f6830c1658), RTUINT128_INIT_C(0x0000000000000000, 0x0000138e6bbb1a47)
    },
    { /* i=1533; 102 / 100 */
        RTUINT128_INIT_C(0x000000163eca496d, 0x84a5c51b09b3f21a), RTUINT128_INIT_C(0x000000023c43d0da, 0xcec9377b5ff1cda1),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000009), RTUINT128_INIT_C(0x000000022067f1bc, 0x3f92d1c4aa33b771)
    },
    { /* i=1534; 118 / 57 */
        RTUINT128_INIT_C(0x00194bf6ec1b399d, 0x2de3b5014b45430d), RTUINT128_INIT_C(0x0000000000000000, 0x0055aed5508d5cd7),
        RTUINT128_INIT_C(0x0000000000000000, 0x4b949f675dd812d2), RTUINT128_INIT_C(0x0000000000000000, 0x003a14d9d65ffcaf)
    },
    { /* i=1535; 65 / 46 */
        RTUINT128_INIT_C(0x0000000000000000, 0x272e1cb985e753b8), RTUINT128_INIT_C(0x0000000000000000, 0x000037108921b62c),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000b626), RTUINT128_INIT_C(0x0000000000000000, 0x00002ec733630130)
    },
    { /* i=1536; 8 / 102 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000059), RTUINT128_INIT_C(0x0000000af0f554e1, 0x655b528fb04731d5),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000059)
    },
    { /* i=1537; 106 / 1 */
        RTUINT128_INIT_C(0x000002b5aeb3cb6b, 0x04ac30c7856de3c2), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001),
        RTUINT128_INIT_C(0x000002b5aeb3cb6b, 0x04ac30c7856de3c2), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=1538; 127 / 70 */
        RTUINT128_INIT_C(0x06ab335a471367df, 0x6ed43261d50fddee), RTUINT128_INIT_C(0x000000000000000d, 0xf7724ce9e03e8818),
        RTUINT128_INIT_C(0x0000000000000000, 0x007a3c103dc038c4), RTUINT128_INIT_C(0x0000000000000006, 0x0968ef70ad6a6b8e)
    },
    { /* i=1539; 116 / 45 */
        RTUINT128_INIT_C(0x000008152014bada, 0x6a629c7c27e63e69), RTUINT128_INIT_C(0x0000000000000000, 0x000018de2a1a12b4),
        RTUINT128_INIT_C(0x0000000000000000, 0x5334745d3ac1ad6b), RTUINT128_INIT_C(0x0000000000000000, 0x000013e40ea8c92d)
    },
    { /* i=1540; 48 / 39 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000038f773134888), RTUINT128_INIT_C(0x0000000000000000, 0x00000007f6410625),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000727), RTUINT128_INIT_C(0x0000000000000000, 0x00000005280055e5)
    },
    { /* i=1541; 125 / 124 */
        RTUINT128_INIT_C(0x0492afab4d86e83e, 0xf13300e6afae14c0), RTUINT128_INIT_C(0x05759b9ad7414b68, 0xb65e0f90f36c8b93),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0492afab4d86e83e, 0xf13300e6afae14c0)
    },
    { /* i=1542; 113 / 119 */
        RTUINT128_INIT_C(0x0000232b45815e70, 0x2dea371fafffc0c0), RTUINT128_INIT_C(0x001e8ee5c6903f2b, 0x132f0c0ec1cc1307),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000232b45815e70, 0x2dea371fafffc0c0)
    },
    { /* i=1543; 63 / 36 */
        RTUINT128_INIT_C(0x0000000000000000, 0x2e8b2bc1cc24818c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000322ba9369),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000ed7e4a9), RTUINT128_INIT_C(0x0000000000000000, 0x000000002880ad3b)
    },
    { /* i=1544; 36 / 3 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000054b76da6d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000006),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000e1e92467), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003)
    },
    { /* i=1545; 94 / 4 */
        RTUINT128_INIT_C(0x000000000736fa1c, 0x3516e7ba09649205), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000d),
        RTUINT128_INIT_C(0x00000000008e133d, 0x3f29258476e05a00), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000005)
    },
    { /* i=1546; 118 / 104 */
        RTUINT128_INIT_C(0x0033a1f26cee15e0, 0x31ef54ce0c52987a), RTUINT128_INIT_C(0x000000348e6cb6f1, 0xca1a2b5cf6dd6e9d),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000fb80), RTUINT128_INIT_C(0x000000069f338bd3, 0x7c55804782275afa)
    },
    { /* i=1547; 120 / 38 */
        RTUINT128_INIT_C(0x007ef1531d718549, 0x2b27c61957f963f8), RTUINT128_INIT_C(0x0000000000000000, 0x0000001cd7842fbb),
        RTUINT128_INIT_C(0x00000000000466bd, 0xda419259b5e7da5d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000f3391cf09)
    },
    { /* i=1548; 45 / 7 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00001f602ff21539), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000006a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000004bc67d741f), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000063)
    },
    { /* i=1549; 122 / 103 */
        RTUINT128_INIT_C(0x030e57517077f36b, 0x8864c9759806b58c), RTUINT128_INIT_C(0x00000022772467c2, 0x47f79befdec254ba),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000016b306), RTUINT128_INIT_C(0x00000013465e7d44, 0x4ff14461363eab30)
    },
    { /* i=1550; 119 / 116 */
        RTUINT128_INIT_C(0x003ae31fdf925f5c, 0xbbf7ea92654e6cf3), RTUINT128_INIT_C(0x000e1ad178db028d, 0xd7421b374bd006d0),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000004), RTUINT128_INIT_C(0x000277d9fc265525, 0x5eef7db5360e51b3)
    },
    { /* i=1551; 122 / 18 */
        RTUINT128_INIT_C(0x03d9fa8a75d1e473, 0xba26647233bc2109), RTUINT128_INIT_C(0x0000000000000000, 0x000000000001e390),
        RTUINT128_INIT_C(0x00000209fb30d97d, 0x60f470b5cb18e3c4), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000136c9)
    },
    { /* i=1552; 127 / 71 */
        RTUINT128_INIT_C(0x0d01e3408ada3987, 0x90157cec1214b852), RTUINT128_INIT_C(0x0000000000000029, 0x7e24517699268244),
        RTUINT128_INIT_C(0x0000000000000000, 0x0050409656f55cec), RTUINT128_INIT_C(0x0000000000000002, 0x58feef1788b031a2)
    },
    { /* i=1553; 124 / 127 */
        RTUINT128_INIT_C(0x08d553a2bf473a79, 0x06aed28c08d6fb3b), RTUINT128_INIT_C(0x7c6e3d66ff5be2b1, 0xf83f41d1f87bf7ec),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x08d553a2bf473a79, 0x06aed28c08d6fb3b)
    },
    { /* i=1554; 117 / 127 */
        RTUINT128_INIT_C(0x00038bfd04e614d8, 0xadeea20513f267d8), RTUINT128_INIT_C(0x42f26f0dc00f478d, 0xa13715a9a77326fd),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00038bfd04e614d8, 0xadeea20513f267d8)
    },
    { /* i=1555; 114 / 46 */
        RTUINT128_INIT_C(0x00024e2a80734387, 0xb1850b90212fa361), RTUINT128_INIT_C(0x0000000000000000, 0x0000158870f762ba),
        RTUINT128_INIT_C(0x000000000000001b, 0x685519b87d9f04df), RTUINT128_INIT_C(0x0000000000000000, 0x00001366b89fbb5b)
    },
    { /* i=1556; 128 / 68 */
        RTUINT128_INIT_C(0x172ed7bda15aaec7, 0x4499ca25360e0129), RTUINT128_INIT_C(0x0000000000000004, 0xcfa99b2d76a4c2a1),
        RTUINT128_INIT_C(0x0000000000000000, 0x04d18d4e52265e64), RTUINT128_INIT_C(0x0000000000000003, 0xf7c71df7e854dc45)
    },
    { /* i=1557; 117 / 118 */
        RTUINT128_INIT_C(0x0002728e55733129, 0xe9e500f69c85e5ca), RTUINT128_INIT_C(0x003b8ba3dac20947, 0xeda5d3cc52de2bab),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0002728e55733129, 0xe9e500f69c85e5ca)
    },
    { /* i=1558; 127 / 112 */
        RTUINT128_INIT_C(0x204a8f62b1bd0c37, 0x47ce3c557a9310e8), RTUINT128_INIT_C(0x00007580ce4ff917, 0x1283a901b71463f9),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000465a), RTUINT128_INIT_C(0x000007b04b832b0a, 0xc54e59ab8a11d55e)
    },
    { /* i=1559; 115 / 103 */
        RTUINT128_INIT_C(0x00066e126aac3bb4, 0xfa7de687708b28a0), RTUINT128_INIT_C(0x00000027ad15a3ec, 0x2be669c5fd0e881e),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000297c), RTUINT128_INIT_C(0x000000221cf00247, 0xcff1f51989b46c18)
    },
    { /* i=1560; 126 / 121 */
        RTUINT128_INIT_C(0x1f0e27c8776b4e6c, 0x0e6e9833ad263614), RTUINT128_INIT_C(0x018eb3fcab176cf4, 0xc19c646c3e4f629a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000013), RTUINT128_INIT_C(0x0176cc07c4ae3841, 0xafd3242b0d41e4a6)
    },
    { /* i=1561; 113 / 95 */
        RTUINT128_INIT_C(0x0000b49c129867b4, 0xd046f71ea0030db2), RTUINT128_INIT_C(0x0000000038d5cce4, 0x61ded1ec1d59bf0d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000032d83), RTUINT128_INIT_C(0x00000000017f4406, 0x1a96b215975a010b)
    },
    { /* i=1562; 122 / 79 */
        RTUINT128_INIT_C(0x0350c0c47457b9e0, 0x7b6c0e4d52f749f4), RTUINT128_INIT_C(0x0000000000001f32, 0xff9ab24e676a3b7a),
        RTUINT128_INIT_C(0x0000000000000000, 0x00001b344d8a812a), RTUINT128_INIT_C(0x0000000000001ada, 0xaef8a56411cd0df0)
    },
    { /* i=1563; 71 / 67 */
        RTUINT128_INIT_C(0x0000000000000073, 0xba0c22eb71bd44d5), RTUINT128_INIT_C(0x0000000000000002, 0x3984d75b9d7bf23f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000034), RTUINT128_INIT_C(0x0000000000000000, 0x0b10644f74901009)
    },
    { /* i=1564; 127 / 13 */
        RTUINT128_INIT_C(0x1c6708dabc7551d1, 0x4f46a81fbdbfee4b), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000093e),
        RTUINT128_INIT_C(0x000312b8e5add166, 0x8daaa91423762073), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000771)
    },
    { /* i=1565; 125 / 96 */
        RTUINT128_INIT_C(0x0b9e91f9aa7c4704, 0x8b176d46aba42532), RTUINT128_INIT_C(0x00000000bf0d65d2, 0xf31becdb1063cb67),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000f91c432), RTUINT128_INIT_C(0x000000000f2e8bfd, 0xb041507fd2148f14)
    },
    { /* i=1566; 122 / 104 */
        RTUINT128_INIT_C(0x024fad24461ff05c, 0xcad521c1f49c1727), RTUINT128_INIT_C(0x0000004b6b48527f, 0x69e1cc926c839001),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000007d85d), RTUINT128_INIT_C(0x0000003f05c29190, 0x37314d689748eeca)
    },
    { /* i=1567; 43 / 7 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000079de3c0c530), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000002a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000002e6d0aaf5c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000018)
    },
    { /* i=1568; 11 / 63 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000004ef), RTUINT128_INIT_C(0x0000000000000000, 0x5f70bfa4852b15ed),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000004ef)
    },
    { /* i=1569; 60 / 56 */
        RTUINT128_INIT_C(0x0000000000000000, 0x064094ab1af24127), RTUINT128_INIT_C(0x0000000000000000, 0x000f57302a89782d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000068), RTUINT128_INIT_C(0x0000000000000000, 0x00052919d3196edf)
    },
    { /* i=1570; 119 / 56 */
        RTUINT128_INIT_C(0x00522b847150de96, 0xfa7c13fa9290da01), RTUINT128_INIT_C(0x0000000000000000, 0x0064080abbfc2e69),
        RTUINT128_INIT_C(0x0000000000000000, 0xd24a035be8102a06), RTUINT128_INIT_C(0x0000000000000000, 0x00401cbdbc7a898b)
    },
    { /* i=1571; 128 / 45 */
        RTUINT128_INIT_C(0xf325cdef332a4246, 0x3a05aab615656d26), RTUINT128_INIT_C(0x0000000000000000, 0x0000029e16682679),
        RTUINT128_INIT_C(0x00000000005ce45d, 0x6d71dced2290da00), RTUINT128_INIT_C(0x0000000000000000, 0x000001eaae926326)
    },
    { /* i=1572; 111 / 23 */
        RTUINT128_INIT_C(0x000051b65e579f85, 0x028f7bc09ba1b9e0), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000625b7b),
        RTUINT128_INIT_C(0x0000000000d4ad5f, 0x6c27c6490db3acd0), RTUINT128_INIT_C(0x0000000000000000, 0x00000000003fc1f0)
    },
    { /* i=1573; 124 / 76 */
        RTUINT128_INIT_C(0x03a161a67f01adf6, 0x2be52dd833a3edf4), RTUINT128_INIT_C(0x000000000000043f, 0xc55413f349bf5b29),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000dab95c16e8bc), RTUINT128_INIT_C(0x000000000000004a, 0xabbf26830ef9d3d8)
    },
    { /* i=1574; 115 / 59 */
        RTUINT128_INIT_C(0x000494a8e1c9787f, 0x727b872efb49f393), RTUINT128_INIT_C(0x0000000000000000, 0x0321a98a977d0a9c),
        RTUINT128_INIT_C(0x0000000000000000, 0x017679170c96598a), RTUINT128_INIT_C(0x0000000000000000, 0x01eea40751c9ff7b)
    },
    { /* i=1575; 115 / 88 */
        RTUINT128_INIT_C(0x000459a2e3b1995d, 0x4536855c1fa32cc7), RTUINT128_INIT_C(0x0000000000b0ec2b, 0x4b8d557547787e84),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000064b6362), RTUINT128_INIT_C(0x00000000002e0029, 0xe806b08f01e9b23f)
    },
    { /* i=1576; 120 / 127 */
        RTUINT128_INIT_C(0x001c916c05db982c, 0x3a44de52332afb14), RTUINT128_INIT_C(0x15f9beae9aeea2db, 0xd490aca57491468a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x001c916c05db982c, 0x3a44de52332afb14)
    },
    { /* i=1577; 125 / 117 */
        RTUINT128_INIT_C(0x110632a2f324cc87, 0x082388c82c963513), RTUINT128_INIT_C(0x000acacba452ac59, 0xcd973f21c5cc67fc),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000193), RTUINT128_INIT_C(0x0008f40f44ff7b28, 0x630b269dcbce835f)
    },
    { /* i=1578; 121 / 120 */
        RTUINT128_INIT_C(0x0171932185409b75, 0x7560b69e740eb92d), RTUINT128_INIT_C(0x002be2acb8bd6c17, 0xd39999176543bd22),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000008), RTUINT128_INIT_C(0x00127dbbbf553ab6, 0xd893ede349f0d01d)
    },
    { /* i=1579; 118 / 73 */
        RTUINT128_INIT_C(0x002900554599ce0e, 0xcb00cc743475d880), RTUINT128_INIT_C(0x00000000000001d8, 0xdba3e7ad5f2d948b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000163298d3d3d9), RTUINT128_INIT_C(0x0000000000000083, 0x1f0a0d21fed35dad)
    },
    { /* i=1580; 120 / 6 */
        RTUINT128_INIT_C(0x007e3ba3923ca913, 0xa95e39cfb40f1036), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000003b),
        RTUINT128_INIT_C(0x000223b9027a8509, 0x02dee29b62826cbf), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000031)
    },
    { /* i=1581; 64 / 34 */
        RTUINT128_INIT_C(0x0000000000000000, 0xed54801aac33a2ae), RTUINT128_INIT_C(0x0000000000000000, 0x0000000143901479),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000bbc5ffc5), RTUINT128_INIT_C(0x0000000000000000, 0x0000000105d25a91)
    },
    { /* i=1582; 33 / 14 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000001205fcdfb), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000a92),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000001b4811), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000a49)
    },
    { /* i=1583; 60 / 5 */
        RTUINT128_INIT_C(0x0000000000000000, 0x05cda11319ec6600), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000014),
        RTUINT128_INIT_C(0x0000000000000000, 0x004a480dc14bd1e6), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000008)
    },
    { /* i=1584; 92 / 123 */
        RTUINT128_INIT_C(0x000000000a0396f0, 0x352a0e10dd6c0af9), RTUINT128_INIT_C(0x018f8eec24f6f461, 0x8aaeb4460310e95f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000000000a0396f0, 0x352a0e10dd6c0af9)
    },
    { /* i=1585; 106 / 15 */
        RTUINT128_INIT_C(0x0000039662227a72, 0xa999323777a6e9e1), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000003b7b),
        RTUINT128_INIT_C(0x000000000f70a93d, 0x74ce478a15240e70), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000002a11)
    },
    { /* i=1586; 126 / 108 */
        RTUINT128_INIT_C(0x044a09a198b67725, 0x007b9172b39700ed), RTUINT128_INIT_C(0x000001afaf767f7d, 0x717e3817595fe506),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000028b29), RTUINT128_INIT_C(0x0000014c28880c71, 0xdaa1356e87d510f7)
    },
    { /* i=1587; 120 / 77 */
        RTUINT128_INIT_C(0x0071ce52e0746738, 0x31f0fd3710fa09ae), RTUINT128_INIT_C(0x00000000000010d6, 0x5bb08a77f329f27b),
        RTUINT128_INIT_C(0x0000000000000000, 0x000006c2572499de), RTUINT128_INIT_C(0x0000000000000e0c, 0xae1d225a3a624004)
    },
    { /* i=1588; 123 / 73 */
        RTUINT128_INIT_C(0x02a72e2484a480a0, 0xd63b77321fdc9891), RTUINT128_INIT_C(0x0000000000000187, 0x91ffddcf7acd04d9),
        RTUINT128_INIT_C(0x0000000000000000, 0x0001bc08732ff5ce), RTUINT128_INIT_C(0x00000000000000ba, 0x22fd421dba6804f3)
    },
    { /* i=1589; 124 / 92 */
        RTUINT128_INIT_C(0x095c482296f592a5, 0xf99c16a332c80584), RTUINT128_INIT_C(0x000000000b54f23b, 0x3d0cbc4791d573de),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000d376ffed), RTUINT128_INIT_C(0x000000000168acf0, 0xff16573a2f6d9efe)
    },
    { /* i=1590; 121 / 113 */
        RTUINT128_INIT_C(0x015860346d429266, 0xb81a0ebfdd8b626a), RTUINT128_INIT_C(0x00007de563af5cdb, 0xca18a38975b464bf),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000002bc), RTUINT128_INIT_C(0x000020f7d9c0a96a, 0x1cbae2e20447e826)
    },
    { /* i=1591; 127 / 10 */
        RTUINT128_INIT_C(0x112059e7451f592b, 0xd68dfbdc01dfdde8), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000001c5),
        RTUINT128_INIT_C(0x0009adb0d412b7dc, 0x7e7ee68f761d50bc), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000013c)
    },
    { /* i=1592; 123 / 33 */
        RTUINT128_INIT_C(0x0397254c8f2e816c, 0x1fc2d61d5c1d65ff), RTUINT128_INIT_C(0x0000000000000000, 0x000000004c0cdd31),
        RTUINT128_INIT_C(0x000000000c160624, 0xde17e36ce795ace7), RTUINT128_INIT_C(0x0000000000000000, 0x00000000235fe2c8)
    },
    { /* i=1593; 126 / 49 */
        RTUINT128_INIT_C(0x24819da9d6c998bb, 0x115663dd016ea67c), RTUINT128_INIT_C(0x0000000000000000, 0x0000b8cb474a94b0),
        RTUINT128_INIT_C(0x0000000000003292, 0xb95dce33546ec0c6), RTUINT128_INIT_C(0x0000000000000000, 0x0000a7464a9ba65c)
    },
    { /* i=1594; 53 / 17 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0016e95d1f3c713f), RTUINT128_INIT_C(0x0000000000000000, 0x000000000001983a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000e5e2f8cd6), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000178c3)
    },
    { /* i=1595; 59 / 2 */
        RTUINT128_INIT_C(0x0000000000000000, 0x01a61d60266f41ac), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003),
        RTUINT128_INIT_C(0x0000000000000000, 0x008cb475622515e4), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=1596; 42 / 21 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000b9e39625bc), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000912fd),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000147c4a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001c9a)
    },
    { /* i=1597; 88 / 32 */
        RTUINT128_INIT_C(0x0000000000453300, 0x26d3fd50332c1987), RTUINT128_INIT_C(0x0000000000000000, 0x000000008f3381b1),
        RTUINT128_INIT_C(0x0000000000000000, 0x007bb5028ae15e4c), RTUINT128_INIT_C(0x0000000000000000, 0x000000005fb19afb)
    },
    { /* i=1598; 113 / 57 */
        RTUINT128_INIT_C(0x0000e4b6854399d9, 0x6a1a6a3a34165e79), RTUINT128_INIT_C(0x0000000000000000, 0x016098f083ccb003),
        RTUINT128_INIT_C(0x0000000000000000, 0x00a60e0c4cd3730a), RTUINT128_INIT_C(0x0000000000000000, 0x01189586248d255b)
    },
    { /* i=1599; 21 / 2 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000d8889), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000482d8), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001)
    },
    { /* i=1600; 87 / 6 */
        RTUINT128_INIT_C(0x00000000007c0bc1, 0x36904cad5d1175e0), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000038),
        RTUINT128_INIT_C(0x0000000000023711, 0x2a1e015e863bbd88), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000020)
    },
    { /* i=1601; 16 / 67 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000ad82), RTUINT128_INIT_C(0x0000000000000007, 0x9ef09e80cf92a230),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000ad82)
    },
    { /* i=1602; 69 / 59 */
        RTUINT128_INIT_C(0x0000000000000005, 0x48f3b3dfc15b4d3e), RTUINT128_INIT_C(0x0000000000000000, 0x00fb3b87016d72a7),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000562), RTUINT128_INIT_C(0x0000000000000000, 0x009d472a12382650)
    },
    { /* i=1603; 117 / 21 */
        RTUINT128_INIT_C(0x000d656944652590, 0x683f45e022e61d7b), RTUINT128_INIT_C(0x0000000000000000, 0x00000000001f27e6),
        RTUINT128_INIT_C(0x000000006e12a153, 0x3e2395f30c9987a7), RTUINT128_INIT_C(0x0000000000000000, 0x000000000012cc71)
    },
    { /* i=1604; 123 / 81 */
        RTUINT128_INIT_C(0x041d8fe6e3fee5bd, 0x1e89d5c7f288fc3b), RTUINT128_INIT_C(0x000000000000ab15, 0xa52aafa687925e17),
        RTUINT128_INIT_C(0x0000000000000000, 0x000006287bab9ab6), RTUINT128_INIT_C(0x0000000000000fe3, 0x1013a8439d8341e1)
    },
    { /* i=1605; 123 / 63 */
        RTUINT128_INIT_C(0x07ec60cb4a02aa0a, 0x5a45b78187bd2a75), RTUINT128_INIT_C(0x0000000000000000, 0x16bfe7b4b649bfe5),
        RTUINT128_INIT_C(0x0000000000000000, 0x592932b29d9a8f1b), RTUINT128_INIT_C(0x0000000000000000, 0x0baa4b583b03024e)
    },
    { /* i=1606; 98 / 43 */
        RTUINT128_INIT_C(0x0000000095853515, 0xa4e09f1aa18c44b4), RTUINT128_INIT_C(0x0000000000000000, 0x0000052a9d034619),
        RTUINT128_INIT_C(0x0000000000000000, 0x001cf0ca5e43c80e), RTUINT128_INIT_C(0x0000000000000000, 0x000000c8f60fe756)
    },
    { /* i=1607; 125 / 45 */
        RTUINT128_INIT_C(0x07faa13e18f53411, 0x890c02a335b9b027), RTUINT128_INIT_C(0x0000000000000000, 0x00001ff97f1cf8f5),
        RTUINT128_INIT_C(0x0000000000003fe2, 0x059f256480d4735c), RTUINT128_INIT_C(0x0000000000000000, 0x000007b2d896291b)
    },
    { /* i=1608; 120 / 117 */
        RTUINT128_INIT_C(0x003e8970329840fd, 0x479a4dd69990e693), RTUINT128_INIT_C(0x0011acbf1d2bace7, 0x04e321640c3d811e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003), RTUINT128_INIT_C(0x00098332db153a48, 0x38f0e9aa74d86339)
    },
    { /* i=1609; 110 / 12 */
        RTUINT128_INIT_C(0x00001635b8c84ce6, 0x4d8adc1b0c1fce5c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000073),
        RTUINT128_INIT_C(0x0000003170e94139, 0xa7a17c594757180e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000012)
    },
    { /* i=1610; 126 / 85 */
        RTUINT128_INIT_C(0x2f35b8c0b8c24d2b, 0x42a098169d17c8e8), RTUINT128_INIT_C(0x000000000005f13c, 0xa383211f37d8addc),
        RTUINT128_INIT_C(0x0000000000000000, 0x000007f1d5c0fae4), RTUINT128_INIT_C(0x00000000000175a9, 0x42e0c078d55418f8)
    },
    { /* i=1611; 125 / 71 */
        RTUINT128_INIT_C(0x061c298fee74de87, 0x933056244373466c), RTUINT128_INIT_C(0x0000000000000000, 0x486c1451c4148313),
        RTUINT128_INIT_C(0x0000000000000000, 0x15990bab369154bd), RTUINT128_INIT_C(0x0000000000000000, 0x225dbf7a85894565)
    },
    { /* i=1612; 120 / 64 */
        RTUINT128_INIT_C(0x001979a6ce9c0649, 0x3a6c3b4c440dbd8e), RTUINT128_INIT_C(0x0000000000000000, 0x056b83f0bc624617),
        RTUINT128_INIT_C(0x0000000000000000, 0x04b342c04fa891a3), RTUINT128_INIT_C(0x0000000000000000, 0x03426af18fb015e9)
    },
    { /* i=1613; 16 / 5 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000a112), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000b81), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000004)
    },
    { /* i=1614; 67 / 50 */
        RTUINT128_INIT_C(0x0000000000000005, 0x12d52e83bcb270d5), RTUINT128_INIT_C(0x0000000000000000, 0x0000d2f926ca301c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000062808), RTUINT128_INIT_C(0x0000000000000000, 0x0000bfedce348ff5)
    },
    { /* i=1615; 72 / 71 */
        RTUINT128_INIT_C(0x000000000000002d, 0x42048a79dd679a01), RTUINT128_INIT_C(0x0000000000000013, 0x1106746d6206258a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002), RTUINT128_INIT_C(0x0000000000000007, 0x1ff7a19f195b4eed)
    },
    { /* i=1616; 62 / 100 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0b274b53274f4158), RTUINT128_INIT_C(0x000000011fc647ce, 0x3905081007936a00),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0b274b53274f4158)
    },
    { /* i=1617; 99 / 78 */
        RTUINT128_INIT_C(0x00000001888cd5a5, 0x5e2dbdad2861308b), RTUINT128_INIT_C(0x0000000000001b16, 0x797e801da260a6de),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000e7de4), RTUINT128_INIT_C(0x0000000000001763, 0x635649b638ae2cd3)
    },
    { /* i=1618; 119 / 58 */
        RTUINT128_INIT_C(0x00327a9f1ff3dc63, 0x067ce12059152228), RTUINT128_INIT_C(0x0000000000000000, 0x03c7760d8550d2c2),
        RTUINT128_INIT_C(0x0000000000000000, 0x0d5b74d18a5aba05), RTUINT128_INIT_C(0x0000000000000000, 0x01c15797592c105e)
    },
    { /* i=1619; 54 / 18 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0025960b06da2853), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000037656),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000adb2158e4), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000133bb)
    },
    { /* i=1620; 127 / 125 */
        RTUINT128_INIT_C(0x3899b0d45629e687, 0x11bcb55c080a4439), RTUINT128_INIT_C(0x1b6ebf50e3b52a5c, 0xccb9c4ae6c020fcb),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002), RTUINT128_INIT_C(0x01bc32328ebf91cd, 0x78492bff300624a3)
    },
    { /* i=1621; 117 / 81 */
        RTUINT128_INIT_C(0x000c6190ae50d8e3, 0xa9f29f40df5d8ac9), RTUINT128_INIT_C(0x00000000000168e2, 0x2b80ef3328054b72),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000008c8652cbd), RTUINT128_INIT_C(0x0000000000002c17, 0xcc07f30396833f9f)
    },
    { /* i=1622; 124 / 84 */
        RTUINT128_INIT_C(0x0ad28100e618efac, 0x728ba414f3238e33), RTUINT128_INIT_C(0x00000000000eda2a, 0xafc967c76bcab54c),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000ba89c1a9e8), RTUINT128_INIT_C(0x00000000000654ab, 0xe733792217741553)
    },
    { /* i=1623; 95 / 88 */
        RTUINT128_INIT_C(0x000000004a1e7e9b, 0x9e1117b99794380f), RTUINT128_INIT_C(0x0000000000b32430, 0x6f010d07bbe4ea02),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000069), RTUINT128_INIT_C(0x0000000000a4a6be, 0x16a2bf8d86b03d3d)
    },
    { /* i=1624; 14 / 4 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000002052), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000c),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000002b1), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000006)
    },
    { /* i=1625; 116 / 107 */
        RTUINT128_INIT_C(0x0007159631ccb758, 0xe6cd3dfd4f5c32a7), RTUINT128_INIT_C(0x000003ac67076417, 0xc85cc58abbe4622a),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000001ed), RTUINT128_INIT_C(0x00000293c890f58c, 0x0c24d1d1788b27c5)
    },
    { /* i=1626; 39 / 3 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000003ef0c1bc2d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000005),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000c968d25a2), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003)
    },
    { /* i=1627; 94 / 74 */
        RTUINT128_INIT_C(0x000000000976dad7, 0x6a728ba3b1221d55), RTUINT128_INIT_C(0x000000000000037e, 0x118c7ff6d546053f),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000002b5bd), RTUINT128_INIT_C(0x0000000000000143, 0x1f50e311b03cb2d2)
    },
    { /* i=1628; 113 / 116 */
        RTUINT128_INIT_C(0x00016687b040a506, 0xdd255c228db360d5), RTUINT128_INIT_C(0x000230a3f60fe110, 0x653474bf9b478637),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00016687b040a506, 0xdd255c228db360d5)
    },
    { /* i=1629; 124 / 59 */
        RTUINT128_INIT_C(0x03849b4b99e4cf51, 0x05657a06a234f2a5), RTUINT128_INIT_C(0x0000000000000000, 0x07cbca8ef58cb307),
        RTUINT128_INIT_C(0x0000000000000000, 0x73854faca0717032), RTUINT128_INIT_C(0x0000000000000000, 0x06fc99f9b84feb47)
    },
    { /* i=1630; 116 / 13 */
        RTUINT128_INIT_C(0x0000b1e48eedc5ef, 0xd0373aea434e7819), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000b6b),
        RTUINT128_INIT_C(0x0000000f947fc65a, 0x072a521573313f5c), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000008a5)
    },
    { /* i=1631; 86 / 82 */
        RTUINT128_INIT_C(0x00000000000f212c, 0xd4a7fbbebbd33274), RTUINT128_INIT_C(0x000000000001a4b6, 0xea7ceee6113acdf2),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000009), RTUINT128_INIT_C(0x00000000000056be, 0x964395a820c1f4f2)
    },
    { /* i=1632; 114 / 75 */
        RTUINT128_INIT_C(0x00009b0706ae06d2, 0xe6d3e87f84df8feb), RTUINT128_INIT_C(0x00000000000000f7, 0x9e43578261c33716),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000a0466ad034), RTUINT128_INIT_C(0x00000000000000a3, 0x0d51e8f0395a7f73)
    },
    { /* i=1633; 65 / 25 */
        RTUINT128_INIT_C(0x0000000000000000, 0x480e8ea0baf9258f), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000caa0a5),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000005b096a8a3b), RTUINT128_INIT_C(0x0000000000000000, 0x00000000005b2d88)
    },
    { /* i=1634; 48 / 70 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000b3754b678ab), RTUINT128_INIT_C(0x0000000000000019, 0x47884b22cdf75eea),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00000b3754b678ab)
    },
    { /* i=1635; 90 / 36 */
        RTUINT128_INIT_C(0x0000000000b92b0d, 0x27795dcea92ff1dc), RTUINT128_INIT_C(0x0000000000000000, 0x00000000e7ab5476),
        RTUINT128_INIT_C(0x0000000000000000, 0x00cc9d7db9a1460f), RTUINT128_INIT_C(0x0000000000000000, 0x00000000d8d7baf2)
    },
    { /* i=1636; 87 / 58 */
        RTUINT128_INIT_C(0x00000000001c4ec1, 0xaf4bf03aef3c6363), RTUINT128_INIT_C(0x0000000000000000, 0x00ae37fddd31eb09),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000029988275), RTUINT128_INIT_C(0x0000000000000000, 0x00151a997fb96646)
    },
    { /* i=1637; 126 / 77 */
        RTUINT128_INIT_C(0x3f3507b3fdce617d, 0x793f9a91be378df0), RTUINT128_INIT_C(0x0000000000001637, 0x49b97638751ff7c4),
        RTUINT128_INIT_C(0x0000000000000000, 0x0002d859f001657b), RTUINT128_INIT_C(0x0000000000001594, 0xdcc696b023572ec4)
    },
    { /* i=1638; 31 / 27 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000005597fc60), RTUINT128_INIT_C(0x0000000000000000, 0x000000000525e6b4),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000010), RTUINT128_INIT_C(0x0000000000000000, 0x0000000003399120)
    },
    { /* i=1639; 118 / 56 */
        RTUINT128_INIT_C(0x001f1523e78147a0, 0x48ae56d009e6632c), RTUINT128_INIT_C(0x0000000000000000, 0x00d1b424625fe1c8),
        RTUINT128_INIT_C(0x0000000000000000, 0x25f1d6ed5ffb6e73), RTUINT128_INIT_C(0x0000000000000000, 0x001b893f0eb80654)
    },
    { /* i=1640; 123 / 116 */
        RTUINT128_INIT_C(0x01243afd8687d322, 0xf4c4b990343016ea), RTUINT128_INIT_C(0x00030c44571ffd8f, 0xdf7616f030654704),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000005f), RTUINT128_INIT_C(0x0002ada131a8babf, 0x07f2366e3e9abc6e)
    },
    { /* i=1641; 111 / 93 */
        RTUINT128_INIT_C(0x00000a81a1ab64e9, 0xd7fc52da1244c22e), RTUINT128_INIT_C(0x00000000076a2a03, 0xa0f22a4f18d10d55),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000016abe), RTUINT128_INIT_C(0x00000000017714a1, 0xf46d130e0a42ab18)
    },
    { /* i=1642; 86 / 58 */
        RTUINT128_INIT_C(0x00000000002f17b5, 0x90ffdb940cad4306), RTUINT128_INIT_C(0x0000000000000000, 0x002cad2cea7e308d),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000010dd8407a), RTUINT128_INIT_C(0x0000000000000000, 0x001da60fa06edfd4)
    },
    { /* i=1643; 118 / 103 */
        RTUINT128_INIT_C(0x0011cda742e6ba68, 0x218a1631f178d006), RTUINT128_INIT_C(0x0000003d2690a6f4, 0x3bbc6b24ec2da4fd),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000004a88), RTUINT128_INIT_C(0x00000004f5cb6f63, 0xee787e4f4788079e)
    },
    { /* i=1644; 58 / 42 */
        RTUINT128_INIT_C(0x0000000000000000, 0x01e1b737661e35b8), RTUINT128_INIT_C(0x0000000000000000, 0x000003fbd310c2d4),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000078ec), RTUINT128_INIT_C(0x0000000000000000, 0x00000020f7573a48)
    },
    { /* i=1645; 103 / 26 */
        RTUINT128_INIT_C(0x0000006cce512e5b, 0xfa2ed4cfe82d535f), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000b0cc19),
        RTUINT128_INIT_C(0x0000000000009d8c, 0xab33322058f5799c), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000c2323)
    },
    { /* i=1646; 127 / 121 */
        RTUINT128_INIT_C(0x394e6d284cc74d3d, 0x189914af2b43ca8f), RTUINT128_INIT_C(0x00a9be70eb38e263, 0x1b3c025fae422b61),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000056), RTUINT128_INIT_C(0x0048733947ab3ff1, 0xf270488aa10937f9)
    },
    { /* i=1647; 62 / 23 */
        RTUINT128_INIT_C(0x0000000000000000, 0x257b682e6e175928), RTUINT128_INIT_C(0x0000000000000000, 0x00000000003b4639),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000a1e1a27427), RTUINT128_INIT_C(0x0000000000000000, 0x00000000002bd279)
    },
    { /* i=1648; 63 / 51 */
        RTUINT128_INIT_C(0x0000000000000000, 0x40759ed92a0316c2), RTUINT128_INIT_C(0x0000000000000000, 0x00015fec886b3c4c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000002ee3), RTUINT128_INIT_C(0x0000000000000000, 0x00010f98ee16f75e)
    },
    { /* i=1649; 9 / 4 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000001a9), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000e),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000001e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000005)
    },
    { /* i=1650; 2 / 115 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x000554072afdd0e6, 0x2d8a46a2ed86e162),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001)
    },
    { /* i=1651; 116 / 113 */
        RTUINT128_INIT_C(0x0002c747b222aa60, 0x103eb71ead57b146), RTUINT128_INIT_C(0x00017597bc24dbdf, 0xc9163f6bb90e001b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x000151aff5fdce80, 0x472877b2f449b12b)
    },
    { /* i=1652; 123 / 49 */
        RTUINT128_INIT_C(0x004342da7b4644b4, 0x121cf43010c31db5), RTUINT128_INIT_C(0x0000000000000000, 0x0000542b3b81abe7),
        RTUINT128_INIT_C(0x00000000000000cc, 0x93377817a516cf63), RTUINT128_INIT_C(0x0000000000000000, 0x000007a88ac3da60)
    },
    { /* i=1653; 123 / 30 */
        RTUINT128_INIT_C(0x0643e4c7ec7fb862, 0x9e030190d74ea104), RTUINT128_INIT_C(0x0000000000000000, 0x000000002671d635),
        RTUINT128_INIT_C(0x0000000029b832f7, 0xfb431d832570c5a5), RTUINT128_INIT_C(0x0000000000000000, 0x0000000015e8c7db)
    },
    { /* i=1654; 124 / 97 */
        RTUINT128_INIT_C(0x0327f4829c2d9811, 0x36288e53432c8416), RTUINT128_INIT_C(0x00000001233e3992, 0x9ab2c5a6d2fc3496),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000002c62f68), RTUINT128_INIT_C(0x0000000031bb3e4b, 0x5e917a57670b9d26)
    },
    { /* i=1655; 116 / 47 */
        RTUINT128_INIT_C(0x000c53598d214c99, 0x6126970dab24f7f3), RTUINT128_INIT_C(0x0000000000000000, 0x000059957215c809),
        RTUINT128_INIT_C(0x0000000000000023, 0x38eb1407f4aa18d3), RTUINT128_INIT_C(0x0000000000000000, 0x00000cd02e764088)
    },
    { /* i=1656; 121 / 85 */
        RTUINT128_INIT_C(0x008cf4052c62c876, 0x8d0412aae74f56ca), RTUINT128_INIT_C(0x00000000000dfd4e, 0x6949a495083e12d0),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000a135e5fb5), RTUINT128_INIT_C(0x00000000000308df, 0xf71d08ecb210d9ba)
    },
    { /* i=1657; 118 / 81 */
        RTUINT128_INIT_C(0x0035a7328bd68b89, 0x0ee39a53ff6d7154), RTUINT128_INIT_C(0x0000000000015aaa, 0x7913cdf153801fa0),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000279eefeac9), RTUINT128_INIT_C(0x000000000000e6a7, 0xf5bd78040c8c5cb4)
    },
    { /* i=1658; 61 / 42 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0c0433acbc6f4b06), RTUINT128_INIT_C(0x0000000000000000, 0x00000355a441a21d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000039a86), RTUINT128_INIT_C(0x0000000000000000, 0x000003446037fdd8)
    },
    { /* i=1659; 119 / 85 */
        RTUINT128_INIT_C(0x002989e311eb402a, 0xec9837fde301a8c3), RTUINT128_INIT_C(0x00000000001976b1, 0x8757b58bc61906f1),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000001a19c4c0a), RTUINT128_INIT_C(0x00000000000b90e2, 0x4a6a2629ec1bd759)
    },
    { /* i=1660; 126 / 96 */
        RTUINT128_INIT_C(0x03ba2483ebdbb061, 0x344b7a3757afb3c9), RTUINT128_INIT_C(0x00000000493ec951, 0xf0cc0a436a9052e7),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000d06d492), RTUINT128_INIT_C(0x00000000462f02ef, 0x3d6ff7ed604f200b)
    },
    { /* i=1661; 121 / 80 */
        RTUINT128_INIT_C(0x01dfac216d7bbee0, 0x904a7cbf49cdd311), RTUINT128_INIT_C(0x000000000000190b, 0x12f2db359f738dfa),
        RTUINT128_INIT_C(0x0000000000000000, 0x000013275c617cd2), RTUINT128_INIT_C(0x00000000000001d0, 0x302190a1e08443fd)
    },
    { /* i=1662; 79 / 38 */
        RTUINT128_INIT_C(0x000000000000559f, 0x23ceaa054e5e59ff), RTUINT128_INIT_C(0x0000000000000000, 0x0000002b292d47a3),
        RTUINT128_INIT_C(0x0000000000000000, 0x000001fbd90748d9), RTUINT128_INIT_C(0x0000000000000000, 0x000000138a61c8d4)
    },
    { /* i=1663; 119 / 84 */
        RTUINT128_INIT_C(0x0008011e180bcab3, 0xfe28c5952cb65d21), RTUINT128_INIT_C(0x00000000000313f6, 0x04dd295266f42cf7),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000299bc714d), RTUINT128_INIT_C(0x0000000000011ecd, 0x8272143bc907cfd6)
    },
    { /* i=1664; 35 / 123 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000030997edc6), RTUINT128_INIT_C(0x063443d814ee094a, 0xe72bf5ea26fc42c0),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000000030997edc6)
    },
    { /* i=1665; 127 / 86 */
        RTUINT128_INIT_C(0x0720f8e6b5e18ea4, 0x5c2f3356128f5bb8), RTUINT128_INIT_C(0x00000000002bfb3e, 0x0cb07d9bba4db637),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000297e81d4a9), RTUINT128_INIT_C(0x000000000001ef79, 0x0c0a0198d6a58569)
    },
    { /* i=1666; 89 / 73 */
        RTUINT128_INIT_C(0x0000000001e1ec36, 0x04cb2fca07c97491), RTUINT128_INIT_C(0x0000000000000114, 0xa3c5dcbb2c0572a5),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000001bdf7), RTUINT128_INIT_C(0x000000000000009d, 0x1031dbad163f065e)
    },
    { /* i=1667; 115 / 103 */
        RTUINT128_INIT_C(0x0002a17542d25ce5, 0x21b62b9a5582251a), RTUINT128_INIT_C(0x000000128f40a963, 0x61d8c9b693de6f3d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000002449), RTUINT128_INIT_C(0x00000005519015cb, 0xbe86f9bee36fd8b5)
    },
    { /* i=1668; 116 / 68 */
        RTUINT128_INIT_C(0x0004ccd97a0ff3fa, 0x37828e35213a075f), RTUINT128_INIT_C(0x0000000000000004, 0xc5e78a924bd442fc),
        RTUINT128_INIT_C(0x0000000000000000, 0x000101747e5739c1), RTUINT128_INIT_C(0x0000000000000001, 0xe9a0eebce7a56b63)
    },
    { /* i=1669; 118 / 96 */
        RTUINT128_INIT_C(0x000e41a7c711824a, 0x0c7b619e89c89726), RTUINT128_INIT_C(0x0000000033df244d, 0x610c0d10fbf75cae),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000465bfe), RTUINT128_INIT_C(0x00000000109b72b8, 0xe73c7b9044d4c882)
    },
    { /* i=1670; 114 / 69 */
        RTUINT128_INIT_C(0x0001f6f121a18bfe, 0x0f538cd74ed67702), RTUINT128_INIT_C(0x0000000000000010, 0x49f69ec53a5082f9),
        RTUINT128_INIT_C(0x0000000000000000, 0x00001ee056a33810), RTUINT128_INIT_C(0x0000000000000005, 0xae37869f029ccf72)
    },
    { /* i=1671; 116 / 79 */
        RTUINT128_INIT_C(0x000ccd3a05223620, 0xb09215c7bdc4d51d), RTUINT128_INIT_C(0x0000000000003e8d, 0x070e3bded274a269),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000003464997781), RTUINT128_INIT_C(0x00000000000032a0, 0xf27f023164bf2f34)
    },
    { /* i=1672; 39 / 11 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000001069675df0), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000047),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000003b2cb935), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000003d)
    },
    { /* i=1673; 121 / 52 */
        RTUINT128_INIT_C(0x01755df52d3158ec, 0xc282f1a8408de4e8), RTUINT128_INIT_C(0x0000000000000000, 0x00078444679c8706),
        RTUINT128_INIT_C(0x0000000000000031, 0xabffeb0ff520dd55), RTUINT128_INIT_C(0x0000000000000000, 0x0006cd5c1a44e1ea)
    },
    { /* i=1674; 106 / 41 */
        RTUINT128_INIT_C(0x000003d617081cc3, 0xa57cf4f827c89218), RTUINT128_INIT_C(0x0000000000000000, 0x000000572f0b2466),
        RTUINT128_INIT_C(0x000000000000000b, 0x43bca1bf1db3420e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000eb4784884)
    },
    { /* i=1675; 125 / 125 */
        RTUINT128_INIT_C(0x161874eda03309c7, 0x1f82a546aa923090), RTUINT128_INIT_C(0x08fb2dc75aaa0b6c, 0x66d861f6972fd549),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002), RTUINT128_INIT_C(0x0422195eeadef2ee, 0x51d1e1597c3285fe)
    },
    { /* i=1676; 124 / 82 */
        RTUINT128_INIT_C(0x0df845f9511c2bff, 0xf2322a3b6e55b56e), RTUINT128_INIT_C(0x0000000000020b47, 0x070446c408551b80),
        RTUINT128_INIT_C(0x0000000000000000, 0x000006d59979c827), RTUINT128_INIT_C(0x0000000000019e15, 0x002a8cb22c6284ee)
    },
    { /* i=1677; 113 / 39 */
        RTUINT128_INIT_C(0x0000a996c7085160, 0xa0afc3097f6dc3e0), RTUINT128_INIT_C(0x0000000000000000, 0x0000005620736b96),
        RTUINT128_INIT_C(0x00000000000001f8, 0x147aa68793ac3787), RTUINT128_INIT_C(0x0000000000000000, 0x000000382baacdc6)
    },
    { /* i=1678; 78 / 60 */
        RTUINT128_INIT_C(0x0000000000001822, 0x8e202b0e4dcd355b), RTUINT128_INIT_C(0x0000000000000000, 0x038d15685323d512),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000006cbe5), RTUINT128_INIT_C(0x0000000000000000, 0x008057f7865e5641)
    },
    { /* i=1679; 114 / 79 */
        RTUINT128_INIT_C(0x0002ee952f663036, 0x1db3f3a9c1dfabf3), RTUINT128_INIT_C(0x000000000000696c, 0xbdea6b6ec6bbb61b),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000071e9e7134), RTUINT128_INIT_C(0x00000000000026fe, 0x57df9981f9b2c377)
    },
    { /* i=1680; 28 / 111 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000096c3e84), RTUINT128_INIT_C(0x00007e1ba6aa8e53, 0x27a220cc32045eb0),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00000000096c3e84)
    },
    { /* i=1681; 110 / 20 */
        RTUINT128_INIT_C(0x00002f8dd58298b2, 0x04e3c8f9be41c246), RTUINT128_INIT_C(0x0000000000000000, 0x000000000005dcff),
        RTUINT128_INIT_C(0x00000000081c49f4, 0x8dab80dcea4fee5c), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000044a2)
    },
    { /* i=1682; 103 / 82 */
        RTUINT128_INIT_C(0x00000042fde12b18, 0x58a78dda9011c2a1), RTUINT128_INIT_C(0x0000000000000044, 0xbb090a4b309b4b15),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000f985ef24), RTUINT128_INIT_C(0x000000000000001b, 0x1f6e9c31503998ad)
    },
    { /* i=1683; 125 / 39 */
        RTUINT128_INIT_C(0x0f42e731cd550c6e, 0x74ebe821d1f66536), RTUINT128_INIT_C(0x0000000000000000, 0x0000001f893a4a69),
        RTUINT128_INIT_C(0x00000000007be30c, 0x38422b3a13aa283e), RTUINT128_INIT_C(0x0000000000000000, 0x00000008457df7c8)
    },
    { /* i=1684; 117 / 122 */
        RTUINT128_INIT_C(0x001a12f801dc6fdf, 0x2e0523b9eab4169a), RTUINT128_INIT_C(0x031c432835460705, 0x4c7b5fdceaabeb53),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x001a12f801dc6fdf, 0x2e0523b9eab4169a)
    },
    { /* i=1685; 75 / 19 */
        RTUINT128_INIT_C(0x00000000000003ef, 0xfd18174fd7453fac), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000046ebf),
        RTUINT128_INIT_C(0x0000000000000000, 0x00e36743bc396eb6), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000171e2)
    },
    { /* i=1686; 118 / 117 */
        RTUINT128_INIT_C(0x0022768b9e4ae38c, 0x58c68979be23c013), RTUINT128_INIT_C(0x0018851ef2cef0e8, 0x9087fc67525c6005),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x0009f16cab7bf2a3, 0xc83e8d126bc7600e)
    },
    { /* i=1687; 119 / 73 */
        RTUINT128_INIT_C(0x006e4b8cbf00c66b, 0xa0a1e72cf638370c), RTUINT128_INIT_C(0x00000000000001b0, 0xd331562e79ec886b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000413c492d2632), RTUINT128_INIT_C(0x0000000000000170, 0x053126718bf6b026)
    },
    { /* i=1688; 116 / 117 */
        RTUINT128_INIT_C(0x000d7f06effa9d49, 0xd7700e0c9e401dd3), RTUINT128_INIT_C(0x00007bc51e7f327f, 0x0ce36404cd78d177),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000001b), RTUINT128_INIT_C(0x0000713cb89049e3, 0x7b74818af2820646)
    },
    { /* i=1689; 117 / 114 */
        RTUINT128_INIT_C(0x00111eba86046285, 0xe08d19c68d09a885), RTUINT128_INIT_C(0x000281c246758730, 0xb3c351f00b98feea),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000006), RTUINT128_INIT_C(0x0002142cdf433761, 0xa9f92e264773af09)
    },
    { /* i=1690; 34 / 29 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000035a85b631), RTUINT128_INIT_C(0x0000000000000000, 0x000000001d5eea86),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000001d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000006c52503)
    },
    { /* i=1691; 26 / 17 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000002cb00d8), RTUINT128_INIT_C(0x0000000000000000, 0x000000000001079f),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000002b6), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000057ce)
    },
    { /* i=1692; 122 / 9 */
        RTUINT128_INIT_C(0x020e842460a1b19c, 0x89d38b2e5f4d93a1), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000001cf),
        RTUINT128_INIT_C(0x0001231e7d2aec7a, 0x8850a132f7e97f7d), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000008e)
    },
    { /* i=1693; 65 / 37 */
        RTUINT128_INIT_C(0x0000000000000000, 0x5e371ef598db00bb), RTUINT128_INIT_C(0x0000000000000000, 0x00000011fa6a8301),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000053d93ae), RTUINT128_INIT_C(0x0000000000000000, 0x00000001feff630d)
    },
    { /* i=1694; 116 / 34 */
        RTUINT128_INIT_C(0x000edd2dafacb1bb, 0x217dbd4a4b24ee28), RTUINT128_INIT_C(0x0000000000000000, 0x00000002b873b7da),
        RTUINT128_INIT_C(0x00000000000576b2, 0x8d98698fe20ffa7a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000128ae6c44)
    },
    { /* i=1695; 120 / 103 */
        RTUINT128_INIT_C(0x00af667399bfc913, 0x20f2fe204e5754de), RTUINT128_INIT_C(0x0000001a223118b5, 0xd99446f6a26bf50c),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000006b630), RTUINT128_INIT_C(0x00000017b4b6c4d1, 0x40ea89e15b9ada9e)
    },
    { /* i=1696; 5 / 100 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000d), RTUINT128_INIT_C(0x000000007c86f6e1, 0x9e4ee6930b68e620),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000d)
    },
    { /* i=1697; 118 / 98 */
        RTUINT128_INIT_C(0x003b8fd2e0f61d5b, 0xbe525f04b2385843), RTUINT128_INIT_C(0x000000023825975a, 0x95bcb8892565c101),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000001ad67b), RTUINT128_INIT_C(0x000000011b2d767f, 0x4c75438710e3c6c8)
    },
    { /* i=1698; 128 / 95 */
        RTUINT128_INIT_C(0xa6aba37d4e34a818, 0x24374188f0c4ac02), RTUINT128_INIT_C(0x0000000030ea9b9c, 0xe250e8db2bdbb3e8),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000036841726d), RTUINT128_INIT_C(0x000000001b4b79ce, 0x130803188033c23a)
    },
    { /* i=1699; 113 / 62 */
        RTUINT128_INIT_C(0x0001b9f77c8f8781, 0x69eb83280b6208f8), RTUINT128_INIT_C(0x0000000000000000, 0x2a9c3979655521d6),
        RTUINT128_INIT_C(0x0000000000000000, 0x000a5f4fb5ec4ad9), RTUINT128_INIT_C(0x0000000000000000, 0x23233d850b287e92)
    },
    { /* i=1700; 114 / 91 */
        RTUINT128_INIT_C(0x0001bac12e85a4ca, 0x9808e7a597bb184d), RTUINT128_INIT_C(0x000000000174237b, 0x9b564be8c3df7e17),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000013093ee), RTUINT128_INIT_C(0x0000000001643733, 0x7bcf13606d3ca9eb)
    },
    { /* i=1701; 77 / 33 */
        RTUINT128_INIT_C(0x0000000000001454, 0xb405219ec9791a13), RTUINT128_INIT_C(0x0000000000000000, 0x000000006b1a6248),
        RTUINT128_INIT_C(0x0000000000000000, 0x000030986436e7a5), RTUINT128_INIT_C(0x0000000000000000, 0x000000001798c9ab)
    },
    { /* i=1702; 101 / 22 */
        RTUINT128_INIT_C(0x0000000e08b49760, 0x73486cb03c4a0dea), RTUINT128_INIT_C(0x0000000000000000, 0x00000000003fb4b5),
        RTUINT128_INIT_C(0x0000000000003865, 0x2b02771794e4dfa3), RTUINT128_INIT_C(0x0000000000000000, 0x00000000001c53ab)
    },
    { /* i=1703; 127 / 106 */
        RTUINT128_INIT_C(0x56ac23608b51a6bd, 0xc2e5d30790a81a16), RTUINT128_INIT_C(0x0000024b018a08c3, 0xe9b3a831191503b9),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000025cc7f), RTUINT128_INIT_C(0x000001fd848a685a, 0x59a5a2a5d686d54f)
    },
    { /* i=1704; 116 / 88 */
        RTUINT128_INIT_C(0x000cf8d19ee02022, 0xa08c181c1956883d), RTUINT128_INIT_C(0x0000000000e1462f, 0x8f51f44889dbf1dd),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000ebdc16a), RTUINT128_INIT_C(0x0000000000bbea87, 0x2e5a73888cc3c5bb)
    },
    { /* i=1705; 122 / 48 */
        RTUINT128_INIT_C(0x01d18f9658895911, 0x686f983f2668e9a9), RTUINT128_INIT_C(0x0000000000000000, 0x00004b81a0d4c0d5),
        RTUINT128_INIT_C(0x000000000000062a, 0x752460371e37a8b9), RTUINT128_INIT_C(0x0000000000000000, 0x00002bf4ea5ac7bc)
    },
    { /* i=1706; 125 / 77 */
        RTUINT128_INIT_C(0x17e7fe44c738fca9, 0x2ffaf11058214095), RTUINT128_INIT_C(0x0000000000001e70, 0xdcaa015fb100d419),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000c90b98bfc696), RTUINT128_INIT_C(0x000000000000171e, 0x4e3fd477e6f2a3ef)
    },
    { /* i=1707; 113 / 20 */
        RTUINT128_INIT_C(0x0000cd05a2e897b8, 0xb360f5b5655e1bdb), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000b90ac),
        RTUINT128_INIT_C(0x0000000011ba44a6, 0x447f8a2dace364b8), RTUINT128_INIT_C(0x0000000000000000, 0x000000000006f03b)
    },
    { /* i=1708; 128 / 122 */
        RTUINT128_INIT_C(0x906d57edf2fb0616, 0x0cdd26d774c9994a), RTUINT128_INIT_C(0x00ff444440c5ca1e, 0x348f38aa6bad1c15),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000090), RTUINT128_INIT_C(0x00d6f18983b95518, 0x7c4d46fae369cd7a)
    },
    { /* i=1709; 121 / 71 */
        RTUINT128_INIT_C(0x014ef38f5eec826a, 0xe6114203a27ef219), RTUINT128_INIT_C(0x0000000000000050, 0x06c55ed3a980ad46),
        RTUINT128_INIT_C(0x0000000000000000, 0x00042f7d811158e8), RTUINT128_INIT_C(0x0000000000000031, 0xdd6601e402abdaa9)
    },
    { /* i=1710; 118 / 64 */
        RTUINT128_INIT_C(0x001692a98845cd2d, 0x86b724d78542815f), RTUINT128_INIT_C(0x0000000000000000, 0x83d004c26152f1cd),
        RTUINT128_INIT_C(0x0000000000000000, 0x002bd709c4c3b7b0), RTUINT128_INIT_C(0x0000000000000000, 0x0f4c9d1e2e3bb96f)
    },
    { /* i=1711; 73 / 33 */
        RTUINT128_INIT_C(0x0000000000000032, 0x98d2ac85aecdb987), RTUINT128_INIT_C(0x0000000000000000, 0x000000002e6127ed),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000117476a1028), RTUINT128_INIT_C(0x0000000000000000, 0x0000000019feac7f)
    },
    { /* i=1712; 109 / 70 */
        RTUINT128_INIT_C(0x00000af39f5faf03, 0x604ba886bd960998), RTUINT128_INIT_C(0x000000000000001b, 0x0b4ebd3b7d82fb85),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000067ab1442e8), RTUINT128_INIT_C(0x0000000000000019, 0xcef75580bca5cf10)
    },
    { /* i=1713; 69 / 86 */
        RTUINT128_INIT_C(0x0000000000000007, 0x30a9f261176cb813), RTUINT128_INIT_C(0x000000000028bf1f, 0xddd6f00938b89074),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000007, 0x30a9f261176cb813)
    },
    { /* i=1714; 120 / 89 */
        RTUINT128_INIT_C(0x00bf287b6557b7fb, 0x5559806e5e35898c), RTUINT128_INIT_C(0x00000000019487c2, 0x2d35c944a8a0f3f6),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000078f89af4), RTUINT128_INIT_C(0x0000000000ce8142, 0xb9738f452bbb0714)
    },
    { /* i=1715; 121 / 75 */
        RTUINT128_INIT_C(0x018a617b2a013763, 0x567f667a782c277e), RTUINT128_INIT_C(0x0000000000000379, 0xed08a9ebc3009452),
        RTUINT128_INIT_C(0x0000000000000000, 0x00007173060028bc), RTUINT128_INIT_C(0x00000000000002d8, 0x8848f08f40926b46)
    },
    { /* i=1716; 32 / 9 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000a9a45576), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000a9),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000100f8ee), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000058)
    },
    { /* i=1717; 29 / 16 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000001d25b743), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000007934),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000003d90), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000002603)
    },
    { /* i=1718; 41 / 14 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000001141dd65f8), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000247f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000790ce3), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000155b)
    },
    { /* i=1719; 114 / 67 */
        RTUINT128_INIT_C(0x0001fa56b8ad7292, 0x49625fb0aa24288c), RTUINT128_INIT_C(0x0000000000000003, 0x8ea486401d8254d2),
        RTUINT128_INIT_C(0x0000000000000000, 0x00008e578ee48cf5), RTUINT128_INIT_C(0x0000000000000001, 0x58b2f1b31efe2392)
    },
    { /* i=1720; 38 / 17 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000010d6484730), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000ee74),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000121375), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000b02c)
    },
    { /* i=1721; 124 / 105 */
        RTUINT128_INIT_C(0x0c990647b43b6270, 0x90438fe369d4ba53), RTUINT128_INIT_C(0x000001caa4eb96cd, 0x5cfe370f8be9ef56),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000007081a), RTUINT128_INIT_C(0x0000001a77fa1bb9, 0xab4ca88a593dbb97)
    },
    { /* i=1722; 97 / 52 */
        RTUINT128_INIT_C(0x0000000047e3f392, 0x9c0b6a10ba02f3d4), RTUINT128_INIT_C(0x0000000000000000, 0x00063fbfe7c4a6df),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000b8117d45fb3), RTUINT128_INIT_C(0x0000000000000000, 0x00025aa877e984e7)
    },
    { /* i=1723; 116 / 117 */
        RTUINT128_INIT_C(0x000bc3bc6132c8bb, 0xafb19f833a080c1c), RTUINT128_INIT_C(0x00119abe9f81bb24, 0xd6c86830331487e4),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000bc3bc6132c8bb, 0xafb19f833a080c1c)
    },
    { /* i=1724; 122 / 14 */
        RTUINT128_INIT_C(0x03e004d56b432dc5, 0xdcb058610d92f2de), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000396c),
        RTUINT128_INIT_C(0x00001146a64d84c1, 0xe4ef4b2b43efcbf2), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000006c6)
    },
    { /* i=1725; 115 / 65 */
        RTUINT128_INIT_C(0x000423209298eec2, 0x4e1b732bf767b5a2), RTUINT128_INIT_C(0x0000000000000001, 0x02133aaa1886af6b),
        RTUINT128_INIT_C(0x0000000000000000, 0x00041a9c6f5c7041), RTUINT128_INIT_C(0x0000000000000000, 0x2a3c299661025b77)
    },
    { /* i=1726; 66 / 46 */
        RTUINT128_INIT_C(0x0000000000000002, 0x4c94e726dce745fc), RTUINT128_INIT_C(0x0000000000000000, 0x00000a6a09ce22ee),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000388464), RTUINT128_INIT_C(0x0000000000000000, 0x000003951a4ee904)
    },
    { /* i=1727; 113 / 94 */
        RTUINT128_INIT_C(0x0001e8f2f1cd4cb8, 0x89d238d710a3b64e), RTUINT128_INIT_C(0x000000002f7f0802, 0x0407ae39fd1ca762),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000a4b63), RTUINT128_INIT_C(0x000000000c407475, 0xec8af8243fb14568)
    },
    { /* i=1728; 70 / 27 */
        RTUINT128_INIT_C(0x0000000000000002, 0xf615b51aaff7ca08), RTUINT128_INIT_C(0x0000000000000000, 0x00000000042df55f),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000b5616ec4f9), RTUINT128_INIT_C(0x0000000000000000, 0x00000000019564a1)
    },
    { /* i=1729; 85 / 20 */
        RTUINT128_INIT_C(0x00000000001aa891, 0x167b39d02dec9bfd), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000998bf),
        RTUINT128_INIT_C(0x0000000000000002, 0xc723b394748a227c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000074179)
    },
    { /* i=1730; 39 / 5 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000040384fabf6), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000016),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000002eb49708b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000004)
    },
    { /* i=1731; 48 / 20 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000057858352eb56), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000732de),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000c287054), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000051a7e)
    },
    { /* i=1732; 62 / 11 */
        RTUINT128_INIT_C(0x0000000000000000, 0x02da371be95337a2), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000155),
        RTUINT128_INIT_C(0x0000000000000000, 0x0002243261876041), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000010d)
    },
    { /* i=1733; 108 / 26 */
        RTUINT128_INIT_C(0x00000f24e7098168, 0x6ca7cf43e3a9acf1), RTUINT128_INIT_C(0x0000000000000000, 0x00000000008a7da0),
        RTUINT128_INIT_C(0x00000000001bfe73, 0x90c7653e53a9aa36), RTUINT128_INIT_C(0x0000000000000000, 0x000000000066ed31)
    },
    { /* i=1734; 1 / 124 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x03392192fc0710c4, 0xac6a39960c03b45a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001)
    },
    { /* i=1735; 124 / 126 */
        RTUINT128_INIT_C(0x0c113768085dfcb8, 0x19220e9f8740985f), RTUINT128_INIT_C(0x30bf4242a1dee97a, 0x6e3bab6d7145b2a8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0c113768085dfcb8, 0x19220e9f8740985f)
    },
    { /* i=1736; 123 / 69 */
        RTUINT128_INIT_C(0x04a7b237ad555cf6, 0xd9754266875779f6), RTUINT128_INIT_C(0x0000000000000007, 0x2e127ff629bde0e5),
        RTUINT128_INIT_C(0x0000000000000000, 0x00a5f99fc767a534), RTUINT128_INIT_C(0x0000000000000006, 0x2a75cb0c2baf3272)
    },
    { /* i=1737; 89 / 88 */
        RTUINT128_INIT_C(0x00000000011bbcfb, 0x96b64b876516840f), RTUINT128_INIT_C(0x0000000000253a2b, 0xe27654954036df10),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000007), RTUINT128_INIT_C(0x00000000001725c8, 0x6579fb72a3966a9f)
    },
    { /* i=1738; 39 / 1 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000004dfe76245e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000004dfe76245e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=1739; 125 / 115 */
        RTUINT128_INIT_C(0x0bc15ebedca16e65, 0xfa1ab5493ad16b19), RTUINT128_INIT_C(0x00012aa9c283812c, 0x0051c5a6e5b294fc),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000a13), RTUINT128_INIT_C(0x0000928c49d3201e, 0xc25084ed34be8465)
    },
    { /* i=1740; 115 / 69 */
        RTUINT128_INIT_C(0x0001b4731cab388f, 0x09a2312cd2d859ef), RTUINT128_INIT_C(0x0000000000000000, 0x2383da82ebdfb630),
        RTUINT128_INIT_C(0x0000000000000000, 0x000c4a0571d72c49), RTUINT128_INIT_C(0x0000000000000000, 0x21201a0fea6d263f)
    },
    { /* i=1741; 96 / 69 */
        RTUINT128_INIT_C(0x000000006024deee, 0xd17147d834261fbc), RTUINT128_INIT_C(0x000000000000001b, 0xd2b3bbd0696dad8b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000003749f16), RTUINT128_INIT_C(0x0000000000000008, 0x88aca3b8c1f3e0ca)
    },
    { /* i=1742; 120 / 99 */
        RTUINT128_INIT_C(0x00a3be8c51921d94, 0x47df3e44f753077e), RTUINT128_INIT_C(0x00000003bada5e03, 0xc39dc6b1ad908bc5),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000002be688), RTUINT128_INIT_C(0x000000031276ee54, 0x3bb1e6a96adec8d6)
    },
    { /* i=1743; 99 / 71 */
        RTUINT128_INIT_C(0x00000004cdb759ae, 0x7825320d7bfcf1f7), RTUINT128_INIT_C(0x0000000000000022, 0x03713c4ae3ea759f),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000002427611b), RTUINT128_INIT_C(0x000000000000000f, 0x7be5c48954784b32)
    },
    { /* i=1744; 84 / 4 */
        RTUINT128_INIT_C(0x000000000002660d, 0xa58d5b405786e1e5), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000e),
        RTUINT128_INIT_C(0x0000000000002bdc, 0x6740f43b73f75947), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003)
    },
    { /* i=1745; 108 / 122 */
        RTUINT128_INIT_C(0x00000c1f9bd401d5, 0x260ae8604f5cf0b0), RTUINT128_INIT_C(0x008ac75e171361dc, 0xbfe988f42b9371a9),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00000c1f9bd401d5, 0x260ae8604f5cf0b0)
    },
    { /* i=1746; 117 / 48 */
        RTUINT128_INIT_C(0x001d436eb84eb012, 0xb009a3da58248a2d), RTUINT128_INIT_C(0x0000000000000000, 0x00000f6545e66ba7),
        RTUINT128_INIT_C(0x00000000000001e6, 0x98832a44824d3e75), RTUINT128_INIT_C(0x0000000000000000, 0x00000c4e6887e4da)
    },
    { /* i=1747; 122 / 47 */
        RTUINT128_INIT_C(0x0356d880818f86b3, 0xb715d6995ac8d535), RTUINT128_INIT_C(0x0000000000000000, 0x000013ad29b96621),
        RTUINT128_INIT_C(0x0000000000002b71, 0xf7f589c8a34ee600), RTUINT128_INIT_C(0x0000000000000000, 0x00000dd0a7f92f35)
    },
    { /* i=1748; 113 / 121 */
        RTUINT128_INIT_C(0x0000a7c3b91d7fae, 0x3ecd600887343512), RTUINT128_INIT_C(0x01b9dab82cf3069d, 0xf911efe652a80d8f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000a7c3b91d7fae, 0x3ecd600887343512)
    },
    { /* i=1749; 77 / 38 */
        RTUINT128_INIT_C(0x0000000000001cff, 0x0dcbab8e1b6e207c), RTUINT128_INIT_C(0x0000000000000000, 0x000000022b1236c2),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000d5f87400ed1), RTUINT128_INIT_C(0x0000000000000000, 0x00000001f410d01a)
    },
    { /* i=1750; 126 / 111 */
        RTUINT128_INIT_C(0x17e91f4b4dbd4a49, 0x104a91234a6835f6), RTUINT128_INIT_C(0x00003b810f228bbc, 0x9f5dced737940703),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000066de), RTUINT128_INIT_C(0x000019586a1af537, 0x7c87725c1d3eef5c)
    },
    { /* i=1751; 17 / 13 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000009737), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000008bd),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000011), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000002aa)
    },
    { /* i=1752; 113 / 56 */
        RTUINT128_INIT_C(0x000154f5db0ca34e, 0x4a8f8a46c9664ec0), RTUINT128_INIT_C(0x0000000000000000, 0x004bde56ce721545),
        RTUINT128_INIT_C(0x0000000000000000, 0x047e7d12acd9bf6f), RTUINT128_INIT_C(0x0000000000000000, 0x001f89c3c4939ad5)
    },
    { /* i=1753; 82 / 38 */
        RTUINT128_INIT_C(0x000000000002bfcf, 0xe6f8930bd725a38f), RTUINT128_INIT_C(0x0000000000000000, 0x0000002b6ba86c57),
        RTUINT128_INIT_C(0x0000000000000000, 0x000010358e039f53), RTUINT128_INIT_C(0x0000000000000000, 0x00000005cd3b7a5a)
    },
    { /* i=1754; 128 / 52 */
        RTUINT128_INIT_C(0x9dbabf2b613f6ce2, 0xc2e844585fa03df0), RTUINT128_INIT_C(0x0000000000000000, 0x0008341921ad8517),
        RTUINT128_INIT_C(0x000000000000133a, 0x21a4273464374639), RTUINT128_INIT_C(0x0000000000000000, 0x00063d99d9a851d1)
    },
    { /* i=1755; 79 / 50 */
        RTUINT128_INIT_C(0x0000000000003d30, 0xae6fa331a39f1de7), RTUINT128_INIT_C(0x0000000000000000, 0x0000350e0c69c97d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000127411ad9), RTUINT128_INIT_C(0x0000000000000000, 0x00002efb2bbfa0f2)
    },
    { /* i=1756; 116 / 109 */
        RTUINT128_INIT_C(0x0004cf0263700ca3, 0x99799919a038c7b9), RTUINT128_INIT_C(0x000004bb843a7e6d, 0x8c3e5006ae4a88ef),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000104), RTUINT128_INIT_C(0x000000901807a561, 0x2a3052509c85b4fd)
    },
    { /* i=1757; 114 / 56 */
        RTUINT128_INIT_C(0x00015045435e5f4f, 0x45ba14c26fe1f19b), RTUINT128_INIT_C(0x0000000000000000, 0x00c7e8e687694293),
        RTUINT128_INIT_C(0x0000000000000000, 0x01ae9edf580f7181), RTUINT128_INIT_C(0x0000000000000000, 0x007020b84ed78288)
    },
    { /* i=1758; 62 / 58 */
        RTUINT128_INIT_C(0x0000000000000000, 0x004183adf0987845), RTUINT128_INIT_C(0x0000000000000000, 0x033b17d664e38e77),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x004183adf0987845)
    },
    { /* i=1759; 124 / 112 */
        RTUINT128_INIT_C(0x0c638f46d295ed72, 0x834ef404bb0515ed), RTUINT128_INIT_C(0x0000881c95c545cc, 0x31107dfdd22b7a50),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000174d), RTUINT128_INIT_C(0x00000d390cfa969f, 0x460740ca9bf41bdd)
    },
    { /* i=1760; 1 / 104 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000008680fc8202, 0xc8665ae140fcd7d3),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=1761; 123 / 77 */
        RTUINT128_INIT_C(0x05ed29827ada3a90, 0x2f8609984e7dfba6), RTUINT128_INIT_C(0x000000000000129c, 0x28ba886808ca20be),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000518627a9e68d), RTUINT128_INIT_C(0x0000000000000ecd, 0xb60d96854e513f00)
    },
    { /* i=1762; 67 / 36 */
        RTUINT128_INIT_C(0x0000000000000002, 0xa898061fccd2d156), RTUINT128_INIT_C(0x0000000000000000, 0x000000016058b39a),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000001ee7d974c), RTUINT128_INIT_C(0x0000000000000000, 0x00000000025ba99e)
    },
    { /* i=1763; 34 / 11 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000021e9d380a), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000007e0),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000044e744), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000008a)
    },
    { /* i=1764; 91 / 2 */
        RTUINT128_INIT_C(0x000000000631ef72, 0x632893f5d758278e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002),
        RTUINT128_INIT_C(0x000000000318f7b9, 0x319449faebac13c7), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=1765; 128 / 60 */
        RTUINT128_INIT_C(0x63542ebfd5b03df9, 0x844552e810764688), RTUINT128_INIT_C(0x0000000000000000, 0x0a7e36db01722ee4),
        RTUINT128_INIT_C(0x0000000000000009, 0x775771a1aa629847), RTUINT128_INIT_C(0x0000000000000000, 0x00e7911182abe54c)
    },
    { /* i=1766; 121 / 84 */
        RTUINT128_INIT_C(0x00dae902242276a8, 0x6f8974854192c047), RTUINT128_INIT_C(0x0000000000036124, 0x2c5669ef8ca6f578),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000040c6d68e08), RTUINT128_INIT_C(0x000000000002fae0, 0x1f4d31983de28487)
    },
    { /* i=1767; 124 / 119 */
        RTUINT128_INIT_C(0x0c59830b4e4f97ed, 0x86958c8b0dc307b2), RTUINT128_INIT_C(0x007e5fc2f6627311, 0xe03b6e35908d697b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000019), RTUINT128_INIT_C(0x000229013eb25b2e, 0xa0c7c94feff3baaf)
    },
    { /* i=1768; 120 / 98 */
        RTUINT128_INIT_C(0x004ff35e60d477f8, 0x24df3c737616467a), RTUINT128_INIT_C(0x00000002ba5031f0, 0xcfcc168ee9fca1e5),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000001d4f4a), RTUINT128_INIT_C(0x000000001df52e1d, 0x8aba1b508628cf48)
    },
    { /* i=1769; 120 / 60 */
        RTUINT128_INIT_C(0x0098457a9a91185f, 0xacddf99c5e0775b6), RTUINT128_INIT_C(0x0000000000000000, 0x02c05131ce2c0e5b),
        RTUINT128_INIT_C(0x0000000000000000, 0x3758b3307abf8873), RTUINT128_INIT_C(0x0000000000000000, 0x0258e6ef44b7aad5)
    },
    { /* i=1770; 122 / 61 */
        RTUINT128_INIT_C(0x01a019f0dda32227, 0x81fcb43d5a7aec8e), RTUINT128_INIT_C(0x0000000000000000, 0x145d0be89d0c613f),
        RTUINT128_INIT_C(0x0000000000000000, 0x146f085fd0c66893), RTUINT128_INIT_C(0x0000000000000000, 0x0d41c8e6be237d61)
    },
    { /* i=1771; 70 / 44 */
        RTUINT128_INIT_C(0x0000000000000031, 0x6ca48bdee5d2b6c4), RTUINT128_INIT_C(0x0000000000000000, 0x00000be324041577),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000042862d5), RTUINT128_INIT_C(0x0000000000000000, 0x0000031f279d4cc1)
    },
    { /* i=1772; 58 / 1 */
        RTUINT128_INIT_C(0x0000000000000000, 0x03e5e798d88da00f), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001),
        RTUINT128_INIT_C(0x0000000000000000, 0x03e5e798d88da00f), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=1773; 122 / 65 */
        RTUINT128_INIT_C(0x0049a9cdc5496481, 0x3181f42607f86046), RTUINT128_INIT_C(0x0000000000000000, 0x86ed6d3675c397dd),
        RTUINT128_INIT_C(0x0000000000000000, 0x008bc3364cbcad48), RTUINT128_INIT_C(0x0000000000000000, 0x240a82e89909511e)
    },
    { /* i=1774; 126 / 122 */
        RTUINT128_INIT_C(0x083c6013340319a8, 0x33024af7c8859637), RTUINT128_INIT_C(0x013d7777147360d9, 0xa63c0363d1df0c7c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000006), RTUINT128_INIT_C(0x00cb9348b94ed48e, 0x4d9a36a0dd4b4b4f)
    },
    { /* i=1775; 119 / 108 */
        RTUINT128_INIT_C(0x0062def812bfe48f, 0x7cd3e48e234028bb), RTUINT128_INIT_C(0x00000c58d007bb1e, 0x162fdb8b8f2000e1),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000801), RTUINT128_INIT_C(0x00000c1f04df38bf, 0xe7c7ac8994191fda)
    },
    { /* i=1776; 25 / 68 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000013cb7b4), RTUINT128_INIT_C(0x0000000000000003, 0xdacc33b552a16941),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00000000013cb7b4)
    },
    { /* i=1777; 116 / 85 */
        RTUINT128_INIT_C(0x000dd0b9f1bc82dc, 0x0bbec1ea16831224), RTUINT128_INIT_C(0x000000000011713a, 0x486abd82c6a90912),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000cac46aa2), RTUINT128_INIT_C(0x00000000000d0ebb, 0xbcd934533c01e0c0)
    },
    { /* i=1778; 78 / 38 */
        RTUINT128_INIT_C(0x000000000000000e, 0xcee30b4a6b0d4254), RTUINT128_INIT_C(0x0000000000000000, 0x0000002892d4470a),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000005d6eb5f2), RTUINT128_INIT_C(0x0000000000000000, 0x0000001a5fdc08e0)
    },
    { /* i=1779; 40 / 18 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000a7d4b5686), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000205eb),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000052f4e), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000063ec)
    },
    { /* i=1780; 114 / 125 */
        RTUINT128_INIT_C(0x0002c4cdf81ac817, 0xde83913392e2e734), RTUINT128_INIT_C(0x1d7ada5e792d853e, 0x25c1f27987021792),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0002c4cdf81ac817, 0xde83913392e2e734)
    },
    { /* i=1781; 114 / 98 */
        RTUINT128_INIT_C(0x0002fb7d44370b29, 0xb50ad4d81e2aa759), RTUINT128_INIT_C(0x00000003de0ed5c0, 0xe6743eff12f3aa74),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000c56a), RTUINT128_INIT_C(0x00000001e79517f2, 0xd46e75a4c31acf51)
    },
    { /* i=1782; 84 / 43 */
        RTUINT128_INIT_C(0x00000000000ccfa1, 0x8ee7f98c16bf6a0b), RTUINT128_INIT_C(0x0000000000000000, 0x000003f51652669f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000033cbd5bb47e), RTUINT128_INIT_C(0x0000000000000000, 0x000003e74c841bc9)
    },
    { /* i=1783; 127 / 105 */
        RTUINT128_INIT_C(0x2fdb2cf94b66dfb5, 0xe8ccc90b06558964), RTUINT128_INIT_C(0x00000115bf1b3561, 0x2297d3a4b06721fc),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000002c1bf4), RTUINT128_INIT_C(0x0000006a1a24ce62, 0x8c765fbe2c239134)
    },
    { /* i=1784; 123 / 53 */
        RTUINT128_INIT_C(0x01fecc8584405714, 0xb84bf0114e6f3da4), RTUINT128_INIT_C(0x0000000000000000, 0x0014febe90a5cf3e),
        RTUINT128_INIT_C(0x0000000000000018, 0x54562eed2ebb82c5), RTUINT128_INIT_C(0x0000000000000000, 0x0003ad36454f46ee)
    },
    { /* i=1785; 87 / 44 */
        RTUINT128_INIT_C(0x00000000005a5679, 0x34fafe27f5f631be), RTUINT128_INIT_C(0x0000000000000000, 0x000009593f85ab44),
        RTUINT128_INIT_C(0x0000000000000000, 0x000009a9c884c1a6), RTUINT128_INIT_C(0x0000000000000000, 0x000002c7901adfa6)
    },
    { /* i=1786; 77 / 74 */
        RTUINT128_INIT_C(0x0000000000001f1e, 0x8232cb6bc73ac738), RTUINT128_INIT_C(0x0000000000000391, 0xc598ff0d7d282a96),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000008), RTUINT128_INIT_C(0x0000000000000290, 0x556ad2ffddf97288)
    },
    { /* i=1787; 120 / 88 */
        RTUINT128_INIT_C(0x00c75d0a90a484e2, 0x94cc4f23de692940), RTUINT128_INIT_C(0x0000000000cd1748, 0x523a247f9ae3fbea),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000f8d9cc6b), RTUINT128_INIT_C(0x000000000068217d, 0x533237153b066672)
    },
    { /* i=1788; 121 / 77 */
        RTUINT128_INIT_C(0x00130e01073c1f4d, 0xf13fbecb849ace11), RTUINT128_INIT_C(0x00000000000006a3, 0x9a5ea05af3ebce82),
        RTUINT128_INIT_C(0x0000000000000000, 0x000002debdd957c2), RTUINT128_INIT_C(0x000000000000027c, 0x5bc35de58288218d)
    },
    { /* i=1789; 126 / 110 */
        RTUINT128_INIT_C(0x3dfe0dfa55ab1ac9, 0xa919bc991157a5b9), RTUINT128_INIT_C(0x0000132b3be4d54c, 0xb850c1011462b3b1),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000033be8), RTUINT128_INIT_C(0x0000044fd13af5d5, 0xc06c56c3bd680251)
    },
    { /* i=1790; 113 / 66 */
        RTUINT128_INIT_C(0x00006b0503c1b989, 0x909ae34d0b75e37b), RTUINT128_INIT_C(0x0000000000000000, 0x4830cf4ccb6b40a9),
        RTUINT128_INIT_C(0x0000000000000000, 0x00017b82555aa0fa), RTUINT128_INIT_C(0x0000000000000000, 0x19a54a2c83e51e71)
    },
    { /* i=1791; 127 / 118 */
        RTUINT128_INIT_C(0x209a18b566461c8d, 0xfa686ff7fce28a1a), RTUINT128_INIT_C(0x001830109cd1f2be, 0x652b3cdca672b5a3),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000159), RTUINT128_INIT_C(0x000152520f55f9f7, 0xa3236a9bac4bc16f)
    },
    { /* i=1792; 33 / 5 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000103eecbc6), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000013fead36), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000008)
    },
    { /* i=1793; 34 / 76 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000002d41e4829), RTUINT128_INIT_C(0x0000000000000832, 0x225d4283e08950cb),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00000002d41e4829)
    },
    { /* i=1794; 118 / 70 */
        RTUINT128_INIT_C(0x000375b260f5edcc, 0xba31cfdf9a6385b4), RTUINT128_INIT_C(0x000000000000000a, 0x279713bd76dd11a7),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000573887864757), RTUINT128_INIT_C(0x0000000000000009, 0xff2a24f696f334f3)
    },
    { /* i=1795; 125 / 96 */
        RTUINT128_INIT_C(0x0e38e0d1246ef089, 0xfc40d4723578d380), RTUINT128_INIT_C(0x0000000085b55d5d, 0x186da780b0e668d2),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000001b3adfc7), RTUINT128_INIT_C(0x000000003f742b61, 0xf44a240e177a6a42)
    },
    { /* i=1796; 119 / 127 */
        RTUINT128_INIT_C(0x0020a1f378f1e1fc, 0x771cfa47163198e8), RTUINT128_INIT_C(0x1fcdceeab0b767be, 0x3c7cecc5eebb6d20),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0020a1f378f1e1fc, 0x771cfa47163198e8)
    },
    { /* i=1797; 126 / 67 */
        RTUINT128_INIT_C(0x0669b61f1a2c18af, 0x94f566f6f2b816f6), RTUINT128_INIT_C(0x0000000000000005, 0xf6adc24c2b436478),
        RTUINT128_INIT_C(0x0000000000000000, 0x01134a06e6c0a8b5), RTUINT128_INIT_C(0x0000000000000004, 0x91130118f8234e1e)
    },
    { /* i=1798; 29 / 14 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000001f38f4fa), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001674),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000163fb), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000153e)
    },
    { /* i=1799; 124 / 81 */
        RTUINT128_INIT_C(0x056bd43794fad27a, 0xba883fee92fcbe28), RTUINT128_INIT_C(0x000000000000676e, 0xc523c0921681c39b),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000d6aee723d5c), RTUINT128_INIT_C(0x000000000000131c, 0xe227b5405bb88374)
    },
    { /* i=1800; 31 / 3 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000037e75c07), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000012a27402), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001)
    },
    { /* i=1801; 91 / 67 */
        RTUINT128_INIT_C(0x000000000768f87c, 0x56efa78a4ac01489), RTUINT128_INIT_C(0x0000000000000005, 0xf5c749ebb190878a),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000013e47a1), RTUINT128_INIT_C(0x0000000000000004, 0xac533a882bd790bf)
    },
    { /* i=1802; 118 / 40 */
        RTUINT128_INIT_C(0x0005efa7c303e8d5, 0xce71376aa347ebbf), RTUINT128_INIT_C(0x0000000000000000, 0x00000017b9a705f0),
        RTUINT128_INIT_C(0x000000000000400d, 0x675a21de5d208ef0), RTUINT128_INIT_C(0x0000000000000000, 0x0000000903673abf)
    },
    { /* i=1803; 127 / 90 */
        RTUINT128_INIT_C(0x0e27dc2a5b5cf26d, 0x552d5a84365acdcb), RTUINT128_INIT_C(0x0000000000ae3378, 0x9b0b533011129a64),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000014cd80a014), RTUINT128_INIT_C(0x00000000003d7511, 0xb9245157fa683dfb)
    },
    { /* i=1804; 118 / 63 */
        RTUINT128_INIT_C(0x0033a016c797136d, 0x762b3a904b3776e1), RTUINT128_INIT_C(0x0000000000000000, 0x184261323e6411c1),
        RTUINT128_INIT_C(0x0000000000000000, 0x0220c8d70c0549bd), RTUINT128_INIT_C(0x0000000000000000, 0x10808acd4d815264)
    },
    { /* i=1805; 125 / 109 */
        RTUINT128_INIT_C(0x197e7a2fce994b2e, 0x8ce93908c155b177), RTUINT128_INIT_C(0x00001ebdfd4b0266, 0xa5b4861470cdb5d4),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000d44c), RTUINT128_INIT_C(0x000004067e57937b, 0xdc487d8ce9b02687)
    },
    { /* i=1806; 120 / 66 */
        RTUINT128_INIT_C(0x0074d3513fa1d602, 0x9efe6da37b07b78c), RTUINT128_INIT_C(0x0000000000000000, 0x663d9b2d9abe337e),
        RTUINT128_INIT_C(0x0000000000000000, 0x012484d38945fa7a), RTUINT128_INIT_C(0x0000000000000000, 0x27f4091daf242180)
    },
    { /* i=1807; 26 / 9 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000013fe4ba), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000167),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000e41d), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000f)
    },
    { /* i=1808; 107 / 113 */
        RTUINT128_INIT_C(0x000005eca60e8577, 0x8e879e7b5a7c5f93), RTUINT128_INIT_C(0x0001b826aabe6cbb, 0x26fcf666141e3d2f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000005eca60e8577, 0x8e879e7b5a7c5f93)
    },
    { /* i=1809; 77 / 15 */
        RTUINT128_INIT_C(0x0000000000001ec8, 0x63dd0ead6eeb8db9), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000003543),
        RTUINT128_INIT_C(0x0000000000000000, 0x93f4bb78b7f2e984), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001c2d)
    },
    { /* i=1810; 64 / 2 */
        RTUINT128_INIT_C(0x0000000000000000, 0xc43ba97cf36b0924), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003),
        RTUINT128_INIT_C(0x0000000000000000, 0x4169387efbce5861), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001)
    },
    { /* i=1811; 83 / 78 */
        RTUINT128_INIT_C(0x000000000007b99c, 0x545a0085aa86fe5f), RTUINT128_INIT_C(0x00000000000020fc, 0x382c60a14bc295ab),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000003b), RTUINT128_INIT_C(0x0000000000001f7b, 0x621fbb5934ae7ff6)
    },
    { /* i=1812; 116 / 105 */
        RTUINT128_INIT_C(0x000d5e53c6908848, 0x7f31d1880500c596), RTUINT128_INIT_C(0x000000866618d9f7, 0xea4269e370b6baf7),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001976), RTUINT128_INIT_C(0x0000006849d2da22, 0x083dccb0388478bc)
    },
    { /* i=1813; 123 / 33 */
        RTUINT128_INIT_C(0x05957d5765b054a1, 0x80746bca08382d70), RTUINT128_INIT_C(0x0000000000000000, 0x0000000190dc8345),
        RTUINT128_INIT_C(0x000000000390e84f, 0x21c2b1bc2e4753e5), RTUINT128_INIT_C(0x0000000000000000, 0x00000001264461b7)
    },
    { /* i=1814; 113 / 106 */
        RTUINT128_INIT_C(0x00015bde69a8f2ba, 0xa582942536dd829e), RTUINT128_INIT_C(0x000002b863ec97d6, 0x7e163009bcb7fb3c),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000007f), RTUINT128_INIT_C(0x00000264d7499f52, 0x1880bf509797dfda)
    },
    { /* i=1815; 120 / 7 */
        RTUINT128_INIT_C(0x008f627cb3b84897, 0x6278127b175b3479), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000007a),
        RTUINT128_INIT_C(0x00012cdf72c8dad3, 0x13b13f1a3074284c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000041)
    },
    { /* i=1816; 125 / 81 */
        RTUINT128_INIT_C(0x0d3086bb52271411, 0x1e20e02f69fa6572), RTUINT128_INIT_C(0x0000000000011d68, 0xba4abc1b60ff3747),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000bd49a46b682), RTUINT128_INIT_C(0x000000000000d702, 0x2fe2027ce3a9d964)
    },
    { /* i=1817; 59 / 29 */
        RTUINT128_INIT_C(0x0000000000000000, 0x033c1b39245d1b1c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000006f5b1c6),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000076fc346d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000002bc31ce)
    },
    { /* i=1818; 76 / 54 */
        RTUINT128_INIT_C(0x0000000000000a0e, 0xd2e42bde830173f9), RTUINT128_INIT_C(0x0000000000000000, 0x001794b2033b5f44),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000006d30fc), RTUINT128_INIT_C(0x0000000000000000, 0x00010bc0a2beed09)
    },
    { /* i=1819; 102 / 46 */
        RTUINT128_INIT_C(0x00000009ef4eb6c9, 0xa00ca7edb5ab69bd), RTUINT128_INIT_C(0x0000000000000000, 0x0000222f92f45baa),
        RTUINT128_INIT_C(0x0000000000000000, 0x004a6582ca4f0f1e), RTUINT128_INIT_C(0x0000000000000000, 0x000014adbe33b5d1)
    },
    { /* i=1820; 96 / 5 */
        RTUINT128_INIT_C(0x00000000f4d02e94, 0x1b4439c943073db2), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000017),
        RTUINT128_INIT_C(0x000000000aa4e0a2, 0x43f7d5fd9ebd883f), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000009)
    },
    { /* i=1821; 93 / 90 */
        RTUINT128_INIT_C(0x0000000011ce90ef, 0x7f1663f9284c3b54), RTUINT128_INIT_C(0x00000000011e6b60, 0x211ba0352bd47cfe),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000f), RTUINT128_INIT_C(0x000000000106464d, 0x8e7800db96d8e872)
    },
    { /* i=1822; 75 / 29 */
        RTUINT128_INIT_C(0x0000000000000499, 0x78ee1df1d6a8c66f), RTUINT128_INIT_C(0x0000000000000000, 0x0000000001b73b07),
        RTUINT128_INIT_C(0x0000000000000000, 0x0002ae4661761ee0), RTUINT128_INIT_C(0x0000000000000000, 0x0000000001304e4f)
    },
    { /* i=1823; 43 / 7 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000003104bb1a427), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000039),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000dc27365af), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000030)
    },
    { /* i=1824; 60 / 26 */
        RTUINT128_INIT_C(0x0000000000000000, 0x092742d1e47a2e4b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000002451241),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000004085c2e64), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000db5ee7)
    },
    { /* i=1825; 81 / 34 */
        RTUINT128_INIT_C(0x0000000000001780, 0x64b4533c4ebe9212), RTUINT128_INIT_C(0x0000000000000000, 0x00000002a9e5bdad),
        RTUINT128_INIT_C(0x0000000000000000, 0x000008d2b151a5be), RTUINT128_INIT_C(0x0000000000000000, 0x00000001823e4aac)
    },
    { /* i=1826; 31 / 36 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000003bf813f), RTUINT128_INIT_C(0x0000000000000000, 0x00000007b22389e6),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000003bf813f)
    },
    { /* i=1827; 117 / 69 */
        RTUINT128_INIT_C(0x000ef6e274ba6fdf, 0xadc1ca3fddbb2857), RTUINT128_INIT_C(0x0000000000000008, 0x9fb4111a5712c46f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0001bc385f82f02f), RTUINT128_INIT_C(0x0000000000000000, 0x7d2e4a1357c307f6)
    },
    { /* i=1828; 120 / 83 */
        RTUINT128_INIT_C(0x00a2a335973a85ac, 0xec2b1c786defc24b), RTUINT128_INIT_C(0x000000000007acc8, 0x6ab3ecb566ee776a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000001530d48b37), RTUINT128_INIT_C(0x000000000007106a, 0xd2e7030b12158c85)
    },
    { /* i=1829; 121 / 108 */
        RTUINT128_INIT_C(0x01c108d5c5d540c7, 0xe4df624d84c18f24), RTUINT128_INIT_C(0x0000020027fbc234, 0xa81758badaa09237),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000e072), RTUINT128_INIT_C(0x000001c7adcab240, 0x9cd65fcba95052a6)
    },
    { /* i=1830; 116 / 114 */
        RTUINT128_INIT_C(0x000cedfd4b576356, 0x00db0cc2121c265d), RTUINT128_INIT_C(0x00013e8e33ce7bbf, 0x4f28261905dc4be3),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000a), RTUINT128_INIT_C(0x00007c6f45468ddc, 0xe9498fc7d7812f7f)
    },
    { /* i=1831; 115 / 69 */
        RTUINT128_INIT_C(0x0007269672de4e9a, 0xf00002ca566c40b1), RTUINT128_INIT_C(0x0000000000000011, 0x124d0a23f9ad9968),
        RTUINT128_INIT_C(0x0000000000000000, 0x00006b3b0f7500d4), RTUINT128_INIT_C(0x0000000000000003, 0xf00081b35e213691)
    },
    { /* i=1832; 113 / 113 */
        RTUINT128_INIT_C(0x0000fd5a22d83d89, 0xa14c2f33b8d880ee), RTUINT128_INIT_C(0x000186fe60a07bbc, 0x0cfc0b67f7b0493e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000fd5a22d83d89, 0xa14c2f33b8d880ee)
    },
    { /* i=1833; 118 / 103 */
        RTUINT128_INIT_C(0x002d934e970d9711, 0xbf5e692962dcb778), RTUINT128_INIT_C(0x0000000b10d3ab57, 0x21ede9c04c6cb9e2),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000041e5d), RTUINT128_INIT_C(0x00000001feb79ab8, 0xe38ac3a5fa0cb45e)
    },
    { /* i=1834; 121 / 66 */
        RTUINT128_INIT_C(0x0019f0a936c2a3b2, 0xe12bcdacc91accf7), RTUINT128_INIT_C(0x0000000000000000, 0x9e1c93545bae57c9),
        RTUINT128_INIT_C(0x0000000000000000, 0x0029fff4bc3cbf4f), RTUINT128_INIT_C(0x0000000000000000, 0x2e86fe553bb2bef0)
    },
    { /* i=1835; 62 / 5 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0a5a07abb1e87f7a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000012),
        RTUINT128_INIT_C(0x0000000000000000, 0x00933950a6540715), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=1836; 89 / 52 */
        RTUINT128_INIT_C(0x0000000001877dd7, 0x84982c0d05a4e93b), RTUINT128_INIT_C(0x0000000000000000, 0x000b5f58b94232c7),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000226cb05884), RTUINT128_INIT_C(0x0000000000000000, 0x00027941e13e529f)
    },
    { /* i=1837; 109 / 14 */
        RTUINT128_INIT_C(0x00001ea00289d98f, 0x6cd0abe223c92f19), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000002445),
        RTUINT128_INIT_C(0x00000000d828e026, 0xa495ca411ecd11df), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000001fe)
    },
    { /* i=1838; 90 / 39 */
        RTUINT128_INIT_C(0x00000000036182e2, 0x63f8bfede4578999), RTUINT128_INIT_C(0x0000000000000000, 0x000000485e212af4),
        RTUINT128_INIT_C(0x0000000000000000, 0x000bf5bccf90b7ad), RTUINT128_INIT_C(0x0000000000000000, 0x000000291cf916b5)
    },
    { /* i=1839; 122 / 49 */
        RTUINT128_INIT_C(0x023779503af10cc9, 0xe90c762288c69ddb), RTUINT128_INIT_C(0x0000000000000000, 0x0001f066792177e0),
        RTUINT128_INIT_C(0x0000000000000124, 0xa7500c3c3fea35b0), RTUINT128_INIT_C(0x0000000000000000, 0x00016b03a132d3db)
    },
    { /* i=1840; 38 / 44 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000011b53e45db), RTUINT128_INIT_C(0x0000000000000000, 0x000004871b1c1b8f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00000011b53e45db)
    },
    { /* i=1841; 126 / 34 */
        RTUINT128_INIT_C(0x233daa8b1156978e, 0xb5df9c799ba7ba6a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000166c02378),
        RTUINT128_INIT_C(0x000000001925c02d, 0x0a6e801a32b5985c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000015b3bb4a)
    },
    { /* i=1842; 123 / 121 */
        RTUINT128_INIT_C(0x02e6630d0d65cdb7, 0x97b44600d69e2d9b), RTUINT128_INIT_C(0x005585e73395e974, 0x6bab1950f65748fc),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000008), RTUINT128_INIT_C(0x003a33d370b68214, 0x3a5b7b7923e3e5bb)
    },
    { /* i=1843; 25 / 16 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000f9314b), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000839b),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000001e4), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000603f)
    },
    { /* i=1844; 88 / 61 */
        RTUINT128_INIT_C(0x00000000000d8857, 0xc4a163bc6df61b4d), RTUINT128_INIT_C(0x0000000000000000, 0x112dd9ee39b61861),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000c9a905), RTUINT128_INIT_C(0x0000000000000000, 0x0dd28e02f3269868)
    },
    { /* i=1845; 110 / 69 */
        RTUINT128_INIT_C(0x00000bff4c30bb0b, 0x89d46e3fcebbcd57), RTUINT128_INIT_C(0x0000000000000017, 0x61086532f4f21fb5),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000835ea72706), RTUINT128_INIT_C(0x0000000000000000, 0xea22608709277c19)
    },
    { /* i=1846; 120 / 58 */
        RTUINT128_INIT_C(0x00d1a108e2a2572d, 0xbde92b3b9df78da6), RTUINT128_INIT_C(0x0000000000000000, 0x028a6e9a684e5ced),
        RTUINT128_INIT_C(0x0000000000000000, 0x5281ba7031a1ed74), RTUINT128_INIT_C(0x0000000000000000, 0x027da7f200610942)
    },
    { /* i=1847; 119 / 56 */
        RTUINT128_INIT_C(0x004795165580d1b4, 0xb93fc1753dd3eda1), RTUINT128_INIT_C(0x0000000000000000, 0x0082ad59a410737b),
        RTUINT128_INIT_C(0x0000000000000000, 0x8c3b54f16e7f709a), RTUINT128_INIT_C(0x0000000000000000, 0x001ab92e3563a5a3)
    },
    { /* i=1848; 68 / 65 */
        RTUINT128_INIT_C(0x0000000000000008, 0xc942649edc5e5a10), RTUINT128_INIT_C(0x0000000000000001, 0xf6c0b852432bcfe5),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000004), RTUINT128_INIT_C(0x0000000000000000, 0xee3f8355cfaf1a7c)
    },
    { /* i=1849; 116 / 110 */
        RTUINT128_INIT_C(0x000a6aab1d41824b, 0x430592ff9badaf55), RTUINT128_INIT_C(0x00003f4ced31ed0b, 0xe380577d53247207),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000002a), RTUINT128_INIT_C(0x0000080c33109e57, 0xeff7386ff7b2fa2f)
    },
    { /* i=1850; 113 / 70 */
        RTUINT128_INIT_C(0x0001f37ad310e44a, 0x2669487114b72149), RTUINT128_INIT_C(0x000000000000000b, 0x9e345ce21bd8abe6),
        RTUINT128_INIT_C(0x0000000000000000, 0x00002afdefceac18), RTUINT128_INIT_C(0x0000000000000007, 0x3bd15964d7d47bb9)
    },
    { /* i=1851; 116 / 122 */
        RTUINT128_INIT_C(0x000b33ccf612fc76, 0x775d773097c569e2), RTUINT128_INIT_C(0x011499f3711e45ac, 0x982a1fa93f037740),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000b33ccf612fc76, 0x775d773097c569e2)
    },
    { /* i=1852; 85 / 52 */
        RTUINT128_INIT_C(0x00000000001ca246, 0x5e51da73f94ce2f7), RTUINT128_INIT_C(0x0000000000000000, 0x0000b4202c33b2e4),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000028b2018d3e), RTUINT128_INIT_C(0x0000000000000000, 0x0000701a905bfbbf)
    },
    { /* i=1853; 55 / 13 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0068bfaf507f535e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000adf),
        RTUINT128_INIT_C(0x0000000000000000, 0x000009a2b23536da), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000778)
    },
    { /* i=1854; 116 / 89 */
        RTUINT128_INIT_C(0x000370dc2e4295f1, 0x1207adedabd803b2), RTUINT128_INIT_C(0x000000000067009b, 0x22dfcdcd6327d14c),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000088d4596), RTUINT128_INIT_C(0x00000000003536f1, 0x8b33e063303de52a)
    },
    { /* i=1855; 96 / 81 */
        RTUINT128_INIT_C(0x0000000026e196a3, 0x4f4f0fa7609c6049), RTUINT128_INIT_C(0x00000000000117bf, 0xb1001c62ba2a4e6c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000002394), RTUINT128_INIT_C(0x000000000000a69d, 0xf75d271ff76e45d9)
    },
    { /* i=1856; 52 / 51 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00004cb320b8fc43), RTUINT128_INIT_C(0x0000000000000000, 0x0007fd1c168d75a8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00004cb320b8fc43)
    },
    { /* i=1857; 34 / 37 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000002d561ad58), RTUINT128_INIT_C(0x0000000000000000, 0x0000000e0ca331b4),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00000002d561ad58)
    },
    { /* i=1858; 80 / 40 */
        RTUINT128_INIT_C(0x0000000000003694, 0x891c70e3b2d2588a), RTUINT128_INIT_C(0x0000000000000000, 0x000000d19308eb14),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000042abc7d679), RTUINT128_INIT_C(0x0000000000000000, 0x000000cea68c8416)
    },
    { /* i=1859; 118 / 75 */
        RTUINT128_INIT_C(0x0032da8da2721178, 0x365b8835f3fc8210), RTUINT128_INIT_C(0x0000000000000635, 0x01fb78569e8f0be5),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000083160ba5eaa), RTUINT128_INIT_C(0x000000000000002b, 0xd308893e9e3e85fe)
    },
    { /* i=1860; 116 / 72 */
        RTUINT128_INIT_C(0x000cc8433a379390, 0x649275265a8af72a), RTUINT128_INIT_C(0x0000000000000015, 0x6098b7be2f238495),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000991255c6ae86), RTUINT128_INIT_C(0x000000000000000c, 0x3a43639785984b2c)
    },
    { /* i=1861; 122 / 64 */
        RTUINT128_INIT_C(0x01aece662d384802, 0xd1e8eef284c1e15b), RTUINT128_INIT_C(0x0000000000000000, 0xe57016a76b4149e1),
        RTUINT128_INIT_C(0x0000000000000000, 0x01e0ae5206b43304), RTUINT128_INIT_C(0x0000000000000000, 0xcc69b0419dd0e6d7)
    },
    { /* i=1862; 121 / 50 */
        RTUINT128_INIT_C(0x015820c053883508, 0x073fc4075125bfe4), RTUINT128_INIT_C(0x0000000000000000, 0x0000ec4252c4f46f),
        RTUINT128_INIT_C(0x0000000000000174, 0xe1c94811a0fdc75e), RTUINT128_INIT_C(0x0000000000000000, 0x00001c8be11eb622)
    },
    { /* i=1863; 113 / 41 */
        RTUINT128_INIT_C(0x000012a9ea571855, 0x18d146a6c3bdb604), RTUINT128_INIT_C(0x0000000000000000, 0x000001c4ea7278bb),
        RTUINT128_INIT_C(0x000000000000000a, 0x8c9aad610d92a71a), RTUINT128_INIT_C(0x0000000000000000, 0x00000070edb57606)
    },
    { /* i=1864; 86 / 7 */
        RTUINT128_INIT_C(0x0000000000304c28, 0x157f986e9aedc665), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000a),
        RTUINT128_INIT_C(0x000000000004d46a, 0x688cc27175e493d6), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000009)
    },
    { /* i=1865; 67 / 32 */
        RTUINT128_INIT_C(0x0000000000000003, 0x3c7be89c419aed42), RTUINT128_INIT_C(0x0000000000000000, 0x00000000bed9e784),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000004574b6f5f), RTUINT128_INIT_C(0x0000000000000000, 0x0000000043afc746)
    },
    { /* i=1866; 125 / 102 */
        RTUINT128_INIT_C(0x09391381d327c376, 0x5b00dea4bdbce68b), RTUINT128_INIT_C(0x00000002f858d306, 0x93676089632aee20),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000031af26b), RTUINT128_INIT_C(0x000000018c2629bd, 0x9b6c125326711f2b)
    },
    { /* i=1867; 122 / 115 */
        RTUINT128_INIT_C(0x01bd26a593472339, 0xdc1e5f1d665717e7), RTUINT128_INIT_C(0x0003e78fc05dd0b5, 0x3e3481813af3853b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000072), RTUINT128_INIT_C(0x000008a1e9803284, 0x28bcb39125e5c3a1)
    },
    { /* i=1868; 92 / 26 */
        RTUINT128_INIT_C(0x000000000607aba5, 0x871fabb6dbff42c5), RTUINT128_INIT_C(0x0000000000000000, 0x00000000039d9561),
        RTUINT128_INIT_C(0x0000000000000001, 0xaaf3b04584f57ac5), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000b61520)
    },
    { /* i=1869; 125 / 75 */
        RTUINT128_INIT_C(0x17ed044262b31cec, 0xf308174569e26e87), RTUINT128_INIT_C(0x0000000000000174, 0x57bdd507e1098ce8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0010732f6d1a5505), RTUINT128_INIT_C(0x0000000000000066, 0xcd6c4dd6c159a5ff)
    },
    { /* i=1870; 122 / 124 */
        RTUINT128_INIT_C(0x00beb3e881d4bb4a, 0xf3cdf45303556e92), RTUINT128_INIT_C(0x05354a3e3eafaf91, 0xf336ed0f13f369fc),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00beb3e881d4bb4a, 0xf3cdf45303556e92)
    },
    { /* i=1871; 127 / 120 */
        RTUINT128_INIT_C(0x430c3927b3963a05, 0xb2356db5053b2778), RTUINT128_INIT_C(0x00ccf243b1930827, 0x37e9d3135c870da4),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000053), RTUINT128_INIT_C(0x0099ad3520ea954e, 0x9165fe6e0571bb4c)
    },
    { /* i=1872; 83 / 102 */
        RTUINT128_INIT_C(0x000000000004f5f7, 0x66283cbfaafbf53f), RTUINT128_INIT_C(0x00000006977f238e, 0xda33875b5512c87f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000000000004f5f7, 0x66283cbfaafbf53f)
    },
    { /* i=1873; 124 / 98 */
        RTUINT128_INIT_C(0x05faaf917fd2c422, 0xd43151ba21e1c1a6), RTUINT128_INIT_C(0x00000002177346cc, 0x4a538cd707a8278e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000002dbd308), RTUINT128_INIT_C(0x000000019785efea, 0x7a7cd289598c7b36)
    },
    { /* i=1874; 128 / 47 */
        RTUINT128_INIT_C(0xd29703c9952875bc, 0x9465e08ecdea625d), RTUINT128_INIT_C(0x0000000000000000, 0x00005ea91e438aa2),
        RTUINT128_INIT_C(0x0000000000023984, 0xd937722823ea0f19), RTUINT128_INIT_C(0x0000000000000000, 0x00000644061e5a8b)
    },
    { /* i=1875; 128 / 69 */
        RTUINT128_INIT_C(0x75b80e7224e7a876, 0xd91b13329f608ba1), RTUINT128_INIT_C(0x0000000000000009, 0x5896ac025dfbb2de),
        RTUINT128_INIT_C(0x0000000000000000, 0x0c98785d0289f311), RTUINT128_INIT_C(0x0000000000000008, 0x23bb1a160212f0e3)
    },
    { /* i=1876; 74 / 42 */
        RTUINT128_INIT_C(0x00000000000001b6, 0x054cf70b7fa6f88e), RTUINT128_INIT_C(0x0000000000000000, 0x000002a6c94fa68a),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000a5325e06), RTUINT128_INIT_C(0x0000000000000000, 0x000001520fae6552)
    },
    { /* i=1877; 86 / 4 */
        RTUINT128_INIT_C(0x000000000016a2a3, 0xfa47ce6986b20d70), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002),
        RTUINT128_INIT_C(0x00000000000b5151, 0xfd23e734c35906b8), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=1878; 113 / 92 */
        RTUINT128_INIT_C(0x00013991a38d715e, 0xa5ae571663384e14), RTUINT128_INIT_C(0x00000000024943c9, 0xecc3e4dc2a16de38),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000892866), RTUINT128_INIT_C(0x0000000000b52d16, 0x3a0c3a8d1f6b03c4)
    },
    { /* i=1879; 127 / 103 */
        RTUINT128_INIT_C(0x04530450e0d62740, 0xd35e2f3eea479398), RTUINT128_INIT_C(0x000000711de689cc, 0xa4d9890726efb987),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000009c957), RTUINT128_INIT_C(0x0000004add19d9a0, 0x2f99a1d0f06587b7)
    },
    { /* i=1880; 68 / 51 */
        RTUINT128_INIT_C(0x000000000000000d, 0xe2056b4b55ba7c4f), RTUINT128_INIT_C(0x0000000000000000, 0x000640b5ee8a7033),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000023864), RTUINT128_INIT_C(0x0000000000000000, 0x00007af6feb58063)
    },
    { /* i=1881; 118 / 83 */
        RTUINT128_INIT_C(0x000e75328c368c80, 0x3b471711586b1305), RTUINT128_INIT_C(0x00000000000066a6, 0x77d475cc4075add9),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000240e6f35e0), RTUINT128_INIT_C(0x0000000000001fbf, 0x1559e5f4555e0825)
    },
    { /* i=1882; 113 / 95 */
        RTUINT128_INIT_C(0x0000b65200cc71b2, 0x1eb038cb73cbd580), RTUINT128_INIT_C(0x00000000665dcce3, 0x905a3c36c49d9dee),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000001c7f3), RTUINT128_INIT_C(0x000000001e9a801f, 0xb803b95aae7cea96)
    },
    { /* i=1883; 121 / 74 */
        RTUINT128_INIT_C(0x01dbde88d5c245b0, 0xa78d7fa7906f1c32), RTUINT128_INIT_C(0x0000000000000043, 0xf7f4903cb23319be),
        RTUINT128_INIT_C(0x0000000000000000, 0x000700560d88e8c3), RTUINT128_INIT_C(0x000000000000002b, 0xdee4b6a5313e5078)
    },
    { /* i=1884; 46 / 44 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000013aed91d7f2c), RTUINT128_INIT_C(0x0000000000000000, 0x0000086d8aee76b9),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002), RTUINT128_INIT_C(0x0000000000000000, 0x000002d3c34091ba)
    },
    { /* i=1885; 118 / 91 */
        RTUINT128_INIT_C(0x003ebb2bafa28b0a, 0xae974e6757bd1504), RTUINT128_INIT_C(0x00000000042f8a9c, 0x2a2e7b117468b1cf),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000efcaabf), RTUINT128_INIT_C(0x0000000002165c08, 0x3ea3944b9dc8f593)
    },
    { /* i=1886; 15 / 8 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001ce1), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000005c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000050), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000021)
    },
    { /* i=1887; 117 / 108 */
        RTUINT128_INIT_C(0x00102ef07648a17d, 0xb9a65422c21a2bb1), RTUINT128_INIT_C(0x000006af7f9e3e9c, 0x8ec11ee3d956b605),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000026b), RTUINT128_INIT_C(0x00000496e2a73cf0, 0x8cb0a3343d700d9a)
    },
    { /* i=1888; 87 / 45 */
        RTUINT128_INIT_C(0x00000000003e89fd, 0xc2fd16c6faf4d56e), RTUINT128_INIT_C(0x0000000000000000, 0x00001804bb2d05cd),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000029a91d69403), RTUINT128_INIT_C(0x0000000000000000, 0x00000344cbb54007)
    },
    { /* i=1889; 60 / 100 */
        RTUINT128_INIT_C(0x0000000000000000, 0x01d76cccfb8fa175), RTUINT128_INIT_C(0x000000008f3bb9c8, 0x5356ac4f2f3bf64a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x01d76cccfb8fa175)
    },
    { /* i=1890; 89 / 47 */
        RTUINT128_INIT_C(0x0000000001be34e8, 0x5749e306b6daac5b), RTUINT128_INIT_C(0x0000000000000000, 0x000022ad2d55533f),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000cde2200366d), RTUINT128_INIT_C(0x0000000000000000, 0x00001e0a0bf6f088)
    },
    { /* i=1891; 88 / 5 */
        RTUINT128_INIT_C(0x0000000000a513fa, 0xe22e3faef2037967), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000004),
        RTUINT128_INIT_C(0x00000000002944fe, 0xb88b8febbc80de59), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003)
    },
    { /* i=1892; 104 / 27 */
        RTUINT128_INIT_C(0x000000b4cd6d7fd0, 0x93f47ad5ee916341), RTUINT128_INIT_C(0x0000000000000000, 0x00000000014c2031),
        RTUINT128_INIT_C(0x0000000000008b5c, 0x74a3e284d5fd6cf3), RTUINT128_INIT_C(0x0000000000000000, 0x00000000004d28be)
    },
    { /* i=1893; 114 / 69 */
        RTUINT128_INIT_C(0x000188de2261e709, 0xb0e9eca7cc2a2f54), RTUINT128_INIT_C(0x0000000000000018, 0x7365bcafe0639598),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000101154f07bad), RTUINT128_INIT_C(0x0000000000000013, 0x19076f73317e0f9c)
    },
    { /* i=1894; 115 / 87 */
        RTUINT128_INIT_C(0x0005a93374c0e2bc, 0x4c1df5c7fd08ffc7), RTUINT128_INIT_C(0x000000000030cbb3, 0x2b73d3e8839cc445),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000001db30911), RTUINT128_INIT_C(0x0000000000268e50, 0xd47cedddaf7a8a32)
    },
    { /* i=1895; 118 / 41 */
        RTUINT128_INIT_C(0x000e757539efbc70, 0x0f9a0288bbaac065), RTUINT128_INIT_C(0x0000000000000000, 0x00000010b23af353),
        RTUINT128_INIT_C(0x000000000000ddb1, 0xc8f374bb9ea0f385), RTUINT128_INIT_C(0x0000000000000000, 0x00000007e0328d46)
    },
    { /* i=1896; 121 / 72 */
        RTUINT128_INIT_C(0x00b3089cf7794c78, 0x52c2a12df8c0b07b), RTUINT128_INIT_C(0x00000000000000cc, 0xf30f5c2a4ffc238b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000dfa0fd287144), RTUINT128_INIT_C(0x0000000000000023, 0x22ca7e3c815ee48f)
    },
    { /* i=1897; 95 / 88 */
        RTUINT128_INIT_C(0x000000005d2bb76e, 0x194e8d251337462e), RTUINT128_INIT_C(0x0000000000d31934, 0x208b86a331d603ac),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000070), RTUINT128_INIT_C(0x0000000000d0b09f, 0xdc43a5bf4595aaee)
    },
    { /* i=1898; 119 / 66 */
        RTUINT128_INIT_C(0x0016b9b9f7b25898, 0x3922d6a7572d6935), RTUINT128_INIT_C(0x0000000000000002, 0x3221aa35c4e58065),
        RTUINT128_INIT_C(0x0000000000000000, 0x000a5972967b2922), RTUINT128_INIT_C(0x0000000000000001, 0x676b4180909b2ecb)
    },
    { /* i=1899; 127 / 111 */
        RTUINT128_INIT_C(0x736b4332a2722c7a, 0x23f42c5c5d2433ea), RTUINT128_INIT_C(0x000020e1d85fb018, 0x50ef9a56f85fd7c6),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000038294), RTUINT128_INIT_C(0x000007a1e36b1282, 0xde09ded492d6e972)
    },
    { /* i=1900; 117 / 15 */
        RTUINT128_INIT_C(0x001533036366f964, 0x6a7992bb03172071), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000004995),
        RTUINT128_INIT_C(0x00000049c12d6c96, 0x004dfcc971e9f1b7), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000041ee)
    },
    { /* i=1901; 120 / 114 */
        RTUINT128_INIT_C(0x0008e211647f79d3, 0xfaf0a0b1eb96300a), RTUINT128_INIT_C(0x0003c13c0cd47332, 0x367a61df75d2d511),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002), RTUINT128_INIT_C(0x00015f994ad6936f, 0x8dfbdcf2fff085e8)
    },
    { /* i=1902; 77 / 59 */
        RTUINT128_INIT_C(0x0000000000000235, 0x271e9cf8ac5a9426), RTUINT128_INIT_C(0x0000000000000000, 0x05cac33556a62857),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000006192), RTUINT128_INIT_C(0x0000000000000000, 0x058412b84c4e9b88)
    },
    { /* i=1903; 115 / 101 */
        RTUINT128_INIT_C(0x000329b90e7d33fe, 0x697aed72e1fa1cad), RTUINT128_INIT_C(0x00000016e55c2b76, 0x5c7893e49f9c8e49),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000235d), RTUINT128_INIT_C(0x0000000c22103b5a, 0x5574f1927ea67128)
    },
    { /* i=1904; 39 / 101 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000004c0c42c1d4), RTUINT128_INIT_C(0x0000001e0dccffde, 0xe3709bc7d586460c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000004c0c42c1d4)
    },
    { /* i=1905; 119 / 77 */
        RTUINT128_INIT_C(0x00079dd27aecad9a, 0x4b113c1d45f8da95), RTUINT128_INIT_C(0x00000000000009bc, 0xaae11649a25ae3d7),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000c83fc68619), RTUINT128_INIT_C(0x00000000000000a1, 0x9681939ab68c1096)
    },
    { /* i=1906; 127 / 120 */
        RTUINT128_INIT_C(0x3061f6eb1cd4cd5b, 0x76dcb398a995c803), RTUINT128_INIT_C(0x00514b870b327fe1, 0x00f7e26cd2003a4e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000098), RTUINT128_INIT_C(0x001d1ebc76d8dfc2, 0xe3ae42fbf97329b3)
    },
    { /* i=1907; 124 / 122 */
        RTUINT128_INIT_C(0x0afc7a88297b5694, 0x8656d715d5705ec7), RTUINT128_INIT_C(0x02696169bd847ab7, 0x82d32a70e2f425f5),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000004), RTUINT128_INIT_C(0x0156f4e133696bb6, 0x7b0a2d52499fc6f3)
    },
    { /* i=1908; 35 / 33 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000291e4f276), RTUINT128_INIT_C(0x0000000000000000, 0x00000000431efdcf),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000009), RTUINT128_INIT_C(0x0000000000000000, 0x0000000035ce062f)
    },
    { /* i=1909; 118 / 76 */
        RTUINT128_INIT_C(0x002351c4d2903fb7, 0x141689dcfa03cdff), RTUINT128_INIT_C(0x0000000000000f24, 0xe0f2fd6d7554d0dd),
        RTUINT128_INIT_C(0x0000000000000000, 0x000002550cf533ce), RTUINT128_INIT_C(0x0000000000000a89, 0x5e0576116aa6b529)
    },
    { /* i=1910; 74 / 27 */
        RTUINT128_INIT_C(0x0000000000000199, 0xbc32ae43bc926b52), RTUINT128_INIT_C(0x0000000000000000, 0x0000000006cbea98),
        RTUINT128_INIT_C(0x0000000000000000, 0x00003c492830e32c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000004015132)
    },
    { /* i=1911; 102 / 2 */
        RTUINT128_INIT_C(0x0000001a0689bed3, 0xcc689d256a537d2f), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003),
        RTUINT128_INIT_C(0x00000008acd894f1, 0x4422df0c78c67f0f), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002)
    },
    { /* i=1912; 122 / 121 */
        RTUINT128_INIT_C(0x025af7d04e2e78a9, 0x0c4c00d8ce52595a), RTUINT128_INIT_C(0x01837d8ccb414c9b, 0xf053c1347324e968),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x00d77a4382ed2c0d, 0x1bf83fa45b2d6ff2)
    },
    { /* i=1913; 114 / 43 */
        RTUINT128_INIT_C(0x0003619dd86d95c3, 0xee74254f14f955f1), RTUINT128_INIT_C(0x0000000000000000, 0x000006487df751cf),
        RTUINT128_INIT_C(0x0000000000000089, 0xc4777782525c5a10), RTUINT128_INIT_C(0x0000000000000000, 0x0000034a8e5d7301)
    },
    { /* i=1914; 123 / 73 */
        RTUINT128_INIT_C(0x0665205fd4247086, 0x9778348c6c6b42f7), RTUINT128_INIT_C(0x00000000000000c2, 0x7108c314bd799ee6),
        RTUINT128_INIT_C(0x0000000000000000, 0x00086b6d164e5a4f), RTUINT128_INIT_C(0x0000000000000085, 0xef31bde503f25dfd)
    },
    { /* i=1915; 91 / 13 */
        RTUINT128_INIT_C(0x0000000000ce29cc, 0x49edf4b8fa2ed879), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001f38),
        RTUINT128_INIT_C(0x000000000000069a, 0x94827f09a1fc39e0), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000f79)
    },
    { /* i=1916; 116 / 67 */
        RTUINT128_INIT_C(0x000384fd9d3d2572, 0x1e766633057448db), RTUINT128_INIT_C(0x0000000000000001, 0xf6311696b09fb3ad),
        RTUINT128_INIT_C(0x0000000000000000, 0x0001cb4b3ddd0f38), RTUINT128_INIT_C(0x0000000000000000, 0xe5494685b1a4d803)
    },
    { /* i=1917; 117 / 120 */
        RTUINT128_INIT_C(0x00123c8d427d43c5, 0xe9c386b5b42abdb7), RTUINT128_INIT_C(0x00b0031556095e77, 0xe389b4e279c9a327),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00123c8d427d43c5, 0xe9c386b5b42abdb7)
    },
    { /* i=1918; 119 / 21 */
        RTUINT128_INIT_C(0x001fd7f3af063019, 0x9a2397d1788ec986), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000140fff),
        RTUINT128_INIT_C(0x0000000196540044, 0x4bc811d71c64e9ea), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000d1370)
    },
    { /* i=1919; 108 / 41 */
        RTUINT128_INIT_C(0x00000b19560b2d3f, 0x7d318321ce047489), RTUINT128_INIT_C(0x0000000000000000, 0x000000061030b76a),
        RTUINT128_INIT_C(0x00000000000001d4, 0x9dd56a9e1e03beed), RTUINT128_INIT_C(0x0000000000000000, 0x00000004168bfb67)
    },
    { /* i=1920; 111 / 14 */
        RTUINT128_INIT_C(0x0000276600491d72, 0x1b2f348da1b9c9d3), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000262),
        RTUINT128_INIT_C(0x0000001088d046f9, 0x0d795cd56cf5d011), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000151)
    },
    { /* i=1921; 90 / 87 */
        RTUINT128_INIT_C(0x0000000002bbf402, 0x938ccc5cb005df2a), RTUINT128_INIT_C(0x0000000000608763, 0xc2c653871495025d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000007), RTUINT128_INIT_C(0x0000000000184048, 0x402083ab1ff2ce9f)
    },
    { /* i=1922; 31 / 98 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000002ae5c0dd), RTUINT128_INIT_C(0x00000001b018b089, 0xd3c9eee5b45ecbee),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000000002ae5c0dd)
    },
    { /* i=1923; 115 / 108 */
        RTUINT128_INIT_C(0x000449532d0a3ed3, 0x369d9dec5a0b2da8), RTUINT128_INIT_C(0x00000fadac9afbde, 0x33467d77b1804e18),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000045), RTUINT128_INIT_C(0x00000f83a7445bef, 0x649dcca982762130)
    },
    { /* i=1924; 117 / 39 */
        RTUINT128_INIT_C(0x0019410955b39c99, 0x5fc9ef5b22a5efe8), RTUINT128_INIT_C(0x0000000000000000, 0x0000003875152cde),
        RTUINT128_INIT_C(0x0000000000007283, 0x0908064d265662ac), RTUINT128_INIT_C(0x0000000000000000, 0x0000000e56aacec0)
    },
    { /* i=1925; 123 / 34 */
        RTUINT128_INIT_C(0x026ed3d9c3c02b8f, 0xee5f354669cbcdc8), RTUINT128_INIT_C(0x0000000000000000, 0x00000003806fdf5a),
        RTUINT128_INIT_C(0x0000000000b1dd2d, 0x9fa620b11e7bc639), RTUINT128_INIT_C(0x0000000000000000, 0x000000016de576be)
    },
    { /* i=1926; 121 / 113 */
        RTUINT128_INIT_C(0x00f7b33939c8c4a4, 0xb8b1198f262781fc), RTUINT128_INIT_C(0x000101c09270ae9c, 0xa08d14c159756b5c),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000f6), RTUINT128_INIT_C(0x0000042c8180fa22, 0x711f27c32f525794)
    },
    { /* i=1927; 125 / 92 */
        RTUINT128_INIT_C(0x090524743c150529, 0x0906aba875904ecf), RTUINT128_INIT_C(0x0000000008824ebf, 0xe8f14e6232040af8),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000010f6042ef), RTUINT128_INIT_C(0x0000000002913979, 0x01c423f613f62147)
    },
    { /* i=1928; 88 / 3 */
        RTUINT128_INIT_C(0x0000000000f6fc83, 0xa4b5aa2c15da6216), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000005),
        RTUINT128_INIT_C(0x00000000003165b3, 0xedbdeed59df87a04), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002)
    },
    { /* i=1929; 121 / 104 */
        RTUINT128_INIT_C(0x00ecd1e7705ef8b0, 0x4c6ec4919c7cd0f2), RTUINT128_INIT_C(0x0000004640d412a1, 0x59d9546cdd869b22),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000035ef6), RTUINT128_INIT_C(0x0000001b0dd9c51a, 0x2b5112097ec74246)
    },
    { /* i=1930; 53 / 1 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000abe4a16b75dce), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001),
        RTUINT128_INIT_C(0x0000000000000000, 0x000abe4a16b75dce), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=1931; 126 / 100 */
        RTUINT128_INIT_C(0x06dec2fdaed02ca1, 0x6816d11d79093d1c), RTUINT128_INIT_C(0x00000006cd4afcaf, 0x70bdcec632f5fcba),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000001029176), RTUINT128_INIT_C(0x00000000ec50b59d, 0x8abbe2fbf40d6560)
    },
    { /* i=1932; 104 / 28 */
        RTUINT128_INIT_C(0x0000003e37faaf72, 0xb6184c4ce39dc2a2), RTUINT128_INIT_C(0x0000000000000000, 0x0000000006b8cc5f),
        RTUINT128_INIT_C(0x0000000000000941, 0x937f315b78462dbe), RTUINT128_INIT_C(0x0000000000000000, 0x00000000008f6120)
    },
    { /* i=1933; 120 / 122 */
        RTUINT128_INIT_C(0x0036af1a4b3aa569, 0x6cf039c7289b58de), RTUINT128_INIT_C(0x03dfacd048cb97ab, 0x769e1f881b308a68),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0036af1a4b3aa569, 0x6cf039c7289b58de)
    },
    { /* i=1934; 117 / 43 */
        RTUINT128_INIT_C(0x000348cc9d3ff890, 0x3d4de464ed91df49), RTUINT128_INIT_C(0x0000000000000000, 0x0000055d9ceaee03),
        RTUINT128_INIT_C(0x000000000000009c, 0xb3199a014cc6eb05), RTUINT128_INIT_C(0x0000000000000000, 0x000002253a2c783a)
    },
    { /* i=1935; 76 / 46 */
        RTUINT128_INIT_C(0x0000000000000ab9, 0x9340aff3e5da8d74), RTUINT128_INIT_C(0x0000000000000000, 0x00001ddbe902077f),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000005bf38675), RTUINT128_INIT_C(0x0000000000000000, 0x000008e41573a669)
    },
    { /* i=1936; 98 / 102 */
        RTUINT128_INIT_C(0x000000032b41a9bc, 0x5e4bba14765a458b), RTUINT128_INIT_C(0x000000198643c191, 0x19723c3a4244f8e3),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000000032b41a9bc, 0x5e4bba14765a458b)
    },
    { /* i=1937; 35 / 26 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000020ee5f8f3), RTUINT128_INIT_C(0x0000000000000000, 0x00000000015e3470),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000181), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000391c83)
    },
    { /* i=1938; 127 / 79 */
        RTUINT128_INIT_C(0x160d3806cc8356df, 0x4448d201fd9c7c8f), RTUINT128_INIT_C(0x0000000000006545, 0x50e9455606897bea),
        RTUINT128_INIT_C(0x0000000000000000, 0x000037be6aabb7bb), RTUINT128_INIT_C(0x0000000000003c9f, 0x167e24ae464cb2a1)
    },
    { /* i=1939; 59 / 32 */
        RTUINT128_INIT_C(0x0000000000000000, 0x019838dd4bd2cb6c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000068ed3506),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000003e3fb12), RTUINT128_INIT_C(0x0000000000000000, 0x0000000041d62f00)
    },
    { /* i=1940; 108 / 77 */
        RTUINT128_INIT_C(0x000000c2bf97c42b, 0xa9463ed18d311cd8), RTUINT128_INIT_C(0x0000000000001c94, 0x3093fb11759b9734),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000006d07ddb), RTUINT128_INIT_C(0x000000000000058f, 0x7225bc7ee6025f5c)
    },
    { /* i=1941; 91 / 71 */
        RTUINT128_INIT_C(0x000000000281c07d, 0x180a07eaa0d6adaf), RTUINT128_INIT_C(0x0000000000000005, 0xf1eefee539994818),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000006bf27c), RTUINT128_INIT_C(0x0000000000000003, 0x7182cd5eb269120f)
    },
    { /* i=1942; 21 / 10 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000030edb), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000013a),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000027e), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000004f)
    },
    { /* i=1943; 128 / 117 */
        RTUINT128_INIT_C(0xf0ad55200504b671, 0xd6e32af3dfec17e5), RTUINT128_INIT_C(0x0005d853a6d256b5, 0xbe1cf56ee8020c72),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000292d), RTUINT128_INIT_C(0x0000e8b402285d0c, 0xc87d434cc391a5db)
    },
    { /* i=1944; 118 / 79 */
        RTUINT128_INIT_C(0x001d8a53b49fb839, 0x997d73b7feb8fc9a), RTUINT128_INIT_C(0x00000000000025a4, 0x72c238b729f43376),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000c8e6387922), RTUINT128_INIT_C(0x000000000000159a, 0xd05890b8ba2760ee)
    },
    { /* i=1945; 83 / 77 */
        RTUINT128_INIT_C(0x000000000002a78c, 0x9a1ba00ae95e32ee), RTUINT128_INIT_C(0x00000000000014c2, 0x2ea5a6eae0e6009e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000020), RTUINT128_INIT_C(0x0000000000000f46, 0xc566c2aecc9e1f2e)
    },
    { /* i=1946; 110 / 72 */
        RTUINT128_INIT_C(0x000028272b0862de, 0x9f0c5d20b1bc41a7), RTUINT128_INIT_C(0x000000000000002d, 0xf4a8370cfc1f1ad8),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000dfacf5ca08), RTUINT128_INIT_C(0x0000000000000019, 0x366fd3d274dcfae7)
    },
    { /* i=1947; 121 / 17 */
        RTUINT128_INIT_C(0x00243004f708361d, 0xb4374ab7bde98159), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000014bf8),
        RTUINT128_INIT_C(0x0000001be803401a, 0x61e1beaa9a413465), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000002881)
    },
    { /* i=1948; 119 / 55 */
        RTUINT128_INIT_C(0x000445abbe4804a1, 0x7179a5abcee0cf06), RTUINT128_INIT_C(0x0000000000000000, 0x005513e0ae292568),
        RTUINT128_INIT_C(0x0000000000000000, 0x0cdadf85d1d62826), RTUINT128_INIT_C(0x0000000000000000, 0x0036622459fd0196)
    },
    { /* i=1949; 99 / 69 */
        RTUINT128_INIT_C(0x00000007ec3fa0ec, 0x6747b27056ce084a), RTUINT128_INIT_C(0x0000000000000013, 0x7653c41b8ccbe27d),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000006836f52b), RTUINT128_INIT_C(0x0000000000000012, 0xcd84dd0c026f5c4b)
    },
    { /* i=1950; 126 / 50 */
        RTUINT128_INIT_C(0x01ca8d4a5a65749d, 0xcd9ae628047291f0), RTUINT128_INIT_C(0x0000000000000000, 0x0000a8a77072ba6d),
        RTUINT128_INIT_C(0x00000000000002b8, 0x0934be84c33bda1f), RTUINT128_INIT_C(0x0000000000000000, 0x00008f79b5ae2cbd)
    },
    { /* i=1951; 128 / 92 */
        RTUINT128_INIT_C(0xe5feafdc7065377f, 0x6e092b07103a83a7), RTUINT128_INIT_C(0x000000000f2dc77c, 0x5bc2d633c88e10a9),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000f2700684c), RTUINT128_INIT_C(0x00000000035e3da2, 0x654bebbd1048e97b)
    },
    { /* i=1952; 78 / 84 */
        RTUINT128_INIT_C(0x0000000000001c44, 0xbedc86d1dad761c8), RTUINT128_INIT_C(0x000000000004931f, 0x07626e8db81f3ca3),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000001c44, 0xbedc86d1dad761c8)
    },
    { /* i=1953; 127 / 65 */
        RTUINT128_INIT_C(0x0e12f57888fe18d6, 0x5e37648f9ebd690d), RTUINT128_INIT_C(0x0000000000000000, 0x1a5b7545a11f1e7b),
        RTUINT128_INIT_C(0x0000000000000000, 0x88b2707476d38367), RTUINT128_INIT_C(0x0000000000000000, 0x0ccacfaa0d3e3490)
    },
    { /* i=1954; 128 / 91 */
        RTUINT128_INIT_C(0x26d601614d5ae6b7, 0xa8b105cc30aeb4b7), RTUINT128_INIT_C(0x000000000295bed2, 0x1cbc0e84a63581ef),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000f061f2de0), RTUINT128_INIT_C(0x0000000000a642ee, 0xda7f01fc04150097)
    },
    { /* i=1955; 96 / 7 */
        RTUINT128_INIT_C(0x00000000d728ce98, 0xbdc73fd54394112d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000038),
        RTUINT128_INIT_C(0x0000000003d795f9, 0x95acb36cf37e1297), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000025)
    },
    { /* i=1956; 121 / 58 */
        RTUINT128_INIT_C(0x01d4e4ad352b2b99, 0xd417764168a1fc57), RTUINT128_INIT_C(0x0000000000000000, 0x03e275fb3f141c05),
        RTUINT128_INIT_C(0x0000000000000000, 0x78b48d316a6d5069), RTUINT128_INIT_C(0x0000000000000000, 0x0172415f407fee4a)
    },
    { /* i=1957; 117 / 106 */
        RTUINT128_INIT_C(0x00188b3f99292a07, 0x53ea77017d5b5d3f), RTUINT128_INIT_C(0x0000016d6b6f58c4, 0x18380a7d101f003a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001131), RTUINT128_INIT_C(0x0000012ba3f426e2, 0xf87e26ff58687825)
    },
    { /* i=1958; 126 / 66 */
        RTUINT128_INIT_C(0x3fadd8bbdd2a40eb, 0xc0c945a353be45b4), RTUINT128_INIT_C(0x0000000000000000, 0xf6cff9d5c355bd39),
        RTUINT128_INIT_C(0x0000000000000000, 0x420caed97d2cfd84), RTUINT128_INIT_C(0x0000000000000000, 0x378f9dec84bb5f50)
    },
    { /* i=1959; 99 / 41 */
        RTUINT128_INIT_C(0x000000029db2b81d, 0x1b7ef9b230da8cb1), RTUINT128_INIT_C(0x0000000000000000, 0x00000194a25ded44),
        RTUINT128_INIT_C(0x0000000000000000, 0x01a7b2afe4e02f4f), RTUINT128_INIT_C(0x0000000000000000, 0x00000008abced8b5)
    },
    { /* i=1960; 55 / 45 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00009545c1e39409), RTUINT128_INIT_C(0x0000000000000000, 0x00000b8292698996),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000c), RTUINT128_INIT_C(0x0000000000000000, 0x00000b26e4f12101)
    },
    { /* i=1961; 100 / 99 */
        RTUINT128_INIT_C(0x000000048c2686ff, 0xb5e35bc750dffccb), RTUINT128_INIT_C(0x0000000576baea64, 0x7b2e0af572e82ab2),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000000048c2686ff, 0xb5e35bc750dffccb)
    },
    { /* i=1962; 115 / 119 */
        RTUINT128_INIT_C(0x00057719aaeaaf58, 0xb36fae6348ee0fcb), RTUINT128_INIT_C(0x002a66204a23156a, 0x27c05138114f6642),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00057719aaeaaf58, 0xb36fae6348ee0fcb)
    },
    { /* i=1963; 70 / 51 */
        RTUINT128_INIT_C(0x000000000000001e, 0xd9da077794775a31), RTUINT128_INIT_C(0x0000000000000000, 0x00007bfba29e5799),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000003fb37c), RTUINT128_INIT_C(0x0000000000000000, 0x000001e889ddf115)
    },
    { /* i=1964; 89 / 68 */
        RTUINT128_INIT_C(0x00000000007cdd3c, 0xb8ebf00de24b3d87), RTUINT128_INIT_C(0x0000000000000001, 0xd9d7365d8938a02b),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000004375bb), RTUINT128_INIT_C(0x0000000000000000, 0x02639031d979971e)
    },
    { /* i=1965; 126 / 82 */
        RTUINT128_INIT_C(0x305ab0d8f61e942e, 0x0789c3fc63dddd47), RTUINT128_INIT_C(0x000000000002d15c, 0x31a87992356e8447),
        RTUINT128_INIT_C(0x0000000000000000, 0x000011290378ec72), RTUINT128_INIT_C(0x000000000001ecfc, 0x01cb99e4e06d81a9)
    },
    { /* i=1966; 55 / 11 */
        RTUINT128_INIT_C(0x0000000000000000, 0x005f5c053a6859a2), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000318),
        RTUINT128_INIT_C(0x0000000000000000, 0x00001ed2c10b1f24), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000242)
    },
    { /* i=1967; 116 / 106 */
        RTUINT128_INIT_C(0x00063b168242efb7, 0xeee423d24e0f5eee), RTUINT128_INIT_C(0x000001e557976bc5, 0xd40b62fb4423dbf7),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000349), RTUINT128_INIT_C(0x000000a9c1d1e2d2, 0x557bf85f7441c07f)
    },
    { /* i=1968; 17 / 75 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000001acbf), RTUINT128_INIT_C(0x00000000000004f8, 0xd974f00773cbe1bf),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000000000001acbf)
    },
    { /* i=1969; 90 / 12 */
        RTUINT128_INIT_C(0x000000000175f95d, 0x9d01910c4a0fe7d9), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000760),
        RTUINT128_INIT_C(0x00000000000032b5, 0x5674bf20af39c569), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000179)
    },
    { /* i=1970; 116 / 94 */
        RTUINT128_INIT_C(0x000b61063437bb4d, 0x46c1ccd440ec13ec), RTUINT128_INIT_C(0x0000000012935e55, 0x1e8703c4814dd1ab),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000009cd1c6), RTUINT128_INIT_C(0x000000000a5aad45, 0x2482a9dbf25b4eaa)
    },
    { /* i=1971; 102 / 96 */
        RTUINT128_INIT_C(0x00000000fc0f26a4, 0xfa662c637863d6cf), RTUINT128_INIT_C(0x00000000cfb2aee2, 0x3d5d4e42a8a730e3),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x000000002c5c77c2, 0xbd08de20cfbca5ec)
    },
    { /* i=1972; 113 / 65 */
        RTUINT128_INIT_C(0x00006fb8c72e7b4b, 0xc35cd766bf2daca6), RTUINT128_INIT_C(0x0000000000000001, 0xdcc6303a3c7aff5b),
        RTUINT128_INIT_C(0x0000000000000000, 0x00003bfcf44b8a88), RTUINT128_INIT_C(0x0000000000000000, 0x1f7189dcc485f64e)
    },
    { /* i=1973; 123 / 63 */
        RTUINT128_INIT_C(0x072e4cffd943e17b, 0x10e7521bdb6dd16a), RTUINT128_INIT_C(0x0000000000000000, 0x2c6f9a09b067b594),
        RTUINT128_INIT_C(0x0000000000000000, 0x295ea3548ea09f27), RTUINT128_INIT_C(0x0000000000000000, 0x0a563df7fd5a3bde)
    },
    { /* i=1974; 120 / 93 */
        RTUINT128_INIT_C(0x00d7867ed272d45a, 0x5f68a2a4e7019d09), RTUINT128_INIT_C(0x000000000cf7cd6a, 0xb8bf6626bc98c291),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000109eac11), RTUINT128_INIT_C(0x0000000004907fa0, 0x0a5ee0ea98a54568)
    },
    { /* i=1975; 95 / 55 */
        RTUINT128_INIT_C(0x0000000008e94f1d, 0x755206de530c2668), RTUINT128_INIT_C(0x0000000000000000, 0x000858f9d97cd5b9),
        RTUINT128_INIT_C(0x0000000000000000, 0x000001114a5a9a1d), RTUINT128_INIT_C(0x0000000000000000, 0x00052fc7fa4ca673)
    },
    { /* i=1976; 126 / 64 */
        RTUINT128_INIT_C(0x0dc5b74cc90dd171, 0x1826829a13d86d58), RTUINT128_INIT_C(0x0000000000000000, 0x3406324dcde5cbb0),
        RTUINT128_INIT_C(0x0000000000000000, 0x43c54b9cf4f56fa4), RTUINT128_INIT_C(0x0000000000000000, 0x2e84ca2bd9e0a098)
    },
    { /* i=1977; 62 / 17 */
        RTUINT128_INIT_C(0x0000000000000000, 0x136b7854452d2b65), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000daeb),
        RTUINT128_INIT_C(0x0000000000000000, 0x000016b5938cb607), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001cf8)
    },
    { /* i=1978; 42 / 26 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000028575df86ba), RTUINT128_INIT_C(0x0000000000000000, 0x00000000010de91a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000026431), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000f3c0c0)
    },
    { /* i=1979; 102 / 59 */
        RTUINT128_INIT_C(0x0000000ad25bd9c6, 0x7ee4d508ce761449), RTUINT128_INIT_C(0x0000000000000000, 0x06d4d18509cabc7a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000019589a85e51), RTUINT128_INIT_C(0x0000000000000000, 0x0157976d4a0ba5af)
    },
    { /* i=1980; 122 / 98 */
        RTUINT128_INIT_C(0x03cb9d10b1b7f5cc, 0x8f69d8b82b2db8d7), RTUINT128_INIT_C(0x00000001c589a3ff, 0x7b969b4bf799c4f9),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000002246dbe), RTUINT128_INIT_C(0x000000016bd7e82b, 0x46e538c0492b8309)
    },
    { /* i=1981; 126 / 72 */
        RTUINT128_INIT_C(0x2be6f135244d4db5, 0x9ffee3bf8eadb19d), RTUINT128_INIT_C(0x0000000000000056, 0xab9e36598482ae88),
        RTUINT128_INIT_C(0x0000000000000000, 0x0081acaecb3e3083), RTUINT128_INIT_C(0x000000000000000a, 0x2d78929c2224e205)
    },
    { /* i=1982; 117 / 69 */
        RTUINT128_INIT_C(0x001557ff0afe0e0a, 0x871b1afc602deac2), RTUINT128_INIT_C(0x000000000000000d, 0x97e79d49ead27204),
        RTUINT128_INIT_C(0x0000000000000000, 0x000191f5cc94d5cc), RTUINT128_INIT_C(0x0000000000000002, 0x8ed06d5b0d4dbb92)
    },
    { /* i=1983; 126 / 35 */
        RTUINT128_INIT_C(0x170fddcae5ba8d0d, 0x81fcc9520e830674), RTUINT128_INIT_C(0x0000000000000000, 0x0000000148128c4e),
        RTUINT128_INIT_C(0x0000000011fee0c9, 0x8a1f52a8f6224234), RTUINT128_INIT_C(0x0000000000000000, 0x000000010c366a9c)
    },
    { /* i=1984; 43 / 4 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000001f4824be36c), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000c),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000029b58652f3), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000008)
    },
    { /* i=1985; 108 / 43 */
        RTUINT128_INIT_C(0x0000018b4d99fbd4, 0x40acac75eff750de), RTUINT128_INIT_C(0x0000000000000000, 0x000003828ec63f8b),
        RTUINT128_INIT_C(0x0000000000000000, 0x709f4c8457099c7b), RTUINT128_INIT_C(0x0000000000000000, 0x0000017e0f1b1515)
    },
    { /* i=1986; 40 / 68 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000d8ce616195), RTUINT128_INIT_C(0x0000000000000004, 0x627033d30c64a6c5),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000000d8ce616195)
    },
    { /* i=1987; 27 / 15 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000024f3b3e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001add),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001602), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000784)
    },
    { /* i=1988; 120 / 97 */
        RTUINT128_INIT_C(0x0058db96def09a40, 0x5571a2e566875091), RTUINT128_INIT_C(0x000000001ca48966, 0x26c463614ece7d2e),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000031a2f16), RTUINT128_INIT_C(0x000000000cbecd3e, 0xb683cea077211c9d)
    },
    { /* i=1989; 126 / 21 */
        RTUINT128_INIT_C(0x3b913dac3abe0936, 0x5782586ca093237a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000132d40),
        RTUINT128_INIT_C(0x0000031b31a3afc9, 0x0a1d4c4dc4b49dab), RTUINT128_INIT_C(0x0000000000000000, 0x000000000003a9ba)
    },
    { /* i=1990; 65 / 7 */
        RTUINT128_INIT_C(0x0000000000000001, 0xca778494d75c8288), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000002c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0a6b718f04e502f7), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000014)
    },
    { /* i=1991; 45 / 6 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000ee4b2b89fee), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003),
        RTUINT128_INIT_C(0x0000000000000000, 0x000004f6e63d8aa4), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002)
    },
    { /* i=1992; 118 / 94 */
        RTUINT128_INIT_C(0x001f4916db10a224, 0x9c9d7c9b6cd465a2), RTUINT128_INIT_C(0x0000000036113a8d, 0xed00dd713c8a6fbf),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000009421c1), RTUINT128_INIT_C(0x00000000057a2d17, 0xccf3f16655a287a3)
    },
    { /* i=1993; 67 / 51 */
        RTUINT128_INIT_C(0x0000000000000007, 0xe804d903c52fcfe9), RTUINT128_INIT_C(0x0000000000000000, 0x0000aae8693d9fae),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000bd7be), RTUINT128_INIT_C(0x0000000000000000, 0x00004a7d0bde2ac5)
    },
    { /* i=1994; 101 / 52 */
        RTUINT128_INIT_C(0x000000067176b4f6, 0x7cbd7c90f72084a8), RTUINT128_INIT_C(0x0000000000000000, 0x00085dfce0872bc6),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000c522cac4dadf), RTUINT128_INIT_C(0x0000000000000000, 0x000087c28682c72e)
    },
    { /* i=1995; 86 / 54 */
        RTUINT128_INIT_C(0x0000000000244946, 0xd203055cfe4d96a8), RTUINT128_INIT_C(0x0000000000000000, 0x0005744bbfb50fe4),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000006a71dde6a), RTUINT128_INIT_C(0x0000000000000000, 0x0004f98810b94a40)
    },
    { /* i=1996; 117 / 118 */
        RTUINT128_INIT_C(0x001c90cb3c832883, 0x6063129c9606996a), RTUINT128_INIT_C(0x002fdb9b784273ef, 0x866a5e1d4d721a85),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x001c90cb3c832883, 0x6063129c9606996a)
    },
    { /* i=1997; 124 / 111 */
        RTUINT128_INIT_C(0x085a998b1838590c, 0x0012c9b82a2e0c84), RTUINT128_INIT_C(0x00004b6387ab970e, 0xae7b849beac089b8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001c5e), RTUINT128_INIT_C(0x0000082882b14692, 0x6c370acae86b5af4)
    },
    { /* i=1998; 128 / 80 */
        RTUINT128_INIT_C(0x6e7081a2a332738f, 0x450d68997146c692), RTUINT128_INIT_C(0x00000000000081b2, 0xac0785d9e8633d1a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000d9fcc14d6868), RTUINT128_INIT_C(0x0000000000004a6c, 0xe8659b28bd516402)
    },
    { /* i=1999; 114 / 85 */
        RTUINT128_INIT_C(0x000240a5fdda7f28, 0x9021ebda321c17e9), RTUINT128_INIT_C(0x00000000001d524e, 0x8b63d667c4a445be),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000013aa98d5), RTUINT128_INIT_C(0x00000000001567d5, 0x3a42247ea1d940d3)
    },
    { /* i=2000; 101 / 2 */
        RTUINT128_INIT_C(0x0000000e5052c7ed, 0x2611c5fd7ec614a7), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002),
        RTUINT128_INIT_C(0x00000007282963f6, 0x9308e2febf630a53), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001)
    },
    { /* i=2001; 23 / 103 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000001bf75f), RTUINT128_INIT_C(0x0000002d16cdf7ea, 0x8b45c97b15010afa),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00000000001bf75f)
    },
    { /* i=2002; 8 / 2 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000034), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000034), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=2003; 121 / 118 */
        RTUINT128_INIT_C(0x01ab248f786c5848, 0x00e7471f4ff0fdcf), RTUINT128_INIT_C(0x001c26b47508d0c8, 0x3b41ba640529498f),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000f), RTUINT128_INIT_C(0x0004dffc9ce81c8c, 0x880d5b430285ae6e)
    },
    { /* i=2004; 72 / 20 */
        RTUINT128_INIT_C(0x0000000000000024, 0x2b83406ab8dfe964), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000078bff),
        RTUINT128_INIT_C(0x0000000000000000, 0x0004caef93428e97), RTUINT128_INIT_C(0x0000000000000000, 0x000000000006e3fb)
    },
    { /* i=2005; 82 / 55 */
        RTUINT128_INIT_C(0x000000000003885a, 0x9b8b024a74ef2c63), RTUINT128_INIT_C(0x0000000000000000, 0x0012b0e351a50d99),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000030627146), RTUINT128_INIT_C(0x0000000000000000, 0x0006195c623aeb8d)
    },
    { /* i=2006; 123 / 18 */
        RTUINT128_INIT_C(0x062636de60b4183f, 0x542605033a6f17dd), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000adff),
        RTUINT128_INIT_C(0x0000090c232fd6a4, 0xaeeb6b80a58a1d62), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000993f)
    },
    { /* i=2007; 116 / 21 */
        RTUINT128_INIT_C(0x000341de167fd949, 0x97514a8436fa1d26), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000098a13),
        RTUINT128_INIT_C(0x000000005769d6a8, 0xaa89a33bfb7fbe37), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000065911)
    },
    { /* i=2008; 86 / 46 */
        RTUINT128_INIT_C(0x00000000002d0078, 0xb12f0b0b31de113f), RTUINT128_INIT_C(0x0000000000000000, 0x000022cdda9abe9a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000014b02456654), RTUINT128_INIT_C(0x0000000000000000, 0x000008153ba42ab7)
    },
    { /* i=2009; 39 / 14 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000004875a1089a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001529),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000036ca14b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000c97)
    },
    { /* i=2010; 74 / 6 */
        RTUINT128_INIT_C(0x00000000000003c1, 0xd44c2581e9503af1), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000037),
        RTUINT128_INIT_C(0x0000000000000011, 0x7ce0cd7b61553d94), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000025)
    },
    { /* i=2011; 121 / 125 */
        RTUINT128_INIT_C(0x0037dbe2ebbfeb40, 0x0f7bd30e5227ec8c), RTUINT128_INIT_C(0x0ef4d5aa32cdb910, 0x87b958b9f9ecfa0c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0037dbe2ebbfeb40, 0x0f7bd30e5227ec8c)
    },
    { /* i=2012; 122 / 100 */
        RTUINT128_INIT_C(0x000e81246f4a9f27, 0xc2f7c3c94b439a1f), RTUINT128_INIT_C(0x0000000bc0627d69, 0xa0b87279d77c12c7),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000013bf8), RTUINT128_INIT_C(0x00000008df902811, 0x1b6cf19adff68c57)
    },
    { /* i=2013; 119 / 71 */
        RTUINT128_INIT_C(0x0055140f747959a7, 0xaa99d842650a8130), RTUINT128_INIT_C(0x0000000000000038, 0x5376c32cbc972e8e),
        RTUINT128_INIT_C(0x0000000000000000, 0x000182adac9e6724), RTUINT128_INIT_C(0x0000000000000021, 0x3ab0db8ae868d338)
    },
    { /* i=2014; 111 / 72 */
        RTUINT128_INIT_C(0x00006102836937b3, 0x3875475afec93714), RTUINT128_INIT_C(0x0000000000000027, 0xd8a4e344315aedef),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000026f421b8bf4), RTUINT128_INIT_C(0x0000000000000027, 0x8ab2f4ffdeb8aa48)
    },
    { /* i=2015; 125 / 33 */
        RTUINT128_INIT_C(0x17589c1046ec58d0, 0xce95be2cd35eb39e), RTUINT128_INIT_C(0x0000000000000000, 0x00000001993de5d6),
        RTUINT128_INIT_C(0x000000000e9aa68e, 0xbc2d7040899536d4), RTUINT128_INIT_C(0x0000000000000000, 0x0000000092133a66)
    },
    { /* i=2016; 25 / 120 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000f7e7ae), RTUINT128_INIT_C(0x003c1dc2ecee4bf5, 0x23c38787468d0616),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000f7e7ae)
    },
    { /* i=2017; 115 / 76 */
        RTUINT128_INIT_C(0x000700fa8b33d852, 0x26710362ae7ce2fa), RTUINT128_INIT_C(0x000000000000052a, 0xad803499f89c9a44),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000015b06755bc9), RTUINT128_INIT_C(0x000000000000049b, 0xb79d95c2b79d9796)
    },
    { /* i=2018; 115 / 3 */
        RTUINT128_INIT_C(0x0006d1283c1f758f, 0x779e7e97290a9238), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003),
        RTUINT128_INIT_C(0x000245b8140a7c85, 0x27df7f87b858db68), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=2019; 121 / 33 */
        RTUINT128_INIT_C(0x0128a698a4a5dbb6, 0x4f420373005db20d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000072d6850b),
        RTUINT128_INIT_C(0x0000000002954d5a, 0x80e013368fcdc43c), RTUINT128_INIT_C(0x0000000000000000, 0x00000000296b1779)
    },
    { /* i=2020; 95 / 48 */
        RTUINT128_INIT_C(0x0000000064322b75, 0x91056f36270caf33), RTUINT128_INIT_C(0x0000000000000000, 0x000002a57adf046a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0025dc743ef3c33e), RTUINT128_INIT_C(0x0000000000000000, 0x000001bfa80edf87)
    },
    { /* i=2021; 113 / 108 */
        RTUINT128_INIT_C(0x00005d3d97f9a9bd, 0x8a6ea93c40c74145), RTUINT128_INIT_C(0x00000783dcd03d1b, 0xfdaee4b292a809ee),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000c), RTUINT128_INIT_C(0x0000030f3e36cc6d, 0xa63bf0dd60e6ca1d)
    },
    { /* i=2022; 115 / 79 */
        RTUINT128_INIT_C(0x00056ec944214988, 0x36493eaf140a1153), RTUINT128_INIT_C(0x000000000000285d, 0x8c9bf6a3fa616b59),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000227473701e), RTUINT128_INIT_C(0x0000000000000974, 0x260cb9b390ad8ce5)
    },
    { /* i=2023; 91 / 79 */
        RTUINT128_INIT_C(0x00000000046bcceb, 0x2b056cb627aa5f62), RTUINT128_INIT_C(0x00000000000068a7, 0xab25169092f27661),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000ad0), RTUINT128_INIT_C(0x0000000000003800, 0xaa0171814a0a6692)
    },
    { /* i=2024; 121 / 110 */
        RTUINT128_INIT_C(0x0139302ee440ad0c, 0x213c02e96de6e9d6), RTUINT128_INIT_C(0x0000113a07a67b7d, 0x4019918794deead0),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000122e), RTUINT128_INIT_C(0x00000337cfa7ae08, 0xd068541501561876)
    },
    { /* i=2025; 123 / 88 */
        RTUINT128_INIT_C(0x05bf57e9b6629b58, 0x2b7cbf54a3d88d1a), RTUINT128_INIT_C(0x000000000018ac0c, 0xed9c2625d3ecdfc7),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000003ba2d01ee8), RTUINT128_INIT_C(0x000000000002820d, 0xc312154813446ec2)
    },
    { /* i=2026; 123 / 127 */
        RTUINT128_INIT_C(0x025e2b8ff2e03106, 0x2dbfc459e112964b), RTUINT128_INIT_C(0x501ef7a0eb289cbb, 0x3929813e8c6d36dc),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x025e2b8ff2e03106, 0x2dbfc459e112964b)
    },
    { /* i=2027; 103 / 62 */
        RTUINT128_INIT_C(0x0000001cf59fbb94, 0x4454541194ddc5f9), RTUINT128_INIT_C(0x0000000000000000, 0x1b60d489bf9c71ff),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000010ec90517a9), RTUINT128_INIT_C(0x0000000000000000, 0x192cd669975d9ba2)
    },
    { /* i=2028; 63 / 34 */
        RTUINT128_INIT_C(0x0000000000000000, 0x22b44361d4c876b9), RTUINT128_INIT_C(0x0000000000000000, 0x00000001b395b107),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000014656bd7), RTUINT128_INIT_C(0x0000000000000000, 0x000000010d4fdcd8)
    },
    { /* i=2029; 105 / 77 */
        RTUINT128_INIT_C(0x000001bd2d6cc2bb, 0xe9686c3fee2cf7ca), RTUINT128_INIT_C(0x0000000000001d88, 0x0b421fc723fbd427),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000f131fcc), RTUINT128_INIT_C(0x0000000000000b30, 0xe7fa8f14baea2fb6)
    },
    { /* i=2030; 47 / 17 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00007bd7b126ae66), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000018d45),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000004fcdd201), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000018721)
    },
    { /* i=2031; 118 / 105 */
        RTUINT128_INIT_C(0x000f5c0e580696f6, 0xe77836b71d469d34), RTUINT128_INIT_C(0x000001dee5796606, 0x316b4e58ce32462a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000835), RTUINT128_INIT_C(0x000001bd0ab44623, 0x51ce37e2daacc682)
    },
    { /* i=2032; 59 / 44 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000e6b2873ddf3f1), RTUINT128_INIT_C(0x0000000000000000, 0x00000c246023f7a1),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000012f), RTUINT128_INIT_C(0x0000000000000000, 0x00000c1aa94bdc62)
    },
    { /* i=2033; 122 / 48 */
        RTUINT128_INIT_C(0x02bdf9743bfd17a8, 0x235290237cf549bd), RTUINT128_INIT_C(0x0000000000000000, 0x000045ede4b2421f),
        RTUINT128_INIT_C(0x0000000000000a09, 0xd13e488a2068ed91), RTUINT128_INIT_C(0x0000000000000000, 0x00002a47302f232e)
    },
    { /* i=2034; 96 / 91 */
        RTUINT128_INIT_C(0x0000000089892234, 0x107c9ade7f79712c), RTUINT128_INIT_C(0x0000000003904228, 0x7fc59b3b39e5e038),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000026), RTUINT128_INIT_C(0x00000000021f5031, 0x19279013e75a28dc)
    },
    { /* i=2035; 73 / 2 */
        RTUINT128_INIT_C(0x00000000000000c0, 0x743622aa3bc6c282), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003),
        RTUINT128_INIT_C(0x0000000000000040, 0x26bcb638be97962b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001)
    },
    { /* i=2036; 74 / 11 */
        RTUINT128_INIT_C(0x0000000000000236, 0xfd63a65c6a0b2337), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000f8),
        RTUINT128_INIT_C(0x0000000000000002, 0x4947a0abba3bea76), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000e7)
    },
    { /* i=2037; 2 / 92 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002), RTUINT128_INIT_C(0x0000000001029190, 0xf54f8effd2148098),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002)
    },
    { /* i=2038; 117 / 122 */
        RTUINT128_INIT_C(0x00097651bc31b250, 0xca9ec47b55fda876), RTUINT128_INIT_C(0x01a8038470595141, 0x40dc1b6f50b4be98),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00097651bc31b250, 0xca9ec47b55fda876)
    },
    { /* i=2039; 120 / 52 */
        RTUINT128_INIT_C(0x002d89dc11254bc0, 0xb70398f6f712afe7), RTUINT128_INIT_C(0x0000000000000000, 0x000e969a2555762c),
        RTUINT128_INIT_C(0x0000000000000003, 0x1f1fdf53ae645678), RTUINT128_INIT_C(0x0000000000000000, 0x0004e832b0208347)
    },
    { /* i=2040; 104 / 53 */
        RTUINT128_INIT_C(0x000000fa528e65b1, 0x62f81da19d7aeb5c), RTUINT128_INIT_C(0x0000000000000000, 0x00053a4492c6e2e2),
        RTUINT128_INIT_C(0x0000000000000000, 0x002fe27bbfccc5b1), RTUINT128_INIT_C(0x0000000000000000, 0x00042eebab48231a)
    },
    { /* i=2041; 118 / 105 */
        RTUINT128_INIT_C(0x000e63af4dc3daba, 0x0a8cb707230a69dc), RTUINT128_INIT_C(0x00000034e539a328, 0xff3e9e8c21242444),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000045a4), RTUINT128_INIT_C(0x00000003ebdd47aa, 0xa5b360532a1cda4c)
    },
    { /* i=2042; 113 / 67 */
        RTUINT128_INIT_C(0x00014b428f2f3f89, 0xf1e8edf0cc6cc335), RTUINT128_INIT_C(0x0000000000000006, 0xfb80cb3a57ddcbdb),
        RTUINT128_INIT_C(0x0000000000000000, 0x00002f7120f16cb3), RTUINT128_INIT_C(0x0000000000000004, 0xa2e19520812bd514)
    },
    { /* i=2043; 110 / 105 */
        RTUINT128_INIT_C(0x00000b32649f6a8f, 0x3c362d99ebfc5915), RTUINT128_INIT_C(0x0000014313fa4052, 0x2b2430bb9c85efa3),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000008), RTUINT128_INIT_C(0x00000119c4cd67fd, 0xe314a7bd07ccdbfd)
    },
    { /* i=2044; 125 / 125 */
        RTUINT128_INIT_C(0x0edcae056d0a349e, 0x80ac4d74d163253c), RTUINT128_INIT_C(0x0f7e25ac47cc6c51, 0x07163eec6df367c0),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0edcae056d0a349e, 0x80ac4d74d163253c)
    },
    { /* i=2045; 119 / 74 */
        RTUINT128_INIT_C(0x0046b975f50816e4, 0x2205cb2ef22d12f9), RTUINT128_INIT_C(0x00000000000001e2, 0xdd453e9a374b74fb),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000257ef714e4f9), RTUINT128_INIT_C(0x0000000000000174, 0x6f7893a2a4fcbed6)
    },
    { /* i=2046; 127 / 125 */
        RTUINT128_INIT_C(0x07137d0e1d0840c0, 0xdf276a84b7ed9559), RTUINT128_INIT_C(0x0c58192b3555c174, 0x02f5d1201d44650f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x07137d0e1d0840c0, 0xdf276a84b7ed9559)
    },
    { /* i=2047; 119 / 46 */
        RTUINT128_INIT_C(0x0021c86938071102, 0xa7b50d1584fc9877), RTUINT128_INIT_C(0x0000000000000000, 0x0000158f01fa01c5),
        RTUINT128_INIT_C(0x0000000000000191, 0x28683b7c517aaaea), RTUINT128_INIT_C(0x0000000000000000, 0x000012ed84682865)
    },
    { /* i=2048; 100 / 32 */
        RTUINT128_INIT_C(0x000000065fee6d7a, 0x109133589dc77f30), RTUINT128_INIT_C(0x0000000000000000, 0x00000000bfe91f84),
        RTUINT128_INIT_C(0x0000000000000008, 0x80ebf39288c433ce), RTUINT128_INIT_C(0x0000000000000000, 0x000000007dd8d6f8)
    },
    { /* i=2049; 50 / 9 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0003a52916236ed7), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000156),
        RTUINT128_INIT_C(0x0000000000000000, 0x000002ba818fd2a9), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000111)
    },
    { /* i=2050; 124 / 29 */
        RTUINT128_INIT_C(0x0ce3f14dff25abb7, 0xef5bdb541c1302aa), RTUINT128_INIT_C(0x0000000000000000, 0x000000000d301d76),
        RTUINT128_INIT_C(0x00000000fa395d95, 0xec2ca7210cbec2a0), RTUINT128_INIT_C(0x0000000000000000, 0x0000000002192cea)
    },
    { /* i=2051; 101 / 96 */
        RTUINT128_INIT_C(0x0000001b70c7dd5e, 0xe75d8812d1995457), RTUINT128_INIT_C(0x000000009e63a564, 0x84c436623064c11d),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000002c), RTUINT128_INIT_C(0x0000000037a77018, 0x15a42f328048235b)
    },
    { /* i=2052; 21 / 58 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000152df1), RTUINT128_INIT_C(0x0000000000000000, 0x019160508dfdb524),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000152df1)
    },
    { /* i=2053; 94 / 89 */
        RTUINT128_INIT_C(0x00000000313a61a4, 0xae78e8c42fc5131b), RTUINT128_INIT_C(0x0000000000cd0a89, 0x51bb95a36ccc24d9),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000003d), RTUINT128_INIT_C(0x00000000005edeec, 0x34c640d343204b66)
    },
    { /* i=2054; 117 / 53 */
        RTUINT128_INIT_C(0x000711c6216d640c, 0x89351194cd338a5b), RTUINT128_INIT_C(0x0000000000000000, 0x00031a03cc45ee79),
        RTUINT128_INIT_C(0x0000000000000002, 0x477e37e48499b0da), RTUINT128_INIT_C(0x0000000000000000, 0x0002c662db624751)
    },
    { /* i=2055; 117 / 94 */
        RTUINT128_INIT_C(0x00071a7e38ea2b33, 0xfc5e5de306b40fd1), RTUINT128_INIT_C(0x0000000008b04a71, 0x5c0eacb536544e52),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000d14baa), RTUINT128_INIT_C(0x00000000077d5df9, 0x8e153bce4ed4075d)
    },
    { /* i=2056; 95 / 8 */
        RTUINT128_INIT_C(0x00000000100faa4f, 0xeebdaac56ecd2501), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000a6),
        RTUINT128_INIT_C(0x000000000018c4e1, 0xa35dac359f82c729), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000006b)
    },
    { /* i=2057; 123 / 85 */
        RTUINT128_INIT_C(0x05e241776ec64f79, 0x08c498cc50aa3311), RTUINT128_INIT_C(0x000000000008caf7, 0x726874979cb6fa71),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000ab4e09d9d7), RTUINT128_INIT_C(0x0000000000035f35, 0x6ee89d685cbb152a)
    },
    { /* i=2058; 126 / 122 */
        RTUINT128_INIT_C(0x0163d3fea9edb643, 0x10fc24368d4f3035), RTUINT128_INIT_C(0x03c857bb243e8f65, 0xa5f2be70e18d0d0f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0163d3fea9edb643, 0x10fc24368d4f3035)
    },
    { /* i=2059; 119 / 123 */
        RTUINT128_INIT_C(0x0053affa7713e0ca, 0x13048d9044963748), RTUINT128_INIT_C(0x0277302b8ed9990e, 0x79ebfbefbacaa85f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0053affa7713e0ca, 0x13048d9044963748)
    },
    { /* i=2060; 121 / 77 */
        RTUINT128_INIT_C(0x01822e07bfd1467d, 0x234b7cfbb9098335), RTUINT128_INIT_C(0x0000000000001e1b, 0x63e0e4c282ed86e1),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000cd3b0a2063c), RTUINT128_INIT_C(0x00000000000017ae, 0xec0671d66dd2a079)
    },
    { /* i=2061; 125 / 77 */
        RTUINT128_INIT_C(0x0aaa5d9dd62e4e37, 0xf1094d189056d28a), RTUINT128_INIT_C(0x000000000000010d, 0xbc8da47df7748be6),
        RTUINT128_INIT_C(0x0000000000000000, 0x000a1f51dbce293a), RTUINT128_INIT_C(0x00000000000000d6, 0x89beeab080734a6e)
    },
    { /* i=2062; 68 / 29 */
        RTUINT128_INIT_C(0x0000000000000006, 0x57a3c111029e9f66), RTUINT128_INIT_C(0x0000000000000000, 0x0000000002e0f56c),
        RTUINT128_INIT_C(0x0000000000000000, 0x000002340273bfb8), RTUINT128_INIT_C(0x0000000000000000, 0x00000000024ea5c6)
    },
    { /* i=2063; 120 / 107 */
        RTUINT128_INIT_C(0x00e438c00c3406e4, 0x10b3f9875e40bc81), RTUINT128_INIT_C(0x0000028552b7aa92, 0x2a15d459889a527f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000005a89), RTUINT128_INIT_C(0x0000005235f25bdf, 0xde5ddb9702a9f08a)
    },
    { /* i=2064; 89 / 12 */
        RTUINT128_INIT_C(0x0000000000cb6c17, 0x520f8e923de588b8), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000b95),
        RTUINT128_INIT_C(0x0000000000001190, 0x4877ac624e12a401), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000923)
    },
    { /* i=2065; 38 / 19 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000001c2c70d292), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000e984),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000001ee2e6), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000007dfa)
    },
    { /* i=2066; 81 / 37 */
        RTUINT128_INIT_C(0x0000000000018961, 0xaef2da214065eb09), RTUINT128_INIT_C(0x0000000000000000, 0x000000110a447195),
        RTUINT128_INIT_C(0x0000000000000000, 0x00001715ebbedcd2), RTUINT128_INIT_C(0x0000000000000000, 0x0000000aef0eb2cf)
    },
    { /* i=2067; 92 / 92 */
        RTUINT128_INIT_C(0x000000000cd0c154, 0xf3c7118accb7859c), RTUINT128_INIT_C(0x000000000c59762b, 0x07769cf89dc969b1),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x0000000000774b29, 0xec5074922eee1beb)
    },
    { /* i=2068; 98 / 39 */
        RTUINT128_INIT_C(0x000000021314d63f, 0x28963277a23b2c14), RTUINT128_INIT_C(0x0000000000000000, 0x00000020328c7001),
        RTUINT128_INIT_C(0x0000000000000000, 0x107e98801a516a19), RTUINT128_INIT_C(0x0000000000000000, 0x0000001501d2d1fb)
    },
    { /* i=2069; 65 / 40 */
        RTUINT128_INIT_C(0x0000000000000001, 0xd595442c975b6079), RTUINT128_INIT_C(0x0000000000000000, 0x0000008a0cc76f3e),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000366cbae), RTUINT128_INIT_C(0x0000000000000000, 0x00000071b5e39a55)
    },
    { /* i=2070; 5 / 7 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000012), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000056),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000012)
    },
    { /* i=2071; 98 / 52 */
        RTUINT128_INIT_C(0x000000026ad9f052, 0x0e60a76f2f1c4ae2), RTUINT128_INIT_C(0x0000000000000000, 0x000be5d443df054c),
        RTUINT128_INIT_C(0x0000000000000000, 0x000034039964de13), RTUINT128_INIT_C(0x0000000000000000, 0x000538a64146fe3e)
    },
    { /* i=2072; 122 / 81 */
        RTUINT128_INIT_C(0x02609c44e974cef6, 0x53c5ae34caff4cd8), RTUINT128_INIT_C(0x0000000000001979, 0xc90115198d844da1),
        RTUINT128_INIT_C(0x0000000000000000, 0x000017e3cb3254a8), RTUINT128_INIT_C(0x00000000000001c5, 0x4ea398d7ae418730)
    },
    { /* i=2073; 111 / 71 */
        RTUINT128_INIT_C(0x000021e6c412a48a, 0xedcdb82409b6879d), RTUINT128_INIT_C(0x0000000000000025, 0x1021c26ce0bd6d38),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000ea29956881), RTUINT128_INIT_C(0x0000000000000001, 0x0f4b8a0b4c4bbe65)
    },
    { /* i=2074; 107 / 105 */
        RTUINT128_INIT_C(0x00000456511c8d98, 0x2ae47a7179675f22), RTUINT128_INIT_C(0x000001094ef20fc3, 0xda719e51bdde5644),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000004), RTUINT128_INIT_C(0x0000003115544e88, 0xc11e012a81ee0612)
    },
    { /* i=2075; 114 / 71 */
        RTUINT128_INIT_C(0x0002cacb7d20900d, 0x22df08e420f768a8), RTUINT128_INIT_C(0x000000000000000c, 0xe9c874635b7cad5e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000375a8f644f63), RTUINT128_INIT_C(0x0000000000000002, 0xf470d6a50b885b4e)
    },
    { /* i=2076; 124 / 83 */
        RTUINT128_INIT_C(0x016d5cf40c9f7882, 0x1fcc2231bd25cd66), RTUINT128_INIT_C(0x000000000007a266, 0xc909663c55ef681a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000002fdb8b4420), RTUINT128_INIT_C(0x000000000003e69e, 0x983cc001a373e226)
    },
    { /* i=2077; 125 / 51 */
        RTUINT128_INIT_C(0x0a372b21567a7bb5, 0x957f59b68d5fd08f), RTUINT128_INIT_C(0x0000000000000000, 0x0007645176209f7b),
        RTUINT128_INIT_C(0x0000000000000161, 0xca38fa568185659a), RTUINT128_INIT_C(0x0000000000000000, 0x00045c78c8ed5991)
    },
    { /* i=2078; 99 / 74 */
        RTUINT128_INIT_C(0x000000050ba7d182, 0x6d01063771229bfb), RTUINT128_INIT_C(0x0000000000000120, 0xd677a718fa7f003f),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000478cee1), RTUINT128_INIT_C(0x000000000000005e, 0xedc1a827fbc8b29c)
    },
    { /* i=2079; 119 / 32 */
        RTUINT128_INIT_C(0x0077e002ac3ad203, 0xd0f133fa2452f979), RTUINT128_INIT_C(0x0000000000000000, 0x000000008495822c),
        RTUINT128_INIT_C(0x0000000000e775fa, 0xc8dda2bc2c002163), RTUINT128_INIT_C(0x0000000000000000, 0x0000000008b9f675)
    },
    { /* i=2080; 86 / 84 */
        RTUINT128_INIT_C(0x00000000001c7a6d, 0x28a04eecd0220bde), RTUINT128_INIT_C(0x0000000000045717, 0xc799566a3fafc6df),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000006), RTUINT128_INIT_C(0x0000000000026fde, 0x7b08486f520362a4)
    },
    { /* i=2081; 103 / 33 */
        RTUINT128_INIT_C(0x0000004c7a7cc5a6, 0x67706c1a2353a63f), RTUINT128_INIT_C(0x0000000000000000, 0x00000001f1b77dc9),
        RTUINT128_INIT_C(0x0000000000000027, 0x562bb3ff5978c40a), RTUINT128_INIT_C(0x0000000000000000, 0x000000015ea2d865)
    },
    { /* i=2082; 87 / 51 */
        RTUINT128_INIT_C(0x000000000069ed66, 0xd93ba5b64f26656b), RTUINT128_INIT_C(0x0000000000000000, 0x00036b7230e1cfd0),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000001ef9bc0aed), RTUINT128_INIT_C(0x0000000000000000, 0x0000d3c04f3ae1db)
    },
    { /* i=2083; 62 / 50 */
        RTUINT128_INIT_C(0x0000000000000000, 0x1f3b64063cf1e149), RTUINT128_INIT_C(0x0000000000000000, 0x0001f60263d0771d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000fed), RTUINT128_INIT_C(0x0000000000000000, 0x00007ff69df8e870)
    },
    { /* i=2084; 14 / 74 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000184d), RTUINT128_INIT_C(0x0000000000000047, 0x889880b4ca161af6),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000184d)
    },
    { /* i=2085; 126 / 27 */
        RTUINT128_INIT_C(0x0b73995441b6eca5, 0x6d3697aa60893495), RTUINT128_INIT_C(0x0000000000000000, 0x000000000154affc),
        RTUINT128_INIT_C(0x000000089ade1c97, 0xbd06d296fe8cd0f9), RTUINT128_INIT_C(0x0000000000000000, 0x00000000005d4879)
    },
    { /* i=2086; 113 / 23 */
        RTUINT128_INIT_C(0x000167751b000f04, 0x7eaaf15f1b003da8), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000092585),
        RTUINT128_INIT_C(0x00000000274cbbaa, 0xfba56d6f1d44a9f9), RTUINT128_INIT_C(0x0000000000000000, 0x000000000001f24b)
    },
    { /* i=2087; 124 / 61 */
        RTUINT128_INIT_C(0x0d988c168124485d, 0x37c5db2103030bf3), RTUINT128_INIT_C(0x0000000000000000, 0x0f0cfbd7b885b59d),
        RTUINT128_INIT_C(0x0000000000000000, 0xe7412b3f5b543e78), RTUINT128_INIT_C(0x0000000000000000, 0x0d0b6b40bbd5e45b)
    },
    { /* i=2088; 56 / 7 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00a48ddbf2dac530), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000004d),
        RTUINT128_INIT_C(0x0000000000000000, 0x00022316cdf58adf), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000001d)
    },
    { /* i=2089; 121 / 126 */
        RTUINT128_INIT_C(0x012138d66a808675, 0xfc2f9bb27abda62d), RTUINT128_INIT_C(0x34d9deae326e0793, 0x0e1c5c01a02ca8d3),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x012138d66a808675, 0xfc2f9bb27abda62d)
    },
    { /* i=2090; 100 / 53 */
        RTUINT128_INIT_C(0x00000005894aa8cd, 0x85bfe283c6c14b64), RTUINT128_INIT_C(0x0000000000000000, 0x000c90262bde580c),
        RTUINT128_INIT_C(0x0000000000000000, 0x000070d0629713ae), RTUINT128_INIT_C(0x0000000000000000, 0x00074bb5ee048f3c)
    },
    { /* i=2091; 35 / 2 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000045654c1d1), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000022b2a60e8), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001)
    },
    { /* i=2092; 87 / 27 */
        RTUINT128_INIT_C(0x000000000040704c, 0x6a546d6bac83df03), RTUINT128_INIT_C(0x0000000000000000, 0x0000000006d0780d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0974d2f617d519eb), RTUINT128_INIT_C(0x0000000000000000, 0x00000000019b6614)
    },
    { /* i=2093; 96 / 82 */
        RTUINT128_INIT_C(0x00000000cb76f1f8, 0xa4d419b1930335ec), RTUINT128_INIT_C(0x00000000000010f5, 0xbc07f2e32b72fde4),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000bff2e), RTUINT128_INIT_C(0x0000000000000b2d, 0x80b34ea750a77af4)
    },
    { /* i=2094; 56 / 11 */
        RTUINT128_INIT_C(0x0000000000000000, 0x009ff1280306e967), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000271),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000418322d222c7), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000190)
    },
    { /* i=2095; 115 / 94 */
        RTUINT128_INIT_C(0x000288d7e91eab05, 0x1d3f1a61145c141a), RTUINT128_INIT_C(0x000000003d1c13d3, 0x03bf86a8ebd246ed),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000a9e20), RTUINT128_INIT_C(0x000000002b21ced9, 0x2d98cd810d0af07a)
    },
    { /* i=2096; 79 / 83 */
        RTUINT128_INIT_C(0x00000000000020d0, 0x21c7c548bca385da), RTUINT128_INIT_C(0x0000000000037f6d, 0xba395fc1eeb8edd7),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00000000000020d0, 0x21c7c548bca385da)
    },
    { /* i=2097; 115 / 49 */
        RTUINT128_INIT_C(0x0006cc5478b8b255, 0x10a15aa53e3b2db8), RTUINT128_INIT_C(0x0000000000000000, 0x00002ffa188c9268),
        RTUINT128_INIT_C(0x0000000000000024, 0x4638bd98ec690b4b), RTUINT128_INIT_C(0x0000000000000000, 0x00002ef21619d140)
    },
    { /* i=2098; 114 / 34 */
        RTUINT128_INIT_C(0x0000b972eb25bb21, 0x2738098acc30fbf8), RTUINT128_INIT_C(0x0000000000000000, 0x000000033610b926),
        RTUINT128_INIT_C(0x00000000000039c0, 0x3380534411fbc0b0), RTUINT128_INIT_C(0x0000000000000000, 0x00000000079331d8)
    },
    { /* i=2099; 120 / 108 */
        RTUINT128_INIT_C(0x00571535e51fca9f, 0x6adafcfda6a5ad93), RTUINT128_INIT_C(0x00000405a011b295, 0x0081db9d63a8ee48),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000015a6), RTUINT128_INIT_C(0x0000036ea5ffc4f6, 0x6fa2abc22b8f42e3)
    },
    { /* i=2100; 114 / 36 */
        RTUINT128_INIT_C(0x00023b9c6d8d3399, 0xf189c7e60afd7bbb), RTUINT128_INIT_C(0x0000000000000000, 0x000000023b3bb310),
        RTUINT128_INIT_C(0x000000000001002b, 0x5963a7ddebbadca4), RTUINT128_INIT_C(0x0000000000000000, 0x00000001013d057b)
    },
    { /* i=2101; 113 / 113 */
        RTUINT128_INIT_C(0x000151178498c9c6, 0x053c7c5a746f8879), RTUINT128_INIT_C(0x0001a8afa8b1acd8, 0xb423f1f1f781232c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000151178498c9c6, 0x053c7c5a746f8879)
    },
    { /* i=2102; 120 / 53 */
        RTUINT128_INIT_C(0x00abd34e016ffe3a, 0xdf90c0f065b0bcad), RTUINT128_INIT_C(0x0000000000000000, 0x001f83a0839c6c80),
        RTUINT128_INIT_C(0x0000000000000005, 0x73cb6938c7eff17c), RTUINT128_INIT_C(0x0000000000000000, 0x00012fe99847aead)
    },
    { /* i=2103; 95 / 49 */
        RTUINT128_INIT_C(0x00000000048e7f8c, 0x56f49cd1c763eb94), RTUINT128_INIT_C(0x0000000000000000, 0x0000e6deb02b67cd),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000050d78a449b8), RTUINT128_INIT_C(0x0000000000000000, 0x0000b1a73043db3c)
    },
    { /* i=2104; 116 / 51 */
        RTUINT128_INIT_C(0x000a3e1e20f3dcd3, 0x014a202d92256c12), RTUINT128_INIT_C(0x0000000000000000, 0x00067ddfc810e944),
        RTUINT128_INIT_C(0x0000000000000001, 0x93eb333b4ea9c7eb), RTUINT128_INIT_C(0x0000000000000000, 0x000116530f676ea6)
    },
    { /* i=2105; 119 / 90 */
        RTUINT128_INIT_C(0x001aa4be473b805d, 0xb3f782f69f2b96f0), RTUINT128_INIT_C(0x00000000002ed4c7, 0xff2b9b00778fc3f5),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000091a535de), RTUINT128_INIT_C(0x0000000000226934, 0x3a0a82271b04ef7a)
    },
    { /* i=2106; 126 / 94 */
        RTUINT128_INIT_C(0x009ec983e1f2e1fd, 0xd26bd621d92e379d), RTUINT128_INIT_C(0x0000000013be43d4, 0xccbb19a66c70e46a),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000080ae8eb), RTUINT128_INIT_C(0x00000000081bec00, 0x1f88b489c2687a4f)
    },
    { /* i=2107; 113 / 79 */
        RTUINT128_INIT_C(0x0000d912c2c156b1, 0xe6929285f5de8d5d), RTUINT128_INIT_C(0x0000000000002c81, 0xf0b3e4608faaf5b3),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000004e091887e), RTUINT128_INIT_C(0x00000000000017a2, 0xc5a2110ea2cf8743)
    },
    { /* i=2108; 116 / 96 */
        RTUINT128_INIT_C(0x000d93c489b17730, 0xe29840ad87e70b23), RTUINT128_INIT_C(0x00000000c4aae0e4, 0x8aeb2b45279f10ca),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000011ac5e), RTUINT128_INIT_C(0x0000000094ac1c51, 0xff944519fecd28f7)
    },
    { /* i=2109; 116 / 108 */
        RTUINT128_INIT_C(0x00052b06f49026d4, 0xb0262de5fa0d50cf), RTUINT128_INIT_C(0x00000e8a7ce26a1e, 0xd1c5a33e20780844),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000005a), RTUINT128_INIT_C(0x00000e570cf6d7fe, 0xf0aaca0e8fda68e7)
    },
    { /* i=2110; 118 / 126 */
        RTUINT128_INIT_C(0x0038236d1e5acaac, 0xd686bee22d98ab4a), RTUINT128_INIT_C(0x06214be4003db012, 0xa7ee1c6c1b7ad323),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0038236d1e5acaac, 0xd686bee22d98ab4a)
    },
    { /* i=2111; 83 / 52 */
        RTUINT128_INIT_C(0x0000000000038f88, 0x88acff3580afbde2), RTUINT128_INIT_C(0x0000000000000000, 0x0007d5c7f70ea0cd),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000745708e7), RTUINT128_INIT_C(0x0000000000000000, 0x0005413793cb3ce7)
    },
    { /* i=2112; 77 / 108 */
        RTUINT128_INIT_C(0x0000000000000f0f, 0xf1bd74df29664857), RTUINT128_INIT_C(0x00000b7da7f5f812, 0xe01b6f35e8ece487),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000f0f, 0xf1bd74df29664857)
    },
    { /* i=2113; 29 / 27 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000154fa172), RTUINT128_INIT_C(0x0000000000000000, 0x0000000005157beb),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000004), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000f9b1c6)
    },
    { /* i=2114; 118 / 48 */
        RTUINT128_INIT_C(0x003c9aaa33ac0351, 0x2c7c0447def11f44), RTUINT128_INIT_C(0x0000000000000000, 0x0000824cf98a9ac1),
        RTUINT128_INIT_C(0x0000000000000077, 0x11741921f412018f), RTUINT128_INIT_C(0x0000000000000000, 0x00007b2f1a57ec75)
    },
    { /* i=2115; 110 / 101 */
        RTUINT128_INIT_C(0x00001777150489af, 0x573699e88e8db9cf), RTUINT128_INIT_C(0x0000001fde6d1780, 0x7f59e19ead4e0a48),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000bc), RTUINT128_INIT_C(0x0000000fbce74751, 0xd134e961493e2cef)
    },
    { /* i=2116; 118 / 117 */
        RTUINT128_INIT_C(0x0036dce357eb8fec, 0xbc6995f9f8571bda), RTUINT128_INIT_C(0x0019c0bb84d43620, 0x7be70dc56fbd4a7d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002), RTUINT128_INIT_C(0x00035b6c4e4323ab, 0xc49b7a6f18dc86e0)
    },
    { /* i=2117; 113 / 90 */
        RTUINT128_INIT_C(0x00009924f1171ff9, 0x9010eff876cf5016), RTUINT128_INIT_C(0x00000000012ea890, 0x209d2653d1c27bbd),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000818906), RTUINT128_INIT_C(0x0000000001299bf4, 0x62a27bc01dcb44a8)
    },
    { /* i=2118; 128 / 104 */
        RTUINT128_INIT_C(0xa2c255d56e16be55, 0xec7d2467a1bb05b5), RTUINT128_INIT_C(0x000000b0368f5059, 0x297242a9b07587db),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000ec7447), RTUINT128_INIT_C(0x0000001f49bcd97e, 0x3329170931af1bf8)
    },
    { /* i=2119; 45 / 11 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00001437b1f04725), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000010a),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000013751ebce6), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000029)
    },
    { /* i=2120; 107 / 49 */
        RTUINT128_INIT_C(0x000001c5a0468487, 0x210f63846be43d9d), RTUINT128_INIT_C(0x0000000000000000, 0x0000afa52eebc262),
        RTUINT128_INIT_C(0x0000000000000000, 0x02952703357f9ed7), RTUINT128_INIT_C(0x0000000000000000, 0x0000a17ac94d814f)
    },
    { /* i=2121; 118 / 95 */
        RTUINT128_INIT_C(0x001e0965a66ba1d6, 0x4aed35efa1d42356), RTUINT128_INIT_C(0x000000003352beaf, 0x538e365e293d627c),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000095d2ad), RTUINT128_INIT_C(0x000000001b09510a, 0x866b39bf1662dd8a)
    },
    { /* i=2122; 91 / 73 */
        RTUINT128_INIT_C(0x00000000001f403b, 0x892adabc96190fb8), RTUINT128_INIT_C(0x00000000000000d7, 0xcab08707cdcde8ae),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000002512), RTUINT128_INIT_C(0x00000000000000c3, 0xc53d3b715afd8d7c)
    },
    { /* i=2123; 103 / 54 */
        RTUINT128_INIT_C(0x0000002f0b1b7511, 0xa683bb103d0cc3c3), RTUINT128_INIT_C(0x0000000000000000, 0x003ddc78a31c0ae4),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000c2adf036d146), RTUINT128_INIT_C(0x0000000000000000, 0x000a1eb5b265a56b)
    },
    { /* i=2124; 125 / 88 */
        RTUINT128_INIT_C(0x0b8c68f79ea60549, 0x9c1a3f8fd27873f7), RTUINT128_INIT_C(0x00000000008b769e, 0x8af57401bd06937a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000001532cf0ba3), RTUINT128_INIT_C(0x000000000047dd18, 0xeff815341b4c4f49)
    },
    { /* i=2125; 122 / 83 */
        RTUINT128_INIT_C(0x003ce0d4fd266262, 0x25b1426485ff5051), RTUINT128_INIT_C(0x000000000000c696, 0xd0b04a09d0e77f7b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000004e7a4f51c8), RTUINT128_INIT_C(0x0000000000008bda, 0x276badf51cd8cd39)
    },
    { /* i=2126; 127 / 127 */
        RTUINT128_INIT_C(0x4947e44c58a2532c, 0xcf1e5c63e3f9c921), RTUINT128_INIT_C(0x37edca2b7daf3691, 0xf607b06a084beeaa),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x115a1a20daf31c9a, 0xd916abf9dbadda77)
    },
    { /* i=2127; 98 / 9 */
        RTUINT128_INIT_C(0x000000016c14a9f0, 0x121afe404015b086), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000001f5),
        RTUINT128_INIT_C(0x0000000000ba0989, 0x6bda3dd3298462f8), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000012e)
    },
    { /* i=2128; 13 / 37 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001d9e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000fe4bf6f92),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001d9e)
    },
    { /* i=2129; 122 / 122 */
        RTUINT128_INIT_C(0x03c13fb3fdac621f, 0xe425606e8cf20a3f), RTUINT128_INIT_C(0x03616974c50c865f, 0xa8cbe64a552a6739),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x005fd63f389fdbc0, 0x3b597a2437c7a306)
    },
    { /* i=2130; 112 / 67 */
        RTUINT128_INIT_C(0x00007b240d0d022c, 0x21389caf0ca3ae40), RTUINT128_INIT_C(0x0000000000000007, 0xf39219f860d06e2f),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000f7c9139fe09), RTUINT128_INIT_C(0x0000000000000001, 0x08c3864fb0862c99)
    },
    { /* i=2131; 124 / 49 */
        RTUINT128_INIT_C(0x065c64dcf7054cbf, 0xbc6853e1803ec455), RTUINT128_INIT_C(0x0000000000000000, 0x00011b5252664893),
        RTUINT128_INIT_C(0x00000000000005bf, 0x5cead7701a74cb01), RTUINT128_INIT_C(0x0000000000000000, 0x0000023041afeac2)
    },
    { /* i=2132; 90 / 71 */
        RTUINT128_INIT_C(0x00000000014915a5, 0xdc0389261e2211e2), RTUINT128_INIT_C(0x000000000000005f, 0xec2798045f480dd0),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000036e44), RTUINT128_INIT_C(0x000000000000003b, 0x56202933af9f06a2)
    },
    { /* i=2133; 126 / 42 */
        RTUINT128_INIT_C(0x359f6bb6a7099f4c, 0x22e5c9b385faee38), RTUINT128_INIT_C(0x0000000000000000, 0x000002bca2f9907c),
        RTUINT128_INIT_C(0x00000000001397c0, 0x942900a2856dc683), RTUINT128_INIT_C(0x0000000000000000, 0x0000025429ba16c4)
    },
    { /* i=2134; 55 / 45 */
        RTUINT128_INIT_C(0x0000000000000000, 0x002bc029ab124ddc), RTUINT128_INIT_C(0x0000000000000000, 0x00000232e7e834df),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000013e5), RTUINT128_INIT_C(0x0000000000000000, 0x00000169fc6e7561)
    },
    { /* i=2135; 51 / 3 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0004935edf1e41f6), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002),
        RTUINT128_INIT_C(0x0000000000000000, 0x000249af6f8f20fb), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=2136; 124 / 117 */
        RTUINT128_INIT_C(0x0101247dcc35ecc9, 0xb3a2282f8b8750af), RTUINT128_INIT_C(0x0002c687fdded560, 0x979e2fd57ce4df15),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000005c), RTUINT128_INIT_C(0x0001cb9e90213e13, 0x36c8f776a9472523)
    },
    { /* i=2137; 119 / 116 */
        RTUINT128_INIT_C(0x0003c79692a97792, 0x989d678c725b0975), RTUINT128_INIT_C(0x000233f5a5fb1598, 0x3219c77d27ba11b8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x000193a0ecae61fa, 0x6683a00f4aa0f7bd)
    },
    { /* i=2138; 113 / 125 */
        RTUINT128_INIT_C(0x000193ef82e514f7, 0x940cf90ec0880834), RTUINT128_INIT_C(0x09fdaaebaeb6d458, 0x41ae367cde7ca0e3),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000193ef82e514f7, 0x940cf90ec0880834)
    },
    { /* i=2139; 116 / 35 */
        RTUINT128_INIT_C(0x000e5dabc76d661b, 0x99786150fa5d1554), RTUINT128_INIT_C(0x0000000000000000, 0x00000005530cbac6),
        RTUINT128_INIT_C(0x000000000002b2b7, 0xf544eefb6b623321), RTUINT128_INIT_C(0x0000000000000000, 0x000000037ab78fce)
    },
    { /* i=2140; 127 / 41 */
        RTUINT128_INIT_C(0x669c1881f79e4d8f, 0x763c03967b4dab94), RTUINT128_INIT_C(0x0000000000000000, 0x00000070d622b33b),
        RTUINT128_INIT_C(0x0000000000e8cc45, 0x04ed5fbaa5f70219), RTUINT128_INIT_C(0x0000000000000000, 0x000000075796b4d1)
    },
    { /* i=2141; 121 / 78 */
        RTUINT128_INIT_C(0x0058c0d113da6b50, 0x5cba86db17564104), RTUINT128_INIT_C(0x0000000000001677, 0x908284fa33bc68d3),
        RTUINT128_INIT_C(0x0000000000000000, 0x000003f34b8cb2a9), RTUINT128_INIT_C(0x0000000000000776, 0xdf0c4eadcaae57b9)
    },
    { /* i=2142; 81 / 3 */
        RTUINT128_INIT_C(0x00000000000134dc, 0x35febc5d84a3c8d0), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000006),
        RTUINT128_INIT_C(0x000000000000337a, 0x08ffca0f961b4c22), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000004)
    },
    { /* i=2143; 122 / 92 */
        RTUINT128_INIT_C(0x034923b8176eb1f8, 0x4526524bd234fb6b), RTUINT128_INIT_C(0x000000000f041455, 0x5792a4fc2e880c1b),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000380436ae), RTUINT128_INIT_C(0x0000000009e16d1c, 0x128e804d66c30f11)
    },
    { /* i=2144; 31 / 20 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000870909f), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000ff2a0),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000087), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000079e3f)
    },
    { /* i=2145; 76 / 76 */
        RTUINT128_INIT_C(0x0000000000000e2c, 0x3f5ff90d15a37c0f), RTUINT128_INIT_C(0x000000000000010f, 0xacebaf355b87e8e8),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000d), RTUINT128_INIT_C(0x0000000000000060, 0x776813576fbca847)
    },
    { /* i=2146; 48 / 33 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000bc1deb93c432), RTUINT128_INIT_C(0x0000000000000000, 0x000000005e00e60a),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000002004c), RTUINT128_INIT_C(0x0000000000000000, 0x00000000373b793a)
    },
    { /* i=2147; 13 / 87 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001103), RTUINT128_INIT_C(0x0000000000007368, 0xcbf99a7b9207e59b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001103)
    },
    { /* i=2148; 116 / 96 */
        RTUINT128_INIT_C(0x0009f6a7840b53cd, 0x8effdcedc5febfce), RTUINT128_INIT_C(0x000000000420221a, 0x882b426883f77259),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000026a4330), RTUINT128_INIT_C(0x00000000010b44c2, 0x64337b7139d2041e)
    },
    { /* i=2149; 104 / 10 */
        RTUINT128_INIT_C(0x0000009f75c6111a, 0x40ff8261da2b33e7), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000e6),
        RTUINT128_INIT_C(0x00000000b17c68b3, 0x506bf68cab3e84ad), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000079)
    },
    { /* i=2150; 114 / 49 */
        RTUINT128_INIT_C(0x0001e324b3574f71, 0x644a32e16ccc4fd5), RTUINT128_INIT_C(0x0000000000000000, 0x000198071522390d),
        RTUINT128_INIT_C(0x0000000000000001, 0x2f20d31629cb1a29), RTUINT128_INIT_C(0x0000000000000000, 0x000146353e36dac0)
    },
    { /* i=2151; 52 / 21 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00021a76daa0c773), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000095484),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000039b65caf), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000089137)
    },
    { /* i=2152; 122 / 80 */
        RTUINT128_INIT_C(0x03bf41f9342027c6, 0x4b6677e6cdcf9cde), RTUINT128_INIT_C(0x0000000000008859, 0x2908bcf02964d43c),
        RTUINT128_INIT_C(0x0000000000000000, 0x000007090c9c7ac8), RTUINT128_INIT_C(0x00000000000084ce, 0x77e55b0c455535fe)
    },
    { /* i=2153; 115 / 3 */
        RTUINT128_INIT_C(0x00055aa7488b2234, 0x5ddd5945b4d5103c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000005),
        RTUINT128_INIT_C(0x0001122174e8a070, 0xdf92ab74575dd00c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=2154; 116 / 52 */
        RTUINT128_INIT_C(0x00047bf408736d2f, 0x29ae2d82a5e90c9c), RTUINT128_INIT_C(0x0000000000000000, 0x000117f601010be5),
        RTUINT128_INIT_C(0x0000000000000004, 0x19b4222ac20d72e7), RTUINT128_INIT_C(0x0000000000000000, 0x0000cc72220a56f9)
    },
    { /* i=2155; 116 / 75 */
        RTUINT128_INIT_C(0x000e424ac94207a3, 0x0d64903f427b4a97), RTUINT128_INIT_C(0x0000000000000343, 0x146a0c3359e026b5),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000045f064d049f), RTUINT128_INIT_C(0x0000000000000002, 0xfcffb4740d376c2c)
    },
    { /* i=2156; 8 / 6 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000011), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000011),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=2157; 127 / 15 */
        RTUINT128_INIT_C(0x2809a2a4131bb21b, 0xfeb1661e76e4ef8e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000002953),
        RTUINT128_INIT_C(0x0000f8079d2c6e88, 0x7bfeb5c4793f6605), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000eef)
    },
    { /* i=2158; 114 / 84 */
        RTUINT128_INIT_C(0x0001be21caeaadbc, 0xc71a983e82603b3b), RTUINT128_INIT_C(0x00000000000d0776, 0x043baa044e82df88),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000223db787), RTUINT128_INIT_C(0x00000000000772ad, 0xcfa6c4fa3a2a2283)
    },
    { /* i=2159; 120 / 92 */
        RTUINT128_INIT_C(0x00ee1b9c94bf42a2, 0x0ebb7f4c211a4dc8), RTUINT128_INIT_C(0x0000000001e1a813, 0xaef588e0c2801ff0),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000007e8dd98d), RTUINT128_INIT_C(0x000000000108c9e1, 0x8cf26658ae464698)
    },
    { /* i=2160; 113 / 10 */
        RTUINT128_INIT_C(0x00012046cc6bbd97, 0xbe7cb96cfb9d8384), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000003db),
        RTUINT128_INIT_C(0x0000004ac55467ae, 0x739d0bdc0ec79dd4), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000328)
    },
    { /* i=2161; 115 / 44 */
        RTUINT128_INIT_C(0x0006d17f35e46fce, 0x484730d2c90abd73), RTUINT128_INIT_C(0x0000000000000000, 0x00000aa538761233),
        RTUINT128_INIT_C(0x00000000000000a3, 0xf7a4b1ccfafb1354), RTUINT128_INIT_C(0x0000000000000000, 0x0000023dd8f1fbb7)
    },
    { /* i=2162; 31 / 94 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000066c05118), RTUINT128_INIT_C(0x000000000f8d186e, 0xef82dd093157de28),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000066c05118)
    },
    { /* i=2163; 119 / 88 */
        RTUINT128_INIT_C(0x0045474dbc8f412f, 0xa9fe0aa9452dbdda), RTUINT128_INIT_C(0x000000000057f053, 0x1ea0aa5dc4f0d316),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000c9ad8905), RTUINT128_INIT_C(0x0000000000033bd5, 0x54af5bf49fa4d86c)
    },
    { /* i=2164; 126 / 119 */
        RTUINT128_INIT_C(0x083ffb925575e4f7, 0x56e62833be9197c5), RTUINT128_INIT_C(0x006a2368bfff277d, 0x740c5b4af0558b2f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000013), RTUINT128_INIT_C(0x005f5acc1585f6a7, 0xb9fb61a3e8384348)
    },
    { /* i=2165; 117 / 95 */
        RTUINT128_INIT_C(0x0018eb2cac836a71, 0x81ee303f7cf1d88f), RTUINT128_INIT_C(0x000000004a49ac88, 0xb78983e1ffa23297),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000055df00), RTUINT128_INIT_C(0x0000000035d361e7, 0xee0271b666bd4f8f)
    },
    { /* i=2166; 101 / 29 */
        RTUINT128_INIT_C(0x0000000b0eb730e3, 0x29b60556fc0a660d), RTUINT128_INIT_C(0x0000000000000000, 0x000000001d56b5c7),
        RTUINT128_INIT_C(0x0000000000000060, 0x7be608e7716d16d3), RTUINT128_INIT_C(0x0000000000000000, 0x000000001d387908)
    },
    { /* i=2167; 121 / 103 */
        RTUINT128_INIT_C(0x00e351d99d9c4488, 0x93db5601f10477c9), RTUINT128_INIT_C(0x0000005195e22960, 0xeb85deea8c754879),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000002c949), RTUINT128_INIT_C(0x00000022fadf87ed, 0x90d383ed3cb9cc48)
    },
    { /* i=2168; 108 / 73 */
        RTUINT128_INIT_C(0x0000065dd8a8c2d0, 0x1f6d84ddd9b8d4ba), RTUINT128_INIT_C(0x0000000000000102, 0xaa9d4c4146777c9d),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000064d0b88e7), RTUINT128_INIT_C(0x000000000000008b, 0x0b2e253c35f4fb0f)
    },
    { /* i=2169; 21 / 13 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000c26e1), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000fe3),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000c3), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000cf8)
    },
    { /* i=2170; 119 / 67 */
        RTUINT128_INIT_C(0x006534f25dfd629b, 0xbf85470fe3877fe0), RTUINT128_INIT_C(0x0000000000000002, 0x066013859edf7b3a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0031fb26bbab4f68), RTUINT128_INIT_C(0x0000000000000000, 0x941095d9b3f88a50)
    },
    { /* i=2171; 49 / 14 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000aa8654460527), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000315),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000003754246dac), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000020b)
    },
    { /* i=2172; 110 / 38 */
        RTUINT128_INIT_C(0x00001fca583fd91e, 0xf1510e51643deed2), RTUINT128_INIT_C(0x0000000000000000, 0x00000008fa5f02b3),
        RTUINT128_INIT_C(0x000000000000038a, 0x79a17001ca4b0bc4), RTUINT128_INIT_C(0x0000000000000000, 0x0000000595f12cc6)
    },
    { /* i=2173; 119 / 83 */
        RTUINT128_INIT_C(0x00323c8d0d195565, 0x76aa0d046d3d6a8e), RTUINT128_INIT_C(0x000000000006bda5, 0x0159e36de3d1ceef),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000773de1075), RTUINT128_INIT_C(0x00000000000293c7, 0x68fec51e6128e753)
    },
    { /* i=2174; 109 / 106 */
        RTUINT128_INIT_C(0x000005e6e43e8abe, 0xcdd48daca238e959), RTUINT128_INIT_C(0x000003bed90bfc04, 0x4644aa8720afd91a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x000002280b328eba, 0x878fe3258189103f)
    },
    { /* i=2175; 111 / 88 */
        RTUINT128_INIT_C(0x00006c03c1f63f3a, 0x3e22719d77b71632), RTUINT128_INIT_C(0x0000000000eae856, 0x8cb5e1aec0ab04dc),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000075b69e), RTUINT128_INIT_C(0x00000000003f02a5, 0xf290dc9fc029ae6a)
    },
    { /* i=2176; 79 / 12 */
        RTUINT128_INIT_C(0x0000000000006836, 0x5cb455261d430619), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000ac3),
        RTUINT128_INIT_C(0x0000000000000009, 0xaf017593c27f0c74), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000001bd)
    },
    { /* i=2177; 124 / 69 */
        RTUINT128_INIT_C(0x00e4c61acfce05d1, 0x67c1f53d998f2860), RTUINT128_INIT_C(0x000000000000001b, 0x63866ff44542c614),
        RTUINT128_INIT_C(0x0000000000000000, 0x00085a535215edf4), RTUINT128_INIT_C(0x000000000000000d, 0x89d7c9e41ce5d950)
    },
    { /* i=2178; 125 / 126 */
        RTUINT128_INIT_C(0x102718351d2a22bc, 0xf1e49be5e5d1a7e9), RTUINT128_INIT_C(0x2418c08f84558b9c, 0x17c349a06ffdb629),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x102718351d2a22bc, 0xf1e49be5e5d1a7e9)
    },
    { /* i=2179; 123 / 122 */
        RTUINT128_INIT_C(0x04b45b3d624a9a51, 0xde45fc7896304411), RTUINT128_INIT_C(0x02bd73820731d68f, 0xe0bf67bd067ac3d8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x01f6e7bb5b18c3c1, 0xfd8694bb8fb58039)
    },
    { /* i=2180; 92 / 15 */
        RTUINT128_INIT_C(0x00000000062f18ff, 0xe6c75768ca48f86f), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000077e4),
        RTUINT128_INIT_C(0x0000000000000d34, 0x5b261fe3e71e0358), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000160f)
    },
    { /* i=2181; 128 / 45 */
        RTUINT128_INIT_C(0xa09c78bdfaf5a958, 0xad7bb0fa97e2a1b3), RTUINT128_INIT_C(0x0000000000000000, 0x000016e254841a2c),
        RTUINT128_INIT_C(0x00000000000704b9, 0xf8e970019dc1917f), RTUINT128_INIT_C(0x0000000000000000, 0x00000f03205ab9df)
    },
    { /* i=2182; 127 / 121 */
        RTUINT128_INIT_C(0x4a0be148b32905fc, 0x0a7082b0e769be85), RTUINT128_INIT_C(0x0109c1f79e1eb632, 0x9f6b02dc37c18464),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000047), RTUINT128_INIT_C(0x0057159bd8a47df1, 0xd3c2b79d70be06c9)
    },
    { /* i=2183; 117 / 9 */
        RTUINT128_INIT_C(0x0004b4d2706ef761, 0x3b0c971ad1a9fdda), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000ed),
        RTUINT128_INIT_C(0x00000515694032bb, 0x478a5091ef9a19ea), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000038)
    },
    { /* i=2184; 123 / 110 */
        RTUINT128_INIT_C(0x050af69d20ac761e, 0xf65a9ad0db43fbe1), RTUINT128_INIT_C(0x0000263bd9648636, 0xb0758d9632f44474),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000021c3), RTUINT128_INIT_C(0x0000200093cd2db7, 0x658f64d68e60e385)
    },
    { /* i=2185; 37 / 29 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000061c4d40f8), RTUINT128_INIT_C(0x0000000000000000, 0x000000001baa874d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000038), RTUINT128_INIT_C(0x0000000000000000, 0x000000000effa820)
    },
    { /* i=2186; 116 / 124 */
        RTUINT128_INIT_C(0x000e858973cf6483, 0x22c29f28350310ec), RTUINT128_INIT_C(0x032941d773894212, 0x79160786e7f82d86),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000e858973cf6483, 0x22c29f28350310ec)
    },
    { /* i=2187; 128 / 36 */
        RTUINT128_INIT_C(0x67ece44fda77c3e7, 0xea2281c1cbe2c53b), RTUINT128_INIT_C(0x0000000000000000, 0x00000000d3685902),
        RTUINT128_INIT_C(0x000000007dd8af5a, 0x25d7935f9bc0b7e5), RTUINT128_INIT_C(0x0000000000000000, 0x00000000206ab871)
    },
    { /* i=2188; 117 / 54 */
        RTUINT128_INIT_C(0x001ae4b7766ca888, 0xdd62d8fbd7133855), RTUINT128_INIT_C(0x0000000000000000, 0x0015af8507df046f),
        RTUINT128_INIT_C(0x0000000000000001, 0x3d7a7713f6888d52), RTUINT128_INIT_C(0x0000000000000000, 0x0004f10f773aa9c7)
    },
    { /* i=2189; 117 / 48 */
        RTUINT128_INIT_C(0x00051b073ba670d7, 0x6c6cf4b05e64ffc0), RTUINT128_INIT_C(0x0000000000000000, 0x0000053c1b915d65),
        RTUINT128_INIT_C(0x00000000000000f9, 0xae4c82f8e7d19ea7), RTUINT128_INIT_C(0x0000000000000000, 0x000000ab4877bcdd)
    },
    { /* i=2190; 119 / 28 */
        RTUINT128_INIT_C(0x0028e829741d8fdc, 0x65c2462410944802), RTUINT128_INIT_C(0x0000000000000000, 0x000000000705b1d2),
        RTUINT128_INIT_C(0x0000000005d348bd, 0x1da6b5c05e79ce30), RTUINT128_INIT_C(0x0000000000000000, 0x000000000229f4a2)
    },
    { /* i=2191; 36 / 33 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000a3a5935e3), RTUINT128_INIT_C(0x0000000000000000, 0x000000009c2216dd),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000010), RTUINT128_INIT_C(0x0000000000000000, 0x000000007837c813)
    },
    { /* i=2192; 125 / 78 */
        RTUINT128_INIT_C(0x19a27651c4cd35c1, 0xa6c22d4cd7e625a0), RTUINT128_INIT_C(0x00000000000027d3, 0x2496c8a2ef3a842f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000a4c88cee9b52), RTUINT128_INIT_C(0x0000000000000284, 0x9e4778db316d5992)
    },
    { /* i=2193; 79 / 30 */
        RTUINT128_INIT_C(0x0000000000006d3b, 0xaa809f6226bce20d), RTUINT128_INIT_C(0x0000000000000000, 0x000000002afda764),
        RTUINT128_INIT_C(0x0000000000000000, 0x00028a74d9a5e074), RTUINT128_INIT_C(0x0000000000000000, 0x0000000011e188bd)
    },
    { /* i=2194; 116 / 22 */
        RTUINT128_INIT_C(0x000c5d889d3f4a2f, 0x0e514fcb1cf10143), RTUINT128_INIT_C(0x0000000000000000, 0x000000000033e122),
        RTUINT128_INIT_C(0x000000003d0462aa, 0x667fd34e6b0b865b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000322e2d)
    },
    { /* i=2195; 72 / 114 */
        RTUINT128_INIT_C(0x000000000000008c, 0x1ef1389795cb5def), RTUINT128_INIT_C(0x00008bd60203eb5e, 0x367c0cd1be43bf94),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000000000000008c, 0x1ef1389795cb5def)
    },
    { /* i=2196; 126 / 120 */
        RTUINT128_INIT_C(0x213fb4369267ddeb, 0x2b38a8cb005f7f41), RTUINT128_INIT_C(0x003b7893ba88f3ec, 0x57e421b37223707e),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000008f), RTUINT128_INIT_C(0x000759b15fe79ce6, 0x12c9d58e3e93a8df)
    },
    { /* i=2197; 117 / 109 */
        RTUINT128_INIT_C(0x0007614c18773f5b, 0x8dacb936888d96c7), RTUINT128_INIT_C(0x00001b854e649aac, 0x26b422d5d8773614),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000044), RTUINT128_INIT_C(0x000011e345be29a1, 0x45d3786908e33977)
    },
    { /* i=2198; 127 / 48 */
        RTUINT128_INIT_C(0x3d6efb063fc48506, 0x61a8250c9400c343), RTUINT128_INIT_C(0x0000000000000000, 0x0000db7cdf686ae0),
        RTUINT128_INIT_C(0x00000000000047a7, 0x31b0e0679c36730f), RTUINT128_INIT_C(0x0000000000000000, 0x00006f18899fe023)
    },
    { /* i=2199; 30 / 24 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000002016df29), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000cc1343),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000028), RTUINT128_INIT_C(0x0000000000000000, 0x000000000033dcb1)
    },
    { /* i=2200; 123 / 46 */
        RTUINT128_INIT_C(0x034e228fde0f7a77, 0x68c69ebbb18c4dc4), RTUINT128_INIT_C(0x0000000000000000, 0x00003785a197a3e5),
        RTUINT128_INIT_C(0x0000000000000f3d, 0x58c427085176d8c8), RTUINT128_INIT_C(0x0000000000000000, 0x00000514803d0adc)
    },
    { /* i=2201; 53 / 51 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0003d027160c373c), RTUINT128_INIT_C(0x0000000000000000, 0x000537954770fc01),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0003d027160c373c)
    },
    { /* i=2202; 50 / 21 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00004c61aac5b58f), RTUINT128_INIT_C(0x0000000000000000, 0x00000000001ddcdd),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000028ec8db), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000171c80)
    },
    { /* i=2203; 110 / 63 */
        RTUINT128_INIT_C(0x00003a0b2d2aaebe, 0x8bda5298eba457be), RTUINT128_INIT_C(0x0000000000000000, 0x7b46f4ee84ef5068),
        RTUINT128_INIT_C(0x0000000000000000, 0x00007888e1a4de2c), RTUINT128_INIT_C(0x0000000000000000, 0x7aca6c17a02855de)
    },
    { /* i=2204; 123 / 72 */
        RTUINT128_INIT_C(0x05d5640f04ec5dbb, 0x777a5246f403fec5), RTUINT128_INIT_C(0x0000000000000044, 0x498315dedeb78271),
        RTUINT128_INIT_C(0x0000000000000000, 0x0015de890c07ca51), RTUINT128_INIT_C(0x000000000000000c, 0xb39e0d6ad1ef8f04)
    },
    { /* i=2205; 117 / 109 */
        RTUINT128_INIT_C(0x0000f10313d80ef9, 0xff35ebc7a2535e6e), RTUINT128_INIT_C(0x000019ec436fea34, 0x398b13490c804f85),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000009), RTUINT128_INIT_C(0x000007b4b4e8d323, 0xf9523e3631d092c1)
    },
    { /* i=2206; 124 / 120 */
        RTUINT128_INIT_C(0x0038f580024979a4, 0x8c7dee628d9eac12), RTUINT128_INIT_C(0x000c42c17017696b, 0x0f452c7374197936),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000004), RTUINT128_INIT_C(0x0007ea7a41ebd3f8, 0x4f693c94bd38c73a)
    },
    { /* i=2207; 126 / 54 */
        RTUINT128_INIT_C(0x26838d1aef607b01, 0xa5435ce158d6c6b0), RTUINT128_INIT_C(0x0000000000000000, 0x0021e7a413090752),
        RTUINT128_INIT_C(0x0000000000000122, 0xccf68827af890aec), RTUINT128_INIT_C(0x0000000000000000, 0x00145f8d7958d318)
    },
    { /* i=2208; 9 / 25 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000165), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000af3142),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000165)
    },
    { /* i=2209; 122 / 91 */
        RTUINT128_INIT_C(0x02aa3ea8b7edcf42, 0x0778d509f2b0fd45), RTUINT128_INIT_C(0x00000000078edfcf, 0x97b78bc2d7f29815),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000005a444492), RTUINT128_INIT_C(0x00000000068432ad, 0x1ffeb8a6925cad4b)
    },
    { /* i=2210; 42 / 5 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000003e0bdd5a791), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000014),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000031a3177b94), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001)
    },
    { /* i=2211; 122 / 23 */
        RTUINT128_INIT_C(0x02c993c34ac04922, 0xe54180b839db0461), RTUINT128_INIT_C(0x0000000000000000, 0x00000000003a3a03),
        RTUINT128_INIT_C(0x0000000c4153105d, 0x001a95805270b826), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000343fef)
    },
    { /* i=2212; 124 / 48 */
        RTUINT128_INIT_C(0x07d8f3af37633e33, 0xe12194d62937831f), RTUINT128_INIT_C(0x0000000000000000, 0x000099d59016ccf4),
        RTUINT128_INIT_C(0x0000000000000d0f, 0x27b23241af806ccb), RTUINT128_INIT_C(0x0000000000000000, 0x00002c3e02ac0da3)
    },
    { /* i=2213; 125 / 109 */
        RTUINT128_INIT_C(0x0bb1b95a2329b79e, 0x9b7cec85d7f7dbf0), RTUINT128_INIT_C(0x00000efc1be3c8c8, 0x5369d849eec0418b),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000c7c8), RTUINT128_INIT_C(0x00000ab648212246, 0x29aa7a2bded19a58)
    },
    { /* i=2214; 126 / 107 */
        RTUINT128_INIT_C(0x3c88657549a17d2c, 0xcca3849b2ee72ae6), RTUINT128_INIT_C(0x0000033a4fa21548, 0x2df478f9941af1f0),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000012c0f2), RTUINT128_INIT_C(0x00000336f3600149, 0x7f418fb3f51a7606)
    },
    { /* i=2215; 115 / 110 */
        RTUINT128_INIT_C(0x00042b1c8f390495, 0x4eabf9bcdfcf9413), RTUINT128_INIT_C(0x000027625cec40f5, 0xcbfbb886e9178219),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000001b), RTUINT128_INIT_C(0x000003bcc24e2aa8, 0xcb1f83824a54db70)
    },
    { /* i=2216; 58 / 24 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00896713623e7636), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000228b5f),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000003fa41a4b0), RTUINT128_INIT_C(0x0000000000000000, 0x000000000016c8e6)
    },
    { /* i=2217; 117 / 91 */
        RTUINT128_INIT_C(0x0012621f1b500604, 0xc35eda46d181788b), RTUINT128_INIT_C(0x0000000005c25e0a, 0x89d87e799874e572),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000003312449), RTUINT128_INIT_C(0x000000000207cdb5, 0x60ca2319a7160309)
    },
    { /* i=2218; 119 / 89 */
        RTUINT128_INIT_C(0x00133fa3d0b9f2df, 0x9523dd9f94bc5e0c), RTUINT128_INIT_C(0x00000000016fc73d, 0x5ea0672b0fa0bc69),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000d65fd6f), RTUINT128_INIT_C(0x0000000000566e39, 0x23d93f864969e785)
    },
    { /* i=2219; 42 / 14 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000002d7c77aa05d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000002d61),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000001009af45), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001638)
    },
    { /* i=2220; 119 / 59 */
        RTUINT128_INIT_C(0x007a9d74cbb4bb1b, 0x05432f0b12681ed1), RTUINT128_INIT_C(0x0000000000000000, 0x064db5a003aa3bf7),
        RTUINT128_INIT_C(0x0000000000000000, 0x1373a532868093f8), RTUINT128_INIT_C(0x0000000000000000, 0x03e8802d7f8f3289)
    },
    { /* i=2221; 81 / 60 */
        RTUINT128_INIT_C(0x000000000000563a, 0x9495ff2b842858b7), RTUINT128_INIT_C(0x0000000000000000, 0x0be0876da46b1045),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000074296), RTUINT128_INIT_C(0x0000000000000000, 0x081ce19c21580649)
    },
    { /* i=2222; 114 / 39 */
        RTUINT128_INIT_C(0x00031bb1209592d2, 0x7e46e9fe51c4d8e8), RTUINT128_INIT_C(0x0000000000000000, 0x0000005cd9b5b2f9),
        RTUINT128_INIT_C(0x0000000000000891, 0xd1eb4851be0bd72e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000b1b1c912a)
    },
    { /* i=2223; 115 / 101 */
        RTUINT128_INIT_C(0x0000b356af0e00d3, 0xa01bff14200561cd), RTUINT128_INIT_C(0x0000000a0a98a02c, 0x55f43abfd155c7a3),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000011dc), RTUINT128_INIT_C(0x0000000171416904, 0x8a52c555880bfeb9)
    },
    { /* i=2224; 97 / 102 */
        RTUINT128_INIT_C(0x000000004e07918d, 0x38de70374d830506), RTUINT128_INIT_C(0x00000001e933c2de, 0x81dbb0ef114bd124),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000000004e07918d, 0x38de70374d830506)
    },
    { /* i=2225; 123 / 82 */
        RTUINT128_INIT_C(0x042a432f13bc42b0, 0x36d48fd07f8e327b), RTUINT128_INIT_C(0x00000000000086fa, 0xa5e3e5faaec50cc1),
        RTUINT128_INIT_C(0x0000000000000000, 0x000007e6433ef98a), RTUINT128_INIT_C(0x00000000000067d5, 0x6873203b062f9971)
    },
    { /* i=2226; 122 / 54 */
        RTUINT128_INIT_C(0x00c0fd82cec581ee, 0xf9f7f0d8e425814d), RTUINT128_INIT_C(0x0000000000000000, 0x002a4881896ae300),
        RTUINT128_INIT_C(0x0000000000000004, 0x90713b4823ec6ca2), RTUINT128_INIT_C(0x0000000000000000, 0x000a455492bddb4d)
    },
    { /* i=2227; 123 / 48 */
        RTUINT128_INIT_C(0x00969fc3550964b9, 0xe86a34ee57d885ec), RTUINT128_INIT_C(0x0000000000000000, 0x00005ba77265a90e),
        RTUINT128_INIT_C(0x00000000000001a4, 0xb5ade59f651b20f1), RTUINT128_INIT_C(0x0000000000000000, 0x00004be196889fbe)
    },
    { /* i=2228; 120 / 111 */
        RTUINT128_INIT_C(0x00e2ee846adc8b70, 0xe26a028d979c4053), RTUINT128_INIT_C(0x0000381ecec6098a, 0x60831e84898be4fb),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000040b), RTUINT128_INIT_C(0x000009f67033f8fc, 0xb04da0b57f057d8a)
    },
    { /* i=2229; 123 / 120 */
        RTUINT128_INIT_C(0x07a0ac31ca80b29c, 0x9ef549f60487db8d), RTUINT128_INIT_C(0x00cb4b69fe35964d, 0x431dfcbc45719031),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000009), RTUINT128_INIT_C(0x007b0577da9e69e5, 0x42e767579389c9d4)
    },
    { /* i=2230; 128 / 89 */
        RTUINT128_INIT_C(0x0930464630dbab74, 0xf981aaad626afdaa), RTUINT128_INIT_C(0x000000000020f0d3, 0x27cf01af04ed9726),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000004768c91983), RTUINT128_INIT_C(0x00000000001bfec2, 0x991967258c3def38)
    },
    { /* i=2231; 121 / 119 */
        RTUINT128_INIT_C(0x01f509d8401c7f58, 0xbc6502fb30eccd96), RTUINT128_INIT_C(0x00096726aa91da07, 0xb150696b63d05aa2),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000035), RTUINT128_INIT_C(0x0002aed6efea5bc1, 0x06bf2fbf86ca0a0c)
    },
    { /* i=2232; 116 / 60 */
        RTUINT128_INIT_C(0x000414115f2cd170, 0x85a931884a4fcfbd), RTUINT128_INIT_C(0x0000000000000000, 0x08fb6fb9c31ea709),
        RTUINT128_INIT_C(0x0000000000000000, 0x00743cdec10bf7c7), RTUINT128_INIT_C(0x0000000000000000, 0x0484a8d213ef48be)
    },
    { /* i=2233; 124 / 55 */
        RTUINT128_INIT_C(0x02641a405811026b, 0x6c25953ac72d84ad), RTUINT128_INIT_C(0x0000000000000000, 0x0008e49e3344f5c5),
        RTUINT128_INIT_C(0x0000000000000044, 0xd453a1065a8c7e3a), RTUINT128_INIT_C(0x0000000000000000, 0x0003fc6b8edae00b)
    },
    { /* i=2234; 120 / 101 */
        RTUINT128_INIT_C(0x005190fe8da4ff44, 0x8e6fedd2e5af4529), RTUINT128_INIT_C(0x000000062c43e7de, 0x0d737d73483ccb3a),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000d36ae), RTUINT128_INIT_C(0x000000035e4de0a3, 0xae9fad24a78ce7bd)
    },
    { /* i=2235; 117 / 108 */
        RTUINT128_INIT_C(0x000af157c86b80f4, 0x25df042d51118e33), RTUINT128_INIT_C(0x0000010514a88866, 0xa9d6870f7bb60e8e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000aba), RTUINT128_INIT_C(0x000000d830a463ba, 0x5eba481852396f07)
    },
    { /* i=2236; 102 / 96 */
        RTUINT128_INIT_C(0x00000006df68ec1e, 0x337556fb8499a35e), RTUINT128_INIT_C(0x000000009f4db771, 0x4022969b837b81de),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000b), RTUINT128_INIT_C(0x0000000007120a40, 0x71f8de4cde4b0ed4)
    },
    { /* i=2237; 58 / 52 */
        RTUINT128_INIT_C(0x0000000000000000, 0x011248867750432c), RTUINT128_INIT_C(0x0000000000000000, 0x000d62cebc31415d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000014), RTUINT128_INIT_C(0x0000000000000000, 0x0006905fc37727e8)
    },
    { /* i=2238; 125 / 69 */
        RTUINT128_INIT_C(0x092f12259fb30dda, 0xb7a8cbaed5786529), RTUINT128_INIT_C(0x0000000000000015, 0x098cc011b520836c),
        RTUINT128_INIT_C(0x0000000000000000, 0x006fc1da0d5fda0c), RTUINT128_INIT_C(0x0000000000000005, 0x802382e766f44419)
    },
    { /* i=2239; 127 / 70 */
        RTUINT128_INIT_C(0x1aeb722c136c4ce8, 0x83268d22169f4023), RTUINT128_INIT_C(0x000000000000002d, 0x7cd7817d24c79a11),
        RTUINT128_INIT_C(0x0000000000000000, 0x0097805da0e9d40a), RTUINT128_INIT_C(0x0000000000000016, 0x100a29a681c42779)
    },
    { /* i=2240; 79 / 53 */
        RTUINT128_INIT_C(0x0000000000005b63, 0xae1458dec9a5ac3a), RTUINT128_INIT_C(0x0000000000000000, 0x001e3a7c5c6e1b59),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000305f646), RTUINT128_INIT_C(0x0000000000000000, 0x0019c1932185abe4)
    },
    { /* i=2241; 18 / 36 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000009991), RTUINT128_INIT_C(0x0000000000000000, 0x0000000f955d8267),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000009991)
    },
    { /* i=2242; 118 / 118 */
        RTUINT128_INIT_C(0x000f375f3708a078, 0xc5d600358d254fc8), RTUINT128_INIT_C(0x0014c3da10670edd, 0xd2e33e82f6d57867),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000f375f3708a078, 0xc5d600358d254fc8)
    },
    { /* i=2243; 118 / 51 */
        RTUINT128_INIT_C(0x0034f62ca4066ee9, 0x12ea1634b32c2c66), RTUINT128_INIT_C(0x0000000000000000, 0x000180d9b8a048e8),
        RTUINT128_INIT_C(0x0000000000000023, 0x3aceec3322ab35f8), RTUINT128_INIT_C(0x0000000000000000, 0x00002d1925d583a6)
    },
    { /* i=2244; 31 / 18 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000004d817bc0), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000c204),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000006644), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000005ab0)
    },
    { /* i=2245; 113 / 76 */
        RTUINT128_INIT_C(0x0001f5679ce32d64, 0xe0d997277e21821a), RTUINT128_INIT_C(0x00000000000004cc, 0x1c4c7a784a22f539),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000006884994218), RTUINT128_INIT_C(0x000000000000013d, 0x2bc924459490d2c2)
    },
    { /* i=2246; 83 / 72 */
        RTUINT128_INIT_C(0x000000000001d983, 0xec5883921a3cdd22), RTUINT128_INIT_C(0x000000000000004f, 0xdcca72ded79dfff5),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000005ed), RTUINT128_INIT_C(0x0000000000000044, 0x90add10e66f71e51)
    },
    { /* i=2247; 113 / 116 */
        RTUINT128_INIT_C(0x0000300f8e5c5ed2, 0x11d26ce065c9d965), RTUINT128_INIT_C(0x00006f1da6840503, 0x918dc95be204670c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000300f8e5c5ed2, 0x11d26ce065c9d965)
    },
    { /* i=2248; 123 / 98 */
        RTUINT128_INIT_C(0x01a1a0a6fcb8c305, 0xbeaea7719a65daca), RTUINT128_INIT_C(0x0000000026b433fb, 0x5dc0313aa9d8e26d),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000aca5237), RTUINT128_INIT_C(0x000000001d599869, 0xe7b2cb74b8444b5f)
    },
    { /* i=2249; 113 / 124 */
        RTUINT128_INIT_C(0x000041adfabef52e, 0x5f4458f2970ffcc3), RTUINT128_INIT_C(0x0f7289f99180bd6b, 0xfd42343ac9cbaaf1),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000041adfabef52e, 0x5f4458f2970ffcc3)
    },
    { /* i=2250; 121 / 107 */
        RTUINT128_INIT_C(0x0175e2c954cb18ad, 0x885706a4932e4ce1), RTUINT128_INIT_C(0x000003f14be58228, 0x4984b36c30ae88b8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000005ed5), RTUINT128_INIT_C(0x00000126e90b0229, 0xa30c03bffbc2fbc9)
    },
    { /* i=2251; 120 / 29 */
        RTUINT128_INIT_C(0x0015b5e261fc16a4, 0xe0f478e03e984cf4), RTUINT128_INIT_C(0x0000000000000000, 0x0000000001826fa9),
        RTUINT128_INIT_C(0x000000000e61e5c3, 0x78799c4397e11820), RTUINT128_INIT_C(0x0000000000000000, 0x0000000001497fd4)
    },
    { /* i=2252; 120 / 103 */
        RTUINT128_INIT_C(0x00e83d4804d14a27, 0xb0546cffcd64c1b9), RTUINT128_INIT_C(0x0000007c7a9c0450, 0x1ef92e5439ee9e8e),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000001dd9d), RTUINT128_INIT_C(0x0000007c1f195b4e, 0x66301366a89eeea3)
    },
    { /* i=2253; 69 / 63 */
        RTUINT128_INIT_C(0x000000000000001c, 0x0c2d3e4cf3092218), RTUINT128_INIT_C(0x0000000000000000, 0x3066197ce7b3e8dc),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000094), RTUINT128_INIT_C(0x0000000000000000, 0x11268216ff0682e8)
    },
    { /* i=2254; 127 / 111 */
        RTUINT128_INIT_C(0x7959d27a80743bbf, 0x8ab27bbdd1604030), RTUINT128_INIT_C(0x0000039b0b900fd8, 0xdbd8159cf79b0eac),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000021a7e2), RTUINT128_INIT_C(0x0000017d45fb7008, 0xb69a16a82fbf1858)
    },
    { /* i=2255; 126 / 127 */
        RTUINT128_INIT_C(0x3d81c65741ab253f, 0xae0147d8e7fd4b58), RTUINT128_INIT_C(0x389a62fc18a5d550, 0x57c8498da1d449a9),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x04e7635b29054fef, 0x5638fe4b462901af)
    },
    { /* i=2256; 33 / 65 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000110c9a458), RTUINT128_INIT_C(0x0000000000000000, 0x0d532cf3023a653e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000110c9a458)
    },
    { /* i=2257; 126 / 34 */
        RTUINT128_INIT_C(0x07105f78dd710886, 0x876a28f76ec4d5a0), RTUINT128_INIT_C(0x0000000000000000, 0x00000002d8c786ed),
        RTUINT128_INIT_C(0x00000000027b3b35, 0x1cdcd440146afd1c), RTUINT128_INIT_C(0x0000000000000000, 0x000000022677dab4)
    },
    { /* i=2258; 116 / 116 */
        RTUINT128_INIT_C(0x00041559ee2ebca7, 0xfcaf45b0bd7e236b), RTUINT128_INIT_C(0x000ecd6a500f11c7, 0xc829cd5fe293869a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00041559ee2ebca7, 0xfcaf45b0bd7e236b)
    },
    { /* i=2259; 67 / 27 */
        RTUINT128_INIT_C(0x0000000000000005, 0xf3e4f2ae0b3f7972), RTUINT128_INIT_C(0x0000000000000000, 0x00000000013abd01),
        RTUINT128_INIT_C(0x0000000000000000, 0x000004d77f0c4341), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000d23931)
    },
    { /* i=2260; 115 / 49 */
        RTUINT128_INIT_C(0x000252d289779b1e, 0xe60dc5fe9dc0ce4a), RTUINT128_INIT_C(0x0000000000000000, 0x000103ec90b2dd08),
        RTUINT128_INIT_C(0x0000000000000002, 0x49d7a49b6b3cfaac), RTUINT128_INIT_C(0x0000000000000000, 0x00007d9893da7cea)
    },
    { /* i=2261; 125 / 123 */
        RTUINT128_INIT_C(0x03bebd31c7a235bd, 0x87ccf6ee2a26c312), RTUINT128_INIT_C(0x00f9b5b38ff89cc3, 0x780f6b87c3a1b446),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003), RTUINT128_INIT_C(0x00d19c1717b85f73, 0x1f9eb456df41a640)
    },
    { /* i=2262; 86 / 30 */
        RTUINT128_INIT_C(0x000000000012f78c, 0xd108c62256c30029), RTUINT128_INIT_C(0x0000000000000000, 0x000000000b2aeae1),
        RTUINT128_INIT_C(0x0000000000000000, 0x01b2c987dab09f97), RTUINT128_INIT_C(0x0000000000000000, 0x0000000003e0b672)
    },
    { /* i=2263; 120 / 10 */
        RTUINT128_INIT_C(0x00004b0b802108d1, 0x18515602251e0c8d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000297),
        RTUINT128_INIT_C(0x0000001cfa03e93b, 0x646dc8244c822b43), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000208)
    },
    { /* i=2264; 123 / 107 */
        RTUINT128_INIT_C(0x00f18b7d0df8c504, 0xe7b1a255931cb86a), RTUINT128_INIT_C(0x000006ff0f202c65, 0x0eb0cc0ac76ac55e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000002286), RTUINT128_INIT_C(0x000001f8dd3c1c2b, 0xbc0d66350302ed36)
    },
    { /* i=2265; 117 / 101 */
        RTUINT128_INIT_C(0x000741a90079be14, 0x2ee6b1c0bdea814a), RTUINT128_INIT_C(0x00000011b4b7d990, 0x2bc025a35923665a),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000068ea), RTUINT128_INIT_C(0x0000000f200a4e86, 0x21f9ee3ae1fa6306)
    },
    { /* i=2266; 117 / 114 */
        RTUINT128_INIT_C(0x0015620a8e5470bf, 0x945a3685c1e1cf7c), RTUINT128_INIT_C(0x0001ca570ab77805, 0x4c68b0e55d217970),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000b), RTUINT128_INIT_C(0x0001b04d18724885, 0x4bda9caac17197ac)
    },
    { /* i=2267; 116 / 118 */
        RTUINT128_INIT_C(0x00066d9ca1210bef, 0x2dce9e8364fd32e7), RTUINT128_INIT_C(0x002d77026bfadaef, 0xfb474b5ce440802f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00066d9ca1210bef, 0x2dce9e8364fd32e7)
    },
    { /* i=2268; 117 / 57 */
        RTUINT128_INIT_C(0x001d9a0ab9f48448, 0x8494f7ba601c1a22), RTUINT128_INIT_C(0x0000000000000000, 0x01927a034f5ce8fa),
        RTUINT128_INIT_C(0x0000000000000000, 0x12d41a5da7aa87d5), RTUINT128_INIT_C(0x0000000000000000, 0x00f35d9f8cee6c20)
    },
    { /* i=2269; 98 / 88 */
        RTUINT128_INIT_C(0x000000017b4f19f0, 0x1079bbd443bfce0a), RTUINT128_INIT_C(0x0000000000e61d90, 0xe4352a2ea3152539),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000001a5), RTUINT128_INIT_C(0x0000000000e07aa8, 0xc50b5d2211f9974d)
    },
    { /* i=2270; 115 / 32 */
        RTUINT128_INIT_C(0x000514d15048c7bc, 0xd523ccc9828214f0), RTUINT128_INIT_C(0x0000000000000000, 0x000000004fb154eb),
        RTUINT128_INIT_C(0x00000000001052aa, 0xe955d2748da9dbee), RTUINT128_INIT_C(0x0000000000000000, 0x0000000039dd1976)
    },
    { /* i=2271; 119 / 111 */
        RTUINT128_INIT_C(0x005b74adcd33be73, 0xe30867ac22d91679), RTUINT128_INIT_C(0x00006b974689203d, 0x1ced392276d05b6a),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000d9), RTUINT128_INIT_C(0x0000417302f76aa6, 0x5df2f9756c3b999f)
    },
    { /* i=2272; 110 / 13 */
        RTUINT128_INIT_C(0x0000107a3f84e180, 0xb285819bd5f9107d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001633),
        RTUINT128_INIT_C(0x00000000be0492b6, 0x256b8cbf9c59761d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000ab6)
    },
    { /* i=2273; 48 / 66 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000032f4dd3887ad), RTUINT128_INIT_C(0x0000000000000003, 0x5f3dc645884665e0),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000032f4dd3887ad)
    },
    { /* i=2274; 113 / 124 */
        RTUINT128_INIT_C(0x0001d1787455253f, 0x15d3165bcdcbafdf), RTUINT128_INIT_C(0x0255fcd7961ade56, 0x5799b7162ceaddaf),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0001d1787455253f, 0x15d3165bcdcbafdf)
    },
    { /* i=2275; 99 / 40 */
        RTUINT128_INIT_C(0x0000000298b6994b, 0x564ce08cd0307ab9), RTUINT128_INIT_C(0x0000000000000000, 0x000000c707170d84),
        RTUINT128_INIT_C(0x0000000000000000, 0x0356fd52d0a0147e), RTUINT128_INIT_C(0x0000000000000000, 0x0000005dd34983c1)
    },
    { /* i=2276; 104 / 97 */
        RTUINT128_INIT_C(0x000000541b8be28b, 0x466db7b06bf1d953), RTUINT128_INIT_C(0x000000001f6df9c2, 0x91e2766a43f84dc0),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000002ad), RTUINT128_INIT_C(0x00000000024694ea, 0xeb76dd588c89ce93)
    },
    { /* i=2277; 123 / 15 */
        RTUINT128_INIT_C(0x067cdf093a448144, 0xc32e078438832d11), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000140),
        RTUINT128_INIT_C(0x000530b26dc836cd, 0xd09c24d2d02d35bd), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000d1)
    },
    { /* i=2278; 116 / 113 */
        RTUINT128_INIT_C(0x0001823e9fe05f92, 0x5fd41eb61873dce6), RTUINT128_INIT_C(0x0001086b4e054d76, 0x682d3c176154cfdc),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x000079d351db121b, 0xf7a6e29eb71f0d0a)
    },
    { /* i=2279; 96 / 25 */
        RTUINT128_INIT_C(0x0000000025048d4a, 0xa722666633b6e7a4), RTUINT128_INIT_C(0x0000000000000000, 0x0000000001f66a05),
        RTUINT128_INIT_C(0x0000000000000012, 0xdcae2cfd80cb066f), RTUINT128_INIT_C(0x0000000000000000, 0x00000000016bd179)
    },
    { /* i=2280; 103 / 42 */
        RTUINT128_INIT_C(0x0000002910592e71, 0x4f189729bed41ab3), RTUINT128_INIT_C(0x0000000000000000, 0x0000030a43867128),
        RTUINT128_INIT_C(0x0000000000000000, 0x0d81e759ce65e410), RTUINT128_INIT_C(0x0000000000000000, 0x00000060f4dd6833)
    },
    { /* i=2281; 123 / 83 */
        RTUINT128_INIT_C(0x0384c3c217b9073a, 0x5400749783962820), RTUINT128_INIT_C(0x00000000000740bd, 0x3f1c171d97edbc7f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000007c31a5e80d), RTUINT128_INIT_C(0x000000000005fc8f, 0x8351bb948cd57dad)
    },
    { /* i=2282; 120 / 114 */
        RTUINT128_INIT_C(0x00bcae9075e88355, 0x483d19ace879eed4), RTUINT128_INIT_C(0x0002bb27777b4074, 0xd5276f6ca8591a2c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000045), RTUINT128_INIT_C(0x00003ced41b023d7, 0xd49c11638875e0f8)
    },
    { /* i=2283; 95 / 7 */
        RTUINT128_INIT_C(0x00000000611e995d, 0x49e7cfe14930d1c8), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000006d),
        RTUINT128_INIT_C(0x0000000000e418e4, 0xac20a8a8d1b2f17b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000069)
    },
    { /* i=2284; 112 / 41 */
        RTUINT128_INIT_C(0x0000da6592e1a615, 0xf0762c27aaa9a7f8), RTUINT128_INIT_C(0x0000000000000000, 0x000000067ee5b6a2),
        RTUINT128_INIT_C(0x000000000000219f, 0x2d359124b91295fb), RTUINT128_INIT_C(0x0000000000000000, 0x00000003a2bf4d22)
    },
    { /* i=2285; 11 / 3 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000006a2), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000006a2), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=2286; 115 / 23 */
        RTUINT128_INIT_C(0x00025a2c4060946c, 0x80872efac80c2399), RTUINT128_INIT_C(0x0000000000000000, 0x00000000001d1060),
        RTUINT128_INIT_C(0x0000000014b808a6, 0x2bb3e45f4bcf7ef9), RTUINT128_INIT_C(0x0000000000000000, 0x000000000017f639)
    },
    { /* i=2287; 125 / 86 */
        RTUINT128_INIT_C(0x14e3afdd1a3293f2, 0x21a2adf9b3b278b4), RTUINT128_INIT_C(0x00000000002c651b, 0x7088b8b26a4c80ff),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000787504917e), RTUINT128_INIT_C(0x0000000000217385, 0x0c7fa0457dfe8c32)
    },
    { /* i=2288; 103 / 78 */
        RTUINT128_INIT_C(0x000000113681f7db, 0xa76414a66aa53b74), RTUINT128_INIT_C(0x0000000000003b93, 0x5e5032adbd1532e7),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000049f703), RTUINT128_INIT_C(0x0000000000003043, 0xb802f0223b69c1bf)
    },
    { /* i=2289; 55 / 25 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00640a948cbed8c3), RTUINT128_INIT_C(0x0000000000000000, 0x00000000015abe16),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000049dc4a82), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000cff597)
    },
    { /* i=2290; 51 / 12 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000d053d46d859f), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000083b),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000194fcdfe7b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000746)
    },
    { /* i=2291; 95 / 26 */
        RTUINT128_INIT_C(0x000000001150770d, 0xe1322964c7a18eb1), RTUINT128_INIT_C(0x0000000000000000, 0x0000000001194f21),
        RTUINT128_INIT_C(0x000000000000000f, 0xc1ae3d2b99cd43f8), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000fa43b9)
    },
    { /* i=2292; 5 / 7 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000f), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000066),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000f)
    },
    { /* i=2293; 116 / 79 */
        RTUINT128_INIT_C(0x000fde4c43a88f6d, 0x7a658707d88681ae), RTUINT128_INIT_C(0x0000000000000161, 0x0e7c9d5ad6d67cbd),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000b818e8f9e2e), RTUINT128_INIT_C(0x0000000000000026, 0x34893adf596c71b8)
    },
    { /* i=2294; 92 / 46 */
        RTUINT128_INIT_C(0x000000000c00c98f, 0x1efd3036cd313c22), RTUINT128_INIT_C(0x0000000000000000, 0x0000160b16f71daa),
        RTUINT128_INIT_C(0x0000000000000000, 0x00008b65cdb9dc76), RTUINT128_INIT_C(0x0000000000000000, 0x000001f647f177c6)
    },
    { /* i=2295; 125 / 69 */
        RTUINT128_INIT_C(0x16c55918112741bc, 0xc155d83b1ef4cff8), RTUINT128_INIT_C(0x000000000000001e, 0x7142f06dcd99fc60),
        RTUINT128_INIT_C(0x0000000000000000, 0x00bf7cd4ac1b404f), RTUINT128_INIT_C(0x0000000000000005, 0xca768ea40f37ee58)
    },
    { /* i=2296; 122 / 22 */
        RTUINT128_INIT_C(0x0362e9c741c4aea9, 0xf6db999382d10c1f), RTUINT128_INIT_C(0x0000000000000000, 0x00000000002703c1),
        RTUINT128_INIT_C(0x00000016385e4c81, 0xd5365fbcac0f388e), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000bbf11)
    },
    { /* i=2297; 96 / 9 */
        RTUINT128_INIT_C(0x00000000e7e24026, 0x1122b0d61b73ba02), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000aa),
        RTUINT128_INIT_C(0x00000000015d3090, 0xc9e397a0e20b38cf), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000008c)
    },
    { /* i=2298; 116 / 105 */
        RTUINT128_INIT_C(0x000296cb457f4900, 0xfab20bb50c36f20c), RTUINT128_INIT_C(0x0000011659437c79, 0xfc91e55b791c1586),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000261), RTUINT128_INIT_C(0x000000a0ebf42acf, 0x239f6d19f067be46)
    },
    { /* i=2299; 121 / 27 */
        RTUINT128_INIT_C(0x00dac49699f3064d, 0x94befa4c4785131d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000006ea161e),
        RTUINT128_INIT_C(0x000000001fa3b40a, 0xe3cb90417209164a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000006e61a71)
    },
    { /* i=2300; 125 / 62 */
        RTUINT128_INIT_C(0x11d2e68d956db3af, 0xbf9c78281d10e6d4), RTUINT128_INIT_C(0x0000000000000000, 0x230ec63d45918373),
        RTUINT128_INIT_C(0x0000000000000000, 0x82276adc2bb6871f), RTUINT128_INIT_C(0x0000000000000000, 0x0609abb12f5e56e7)
    },
    { /* i=2301; 59 / 33 */
        RTUINT128_INIT_C(0x0000000000000000, 0x045ce18485d16352), RTUINT128_INIT_C(0x0000000000000000, 0x000000008de44b0d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000007df1152), RTUINT128_INIT_C(0x0000000000000000, 0x000000002e627c28)
    },
    { /* i=2302; 75 / 75 */
        RTUINT128_INIT_C(0x000000000000041d, 0x6e38bcc8105146e4), RTUINT128_INIT_C(0x000000000000004f, 0xb9617fe329c4e5cf),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000d), RTUINT128_INIT_C(0x0000000000000011, 0x04453e3ef1519b61)
    },
    { /* i=2303; 56 / 47 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00c6904f5626a8ca), RTUINT128_INIT_C(0x0000000000000000, 0x00005f6b4f893588),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000214), RTUINT128_INIT_C(0x0000000000000000, 0x0000454e0d036a2a)
    },
    { /* i=2304; 57 / 91 */
        RTUINT128_INIT_C(0x0000000000000000, 0x01fbdb09a942fe2d), RTUINT128_INIT_C(0x0000000001240cf1, 0xdf7d643439f8667e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x01fbdb09a942fe2d)
    },
    { /* i=2305; 126 / 107 */
        RTUINT128_INIT_C(0x00002f216efa48b4, 0x9fdb8472e5f8ac6d), RTUINT128_INIT_C(0x00000700f4321409, 0xd06ab34ba2cc1502),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000006), RTUINT128_INIT_C(0x0000051bb5cdd079, 0xbd5b50ad15302e61)
    },
    { /* i=2306; 120 / 20 */
        RTUINT128_INIT_C(0x00bd6dbe0bf4f971, 0x54013dbc95701dfa), RTUINT128_INIT_C(0x0000000000000000, 0x000000000002071d),
        RTUINT128_INIT_C(0x0000005d6a9f4e62, 0x34712594765764e3), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000017b43)
    },
    { /* i=2307; 120 / 33 */
        RTUINT128_INIT_C(0x00da20701bc08949, 0x67705bd8fe7e16e8), RTUINT128_INIT_C(0x0000000000000000, 0x0000000164479e61),
        RTUINT128_INIT_C(0x00000000009cbb64, 0x141a064955d4ca1e), RTUINT128_INIT_C(0x0000000000000000, 0x000000005dccfd8a)
    },
    { /* i=2308; 126 / 120 */
        RTUINT128_INIT_C(0x00a412e910eed42e, 0x16602121ee6c4121), RTUINT128_INIT_C(0x00f219c2cd136d40, 0x93c41e6c0e147729),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00a412e910eed42e, 0x16602121ee6c4121)
    },
    { /* i=2309; 99 / 78 */
        RTUINT128_INIT_C(0x00000002b69c89d4, 0x3b939e03e73d4a24), RTUINT128_INIT_C(0x0000000000001b0d, 0xfb6126d8eab1b327),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000019aca6), RTUINT128_INIT_C(0x0000000000000d61, 0x294bc451d4d5eada)
    },
    { /* i=2310; 60 / 14 */
        RTUINT128_INIT_C(0x0000000000000000, 0x05b8cb6a26ee420b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000002c5b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000210624418982), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000008d5)
    },
    { /* i=2311; 107 / 26 */
        RTUINT128_INIT_C(0x00000056ca81f112, 0xa9689439a59e400c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000003718084),
        RTUINT128_INIT_C(0x0000000000001934, 0x8d6a6dfe1f08e9f8), RTUINT128_INIT_C(0x0000000000000000, 0x0000000001919c2c)
    },
    { /* i=2312; 123 / 86 */
        RTUINT128_INIT_C(0x0578f0c4e04dec60, 0x8231b5ae23c2f9c9), RTUINT128_INIT_C(0x00000000003275ac, 0x4a52f13efde3f61a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000001bc379940c), RTUINT128_INIT_C(0x00000000001d0cb9, 0x49a061ff52826891)
    },
    { /* i=2313; 113 / 3 */
        RTUINT128_INIT_C(0x0000c0bdffa9f87c, 0xfb05663feb33c2df), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000005),
        RTUINT128_INIT_C(0x0000268c665531b2, 0x989aae0cc8a3f3c6), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001)
    },
    { /* i=2314; 123 / 70 */
        RTUINT128_INIT_C(0x079e9bfeb72fba72, 0x3befecac98b7534b), RTUINT128_INIT_C(0x0000000000000002, 0x252abad1468398f1),
        RTUINT128_INIT_C(0x0000000000000000, 0x038d4c1c49a28124), RTUINT128_INIT_C(0x0000000000000001, 0xbcb6c676dca26067)
    },
    { /* i=2315; 125 / 124 */
        RTUINT128_INIT_C(0x13423c0b31144e8e, 0x86d4c16cce32c0ab), RTUINT128_INIT_C(0x0c44a08bca7f03e1, 0xa1033c601c315148),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x06fd9b7f66954aac, 0xe5d1850cb2016f63)
    },
    { /* i=2316; 128 / 25 */
        RTUINT128_INIT_C(0x6cbae57a5562573a, 0x88636c89effb29ec), RTUINT128_INIT_C(0x0000000000000000, 0x000000000004525d),
        RTUINT128_INIT_C(0x00001928ae746ab9, 0xff754a3fc1d2c123), RTUINT128_INIT_C(0x0000000000000000, 0x000000000001ca35)
    },
    { /* i=2317; 125 / 70 */
        RTUINT128_INIT_C(0x1fc1b1b3d96e876d, 0xa732ad671ad974c5), RTUINT128_INIT_C(0x0000000000000023, 0xa3a20a0a93de55fa),
        RTUINT128_INIT_C(0x0000000000000000, 0x00e41c6f42525e56), RTUINT128_INIT_C(0x000000000000001a, 0x3c1a1cc5cc82c6c9)
    },
    { /* i=2318; 123 / 32 */
        RTUINT128_INIT_C(0x065587268cc6a153, 0xeb0dc6f6f546daae), RTUINT128_INIT_C(0x0000000000000000, 0x00000000278d1b6d),
        RTUINT128_INIT_C(0x0000000028ff89ed, 0x73cc043990a5aa5c), RTUINT128_INIT_C(0x0000000000000000, 0x000000000d199d82)
    },
    { /* i=2319; 40 / 25 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000048d1c3754e), RTUINT128_INIT_C(0x0000000000000000, 0x00000000005a3118),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000ceb0), RTUINT128_INIT_C(0x0000000000000000, 0x00000000004064ce)
    },
    { /* i=2320; 59 / 65 */
        RTUINT128_INIT_C(0x0000000000000000, 0x06cbc128e2873a25), RTUINT128_INIT_C(0x0000000000000000, 0xb7bc5c5df2a246a0),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x06cbc128e2873a25)
    },
    { /* i=2321; 120 / 99 */
        RTUINT128_INIT_C(0x008252ab4e31773e, 0xa741b82f4a2221df), RTUINT128_INIT_C(0x00000004a745f2ce, 0xebdc452a06842939),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000001c0182), RTUINT128_INIT_C(0x0000000088178f27, 0x7488b85cf49ff9ed)
    },
    { /* i=2322; 114 / 123 */
        RTUINT128_INIT_C(0x0002725c256f49ee, 0x004209beda3fa7b6), RTUINT128_INIT_C(0x02de981b8f6069f8, 0x9138b67ebb31be1e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0002725c256f49ee, 0x004209beda3fa7b6)
    },
    { /* i=2323; 125 / 57 */
        RTUINT128_INIT_C(0x1a568af731ad56d9, 0x4959ab07f787ed4b), RTUINT128_INIT_C(0x0000000000000000, 0x0031ba852850a291),
        RTUINT128_INIT_C(0x0000000000000087, 0x963afa778339638f), RTUINT128_INIT_C(0x0000000000000000, 0x00129383de560b4c)
    },
    { /* i=2324; 79 / 19 */
        RTUINT128_INIT_C(0x0000000000006233, 0xb72f927092492313), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000ab9f),
        RTUINT128_INIT_C(0x0000000000000000, 0x927bdc743f3c5390), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000ca3)
    },
    { /* i=2325; 120 / 69 */
        RTUINT128_INIT_C(0x0026753ee229aa1c, 0x828680c893de812e), RTUINT128_INIT_C(0x0000000000000013, 0xdbf2320950c1a2e0),
        RTUINT128_INIT_C(0x0000000000000000, 0x0001efc0d6325673), RTUINT128_INIT_C(0x0000000000000008, 0xcd6df97f306b168e)
    },
    { /* i=2326; 124 / 36 */
        RTUINT128_INIT_C(0x0dfa7f76a28e7575, 0xe30871276499c72b), RTUINT128_INIT_C(0x0000000000000000, 0x00000005d82f9f5d),
        RTUINT128_INIT_C(0x0000000002644982, 0x0cef813bd7bf4454), RTUINT128_INIT_C(0x0000000000000000, 0x00000001cd41c8a7)
    },
    { /* i=2327; 108 / 5 */
        RTUINT128_INIT_C(0x00000200844973bd, 0x061af034174fb2ec), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000018),
        RTUINT128_INIT_C(0x000000155ad864d2, 0x8aebca022ba3521f), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000004)
    },
    { /* i=2328; 58 / 45 */
        RTUINT128_INIT_C(0x0000000000000000, 0x026bf9747a75ee41), RTUINT128_INIT_C(0x0000000000000000, 0x000001524dfc24ba),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000001d524), RTUINT128_INIT_C(0x0000000000000000, 0x0000010293b80219)
    },
    { /* i=2329; 126 / 38 */
        RTUINT128_INIT_C(0x0cbbd5b4322c3142, 0xb0a154fe90247cc7), RTUINT128_INIT_C(0x0000000000000000, 0x00000036808e9007),
        RTUINT128_INIT_C(0x00000000003bcfa3, 0xea40e7ed4003be5f), RTUINT128_INIT_C(0x0000000000000000, 0x000000329c42d82e)
    },
    { /* i=2330; 91 / 59 */
        RTUINT128_INIT_C(0x00000000027c6566, 0xb8c651caeef5c182), RTUINT128_INIT_C(0x0000000000000000, 0x04e0f3a8e429d0ab),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000082717c80), RTUINT128_INIT_C(0x0000000000000000, 0x00dcbc68a77f9802)
    },
    { /* i=2331; 59 / 45 */
        RTUINT128_INIT_C(0x0000000000000000, 0x05464430be75f102), RTUINT128_INIT_C(0x0000000000000000, 0x00000b12b3868b3d),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000079f1), RTUINT128_INIT_C(0x0000000000000000, 0x000000bb24fd0795)
    },
    { /* i=2332; 77 / 47 */
        RTUINT128_INIT_C(0x000000000000087c, 0x7fe1a95eac4c6966), RTUINT128_INIT_C(0x0000000000000000, 0x00005aea97853b7c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000017e544c1), RTUINT128_INIT_C(0x0000000000000000, 0x00004bbcb321a0ea)
    },
    { /* i=2333; 89 / 66 */
        RTUINT128_INIT_C(0x0000000001825f4d, 0x22a8f13680cfd2c7), RTUINT128_INIT_C(0x0000000000000003, 0xd7a41ba83e4db0b0),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000648e69), RTUINT128_INIT_C(0x0000000000000001, 0xdb49f04cd630ba97)
    },
    { /* i=2334; 124 / 62 */
        RTUINT128_INIT_C(0x065b26ffc59bfa21, 0x4ffa1c0e83b24aea), RTUINT128_INIT_C(0x0000000000000000, 0x3a2966a1ad40d58f),
        RTUINT128_INIT_C(0x0000000000000000, 0x1bf9f1ab4e61efd7), RTUINT128_INIT_C(0x0000000000000000, 0x19e64d5efdaf6ed1)
    },
    { /* i=2335; 53 / 1 */
        RTUINT128_INIT_C(0x0000000000000000, 0x001145e5d8c5f59f), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001),
        RTUINT128_INIT_C(0x0000000000000000, 0x001145e5d8c5f59f), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=2336; 119 / 107 */
        RTUINT128_INIT_C(0x004871a89a503a43, 0x8311e01cb27350a3), RTUINT128_INIT_C(0x000001fe34355f3d, 0x5ae6c77ee849db96),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000002459), RTUINT128_INIT_C(0x000000f0f25d7d26, 0x74c8ac538de4e17d)
    },
    { /* i=2337; 125 / 13 */
        RTUINT128_INIT_C(0x0c3ea8bfa15ab22f, 0xdf004759b04d1972), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000886),
        RTUINT128_INIT_C(0x00016fc4f4ed9f2c, 0x22b67031ab41807b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000110)
    },
    { /* i=2338; 37 / 84 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000018a76cae4a), RTUINT128_INIT_C(0x000000000003923a, 0xc44870807c4d966d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00000018a76cae4a)
    },
    { /* i=2339; 124 / 107 */
        RTUINT128_INIT_C(0x0bd196d915c59589, 0x4573a811ec04ce4f), RTUINT128_INIT_C(0x000005a11150584c, 0x83c30ea694ba194a),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000002197b), RTUINT128_INIT_C(0x000005243af2a861, 0xcd00300e178e6dc1)
    },
    { /* i=2340; 110 / 99 */
        RTUINT128_INIT_C(0x0000320e6147fc42, 0x27e8cfe727da0df5), RTUINT128_INIT_C(0x000000057a982833, 0xbcf85dc4ba604e37),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000922), RTUINT128_INIT_C(0x00000004bfa8d3be, 0x53a07139044fbba7)
    },
    { /* i=2341; 118 / 66 */
        RTUINT128_INIT_C(0x0010f0a4c43241eb, 0xd743b0765d869d96), RTUINT128_INIT_C(0x0000000000000002, 0x13dad2cbd2810a85),
        RTUINT128_INIT_C(0x0000000000000000, 0x0008276030ee0b46), RTUINT128_INIT_C(0x0000000000000000, 0xe4432fde8b240638)
    },
    { /* i=2342; 114 / 114 */
        RTUINT128_INIT_C(0x00005b6e64d8270e, 0xe0532fc6a2ccc25f), RTUINT128_INIT_C(0x00013e49e5a5d827, 0x66c473176a3d55e8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00005b6e64d8270e, 0xe0532fc6a2ccc25f)
    },
    { /* i=2343; 81 / 73 */
        RTUINT128_INIT_C(0x000000000000e927, 0x5d7cf29c44d288a2), RTUINT128_INIT_C(0x0000000000000032, 0x28e4a5e434f97386),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000004a5), RTUINT128_INIT_C(0x000000000000002f, 0x6f8675b23a3cfb44)
    },
    { /* i=2344; 99 / 50 */
        RTUINT128_INIT_C(0x000000076bfce7f3, 0xfdf395fab88422fd), RTUINT128_INIT_C(0x0000000000000000, 0x00027316273db210),
        RTUINT128_INIT_C(0x0000000000000000, 0x000307a54559cb3d), RTUINT128_INIT_C(0x0000000000000000, 0x00021ed43b0e052d)
    },
    { /* i=2345; 98 / 74 */
        RTUINT128_INIT_C(0x0000000218f017d5, 0x4ece925a34e4b048), RTUINT128_INIT_C(0x0000000000000253, 0x071da8b65ef96c8a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000e70202), RTUINT128_INIT_C(0x000000000000015d, 0xc8b2211e9392c334)
    },
    { /* i=2346; 90 / 70 */
        RTUINT128_INIT_C(0x0000000002e6aed7, 0xc109e79f243c3489), RTUINT128_INIT_C(0x0000000000000027, 0xdb5292fda06625c2),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000012a241), RTUINT128_INIT_C(0x0000000000000020, 0x7a38ce8a1ec3da47)
    },
    { /* i=2347; 68 / 46 */
        RTUINT128_INIT_C(0x000000000000000a, 0x13712a9bf1965dc8), RTUINT128_INIT_C(0x0000000000000000, 0x0000035a0fea461d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000003019166), RTUINT128_INIT_C(0x0000000000000000, 0x000002f94b6b013a)
    },
    { /* i=2348; 77 / 59 */
        RTUINT128_INIT_C(0x0000000000001714, 0x8f4c4570ff1db1eb), RTUINT128_INIT_C(0x0000000000000000, 0x07070849d00a9f0f),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000348c7), RTUINT128_INIT_C(0x0000000000000000, 0x05a2a16d6cf2d542)
    },
    { /* i=2349; 126 / 50 */
        RTUINT128_INIT_C(0x0cdd19929a48c5b5, 0x51c92a5f1f2c8c0f), RTUINT128_INIT_C(0x0000000000000000, 0x0001066be528cbf5),
        RTUINT128_INIT_C(0x0000000000000c8c, 0x84808304cd10bc4e), RTUINT128_INIT_C(0x0000000000000000, 0x00006c8166a67b69)
    },
    { /* i=2350; 116 / 119 */
        RTUINT128_INIT_C(0x0007524c52e6fab0, 0x522c66124543ae14), RTUINT128_INIT_C(0x00220ba54e7a6b09, 0x02fce0eefaaaab5f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0007524c52e6fab0, 0x522c66124543ae14)
    },
    { /* i=2351; 121 / 6 */
        RTUINT128_INIT_C(0x0164cc6700a13736, 0x159eaa1d26832b0b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000021),
        RTUINT128_INIT_C(0x000acfe4174ab418, 0xe961e61fe9e4f1ca), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001)
    },
    { /* i=2352; 124 / 95 */
        RTUINT128_INIT_C(0x057a584f54f4a526, 0x700d9d04def576fe), RTUINT128_INIT_C(0x000000004d38f021, 0x6201da2e12e9b8e8),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000001228e9cf), RTUINT128_INIT_C(0x000000003340a653, 0x2c72df07a66dcb66)
    },
    { /* i=2353; 53 / 19 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0013857231dd5d40), RTUINT128_INIT_C(0x0000000000000000, 0x000000000002fabc),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000068d50c50e), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000faf8)
    },
    { /* i=2354; 83 / 50 */
        RTUINT128_INIT_C(0x0000000000067581, 0x156859302ed149b3), RTUINT128_INIT_C(0x0000000000000000, 0x0000eabb74698b14),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000070b51a08b), RTUINT128_INIT_C(0x0000000000000000, 0x000090bb254245d7)
    },
    { /* i=2355; 66 / 16 */
        RTUINT128_INIT_C(0x0000000000000000, 0x9583040616cb748c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000008715),
        RTUINT128_INIT_C(0x0000000000000000, 0x00011b58b1c62ca2), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000005d42)
    },
    { /* i=2356; 3 / 10 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000175),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003)
    },
    { /* i=2357; 126 / 104 */
        RTUINT128_INIT_C(0x1c080bdfa84def21, 0xbb73fd6606d6e31c), RTUINT128_INIT_C(0x000000def0ce5e86, 0x794f36e38b4f1442),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000020302a), RTUINT128_INIT_C(0x00000059a3ea0c6c, 0x1db8e80fcfd13048)
    },
    { /* i=2358; 85 / 72 */
        RTUINT128_INIT_C(0x000000000017a29a, 0x8fdc99413634a431), RTUINT128_INIT_C(0x0000000000000009, 0x95eb7e9edde3a0a0),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000027737), RTUINT128_INIT_C(0x0000000000000003, 0xe52ad0337962c1d1)
    },
    { /* i=2359; 116 / 39 */
        RTUINT128_INIT_C(0x0005a870cf83cd07, 0x3f263c66c969c015), RTUINT128_INIT_C(0x0000000000000000, 0x000000316fb9c36a),
        RTUINT128_INIT_C(0x0000000000001d4c, 0x8eea5b37285a3f88), RTUINT128_INIT_C(0x0000000000000000, 0x00000007745ed9c5)
    },
    { /* i=2360; 76 / 47 */
        RTUINT128_INIT_C(0x0000000000000df0, 0x1a2a400366ee8acd), RTUINT128_INIT_C(0x0000000000000000, 0x0000090566b09fe8),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000018b87516d), RTUINT128_INIT_C(0x0000000000000000, 0x000005597fca0d05)
    },
    { /* i=2361; 115 / 95 */
        RTUINT128_INIT_C(0x0000d43300e3fbd4, 0x1aa1f718cd308abe), RTUINT128_INIT_C(0x00000000017bc1a5, 0x836a51f35ec97ef2),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000008f0c05), RTUINT128_INIT_C(0x0000000000f1090b, 0xc6c50258981fb804)
    },
    { /* i=2362; 70 / 70 */
        RTUINT128_INIT_C(0x0000000000000024, 0x9414c092881c574d), RTUINT128_INIT_C(0x000000000000000b, 0x5d3b143871eb5dd1),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003), RTUINT128_INIT_C(0x0000000000000002, 0x7c6383e9325a3dda)
    },
    { /* i=2363; 123 / 76 */
        RTUINT128_INIT_C(0x0201464ddd6fafc0, 0xbe5d58664d5367e4), RTUINT128_INIT_C(0x0000000000000927, 0xc53f0f10c6be7538),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000381012c23d4b), RTUINT128_INIT_C(0x00000000000001bb, 0x40115b0ded28b87c)
    },
    { /* i=2364; 103 / 65 */
        RTUINT128_INIT_C(0x000000759f33fb44, 0x0a5a146786bafffe), RTUINT128_INIT_C(0x0000000000000001, 0xd30fd1ef2cca0e95),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000040782be4c8), RTUINT128_INIT_C(0x0000000000000001, 0x7c562ba248dbe796)
    },
    { /* i=2365; 114 / 5 */
        RTUINT128_INIT_C(0x0001f6137678343e, 0x1a6bd9fe1c5aad3d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000012),
        RTUINT128_INIT_C(0x00001be4a306ad91, 0xac226faa8fcc2611), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000b)
    },
    { /* i=2366; 118 / 44 */
        RTUINT128_INIT_C(0x0034d6d58020d44d, 0x7fa4086144aab2c6), RTUINT128_INIT_C(0x0000000000000000, 0x0000006d2c4dfbf8),
        RTUINT128_INIT_C(0x0000000000007be7, 0x153ac4ae23c166c9), RTUINT128_INIT_C(0x0000000000000000, 0x000000348b130d0e)
    },
    { /* i=2367; 94 / 43 */
        RTUINT128_INIT_C(0x000000001f068486, 0xbcbe7da90a6482a8), RTUINT128_INIT_C(0x0000000000000000, 0x0000007eea667d67),
        RTUINT128_INIT_C(0x0000000000000000, 0x003e94c207068051), RTUINT128_INIT_C(0x0000000000000000, 0x0000006adfd95511)
    },
    { /* i=2368; 64 / 62 */
        RTUINT128_INIT_C(0x0000000000000000, 0x02b8cae53d304d2d), RTUINT128_INIT_C(0x0000000000000000, 0x24345cd273089199),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x02b8cae53d304d2d)
    },
    { /* i=2369; 106 / 106 */
        RTUINT128_INIT_C(0x000000c3b6277ad5, 0x1bd2da7daad2f94e), RTUINT128_INIT_C(0x0000034fcc66185f, 0x462f81de42b22c48),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000000c3b6277ad5, 0x1bd2da7daad2f94e)
    },
    { /* i=2370; 92 / 26 */
        RTUINT128_INIT_C(0x0000000003f96a11, 0x904db9c8b5e51743), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000b5f594),
        RTUINT128_INIT_C(0x0000000000000005, 0x9768919db0453253), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000b9047)
    },
    { /* i=2371; 75 / 79 */
        RTUINT128_INIT_C(0x000000000000020c, 0x288a01f9f3311f2e), RTUINT128_INIT_C(0x0000000000004696, 0x419aed692c837ebf),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000000000000020c, 0x288a01f9f3311f2e)
    },
    { /* i=2372; 90 / 5 */
        RTUINT128_INIT_C(0x00000000034d3994, 0x0202d31e622402e3), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000001c),
        RTUINT128_INIT_C(0x00000000001e2fc5, 0x4936f54115ca6dd1), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000007)
    },
    { /* i=2373; 60 / 35 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0225f3738aff087d), RTUINT128_INIT_C(0x0000000000000000, 0x000000005ee0f8e8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000005cbddc6), RTUINT128_INIT_C(0x0000000000000000, 0x000000000a263d0d)
    },
    { /* i=2374; 13 / 9 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001c80), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000167),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000014), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000074)
    },
    { /* i=2375; 113 / 82 */
        RTUINT128_INIT_C(0x000047097b0637af, 0xae1216f9d2e95018), RTUINT128_INIT_C(0x0000000000015952, 0x6f38d5c1cb78b072),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000034a9920d), RTUINT128_INIT_C(0x000000000000b321, 0x2402df9405e5564e)
    },
    { /* i=2376; 121 / 119 */
        RTUINT128_INIT_C(0x00de13eb532e804f, 0x3a1a5c5871ec4735), RTUINT128_INIT_C(0x002abba0725b34bf, 0x051dc45ea6bfb0fc),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000005), RTUINT128_INIT_C(0x000869c917667894, 0x2085867f302dd249)
    },
    { /* i=2377; 113 / 108 */
        RTUINT128_INIT_C(0x000020c385d637ff, 0x2f6ddc1b6a2b5b09), RTUINT128_INIT_C(0x00000c77cd30b5ec, 0x57ed57063546c331),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002), RTUINT128_INIT_C(0x000007d3eb74cc26, 0x7f932e0eff9dd4a7)
    },
    { /* i=2378; 124 / 91 */
        RTUINT128_INIT_C(0x068183320936d4e4, 0xcca81e69df186099), RTUINT128_INIT_C(0x0000000005e4021c, 0x91f1693658aa819c),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000011abcebcc), RTUINT128_INIT_C(0x0000000003d5d0f8, 0xc31e73b9abaee449)
    },
    { /* i=2379; 127 / 79 */
        RTUINT128_INIT_C(0x55c32fe95b51135f, 0x4e7f31f83b029eb8), RTUINT128_INIT_C(0x000000000000427f, 0x53c89ccf0683a0d1),
        RTUINT128_INIT_C(0x0000000000000000, 0x00014a2a8e845cef), RTUINT128_INIT_C(0x000000000000299b, 0x8e983afcfe905f99)
    },
    { /* i=2380; 126 / 95 */
        RTUINT128_INIT_C(0x328aeda0afa3c4d5, 0x66a4136e129b535a), RTUINT128_INIT_C(0x0000000025b31051, 0xfd12073a5f0c7304),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000001573665c9), RTUINT128_INIT_C(0x00000000253d1220, 0xdaf8a45ee99c7136)
    },
    { /* i=2381; 116 / 60 */
        RTUINT128_INIT_C(0x0005b186ff9dc713, 0x4502277a842438a1), RTUINT128_INIT_C(0x0000000000000000, 0x00013b18fdb533b1),
        RTUINT128_INIT_C(0x0000000000000004, 0xa029c5996f268ee2), RTUINT128_INIT_C(0x0000000000000000, 0x0000ca979c3a685f)
    },
    { /* i=2382; 66 / 41 */
        RTUINT128_INIT_C(0x0000000000000000, 0x77d7bacb406c1063), RTUINT128_INIT_C(0x0000000000000000, 0x000000dbfacad42d),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000008b7759), RTUINT128_INIT_C(0x0000000000000000, 0x0000009b92d861be)
    },
    { /* i=2383; 126 / 121 */
        RTUINT128_INIT_C(0x05c51165c2417ca7, 0x39ca7cf346d28414), RTUINT128_INIT_C(0x00f3b04fd96ee0e4, 0xcefcead2d7b056f1),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000006), RTUINT128_INIT_C(0x000eef86a9a8374a, 0x5fdcfc0238b07a6e)
    },
    { /* i=2384; 126 / 57 */
        RTUINT128_INIT_C(0x2893a564b26055c5, 0x1d64b9e1cd7bab1a), RTUINT128_INIT_C(0x0000000000000000, 0x017df00e3973c1d4),
        RTUINT128_INIT_C(0x000000000000001b, 0x327d583ca59ba718), RTUINT128_INIT_C(0x0000000000000000, 0x00123e5de7d4333a)
    },
    { /* i=2385; 30 / 59 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000374f6992), RTUINT128_INIT_C(0x0000000000000000, 0x06eb328b8fbf8eca),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00000000374f6992)
    },
    { /* i=2386; 121 / 63 */
        RTUINT128_INIT_C(0x015d4dbb57f482d5, 0x089eeac6c845ec0d), RTUINT128_INIT_C(0x0000000000000000, 0x7487f3f8b013c2f9),
        RTUINT128_INIT_C(0x0000000000000000, 0x02ff5d2787270548), RTUINT128_INIT_C(0x0000000000000000, 0x220309a1dcf93905)
    },
    { /* i=2387; 126 / 107 */
        RTUINT128_INIT_C(0x2958f59f1cf54799, 0x778e4cc2adc8cac1), RTUINT128_INIT_C(0x0000040179924ec9, 0x8fba8c7f018a89a1),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000a526f), RTUINT128_INIT_C(0x000000537568f0e0, 0xe7b4a3c942578bf2)
    },
    { /* i=2388; 126 / 124 */
        RTUINT128_INIT_C(0x20df22817bc1b56e, 0x0d981197219708f2), RTUINT128_INIT_C(0x02e2460a0a21ec29, 0x250f93afda41391e),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000b), RTUINT128_INIT_C(0x012620130c4c8fa9, 0x75ecb908c0c994a8)
    },
    { /* i=2389; 117 / 48 */
        RTUINT128_INIT_C(0x000f4eb9d648ff4a, 0x68ca8a8644d0d2e4), RTUINT128_INIT_C(0x0000000000000000, 0x000041005bc509c3),
        RTUINT128_INIT_C(0x000000000000003c, 0x496b3a3b68a8828c), RTUINT128_INIT_C(0x0000000000000000, 0x00001c8366227640)
    },
    { /* i=2390; 87 / 66 */
        RTUINT128_INIT_C(0x0000000000199b4c, 0xf7426d6f522cbf30), RTUINT128_INIT_C(0x0000000000000002, 0xaa738dba2c8ca2a7),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000099b03), RTUINT128_INIT_C(0x0000000000000001, 0x058c7a55ee2cba3b)
    },
    { /* i=2391; 114 / 71 */
        RTUINT128_INIT_C(0x0002e9320ecc08e5, 0x6efd53b6fc415307), RTUINT128_INIT_C(0x0000000000000034, 0xb29ae2a78fa784a5),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000e2415b87433), RTUINT128_INIT_C(0x0000000000000021, 0xa76693c0962f2228)
    },
    { /* i=2392; 123 / 124 */
        RTUINT128_INIT_C(0x005ed9e562fd03a3, 0x42123f5ec2d9be86), RTUINT128_INIT_C(0x05d5eebe7214e327, 0x2d9cc6c1c82adc33),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x005ed9e562fd03a3, 0x42123f5ec2d9be86)
    },
    { /* i=2393; 117 / 126 */
        RTUINT128_INIT_C(0x000c336ad3c524ac, 0x51161149ed6c922e), RTUINT128_INIT_C(0x256cb2c707f3d12b, 0xf041535fb0697090),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000c336ad3c524ac, 0x51161149ed6c922e)
    },
    { /* i=2394; 118 / 35 */
        RTUINT128_INIT_C(0x00377595a05688f1, 0x02719552ec9895f2), RTUINT128_INIT_C(0x0000000000000000, 0x00000001897529d4),
        RTUINT128_INIT_C(0x000000000024158a, 0xac60dd9f3d33d648), RTUINT128_INIT_C(0x0000000000000000, 0x0000000179719a52)
    },
    { /* i=2395; 110 / 34 */
        RTUINT128_INIT_C(0x0000111a8ce0c34a, 0x539d992ea66099fd), RTUINT128_INIT_C(0x0000000000000000, 0x00000000fb433e93),
        RTUINT128_INIT_C(0x000000000000116d, 0x1a954a96521650b8), RTUINT128_INIT_C(0x0000000000000000, 0x0000000093dbb055)
    },
    { /* i=2396; 122 / 71 */
        RTUINT128_INIT_C(0x03ff1f18b40483ee, 0xc621b44297f4daf9), RTUINT128_INIT_C(0x0000000000000000, 0x32be9f766c53da65),
        RTUINT128_INIT_C(0x0000000000000000, 0x142983b777ad9e74), RTUINT128_INIT_C(0x0000000000000000, 0x1b145f5b37ea8f35)
    },
    { /* i=2397; 115 / 107 */
        RTUINT128_INIT_C(0x00055fbc896a92d4, 0x2714be4a661330ab), RTUINT128_INIT_C(0x000006d46131f688, 0xb8e96e26b6412760),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000c9), RTUINT128_INIT_C(0x000002fc3930017a, 0xf7cd41e54ceb464b)
    },
    { /* i=2398; 126 / 117 */
        RTUINT128_INIT_C(0x0d08cf3101d9ec5e, 0xd0bd94872dc14ab4), RTUINT128_INIT_C(0x001a531f7ada1fe0, 0x20f9797b0547e107),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000007e), RTUINT128_INIT_C(0x0013e5b28a7e3c0e, 0x95f3c9fa94608942)
    },
    { /* i=2399; 108 / 41 */
        RTUINT128_INIT_C(0x0000036e9babd71a, 0xa52f31f454a25cea), RTUINT128_INIT_C(0x0000000000000000, 0x0000017da38ec61a),
        RTUINT128_INIT_C(0x0000000000000002, 0x4d5ccfa83438d795), RTUINT128_INIT_C(0x0000000000000000, 0x000000ee9c7939c8)
    },
    { /* i=2400; 52 / 80 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000c06462a82c0d7), RTUINT128_INIT_C(0x00000000000040c5, 0x5d6d83097fd5e7d4),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000c06462a82c0d7)
    },
    { /* i=2401; 81 / 24 */
        RTUINT128_INIT_C(0x0000000000003101, 0xdf0c8d59d0f9c2e8), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000e5d68e),
        RTUINT128_INIT_C(0x0000000000000000, 0x003695efb7551acf), RTUINT128_INIT_C(0x0000000000000000, 0x000000000030da16)
    },
    { /* i=2402; 35 / 33 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000009ed9f06e), RTUINT128_INIT_C(0x0000000000000000, 0x00000000441fbfd3),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002), RTUINT128_INIT_C(0x0000000000000000, 0x00000000169a70c8)
    },
    { /* i=2403; 88 / 8 */
        RTUINT128_INIT_C(0x0000000000cf071f, 0x8e1d904fff8c013d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000093),
        RTUINT128_INIT_C(0x0000000000016889, 0xcafafa0406f680e1), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000a)
    },
    { /* i=2404; 126 / 109 */
        RTUINT128_INIT_C(0x2f6d80baa76b5098, 0x60832c694d603b06), RTUINT128_INIT_C(0x000013b80325855e, 0x1466928cee14a9ff),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000267bb), RTUINT128_INIT_C(0x000009c1379de1dd, 0x0f858f83bfe474c1)
    },
    { /* i=2405; 26 / 9 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000002d9253c), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000d4),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000003707a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000034)
    },
    { /* i=2406; 79 / 3 */
        RTUINT128_INIT_C(0x0000000000005668, 0x59ac177ee690d52e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002),
        RTUINT128_INIT_C(0x0000000000002b34, 0x2cd60bbf73486a97), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=2407; 123 / 107 */
        RTUINT128_INIT_C(0x0083783dc9199e37, 0xc12f179574369ca8), RTUINT128_INIT_C(0x000004b588c49b91, 0x216c3490d3571e7e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001beb), RTUINT128_INIT_C(0x0000002c80368177, 0xa94f9059430654fe)
    },
    { /* i=2408; 128 / 121 */
        RTUINT128_INIT_C(0xa0c79ae197fbd195, 0x34cac4ab2561047e), RTUINT128_INIT_C(0x0151ff4628ebb694, 0x666bfd74ec5dc962),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000079), RTUINT128_INIT_C(0x0105f2b840928570, 0xcbbff8676d0cd52c)
    },
    { /* i=2409; 116 / 25 */
        RTUINT128_INIT_C(0x0007f753a9e1ac5e, 0x1188fb0491361efd), RTUINT128_INIT_C(0x0000000000000000, 0x0000000001889fb0),
        RTUINT128_INIT_C(0x000000000531b07a, 0x31ed4a08c307bf22), RTUINT128_INIT_C(0x0000000000000000, 0x00000000001c999d)
    },
    { /* i=2410; 120 / 49 */
        RTUINT128_INIT_C(0x00f5a2b8398be3fb, 0x183e27b0c154a015), RTUINT128_INIT_C(0x0000000000000000, 0x00007debbec52cd7),
        RTUINT128_INIT_C(0x00000000000001f3, 0x61fe38f7e1d6fc5d), RTUINT128_INIT_C(0x0000000000000000, 0x00004894e8d5b1fa)
    },
    { /* i=2411; 113 / 107 */
        RTUINT128_INIT_C(0x00010a06b68f6be8, 0x54869d39b0f6cddf), RTUINT128_INIT_C(0x000003c98939e250, 0xec18fc46c8a517b0),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000046), RTUINT128_INIT_C(0x000000eb30bb89c7, 0xc5b1a1ded3d253bf)
    },
    { /* i=2412; 128 / 87 */
        RTUINT128_INIT_C(0x983b9d994f7a1057, 0x034ccfb9fedb3b2d), RTUINT128_INIT_C(0x00000000006a64cc, 0xf4f5a1055610d258),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000016e4bcca08c), RTUINT128_INIT_C(0x000000000007779d, 0x9bd12e2d0411330d)
    },
    { /* i=2413; 121 / 18 */
        RTUINT128_INIT_C(0x01cb3a236c4f62f7, 0x716b812681da0c24), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000028464),
        RTUINT128_INIT_C(0x000000b670724902, 0xbacaec2f66cfa412), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000ad1c)
    },
    { /* i=2414; 125 / 33 */
        RTUINT128_INIT_C(0x0d8351ecd7190d4f, 0x0fc27d12b889f400), RTUINT128_INIT_C(0x0000000000000000, 0x00000001a8662515),
        RTUINT128_INIT_C(0x000000000826aeb0, 0xe45841969b309bb9), RTUINT128_INIT_C(0x0000000000000000, 0x00000001835570d3)
    },
    { /* i=2415; 122 / 48 */
        RTUINT128_INIT_C(0x03091a3f93c8e78b, 0xc4b7c648c3165b65), RTUINT128_INIT_C(0x0000000000000000, 0x00004a708312f71d),
        RTUINT128_INIT_C(0x0000000000000a70, 0x7b79dafdbe5c4f82), RTUINT128_INIT_C(0x0000000000000000, 0x000028d204c6ebab)
    },
    { /* i=2416; 103 / 63 */
        RTUINT128_INIT_C(0x00000071fc45bb18, 0x7b709ea321e51e42), RTUINT128_INIT_C(0x0000000000000000, 0x2f7fe256d384e143),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000026653cf0050), RTUINT128_INIT_C(0x0000000000000000, 0x27fc7f542a31b952)
    },
    { /* i=2417; 38 / 43 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000026d9ec15ed), RTUINT128_INIT_C(0x0000000000000000, 0x00000295c6c1604f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00000026d9ec15ed)
    },
    { /* i=2418; 121 / 103 */
        RTUINT128_INIT_C(0x0145503a024759bc, 0xf024860027a05544), RTUINT128_INIT_C(0x00000020e3f81525, 0x4ae051d65510becd),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000009e40b), RTUINT128_INIT_C(0x0000000e85799890, 0x0f152070e0c48e75)
    },
    { /* i=2419; 116 / 84 */
        RTUINT128_INIT_C(0x000abec2d394c190, 0xd3f99052d0ca4fb7), RTUINT128_INIT_C(0x00000000000ddff8, 0x7b14c2c042e34a89),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000c6413331), RTUINT128_INIT_C(0x0000000000051395, 0xfba734d6d8a6c07e)
    },
    { /* i=2420; 82 / 9 */
        RTUINT128_INIT_C(0x00000000000000e4, 0xf2079d305edd3000), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000009a),
        RTUINT128_INIT_C(0x0000000000000001, 0x7c95a8eab42601f9), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000036)
    },
    { /* i=2421; 122 / 108 */
        RTUINT128_INIT_C(0x03ea17683c6efb30, 0xeacf4f399015ae81), RTUINT128_INIT_C(0x00000fcb10a81785, 0xa73e699e80324f70),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000003f73), RTUINT128_INIT_C(0x00000616632285fe, 0x6dc7db7997ef6f31)
    },
    { /* i=2422; 118 / 62 */
        RTUINT128_INIT_C(0x001643c252f4d32a, 0x5e4ff06f37be6390), RTUINT128_INIT_C(0x0000000000000000, 0x180838611195cd05),
        RTUINT128_INIT_C(0x0000000000000000, 0x00ed2c323dbe94c6), RTUINT128_INIT_C(0x0000000000000000, 0x1200912ea8a4edb2)
    },
    { /* i=2423; 118 / 59 */
        RTUINT128_INIT_C(0x0025b96d1071fee5, 0xfe45a18e6ebb1638), RTUINT128_INIT_C(0x0000000000000000, 0x01795b48504cb2d8),
        RTUINT128_INIT_C(0x0000000000000000, 0x1997a1918bb951b8), RTUINT128_INIT_C(0x0000000000000000, 0x00fb534becec32f8)
    },
    { /* i=2424; 106 / 44 */
        RTUINT128_INIT_C(0x000002ee2584ac28, 0xf62086e4e8d2c0ba), RTUINT128_INIT_C(0x0000000000000000, 0x00000677a23dc429),
        RTUINT128_INIT_C(0x0000000000000000, 0x73fd86c489ca5fae), RTUINT128_INIT_C(0x0000000000000000, 0x00000444fdb235dc)
    },
    { /* i=2425; 120 / 101 */
        RTUINT128_INIT_C(0x00b98aaab2893e3b, 0x30be7d0038b61479), RTUINT128_INIT_C(0x0000000efda225e7, 0x0419d6caf2028adf),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000c6087), RTUINT128_INIT_C(0x0000000c5cfc6ea8, 0x450ec51b22d738e0)
    },
    { /* i=2426; 117 / 33 */
        RTUINT128_INIT_C(0x00133b01f1786520, 0xbeb1a9c7150fd7c6), RTUINT128_INIT_C(0x0000000000000000, 0x00000001202a0a4c),
        RTUINT128_INIT_C(0x0000000000111583, 0x500355c0b4365253), RTUINT128_INIT_C(0x0000000000000000, 0x00000000941a2922)
    },
    { /* i=2427; 97 / 19 */
        RTUINT128_INIT_C(0x000000010e3874c5, 0x3a1bbd2531cf9e96), RTUINT128_INIT_C(0x0000000000000000, 0x000000000007c740),
        RTUINT128_INIT_C(0x00000000000022bd, 0x7ed4599f3921eef0), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000075296)
    },
    { /* i=2428; 96 / 87 */
        RTUINT128_INIT_C(0x000000002a2f5723, 0x88bc9d61ca64c9ed), RTUINT128_INIT_C(0x00000000003f1201, 0xfc8244015f32a10b),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000ab), RTUINT128_INIT_C(0x00000000000e4fcf, 0xddb9307733933794)
    },
    { /* i=2429; 37 / 8 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000001bf3aa2817), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000bb),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000002643fd79), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000b4)
    },
    { /* i=2430; 118 / 116 */
        RTUINT128_INIT_C(0x000e60db911b2a5a, 0xab1cb7250d6e7ea4), RTUINT128_INIT_C(0x000f821fdb4cb7a8, 0x92457ae1ab0016ba),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000e60db911b2a5a, 0xab1cb7250d6e7ea4)
    },
    { /* i=2431; 75 / 56 */
        RTUINT128_INIT_C(0x0000000000000003, 0xf6995a96acc8d3ab), RTUINT128_INIT_C(0x0000000000000000, 0x0065409c2b85b667),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000a05), RTUINT128_INIT_C(0x0000000000000000, 0x0018fdd69a0c3da8)
    },
    { /* i=2432; 69 / 33 */
        RTUINT128_INIT_C(0x0000000000000017, 0xb20517fc1da8382f), RTUINT128_INIT_C(0x0000000000000000, 0x0000000070998da2),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000035df5425ef), RTUINT128_INIT_C(0x0000000000000000, 0x0000000035ac93f1)
    },
    { /* i=2433; 98 / 80 */
        RTUINT128_INIT_C(0x000000014001c1df, 0x77806960465fe3e8), RTUINT128_INIT_C(0x0000000000004d45, 0xbb7790fae2db4cc0),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000004242b), RTUINT128_INIT_C(0x0000000000000aed, 0xe61c3be821beffa8)
    },
    { /* i=2434; 125 / 122 */
        RTUINT128_INIT_C(0x1496c92937c00b3a, 0xc953f6f3046aa503), RTUINT128_INIT_C(0x02ec1d3fbdc24ebe, 0xeebfc588dadfb599),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000007), RTUINT128_INIT_C(0x0021fc6b076fe402, 0x42159035084cadd4)
    },
    { /* i=2435; 117 / 117 */
        RTUINT128_INIT_C(0x00051051cc4a72e1, 0xb8375b745e9447af), RTUINT128_INIT_C(0x00078b3ee1aa37eb, 0x980e78a2eabdbaf4),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00051051cc4a72e1, 0xb8375b745e9447af)
    },
    { /* i=2436; 54 / 43 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000e326808542659), RTUINT128_INIT_C(0x0000000000000000, 0x000000ead1984495),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000f7a), RTUINT128_INIT_C(0x0000000000000000, 0x0000003839bebc57)
    },
    { /* i=2437; 89 / 25 */
        RTUINT128_INIT_C(0x0000000000b1b6c7, 0xbdc1ee1198596063), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000d5b08d),
        RTUINT128_INIT_C(0x0000000000000000, 0xd4e6b4204658da74), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000b54e7f)
    },
    { /* i=2438; 105 / 42 */
        RTUINT128_INIT_C(0x000001e4626beb10, 0xd50ac9800a047259), RTUINT128_INIT_C(0x0000000000000000, 0x0000013230999919),
        RTUINT128_INIT_C(0x0000000000000001, 0x94fc444ab472b4cd), RTUINT128_INIT_C(0x0000000000000000, 0x000000dd5e3d4554)
    },
    { /* i=2439; 84 / 120 */
        RTUINT128_INIT_C(0x00000000000dd3c0, 0xd68e02a41c0166d9), RTUINT128_INIT_C(0x00b68e7e0640ccdc, 0x59a657944c3087ea),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00000000000dd3c0, 0xd68e02a41c0166d9)
    },
    { /* i=2440; 105 / 91 */
        RTUINT128_INIT_C(0x000001ca0dea912d, 0x21badc54f254a930), RTUINT128_INIT_C(0x0000000001059a81, 0x24f144d44a7831f0),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000001c03e), RTUINT128_INIT_C(0x00000000002d253f, 0xf6d8ae9891d49110)
    },
    { /* i=2441; 125 / 50 */
        RTUINT128_INIT_C(0x04fbeebf051b24ce, 0xdf9b03159b093b63), RTUINT128_INIT_C(0x0000000000000000, 0x0003cf097f40aafb),
        RTUINT128_INIT_C(0x000000000000014f, 0x00589c8a11b61265), RTUINT128_INIT_C(0x0000000000000000, 0x0002c6c1a10e205c)
    },
    { /* i=2442; 65 / 15 */
        RTUINT128_INIT_C(0x0000000000000000, 0x5e87b2901b5b7abd), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000486d),
        RTUINT128_INIT_C(0x0000000000000000, 0x00014e218820855e), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000041b7)
    },
    { /* i=2443; 127 / 39 */
        RTUINT128_INIT_C(0x4c780eaad99e5fc4, 0xea7a7d302a4b2e70), RTUINT128_INIT_C(0x0000000000000000, 0x0000001a37991dbd),
        RTUINT128_INIT_C(0x0000000002eab029, 0x88e411b60337586f), RTUINT128_INIT_C(0x0000000000000000, 0x00000018d213517d)
    },
    { /* i=2444; 123 / 82 */
        RTUINT128_INIT_C(0x07aaefbb8adfbb35, 0xfb310f0340d47d51), RTUINT128_INIT_C(0x000000000003652d, 0xdf91721f93aa81ba),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000024225286424), RTUINT128_INIT_C(0x000000000000f5e9, 0xede90f8bbb1d9729)
    },
    { /* i=2445; 127 / 84 */
        RTUINT128_INIT_C(0x0af9266519ff8655, 0xd51cc6dc59769e29), RTUINT128_INIT_C(0x000000000008dc60, 0x704572bbc323e22e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000013d078f09d3), RTUINT128_INIT_C(0x000000000002cf77, 0xfe2f8d0da63d943f)
    },
    { /* i=2446; 11 / 7 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000007f2), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000047),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000001c), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000002e)
    },
    { /* i=2447; 85 / 35 */
        RTUINT128_INIT_C(0x000000000005e33d, 0x8e696bc3a3cedaf9), RTUINT128_INIT_C(0x0000000000000000, 0x000000043930c9f4),
        RTUINT128_INIT_C(0x0000000000000000, 0x000164e0de4debb3), RTUINT128_INIT_C(0x0000000000000000, 0x0000000186eaa95d)
    },
    { /* i=2448; 125 / 38 */
        RTUINT128_INIT_C(0x12b47348cb3db452, 0xcf60ededb313df85), RTUINT128_INIT_C(0x0000000000000000, 0x00000025329bbbb7),
        RTUINT128_INIT_C(0x000000000080bad2, 0xebdd3eb4412d53da), RTUINT128_INIT_C(0x0000000000000000, 0x00000022a66eb0af)
    },
    { /* i=2449; 17 / 107 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000019ce1), RTUINT128_INIT_C(0x000001240edd9995, 0x192c8f79e838eaa1),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000019ce1)
    },
    { /* i=2450; 90 / 61 */
        RTUINT128_INIT_C(0x0000000002c747ff, 0xa04346cebec02bfa), RTUINT128_INIT_C(0x0000000000000000, 0x0cc2693d56d35ff2),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000037bedeaf), RTUINT128_INIT_C(0x0000000000000000, 0x06ec4a16e371b98c)
    },
    { /* i=2451; 119 / 107 */
        RTUINT128_INIT_C(0x0079b2975c1f781e, 0xed2d50411821b815), RTUINT128_INIT_C(0x000001d01b9e0f01, 0x524288f4cb927d5b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000004320), RTUINT128_INIT_C(0x000001598a703f6d, 0x3b0420604f033bb5)
    },
    { /* i=2452; 117 / 119 */
        RTUINT128_INIT_C(0x00073b41b8c84e49, 0x398260c611032679), RTUINT128_INIT_C(0x00792f596a825019, 0x24f3784b115f7064),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00073b41b8c84e49, 0x398260c611032679)
    },
    { /* i=2453; 128 / 100 */
        RTUINT128_INIT_C(0x4aff9db6380041b1, 0xf72e4ce3d44c84ab), RTUINT128_INIT_C(0x0000000eee23e048, 0x4240518ca4e578ca),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000505f494), RTUINT128_INIT_C(0x000000058ec92bed, 0x054d66927a9027e3)
    },
    { /* i=2454; 7 / 6 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000004d), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000002a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000023)
    },
    { /* i=2455; 123 / 114 */
        RTUINT128_INIT_C(0x05e9aa6639ebe7b1, 0xd5d0905873dde219), RTUINT128_INIT_C(0x0003add2c8b7436f, 0xe7d59868fe9b4df6),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000019b), RTUINT128_INIT_C(0x000198fdfbb2a308, 0xa1e4dfc7b087b827)
    },
    { /* i=2456; 125 / 42 */
        RTUINT128_INIT_C(0x17c075b8214ef807, 0x4a65b0cd568e1d04), RTUINT128_INIT_C(0x0000000000000000, 0x000003e6e7ca723a),
        RTUINT128_INIT_C(0x000000000006164d, 0xaac4e79b742c292a), RTUINT128_INIT_C(0x0000000000000000, 0x0000001ff9141580)
    },
    { /* i=2457; 114 / 125 */
        RTUINT128_INIT_C(0x0002bacbbe8dc2e2, 0x2b49f21958c4dedf), RTUINT128_INIT_C(0x088c33d02abb0caa, 0x56678da812ca9eef),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0002bacbbe8dc2e2, 0x2b49f21958c4dedf)
    },
    { /* i=2458; 123 / 72 */
        RTUINT128_INIT_C(0x0278435b8accfa1e, 0xb7a37ef9dc8822d9), RTUINT128_INIT_C(0x0000000000000006, 0x8dca68374101c50b),
        RTUINT128_INIT_C(0x0000000000000000, 0x006078c2ef877495), RTUINT128_INIT_C(0x0000000000000003, 0xf2f364220b6a7772)
    },
    { /* i=2459; 91 / 30 */
        RTUINT128_INIT_C(0x0000000004538657, 0x703ff42e17ca7d0d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000010be8519),
        RTUINT128_INIT_C(0x0000000000000000, 0x4224ca5ae13cf0ea), RTUINT128_INIT_C(0x0000000000000000, 0x0000000002016433)
    },
    { /* i=2460; 113 / 109 */
        RTUINT128_INIT_C(0x000037cd4dc6aa26, 0xa950a6fe6765a301), RTUINT128_INIT_C(0x000000d85cc24891, 0x7636b0b26bcf3818),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000042), RTUINT128_INIT_C(0x0000000563aff4a6, 0x2f3718fe9bf92cd1)
    },
    { /* i=2461; 124 / 110 */
        RTUINT128_INIT_C(0x04738481d83ba36d, 0xf11116414a534aca), RTUINT128_INIT_C(0x000033273b6ad073, 0x764b3ccd83f1274f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001646), RTUINT128_INIT_C(0x000028ac6b1cb7b1, 0x2144ccb87d01c130)
    },
    { /* i=2462; 120 / 101 */
        RTUINT128_INIT_C(0x008e5ad019e793b7, 0x9c9144301822f9a7), RTUINT128_INIT_C(0x0000001a7b0a6002, 0x79e2a8d6efcba274),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000056034), RTUINT128_INIT_C(0x0000001757bec414, 0x8f03afa0d9967a17)
    },
    { /* i=2463; 117 / 24 */
        RTUINT128_INIT_C(0x001c5f0dfc78ddc5, 0x1a935bbaea4cf625), RTUINT128_INIT_C(0x0000000000000000, 0x00000000009c6fd4),
        RTUINT128_INIT_C(0x000000002e6d93bc, 0x2dd56ef0c6b4ceb6), RTUINT128_INIT_C(0x0000000000000000, 0x000000000008dd6d)
    },
    { /* i=2464; 95 / 29 */
        RTUINT128_INIT_C(0x00000000525b62ce, 0x574a5c798b13836e), RTUINT128_INIT_C(0x0000000000000000, 0x000000001db1fa7c),
        RTUINT128_INIT_C(0x0000000000000002, 0xc5fe0ce090b74c4c), RTUINT128_INIT_C(0x0000000000000000, 0x00000000153c569e)
    },
    { /* i=2465; 112 / 84 */
        RTUINT128_INIT_C(0x000065eb2b895e0c, 0x6a981edbc65419bb), RTUINT128_INIT_C(0x00000000000f9b75, 0xdb64761e625d7c77),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000687bb6d), RTUINT128_INIT_C(0x00000000000a08dc, 0x9e3591da2dda2e10)
    },
    { /* i=2466; 19 / 57 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000507ac), RTUINT128_INIT_C(0x0000000000000000, 0x009a9d9c49997080),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000507ac)
    },
    { /* i=2467; 38 / 3 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000002435da8714), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000006),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000608f9c12e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=2468; 118 / 36 */
        RTUINT128_INIT_C(0x002aa5f9721691de, 0x1e1e131abdf000f2), RTUINT128_INIT_C(0x0000000000000000, 0x0000000e4a6ebeaf),
        RTUINT128_INIT_C(0x000000000002fbfd, 0x207d959b9a45136c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000973e5921e)
    },
    { /* i=2469; 39 / 22 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000428c3bd1f8), RTUINT128_INIT_C(0x0000000000000000, 0x00000000003dcc44),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000113ad), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000bbc04)
    },
    { /* i=2470; 113 / 98 */
        RTUINT128_INIT_C(0x0000603b19de95ab, 0xb68ec3be1ae3ddb9), RTUINT128_INIT_C(0x000000034fcb2588, 0x3b57e1be0209612e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001d0e), RTUINT128_INIT_C(0x00000002b982197f, 0x832de51eee5e5735)
    },
    { /* i=2471; 128 / 96 */
        RTUINT128_INIT_C(0x37159326684dcc15, 0x7e423955c3187738), RTUINT128_INIT_C(0x000000007186cf46, 0x3404f860d0d18edf),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000007c36be20), RTUINT128_INIT_C(0x000000006f9c6758, 0x03b9c4d7f9d31958)
    },
    { /* i=2472; 95 / 89 */
        RTUINT128_INIT_C(0x0000000033cff244, 0x3bdf285e2983c541), RTUINT128_INIT_C(0x00000000008a8e3f, 0x4ff4d953e5d77991),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000005f), RTUINT128_INIT_C(0x00000000006528c5, 0x9002823bde8da872)
    },
    { /* i=2473; 113 / 121 */
        RTUINT128_INIT_C(0x000055f8b1e6da0b, 0x6d003b7ba6f797f9), RTUINT128_INIT_C(0x018a54a262d7a0bd, 0xcba68c8d3a39b389),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000055f8b1e6da0b, 0x6d003b7ba6f797f9)
    },
    { /* i=2474; 116 / 119 */
        RTUINT128_INIT_C(0x00080dac53ea51ef, 0xbcfeb84da070901f), RTUINT128_INIT_C(0x007960adab258db6, 0x4c81dca29035af3f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00080dac53ea51ef, 0xbcfeb84da070901f)
    },
    { /* i=2475; 113 / 61 */
        RTUINT128_INIT_C(0x0000beb039a57a77, 0x5fdc14fcfef86874), RTUINT128_INIT_C(0x0000000000000000, 0x1dc3c34f8b118f51),
        RTUINT128_INIT_C(0x0000000000000000, 0x000668123963a176), RTUINT128_INIT_C(0x0000000000000000, 0x06b65b77646b681e)
    },
    { /* i=2476; 116 / 115 */
        RTUINT128_INIT_C(0x000210a59f935ced, 0x4f7f1e733594a8e2), RTUINT128_INIT_C(0x0004789772a51ab0, 0xe78c5adfd534d384),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000210a59f935ced, 0x4f7f1e733594a8e2)
    },
    { /* i=2477; 64 / 10 */
        RTUINT128_INIT_C(0x0000000000000000, 0xc6e572c6ee23d11f), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000276),
        RTUINT128_INIT_C(0x0000000000000000, 0x0050d243c50d0f5d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000241)
    },
    { /* i=2478; 117 / 114 */
        RTUINT128_INIT_C(0x001e3ff68d91c4b7, 0xc6344c6f5a5dc86b), RTUINT128_INIT_C(0x0001c4d79b156e8c, 0x370d6d03297a9cf2),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000011), RTUINT128_INIT_C(0x00002da541256d68, 0x1e500f3999395c59)
    },
    { /* i=2479; 123 / 93 */
        RTUINT128_INIT_C(0x0249321074928d11, 0x6d4954ef0fc83fe2), RTUINT128_INIT_C(0x000000001050d8a5, 0xaeadbc41262ecc6e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000023dde5e2), RTUINT128_INIT_C(0x000000000d7d88d3, 0x620c7fe9f8a360c6)
    },
    { /* i=2480; 107 / 102 */
        RTUINT128_INIT_C(0x0000039a8c5baf9a, 0xa5c2c906f71d500a), RTUINT128_INIT_C(0x000000319acb474c, 0x94785b50b8a0611f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000012), RTUINT128_INIT_C(0x0000001daa10ac38, 0x354c5d59fbd67bdc)
    },
    { /* i=2481; 78 / 53 */
        RTUINT128_INIT_C(0x0000000000000348, 0x6dadbb7857a79404), RTUINT128_INIT_C(0x0000000000000000, 0x000f587101499ac6),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000036c466), RTUINT128_INIT_C(0x0000000000000000, 0x0003b3eed4105120)
    },
    { /* i=2482; 58 / 58 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00d6dddd294bd3a4), RTUINT128_INIT_C(0x0000000000000000, 0x03cd103eba166ac8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00d6dddd294bd3a4)
    },
    { /* i=2483; 25 / 21 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000019b1b0), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000043001),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000006), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000091aa)
    },
    { /* i=2484; 70 / 5 */
        RTUINT128_INIT_C(0x0000000000000032, 0xbe5a46b3584bd429), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000001e),
        RTUINT128_INIT_C(0x0000000000000001, 0xb103025b4fbe42ce), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000005)
    },
    { /* i=2485; 19 / 36 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000043f90), RTUINT128_INIT_C(0x0000000000000000, 0x0000000c0d59ed91),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000043f90)
    },
    { /* i=2486; 115 / 125 */
        RTUINT128_INIT_C(0x0007a5f793e47056, 0x9030fad289bb4949), RTUINT128_INIT_C(0x1d8a2cf089d14b99, 0x316b9594321ad97d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0007a5f793e47056, 0x9030fad289bb4949)
    },
    { /* i=2487; 119 / 46 */
        RTUINT128_INIT_C(0x00558ba83e2bf422, 0xb957e7f2c3343e3f), RTUINT128_INIT_C(0x0000000000000000, 0x0000116e2bbfe010),
        RTUINT128_INIT_C(0x00000000000004e8, 0x68bc9464ff2ae2f3), RTUINT128_INIT_C(0x0000000000000000, 0x000005d525a46f0f)
    },
    { /* i=2488; 113 / 47 */
        RTUINT128_INIT_C(0x00009da46a8dfa86, 0x3dbbbf24cf1628a0), RTUINT128_INIT_C(0x0000000000000000, 0x0000350dcdc330ee),
        RTUINT128_INIT_C(0x0000000000000002, 0xf8aafd79b63fc2e5), RTUINT128_INIT_C(0x0000000000000000, 0x0000158d95d507ba)
    },
    { /* i=2489; 100 / 4 */
        RTUINT128_INIT_C(0x0000000b75f3476c, 0x23e2f77d4b120cff), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000f),
        RTUINT128_INIT_C(0x00000000c398c07e, 0xad0f2190e2df11ee), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000d)
    },
    { /* i=2490; 93 / 85 */
        RTUINT128_INIT_C(0x000000000c4f28f6, 0xe0cbcd19aec94eed), RTUINT128_INIT_C(0x0000000000092a15, 0xfd03ba62b94c63a4),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000157), RTUINT128_INIT_C(0x000000000007c580, 0xe0cd12d3696fce31)
    },
    { /* i=2491; 119 / 121 */
        RTUINT128_INIT_C(0x007471a2edbd6772, 0x1fdc0813c4dcfc9f), RTUINT128_INIT_C(0x00636ac5f519a187, 0xfb1bf339289b53e4),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x001106dcf8a3c5ea, 0x24c014da9c41a8bb)
    },
    { /* i=2492; 113 / 68 */
        RTUINT128_INIT_C(0x000117ec38c9bd75, 0x803368ba60ad9f11), RTUINT128_INIT_C(0x0000000000000002, 0x7fbcacc86bc182af),
        RTUINT128_INIT_C(0x0000000000000000, 0x00007003df4919df), RTUINT128_INIT_C(0x0000000000000001, 0x0683f08ce872b1a0)
    },
    { /* i=2493; 83 / 24 */
        RTUINT128_INIT_C(0x000000000001b4e5, 0x330d8980eb3236e9), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000009167),
        RTUINT128_INIT_C(0x0000000000000003, 0x013638ea2ca41e4d), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000068ee)
    },
    { /* i=2494; 113 / 79 */
        RTUINT128_INIT_C(0x000120bd9ff83543, 0x44017ea04aeba18f), RTUINT128_INIT_C(0x0000000000006f8f, 0x1e649c9c17103063),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000296965f45), RTUINT128_INIT_C(0x0000000000000b79, 0x55abfb62b597d9e0)
    },
    { /* i=2495; 124 / 33 */
        RTUINT128_INIT_C(0x09cb3ee3e7a12c15, 0xadc9e51f30bae758), RTUINT128_INIT_C(0x0000000000000000, 0x0000000046760f64),
        RTUINT128_INIT_C(0x0000000023955774, 0xd1a2df6ea87a6c3b), RTUINT128_INIT_C(0x0000000000000000, 0x000000002f5f2b4c)
    },
    { /* i=2496; 29 / 31 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000009bec241), RTUINT128_INIT_C(0x0000000000000000, 0x000000003716aebe),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000009bec241)
    },
    { /* i=2497; 128 / 80 */
        RTUINT128_INIT_C(0x4d0cfb8dab12c5d3, 0xdd2ba8785c9ef457), RTUINT128_INIT_C(0x000000000000fbb1, 0x31ccab9ced8d629b),
        RTUINT128_INIT_C(0x0000000000000000, 0x00004e5e95d67fac), RTUINT128_INIT_C(0x0000000000002e17, 0xc51e33b0f923cf33)
    },
    { /* i=2498; 124 / 123 */
        RTUINT128_INIT_C(0x0e830c5867dc00c7, 0xb407bdecb305ef4b), RTUINT128_INIT_C(0x035cd583aa541174, 0xe8a61c066f0e380c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000004), RTUINT128_INIT_C(0x010fb649be8bbaf4, 0x116f4dd2f6cd0f1b)
    },
    { /* i=2499; 113 / 31 */
        RTUINT128_INIT_C(0x0001ba2d6efaff50, 0x494fa3ac3eaa6626), RTUINT128_INIT_C(0x0000000000000000, 0x000000006593bcc6),
        RTUINT128_INIT_C(0x0000000000045a66, 0x2f052a8aa365a271), RTUINT128_INIT_C(0x0000000000000000, 0x000000005ee0c6c0)
    },
    { /* i=2500; 78 / 61 */
        RTUINT128_INIT_C(0x00000000000023bf, 0xc0b96d040e70ff98), RTUINT128_INIT_C(0x0000000000000000, 0x14e2c86a04207930),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000001b62d), RTUINT128_INIT_C(0x0000000000000000, 0x11f6cf51c5639228)
    },
    { /* i=2501; 91 / 77 */
        RTUINT128_INIT_C(0x000000000552328e, 0x97f101d3d875cf24), RTUINT128_INIT_C(0x0000000000000240, 0xa5284eb6e18bf659),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000025cbe), RTUINT128_INIT_C(0x00000000000000e8, 0xea4f19f2395afd16)
    },
    { /* i=2502; 110 / 93 */
        RTUINT128_INIT_C(0x000024384b1bb514, 0x0e4fcf81a28ecc68), RTUINT128_INIT_C(0x000000000df38a67, 0xd1e1b5a5417a5bda),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000002989d), RTUINT128_INIT_C(0x000000000dc28b06, 0xe7bec7531c4707b6)
    },
    { /* i=2503; 98 / 61 */
        RTUINT128_INIT_C(0x0000000281051791, 0xa829b9842cead2cb), RTUINT128_INIT_C(0x0000000000000000, 0x137ddf4ede6570ae),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000020e3076c72), RTUINT128_INIT_C(0x0000000000000000, 0x08dce521f9733d4f)
    },
    { /* i=2504; 73 / 20 */
        RTUINT128_INIT_C(0x00000000000000c8, 0xed3b85c07377faa8), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000038908),
        RTUINT128_INIT_C(0x0000000000000000, 0x0038d5b2bb4f1731), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000030820)
    },
    { /* i=2505; 125 / 114 */
        RTUINT128_INIT_C(0x0476dffc6837d1c6, 0xd3bf98135b84c33e), RTUINT128_INIT_C(0x0003aff8963351b1, 0xd37cdcfb58bfe2ba),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000135), RTUINT128_INIT_C(0x000378ef1c463622, 0x8e08dcb13be818bc)
    },
    { /* i=2506; 93 / 11 */
        RTUINT128_INIT_C(0x00000000139084ab, 0xe739472c5487ec2d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000781),
        RTUINT128_INIT_C(0x0000000000029b74, 0x6dcbec727f2d8385), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000328)
    },
    { /* i=2507; 128 / 66 */
        RTUINT128_INIT_C(0x54ed4046bc3bd3c9, 0x4de1ddd26260eeb3), RTUINT128_INIT_C(0x0000000000000001, 0x886230b391ffecb4),
        RTUINT128_INIT_C(0x0000000000000000, 0x37687d3714e76cc0), RTUINT128_INIT_C(0x0000000000000000, 0x74911a74442777b3)
    },
    { /* i=2508; 76 / 14 */
        RTUINT128_INIT_C(0x000000000000053c, 0x82a7ff037e34857d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000365),
        RTUINT128_INIT_C(0x0000000000000001, 0x8ae7272df5d5a3a6), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000002ff)
    },
    { /* i=2509; 124 / 64 */
        RTUINT128_INIT_C(0x0a9d656a51dd56af, 0x9548bb86015a890f), RTUINT128_INIT_C(0x0000000000000000, 0x9d8044b0a66990b1),
        RTUINT128_INIT_C(0x0000000000000000, 0x1140d1540749e437), RTUINT128_INIT_C(0x0000000000000000, 0x5f9c53392255cf08)
    },
    { /* i=2510; 72 / 42 */
        RTUINT128_INIT_C(0x0000000000000042, 0x83bca2444221e9d4), RTUINT128_INIT_C(0x0000000000000000, 0x0000012831bd9f13),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000397d07e3), RTUINT128_INIT_C(0x0000000000000000, 0x00000042105d56fb)
    },
    { /* i=2511; 122 / 114 */
        RTUINT128_INIT_C(0x00301d6cf42bf5bc, 0x7d8b5f3c4bc0e5f0), RTUINT128_INIT_C(0x0003ca872b98d320, 0x0a9766bb6d882f9d),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000c), RTUINT128_INIT_C(0x00029f16e902103b, 0xfe728e73295eaa94)
    },
    { /* i=2512; 123 / 50 */
        RTUINT128_INIT_C(0x0233c1226f1ee215, 0xb404bcc02dd9be88), RTUINT128_INIT_C(0x0000000000000000, 0x0001c0251d89f284),
        RTUINT128_INIT_C(0x0000000000000142, 0x0a8a24d0aebf799f), RTUINT128_INIT_C(0x0000000000000000, 0x000072baf90fba8c)
    },
    { /* i=2513; 40 / 55 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000fc5bfe8342), RTUINT128_INIT_C(0x0000000000000000, 0x005f7ebb39cfed12),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000000fc5bfe8342)
    },
    { /* i=2514; 122 / 90 */
        RTUINT128_INIT_C(0x00479aeb5119a157, 0x04712fb07fb18b18), RTUINT128_INIT_C(0x000000000301d485, 0xeffd605ae7e69584),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000017cfc7ab), RTUINT128_INIT_C(0x0000000001cfbcc8, 0xabf3edd198b60fec)
    },
    { /* i=2515; 113 / 103 */
        RTUINT128_INIT_C(0x00019b32ebe8f6ae, 0xe3c10eca4561a146), RTUINT128_INIT_C(0x0000002692733d48, 0x7f76bedac6b7ceb7),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000aa9), RTUINT128_INIT_C(0x00000003bd70acd8, 0x1ae88499e7f70477)
    },
    { /* i=2516; 83 / 46 */
        RTUINT128_INIT_C(0x000000000007e17b, 0x2c19d86c73c300bb), RTUINT128_INIT_C(0x0000000000000000, 0x0000298cc00b3ef7),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000308e4456c2), RTUINT128_INIT_C(0x0000000000000000, 0x00000505687a4f8d)
    },
    { /* i=2517; 115 / 70 */
        RTUINT128_INIT_C(0x0002d973dbdb25e9, 0x947b096abaedfb12), RTUINT128_INIT_C(0x000000000000003a, 0x33cfb77a66861494),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000c8874fc9921), RTUINT128_INIT_C(0x0000000000000000, 0xeee8af6e0fa8dffe)
    },
    { /* i=2518; 125 / 92 */
        RTUINT128_INIT_C(0x180cb48e3787d92e, 0x3ba74b7adb2de8ca), RTUINT128_INIT_C(0x0000000009804f6e, 0xaf33a61735c9d37b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000287fdd771), RTUINT128_INIT_C(0x000000000600255e, 0xb77c3f1dbeec427f)
    },
    { /* i=2519; 123 / 112 */
        RTUINT128_INIT_C(0x06dc15c8e74e6028, 0x2ab893fbbfbab14c), RTUINT128_INIT_C(0x00003377e20dac5c, 0x37337d638948779a),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000221e), RTUINT128_INIT_C(0x000021b698cfee04, 0xdc08aa16095a3940)
    },
    { /* i=2520; 121 / 85 */
        RTUINT128_INIT_C(0x0151ddd741264405, 0x3871e5e48caa6123), RTUINT128_INIT_C(0x000000000019d5c2, 0xabec66b3a60fec54),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000d13eeb5c8), RTUINT128_INIT_C(0x00000000001507da, 0x83fe13859c0a5b83)
    },
    { /* i=2521; 119 / 99 */
        RTUINT128_INIT_C(0x003b15f5bf71c1ee, 0x3d0d16e1d635ec6d), RTUINT128_INIT_C(0x00000005b5b43081, 0x8c8d6e38edd123fd),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000a5921), RTUINT128_INIT_C(0x00000003c94af9d7, 0xa546ccb210db53d0)
    },
    { /* i=2522; 66 / 50 */
        RTUINT128_INIT_C(0x0000000000000002, 0x71b31f2789fb36d4), RTUINT128_INIT_C(0x0000000000000000, 0x00021dc959529fe7),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000127a6), RTUINT128_INIT_C(0x0000000000000000, 0x0000c8a96824560a)
    },
    { /* i=2523; 99 / 78 */
        RTUINT128_INIT_C(0x00000006d1310544, 0x0c9eef462e2b63e8), RTUINT128_INIT_C(0x0000000000003832, 0x779ad1eec00a05f7),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000001f0e08), RTUINT128_INIT_C(0x0000000000000566, 0x6c641018e89eb230)
    },
    { /* i=2524; 121 / 40 */
        RTUINT128_INIT_C(0x01ff29623946bf5f, 0x11a32d16867aac77), RTUINT128_INIT_C(0x0000000000000000, 0x00000049d8cb9f7b),
        RTUINT128_INIT_C(0x000000000006ec02, 0x9c443210a0f8302f), RTUINT128_INIT_C(0x0000000000000000, 0x000000422c0954e2)
    },
    { /* i=2525; 114 / 67 */
        RTUINT128_INIT_C(0x0003cb94f0cf24b2, 0xec1bd59051752b33), RTUINT128_INIT_C(0x0000000000000000, 0x2494e85e56b24da8),
        RTUINT128_INIT_C(0x0000000000000000, 0x001a8f2b1ee80ef5), RTUINT128_INIT_C(0x0000000000000000, 0x14d8f0a18851a96b)
    },
    { /* i=2526; 117 / 66 */
        RTUINT128_INIT_C(0x0006852fbbda75e1, 0x219f70dbef84b187), RTUINT128_INIT_C(0x0000000000000001, 0x724a19daf530c462),
        RTUINT128_INIT_C(0x0000000000000000, 0x000481fe6900dd08), RTUINT128_INIT_C(0x0000000000000000, 0xdd8b6090fa75f477)
    },
    { /* i=2527; 120 / 99 */
        RTUINT128_INIT_C(0x00fcb7b93ad8dce8, 0xf14e4da25d136dd1), RTUINT128_INIT_C(0x000000041d1301f3, 0x2b406b5c9dbaa9a2),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000003d6f62), RTUINT128_INIT_C(0x0000000364c85fb7, 0xdf06764fa0773fcd)
    },
    { /* i=2528; 95 / 53 */
        RTUINT128_INIT_C(0x000000002c44a29c, 0xd4489e65fb31e0f4), RTUINT128_INIT_C(0x0000000000000000, 0x000b31f6cd1c0374),
        RTUINT128_INIT_C(0x0000000000000000, 0x000003f4475e328f), RTUINT128_INIT_C(0x0000000000000000, 0x0005c5ab7f474b28)
    },
    { /* i=2529; 21 / 10 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000ba1f5), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000ea),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000cb9), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000db)
    },
    { /* i=2530; 19 / 69 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000030290), RTUINT128_INIT_C(0x0000000000000016, 0xc60079779529bfea),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000030290)
    },
    { /* i=2531; 109 / 77 */
        RTUINT128_INIT_C(0x00000ac8a790c125, 0x3b90caee38d4530e), RTUINT128_INIT_C(0x0000000000001864, 0xf33c3e079a562a23),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000712af80f), RTUINT128_INIT_C(0x0000000000000855, 0x1692703c5837f301)
    },
    { /* i=2532; 73 / 22 */
        RTUINT128_INIT_C(0x0000000000000105, 0x4b4e3fcf9992f644), RTUINT128_INIT_C(0x0000000000000000, 0x00000000002972cf),
        RTUINT128_INIT_C(0x0000000000000000, 0x00064dd7b06f5fc6), RTUINT128_INIT_C(0x0000000000000000, 0x000000000028592a)
    },
    { /* i=2533; 116 / 116 */
        RTUINT128_INIT_C(0x000f155d37b0db7d, 0xba3d9b85cfce9610), RTUINT128_INIT_C(0x0008d6691b1d7604, 0xa78484ec6a1a0539),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x00063ef41c936579, 0x12b9169965b490d7)
    },
    { /* i=2534; 81 / 65 */
        RTUINT128_INIT_C(0x000000000001c11a, 0xac13f91a52a11cd4), RTUINT128_INIT_C(0x0000000000000000, 0xbdf6887170847c12),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000025d3a), RTUINT128_INIT_C(0x0000000000000000, 0x01c4f87dbb6676c0)
    },
    { /* i=2535; 64 / 63 */
        RTUINT128_INIT_C(0x0000000000000000, 0x061be4caf5c65e0e), RTUINT128_INIT_C(0x0000000000000000, 0x75b44636b954dca3),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x061be4caf5c65e0e)
    },
    { /* i=2536; 126 / 125 */
        RTUINT128_INIT_C(0x24216e1b0d7605f1, 0x39ad61a92ad1a90a), RTUINT128_INIT_C(0x09778289d6569e92, 0xba35525e70fb23f0),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003), RTUINT128_INIT_C(0x07bae67d8a722a39, 0x0b0d6a8dd7e03d3a)
    },
    { /* i=2537; 82 / 26 */
        RTUINT128_INIT_C(0x0000000000016b34, 0x7e368af44c47c3e5), RTUINT128_INIT_C(0x0000000000000000, 0x000000000333345a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0071803e98c4e59d), RTUINT128_INIT_C(0x0000000000000000, 0x00000000032426b3)
    },
    { /* i=2538; 126 / 77 */
        RTUINT128_INIT_C(0x3e433b0eff7bef1e, 0x3ebf27edfc959e3f), RTUINT128_INIT_C(0x00000000000015fb, 0xed837201d8af3fdd),
        RTUINT128_INIT_C(0x0000000000000000, 0x0002d508e38ae9f7), RTUINT128_INIT_C(0x0000000000000c35, 0x44af65ed063cdb04)
    },
    { /* i=2539; 121 / 109 */
        RTUINT128_INIT_C(0x001ced1e58cfdd6b, 0x11caeef630710c9e), RTUINT128_INIT_C(0x000005f6cf6984a1, 0xb7b8dc98b82512a4),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000004d9), RTUINT128_INIT_C(0x000003aae24be977, 0x72a58ea184b9af9a)
    },
    { /* i=2540; 44 / 39 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000cdeb44b0487), RTUINT128_INIT_C(0x0000000000000000, 0x00000027d6446b68),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000052), RTUINT128_INIT_C(0x0000000000000000, 0x0000001c12609d37)
    },
    { /* i=2541; 65 / 50 */
        RTUINT128_INIT_C(0x0000000000000000, 0x41d24040f225127d), RTUINT128_INIT_C(0x0000000000000000, 0x0001db345ee7df75),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000002375), RTUINT128_INIT_C(0x0000000000000000, 0x0000e857de9ef304)
    },
    { /* i=2542; 91 / 86 */
        RTUINT128_INIT_C(0x000000000008c2c6, 0x0588b23e938d8591), RTUINT128_INIT_C(0x00000000001f5573, 0x3f1452c1668e3de8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000000000008c2c6, 0x0588b23e938d8591)
    },
    { /* i=2543; 121 / 95 */
        RTUINT128_INIT_C(0x000fd5b6c840df59, 0x7743c01635238399), RTUINT128_INIT_C(0x0000000071715ec8, 0xb08f6ca60efc6cb9),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000023bbc8), RTUINT128_INIT_C(0x00000000620215fa, 0xe82584e53f387011)
    },
    { /* i=2544; 59 / 6 */
        RTUINT128_INIT_C(0x0000000000000000, 0x033b4d59621ced25), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000001e),
        RTUINT128_INIT_C(0x0000000000000000, 0x001b93a51cded4b4), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000d)
    },
    { /* i=2545; 110 / 74 */
        RTUINT128_INIT_C(0x0000073e6be9ac52, 0x227bd69590b5c906), RTUINT128_INIT_C(0x00000000000000d5, 0xcf2147863ff0125a),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000008ac5aa58a), RTUINT128_INIT_C(0x000000000000009c, 0xafc9677671d3e282)
    },
    { /* i=2546; 107 / 104 */
        RTUINT128_INIT_C(0x000007495d7ca911, 0x6c9d6d8e1ac1aff1), RTUINT128_INIT_C(0x0000005799527fe6, 0xb1ad733b365a42e1),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000015), RTUINT128_INIT_C(0x00000019c9b82b24, 0xd962f9b2a55a337c)
    },
    { /* i=2547; 57 / 42 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00027bae3b17797b), RTUINT128_INIT_C(0x0000000000000000, 0x000001226cae4014),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000230), RTUINT128_INIT_C(0x0000000000000000, 0x000000607deb4dbb)
    },
    { /* i=2548; 27 / 82 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000a6e279), RTUINT128_INIT_C(0x0000000000013ce7, 0xbc5470ff75eb525f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000a6e279)
    },
    { /* i=2549; 124 / 62 */
        RTUINT128_INIT_C(0x051149d9ed69a56e, 0x236a62a774a6f11f), RTUINT128_INIT_C(0x0000000000000000, 0x0409e26c578bd4bc),
        RTUINT128_INIT_C(0x0000000000000001, 0x4138aff0386984a1), RTUINT128_INIT_C(0x0000000000000000, 0x0038ac3ceae936e3)
    },
    { /* i=2550; 127 / 21 */
        RTUINT128_INIT_C(0x1c564760f6f286fb, 0x68f0b2522091b5b4), RTUINT128_INIT_C(0x0000000000000000, 0x000000000003c54c),
        RTUINT128_INIT_C(0x00000783dbfbaa1c, 0x20884a68271a6698), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000004894)
    },
    { /* i=2551; 116 / 83 */
        RTUINT128_INIT_C(0x00034d6e20636e69, 0x84a339f38189946b), RTUINT128_INIT_C(0x0000000000034c26, 0x4a0a3b61497187e0),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000100636bd2), RTUINT128_INIT_C(0x00000000000218b8, 0x415bebab42fd7eab)
    },
    { /* i=2552; 127 / 100 */
        RTUINT128_INIT_C(0x4b33a822a37df569, 0x4299e7af16f9c64f), RTUINT128_INIT_C(0x0000000b055e90a8, 0xf63bf7eccc2faf88),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000006d2d1e3), RTUINT128_INIT_C(0x000000040c2a598f, 0x08fc20c7ecd318b7)
    },
    { /* i=2553; 123 / 24 */
        RTUINT128_INIT_C(0x0157f1f5fc58bd1b, 0x37cc6cc9365671ad), RTUINT128_INIT_C(0x0000000000000000, 0x00000000007ce653),
        RTUINT128_INIT_C(0x00000002c0f71fc9, 0xa19bf303eda31e2c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000082169)
    },
    { /* i=2554; 38 / 2 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000025ad0d00d7), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000025ad0d00d7), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=2555; 96 / 40 */
        RTUINT128_INIT_C(0x00000000968937e2, 0x578feb629d7f4747), RTUINT128_INIT_C(0x0000000000000000, 0x000000427785fbcc),
        RTUINT128_INIT_C(0x0000000000000000, 0x0243cbb54d674fdd), RTUINT128_INIT_C(0x0000000000000000, 0x0000003e6b0cf42b)
    },
    { /* i=2556; 114 / 115 */
        RTUINT128_INIT_C(0x00039d5dfaaffae1, 0x0fc895eedca82f09), RTUINT128_INIT_C(0x0005694ba13e3df7, 0x11df8cf355c1cf17),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00039d5dfaaffae1, 0x0fc895eedca82f09)
    },
    { /* i=2557; 46 / 24 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000007fd490e2d35), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000d48665),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000099fad), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000699ff4)
    },
    { /* i=2558; 33 / 29 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000053ea49b2), RTUINT128_INIT_C(0x0000000000000000, 0x0000000015aea29b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003), RTUINT128_INIT_C(0x0000000000000000, 0x0000000012de61e1)
    },
    { /* i=2559; 93 / 38 */
        RTUINT128_INIT_C(0x000000000c089764, 0xd0fa51c8e9bf0899), RTUINT128_INIT_C(0x0000000000000000, 0x00000035add51b96),
        RTUINT128_INIT_C(0x0000000000000000, 0x0039639c0b1f60c9), RTUINT128_INIT_C(0x0000000000000000, 0x0000000db9ea1fd3)
    },
    { /* i=2560; 111 / 44 */
        RTUINT128_INIT_C(0x0000687c7498ddf3, 0x6fe46f604a4d14be), RTUINT128_INIT_C(0x0000000000000000, 0x00000370c5a4051f),
        RTUINT128_INIT_C(0x000000000000001e, 0x5e8c5446e31d66e6), RTUINT128_INIT_C(0x0000000000000000, 0x000002b64d6320e4)
    },
    { /* i=2561; 111 / 41 */
        RTUINT128_INIT_C(0x00007d4667038049, 0xcaafaa29f1700ab3), RTUINT128_INIT_C(0x0000000000000000, 0x000001c785af0598),
        RTUINT128_INIT_C(0x0000000000000046, 0x6752422a1eca6a88), RTUINT128_INIT_C(0x0000000000000000, 0x0000011e3a3421f3)
    },
    { /* i=2562; 36 / 98 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000819d04e14), RTUINT128_INIT_C(0x000000015de122eb, 0xfee2260035f65850),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000819d04e14)
    },
    { /* i=2563; 22 / 11 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000176bc8), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000036c),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000006d8), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000a8)
    },
    { /* i=2564; 51 / 16 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0003f96ab323d0e2), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000007918),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000866e27ebe), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000002112)
    },
    { /* i=2565; 124 / 94 */
        RTUINT128_INIT_C(0x0fdc0b00b6152288, 0x8f0d7590c47bcbd7), RTUINT128_INIT_C(0x000000003f3589c8, 0xbe632eed54e5bbaa),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000403b5e08), RTUINT128_INIT_C(0x0000000022f471c3, 0x0accd91d02378287)
    },
    { /* i=2566; 73 / 43 */
        RTUINT128_INIT_C(0x00000000000001d9, 0x4b4974da44aee177), RTUINT128_INIT_C(0x0000000000000000, 0x0000031748350184),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000991f6cb7), RTUINT128_INIT_C(0x0000000000000000, 0x0000006c372b1c1b)
    },
    { /* i=2567; 124 / 65 */
        RTUINT128_INIT_C(0x06101290194aca18, 0x49062d01751b7460), RTUINT128_INIT_C(0x0000000000000000, 0x33713ed6d13a2b0a),
        RTUINT128_INIT_C(0x0000000000000000, 0x1e2bccea86df988f), RTUINT128_INIT_C(0x0000000000000000, 0x20aa8371525979ca)
    },
    { /* i=2568; 118 / 52 */
        RTUINT128_INIT_C(0x0024d107d083bb8d, 0xd518937d2d7c2387), RTUINT128_INIT_C(0x0000000000000000, 0x0001df02d6a4f2bf),
        RTUINT128_INIT_C(0x0000000000000013, 0xad0f7af2cd982dd0), RTUINT128_INIT_C(0x0000000000000000, 0x0000da92b4635557)
    },
    { /* i=2569; 124 / 93 */
        RTUINT128_INIT_C(0x0158a523916c857e, 0x231af855c2ae0678), RTUINT128_INIT_C(0x0000000002229d4b, 0x14aad966ab148eac),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000a1690243), RTUINT128_INIT_C(0x000000000157d7e1, 0xa7fd2bf822a35774)
    },
    { /* i=2570; 124 / 89 */
        RTUINT128_INIT_C(0x01d472ae4f9e431f, 0xcaf3d284aa7a33b9), RTUINT128_INIT_C(0x0000000001acb51b, 0x2377d70bf1c5c775),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000117bb165b), RTUINT128_INIT_C(0x00000000012f0985, 0xc8a732a584913f22)
    },
    { /* i=2571; 120 / 49 */
        RTUINT128_INIT_C(0x00e55adef4c95f4a, 0xb7886abe75a8944e), RTUINT128_INIT_C(0x0000000000000000, 0x0001eece7a57adb7),
        RTUINT128_INIT_C(0x0000000000000076, 0xa98ac9eeb0ee5ea1), RTUINT128_INIT_C(0x0000000000000000, 0x000135e402992237)
    },
    { /* i=2572; 52 / 32 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0004df08a49b461f), RTUINT128_INIT_C(0x0000000000000000, 0x0000000090b9a015),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000089dd7), RTUINT128_INIT_C(0x0000000000000000, 0x0000000040e0f37c)
    },
    { /* i=2573; 92 / 33 */
        RTUINT128_INIT_C(0x0000000000e51e8a, 0xbf8c1a123d1ad4bd), RTUINT128_INIT_C(0x0000000000000000, 0x000000007a7351d7),
        RTUINT128_INIT_C(0x0000000000000000, 0x01df019b0ee2a243), RTUINT128_INIT_C(0x0000000000000000, 0x0000000035545b78)
    },
    { /* i=2574; 124 / 78 */
        RTUINT128_INIT_C(0x0628532d75b8997d, 0x9acd0166a1f40bdb), RTUINT128_INIT_C(0x0000000000003909, 0xd391c10349694ae0),
        RTUINT128_INIT_C(0x0000000000000000, 0x00001ba2ded18503), RTUINT128_INIT_C(0x0000000000003743, 0x69f1c994b0f1cb3b)
    },
    { /* i=2575; 126 / 14 */
        RTUINT128_INIT_C(0x1d7b1a28e1f40759, 0x9f148af46e738725), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000003e88),
        RTUINT128_INIT_C(0x000078b17b582ddd, 0x9327017adda7f48a), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000031d5)
    },
    { /* i=2576; 41 / 69 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000001ad8665b379), RTUINT128_INIT_C(0x0000000000000016, 0x34c4f873f3fe6343),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000001ad8665b379)
    },
    { /* i=2577; 120 / 82 */
        RTUINT128_INIT_C(0x00cd46fe7cb0c35d, 0x5b4146ecab9fc02f), RTUINT128_INIT_C(0x000000000001eeae, 0x433eb5dbcf0c92ed),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000006a3b6df5d4), RTUINT128_INIT_C(0x000000000000f211, 0xd4c36b64feb042eb)
    },
    { /* i=2578; 115 / 57 */
        RTUINT128_INIT_C(0x000383cd2d5db6a9, 0xfc6cb14849f98e38), RTUINT128_INIT_C(0x0000000000000000, 0x007776b327bf1c53),
        RTUINT128_INIT_C(0x0000000000000000, 0x078831c1aed87426), RTUINT128_INIT_C(0x0000000000000000, 0x0022389a7abdbde6)
    },
    { /* i=2579; 113 / 7 */
        RTUINT128_INIT_C(0x0001566cff0a209a, 0xc1f649b1ca6fa632), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001),
        RTUINT128_INIT_C(0x0001566cff0a209a, 0xc1f649b1ca6fa632), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=2580; 115 / 123 */
        RTUINT128_INIT_C(0x0005daa1e6c537b3, 0xfdf5916371b38529), RTUINT128_INIT_C(0x01eb4b26fdd91e31, 0xd85c75f92a136809),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0005daa1e6c537b3, 0xfdf5916371b38529)
    },
    { /* i=2581; 117 / 112 */
        RTUINT128_INIT_C(0x001d8f0968020974, 0x1872071a88a8991a), RTUINT128_INIT_C(0x0000061921ad7ae0, 0x22f5efbbb0c0b5ac),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000004d8), RTUINT128_INIT_C(0x0000054e47b6dbca, 0xc130d1fa63389ffa)
    },
    { /* i=2582; 119 / 35 */
        RTUINT128_INIT_C(0x004d10665f60df8d, 0x087a66fe7fff10ce), RTUINT128_INIT_C(0x0000000000000000, 0x0000000297b23644),
        RTUINT128_INIT_C(0x00000000001db99c, 0xc56f4a1703333772), RTUINT128_INIT_C(0x0000000000000000, 0x000000000d6e4a86)
    },
    { /* i=2583; 124 / 57 */
        RTUINT128_INIT_C(0x0e0654a12baa973b, 0x8bbd95f325b22fc0), RTUINT128_INIT_C(0x0000000000000000, 0x013c3b2a4c32da4b),
        RTUINT128_INIT_C(0x000000000000000b, 0x5a7f1b42c2f31258), RTUINT128_INIT_C(0x0000000000000000, 0x00a4380555acdff8)
    },
    { /* i=2584; 118 / 53 */
        RTUINT128_INIT_C(0x002365c7987bb60c, 0xbeb8c3db31aa6f79), RTUINT128_INIT_C(0x0000000000000000, 0x00117f9c1f3c279c),
        RTUINT128_INIT_C(0x0000000000000002, 0x05dc6fbccc7c061a), RTUINT128_INIT_C(0x0000000000000000, 0x00075a011d10c1a1)
    },
    { /* i=2585; 45 / 8 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000015e57ab9f468), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000bc),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000001dd0fe4406), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=2586; 52 / 2 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0009b0acd178da36), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001),
        RTUINT128_INIT_C(0x0000000000000000, 0x0009b0acd178da36), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=2587; 125 / 7 */
        RTUINT128_INIT_C(0x1c41e7515fc698d0, 0x01ad8ad8d372476d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000012),
        RTUINT128_INIT_C(0x0191e22f2ffccf99, 0xc7344ed3283103f7), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000f)
    },
    { /* i=2588; 50 / 8 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000218882c33eee0), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000060),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000596c075dfd2), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000020)
    },
    { /* i=2589; 122 / 37 */
        RTUINT128_INIT_C(0x001cc6ba93e2a855, 0x80bffea35e075b5c), RTUINT128_INIT_C(0x0000000000000000, 0x000000073cd08f2d),
        RTUINT128_INIT_C(0x000000000003f9d8, 0xee14c0532f8fe828), RTUINT128_INIT_C(0x0000000000000000, 0x000000049e8d3454)
    },
    { /* i=2590; 65 / 15 */
        RTUINT128_INIT_C(0x0000000000000001, 0x63764ad0f7de1eb5), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000004783),
        RTUINT128_INIT_C(0x0000000000000000, 0x0004f87ead0c515b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000004024)
    },
    { /* i=2591; 117 / 74 */
        RTUINT128_INIT_C(0x001876df457bcc9e, 0xd653f74f292ad60d), RTUINT128_INIT_C(0x000000000000036e, 0x9be8ebb59813037b),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000720cf936416), RTUINT128_INIT_C(0x0000000000000103, 0xbd864731358b7d7b)
    },
    { /* i=2592; 80 / 113 */
        RTUINT128_INIT_C(0x000000000000a14e, 0x7ca8f4daafbe566f), RTUINT128_INIT_C(0x000010971aba229e, 0x5dbb7f1f457e2c53),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000000000000a14e, 0x7ca8f4daafbe566f)
    },
    { /* i=2593; 123 / 46 */
        RTUINT128_INIT_C(0x07556ecf01dd9091, 0x6579c29a89c76910), RTUINT128_INIT_C(0x0000000000000000, 0x00002e72a62f826b),
        RTUINT128_INIT_C(0x000000000000286b, 0x94625656baefe1c4), RTUINT128_INIT_C(0x0000000000000000, 0x000001b50be28424)
    },
    { /* i=2594; 117 / 71 */
        RTUINT128_INIT_C(0x0017a8e598c46fec, 0xb4d49cfff9b9245c), RTUINT128_INIT_C(0x000000000000005b, 0x3bd4ce88f64db7bf),
        RTUINT128_INIT_C(0x0000000000000000, 0x00004263885b056d), RTUINT128_INIT_C(0x0000000000000013, 0x9c39dbc4cd262d09)
    },
    { /* i=2595; 115 / 70 */
        RTUINT128_INIT_C(0x0000377fa929a3b0, 0x892fe0aa98ad288a), RTUINT128_INIT_C(0x000000000000001f, 0xd67cc758184c85bc),
        RTUINT128_INIT_C(0x0000000000000000, 0x000001be40317961), RTUINT128_INIT_C(0x000000000000000c, 0xc66eef309f7ca04e)
    },
    { /* i=2596; 72 / 55 */
        RTUINT128_INIT_C(0x0000000000000078, 0x93f9b8917b68e7c9), RTUINT128_INIT_C(0x0000000000000000, 0x007e074d85fa3441),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000f4ed), RTUINT128_INIT_C(0x0000000000000000, 0x00571219f8f8939c)
    },
    { /* i=2597; 114 / 126 */
        RTUINT128_INIT_C(0x000117bfe03aa260, 0x63593bc2b9529bf4), RTUINT128_INIT_C(0x2359848e0691617c, 0x972b4bbb1b0c6e67),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000117bfe03aa260, 0x63593bc2b9529bf4)
    },
    { /* i=2598; 116 / 56 */
        RTUINT128_INIT_C(0x0003fed09e45c9cb, 0xec44a17957a552fd), RTUINT128_INIT_C(0x0000000000000000, 0x002f63463d2ea9f4),
        RTUINT128_INIT_C(0x0000000000000000, 0x15957ca90446fc93), RTUINT128_INIT_C(0x0000000000000000, 0x0007a46bfdd58be1)
    },
    { /* i=2599; 122 / 110 */
        RTUINT128_INIT_C(0x03a2a6ceb5e40109, 0xbd2f2ad8f6071472), RTUINT128_INIT_C(0x00000c9c52bfea33, 0xdbde0f8427a7defb),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000049cc), RTUINT128_INIT_C(0x000006a40b2c9604, 0x35ce1e3a7dabd16e)
    },
    { /* i=2600; 122 / 117 */
        RTUINT128_INIT_C(0x00b6bc08100bdfe9, 0xe18d417fdd401415), RTUINT128_INIT_C(0x0006f47c8f009806, 0xf5579b15f6154a10),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000001a), RTUINT128_INIT_C(0x0001e76189fc6f34, 0xf6a78144df168e75)
    },
    { /* i=2601; 121 / 66 */
        RTUINT128_INIT_C(0x00c740f3a238118d, 0x2b991869df08d1e6), RTUINT128_INIT_C(0x0000000000000001, 0x9c6855a7223247bd),
        RTUINT128_INIT_C(0x0000000000000000, 0x007baf8f7d7158a1), RTUINT128_INIT_C(0x0000000000000000, 0x9521dbc02153bc09)
    },
    { /* i=2602; 102 / 58 */
        RTUINT128_INIT_C(0x000000143613d8c6, 0x8668bd2616003f0c), RTUINT128_INIT_C(0x0000000000000000, 0x03086763a8b865ac),
        RTUINT128_INIT_C(0x0000000000000000, 0x000006aa0637773b), RTUINT128_INIT_C(0x0000000000000000, 0x023677889c49dc68)
    },
    { /* i=2603; 123 / 94 */
        RTUINT128_INIT_C(0x018505166d653aeb, 0xf47f49cf550ebbd6), RTUINT128_INIT_C(0x000000001ce7ee2d, 0x80bd77088812db87),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000d7546ca), RTUINT128_INIT_C(0x0000000008ed642d, 0xbaa3e21a9e739950)
    },
    { /* i=2604; 114 / 103 */
        RTUINT128_INIT_C(0x0002fc4f6a934c00, 0xfe9e5e911a7ac010), RTUINT128_INIT_C(0x00000009b25b83c2, 0xe3990c1c1170727a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000004ed2), RTUINT128_INIT_C(0x00000003395bd4c9, 0xa961e23a895babfc)
    },
    { /* i=2605; 115 / 14 */
        RTUINT128_INIT_C(0x0005154dcd7e4a5b, 0x7a21c6f9a97a5f95), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000003668),
        RTUINT128_INIT_C(0x00000017eb14648b, 0x960bf317cd4d13bf), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000ffd)
    },
    { /* i=2606; 121 / 70 */
        RTUINT128_INIT_C(0x00c8ca5670c780f5, 0xf97557b0d52de430), RTUINT128_INIT_C(0x0000000000000018, 0xcc41e15604776af0),
        RTUINT128_INIT_C(0x0000000000000000, 0x000818da21e8a33b), RTUINT128_INIT_C(0x000000000000000a, 0x500da2a3eb116ee0)
    },
    { /* i=2607; 99 / 65 */
        RTUINT128_INIT_C(0x0000000529e080fe, 0x030bd9e51f01416a), RTUINT128_INIT_C(0x0000000000000000, 0xf2a38481318b8d3b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000572ab0694), RTUINT128_INIT_C(0x0000000000000000, 0xe55238c8989b394e)
    },
    { /* i=2608; 36 / 36 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000063f305121), RTUINT128_INIT_C(0x0000000000000000, 0x0000000844fc0d13),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000000063f305121)
    },
    { /* i=2609; 31 / 127 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000033e18273), RTUINT128_INIT_C(0x4ee6e3da1dba0a00, 0xd245074c7f3ac0f3),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000033e18273)
    },
    { /* i=2610; 106 / 15 */
        RTUINT128_INIT_C(0x0000028f762d515e, 0xd303e6765680ddd1), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000006d0f),
        RTUINT128_INIT_C(0x0000000006029b10, 0xfc2f15bd5c753e8d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000002a8e)
    },
    { /* i=2611; 115 / 76 */
        RTUINT128_INIT_C(0x00006b1cef46565c, 0xa47d7cb03998721e), RTUINT128_INIT_C(0x000000000000050a, 0x2c4bb85750f9dbfb),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000001540f1ad56), RTUINT128_INIT_C(0x000000000000047a, 0x9489cfd454b4eccc)
    },
    { /* i=2612; 65 / 30 */
        RTUINT128_INIT_C(0x0000000000000000, 0x4890f82c5977a2ba), RTUINT128_INIT_C(0x0000000000000000, 0x000000002490dfeb),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000001fc0a6340), RTUINT128_INIT_C(0x0000000000000000, 0x000000001b79c6fa)
    },
    { /* i=2613; 78 / 55 */
        RTUINT128_INIT_C(0x0000000000003865, 0xc33fb3cad447210d), RTUINT128_INIT_C(0x0000000000000000, 0x00331b0bf8f4fbd2),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000011a8215), RTUINT128_INIT_C(0x0000000000000000, 0x002229859af9d4d3)
    },
    { /* i=2614; 123 / 115 */
        RTUINT128_INIT_C(0x001bc1073c85855f, 0x2ac766a83e96c5e6), RTUINT128_INIT_C(0x0004c70d604b9f16, 0x4c9749f972e9bbce),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000005), RTUINT128_INIT_C(0x0003ddc45b0b69ef, 0xabd2f4c900061ae0)
    },
    { /* i=2615; 46 / 7 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000248676de9055), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000058),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000006a4159cd46), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000045)
    },
    { /* i=2616; 125 / 80 */
        RTUINT128_INIT_C(0x19985f0bc8ab865f, 0x3cdbc41528d26bc4), RTUINT128_INIT_C(0x0000000000005170, 0x960d0d6b1946e6a5),
        RTUINT128_INIT_C(0x0000000000000000, 0x00005074e5e89e22), RTUINT128_INIT_C(0x000000000000038c, 0xadf87aeb6c85f3da)
    },
    { /* i=2617; 114 / 126 */
        RTUINT128_INIT_C(0x00011cc9c064566d, 0x4a2cba1b50cdb747), RTUINT128_INIT_C(0x3d97294964cefbc4, 0xf1baf1134c6602f7),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00011cc9c064566d, 0x4a2cba1b50cdb747)
    },
    { /* i=2618; 121 / 75 */
        RTUINT128_INIT_C(0x0075846e86045080, 0xba84ad58aef32d32), RTUINT128_INIT_C(0x00000000000007cb, 0x2ee3d074ed872b0b),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000f141aa02927), RTUINT128_INIT_C(0x000000000000016e, 0x762400c7d496db85)
    },
    { /* i=2619; 122 / 123 */
        RTUINT128_INIT_C(0x034127b1e69ab2a4, 0xe80a35231a579fcd), RTUINT128_INIT_C(0x0776add4fa071a69, 0x47aa5b86a3a698c4),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x034127b1e69ab2a4, 0xe80a35231a579fcd)
    },
    { /* i=2620; 88 / 17 */
        RTUINT128_INIT_C(0x000000000039dc25, 0x3f4a49e9b6dc5b52), RTUINT128_INIT_C(0x0000000000000000, 0x000000000001cc7b),
        RTUINT128_INIT_C(0x0000000000000020, 0x2aae0c0ebeca9954), RTUINT128_INIT_C(0x0000000000000000, 0x000000000001bff6)
    },
    { /* i=2621; 12 / 8 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000eb2), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000008e),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000001a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000046)
    },
    { /* i=2622; 114 / 65 */
        RTUINT128_INIT_C(0x00006c3ef18c820b, 0xe984a93351522c40), RTUINT128_INIT_C(0x0000000000000000, 0x62159afb0ab2b07d),
        RTUINT128_INIT_C(0x0000000000000000, 0x00011a857c3e9b63), RTUINT128_INIT_C(0x0000000000000000, 0x5f1932efb3163ce9)
    },
    { /* i=2623; 122 / 69 */
        RTUINT128_INIT_C(0x015786b68008e46c, 0xac7970f48514eb13), RTUINT128_INIT_C(0x0000000000000007, 0x2d229e309fd86f98),
        RTUINT128_INIT_C(0x0000000000000000, 0x002fde966ab0bdf8), RTUINT128_INIT_C(0x0000000000000001, 0xaa0995c5388597d3)
    },
    { /* i=2624; 70 / 3 */
        RTUINT128_INIT_C(0x000000000000002e, 0x992988dc138d39b3), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003),
        RTUINT128_INIT_C(0x000000000000000f, 0x88632d9eb12f133b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002)
    },
    { /* i=2625; 32 / 119 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000030dfd86a), RTUINT128_INIT_C(0x001fdf72a249a274, 0xe03432d193e7473a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000030dfd86a)
    },
    { /* i=2626; 126 / 122 */
        RTUINT128_INIT_C(0x26df9ffc0030d049, 0xfc504499d89172d7), RTUINT128_INIT_C(0x00ab419216f54dcb, 0x771f601f82b4dffd),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000003a), RTUINT128_INIT_C(0x0012c4e2cc9d3030, 0xff347d763b96b385)
    },
    { /* i=2627; 80 / 2 */
        RTUINT128_INIT_C(0x0000000000007034, 0xedde61dc7e457909), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003),
        RTUINT128_INIT_C(0x0000000000002566, 0xf9f4cb497f6c7dad), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002)
    },
    { /* i=2628; 120 / 83 */
        RTUINT128_INIT_C(0x00cf51c117af7252, 0x55f955e38e098b80), RTUINT128_INIT_C(0x000000000003faeb, 0x54299bba10986016),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000341699b4bc), RTUINT128_INIT_C(0x0000000000013447, 0xd7579dc8e96d8358)
    },
    { /* i=2629; 44 / 7 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000a381be77924), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000058),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000001dba7fb8a6), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000014)
    },
    { /* i=2630; 21 / 16 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000190027), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000d1e6),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000001e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000006733)
    },
    { /* i=2631; 119 / 42 */
        RTUINT128_INIT_C(0x00734950a85c87e7, 0xc8652ccf31c5d916), RTUINT128_INIT_C(0x0000000000000000, 0x000003fd6ab659ba),
        RTUINT128_INIT_C(0x0000000000001ce4, 0xfd0e74d9dc8cad61), RTUINT128_INIT_C(0x0000000000000000, 0x0000012d9e53279c)
    },
    { /* i=2632; 57 / 35 */
        RTUINT128_INIT_C(0x0000000000000000, 0x01659a5a780928ca), RTUINT128_INIT_C(0x0000000000000000, 0x000000008aab1bc8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000002942e8c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000043d8076a)
    },
    { /* i=2633; 90 / 2 */
        RTUINT128_INIT_C(0x0000000002f77e10, 0x4e22065feed6f2bc), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002),
        RTUINT128_INIT_C(0x00000000017bbf08, 0x2711032ff76b795e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=2634; 19 / 8 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000007c567), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000b),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000b4da), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000009)
    },
    { /* i=2635; 22 / 3 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000001b65ae), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000004),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000006d96b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002)
    },
    { /* i=2636; 111 / 39 */
        RTUINT128_INIT_C(0x000036e390564af1, 0xcb467a1b84db1e1c), RTUINT128_INIT_C(0x0000000000000000, 0x0000007a664474a2),
        RTUINT128_INIT_C(0x0000000000000072, 0xcd0418f85d9b7c78), RTUINT128_INIT_C(0x0000000000000000, 0x00000070f42ffa2c)
    },
    { /* i=2637; 122 / 78 */
        RTUINT128_INIT_C(0x0247e7bf5af2e28c, 0xdeb10673c899c4d9), RTUINT128_INIT_C(0x0000000000001291, 0x4459fdc174e8534d),
        RTUINT128_INIT_C(0x0000000000000000, 0x00001f72a26f965d), RTUINT128_INIT_C(0x00000000000002d2, 0xaae85bef570163e0)
    },
    { /* i=2638; 116 / 29 */
        RTUINT128_INIT_C(0x00040c7f1cbdbe3d, 0x3e600abd6f4ae5b1), RTUINT128_INIT_C(0x0000000000000000, 0x000000000047417c),
        RTUINT128_INIT_C(0x000000000e8bcf91, 0x5ecca392d30af321), RTUINT128_INIT_C(0x0000000000000000, 0x00000000001ac0b5)
    },
    { /* i=2639; 115 / 65 */
        RTUINT128_INIT_C(0x00030898d13c33b0, 0x3c8719ff2cfca66d), RTUINT128_INIT_C(0x0000000000000000, 0xa1860b282c0c8f03),
        RTUINT128_INIT_C(0x0000000000000000, 0x0004ced59d10f4b6), RTUINT128_INIT_C(0x0000000000000000, 0x517f05771c901e4b)
    },
    { /* i=2640; 116 / 83 */
        RTUINT128_INIT_C(0x0006f24522aab681, 0x73c2e93e8aefad4b), RTUINT128_INIT_C(0x000000000003f12d, 0x43348422a0ccc669),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000001c318f5d0), RTUINT128_INIT_C(0x0000000000029eb4, 0x321a947a55d3fafb)
    },
    { /* i=2641; 22 / 78 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000078af0), RTUINT128_INIT_C(0x0000000000003c23, 0xd03094c936d93ea5),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000078af0)
    },
    { /* i=2642; 123 / 113 */
        RTUINT128_INIT_C(0x0297086640e2cab3, 0x52ab594aa4699c03), RTUINT128_INIT_C(0x0001884286489a06, 0xd9c505064712cc73),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000001b0), RTUINT128_INIT_C(0x00011823a65edf23, 0xd632deb2b4b099f3)
    },
    { /* i=2643; 84 / 62 */
        RTUINT128_INIT_C(0x00000000000b55f6, 0xbc3ac27807d6451a), RTUINT128_INIT_C(0x0000000000000000, 0x23de91c3e5b4919a),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000050e751), RTUINT128_INIT_C(0x0000000000000000, 0x000f16c8ea323d60)
    },
    { /* i=2644; 73 / 27 */
        RTUINT128_INIT_C(0x00000000000000e7, 0x14b2565c637c6daf), RTUINT128_INIT_C(0x0000000000000000, 0x000000000524b841),
        RTUINT128_INIT_C(0x0000000000000000, 0x00002ced6536ba6d), RTUINT128_INIT_C(0x0000000000000000, 0x000000000244c002)
    },
    { /* i=2645; 125 / 45 */
        RTUINT128_INIT_C(0x1c116699919eb0a5, 0xa4e77bf8a39d9d26), RTUINT128_INIT_C(0x0000000000000000, 0x0000079279a74a85),
        RTUINT128_INIT_C(0x000000000003b4ec, 0x242cae75d0c4a751), RTUINT128_INIT_C(0x0000000000000000, 0x000003d9e63e4611)
    },
    { /* i=2646; 116 / 95 */
        RTUINT128_INIT_C(0x000f76c873d1750e, 0x25c0ab840a7bf26b), RTUINT128_INIT_C(0x000000007bce81e9, 0x2161307079dc7261),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000001ff9bb), RTUINT128_INIT_C(0x000000006c61c386, 0x5e062121c1750c90)
    },
    { /* i=2647; 123 / 115 */
        RTUINT128_INIT_C(0x03d293f195a0ddb9, 0xd4eb1e9f28f4776d), RTUINT128_INIT_C(0x00001d1cbd4d0afe, 0x99f424d90b5b38eb),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000219d), RTUINT128_INIT_C(0x000004ea8ef64dbc, 0xf1708b0c6fac444e)
    },
    { /* i=2648; 106 / 57 */
        RTUINT128_INIT_C(0x00000068901b3459, 0xc07e3d10614e97fb), RTUINT128_INIT_C(0x0000000000000000, 0x0050576ba916871f),
        RTUINT128_INIT_C(0x0000000000000000, 0x00014d2ddb353179), RTUINT128_INIT_C(0x0000000000000000, 0x001ff51ba760cb54)
    },
    { /* i=2649; 113 / 43 */
        RTUINT128_INIT_C(0x0000216276bbd138, 0xb5783648ed1943d2), RTUINT128_INIT_C(0x0000000000000000, 0x000001fcbb96b6a8),
        RTUINT128_INIT_C(0x0000000000000010, 0xccad04cbfec57c38), RTUINT128_INIT_C(0x0000000000000000, 0x000000b5a45fef12)
    },
    { /* i=2650; 98 / 14 */
        RTUINT128_INIT_C(0x00000001cb98d1c4, 0x29a8492912dc7e9d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000003db9),
        RTUINT128_INIT_C(0x0000000000077237, 0xbab99951c9ad7379), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000372c)
    },
    { /* i=2651; 110 / 44 */
        RTUINT128_INIT_C(0x000003acf3fa4b47, 0xf1e7a25b4a75a215), RTUINT128_INIT_C(0x0000000000000000, 0x00000dcaa110d903),
        RTUINT128_INIT_C(0x0000000000000000, 0x443a17e104c75aca), RTUINT128_INIT_C(0x0000000000000000, 0x00000bb8898a57b7)
    },
    { /* i=2652; 118 / 124 */
        RTUINT128_INIT_C(0x00005674669a5e01, 0x14cddb78e4a6f3b2), RTUINT128_INIT_C(0x0e1e335b4a24a573, 0x1335ab73c4c7634e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00005674669a5e01, 0x14cddb78e4a6f3b2)
    },
    { /* i=2653; 58 / 49 */
        RTUINT128_INIT_C(0x0000000000000000, 0x02be179e4991e6ec), RTUINT128_INIT_C(0x0000000000000000, 0x0000b9b25bc77f60),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000003c7), RTUINT128_INIT_C(0x0000000000000000, 0x0000a6e59affc34c)
    },
    { /* i=2654; 100 / 45 */
        RTUINT128_INIT_C(0x00000008361b4d41, 0x6f7620d5090ed21f), RTUINT128_INIT_C(0x0000000000000000, 0x0000061724614d2c),
        RTUINT128_INIT_C(0x0000000000000000, 0x015926a15b4f3ca0), RTUINT128_INIT_C(0x0000000000000000, 0x000004b60994469f)
    },
    { /* i=2655; 119 / 75 */
        RTUINT128_INIT_C(0x0034dbe3ca9d8af4, 0x28d2615a7b56a86d), RTUINT128_INIT_C(0x000000000000053c, 0x70d89db232812f64),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000a1858c24bf9), RTUINT128_INIT_C(0x0000000000000510, 0x6590c2ab39054429)
    },
    { /* i=2656; 19 / 5 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000002b181), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000001c),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000018a0), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001)
    },
    { /* i=2657; 25 / 101 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000008532ae), RTUINT128_INIT_C(0x0000001d816ec357, 0x4c787d69127041cd),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00000000008532ae)
    },
    { /* i=2658; 96 / 46 */
        RTUINT128_INIT_C(0x00000000db64f8c2, 0xfbe59665758d01f2), RTUINT128_INIT_C(0x0000000000000000, 0x00001ba8bd5e8865),
        RTUINT128_INIT_C(0x0000000000000000, 0x0007ee9c96d5cf0a), RTUINT128_INIT_C(0x0000000000000000, 0x0000198ff5890300)
    },
    { /* i=2659; 114 / 120 */
        RTUINT128_INIT_C(0x000174bed4c42cd4, 0x035b1f390ca95303), RTUINT128_INIT_C(0x00fd85511609dd22, 0x125065fb408d7380),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000174bed4c42cd4, 0x035b1f390ca95303)
    },
    { /* i=2660; 83 / 77 */
        RTUINT128_INIT_C(0x0000000000043492, 0xe27fae6285588f5c), RTUINT128_INIT_C(0x0000000000000c84, 0x30cf187c1ff26b90),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000056), RTUINT128_INIT_C(0x000000000000002a, 0x7ced74afc9e86cfc)
    },
    { /* i=2661; 126 / 52 */
        RTUINT128_INIT_C(0x1188ef858631754e, 0x8c2ce1d62eafe222), RTUINT128_INIT_C(0x0000000000000000, 0x0006195354f44d24),
        RTUINT128_INIT_C(0x00000000000002e0, 0x053cc6020e8a7b66), RTUINT128_INIT_C(0x0000000000000000, 0x0000269f66e0d9ca)
    },
    { /* i=2662; 122 / 68 */
        RTUINT128_INIT_C(0x0359ecc46c98864f, 0x7c0e8fc9a7cb396e), RTUINT128_INIT_C(0x0000000000000000, 0x22e8339ea8d1f629),
        RTUINT128_INIT_C(0x0000000000000000, 0x1893d1b27d2cba5b), RTUINT128_INIT_C(0x0000000000000000, 0x08cfc4f0c442eedb)
    },
    { /* i=2663; 122 / 23 */
        RTUINT128_INIT_C(0x0115a9c5e8cbb6d6, 0x86b01b66befefa24), RTUINT128_INIT_C(0x0000000000000000, 0x00000000003b2107),
        RTUINT128_INIT_C(0x00000004b225aa03, 0xb01e858948b76cf7), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000022863)
    },
    { /* i=2664; 101 / 34 */
        RTUINT128_INIT_C(0x0000000d034a9ce2, 0x7b945278c0c07358), RTUINT128_INIT_C(0x0000000000000000, 0x0000000350a0e7af),
        RTUINT128_INIT_C(0x0000000000000003, 0xeced9434147edae5), RTUINT128_INIT_C(0x0000000000000000, 0x00000000e7642dcd)
    },
    { /* i=2665; 128 / 120 */
        RTUINT128_INIT_C(0x1c0b248fe41ee62b, 0x7ec0f8f8e05ec4b8), RTUINT128_INIT_C(0x002b01e73bd309ab, 0x0995b40043cbf876),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000a6), RTUINT128_INIT_C(0x0027e89f1946a143, 0x47ae40ccea1ba834)
    },
    { /* i=2666; 87 / 76 */
        RTUINT128_INIT_C(0x0000000000527111, 0xd68cb84af7529ed5), RTUINT128_INIT_C(0x0000000000000857, 0x201012c86c9e39f8),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000009e2), RTUINT128_INIT_C(0x0000000000000406, 0xf7b317898399b9e5)
    },
    { /* i=2667; 122 / 95 */
        RTUINT128_INIT_C(0x035dc57d7fd42f32, 0xe35f1edcdc6dbfc5), RTUINT128_INIT_C(0x0000000005282943, 0xeb374003941b4fd3),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000a71c6c24), RTUINT128_INIT_C(0x0000000002e6f59d, 0x2a9697d122d58219)
    },
    { /* i=2668; 124 / 125 */
        RTUINT128_INIT_C(0x06508d3d78be5fb2, 0x4fb54ca0dc7ec5fc), RTUINT128_INIT_C(0x1747662fa76c554f, 0xe07732e57b0bc732),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x06508d3d78be5fb2, 0x4fb54ca0dc7ec5fc)
    },
    { /* i=2669; 119 / 83 */
        RTUINT128_INIT_C(0x0069850d465288b9, 0x78dff7f83fb47c85), RTUINT128_INIT_C(0x0000000000008a08, 0x5c89fab32a0bdf1f),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000c3b34fa316), RTUINT128_INIT_C(0x00000000000059bc, 0xffa91d838c0d92db)
    },
    { /* i=2670; 126 / 100 */
        RTUINT128_INIT_C(0x12bcb0a3212f949e, 0xa91c099c3014bbbf), RTUINT128_INIT_C(0x00000002a72c70af, 0xe8d9336aba403ef0),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000710028e), RTUINT128_INIT_C(0x00000000334b353e, 0xac774937e0f3f29f)
    },
    { /* i=2671; 124 / 90 */
        RTUINT128_INIT_C(0x04efcd7b90bf92ab, 0x49be9cd47341e7b3), RTUINT128_INIT_C(0x0000000000350001, 0xfb4fca2f8644cf11),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000017d866dfb1), RTUINT128_INIT_C(0x00000000001838ba, 0x4e0c435ad488edf2)
    },
    { /* i=2672; 90 / 28 */
        RTUINT128_INIT_C(0x0000000002e79f94, 0x071ff50101fca9b8), RTUINT128_INIT_C(0x0000000000000000, 0x0000000001b51d66),
        RTUINT128_INIT_C(0x0000000000000001, 0xb38261ace138024c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000001ad2370)
    },
    { /* i=2673; 89 / 45 */
        RTUINT128_INIT_C(0x0000000000e0fa8c, 0xfcece1e921ed8d8d), RTUINT128_INIT_C(0x0000000000000000, 0x00000a6eed380ebd),
        RTUINT128_INIT_C(0x0000000000000000, 0x00001590422142e8), RTUINT128_INIT_C(0x0000000000000000, 0x000000e312f67845)
    },
    { /* i=2674; 76 / 123 */
        RTUINT128_INIT_C(0x00000000000000d0, 0xb0d3afd9c05c7267), RTUINT128_INIT_C(0x0370b50c607cd2d1, 0xacf39f54daab63c0),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00000000000000d0, 0xb0d3afd9c05c7267)
    },
    { /* i=2675; 115 / 71 */
        RTUINT128_INIT_C(0x000399cd53dc03fb, 0x819bf8af563a86fb), RTUINT128_INIT_C(0x000000000000002b, 0x7b24464523152c53),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000153339d0b7c9), RTUINT128_INIT_C(0x000000000000000b, 0xad0e84b7297b64d0)
    },
    { /* i=2676; 87 / 15 */
        RTUINT128_INIT_C(0x00000000000ba2c1, 0x9ebf79c72661ecc0), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000765e),
        RTUINT128_INIT_C(0x0000000000000019, 0x2a56f06f0f2ece86), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000538c)
    },
    { /* i=2677; 73 / 44 */
        RTUINT128_INIT_C(0x00000000000001a8, 0x6100335543c6ccda), RTUINT128_INIT_C(0x0000000000000000, 0x000007f41b88877f),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000355b718d), RTUINT128_INIT_C(0x0000000000000000, 0x0000042560a01ce7)
    },
    { /* i=2678; 128 / 127 */
        RTUINT128_INIT_C(0x3e8959504491c65d, 0x4d582db6e862c281), RTUINT128_INIT_C(0x3f12448c43834509, 0xf2cf01ef6895a41e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x3e8959504491c65d, 0x4d582db6e862c281)
    },
    { /* i=2679; 122 / 89 */
        RTUINT128_INIT_C(0x011b7cf9b16aa7ed, 0xe12642879bbbcaad), RTUINT128_INIT_C(0x0000000000963909, 0x294602cc1395db12),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000001e31a2f0f), RTUINT128_INIT_C(0x000000000057596d, 0x49dae76ebce7a69f)
    },
    { /* i=2680; 114 / 72 */
        RTUINT128_INIT_C(0x0003295053291057, 0xc901a2357645b53b), RTUINT128_INIT_C(0x000000000000006e, 0x8e28cfee43c582b8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000075208819447), RTUINT128_INIT_C(0x0000000000000042, 0x6e74fe65dc341433)
    },
    { /* i=2681; 14 / 11 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000002571), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000004ba),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000007), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000045b)
    },
    { /* i=2682; 107 / 12 */
        RTUINT128_INIT_C(0x00000412c33b7764, 0x81f9576d5284b776), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000004c4),
        RTUINT128_INIT_C(0x00000000dacf282d, 0x327799e1a9d33430), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000002b6)
    },
    { /* i=2683; 124 / 70 */
        RTUINT128_INIT_C(0x02d5d951c23d4728, 0xb25048f1a51c84d3), RTUINT128_INIT_C(0x0000000000000017, 0xa3356f19286aeff2),
        RTUINT128_INIT_C(0x0000000000000000, 0x001eb51cd9c8ec1f), RTUINT128_INIT_C(0x000000000000000f, 0x67ce123b93e65e85)
    },
    { /* i=2684; 126 / 113 */
        RTUINT128_INIT_C(0x25d6bbffd042ab09, 0x0520f75ac3ae6fc0), RTUINT128_INIT_C(0x00000d48d51fc829, 0x6bf98968b3c674e1),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000002d92c), RTUINT128_INIT_C(0x00000c93adce4f70, 0xddf2316bbabda014)
    },
    { /* i=2685; 57 / 6 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0001bfcf3e69fff6), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000026),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000bc8d27c0d79), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=2686; 125 / 123 */
        RTUINT128_INIT_C(0x0b5aeebecd20d1fb, 0xc3e04f003e058dc5), RTUINT128_INIT_C(0x01cf679d18a7fa1c, 0x7a82b2d0705c2b1d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000006), RTUINT128_INIT_C(0x007e81103930f550, 0xe4d01e1d9bdc8b17)
    },
    { /* i=2687; 128 / 107 */
        RTUINT128_INIT_C(0x0c141171a32c2734, 0xdfad455d4f5647b7), RTUINT128_INIT_C(0x000006c8f263ebdf, 0xe05d7e98b97e85f9),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000001c7b9), RTUINT128_INIT_C(0x0000036ae0bbcaa5, 0x901b574f62c9e7c6)
    },
    { /* i=2688; 111 / 118 */
        RTUINT128_INIT_C(0x000042b3aa91fa77, 0xdd69024cd085aa15), RTUINT128_INIT_C(0x0012b9b3eec9d512, 0x0b87f93def39941b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000042b3aa91fa77, 0xdd69024cd085aa15)
    },
    { /* i=2689; 31 / 11 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000003e024c3c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000707),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000008d2ee), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000005ba)
    },
    { /* i=2690; 60 / 17 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0d9739398b07d501), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000145c5),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000aae157951a9), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000070f4)
    },
    { /* i=2691; 54 / 28 */
        RTUINT128_INIT_C(0x0000000000000000, 0x002db85064b7012f), RTUINT128_INIT_C(0x0000000000000000, 0x000000000981ecda),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000004cf0efc), RTUINT128_INIT_C(0x0000000000000000, 0x000000000197ee97)
    },
    { /* i=2692; 72 / 55 */
        RTUINT128_INIT_C(0x00000000000000ea, 0xc16a826673f8fe86), RTUINT128_INIT_C(0x0000000000000000, 0x003802452a0cb2ca),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000430ff), RTUINT128_INIT_C(0x0000000000000000, 0x001e9f6c64a50750)
    },
    { /* i=2693; 113 / 85 */
        RTUINT128_INIT_C(0x0000b313c3f322a6, 0xc550d5dad4d3514a), RTUINT128_INIT_C(0x000000000009214e, 0xd41756d2af9ffa4e),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000139d29b7), RTUINT128_INIT_C(0x000000000000e593, 0x897b726e5e8ae588)
    },
    { /* i=2694; 65 / 57 */
        RTUINT128_INIT_C(0x0000000000000000, 0x6af2f3170bd50660), RTUINT128_INIT_C(0x0000000000000000, 0x00bcd409c4828f3a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000090), RTUINT128_INIT_C(0x0000000000000000, 0x00bbad98826475c0)
    },
    { /* i=2695; 125 / 89 */
        RTUINT128_INIT_C(0x140217d8ff39f56e, 0x9ab1e316ff18a32c), RTUINT128_INIT_C(0x0000000000be8cf6, 0x8a4ac6bfb9d4a707),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000001ae1675560), RTUINT128_INIT_C(0x0000000000a1b0d2, 0x9199106b5913ad8c)
    },
    { /* i=2696; 80 / 16 */
        RTUINT128_INIT_C(0x000000000000fc78, 0x260d7b69eecd2b13), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000004a9c),
        RTUINT128_INIT_C(0x0000000000000003, 0x62461960ec7512e3), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000abf)
    },
    { /* i=2697; 75 / 9 */
        RTUINT128_INIT_C(0x000000000000032e, 0x7c4bee9835150b73), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000001c7),
        RTUINT128_INIT_C(0x0000000000000001, 0xca428edf239014d7), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000152)
    },
    { /* i=2698; 124 / 115 */
        RTUINT128_INIT_C(0x08a8fc4388bbf9c1, 0xbf869b2de1e32521), RTUINT128_INIT_C(0x0000ca4908a2e95a, 0xee9d72d3dc0959ed),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000af5), RTUINT128_INIT_C(0x00008a07e7b51869, 0x3c5b6fd3ef6cd350)
    },
    { /* i=2699; 117 / 103 */
        RTUINT128_INIT_C(0x00154ade55557d10, 0x62fa172bc6597c98), RTUINT128_INIT_C(0x000000457e79ebd5, 0x5e00cc551e7c013a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000004e6f), RTUINT128_INIT_C(0x00000033589d38e8, 0x625f8ef9c6354872)
    },
    { /* i=2700; 78 / 34 */
        RTUINT128_INIT_C(0x0000000000002924, 0xe4b3bf1208f4c391), RTUINT128_INIT_C(0x0000000000000000, 0x000000026e6e1ed6),
        RTUINT128_INIT_C(0x0000000000000000, 0x000010ec15e78536), RTUINT128_INIT_C(0x0000000000000000, 0x00000002269b146d)
    },
    { /* i=2701; 36 / 30 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000bd7cb3116), RTUINT128_INIT_C(0x0000000000000000, 0x000000000bb0148e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000103), RTUINT128_INIT_C(0x0000000000000000, 0x0000000004a6656c)
    },
    { /* i=2702; 118 / 51 */
        RTUINT128_INIT_C(0x001f820016bab7df, 0xfa26a4f8a8189ee6), RTUINT128_INIT_C(0x0000000000000000, 0x0007202b9eba77b1),
        RTUINT128_INIT_C(0x0000000000000004, 0x6bf6e8325c46c653), RTUINT128_INIT_C(0x0000000000000000, 0x0003477da2aaea83)
    },
    { /* i=2703; 114 / 42 */
        RTUINT128_INIT_C(0x00012c6da75f944e, 0xeed8b15dfd7c47e4), RTUINT128_INIT_C(0x0000000000000000, 0x000003ae5a8eb19e),
        RTUINT128_INIT_C(0x0000000000000051, 0x9d4a9f1bf3d1ae41), RTUINT128_INIT_C(0x0000000000000000, 0x000001ca0689cac6)
    },
    { /* i=2704; 17 / 48 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000caa6), RTUINT128_INIT_C(0x0000000000000000, 0x00001b5c0abf4835),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000caa6)
    },
    { /* i=2705; 117 / 99 */
        RTUINT128_INIT_C(0x001fcef0e5457b66, 0xcfc0085c3ded16dd), RTUINT128_INIT_C(0x00000006a455ee6a, 0x1b2631b862316708),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000004c9fd), RTUINT128_INIT_C(0x000000014a7f20a0, 0x37159744cd14fbf5)
    },
    { /* i=2706; 114 / 121 */
        RTUINT128_INIT_C(0x00035c83a8d38382, 0x9cca61bbab5a6ce1), RTUINT128_INIT_C(0x01e67cccae7b949c, 0xbf1b9b106b401ab0),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00035c83a8d38382, 0x9cca61bbab5a6ce1)
    },
    { /* i=2707; 123 / 36 */
        RTUINT128_INIT_C(0x078ada59454bfbce, 0xcbf18cf10a0ca0d8), RTUINT128_INIT_C(0x0000000000000000, 0x00000004a1aabe3e),
        RTUINT128_INIT_C(0x0000000001a0e50f, 0x32d170d731983636), RTUINT128_INIT_C(0x0000000000000000, 0x0000000019176bc4)
    },
    { /* i=2708; 28 / 17 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000861aca3), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000016509),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000602), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000ac91)
    },
    { /* i=2709; 109 / 81 */
        RTUINT128_INIT_C(0x00001d95728b30e2, 0xba175642b8a1a224), RTUINT128_INIT_C(0x000000000001cdd9, 0xfc7968454b1f23b9),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000001065e43c), RTUINT128_INIT_C(0x0000000000009a84, 0xf4bc9998b9877ec8)
    },
    { /* i=2710; 127 / 122 */
        RTUINT128_INIT_C(0x269d43be4d99e3a1, 0x8bae8b6263443024), RTUINT128_INIT_C(0x0112b53c891ec9a3, 0x0035a8695045cdbf),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000023), RTUINT128_INIT_C(0x010e7c778e645258, 0x845884fc69b90f07)
    },
    { /* i=2711; 126 / 64 */
        RTUINT128_INIT_C(0x31eaee77f3375e7e, 0x97b13d4e0eb7b1de), RTUINT128_INIT_C(0x0000000000000000, 0x876b84641afbf43e),
        RTUINT128_INIT_C(0x0000000000000000, 0x5e5d7c62564ef336), RTUINT128_INIT_C(0x0000000000000000, 0x237fe605f5d752ca)
    },
    { /* i=2712; 119 / 125 */
        RTUINT128_INIT_C(0x0079bdf0724ba0c7, 0x0333415c6e98d492), RTUINT128_INIT_C(0x0d7b58ff33f69cbc, 0xd3b71280351a629e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0079bdf0724ba0c7, 0x0333415c6e98d492)
    },
    { /* i=2713; 120 / 104 */
        RTUINT128_INIT_C(0x00ef4c9b6c03702c, 0x9565727e5e2fe9f3), RTUINT128_INIT_C(0x0000002ec49e11c8, 0xc1a984a61c91e327),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000051de1), RTUINT128_INIT_C(0x000000245c26487a, 0x94227c694b78d9ac)
    },
    { /* i=2714; 119 / 104 */
        RTUINT128_INIT_C(0x006ce171eed71dd6, 0xc3e951b0002defd2), RTUINT128_INIT_C(0x000000d20c116877, 0xd10e93fe97e21a4a),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000084b3), RTUINT128_INIT_C(0x0000005a84cd4a44, 0x1268905b37876614)
    },
    { /* i=2715; 120 / 96 */
        RTUINT128_INIT_C(0x00cfb58ffaa7c31a, 0x320c3164d4469390), RTUINT128_INIT_C(0x00000000590d2791, 0x2680989b6b4c726f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000002551c6b), RTUINT128_INIT_C(0x000000000c558f55, 0x272a2f6bc1f39b2b)
    },
    { /* i=2716; 99 / 77 */
        RTUINT128_INIT_C(0x00000004054ff6b3, 0x479c93c7ccc3a1a7), RTUINT128_INIT_C(0x0000000000001f44, 0xc8614bca3a946302),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000020eb16), RTUINT128_INIT_C(0x00000000000016af, 0x45661a142ce0497b)
    },
    { /* i=2717; 23 / 20 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000001375bb), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000b914d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x0000000000000000, 0x000000000007e46e)
    },
    { /* i=2718; 114 / 82 */
        RTUINT128_INIT_C(0x00030c58764fa5cb, 0x3ce5ad139baa99a0), RTUINT128_INIT_C(0x000000000001d938, 0x18c9a07668325d3c),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000001a625dce7), RTUINT128_INIT_C(0x0000000000007b38, 0x38300bb7ec6ce87c)
    },
    { /* i=2719; 106 / 73 */
        RTUINT128_INIT_C(0x000000efadba7812, 0x60d8113bb3dd1bb7), RTUINT128_INIT_C(0x000000000000009e, 0x6c594879d84092a3),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000001834d75d0), RTUINT128_INIT_C(0x000000000000006a, 0x8b9dd54df85a7847)
    },
    { /* i=2720; 34 / 2 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000225bcbce), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000225bcbce), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=2721; 123 / 40 */
        RTUINT128_INIT_C(0x0603f3896e190c2d, 0x3cddf12aac07798a), RTUINT128_INIT_C(0x0000000000000000, 0x000000f15fae0921),
        RTUINT128_INIT_C(0x0000000000066144, 0x183e38e159e7e70f), RTUINT128_INIT_C(0x0000000000000000, 0x0000007850d1299b)
    },
    { /* i=2722; 45 / 71 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00001947ac3c3381), RTUINT128_INIT_C(0x000000000000004a, 0x9599362721314aa6),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00001947ac3c3381)
    },
    { /* i=2723; 109 / 42 */
        RTUINT128_INIT_C(0x0000081937c0e28f, 0x72045cc4c571a35e), RTUINT128_INIT_C(0x0000000000000000, 0x000000aa60da99ff),
        RTUINT128_INIT_C(0x000000000000000c, 0x2b16e5531d32569e), RTUINT128_INIT_C(0x0000000000000000, 0x0000004297fcedfc)
    },
    { /* i=2724; 104 / 23 */
        RTUINT128_INIT_C(0x00000027eb76016e, 0x8846dd74f19daac1), RTUINT128_INIT_C(0x0000000000000000, 0x000000000031427d),
        RTUINT128_INIT_C(0x000000000000cf75, 0xf71593f8a49fe7a1), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000010f24)
    },
    { /* i=2725; 88 / 18 */
        RTUINT128_INIT_C(0x0000000000957c24, 0x9d6b89954caff9d1), RTUINT128_INIT_C(0x0000000000000000, 0x000000000002e313),
        RTUINT128_INIT_C(0x0000000000000033, 0xc74ac3ade7a38b72), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000028a5b)
    },
    { /* i=2726; 115 / 92 */
        RTUINT128_INIT_C(0x0006620a9aeec769, 0x3a517da3ad00c287), RTUINT128_INIT_C(0x000000000c2f78ce, 0xb834c4350027beb1),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000086190f), RTUINT128_INIT_C(0x00000000052617b0, 0x9452bcb6f8674d28)
    },
    { /* i=2727; 125 / 93 */
        RTUINT128_INIT_C(0x127cd5f352e64df6, 0xa6f2b5cf56d69121), RTUINT128_INIT_C(0x000000001b18d725, 0xd714bd5e06066dc1),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000aea99a2b), RTUINT128_INIT_C(0x00000000142251d2, 0x2161fe8cd35307b6)
    },
    { /* i=2728; 127 / 36 */
        RTUINT128_INIT_C(0x5c5dde2e29cc0c7a, 0x3d4ee0ad2afe559a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000d7d55b7be),
        RTUINT128_INIT_C(0x0000000006d8e5c6, 0x012c4dc4e70c9496), RTUINT128_INIT_C(0x0000000000000000, 0x000000071da2d446)
    },
    { /* i=2729; 100 / 95 */
        RTUINT128_INIT_C(0x00000006f61da2c1, 0xf79f81090842c025), RTUINT128_INIT_C(0x000000004b36a801, 0x8fef6b1a0d9d178c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000017), RTUINT128_INIT_C(0x0000000034348a9e, 0x091ce1b1cf25a291)
    },
    { /* i=2730; 124 / 25 */
        RTUINT128_INIT_C(0x0e29afe3791fbe8a, 0x196e82638170321e), RTUINT128_INIT_C(0x0000000000000000, 0x000000000092f3ec),
        RTUINT128_INIT_C(0x00000018ac261d19, 0x311b883b27eca335), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000246e42)
    },
    { /* i=2731; 118 / 125 */
        RTUINT128_INIT_C(0x003dc4b428a27010, 0xa6c16337dd6230d7), RTUINT128_INIT_C(0x16f90f5151549450, 0x664594e6aed7af11),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x003dc4b428a27010, 0xa6c16337dd6230d7)
    },
    { /* i=2732; 45 / 21 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000161b2ef7fe13), RTUINT128_INIT_C(0x0000000000000000, 0x00000000001c709b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000c6fcda), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000058615)
    },
    { /* i=2733; 86 / 58 */
        RTUINT128_INIT_C(0x0000000000382b27, 0x17c03cfea62fb0b4), RTUINT128_INIT_C(0x0000000000000000, 0x00f20526b9b6963b),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000003b69bd65), RTUINT128_INIT_C(0x0000000000000000, 0x00c75d185d09dc6d)
    },
    { /* i=2734; 108 / 54 */
        RTUINT128_INIT_C(0x0000042ef6a8b26f, 0xed77420b55385b8b), RTUINT128_INIT_C(0x0000000000000000, 0x00032a63213ce40f),
        RTUINT128_INIT_C(0x0000000000000000, 0x015250cca65f17dc), RTUINT128_INIT_C(0x0000000000000000, 0x0000af6ff0d605a7)
    },
    { /* i=2735; 76 / 23 */
        RTUINT128_INIT_C(0x0000000000000edc, 0x1cb9b7805ce2ee14), RTUINT128_INIT_C(0x0000000000000000, 0x00000000003ea575),
        RTUINT128_INIT_C(0x0000000000000000, 0x003cb9404cd50805), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000250acb)
    },
    { /* i=2736; 83 / 40 */
        RTUINT128_INIT_C(0x000000000002258a, 0xa1c6b5c5bfa21b7c), RTUINT128_INIT_C(0x0000000000000000, 0x000000ccf2cfa21b),
        RTUINT128_INIT_C(0x0000000000000000, 0x000002ae6de355b2), RTUINT128_INIT_C(0x0000000000000000, 0x00000029bd7f6db6)
    },
    { /* i=2737; 18 / 76 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000033a2e), RTUINT128_INIT_C(0x00000000000002ff, 0x37681155cb4ac397),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000033a2e)
    },
    { /* i=2738; 125 / 120 */
        RTUINT128_INIT_C(0x00269c6a5c303a06, 0x503fe18acc752947), RTUINT128_INIT_C(0x008dbf097559112b, 0xc856dcf2c5c5096a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00269c6a5c303a06, 0x503fe18acc752947)
    },
    { /* i=2739; 126 / 89 */
        RTUINT128_INIT_C(0x292d70152e296cf6, 0x3201f9d8161a2079), RTUINT128_INIT_C(0x0000000001b9a3ce, 0x16b1aa45b226f083),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000017de6d4688), RTUINT128_INIT_C(0x00000000005c05b4, 0x9d663b2fc9df88e1)
    },
    { /* i=2740; 116 / 76 */
        RTUINT128_INIT_C(0x0008204ec7ea523b, 0x07d9f28d99dfd53b), RTUINT128_INIT_C(0x00000000000004ac, 0xb86fba540165b1ee),
        RTUINT128_INIT_C(0x0000000000000000, 0x000001bd03e3829d), RTUINT128_INIT_C(0x000000000000005d, 0x8c6e4b5a8a1cda45)
    },
    { /* i=2741; 74 / 1 */
        RTUINT128_INIT_C(0x000000000000004e, 0x259d7c168d63ac6a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001),
        RTUINT128_INIT_C(0x000000000000004e, 0x259d7c168d63ac6a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=2742; 84 / 32 */
        RTUINT128_INIT_C(0x00000000000891ce, 0xac7dcda4c28837bf), RTUINT128_INIT_C(0x0000000000000000, 0x0000000017481e3c),
        RTUINT128_INIT_C(0x0000000000000000, 0x005e3a918155263f), RTUINT128_INIT_C(0x0000000000000000, 0x000000000d5fdefb)
    },
    { /* i=2743; 121 / 100 */
        RTUINT128_INIT_C(0x00339eb93e5ff09c, 0x5f99ac84c152f68b), RTUINT128_INIT_C(0x0000000d119e8ffb, 0x91925cc767b4bb95),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000003f329), RTUINT128_INIT_C(0x0000000c395c616d, 0x0ac1520664937cae)
    },
    { /* i=2744; 123 / 50 */
        RTUINT128_INIT_C(0x00d08c7e9d51ab47, 0xff5e3982253590ad), RTUINT128_INIT_C(0x0000000000000000, 0x000354993a9daca6),
        RTUINT128_INIT_C(0x000000000000003e, 0x9e5a0821f910e982), RTUINT128_INIT_C(0x0000000000000000, 0x0002552a9ea0ce61)
    },
    { /* i=2745; 124 / 110 */
        RTUINT128_INIT_C(0x053c7263f18c0204, 0x4fd60182db554ae9), RTUINT128_INIT_C(0x0000394e34594972, 0x9ca01d3742982e86),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001764), RTUINT128_INIT_C(0x000009237912052c, 0xbeaaa0f12bb51491)
    },
    { /* i=2746; 126 / 123 */
        RTUINT128_INIT_C(0x05d3e1108e14d62e, 0xa480215495d722c2), RTUINT128_INIT_C(0x026436b39b181d4a, 0x6990df957bf5c018),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002), RTUINT128_INIT_C(0x010b73a957e49b99, 0xd15e62299deba292)
    },
    { /* i=2747; 127 / 80 */
        RTUINT128_INIT_C(0x71531e9e50267e43, 0xd65d7688e9a238df), RTUINT128_INIT_C(0x000000000000490c, 0xcf62203b015fa9ed),
        RTUINT128_INIT_C(0x0000000000000000, 0x00018d23ef377883), RTUINT128_INIT_C(0x0000000000000821, 0x2a7cf019991c2c98)
    },
    { /* i=2748; 122 / 107 */
        RTUINT128_INIT_C(0x0255b40aeace584b, 0x1b956fba2bad2bc5), RTUINT128_INIT_C(0x000001aa3f9edae5, 0x74ad858ee4923fb2),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000166f9), RTUINT128_INIT_C(0x0000007ae32e8df1, 0xf608b419545a4ba3)
    },
    { /* i=2749; 101 / 4 */
        RTUINT128_INIT_C(0x0000001a19fa30ab, 0x7d4bced84e4d24fe), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000e),
        RTUINT128_INIT_C(0x00000001dd48ba55, 0x6460d7eae10582a4), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000006)
    },
    { /* i=2750; 96 / 8 */
        RTUINT128_INIT_C(0x00000000789cd761, 0xae680ae4d413613e), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000005d),
        RTUINT128_INIT_C(0x00000000014c0250, 0xe0d7d412fa05b6b9), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000009)
    },
    { /* i=2751; 114 / 94 */
        RTUINT128_INIT_C(0x00027317bbbea9cf, 0xbffe3bfbf01a4ab9), RTUINT128_INIT_C(0x000000000cc59dd4, 0xb093fa854b6fa370),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000311968), RTUINT128_INIT_C(0x000000000956f9d6, 0x9ce601191b59f539)
    },
    { /* i=2752; 124 / 114 */
        RTUINT128_INIT_C(0x06a7a055e37e1d0c, 0xe49f4149b5265344), RTUINT128_INIT_C(0x0000bc6e1da6523d, 0xac7e364d5d0be77a),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000090a), RTUINT128_INIT_C(0x000064fde21abb93, 0xb7c869fea78bfe80)
    },
    { /* i=2753; 51 / 69 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0001b39a33c24093), RTUINT128_INIT_C(0x000000000000000b, 0x103c291054847ba9),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0001b39a33c24093)
    },
    { /* i=2754; 125 / 123 */
        RTUINT128_INIT_C(0x0cff989a0fb4f2d7, 0x0dc1481763024e84), RTUINT128_INIT_C(0x07412e3a8092c886, 0x1721a4b29ba68dc0),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x05be6a5f8f222a50, 0xf69fa364c75bc0c4)
    },
    { /* i=2755; 112 / 3 */
        RTUINT128_INIT_C(0x0000056a1a3aa1bd, 0x80cf2a0c7b41ae82), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001),
        RTUINT128_INIT_C(0x0000056a1a3aa1bd, 0x80cf2a0c7b41ae82), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=2756; 123 / 22 */
        RTUINT128_INIT_C(0x054f35bd49e3efb1, 0xc842aa8d51f680b5), RTUINT128_INIT_C(0x0000000000000000, 0x00000000003fa896),
        RTUINT128_INIT_C(0x000000155a00ab21, 0x4c71d87fe71c3668), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000225fc5)
    },
    { /* i=2757; 119 / 25 */
        RTUINT128_INIT_C(0x007fa1454306d0c3, 0x7181f25c14359abd), RTUINT128_INIT_C(0x0000000000000000, 0x0000000001f0c267),
        RTUINT128_INIT_C(0x0000000041c5d830, 0xd27ec373d047b419), RTUINT128_INIT_C(0x0000000000000000, 0x00000000007132ae)
    },
    { /* i=2758; 66 / 40 */
        RTUINT128_INIT_C(0x0000000000000000, 0x46277c96dc33fb00), RTUINT128_INIT_C(0x0000000000000000, 0x00000000e3cd8e2a),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000004ed67afd), RTUINT128_INIT_C(0x0000000000000000, 0x000000002132777e)
    },
    { /* i=2759; 117 / 122 */
        RTUINT128_INIT_C(0x0010a4f9bd655777, 0x65ac1edf598334dd), RTUINT128_INIT_C(0x03ed46070c2bf363, 0xa5b3372108eee2d2),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0010a4f9bd655777, 0x65ac1edf598334dd)
    },
    { /* i=2760; 68 / 3 */
        RTUINT128_INIT_C(0x000000000000000b, 0x0381454ecb0c9b4b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001),
        RTUINT128_INIT_C(0x000000000000000b, 0x0381454ecb0c9b4b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=2761; 115 / 24 */
        RTUINT128_INIT_C(0x0006358e1b17d24d, 0x0dc9f17f98ee8d6c), RTUINT128_INIT_C(0x0000000000000000, 0x00000000003288c2),
        RTUINT128_INIT_C(0x000000001f747cd9, 0x8d7c46b886c2eb20), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000f5f2c)
    },
    { /* i=2762; 125 / 103 */
        RTUINT128_INIT_C(0x1db224c8193938d7, 0x00ca9b5af5454960), RTUINT128_INIT_C(0x0000000c7ee2a2f6, 0x20fe8519e2fd3214),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000002606227), RTUINT128_INIT_C(0x0000000af9c1d03a, 0x6d95522d84070054)
    },
    { /* i=2763; 127 / 99 */
        RTUINT128_INIT_C(0x6b9e88238c2e36fd, 0x97c2d53a0cbe8245), RTUINT128_INIT_C(0x000000077b3db834, 0x2c4a583debec5cf1),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000e628821), RTUINT128_INIT_C(0x0000000080f8bb73, 0x38b152584fa47f34)
    },
    { /* i=2764; 67 / 56 */
        RTUINT128_INIT_C(0x0000000000000002, 0x678c84b9588f2cc0), RTUINT128_INIT_C(0x0000000000000000, 0x0016007cae741ede),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001bfa), RTUINT128_INIT_C(0x0000000000000000, 0x0002e490bbe79df4)
    },
    { /* i=2765; 82 / 63 */
        RTUINT128_INIT_C(0x00000000000357cd, 0xa82654ddc2a5b9f6), RTUINT128_INIT_C(0x0000000000000000, 0x742396315f83e62c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000075e68), RTUINT128_INIT_C(0x0000000000000000, 0x4d3193213b581016)
    },
    { /* i=2766; 124 / 117 */
        RTUINT128_INIT_C(0x017e02104f12c055, 0x5b1cb23cca6ab6de), RTUINT128_INIT_C(0x001bca80fbbdaf96, 0x1c761f4447192347),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000d), RTUINT128_INIT_C(0x0014b9838670d5b5, 0xe91d1bc52e23ec43)
    },
    { /* i=2767; 115 / 59 */
        RTUINT128_INIT_C(0x00003edab7e62069, 0xf45aa341e34432ed), RTUINT128_INIT_C(0x0000000000000000, 0x000cddd4f6f022e9),
        RTUINT128_INIT_C(0x0000000000000000, 0x04e29650a481bb33), RTUINT128_INIT_C(0x0000000000000000, 0x000c2d446c840b82)
    },
    { /* i=2768; 30 / 17 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000005808d69), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000005b04),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000f79), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000004c85)
    },
    { /* i=2769; 53 / 11 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00137367c80586b5), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000457),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000047b5ea74ac7), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000114)
    },
    { /* i=2770; 33 / 123 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000003ed25855), RTUINT128_INIT_C(0x046191e86a1ce84e, 0xb3ef30097e3e0918),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000000003ed25855)
    },
    { /* i=2771; 127 / 118 */
        RTUINT128_INIT_C(0x111a2e44e05d58dd, 0xa6f9df9eacb4b176), RTUINT128_INIT_C(0x0018a24bb27f7bbb, 0xd22c994609bf82db),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000b1), RTUINT128_INIT_C(0x0011f7ee7638cc01, 0x5623e631ef4b380b)
    },
    { /* i=2772; 113 / 28 */
        RTUINT128_INIT_C(0x0000779b2155b825, 0x08ecadaabce838e9), RTUINT128_INIT_C(0x0000000000000000, 0x000000000f11f65e),
        RTUINT128_INIT_C(0x000000000007efc5, 0x75cea5bf12882d56), RTUINT128_INIT_C(0x0000000000000000, 0x0000000006a0ef55)
    },
    { /* i=2773; 39 / 35 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000743f23e9c7), RTUINT128_INIT_C(0x0000000000000000, 0x000000071723faa6),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000010), RTUINT128_INIT_C(0x0000000000000000, 0x00000002cce43f67)
    },
    { /* i=2774; 126 / 124 */
        RTUINT128_INIT_C(0x1573fe8002f088c3, 0x8e791935eedfac1d), RTUINT128_INIT_C(0x0db44f46f1a73e23, 0xd03d09d257059f8f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x07bfaf3911494a9f, 0xbe3c0f6397da0c8e)
    },
    { /* i=2775; 124 / 94 */
        RTUINT128_INIT_C(0x00f4689161b0661d, 0x70a3a6ba85b1c8e0), RTUINT128_INIT_C(0x000000000b801e5b, 0x0eba6e0bd8f1ed0f),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000154086a1), RTUINT128_INIT_C(0x000000000740ab81, 0x1c0828caf4b5d871)
    },
    { /* i=2776; 58 / 48 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00e2b7cfdc295403), RTUINT128_INIT_C(0x0000000000000000, 0x00007550476a1105),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000001ee), RTUINT128_INIT_C(0x0000000000000000, 0x000056e60d7c7c5d)
    },
    { /* i=2777; 90 / 49 */
        RTUINT128_INIT_C(0x000000000194b1c4, 0xd2365415e7952f9c), RTUINT128_INIT_C(0x0000000000000000, 0x00013523748a3aaa),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000014f216ec1d5), RTUINT128_INIT_C(0x0000000000000000, 0x0000b94e9b4c362a)
    },
    { /* i=2778; 32 / 16 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000079e66c5b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000f08),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000081c1a), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000058b)
    },
    { /* i=2779; 68 / 54 */
        RTUINT128_INIT_C(0x0000000000000008, 0x19c3e9e6f7746a5f), RTUINT128_INIT_C(0x0000000000000000, 0x00292beac1afa6bc),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000325e), RTUINT128_INIT_C(0x0000000000000000, 0x0011efdf8a647957)
    },
    { /* i=2780; 105 / 39 */
        RTUINT128_INIT_C(0x000001618623d2fb, 0xdfd1cb515d5f3926), RTUINT128_INIT_C(0x0000000000000000, 0x00000045dce5400f),
        RTUINT128_INIT_C(0x0000000000000005, 0x0f6ce6ab5999f124), RTUINT128_INIT_C(0x0000000000000000, 0x0000003cfbdd180a)
    },
    { /* i=2781; 62 / 23 */
        RTUINT128_INIT_C(0x0000000000000000, 0x13b8b81a895db696), RTUINT128_INIT_C(0x0000000000000000, 0x00000000003c4e8b),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000053b79c9a23), RTUINT128_INIT_C(0x0000000000000000, 0x00000000002b5b95)
    },
    { /* i=2782; 120 / 85 */
        RTUINT128_INIT_C(0x00ed2401cd9f9163, 0x2751cfe81a3104b6), RTUINT128_INIT_C(0x00000000001158a2, 0xb00d3a37596208b2),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000dabc7d2ee), RTUINT128_INIT_C(0x00000000000e10bd, 0xdd8ee112ed8ceb3a)
    },
    { /* i=2783; 117 / 73 */
        RTUINT128_INIT_C(0x001966f6e03542f8, 0x6db3d15c6f5c542f), RTUINT128_INIT_C(0x0000000000000170, 0x6a9fbf82aafcb9a6),
        RTUINT128_INIT_C(0x0000000000000000, 0x000011a6afe3ed67), RTUINT128_INIT_C(0x0000000000000060, 0xd72d02d8939cf465)
    },
    { /* i=2784; 52 / 90 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000810f1c462dc93), RTUINT128_INIT_C(0x0000000003179af0, 0x00ea088c91cca2db),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000810f1c462dc93)
    },
    { /* i=2785; 117 / 75 */
        RTUINT128_INIT_C(0x000e2fb66c9cdf4e, 0xfe9a32ea99a34167), RTUINT128_INIT_C(0x00000000000007df, 0x2b6f9261e5746504),
        RTUINT128_INIT_C(0x0000000000000000, 0x000001cd5c20a8cc), RTUINT128_INIT_C(0x000000000000041f, 0x7c54e3454e182237)
    },
    { /* i=2786; 116 / 112 */
        RTUINT128_INIT_C(0x000076eccdae354d, 0xf061099196a701f6), RTUINT128_INIT_C(0x000080411ff2d42c, 0xc618a7e51a75485f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000076eccdae354d, 0xf061099196a701f6)
    },
    { /* i=2787; 113 / 87 */
        RTUINT128_INIT_C(0x0001d9d37dd9af70, 0x88bcdaa193c9678d), RTUINT128_INIT_C(0x00000000000538b5, 0x5f53153d67f8145c),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000005abeb270), RTUINT128_INIT_C(0x000000000002cead, 0xb57e7c3224d0874d)
    },
    { /* i=2788; 127 / 11 */
        RTUINT128_INIT_C(0x70719dccdb3994a3, 0xca2489124a9cd5f3), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000068e),
        RTUINT128_INIT_C(0x0011279b95563b6f, 0x77e1d07b6f1c2a3c), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000ab)
    },
    { /* i=2789; 110 / 28 */
        RTUINT128_INIT_C(0x00000b64a63d60bc, 0x7a90cfebe7856995), RTUINT128_INIT_C(0x0000000000000000, 0x000000000cf46601),
        RTUINT128_INIT_C(0x000000000000e124, 0x7ae6e16dc4b97246), RTUINT128_INIT_C(0x0000000000000000, 0x000000000c8c134f)
    },
    { /* i=2790; 79 / 57 */
        RTUINT128_INIT_C(0x00000000000026cb, 0x7532c3e66bfce2d6), RTUINT128_INIT_C(0x0000000000000000, 0x01b7a8c494cf9726),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000001696c7), RTUINT128_INIT_C(0x0000000000000000, 0x01a69a0e1eca204c)
    },
    { /* i=2791; 119 / 83 */
        RTUINT128_INIT_C(0x00003bc83b131a6d, 0x1364ea1c93aa413c), RTUINT128_INIT_C(0x0000000000010b1f, 0xbabe5e8dd3fbee17),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000394ae930), RTUINT128_INIT_C(0x000000000000c56d, 0xe271babe9714adec)
    },
    { /* i=2792; 124 / 87 */
        RTUINT128_INIT_C(0x0e2279803ced71db, 0x465db2e2101a07d7), RTUINT128_INIT_C(0x0000000000316422, 0x768c17448cd9462c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000004942f80d2e), RTUINT128_INIT_C(0x0000000000121b62, 0x7b55904a65df2fef)
    },
    { /* i=2793; 123 / 57 */
        RTUINT128_INIT_C(0x07d10e5e0d7127a1, 0x61050767b537bf57), RTUINT128_INIT_C(0x0000000000000000, 0x000cbe3f3330f651),
        RTUINT128_INIT_C(0x000000000000009d, 0x07a8de97dfc2c1aa), RTUINT128_INIT_C(0x0000000000000000, 0x00011265949f1c8d)
    },
    { /* i=2794; 125 / 85 */
        RTUINT128_INIT_C(0x169d6eb945ad7906, 0x4863a490ed5d9147), RTUINT128_INIT_C(0x000000000019f7bc, 0xd12aafa4964144f4),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000def27e221e), RTUINT128_INIT_C(0x00000000000dbf57, 0xc469c06c0e7714af)
    },
    { /* i=2795; 83 / 24 */
        RTUINT128_INIT_C(0x000000000004c7ea, 0x617e92e72030e5bb), RTUINT128_INIT_C(0x0000000000000000, 0x000000000085540d),
        RTUINT128_INIT_C(0x0000000000000000, 0x092e019384fbb85a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000290129)
    },
    { /* i=2796; 58 / 29 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00be7a823382150f), RTUINT128_INIT_C(0x0000000000000000, 0x0000000006caed4f),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000001c0aae59), RTUINT128_INIT_C(0x0000000000000000, 0x000000000093e298)
    },
    { /* i=2797; 71 / 15 */
        RTUINT128_INIT_C(0x000000000000006b, 0x4e0af8dbc9860079), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000005bd1),
        RTUINT128_INIT_C(0x0000000000000000, 0x012b2f39706db6b9), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001070)
    },
    { /* i=2798; 114 / 66 */
        RTUINT128_INIT_C(0x000108327320822e, 0x1ccc80bfdc3efdde), RTUINT128_INIT_C(0x0000000000000002, 0x57af4c57bde6aec3),
        RTUINT128_INIT_C(0x0000000000000000, 0x000070c888efa2c9), RTUINT128_INIT_C(0x0000000000000002, 0x2a5f5a23077b60c3)
    },
    { /* i=2799; 93 / 65 */
        RTUINT128_INIT_C(0x000000000106416e, 0xa8f360ffc230feb0), RTUINT128_INIT_C(0x0000000000000001, 0x720051103725fcde),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000b573b0), RTUINT128_INIT_C(0x0000000000000000, 0xd3da5f37fe856c10)
    },
    { /* i=2800; 8 / 88 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000fa), RTUINT128_INIT_C(0x0000000000c0c1a0, 0xe591a8be1e7a29e8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000fa)
    },
    { /* i=2801; 120 / 14 */
        RTUINT128_INIT_C(0x00c133bcf2947475, 0xd41c5fc4533f2a91), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001f4e),
        RTUINT128_INIT_C(0x0000062bf25bb2b5, 0xb6758ecd54476727), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000003af)
    },
    { /* i=2802; 96 / 86 */
        RTUINT128_INIT_C(0x00000000bfa14b31, 0x7b6ddd400f431392), RTUINT128_INIT_C(0x0000000000276938, 0x69ee2e073a988891),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000004dc), RTUINT128_INIT_C(0x00000000001dfd0e, 0xba06321f520b72f6)
    },
    { /* i=2803; 47 / 40 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000052c8e5431bce), RTUINT128_INIT_C(0x0000000000000000, 0x000000bfb08f8cde),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000006e), RTUINT128_INIT_C(0x0000000000000000, 0x0000006b0794946a)
    },
    { /* i=2804; 116 / 64 */
        RTUINT128_INIT_C(0x00026ed05f95a6b8, 0xd34aec9bc300812e), RTUINT128_INIT_C(0x0000000000000000, 0x398d5e9bbb86b229),
        RTUINT128_INIT_C(0x0000000000000000, 0x000ad25c1f877b05), RTUINT128_INIT_C(0x0000000000000000, 0x2f16642077265361)
    },
    { /* i=2805; 122 / 107 */
        RTUINT128_INIT_C(0x02641572328ac538, 0xbfbe4858bcc0fd39), RTUINT128_INIT_C(0x0000013275fdbf5c, 0x8cceb1cd2d61e98b),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000001ff4c), RTUINT128_INIT_C(0x000000f1aa3c38ae, 0x5d78f1d8d28332f5)
    },
    { /* i=2806; 114 / 117 */
        RTUINT128_INIT_C(0x0003b8befd0e2afe, 0xa8a22b2bf1e250ba), RTUINT128_INIT_C(0x00118133c17693b3, 0x79b4003f42afa7c3),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0003b8befd0e2afe, 0xa8a22b2bf1e250ba)
    },
    { /* i=2807; 87 / 57 */
        RTUINT128_INIT_C(0x000000000028961a, 0x172abacba3fd037b), RTUINT128_INIT_C(0x0000000000000000, 0x0016b2100e510af4),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000001c9cda760), RTUINT128_INIT_C(0x0000000000000000, 0x001557fc0e0fbbfb)
    },
    { /* i=2808; 118 / 106 */
        RTUINT128_INIT_C(0x000f70d2a6a0227a, 0x1ab7fe36b2d44aeb), RTUINT128_INIT_C(0x000002577b3fd4a2, 0xc06581c1d04e4b42),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000697), RTUINT128_INIT_C(0x0000025574fde5f8, 0x3dcdea02fee25afd)
    },
    { /* i=2809; 113 / 24 */
        RTUINT128_INIT_C(0x0001c5b1cd27ef8d, 0x7bab6e7440a2bd19), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000d52805),
        RTUINT128_INIT_C(0x000000000220e2b3, 0x30b00270cc07a859), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000218b5c)
    },
    { /* i=2810; 71 / 53 */
        RTUINT128_INIT_C(0x000000000000007a, 0x4ceeea73bd7a2cf2), RTUINT128_INIT_C(0x0000000000000000, 0x0007925725027d69),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000102706), RTUINT128_INIT_C(0x0000000000000000, 0x0003e59da7c03d7c)
    },
    { /* i=2811; 90 / 15 */
        RTUINT128_INIT_C(0x0000000003ea4a0d, 0x0e2df38cdd2959d4), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000285d),
        RTUINT128_INIT_C(0x00000000000018d4, 0xeae4a0c9db01efbb), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000ae5)
    },
    { /* i=2812; 126 / 52 */
        RTUINT128_INIT_C(0x16d5bd8c1437eac6, 0xf38d85a5fe594046), RTUINT128_INIT_C(0x0000000000000000, 0x00011884b766f1fd),
        RTUINT128_INIT_C(0x00000000000014d6, 0xccac72eea64cf9d8), RTUINT128_INIT_C(0x0000000000000000, 0x0000e8983901fdce)
    },
    { /* i=2813; 117 / 105 */
        RTUINT128_INIT_C(0x0006358c0445a512, 0xb81edb1ca9c56b70), RTUINT128_INIT_C(0x00000013571acc56, 0x20980d18c3588752),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000005230), RTUINT128_INIT_C(0x0000000519cbbe7b, 0xe76a77e5add3c810)
    },
    { /* i=2814; 126 / 112 */
        RTUINT128_INIT_C(0x1a50a3a0060a80b2, 0xb77ef636eeceb5bd), RTUINT128_INIT_C(0x00006fa5257bc83e, 0x20344f8701c5580f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000003c56), RTUINT128_INIT_C(0x00006d5c6b86ac47, 0xa3489a7215df9cb3)
    },
    { /* i=2815; 124 / 50 */
        RTUINT128_INIT_C(0x01fd4c4b62e5e142, 0xcdac952f1cb14b38), RTUINT128_INIT_C(0x0000000000000000, 0x000293eef419b855),
        RTUINT128_INIT_C(0x00000000000000c5, 0x90da72f22c18ba68), RTUINT128_INIT_C(0x0000000000000000, 0x0001764f5e58a6b0)
    },
    { /* i=2816; 57 / 117 */
        RTUINT128_INIT_C(0x0000000000000000, 0x013dd03028d98d3e), RTUINT128_INIT_C(0x00127f422cdb6210, 0xbe56b804fe13e1c1),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x013dd03028d98d3e)
    },
    { /* i=2817; 128 / 113 */
        RTUINT128_INIT_C(0x4ef945927f7b766e, 0x072cba8fcd24d150), RTUINT128_INIT_C(0x0000da1533790d0e, 0x67ae4ea73c8bfd51),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000005cb4), RTUINT128_INIT_C(0x0000502acdad1b0a, 0x7c595336ebad985c)
    },
    { /* i=2818; 79 / 68 */
        RTUINT128_INIT_C(0x00000000000012df, 0x8dfbc818f65f02d4), RTUINT128_INIT_C(0x0000000000000005, 0xf99bc5d337910d65),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000328), RTUINT128_INIT_C(0x0000000000000003, 0xba536571948cbc0c)
    },
    { /* i=2819; 115 / 113 */
        RTUINT128_INIT_C(0x00019651e6298a95, 0x8cd70a00e8d44dba), RTUINT128_INIT_C(0x000174ac7b7428c4, 0xccfd9ec3daf0697b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x000021a56ab561d0, 0xbfd96b3d0de3e43f)
    },
    { /* i=2820; 68 / 66 */
        RTUINT128_INIT_C(0x0000000000000005, 0x28622f4310f96985), RTUINT128_INIT_C(0x0000000000000001, 0xb0b7ec0da2a5c25d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003), RTUINT128_INIT_C(0x0000000000000000, 0x163a6b1a2908226e)
    },
    { /* i=2821; 125 / 126 */
        RTUINT128_INIT_C(0x0ce0c09c2d18ef51, 0xc7b9f2795083d5e5), RTUINT128_INIT_C(0x31ca1c9ae6f76462, 0x0394f5ccd1eef896),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0ce0c09c2d18ef51, 0xc7b9f2795083d5e5)
    },
    { /* i=2822; 122 / 104 */
        RTUINT128_INIT_C(0x027c1fc161084a39, 0xfdd8b648c178e24c), RTUINT128_INIT_C(0x00000056791c7532, 0x039cb27afa981473),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000075b38), RTUINT128_INIT_C(0x0000000290c7c6b7, 0x9ec31a2551ca8824)
    },
    { /* i=2823; 22 / 9 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000e332f), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000001ed),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000075f), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000013c)
    },
    { /* i=2824; 118 / 101 */
        RTUINT128_INIT_C(0x002e03031302ff35, 0x86fdb4453668d4e0), RTUINT128_INIT_C(0x0000001b2e0856da, 0x927bac9aa7f2f6d0),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000001b15f), RTUINT128_INIT_C(0x00000010e3031255, 0xfc2710ceefc96db0)
    },
    { /* i=2825; 51 / 32 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0002a174afee0ed5), RTUINT128_INIT_C(0x0000000000000000, 0x000000005f5e9873),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000070fc1), RTUINT128_INIT_C(0x0000000000000000, 0x0000000013896322)
    },
    { /* i=2826; 114 / 113 */
        RTUINT128_INIT_C(0x00005239aa52c78b, 0x9038f733dce3f8e4), RTUINT128_INIT_C(0x0000e5ed2fc18a4c, 0x63541484a2ef0368),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00005239aa52c78b, 0x9038f733dce3f8e4)
    },
    { /* i=2827; 117 / 103 */
        RTUINT128_INIT_C(0x00190728ae4f88bf, 0x6227fb5b49bd0e70), RTUINT128_INIT_C(0x0000003c5e687b75, 0x110d13550924b9df),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000006a22), RTUINT128_INIT_C(0x0000000ce150aa23, 0xb46a3446dde608d2)
    },
    { /* i=2828; 119 / 17 */
        RTUINT128_INIT_C(0x0048dee9d9359272, 0xfac1a6b8b6828a45), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000016229),
        RTUINT128_INIT_C(0x00000034ac75514c, 0x54c5b706c0d30aa3), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000702a)
    },
    { /* i=2829; 114 / 110 */
        RTUINT128_INIT_C(0x0003782b3612987a, 0x0a8ee9022cc8f0ab), RTUINT128_INIT_C(0x0000111cb5ac7e96, 0xfe66265d874c77a3),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000033), RTUINT128_INIT_C(0x00000f7304b56065, 0x5c354460388d1b32)
    },
    { /* i=2830; 65 / 63 */
        RTUINT128_INIT_C(0x0000000000000001, 0xa4c2fbeade2a524e), RTUINT128_INIT_C(0x0000000000000000, 0x47301694db539557),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000005), RTUINT128_INIT_C(0x0000000000000000, 0x40d28b029588679b)
    },
    { /* i=2831; 120 / 102 */
        RTUINT128_INIT_C(0x004619f27905ef5c, 0x1412c2d9776fbdd5), RTUINT128_INIT_C(0x00000038cceffaea, 0x113fd93cc1cb8e7a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000013bf2), RTUINT128_INIT_C(0x00000015746cbade, 0x3569a4f4ccb2f081)
    },
    { /* i=2832; 82 / 49 */
        RTUINT128_INIT_C(0x000000000001a214, 0x673231915d7250cb), RTUINT128_INIT_C(0x0000000000000000, 0x0000d049970232d4),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000201d9777a), RTUINT128_INIT_C(0x0000000000000000, 0x0000509577118bc3)
    },
    { /* i=2833; 84 / 114 */
        RTUINT128_INIT_C(0x00000000000da601, 0x0cabc466fcc77b4b), RTUINT128_INIT_C(0x00038720926b78ac, 0xdc3bf9812fede986),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00000000000da601, 0x0cabc466fcc77b4b)
    },
    { /* i=2834; 99 / 83 */
        RTUINT128_INIT_C(0x000000026c761155, 0x741dae2f97c2c89a), RTUINT128_INIT_C(0x000000000007a16f, 0x4ba7019cdd989ef4),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000514f), RTUINT128_INIT_C(0x000000000007090d, 0x44118ca9eb5e874e)
    },
    { /* i=2835; 60 / 37 */
        RTUINT128_INIT_C(0x0000000000000000, 0x032e80f12c7e951c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000672c225e3),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000007e503c), RTUINT128_INIT_C(0x0000000000000000, 0x00000002f56cc3e8)
    },
    { /* i=2836; 114 / 73 */
        RTUINT128_INIT_C(0x000268f9f3d06ef8, 0xc5dc75a3d0842ebe), RTUINT128_INIT_C(0x0000000000000150, 0x9444fe10c2637ae8),
        RTUINT128_INIT_C(0x0000000000000000, 0x000001d544b2012f), RTUINT128_INIT_C(0x0000000000000070, 0x0ca9fef4a775b626)
    },
    { /* i=2837; 89 / 22 */
        RTUINT128_INIT_C(0x00000000009e8575, 0x9730c66598e6c71b), RTUINT128_INIT_C(0x0000000000000000, 0x00000000003ea976),
        RTUINT128_INIT_C(0x0000000000000002, 0x87a00a035a9d08ed), RTUINT128_INIT_C(0x0000000000000000, 0x00000000003a34dd)
    },
    { /* i=2838; 90 / 86 */
        RTUINT128_INIT_C(0x000000000321162a, 0x17c990e68f199c59), RTUINT128_INIT_C(0x0000000000353353, 0xe2e0a17983570777),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000f), RTUINT128_INIT_C(0x000000000003143f, 0xcca01ac7dd002c60)
    },
    { /* i=2839; 69 / 62 */
        RTUINT128_INIT_C(0x000000000000000d, 0xb352225db6ba4b07), RTUINT128_INIT_C(0x0000000000000000, 0x0949b5351bd7d2c7),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000179), RTUINT128_INIT_C(0x0000000000000000, 0x05c64727b5e4e3f8)
    },
    { /* i=2840; 123 / 72 */
        RTUINT128_INIT_C(0x078042a731a65d7b, 0x6455a78b3382637a), RTUINT128_INIT_C(0x0000000000000032, 0x6df3181d1849b274),
        RTUINT128_INIT_C(0x0000000000000000, 0x002613ffe4b4131f), RTUINT128_INIT_C(0x0000000000000017, 0x04257eeb00c72b6e)
    },
    { /* i=2841; 59 / 35 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0672897dfa78b3bc), RTUINT128_INIT_C(0x0000000000000000, 0x00000003ad3499e8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000001c0eea8), RTUINT128_INIT_C(0x0000000000000000, 0x0000000012de037c)
    },
    { /* i=2842; 127 / 66 */
        RTUINT128_INIT_C(0x5ea341372b7196fb, 0x794950a5bf99cb01), RTUINT128_INIT_C(0x0000000000000003, 0x4528bcc862185e6b),
        RTUINT128_INIT_C(0x0000000000000000, 0x1cf0999fe85244ad), RTUINT128_INIT_C(0x0000000000000003, 0x23a66a58c5c790b2)
    },
    { /* i=2843; 48 / 14 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000008767ff00601), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000002fce),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000002d51df9e), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000012dd)
    },
    { /* i=2844; 116 / 126 */
        RTUINT128_INIT_C(0x000918492bdcc11c, 0x4d71b32a883328c7), RTUINT128_INIT_C(0x27f2f383983bfb31, 0xeabbda8b0666c64e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000918492bdcc11c, 0x4d71b32a883328c7)
    },
    { /* i=2845; 124 / 71 */
        RTUINT128_INIT_C(0x0e1a43458fcc794d, 0xabea3ecfd0bd8167), RTUINT128_INIT_C(0x000000000000006c, 0x86c8ea46bae67a4e),
        RTUINT128_INIT_C(0x0000000000000000, 0x00214424ba71dbca), RTUINT128_INIT_C(0x0000000000000029, 0x5eff018c83d245db)
    },
    { /* i=2846; 125 / 68 */
        RTUINT128_INIT_C(0x0b746bde177bac4c, 0x506d57337b362864), RTUINT128_INIT_C(0x0000000000000005, 0xdd52f3cf19130e33),
        RTUINT128_INIT_C(0x0000000000000000, 0x01f4067448edb4cb), RTUINT128_INIT_C(0x0000000000000003, 0xfbdd309ab5e709f3)
    },
    { /* i=2847; 70 / 32 */
        RTUINT128_INIT_C(0x000000000000001c, 0x92891c6a2b7339f4), RTUINT128_INIT_C(0x0000000000000000, 0x00000000ec5c0a69),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000001ef2579adf), RTUINT128_INIT_C(0x0000000000000000, 0x000000001d53fe7d)
    },
    { /* i=2848; 88 / 96 */
        RTUINT128_INIT_C(0x000000000045a602, 0x8cfe0bc8064c6738), RTUINT128_INIT_C(0x00000000127df48d, 0xc5bf8668d870702c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000000000045a602, 0x8cfe0bc8064c6738)
    },
    { /* i=2849; 113 / 33 */
        RTUINT128_INIT_C(0x00018ab17f42ca17, 0xc23369efe4fc63ea), RTUINT128_INIT_C(0x0000000000000000, 0x000000018b5b62f2),
        RTUINT128_INIT_C(0x000000000000ff91, 0xfe6f629189aeb71e), RTUINT128_INIT_C(0x0000000000000000, 0x000000007a0fcd8e)
    },
    { /* i=2850; 60 / 23 */
        RTUINT128_INIT_C(0x0000000000000000, 0x03d0b893bea252f7), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000786434),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000081ce5a281), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000aecc3)
    },
    { /* i=2851; 125 / 28 */
        RTUINT128_INIT_C(0x0e4e4573fe845824, 0xb8cd7026fe533879), RTUINT128_INIT_C(0x0000000000000000, 0x000000000f69a746),
        RTUINT128_INIT_C(0x00000000ed9d1de2, 0x7a5993d04beed8b3), RTUINT128_INIT_C(0x0000000000000000, 0x000000000d3c3287)
    },
    { /* i=2852; 115 / 124 */
        RTUINT128_INIT_C(0x00024fe3ae8d69f0, 0x0fb2085c216fe445), RTUINT128_INIT_C(0x011e9d1198419dcf, 0x4eeef3f4e9bb6669),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00024fe3ae8d69f0, 0x0fb2085c216fe445)
    },
    { /* i=2853; 118 / 80 */
        RTUINT128_INIT_C(0x002cb823905b12ee, 0x56687b48bee8c807), RTUINT128_INIT_C(0x000000000000933e, 0x2989b72fad5ced27),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000004dc00441bc), RTUINT128_INIT_C(0x0000000000001fda, 0x1a0b1d34e1d7b863)
    },
    { /* i=2854; 120 / 115 */
        RTUINT128_INIT_C(0x007e1d0b8f262e5a, 0x73f8a90263d9e83f), RTUINT128_INIT_C(0x00003b3590fb19fe, 0xf6897bd3226c0184),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000221), RTUINT128_INIT_C(0x00001001e893d68f, 0x99480c861beaae3b)
    },
    { /* i=2855; 117 / 59 */
        RTUINT128_INIT_C(0x00093320904c9597, 0x104d21ab03520940), RTUINT128_INIT_C(0x0000000000000000, 0x0058477ef1d7c997),
        RTUINT128_INIT_C(0x0000000000000000, 0x1aad9ab96be2bbbe), RTUINT128_INIT_C(0x0000000000000000, 0x002720e9d09b1e2e)
    },
    { /* i=2856; 64 / 42 */
        RTUINT128_INIT_C(0x0000000000000000, 0x8e262080a95c01db), RTUINT128_INIT_C(0x0000000000000000, 0x0000012fe2678050),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000077bff9), RTUINT128_INIT_C(0x0000000000000000, 0x000000e594c4840b)
    },
    { /* i=2857; 123 / 104 */
        RTUINT128_INIT_C(0x0039327c24617e95, 0x05fc1e05282e0504), RTUINT128_INIT_C(0x0000005a5aa62efe, 0x6a2a21fa50757497),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000a20e), RTUINT128_INIT_C(0x0000002e058ded7c, 0x8e2ddb6a6dfa16c2)
    },
    { /* i=2858; 58 / 14 */
        RTUINT128_INIT_C(0x0000000000000000, 0x02dc5974c9eee0f6), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000020dd),
        RTUINT128_INIT_C(0x0000000000000000, 0x00001648e43e0330), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000002086)
    },
    { /* i=2859; 120 / 55 */
        RTUINT128_INIT_C(0x0090196ad388c48e, 0x456909b65fee4b7c), RTUINT128_INIT_C(0x0000000000000000, 0x002a1cf5b58ffffa),
        RTUINT128_INIT_C(0x0000000000000003, 0x6bf5ca54d76b1315), RTUINT128_INIT_C(0x0000000000000000, 0x002257e1d7a0bdfa)
    },
    { /* i=2860; 124 / 72 */
        RTUINT128_INIT_C(0x0194f887a556d3a7, 0x55b9177dc70d4ad5), RTUINT128_INIT_C(0x000000000000008e, 0x885229cadcb30268),
        RTUINT128_INIT_C(0x0000000000000000, 0x0002d75c516829e8), RTUINT128_INIT_C(0x0000000000000064, 0xcc29387137307495)
    },
    { /* i=2861; 23 / 14 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000477af8), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000003af3),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000136), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000018b6)
    },
    { /* i=2862; 122 / 43 */
        RTUINT128_INIT_C(0x03a723f02740447f, 0x7b43d55af92542ea), RTUINT128_INIT_C(0x0000000000000000, 0x0000007fe17c1d2a),
        RTUINT128_INIT_C(0x0000000000075006, 0x2a9c51759d22e684), RTUINT128_INIT_C(0x0000000000000000, 0x00000044915e7d42)
    },
    { /* i=2863; 34 / 28 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000397fbb8c3), RTUINT128_INIT_C(0x0000000000000000, 0x000000000237b457),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000019e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000001e61411)
    },
    { /* i=2864; 45 / 11 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00001a6a86834852), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000777),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000389eaa288), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000031a)
    },
    { /* i=2865; 72 / 88 */
        RTUINT128_INIT_C(0x00000000000000ed, 0xd263f65a7b1b2e32), RTUINT128_INIT_C(0x0000000000d8bc00, 0x7e00ea0570f0d519),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00000000000000ed, 0xd263f65a7b1b2e32)
    },
    { /* i=2866; 99 / 44 */
        RTUINT128_INIT_C(0x00000000f52200b1, 0x3be3d26d087476f0), RTUINT128_INIT_C(0x0000000000000000, 0x0000096565815fff),
        RTUINT128_INIT_C(0x0000000000000000, 0x001a16be2ae4b83a), RTUINT128_INIT_C(0x0000000000000000, 0x00000643b7096f2a)
    },
    { /* i=2867; 126 / 40 */
        RTUINT128_INIT_C(0x1685818d82571ee2, 0x6d4e0781b1fde3c6), RTUINT128_INIT_C(0x0000000000000000, 0x00000064870b7966),
        RTUINT128_INIT_C(0x0000000000395a3e, 0x71ee42d63226bc5a), RTUINT128_INIT_C(0x0000000000000000, 0x0000004fd9aa4dea)
    },
    { /* i=2868; 124 / 69 */
        RTUINT128_INIT_C(0x099fe16a2bdb7c9d, 0xe9e914a7a7a88d99), RTUINT128_INIT_C(0x0000000000000019, 0xa87a9ca15e9278ab),
        RTUINT128_INIT_C(0x0000000000000000, 0x006006fe49d1490f), RTUINT128_INIT_C(0x000000000000000d, 0xac122d94120fb894)
    },
    { /* i=2869; 127 / 60 */
        RTUINT128_INIT_C(0x0d5389bb2c5b573b, 0x983d926325dd3f0c), RTUINT128_INIT_C(0x0000000000000000, 0x06c69fd8e30ca062),
        RTUINT128_INIT_C(0x0000000000000001, 0xf77b9f91c6613070), RTUINT128_INIT_C(0x0000000000000000, 0x03bb7796e122b42c)
    },
    { /* i=2870; 64 / 62 */
        RTUINT128_INIT_C(0x0000000000000000, 0x10dd9dc685ebab68), RTUINT128_INIT_C(0x0000000000000000, 0x3fc4b0316772518a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x10dd9dc685ebab68)
    },
    { /* i=2871; 106 / 60 */
        RTUINT128_INIT_C(0x00000261db87559b, 0xc74d217d1234ac42), RTUINT128_INIT_C(0x0000000000000000, 0x047a064e6bd26f71),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000883b032d29cb), RTUINT128_INIT_C(0x0000000000000000, 0x03c76fb1f4a034a7)
    },
    { /* i=2872; 119 / 47 */
        RTUINT128_INIT_C(0x0051c57ffb722b29, 0x0fedc90f68c7cd0c), RTUINT128_INIT_C(0x0000000000000000, 0x0000148d5b0b1656),
        RTUINT128_INIT_C(0x00000000000003fa, 0x8de14a682a2ddb33), RTUINT128_INIT_C(0x0000000000000000, 0x00000276c058c7ea)
    },
    { /* i=2873; 90 / 18 */
        RTUINT128_INIT_C(0x0000000001b5b290, 0x75e3cb161cfafa0b), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000b6ae),
        RTUINT128_INIT_C(0x0000000000000265, 0x5f2cb08c5f31cef2), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000458f)
    },
    { /* i=2874; 125 / 68 */
        RTUINT128_INIT_C(0x0aabf181e47da80c, 0x6dee76980529e362), RTUINT128_INIT_C(0x000000000000000c, 0xb2c5f1c58004fcbf),
        RTUINT128_INIT_C(0x0000000000000000, 0x00d724532938b8e3), RTUINT128_INIT_C(0x000000000000000c, 0xa45c84f50a4c7e05)
    },
    { /* i=2875; 121 / 107 */
        RTUINT128_INIT_C(0x00e7626a4cabf827, 0x49e8f5e7ed6f09a1), RTUINT128_INIT_C(0x0000040f842a8d2c, 0x61a4471a5d81c356),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000038fb), RTUINT128_INIT_C(0x0000024a6811d847, 0x9e497a99dc79b44f)
    },
    { /* i=2876; 122 / 36 */
        RTUINT128_INIT_C(0x00fd1579eded940e, 0x07c8bfcff6566487), RTUINT128_INIT_C(0x0000000000000000, 0x00000003133c5d4a),
        RTUINT128_INIT_C(0x0000000000524cca, 0x4efcde5eba9e314c), RTUINT128_INIT_C(0x0000000000000000, 0x000000025ae3888f)
    },
    { /* i=2877; 28 / 21 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000fb234eb), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000acc5e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000174), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000013c53)
    },
    { /* i=2878; 115 / 3 */
        RTUINT128_INIT_C(0x0003ebb8d232029c, 0x7719db0a5b3819b7), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000005),
        RTUINT128_INIT_C(0x0000c8be907066ec, 0x17d1f89babd80524), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003)
    },
    { /* i=2879; 124 / 89 */
        RTUINT128_INIT_C(0x0971b4cb894e51e4, 0xb01bc99e7de99569), RTUINT128_INIT_C(0x000000000179ead6, 0xf22a3022f180ac56),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000665bf18f5), RTUINT128_INIT_C(0x0000000000b5f831, 0x9cda7486cb72971b)
    },
    { /* i=2880; 9 / 30 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000014a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000020921f54),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000014a)
    },
    { /* i=2881; 118 / 51 */
        RTUINT128_INIT_C(0x001d9f259899cc4f, 0x5a5faa933d0ec84f), RTUINT128_INIT_C(0x0000000000000000, 0x000290c1f1146377),
        RTUINT128_INIT_C(0x000000000000000b, 0x8bdcfca5cdf309b5), RTUINT128_INIT_C(0x0000000000000000, 0x000216465d30462c)
    },
    { /* i=2882; 127 / 119 */
        RTUINT128_INIT_C(0x44de13f8e51908ad, 0x245d2ad3eb0720f4), RTUINT128_INIT_C(0x001746046bcb5f2b, 0x5df3195a091d5ba5),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000002f5), RTUINT128_INIT_C(0x000c08e624b89d70, 0x54833396f737220b)
    },
    { /* i=2883; 125 / 102 */
        RTUINT128_INIT_C(0x0f0d22995bdfdd43, 0xfd41f7ea59f3ded1), RTUINT128_INIT_C(0x0000002c84d1ed3b, 0x1d1c378f0c4de9ad),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000568cf9), RTUINT128_INIT_C(0x00000023ac18035e, 0x945f90e04642f98c)
    },
    { /* i=2884; 107 / 39 */
        RTUINT128_INIT_C(0x00000158e4a29865, 0x566645fd5b14f3ad), RTUINT128_INIT_C(0x0000000000000000, 0x00000074936b10d3),
        RTUINT128_INIT_C(0x0000000000000002, 0xf562318d845d296a), RTUINT128_INIT_C(0x0000000000000000, 0x000000534267314f)
    },
    { /* i=2885; 107 / 52 */
        RTUINT128_INIT_C(0x000005cec29591a8, 0xf081c06f80057150), RTUINT128_INIT_C(0x0000000000000000, 0x000a15e0cf3550b8),
        RTUINT128_INIT_C(0x0000000000000000, 0x00936a89f891d673), RTUINT128_INIT_C(0x0000000000000000, 0x0002995ee1605ea8)
    },
    { /* i=2886; 14 / 7 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000c21), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000002d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000045), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=2887; 85 / 73 */
        RTUINT128_INIT_C(0x000000000006e36a, 0x28ba0d4e1c8aa6eb), RTUINT128_INIT_C(0x0000000000000086, 0xd016cd67869605f2),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000d14), RTUINT128_INIT_C(0x0000000000000050, 0xbe83bf61fa84e603)
    },
    { /* i=2888; 65 / 32 */
        RTUINT128_INIT_C(0x0000000000000000, 0x1cc95bd1111dd357), RTUINT128_INIT_C(0x0000000000000000, 0x00000000e69def4b),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000001ff47956), RTUINT128_INIT_C(0x0000000000000000, 0x00000000c978fd25)
    },
    { /* i=2889; 125 / 100 */
        RTUINT128_INIT_C(0x08fa11e9e344b787, 0x907122ff998bb7ad), RTUINT128_INIT_C(0x0000000e5e71bde9, 0x70ee9507981e2bc7),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000009feeef), RTUINT128_INIT_C(0x0000000d04883f6a, 0xc36f76bf5814d6e4)
    },
    { /* i=2890; 19 / 5 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000070757), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000f),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000077f4), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000b)
    },
    { /* i=2891; 119 / 68 */
        RTUINT128_INIT_C(0x00213bcd7a2ea9d4, 0xf02c58f91182e504), RTUINT128_INIT_C(0x0000000000000000, 0x9b6b529ed1842d23),
        RTUINT128_INIT_C(0x0000000000000000, 0x0036bdb196aef0a8), RTUINT128_INIT_C(0x0000000000000000, 0x267b55d778aa760c)
    },
    { /* i=2892; 124 / 123 */
        RTUINT128_INIT_C(0x02345da052b6229d, 0x359d364aa1b7eb66), RTUINT128_INIT_C(0x01a6f650e64f566b, 0x1dea07fa586eea2a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x008d674f6c66cc32, 0x17b32e504949013c)
    },
    { /* i=2893; 93 / 52 */
        RTUINT128_INIT_C(0x000000001f8cde89, 0xbce3dfe12751a511), RTUINT128_INIT_C(0x0000000000000000, 0x000b619deee0d2d0),
        RTUINT128_INIT_C(0x0000000000000000, 0x000002c5a90fa16e), RTUINT128_INIT_C(0x0000000000000000, 0x0000566173f23fb1)
    },
    { /* i=2894; 122 / 40 */
        RTUINT128_INIT_C(0x01f06c38b0d4b079, 0xfdb992ea20273d9d), RTUINT128_INIT_C(0x0000000000000000, 0x0000004c9ad6672c),
        RTUINT128_INIT_C(0x0000000000067af5, 0x4fe8ca2b9c285929), RTUINT128_INIT_C(0x0000000000000000, 0x0000000ddb126b91)
    },
    { /* i=2895; 122 / 30 */
        RTUINT128_INIT_C(0x028afdaa5e8d13ce, 0x66112100711f0834), RTUINT128_INIT_C(0x0000000000000000, 0x000000001acc2955),
        RTUINT128_INIT_C(0x00000000184affc9, 0x778642c4f4a232f2), RTUINT128_INIT_C(0x0000000000000000, 0x0000000010435bda)
    },
    { /* i=2896; 80 / 90 */
        RTUINT128_INIT_C(0x000000000000f419, 0xed20c6474d2a1b7b), RTUINT128_INIT_C(0x0000000001172d2b, 0x04771952458a2692),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000000000000f419, 0xed20c6474d2a1b7b)
    },
    { /* i=2897; 106 / 4 */
        RTUINT128_INIT_C(0x0000029a778ffab7, 0xb089c4734c1ff0d4), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000f),
        RTUINT128_INIT_C(0x0000002c6e5eee94, 0xc780a6b25a688785), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000009)
    },
    { /* i=2898; 4 / 3 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000004), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000004),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=2899; 128 / 90 */
        RTUINT128_INIT_C(0x90f648d34d0d50ac, 0xa254c622f71d13ab), RTUINT128_INIT_C(0x00000000009334d3, 0x30c87e00dcf691e3),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000fc18d79cb7), RTUINT128_INIT_C(0x0000000000550eef, 0x2c11e0a8f44f7666)
    },
    { /* i=2900; 88 / 85 */
        RTUINT128_INIT_C(0x0000000000cdde22, 0xcd1be0fe9af57fb8), RTUINT128_INIT_C(0x00000000000daa98, 0x17c987ebc4ffc155),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000f), RTUINT128_INIT_C(0x000000000000df39, 0x684cea2e0ff92bbd)
    },
    { /* i=2901; 119 / 62 */
        RTUINT128_INIT_C(0x00049a3c4785e753, 0x76c9f33d0b4707fb), RTUINT128_INIT_C(0x0000000000000000, 0x33a9917326a22e45),
        RTUINT128_INIT_C(0x0000000000000000, 0x0016ce739ba80fff), RTUINT128_INIT_C(0x0000000000000000, 0x0f6276d4eabce640)
    },
    { /* i=2902; 114 / 63 */
        RTUINT128_INIT_C(0x0002c76ed7d411ff, 0xf6a215625cac75d5), RTUINT128_INIT_C(0x0000000000000000, 0x1d1dcd8eb72978f3),
        RTUINT128_INIT_C(0x0000000000000000, 0x00186f2016d0ed2a), RTUINT128_INIT_C(0x0000000000000000, 0x19565eefc375a6f7)
    },
    { /* i=2903; 73 / 64 */
        RTUINT128_INIT_C(0x0000000000000130, 0xb8d57d4a626a00f2), RTUINT128_INIT_C(0x0000000000000000, 0xd2c725df9a98b1f2),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000172), RTUINT128_INIT_C(0x0000000000000000, 0x1500c01cf1b8d12e)
    },
    { /* i=2904; 124 / 60 */
        RTUINT128_INIT_C(0x009654a284044b09, 0xfb8f2f31dcce02a5), RTUINT128_INIT_C(0x0000000000000000, 0x03421162f9c079c4),
        RTUINT128_INIT_C(0x0000000000000000, 0x2e2411469d3a3fd1), RTUINT128_INIT_C(0x0000000000000000, 0x0278b20cce4b5da1)
    },
    { /* i=2905; 98 / 90 */
        RTUINT128_INIT_C(0x0000000363e9119c, 0x036ceee5f5f6cec3), RTUINT128_INIT_C(0x0000000003c146a2, 0x7807958d6e77ba5f),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000e7), RTUINT128_INIT_C(0x0000000000825501, 0xb494fc4747eda30a)
    },
    { /* i=2906; 118 / 65 */
        RTUINT128_INIT_C(0x0005f89491c03109, 0x43da6736a73063ff), RTUINT128_INIT_C(0x0000000000000001, 0x38feab3ac1faea86),
        RTUINT128_INIT_C(0x0000000000000000, 0x0004e23bc375a5a1), RTUINT128_INIT_C(0x0000000000000000, 0x61c0b708adfc87b9)
    },
    { /* i=2907; 116 / 38 */
        RTUINT128_INIT_C(0x000ddfa7d3093e9f, 0x73d4888715e57279), RTUINT128_INIT_C(0x0000000000000000, 0x0000002af320c5c9),
        RTUINT128_INIT_C(0x00000000000052b1, 0x7e85458d893b34be), RTUINT128_INIT_C(0x0000000000000000, 0x00000028d512d34b)
    },
    { /* i=2908; 127 / 109 */
        RTUINT128_INIT_C(0x6f4e0d57b9666d89, 0x8d5ab5c3f133024b), RTUINT128_INIT_C(0x00001a7cc64f2ace, 0xb788ee5ecbf5a53c),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000433c2), RTUINT128_INIT_C(0x0000060b00a5f02e, 0x769dff74dc30d6d3)
    },
    { /* i=2909; 79 / 20 */
        RTUINT128_INIT_C(0x00000000000061df, 0x6b369e282229c34c), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000e69e7),
        RTUINT128_INIT_C(0x0000000000000000, 0x06ca4ee1148b86b7), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000252b)
    },
    { /* i=2910; 51 / 39 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0003f3c55b58c7a9), RTUINT128_INIT_C(0x0000000000000000, 0x0000001335704080),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000034ac), RTUINT128_INIT_C(0x0000000000000000, 0x00000002a6d371a9)
    },
    { /* i=2911; 117 / 39 */
        RTUINT128_INIT_C(0x0008a0f89830a8c4, 0xb8cb4dd2065238d0), RTUINT128_INIT_C(0x0000000000000000, 0x0000004bc4b5f673),
        RTUINT128_INIT_C(0x0000000000001d27, 0x7d0f35160c009752), RTUINT128_INIT_C(0x0000000000000000, 0x000000164bab72fa)
    },
    { /* i=2912; 38 / 90 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000fb036caf0), RTUINT128_INIT_C(0x0000000002854fe4, 0xb271d7088c78d812),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000fb036caf0)
    },
    { /* i=2913; 126 / 25 */
        RTUINT128_INIT_C(0x3d15ec3569813ecf, 0xa292ab7321722280), RTUINT128_INIT_C(0x0000000000000000, 0x00000000010727ea),
        RTUINT128_INIT_C(0x0000003b6caf8897, 0x1d903bff9aa8a399), RTUINT128_INIT_C(0x0000000000000000, 0x00000000003149a6)
    },
    { /* i=2914; 115 / 109 */
        RTUINT128_INIT_C(0x000560ecfb30abcb, 0xbeadc73222afdcc2), RTUINT128_INIT_C(0x00001f6216398a67, 0xfca238af4d7ce587),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000002b), RTUINT128_INIT_C(0x00001b733f866c54, 0x4f6e41c01eb54f15)
    },
    { /* i=2915; 117 / 16 */
        RTUINT128_INIT_C(0x0010ea330de6303f, 0x9cfec72982211dbf), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000a491),
        RTUINT128_INIT_C(0x0000001a501243fc, 0x613f44ee6a5649c3), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000006a4c)
    },
    { /* i=2916; 121 / 115 */
        RTUINT128_INIT_C(0x005d40b9439855d6, 0x500169e7972bac12), RTUINT128_INIT_C(0x00010dae2ea0c2d8, 0xed97dd94b5322e32),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000058), RTUINT128_INIT_C(0x00008cd93c555b44, 0xa3cd3ec94debcae2)
    },
    { /* i=2917; 118 / 66 */
        RTUINT128_INIT_C(0x003eac2cfe063f05, 0x028a322da4833a75), RTUINT128_INIT_C(0x0000000000000000, 0x78d81e8c20cb8b9f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0084c47627c0dfc1), RTUINT128_INIT_C(0x0000000000000000, 0x703367bfac2f7696)
    },
    { /* i=2918; 116 / 113 */
        RTUINT128_INIT_C(0x00071aebc727cae6, 0x675ecd7e349a44c8), RTUINT128_INIT_C(0x0000944c0fa04619, 0x2b4682d5eb94f89b),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000c), RTUINT128_INIT_C(0x0000275b0ba481b8, 0x6010ab77299e9d84)
    },
    { /* i=2919; 109 / 52 */
        RTUINT128_INIT_C(0x00000ef5015d7d71, 0x52bed4ad8c7f8c33), RTUINT128_INIT_C(0x0000000000000000, 0x00097e47d48b78ee),
        RTUINT128_INIT_C(0x0000000000000000, 0x0193569e31504906), RTUINT128_INIT_C(0x0000000000000000, 0x0003aec3735ed89f)
    },
    { /* i=2920; 126 / 111 */
        RTUINT128_INIT_C(0x2167180c2cc0e136, 0x6134e36bd9aeb695), RTUINT128_INIT_C(0x00000fd32131b0e1, 0xe07d22dcd9aec462),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000021c5c), RTUINT128_INIT_C(0x00000e276dc8da81, 0xbeb280e0f8a16b5d)
    },
    { /* i=2921; 123 / 63 */
        RTUINT128_INIT_C(0x07ab648976e528bf, 0xe94e593a1fed86e0), RTUINT128_INIT_C(0x0000000000000000, 0x1eb4ae1ab4941936),
        RTUINT128_INIT_C(0x0000000000000000, 0x3ff12eab1bdd78df), RTUINT128_INIT_C(0x0000000000000000, 0x18ea1dbcf17c40d6)
    },
    { /* i=2922; 115 / 19 */
        RTUINT128_INIT_C(0x0006965459de6440, 0xb792ec26c71354ba), RTUINT128_INIT_C(0x0000000000000000, 0x000000000005a75e),
        RTUINT128_INIT_C(0x000000012a441562, 0x48eb4a564514f2f9), RTUINT128_INIT_C(0x0000000000000000, 0x000000000004ae4c)
    },
    { /* i=2923; 115 / 55 */
        RTUINT128_INIT_C(0x00034add0ba9093a, 0x5cc8243aa77e26c3), RTUINT128_INIT_C(0x0000000000000000, 0x006b4cc75ae89ffd),
        RTUINT128_INIT_C(0x0000000000000000, 0x07daef1737760d74), RTUINT128_INIT_C(0x0000000000000000, 0x0021c5f38c57cf1f)
    },
    { /* i=2924; 128 / 118 */
        RTUINT128_INIT_C(0x085d5a23a1431b22, 0xa34aa82220c5754a), RTUINT128_INIT_C(0x00157e1d11c48828, 0xf362414690e12068),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000063), RTUINT128_INIT_C(0x000d94e5c242734c, 0x844b69d819b5ed12)
    },
    { /* i=2925; 115 / 27 */
        RTUINT128_INIT_C(0x0006b6b7bd80cd12, 0x2675092050f34769), RTUINT128_INIT_C(0x0000000000000000, 0x0000000006684451),
        RTUINT128_INIT_C(0x00000000010c3e76, 0xa3d3fba1557930b7), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000524182)
    },
    { /* i=2926; 124 / 105 */
        RTUINT128_INIT_C(0x0d4cc587b607e84a, 0x6a2d1b54d81aedd0), RTUINT128_INIT_C(0x000000b9f8840ce0, 0xb21e102d642b407e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000124edf), RTUINT128_INIT_C(0x000000871747b42c, 0xf5de243adfeb5c0e)
    },
    { /* i=2927; 104 / 11 */
        RTUINT128_INIT_C(0x0000005a8cbebf2d, 0x25dd8ab03dc7dd8c), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000006a7),
        RTUINT128_INIT_C(0x000000000d9c9924, 0x1aa12040241d2133), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000347)
    },
    { /* i=2928; 63 / 43 */
        RTUINT128_INIT_C(0x0000000000000000, 0x33947859f907ccd5), RTUINT128_INIT_C(0x0000000000000000, 0x000000875699d6ec),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000619100), RTUINT128_INIT_C(0x0000000000000000, 0x0000000266e020d5)
    },
    { /* i=2929; 95 / 2 */
        RTUINT128_INIT_C(0x000000006237326d, 0x017d0f4ece79a6ec), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001),
        RTUINT128_INIT_C(0x000000006237326d, 0x017d0f4ece79a6ec), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=2930; 11 / 32 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000063e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000046248535),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000063e)
    },
    { /* i=2931; 119 / 29 */
        RTUINT128_INIT_C(0x0027ad63c6520c25, 0x40f2c28826f807ab), RTUINT128_INIT_C(0x0000000000000000, 0x0000000006b769b6),
        RTUINT128_INIT_C(0x0000000005e85050, 0x2753b3266ab979ff), RTUINT128_INIT_C(0x0000000000000000, 0x0000000004c8b561)
    },
    { /* i=2932; 115 / 98 */
        RTUINT128_INIT_C(0x000531708d401b62, 0x4fbb14cc3cd9d779), RTUINT128_INIT_C(0x0000000118dfb558, 0x84b1578673ea1d04),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000004bbb4), RTUINT128_INIT_C(0x00000000d11add72, 0x1a0083ee44fb84a9)
    },
    { /* i=2933; 106 / 1 */
        RTUINT128_INIT_C(0x0000005c8cb3fc3f, 0xcec627639f4b040a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001),
        RTUINT128_INIT_C(0x0000005c8cb3fc3f, 0xcec627639f4b040a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=2934; 118 / 93 */
        RTUINT128_INIT_C(0x00391aef7b40449d, 0x0df8ec6479082636), RTUINT128_INIT_C(0x00000000179166f3, 0xee7986ea5c96a183),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000026c49c0), RTUINT128_INIT_C(0x000000000111f056, 0xcbc2ab68eabca8f6)
    },
    { /* i=2935; 123 / 113 */
        RTUINT128_INIT_C(0x01d3bc0cdcc6356e, 0xcb51400996783971), RTUINT128_INIT_C(0x0000dd93272fea44, 0xc2a13ce0bf0d810f),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000021c), RTUINT128_INIT_C(0x000059a633b40c64, 0x3f34d5f695fbfdcd)
    },
    { /* i=2936; 119 / 114 */
        RTUINT128_INIT_C(0x005da3b361d3ce0f, 0xd133bc9c69dc65ff), RTUINT128_INIT_C(0x000296f471bfae89, 0x71539daa832b1734),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000024), RTUINT128_INIT_C(0x0000695362df42bb, 0xe17190a1f7cd22af)
    },
    { /* i=2937; 82 / 57 */
        RTUINT128_INIT_C(0x0000000000026970, 0x8062693940fcbde5), RTUINT128_INIT_C(0x0000000000000000, 0x00508ef8ef4f06fc),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000007aa1bcf), RTUINT128_INIT_C(0x0000000000000000, 0x00507906e3018421)
    },
    { /* i=2938; 117 / 12 */
        RTUINT128_INIT_C(0x000f5895206cd709, 0xdc69fe830117000c), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000004e1),
        RTUINT128_INIT_C(0x0000032537c6b27d, 0xa69b7292dbed5ddf), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000030d)
    },
    { /* i=2939; 116 / 105 */
        RTUINT128_INIT_C(0x000ed30e0d9c1401, 0xfda0263410b7157d), RTUINT128_INIT_C(0x0000004b4853e8ea, 0x5174e542df67b53f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000003269), RTUINT128_INIT_C(0x0000000cffb3c7fd, 0xbfe70e242dc770a6)
    },
    { /* i=2940; 98 / 45 */
        RTUINT128_INIT_C(0x0000000340c4419e, 0x45071c52a819caa0), RTUINT128_INIT_C(0x0000000000000000, 0x0000167a39d80301),
        RTUINT128_INIT_C(0x0000000000000000, 0x00250c8a91c50574), RTUINT128_INIT_C(0x0000000000000000, 0x000002575964692c)
    },
    { /* i=2941; 120 / 71 */
        RTUINT128_INIT_C(0x0059f06b8429ab73, 0x820624aa52b87808), RTUINT128_INIT_C(0x000000000000003b, 0x68cdafe79a9f1f17),
        RTUINT128_INIT_C(0x0000000000000000, 0x0001838e246095bf), RTUINT128_INIT_C(0x000000000000000b, 0xc052ba127447e2df)
    },
    { /* i=2942; 91 / 73 */
        RTUINT128_INIT_C(0x0000000000d6a04a, 0x1e34960ab652375b), RTUINT128_INIT_C(0x00000000000001df, 0xf8ac6bd90248a00a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000007279), RTUINT128_INIT_C(0x00000000000000b0, 0xccaef9744aba1ea1)
    },
    { /* i=2943; 28 / 25 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000055283d0), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000e7c238),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000005), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000cbb8b8)
    },
    { /* i=2944; 91 / 42 */
        RTUINT128_INIT_C(0x0000000005f6f343, 0xa6a6c7e20f25d878), RTUINT128_INIT_C(0x0000000000000000, 0x00000126652ce2cc),
        RTUINT128_INIT_C(0x0000000000000000, 0x00052fcded5c8a16), RTUINT128_INIT_C(0x0000000000000000, 0x00000096cdb862f0)
    },
    { /* i=2945; 69 / 62 */
        RTUINT128_INIT_C(0x0000000000000018, 0x4d7885fad747faa8), RTUINT128_INIT_C(0x0000000000000000, 0x3677e662b004b3f1),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000072), RTUINT128_INIT_C(0x0000000000000000, 0x0c13ee08752fd956)
    },
    { /* i=2946; 100 / 111 */
        RTUINT128_INIT_C(0x0000000c4eab3913, 0xc9a6f642b9a9a570), RTUINT128_INIT_C(0x00003b4b7f2adc5f, 0xee081a4adec94030),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000c4eab3913, 0xc9a6f642b9a9a570)
    },
    { /* i=2947; 63 / 10 */
        RTUINT128_INIT_C(0x0000000000000000, 0x7f5b334f925c326a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000283),
        RTUINT128_INIT_C(0x0000000000000000, 0x0032b46f33fc297b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000279)
    },
    { /* i=2948; 85 / 54 */
        RTUINT128_INIT_C(0x00000000001f65d1, 0x69a4413249afc019), RTUINT128_INIT_C(0x0000000000000000, 0x0008f22918552fcf),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000003827ce3db), RTUINT128_INIT_C(0x0000000000000000, 0x00000c7fa9274d04)
    },
    { /* i=2949; 124 / 122 */
        RTUINT128_INIT_C(0x0c704cca22d3150e, 0xbda5ad1d9b602aab), RTUINT128_INIT_C(0x009db5a042077143, 0x9aeff2010bd3fce9),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000014), RTUINT128_INIT_C(0x001e1c44fa3e3bc6, 0xa2e6c508aed06877)
    },
    { /* i=2950; 86 / 54 */
        RTUINT128_INIT_C(0x00000000001a2970, 0xb07b2f95ccffb617), RTUINT128_INIT_C(0x0000000000000000, 0x0026756727b30209),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000ae258fd5), RTUINT128_INIT_C(0x0000000000000000, 0x000279535d9efd9a)
    },
    { /* i=2951; 122 / 127 */
        RTUINT128_INIT_C(0x0181be4425be380e, 0xf4519c5962302b90), RTUINT128_INIT_C(0x3b7cf09501fa7c1c, 0xd79990535d18f355),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0181be4425be380e, 0xf4519c5962302b90)
    },
    { /* i=2952; 68 / 4 */
        RTUINT128_INIT_C(0x0000000000000008, 0x583172432e80c02d), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000d),
        RTUINT128_INIT_C(0x0000000000000000, 0xa45292a2b4ced3b4), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000009)
    },
    { /* i=2953; 114 / 108 */
        RTUINT128_INIT_C(0x00038980c962d932, 0x67492c31d6ca08d8), RTUINT128_INIT_C(0x00000d6929ac2609, 0x945e574f174571d7),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000043), RTUINT128_INIT_C(0x000006fae154e4b0, 0x9298527ebf9d3d93)
    },
    { /* i=2954; 126 / 109 */
        RTUINT128_INIT_C(0x3e6c124c8275c0c3, 0x5b05a4bd9ae724dc), RTUINT128_INIT_C(0x0000002ec2678edf, 0x3623cdb5d58025c6),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000155c044), RTUINT128_INIT_C(0x00000021e479472d, 0x1c053c9e77ca9c44)
    },
    { /* i=2955; 87 / 36 */
        RTUINT128_INIT_C(0x00000000007f1bb0, 0xbaaa0a61e8b88cf6), RTUINT128_INIT_C(0x0000000000000000, 0x0000000a3b4e53df),
        RTUINT128_INIT_C(0x0000000000000000, 0x000c6c4b0977fbee), RTUINT128_INIT_C(0x0000000000000000, 0x000000082601eea4)
    },
    { /* i=2956; 83 / 5 */
        RTUINT128_INIT_C(0x0000000000071f79, 0x04c82362c7c0d685), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000016),
        RTUINT128_INIT_C(0x00000000000052e2, 0x977d75f8da88c3ee), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000011)
    },
    { /* i=2957; 47 / 11 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00002ae9e15bee3f), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000602),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000724995c33), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000003d9)
    },
    { /* i=2958; 93 / 38 */
        RTUINT128_INIT_C(0x0000000012a2b9b7, 0x2e0b7e791c9222c4), RTUINT128_INIT_C(0x0000000000000000, 0x0000003100132fff),
        RTUINT128_INIT_C(0x0000000000000000, 0x00615c751fae7b00), RTUINT128_INIT_C(0x0000000000000000, 0x0000000a64309dc4)
    },
    { /* i=2959; 125 / 77 */
        RTUINT128_INIT_C(0x0a307c741526ce9d, 0x6a3e1bfc09b09cac), RTUINT128_INIT_C(0x0000000000000be2, 0x77445bd5f76c09e1),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000db7be4a3c8ea), RTUINT128_INIT_C(0x00000000000007a6, 0xa70e0469caf4cd02)
    },
    { /* i=2960; 32 / 36 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000001ef032c5), RTUINT128_INIT_C(0x0000000000000000, 0x0000000471f74b19),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000000001ef032c5)
    },
    { /* i=2961; 114 / 70 */
        RTUINT128_INIT_C(0x0001a8ac64c36a1e, 0x9a32730691d50176), RTUINT128_INIT_C(0x0000000000000027, 0x47ac1d11fde4d12d),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000acfbb27c730), RTUINT128_INIT_C(0x000000000000001e, 0x90ef4b3f5b78ce06)
    },
    { /* i=2962; 117 / 75 */
        RTUINT128_INIT_C(0x00183f780de126c2, 0x8543adaf66ff4904), RTUINT128_INIT_C(0x000000000000079d, 0xf0eb680b0e55f7b8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000032ef4315422), RTUINT128_INIT_C(0x000000000000015a, 0x3ebae1e380140294)
    },
    { /* i=2963; 72 / 58 */
        RTUINT128_INIT_C(0x0000000000000074, 0x4187467d1f307b9f), RTUINT128_INIT_C(0x0000000000000000, 0x02c7c4adbb68a379),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000029d0), RTUINT128_INIT_C(0x0000000000000000, 0x00b7a65117fd484f)
    },
    { /* i=2964; 27 / 22 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000004cefe28), RTUINT128_INIT_C(0x0000000000000000, 0x00000000001b9226),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000002c), RTUINT128_INIT_C(0x0000000000000000, 0x000000000011dfa0)
    },
    { /* i=2965; 128 / 101 */
        RTUINT128_INIT_C(0x1ad0b16bde1284e7, 0x54083bab1bc8a386), RTUINT128_INIT_C(0x0000001fd8a3b830, 0x7909f19d9594d1ec),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000d78eae), RTUINT128_INIT_C(0x0000001c1deac977, 0x9fe7f99a96fd0d1e)
    },
    { /* i=2966; 19 / 12 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000015720), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000dab),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000019), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000016d)
    },
    { /* i=2967; 69 / 62 */
        RTUINT128_INIT_C(0x000000000000001b, 0xb5d92eeb149426a7), RTUINT128_INIT_C(0x0000000000000000, 0x35766b2e45a0ce06),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000084), RTUINT128_INIT_C(0x0000000000000000, 0x24c9eb0f2da9eb8f)
    },
    { /* i=2968; 123 / 109 */
        RTUINT128_INIT_C(0x05894f4860336500, 0x4f967c4891f7c317), RTUINT128_INIT_C(0x00000e75c7bca908, 0xea14e5e7d86246b1),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000006203), RTUINT128_INIT_C(0x00000d70d0480049, 0x915509bb69c12d04)
    },
    { /* i=2969; 126 / 56 */
        RTUINT128_INIT_C(0x1159147b5f837775, 0x3f5cfd09a90e15bf), RTUINT128_INIT_C(0x0000000000000000, 0x004cdc98168d9f09),
        RTUINT128_INIT_C(0x0000000000000039, 0xc7b7a7fc8d80cae3), RTUINT128_INIT_C(0x0000000000000000, 0x0017ad1e707cf6c4)
    },
    { /* i=2970; 114 / 108 */
        RTUINT128_INIT_C(0x000056e9ea2c4d96, 0x6208b25d75ff43fd), RTUINT128_INIT_C(0x00000770f174eec8, 0x13c1ce0b3bc9e22c),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000b), RTUINT128_INIT_C(0x0000050f8a260afd, 0x88b4d7e1e4528c19)
    },
    { /* i=2971; 124 / 41 */
        RTUINT128_INIT_C(0x05e83a6ef6b012ea, 0x6cf196fe21057d2b), RTUINT128_INIT_C(0x0000000000000000, 0x0000006c9070c7a7),
        RTUINT128_INIT_C(0x00000000000dede9, 0x69ffce9cb89a3546), RTUINT128_INIT_C(0x0000000000000000, 0x0000004b26635281)
    },
    { /* i=2972; 98 / 4 */
        RTUINT128_INIT_C(0x00000000b4cefb0a, 0x28a6f01a178467e0), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000f),
        RTUINT128_INIT_C(0x000000000c0dcc78, 0x24d7eddf9b2af5db), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000b)
    },
    { /* i=2973; 70 / 67 */
        RTUINT128_INIT_C(0x000000000000002b, 0xe2fe62114f754030), RTUINT128_INIT_C(0x0000000000000001, 0x30312bf42b68cdc3),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000024), RTUINT128_INIT_C(0x0000000000000001, 0x1c1433bb34b850c4)
    },
    { /* i=2974; 122 / 53 */
        RTUINT128_INIT_C(0x03e50db5e2b56d72, 0xc59053ce9024f48f), RTUINT128_INIT_C(0x0000000000000000, 0x001191f8aabe0f75),
        RTUINT128_INIT_C(0x0000000000000038, 0xbf31a13f4c839849), RTUINT128_INIT_C(0x0000000000000000, 0x000edfe161e61432)
    },
    { /* i=2975; 87 / 13 */
        RTUINT128_INIT_C(0x00000000004ce46b, 0x5d1d542455d1aa30), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000161e),
        RTUINT128_INIT_C(0x000000000000037a, 0x016b06a9495a0eb9), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000a82)
    },
    { /* i=2976; 25 / 28 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000539a30), RTUINT128_INIT_C(0x0000000000000000, 0x000000000331e1df),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000539a30)
    },
    { /* i=2977; 127 / 127 */
        RTUINT128_INIT_C(0x1848eb131a3fd4cd, 0xec05812e4c70fb60), RTUINT128_INIT_C(0x19e4c491040de529, 0x9474a09187d303b4),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x1848eb131a3fd4cd, 0xec05812e4c70fb60)
    },
    { /* i=2978; 125 / 70 */
        RTUINT128_INIT_C(0x0e5d16d0453aee8e, 0x5a3d61d4947a10a3), RTUINT128_INIT_C(0x0000000000000015, 0x04bf9f960a9ee230),
        RTUINT128_INIT_C(0x0000000000000000, 0x00aef1e89f97189e), RTUINT128_INIT_C(0x0000000000000007, 0x335db487e6e5f703)
    },
    { /* i=2979; 123 / 62 */
        RTUINT128_INIT_C(0x078d97dc04983bbb, 0x7fb5687f807220ed), RTUINT128_INIT_C(0x0000000000000000, 0x05c81ba124aa8a06),
        RTUINT128_INIT_C(0x0000000000000001, 0x4e6f5a9894b51e56), RTUINT128_INIT_C(0x0000000000000000, 0x02bbaa2224bd0ee9)
    },
    { /* i=2980; 93 / 21 */
        RTUINT128_INIT_C(0x000000000a8dd41e, 0xd19dea3851865b5a), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000925a4),
        RTUINT128_INIT_C(0x0000000000000127, 0x60a88138a90de3da), RTUINT128_INIT_C(0x0000000000000000, 0x000000000007e1b2)
    },
    { /* i=2981; 122 / 77 */
        RTUINT128_INIT_C(0x00202d7afd712bfc, 0xd840aaa348484215), RTUINT128_INIT_C(0x0000000000001b06, 0xa9d9a6fe44a97165),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000130cc4b9dfb), RTUINT128_INIT_C(0x0000000000001481, 0xc00433495704230e)
    },
    { /* i=2982; 101 / 48 */
        RTUINT128_INIT_C(0x00000013a8887201, 0x9f7d633043389d4c), RTUINT128_INIT_C(0x0000000000000000, 0x000054b9d346dee6),
        RTUINT128_INIT_C(0x0000000000000000, 0x003b65d7da5066d6), RTUINT128_INIT_C(0x0000000000000000, 0x0000348be54aa508)
    },
    { /* i=2983; 120 / 64 */
        RTUINT128_INIT_C(0x0091d735317bd2d3, 0x0bc98a1c03b87ba2), RTUINT128_INIT_C(0x0000000000000000, 0xa376555829533593),
        RTUINT128_INIT_C(0x0000000000000000, 0x00e46713b0ba256c), RTUINT128_INIT_C(0x0000000000000000, 0x1a6970be9111a29e)
    },
    { /* i=2984; 117 / 40 */
        RTUINT128_INIT_C(0x000064c604542e12, 0x618053924d77acaa), RTUINT128_INIT_C(0x0000000000000000, 0x00000083612bb1cc),
        RTUINT128_INIT_C(0x00000000000000c4, 0x5cca8f90a50f9aec), RTUINT128_INIT_C(0x0000000000000000, 0x0000001889470c9a)
    },
    { /* i=2985; 120 / 80 */
        RTUINT128_INIT_C(0x00a3e5d16a0e9fb5, 0x131da3ff7c14596e), RTUINT128_INIT_C(0x000000000000e674, 0xae1b764b200b3c1d),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000b6108375af), RTUINT128_INIT_C(0x000000000000d984, 0x7ed89adfdf16009b)
    },
    { /* i=2986; 126 / 40 */
        RTUINT128_INIT_C(0x0db9e14819732817, 0x9103f327dc993ddc), RTUINT128_INIT_C(0x0000000000000000, 0x000000b7fd002e27),
        RTUINT128_INIT_C(0x0000000000131930, 0x169115658320d76c), RTUINT128_INIT_C(0x0000000000000000, 0x000000073fe30468)
    },
    { /* i=2987; 114 / 112 */
        RTUINT128_INIT_C(0x00035920340fae4d, 0xc78ca9c40f0fb628), RTUINT128_INIT_C(0x0000454bff22ce2b, 0xc6feac529cc972c0),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000c), RTUINT128_INIT_C(0x000019903e6e0440, 0x739c95e4b59e5528)
    },
    { /* i=2988; 111 / 107 */
        RTUINT128_INIT_C(0x00005b17bf0b698f, 0xfc3a1efde316287b), RTUINT128_INIT_C(0x0000008cd56e69f4, 0x7113c343514e165f),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000a5), RTUINT128_INIT_C(0x000000522ee11f03, 0x1a7d449a7bc1bd40)
    },
    { /* i=2989; 90 / 22 */
        RTUINT128_INIT_C(0x00000000011035e8, 0x4dfcdc0d868f3ca5), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000304f48),
        RTUINT128_INIT_C(0x0000000000000005, 0xa27ba26b2b3db1bc), RTUINT128_INIT_C(0x0000000000000000, 0x00000000001c3bc5)
    },
    { /* i=2990; 126 / 83 */
        RTUINT128_INIT_C(0x09910a89284c620a, 0xfe2258748dbc5306), RTUINT128_INIT_C(0x0000000000044fa9, 0x216f922e1e4a0deb),
        RTUINT128_INIT_C(0x0000000000000000, 0x000002381176014a), RTUINT128_INIT_C(0x0000000000038990, 0x3ebc268a7cf46218)
    },
    { /* i=2991; 125 / 47 */
        RTUINT128_INIT_C(0x0901644fcb435a67, 0x8119909cab91c06e), RTUINT128_INIT_C(0x0000000000000000, 0x00007296a694a237),
        RTUINT128_INIT_C(0x000000000000141e, 0x6ee82f10e2e440ae), RTUINT128_INIT_C(0x0000000000000000, 0x0000348d4301bf0c)
    },
    { /* i=2992; 25 / 7 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000186176e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000069),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000003b714), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000003a)
    },
    { /* i=2993; 40 / 60 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000058e0642bf6), RTUINT128_INIT_C(0x0000000000000000, 0x0b600e1ee6b6062e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00000058e0642bf6)
    },
    { /* i=2994; 115 / 120 */
        RTUINT128_INIT_C(0x00064b7595bf4fad, 0xadd663210503c9b6), RTUINT128_INIT_C(0x00d6c2c04f375bd0, 0x4c6a9eefba38f950),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00064b7595bf4fad, 0xadd663210503c9b6)
    },
    { /* i=2995; 124 / 108 */
        RTUINT128_INIT_C(0x08c68eac78a54709, 0xca9f7468e3a28a33), RTUINT128_INIT_C(0x0000049db317d6e8, 0x16a4df3474e16473),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000001e6b0), RTUINT128_INIT_C(0x000000421644ec7d, 0x39886a74a3fb2923)
    },
    { /* i=2996; 121 / 17 */
        RTUINT128_INIT_C(0x01685f7bdfa43bae, 0xb79c302c09a05525), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000013bbc),
        RTUINT128_INIT_C(0x00000124317f3501, 0xdfbdb09ad070ef7e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000006a9d)
    },
    { /* i=2997; 87 / 74 */
        RTUINT128_INIT_C(0x00000000002e4904, 0x8d7dbcdc65bf961e), RTUINT128_INIT_C(0x0000000000000238, 0xbf0723b2e169267a),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000014d5), RTUINT128_INIT_C(0x00000000000000e1, 0x0dc30f6aa2410a9c)
    },
    { /* i=2998; 82 / 36 */
        RTUINT128_INIT_C(0x00000000000050b8, 0x3719572115937db8), RTUINT128_INIT_C(0x0000000000000000, 0x000000022cf6be75),
        RTUINT128_INIT_C(0x0000000000000000, 0x00002519fe659604), RTUINT128_INIT_C(0x0000000000000000, 0x0000000193f6f5e4)
    },
    { /* i=2999; 114 / 103 */
        RTUINT128_INIT_C(0x0002bd9b5c53a14f, 0xec55e963d2970203), RTUINT128_INIT_C(0x0000005ec280cf1c, 0x501bdfd108d46d34),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000767), RTUINT128_INIT_C(0x0000002994d686ba, 0xee00250b7622a617)
    },
    { /* i=3000; 77 / 22 */
        RTUINT128_INIT_C(0x0000000000000f93, 0x8eb9fff951376bbf), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000213118),
        RTUINT128_INIT_C(0x0000000000000000, 0x0078230d9bfec167), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000099317)
    },
    { /* i=3001; 66 / 59 */
        RTUINT128_INIT_C(0x0000000000000001, 0x1fd3a17b07966e9e), RTUINT128_INIT_C(0x0000000000000000, 0x0463525a045a31e6),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000041), RTUINT128_INIT_C(0x0000000000000000, 0x029bb89fecafc338)
    },
    { /* i=3002; 124 / 84 */
        RTUINT128_INIT_C(0x077f316257c8bfd4, 0xaef40aa7c169b89d), RTUINT128_INIT_C(0x000000000003aeda, 0x0a92c63242cc2e2d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000020917cb6e06), RTUINT128_INIT_C(0x00000000000207b1, 0xbef48322cc1a4d8f)
    },
    { /* i=3003; 66 / 7 */
        RTUINT128_INIT_C(0x0000000000000000, 0x1182e48988f0d0b5), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000024),
        RTUINT128_INIT_C(0x0000000000000000, 0x007c8659275c05cc), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000005)
    },
    { /* i=3004; 117 / 18 */
        RTUINT128_INIT_C(0x0016e79a0b0faf85, 0xe3b00f473cba8f80), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000ba61),
        RTUINT128_INIT_C(0x0000001f75ed3a0b, 0xf65a365f98d9e773), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000004eed)
    },
    { /* i=3005; 119 / 97 */
        RTUINT128_INIT_C(0x002c68bad4ccd74b, 0x186c3411ac5a5db1), RTUINT128_INIT_C(0x0000000161a37878, 0x486577096edadd89),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000002025db), RTUINT128_INIT_C(0x000000009e82593f, 0x9e3d269e83fa0c7e)
    },
    { /* i=3006; 105 / 97 */
        RTUINT128_INIT_C(0x0000012fcb37315b, 0x914548fd8db94f08), RTUINT128_INIT_C(0x00000001fc9cde46, 0xe65e20a30ca73804),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000098), RTUINT128_INIT_C(0x00000001ce133742, 0xc961e82e0a700ca8)
    },
    { /* i=3007; 93 / 28 */
        RTUINT128_INIT_C(0x0000000015a170c7, 0xff505b94bed8e209), RTUINT128_INIT_C(0x0000000000000000, 0x000000000afe3e10),
        RTUINT128_INIT_C(0x0000000000000001, 0xf7b7d3c948445dda), RTUINT128_INIT_C(0x0000000000000000, 0x00000000098c3869)
    },
    { /* i=3008; 106 / 111 */
        RTUINT128_INIT_C(0x000001c94e498e51, 0x6c46c46d6a75155d), RTUINT128_INIT_C(0x00002ee518e9a5c1, 0x716855feb5b7e369),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000001c94e498e51, 0x6c46c46d6a75155d)
    },
    { /* i=3009; 117 / 57 */
        RTUINT128_INIT_C(0x00155cecdfb1702d, 0x79e7866ea56be464), RTUINT128_INIT_C(0x0000000000000000, 0x01ba41f51a6f0ac6),
        RTUINT128_INIT_C(0x0000000000000000, 0x0c5dad521a8ccfb2), RTUINT128_INIT_C(0x0000000000000000, 0x008f7c647a384cb8)
    },
    { /* i=3010; 46 / 41 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000f2949e784ac), RTUINT128_INIT_C(0x0000000000000000, 0x000000693289326f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000024), RTUINT128_INIT_C(0x0000000000000000, 0x0000005e2e9c6d10)
    },
    { /* i=3011; 124 / 108 */
        RTUINT128_INIT_C(0x0fd88908e113654b, 0x8ca5c7ddd601d56d), RTUINT128_INIT_C(0x00000497cd6db1bc, 0x4450d3ac9179d5c3),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000037334), RTUINT128_INIT_C(0x000000a1cabeeb6a, 0xe21e8f090cf2d0d1)
    },
    { /* i=3012; 71 / 37 */
        RTUINT128_INIT_C(0x0000000000000059, 0x26ae568ebace7bce), RTUINT128_INIT_C(0x0000000000000000, 0x0000000ae2758938),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000830c904d9), RTUINT128_INIT_C(0x0000000000000000, 0x00000007b2104b56)
    },
    { /* i=3013; 83 / 6 */
        RTUINT128_INIT_C(0x0000000000077187, 0x37fa73710d78e13c), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000f),
        RTUINT128_INIT_C(0x0000000000007f09, 0x03bb5d07896e756a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000006)
    },
    { /* i=3014; 113 / 122 */
        RTUINT128_INIT_C(0x0000b6ab1ae3aa77, 0xf01d2dfc30081b64), RTUINT128_INIT_C(0x03767d1fe7f3e2cd, 0x56d9d6025eb256f9),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000b6ab1ae3aa77, 0xf01d2dfc30081b64)
    },
    { /* i=3015; 99 / 21 */
        RTUINT128_INIT_C(0x000000019b171042, 0xacb6ecb7fd0131d7), RTUINT128_INIT_C(0x0000000000000000, 0x000000000010002a),
        RTUINT128_INIT_C(0x00000000000019b1, 0x2d9313295c7eed02), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000e4f83)
    },
    { /* i=3016; 113 / 28 */
        RTUINT128_INIT_C(0x00016b6add2cd0e2, 0xf62ab50d3093a102), RTUINT128_INIT_C(0x0000000000000000, 0x00000000016bdca7),
        RTUINT128_INIT_C(0x0000000000ffaff1, 0x50dcb8709c4a3f11), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000d6e0eb)
    },
    { /* i=3017; 114 / 39 */
        RTUINT128_INIT_C(0x000038dd0e7336b4, 0x164ecf85a9223b3c), RTUINT128_INIT_C(0x0000000000000000, 0x000000304788bce6),
        RTUINT128_INIT_C(0x000000000000012d, 0x844920e8fcf80526), RTUINT128_INIT_C(0x0000000000000000, 0x0000001bf855b318)
    },
    { /* i=3018; 119 / 34 */
        RTUINT128_INIT_C(0x00174b0f48e21300, 0xa1b8246fc3fce998), RTUINT128_INIT_C(0x0000000000000000, 0x0000000086bfdb98),
        RTUINT128_INIT_C(0x00000000002c40c0, 0xfab66aaffdc67f84), RTUINT128_INIT_C(0x0000000000000000, 0x000000000b8f4738)
    },
    { /* i=3019; 111 / 17 */
        RTUINT128_INIT_C(0x00003a3f4a9a71f9, 0x70fa9479f8d9e671), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000106e9),
        RTUINT128_INIT_C(0x0000000038b75f77, 0xbf7f2b38e83d2a31), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000059d8)
    },
    { /* i=3020; 128 / 63 */
        RTUINT128_INIT_C(0x2ea992f274608694, 0x0b5ba62006dc3212), RTUINT128_INIT_C(0x0000000000000000, 0x6aca1c705b705a47),
        RTUINT128_INIT_C(0x0000000000000000, 0x6fdc66e7fa6f4be4), RTUINT128_INIT_C(0x0000000000000000, 0x06a44953318ffdd6)
    },
    { /* i=3021; 48 / 3 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000059ad931d9567), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003),
        RTUINT128_INIT_C(0x0000000000000000, 0x00001de4865f31cd), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=3022; 110 / 16 */
        RTUINT128_INIT_C(0x0000154bf5925f18, 0x664083fa3a071c91), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000a1b7),
        RTUINT128_INIT_C(0x0000000021b6a236, 0xb869dac3c9f7d01b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000005e44)
    },
    { /* i=3023; 54 / 37 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00201ddc207efa84), RTUINT128_INIT_C(0x0000000000000000, 0x00000001780b5573),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000015dd33), RTUINT128_INIT_C(0x0000000000000000, 0x000000016b09ad9b)
    },
    { /* i=3024; 54 / 58 */
        RTUINT128_INIT_C(0x0000000000000000, 0x001ca79d6b1b6fa7), RTUINT128_INIT_C(0x0000000000000000, 0x002d1f42ef660d6f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x001ca79d6b1b6fa7)
    },
    { /* i=3025; 70 / 13 */
        RTUINT128_INIT_C(0x0000000000000001, 0xe5480b2f697bde70), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000005a3),
        RTUINT128_INIT_C(0x0000000000000000, 0x005617c7cb6203e1), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000012d)
    },
    { /* i=3026; 117 / 53 */
        RTUINT128_INIT_C(0x001aaeb2a02038d9, 0xc05e94aef829cd08), RTUINT128_INIT_C(0x0000000000000000, 0x001cf0cefb8bff05),
        RTUINT128_INIT_C(0x0000000000000000, 0xec063692b34f85e3), RTUINT128_INIT_C(0x0000000000000000, 0x00168217fdfe1299)
    },
    { /* i=3027; 127 / 117 */
        RTUINT128_INIT_C(0x42e74435598bdd9e, 0xe1c218a9b7964397), RTUINT128_INIT_C(0x000fda363ffa4288, 0x0bb05c23248cfffb),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000438), RTUINT128_INIT_C(0x0006af5771c32fad, 0x91bd646784be58af)
    },
    { /* i=3028; 125 / 63 */
        RTUINT128_INIT_C(0x11cc0d666a478c25, 0xe59ffd3032485b58), RTUINT128_INIT_C(0x0000000000000000, 0x52ed933001e90fbb),
        RTUINT128_INIT_C(0x0000000000000000, 0x36f099325b119c92), RTUINT128_INIT_C(0x0000000000000000, 0x2256fc0d915c6eb2)
    },
    { /* i=3029; 94 / 77 */
        RTUINT128_INIT_C(0x00000000303e624d, 0x35648110068d4f12), RTUINT128_INIT_C(0x0000000000000ab9, 0x42e8801e9523cfd8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000047fb1), RTUINT128_INIT_C(0x0000000000000462, 0x9a9a6b5ee54e72ba)
    },
    { /* i=3030; 121 / 75 */
        RTUINT128_INIT_C(0x01ce3d0fcb2f6285, 0x937c8ccda7eb0ef3), RTUINT128_INIT_C(0x000000000000023c, 0x90b1310ec54ff9af),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000ceabf8d808f0), RTUINT128_INIT_C(0x000000000000008c, 0x88e38988f97b82e3)
    },
    { /* i=3031; 124 / 122 */
        RTUINT128_INIT_C(0x0127739517150a37, 0x5080c9fc18d072bc), RTUINT128_INIT_C(0x0178c15b5274fe91, 0xa8f1732f40bc6ab1),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0127739517150a37, 0x5080c9fc18d072bc)
    },
    { /* i=3032; 128 / 65 */
        RTUINT128_INIT_C(0x90236e2d62d24a2a, 0x1401c7e2e24a1ac5), RTUINT128_INIT_C(0x0000000000000001, 0xe2862aafdfc703c9),
        RTUINT128_INIT_C(0x0000000000000000, 0x4c78c061e7e5d05e), RTUINT128_INIT_C(0x0000000000000000, 0x825844e3425666f7)
    },
    { /* i=3033; 117 / 116 */
        RTUINT128_INIT_C(0x000b108a8a17f93b, 0xe60efaf433d1372f), RTUINT128_INIT_C(0x000a02561da03199, 0x1fa4d82c7a931f8c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x00010e346c77c7a2, 0xc66a22c7b93e17a3)
    },
    { /* i=3034; 98 / 43 */
        RTUINT128_INIT_C(0x0000000249eec4ff, 0x6495990b8e78a68c), RTUINT128_INIT_C(0x0000000000000000, 0x00000279f30b7a7d),
        RTUINT128_INIT_C(0x0000000000000000, 0x00ec9c2950956139), RTUINT128_INIT_C(0x0000000000000000, 0x000000d2bcc003b7)
    },
    { /* i=3035; 120 / 24 */
        RTUINT128_INIT_C(0x004c17bec493eda1, 0xb1fe184a1ed9b6e5), RTUINT128_INIT_C(0x0000000000000000, 0x000000000081cc85),
        RTUINT128_INIT_C(0x0000000096138b5c, 0x0656dca4cab4df9a), RTUINT128_INIT_C(0x0000000000000000, 0x000000000018d3e3)
    },
    { /* i=3036; 80 / 23 */
        RTUINT128_INIT_C(0x00000000000082cd, 0x7d28ff67bdbf1549), RTUINT128_INIT_C(0x0000000000000000, 0x00000000006aae36),
        RTUINT128_INIT_C(0x0000000000000000, 0x0139e2be64db08ad), RTUINT128_INIT_C(0x0000000000000000, 0x000000000003aacb)
    },
    { /* i=3037; 117 / 121 */
        RTUINT128_INIT_C(0x001712db0cc82fea, 0xe8f5a6a6b9f55488), RTUINT128_INIT_C(0x0003e6e238822bc5, 0xeb8ef75ed55a17b5),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000005), RTUINT128_INIT_C(0x0003906ff23d550d, 0x4f2ad1cc8f32ddff)
    },
    { /* i=3038; 105 / 87 */
        RTUINT128_INIT_C(0x000001dc14627c3d, 0x2c316ff298adc65d), RTUINT128_INIT_C(0x00000000003dac68, 0x7e71d61dbc85e809),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000007b827), RTUINT128_INIT_C(0x000000000036a853, 0x3c244a414941f4fe)
    },
    { /* i=3039; 114 / 125 */
        RTUINT128_INIT_C(0x00022c76f72437b7, 0x15876a4665ffcbc8), RTUINT128_INIT_C(0x0a106db46ae55446, 0x957aaa25c21b119d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00022c76f72437b7, 0x15876a4665ffcbc8)
    },
    { /* i=3040; 89 / 80 */
        RTUINT128_INIT_C(0x00000000007b634b, 0x62d6bbade70fcf2a), RTUINT128_INIT_C(0x000000000000ab47, 0x8558d2c8fcfd5ea6),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000b8), RTUINT128_INIT_C(0x00000000000047e3, 0x8aff3b3810f3c7da)
    },
    { /* i=3041; 124 / 92 */
        RTUINT128_INIT_C(0x0b5b5ddda86ee529, 0x10036f12bb85170b), RTUINT128_INIT_C(0x0000000000ab404f, 0x1eaf162f55add5f6),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000010fa2a08db), RTUINT128_INIT_C(0x000000000009012b, 0x1f3cc90faac35d99)
    },
    { /* i=3042; 43 / 10 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000029770349739), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000071),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000005df02bb1b), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000004e)
    },
    { /* i=3043; 86 / 15 */
        RTUINT128_INIT_C(0x0000000000280baa, 0xd015484b230e19fc), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000003e6b),
        RTUINT128_INIT_C(0x00000000000000a4, 0x3e03afa8b8de6bba), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000073e)
    },
    { /* i=3044; 49 / 26 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0001ca043647a210), RTUINT128_INIT_C(0x0000000000000000, 0x0000000003ee9f3d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000747b1a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000001e526de)
    },
    { /* i=3045; 39 / 77 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000003c702ddf50), RTUINT128_INIT_C(0x0000000000000530, 0xf9880a425adbcf5f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000003c702ddf50)
    },
    { /* i=3046; 108 / 22 */
        RTUINT128_INIT_C(0x00000d3089ce1abf, 0x06be94409f368bb6), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000c5279),
        RTUINT128_INIT_C(0x000000000112058a, 0xea6aabf009130521), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000088d1d)
    },
    { /* i=3047; 120 / 49 */
        RTUINT128_INIT_C(0x00eb6c9536668508, 0xb482997c17330eec), RTUINT128_INIT_C(0x0000000000000000, 0x00003baab46677d0),
        RTUINT128_INIT_C(0x00000000000003f2, 0x15e1239cb37c9663), RTUINT128_INIT_C(0x0000000000000000, 0x0000069bd09ed97c)
    },
    { /* i=3048; 128 / 41 */
        RTUINT128_INIT_C(0x93e412fe9a9c12a2, 0xa86baf322ee158b1), RTUINT128_INIT_C(0x0000000000000000, 0x0000000009cbd66d),
        RTUINT128_INIT_C(0x0000000f18c1641c, 0xdaf73fe5a093ad38), RTUINT128_INIT_C(0x0000000000000000, 0x0000000009cbc7d9)
    },
    { /* i=3049; 119 / 85 */
        RTUINT128_INIT_C(0x00285953ab2a4422, 0x4228de818ce5959d), RTUINT128_INIT_C(0x0000000000116b05, 0x4c2b882c09fef0ff),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000251063928), RTUINT128_INIT_C(0x00000000000cbde5, 0x75da012de46d26c5)
    },
    { /* i=3050; 128 / 98 */
        RTUINT128_INIT_C(0x45241150fc77924e, 0xf47368de67c3c913), RTUINT128_INIT_C(0x00000003fdc05d8d, 0x99e9f6ffe20ec37c),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000001152c14b), RTUINT128_INIT_C(0x0000000340009271, 0x5db7bec4325807bf)
    },
    { /* i=3051; 118 / 108 */
        RTUINT128_INIT_C(0x002acb7cfd763dc7, 0xe39478c4f6455f1e), RTUINT128_INIT_C(0x0000028f8125cd1c, 0xf4c119adadcfb0c1),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000010b6), RTUINT128_INIT_C(0x00000164cfc49be5, 0xd0b15c6e6991a5e8)
    },
    { /* i=3052; 120 / 82 */
        RTUINT128_INIT_C(0x00ddb8a526a44bc0, 0x9723996569add47a), RTUINT128_INIT_C(0x000000000003b440, 0x6cbeee9dc3e065d9),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000003bdbb3860e), RTUINT128_INIT_C(0x0000000000025950, 0xc0339232645dac9c)
    },
    { /* i=3053; 95 / 6 */
        RTUINT128_INIT_C(0x000000003ec1d8a4, 0x298de670e6a92192), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000001f),
        RTUINT128_INIT_C(0x00000000020640cb, 0x7d36203530bb221d), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000f)
    },
    { /* i=3054; 63 / 16 */
        RTUINT128_INIT_C(0x0000000000000000, 0x6155781bf5d2f456), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000fe69),
        RTUINT128_INIT_C(0x0000000000000000, 0x000061f12e8cf7f1), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000247d)
    },
    { /* i=3055; 123 / 23 */
        RTUINT128_INIT_C(0x04df4c2d961be5f7, 0x0389d9f65d5ea7bc), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000430ab7),
        RTUINT128_INIT_C(0x000000129ad180e2, 0xa025174165e9f5f6), RTUINT128_INIT_C(0x0000000000000000, 0x00000000002238e2)
    },
    { /* i=3056; 97 / 77 */
        RTUINT128_INIT_C(0x000000007bc0119b, 0xd4f03a33fb92d5d1), RTUINT128_INIT_C(0x0000000000000182, 0x7e4831ed2a5e3a5c),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000051f7cc), RTUINT128_INIT_C(0x00000000000000ef, 0xbf323584d7119081)
    },
    { /* i=3057; 12 / 69 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000005a2), RTUINT128_INIT_C(0x0000000000000016, 0xbfcf87a89d0db8f4),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000005a2)
    },
    { /* i=3058; 117 / 103 */
        RTUINT128_INIT_C(0x00133d35846e9d9a, 0xa3173b78311339fd), RTUINT128_INIT_C(0x0000005e240ec827, 0x8d23f9faef0e0dbb),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000003451), RTUINT128_INIT_C(0x000000191b19406b, 0xabee2a83b2d6e5d2)
    },
    { /* i=3059; 20 / 10 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000037651), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000006),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000093b8), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001)
    },
    { /* i=3060; 117 / 87 */
        RTUINT128_INIT_C(0x00175e5febca0715, 0x732e50abf8ef2881), RTUINT128_INIT_C(0x00000000000aa2d9, 0xc754a586fcea0a6a),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000002327521b8), RTUINT128_INIT_C(0x000000000006faca, 0x47158f388eee0251)
    },
    { /* i=3061; 63 / 48 */
        RTUINT128_INIT_C(0x0000000000000000, 0x66f8500746a0e43b), RTUINT128_INIT_C(0x0000000000000000, 0x000090264d5ae327),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000b6de), RTUINT128_INIT_C(0x0000000000000000, 0x000013d194522e69)
    },
    { /* i=3062; 118 / 80 */
        RTUINT128_INIT_C(0x0023ae1a627950f0, 0x3dd0b189fb924948), RTUINT128_INIT_C(0x00000000000095c8, 0x26fa6fca8223504a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000003cfb92ff5d), RTUINT128_INIT_C(0x0000000000008e80, 0xd01db4232f906866)
    },
    { /* i=3063; 108 / 5 */
        RTUINT128_INIT_C(0x00000823142f615b, 0x2c1faa2cdbeb84a0), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000001d),
        RTUINT128_INIT_C(0x00000047d48ee00b, 0xf8b1a4c3c0f67754), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000001c)
    },
    { /* i=3064; 124 / 24 */
        RTUINT128_INIT_C(0x0c8493077324c89c, 0xf407768cb3c23da9), RTUINT128_INIT_C(0x0000000000000000, 0x00000000007451a9),
        RTUINT128_INIT_C(0x0000001b8cc51438, 0x973c7955714749a1), RTUINT128_INIT_C(0x0000000000000000, 0x000000000072b160)
    },
    { /* i=3065; 100 / 63 */
        RTUINT128_INIT_C(0x0000000bb3fe26a3, 0xeb5ea8c1517ab480), RTUINT128_INIT_C(0x0000000000000000, 0x20675bba5e69cb17),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000005c754e9813), RTUINT128_INIT_C(0x0000000000000000, 0x1748178c1b08f9cb)
    },
    { /* i=3066; 89 / 80 */
        RTUINT128_INIT_C(0x0000000000666761, 0xb1527805d204b457), RTUINT128_INIT_C(0x0000000000001643, 0x2cec1815a88c5a37),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000499), RTUINT128_INIT_C(0x0000000000000c88, 0x27d7bc71e4b9ed78)
    },
    { /* i=3067; 39 / 25 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000044c16d3153), RTUINT128_INIT_C(0x0000000000000000, 0x000000000017d0d2),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000002e311), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000a1d61)
    },
    { /* i=3068; 46 / 19 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00001c53cae8e5e7), RTUINT128_INIT_C(0x0000000000000000, 0x000000000005e938),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000004cad3ee), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000ebd7)
    },
    { /* i=3069; 117 / 111 */
        RTUINT128_INIT_C(0x001612b3b80f7890, 0x174eb9ac57ab8f84), RTUINT128_INIT_C(0x000056c2195f9764, 0x8638ec6548622cd2),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000041), RTUINT128_INIT_C(0x00000b6b46ca080a, 0x02dab3f4f6be2e32)
    },
    { /* i=3070; 68 / 48 */
        RTUINT128_INIT_C(0x000000000000000c, 0x9c6eee37845ca4a7), RTUINT128_INIT_C(0x0000000000000000, 0x0000edf62a00746f),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000d9129), RTUINT128_INIT_C(0x0000000000000000, 0x000041fa9eb41fe0)
    },
    { /* i=3071; 119 / 112 */
        RTUINT128_INIT_C(0x002b741ec9f0b95a, 0x2d3a46a2c8cf27c8), RTUINT128_INIT_C(0x000011e9ba7fe5b2, 0x88a18d1bc6733aba),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000026d), RTUINT128_INIT_C(0x0000002561b08744, 0xbd56fa426349b296)
    },
    { /* i=3072; 58 / 100 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0040dc27170a1312), RTUINT128_INIT_C(0x00000004e8708cd6, 0x05c09cdcdfc14174),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0040dc27170a1312)
    },
    { /* i=3073; 71 / 21 */
        RTUINT128_INIT_C(0x0000000000000001, 0x364656bd60edf0f3), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000077e95),
        RTUINT128_INIT_C(0x0000000000000000, 0x000029668a04ad8a), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000503a1)
    },
    { /* i=3074; 127 / 122 */
        RTUINT128_INIT_C(0x3346f421a4cb2e93, 0x74a8dcb8cd3c75fc), RTUINT128_INIT_C(0x005ca527af632d81, 0xc1ae69871cd1ad85),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000008d), RTUINT128_INIT_C(0x003ffd460b2b1e1b, 0xc798bd4dedbfe3bb)
    },
    { /* i=3075; 116 / 103 */
        RTUINT128_INIT_C(0x00050e9a0442bee5, 0x49234e8538df9a30), RTUINT128_INIT_C(0x0000002364e14fe4, 0x9e8da916d6b0085e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000002493), RTUINT128_INIT_C(0x0000001767a5b852, 0x52040037309d9436)
    },
    { /* i=3076; 128 / 118 */
        RTUINT128_INIT_C(0xae0470da20a1bd9a, 0xe3132474f276b75f), RTUINT128_INIT_C(0x000f2c8e0b79f35c, 0x4c36905fcfb95e99),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000b77), RTUINT128_INIT_C(0x000ca0548d7ca66d, 0x1d81e9fe6c3b2b40)
    },
    { /* i=3077; 122 / 17 */
        RTUINT128_INIT_C(0x00c4e4060d9238f5, 0xe2747562e21ca850), RTUINT128_INIT_C(0x0000000000000000, 0x000000000001ec0e),
        RTUINT128_INIT_C(0x000000666f91aa76, 0x0fdf3a67aeae7b17), RTUINT128_INIT_C(0x0000000000000000, 0x000000000001b90e)
    },
    { /* i=3078; 119 / 83 */
        RTUINT128_INIT_C(0x0030f11ed27b6a36, 0xdc1d13ec0ca84515), RTUINT128_INIT_C(0x0000000000042cfb, 0x52d433036cf8d2fe),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000bb87a0b82), RTUINT128_INIT_C(0x0000000000019717, 0x39842f5ae8303619)
    },
    { /* i=3079; 127 / 22 */
        RTUINT128_INIT_C(0x2b24dbf5c5f453eb, 0x06b76ac83b3f6919), RTUINT128_INIT_C(0x0000000000000000, 0x000000000014c54e),
        RTUINT128_INIT_C(0x00000213c058a5c4, 0xddc398d3688bbdf9), RTUINT128_INIT_C(0x0000000000000000, 0x000000000006ea3b)
    },
    { /* i=3080; 114 / 93 */
        RTUINT128_INIT_C(0x0001f47f08586f51, 0x2e4635654991707a), RTUINT128_INIT_C(0x0000000018ab47ee, 0x7b4b200de7b5e954),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000001449d5), RTUINT128_INIT_C(0x000000000bb0f2dd, 0xab8a788a651d5996)
    },
    { /* i=3081; 123 / 97 */
        RTUINT128_INIT_C(0x002b1858f2c0023d, 0x9bf52af38ff10ca0), RTUINT128_INIT_C(0x000000001ca65e25, 0xe7ea6360bc72dd10),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000181132c), RTUINT128_INIT_C(0x0000000016293c03, 0xe5d07f9830badde0)
    },
    { /* i=3082; 49 / 18 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00001054d4b13420), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000023d93),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000074a016d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000016989)
    },
    { /* i=3083; 119 / 26 */
        RTUINT128_INIT_C(0x003f448548738328, 0xecb5c9c137b30245), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000fe610b),
        RTUINT128_INIT_C(0x000000003fabb9ee, 0x7c21234f87317fa6), RTUINT128_INIT_C(0x0000000000000000, 0x000000000080a023)
    },
    { /* i=3084; 122 / 115 */
        RTUINT128_INIT_C(0x0372ae8138c3c793, 0x479c790238b2e1a0), RTUINT128_INIT_C(0x00036ad0d7ceeb11, 0x6f29db73b8608c39),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000102), RTUINT128_INIT_C(0x00010807ba3ae001, 0x3f6d4e626765902e)
    },
    { /* i=3085; 115 / 91 */
        RTUINT128_INIT_C(0x0006a2bd778ea9e5, 0xd5f84a7e5be2bde4), RTUINT128_INIT_C(0x0000000003127edc, 0x2dbab8a6e8c725fe),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000228ee3c), RTUINT128_INIT_C(0x000000000285a129, 0x5ea3e98cbc33b25c)
    },
    { /* i=3086; 81 / 25 */
        RTUINT128_INIT_C(0x000000000001d51a, 0x9be73356716c2444), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000645b1f),
        RTUINT128_INIT_C(0x0000000000000000, 0x04aca58fbb08d399), RTUINT128_INIT_C(0x0000000000000000, 0x00000000005f21bd)
    },
    { /* i=3087; 69 / 32 */
        RTUINT128_INIT_C(0x000000000000000b, 0x02724b02bb5752ad), RTUINT128_INIT_C(0x0000000000000000, 0x00000000ab3a881f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000001075cb61d9), RTUINT128_INIT_C(0x0000000000000000, 0x000000004d913166)
    },
    { /* i=3088; 6 / 28 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000018), RTUINT128_INIT_C(0x0000000000000000, 0x000000000589f3bd),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000018)
    },
    { /* i=3089; 95 / 40 */
        RTUINT128_INIT_C(0x000000001ec0488e, 0x7dfd839c3eb2fe87), RTUINT128_INIT_C(0x0000000000000000, 0x000000b3604a3d2b),
        RTUINT128_INIT_C(0x0000000000000000, 0x002be3138f1007a5), RTUINT128_INIT_C(0x0000000000000000, 0x0000005d4f7d64d0)
    },
    { /* i=3090; 119 / 39 */
        RTUINT128_INIT_C(0x006ed64a515ad4e3, 0x01958be4eb5f12b1), RTUINT128_INIT_C(0x0000000000000000, 0x0000006560da19db),
        RTUINT128_INIT_C(0x00000000000117e2, 0x9a56cb8321010f8f), RTUINT128_INIT_C(0x0000000000000000, 0x00000056b52bcc5c)
    },
    { /* i=3091; 122 / 114 */
        RTUINT128_INIT_C(0x01bcaaa5293ee016, 0x9562243f228eb927), RTUINT128_INIT_C(0x000356a2af6b6221, 0xea399079d97a216b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000085), RTUINT128_INIT_C(0x0000a8200674e477, 0xe57a14f1261b5c90)
    },
    { /* i=3092; 42 / 25 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000034bd760bcde), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000de1521),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000003ccb7), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000665647)
    },
    { /* i=3093; 100 / 82 */
        RTUINT128_INIT_C(0x00000007c9bc4090, 0x59c0d8abe5831b8c), RTUINT128_INIT_C(0x000000000001fa1b, 0x822ff533e605ae90),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000003f079), RTUINT128_INIT_C(0x000000000000b8f2, 0xfb99996dcd7c997c)
    },
    { /* i=3094; 125 / 82 */
        RTUINT128_INIT_C(0x1bb9fd5209a2cc97, 0x6493d861ba77da53), RTUINT128_INIT_C(0x000000000003e050, 0x40b336b6cba581c8),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000727291a6cb1), RTUINT128_INIT_C(0x0000000000033e6d, 0xaba47804e3f8bf0b)
    },
    { /* i=3095; 113 / 122 */
        RTUINT128_INIT_C(0x0000f5821c132061, 0xd696db18ebdda5e4), RTUINT128_INIT_C(0x00bb43bf7c757fde, 0x12f4998af848271e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000f5821c132061, 0xd696db18ebdda5e4)
    },
    { /* i=3096; 117 / 91 */
        RTUINT128_INIT_C(0x000610eb6d43299b, 0x1e8a07d33485cb11), RTUINT128_INIT_C(0x000000000164c626, 0xd77f3237b3dde677),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000045a4895), RTUINT128_INIT_C(0x0000000000db28e3, 0x64fd6f3439b72fce)
    },
    { /* i=3097; 128 / 94 */
        RTUINT128_INIT_C(0xfa9207ac0d0ca97a, 0xf277e099133e8d03), RTUINT128_INIT_C(0x00000000379818ca, 0x1da123ef667bd175),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000481d3d242), RTUINT128_INIT_C(0x0000000035774a67, 0x448d18617d1192d9)
    },
    { /* i=3098; 58 / 40 */
        RTUINT128_INIT_C(0x0000000000000000, 0x033c89ac06008aeb), RTUINT128_INIT_C(0x0000000000000000, 0x000000436c534fea),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000c49e3), RTUINT128_INIT_C(0x0000000000000000, 0x00000017775ef46d)
    },
    { /* i=3099; 113 / 19 */
        RTUINT128_INIT_C(0x000086a44058919c, 0xb501c1d4931de20c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000010fed),
        RTUINT128_INIT_C(0x000000007ec18fba, 0x93418a3b4f470512), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000002262)
    },
    { /* i=3100; 118 / 90 */
        RTUINT128_INIT_C(0x001c347185f1d06f, 0x1510d2db9fe828f6), RTUINT128_INIT_C(0x00000000028aa851, 0xd91e1d4978b7ee62),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000b18dec7), RTUINT128_INIT_C(0x0000000002315872, 0x4a2f1f92b904dec8)
    },
    { /* i=3101; 124 / 62 */
        RTUINT128_INIT_C(0x0800d5abeb9942fe, 0x3e603fc5f1b2e135), RTUINT128_INIT_C(0x0000000000000000, 0x0bf19dad82dccb96),
        RTUINT128_INIT_C(0x0000000000000000, 0xab8a179cc64eff7c), RTUINT128_INIT_C(0x0000000000000000, 0x0580dc3c9441da8d)
    },
    { /* i=3102; 119 / 93 */
        RTUINT128_INIT_C(0x00052147e6ea33c1, 0x0877955b92e59e34), RTUINT128_INIT_C(0x0000000012ed56ea, 0x46b9e6f2809b5de8),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000004562e0), RTUINT128_INIT_C(0x000000000ed36794, 0xbc08020f4178a334)
    },
    { /* i=3103; 101 / 51 */
        RTUINT128_INIT_C(0x00000012f08aed8b, 0x19c545ed3bead527), RTUINT128_INIT_C(0x0000000000000000, 0x000784b792aa15a3),
        RTUINT128_INIT_C(0x0000000000000000, 0x000284e3533cbd42), RTUINT128_INIT_C(0x0000000000000000, 0x0006c6e7eee3ea21)
    },
    { /* i=3104; 109 / 93 */
        RTUINT128_INIT_C(0x00001b20acce20f3, 0x3df7dbacdc659efa), RTUINT128_INIT_C(0x0000000005c461ce, 0x93ef27787b552211),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000004b42f), RTUINT128_INIT_C(0x0000000001c09c45, 0x4f6cf881d38c69db)
    },
    { /* i=3105; 55 / 19 */
        RTUINT128_INIT_C(0x0000000000000000, 0x001860fa062e1bc9), RTUINT128_INIT_C(0x0000000000000000, 0x000000000007cb31),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000320c5327c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000031e0d)
    },
    { /* i=3106; 1 / 69 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x0000000000000012, 0x211916a8b9c59c1e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001)
    },
    { /* i=3107; 120 / 121 */
        RTUINT128_INIT_C(0x004cae8f03c51487, 0x34c43aa6b2773e9d), RTUINT128_INIT_C(0x017f294b23ffad85, 0xfd336ff659a9b31d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x004cae8f03c51487, 0x34c43aa6b2773e9d)
    },
    { /* i=3108; 57 / 48 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00c584b741eed850), RTUINT128_INIT_C(0x0000000000000000, 0x00009bc55a7a66b2),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000144), RTUINT128_INIT_C(0x0000000000000000, 0x00005ef0bf04df08)
    },
    { /* i=3109; 95 / 40 */
        RTUINT128_INIT_C(0x000000005f483092, 0xc0ed7cc15de8b077), RTUINT128_INIT_C(0x0000000000000000, 0x000000307b6577c6),
        RTUINT128_INIT_C(0x0000000000000000, 0x01f71e4892e804c2), RTUINT128_INIT_C(0x0000000000000000, 0x00000022cdb4d46b)
    },
    { /* i=3110; 58 / 8 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00c55e7c5f90536c), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000c8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000fca1e6e0b8bc), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000008c)
    },
    { /* i=3111; 22 / 6 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000333ff0), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000006),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000088aa8), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=3112; 67 / 29 */
        RTUINT128_INIT_C(0x0000000000000006, 0x0d778b4dc9d40fa8), RTUINT128_INIT_C(0x0000000000000000, 0x0000000009bf42aa),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000009ef77fbc89), RTUINT128_INIT_C(0x0000000000000000, 0x00000000052e8aae)
    },
    { /* i=3113; 126 / 49 */
        RTUINT128_INIT_C(0x04e402c84249a842, 0xe48d5aaf062f1061), RTUINT128_INIT_C(0x0000000000000000, 0x0001c393ea59a374),
        RTUINT128_INIT_C(0x00000000000002c5, 0xc4381b5a680a6d18), RTUINT128_INIT_C(0x0000000000000000, 0x0000c55960a75981)
    },
    { /* i=3114; 111 / 21 */
        RTUINT128_INIT_C(0x0000113ba4e95f63, 0xfca1477b0a9853ee), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000e8b0f),
        RTUINT128_INIT_C(0x00000000012f58fc, 0xb5d89f5110f733a5), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000bb643)
    },
    { /* i=3115; 96 / 33 */
        RTUINT128_INIT_C(0x0000000017b98b2d, 0xddcdbc8f9297a076), RTUINT128_INIT_C(0x0000000000000000, 0x0000000089e02fcf),
        RTUINT128_INIT_C(0x0000000000000000, 0x2c0d04c9313f3ae1), RTUINT128_INIT_C(0x0000000000000000, 0x0000000036c7b587)
    },
    { /* i=3116; 18 / 6 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000002a895), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000003a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000bbb), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000037)
    },
    { /* i=3117; 125 / 45 */
        RTUINT128_INIT_C(0x0ed61234c5621194, 0x92bf9fcd27bfa40b), RTUINT128_INIT_C(0x0000000000000000, 0x0000196331cd3922),
        RTUINT128_INIT_C(0x000000000000959a, 0xa6de4a3c413a7e5c), RTUINT128_INIT_C(0x0000000000000000, 0x000011abac2c5fd3)
    },
    { /* i=3118; 121 / 91 */
        RTUINT128_INIT_C(0x01d0d9a2deaa9186, 0x3efaacfdc28923f8), RTUINT128_INIT_C(0x0000000003a1c99c, 0x157dc19d4fbd93f0),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000007ffcecc7), RTUINT128_INIT_C(0x0000000001bc6a89, 0xfa529b305189e468)
    },
    { /* i=3119; 114 / 71 */
        RTUINT128_INIT_C(0x000353895da4a438, 0x5d40e6939d7431ba), RTUINT128_INIT_C(0x0000000000000066, 0x1b646dcd18b06107),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000856f3425f28), RTUINT128_INIT_C(0x0000000000000050, 0x05380871a5156fa2)
    },
    { /* i=3120; 56 / 106 */
        RTUINT128_INIT_C(0x0000000000000000, 0x007d880bf9222778), RTUINT128_INIT_C(0x0000037a43d766f5, 0x7ab83e5d925c6e9f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x007d880bf9222778)
    },
    { /* i=3121; 116 / 127 */
        RTUINT128_INIT_C(0x0007a681ce5d97eb, 0xbf633585ec993ae2), RTUINT128_INIT_C(0x08ea24f18eda9ce0, 0xd9a29adad17ea6ad),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0007a681ce5d97eb, 0xbf633585ec993ae2)
    },
    { /* i=3122; 117 / 11 */
        RTUINT128_INIT_C(0x00118871bcc3c41f, 0xd2f39638555f78e4), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000271),
        RTUINT128_INIT_C(0x0000072e777ee12f, 0x27a8bc3f2b25044a), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000003a)
    },
    { /* i=3123; 123 / 116 */
        RTUINT128_INIT_C(0x02ebf3429c89e7bc, 0x7f1cae8b305dccbd), RTUINT128_INIT_C(0x000b49ca1f0b12c3, 0xceddb9d29391c1df),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000042), RTUINT128_INIT_C(0x0002ed269baf1141, 0x29f2c64124c9d13f)
    },
    { /* i=3124; 113 / 127 */
        RTUINT128_INIT_C(0x0000be8e8705e1ff, 0x27af55b61de27617), RTUINT128_INIT_C(0x2a69bc7fef668450, 0x499a9f47a3bdaff1),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000be8e8705e1ff, 0x27af55b61de27617)
    },
    { /* i=3125; 114 / 84 */
        RTUINT128_INIT_C(0x0001f3a1e0adb886, 0xbf681a9aa240a69b), RTUINT128_INIT_C(0x00000000000143a1, 0x8fdaa28e14442f0a),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000018b38a1aa), RTUINT128_INIT_C(0x000000000000631f, 0xefa32a0393341ff7)
    },
    { /* i=3126; 92 / 73 */
        RTUINT128_INIT_C(0x0000000001e1e966, 0x2534804b7cfc8cbc), RTUINT128_INIT_C(0x00000000000000be, 0xd9eff4f194337d77),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000002866a), RTUINT128_INIT_C(0x000000000000006c, 0x63bf784a31104f76)
    },
    { /* i=3127; 121 / 109 */
        RTUINT128_INIT_C(0x01c62156c8d710dd, 0x8ccd6ebfefba21db), RTUINT128_INIT_C(0x00001df9a6b5fa78, 0x727624030e01ba08),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000f26), RTUINT128_INIT_C(0x00000d836026d447, 0xa327e879c1920cab)
    },
    { /* i=3128; 117 / 42 */
        RTUINT128_INIT_C(0x0019337947ad3ea0, 0x010bbbaa587b10ff), RTUINT128_INIT_C(0x0000000000000000, 0x0000002a086e2781),
        RTUINT128_INIT_C(0x000000000000997c, 0x75eca9e744d7a804), RTUINT128_INIT_C(0x0000000000000000, 0x000000117b7ecafb)
    },
    { /* i=3129; 127 / 121 */
        RTUINT128_INIT_C(0x7d06b0d32f166fb7, 0xc5dc4e7ca1b7aed6), RTUINT128_INIT_C(0x00b09f756c30696d, 0xc861ffdf5c0e51ac),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000b5), RTUINT128_INIT_C(0x0025f2cdb0dbe519, 0x189265908b97f03a)
    },
    { /* i=3130; 25 / 1 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000001c8ae7a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000001c8ae7a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=3131; 120 / 28 */
        RTUINT128_INIT_C(0x00475bee82abcba9, 0x1d47f30f9ceb4b21), RTUINT128_INIT_C(0x0000000000000000, 0x000000000cc0f954),
        RTUINT128_INIT_C(0x00000000059859ff, 0xc6a0470ff7616d8b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000001272685)
    },
    { /* i=3132; 116 / 70 */
        RTUINT128_INIT_C(0x000776242ab886cb, 0x68d6b90ec4533995), RTUINT128_INIT_C(0x000000000000002e, 0x8718e85a8a5e81e8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000290dc7d252c4), RTUINT128_INIT_C(0x0000000000000016, 0xd9e81a20a60b73f5)
    },
    { /* i=3133; 128 / 99 */
        RTUINT128_INIT_C(0x744224d79813d98e, 0x641cfc64a2f151f5), RTUINT128_INIT_C(0x00000000c735a17b, 0x03ce393f9849bdd2),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000009566b71b), RTUINT128_INIT_C(0x000000004ec2565f, 0xbf76e3f600cd2ecf)
    },
    { /* i=3134; 115 / 118 */
        RTUINT128_INIT_C(0x00041ccbc6430e50, 0xd288a1d4f53ac7ae), RTUINT128_INIT_C(0x00274bad47c8a1a0, 0xe3e667899576106d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00041ccbc6430e50, 0xd288a1d4f53ac7ae)
    },
    { /* i=3135; 42 / 10 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000003bd19ea0eee), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000033d),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000001278ef35b), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000013f)
    },
    { /* i=3136; 56 / 59 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00f007697a98810b), RTUINT128_INIT_C(0x0000000000000000, 0x02c4389a8a3f7f5e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00f007697a98810b)
    },
    { /* i=3137; 116 / 114 */
        RTUINT128_INIT_C(0x0008041bdf32a91f, 0x19a6500c1bada074), RTUINT128_INIT_C(0x000171ddea157fad, 0x2b5704a61c7d203d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000005), RTUINT128_INIT_C(0x0000cac64cc72abd, 0x40f338cd8d3bff43)
    },
    { /* i=3138; 112 / 14 */
        RTUINT128_INIT_C(0x0000a9f3b04b0ef7, 0xde68cff5a9f0dd00), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000324c),
        RTUINT128_INIT_C(0x00000003610489f6, 0x46efaa490176eec2), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001768)
    },
    { /* i=3139; 125 / 123 */
        RTUINT128_INIT_C(0x0e711439411f0db2, 0xa356eb57218ed43a), RTUINT128_INIT_C(0x070ac4c9584f2c46, 0x9ef262f7f57d6782),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002), RTUINT128_INIT_C(0x005b8aa69080b525, 0x6572256736940536)
    },
    { /* i=3140; 122 / 100 */
        RTUINT128_INIT_C(0x014056a395f9fc78, 0x4e92dcbb40daf5f4), RTUINT128_INIT_C(0x00000001fb26337c, 0xe43306092440771a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000a1b381), RTUINT128_INIT_C(0x00000001f02e32e2, 0xd7e4a13c01bdc3da)
    },
    { /* i=3141; 119 / 120 */
        RTUINT128_INIT_C(0x0027e51a4c6e275f, 0x60e4424639751662), RTUINT128_INIT_C(0x00c69810f1c3bcda, 0xd6696cd18e010fca),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0027e51a4c6e275f, 0x60e4424639751662)
    },
    { /* i=3142; 125 / 83 */
        RTUINT128_INIT_C(0x112f0b7361ad8583, 0xfc4aae5975ae32e3), RTUINT128_INIT_C(0x000000000005d637, 0x10bf6db4f95a17fc),
        RTUINT128_INIT_C(0x0000000000000000, 0x000002f1ad4b5e41), RTUINT128_INIT_C(0x000000000004f2d8, 0x8edfe400be2b93e7)
    },
    { /* i=3143; 120 / 118 */
        RTUINT128_INIT_C(0x0091ce0081935b7d, 0x31b562914e86edb8), RTUINT128_INIT_C(0x003e946654ca8503, 0xd9731c0c62671ee4),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002), RTUINT128_INIT_C(0x0014a533d7fe5175, 0x7ecf2a7889b8aff0)
    },
    { /* i=3144; 128 / 126 */
        RTUINT128_INIT_C(0x3e13fc9149343b54, 0x5f04f588d346dfa1), RTUINT128_INIT_C(0x3f3dcff1d2af7181, 0x034d819c587dfef0),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x3e13fc9149343b54, 0x5f04f588d346dfa1)
    },
    { /* i=3145; 99 / 93 */
        RTUINT128_INIT_C(0x000000007d09d64e, 0xa5a49eedc0363ae9), RTUINT128_INIT_C(0x0000000018105bb8, 0x6bd7f79f4fd4609f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000005), RTUINT128_INIT_C(0x0000000004b80bb4, 0x8a6cc8d1311057ce)
    },
    { /* i=3146; 126 / 106 */
        RTUINT128_INIT_C(0x29490cb36f2dbf7e, 0x5b7aefa1ff0ba4d6), RTUINT128_INIT_C(0x000001887dabc40d, 0xddcbb35b2ec8471b),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000001aed9a), RTUINT128_INIT_C(0x000000cde7f07221, 0x22a2e02137fedf98)
    },
    { /* i=3147; 68 / 9 */
        RTUINT128_INIT_C(0x0000000000000005, 0xfafc98243d4d6579), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000182),
        RTUINT128_INIT_C(0x0000000000000000, 0x03f75e920028a80e), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000005d)
    },
    { /* i=3148; 124 / 71 */
        RTUINT128_INIT_C(0x0d8ebec684879bb7, 0xe333eee13199da6a), RTUINT128_INIT_C(0x0000000000000012, 0xb3c67fd15f1d7252),
        RTUINT128_INIT_C(0x0000000000000000, 0x00b9943c2c9553c7), RTUINT128_INIT_C(0x000000000000000d, 0x7900124813eb66ac)
    },
    { /* i=3149; 122 / 65 */
        RTUINT128_INIT_C(0x01967b4c5957e6cb, 0xee7de79d9e1ef1e7), RTUINT128_INIT_C(0x0000000000000001, 0x46cffde30bff4fb8),
        RTUINT128_INIT_C(0x0000000000000000, 0x013e682145fe8f1f), RTUINT128_INIT_C(0x0000000000000000, 0xc81e96e5dc1c829f)
    },
    { /* i=3150; 86 / 38 */
        RTUINT128_INIT_C(0x0000000000045bf8, 0x9f2aa61b65066240), RTUINT128_INIT_C(0x0000000000000000, 0x00000032ef398756),
        RTUINT128_INIT_C(0x0000000000000000, 0x000015e8f1c7a4ff), RTUINT128_INIT_C(0x0000000000000000, 0x0000000e162b7b96)
    },
    { /* i=3151; 83 / 48 */
        RTUINT128_INIT_C(0x000000000001f2f7, 0x4b974681a76e79b5), RTUINT128_INIT_C(0x0000000000000000, 0x00000e031e185303),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000239c052214), RTUINT128_INIT_C(0x0000000000000000, 0x000001cb9f729779)
    },
    { /* i=3152; 92 / 77 */
        RTUINT128_INIT_C(0x000000000da0c3f1, 0xe79efaed22bc7bbc), RTUINT128_INIT_C(0x0000000000001e84, 0xac782f531a437eae),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000007251), RTUINT128_INIT_C(0x0000000000000729, 0xd084ffefc4f7eaae)
    },
    { /* i=3153; 3 / 127 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000004), RTUINT128_INIT_C(0x4bf135c784ddbda5, 0x2161196edfce5eac),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000004)
    },
    { /* i=3154; 28 / 5 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000002cfd30c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000011),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000002a57b5), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000007)
    },
    { /* i=3155; 113 / 127 */
        RTUINT128_INIT_C(0x00011d852562debc, 0x9ef8a0ee4b36e5b1), RTUINT128_INIT_C(0x7277a86788627e20, 0xed1cacafbee453e6),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00011d852562debc, 0x9ef8a0ee4b36e5b1)
    },
    { /* i=3156; 125 / 125 */
        RTUINT128_INIT_C(0x0d7a2b8b59c8609b, 0xf8dee45ed64ddd3f), RTUINT128_INIT_C(0x018426f286c8d240, 0xb204a13f05b9a101),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000008), RTUINT128_INIT_C(0x0158f3f72381ce96, 0x68b9da66a880d537)
    },
    { /* i=3157; 101 / 6 */
        RTUINT128_INIT_C(0x0000000f399ed26e, 0xa26d7810e041bda8), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002),
        RTUINT128_INIT_C(0x000000079ccf6937, 0x5136bc087020ded4), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=3158; 118 / 22 */
        RTUINT128_INIT_C(0x001b6b80709271fb, 0xd4240d0d1519bb4d), RTUINT128_INIT_C(0x0000000000000000, 0x00000000001433d9),
        RTUINT128_INIT_C(0x000000015b74e1ad, 0x480997bd2fdb89f9), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000112c3c)
    },
    { /* i=3159; 126 / 68 */
        RTUINT128_INIT_C(0x112207f599e78d6b, 0xa239c23f6c490aa0), RTUINT128_INIT_C(0x0000000000000004, 0xabbb3aeb619d24d4),
        RTUINT128_INIT_C(0x0000000000000000, 0x03ab06e51a43489e), RTUINT128_INIT_C(0x0000000000000002, 0x9289c602cf74afc8)
    },
    { /* i=3160; 120 / 7 */
        RTUINT128_INIT_C(0x002e30b153e7770c, 0xcf62afb4fa5bee40), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000077),
        RTUINT128_INIT_C(0x0000635dfe8dc6ea, 0x9854ba7c24862692), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000062)
    },
    { /* i=3161; 118 / 67 */
        RTUINT128_INIT_C(0x002a6e70439417c3, 0x9f67bdf4c73291ba), RTUINT128_INIT_C(0x0000000000000001, 0x5d374094a3427b12),
        RTUINT128_INIT_C(0x0000000000000000, 0x001f1af052ffd4a2), RTUINT128_INIT_C(0x0000000000000001, 0x3a9aa92e0e47c856)
    },
    { /* i=3162; 109 / 60 */
        RTUINT128_INIT_C(0x000004245f739086, 0xd053e18afc72b5bb), RTUINT128_INIT_C(0x0000000000000000, 0x0910bf5529d6d533),
        RTUINT128_INIT_C(0x0000000000000000, 0x000074f80ef5d5e8), RTUINT128_INIT_C(0x0000000000000000, 0x047030e27e8f1083)
    },
    { /* i=3163; 128 / 34 */
        RTUINT128_INIT_C(0x163681915df9ead5, 0x3c54cb626c3c3203), RTUINT128_INIT_C(0x0000000000000000, 0x00000000b5d6bba7),
        RTUINT128_INIT_C(0x000000001f45b157, 0x6cbf97a0a8b7251d), RTUINT128_INIT_C(0x0000000000000000, 0x000000000d68cd18)
    },
    { /* i=3164; 118 / 44 */
        RTUINT128_INIT_C(0x002766c816403e15, 0xdc79d01a885f6f75), RTUINT128_INIT_C(0x0000000000000000, 0x00000571635a5f1b),
        RTUINT128_INIT_C(0x000000000000073d, 0x313a4254c35847f4), RTUINT128_INIT_C(0x0000000000000000, 0x0000051b83944cb9)
    },
    { /* i=3165; 119 / 107 */
        RTUINT128_INIT_C(0x00084968e97cf58b, 0x7ba841807b437de9), RTUINT128_INIT_C(0x0000025a07dcc342, 0x1d86b79ef3ebb085),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000386), RTUINT128_INIT_C(0x0000003135a4fa97, 0x72fd47710ad3894b)
    },
    { /* i=3166; 40 / 17 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000010ef38aa5d), RTUINT128_INIT_C(0x0000000000000000, 0x000000000001eec1),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000008c32b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000008cf2)
    },
    { /* i=3167; 128 / 87 */
        RTUINT128_INIT_C(0xc39a2d90ce20bd57, 0xb7027706f6c5465d), RTUINT128_INIT_C(0x00000000002aae11, 0xff3de1e4136ccfe8),
        RTUINT128_INIT_C(0x0000000000000000, 0x000004953f798d68), RTUINT128_INIT_C(0x00000000000c338f, 0x094a7c0bc766081d)
    },
    { /* i=3168; 77 / 107 */
        RTUINT128_INIT_C(0x0000000000001800, 0xc0c20d0889aacfeb), RTUINT128_INIT_C(0x000003907b6919de, 0x049be939726488e8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000001800, 0xc0c20d0889aacfeb)
    },
    { /* i=3169; 125 / 104 */
        RTUINT128_INIT_C(0x1ea39ada303ea082, 0x496a94f9a3f30be2), RTUINT128_INIT_C(0x0000004a4e8462b2, 0x26476bedeed96fb7),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000698ea1), RTUINT128_INIT_C(0x00000044e52c09f1, 0x540ac2aaff2d47cb)
    },
    { /* i=3170; 121 / 20 */
        RTUINT128_INIT_C(0x0113c80c45383416, 0x0779d3cbc6cf0bcf), RTUINT128_INIT_C(0x0000000000000000, 0x000000000006abae),
        RTUINT128_INIT_C(0x0000002957b99c47, 0x622a7cdd801c9979), RTUINT128_INIT_C(0x0000000000000000, 0x000000000004e891)
    },
    { /* i=3171; 88 / 27 */
        RTUINT128_INIT_C(0x0000000000400a5e, 0xa8d721988ca87d97), RTUINT128_INIT_C(0x0000000000000000, 0x0000000003bef6ce),
        RTUINT128_INIT_C(0x0000000000000000, 0x11188dfa4b746c7b), RTUINT128_INIT_C(0x0000000000000000, 0x000000000071009d)
    },
    { /* i=3172; 36 / 24 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000088a8be9c), RTUINT128_INIT_C(0x0000000000000000, 0x00000000002f2276),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000002e6), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000adc98)
    },
    { /* i=3173; 122 / 72 */
        RTUINT128_INIT_C(0x01e3cbf2a6bf69ea, 0x5cb8f8923fd00065), RTUINT128_INIT_C(0x000000000000004b, 0x964b7bb5a78993ca),
        RTUINT128_INIT_C(0x0000000000000000, 0x00066688795ba6eb), RTUINT128_INIT_C(0x0000000000000049, 0x54bf0a1c3be259f7)
    },
    { /* i=3174; 124 / 114 */
        RTUINT128_INIT_C(0x0887aa6a48160d04, 0xba3f5d8c28d3fb97), RTUINT128_INIT_C(0x0003873821352517, 0x98e03e6dbdc70846),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000026a), RTUINT128_INIT_C(0x00033cea1dca820d, 0xace8a8a0065a029b)
    },
    { /* i=3175; 60 / 21 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0b4d2bc725bc0420), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000ad026),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000010b8fe9c89a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000071d44)
    },
    { /* i=3176; 125 / 49 */
        RTUINT128_INIT_C(0x0aa5a8cef5484ee7, 0xd5c8d9ea69203baa), RTUINT128_INIT_C(0x0000000000000000, 0x00000877bcac0032),
        RTUINT128_INIT_C(0x00000000000141e3, 0x5c7798ecb99ce45c), RTUINT128_INIT_C(0x0000000000000000, 0x000007cd2aaba1b2)
    },
    { /* i=3177; 92 / 20 */
        RTUINT128_INIT_C(0x000000000fc243c9, 0x0d80aac2de9e6c7b), RTUINT128_INIT_C(0x0000000000000000, 0x000000000009d61d),
        RTUINT128_INIT_C(0x000000000000019a, 0x231bc3572f2988bc), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000c72f)
    },
    { /* i=3178; 84 / 63 */
        RTUINT128_INIT_C(0x0000000000041cc1, 0x2535ec4ffdb3812b), RTUINT128_INIT_C(0x0000000000000000, 0x091ed465b6abe3ea),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000736d9d), RTUINT128_INIT_C(0x0000000000000000, 0x032d4bf0642018a9)
    },
    { /* i=3179; 108 / 17 */
        RTUINT128_INIT_C(0x00000a8fe2001590, 0x8d61b2b73e3e101f), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000017cfc),
        RTUINT128_INIT_C(0x000000000718db4e, 0x4918a7d286630087), RTUINT128_INIT_C(0x0000000000000000, 0x000000000001273b)
    },
    { /* i=3180; 126 / 100 */
        RTUINT128_INIT_C(0x0d4d577efd16b011, 0x08d72b3fb0890666), RTUINT128_INIT_C(0x0000000c1e74bb98, 0x3b8720f224d3c1f6),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000118fe21), RTUINT128_INIT_C(0x0000000a0f685a95, 0x40e363e2b1baf1b0)
    },
    { /* i=3181; 124 / 88 */
        RTUINT128_INIT_C(0x0ab47475190045cc, 0xcea89d646e3e4b5f), RTUINT128_INIT_C(0x0000000000070d01, 0xda44ce13191bb2ed),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000184ac210d2a), RTUINT128_INIT_C(0x0000000000035924, 0x0d97cdfe9b0fe77d)
    },
    { /* i=3182; 37 / 16 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000343988baa), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000010fa),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000313876), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000086e)
    },
    { /* i=3183; 79 / 50 */
        RTUINT128_INIT_C(0x0000000000003e00, 0x62f41fa371abee8a), RTUINT128_INIT_C(0x0000000000000000, 0x000100890b743d17),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000003ddf43b4), RTUINT128_INIT_C(0x0000000000000000, 0x0000347845eaf55e)
    },
    { /* i=3184; 68 / 2 */
        RTUINT128_INIT_C(0x0000000000000003, 0x6ab75d25bd57a8f2), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001),
        RTUINT128_INIT_C(0x0000000000000003, 0x6ab75d25bd57a8f2), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=3185; 59 / 119 */
        RTUINT128_INIT_C(0x0000000000000000, 0x017632df0774a832), RTUINT128_INIT_C(0x00222559aa2e96c7, 0xfb364deefecc4c77),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x017632df0774a832)
    },
    { /* i=3186; 89 / 29 */
        RTUINT128_INIT_C(0x0000000000f18020, 0x7f8e94efae01562f), RTUINT128_INIT_C(0x0000000000000000, 0x0000000016a70929),
        RTUINT128_INIT_C(0x0000000000000000, 0x0aa93e265fcee278), RTUINT128_INIT_C(0x0000000000000000, 0x0000000003a0d8f7)
    },
    { /* i=3187; 116 / 72 */
        RTUINT128_INIT_C(0x0000b0add4a6162c, 0xe3cf85bbf10aa077), RTUINT128_INIT_C(0x000000000000002c, 0x01ee6c13afec5ba9),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000403c643e65f), RTUINT128_INIT_C(0x0000000000000023, 0xb2d029a39abfc6c0)
    },
    { /* i=3188; 115 / 113 */
        RTUINT128_INIT_C(0x0001f707ab9c699e, 0x47fc7e1b06e2658e), RTUINT128_INIT_C(0x00010a4aeb1b5f0e, 0xcb3618875eea2fe0),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x0000ecbcc0810a8f, 0x7cc66593a7f835ae)
    },
    { /* i=3189; 119 / 20 */
        RTUINT128_INIT_C(0x0029d53831144b5f, 0xcae13381bd2060b2), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000b66b9),
        RTUINT128_INIT_C(0x00000003ab4d26a1, 0x5efde8425b33923c), RTUINT128_INIT_C(0x0000000000000000, 0x000000000003cb56)
    },
    { /* i=3190; 75 / 19 */
        RTUINT128_INIT_C(0x0000000000000209, 0x038a0ac629bf7bae), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000057b02),
        RTUINT128_INIT_C(0x0000000000000000, 0x005f111d5c3eaaa7), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000e960)
    },
    { /* i=3191; 87 / 77 */
        RTUINT128_INIT_C(0x0000000000665962, 0x39d595e93f2ae880), RTUINT128_INIT_C(0x0000000000001be2, 0x87c1e6bd6df5188a),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000003ab), RTUINT128_INIT_C(0x000000000000117a, 0x459c3d16ed29e652)
    },
    { /* i=3192; 115 / 92 */
        RTUINT128_INIT_C(0x00037aab2f4042bb, 0xc0bc38c82651ede5), RTUINT128_INIT_C(0x00000000050ac467, 0x8d0547f73af7255e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000b0a5d6), RTUINT128_INIT_C(0x00000000007862a5, 0xfcf72d31e0031b51)
    },
    { /* i=3193; 109 / 33 */
        RTUINT128_INIT_C(0x00001f73ddb87b99, 0x3d2d7ef2e22292bd), RTUINT128_INIT_C(0x0000000000000000, 0x00000000215e04bd),
        RTUINT128_INIT_C(0x000000000000f14f, 0x74f94a439c4795c4), RTUINT128_INIT_C(0x0000000000000000, 0x0000000020f9f109)
    },
    { /* i=3194; 119 / 107 */
        RTUINT128_INIT_C(0x0079cb4f1fc06c1e, 0xc848d4c4e751836e), RTUINT128_INIT_C(0x000003aa94c827a2, 0x4111cffd02704999),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000002138), RTUINT128_INIT_C(0x000000d0c6dbd63d, 0x4093b81be544b0f6)
    },
    { /* i=3195; 76 / 64 */
        RTUINT128_INIT_C(0x0000000000000f8b, 0x146accc761820f73), RTUINT128_INIT_C(0x0000000000000000, 0x37c533ff9b9b5005),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000004758), RTUINT128_INIT_C(0x0000000000000000, 0x373508c1d0ed2abb)
    },
    { /* i=3196; 123 / 70 */
        RTUINT128_INIT_C(0x03aa46c948751e40, 0xfe56b253386e164f), RTUINT128_INIT_C(0x0000000000000011, 0x86f637b3be5654dd),
        RTUINT128_INIT_C(0x0000000000000000, 0x00358859496e8d0b), RTUINT128_INIT_C(0x0000000000000001, 0xc9b7fda40204b7d0)
    },
    { /* i=3197; 115 / 66 */
        RTUINT128_INIT_C(0x0004758d3fd9f6f0, 0xf327a31b2891c419), RTUINT128_INIT_C(0x0000000000000001, 0xd8afa9cd5933b4cb),
        RTUINT128_INIT_C(0x0000000000000000, 0x00026a3f77885ead), RTUINT128_INIT_C(0x0000000000000000, 0x945e841d7b660cea)
    },
    { /* i=3198; 82 / 1 */
        RTUINT128_INIT_C(0x000000000002cc53, 0xd68f671fd25433b2), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001),
        RTUINT128_INIT_C(0x000000000002cc53, 0xd68f671fd25433b2), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=3199; 117 / 53 */
        RTUINT128_INIT_C(0x000fe3a1cee867ce, 0x12be86c25235f1a6), RTUINT128_INIT_C(0x0000000000000000, 0x00145dd24d8bd041),
        RTUINT128_INIT_C(0x0000000000000000, 0xc7b8c7cfea5c4581), RTUINT128_INIT_C(0x0000000000000000, 0x0013fab94e447be5)
    },
    { /* i=3200; 75 / 91 */
        RTUINT128_INIT_C(0x0000000000000077, 0x5a880144908bc8d0), RTUINT128_INIT_C(0x0000000007199ea1, 0xc952387849e1e2c5),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000077, 0x5a880144908bc8d0)
    },
    { /* i=3201; 127 / 96 */
        RTUINT128_INIT_C(0x0ac78fc669178e51, 0x35ecf10a47891f8b), RTUINT128_INIT_C(0x00000000bc5020ce, 0x5ebdb44012a15fa1),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000ea77484), RTUINT128_INIT_C(0x00000000511af35e, 0x4f9dfd0f5cf7dc87)
    },
    { /* i=3202; 88 / 24 */
        RTUINT128_INIT_C(0x00000000003c84b2, 0x525ff04c83025360), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000c3b2fe),
        RTUINT128_INIT_C(0x0000000000000000, 0x4f2a767b39600653), RTUINT128_INIT_C(0x0000000000000000, 0x00000000001d5706)
    },
    { /* i=3203; 118 / 124 */
        RTUINT128_INIT_C(0x002c06f0053ec94e, 0x662690c98c715f0c), RTUINT128_INIT_C(0x0f5cb1325e7a3745, 0x944236d854df91f0),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x002c06f0053ec94e, 0x662690c98c715f0c)
    },
    { /* i=3204; 36 / 11 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000032621954e), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000003f9),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000caeb81), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000001d5)
    },
    { /* i=3205; 117 / 125 */
        RTUINT128_INIT_C(0x0000bb1fd8ce6466, 0xf22efb378b26df01), RTUINT128_INIT_C(0x0fbfa63a82e7282d, 0x4aa9377b37a09c2b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000bb1fd8ce6466, 0xf22efb378b26df01)
    },
    { /* i=3206; 44 / 2 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000040b05502249), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000040b05502249), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=3207; 118 / 116 */
        RTUINT128_INIT_C(0x003565f9b66427aa, 0xadaa2ec2effe3b41), RTUINT128_INIT_C(0x0000d81da02f5085, 0xd75299a0198e7e61),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000003f), RTUINT128_INIT_C(0x000036af4abf56ba, 0xb056605ca5ed2162)
    },
    { /* i=3208; 113 / 90 */
        RTUINT128_INIT_C(0x00009ae03da24679, 0x5da70e3ecae69f63), RTUINT128_INIT_C(0x0000000003a5780c, 0x9d04ff1a5682b652),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000002a795d), RTUINT128_INIT_C(0x0000000002b5f0db, 0x1bf0bd57abc9a199)
    },
    { /* i=3209; 121 / 107 */
        RTUINT128_INIT_C(0x01b7adb3c58e7273, 0x55dec058bc729fec), RTUINT128_INIT_C(0x000004b4b2141b03, 0x723d65238353cc2f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000005d6e), RTUINT128_INIT_C(0x0000035df31a9677, 0xf1bf6460dd43d0ba)
    },
    { /* i=3210; 112 / 99 */
        RTUINT128_INIT_C(0x00003d9afa96e9fa, 0xede27baac5c5898e), RTUINT128_INIT_C(0x00000001546841e4, 0x3ae599b99f06df60),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000002e54), RTUINT128_INIT_C(0x000000008c8a4882, 0x58ecb02f5b60fe0e)
    },
    { /* i=3211; 114 / 3 */
        RTUINT128_INIT_C(0x0002fe61e9852a6a, 0x751e85ed41079633), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000004),
        RTUINT128_INIT_C(0x0000bf987a614a9a, 0x9d47a17b5041e58c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003)
    },
    { /* i=3212; 115 / 15 */
        RTUINT128_INIT_C(0x00075a6b96af8628, 0x688a84f69dc8b76f), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000076fd),
        RTUINT128_INIT_C(0x0000000fd1f9a6f6, 0x4716082c593da8e3), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000002d18)
    },
    { /* i=3213; 57 / 36 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0138d51fe0e6387d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000b4f788bde),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000001ba8a4), RTUINT128_INIT_C(0x0000000000000000, 0x000000031b78ee45)
    },
    { /* i=3214; 108 / 8 */
        RTUINT128_INIT_C(0x000005d1747bc757, 0xf55df4df04691df3), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000002d),
        RTUINT128_INIT_C(0x000000211958157f, 0x1c3549b54fbe11bb), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000014)
    },
    { /* i=3215; 29 / 5 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000001a7e4f6b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000005),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000054c7648), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003)
    },
    { /* i=3216; 67 / 59 */
        RTUINT128_INIT_C(0x0000000000000003, 0xa73b4569a5a7f9a0), RTUINT128_INIT_C(0x0000000000000000, 0x068903620fd0f757),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000008f), RTUINT128_INIT_C(0x0000000000000000, 0x00b261a2cfedd007)
    },
    { /* i=3217; 100 / 2 */
        RTUINT128_INIT_C(0x0000000e88639a54, 0x2ce795c1b89a1c35), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001),
        RTUINT128_INIT_C(0x0000000e88639a54, 0x2ce795c1b89a1c35), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=3218; 93 / 56 */
        RTUINT128_INIT_C(0x00000000072cfe12, 0x50e0cfc57deaa823), RTUINT128_INIT_C(0x0000000000000000, 0x003273f4a91027e7),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000002468f66411), RTUINT128_INIT_C(0x0000000000000000, 0x002ce843c447c5cc)
    },
    { /* i=3219; 33 / 18 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000001e7461109), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000246d),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000d608d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000002100)
    },
    { /* i=3220; 1 / 41 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x0000000000000000, 0x0000000ad319d60a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001)
    },
    { /* i=3221; 114 / 113 */
        RTUINT128_INIT_C(0x0002ec99fe0c5e8c, 0xf6aa694b14837e9a), RTUINT128_INIT_C(0x0001b847060dfa2e, 0x2b0a726de28e27fb),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x00013452f7fe645e, 0xcb9ff6dd31f5569f)
    },
    { /* i=3222; 125 / 71 */
        RTUINT128_INIT_C(0x03b8df411cd563b4, 0x96be16ec32b28d6d), RTUINT128_INIT_C(0x000000000000003c, 0x88de83d62f635986),
        RTUINT128_INIT_C(0x0000000000000000, 0x000fbdae19b74d6a), RTUINT128_INIT_C(0x0000000000000026, 0x06beb9249cd82df1)
    },
    { /* i=3223; 118 / 72 */
        RTUINT128_INIT_C(0x000b6ac451fe8a01, 0x7078920ed876afe2), RTUINT128_INIT_C(0x0000000000000060, 0x851ffc8cd93b46e8),
        RTUINT128_INIT_C(0x0000000000000000, 0x00001e480d9b8953), RTUINT128_INIT_C(0x0000000000000035, 0x0da7a565fad48aaa)
    },
    { /* i=3224; 120 / 96 */
        RTUINT128_INIT_C(0x00dbb46659b67eb2, 0x8adecd4c079ae6ed), RTUINT128_INIT_C(0x000000002634b781, 0x53b36f93e60ef806),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000005c0235d), RTUINT128_INIT_C(0x000000001bd7de84, 0x0803360b45c1fabf)
    },
    { /* i=3225; 117 / 119 */
        RTUINT128_INIT_C(0x0000671bc9ddc1d0, 0x3f63dff8ad0cd15e), RTUINT128_INIT_C(0x006225cd47ce60ec, 0xa5ee29be2eb0e683),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000671bc9ddc1d0, 0x3f63dff8ad0cd15e)
    },
    { /* i=3226; 116 / 119 */
        RTUINT128_INIT_C(0x00048995391b3a29, 0x236f23e3a95cc836), RTUINT128_INIT_C(0x00602d3b14d7b0a2, 0xcf92d55fd38faaba),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00048995391b3a29, 0x236f23e3a95cc836)
    },
    { /* i=3227; 124 / 117 */
        RTUINT128_INIT_C(0x01b946ea15d88c9d, 0xa1958fb3a6437f7f), RTUINT128_INIT_C(0x000f45c35b6f8675, 0x13ab827a9e1b97bd),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000001c), RTUINT128_INIT_C(0x000da58c15a5d7cf, 0x7ad34a4a5b3ee6d3)
    },
    { /* i=3228; 114 / 126 */
        RTUINT128_INIT_C(0x0003db1f0b924f98, 0x91cda01e8d4199b0), RTUINT128_INIT_C(0x0e87fbee77ebfa5e, 0xef78f17efbfa9729),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0003db1f0b924f98, 0x91cda01e8d4199b0)
    },
    { /* i=3229; 55 / 23 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0005bff88afd31f8), RTUINT128_INIT_C(0x0000000000000000, 0x00000000005cb2f1),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000fe108b2), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000203e66)
    },
    { /* i=3230; 70 / 4 */
        RTUINT128_INIT_C(0x000000000000000f, 0x3a6a276a597cfd24), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000008),
        RTUINT128_INIT_C(0x0000000000000001, 0xe74d44ed4b2f9fa4), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000004)
    },
    { /* i=3231; 120 / 53 */
        RTUINT128_INIT_C(0x00ba349611d3ad48, 0x376f36f8e0e3f6ca), RTUINT128_INIT_C(0x0000000000000000, 0x000e835a6cac5ea9),
        RTUINT128_INIT_C(0x000000000000000c, 0xd4858a7adfeb0089), RTUINT128_INIT_C(0x0000000000000000, 0x0005cc5a9c824e59)
    },
    { /* i=3232; 52 / 103 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000127ee50f54387), RTUINT128_INIT_C(0x00000038a71d9c96, 0x4bf46e0e123d0e34),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000127ee50f54387)
    },
    { /* i=3233; 102 / 14 */
        RTUINT128_INIT_C(0x000000271493382d, 0x2d075aa74aef405a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000003323),
        RTUINT128_INIT_C(0x0000000000c3a4c7, 0x3bebd6c3b9320f83), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000871)
    },
    { /* i=3234; 75 / 68 */
        RTUINT128_INIT_C(0x00000000000000fa, 0x34e282113827e913), RTUINT128_INIT_C(0x000000000000000d, 0x465fb2b76641230e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000012), RTUINT128_INIT_C(0x000000000000000b, 0x4227f12c07937217)
    },
    { /* i=3235; 121 / 99 */
        RTUINT128_INIT_C(0x01e59f058868f91b, 0xe43eded5d2d3013d), RTUINT128_INIT_C(0x000000038fcddb26, 0x233c9fc32a95c98d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000885810), RTUINT128_INIT_C(0x000000015bf37267, 0xf9db2c6c9945f06d)
    },
    { /* i=3236; 111 / 22 */
        RTUINT128_INIT_C(0x0000656cac3bbc01, 0x2353aad45f67f204), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000dbeb9),
        RTUINT128_INIT_C(0x000000000761067c, 0x2591d3d34a4e9100), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000032904)
    },
    { /* i=3237; 118 / 115 */
        RTUINT128_INIT_C(0x0031337a8af9bed6, 0xb73cd53c1fac4d38), RTUINT128_INIT_C(0x000187630507d617, 0x4ad60b1b515f482a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000020), RTUINT128_INIT_C(0x00004719e9fefbed, 0x5c7b71d1f3c347f8)
    },
    { /* i=3238; 124 / 95 */
        RTUINT128_INIT_C(0x05c5d9db953503ea, 0x0cf356df4df6e999), RTUINT128_INIT_C(0x000000003f74c7df, 0xce85580fe829cc39),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000174a10b7), RTUINT128_INIT_C(0x0000000009fc7890, 0x33ab878f93d85cda)
    },
    { /* i=3239; 69 / 50 */
        RTUINT128_INIT_C(0x0000000000000010, 0x07e2cdaac264ae3a), RTUINT128_INIT_C(0x0000000000000000, 0x0000c194d4cc68f4),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000153325), RTUINT128_INIT_C(0x0000000000000000, 0x0000b7feabece6f6)
    },
    { /* i=3240; 127 / 106 */
        RTUINT128_INIT_C(0x65b921bcfbe54976, 0x8a25968ed665bc95), RTUINT128_INIT_C(0x0000018f2916f7ed, 0x2f9da4f9a856b3c9),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000413d60), RTUINT128_INIT_C(0x0000006e26fbb525, 0x3b547dcf67026c35)
    },
    { /* i=3241; 122 / 108 */
        RTUINT128_INIT_C(0x0085cdf99b7c44f4, 0x992374e24f18411d), RTUINT128_INIT_C(0x000001679029e8fc, 0x00c3d97259ca9e9f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000005f43), RTUINT128_INIT_C(0x0000015f530ec6b7, 0xb8301ca29e33bc80)
    },
    { /* i=3242; 125 / 110 */
        RTUINT128_INIT_C(0x097af5b37726642f, 0x48d15c17f41c4ad2), RTUINT128_INIT_C(0x00000bd9321a2346, 0xe83f85e1b1beecab),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000ccd5), RTUINT128_INIT_C(0x0000060ff34a891d, 0x6d471daaeba91c8b)
    },
    { /* i=3243; 117 / 96 */
        RTUINT128_INIT_C(0x00003333ef9c8fc0, 0x7d76b7ad3416014b), RTUINT128_INIT_C(0x00000000cbe34770, 0x32d864853aba6fef),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000404a), RTUINT128_INIT_C(0x000000002e0ddc9b, 0xb1c85a7b9e35e635)
    },
    { /* i=3244; 127 / 52 */
        RTUINT128_INIT_C(0x4bfd7c3d353a40e3, 0x162f8211e939bcc8), RTUINT128_INIT_C(0x0000000000000000, 0x000466850a10a85a),
        RTUINT128_INIT_C(0x0000000000001144, 0xc6e52fe9368670ae), RTUINT128_INIT_C(0x0000000000000000, 0x00011718ad23ef9c)
    },
    { /* i=3245; 125 / 2 */
        RTUINT128_INIT_C(0x033fc9013dbf159d, 0xaebb22de1ad819d2), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002),
        RTUINT128_INIT_C(0x019fe4809edf8ace, 0xd75d916f0d6c0ce9), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=3246; 119 / 31 */
        RTUINT128_INIT_C(0x002d2f957aa4324f, 0x7376f56753ee4a4f), RTUINT128_INIT_C(0x0000000000000000, 0x000000001bd87dba),
        RTUINT128_INIT_C(0x00000000019f6aef, 0x3fd84a12898e771f), RTUINT128_INIT_C(0x0000000000000000, 0x000000000b199ac9)
    },
    { /* i=3247; 98 / 76 */
        RTUINT128_INIT_C(0x00000003474e2096, 0xc5304849b9d93ad4), RTUINT128_INIT_C(0x0000000000000bdf, 0x2a72cc18c5b3e1fc),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000046b29e), RTUINT128_INIT_C(0x00000000000005f2, 0xf1a70858d6ca894c)
    },
    { /* i=3248; 67 / 68 */
        RTUINT128_INIT_C(0x0000000000000002, 0x57304ac43f8aef86), RTUINT128_INIT_C(0x0000000000000002, 0x7c441d63d9910cf6),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000002, 0x57304ac43f8aef86)
    },
    { /* i=3249; 118 / 101 */
        RTUINT128_INIT_C(0x000f58cb10a433d0, 0xd19ec91b5509a955), RTUINT128_INIT_C(0x00000015470ccd95, 0x05da8838ca0a7dde),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000b8a5), RTUINT128_INIT_C(0x0000000311a0968e, 0xf9dc2b4991cef93f)
    },
    { /* i=3250; 122 / 45 */
        RTUINT128_INIT_C(0x03072b04164d7239, 0x173580643bdb166e), RTUINT128_INIT_C(0x0000000000000000, 0x0000149781017b5f),
        RTUINT128_INIT_C(0x00000000000025a4, 0xfc89e56ba6a26e34), RTUINT128_INIT_C(0x0000000000000000, 0x0000138ab86d3522)
    },
    { /* i=3251; 85 / 12 */
        RTUINT128_INIT_C(0x0000000000165f1a, 0x91594a6f0660a411), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000091f),
        RTUINT128_INIT_C(0x0000000000000273, 0xe587c47fe21275d1), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000006c2)
    },
    { /* i=3252; 128 / 77 */
        RTUINT128_INIT_C(0x989d206b09ec1e40, 0x73f7980b057efb2f), RTUINT128_INIT_C(0x0000000000000aaa, 0x2039f11b544b67d0),
        RTUINT128_INIT_C(0x0000000000000000, 0x000e4f74c53ae241), RTUINT128_INIT_C(0x000000000000096b, 0x51c3e5777793ff5f)
    },
    { /* i=3253; 93 / 89 */
        RTUINT128_INIT_C(0x0000000005eaa325, 0xb8396d83b25d8c10), RTUINT128_INIT_C(0x00000000005bef88, 0x87fe85dbb6204920),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000010), RTUINT128_INIT_C(0x00000000002baa9d, 0x38510fc85058fa10)
    },
    { /* i=3254; 86 / 69 */
        RTUINT128_INIT_C(0x000000000023d62b, 0x750c58910968cbb7), RTUINT128_INIT_C(0x0000000000000017, 0x595d43dc8b1c6253),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000188e9), RTUINT128_INIT_C(0x0000000000000014, 0x4f3fdfd2f604362c)
    },
    { /* i=3255; 117 / 118 */
        RTUINT128_INIT_C(0x000ad9f8bdf8d7b3, 0x2f6ac8085aaa448b), RTUINT128_INIT_C(0x00253e0f6aaac72a, 0xf8e4431a9ac381ca),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000ad9f8bdf8d7b3, 0x2f6ac8085aaa448b)
    },
    { /* i=3256; 88 / 46 */
        RTUINT128_INIT_C(0x0000000000f8427e, 0x47df706d8ed2db49), RTUINT128_INIT_C(0x0000000000000000, 0x000027dd07f05138),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000063a4e8a1964), RTUINT128_INIT_C(0x0000000000000000, 0x0000115524d4a969)
    },
    { /* i=3257; 120 / 75 */
        RTUINT128_INIT_C(0x006cbd6f28512bb8, 0xa144bbab3b11235e), RTUINT128_INIT_C(0x0000000000000177, 0x4971e20105966120),
        RTUINT128_INIT_C(0x0000000000000000, 0x00004a2d292705f2), RTUINT128_INIT_C(0x000000000000012e, 0xeea3cf811723b31e)
    },
    { /* i=3258; 84 / 30 */
        RTUINT128_INIT_C(0x00000000000c8a65, 0x3da835e46ce123f2), RTUINT128_INIT_C(0x0000000000000000, 0x000000003b4522be),
        RTUINT128_INIT_C(0x0000000000000000, 0x00362a617be36fe2), RTUINT128_INIT_C(0x0000000000000000, 0x00000000074e1636)
    },
    { /* i=3259; 88 / 68 */
        RTUINT128_INIT_C(0x0000000000dca5d1, 0xbb320d3fbcbef054), RTUINT128_INIT_C(0x000000000000000b, 0x94354b9e2acdcc27),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000130e53), RTUINT128_INIT_C(0x0000000000000001, 0x270ab55a73f69daf)
    },
    { /* i=3260; 94 / 4 */
        RTUINT128_INIT_C(0x00000000372d74ba, 0x09921d82c5185294), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000004),
        RTUINT128_INIT_C(0x000000000dcb5d2e, 0x82648760b14614a5), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=3261; 56 / 23 */
        RTUINT128_INIT_C(0x0000000000000000, 0x003eeadbcca816b2), RTUINT128_INIT_C(0x0000000000000000, 0x00000000006b2cb0),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000009649451b), RTUINT128_INIT_C(0x0000000000000000, 0x00000000001ef022)
    },
    { /* i=3262; 119 / 90 */
        RTUINT128_INIT_C(0x0023ada7630b7e1d, 0x8e851a1c46ba4578), RTUINT128_INIT_C(0x00000000029462d7, 0xfb07cf487df88423),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000dd4ade3), RTUINT128_INIT_C(0x0000000000109bf7, 0x59165f306e15736f)
    },
    { /* i=3263; 56 / 35 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00b5ce8785af34ec), RTUINT128_INIT_C(0x0000000000000000, 0x00000005f1838c31),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000001e96f1), RTUINT128_INIT_C(0x0000000000000000, 0x00000001a6f584cb)
    },
    { /* i=3264; 3 / 58 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000006), RTUINT128_INIT_C(0x0000000000000000, 0x01f9222935228b01),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000006)
    },
    { /* i=3265; 122 / 17 */
        RTUINT128_INIT_C(0x009ea85a88c42462, 0xebbbdbf64112e50b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000003420),
        RTUINT128_INIT_C(0x0000030b35eb4b97, 0x1b116a2075aefc10), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000230b)
    },
    { /* i=3266; 115 / 24 */
        RTUINT128_INIT_C(0x0006bde86296aa36, 0x74d5a02fa02cb22e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000416815),
        RTUINT128_INIT_C(0x000000001a632b0f, 0x98cc3ecf05667082), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000ea784)
    },
    { /* i=3267; 126 / 13 */
        RTUINT128_INIT_C(0x12ab4009baf5e438, 0xbe4ee9a4e64d7f7e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000b9f),
        RTUINT128_INIT_C(0x00019b41a8e4cdfe, 0xd07a63e5a350a7c1), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000039f)
    },
    { /* i=3268; 127 / 117 */
        RTUINT128_INIT_C(0x166817a406f3262a, 0x8abbd1a93194fb6c), RTUINT128_INIT_C(0x00084c8462c0afc9, 0x0075e3d5d1c0596c),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000002b3), RTUINT128_INIT_C(0x00018e4d78d8aa9e, 0x4c85d78407639ce8)
    },
    { /* i=3269; 34 / 26 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000034c5732), RTUINT128_INIT_C(0x0000000000000000, 0x0000000001dca567),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x0000000000000000, 0x00000000016fb1cb)
    },
    { /* i=3270; 53 / 29 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00067b659d3ae501), RTUINT128_INIT_C(0x0000000000000000, 0x0000000002530720),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000002c9ecf5), RTUINT128_INIT_C(0x0000000000000000, 0x0000000001139361)
    },
    { /* i=3271; 106 / 56 */
        RTUINT128_INIT_C(0x0000014984f078e9, 0x4ba75719107aa170), RTUINT128_INIT_C(0x0000000000000000, 0x0078727581649326),
        RTUINT128_INIT_C(0x0000000000000000, 0x0002bc5d71e550d1), RTUINT128_INIT_C(0x0000000000000000, 0x006dac0198649f6a)
    },
    { /* i=3272; 123 / 95 */
        RTUINT128_INIT_C(0x07feb3c361e4f2d3, 0x21c595ab18f713c9), RTUINT128_INIT_C(0x000000001dc00c86, 0x1aacd09250095e3d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000044cbd865), RTUINT128_INIT_C(0x000000000d21ccf8, 0x8a53e3f3af626db8)
    },
    { /* i=3273; 54 / 14 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0039a6035fee2c5b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000002a9b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000015a6344b2ce), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001da1)
    },
    { /* i=3274; 119 / 9 */
        RTUINT128_INIT_C(0x007b4b3bc7ecc5f2, 0x4ba8762cfa03d246), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000175),
        RTUINT128_INIT_C(0x0000549eb3aad809, 0x9263f814b5dc523c), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000da)
    },
    { /* i=3275; 106 / 100 */
        RTUINT128_INIT_C(0x000000609c77e842, 0x3fada50bf6931ff9), RTUINT128_INIT_C(0x00000007f42c647d, 0xa1aaec462d78633a),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000c), RTUINT128_INIT_C(0x000000012a63325e, 0xabaa91c1d4ee7941)
    },
    { /* i=3276; 127 / 87 */
        RTUINT128_INIT_C(0x3006e54ae093e830, 0x0f161520d1ee6261), RTUINT128_INIT_C(0x00000000004a5d0b, 0x553c6eba9770a55e),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000a555cee0d1), RTUINT128_INIT_C(0x00000000001501b1, 0xedd3912556a120a3)
    },
    { /* i=3277; 116 / 127 */
        RTUINT128_INIT_C(0x0002fc57a99fc688, 0x7321a0c21cc98606), RTUINT128_INIT_C(0x69b89d814547a8f1, 0x672765413a691ebe),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0002fc57a99fc688, 0x7321a0c21cc98606)
    },
    { /* i=3278; 123 / 112 */
        RTUINT128_INIT_C(0x07cb4469229b3580, 0x57f6c1b18742a870), RTUINT128_INIT_C(0x0000f173bb21198e, 0xe4ce8c5e33fbc5c7),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000843), RTUINT128_INIT_C(0x0000754620250df4, 0x0185136a0e2fad5b)
    },
    { /* i=3279; 113 / 10 */
        RTUINT128_INIT_C(0x0001d2f876280aa8, 0xb0a8bf30dda66b32), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000149),
        RTUINT128_INIT_C(0x0000016b5b660e09, 0xd9a1953381101171), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000f9)
    },
    { /* i=3280; 66 / 71 */
        RTUINT128_INIT_C(0x0000000000000001, 0x2aa97d0ef9f63d80), RTUINT128_INIT_C(0x000000000000007d, 0x91442b25033d5575),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000001, 0x2aa97d0ef9f63d80)
    },
    { /* i=3281; 86 / 22 */
        RTUINT128_INIT_C(0x00000000000801f9, 0x54ce10688e001431), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000a29cb),
        RTUINT128_INIT_C(0x0000000000000000, 0xc9b459a4c25cf450), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000988c1)
    },
    { /* i=3282; 114 / 5 */
        RTUINT128_INIT_C(0x00029c567bb2dfd3, 0x2cbafb2305f7d82c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000018),
        RTUINT128_INIT_C(0x00001bd8efd21ea8, 0xcc87ca76caea53ac), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000c)
    },
    { /* i=3283; 113 / 119 */
        RTUINT128_INIT_C(0x00008117ab418f98, 0x32c14096d686397f), RTUINT128_INIT_C(0x007090c9cfb50a36, 0xba6125cfa9c97df3),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00008117ab418f98, 0x32c14096d686397f)
    },
    { /* i=3284; 19 / 19 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000642a0), RTUINT128_INIT_C(0x0000000000000000, 0x000000000007e947),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000642a0)
    },
    { /* i=3285; 81 / 62 */
        RTUINT128_INIT_C(0x000000000001fa03, 0x300e1045194ab761), RTUINT128_INIT_C(0x0000000000000000, 0x056b8ab383e7d6e7),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000005d5bd7), RTUINT128_INIT_C(0x0000000000000000, 0x0537d864d6461e60)
    },
    { /* i=3286; 114 / 112 */
        RTUINT128_INIT_C(0x00032472fa4e1d9f, 0x36b8ab5b969c936a), RTUINT128_INIT_C(0x00003671dbd1b7de, 0x81765671323be150),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000e), RTUINT128_INIT_C(0x00002a38f4d60f74, 0x223ff12ad756410a)
    },
    { /* i=3287; 127 / 24 */
        RTUINT128_INIT_C(0x55ca2372dba1562d, 0x14bb3687f23b4606), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000d643eb),
        RTUINT128_INIT_C(0x000000667fef1a20, 0xa9a272a8322c435a), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000bce468)
    },
    { /* i=3288; 119 / 126 */
        RTUINT128_INIT_C(0x00280db8a9a3e0e5, 0x1c13c4f94dedd22f), RTUINT128_INIT_C(0x3d94ddb7eff1f3bd, 0xa88d9bc5d2748b1e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00280db8a9a3e0e5, 0x1c13c4f94dedd22f)
    },
    { /* i=3289; 125 / 108 */
        RTUINT128_INIT_C(0x02d4d856c6d740a4, 0xcca818d83ea0bbd1), RTUINT128_INIT_C(0x00000199d495f35f, 0x0dc7ec9b2bb12cd7),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000001c4c6), RTUINT128_INIT_C(0x00000003992930cb, 0x26451fafa06c7187)
    },
    { /* i=3290; 116 / 78 */
        RTUINT128_INIT_C(0x0009b976ffd6c90c, 0x2e728391fa2f4d90), RTUINT128_INIT_C(0x000000000000130e, 0xddca05025b46f0dc),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000082a00e83e7), RTUINT128_INIT_C(0x0000000000000bc3, 0x93642599a3e3630c)
    },
    { /* i=3291; 126 / 99 */
        RTUINT128_INIT_C(0x164e3b2f9ee12160, 0xfce0ceb092950f1d), RTUINT128_INIT_C(0x00000005bf9ed751, 0xeee7287453d355cd),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000003e156fd), RTUINT128_INIT_C(0x00000000adc12082, 0x4f9d98d0ebb96584)
    },
    { /* i=3292; 93 / 28 */
        RTUINT128_INIT_C(0x000000000a665171, 0xc9f7b80f81767957), RTUINT128_INIT_C(0x0000000000000000, 0x000000000a678820),
        RTUINT128_INIT_C(0x0000000000000000, 0xffe223baa964b8a7), RTUINT128_INIT_C(0x0000000000000000, 0x000000000195ac77)
    },
    { /* i=3293; 124 / 14 */
        RTUINT128_INIT_C(0x039794fa7940a109, 0xea41c50c55407e79), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000023be),
        RTUINT128_INIT_C(0x000019ba6af21a17, 0xddceeefb9bd8fa40), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000002f9)
    },
    { /* i=3294; 68 / 61 */
        RTUINT128_INIT_C(0x0000000000000005, 0xc2a91613529bb443), RTUINT128_INIT_C(0x0000000000000000, 0x111793ea218f9ebe),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000056), RTUINT128_INIT_C(0x0000000000000000, 0x04bd656c0c5c606f)
    },
    { /* i=3295; 69 / 65 */
        RTUINT128_INIT_C(0x0000000000000017, 0x55e60e8f52d51370), RTUINT128_INIT_C(0x0000000000000000, 0x765f1b628ca8e97a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000032), RTUINT128_INIT_C(0x0000000000000000, 0x3752b54fd9d7799c)
    },
    { /* i=3296; 118 / 7 */
        RTUINT128_INIT_C(0x0000e04a25ceacfa, 0x65c56ad03cec7676), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002),
        RTUINT128_INIT_C(0x0000702512e7567d, 0x32e2b5681e763b3b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=3297; 78 / 48 */
        RTUINT128_INIT_C(0x0000000000003fc0, 0x490b7d26bce60c5f), RTUINT128_INIT_C(0x0000000000000000, 0x0000875dbcfce23e),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000789061d4), RTUINT128_INIT_C(0x0000000000000000, 0x0000069e16e13307)
    },
    { /* i=3298; 89 / 25 */
        RTUINT128_INIT_C(0x00000000008e1bd1, 0x36b98781c988cf3a), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000da9e5),
        RTUINT128_INIT_C(0x000000000000000a, 0x668683f20de86143), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000d934b)
    },
    { /* i=3299; 7 / 28 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000053), RTUINT128_INIT_C(0x0000000000000000, 0x000000000798f6bf),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000053)
    },
    { /* i=3300; 126 / 115 */
        RTUINT128_INIT_C(0x1c6de1f11cfd4b80, 0xdb43697492138e1c), RTUINT128_INIT_C(0x0003ae3173b4552b, 0xbd9ef7f9e4f47fc9),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000007b9), RTUINT128_INIT_C(0x0001a60a91578cb5, 0x7a9a609b6de4b6db)
    },
    { /* i=3301; 119 / 81 */
        RTUINT128_INIT_C(0x0004feaffa94e44b, 0xf816c82ee37c5375), RTUINT128_INIT_C(0x000000000001289a, 0xcfe4da5bcb95cc37),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000044fa316ae), RTUINT128_INIT_C(0x00000000000095ac, 0x75296f09a419cc13)
    },
    { /* i=3302; 92 / 50 */
        RTUINT128_INIT_C(0x000000000816f97a, 0xd17169ddb17a8929), RTUINT128_INIT_C(0x0000000000000000, 0x00001a0a2d1a0c27),
        RTUINT128_INIT_C(0x0000000000000000, 0x00004f880187790c), RTUINT128_INIT_C(0x0000000000000000, 0x00000191b4f28855)
    },
    { /* i=3303; 85 / 32 */
        RTUINT128_INIT_C(0x000000000010f674, 0xd70ba866a62452be), RTUINT128_INIT_C(0x0000000000000000, 0x000000000d2574b3),
        RTUINT128_INIT_C(0x0000000000000000, 0x014a51453ff07b17), RTUINT128_INIT_C(0x0000000000000000, 0x0000000003e4d5a9)
    },
    { /* i=3304; 124 / 79 */
        RTUINT128_INIT_C(0x0fa038876e0c8cd4, 0xe6cc59e459aa3016), RTUINT128_INIT_C(0x0000000000006ff8, 0xe1bfad4f205d9972),
        RTUINT128_INIT_C(0x0000000000000000, 0x000023b9a1e3a070), RTUINT128_INIT_C(0x0000000000003a49, 0xb67c0929eeb9ce36)
    },
    { /* i=3305; 125 / 20 */
        RTUINT128_INIT_C(0x084299dff4f62447, 0x481e29af5d48d9d4), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000c588f),
        RTUINT128_INIT_C(0x000000ab47782502, 0xb618eaa0faf53d6e), RTUINT128_INIT_C(0x0000000000000000, 0x000000000005b962)
    },
    { /* i=3306; 116 / 104 */
        RTUINT128_INIT_C(0x000123e59663738d, 0xe4a7e9a8ccc4b93a), RTUINT128_INIT_C(0x000000158b7db62c, 0x13f774d64d3ee6ec),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000d8c), RTUINT128_INIT_C(0x00000007eb63966f, 0x6865228a5ca4742a)
    },
    { /* i=3307; 60 / 55 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0760678afadfbf78), RTUINT128_INIT_C(0x0000000000000000, 0x004a309012cbb400),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000019), RTUINT128_INIT_C(0x0000000000000000, 0x0021a97924fb2b78)
    },
    { /* i=3308; 53 / 6 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000347b0b13fd649), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000003e),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000d8b1ba20fd7), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000037)
    },
    { /* i=3309; 62 / 17 */
        RTUINT128_INIT_C(0x0000000000000000, 0x176d8c1889221257), RTUINT128_INIT_C(0x0000000000000000, 0x000000000001c69a),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000d3166d6a6e9), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000742d)
    },
    { /* i=3310; 67 / 46 */
        RTUINT128_INIT_C(0x0000000000000003, 0x1906b0d3b04e2a2b), RTUINT128_INIT_C(0x0000000000000000, 0x000035896b346638),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000ed00f), RTUINT128_INIT_C(0x0000000000000000, 0x000009ce3e1eace3)
    },
    { /* i=3311; 118 / 77 */
        RTUINT128_INIT_C(0x000a1db79e6ff576, 0x8e3a96aaaebde4ec), RTUINT128_INIT_C(0x0000000000001c2d, 0x52d2393f62723114),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000005be8a47bb8), RTUINT128_INIT_C(0x0000000000000201, 0xe935fd117e46028c)
    },
    { /* i=3312; 117 / 119 */
        RTUINT128_INIT_C(0x001b200986ede1b3, 0x2603db4a78ab2af9), RTUINT128_INIT_C(0x0020b3d1c53f5d2e, 0xe1aca742cb078149),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x001b200986ede1b3, 0x2603db4a78ab2af9)
    },
    { /* i=3313; 35 / 11 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000076b4b42a2), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000162),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000055d8030), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000042)
    },
    { /* i=3314; 121 / 87 */
        RTUINT128_INIT_C(0x00e3a4c0f39ed737, 0x58924479b7500396), RTUINT128_INIT_C(0x0000000000462978, 0x5428ad8d5963295a),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000033e9a571e), RTUINT128_INIT_C(0x00000000000f935a, 0xf9fb9ecfde7f950a)
    },
    { /* i=3315; 127 / 88 */
        RTUINT128_INIT_C(0x56ec7de714a28da0, 0x07de40bedd06a18e), RTUINT128_INIT_C(0x000000000009c17a, 0x8d7bb26bb1f7c17a),
        RTUINT128_INIT_C(0x0000000000000000, 0x000008e8f49dab61), RTUINT128_INIT_C(0x000000000003a79a, 0xb39246260017d454)
    },
    { /* i=3316; 70 / 42 */
        RTUINT128_INIT_C(0x000000000000001e, 0x9558c210b1776dc7), RTUINT128_INIT_C(0x0000000000000000, 0x00000381d2343514),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000008b86b39), RTUINT128_INIT_C(0x0000000000000000, 0x0000001e4b484053)
    },
    { /* i=3317; 85 / 10 */
        RTUINT128_INIT_C(0x0000000000070ecf, 0x84e8961fa19dc086), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000029c),
        RTUINT128_INIT_C(0x00000000000002b4, 0x6e2fde800c1f472f), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000001e2)
    },
    { /* i=3318; 65 / 53 */
        RTUINT128_INIT_C(0x0000000000000001, 0x77fa977afb3f9b1a), RTUINT128_INIT_C(0x0000000000000000, 0x00184fa86b3dea8b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000f77), RTUINT128_INIT_C(0x0000000000000000, 0x0002b1e880b96f7d)
    },
    { /* i=3319; 114 / 119 */
        RTUINT128_INIT_C(0x000218daab245ae1, 0xc5f180ecaea12ead), RTUINT128_INIT_C(0x0070b27b9b2eea44, 0x85bcb75d8678b060),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000218daab245ae1, 0xc5f180ecaea12ead)
    },
    { /* i=3320; 127 / 56 */
        RTUINT128_INIT_C(0x6b416637e71df8df, 0x8059026732f3ef20), RTUINT128_INIT_C(0x0000000000000000, 0x0030b7da269021b4),
        RTUINT128_INIT_C(0x0000000000000233, 0x98beb8845ee3a2ed), RTUINT128_INIT_C(0x0000000000000000, 0x002ae20c4f94d37c)
    },
    { /* i=3321; 113 / 119 */
        RTUINT128_INIT_C(0x0001e7bee7bfc1f6, 0xa649dc875a2f6f31), RTUINT128_INIT_C(0x005b7478bba692f4, 0x1c10f4f55727c959),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0001e7bee7bfc1f6, 0xa649dc875a2f6f31)
    },
    { /* i=3322; 79 / 14 */
        RTUINT128_INIT_C(0x0000000000000507, 0xd22411fd990e1fad), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001083),
        RTUINT128_INIT_C(0x0000000000000000, 0x4dfe8e15cd584de4), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000401)
    },
    { /* i=3323; 126 / 39 */
        RTUINT128_INIT_C(0x2947a2e0a04dcbcf, 0x712855dc28e52de2), RTUINT128_INIT_C(0x0000000000000000, 0x0000004586d1c8b4),
        RTUINT128_INIT_C(0x000000000097fe7a, 0xe00b3f55809a860a), RTUINT128_INIT_C(0x0000000000000000, 0x00000042595d1eda)
    },
    { /* i=3324; 66 / 26 */
        RTUINT128_INIT_C(0x0000000000000003, 0x4a258c6f7b7d1686), RTUINT128_INIT_C(0x0000000000000000, 0x00000000026f3ead),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000159ea29e5bd), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000960fcd)
    },
    { /* i=3325; 126 / 52 */
        RTUINT128_INIT_C(0x3a8d354965383e14, 0x1b9f02418b21d2f5), RTUINT128_INIT_C(0x0000000000000000, 0x00002cff56d1239f),
        RTUINT128_INIT_C(0x0000000000014d1c, 0xd4f13d155ed94422), RTUINT128_INIT_C(0x0000000000000000, 0x000003e1e21ddbd7)
    },
    { /* i=3326; 121 / 45 */
        RTUINT128_INIT_C(0x002071dadd2202ce, 0x4f8c910dbd6818f2), RTUINT128_INIT_C(0x0000000000000000, 0x000018a23fea73aa),
        RTUINT128_INIT_C(0x0000000000000151, 0x2c5bd88fc7e81322), RTUINT128_INIT_C(0x0000000000000000, 0x0000086ae19f1e5e)
    },
    { /* i=3327; 125 / 117 */
        RTUINT128_INIT_C(0x12143a25e29c26c4, 0x521ef798ef314e9e), RTUINT128_INIT_C(0x000ab2341bcb233e, 0x3f8738349e7901e4),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000001b0), RTUINT128_INIT_C(0x00078236fbd0adb9, 0x1df01ecd82fe1dde)
    },
    { /* i=3328; 8 / 13 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000080), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000be5),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000080)
    },
    { /* i=3329; 34 / 11 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000029df216e8), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000790),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000058967d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000598)
    },
    { /* i=3330; 85 / 1 */
        RTUINT128_INIT_C(0x000000000014bbec, 0xa99b44ce4d0e2bea), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001),
        RTUINT128_INIT_C(0x000000000014bbec, 0xa99b44ce4d0e2bea), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=3331; 44 / 16 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000569ea082053), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000edf8),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000005d2ed4f), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000018cb)
    },
    { /* i=3332; 101 / 55 */
        RTUINT128_INIT_C(0x00000007b67a58e9, 0xb34d23ec1d62ffc7), RTUINT128_INIT_C(0x0000000000000000, 0x002762e47c3855cf),
        RTUINT128_INIT_C(0x0000000000000000, 0x000032218ed2395a), RTUINT128_INIT_C(0x0000000000000000, 0x0014dc71b0abbe01)
    },
    { /* i=3333; 91 / 11 */
        RTUINT128_INIT_C(0x00000000026a22da, 0xb578fe1c632f53c0), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000139),
        RTUINT128_INIT_C(0x000000000001f991, 0x772c8d7d3a631db6), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000003a)
    },
    { /* i=3334; 106 / 95 */
        RTUINT128_INIT_C(0x000001e9f68b3fc0, 0xac78fe64a409cf24), RTUINT128_INIT_C(0x00000000362dcafd, 0xd7880187c8a58e93),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000090b), RTUINT128_INIT_C(0x0000000006709a44, 0xa193278132e983d3)
    },
    { /* i=3335; 123 / 41 */
        RTUINT128_INIT_C(0x032c1afe58c60ebe, 0x8156e6d59a3fe177), RTUINT128_INIT_C(0x0000000000000000, 0x0000009e4ec198f4),
        RTUINT128_INIT_C(0x0000000000052142, 0x6609b3edbfd6cace), RTUINT128_INIT_C(0x0000000000000000, 0x000000758fce451f)
    },
    { /* i=3336; 96 / 30 */
        RTUINT128_INIT_C(0x00000000856e2198, 0x936dfd9ae7386f97), RTUINT128_INIT_C(0x0000000000000000, 0x0000000033ec74ad),
        RTUINT128_INIT_C(0x0000000000000002, 0x91da5cb2bf23dd8d), RTUINT128_INIT_C(0x0000000000000000, 0x00000000269bd34e)
    },
    { /* i=3337; 35 / 6 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000355629188), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000022),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000019197cc0), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000008)
    },
    { /* i=3338; 127 / 99 */
        RTUINT128_INIT_C(0x752eb43f257235c9, 0x9a23edd588d48dde), RTUINT128_INIT_C(0x00000001e8003b45, 0x5ceb06906b40da2d),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000003d78fef5), RTUINT128_INIT_C(0x0000000092c31b7a, 0xff72a0d18d331acd)
    },
    { /* i=3339; 16 / 2 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000f933), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000f933), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=3340; 90 / 71 */
        RTUINT128_INIT_C(0x0000000001086ce4, 0x3cf884a6f12ca492), RTUINT128_INIT_C(0x0000000000000000, 0x52387ad886e21522),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000003374ed4), RTUINT128_INIT_C(0x0000000000000000, 0x02ab2f6c6b34c86a)
    },
    { /* i=3341; 88 / 21 */
        RTUINT128_INIT_C(0x00000000005f9330, 0x46bfe21bbec784c5), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000087923),
        RTUINT128_INIT_C(0x000000000000000b, 0x4799ba735bbf1bee), RTUINT128_INIT_C(0x0000000000000000, 0x000000000003353b)
    },
    { /* i=3342; 119 / 111 */
        RTUINT128_INIT_C(0x0044e81e8968ea20, 0x175c694f33cac23e), RTUINT128_INIT_C(0x0000575672608d41, 0x32ecbc8f382e15a5),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000c9), RTUINT128_INIT_C(0x0000553ebb9a01ef, 0x1b7c5cdc179bc3b1)
    },
    { /* i=3343; 111 / 29 */
        RTUINT128_INIT_C(0x0000324901a90f5a, 0x1a1227253faa6f54), RTUINT128_INIT_C(0x0000000000000000, 0x000000001326cbbe),
        RTUINT128_INIT_C(0x000000000002a02a, 0x5683ac34c9810070), RTUINT128_INIT_C(0x0000000000000000, 0x0000000005f34c34)
    },
    { /* i=3344; 16 / 19 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000009ace), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000065edf),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000009ace)
    },
    { /* i=3345; 123 / 49 */
        RTUINT128_INIT_C(0x060d0acd64851c17, 0x9557ceb30c7d3fa0), RTUINT128_INIT_C(0x0000000000000000, 0x00000418c062d981),
        RTUINT128_INIT_C(0x0000000000017a1e, 0xef6f59b14204d84b), RTUINT128_INIT_C(0x0000000000000000, 0x0000004f9ffeaed5)
    },
    { /* i=3346; 124 / 74 */
        RTUINT128_INIT_C(0x065fe8f24d822103, 0xa4de0de894f0ffb3), RTUINT128_INIT_C(0x0000000000000124, 0x3651242206d1b0d9),
        RTUINT128_INIT_C(0x0000000000000000, 0x000595ad3de8313f), RTUINT128_INIT_C(0x0000000000000080, 0xc8a5b169cad4f14c)
    },
    { /* i=3347; 121 / 104 */
        RTUINT128_INIT_C(0x014978b8cfef1ea5, 0x79571b7a5753b6cf), RTUINT128_INIT_C(0x000000fc11b6684b, 0x6d45c736065299ef),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000014e9c), RTUINT128_INIT_C(0x0000000208b5281d, 0xd8e93a4eb828172b)
    },
    { /* i=3348; 128 / 85 */
        RTUINT128_INIT_C(0x63b2419b2262e85f, 0x9d27e83662ef640e), RTUINT128_INIT_C(0x000000000019556e, 0xfd35fac451e9dd21),
        RTUINT128_INIT_C(0x0000000000000000, 0x000003ef7121702e), RTUINT128_INIT_C(0x00000000000c1dc2, 0x4d5b568947ea3820)
    },
    { /* i=3349; 103 / 4 */
        RTUINT128_INIT_C(0x0000003581b0039a, 0x4b642398b96a93cb), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000b),
        RTUINT128_INIT_C(0x00000004dd3e8bf6, 0xc1091a823f66c79e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001)
    },
    { /* i=3350; 79 / 59 */
        RTUINT128_INIT_C(0x0000000000000c5b, 0xaf31f52b8347638a), RTUINT128_INIT_C(0x0000000000000000, 0x03d74754d02c861e),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000337ad), RTUINT128_INIT_C(0x0000000000000000, 0x0065179bb2064f44)
    },
    { /* i=3351; 28 / 12 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000056e03e2), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000a09),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000008a83), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000747)
    },
    { /* i=3352; 128 / 109 */
        RTUINT128_INIT_C(0x54224e476c69b2b1, 0x70741a8e95769c7a), RTUINT128_INIT_C(0x000000ff0781bfb4, 0xc1968e6de242fed9),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000547448), RTUINT128_INIT_C(0x000000939dbe5abc, 0x09840324f7f09b72)
    },
    { /* i=3353; 61 / 5 */
        RTUINT128_INIT_C(0x0000000000000000, 0x13022001e6492d02), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000007),
        RTUINT128_INIT_C(0x0000000000000000, 0x02b72924d7c14f92), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000004)
    },
    { /* i=3354; 114 / 109 */
        RTUINT128_INIT_C(0x000368cb47535494, 0x34a5de097eccca7c), RTUINT128_INIT_C(0x00001c73633d8509, 0x8df54bf99c9dfc74),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000001e), RTUINT128_INIT_C(0x00001345a61dbd75, 0x91e6f6c9244934e4)
    },
    { /* i=3355; 115 / 104 */
        RTUINT128_INIT_C(0x000461f9da37ba92, 0x5c7abfde01e1f191), RTUINT128_INIT_C(0x000000bcbac391ff, 0xe0516e398d9393a2),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000005f1), RTUINT128_INIT_C(0x000000a83641494e, 0x98aadbebd811cc0f)
    },
    { /* i=3356; 118 / 20 */
        RTUINT128_INIT_C(0x0006795ffc2dfd4f, 0x0245dc1a86c06142), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000080575),
        RTUINT128_INIT_C(0x00000000ce9f0e46, 0xa2bb1f64719f4f8c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000034a46)
    },
    { /* i=3357; 117 / 40 */
        RTUINT128_INIT_C(0x001cf772046a266e, 0x5eab8a328c8cb2a6), RTUINT128_INIT_C(0x0000000000000000, 0x00000077fba502ab),
        RTUINT128_INIT_C(0x0000000000003dcd, 0xdc295c16113421ad), RTUINT128_INIT_C(0x0000000000000000, 0x0000004952f5da17)
    },
    { /* i=3358; 80 / 5 */
        RTUINT128_INIT_C(0x000000000000607f, 0xdc39df3c5c5eeeaf), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000a),
        RTUINT128_INIT_C(0x00000000000009a6, 0x62d29652d6097e44), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000007)
    },
    { /* i=3359; 121 / 37 */
        RTUINT128_INIT_C(0x01f3639172f081fd, 0x7578dbfcd74cf2f8), RTUINT128_INIT_C(0x0000000000000000, 0x0000000f21864dbd),
        RTUINT128_INIT_C(0x0000000000210123, 0xf247638ef8ba68a3), RTUINT128_INIT_C(0x0000000000000000, 0x000000025be2aba1)
    },
    { /* i=3360; 64 / 21 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0b9748ee85a22a44), RTUINT128_INIT_C(0x0000000000000000, 0x00000000001ec802),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000060662559f7), RTUINT128_INIT_C(0x0000000000000000, 0x00000000001c7e56)
    },
    { /* i=3361; 112 / 118 */
        RTUINT128_INIT_C(0x000093761d01dd9c, 0x0f52703ebd90b71e), RTUINT128_INIT_C(0x00115f80ccd38fa2, 0x4aa0afe1434def1d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x000093761d01dd9c, 0x0f52703ebd90b71e)
    },
    { /* i=3362; 125 / 123 */
        RTUINT128_INIT_C(0x0dc112e6037aa94a, 0xa3b8f8ceaac62723), RTUINT128_INIT_C(0x00c5dc93bd24ee7b, 0x5c3fa92fe456d810),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000011), RTUINT128_INIT_C(0x009d6d167406d319, 0x837ebca08101ce13)
    },
    { /* i=3363; 117 / 97 */
        RTUINT128_INIT_C(0x000bc994f3df2064, 0xf240819fa9ae4989), RTUINT128_INIT_C(0x00000001c02a20c2, 0x6a37ba0b9ed16be6),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000006bbb3), RTUINT128_INIT_C(0x000000000bedb78f, 0x9c1d35941c0ad5b7)
    },
    { /* i=3364; 24 / 21 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000667df7), RTUINT128_INIT_C(0x0000000000000000, 0x00000000001a0774),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003), RTUINT128_INIT_C(0x0000000000000000, 0x000000000018679b)
    },
    { /* i=3365; 123 / 109 */
        RTUINT128_INIT_C(0x03436d8cd6ab549c, 0xe4a3cc402224233d), RTUINT128_INIT_C(0x0000153eef7c85e3, 0xb27a490b17914a02),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000002752), RTUINT128_INIT_C(0x000008e82862c17d, 0x1857b61b73542099)
    },
    { /* i=3366; 11 / 10 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000006cb), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000003e5),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000002e6)
    },
    { /* i=3367; 125 / 126 */
        RTUINT128_INIT_C(0x03347dd08f4947dc, 0x53813e0215255fb0), RTUINT128_INIT_C(0x2c97df0129dec691, 0x238ec7f9e77d8194),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x03347dd08f4947dc, 0x53813e0215255fb0)
    },
    { /* i=3368; 126 / 84 */
        RTUINT128_INIT_C(0x33ef7bc90cbda747, 0x4b14a34da903e25a), RTUINT128_INIT_C(0x0000000000036c1a, 0x7dee043c2fb0bf22),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000f2cfaaad183), RTUINT128_INIT_C(0x0000000000016394, 0x64b537b3d4f351f4)
    },
    { /* i=3369; 125 / 63 */
        RTUINT128_INIT_C(0x17567a7fda9a8b01, 0x1b9b69b7fc6e0fd2), RTUINT128_INIT_C(0x0000000000000000, 0x6e8936c32559ee3f),
        RTUINT128_INIT_C(0x0000000000000000, 0x360cd1a25a69a228), RTUINT128_INIT_C(0x0000000000000000, 0x6cf93b145fc5f7fa)
    },
    { /* i=3370; 122 / 123 */
        RTUINT128_INIT_C(0x02766def14bf68d9, 0x39c33bb3b598285d), RTUINT128_INIT_C(0x0581e2bde1d520c4, 0x1324acf200955532),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x02766def14bf68d9, 0x39c33bb3b598285d)
    },
    { /* i=3371; 120 / 98 */
        RTUINT128_INIT_C(0x00f40ace93985f1f, 0xa5ecb462dc07c309), RTUINT128_INIT_C(0x0000000006d4dc46, 0xddeb947abc78c30d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000023b92074), RTUINT128_INIT_C(0x00000000000e1eba, 0x90275f46a188c125)
    },
    { /* i=3372; 117 / 24 */
        RTUINT128_INIT_C(0x00166034abc96cfd, 0x339ea5bdf4d321d4), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000ea94e2),
        RTUINT128_INIT_C(0x00000000186b37ef, 0x5db73dd8b89f612d), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000cf541a)
    },
    { /* i=3373; 88 / 2 */
        RTUINT128_INIT_C(0x0000000000ebbb69, 0x78e27a146d38babb), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003),
        RTUINT128_INIT_C(0x00000000004e93cd, 0xd2f628b179bd9393), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002)
    },
    { /* i=3374; 89 / 31 */
        RTUINT128_INIT_C(0x00000000010364e9, 0x1c2fe11ab7b781a5), RTUINT128_INIT_C(0x0000000000000000, 0x000000005008fb6e),
        RTUINT128_INIT_C(0x0000000000000000, 0x033db28edd4088dd), RTUINT128_INIT_C(0x0000000000000000, 0x0000000008e403af)
    },
    { /* i=3375; 123 / 94 */
        RTUINT128_INIT_C(0x05d09a3ea109c575, 0xa20c0ac658471714), RTUINT128_INIT_C(0x000000000dee2e8b, 0xedb658d118b731f0),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000006adc29f8), RTUINT128_INIT_C(0x000000000c2a7b5a, 0x3d3f6b24c58f4694)
    },
    { /* i=3376; 117 / 3 */
        RTUINT128_INIT_C(0x0003978a381efe72, 0x308c21c7f1990af7), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000006),
        RTUINT128_INIT_C(0x00009941b4052a68, 0x5d6cb04bfd9981d3), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000005)
    },
    { /* i=3377; 123 / 32 */
        RTUINT128_INIT_C(0x02911a75d6279979, 0x7595e625d946fc16), RTUINT128_INIT_C(0x0000000000000000, 0x000000005cbdd73f),
        RTUINT128_INIT_C(0x000000000715d750, 0x1b4ba427066432a6), RTUINT128_INIT_C(0x0000000000000000, 0x0000000013871b3c)
    },
    { /* i=3378; 112 / 33 */
        RTUINT128_INIT_C(0x00002f165d8c7faf, 0x4e4661aa04338142), RTUINT128_INIT_C(0x0000000000000000, 0x00000000a67c96aa),
        RTUINT128_INIT_C(0x0000000000004867, 0x85d955310fd6f641), RTUINT128_INIT_C(0x0000000000000000, 0x000000001dade418)
    },
    { /* i=3379; 61 / 76 */
        RTUINT128_INIT_C(0x0000000000000000, 0x1a3b065717a5236f), RTUINT128_INIT_C(0x000000000000015a, 0x6046289e84e87e68),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x1a3b065717a5236f)
    },
    { /* i=3380; 124 / 69 */
        RTUINT128_INIT_C(0x07fc08b469237d1f, 0xc80efa5287116e11), RTUINT128_INIT_C(0x000000000000001e, 0xca8ab6f0393de12e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0042623d94aed283), RTUINT128_INIT_C(0x0000000000000011, 0xbed55c3cd46b7787)
    },
    { /* i=3381; 67 / 3 */
        RTUINT128_INIT_C(0x0000000000000005, 0x766c07bb418f26d1), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000004),
        RTUINT128_INIT_C(0x0000000000000001, 0x5d9b01eed063c9b4), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001)
    },
    { /* i=3382; 115 / 13 */
        RTUINT128_INIT_C(0x000172a8124b8a9d, 0xf894b723fbf0861d), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000007dd),
        RTUINT128_INIT_C(0x0000002f233c71e3, 0x9775b5913ff75832), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000004f3)
    },
    { /* i=3383; 67 / 37 */
        RTUINT128_INIT_C(0x0000000000000001, 0x54ca97365dc0241d), RTUINT128_INIT_C(0x0000000000000000, 0x00000012275f395b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000012c5bfbe), RTUINT128_INIT_C(0x0000000000000000, 0x0000000d9041ad93)
    },
    { /* i=3384; 124 / 121 */
        RTUINT128_INIT_C(0x0d94c9c516e48692, 0xe022d185c95c922c), RTUINT128_INIT_C(0x0118945b47c2e4cc, 0x6100f9d99db074de),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000c), RTUINT128_INIT_C(0x006dd57db9c1ccfe, 0x54171b52651717c4)
    },
    { /* i=3385; 106 / 44 */
        RTUINT128_INIT_C(0x00000058ec686a29, 0xd3b0fee20aa04d30), RTUINT128_INIT_C(0x0000000000000000, 0x0000014a951f34f7),
        RTUINT128_INIT_C(0x0000000000000000, 0x44dc8b5eb6c1bf23), RTUINT128_INIT_C(0x0000000000000000, 0x0000008cd6a0c66b)
    },
    { /* i=3386; 66 / 14 */
        RTUINT128_INIT_C(0x0000000000000000, 0xf5d1592fc851a2cc), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001623),
        RTUINT128_INIT_C(0x0000000000000000, 0x000b1ac235ed7e3e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000c52)
    },
    { /* i=3387; 125 / 81 */
        RTUINT128_INIT_C(0x1a855c1f29e7ec2f, 0x1a852f191efdfcf7), RTUINT128_INIT_C(0x000000000001cb35, 0x7870b97531e9cdd5),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000ec8ef956589), RTUINT128_INIT_C(0x0000000000007103, 0x0a4cea0982b0ccfa)
    },
    { /* i=3388; 113 / 34 */
        RTUINT128_INIT_C(0x00001bc133324874, 0x64a2f6bee7343af6), RTUINT128_INIT_C(0x0000000000000000, 0x000000019f5f5243),
        RTUINT128_INIT_C(0x000000000000111b, 0x09a9fbcea21eaa79), RTUINT128_INIT_C(0x0000000000000000, 0x000000013cabdb4b)
    },
    { /* i=3389; 87 / 21 */
        RTUINT128_INIT_C(0x0000000000739002, 0x551971380aa58979), RTUINT128_INIT_C(0x0000000000000000, 0x00000000001c095f),
        RTUINT128_INIT_C(0x0000000000000004, 0x1f31371a80910b43), RTUINT128_INIT_C(0x0000000000000000, 0x000000000019009c)
    },
    { /* i=3390; 42 / 25 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000240af95cc1c), RTUINT128_INIT_C(0x0000000000000000, 0x00000000002a19d2),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000db29d), RTUINT128_INIT_C(0x0000000000000000, 0x000000000025f252)
    },
    { /* i=3391; 66 / 9 */
        RTUINT128_INIT_C(0x0000000000000000, 0x3dc71dcaeb21d713), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000054),
        RTUINT128_INIT_C(0x0000000000000000, 0x00bc46732d77428f), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000027)
    },
    { /* i=3392; 87 / 24 */
        RTUINT128_INIT_C(0x000000000034ad20, 0xff5d04f8e36a00db), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000f17c17),
        RTUINT128_INIT_C(0x0000000000000000, 0x37d7b2fd1e191fe1), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000e627a4)
    },
    { /* i=3393; 91 / 100 */
        RTUINT128_INIT_C(0x0000000000b6d7db, 0x66c99f2fed8d2058), RTUINT128_INIT_C(0x0000000cd6d9f93c, 0x2fd727b1e4438c4d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000b6d7db, 0x66c99f2fed8d2058)
    },
    { /* i=3394; 119 / 89 */
        RTUINT128_INIT_C(0x0056b41ff0747023, 0x42767b325e8dec6f), RTUINT128_INIT_C(0x0000000001b79953, 0xdc53b6d656b64b1b),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000327de41a), RTUINT128_INIT_C(0x0000000000453ece, 0x2f87128542f73fb1)
    },
    { /* i=3395; 105 / 34 */
        RTUINT128_INIT_C(0x0000004b776cdeac, 0xcbb365c63cbbcf0d), RTUINT128_INIT_C(0x0000000000000000, 0x00000003d5336bb8),
        RTUINT128_INIT_C(0x0000000000000013, 0xb087ce98a8aa0392), RTUINT128_INIT_C(0x0000000000000000, 0x00000000c2f5381d)
    },
    { /* i=3396; 113 / 31 */
        RTUINT128_INIT_C(0x00008f27a22dc046, 0x50a5d8e8d71c559f), RTUINT128_INIT_C(0x0000000000000000, 0x000000001b26bf34),
        RTUINT128_INIT_C(0x00000000000545c0, 0xde360c2fd51cec12), RTUINT128_INIT_C(0x0000000000000000, 0x00000000086ef3f7)
    },
    { /* i=3397; 115 / 78 */
        RTUINT128_INIT_C(0x00077e577ab16ef3, 0x5560ff7f29dc5dc3), RTUINT128_INIT_C(0x0000000000000b58, 0x00be9c77eff17959),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000a91c1ebf0c), RTUINT128_INIT_C(0x00000000000003a4, 0x3afe8a87cc934697)
    },
    { /* i=3398; 123 / 76 */
        RTUINT128_INIT_C(0x051fad0a00c2ffda, 0x342b369e6dc453e2), RTUINT128_INIT_C(0x0000000000000549, 0x986cb9e470aad1c0),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000f8126aa8af6d), RTUINT128_INIT_C(0x00000000000004c9, 0xff077ce289a6c522)
    },
    { /* i=3399; 122 / 127 */
        RTUINT128_INIT_C(0x00d655734f7780f4, 0x5bcc538711a9b1fb), RTUINT128_INIT_C(0x3c272478421b1a14, 0x6d74db6a9bafd5d6),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00d655734f7780f4, 0x5bcc538711a9b1fb)
    },
    { /* i=3400; 94 / 26 */
        RTUINT128_INIT_C(0x000000000d8d5d62, 0x16213be2f6d9c42f), RTUINT128_INIT_C(0x0000000000000000, 0x00000000006ba100),
        RTUINT128_INIT_C(0x0000000000000020, 0x3c08adc3d2bb77c7), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000589d2f)
    },
    { /* i=3401; 123 / 84 */
        RTUINT128_INIT_C(0x001ffbb596b1d8d3, 0x8616d36510a131ed), RTUINT128_INIT_C(0x000000000002d164, 0xbc8c5b296e7e03d4),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000b598fe30f), RTUINT128_INIT_C(0x00000000000137db, 0xf20f0d29026dfc81)
    },
    { /* i=3402; 47 / 45 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00002cb2a69ab909), RTUINT128_INIT_C(0x0000000000000000, 0x00000f2c393ac6df),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002), RTUINT128_INIT_C(0x0000000000000000, 0x00000e5a34252b4b)
    },
    { /* i=3403; 123 / 80 */
        RTUINT128_INIT_C(0x04f1c1c0713e10d2, 0x4c04de824ae430aa), RTUINT128_INIT_C(0x000000000000510e, 0x83f03a0093ba70a9),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000f9d9e4a3230), RTUINT128_INIT_C(0x0000000000000614, 0xfe5d1d7a4f140efa)
    },
    { /* i=3404; 69 / 23 */
        RTUINT128_INIT_C(0x0000000000000017, 0x8d2c17b4eef55d32), RTUINT128_INIT_C(0x0000000000000000, 0x00000000005d04f4),
        RTUINT128_INIT_C(0x0000000000000000, 0x000040d0faa1540a), RTUINT128_INIT_C(0x0000000000000000, 0x00000000003f1baa)
    },
    { /* i=3405; 8 / 5 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000e6), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000008),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000001c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000006)
    },
    { /* i=3406; 95 / 41 */
        RTUINT128_INIT_C(0x0000000024539be4, 0x6ed0d433388991eb), RTUINT128_INIT_C(0x0000000000000000, 0x000000c0b903a97e),
        RTUINT128_INIT_C(0x0000000000000000, 0x003040fafdca6e85), RTUINT128_INIT_C(0x0000000000000000, 0x0000002243625f75)
    },
    { /* i=3407; 125 / 4 */
        RTUINT128_INIT_C(0x06559e4b49bbb212, 0x5371848383755e90), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000d),
        RTUINT128_INIT_C(0x007cbd6840bfab3c, 0x7c92940a1dcdf394), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000c)
    },
    { /* i=3408; 92 / 54 */
        RTUINT128_INIT_C(0x000000000176677e, 0xf6e26f90f457ff00), RTUINT128_INIT_C(0x0000000000000000, 0x00241fe0d7ae50c9),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000a5d40b776), RTUINT128_INIT_C(0x0000000000000000, 0x00129cf8b6ff135a)
    },
    { /* i=3409; 14 / 15 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000de4), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000006a61),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000de4)
    },
    { /* i=3410; 114 / 116 */
        RTUINT128_INIT_C(0x00027f332b30836d, 0x2038a3202adb8414), RTUINT128_INIT_C(0x000962a3e97bd949, 0xf8c48c46f1e53258),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00027f332b30836d, 0x2038a3202adb8414)
    },
    { /* i=3411; 115 / 34 */
        RTUINT128_INIT_C(0x00073fbecb7500d8, 0x239addd6609c5413), RTUINT128_INIT_C(0x0000000000000000, 0x0000000068a74e86),
        RTUINT128_INIT_C(0x000000000011bb76, 0x50ec677bade8c804), RTUINT128_INIT_C(0x0000000000000000, 0x00000000513669fb)
    },
    { /* i=3412; 122 / 107 */
        RTUINT128_INIT_C(0x00be89ec5a555650, 0x9c3aa4296b52999a), RTUINT128_INIT_C(0x00000794788e7d9a, 0x84cbc9ec4d936893),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001923), RTUINT128_INIT_C(0x000000d9f4961338, 0x8da5f5476af4f281)
    },
    { /* i=3413; 57 / 7 */
        RTUINT128_INIT_C(0x0000000000000000, 0x01ffe93a6c3b1b8e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000058),
        RTUINT128_INIT_C(0x0000000000000000, 0x0005d1321e522050), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000e)
    },
    { /* i=3414; 40 / 10 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000000e1b68198ea), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000023d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000064d791ea), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000028)
    },
    { /* i=3415; 99 / 13 */
        RTUINT128_INIT_C(0x00000000a61cca6c, 0x212856a74a4fdeba), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001e43),
        RTUINT128_INIT_C(0x0000000000057d3b, 0xdbc972a4fb83f58d), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000014d3)
    },
    { /* i=3416; 113 / 82 */
        RTUINT128_INIT_C(0x0001d9cd53a807bf, 0x5bd8067ba9347265), RTUINT128_INIT_C(0x0000000000036936, 0xe9ebdb60ba7700b7),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000008ae785fb), RTUINT128_INIT_C(0x0000000000001f4b, 0x5fd24600b806abf8)
    },
    { /* i=3417; 123 / 111 */
        RTUINT128_INIT_C(0x06f616fb7ff7f7a2, 0x883a643b69ef0204), RTUINT128_INIT_C(0x00003be86de1877e, 0x3c21d3567eb8b5da),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000001dbf), RTUINT128_INIT_C(0x0000101ef85a93a3, 0xd60cea57f185a25e)
    },
    { /* i=3418; 120 / 91 */
        RTUINT128_INIT_C(0x003304c08463fadb, 0xd3a7a644c5d77f86), RTUINT128_INIT_C(0x00000000060fc5d7, 0x1033e73961000708),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000086aaa8f), RTUINT128_INIT_C(0x0000000004a5523f, 0xc653389268d8420e)
    },
    { /* i=3419; 125 / 97 */
        RTUINT128_INIT_C(0x0751353e608f1ab2, 0xcad08910faf14fe4), RTUINT128_INIT_C(0x000000003ff61990, 0xae60e68ab2d8f304),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000001d495cbd), RTUINT128_INIT_C(0x0000000008ab8877, 0xc69ce900394c75f0)
    },
    { /* i=3420; 123 / 113 */
        RTUINT128_INIT_C(0x01568f69499ce56e, 0x573e01f702164a11), RTUINT128_INIT_C(0x0001602787f887d9, 0x309686ad833684c9),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000f9), RTUINT128_INIT_C(0x000008f608e0c32e, 0x14d50332620f2290)
    },
    { /* i=3421; 126 / 74 */
        RTUINT128_INIT_C(0x33f05412ef7be9bd, 0x71480fc17640d692), RTUINT128_INIT_C(0x0000000000000011, 0x9491bb10ec5bc49d),
        RTUINT128_INIT_C(0x0000000000000000, 0x02f4515311dd659a), RTUINT128_INIT_C(0x000000000000000b, 0xaae74b24e9f19f20)
    },
    { /* i=3422; 123 / 55 */
        RTUINT128_INIT_C(0x031293d490c8ba30, 0x21c1249353eb7403), RTUINT128_INIT_C(0x0000000000000000, 0x006256991b29b0cf),
        RTUINT128_INIT_C(0x0000000000000007, 0xffaa362b572bdc38), RTUINT128_INIT_C(0x0000000000000000, 0x001d87e18315e2bb)
    },
    { /* i=3423; 89 / 42 */
        RTUINT128_INIT_C(0x0000000000f62ed4, 0x7ff86a81556dd57e), RTUINT128_INIT_C(0x0000000000000000, 0x000003991ccb683f),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000446b9b7b12a7), RTUINT128_INIT_C(0x0000000000000000, 0x0000016b04236665)
    },
    { /* i=3424; 42 / 93 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000001259dc3d8c3), RTUINT128_INIT_C(0x000000000d60d677, 0x841a050d0288762e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x000001259dc3d8c3)
    },
    { /* i=3425; 119 / 118 */
        RTUINT128_INIT_C(0x007f849eb6a6a4cf, 0x9d00d85d4fe7759e), RTUINT128_INIT_C(0x0015ebecea538f8d, 0x19f7626aed742bd2),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000005), RTUINT128_INIT_C(0x0011e8fe2304d70e, 0x1b2bec46aca29a84)
    },
    { /* i=3426; 117 / 70 */
        RTUINT128_INIT_C(0x00126ff8953c7421, 0x642943bdfa9b6a31), RTUINT128_INIT_C(0x0000000000000029, 0xa08541960f1c2a8d),
        RTUINT128_INIT_C(0x0000000000000000, 0x000071631cd24d7f), RTUINT128_INIT_C(0x0000000000000003, 0x2fe76c77af2be53e)
    },
    { /* i=3427; 86 / 27 */
        RTUINT128_INIT_C(0x00000000002dcbee, 0x4007efa3fa015ab9), RTUINT128_INIT_C(0x0000000000000000, 0x0000000006bb2b12),
        RTUINT128_INIT_C(0x0000000000000000, 0x06cdbfb27f1adaa3), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000539a43)
    },
    { /* i=3428; 123 / 117 */
        RTUINT128_INIT_C(0x03ea52f6fb413a7e, 0x5374f534423a7388), RTUINT128_INIT_C(0x000fb3b63985d1d8, 0x937849d8ff7aafa9),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000003f), RTUINT128_INIT_C(0x000d191ed3529632, 0x08dac8cd630938f1)
    },
    { /* i=3429; 124 / 30 */
        RTUINT128_INIT_C(0x08b21e666728166e, 0x58f79757cfcd8b11), RTUINT128_INIT_C(0x0000000000000000, 0x000000003b4a5ef6),
        RTUINT128_INIT_C(0x00000000258bc391, 0x3d00d9e7d0d35e9c), RTUINT128_INIT_C(0x0000000000000000, 0x000000003adb5929)
    },
    { /* i=3430; 106 / 11 */
        RTUINT128_INIT_C(0x0000026cd8bce05a, 0xa68f4e113685513e), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000072),
        RTUINT128_INIT_C(0x00000005722e91af, 0xf3fcc40d9feab69b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000038)
    },
    { /* i=3431; 122 / 3 */
        RTUINT128_INIT_C(0x03555951f8e6adf4, 0x4f9181dcba79b7d0), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000005),
        RTUINT128_INIT_C(0x00aaab76cb6155fd, 0xa983805f587ebe5c), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000004)
    },
    { /* i=3432; 73 / 25 */
        RTUINT128_INIT_C(0x0000000000000045, 0xf308b9bc40519db2), RTUINT128_INIT_C(0x0000000000000000, 0x0000000001bdb56b),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000282d3209792d), RTUINT128_INIT_C(0x0000000000000000, 0x00000000007626e3)
    },
    { /* i=3433; 41 / 9 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000c8468f4af), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000011d),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000b3e58e2), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000115)
    },
    { /* i=3434; 113 / 105 */
        RTUINT128_INIT_C(0x0001e3dd09dd6160, 0xb3292bddbc4e156b), RTUINT128_INIT_C(0x0000017e229aac55, 0x4b423821bb1ae569),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000144), RTUINT128_INIT_C(0x000000393e1b456d, 0x735a212cee43bc87)
    },
    { /* i=3435; 122 / 127 */
        RTUINT128_INIT_C(0x01737db206b98f27, 0x18dead7796b4ef5b), RTUINT128_INIT_C(0x2999163507fd23d2, 0x6088465a380ab807),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x01737db206b98f27, 0x18dead7796b4ef5b)
    },
    { /* i=3436; 119 / 82 */
        RTUINT128_INIT_C(0x004b6316bc661e2c, 0xbc234898da18f085), RTUINT128_INIT_C(0x000000000002bee7, 0x1c3df20e8c818c8d),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000001b74ce2701), RTUINT128_INIT_C(0x000000000000d6e7, 0xfefb885493b7e8f8)
    },
    { /* i=3437; 114 / 127 */
        RTUINT128_INIT_C(0x00037920b8147bd0, 0xa80a22b17f6ee31f), RTUINT128_INIT_C(0x2885ac93e2d29e8d, 0xf5cb4d60ccde22b7),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00037920b8147bd0, 0xa80a22b17f6ee31f)
    },
    { /* i=3438; 67 / 7 */
        RTUINT128_INIT_C(0x0000000000000000, 0x7f63d59a5f91da43), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000002e),
        RTUINT128_INIT_C(0x0000000000000000, 0x02c4f3f2a908bc65), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000001d)
    },
    { /* i=3439; 75 / 68 */
        RTUINT128_INIT_C(0x000000000000070c, 0x4d679672f4ff74e2), RTUINT128_INIT_C(0x0000000000000007, 0x635411e6bd4c80c6),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000f4), RTUINT128_INIT_C(0x0000000000000001, 0xa14686868814b82a)
    },
    { /* i=3440; 25 / 73 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000e53115), RTUINT128_INIT_C(0x000000000000009e, 0xd00259414440237a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000e53115)
    },
    { /* i=3441; 124 / 77 */
        RTUINT128_INIT_C(0x0d2d8fec5d3db3d2, 0x1d683fcdd99dcdcb), RTUINT128_INIT_C(0x00000000000014d8, 0xfe1b209b417c42a1),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000a1d1e8d336b3), RTUINT128_INIT_C(0x00000000000011a6, 0x87e6773106fa4138)
    },
    { /* i=3442; 114 / 71 */
        RTUINT128_INIT_C(0x00012a5cb05e3860, 0x39a2c765cba4f8cb), RTUINT128_INIT_C(0x0000000000000046, 0x8a87b66035c74518),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000043ac8434ca1), RTUINT128_INIT_C(0x000000000000003f, 0x9eb8bc5afb8764b3)
    },
    { /* i=3443; 111 / 14 */
        RTUINT128_INIT_C(0x00003123e92bd514, 0x19f193a69a44dc98), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000022dd),
        RTUINT128_INIT_C(0x0000000168d5e5c7, 0x4b86c832d12d5b35), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000015d7)
    },
    { /* i=3444; 115 / 17 */
        RTUINT128_INIT_C(0x0003afab7c800214, 0xad1934bc50932e7a), RTUINT128_INIT_C(0x0000000000000000, 0x000000000001ac83),
        RTUINT128_INIT_C(0x0000000233c39660, 0xee57c0b6c87ea28e), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000097d0)
    },
    { /* i=3445; 120 / 36 */
        RTUINT128_INIT_C(0x002bf2e14d7acba7, 0x37aefa776ec840ed), RTUINT128_INIT_C(0x0000000000000000, 0x0000000470b8b287),
        RTUINT128_INIT_C(0x000000000009e5cc, 0xe5ae3603a34cc0dd), RTUINT128_INIT_C(0x0000000000000000, 0x00000001a45ce262)
    },
    { /* i=3446; 122 / 110 */
        RTUINT128_INIT_C(0x01bb4553325989f9, 0x4f8d1e121b02423a), RTUINT128_INIT_C(0x00003333e9c982a0, 0x92a7392001825197),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000008a8), RTUINT128_INIT_C(0x00000bf37a06cc03, 0xd806a1050aefff22)
    },
    { /* i=3447; 117 / 61 */
        RTUINT128_INIT_C(0x0006a45b11cfe746, 0xf8c2445c635ca71b), RTUINT128_INIT_C(0x0000000000000000, 0x19b3a8c0131ba83e),
        RTUINT128_INIT_C(0x0000000000000000, 0x00422836b392e6fb), RTUINT128_INIT_C(0x0000000000000000, 0x16fcd56180bafe51)
    },
    { /* i=3448; 90 / 63 */
        RTUINT128_INIT_C(0x0000000003ae40f5, 0x5bbd9d984db80e13), RTUINT128_INIT_C(0x0000000000000000, 0x6e1518b3008670b5),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000088f3d66), RTUINT128_INIT_C(0x0000000000000000, 0x1471a087723104f5)
    },
    { /* i=3449; 50 / 26 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00003791fd737951), RTUINT128_INIT_C(0x0000000000000000, 0x0000000002b15bc8),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000014a2f5), RTUINT128_INIT_C(0x0000000000000000, 0x00000000020212e9)
    },
    { /* i=3450; 96 / 24 */
        RTUINT128_INIT_C(0x00000000999b63b3, 0x35320703e2cc2287), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000c80549),
        RTUINT128_INIT_C(0x00000000000000c4, 0x98be47990213a3b9), RTUINT128_INIT_C(0x0000000000000000, 0x000000000077d5c6)
    },
    { /* i=3451; 117 / 34 */
        RTUINT128_INIT_C(0x00154a7d31de5534, 0x399fbd165a32ff58), RTUINT128_INIT_C(0x0000000000000000, 0x000000022983fc98),
        RTUINT128_INIT_C(0x000000000009d8d7, 0x805ddd36d0d1f94d), RTUINT128_INIT_C(0x0000000000000000, 0x00000001c4b82da0)
    },
    { /* i=3452; 125 / 65 */
        RTUINT128_INIT_C(0x087c6a444225bd3e, 0x1de54f99c8889b37), RTUINT128_INIT_C(0x0000000000000001, 0x12f225f74fe2f222),
        RTUINT128_INIT_C(0x0000000000000000, 0x07e6b80d5a7cb787), RTUINT128_INIT_C(0x0000000000000000, 0x0c14494c304c9d49)
    },
    { /* i=3453; 121 / 120 */
        RTUINT128_INIT_C(0x01b1890d55f58d86, 0x48b941aa4986c0cb), RTUINT128_INIT_C(0x00d0b9bc92f61229, 0x6b5a6d7447824581),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000002), RTUINT128_INIT_C(0x0010159430096933, 0x720466c1ba8235c9)
    },
    { /* i=3454; 121 / 4 */
        RTUINT128_INIT_C(0x01a3df3d80d1cc93, 0xad3fc36058a5b737), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000005),
        RTUINT128_INIT_C(0x0053f972b35d28ea, 0x55d98d79ab5457d7), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000004)
    },
    { /* i=3455; 74 / 55 */
        RTUINT128_INIT_C(0x000000000000035b, 0x6cfa6b560efe59e7), RTUINT128_INIT_C(0x0000000000000000, 0x001ada077cca6839),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000002001a3), RTUINT128_INIT_C(0x0000000000000000, 0x0017f7c7c895c49c)
    },
    { /* i=3456; 37 / 74 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000001eef0def24), RTUINT128_INIT_C(0x0000000000000323, 0x00fc152f41cb1764),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000001eef0def24)
    },
    { /* i=3457; 123 / 18 */
        RTUINT128_INIT_C(0x04328d3c1da61012, 0xac692e0601f4842b), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000320f6),
        RTUINT128_INIT_C(0x0000015771aa8654, 0xcb11c58bf3b13a20), RTUINT128_INIT_C(0x0000000000000000, 0x000000000002a96b)
    },
    { /* i=3458; 118 / 30 */
        RTUINT128_INIT_C(0x00291d95eaf20047, 0xefc610fa8f414021), RTUINT128_INIT_C(0x0000000000000000, 0x00000000267a49f3),
        RTUINT128_INIT_C(0x0000000001118ce3, 0x69ff5aecf61a4c65), RTUINT128_INIT_C(0x0000000000000000, 0x000000000e5fef42)
    },
    { /* i=3459; 126 / 97 */
        RTUINT128_INIT_C(0x24393ee4b55b8438, 0x1e0bcf545edb8105), RTUINT128_INIT_C(0x00000000fbf283df, 0x0194704ca6f7fbac),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000024ce68dc), RTUINT128_INIT_C(0x0000000031b372b1, 0x4fb2eeaf6f195935)
    },
    { /* i=3460; 119 / 53 */
        RTUINT128_INIT_C(0x00330a71571c681f, 0xe43a907869e6a8e8), RTUINT128_INIT_C(0x0000000000000000, 0x0018ddc3a1c662d5),
        RTUINT128_INIT_C(0x0000000000000002, 0x0d77f7a93fe6bedf), RTUINT128_INIT_C(0x0000000000000000, 0x001144d10a5e7b5d)
    },
    { /* i=3461; 119 / 106 */
        RTUINT128_INIT_C(0x0040fafb1e8bfa60, 0x10f6f925f8571639), RTUINT128_INIT_C(0x0000019f4511915b, 0x9014addfd60690d1),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000280e), RTUINT128_INIT_C(0x0000017a98dfb8da, 0xf4aa7d773d5a82cb)
    },
    { /* i=3462; 127 / 37 */
        RTUINT128_INIT_C(0x67c0467ca5bc0110, 0x08adfaffe405dbdb), RTUINT128_INIT_C(0x0000000000000000, 0x0000000cf8d84d1c),
        RTUINT128_INIT_C(0x0000000007ff8009, 0xdc86dc225c471250), RTUINT128_INIT_C(0x0000000000000000, 0x00000007783dcb1b)
    },
    { /* i=3463; 67 / 61 */
        RTUINT128_INIT_C(0x0000000000000007, 0xfd9027bf3b1fce94), RTUINT128_INIT_C(0x0000000000000000, 0x09cc4121604abe9f),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000d0), RTUINT128_INIT_C(0x0000000000000000, 0x079b3ca0fe64ed64)
    },
    { /* i=3464; 124 / 84 */
        RTUINT128_INIT_C(0x082d82b5e1d92fa1, 0xff7741f93e4fdbd6), RTUINT128_INIT_C(0x000000000001d6fe, 0xa566efdff6a97122),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000471e30baab2), RTUINT128_INIT_C(0x000000000001d4e6, 0x35b26dd834e89e32)
    },
    { /* i=3465; 128 / 93 */
        RTUINT128_INIT_C(0x200c1241d06d4a01, 0x8b4635a299530332), RTUINT128_INIT_C(0x0000000018a92473, 0x8f73a25b0bce8d0d),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000014cad83a3), RTUINT128_INIT_C(0x000000000ef20a52, 0x3dba651d34d88ceb)
    },
    { /* i=3466; 123 / 107 */
        RTUINT128_INIT_C(0x01a04bb2b5bc7414, 0x9d95203d984c9688), RTUINT128_INIT_C(0x000001eb2df228b7, 0x5c1d755fcad14eb3),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000d8f8), RTUINT128_INIT_C(0x00000119e0ca4cba, 0x8602985083215120)
    },
    { /* i=3467; 45 / 40 */
        RTUINT128_INIT_C(0x0000000000000000, 0x000012bc0571484b), RTUINT128_INIT_C(0x0000000000000000, 0x00000014fa2e1664),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000e4), RTUINT128_INIT_C(0x0000000000000000, 0x0000000d3465573b)
    },
    { /* i=3468; 114 / 64 */
        RTUINT128_INIT_C(0x0002f481702b6c64, 0x5c2861b99b4e3272), RTUINT128_INIT_C(0x0000000000000000, 0xf6f5d4adf25403b6),
        RTUINT128_INIT_C(0x0000000000000000, 0x000310325c138448), RTUINT128_INIT_C(0x0000000000000000, 0x399598bc73414f42)
    },
    { /* i=3469; 125 / 73 */
        RTUINT128_INIT_C(0x06cebea5ed351da2, 0xf714502f0b298142), RTUINT128_INIT_C(0x000000000000009d, 0x8f3e6dec0907d55e),
        RTUINT128_INIT_C(0x0000000000000000, 0x000b0f94c909da33), RTUINT128_INIT_C(0x0000000000000071, 0x3a9416534499f388)
    },
    { /* i=3470; 122 / 114 */
        RTUINT128_INIT_C(0x01a8b25819d5b4d6, 0xbbb88cac4336b86d), RTUINT128_INIT_C(0x0000b24afb6746ae, 0x1b2c1f0f1db908bf),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000261), RTUINT128_INIT_C(0x00008df8092690a8, 0x17c2a9b68e08ea0e)
    },
    { /* i=3471; 114 / 98 */
        RTUINT128_INIT_C(0x00002b054ca82f0c, 0xb76a74df8ef0a82c), RTUINT128_INIT_C(0x000000004cb0b06f, 0x5c0962a2c4050a6c),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000008f9b), RTUINT128_INIT_C(0x000000002b1f2736, 0xbfa2d0d40f1104c8)
    },
    { /* i=3472; 115 / 94 */
        RTUINT128_INIT_C(0x00019eb71ccdc254, 0xc246df3b7b9f63fb), RTUINT128_INIT_C(0x000000000436d822, 0xe50480d8979a7fde),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000062687f), RTUINT128_INIT_C(0x00000000006eb041, 0xfdc8ed0c8f0bc4d9)
    },
    { /* i=3473; 61 / 99 */
        RTUINT128_INIT_C(0x0000000000000000, 0x137cd1f2ccaf5625), RTUINT128_INIT_C(0x0000000183d11768, 0x43d5fc9bef479080),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x137cd1f2ccaf5625)
    },
    { /* i=3474; 125 / 108 */
        RTUINT128_INIT_C(0x1d2ee99c8c14beb5, 0xcaa272162c7ac304), RTUINT128_INIT_C(0x00000909d270ba5b, 0xd60eb5368154cc5a),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000033a93), RTUINT128_INIT_C(0x000007f8fc0d6b4e, 0x6b7e867e4d6f0756)
    },
    { /* i=3475; 123 / 102 */
        RTUINT128_INIT_C(0x002521b8717aa0a8, 0xb620210b880f6f25), RTUINT128_INIT_C(0x0000001f472b2d80, 0xa85c7c7af875a720),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000012fe9), RTUINT128_INIT_C(0x000000049052ef4a, 0x029d490c242b7305)
    },
    { /* i=3476; 80 / 73 */
        RTUINT128_INIT_C(0x000000000000d48f, 0x76e5cef82a0d90f4), RTUINT128_INIT_C(0x0000000000000146, 0xf678434675f0eeea),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000a6), RTUINT128_INIT_C(0x000000000000008b, 0xa4ea2f47afd2a538)
    },
    { /* i=3477; 114 / 89 */
        RTUINT128_INIT_C(0x0003d36f2fa3a2e1, 0x067f0de1e3871cd4), RTUINT128_INIT_C(0x0000000001b41a63, 0xa597f34936774bc1),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000023ef1dc), RTUINT128_INIT_C(0x000000000097dba7, 0x2db9ef34ebf351f8)
    },
    { /* i=3478; 118 / 118 */
        RTUINT128_INIT_C(0x00141ee0462ffdc6, 0x7e81a037814f72bb), RTUINT128_INIT_C(0x000fa37e7d4ac396, 0x01117258909c5222),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001), RTUINT128_INIT_C(0x00047b61c8e53a30, 0x7d702ddef0b32099)
    },
    { /* i=3479; 128 / 39 */
        RTUINT128_INIT_C(0x51a7a4740d735f8a, 0x2e82c7e01b2aed67), RTUINT128_INIT_C(0x0000000000000000, 0x000000071eb393ad),
        RTUINT128_INIT_C(0x000000000b77ef46, 0xd5128c8df25f847e), RTUINT128_INIT_C(0x0000000000000000, 0x000000040f700a41)
    },
    { /* i=3480; 115 / 114 */
        RTUINT128_INIT_C(0x00015c3bd77e28eb, 0x1c6144a0d9d3bca7), RTUINT128_INIT_C(0x0002659624419a0b, 0xec4b9b43308162ac),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x00015c3bd77e28eb, 0x1c6144a0d9d3bca7)
    },
    { /* i=3481; 128 / 73 */
        RTUINT128_INIT_C(0x5158538582d7292f, 0xbe0d090847e95ecb), RTUINT128_INIT_C(0x0000000000000051, 0x2666dafcac213660),
        RTUINT128_INIT_C(0x0000000000000000, 0x01009d7e8c854287), RTUINT128_INIT_C(0x0000000000000028, 0x8f412f2b3280f22b)
    },
    { /* i=3482; 125 / 101 */
        RTUINT128_INIT_C(0x01b7e3f5cd6e2930, 0x303f3656242125c4), RTUINT128_INIT_C(0x0000001bac18b6c0, 0x1c469eaaf1f9ff26),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000fe57d), RTUINT128_INIT_C(0x0000000df4a16bf3, 0xe9d0a4c368989236)
    },
    { /* i=3483; 75 / 41 */
        RTUINT128_INIT_C(0x00000000000005d2, 0x5072180482ea0306), RTUINT128_INIT_C(0x0000000000000000, 0x00000082670b9b25),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000b6db6b704), RTUINT128_INIT_C(0x0000000000000000, 0x0000006b8d862372)
    },
    { /* i=3484; 101 / 74 */
        RTUINT128_INIT_C(0x000000029744750c, 0x0774d931cade7524), RTUINT128_INIT_C(0x0000000000000249, 0x83e351e710015f2a),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000121feb6), RTUINT128_INIT_C(0x000000000000004d, 0x42bc4b7e9f0f2148)
    },
    { /* i=3485; 118 / 55 */
        RTUINT128_INIT_C(0x0007777200cf98d3, 0xf4702346b4efeeff), RTUINT128_INIT_C(0x0000000000000000, 0x002fd11e61e15fef),
        RTUINT128_INIT_C(0x0000000000000000, 0x27f96aefa1eebb71), RTUINT128_INIT_C(0x0000000000000000, 0x002d6060602f0180)
    },
    { /* i=3486; 116 / 69 */
        RTUINT128_INIT_C(0x00042e0aaed1ec09, 0xff9d6e3185c9b197), RTUINT128_INIT_C(0x000000000000001c, 0xf9aeafc9c67db94c),
        RTUINT128_INIT_C(0x0000000000000000, 0x000024edee401181), RTUINT128_INIT_C(0x000000000000000b, 0x9b7cb6472c21464b)
    },
    { /* i=3487; 117 / 106 */
        RTUINT128_INIT_C(0x001b324f2cbf5922, 0xa3baf8ee14825257), RTUINT128_INIT_C(0x000002188cdc888e, 0x8a800cf76dda49f3),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000cf9), RTUINT128_INIT_C(0x000001d3d3d7d7ff, 0xec92c31dffb900fc)
    },
    { /* i=3488; 90 / 124 */
        RTUINT128_INIT_C(0x0000000003ae1f40, 0x86efd3734c663726), RTUINT128_INIT_C(0x0ebe02557eced477, 0x534ed3598aecae05),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000003ae1f40, 0x86efd3734c663726)
    },
    { /* i=3489; 125 / 39 */
        RTUINT128_INIT_C(0x1da5d81fb5f59704, 0x88c27aa7e8d50cf7), RTUINT128_INIT_C(0x0000000000000000, 0x00000039f24bd1dd),
        RTUINT128_INIT_C(0x000000000082faf3, 0x00767b2ba20466d8), RTUINT128_INIT_C(0x0000000000000000, 0x0000001d21c9ec7f)
    },
    { /* i=3490; 41 / 6 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000019bd403b70b), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000010),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000019bd403b70), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000000b)
    },
    { /* i=3491; 83 / 70 */
        RTUINT128_INIT_C(0x0000000000018a54, 0xc1669a74647fceea), RTUINT128_INIT_C(0x0000000000000012, 0x810200e6a8c4d6dc),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000154f), RTUINT128_INIT_C(0x0000000000000009, 0xc7b5676e2a217506)
    },
    { /* i=3492; 126 / 73 */
        RTUINT128_INIT_C(0x24ada8863d2175d0, 0xb245f83c5eef931a), RTUINT128_INIT_C(0x00000000000000de, 0x0f9ea30c0a84583c),
        RTUINT128_INIT_C(0x0000000000000000, 0x002a48bd2fa8ac76), RTUINT128_INIT_C(0x000000000000005d, 0x3d678245af469772)
    },
    { /* i=3493; 121 / 121 */
        RTUINT128_INIT_C(0x005bb67f4d75a400, 0x4f17d48e7fdcda6c), RTUINT128_INIT_C(0x01b0619f74137ba9, 0xcc86685cd3a9f1d5),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x005bb67f4d75a400, 0x4f17d48e7fdcda6c)
    },
    { /* i=3494; 76 / 21 */
        RTUINT128_INIT_C(0x00000000000009d0, 0x9fd9dcd38c7f335c), RTUINT128_INIT_C(0x0000000000000000, 0x000000000013d53c),
        RTUINT128_INIT_C(0x0000000000000000, 0x007eb07d7a8cd2f2), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000468a4)
    },
    { /* i=3495; 85 / 12 */
        RTUINT128_INIT_C(0x0000000000086651, 0x411bafe26097c9ed), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000b1f),
        RTUINT128_INIT_C(0x00000000000000c1, 0x5ad75dc1f201abff), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000010c)
    },
    { /* i=3496; 110 / 8 */
        RTUINT128_INIT_C(0x000033fb9374acb1, 0x71621f6c24b9c7d9), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000054),
        RTUINT128_INIT_C(0x0000009e6c6c0e3f, 0x1096805fc37c1dce), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000041)
    },
    { /* i=3497; 123 / 98 */
        RTUINT128_INIT_C(0x07113cf281617e37, 0xc04cf56290578007), RTUINT128_INIT_C(0x0000000111a6eef9, 0x960c0b7305e5b51e),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000069c883a), RTUINT128_INIT_C(0x0000000058ff0a59, 0xaf4247f81fcc873b)
    },
    { /* i=3498; 127 / 77 */
        RTUINT128_INIT_C(0x5194702ab31151b5, 0x149a50be1d9cb111), RTUINT128_INIT_C(0x0000000000000205, 0x4b0539f5c996c282),
        RTUINT128_INIT_C(0x0000000000000000, 0x00285f5f45376caa), RTUINT128_INIT_C(0x0000000000000039, 0x3619c46bd182aebd)
    },
    { /* i=3499; 128 / 109 */
        RTUINT128_INIT_C(0xea457f2aaf6c5592, 0x652f12ebe8d6ab5d), RTUINT128_INIT_C(0x00001b78154429ed, 0x5de3ea3101cf98c2),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000008874f), RTUINT128_INIT_C(0x000007c3dddc49af, 0xe9d1e75b1a28397f)
    },
    { /* i=3500; 111 / 12 */
        RTUINT128_INIT_C(0x00001e1ac363e741, 0x3eec4ed3482da53e), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000c9),
        RTUINT128_INIT_C(0x0000002657943d02, 0xdf32d8e8da266fa0), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000009e)
    },
    { /* i=3501; 117 / 60 */
        RTUINT128_INIT_C(0x0011519e97393dff, 0xab3312686f328ce1), RTUINT128_INIT_C(0x0000000000000000, 0x0ffd3c5fc4007801),
        RTUINT128_INIT_C(0x0000000000000000, 0x011549d0fa4809c0), RTUINT128_INIT_C(0x0000000000000000, 0x0a200d8eb0588321)
    },
    { /* i=3502; 74 / 66 */
        RTUINT128_INIT_C(0x0000000000000282, 0x55e16eb3e90e8555), RTUINT128_INIT_C(0x0000000000000002, 0xc8f4aeb15fa52af5),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000000e6), RTUINT128_INIT_C(0x0000000000000001, 0xca0c7b57faa9ed37)
    },
    { /* i=3503; 127 / 102 */
        RTUINT128_INIT_C(0x5c164b9d6f4e10da, 0x689a2762ad6b6410), RTUINT128_INIT_C(0x00000021d34d307c, 0x9fdc13ba76d72a6e),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000002b8f0d1), RTUINT128_INIT_C(0x0000000bbd0206e7, 0xf07c23c294eaa042)
    },
    { /* i=3504; 117 / 62 */
        RTUINT128_INIT_C(0x001203955c66ec31, 0xae585ec00f393bd4), RTUINT128_INIT_C(0x0000000000000000, 0x39b30df5f60b43f7),
        RTUINT128_INIT_C(0x0000000000000000, 0x004fec9b3aa52e29), RTUINT128_INIT_C(0x0000000000000000, 0x362ff2efdd01f745)
    },
    { /* i=3505; 22 / 21 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000001129b7), RTUINT128_INIT_C(0x0000000000000000, 0x00000000000454eb),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000042af6)
    },
    { /* i=3506; 69 / 56 */
        RTUINT128_INIT_C(0x000000000000000a, 0xad057c52faf474c5), RTUINT128_INIT_C(0x0000000000000000, 0x00f0c950acef5099),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000b59), RTUINT128_INIT_C(0x0000000000000000, 0x00a907d8934adc94)
    },
    { /* i=3507; 116 / 19 */
        RTUINT128_INIT_C(0x000ee86534a6d988, 0xa63c2c46788f9275), RTUINT128_INIT_C(0x0000000000000000, 0x000000000006185f),
        RTUINT128_INIT_C(0x0000000272219de5, 0x4b115c5b0f814433), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000007b88)
    },
    { /* i=3508; 126 / 66 */
        RTUINT128_INIT_C(0x0d3a6ca87622eb3d, 0x80aa7ad340de718c), RTUINT128_INIT_C(0x0000000000000001, 0x5a06fb9627dc5012),
        RTUINT128_INIT_C(0x0000000000000000, 0x09c95d767451870c), RTUINT128_INIT_C(0x0000000000000001, 0x0c529d7ab69f32b4)
    },
    { /* i=3509; 2 / 15 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000003a64),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000003)
    },
    { /* i=3510; 123 / 68 */
        RTUINT128_INIT_C(0x05bb76011c782b19, 0x6b4a0003626e4ffd), RTUINT128_INIT_C(0x0000000000000006, 0x8ee48274667910dd),
        RTUINT128_INIT_C(0x0000000000000000, 0x00dfc2b61c05067a), RTUINT128_INIT_C(0x0000000000000006, 0x667d64d0360618ab)
    },
    { /* i=3511; 104 / 16 */
        RTUINT128_INIT_C(0x0000006c8d9df92e, 0x1fef353a389c5a2f), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000bb03),
        RTUINT128_INIT_C(0x0000000000949927, 0xf1ea7e33a67faf62), RTUINT128_INIT_C(0x0000000000000000, 0x000000000000b609)
    },
    { /* i=3512; 117 / 102 */
        RTUINT128_INIT_C(0x0003aa9ac16aba20, 0xb5ab3ded789be95c), RTUINT128_INIT_C(0x00000006d4180f4c, 0xdec4524fb80de3bf),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000008974), RTUINT128_INIT_C(0x00000001c653a814, 0xb4a9484ea36f7fd0)
    },
    { /* i=3513; 120 / 86 */
        RTUINT128_INIT_C(0x00927b6e0086662c, 0x2561a404f6cc0853), RTUINT128_INIT_C(0x0000000000320f58, 0xdf9a87493998fc4d),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000002ed1726dc), RTUINT128_INIT_C(0x000000000006cfe7, 0xa767bb9ecdf4c827)
    },
    { /* i=3514; 119 / 101 */
        RTUINT128_INIT_C(0x007b3f1c5d93fbe2, 0xe52885256e1ca991), RTUINT128_INIT_C(0x00000018e6f7a652, 0x56633a0e849dce28),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000004f300), RTUINT128_INIT_C(0x00000000b16a7a55, 0xccd2aacc6accb191)
    },
    { /* i=3515; 125 / 27 */
        RTUINT128_INIT_C(0x165cb0caa0307b40, 0x94bb0f2aa63b18ea), RTUINT128_INIT_C(0x0000000000000000, 0x0000000007ef6d86),
        RTUINT128_INIT_C(0x00000002d16c8b61, 0x6fef0ee63150c149), RTUINT128_INIT_C(0x0000000000000000, 0x000000000182d7b4)
    },
    { /* i=3516; 118 / 58 */
        RTUINT128_INIT_C(0x0009398e07869af3, 0xc43669c7e8aa274d), RTUINT128_INIT_C(0x0000000000000000, 0x0001c1096f3c544f),
        RTUINT128_INIT_C(0x0000000000000005, 0x425809ef5a336281), RTUINT128_INIT_C(0x0000000000000000, 0x0000ac0831406d7e)
    },
    { /* i=3517; 123 / 26 */
        RTUINT128_INIT_C(0x03bc9e9ee77c5f12, 0xf3d6badc10ddf12a), RTUINT128_INIT_C(0x0000000000000000, 0x00000000017f0cc7),
        RTUINT128_INIT_C(0x000000027f5406ad, 0x0565257144635462), RTUINT128_INIT_C(0x0000000000000000, 0x000000000114c0fc)
    },
    { /* i=3518; 127 / 67 */
        RTUINT128_INIT_C(0x01cbf27d6f31bf8a, 0x687a3b9b6193039e), RTUINT128_INIT_C(0x0000000000000005, 0x7ae81965dd2edb40),
        RTUINT128_INIT_C(0x0000000000000000, 0x0053ee2d8385c665), RTUINT128_INIT_C(0x0000000000000002, 0x8e567f8f3843035e)
    },
    { /* i=3519; 31 / 3 */
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000081493ac), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000001),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000081493ac), RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000)
    },
    { /* i=3520; 45 / 103 */
        RTUINT128_INIT_C(0x0000000000000000, 0x0000050097404f80), RTUINT128_INIT_C(0x0000004684550a2d, 0x543b4e43f67b6cfc),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000000), RTUINT128_INIT_C(0x0000000000000000, 0x0000050097404f80)
    },
    { /* i=3521; 125 / 115 */
        RTUINT128_INIT_C(0x0ad67266e4466fea, 0xcd0800bab07d22b3), RTUINT128_INIT_C(0x0004076f7c61072b, 0xdcf164148bdda1ac),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000000002b0), RTUINT128_INIT_C(0x000276c89f832a09, 0x044b0982ccdaa473)
    },
    { /* i=3522; 114 / 112 */
        RTUINT128_INIT_C(0x00033defa38e6391, 0x3363b72a6bdb971f), RTUINT128_INIT_C(0x0000b560b1fcd7c1, 0xea6b30b0c29fc8ea),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000004), RTUINT128_INIT_C(0x0000686cdb9b0489, 0x89b6f467615c7377)
    },
    { /* i=3523; 122 / 117 */
        RTUINT128_INIT_C(0x017585806d9e1cfe, 0x79a2e1454f64ddc9), RTUINT128_INIT_C(0x0013780711d5ff20, 0xfcc2c82bc9265501),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000000013), RTUINT128_INIT_C(0x00039cfa1abc2d8b, 0xb72e0605618c8eb6)
    },
    { /* i=3524; 114 / 98 */
        RTUINT128_INIT_C(0x0000b7ab4097d7f2, 0x6b4adbf50f75cb82), RTUINT128_INIT_C(0x00000002f6fa2616, 0x78c352227b5085ff),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000003df3), RTUINT128_INIT_C(0x00000001361255d7, 0x3f51add7d218d775)
    },
    { /* i=3525; 125 / 59 */
        RTUINT128_INIT_C(0x10070043f7325576, 0xb50fec47c14e0ad7), RTUINT128_INIT_C(0x0000000000000000, 0x050f16e8b23d94dd),
        RTUINT128_INIT_C(0x0000000000000003, 0x2b0a051e70e1484b), RTUINT128_INIT_C(0x0000000000000000, 0x03f167d3b1284618)
    },
    { /* i=3526; 117 / 90 */
        RTUINT128_INIT_C(0x0018992dcb883c08, 0xb6bc4ffdb6e9bef6), RTUINT128_INIT_C(0x0000000001c7534a, 0xfe5ca1983ce68d5a),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000dd47f12), RTUINT128_INIT_C(0x00000000002cd3a8, 0x52e448f86e0c28a2)
    },
    { /* i=3527; 109 / 76 */
        RTUINT128_INIT_C(0x00001a6c6d0424bf, 0x7864ac3a8371eab4), RTUINT128_INIT_C(0x0000000000000fb3, 0xabdfa81097bd04c2),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000001aecdfbce), RTUINT128_INIT_C(0x0000000000000a41, 0x6c7a29bf6a53e098)
    },
    { /* i=3528; 114 / 87 */
        RTUINT128_INIT_C(0x000084dbd41452c2, 0x35ebf4e730ccb92b), RTUINT128_INIT_C(0x0000000000041afb, 0x68488263a169020e),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000000205ca8ba), RTUINT128_INIT_C(0x000000000001314d, 0x8bb0b49884200aff)
    },
    { /* i=3529; 124 / 69 */
        RTUINT128_INIT_C(0x0c88957b81cfefa8, 0xdcdeea01a3eee71c), RTUINT128_INIT_C(0x000000000000000c, 0xa72fbdaa151d2a9a),
        RTUINT128_INIT_C(0x0000000000000000, 0x00fd94d7664414ab), RTUINT128_INIT_C(0x0000000000000005, 0x9d40e5b095376a3e)
    },
    { /* i=3530; 115 / 56 */
        RTUINT128_INIT_C(0x0001ee83b6e0db58, 0x185a449ee902f109), RTUINT128_INIT_C(0x0000000000000000, 0x0047824b5dabc7ce),
        RTUINT128_INIT_C(0x0000000000000000, 0x06ea58f709448b6d), RTUINT128_INIT_C(0x0000000000000000, 0x00205b4270aa0453)
    },
    { /* i=3531; 113 / 49 */
        RTUINT128_INIT_C(0x0000f65ceed8d31c, 0x23659650151f429b), RTUINT128_INIT_C(0x0000000000000000, 0x0000ff7595443661),
        RTUINT128_INIT_C(0x0000000000000000, 0xf6e26bd5ceda0f11), RTUINT128_INIT_C(0x0000000000000000, 0x0000f234cfcdf72a)
    },
    { /* i=3532; 128 / 118 */
        RTUINT128_INIT_C(0x952d074200fd6369, 0xdb6b05135d0fa168), RTUINT128_INIT_C(0x00034e1f851e86a9, 0x160bfaf3bf62a2dc),
        RTUINT128_INIT_C(0x0000000000000000, 0x0000000000002d22), RTUINT128_INIT_C(0x00011cabf543c814, 0xd2b6d80f9b555430)
    },
    { /* i=3533; 116 / 102 */
        RTUINT128_INIT_C(0x000fa4fc3568ee91, 0x0a9d496bf173578f), RTUINT128_INIT_C(0x00000039bcc625bf, 0xc5e588d62690bc7f),
        RTUINT128_INIT_C(0x0000000000000000, 0x000000000000455d), RTUINT128_INIT_C(0x000000213940878f, 0x4858db3aec10a26c)
    },
    { /* i=3534; 121 / 76 */
        RTUINT128_INIT_C(0x0034e426ad1c0997, 0xabade59f3dd87a70), RTUINT128_INIT_C(0x0000000000000776, 0xf9b3cb0029158ca9),
        RTUINT128_INIT_C(0x0000000000000000, 0x00000715e1184b25), RTUINT128_INIT_C(0x00000000000003d4, 0xc67b8f0d44ada303)
    },
    { /* i=3535; 96 / 54 */
        RTUINT128_INIT_C(0x00000000138c70bc, 0x1785a8a0554d0979), RTUINT128_INIT_C(0x0000000000000000, 0x0030b9c6f4edb8d6),
        RTUINT128